/*
   +----------------------------------------------------------------------+
   | Zend Engine                                                          |
   +----------------------------------------------------------------------+
   | Copyright (c) 1998-2015 Zend Technologies Ltd. (http://www.zend.com) |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2.00 of the Zend license,     |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.zend.com/license/2_00.txt.                                |
   | If you did not receive a copy of the Zend license and are unable to  |
   | obtain it through the world-wide-web, please send a note to          |
   | license@zend.com so we can mail you a copy immediately.              |
   +----------------------------------------------------------------------+
   | Authors: Andi Gutmans <andi@zend.com>                                |
   |          Zeev Suraski <zeev@zend.com>                                |
   |          Dmitry Stogov <dmitry@zend.com>                             |
   +----------------------------------------------------------------------+
*/

#ifdef ZEND_WIN32
# pragma warning(once : 4101)
# pragma warning(once : 6235)
# pragma warning(once : 6237)
# pragma warning(once : 6239)
# pragma warning(once : 6240)
# pragma warning(once : 6285)
# pragma warning(once : 6286)
# pragma warning(once : 6326)
#endif
static user_opcode_handler_t zend_user_opcode_handlers[256] = {
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL,
	(user_opcode_handler_t)NULL
};

static zend_uchar zend_user_opcodes[256] = {0,
	1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,
	17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,
	33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,
	49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
	65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,
	81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,
	97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,
	113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,
	129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,
	145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,
	161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,
	177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,
	193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,
	209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,
	225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,
	241,242,243,244,245,246,247,248,249,250,251,252,253,254,255
};

static const void **zend_opcode_handlers;
static const void *zend_vm_get_opcode_handler(zend_uchar opcode, const zend_op* op);


#ifdef ZEND_VM_FP_GLOBAL_REG
register zend_execute_data* volatile execute_data __asm__(ZEND_VM_FP_GLOBAL_REG);
#endif

#ifdef ZEND_VM_IP_GLOBAL_REG
register const zend_op* volatile opline __asm__(ZEND_VM_IP_GLOBAL_REG);
#endif

#ifdef ZEND_VM_FP_GLOBAL_REG
# define ZEND_OPCODE_HANDLER_ARGS void
# define ZEND_OPCODE_HANDLER_ARGS_PASSTHRU
# define ZEND_OPCODE_HANDLER_ARGS_DC
# define ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC
#else
# define ZEND_OPCODE_HANDLER_ARGS zend_execute_data *execute_data
# define ZEND_OPCODE_HANDLER_ARGS_PASSTHRU execute_data
# define ZEND_OPCODE_HANDLER_ARGS_DC , ZEND_OPCODE_HANDLER_ARGS
# define ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC , ZEND_OPCODE_HANDLER_ARGS_PASSTHRU
#endif

#if defined(ZEND_VM_FP_GLOBAL_REG) && defined(ZEND_VM_IP_GLOBAL_REG)
# define ZEND_OPCODE_HANDLER_RET void
# define ZEND_VM_TAIL_CALL(call) call; return
# define ZEND_VM_CONTINUE()      return
# define ZEND_VM_RETURN()        opline = NULL; ZEND_VM_CONTINUE()
#else
# define ZEND_OPCODE_HANDLER_RET int
# define ZEND_VM_TAIL_CALL(call) return call
# define ZEND_VM_CONTINUE()      return  0
# define ZEND_VM_RETURN()        return -1
#endif

typedef ZEND_OPCODE_HANDLER_RET (ZEND_FASTCALL *opcode_handler_t) (ZEND_OPCODE_HANDLER_ARGS);

#undef OPLINE
#undef DCL_OPLINE
#undef USE_OPLINE
#undef LOAD_OPLINE
#undef LOAD_OPLINE_EX
#undef SAVE_OPLINE
#define DCL_OPLINE
#ifdef ZEND_VM_IP_GLOBAL_REG
# define OPLINE opline
# define USE_OPLINE
# define LOAD_OPLINE() opline = EX(opline)
# define LOAD_NEXT_OPLINE() opline = EX(opline) + 1
# define SAVE_OPLINE() EX(opline) = opline
#else
# define OPLINE EX(opline)
# define USE_OPLINE const zend_op *opline = EX(opline);
# define LOAD_OPLINE()
# define LOAD_NEXT_OPLINE() ZEND_VM_INC_OPCODE()
# define SAVE_OPLINE()
#endif
#undef HANDLE_EXCEPTION
#undef HANDLE_EXCEPTION_LEAVE
#define HANDLE_EXCEPTION() LOAD_OPLINE(); ZEND_VM_CONTINUE()
#define HANDLE_EXCEPTION_LEAVE() LOAD_OPLINE(); ZEND_VM_LEAVE()
#if defined(ZEND_VM_FP_GLOBAL_REG)
# define ZEND_VM_ENTER()           execute_data = EG(current_execute_data); LOAD_OPLINE(); ZEND_VM_CONTINUE()
# define ZEND_VM_LEAVE()           ZEND_VM_CONTINUE()
#elif defined(ZEND_VM_IP_GLOBAL_REG)
# define ZEND_VM_ENTER()           opline = EG(current_execute_data)->opline; return 1
# define ZEND_VM_LEAVE()           return  2
#else
# define ZEND_VM_ENTER()           return  1
# define ZEND_VM_LEAVE()           return  2
#endif
#define ZEND_VM_DISPATCH(opcode, opline) ZEND_VM_TAIL_CALL(((opcode_handler_t)zend_vm_get_opcode_handler(opcode, opline))(ZEND_OPCODE_HANDLER_ARGS_PASSTHRU));


ZEND_API void execute_ex(zend_execute_data *ex)
{
	DCL_OPLINE

#ifdef ZEND_VM_IP_GLOBAL_REG
	const zend_op *orig_opline = opline;
#endif
#ifdef ZEND_VM_FP_GLOBAL_REG
	zend_execute_data *orig_execute_data = execute_data;
	execute_data = ex;
#else
	zend_execute_data *execute_data = ex;
#endif


	LOAD_OPLINE();

	while (1) {
#if !defined(ZEND_VM_FP_GLOBAL_REG) || !defined(ZEND_VM_IP_GLOBAL_REG)
    	int ret;
#endif
#if defined(ZEND_VM_FP_GLOBAL_REG) && defined(ZEND_VM_IP_GLOBAL_REG)
		((opcode_handler_t)OPLINE->handler)(ZEND_OPCODE_HANDLER_ARGS_PASSTHRU);
		if (UNEXPECTED(!OPLINE)) {
#else
		if (UNEXPECTED((ret = ((opcode_handler_t)OPLINE->handler)(ZEND_OPCODE_HANDLER_ARGS_PASSTHRU)) != 0)) {
#endif
#ifdef ZEND_VM_FP_GLOBAL_REG
			execute_data = orig_execute_data;
# ifdef ZEND_VM_IP_GLOBAL_REG
			opline = orig_opline;
# endif
			return;
#else
			if (EXPECTED(ret > 0)) {
				execute_data = EG(current_execute_data);
			} else {
# ifdef ZEND_VM_IP_GLOBAL_REG
				opline = orig_opline;
# endif
				return;
			}
#endif
		}

	}
	zend_error_noreturn(E_CORE_ERROR, "Arrived at end of main loop which shouldn't happen");
}

ZEND_API void zend_execute(zend_op_array *op_array, zval *return_value)
{
	zend_execute_data *execute_data;

	if (EG(exception) != NULL) {
		return;
	}

	execute_data = zend_vm_stack_push_call_frame(ZEND_CALL_TOP_CODE,
		(zend_function*)op_array, 0, zend_get_called_scope(EG(current_execute_data)), zend_get_this_object(EG(current_execute_data)));
	if (EG(current_execute_data)) {
		execute_data->symbol_table = zend_rebuild_symbol_table();
	} else {
		execute_data->symbol_table = &EG(symbol_table);
	}
	EX(prev_execute_data) = EG(current_execute_data);
	i_init_execute_data(execute_data, op_array, return_value);
	zend_execute_ex(execute_data);
	zend_vm_stack_free_call_frame(execute_data);
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL zend_leave_helper_SPEC(ZEND_OPCODE_HANDLER_ARGS)
{
	zend_execute_data *old_execute_data;
	uint32_t call_info = EX_CALL_INFO();

	if (ZEND_CALL_KIND_EX(call_info) == ZEND_CALL_NESTED_FUNCTION) {
		zend_object *object;

		i_free_compiled_variables(execute_data);
		if (UNEXPECTED(EX(symbol_table) != NULL)) {
			zend_clean_and_cache_symbol_table(EX(symbol_table));
		}
		zend_vm_stack_free_extra_args_ex(call_info, execute_data);
		old_execute_data = execute_data;
		execute_data = EG(current_execute_data) = EX(prev_execute_data);
		if (UNEXPECTED(call_info & ZEND_CALL_CLOSURE)) {
			OBJ_RELEASE((zend_object*)old_execute_data->func->op_array.prototype);
		}
		if (UNEXPECTED(call_info & ZEND_CALL_RELEASE_THIS)) {
			object = Z_OBJ(old_execute_data->This);
#if 0
			if (UNEXPECTED(EG(exception) != NULL) && (EX(opline)->op1.num & ZEND_CALL_CTOR)) {
				if (!(EX(opline)->op1.num & ZEND_CALL_CTOR_RESULT_UNUSED)) {
#else
			if (UNEXPECTED(EG(exception) != NULL) && (call_info & ZEND_CALL_CTOR)) {
				if (!(call_info & ZEND_CALL_CTOR_RESULT_UNUSED)) {
#endif
					GC_REFCOUNT(object)--;
				}
				if (GC_REFCOUNT(object) == 1) {
					zend_object_store_ctor_failed(object);
				}
			}
			OBJ_RELEASE(object);
		}
		EG(scope) = EX(func)->op_array.scope;

		zend_vm_stack_free_call_frame_ex(call_info, old_execute_data);

		if (UNEXPECTED(EG(exception) != NULL)) {
			const zend_op *old_opline = EX(opline);
			zend_throw_exception_internal(NULL);
			if (RETURN_VALUE_USED(old_opline)) {
				zval_ptr_dtor(EX_VAR(old_opline->result.var));
			}
			HANDLE_EXCEPTION_LEAVE();
		}

		LOAD_NEXT_OPLINE();
		ZEND_VM_LEAVE();
	} else if (ZEND_CALL_KIND_EX(call_info) == ZEND_CALL_NESTED_CODE) {
		zend_detach_symbol_table(execute_data);
		destroy_op_array(&EX(func)->op_array);
		efree_size(EX(func), sizeof(zend_op_array));
		old_execute_data = execute_data;
		execute_data = EG(current_execute_data) = EX(prev_execute_data);
		zend_vm_stack_free_call_frame_ex(call_info, old_execute_data);

		zend_attach_symbol_table(execute_data);
		if (UNEXPECTED(EG(exception) != NULL)) {
			zend_throw_exception_internal(NULL);
			HANDLE_EXCEPTION_LEAVE();
		}

		LOAD_NEXT_OPLINE();
		ZEND_VM_LEAVE();
	} else {
		if (ZEND_CALL_KIND_EX(call_info) == ZEND_CALL_TOP_FUNCTION) {
			i_free_compiled_variables(execute_data);
			if (UNEXPECTED(EX(symbol_table) != NULL)) {
				zend_clean_and_cache_symbol_table(EX(symbol_table));
			}
			zend_vm_stack_free_extra_args_ex(call_info, execute_data);
			EG(current_execute_data) = EX(prev_execute_data);
			if (UNEXPECTED(call_info & ZEND_CALL_CLOSURE)) {
				OBJ_RELEASE((zend_object*)EX(func)->op_array.prototype);
			}
		} else /* if (call_kind == ZEND_CALL_TOP_CODE) */ {
			zend_array *symbol_table = EX(symbol_table);

			zend_detach_symbol_table(execute_data);
			old_execute_data = EX(prev_execute_data);
			while (old_execute_data) {
				if (old_execute_data->func && ZEND_USER_CODE(old_execute_data->func->op_array.type)) {
					if (old_execute_data->symbol_table == symbol_table) {
						zend_attach_symbol_table(old_execute_data);
					}
					break;
				}
				old_execute_data = old_execute_data->prev_execute_data;
			}
			EG(current_execute_data) = EX(prev_execute_data);
		}

		ZEND_VM_RETURN();
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_JMP_SPEC_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	ZEND_VM_SET_OPCODE(OP_JMP_ADDR(opline, opline->op1));
	ZEND_VM_CONTINUE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_DO_ICALL_SPEC_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_execute_data *call = EX(call);
	zend_function *fbc = call->func;
	zval *ret;

	SAVE_OPLINE();
	EX(call) = call->prev_execute_data;

	call->prev_execute_data = execute_data;
	EG(current_execute_data) = call;

	ret = EX_VAR(opline->result.var);
	ZVAL_NULL(ret);
	Z_VAR_FLAGS_P(ret) = 0;

	fbc->internal_function.handler(call, ret);

#if ZEND_DEBUG
	ZEND_ASSERT(
		!call->func ||
		!(call->func->common.fn_flags & ZEND_ACC_HAS_RETURN_TYPE) ||
		zend_verify_internal_return_type(call->func, EX_VAR(opline->result.var)));
#endif

	EG(current_execute_data) = call->prev_execute_data;
	zend_vm_stack_free_args(call);
	zend_vm_stack_free_call_frame(call);

	if (!RETURN_VALUE_USED(opline)) {
		zval_ptr_dtor(EX_VAR(opline->result.var));
	}

	if (UNEXPECTED(EG(exception) != NULL)) {
		zend_throw_exception_internal(NULL);
		if (RETURN_VALUE_USED(opline)) {
			zval_ptr_dtor(EX_VAR(opline->result.var));
		}
		HANDLE_EXCEPTION();
	}

	ZEND_VM_INTERRUPT_CHECK();
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_DO_UCALL_SPEC_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_execute_data *call = EX(call);
	zend_function *fbc = call->func;
	zval *ret;

	SAVE_OPLINE();
	EX(call) = call->prev_execute_data;

	EG(scope) = NULL;
	ret = NULL;
	call->symbol_table = NULL;
	if (RETURN_VALUE_USED(opline)) {
		ret = EX_VAR(opline->result.var);
		ZVAL_NULL(ret);
		Z_VAR_FLAGS_P(ret) = 0;
	}

	call->prev_execute_data = execute_data;
	i_init_func_execute_data(call, &fbc->op_array, ret, 0);

	ZEND_VM_ENTER();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_DO_FCALL_BY_NAME_SPEC_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_execute_data *call = EX(call);
	zend_function *fbc = call->func;
	zval *ret;

	SAVE_OPLINE();
	EX(call) = call->prev_execute_data;

	if (EXPECTED(fbc->type == ZEND_USER_FUNCTION)) {
		EG(scope) = NULL;
		if (UNEXPECTED((fbc->common.fn_flags & ZEND_ACC_GENERATOR) != 0)) {
			if (EXPECTED(RETURN_VALUE_USED(opline))) {
				ret = EX_VAR(opline->result.var);
				zend_generator_create_zval(call, &fbc->op_array, ret);
				Z_VAR_FLAGS_P(ret) = 0;
			} else {
				zend_vm_stack_free_args(call);
			}

			zend_vm_stack_free_call_frame(call);
		} else {
			ret = NULL;
			call->symbol_table = NULL;
			if (RETURN_VALUE_USED(opline)) {
				ret = EX_VAR(opline->result.var);
				ZVAL_NULL(ret);
				Z_VAR_FLAGS_P(ret) = 0;
			}

			call->prev_execute_data = execute_data;
			i_init_func_execute_data(call, &fbc->op_array, ret, 0);

			ZEND_VM_ENTER();
		}
		EG(scope) = EX(func)->op_array.scope;
	} else {
		ZEND_ASSERT(fbc->type == ZEND_INTERNAL_FUNCTION);

		if (UNEXPECTED((fbc->common.fn_flags & ZEND_ACC_DEPRECATED) != 0)) {
			zend_error(E_DEPRECATED, "Function %s%s%s() is deprecated",
				fbc->common.scope ? ZSTR_VAL(fbc->common.scope->name) : "",
				fbc->common.scope ? "::" : "",
				ZSTR_VAL(fbc->common.function_name));
			if (UNEXPECTED(EG(exception) != NULL)) {
				HANDLE_EXCEPTION();
			}
		}

		call->prev_execute_data = execute_data;
		EG(current_execute_data) = call;

		if (fbc->common.fn_flags & ZEND_ACC_HAS_TYPE_HINTS) {
			uint32_t i;
			uint32_t num_args = ZEND_CALL_NUM_ARGS(call);
			zval *p = ZEND_CALL_ARG(call, 1);

			for (i = 0; i < num_args; ++i) {
				zend_verify_internal_arg_type(fbc, i + 1, p);
				p++;
			}
			if (UNEXPECTED(EG(exception) != NULL)) {
				EG(current_execute_data) = call->prev_execute_data;
				zend_vm_stack_free_args(call);
				zend_vm_stack_free_call_frame(call);
				zend_throw_exception_internal(NULL);
				HANDLE_EXCEPTION();
			}
		}

		ret = EX_VAR(opline->result.var);
		ZVAL_NULL(ret);
		Z_VAR_FLAGS_P(ret) = (fbc->common.fn_flags & ZEND_ACC_RETURN_REFERENCE) != 0 ? IS_VAR_RET_REF : 0;

		fbc->internal_function.handler(call, ret);

#if ZEND_DEBUG
		ZEND_ASSERT(
			!call->func ||
			!(call->func->common.fn_flags & ZEND_ACC_HAS_RETURN_TYPE) ||
			zend_verify_internal_return_type(call->func, EX_VAR(opline->result.var)));
#endif

		EG(current_execute_data) = call->prev_execute_data;
		zend_vm_stack_free_args(call);
		zend_vm_stack_free_call_frame(call);

		if (!RETURN_VALUE_USED(opline)) {
			zval_ptr_dtor(EX_VAR(opline->result.var));
		}
	}

	if (UNEXPECTED(EG(exception) != NULL)) {
		zend_throw_exception_internal(NULL);
		if (RETURN_VALUE_USED(opline)) {
			zval_ptr_dtor(EX_VAR(opline->result.var));
		}
		HANDLE_EXCEPTION();
	}
	ZEND_VM_INTERRUPT_CHECK();
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_DO_FCALL_SPEC_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_execute_data *call = EX(call);
	zend_function *fbc = call->func;
	zend_object *object;
	zval *ret;

	SAVE_OPLINE();
	EX(call) = call->prev_execute_data;
	if (UNEXPECTED((fbc->common.fn_flags & (ZEND_ACC_ABSTRACT|ZEND_ACC_DEPRECATED)) != 0)) {
		if (UNEXPECTED((fbc->common.fn_flags & ZEND_ACC_ABSTRACT) != 0)) {
			zend_throw_error(NULL, "Cannot call abstract method %s::%s()", ZSTR_VAL(fbc->common.scope->name), ZSTR_VAL(fbc->common.function_name));
			HANDLE_EXCEPTION();
		}
		if (UNEXPECTED((fbc->common.fn_flags & ZEND_ACC_DEPRECATED) != 0)) {
			zend_error(E_DEPRECATED, "Function %s%s%s() is deprecated",
				fbc->common.scope ? ZSTR_VAL(fbc->common.scope->name) : "",
				fbc->common.scope ? "::" : "",
				ZSTR_VAL(fbc->common.function_name));
			if (UNEXPECTED(EG(exception) != NULL)) {
				HANDLE_EXCEPTION();
			}
		}
	}

	LOAD_OPLINE();

	if (EXPECTED(fbc->type == ZEND_USER_FUNCTION)) {
		EG(scope) = fbc->common.scope;
		if (UNEXPECTED((fbc->common.fn_flags & ZEND_ACC_GENERATOR) != 0)) {
			if (EXPECTED(RETURN_VALUE_USED(opline))) {
				ret = EX_VAR(opline->result.var);
				zend_generator_create_zval(call, &fbc->op_array, ret);
				Z_VAR_FLAGS_P(ret) = 0;
			} else {
				if (UNEXPECTED(ZEND_CALL_INFO(call) & ZEND_CALL_CLOSURE)) {
					OBJ_RELEASE((zend_object*)fbc->op_array.prototype);
				}
				zend_vm_stack_free_args(call);
			}
		} else {
			ret = NULL;
			call->symbol_table = NULL;
			if (RETURN_VALUE_USED(opline)) {
				ret = EX_VAR(opline->result.var);
				ZVAL_NULL(ret);
				Z_VAR_FLAGS_P(ret) = 0;
			}

			call->prev_execute_data = execute_data;
			i_init_func_execute_data(call, &fbc->op_array, ret, 1);

			if (EXPECTED(zend_execute_ex == execute_ex)) {
				ZEND_VM_ENTER();
			} else {
				ZEND_ADD_CALL_FLAG(call, ZEND_CALL_TOP);
				zend_execute_ex(call);
			}
		}
	} else if (EXPECTED(fbc->type < ZEND_USER_FUNCTION)) {
		int should_change_scope = 0;

		if (fbc->common.scope) {
			should_change_scope = 1;
			EG(scope) = fbc->common.scope;
		}

		call->prev_execute_data = execute_data;
		EG(current_execute_data) = call;

		if (fbc->common.fn_flags & ZEND_ACC_HAS_TYPE_HINTS) {
			uint32_t i;
			uint32_t num_args = ZEND_CALL_NUM_ARGS(call);
			zval *p = ZEND_CALL_ARG(call, 1);

			for (i = 0; i < num_args; ++i) {
				zend_verify_internal_arg_type(fbc, i + 1, p);
				if (UNEXPECTED(EG(exception) != NULL)) {
					EG(current_execute_data) = call->prev_execute_data;
					zend_vm_stack_free_args(call);
					if (RETURN_VALUE_USED(opline)) {
						ZVAL_UNDEF(EX_VAR(opline->result.var));
					}
					if (UNEXPECTED(should_change_scope)) {
						goto fcall_end_change_scope;
					} else {
						goto fcall_end;
					}
				}
				p++;
			}
		}

		ret = EX_VAR(opline->result.var);
		ZVAL_NULL(ret);
		Z_VAR_FLAGS_P(ret) = (fbc->common.fn_flags & ZEND_ACC_RETURN_REFERENCE) != 0 ? IS_VAR_RET_REF : 0;

		if (!zend_execute_internal) {
			/* saves one function call if zend_execute_internal is not used */
			fbc->internal_function.handler(call, ret);
		} else {
			zend_execute_internal(call, ret);
		}

#if ZEND_DEBUG
		ZEND_ASSERT(
			!call->func ||
			!(call->func->common.fn_flags & ZEND_ACC_HAS_RETURN_TYPE) ||
			zend_verify_internal_return_type(call->func, EX_VAR(opline->result.var)));
#endif

		EG(current_execute_data) = call->prev_execute_data;
		zend_vm_stack_free_args(call);

		if (!RETURN_VALUE_USED(opline)) {
			zval_ptr_dtor(EX_VAR(opline->result.var));
		}

		if (UNEXPECTED(should_change_scope)) {
			goto fcall_end_change_scope;
		} else {
			goto fcall_end;
		}
	} else { /* ZEND_OVERLOADED_FUNCTION */
		EG(scope) = fbc->common.scope;

		ZVAL_NULL(EX_VAR(opline->result.var));

		/* Not sure what should be done here if it's a static method */
		object = Z_OBJ(call->This);
		if (EXPECTED(object != NULL)) {
			call->prev_execute_data = execute_data;
			EG(current_execute_data) = call;
			object->handlers->call_method(fbc->common.function_name, object, call, EX_VAR(opline->result.var));
			EG(current_execute_data) = call->prev_execute_data;
		} else {
			zend_throw_error(NULL, "Cannot call overloaded function for non-object");
#if 0
			//TODO: implement clean exit ???
			zend_vm_stack_free_args(call);

			zend_vm_stack_free_call_frame(call);

			if (fbc->type == ZEND_OVERLOADED_FUNCTION_TEMPORARY) {
				zend_string_release(fbc->common.function_name);
			}
			efree(fbc);
#endif
			HANDLE_EXCEPTION();
		}

		zend_vm_stack_free_args(call);

		if (fbc->type == ZEND_OVERLOADED_FUNCTION_TEMPORARY) {
			zend_string_release(fbc->common.function_name);
		}
		efree(fbc);

		if (!RETURN_VALUE_USED(opline)) {
			zval_ptr_dtor(EX_VAR(opline->result.var));
		} else {
			Z_VAR_FLAGS_P(EX_VAR(opline->result.var)) = 0;
		}
	}

fcall_end_change_scope:
	if (UNEXPECTED(ZEND_CALL_INFO(call) & ZEND_CALL_RELEASE_THIS)) {
		object = Z_OBJ(call->This);
#if 0
		if (UNEXPECTED(EG(exception) != NULL) && (opline->op1.num & ZEND_CALL_CTOR)) {
			if (!(opline->op1.num & ZEND_CALL_CTOR_RESULT_UNUSED)) {
#else
		if (UNEXPECTED(EG(exception) != NULL) && (ZEND_CALL_INFO(call) & ZEND_CALL_CTOR)) {
			if (!(ZEND_CALL_INFO(call) & ZEND_CALL_CTOR_RESULT_UNUSED)) {
#endif
				GC_REFCOUNT(object)--;
			}
			if (GC_REFCOUNT(object) == 1) {
				zend_object_store_ctor_failed(object);
			}
		}
		OBJ_RELEASE(object);
	}
	EG(scope) = EX(func)->op_array.scope;

fcall_end:
	zend_vm_stack_free_call_frame(call);
	if (UNEXPECTED(EG(exception) != NULL)) {
		zend_throw_exception_internal(NULL);
		if (RETURN_VALUE_USED(opline)) {
			zval_ptr_dtor(EX_VAR(opline->result.var));
		}
		HANDLE_EXCEPTION();
	}

	ZEND_VM_INTERRUPT_CHECK();
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_SEND_UNPACK_SPEC_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *args;
	int arg_num;

	SAVE_OPLINE();
	args = get_zval_ptr_undef(opline->op1_type, opline->op1, execute_data, &free_op1, BP_VAR_R);
	arg_num = ZEND_CALL_NUM_ARGS(EX(call)) + 1;

send_again:
	if (EXPECTED(Z_TYPE_P(args) == IS_ARRAY)) {
		HashTable *ht = Z_ARRVAL_P(args);
		zval *arg, *top;
		zend_string *name;

		zend_vm_stack_extend_call_frame(&EX(call), arg_num - 1, zend_hash_num_elements(ht));

		if (opline->op1_type != IS_CONST && opline->op1_type != IS_TMP_VAR && Z_IMMUTABLE_P(args)) {
			uint32_t i;
			int separate = 0;

			/* check if any of arguments are going to be passed by reference */
			for (i = 0; i < zend_hash_num_elements(ht); i++) {
				if (ARG_SHOULD_BE_SENT_BY_REF(EX(call)->func, arg_num + i)) {
					separate = 1;
					break;
				}
			}
			if (separate) {
				zval_copy_ctor(args);
				ht = Z_ARRVAL_P(args);
			}
		}

		ZEND_HASH_FOREACH_STR_KEY_VAL(ht, name, arg) {
			if (name) {
				zend_throw_error(NULL, "Cannot unpack array with string keys");
				FREE_OP(free_op1);
				HANDLE_EXCEPTION();
			}

			top = ZEND_CALL_ARG(EX(call), arg_num);
			if (ARG_SHOULD_BE_SENT_BY_REF(EX(call)->func, arg_num)) {
				if (!Z_IMMUTABLE_P(args)) {
					ZVAL_MAKE_REF(arg);
					Z_ADDREF_P(arg);
					ZVAL_REF(top, Z_REF_P(arg));
				} else {
					ZVAL_DUP(top, arg);
				}
			} else if (Z_ISREF_P(arg)) {
				ZVAL_COPY(top, Z_REFVAL_P(arg));
			} else {
				ZVAL_COPY(top, arg);
			}

			ZEND_CALL_NUM_ARGS(EX(call))++;
			arg_num++;
		} ZEND_HASH_FOREACH_END();

	} else if (EXPECTED(Z_TYPE_P(args) == IS_OBJECT)) {
		zend_class_entry *ce = Z_OBJCE_P(args);
		zend_object_iterator *iter;

		if (!ce || !ce->get_iterator) {
			zend_error(E_WARNING, "Only arrays and Traversables can be unpacked");
		} else {

			iter = ce->get_iterator(ce, args, 0);
			if (UNEXPECTED(!iter)) {
				FREE_OP(free_op1);
				if (!EG(exception)) {
					zend_throw_exception_ex(
						NULL, 0, "Object of type %s did not create an Iterator", ZSTR_VAL(ce->name)
					);
				}
				HANDLE_EXCEPTION();
			}

			if (iter->funcs->rewind) {
				iter->funcs->rewind(iter);
				if (UNEXPECTED(EG(exception) != NULL)) {
					goto unpack_iter_dtor;
				}
			}

			for (; iter->funcs->valid(iter) == SUCCESS; ++arg_num) {
				zval *arg, *top;

				if (UNEXPECTED(EG(exception) != NULL)) {
					goto unpack_iter_dtor;
				}

				arg = iter->funcs->get_current_data(iter);
				if (UNEXPECTED(EG(exception) != NULL)) {
					goto unpack_iter_dtor;
				}

				if (iter->funcs->get_current_key) {
					zval key;
					iter->funcs->get_current_key(iter, &key);
					if (UNEXPECTED(EG(exception) != NULL)) {
						goto unpack_iter_dtor;
					}

					if (Z_TYPE(key) == IS_STRING) {
						zend_throw_error(NULL,
							"Cannot unpack Traversable with string keys");
						zend_string_release(Z_STR(key));
						goto unpack_iter_dtor;
					}

					zval_dtor(&key);
				}

				if (ARG_MUST_BE_SENT_BY_REF(EX(call)->func, arg_num)) {
					zend_error(
						E_WARNING, "Cannot pass by-reference argument %d of %s%s%s()"
						" by unpacking a Traversable, passing by-value instead", arg_num,
						EX(call)->func->common.scope ? ZSTR_VAL(EX(call)->func->common.scope->name) : "",
						EX(call)->func->common.scope ? "::" : "",
						ZSTR_VAL(EX(call)->func->common.function_name)
					);
				}

				if (Z_ISREF_P(arg)) {
					ZVAL_DUP(arg, Z_REFVAL_P(arg));
				} else {
					if (Z_REFCOUNTED_P(arg)) Z_ADDREF_P(arg);
				}

				zend_vm_stack_extend_call_frame(&EX(call), arg_num - 1, 1);
				top = ZEND_CALL_ARG(EX(call), arg_num);
				ZVAL_COPY_VALUE(top, arg);
				ZEND_CALL_NUM_ARGS(EX(call))++;

				iter->funcs->move_forward(iter);
				if (UNEXPECTED(EG(exception) != NULL)) {
					goto unpack_iter_dtor;
				}
			}

unpack_iter_dtor:
			zend_iterator_dtor(iter);
		}
	} else if (EXPECTED(Z_ISREF_P(args))) {
		args = Z_REFVAL_P(args);
		goto send_again;
	} else {
		if (opline->op1_type == IS_CV && UNEXPECTED(Z_TYPE_P(args) == IS_UNDEF)) {
			GET_OP1_UNDEF_CV(args, BP_VAR_R);
		}
		zend_error(E_WARNING, "Only arrays and Traversables can be unpacked");
	}

	FREE_OP(free_op1);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_SEND_ARRAY_SPEC_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *args;
	SAVE_OPLINE();

	SAVE_OPLINE();
	args = get_zval_ptr(opline->op1_type, opline->op1, execute_data, &free_op1, BP_VAR_R);

	if (UNEXPECTED(Z_TYPE_P(args) != IS_ARRAY)) {
		if ((opline->op1_type & (IS_VAR|IS_CV)) && Z_ISREF_P(args)) {
			args = Z_REFVAL_P(args);
			if (EXPECTED(Z_TYPE_P(args) == IS_ARRAY)) {
				goto send_array;
			}
		}
		zend_internal_type_error(EX_USES_STRICT_TYPES(), "call_user_func_array() expects parameter 2 to be array, %s given", zend_get_type_by_const(Z_TYPE_P(args)));
		if (ZEND_CALL_INFO(EX(call)) & ZEND_CALL_CLOSURE) {
			OBJ_RELEASE((zend_object*)EX(call)->func->common.prototype);
		}
		if (Z_OBJ(EX(call)->This)) {
			OBJ_RELEASE(Z_OBJ(EX(call)->This));
		}
		EX(call)->func = (zend_function*)&zend_pass_function;
		EX(call)->called_scope = NULL;
		Z_OBJ(EX(call)->This) = NULL;
	} else {
		uint32_t arg_num;
		HashTable *ht;
		zval *arg, *param;

send_array:
		ht = Z_ARRVAL_P(args);
		zend_vm_stack_extend_call_frame(&EX(call), 0, zend_hash_num_elements(ht));

		if (opline->op1_type != IS_CONST && opline->op1_type != IS_TMP_VAR && Z_IMMUTABLE_P(args)) {
			int separate = 0;

			/* check if any of arguments are going to be passed by reference */
			for (arg_num = 0; arg_num < zend_hash_num_elements(ht); arg_num++) {
				if (ARG_SHOULD_BE_SENT_BY_REF(EX(call)->func, arg_num + 1)) {
					separate = 1;
					break;
				}
			}
			if (separate) {
				zval_copy_ctor(args);
				ht = Z_ARRVAL_P(args);
			}
		}

		arg_num = 1;
		param = ZEND_CALL_ARG(EX(call), 1);
		ZEND_HASH_FOREACH_VAL(ht, arg) {
			if (ARG_SHOULD_BE_SENT_BY_REF(EX(call)->func, arg_num)) {
				if (UNEXPECTED(!Z_ISREF_P(arg))) {
					if (!ARG_MAY_BE_SENT_BY_REF(EX(call)->func, arg_num)) {

						zend_error(E_WARNING, "Parameter %d to %s%s%s() expected to be a reference, value given",
							arg_num,
							EX(call)->func->common.scope ? ZSTR_VAL(EX(call)->func->common.scope->name) : "",
							EX(call)->func->common.scope ? "::" : "",
							ZSTR_VAL(EX(call)->func->common.function_name));

						if (ZEND_CALL_INFO(EX(call)) & ZEND_CALL_CLOSURE) {
							OBJ_RELEASE((zend_object*)EX(call)->func->common.prototype);
						}
						if (Z_OBJ(EX(call)->This)) {
							OBJ_RELEASE(Z_OBJ(EX(call)->This));
						}
						EX(call)->func = (zend_function*)&zend_pass_function;
						EX(call)->called_scope = NULL;
						Z_OBJ(EX(call)->This) = NULL;

						break;
					}

					ZVAL_NEW_REF(arg, arg);
				}
				Z_ADDREF_P(arg);
			} else{
				if (Z_ISREF_P(arg) &&
				    !(EX(call)->func->common.fn_flags & ZEND_ACC_CALL_VIA_TRAMPOLINE)) {
					/* don't separate references for __call */
					arg = Z_REFVAL_P(arg);
				}
				if (Z_OPT_REFCOUNTED_P(arg)) {
					Z_ADDREF_P(arg);
				}
			}
			ZVAL_COPY_VALUE(param, arg);
			ZEND_CALL_NUM_ARGS(EX(call))++;
			arg_num++;
			param++;
		} ZEND_HASH_FOREACH_END();
	}
	FREE_OP(free_op1);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_RECV_SPEC_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	uint32_t arg_num = opline->op1.num;

	if (UNEXPECTED(arg_num > EX_NUM_ARGS())) {
		SAVE_OPLINE();
		if (UNEXPECTED(!zend_verify_missing_arg(execute_data, arg_num, CACHE_ADDR(opline->op2.num)))) {
			HANDLE_EXCEPTION();
		}
	} else if (UNEXPECTED((EX(func)->op_array.fn_flags & ZEND_ACC_HAS_TYPE_HINTS) != 0)) {
		zval *param = _get_zval_ptr_cv_undef_BP_VAR_W(execute_data, opline->result.var);

		SAVE_OPLINE();
		if (UNEXPECTED(!zend_verify_arg_type(EX(func), arg_num, param, NULL, CACHE_ADDR(opline->op2.num)))) {
			HANDLE_EXCEPTION();
		}
	}

	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_RECV_VARIADIC_SPEC_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	uint32_t arg_num = opline->op1.num;
	uint32_t arg_count = EX_NUM_ARGS();
	zval *params;

	SAVE_OPLINE();

	params = _get_zval_ptr_cv_undef_BP_VAR_W(execute_data, opline->result.var);

	if (arg_num <= arg_count) {
		zval *param;

		array_init_size(params, arg_count - arg_num + 1);
		zend_hash_real_init(Z_ARRVAL_P(params), 1);
		ZEND_HASH_FILL_PACKED(Z_ARRVAL_P(params)) {
			param = EX_VAR_NUM(EX(func)->op_array.last_var + EX(func)->op_array.T);
			if (UNEXPECTED((EX(func)->op_array.fn_flags & ZEND_ACC_HAS_TYPE_HINTS) != 0)) {
				do {
					zend_verify_arg_type(EX(func), arg_num, param, NULL, CACHE_ADDR(opline->op2.num));
					if (Z_OPT_REFCOUNTED_P(param)) Z_ADDREF_P(param);
					ZEND_HASH_FILL_ADD(param);
					param++;
				} while (++arg_num <= arg_count);
			} else {
				do {
					if (Z_OPT_REFCOUNTED_P(param)) Z_ADDREF_P(param);
					ZEND_HASH_FILL_ADD(param);
					param++;
				} while (++arg_num <= arg_count);
			}
		} ZEND_HASH_FILL_END();
	} else {
		array_init(params);
	}

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_BEGIN_SILENCE_SPEC_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	ZVAL_LONG(EX_VAR(opline->result.var), EG(error_reporting));

	if (EG(error_reporting)) {
		do {
			EG(error_reporting) = 0;
			if (!EG(error_reporting_ini_entry)) {
				zend_ini_entry *p = zend_hash_str_find_ptr(EG(ini_directives), "error_reporting", sizeof("error_reporting")-1);
				if (p) {
					EG(error_reporting_ini_entry) = p;
				} else {
					break;
				}
			}
			if (!EG(error_reporting_ini_entry)->modified) {
				if (!EG(modified_ini_directives)) {
					ALLOC_HASHTABLE(EG(modified_ini_directives));
					zend_hash_init(EG(modified_ini_directives), 8, NULL, NULL, 0);
				}
				if (EXPECTED(zend_hash_str_add_ptr(EG(modified_ini_directives), "error_reporting", sizeof("error_reporting")-1, EG(error_reporting_ini_entry)) != NULL)) {
					EG(error_reporting_ini_entry)->orig_value = EG(error_reporting_ini_entry)->value;
					EG(error_reporting_ini_entry)->orig_modifiable = EG(error_reporting_ini_entry)->modifiable;
					EG(error_reporting_ini_entry)->modified = 1;
				}
			}
		} while (0);
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_EXT_STMT_SPEC_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	if (!EG(no_extensions)) {
		SAVE_OPLINE();
		zend_llist_apply_with_argument(&zend_extensions, (llist_apply_with_arg_func_t) zend_extension_statement_handler, EX(func));
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_EXT_FCALL_BEGIN_SPEC_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	if (!EG(no_extensions)) {
		SAVE_OPLINE();
		zend_llist_apply_with_argument(&zend_extensions, (llist_apply_with_arg_func_t) zend_extension_fcall_begin_handler, EX(func));
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_EXT_FCALL_END_SPEC_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	if (!EG(no_extensions)) {
		SAVE_OPLINE();
		zend_llist_apply_with_argument(&zend_extensions, (llist_apply_with_arg_func_t) zend_extension_fcall_end_handler, EX(func));
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_DECLARE_CLASS_SPEC_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	SAVE_OPLINE();
	Z_CE_P(EX_VAR(opline->result.var)) = do_bind_class(&EX(func)->op_array, opline, EG(class_table), 0);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_DECLARE_INHERITED_CLASS_SPEC_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	SAVE_OPLINE();
	Z_CE_P(EX_VAR(opline->result.var)) = do_bind_inherited_class(&EX(func)->op_array, opline, EG(class_table), Z_CE_P(EX_VAR(opline->extended_value)), 0);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_DECLARE_INHERITED_CLASS_DELAYED_SPEC_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *zce, *orig_zce;

	SAVE_OPLINE();
	if ((zce = zend_hash_find(EG(class_table), Z_STR_P(EX_CONSTANT(opline->op2)))) == NULL ||
	    ((orig_zce = zend_hash_find(EG(class_table), Z_STR_P(EX_CONSTANT(opline->op1)))) != NULL &&
	     Z_CE_P(zce) != Z_CE_P(orig_zce))) {
		do_bind_inherited_class(&EX(func)->op_array, opline, EG(class_table), Z_CE_P(EX_VAR(opline->extended_value)), 0);
	}
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_DECLARE_ANON_CLASS_SPEC_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	zend_class_entry *ce;
	USE_OPLINE

	SAVE_OPLINE();
	ce = zend_hash_find_ptr(EG(class_table), Z_STR_P(EX_CONSTANT(opline->op2)));
	Z_CE_P(EX_VAR(opline->result.var)) = ce;
	ZEND_ASSERT(ce != NULL);

	if (ce->ce_flags & ZEND_ACC_ANON_BOUND) {
		ZEND_VM_JMP(OP_JMP_ADDR(opline, opline->op1));
	}

	if (!(ce->ce_flags & (ZEND_ACC_INTERFACE|ZEND_ACC_IMPLEMENT_INTERFACES|ZEND_ACC_IMPLEMENT_TRAITS))) {
		zend_verify_abstract_class(ce);
	}
	ce->ce_flags |= ZEND_ACC_ANON_BOUND;
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_DECLARE_ANON_INHERITED_CLASS_SPEC_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	zend_class_entry *ce;
	USE_OPLINE

	SAVE_OPLINE();
	ce = zend_hash_find_ptr(EG(class_table), Z_STR_P(EX_CONSTANT(opline->op2)));
	Z_CE_P(EX_VAR(opline->result.var)) = ce;
	ZEND_ASSERT(ce != NULL);

	if (ce->ce_flags & ZEND_ACC_ANON_BOUND) {
		ZEND_VM_JMP(OP_JMP_ADDR(opline, opline->op1));
	}

	zend_do_inheritance(ce, Z_CE_P(EX_VAR(opline->extended_value)));
	ce->ce_flags |= ZEND_ACC_ANON_BOUND;
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_DECLARE_FUNCTION_SPEC_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	SAVE_OPLINE();
	do_bind_function(&EX(func)->op_array, opline, EG(function_table), 0);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_TICKS_SPEC_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	if ((uint32_t)++EG(ticks_count) >= opline->extended_value) {
		EG(ticks_count) = 0;
		if (zend_ticks_function) {
			SAVE_OPLINE();
			zend_ticks_function(opline->extended_value);
			ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
		}
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_EXT_NOP_SPEC_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_NOP_SPEC_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ADD_TRAIT_SPEC_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_class_entry *ce = Z_CE_P(EX_VAR(opline->op1.var));
	zend_class_entry *trait;

	SAVE_OPLINE();
	if (EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2))))) {
		trait = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)));
	} else {
		trait = zend_fetch_class_by_name(Z_STR_P(EX_CONSTANT(opline->op2)),
		                                 EX_CONSTANT(opline->op2) + 1,
		                                 ZEND_FETCH_CLASS_TRAIT);
		if (UNEXPECTED(trait == NULL)) {
			ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
		}
		if (!(trait->ce_flags & ZEND_ACC_TRAIT)) {
			zend_error_noreturn(E_ERROR, "%s cannot use %s - it is not a trait", ZSTR_VAL(ce->name), ZSTR_VAL(trait->name));
		}
		CACHE_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)), trait);
	}

	zend_do_implement_trait(ce, trait);

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_BIND_TRAITS_SPEC_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_class_entry *ce = Z_CE_P(EX_VAR(opline->op1.var));

	SAVE_OPLINE();
	zend_do_bind_traits(ce);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_HANDLE_EXCEPTION_SPEC_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	uint32_t op_num = EG(opline_before_exception) - EX(func)->op_array.opcodes;
	int i;
	uint32_t catch_op_num = 0, finally_op_num = 0, finally_op_end = 0;
	int in_finally = 0;

	ZEND_VM_INTERRUPT_CHECK();

	{
		const zend_op *exc_opline = EG(opline_before_exception);
		if ((exc_opline->opcode == ZEND_FREE || exc_opline->opcode == ZEND_FE_FREE)
			&& exc_opline->extended_value & ZEND_FREE_ON_RETURN) {
			/* exceptions thrown because of loop var destruction on return/break/...
			 * are logically thrown at the end of the foreach loop, so adjust the
			 * op_num.
			 */
			op_num = EX(func)->op_array.brk_cont_array[exc_opline->op2.num].brk;
		}
	}

	for (i = 0; i < EX(func)->op_array.last_try_catch; i++) {
		if (EX(func)->op_array.try_catch_array[i].try_op > op_num) {
			/* further blocks will not be relevant... */
			break;
		}
		in_finally = 0;
		if (op_num < EX(func)->op_array.try_catch_array[i].catch_op) {
			catch_op_num = EX(func)->op_array.try_catch_array[i].catch_op;
		}
		if (op_num < EX(func)->op_array.try_catch_array[i].finally_op) {
			finally_op_num = EX(func)->op_array.try_catch_array[i].finally_op;
			finally_op_end = EX(func)->op_array.try_catch_array[i].finally_end;
		}
		if (op_num >= EX(func)->op_array.try_catch_array[i].finally_op &&
				op_num < EX(func)->op_array.try_catch_array[i].finally_end) {
			finally_op_end = EX(func)->op_array.try_catch_array[i].finally_end;
			in_finally = 1;
		}
	}

	i_cleanup_unfinished_execution(execute_data, op_num, catch_op_num);

	if (finally_op_num && (!catch_op_num || catch_op_num >= finally_op_num)) {
		zval *fast_call = EX_VAR(EX(func)->op_array.opcodes[finally_op_end].op1.var);

		if (in_finally && Z_OBJ_P(fast_call)) {
			zend_exception_set_previous(EG(exception), Z_OBJ_P(fast_call));
		}
		Z_OBJ_P(fast_call) = EG(exception);
		EG(exception) = NULL;
		fast_call->u2.lineno = (uint32_t)-1;
		ZEND_VM_SET_OPCODE(&EX(func)->op_array.opcodes[finally_op_num]);
		ZEND_VM_CONTINUE();
	} else {
		if (in_finally) {
			/* we are going out of current finally scope */
			zval *fast_call = EX_VAR(EX(func)->op_array.opcodes[finally_op_end].op1.var);

			if (Z_OBJ_P(fast_call)) {
				zend_exception_set_previous(EG(exception), Z_OBJ_P(fast_call));
				Z_OBJ_P(fast_call) = NULL;
			}
		}
		if (catch_op_num) {
			ZEND_VM_SET_OPCODE(&EX(func)->op_array.opcodes[catch_op_num]);
			ZEND_VM_CONTINUE();
		} else if (UNEXPECTED((EX(func)->op_array.fn_flags & ZEND_ACC_GENERATOR) != 0)) {
			zend_generator *generator = zend_get_running_generator(execute_data);
			zend_generator_close(generator, 1);
			ZEND_VM_RETURN();
		} else {
			ZEND_VM_TAIL_CALL(zend_leave_helper_SPEC(ZEND_OPCODE_HANDLER_ARGS_PASSTHRU));
		}
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_VERIFY_ABSTRACT_CLASS_SPEC_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	SAVE_OPLINE();
	zend_verify_abstract_class(Z_CE_P(EX_VAR(opline->op1.var)));
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_USER_OPCODE_SPEC_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	int ret;

	SAVE_OPLINE();
	ret = zend_user_opcode_handlers[opline->opcode](execute_data);
	LOAD_OPLINE();

	switch (ret) {
		case ZEND_USER_OPCODE_CONTINUE:
			ZEND_VM_CONTINUE();
		case ZEND_USER_OPCODE_RETURN:
			if (UNEXPECTED((EX(func)->op_array.fn_flags & ZEND_ACC_GENERATOR) != 0)) {
				zend_generator *generator = zend_get_running_generator(execute_data);
				zend_generator_close(generator, 1);
				ZEND_VM_RETURN();
			} else {
				ZEND_VM_TAIL_CALL(zend_leave_helper_SPEC(ZEND_OPCODE_HANDLER_ARGS_PASSTHRU));
			}
		case ZEND_USER_OPCODE_ENTER:
			ZEND_VM_ENTER();
		case ZEND_USER_OPCODE_LEAVE:
			ZEND_VM_LEAVE();
		case ZEND_USER_OPCODE_DISPATCH:
			ZEND_VM_DISPATCH(opline->opcode, opline);
		default:
			ZEND_VM_DISPATCH((zend_uchar)(ret & 0xff), opline);
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_DISCARD_EXCEPTION_SPEC_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *fast_call = EX_VAR(opline->op1.var);

	/* check for delayed exception */
	if (Z_OBJ_P(fast_call) != NULL) {
		SAVE_OPLINE();
		/* discard the previously thrown exception */
		OBJ_RELEASE(Z_OBJ_P(fast_call));
		Z_OBJ_P(fast_call) = NULL;
	}

	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FAST_CALL_SPEC_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *fast_call = EX_VAR(opline->result.var);

	if (opline->extended_value == ZEND_FAST_CALL_FROM_FINALLY && UNEXPECTED(Z_OBJ_P(fast_call) != NULL)) {
		fast_call->u2.lineno = (uint32_t)-1;
	} else {
		Z_OBJ_P(fast_call) = NULL;
		/* set return address */
		fast_call->u2.lineno = opline - EX(func)->op_array.opcodes;
	}
	ZEND_VM_SET_OPCODE(OP_JMP_ADDR(opline, opline->op1));
	ZEND_VM_CONTINUE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FAST_RET_SPEC_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *fast_call = EX_VAR(opline->op1.var);

	if (fast_call->u2.lineno != (uint32_t)-1) {
		const zend_op *fast_ret = EX(func)->op_array.opcodes + fast_call->u2.lineno;
		ZEND_VM_SET_OPCODE(fast_ret + 1);
		if (fast_ret->extended_value & ZEND_FAST_CALL_FROM_FINALLY) {
			fast_call->u2.lineno = fast_ret->op2.opline_num;
		}
		ZEND_VM_CONTINUE();
	} else {
		/* special case for unhandled exceptions */
		USE_OPLINE

		if (opline->extended_value == ZEND_FAST_RET_TO_FINALLY) {
			ZEND_VM_SET_OPCODE(&EX(func)->op_array.opcodes[opline->op2.opline_num]);
			ZEND_VM_CONTINUE();
		} else {
			EG(exception) = Z_OBJ_P(fast_call);
			Z_OBJ_P(fast_call) = NULL;
			if (opline->extended_value == ZEND_FAST_RET_TO_CATCH) {
				ZEND_VM_SET_OPCODE(&EX(func)->op_array.opcodes[opline->op2.opline_num]);
				ZEND_VM_CONTINUE();
			} else if (UNEXPECTED((EX(func)->op_array.fn_flags & ZEND_ACC_GENERATOR) != 0)) {
				zend_generator *generator = zend_get_running_generator(execute_data);
				zend_generator_close(generator, 1);
				ZEND_VM_RETURN();
			} else {
				ZEND_VM_TAIL_CALL(zend_leave_helper_SPEC(ZEND_OPCODE_HANDLER_ARGS_PASSTHRU));
			}
		}
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSERT_CHECK_SPEC_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	if (EG(assertions) <= 0) {
		zend_op *target = OP_JMP_ADDR(opline, opline->op2);
		zend_op *result = target - 1;
		SKIP_EXT_OPLINE(result);
		if (RETURN_VALUE_USED(result)) {
			ZVAL_TRUE(EX_VAR(result->result.var));
		}
		ZEND_VM_JMP(target);
	} else {
		ZEND_VM_NEXT_OPCODE();
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_CLASS_NAME_SPEC_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	uint32_t fetch_type;
	USE_OPLINE

	SAVE_OPLINE();
	fetch_type = opline->extended_value;

	if (UNEXPECTED(EG(scope) == NULL)) {
		zend_throw_error(NULL, "Cannot use \"%s\" when no class scope is active",
			fetch_type == ZEND_FETCH_CLASS_SELF ? "self" :
			fetch_type == ZEND_FETCH_CLASS_PARENT ? "parent" : "static");
		HANDLE_EXCEPTION();
	}

	switch (fetch_type) {
		case ZEND_FETCH_CLASS_SELF:
			ZVAL_STR_COPY(EX_VAR(opline->result.var), EG(scope)->name);
			break;
		case ZEND_FETCH_CLASS_PARENT:
			if (UNEXPECTED(EG(scope)->parent == NULL)) {
				zend_throw_error(NULL,
					"Cannot use \"parent\" when current class scope has no parent");
				HANDLE_EXCEPTION();
			}
			ZVAL_STR_COPY(EX_VAR(opline->result.var), EG(scope)->parent->name);
			break;
		case ZEND_FETCH_CLASS_STATIC:
			ZVAL_STR_COPY(EX_VAR(opline->result.var), EX(called_scope)->name);
			break;
		EMPTY_SWITCH_DEFAULT_CASE()
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_CALL_TRAMPOLINE_SPEC_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	zend_array *args;
	zend_function *fbc = EX(func);
	zend_object *object = Z_OBJ(EX(This));
	zval *ret = EX(return_value);
	uint32_t call_info = EX_CALL_INFO() & (ZEND_CALL_NESTED | ZEND_CALL_TOP | ZEND_CALL_RELEASE_THIS);
	zend_class_entry *scope = EX(called_scope);
	uint32_t num_args = EX_NUM_ARGS();
	zend_execute_data *call;
	USE_OPLINE

	args = emalloc(sizeof(zend_array));
	zend_hash_init(args, num_args, NULL, ZVAL_PTR_DTOR, 0);
	if (num_args) {
		zval *p = ZEND_CALL_ARG(execute_data, 1);
		zval *end = p + num_args;

		zend_hash_real_init(args, 1);
		ZEND_HASH_FILL_PACKED(args) {
			do {
				ZEND_HASH_FILL_ADD(p);
				p++;
			} while (p != end);
		} ZEND_HASH_FILL_END();
	}

	SAVE_OPLINE();
	call = execute_data;
	execute_data = EG(current_execute_data) = EX(prev_execute_data);
	zend_vm_stack_free_call_frame(call);
	call = zend_vm_stack_push_call_frame(call_info, fbc->common.prototype, 2, scope, object);
	call->prev_execute_data = execute_data;

	ZVAL_STR(ZEND_CALL_ARG(call, 1), fbc->common.function_name);
	ZVAL_ARR(ZEND_CALL_ARG(call, 2), args);
	zend_free_trampoline(fbc);
	fbc = call->func;

	if (EXPECTED(fbc->type == ZEND_USER_FUNCTION)) {

		ZEND_ASSERT(!(fbc->common.fn_flags & ZEND_ACC_GENERATOR));

		call->symbol_table = NULL;
		i_init_func_execute_data(call, &fbc->op_array,
				ret, (fbc->common.fn_flags & ZEND_ACC_STATIC) == 0);

		if (EXPECTED(zend_execute_ex == execute_ex)) {
			ZEND_VM_ENTER();
		} else {
			ZEND_ADD_CALL_FLAG(call, ZEND_CALL_TOP);
			zend_execute_ex(call);
		}
	} else {
		zval retval;

		ZEND_ASSERT(fbc->type == ZEND_INTERNAL_FUNCTION);

		EG(current_execute_data) = call;

		if (fbc->common.fn_flags & ZEND_ACC_HAS_TYPE_HINTS) {
			uint32_t i;
			uint32_t num_args = ZEND_CALL_NUM_ARGS(call);
			zval *p = ZEND_CALL_ARG(call, 1);

			EG(current_execute_data) = call;

			for (i = 0; i < num_args; ++i) {
				zend_verify_internal_arg_type(fbc, i + 1, p);
				if (UNEXPECTED(EG(exception) != NULL)) {
					EG(current_execute_data) = call->prev_execute_data;
					zend_vm_stack_free_args(call);
					zend_vm_stack_free_call_frame(call);
					if (ret) {
						ZVAL_UNDEF(ret);
					}
					goto call_trampoline_end;
				}
				p++;
			}
		}

		if (ret == NULL) {
			ZVAL_NULL(&retval);
			ret = &retval;
		}
		Z_VAR_FLAGS_P(ret) = (fbc->common.fn_flags & ZEND_ACC_RETURN_REFERENCE) != 0 ? IS_VAR_RET_REF : 0;

		if (!zend_execute_internal) {
			/* saves one function call if zend_execute_internal is not used */
			fbc->internal_function.handler(call, ret);
		} else {
			zend_execute_internal(call, ret);
		}

#if ZEND_DEBUG
		ZEND_ASSERT(
			!call->func ||
			!(call->func->common.fn_flags & ZEND_ACC_HAS_RETURN_TYPE) ||
			zend_verify_internal_return_type(call->func, EX_VAR(opline->result.var)));
#endif

		EG(current_execute_data) = call->prev_execute_data;

		zend_vm_stack_free_args(call);

		if (ret == &retval) {
			zval_ptr_dtor(ret);
		}
	}

call_trampoline_end:
	execute_data = EG(current_execute_data);

	if (!EX(func) || !ZEND_USER_CODE(EX(func)->type) || (call_info & ZEND_CALL_TOP)) {
		ZEND_VM_RETURN();
	}

	opline = EX(opline);

	if (UNEXPECTED(call_info & ZEND_CALL_RELEASE_THIS)) {
		object = Z_OBJ(call->This);
		OBJ_RELEASE(object);
	}
	EG(scope) = EX(func)->op_array.scope;
	zend_vm_stack_free_call_frame(call);

	if (UNEXPECTED(EG(exception) != NULL)) {
		zend_throw_exception_internal(NULL);
		if (RETURN_VALUE_USED(opline)) {
			zval_ptr_dtor(EX_VAR(opline->result.var));
		}
		HANDLE_EXCEPTION_LEAVE();
	}

	ZEND_VM_INC_OPCODE();
	ZEND_VM_LEAVE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_CLASS_SPEC_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	SAVE_OPLINE();
	if (IS_CONST == IS_UNUSED) {
		Z_CE_P(EX_VAR(opline->result.var)) = zend_fetch_class(NULL, opline->extended_value);
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	} else {

		zval *class_name = EX_CONSTANT(opline->op2);

try_class_name:
		if (IS_CONST == IS_CONST) {
			if (EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(class_name)))) {
				Z_CE_P(EX_VAR(opline->result.var)) = CACHED_PTR(Z_CACHE_SLOT_P(class_name));
			} else {
				Z_CE_P(EX_VAR(opline->result.var)) = zend_fetch_class_by_name(Z_STR_P(class_name), EX_CONSTANT(opline->op2) + 1, opline->extended_value);
				CACHE_PTR(Z_CACHE_SLOT_P(class_name), Z_CE_P(EX_VAR(opline->result.var)));
			}
		} else if (Z_TYPE_P(class_name) == IS_OBJECT) {
			Z_CE_P(EX_VAR(opline->result.var)) = Z_OBJCE_P(class_name);
		} else if (Z_TYPE_P(class_name) == IS_STRING) {
			Z_CE_P(EX_VAR(opline->result.var)) = zend_fetch_class(Z_STR_P(class_name), opline->extended_value);
		} else if ((IS_CONST & (IS_VAR|IS_CV)) && Z_TYPE_P(class_name) == IS_REFERENCE) {
			class_name = Z_REFVAL_P(class_name);
			goto try_class_name;
		} else {
			if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(class_name) == IS_UNDEF)) {
				GET_OP2_UNDEF_CV(class_name, BP_VAR_R);
			}
			if (UNEXPECTED(EG(exception) != NULL)) {
				HANDLE_EXCEPTION();
			}
			zend_throw_error(NULL, "Class name must be a valid object or a string");
		}

		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_INIT_FCALL_BY_NAME_SPEC_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_function *fbc;
	zval *function_name, *func;
	zend_execute_data *call;

	if (EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2))))) {
		fbc = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)));
	} else {
		function_name = (zval*)(EX_CONSTANT(opline->op2)+1);
		if (UNEXPECTED((func = zend_hash_find(EG(function_table), Z_STR_P(function_name))) == NULL)) {
			SAVE_OPLINE();
			zend_throw_error(NULL, "Call to undefined function %s()", Z_STRVAL_P(EX_CONSTANT(opline->op2)));
			HANDLE_EXCEPTION();
		} else {
			fbc = Z_FUNC_P(func);
			CACHE_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)), fbc);
		}
	}
	call = zend_vm_stack_push_call_frame(ZEND_CALL_NESTED_FUNCTION,
		fbc, opline->extended_value, NULL, NULL);
	call->prev_execute_data = EX(call);
	EX(call) = call;

	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_INIT_DYNAMIC_CALL_SPEC_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_function *fbc;
	zval *function_name, *func;
	zend_string *lcname;

	zend_class_entry *called_scope;
	zend_object *object;
	zend_execute_data *call;
	uint32_t call_info = ZEND_CALL_NESTED_FUNCTION;

	SAVE_OPLINE();
	function_name = EX_CONSTANT(opline->op2);

try_function_name:
	if (IS_CONST != IS_CONST && EXPECTED(Z_TYPE_P(function_name) == IS_STRING)) {
		const char *colon;

		if ((colon = zend_memrchr(Z_STRVAL_P(function_name), ':', Z_STRLEN_P(function_name))) != NULL &&
			colon > Z_STRVAL_P(function_name) &&
			*(colon-1) == ':'
		) {
			zend_string *mname;
			size_t cname_length = colon - Z_STRVAL_P(function_name) - 1;
			size_t mname_length = Z_STRLEN_P(function_name) - cname_length - (sizeof("::") - 1);

			lcname = zend_string_init(Z_STRVAL_P(function_name), cname_length, 0);

			object = NULL;
			called_scope = zend_fetch_class_by_name(lcname, NULL, ZEND_FETCH_CLASS_DEFAULT | ZEND_FETCH_CLASS_EXCEPTION);
			if (UNEXPECTED(called_scope == NULL)) {
				zend_string_release(lcname);
				ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
			}

			mname = zend_string_init(Z_STRVAL_P(function_name) + (cname_length + sizeof("::") - 1), mname_length, 0);

			if (called_scope->get_static_method) {
				fbc = called_scope->get_static_method(called_scope, mname);
			} else {
				fbc = zend_std_get_static_method(called_scope, mname, NULL);
			}
			if (UNEXPECTED(fbc == NULL)) {
				if (EXPECTED(!EG(exception))) {
					zend_throw_error(NULL, "Call to undefined method %s::%s()", ZSTR_VAL(called_scope->name), ZSTR_VAL(mname));
				}
				zend_string_release(lcname);
				zend_string_release(mname);

				HANDLE_EXCEPTION();
			}

			zend_string_release(lcname);
			zend_string_release(mname);

			if (!(fbc->common.fn_flags & ZEND_ACC_STATIC)) {
				if (fbc->common.fn_flags & ZEND_ACC_ALLOW_STATIC) {
					zend_error(E_DEPRECATED,
						"Non-static method %s::%s() should not be called statically",
						ZSTR_VAL(fbc->common.scope->name), ZSTR_VAL(fbc->common.function_name));
					if (UNEXPECTED(EG(exception) != NULL)) {
						HANDLE_EXCEPTION();
					}
				} else {
					zend_throw_error(
						zend_ce_error,
						"Non-static method %s::%s() cannot be called statically",
						ZSTR_VAL(fbc->common.scope->name), ZSTR_VAL(fbc->common.function_name));

					HANDLE_EXCEPTION();
				}
			}
		} else {
			if (Z_STRVAL_P(function_name)[0] == '\\') {
				lcname = zend_string_alloc(Z_STRLEN_P(function_name) - 1, 0);
				zend_str_tolower_copy(ZSTR_VAL(lcname), Z_STRVAL_P(function_name) + 1, Z_STRLEN_P(function_name) - 1);
			} else {
				lcname = zend_string_tolower(Z_STR_P(function_name));
			}
			if (UNEXPECTED((func = zend_hash_find(EG(function_table), lcname)) == NULL)) {
				zend_throw_error(NULL, "Call to undefined function %s()", Z_STRVAL_P(function_name));
				zend_string_release(lcname);

				HANDLE_EXCEPTION();
			}
			zend_string_release(lcname);

			fbc = Z_FUNC_P(func);
			called_scope = NULL;
			object = NULL;
		}

	} else if (IS_CONST != IS_CONST &&
	    EXPECTED(Z_TYPE_P(function_name) == IS_OBJECT) &&
		Z_OBJ_HANDLER_P(function_name, get_closure) &&
		Z_OBJ_HANDLER_P(function_name, get_closure)(function_name, &called_scope, &fbc, &object) == SUCCESS) {
		if (fbc->common.fn_flags & ZEND_ACC_CLOSURE) {
			/* Delay closure destruction until its invocation */
			ZEND_ASSERT(GC_TYPE((zend_object*)fbc->common.prototype) == IS_OBJECT);
			GC_REFCOUNT((zend_object*)fbc->common.prototype)++;
			call_info |= ZEND_CALL_CLOSURE;
		} else if (object) {
			call_info |= ZEND_CALL_RELEASE_THIS;
			GC_REFCOUNT(object)++; /* For $this pointer */
		}

	} else if (EXPECTED(Z_TYPE_P(function_name) == IS_ARRAY) &&
			zend_hash_num_elements(Z_ARRVAL_P(function_name)) == 2) {
		zval *obj;
		zval *method;
		obj = zend_hash_index_find(Z_ARRVAL_P(function_name), 0);
		method = zend_hash_index_find(Z_ARRVAL_P(function_name), 1);

		if (!obj || !method) {
			zend_throw_error(NULL, "Array callback has to contain indices 0 and 1");

			HANDLE_EXCEPTION();
		}

		ZVAL_DEREF(obj);
		if (Z_TYPE_P(obj) != IS_STRING && Z_TYPE_P(obj) != IS_OBJECT) {
			zend_throw_error(NULL, "First array member is not a valid class name or object");

			HANDLE_EXCEPTION();
		}

		ZVAL_DEREF(method);
		if (Z_TYPE_P(method) != IS_STRING) {
			zend_throw_error(NULL, "Second array member is not a valid method");

			HANDLE_EXCEPTION();
		}

		if (Z_TYPE_P(obj) == IS_STRING) {
			object = NULL;
			called_scope = zend_fetch_class_by_name(Z_STR_P(obj), NULL, ZEND_FETCH_CLASS_DEFAULT | ZEND_FETCH_CLASS_EXCEPTION);
			if (UNEXPECTED(called_scope == NULL)) {
				ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
			}

			if (called_scope->get_static_method) {
				fbc = called_scope->get_static_method(called_scope, Z_STR_P(method));
			} else {
				fbc = zend_std_get_static_method(called_scope, Z_STR_P(method), NULL);
			}
			if (UNEXPECTED(fbc == NULL)) {
				if (EXPECTED(!EG(exception))) {
					zend_throw_error(NULL, "Call to undefined method %s::%s()", ZSTR_VAL(called_scope->name), Z_STRVAL_P(method));
				}

				HANDLE_EXCEPTION();
			}
			if (!(fbc->common.fn_flags & ZEND_ACC_STATIC)) {
				if (fbc->common.fn_flags & ZEND_ACC_ALLOW_STATIC) {
					zend_error(E_DEPRECATED,
						"Non-static method %s::%s() should not be called statically",
						ZSTR_VAL(fbc->common.scope->name), ZSTR_VAL(fbc->common.function_name));
					if (UNEXPECTED(EG(exception) != NULL)) {
						HANDLE_EXCEPTION();
					}
				} else {
					zend_throw_error(
						zend_ce_error,
						"Non-static method %s::%s() cannot be called statically",
						ZSTR_VAL(fbc->common.scope->name), ZSTR_VAL(fbc->common.function_name));

					HANDLE_EXCEPTION();
				}
			}
		} else {
			called_scope = Z_OBJCE_P(obj);
			object = Z_OBJ_P(obj);

			fbc = Z_OBJ_HT_P(obj)->get_method(&object, Z_STR_P(method), NULL);
			if (UNEXPECTED(fbc == NULL)) {
				if (EXPECTED(!EG(exception))) {
					zend_throw_error(NULL, "Call to undefined method %s::%s()", ZSTR_VAL(object->ce->name), Z_STRVAL_P(method));
				}

				HANDLE_EXCEPTION();
			}

			if ((fbc->common.fn_flags & ZEND_ACC_STATIC) != 0) {
				object = NULL;
			} else {
				call_info |= ZEND_CALL_RELEASE_THIS;
				GC_REFCOUNT(object)++; /* For $this pointer */
			}
		}

	} else if ((IS_CONST & (IS_VAR|IS_CV)) && Z_TYPE_P(function_name) == IS_REFERENCE) {
		function_name = Z_REFVAL_P(function_name);
		goto try_function_name;
	} else {
		if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(function_name) == IS_UNDEF)) {
			GET_OP2_UNDEF_CV(function_name, BP_VAR_R);
		}
		if (UNEXPECTED(EG(exception) != NULL)) {
			HANDLE_EXCEPTION();
		}
		zend_throw_error(NULL, "Function name must be a string");

		HANDLE_EXCEPTION();
	}
	call = zend_vm_stack_push_call_frame(call_info,
		fbc, opline->extended_value, called_scope, object);
	call->prev_execute_data = EX(call);
	EX(call) = call;

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_INIT_NS_FCALL_BY_NAME_SPEC_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *func_name;
	zval *func;
	zend_function *fbc;
	zend_execute_data *call;

	func_name = EX_CONSTANT(opline->op2) + 1;
	if (EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2))))) {
		fbc = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)));
	} else if ((func = zend_hash_find(EG(function_table), Z_STR_P(func_name))) == NULL) {
		func_name++;
		if (UNEXPECTED((func = zend_hash_find(EG(function_table), Z_STR_P(func_name))) == NULL)) {
			SAVE_OPLINE();
			zend_throw_error(NULL, "Call to undefined function %s()", Z_STRVAL_P(EX_CONSTANT(opline->op2)));
			HANDLE_EXCEPTION();
		} else {
			fbc = Z_FUNC_P(func);
			CACHE_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)), fbc);
		}
	} else {
		fbc = Z_FUNC_P(func);
		CACHE_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)), fbc);
	}

	call = zend_vm_stack_push_call_frame(ZEND_CALL_NESTED_FUNCTION,
		fbc, opline->extended_value, NULL, NULL);
	call->prev_execute_data = EX(call);
	EX(call) = call;

	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_INIT_FCALL_SPEC_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *fname = EX_CONSTANT(opline->op2);
	zval *func;
	zend_function *fbc;
	zend_execute_data *call;

	if (EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(fname)))) {
		fbc = CACHED_PTR(Z_CACHE_SLOT_P(fname));
	} else if (UNEXPECTED((func = zend_hash_find(EG(function_table), Z_STR_P(fname))) == NULL)) {
	    SAVE_OPLINE();
		zend_throw_error(NULL, "Call to undefined function %s()", Z_STRVAL_P(fname));
		HANDLE_EXCEPTION();
	} else {
		fbc = Z_FUNC_P(func);
		CACHE_PTR(Z_CACHE_SLOT_P(fname), fbc);
	}

	call = zend_vm_stack_push_call_frame_ex(
		opline->op1.num, ZEND_CALL_NESTED_FUNCTION,
		fbc, opline->extended_value, NULL, NULL);
	call->prev_execute_data = EX(call);
	EX(call) = call;

	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_RECV_INIT_SPEC_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	uint32_t arg_num;
	zval *param;

	ZEND_VM_REPEATABLE_OPCODE

	arg_num = opline->op1.num;
	param = _get_zval_ptr_cv_undef_BP_VAR_W(execute_data, opline->result.var);
	if (arg_num > EX_NUM_ARGS()) {
		ZVAL_COPY_VALUE(param, EX_CONSTANT(opline->op2));
		if (Z_OPT_CONSTANT_P(param)) {
			SAVE_OPLINE();
			if (UNEXPECTED(zval_update_constant_ex(param, 0, NULL) != SUCCESS)) {
				ZVAL_UNDEF(param);
				HANDLE_EXCEPTION();
			}
		} else {
			/* IS_CONST can't be IS_OBJECT, IS_RESOURCE or IS_REFERENCE */
			if (UNEXPECTED(Z_OPT_COPYABLE_P(param))) {
				zval_copy_ctor_func(param);
			}
		}
	}

	if (UNEXPECTED((EX(func)->op_array.fn_flags & ZEND_ACC_HAS_TYPE_HINTS) != 0)) {
		zval *default_value = EX_CONSTANT(opline->op2);

		SAVE_OPLINE();
		if (UNEXPECTED(!zend_verify_arg_type(EX(func), arg_num, param, default_value, CACHE_ADDR(Z_CACHE_SLOT_P(default_value))))) {
			HANDLE_EXCEPTION();
		}
	}

	ZEND_VM_REPEAT_OPCODE(ZEND_RECV_INIT);
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ADD_INTERFACE_SPEC_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_class_entry *ce = Z_CE_P(EX_VAR(opline->op1.var));
	zend_class_entry *iface;

	SAVE_OPLINE();
	if (EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2))))) {
		iface = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)));
	} else {
		iface = zend_fetch_class_by_name(Z_STR_P(EX_CONSTANT(opline->op2)), EX_CONSTANT(opline->op2) + 1, ZEND_FETCH_CLASS_INTERFACE);
		if (UNEXPECTED(iface == NULL)) {
			ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
		}
		CACHE_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)), iface);
	}

	if (UNEXPECTED((iface->ce_flags & ZEND_ACC_INTERFACE) == 0)) {
		zend_error_noreturn(E_ERROR, "%s cannot implement %s - it is not an interface", ZSTR_VAL(ce->name), ZSTR_VAL(iface->name));
	}
	zend_do_implement_interface(ce, iface);

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_CLASS_SPEC_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	SAVE_OPLINE();
	if (IS_UNUSED == IS_UNUSED) {
		Z_CE_P(EX_VAR(opline->result.var)) = zend_fetch_class(NULL, opline->extended_value);
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	} else {

		zval *class_name = NULL;

try_class_name:
		if (IS_UNUSED == IS_CONST) {
			if (EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(class_name)))) {
				Z_CE_P(EX_VAR(opline->result.var)) = CACHED_PTR(Z_CACHE_SLOT_P(class_name));
			} else {
				Z_CE_P(EX_VAR(opline->result.var)) = zend_fetch_class_by_name(Z_STR_P(class_name), EX_CONSTANT(opline->op2) + 1, opline->extended_value);
				CACHE_PTR(Z_CACHE_SLOT_P(class_name), Z_CE_P(EX_VAR(opline->result.var)));
			}
		} else if (Z_TYPE_P(class_name) == IS_OBJECT) {
			Z_CE_P(EX_VAR(opline->result.var)) = Z_OBJCE_P(class_name);
		} else if (Z_TYPE_P(class_name) == IS_STRING) {
			Z_CE_P(EX_VAR(opline->result.var)) = zend_fetch_class(Z_STR_P(class_name), opline->extended_value);
		} else if ((IS_UNUSED & (IS_VAR|IS_CV)) && Z_TYPE_P(class_name) == IS_REFERENCE) {
			class_name = Z_REFVAL_P(class_name);
			goto try_class_name;
		} else {
			if (IS_UNUSED == IS_CV && UNEXPECTED(Z_TYPE_P(class_name) == IS_UNDEF)) {
				GET_OP2_UNDEF_CV(class_name, BP_VAR_R);
			}
			if (UNEXPECTED(EG(exception) != NULL)) {
				HANDLE_EXCEPTION();
			}
			zend_throw_error(NULL, "Class name must be a valid object or a string");
		}

		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_CLASS_SPEC_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	SAVE_OPLINE();
	if (IS_CV == IS_UNUSED) {
		Z_CE_P(EX_VAR(opline->result.var)) = zend_fetch_class(NULL, opline->extended_value);
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	} else {

		zval *class_name = _get_zval_ptr_cv_undef(execute_data, opline->op2.var);

try_class_name:
		if (IS_CV == IS_CONST) {
			if (EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(class_name)))) {
				Z_CE_P(EX_VAR(opline->result.var)) = CACHED_PTR(Z_CACHE_SLOT_P(class_name));
			} else {
				Z_CE_P(EX_VAR(opline->result.var)) = zend_fetch_class_by_name(Z_STR_P(class_name), EX_CONSTANT(opline->op2) + 1, opline->extended_value);
				CACHE_PTR(Z_CACHE_SLOT_P(class_name), Z_CE_P(EX_VAR(opline->result.var)));
			}
		} else if (Z_TYPE_P(class_name) == IS_OBJECT) {
			Z_CE_P(EX_VAR(opline->result.var)) = Z_OBJCE_P(class_name);
		} else if (Z_TYPE_P(class_name) == IS_STRING) {
			Z_CE_P(EX_VAR(opline->result.var)) = zend_fetch_class(Z_STR_P(class_name), opline->extended_value);
		} else if ((IS_CV & (IS_VAR|IS_CV)) && Z_TYPE_P(class_name) == IS_REFERENCE) {
			class_name = Z_REFVAL_P(class_name);
			goto try_class_name;
		} else {
			if (IS_CV == IS_CV && UNEXPECTED(Z_TYPE_P(class_name) == IS_UNDEF)) {
				GET_OP2_UNDEF_CV(class_name, BP_VAR_R);
			}
			if (UNEXPECTED(EG(exception) != NULL)) {
				HANDLE_EXCEPTION();
			}
			zend_throw_error(NULL, "Class name must be a valid object or a string");
		}

		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_INIT_DYNAMIC_CALL_SPEC_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_function *fbc;
	zval *function_name, *func;
	zend_string *lcname;

	zend_class_entry *called_scope;
	zend_object *object;
	zend_execute_data *call;
	uint32_t call_info = ZEND_CALL_NESTED_FUNCTION;

	SAVE_OPLINE();
	function_name = _get_zval_ptr_cv_undef(execute_data, opline->op2.var);

try_function_name:
	if (IS_CV != IS_CONST && EXPECTED(Z_TYPE_P(function_name) == IS_STRING)) {
		const char *colon;

		if ((colon = zend_memrchr(Z_STRVAL_P(function_name), ':', Z_STRLEN_P(function_name))) != NULL &&
			colon > Z_STRVAL_P(function_name) &&
			*(colon-1) == ':'
		) {
			zend_string *mname;
			size_t cname_length = colon - Z_STRVAL_P(function_name) - 1;
			size_t mname_length = Z_STRLEN_P(function_name) - cname_length - (sizeof("::") - 1);

			lcname = zend_string_init(Z_STRVAL_P(function_name), cname_length, 0);

			object = NULL;
			called_scope = zend_fetch_class_by_name(lcname, NULL, ZEND_FETCH_CLASS_DEFAULT | ZEND_FETCH_CLASS_EXCEPTION);
			if (UNEXPECTED(called_scope == NULL)) {
				zend_string_release(lcname);
				ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
			}

			mname = zend_string_init(Z_STRVAL_P(function_name) + (cname_length + sizeof("::") - 1), mname_length, 0);

			if (called_scope->get_static_method) {
				fbc = called_scope->get_static_method(called_scope, mname);
			} else {
				fbc = zend_std_get_static_method(called_scope, mname, NULL);
			}
			if (UNEXPECTED(fbc == NULL)) {
				if (EXPECTED(!EG(exception))) {
					zend_throw_error(NULL, "Call to undefined method %s::%s()", ZSTR_VAL(called_scope->name), ZSTR_VAL(mname));
				}
				zend_string_release(lcname);
				zend_string_release(mname);

				HANDLE_EXCEPTION();
			}

			zend_string_release(lcname);
			zend_string_release(mname);

			if (!(fbc->common.fn_flags & ZEND_ACC_STATIC)) {
				if (fbc->common.fn_flags & ZEND_ACC_ALLOW_STATIC) {
					zend_error(E_DEPRECATED,
						"Non-static method %s::%s() should not be called statically",
						ZSTR_VAL(fbc->common.scope->name), ZSTR_VAL(fbc->common.function_name));
					if (UNEXPECTED(EG(exception) != NULL)) {
						HANDLE_EXCEPTION();
					}
				} else {
					zend_throw_error(
						zend_ce_error,
						"Non-static method %s::%s() cannot be called statically",
						ZSTR_VAL(fbc->common.scope->name), ZSTR_VAL(fbc->common.function_name));

					HANDLE_EXCEPTION();
				}
			}
		} else {
			if (Z_STRVAL_P(function_name)[0] == '\\') {
				lcname = zend_string_alloc(Z_STRLEN_P(function_name) - 1, 0);
				zend_str_tolower_copy(ZSTR_VAL(lcname), Z_STRVAL_P(function_name) + 1, Z_STRLEN_P(function_name) - 1);
			} else {
				lcname = zend_string_tolower(Z_STR_P(function_name));
			}
			if (UNEXPECTED((func = zend_hash_find(EG(function_table), lcname)) == NULL)) {
				zend_throw_error(NULL, "Call to undefined function %s()", Z_STRVAL_P(function_name));
				zend_string_release(lcname);

				HANDLE_EXCEPTION();
			}
			zend_string_release(lcname);

			fbc = Z_FUNC_P(func);
			called_scope = NULL;
			object = NULL;
		}

	} else if (IS_CV != IS_CONST &&
	    EXPECTED(Z_TYPE_P(function_name) == IS_OBJECT) &&
		Z_OBJ_HANDLER_P(function_name, get_closure) &&
		Z_OBJ_HANDLER_P(function_name, get_closure)(function_name, &called_scope, &fbc, &object) == SUCCESS) {
		if (fbc->common.fn_flags & ZEND_ACC_CLOSURE) {
			/* Delay closure destruction until its invocation */
			ZEND_ASSERT(GC_TYPE((zend_object*)fbc->common.prototype) == IS_OBJECT);
			GC_REFCOUNT((zend_object*)fbc->common.prototype)++;
			call_info |= ZEND_CALL_CLOSURE;
		} else if (object) {
			call_info |= ZEND_CALL_RELEASE_THIS;
			GC_REFCOUNT(object)++; /* For $this pointer */
		}

	} else if (EXPECTED(Z_TYPE_P(function_name) == IS_ARRAY) &&
			zend_hash_num_elements(Z_ARRVAL_P(function_name)) == 2) {
		zval *obj;
		zval *method;
		obj = zend_hash_index_find(Z_ARRVAL_P(function_name), 0);
		method = zend_hash_index_find(Z_ARRVAL_P(function_name), 1);

		if (!obj || !method) {
			zend_throw_error(NULL, "Array callback has to contain indices 0 and 1");

			HANDLE_EXCEPTION();
		}

		ZVAL_DEREF(obj);
		if (Z_TYPE_P(obj) != IS_STRING && Z_TYPE_P(obj) != IS_OBJECT) {
			zend_throw_error(NULL, "First array member is not a valid class name or object");

			HANDLE_EXCEPTION();
		}

		ZVAL_DEREF(method);
		if (Z_TYPE_P(method) != IS_STRING) {
			zend_throw_error(NULL, "Second array member is not a valid method");

			HANDLE_EXCEPTION();
		}

		if (Z_TYPE_P(obj) == IS_STRING) {
			object = NULL;
			called_scope = zend_fetch_class_by_name(Z_STR_P(obj), NULL, ZEND_FETCH_CLASS_DEFAULT | ZEND_FETCH_CLASS_EXCEPTION);
			if (UNEXPECTED(called_scope == NULL)) {
				ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
			}

			if (called_scope->get_static_method) {
				fbc = called_scope->get_static_method(called_scope, Z_STR_P(method));
			} else {
				fbc = zend_std_get_static_method(called_scope, Z_STR_P(method), NULL);
			}
			if (UNEXPECTED(fbc == NULL)) {
				if (EXPECTED(!EG(exception))) {
					zend_throw_error(NULL, "Call to undefined method %s::%s()", ZSTR_VAL(called_scope->name), Z_STRVAL_P(method));
				}

				HANDLE_EXCEPTION();
			}
			if (!(fbc->common.fn_flags & ZEND_ACC_STATIC)) {
				if (fbc->common.fn_flags & ZEND_ACC_ALLOW_STATIC) {
					zend_error(E_DEPRECATED,
						"Non-static method %s::%s() should not be called statically",
						ZSTR_VAL(fbc->common.scope->name), ZSTR_VAL(fbc->common.function_name));
					if (UNEXPECTED(EG(exception) != NULL)) {
						HANDLE_EXCEPTION();
					}
				} else {
					zend_throw_error(
						zend_ce_error,
						"Non-static method %s::%s() cannot be called statically",
						ZSTR_VAL(fbc->common.scope->name), ZSTR_VAL(fbc->common.function_name));

					HANDLE_EXCEPTION();
				}
			}
		} else {
			called_scope = Z_OBJCE_P(obj);
			object = Z_OBJ_P(obj);

			fbc = Z_OBJ_HT_P(obj)->get_method(&object, Z_STR_P(method), NULL);
			if (UNEXPECTED(fbc == NULL)) {
				if (EXPECTED(!EG(exception))) {
					zend_throw_error(NULL, "Call to undefined method %s::%s()", ZSTR_VAL(object->ce->name), Z_STRVAL_P(method));
				}

				HANDLE_EXCEPTION();
			}

			if ((fbc->common.fn_flags & ZEND_ACC_STATIC) != 0) {
				object = NULL;
			} else {
				call_info |= ZEND_CALL_RELEASE_THIS;
				GC_REFCOUNT(object)++; /* For $this pointer */
			}
		}

	} else if ((IS_CV & (IS_VAR|IS_CV)) && Z_TYPE_P(function_name) == IS_REFERENCE) {
		function_name = Z_REFVAL_P(function_name);
		goto try_function_name;
	} else {
		if (IS_CV == IS_CV && UNEXPECTED(Z_TYPE_P(function_name) == IS_UNDEF)) {
			GET_OP2_UNDEF_CV(function_name, BP_VAR_R);
		}
		if (UNEXPECTED(EG(exception) != NULL)) {
			HANDLE_EXCEPTION();
		}
		zend_throw_error(NULL, "Function name must be a string");

		HANDLE_EXCEPTION();
	}
	call = zend_vm_stack_push_call_frame(call_info,
		fbc, opline->extended_value, called_scope, object);
	call->prev_execute_data = EX(call);
	EX(call) = call;

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_CLASS_SPEC_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	SAVE_OPLINE();
	if ((IS_TMP_VAR|IS_VAR) == IS_UNUSED) {
		Z_CE_P(EX_VAR(opline->result.var)) = zend_fetch_class(NULL, opline->extended_value);
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	} else {
		zend_free_op free_op2;
		zval *class_name = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);

try_class_name:
		if ((IS_TMP_VAR|IS_VAR) == IS_CONST) {
			if (EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(class_name)))) {
				Z_CE_P(EX_VAR(opline->result.var)) = CACHED_PTR(Z_CACHE_SLOT_P(class_name));
			} else {
				Z_CE_P(EX_VAR(opline->result.var)) = zend_fetch_class_by_name(Z_STR_P(class_name), EX_CONSTANT(opline->op2) + 1, opline->extended_value);
				CACHE_PTR(Z_CACHE_SLOT_P(class_name), Z_CE_P(EX_VAR(opline->result.var)));
			}
		} else if (Z_TYPE_P(class_name) == IS_OBJECT) {
			Z_CE_P(EX_VAR(opline->result.var)) = Z_OBJCE_P(class_name);
		} else if (Z_TYPE_P(class_name) == IS_STRING) {
			Z_CE_P(EX_VAR(opline->result.var)) = zend_fetch_class(Z_STR_P(class_name), opline->extended_value);
		} else if (((IS_TMP_VAR|IS_VAR) & (IS_VAR|IS_CV)) && Z_TYPE_P(class_name) == IS_REFERENCE) {
			class_name = Z_REFVAL_P(class_name);
			goto try_class_name;
		} else {
			if ((IS_TMP_VAR|IS_VAR) == IS_CV && UNEXPECTED(Z_TYPE_P(class_name) == IS_UNDEF)) {
				GET_OP2_UNDEF_CV(class_name, BP_VAR_R);
			}
			if (UNEXPECTED(EG(exception) != NULL)) {
				HANDLE_EXCEPTION();
			}
			zend_throw_error(NULL, "Class name must be a valid object or a string");
		}

		zval_ptr_dtor_nogc(free_op2);
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_INIT_DYNAMIC_CALL_SPEC_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_function *fbc;
	zval *function_name, *func;
	zend_string *lcname;
	zend_free_op free_op2;
	zend_class_entry *called_scope;
	zend_object *object;
	zend_execute_data *call;
	uint32_t call_info = ZEND_CALL_NESTED_FUNCTION;

	SAVE_OPLINE();
	function_name = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);

try_function_name:
	if ((IS_TMP_VAR|IS_VAR) != IS_CONST && EXPECTED(Z_TYPE_P(function_name) == IS_STRING)) {
		const char *colon;

		if ((colon = zend_memrchr(Z_STRVAL_P(function_name), ':', Z_STRLEN_P(function_name))) != NULL &&
			colon > Z_STRVAL_P(function_name) &&
			*(colon-1) == ':'
		) {
			zend_string *mname;
			size_t cname_length = colon - Z_STRVAL_P(function_name) - 1;
			size_t mname_length = Z_STRLEN_P(function_name) - cname_length - (sizeof("::") - 1);

			lcname = zend_string_init(Z_STRVAL_P(function_name), cname_length, 0);

			object = NULL;
			called_scope = zend_fetch_class_by_name(lcname, NULL, ZEND_FETCH_CLASS_DEFAULT | ZEND_FETCH_CLASS_EXCEPTION);
			if (UNEXPECTED(called_scope == NULL)) {
				zend_string_release(lcname);
				ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
			}

			mname = zend_string_init(Z_STRVAL_P(function_name) + (cname_length + sizeof("::") - 1), mname_length, 0);

			if (called_scope->get_static_method) {
				fbc = called_scope->get_static_method(called_scope, mname);
			} else {
				fbc = zend_std_get_static_method(called_scope, mname, NULL);
			}
			if (UNEXPECTED(fbc == NULL)) {
				if (EXPECTED(!EG(exception))) {
					zend_throw_error(NULL, "Call to undefined method %s::%s()", ZSTR_VAL(called_scope->name), ZSTR_VAL(mname));
				}
				zend_string_release(lcname);
				zend_string_release(mname);
				zval_ptr_dtor_nogc(free_op2);
				HANDLE_EXCEPTION();
			}

			zend_string_release(lcname);
			zend_string_release(mname);

			if (!(fbc->common.fn_flags & ZEND_ACC_STATIC)) {
				if (fbc->common.fn_flags & ZEND_ACC_ALLOW_STATIC) {
					zend_error(E_DEPRECATED,
						"Non-static method %s::%s() should not be called statically",
						ZSTR_VAL(fbc->common.scope->name), ZSTR_VAL(fbc->common.function_name));
					if (UNEXPECTED(EG(exception) != NULL)) {
						HANDLE_EXCEPTION();
					}
				} else {
					zend_throw_error(
						zend_ce_error,
						"Non-static method %s::%s() cannot be called statically",
						ZSTR_VAL(fbc->common.scope->name), ZSTR_VAL(fbc->common.function_name));
					zval_ptr_dtor_nogc(free_op2);
					HANDLE_EXCEPTION();
				}
			}
		} else {
			if (Z_STRVAL_P(function_name)[0] == '\\') {
				lcname = zend_string_alloc(Z_STRLEN_P(function_name) - 1, 0);
				zend_str_tolower_copy(ZSTR_VAL(lcname), Z_STRVAL_P(function_name) + 1, Z_STRLEN_P(function_name) - 1);
			} else {
				lcname = zend_string_tolower(Z_STR_P(function_name));
			}
			if (UNEXPECTED((func = zend_hash_find(EG(function_table), lcname)) == NULL)) {
				zend_throw_error(NULL, "Call to undefined function %s()", Z_STRVAL_P(function_name));
				zend_string_release(lcname);
				zval_ptr_dtor_nogc(free_op2);
				HANDLE_EXCEPTION();
			}
			zend_string_release(lcname);

			fbc = Z_FUNC_P(func);
			called_scope = NULL;
			object = NULL;
		}
		zval_ptr_dtor_nogc(free_op2);
	} else if ((IS_TMP_VAR|IS_VAR) != IS_CONST &&
	    EXPECTED(Z_TYPE_P(function_name) == IS_OBJECT) &&
		Z_OBJ_HANDLER_P(function_name, get_closure) &&
		Z_OBJ_HANDLER_P(function_name, get_closure)(function_name, &called_scope, &fbc, &object) == SUCCESS) {
		if (fbc->common.fn_flags & ZEND_ACC_CLOSURE) {
			/* Delay closure destruction until its invocation */
			ZEND_ASSERT(GC_TYPE((zend_object*)fbc->common.prototype) == IS_OBJECT);
			GC_REFCOUNT((zend_object*)fbc->common.prototype)++;
			call_info |= ZEND_CALL_CLOSURE;
		} else if (object) {
			call_info |= ZEND_CALL_RELEASE_THIS;
			GC_REFCOUNT(object)++; /* For $this pointer */
		}
		zval_ptr_dtor_nogc(free_op2);
	} else if (EXPECTED(Z_TYPE_P(function_name) == IS_ARRAY) &&
			zend_hash_num_elements(Z_ARRVAL_P(function_name)) == 2) {
		zval *obj;
		zval *method;
		obj = zend_hash_index_find(Z_ARRVAL_P(function_name), 0);
		method = zend_hash_index_find(Z_ARRVAL_P(function_name), 1);

		if (!obj || !method) {
			zend_throw_error(NULL, "Array callback has to contain indices 0 and 1");
			zval_ptr_dtor_nogc(free_op2);
			HANDLE_EXCEPTION();
		}

		ZVAL_DEREF(obj);
		if (Z_TYPE_P(obj) != IS_STRING && Z_TYPE_P(obj) != IS_OBJECT) {
			zend_throw_error(NULL, "First array member is not a valid class name or object");
			zval_ptr_dtor_nogc(free_op2);
			HANDLE_EXCEPTION();
		}

		ZVAL_DEREF(method);
		if (Z_TYPE_P(method) != IS_STRING) {
			zend_throw_error(NULL, "Second array member is not a valid method");
			zval_ptr_dtor_nogc(free_op2);
			HANDLE_EXCEPTION();
		}

		if (Z_TYPE_P(obj) == IS_STRING) {
			object = NULL;
			called_scope = zend_fetch_class_by_name(Z_STR_P(obj), NULL, ZEND_FETCH_CLASS_DEFAULT | ZEND_FETCH_CLASS_EXCEPTION);
			if (UNEXPECTED(called_scope == NULL)) {
				ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
			}

			if (called_scope->get_static_method) {
				fbc = called_scope->get_static_method(called_scope, Z_STR_P(method));
			} else {
				fbc = zend_std_get_static_method(called_scope, Z_STR_P(method), NULL);
			}
			if (UNEXPECTED(fbc == NULL)) {
				if (EXPECTED(!EG(exception))) {
					zend_throw_error(NULL, "Call to undefined method %s::%s()", ZSTR_VAL(called_scope->name), Z_STRVAL_P(method));
				}
				zval_ptr_dtor_nogc(free_op2);
				HANDLE_EXCEPTION();
			}
			if (!(fbc->common.fn_flags & ZEND_ACC_STATIC)) {
				if (fbc->common.fn_flags & ZEND_ACC_ALLOW_STATIC) {
					zend_error(E_DEPRECATED,
						"Non-static method %s::%s() should not be called statically",
						ZSTR_VAL(fbc->common.scope->name), ZSTR_VAL(fbc->common.function_name));
					if (UNEXPECTED(EG(exception) != NULL)) {
						HANDLE_EXCEPTION();
					}
				} else {
					zend_throw_error(
						zend_ce_error,
						"Non-static method %s::%s() cannot be called statically",
						ZSTR_VAL(fbc->common.scope->name), ZSTR_VAL(fbc->common.function_name));
					zval_ptr_dtor_nogc(free_op2);
					HANDLE_EXCEPTION();
				}
			}
		} else {
			called_scope = Z_OBJCE_P(obj);
			object = Z_OBJ_P(obj);

			fbc = Z_OBJ_HT_P(obj)->get_method(&object, Z_STR_P(method), NULL);
			if (UNEXPECTED(fbc == NULL)) {
				if (EXPECTED(!EG(exception))) {
					zend_throw_error(NULL, "Call to undefined method %s::%s()", ZSTR_VAL(object->ce->name), Z_STRVAL_P(method));
				}
				zval_ptr_dtor_nogc(free_op2);
				HANDLE_EXCEPTION();
			}

			if ((fbc->common.fn_flags & ZEND_ACC_STATIC) != 0) {
				object = NULL;
			} else {
				call_info |= ZEND_CALL_RELEASE_THIS;
				GC_REFCOUNT(object)++; /* For $this pointer */
			}
		}
		zval_ptr_dtor_nogc(free_op2);
	} else if (((IS_TMP_VAR|IS_VAR) & (IS_VAR|IS_CV)) && Z_TYPE_P(function_name) == IS_REFERENCE) {
		function_name = Z_REFVAL_P(function_name);
		goto try_function_name;
	} else {
		if ((IS_TMP_VAR|IS_VAR) == IS_CV && UNEXPECTED(Z_TYPE_P(function_name) == IS_UNDEF)) {
			GET_OP2_UNDEF_CV(function_name, BP_VAR_R);
		}
		if (UNEXPECTED(EG(exception) != NULL)) {
			HANDLE_EXCEPTION();
		}
		zend_throw_error(NULL, "Function name must be a string");
		zval_ptr_dtor_nogc(free_op2);
		HANDLE_EXCEPTION();
	}
	call = zend_vm_stack_push_call_frame(call_info,
		fbc, opline->extended_value, called_scope, object);
	call->prev_execute_data = EX(call);
	EX(call) = call;

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_BW_NOT_SPEC_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE


	SAVE_OPLINE();
	bitwise_not_function(EX_VAR(opline->result.var),
		EX_CONSTANT(opline->op1));

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_BOOL_NOT_SPEC_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *val;


	val = EX_CONSTANT(opline->op1);
	if (Z_TYPE_INFO_P(val) == IS_TRUE) {
		ZVAL_FALSE(EX_VAR(opline->result.var));
	} else if (EXPECTED(Z_TYPE_INFO_P(val) <= IS_TRUE)) {
		ZVAL_TRUE(EX_VAR(opline->result.var));
		if (UNEXPECTED(Z_TYPE_INFO_P(val) == IS_UNDEF)) {
			SAVE_OPLINE();
			GET_OP1_UNDEF_CV(val, BP_VAR_R);
			ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
		}
	} else {
		SAVE_OPLINE();
		ZVAL_BOOL(EX_VAR(opline->result.var), !i_zend_is_true(val));

		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ECHO_SPEC_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *z;

	SAVE_OPLINE();
	z = EX_CONSTANT(opline->op1);

	if (Z_TYPE_P(z) == IS_STRING) {
		zend_string *str = Z_STR_P(z);

		if (ZSTR_LEN(str) != 0) {
			zend_write(ZSTR_VAL(str), ZSTR_LEN(str));
		}
	} else {
		zend_string *str = _zval_get_string_func(z);

		if (ZSTR_LEN(str) != 0) {
			zend_write(ZSTR_VAL(str), ZSTR_LEN(str));
		} else if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(z) == IS_UNDEF)) {
			GET_OP1_UNDEF_CV(z, BP_VAR_R);
		}
		zend_string_release(str);
	}

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_JMPZ_SPEC_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *val;

	val = EX_CONSTANT(opline->op1);

	if (Z_TYPE_INFO_P(val) == IS_TRUE) {
		ZEND_VM_SET_NEXT_OPCODE(opline + 1);
		ZEND_VM_CONTINUE();
	} else if (EXPECTED(Z_TYPE_INFO_P(val) <= IS_TRUE)) {
		if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(val) == IS_UNDEF)) {
			SAVE_OPLINE();
			GET_OP1_UNDEF_CV(val, BP_VAR_R);
			ZEND_VM_JMP(OP_JMP_ADDR(opline, opline->op2));
		} else {
			ZEND_VM_SET_OPCODE(OP_JMP_ADDR(opline, opline->op2));
			ZEND_VM_CONTINUE();
		}
	}

	SAVE_OPLINE();
	if (i_zend_is_true(val)) {
		opline++;
	} else {
		opline = OP_JMP_ADDR(opline, opline->op2);
	}

	if (UNEXPECTED(EG(exception) != NULL)) {
		HANDLE_EXCEPTION();
	}
	ZEND_VM_JMP(opline);
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_JMPNZ_SPEC_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *val;

	val = EX_CONSTANT(opline->op1);

	if (Z_TYPE_INFO_P(val) == IS_TRUE) {
		ZEND_VM_SET_OPCODE(OP_JMP_ADDR(opline, opline->op2));
		ZEND_VM_CONTINUE();
	} else if (EXPECTED(Z_TYPE_INFO_P(val) <= IS_TRUE)) {
		if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(val) == IS_UNDEF)) {
			SAVE_OPLINE();
			GET_OP1_UNDEF_CV(val, BP_VAR_R);
			ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
		} else {
			ZEND_VM_NEXT_OPCODE();
		}
	}

	SAVE_OPLINE();
	if (i_zend_is_true(val)) {
		opline = OP_JMP_ADDR(opline, opline->op2);
	} else {
		opline++;
	}

	if (UNEXPECTED(EG(exception) != NULL)) {
		HANDLE_EXCEPTION();
	}
	ZEND_VM_JMP(opline);
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_JMPZNZ_SPEC_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *val;

	val = EX_CONSTANT(opline->op1);

	if (EXPECTED(Z_TYPE_INFO_P(val) == IS_TRUE)) {
		ZEND_VM_SET_RELATIVE_OPCODE(opline, opline->extended_value);
		ZEND_VM_CONTINUE();
	} else if (EXPECTED(Z_TYPE_INFO_P(val) <= IS_TRUE)) {
		if (IS_CONST == IS_CV) {
			if (UNEXPECTED(Z_TYPE_INFO_P(val) == IS_UNDEF)) {
				SAVE_OPLINE();
				GET_OP1_UNDEF_CV(val, BP_VAR_R);
			}
			ZEND_VM_JMP(OP_JMP_ADDR(opline, opline->op2));
		} else {
			ZEND_VM_SET_OPCODE(OP_JMP_ADDR(opline, opline->op2));
			ZEND_VM_CONTINUE();
		}
	}

	SAVE_OPLINE();
	if (i_zend_is_true(val)) {
		opline = ZEND_OFFSET_TO_OPLINE(opline, opline->extended_value);
	} else {
		opline = OP_JMP_ADDR(opline, opline->op2);
	}

	if (UNEXPECTED(EG(exception) != NULL)) {
		HANDLE_EXCEPTION();
	}
	ZEND_VM_JMP(opline);
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_JMPZ_EX_SPEC_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *val;
	int ret;

	val = EX_CONSTANT(opline->op1);

	if (Z_TYPE_INFO_P(val) == IS_TRUE) {
		ZVAL_TRUE(EX_VAR(opline->result.var));
		ZEND_VM_SET_NEXT_OPCODE(opline + 1);
		ZEND_VM_CONTINUE();
	} else if (EXPECTED(Z_TYPE_INFO_P(val) <= IS_TRUE)) {
		ZVAL_FALSE(EX_VAR(opline->result.var));
		if (IS_CONST == IS_CV) {
			if (UNEXPECTED(Z_TYPE_INFO_P(val) == IS_UNDEF)) {
				SAVE_OPLINE();
				GET_OP1_UNDEF_CV(val, BP_VAR_R);
			}
			ZEND_VM_JMP(OP_JMP_ADDR(opline, opline->op2));
		} else {
			ZEND_VM_SET_OPCODE(OP_JMP_ADDR(opline, opline->op2));
			ZEND_VM_CONTINUE();
		}
	}

	SAVE_OPLINE();
	ret = i_zend_is_true(val);

	if (ret) {
		ZVAL_TRUE(EX_VAR(opline->result.var));
		opline++;
	} else {
		ZVAL_FALSE(EX_VAR(opline->result.var));
		opline = OP_JMP_ADDR(opline, opline->op2);
	}
	if (UNEXPECTED(EG(exception) != NULL)) {
		HANDLE_EXCEPTION();
	}
	ZEND_VM_JMP(opline);
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_JMPNZ_EX_SPEC_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *val;
	int ret;

	val = EX_CONSTANT(opline->op1);

	if (Z_TYPE_INFO_P(val) == IS_TRUE) {
		ZVAL_TRUE(EX_VAR(opline->result.var));
		ZEND_VM_SET_OPCODE(OP_JMP_ADDR(opline, opline->op2));
		ZEND_VM_CONTINUE();
	} else if (EXPECTED(Z_TYPE_INFO_P(val) <= IS_TRUE)) {
		ZVAL_FALSE(EX_VAR(opline->result.var));
		if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(val) == IS_UNDEF)) {
			SAVE_OPLINE();
			GET_OP1_UNDEF_CV(val, BP_VAR_R);
			ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
		} else {
			ZEND_VM_NEXT_OPCODE();
		}
	}

	SAVE_OPLINE();
	ret = i_zend_is_true(val);

	if (ret) {
		ZVAL_TRUE(EX_VAR(opline->result.var));
		opline = OP_JMP_ADDR(opline, opline->op2);
	} else {
		ZVAL_FALSE(EX_VAR(opline->result.var));
		opline++;
	}
	if (UNEXPECTED(EG(exception) != NULL)) {
		HANDLE_EXCEPTION();
	}
	ZEND_VM_JMP(opline);
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_RETURN_SPEC_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *retval_ptr;
	zend_free_op free_op1;

	retval_ptr = EX_CONSTANT(opline->op1);
	if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(retval_ptr) == IS_UNDEF)) {
		SAVE_OPLINE();
		retval_ptr = GET_OP1_UNDEF_CV(retval_ptr, BP_VAR_R);
		if (EX(return_value)) {
			ZVAL_NULL(EX(return_value));
		}
	} else if (!EX(return_value)) {
		if (IS_CONST == IS_VAR || IS_CONST == IS_TMP_VAR ) {
			if (Z_REFCOUNTED_P(free_op1) && !Z_DELREF_P(free_op1)) {
				SAVE_OPLINE();
				zval_dtor_func_for_ptr(Z_COUNTED_P(free_op1));
			}
		}
	} else {
		if (IS_CONST == IS_CONST || IS_CONST == IS_TMP_VAR) {
			ZVAL_COPY_VALUE(EX(return_value), retval_ptr);
			if (IS_CONST == IS_CONST) {
				if (UNEXPECTED(Z_OPT_COPYABLE_P(EX(return_value)))) {
					zval_copy_ctor_func(EX(return_value));
				}
			}
		} else if (IS_CONST == IS_CV) {
			ZVAL_DEREF(retval_ptr);
			ZVAL_COPY(EX(return_value), retval_ptr);
		} else /* if (IS_CONST == IS_VAR) */ {
			if (UNEXPECTED(Z_ISREF_P(retval_ptr))) {
				zend_refcounted *ref = Z_COUNTED_P(retval_ptr);

				retval_ptr = Z_REFVAL_P(retval_ptr);
				ZVAL_COPY_VALUE(EX(return_value), retval_ptr);
				if (UNEXPECTED(--GC_REFCOUNT(ref) == 0)) {
					efree_size(ref, sizeof(zend_reference));
				} else if (Z_OPT_REFCOUNTED_P(retval_ptr)) {
					Z_ADDREF_P(retval_ptr);
				}
			} else {
				ZVAL_COPY_VALUE(EX(return_value), retval_ptr);
			}
		}
	}
	ZEND_VM_TAIL_CALL(zend_leave_helper_SPEC(ZEND_OPCODE_HANDLER_ARGS_PASSTHRU));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_RETURN_BY_REF_SPEC_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *retval_ptr;


	SAVE_OPLINE();

	do {
		if (IS_CONST == IS_CONST || IS_CONST == IS_TMP_VAR ||
		    (IS_CONST == IS_VAR && opline->extended_value == ZEND_RETURNS_VALUE)) {
			/* Not supposed to happen, but we'll allow it */
			zend_error(E_NOTICE, "Only variable references should be returned by reference");

			retval_ptr = EX_CONSTANT(opline->op1);
			if (!EX(return_value)) {
				if (IS_CONST == IS_TMP_VAR) {

				}
			} else {
				ZVAL_COPY_VALUE(EX(return_value), retval_ptr);
				Z_VAR_FLAGS_P(EX(return_value)) = IS_VAR_RET_REF;
				if (IS_CONST != IS_TMP_VAR) {
					zval_opt_copy_ctor_no_imm(EX(return_value));
				}
			}
			break;
		}

		retval_ptr = NULL;

		if (IS_CONST == IS_VAR && UNEXPECTED(retval_ptr == NULL)) {
			zend_throw_error(NULL, "Cannot return string offsets by reference");
			HANDLE_EXCEPTION();
		}

		if (IS_CONST == IS_VAR) {
			if (retval_ptr == &EG(uninitialized_zval) ||
			    (opline->extended_value == ZEND_RETURNS_FUNCTION &&
			     !(Z_VAR_FLAGS_P(retval_ptr) & IS_VAR_RET_REF))) {
				zend_error(E_NOTICE, "Only variable references should be returned by reference");
				if (EX(return_value)) {
					ZVAL_NEW_REF(EX(return_value), retval_ptr);
					Z_VAR_FLAGS_P(EX(return_value)) = IS_VAR_RET_REF;
					if (Z_REFCOUNTED_P(retval_ptr)) Z_ADDREF_P(retval_ptr);
				}
				break;
			}
		}

		if (EX(return_value)) {
			ZVAL_MAKE_REF(retval_ptr);
			Z_ADDREF_P(retval_ptr);
			ZVAL_REF(EX(return_value), Z_REF_P(retval_ptr));
			Z_VAR_FLAGS_P(EX(return_value)) = IS_VAR_RET_REF;
		}
	} while (0);

	ZEND_VM_TAIL_CALL(zend_leave_helper_SPEC(ZEND_OPCODE_HANDLER_ARGS_PASSTHRU));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_GENERATOR_RETURN_SPEC_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *retval;


	zend_generator *generator = zend_get_running_generator(execute_data);

	SAVE_OPLINE();
	retval = EX_CONSTANT(opline->op1);

	/* Copy return value into generator->retval */
	if (IS_CONST == IS_CONST || IS_CONST == IS_TMP_VAR) {
		ZVAL_COPY_VALUE(&generator->retval, retval);
		if (IS_CONST == IS_CONST) {
			if (UNEXPECTED(Z_OPT_COPYABLE(generator->retval))) {
				zval_copy_ctor_func(&generator->retval);
			}
		}
	} else if (IS_CONST == IS_CV) {
		ZVAL_DEREF(retval);
		ZVAL_COPY(&generator->retval, retval);
	} else /* if (IS_CONST == IS_VAR) */ {
		if (UNEXPECTED(Z_ISREF_P(retval))) {
			zend_refcounted *ref = Z_COUNTED_P(retval);

			retval = Z_REFVAL_P(retval);
			ZVAL_COPY_VALUE(&generator->retval, retval);
			if (UNEXPECTED(--GC_REFCOUNT(ref) == 0)) {
				efree_size(ref, sizeof(zend_reference));
			} else if (Z_OPT_REFCOUNTED_P(retval)) {
				Z_ADDREF_P(retval);
			}
		} else {
			ZVAL_COPY_VALUE(&generator->retval, retval);
		}
	}

	/* Close the generator to free up resources */
	zend_generator_close(generator, 1);

	/* Pass execution back to handling code */
	ZEND_VM_RETURN();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_THROW_SPEC_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *value;


	SAVE_OPLINE();
	value = EX_CONSTANT(opline->op1);

	do {
		if (IS_CONST == IS_CONST || UNEXPECTED(Z_TYPE_P(value) != IS_OBJECT)) {
			if ((IS_CONST & (IS_VAR|IS_CV)) && Z_ISREF_P(value)) {
				value = Z_REFVAL_P(value);
				if (EXPECTED(Z_TYPE_P(value) == IS_OBJECT)) {
					break;
				}
			}
			if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(value) == IS_UNDEF)) {
				GET_OP1_UNDEF_CV(value, BP_VAR_R);
			}
			if (UNEXPECTED(EG(exception) != NULL)) {
				HANDLE_EXCEPTION();
			}
			zend_throw_error(NULL, "Can only throw objects");

			HANDLE_EXCEPTION();
		}
	} while (0);

	zend_exception_save();
	if (IS_CONST != IS_TMP_VAR) {
		if (Z_REFCOUNTED_P(value)) Z_ADDREF_P(value);
	}

	zend_throw_exception_object(value);
	zend_exception_restore();

	HANDLE_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_SEND_VAL_SPEC_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *value, *arg;


	value = EX_CONSTANT(opline->op1);
	arg = ZEND_CALL_VAR(EX(call), opline->result.var);
	ZVAL_COPY_VALUE(arg, value);
	if (IS_CONST == IS_CONST) {
		if (UNEXPECTED(Z_OPT_COPYABLE_P(arg))) {
			zval_copy_ctor_func(arg);
		}
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_SEND_VAL_EX_SPEC_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *value, *arg;


	if (EXPECTED(opline->op2.num <= MAX_ARG_FLAG_NUM)) {
		if (QUICK_ARG_MUST_BE_SENT_BY_REF(EX(call)->func, opline->op2.num)) {
			goto send_val_by_ref;
		}
	} else if (ARG_MUST_BE_SENT_BY_REF(EX(call)->func, opline->op2.num)) {
send_val_by_ref:
		SAVE_OPLINE();
		zend_throw_error(NULL, "Cannot pass parameter %d by reference", opline->op2.num);

		arg = ZEND_CALL_VAR(EX(call), opline->result.var);
		ZVAL_UNDEF(arg);
		HANDLE_EXCEPTION();
	}
	value = EX_CONSTANT(opline->op1);
	arg = ZEND_CALL_VAR(EX(call), opline->result.var);
	ZVAL_COPY_VALUE(arg, value);
	if (IS_CONST == IS_CONST) {
		if (UNEXPECTED(Z_OPT_COPYABLE_P(arg))) {
			zval_copy_ctor_func(arg);
		}
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_BOOL_SPEC_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *val;


	val = EX_CONSTANT(opline->op1);
	if (Z_TYPE_INFO_P(val) == IS_TRUE) {
		ZVAL_TRUE(EX_VAR(opline->result.var));
	} else if (EXPECTED(Z_TYPE_INFO_P(val) <= IS_TRUE)) {
		ZVAL_FALSE(EX_VAR(opline->result.var));
		if (UNEXPECTED(Z_TYPE_INFO_P(val) == IS_UNDEF)) {
			SAVE_OPLINE();
			GET_OP1_UNDEF_CV(val, BP_VAR_R);
			ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
		}
	} else {
		SAVE_OPLINE();
		ZVAL_BOOL(EX_VAR(opline->result.var), i_zend_is_true(val));

		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_NEW_SPEC_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval object_zval;
	zend_function *constructor;
	zend_class_entry *ce;

	SAVE_OPLINE();
	if (IS_CONST == IS_CONST) {
		if (EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1))))) {
			ce = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)));
		} else {
			ce = zend_fetch_class_by_name(Z_STR_P(EX_CONSTANT(opline->op1)), EX_CONSTANT(opline->op1) + 1, ZEND_FETCH_CLASS_DEFAULT | ZEND_FETCH_CLASS_EXCEPTION);
			if (UNEXPECTED(ce == NULL)) {
				ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
			}
			CACHE_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)), ce);
		}
	} else {
		ce = Z_CE_P(EX_VAR(opline->op1.var));
	}
	if (UNEXPECTED(object_init_ex(&object_zval, ce) != SUCCESS)) {
		HANDLE_EXCEPTION();
	}
	constructor = Z_OBJ_HT(object_zval)->get_constructor(Z_OBJ(object_zval));

	if (constructor == NULL) {
		if (EXPECTED(RETURN_VALUE_USED(opline))) {
			ZVAL_COPY_VALUE(EX_VAR(opline->result.var), &object_zval);
		} else {
			OBJ_RELEASE(Z_OBJ(object_zval));
		}
		ZEND_VM_JMP(OP_JMP_ADDR(opline, opline->op2));
	} else {
		/* We are not handling overloaded classes right now */
		zend_execute_data *call = zend_vm_stack_push_call_frame(
				ZEND_CALL_FUNCTION | ZEND_CALL_RELEASE_THIS | ZEND_CALL_CTOR |
				(EXPECTED(RETURN_VALUE_USED(opline)) ? 0 : ZEND_CALL_CTOR_RESULT_UNUSED),
			constructor,
			opline->extended_value,
			ce,
			Z_OBJ(object_zval));
		call->prev_execute_data = EX(call);
		EX(call) = call;

		if (EXPECTED(RETURN_VALUE_USED(opline))) {
			ZVAL_COPY(EX_VAR(opline->result.var), &object_zval);
		}

		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_CLONE_SPEC_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *obj;
	zend_class_entry *ce;
	zend_function *clone;
	zend_object_clone_obj_t clone_call;

	SAVE_OPLINE();
	obj = EX_CONSTANT(opline->op1);

	if (IS_CONST == IS_UNUSED && UNEXPECTED(Z_OBJ_P(obj) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");
		HANDLE_EXCEPTION();
	}

	do {
		if (IS_CONST == IS_CONST ||
		    (IS_CONST != IS_UNUSED && UNEXPECTED(Z_TYPE_P(obj) != IS_OBJECT))) {
		    if ((IS_CONST & (IS_VAR|IS_CV)) && Z_ISREF_P(obj)) {
		    	obj = Z_REFVAL_P(obj);
		    	if (EXPECTED(Z_TYPE_P(obj) == IS_OBJECT)) {
		    		break;
				}
			}
			if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(obj) == IS_UNDEF)) {
				GET_OP1_UNDEF_CV(obj, BP_VAR_R);
			}
			if (UNEXPECTED(EG(exception) != NULL)) {
				HANDLE_EXCEPTION();
			}
			zend_throw_error(NULL, "__clone method called on non-object");

			HANDLE_EXCEPTION();
		}
	} while (0);

	ce = Z_OBJCE_P(obj);
	clone = ce ? ce->clone : NULL;
	clone_call =  Z_OBJ_HT_P(obj)->clone_obj;
	if (UNEXPECTED(clone_call == NULL)) {
		if (ce) {
			zend_throw_error(NULL, "Trying to clone an uncloneable object of class %s", ZSTR_VAL(ce->name));
		} else {
			zend_throw_error(NULL, "Trying to clone an uncloneable object");
		}

		HANDLE_EXCEPTION();
	}

	if (ce && clone) {
		if (clone->op_array.fn_flags & ZEND_ACC_PRIVATE) {
			/* Ensure that if we're calling a private function, we're allowed to do so.
			 */
			if (UNEXPECTED(ce != EG(scope))) {
				zend_throw_error(NULL, "Call to private %s::__clone() from context '%s'", ZSTR_VAL(ce->name), EG(scope) ? ZSTR_VAL(EG(scope)->name) : "");

				HANDLE_EXCEPTION();
			}
		} else if ((clone->common.fn_flags & ZEND_ACC_PROTECTED)) {
			/* Ensure that if we're calling a protected function, we're allowed to do so.
			 */
			if (UNEXPECTED(!zend_check_protected(zend_get_function_root_class(clone), EG(scope)))) {
				zend_throw_error(NULL, "Call to protected %s::__clone() from context '%s'", ZSTR_VAL(ce->name), EG(scope) ? ZSTR_VAL(EG(scope)->name) : "");

				HANDLE_EXCEPTION();
			}
		}
	}

	if (EXPECTED(EG(exception) == NULL)) {
		ZVAL_OBJ(EX_VAR(opline->result.var), clone_call(obj));
		if (UNEXPECTED(!RETURN_VALUE_USED(opline)) || UNEXPECTED(EG(exception) != NULL)) {
			OBJ_RELEASE(Z_OBJ_P(EX_VAR(opline->result.var)));
		}
	}

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_CAST_SPEC_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *expr;
	zval *result = EX_VAR(opline->result.var);

	SAVE_OPLINE();
	expr = EX_CONSTANT(opline->op1);

	switch (opline->extended_value) {
		case IS_NULL:
			/* This code is taken from convert_to_null. However, it does not seems very useful,
			 * because a conversion to null always results in the same value. This could only
			 * be relevant if a cast_object handler for IS_NULL has some kind of side-effect. */
#if 0
			if (IS_CONST == IS_VAR || IS_CONST == IS_CV) {
				ZVAL_DEREF(expr);
			}
			if (Z_TYPE_P(expr) == IS_OBJECT && Z_OBJ_HT_P(expr)->cast_object) {
				if (Z_OBJ_HT_P(expr)->cast_object(expr, result, IS_NULL) == SUCCESS) {
					break;
				}
			}
#endif

			ZVAL_NULL(result);
			break;
		case _IS_BOOL:
			ZVAL_BOOL(result, zend_is_true(expr));
			break;
		case IS_LONG:
			ZVAL_LONG(result, zval_get_long(expr));
			break;
		case IS_DOUBLE:
			ZVAL_DOUBLE(result, zval_get_double(expr));
			break;
		case IS_STRING:
			ZVAL_STR(result, zval_get_string(expr));
			break;
		default:
			if (IS_CONST & (IS_VAR|IS_CV)) {
				ZVAL_DEREF(expr);
			}
			/* If value is already of correct type, return it directly */
			if (Z_TYPE_P(expr) == opline->extended_value) {
				ZVAL_COPY_VALUE(result, expr);
				if (IS_CONST == IS_CONST) {
					if (UNEXPECTED(Z_OPT_COPYABLE_P(result))) {
						zval_copy_ctor_func(result);
					}
				} else if (IS_CONST != IS_TMP_VAR) {
					if (Z_OPT_REFCOUNTED_P(expr)) Z_ADDREF_P(expr);
				}

				ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
			}

			if (opline->extended_value == IS_ARRAY) {
				if (Z_TYPE_P(expr) != IS_OBJECT) {
					ZVAL_NEW_ARR(result);
					zend_hash_init(Z_ARRVAL_P(result), 8, NULL, ZVAL_PTR_DTOR, 0);
					if (Z_TYPE_P(expr) != IS_NULL) {
						expr = zend_hash_index_add_new(Z_ARRVAL_P(result), 0, expr);
						if (IS_CONST == IS_CONST) {
							if (UNEXPECTED(Z_OPT_COPYABLE_P(expr))) {
								zval_copy_ctor_func(expr);
							}
						} else {
							if (Z_OPT_REFCOUNTED_P(expr)) Z_ADDREF_P(expr);
						}
					}
				} else {
					ZVAL_COPY_VALUE(result, expr);
					Z_ADDREF_P(result);
					convert_to_array(result);
				}
			} else {
				if (Z_TYPE_P(expr) != IS_ARRAY) {
					object_init(result);
					if (Z_TYPE_P(expr) != IS_NULL) {
						expr = zend_hash_str_add_new(Z_OBJPROP_P(result), "scalar", sizeof("scalar")-1, expr);
						if (IS_CONST == IS_CONST) {
							if (UNEXPECTED(Z_OPT_COPYABLE_P(expr))) {
								zval_copy_ctor_func(expr);
							}
						} else {
							if (Z_OPT_REFCOUNTED_P(expr)) Z_ADDREF_P(expr);
						}
					}
				} else {
					ZVAL_COPY(result, expr);
					convert_to_object(result);
				}
			}
	}

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_INCLUDE_OR_EVAL_SPEC_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_op_array *new_op_array=NULL;

	zval *inc_filename;
	zval tmp_inc_filename;
	zend_bool failure_retval=0;

	SAVE_OPLINE();
	inc_filename = EX_CONSTANT(opline->op1);

	ZVAL_UNDEF(&tmp_inc_filename);
	if (Z_TYPE_P(inc_filename) != IS_STRING) {
		if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(inc_filename) == IS_UNDEF)) {
			inc_filename = GET_OP1_UNDEF_CV(inc_filename, BP_VAR_R);
		}
		ZVAL_STR(&tmp_inc_filename, zval_get_string(inc_filename));
		inc_filename = &tmp_inc_filename;
	}

	if (opline->extended_value != ZEND_EVAL && strlen(Z_STRVAL_P(inc_filename)) != Z_STRLEN_P(inc_filename)) {
		if (opline->extended_value == ZEND_INCLUDE_ONCE || opline->extended_value == ZEND_INCLUDE) {
			zend_message_dispatcher(ZMSG_FAILED_INCLUDE_FOPEN, Z_STRVAL_P(inc_filename));
		} else {
			zend_message_dispatcher(ZMSG_FAILED_REQUIRE_FOPEN, Z_STRVAL_P(inc_filename));
		}
	} else {
		switch (opline->extended_value) {
			case ZEND_INCLUDE_ONCE:
			case ZEND_REQUIRE_ONCE: {
					zend_file_handle file_handle;
					zend_string *resolved_path;

					resolved_path = zend_resolve_path(Z_STRVAL_P(inc_filename), (int)Z_STRLEN_P(inc_filename));
					if (resolved_path) {
						failure_retval = zend_hash_exists(&EG(included_files), resolved_path);
					} else {
						resolved_path = zend_string_copy(Z_STR_P(inc_filename));
					}

					if (failure_retval) {
						/* do nothing, file already included */
					} else if (SUCCESS == zend_stream_open(ZSTR_VAL(resolved_path), &file_handle)) {

						if (!file_handle.opened_path) {
							file_handle.opened_path = zend_string_copy(resolved_path);
						}

						if (zend_hash_add_empty_element(&EG(included_files), file_handle.opened_path)) {
							new_op_array = zend_compile_file(&file_handle, (opline->extended_value==ZEND_INCLUDE_ONCE?ZEND_INCLUDE:ZEND_REQUIRE));
							zend_destroy_file_handle(&file_handle);
						} else {
							zend_file_handle_dtor(&file_handle);
							failure_retval=1;
						}
					} else {
						if (opline->extended_value == ZEND_INCLUDE_ONCE) {
							zend_message_dispatcher(ZMSG_FAILED_INCLUDE_FOPEN, Z_STRVAL_P(inc_filename));
						} else {
							zend_message_dispatcher(ZMSG_FAILED_REQUIRE_FOPEN, Z_STRVAL_P(inc_filename));
						}
					}
					zend_string_release(resolved_path);
				}
				break;
			case ZEND_INCLUDE:
			case ZEND_REQUIRE:
				new_op_array = compile_filename(opline->extended_value, inc_filename);
				break;
			case ZEND_EVAL: {
					char *eval_desc = zend_make_compiled_string_description("eval()'d code");

					new_op_array = zend_compile_string(inc_filename, eval_desc);
					efree(eval_desc);
				}
				break;
			EMPTY_SWITCH_DEFAULT_CASE()
		}
	}
	if (Z_TYPE(tmp_inc_filename) != IS_UNDEF) {
		zend_string_release(Z_STR(tmp_inc_filename));
	}

	if (UNEXPECTED(EG(exception) != NULL)) {
		HANDLE_EXCEPTION();
	} else if (EXPECTED(new_op_array != NULL)) {
		zval *return_value = NULL;
		zend_execute_data *call;

		if (RETURN_VALUE_USED(opline)) {
			return_value = EX_VAR(opline->result.var);
		}

		new_op_array->scope = EG(scope);

		call = zend_vm_stack_push_call_frame(ZEND_CALL_NESTED_CODE,
			(zend_function*)new_op_array, 0, EX(called_scope), Z_OBJ(EX(This)));

		if (EX(symbol_table)) {
			call->symbol_table = EX(symbol_table);
		} else {
			call->symbol_table = zend_rebuild_symbol_table();
		}

		call->prev_execute_data = execute_data;
	    i_init_code_execute_data(call, new_op_array, return_value);
		if (EXPECTED(zend_execute_ex == execute_ex)) {
			ZEND_VM_ENTER();
		} else {
			ZEND_ADD_CALL_FLAG(call, ZEND_CALL_TOP);
			zend_execute_ex(call);
			zend_vm_stack_free_call_frame(call);
		}

		destroy_op_array(new_op_array);
		efree_size(new_op_array, sizeof(zend_op_array));
		if (UNEXPECTED(EG(exception) != NULL)) {
			zend_throw_exception_internal(NULL);
			HANDLE_EXCEPTION();
		}

	} else if (RETURN_VALUE_USED(opline)) {
		ZVAL_BOOL(EX_VAR(opline->result.var), failure_retval);
	}
	ZEND_VM_INTERRUPT_CHECK();
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FE_RESET_R_SPEC_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *array_ptr, *result;
	HashTable *fe_ht;

	SAVE_OPLINE();

	array_ptr = EX_CONSTANT(opline->op1);
	if (EXPECTED(Z_TYPE_P(array_ptr) == IS_ARRAY)) {
		result = EX_VAR(opline->result.var);
		ZVAL_COPY_VALUE(result, array_ptr);
		if (IS_CONST != IS_TMP_VAR && Z_OPT_REFCOUNTED_P(result)) {
			Z_ADDREF_P(array_ptr);
		}
		Z_FE_POS_P(result) = 0;

		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	} else if (IS_CONST != IS_CONST && EXPECTED(Z_TYPE_P(array_ptr) == IS_OBJECT)) {
		if (!Z_OBJCE_P(array_ptr)->get_iterator) {
			HashPosition pos = 0;
			Bucket *p;

			result = EX_VAR(opline->result.var);
			ZVAL_COPY_VALUE(result, array_ptr);
			if (IS_CONST != IS_TMP_VAR) {
				Z_ADDREF_P(array_ptr);
			}
			fe_ht = Z_OBJPROP_P(array_ptr);
			pos = 0;
			p = fe_ht->arData;
			while (1) {
				if (UNEXPECTED(pos >= fe_ht->nNumUsed)) {

					Z_FE_ITER_P(EX_VAR(opline->result.var)) = (uint32_t)-1;
					ZEND_VM_JMP(OP_JMP_ADDR(opline, opline->op2));
				}
				if ((EXPECTED(Z_TYPE(p->val) != IS_UNDEF) &&
				     (EXPECTED(Z_TYPE(p->val) != IS_INDIRECT) ||
				      EXPECTED(Z_TYPE_P(Z_INDIRECT(p->val)) != IS_UNDEF))) &&
				    (UNEXPECTED(!p->key) ||
				     EXPECTED(zend_check_property_access(Z_OBJ_P(array_ptr), p->key) == SUCCESS))) {
					break;
				}
				pos++;
				p++;
			}
			Z_FE_ITER_P(EX_VAR(opline->result.var)) = zend_hash_iterator_add(fe_ht, pos);

			ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
		} else {
			zend_class_entry *ce = Z_OBJCE_P(array_ptr);
			zend_object_iterator *iter = ce->get_iterator(ce, array_ptr, 0);
			zend_bool is_empty;

			if (UNEXPECTED(!iter) || UNEXPECTED(EG(exception))) {

				if (!EG(exception)) {
					zend_throw_exception_ex(NULL, 0, "Object of type %s did not create an Iterator", ZSTR_VAL(ce->name));
				}
				zend_throw_exception_internal(NULL);
				HANDLE_EXCEPTION();
			}

			iter->index = 0;
			if (iter->funcs->rewind) {
				iter->funcs->rewind(iter);
				if (UNEXPECTED(EG(exception) != NULL)) {
					OBJ_RELEASE(&iter->std);

					HANDLE_EXCEPTION();
				}
			}

			is_empty = iter->funcs->valid(iter) != SUCCESS;

			if (UNEXPECTED(EG(exception) != NULL)) {
				OBJ_RELEASE(&iter->std);

				HANDLE_EXCEPTION();
			}
			iter->index = -1; /* will be set to 0 before using next handler */

			ZVAL_OBJ(EX_VAR(opline->result.var), &iter->std);
			Z_FE_ITER_P(EX_VAR(opline->result.var)) = (uint32_t)-1;

			if (is_empty) {
				ZEND_VM_JMP(OP_JMP_ADDR(opline, opline->op2));
			} else {
				ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
			}
		}
	} else {
		zend_error(E_WARNING, "Invalid argument supplied for foreach()");
		ZVAL_UNDEF(EX_VAR(opline->result.var));
		Z_FE_ITER_P(EX_VAR(opline->result.var)) = (uint32_t)-1;

		ZEND_VM_JMP(OP_JMP_ADDR(opline, opline->op2));
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FE_RESET_RW_SPEC_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *array_ptr, *array_ref;
	HashTable *fe_ht;
	HashPosition pos = 0;
	Bucket *p;

	SAVE_OPLINE();

	if (IS_CONST == IS_VAR || IS_CONST == IS_CV) {
		array_ref = array_ptr = NULL;
		if (Z_ISREF_P(array_ref)) {
			array_ptr = Z_REFVAL_P(array_ref);
		}
	} else {
		array_ref = array_ptr = EX_CONSTANT(opline->op1);
	}

	if (EXPECTED(Z_TYPE_P(array_ptr) == IS_ARRAY)) {
		if (IS_CONST == IS_VAR || IS_CONST == IS_CV) {
			if (array_ptr == array_ref) {
				ZVAL_NEW_REF(array_ref, array_ref);
				array_ptr = Z_REFVAL_P(array_ref);
			}
			Z_ADDREF_P(array_ref);
			ZVAL_COPY_VALUE(EX_VAR(opline->result.var), array_ref);
		} else {
			array_ptr = EX_VAR(opline->result.var);
			ZVAL_COPY_VALUE(array_ptr, array_ref);
		}
		if (IS_CONST == IS_CONST) {
			zval_copy_ctor_func(array_ptr);
		} else {
			SEPARATE_ARRAY(array_ptr);
		}
		fe_ht = Z_ARRVAL_P(array_ptr);
		p = fe_ht->arData;
		while (1) {
			if (UNEXPECTED(pos >= fe_ht->nNumUsed)) {

				Z_FE_ITER_P(EX_VAR(opline->result.var)) = (uint32_t)-1;
				ZEND_VM_JMP(OP_JMP_ADDR(opline, opline->op2));
			}
			if (EXPECTED(Z_TYPE(p->val) != IS_UNDEF) &&
			    (EXPECTED(Z_TYPE(p->val) != IS_INDIRECT) ||
			     EXPECTED(Z_TYPE_P(Z_INDIRECT(p->val)) != IS_UNDEF))) {
				break;
			}
			pos++;
			p++;
		}
		Z_FE_ITER_P(EX_VAR(opline->result.var)) = zend_hash_iterator_add(fe_ht, pos);

		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	} else if (IS_CONST != IS_CONST && EXPECTED(Z_TYPE_P(array_ptr) == IS_OBJECT)) {
		if (!Z_OBJCE_P(array_ptr)->get_iterator) {
			if (IS_CONST == IS_VAR || IS_CONST == IS_CV) {
				if (array_ptr == array_ref) {
					ZVAL_NEW_REF(array_ref, array_ref);
					array_ptr = Z_REFVAL_P(array_ref);
				}
				Z_ADDREF_P(array_ref);
				ZVAL_COPY_VALUE(EX_VAR(opline->result.var), array_ref);
			} else {
				array_ptr = EX_VAR(opline->result.var);
				ZVAL_COPY_VALUE(array_ptr, array_ref);
			}
			fe_ht = Z_OBJPROP_P(array_ptr);
			p = fe_ht->arData;
			while (1) {
				if (UNEXPECTED(pos >= fe_ht->nNumUsed)) {

					Z_FE_ITER_P(EX_VAR(opline->result.var)) = (uint32_t)-1;
					ZEND_VM_JMP(OP_JMP_ADDR(opline, opline->op2));
				}
				if ((EXPECTED(Z_TYPE(p->val) != IS_UNDEF) &&
				     (EXPECTED(Z_TYPE(p->val) != IS_INDIRECT) ||
				      EXPECTED(Z_TYPE_P(Z_INDIRECT(p->val)) != IS_UNDEF))) &&
				    (UNEXPECTED(!p->key) ||
				     EXPECTED(zend_check_property_access(Z_OBJ_P(array_ptr), p->key) == SUCCESS))) {
					break;
				}
				pos++;
				p++;
			}
			Z_FE_ITER_P(EX_VAR(opline->result.var)) = zend_hash_iterator_add(fe_ht, pos);

			ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
		} else {
			zend_class_entry *ce = Z_OBJCE_P(array_ptr);
			zend_object_iterator *iter = ce->get_iterator(ce, array_ptr, 1);
			zend_bool is_empty;

			if (UNEXPECTED(!iter) || UNEXPECTED(EG(exception))) {
				if (IS_CONST == IS_VAR) {

				} else {

				}
				if (!EG(exception)) {
					zend_throw_exception_ex(NULL, 0, "Object of type %s did not create an Iterator", ZSTR_VAL(ce->name));
				}
				zend_throw_exception_internal(NULL);
				HANDLE_EXCEPTION();
			}

			iter->index = 0;
			if (iter->funcs->rewind) {
				iter->funcs->rewind(iter);
				if (UNEXPECTED(EG(exception) != NULL)) {
					OBJ_RELEASE(&iter->std);
					if (IS_CONST == IS_VAR) {

					} else {

					}
					HANDLE_EXCEPTION();
				}
			}

			is_empty = iter->funcs->valid(iter) != SUCCESS;

			if (UNEXPECTED(EG(exception) != NULL)) {
				OBJ_RELEASE(&iter->std);
				if (IS_CONST == IS_VAR) {

				} else {

				}
				HANDLE_EXCEPTION();
			}
			iter->index = -1; /* will be set to 0 before using next handler */

			ZVAL_OBJ(EX_VAR(opline->result.var), &iter->std);
			Z_FE_ITER_P(EX_VAR(opline->result.var)) = (uint32_t)-1;

			if (IS_CONST == IS_VAR) {

			} else {

			}
			if (is_empty) {
				ZEND_VM_JMP(OP_JMP_ADDR(opline, opline->op2));
			} else {
				ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
			}
		}
	} else {
		zend_error(E_WARNING, "Invalid argument supplied for foreach()");
		ZVAL_UNDEF(EX_VAR(opline->result.var));
		Z_FE_ITER_P(EX_VAR(opline->result.var)) = (uint32_t)-1;
		if (IS_CONST == IS_VAR) {

		} else {

		}
		ZEND_VM_JMP(OP_JMP_ADDR(opline, opline->op2));
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_EXIT_SPEC_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	SAVE_OPLINE();
	if (IS_CONST != IS_UNUSED) {

		zval *ptr = EX_CONSTANT(opline->op1);

		do {
			if (Z_TYPE_P(ptr) == IS_LONG) {
				EG(exit_status) = Z_LVAL_P(ptr);
			} else {
				if ((IS_CONST & (IS_VAR|IS_CV)) && Z_ISREF_P(ptr)) {
					ptr = Z_REFVAL_P(ptr);
					if (Z_TYPE_P(ptr) == IS_LONG) {
						EG(exit_status) = Z_LVAL_P(ptr);
						break;
					}
				}
				zend_print_variable(ptr);
			}
		} while (0);

	}
	zend_bailout();
	ZEND_VM_NEXT_OPCODE(); /* Never reached */
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_JMP_SET_SPEC_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *value;
	zval *ref = NULL;

	SAVE_OPLINE();
	value = EX_CONSTANT(opline->op1);

	if ((IS_CONST == IS_VAR || IS_CONST == IS_CV) && Z_ISREF_P(value)) {
		if (IS_CONST == IS_VAR) {
			ref = value;
		}
		value = Z_REFVAL_P(value);
	}
	if (i_zend_is_true(value)) {
		ZVAL_COPY_VALUE(EX_VAR(opline->result.var), value);
		if (IS_CONST == IS_CONST) {
			if (UNEXPECTED(Z_OPT_COPYABLE_P(value))) {
				zval_copy_ctor_func(EX_VAR(opline->result.var));
			}
		} else if (IS_CONST == IS_CV) {
			if (Z_OPT_REFCOUNTED_P(value)) Z_ADDREF_P(value);
		} else if (IS_CONST == IS_VAR && ref) {
			zend_reference *r = Z_REF_P(ref);

			if (Z_OPT_REFCOUNTED_P(value)) Z_ADDREF_P(value);
			if (UNEXPECTED(--GC_REFCOUNT(r) == 0)) {
				efree_size(r, sizeof(zend_reference));
			}
		}
		ZEND_VM_JMP(OP_JMP_ADDR(opline, opline->op2));
	}

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_COALESCE_SPEC_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *value;
	zval *ref = NULL;

	SAVE_OPLINE();
	value = EX_CONSTANT(opline->op1);

	if ((IS_CONST == IS_VAR || IS_CONST == IS_CV) && Z_ISREF_P(value)) {
		if (IS_CONST == IS_VAR) {
			ref = value;
		}
		value = Z_REFVAL_P(value);
	}

	if (Z_TYPE_P(value) > IS_NULL) {
		ZVAL_COPY_VALUE(EX_VAR(opline->result.var), value);
		if (IS_CONST == IS_CONST) {
			if (UNEXPECTED(Z_OPT_COPYABLE_P(value))) {
				zval_copy_ctor_func(EX_VAR(opline->result.var));
			}
		} else if (IS_CONST == IS_CV) {
			if (Z_OPT_REFCOUNTED_P(value)) Z_ADDREF_P(value);
		} else if (IS_CONST == IS_VAR && ref) {
			zend_reference *r = Z_REF_P(ref);

			if (Z_OPT_REFCOUNTED_P(value)) Z_ADDREF_P(value);
			if (UNEXPECTED(--GC_REFCOUNT(r) == 0)) {
				efree_size(r, sizeof(zend_reference));
			}
		}
		ZEND_VM_JMP(OP_JMP_ADDR(opline, opline->op2));
	}

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_QM_ASSIGN_SPEC_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *value;

	value = EX_CONSTANT(opline->op1);
	if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(value) == IS_UNDEF)) {
		SAVE_OPLINE();
		GET_OP1_UNDEF_CV(value, BP_VAR_R);
		ZVAL_NULL(EX_VAR(opline->result.var));
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}

	if ((IS_CONST == IS_VAR || IS_CONST == IS_CV) && Z_ISREF_P(value)) {
		ZVAL_COPY(EX_VAR(opline->result.var), Z_REFVAL_P(value));
		if (IS_CONST == IS_VAR) {
			if (UNEXPECTED(Z_DELREF_P(value) == 0)) {
				efree_size(Z_REF_P(value), sizeof(zend_reference));
			}
		}
	} else {
		ZVAL_COPY_VALUE(EX_VAR(opline->result.var), value);
		if (IS_CONST == IS_CONST) {
			if (UNEXPECTED(Z_OPT_COPYABLE_P(value))) {
				zval_copy_ctor_func(EX_VAR(opline->result.var));
			}
		} else if (IS_CONST == IS_CV) {
			if (Z_OPT_REFCOUNTED_P(value)) Z_ADDREF_P(value);
		}
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_YIELD_FROM_SPEC_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zend_generator *generator = zend_get_running_generator(execute_data);

	zval *val;


	SAVE_OPLINE();
	val = EX_CONSTANT(opline->op1);

	if (Z_TYPE_P(val) == IS_ARRAY) {
		ZVAL_COPY_VALUE(&generator->values, val);
		if (IS_CONST != IS_TMP_VAR && Z_OPT_REFCOUNTED_P(val)) {
			Z_ADDREF_P(val);
		}
		Z_FE_POS(generator->values) = 0;

	} else if (IS_CONST != IS_CONST && Z_TYPE_P(val) == IS_OBJECT && Z_OBJCE_P(val)->get_iterator) {
		zend_class_entry *ce = Z_OBJCE_P(val);
		if (ce == zend_ce_generator) {
			zend_generator *new_gen = (zend_generator *) Z_OBJ_P(val);

			if (IS_CONST != IS_TMP_VAR) {
				Z_ADDREF_P(val);
			}

			if (Z_ISUNDEF(new_gen->retval)) {
				if (UNEXPECTED(zend_generator_get_current(new_gen) == generator)) {
					zend_throw_error(NULL, "Impossible to yield from the Generator being currently run");
					HANDLE_EXCEPTION();
				} else {
					zend_generator_yield_from(generator, new_gen);
				}
			} else if (UNEXPECTED(new_gen->execute_data == NULL)) {
				zend_throw_error(NULL, "Generator passed to yield from was aborted without proper return and is unable to continue");
				HANDLE_EXCEPTION();
			} else {
				if (RETURN_VALUE_USED(opline)) {
					ZVAL_COPY(EX_VAR(opline->result.var), &new_gen->retval);
				}
				ZEND_VM_NEXT_OPCODE();
			}
		} else {
			zend_object_iterator *iter = ce->get_iterator(ce, val, 0);

			if (UNEXPECTED(!iter) || UNEXPECTED(EG(exception))) {
				if (!EG(exception)) {
					zend_throw_error(NULL, "Object of type %s did not create an Iterator", ZSTR_VAL(ce->name));
				}
				HANDLE_EXCEPTION();
			}

			iter->index = 0;
			if (iter->funcs->rewind) {
				iter->funcs->rewind(iter);
				if (UNEXPECTED(EG(exception) != NULL)) {
					OBJ_RELEASE(&iter->std);
					HANDLE_EXCEPTION();
				}
			}

			ZVAL_OBJ(&generator->values, &iter->std);
		}
	} else {
		zend_throw_error(NULL, "Can use \"yield from\" only with arrays and Traversables", 0);
		HANDLE_EXCEPTION();
	}

	/* This is the default return value
	 * when the expression is a Generator, it will be overwritten in zend_generator_resume() */
	if (RETURN_VALUE_USED(opline)) {
		ZVAL_NULL(EX_VAR(opline->result.var));
	}

	/* We increment to the next op, so we are at the correct position when the
	 * generator is resumed. */
	ZEND_VM_INC_OPCODE();

	/* The GOTO VM uses a local opline variable. We need to set the opline
	 * variable in execute_data so we don't resume at an old position. */
	SAVE_OPLINE();

	ZEND_VM_RETURN();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_STRLEN_SPEC_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *value;


	SAVE_OPLINE();
	value = EX_CONSTANT(opline->op1);
try_strlen:
	if (EXPECTED(Z_TYPE_P(value) == IS_STRING)) {
		ZVAL_LONG(EX_VAR(opline->result.var), Z_STRLEN_P(value));
	} else {
		zend_bool strict;

		if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(value) == IS_UNDEF)) {
			value = GET_OP1_UNDEF_CV(value, BP_VAR_R);
		}
		if ((IS_CONST & (IS_VAR|IS_CV)) && Z_TYPE_P(value) == IS_REFERENCE) {
			value = Z_REFVAL_P(value);
			goto try_strlen;
		}
		strict = EX_USES_STRICT_TYPES();
		do {
			if (EXPECTED(!strict)) {
				zend_string *str;
				zval tmp;

				ZVAL_COPY(&tmp, value);
				if (zend_parse_arg_str_weak(&tmp, &str)) {
					ZVAL_LONG(EX_VAR(opline->result.var), ZSTR_LEN(str));
					zval_ptr_dtor(&tmp);
					break;
				}
				zval_ptr_dtor(&tmp);
			}
			zend_internal_type_error(strict, "strlen() expects parameter 1 to be string, %s given", zend_get_type_by_const(Z_TYPE_P(value)));
			ZVAL_NULL(EX_VAR(opline->result.var));
		} while (0);
	}

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_TYPE_CHECK_SPEC_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *value;
	int result = 0;


	SAVE_OPLINE();
	value = EX_CONSTANT(opline->op1);
	if (EXPECTED(Z_TYPE_P(value) == opline->extended_value)) {
		if (IS_CONST != IS_CONST && UNEXPECTED(Z_TYPE_P(value) == IS_OBJECT)) {
			zend_class_entry *ce = Z_OBJCE_P(value);

			if (UNEXPECTED(ZSTR_LEN(ce->name) != sizeof("__PHP_Incomplete_Class") - 1) ||
			    EXPECTED(memcmp(ZSTR_VAL(ce->name), "__PHP_Incomplete_Class", sizeof("__PHP_Incomplete_Class") - 1) != 0)) {
				result = 1;
			}
		} else if (UNEXPECTED(Z_TYPE_P(value) == IS_RESOURCE)) {
			const char *type_name = zend_rsrc_list_get_rsrc_type(Z_RES_P(value));

			if (EXPECTED(type_name != NULL)) {
				result = 1;
			}
		} else {
			result = 1;
		}
	} else if (UNEXPECTED(opline->extended_value == _IS_BOOL) &&
			   EXPECTED(Z_TYPE_P(value) == IS_TRUE || Z_TYPE_P(value) == IS_FALSE)) {
		result = 1;
	}

	ZEND_VM_SMART_BRANCH(result, 1);
	ZVAL_BOOL(EX_VAR(opline->result.var), result);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_DEFINED_SPEC_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_constant *c;
	int result;

	if (EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1))))) {
		result = 1;
	} else if ((c = zend_quick_get_constant(EX_CONSTANT(opline->op1), 0)) == NULL) {
		result = 0;
		ZVAL_FALSE(EX_VAR(opline->result.var));
	} else {
		CACHE_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)), c);
		result = 1;
	}
	ZEND_VM_SMART_BRANCH(result, 0);
	ZVAL_BOOL(EX_VAR(opline->result.var), result);
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ADD_SPEC_CONST_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2, *result;

	op1 = EX_CONSTANT(opline->op1);
	op2 = EX_CONSTANT(opline->op2);
	if (EXPECTED(Z_TYPE_INFO_P(op1) == IS_LONG)) {
		if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_LONG)) {
			result = EX_VAR(opline->result.var);
			fast_long_add_function(result, op1, op2);
			ZEND_VM_NEXT_OPCODE();
		} else if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_DOUBLE)) {
			result = EX_VAR(opline->result.var);
			ZVAL_DOUBLE(result, ((double)Z_LVAL_P(op1)) + Z_DVAL_P(op2));
			ZEND_VM_NEXT_OPCODE();
		}
	} else if (EXPECTED(Z_TYPE_INFO_P(op1) == IS_DOUBLE)) {
		if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_DOUBLE)) {
			result = EX_VAR(opline->result.var);
			ZVAL_DOUBLE(result, Z_DVAL_P(op1) + Z_DVAL_P(op2));
			ZEND_VM_NEXT_OPCODE();
		} else if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_LONG)) {
			result = EX_VAR(opline->result.var);
			ZVAL_DOUBLE(result, Z_DVAL_P(op1) + ((double)Z_LVAL_P(op2)));
			ZEND_VM_NEXT_OPCODE();
		}
	}

	SAVE_OPLINE();
	if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(op1) == IS_UNDEF)) {
		op1 = GET_OP1_UNDEF_CV(op1, BP_VAR_R);
	}
	if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(op2) == IS_UNDEF)) {
		op2 = GET_OP2_UNDEF_CV(op2, BP_VAR_R);
	}
	add_function(EX_VAR(opline->result.var), op1, op2);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_SUB_SPEC_CONST_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2, *result;

	op1 = EX_CONSTANT(opline->op1);
	op2 = EX_CONSTANT(opline->op2);
	if (EXPECTED(Z_TYPE_INFO_P(op1) == IS_LONG)) {
		if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_LONG)) {
			result = EX_VAR(opline->result.var);
			fast_long_sub_function(result, op1, op2);
			ZEND_VM_NEXT_OPCODE();
		} else if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_DOUBLE)) {
			result = EX_VAR(opline->result.var);
			ZVAL_DOUBLE(result, ((double)Z_LVAL_P(op1)) - Z_DVAL_P(op2));
			ZEND_VM_NEXT_OPCODE();
		}
	} else if (EXPECTED(Z_TYPE_INFO_P(op1) == IS_DOUBLE)) {
		if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_DOUBLE)) {
			result = EX_VAR(opline->result.var);
			ZVAL_DOUBLE(result, Z_DVAL_P(op1) - Z_DVAL_P(op2));
			ZEND_VM_NEXT_OPCODE();
		} else if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_LONG)) {
			result = EX_VAR(opline->result.var);
			ZVAL_DOUBLE(result, Z_DVAL_P(op1) - ((double)Z_LVAL_P(op2)));
			ZEND_VM_NEXT_OPCODE();
		}
	}

	SAVE_OPLINE();
	if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(op1) == IS_UNDEF)) {
		op1 = GET_OP1_UNDEF_CV(op1, BP_VAR_R);
	}
	if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(op2) == IS_UNDEF)) {
		op2 = GET_OP2_UNDEF_CV(op2, BP_VAR_R);
	}
	sub_function(EX_VAR(opline->result.var), op1, op2);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_MUL_SPEC_CONST_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2, *result;

	op1 = EX_CONSTANT(opline->op1);
	op2 = EX_CONSTANT(opline->op2);
	if (EXPECTED(Z_TYPE_INFO_P(op1) == IS_LONG)) {
		if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_LONG)) {
			zend_long overflow;

			result = EX_VAR(opline->result.var);
			ZEND_SIGNED_MULTIPLY_LONG(Z_LVAL_P(op1), Z_LVAL_P(op2), Z_LVAL_P(result), Z_DVAL_P(result), overflow);
			Z_TYPE_INFO_P(result) = overflow ? IS_DOUBLE : IS_LONG;
			ZEND_VM_NEXT_OPCODE();
		} else if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_DOUBLE)) {
			result = EX_VAR(opline->result.var);
			ZVAL_DOUBLE(result, ((double)Z_LVAL_P(op1)) * Z_DVAL_P(op2));
			ZEND_VM_NEXT_OPCODE();
		}
	} else if (EXPECTED(Z_TYPE_INFO_P(op1) == IS_DOUBLE)) {
		if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_DOUBLE)) {
			result = EX_VAR(opline->result.var);
			ZVAL_DOUBLE(result, Z_DVAL_P(op1) * Z_DVAL_P(op2));
			ZEND_VM_NEXT_OPCODE();
		} else if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_LONG)) {
			result = EX_VAR(opline->result.var);
			ZVAL_DOUBLE(result, Z_DVAL_P(op1) * ((double)Z_LVAL_P(op2)));
			ZEND_VM_NEXT_OPCODE();
		}
	}

	SAVE_OPLINE();
	if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(op1) == IS_UNDEF)) {
		op1 = GET_OP1_UNDEF_CV(op1, BP_VAR_R);
	}
	if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(op2) == IS_UNDEF)) {
		op2 = GET_OP2_UNDEF_CV(op2, BP_VAR_R);
	}
	mul_function(EX_VAR(opline->result.var), op1, op2);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_DIV_SPEC_CONST_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2;

	SAVE_OPLINE();
	op1 = EX_CONSTANT(opline->op1);
	op2 = EX_CONSTANT(opline->op2);
	fast_div_function(EX_VAR(opline->result.var), op1, op2);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_MOD_SPEC_CONST_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2, *result;

	op1 = EX_CONSTANT(opline->op1);
	op2 = EX_CONSTANT(opline->op2);
	if (EXPECTED(Z_TYPE_INFO_P(op1) == IS_LONG)) {
		if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_LONG)) {
			result = EX_VAR(opline->result.var);
			if (UNEXPECTED(Z_LVAL_P(op2) == 0)) {
				SAVE_OPLINE();
				zend_throw_exception_ex(zend_ce_division_by_zero_error, 0, "Modulo by zero");
				HANDLE_EXCEPTION();
			} else if (UNEXPECTED(Z_LVAL_P(op2) == -1)) {
				/* Prevent overflow error/crash if op1==ZEND_LONG_MIN */
				ZVAL_LONG(result, 0);
			} else {
				ZVAL_LONG(result, Z_LVAL_P(op1) % Z_LVAL_P(op2));
			}
			ZEND_VM_NEXT_OPCODE();
		}
	}

	SAVE_OPLINE();
	if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(op1) == IS_UNDEF)) {
		op1 = GET_OP1_UNDEF_CV(op1, BP_VAR_R);
	}
	if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(op2) == IS_UNDEF)) {
		op2 = GET_OP2_UNDEF_CV(op2, BP_VAR_R);
	}
	mod_function(EX_VAR(opline->result.var), op1, op2);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_SL_SPEC_CONST_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2;

	SAVE_OPLINE();
	op1 = EX_CONSTANT(opline->op1);
	op2 = EX_CONSTANT(opline->op2);
	shift_left_function(EX_VAR(opline->result.var), op1, op2);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_SR_SPEC_CONST_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2;

	SAVE_OPLINE();
	op1 = EX_CONSTANT(opline->op1);
	op2 = EX_CONSTANT(opline->op2);
	shift_right_function(EX_VAR(opline->result.var), op1, op2);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_CONCAT_SPEC_CONST_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2;

	SAVE_OPLINE();
	op1 = EX_CONSTANT(opline->op1);
	op2 = EX_CONSTANT(opline->op2);

	do {
		if ((IS_CONST == IS_CONST || EXPECTED(Z_TYPE_P(op1) == IS_STRING)) &&
		    (IS_CONST == IS_CONST || EXPECTED(Z_TYPE_P(op2) == IS_STRING))) {
			zend_string *op1_str = Z_STR_P(op1);
			zend_string *op2_str = Z_STR_P(op2);
			zend_string *str;

			if (IS_CONST != IS_CONST) {
				if (UNEXPECTED(ZSTR_LEN(op1_str) == 0)) {
					ZVAL_STR_COPY(EX_VAR(opline->result.var), op2_str);

					break;
				}
			}
			if (IS_CONST != IS_CONST) {
				if (UNEXPECTED(ZSTR_LEN(op2_str) == 0)) {
					ZVAL_STR_COPY(EX_VAR(opline->result.var), op1_str);

					break;
				}
			}
			if (IS_CONST != IS_CONST && IS_CONST != IS_CV &&
			    !ZSTR_IS_INTERNED(op1_str) && GC_REFCOUNT(op1_str) == 1) {
			    size_t len = ZSTR_LEN(op1_str);

				str = zend_string_realloc(op1_str, len + ZSTR_LEN(op2_str), 0);
				memcpy(ZSTR_VAL(str) + len, ZSTR_VAL(op2_str), ZSTR_LEN(op2_str)+1);
				ZVAL_NEW_STR(EX_VAR(opline->result.var), str);
				break;
			} else {
				str = zend_string_alloc(ZSTR_LEN(op1_str) + ZSTR_LEN(op2_str), 0);
				memcpy(ZSTR_VAL(str), ZSTR_VAL(op1_str), ZSTR_LEN(op1_str));
				memcpy(ZSTR_VAL(str) + ZSTR_LEN(op1_str), ZSTR_VAL(op2_str), ZSTR_LEN(op2_str)+1);
				ZVAL_NEW_STR(EX_VAR(opline->result.var), str);
			}
		} else {
			if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(op1) == IS_UNDEF)) {
				op1 = GET_OP1_UNDEF_CV(op1, BP_VAR_R);
			}
			if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(op2) == IS_UNDEF)) {
				op2 = GET_OP2_UNDEF_CV(op2, BP_VAR_R);
			}
			concat_function(EX_VAR(opline->result.var), op1, op2);
		}

	} while (0);

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_IS_IDENTICAL_SPEC_CONST_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2;
	int result;

	SAVE_OPLINE();
	op1 = EX_CONSTANT(opline->op1);
	op2 = EX_CONSTANT(opline->op2);
	result = fast_is_identical_function(op1, op2);


	ZEND_VM_SMART_BRANCH(result, (IS_CONST|IS_CONST) & (IS_VAR|IS_TMP_VAR));
	ZVAL_BOOL(EX_VAR(opline->result.var), result);
	if ((IS_CONST|IS_CONST) & (IS_VAR|IS_TMP_VAR)) {
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_IS_NOT_IDENTICAL_SPEC_CONST_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2;
	int result;

	SAVE_OPLINE();
	op1 = EX_CONSTANT(opline->op1);
	op2 = EX_CONSTANT(opline->op2);
	result = fast_is_not_identical_function(op1, op2);


	ZEND_VM_SMART_BRANCH(result, (IS_CONST|IS_CONST) & (IS_VAR|IS_TMP_VAR));
	ZVAL_BOOL(EX_VAR(opline->result.var), result);
	if ((IS_CONST|IS_CONST) & (IS_VAR|IS_TMP_VAR)) {
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_IS_EQUAL_SPEC_CONST_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2, *result;

	op1 = EX_CONSTANT(opline->op1);
	op2 = EX_CONSTANT(opline->op2);
	do {
		int result;

		if (EXPECTED(Z_TYPE_P(op1) == IS_LONG)) {
			if (EXPECTED(Z_TYPE_P(op2) == IS_LONG)) {
				result = (Z_LVAL_P(op1) == Z_LVAL_P(op2));
			} else if (EXPECTED(Z_TYPE_P(op2) == IS_DOUBLE)) {
				result = ((double)Z_LVAL_P(op1) == Z_DVAL_P(op2));
			} else {
				break;
			}
		} else if (EXPECTED(Z_TYPE_P(op1) == IS_DOUBLE)) {
			if (EXPECTED(Z_TYPE_P(op2) == IS_DOUBLE)) {
				result = (Z_DVAL_P(op1) == Z_DVAL_P(op2));
			} else if (EXPECTED(Z_TYPE_P(op2) == IS_LONG)) {
				result = (Z_DVAL_P(op1) == ((double)Z_LVAL_P(op2)));
			} else {
				break;
			}
		} else if (EXPECTED(Z_TYPE_P(op1) == IS_STRING)) {
			if (EXPECTED(Z_TYPE_P(op2) == IS_STRING)) {
				if (Z_STR_P(op1) == Z_STR_P(op2)) {
					result = 1;
				} else if (Z_STRVAL_P(op1)[0] > '9' || Z_STRVAL_P(op2)[0] > '9') {
					if (Z_STRLEN_P(op1) != Z_STRLEN_P(op2)) {
						result = 0;
					} else {
						result = (memcmp(Z_STRVAL_P(op1), Z_STRVAL_P(op2), Z_STRLEN_P(op1)) == 0);
					}
				} else {
					result = (zendi_smart_strcmp(op1, op2) == 0);
				}


			} else {
				break;
			}
		} else {
			break;
		}
		ZEND_VM_SMART_BRANCH(result, 0);
		ZVAL_BOOL(EX_VAR(opline->result.var), result);
		ZEND_VM_NEXT_OPCODE();
	} while (0);

	SAVE_OPLINE();
	if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(op1) == IS_UNDEF)) {
		op1 = GET_OP1_UNDEF_CV(op1, BP_VAR_R);
	}
	if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(op2) == IS_UNDEF)) {
		op2 = GET_OP2_UNDEF_CV(op2, BP_VAR_R);
	}
	result = EX_VAR(opline->result.var);
	compare_function(result, op1, op2);
	ZVAL_BOOL(result, Z_LVAL_P(result) == 0);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_IS_NOT_EQUAL_SPEC_CONST_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2, *result;

	op1 = EX_CONSTANT(opline->op1);
	op2 = EX_CONSTANT(opline->op2);
	do {
		int result;

		if (EXPECTED(Z_TYPE_P(op1) == IS_LONG)) {
			if (EXPECTED(Z_TYPE_P(op2) == IS_LONG)) {
				result = (Z_LVAL_P(op1) != Z_LVAL_P(op2));
			} else if (EXPECTED(Z_TYPE_P(op2) == IS_DOUBLE)) {
				result = ((double)Z_LVAL_P(op1) != Z_DVAL_P(op2));
			} else {
				break;
			}
		} else if (EXPECTED(Z_TYPE_P(op1) == IS_DOUBLE)) {
			if (EXPECTED(Z_TYPE_P(op2) == IS_DOUBLE)) {
				result = (Z_DVAL_P(op1) != Z_DVAL_P(op2));
			} else if (EXPECTED(Z_TYPE_P(op2) == IS_LONG)) {
				result = (Z_DVAL_P(op1) != ((double)Z_LVAL_P(op2)));
			} else {
				break;
			}
		} else if (EXPECTED(Z_TYPE_P(op1) == IS_STRING)) {
			if (EXPECTED(Z_TYPE_P(op2) == IS_STRING)) {
				if (Z_STR_P(op1) == Z_STR_P(op2)) {
					result = 0;
				} else if (Z_STRVAL_P(op1)[0] > '9' || Z_STRVAL_P(op2)[0] > '9') {
					if (Z_STRLEN_P(op1) != Z_STRLEN_P(op2)) {
						result = 1;
					} else {
						result = (memcmp(Z_STRVAL_P(op1), Z_STRVAL_P(op2), Z_STRLEN_P(op1)) != 0);
					}
				} else {
					result = (zendi_smart_strcmp(op1, op2) != 0);
				}


			} else {
				break;
			}
		} else {
			break;
		}
		ZEND_VM_SMART_BRANCH(result, 0);
		ZVAL_BOOL(EX_VAR(opline->result.var), result);
		ZEND_VM_NEXT_OPCODE();
	} while (0);

	SAVE_OPLINE();
	if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(op1) == IS_UNDEF)) {
		op1 = GET_OP1_UNDEF_CV(op1, BP_VAR_R);
	}
	if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(op2) == IS_UNDEF)) {
		op2 = GET_OP2_UNDEF_CV(op2, BP_VAR_R);
	}
	result = EX_VAR(opline->result.var);
	compare_function(result, op1, op2);
	ZVAL_BOOL(result, Z_LVAL_P(result) != 0);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_IS_SMALLER_SPEC_CONST_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2, *result;

	op1 = EX_CONSTANT(opline->op1);
	op2 = EX_CONSTANT(opline->op2);
	do {
		int result;

		if (EXPECTED(Z_TYPE_INFO_P(op1) == IS_LONG)) {
			if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_LONG)) {
				result = (Z_LVAL_P(op1) < Z_LVAL_P(op2));
			} else if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_DOUBLE)) {
				result = ((double)Z_LVAL_P(op1) < Z_DVAL_P(op2));
			} else {
				break;
			}
		} else if (EXPECTED(Z_TYPE_INFO_P(op1) == IS_DOUBLE)) {
			if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_DOUBLE)) {
				result = (Z_DVAL_P(op1) < Z_DVAL_P(op2));
			} else if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_LONG)) {
				result = (Z_DVAL_P(op1) < ((double)Z_LVAL_P(op2)));
			} else {
				break;
			}
		} else {
			break;
		}
		ZEND_VM_SMART_BRANCH(result, 0);
		ZVAL_BOOL(EX_VAR(opline->result.var), result);
		ZEND_VM_NEXT_OPCODE();
	} while (0);

	SAVE_OPLINE();
	if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(op1) == IS_UNDEF)) {
		op1 = GET_OP1_UNDEF_CV(op1, BP_VAR_R);
	}
	if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(op2) == IS_UNDEF)) {
		op2 = GET_OP2_UNDEF_CV(op2, BP_VAR_R);
	}
	result = EX_VAR(opline->result.var);
	compare_function(result, op1, op2);
	ZVAL_BOOL(result, Z_LVAL_P(result) < 0);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_IS_SMALLER_OR_EQUAL_SPEC_CONST_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2, *result;

	op1 = EX_CONSTANT(opline->op1);
	op2 = EX_CONSTANT(opline->op2);
	do {
		int result;

		if (EXPECTED(Z_TYPE_INFO_P(op1) == IS_LONG)) {
			if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_LONG)) {
				result = (Z_LVAL_P(op1) <= Z_LVAL_P(op2));
			} else if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_DOUBLE)) {
				result = ((double)Z_LVAL_P(op1) <= Z_DVAL_P(op2));
			} else {
				break;
			}
		} else if (EXPECTED(Z_TYPE_INFO_P(op1) == IS_DOUBLE)) {
			if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_DOUBLE)) {
				result = (Z_DVAL_P(op1) <= Z_DVAL_P(op2));
			} else if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_LONG)) {
				result = (Z_DVAL_P(op1) <= ((double)Z_LVAL_P(op2)));
			} else {
				break;
			}
		} else {
			break;
		}
		ZEND_VM_SMART_BRANCH(result, 0);
		ZVAL_BOOL(EX_VAR(opline->result.var), result);
		ZEND_VM_NEXT_OPCODE();
	} while (0);

	SAVE_OPLINE();
	if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(op1) == IS_UNDEF)) {
		op1 = GET_OP1_UNDEF_CV(op1, BP_VAR_R);
	}
	if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(op2) == IS_UNDEF)) {
		op2 = GET_OP2_UNDEF_CV(op2, BP_VAR_R);
	}
	result = EX_VAR(opline->result.var);
	compare_function(result, op1, op2);
	ZVAL_BOOL(result, Z_LVAL_P(result) <= 0);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_SPACESHIP_SPEC_CONST_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2;

	SAVE_OPLINE();
	op1 = EX_CONSTANT(opline->op1);
	op2 = EX_CONSTANT(opline->op2);
	compare_function(EX_VAR(opline->result.var), op1, op2);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_BW_OR_SPEC_CONST_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2;

	SAVE_OPLINE();
	op1 = EX_CONSTANT(opline->op1);
	op2 = EX_CONSTANT(opline->op2);
	bitwise_or_function(EX_VAR(opline->result.var), op1, op2);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_BW_AND_SPEC_CONST_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2;

	SAVE_OPLINE();
	op1 = EX_CONSTANT(opline->op1);
	op2 = EX_CONSTANT(opline->op2);
	bitwise_and_function(EX_VAR(opline->result.var), op1, op2);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_BW_XOR_SPEC_CONST_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2;

	SAVE_OPLINE();
	op1 = EX_CONSTANT(opline->op1);
	op2 = EX_CONSTANT(opline->op2);
	bitwise_xor_function(EX_VAR(opline->result.var), op1, op2);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_BOOL_XOR_SPEC_CONST_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2;

	SAVE_OPLINE();
	op1 = EX_CONSTANT(opline->op1);
	op2 = EX_CONSTANT(opline->op2);
	boolean_xor_function(EX_VAR(opline->result.var), op1, op2);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL zend_fetch_var_address_helper_SPEC_CONST_CONST(int type ZEND_OPCODE_HANDLER_ARGS_DC)
{
	USE_OPLINE

	zval *varname;
	zval *retval;
	zend_string *name;
	HashTable *target_symbol_table;

	SAVE_OPLINE();
	varname = EX_CONSTANT(opline->op1);

 	if (IS_CONST == IS_CONST) {
		name = Z_STR_P(varname);
	} else if (EXPECTED(Z_TYPE_P(varname) == IS_STRING)) {
		name = Z_STR_P(varname);
		zend_string_addref(name);
	} else {
		if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(varname) == IS_UNDEF)) {
			GET_OP1_UNDEF_CV(varname, BP_VAR_R);
		}
		name = zval_get_string(varname);
	}

	if (IS_CONST != IS_UNUSED) {
		zend_class_entry *ce;

		if (IS_CONST == IS_CONST) {
			if (IS_CONST == IS_CONST && EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1))))) {

				ce = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)));
				retval = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)) + sizeof(void*));

				/* check if static properties were destoyed */
				if (UNEXPECTED(CE_STATIC_MEMBERS(ce) == NULL)) {
					zend_throw_error(NULL, "Access to undeclared static property: %s::$%s", ZSTR_VAL(ce->name), ZSTR_VAL(name));

					HANDLE_EXCEPTION();
				}

				goto fetch_var_return;
			} else if (EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2))))) {
				ce = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)));
			} else {
				ce = zend_fetch_class_by_name(Z_STR_P(EX_CONSTANT(opline->op2)), EX_CONSTANT(opline->op2) + 1, ZEND_FETCH_CLASS_DEFAULT | ZEND_FETCH_CLASS_EXCEPTION);
				if (UNEXPECTED(ce == NULL)) {
					if (IS_CONST != IS_CONST) {
						zend_string_release(name);
					}

					ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
				}
				CACHE_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)), ce);
			}
		} else {
			ce = Z_CE_P(EX_VAR(opline->op2.var));
			if (IS_CONST == IS_CONST &&
			    (retval = CACHED_POLYMORPHIC_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)), ce)) != NULL) {

				/* check if static properties were destoyed */
				if (UNEXPECTED(CE_STATIC_MEMBERS(ce) == NULL)) {
					zend_throw_error(NULL, "Access to undeclared static property: %s::$%s", ZSTR_VAL(ce->name), ZSTR_VAL(name));

					HANDLE_EXCEPTION();
				}

				goto fetch_var_return;
			}
		}
		retval = zend_std_get_static_property(ce, name, 0);
		if (UNEXPECTED(EG(exception))) {

			HANDLE_EXCEPTION();
		}
		if (IS_CONST == IS_CONST && retval) {
			CACHE_POLYMORPHIC_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)), ce, retval);
		}

	} else {
		target_symbol_table = zend_get_target_symbol_table(execute_data, opline->extended_value & ZEND_FETCH_TYPE_MASK);
		retval = zend_hash_find(target_symbol_table, name);
		if (retval == NULL) {
			switch (type) {
				case BP_VAR_R:
				case BP_VAR_UNSET:
					zend_error(E_NOTICE,"Undefined variable: %s", ZSTR_VAL(name));
					/* break missing intentionally */
				case BP_VAR_IS:
					retval = &EG(uninitialized_zval);
					break;
				case BP_VAR_RW:
					zend_error(E_NOTICE,"Undefined variable: %s", ZSTR_VAL(name));
					/* break missing intentionally */
				case BP_VAR_W:
					retval = zend_hash_add_new(target_symbol_table, name, &EG(uninitialized_zval));
					break;
				EMPTY_SWITCH_DEFAULT_CASE()
			}
		/* GLOBAL or $$name variable may be an INDIRECT pointer to CV */
		} else if (Z_TYPE_P(retval) == IS_INDIRECT) {
			retval = Z_INDIRECT_P(retval);
			if (Z_TYPE_P(retval) == IS_UNDEF) {
				switch (type) {
					case BP_VAR_R:
					case BP_VAR_UNSET:
						zend_error(E_NOTICE,"Undefined variable: %s", ZSTR_VAL(name));
						/* break missing intentionally */
					case BP_VAR_IS:
						retval = &EG(uninitialized_zval);
						break;
					case BP_VAR_RW:
						zend_error(E_NOTICE,"Undefined variable: %s", ZSTR_VAL(name));
						/* break missing intentionally */
					case BP_VAR_W:
						ZVAL_NULL(retval);
						break;
					EMPTY_SWITCH_DEFAULT_CASE()
				}
			}
		}
		if ((opline->extended_value & ZEND_FETCH_TYPE_MASK) == ZEND_FETCH_STATIC) {
			if (Z_CONSTANT_P(retval)) {
				if (UNEXPECTED(zval_update_constant_ex(retval, 1, NULL) != SUCCESS)) {

					HANDLE_EXCEPTION();
				}
			}
		} else if ((opline->extended_value & ZEND_FETCH_TYPE_MASK) != ZEND_FETCH_GLOBAL_LOCK) {

		}
	}

	if (IS_CONST != IS_CONST) {
		zend_string_release(name);
	}

fetch_var_return:
	ZEND_ASSERT(retval != NULL);
	if (type == BP_VAR_R || type == BP_VAR_IS) {
		if (/*type == BP_VAR_R &&*/ Z_ISREF_P(retval) && Z_REFCOUNT_P(retval) == 1) {
			ZVAL_UNREF(retval);
		}
		ZVAL_COPY(EX_VAR(opline->result.var), retval);
	} else {
		ZVAL_INDIRECT(EX_VAR(opline->result.var), retval);
	}
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_R_SPEC_CONST_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	ZEND_VM_TAIL_CALL(zend_fetch_var_address_helper_SPEC_CONST_CONST(BP_VAR_R ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_W_SPEC_CONST_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	ZEND_VM_TAIL_CALL(zend_fetch_var_address_helper_SPEC_CONST_CONST(BP_VAR_W ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_RW_SPEC_CONST_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	ZEND_VM_TAIL_CALL(zend_fetch_var_address_helper_SPEC_CONST_CONST(BP_VAR_RW ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_FUNC_ARG_SPEC_CONST_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	if (zend_is_by_ref_func_arg_fetch(opline, EX(call))) {
		ZEND_VM_TAIL_CALL(zend_fetch_var_address_helper_SPEC_CONST_CONST(BP_VAR_W ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else {
		ZEND_VM_TAIL_CALL(zend_fetch_var_address_helper_SPEC_CONST_CONST(BP_VAR_R ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_UNSET_SPEC_CONST_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	ZEND_VM_TAIL_CALL(zend_fetch_var_address_helper_SPEC_CONST_CONST(BP_VAR_UNSET ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_IS_SPEC_CONST_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	ZEND_VM_TAIL_CALL(zend_fetch_var_address_helper_SPEC_CONST_CONST(BP_VAR_IS ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_DIM_R_SPEC_CONST_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *container;

	SAVE_OPLINE();
	container = EX_CONSTANT(opline->op1);
	zend_fetch_dimension_address_read_R(EX_VAR(opline->result.var), container, EX_CONSTANT(opline->op2), IS_CONST);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_DIM_IS_SPEC_CONST_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *container;

	SAVE_OPLINE();
	container = EX_CONSTANT(opline->op1);
	zend_fetch_dimension_address_read_IS(EX_VAR(opline->result.var), container, EX_CONSTANT(opline->op2), IS_CONST);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_DIM_FUNC_ARG_SPEC_CONST_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *container;
	zend_free_op free_op1;

	SAVE_OPLINE();

	if (zend_is_by_ref_func_arg_fetch(opline, EX(call))) {
        if (IS_CONST == IS_CONST || IS_CONST == IS_TMP_VAR) {
            zend_throw_error(NULL, "Cannot use temporary expression in write context");


			HANDLE_EXCEPTION();
        }
		container = NULL;
		if (IS_CONST == IS_VAR && UNEXPECTED(container == NULL)) {
			zend_throw_error(NULL, "Cannot use string offset as an array");

			HANDLE_EXCEPTION();
		}
		zend_fetch_dimension_address_W(EX_VAR(opline->result.var), container, EX_CONSTANT(opline->op2), IS_CONST);
		if (IS_CONST == IS_VAR && READY_TO_DESTROY(free_op1)) {
			EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 1);
		}


	} else {
		if (IS_CONST == IS_UNUSED) {
			zend_throw_error(NULL, "Cannot use [] for reading");


			HANDLE_EXCEPTION();
		}
		container = EX_CONSTANT(opline->op1);
		zend_fetch_dimension_address_read_R(EX_VAR(opline->result.var), container, EX_CONSTANT(opline->op2), IS_CONST);


	}
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_R_SPEC_CONST_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *container;

	zval *offset;

	SAVE_OPLINE();
	container = EX_CONSTANT(opline->op1);

	if (IS_CONST == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}

	offset = EX_CONSTANT(opline->op2);

	if (IS_CONST == IS_CONST ||
	    (IS_CONST != IS_UNUSED && UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT))) {
		if ((IS_CONST & (IS_VAR|IS_CV)) && Z_ISREF_P(container)) {
			container = Z_REFVAL_P(container);
			if (UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT)) {
				goto fetch_obj_r_no_object;
			}
		} else {
			goto fetch_obj_r_no_object;
		}
	}

	/* here we are sure we are dealing with an object */
	do {
		zend_object *zobj = Z_OBJ_P(container);
		zval *retval;

		if (IS_CONST == IS_CONST &&
			EXPECTED(zobj->ce == CACHED_PTR(Z_CACHE_SLOT_P(offset)))) {
			uint32_t prop_offset = (uint32_t)(intptr_t)CACHED_PTR(Z_CACHE_SLOT_P(offset) + sizeof(void*));

			if (EXPECTED(prop_offset != (uint32_t)ZEND_DYNAMIC_PROPERTY_OFFSET)) {
				retval = OBJ_PROP(zobj, prop_offset);
				if (EXPECTED(Z_TYPE_P(retval) != IS_UNDEF)) {
					ZVAL_COPY(EX_VAR(opline->result.var), retval);
					break;
				}
			} else if (EXPECTED(zobj->properties != NULL)) {
				retval = zend_hash_find(zobj->properties, Z_STR_P(offset));
				if (EXPECTED(retval)) {
					ZVAL_COPY(EX_VAR(opline->result.var), retval);
					break;
				}
			}
		}

		if (UNEXPECTED(zobj->handlers->read_property == NULL)) {
fetch_obj_r_no_object:
			zend_error(E_NOTICE, "Trying to get property of non-object");
			ZVAL_NULL(EX_VAR(opline->result.var));
		} else {
			retval = zobj->handlers->read_property(container, offset, BP_VAR_R, ((IS_CONST == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(offset)) : NULL), EX_VAR(opline->result.var));

			if (retval != EX_VAR(opline->result.var)) {
				ZVAL_COPY(EX_VAR(opline->result.var), retval);
			}
		}
	} while (0);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_IS_SPEC_CONST_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *container;

	zval *offset;

	SAVE_OPLINE();
	container = EX_CONSTANT(opline->op1);

	if (IS_CONST == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}

	offset  = EX_CONSTANT(opline->op2);

	if (IS_CONST == IS_CONST ||
	    (IS_CONST != IS_UNUSED && UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT))) {
		if ((IS_CONST & (IS_VAR|IS_CV)) && Z_ISREF_P(container)) {
			container = Z_REFVAL_P(container);
			if (UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT)) {
				goto fetch_obj_is_no_object;
			}
		} else {
			goto fetch_obj_is_no_object;
		}
	}

	/* here we are sure we are dealing with an object */
	do {
		zend_object *zobj = Z_OBJ_P(container);
		zval *retval;

		if (IS_CONST == IS_CONST &&
			EXPECTED(zobj->ce == CACHED_PTR(Z_CACHE_SLOT_P(offset)))) {
			uint32_t prop_offset = (uint32_t)(intptr_t)CACHED_PTR(Z_CACHE_SLOT_P(offset) + sizeof(void*));

			if (EXPECTED(prop_offset != (uint32_t)ZEND_DYNAMIC_PROPERTY_OFFSET)) {
				retval = OBJ_PROP(zobj, prop_offset);
				if (EXPECTED(Z_TYPE_P(retval) != IS_UNDEF)) {
					ZVAL_COPY(EX_VAR(opline->result.var), retval);
					break;
				}
			} else if (EXPECTED(zobj->properties != NULL)) {
				retval = zend_hash_find(zobj->properties, Z_STR_P(offset));
				if (EXPECTED(retval)) {
					ZVAL_COPY(EX_VAR(opline->result.var), retval);
					break;
				}
			}
		}

		if (UNEXPECTED(zobj->handlers->read_property == NULL)) {
fetch_obj_is_no_object:
			ZVAL_NULL(EX_VAR(opline->result.var));
		} else {

			retval = zobj->handlers->read_property(container, offset, BP_VAR_IS, ((IS_CONST == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(offset)) : NULL), EX_VAR(opline->result.var));

			if (retval != EX_VAR(opline->result.var)) {
				ZVAL_COPY(EX_VAR(opline->result.var), retval);
			}
		}
	} while (0);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_FUNC_ARG_SPEC_CONST_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *container;

	if (zend_is_by_ref_func_arg_fetch(opline, EX(call))) {
		/* Behave like FETCH_OBJ_W */
		zend_free_op free_op1;
		zval *property;

		SAVE_OPLINE();
		property = EX_CONSTANT(opline->op2);
		container = NULL;

		if (IS_CONST == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
			zend_throw_error(NULL, "Using $this when not in object context");

			HANDLE_EXCEPTION();
		}
		if (IS_CONST == IS_CONST || IS_CONST == IS_TMP_VAR) {
			zend_throw_error(NULL, "Cannot use temporary expression in write context");


			HANDLE_EXCEPTION();
		}
		if (IS_CONST == IS_VAR && UNEXPECTED(container == NULL)) {
			zend_throw_error(NULL, "Cannot use string offset as an object");

			HANDLE_EXCEPTION();
		}
		zend_fetch_property_address(EX_VAR(opline->result.var), container, IS_CONST, property, IS_CONST, ((IS_CONST == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), BP_VAR_W);

		if (IS_CONST == IS_VAR && READY_TO_DESTROY(free_op1)) {
			EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 0);
		}

		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	} else {
		ZEND_VM_TAIL_CALL(ZEND_FETCH_OBJ_R_SPEC_CONST_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS_PASSTHRU));
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_LIST_SPEC_CONST_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *container;

	SAVE_OPLINE();
	container = EX_CONSTANT(opline->op1);

try_fetch_list:
	if (EXPECTED(Z_TYPE_P(container) == IS_ARRAY)) {
		zval *value = zend_hash_index_find(Z_ARRVAL_P(container), Z_LVAL_P(EX_CONSTANT(opline->op2)));

		if (UNEXPECTED(value == NULL)) {
			zend_error(E_NOTICE,"Undefined offset: " ZEND_ULONG_FMT, Z_LVAL_P(EX_CONSTANT(opline->op2)));
			ZVAL_NULL(EX_VAR(opline->result.var));
		} else {
			ZVAL_COPY(EX_VAR(opline->result.var), value);
		}
	} else if (IS_CONST != IS_CONST &&
	           UNEXPECTED(Z_TYPE_P(container) == IS_OBJECT) &&
	           EXPECTED(Z_OBJ_HT_P(container)->read_dimension)) {
		zval *result = EX_VAR(opline->result.var);
		zval *retval = Z_OBJ_HT_P(container)->read_dimension(container, EX_CONSTANT(opline->op2), BP_VAR_R, result);

		if (retval) {
			if (result != retval) {
				ZVAL_COPY(result, retval);
			}
		} else {
			ZVAL_NULL(result);
		}
	} else if ((IS_CONST & (IS_VAR|IS_CV)) && Z_TYPE_P(container) == IS_REFERENCE) {
		container = Z_REFVAL_P(container);
		goto try_fetch_list;
	} else {
		if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(container) == IS_UNDEF)) {
			GET_OP1_UNDEF_CV(container, BP_VAR_R);
		}
		ZVAL_NULL(EX_VAR(opline->result.var));
	}
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FAST_CONCAT_SPEC_CONST_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2;
	zend_string *op1_str, *op2_str, *str;

	SAVE_OPLINE();
	op1 = EX_CONSTANT(opline->op1);
	if (IS_CONST == IS_CONST) {
		op1_str = Z_STR_P(op1);
	} else if (EXPECTED(Z_TYPE_P(op1) == IS_STRING)) {
		op1_str = zend_string_copy(Z_STR_P(op1));
	} else {
		if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(op1) == IS_UNDEF)) {
			GET_OP1_UNDEF_CV(op1, BP_VAR_R);
		}
		op1_str = _zval_get_string_func(op1);
	}
	op2 = EX_CONSTANT(opline->op2);
	if (IS_CONST == IS_CONST) {
		op2_str = Z_STR_P(op2);
	} else if (EXPECTED(Z_TYPE_P(op2) == IS_STRING)) {
		op2_str = zend_string_copy(Z_STR_P(op2));
	} else {
		if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(op2) == IS_UNDEF)) {
			GET_OP2_UNDEF_CV(op2, BP_VAR_R);
		}
		op2_str = _zval_get_string_func(op2);
	}
	do {
		if (IS_CONST != IS_CONST) {
			if (UNEXPECTED(ZSTR_LEN(op1_str) == 0)) {
				if (IS_CONST == IS_CONST) {
					zend_string_addref(op2_str);
				}
				ZVAL_STR(EX_VAR(opline->result.var), op2_str);
				zend_string_release(op1_str);
				break;
			}
		}
		if (IS_CONST != IS_CONST) {
			if (UNEXPECTED(ZSTR_LEN(op2_str) == 0)) {
				if (IS_CONST == IS_CONST) {
					zend_string_addref(op1_str);
				}
				ZVAL_STR(EX_VAR(opline->result.var), op1_str);
				zend_string_release(op2_str);
				break;
			}
		}
		str = zend_string_alloc(ZSTR_LEN(op1_str) + ZSTR_LEN(op2_str), 0);
		memcpy(ZSTR_VAL(str), ZSTR_VAL(op1_str), ZSTR_LEN(op1_str));
		memcpy(ZSTR_VAL(str) + ZSTR_LEN(op1_str), ZSTR_VAL(op2_str), ZSTR_LEN(op2_str)+1);
		ZVAL_NEW_STR(EX_VAR(opline->result.var), str);
		if (IS_CONST != IS_CONST) {
			zend_string_release(op1_str);
		}
		if (IS_CONST != IS_CONST) {
			zend_string_release(op2_str);
		}
	} while (0);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_INIT_METHOD_CALL_SPEC_CONST_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *function_name;

	zval *object;
	zend_function *fbc;
	zend_class_entry *called_scope;
	zend_object *obj;
	zend_execute_data *call;
	uint32_t call_info;

	SAVE_OPLINE();

	function_name = EX_CONSTANT(opline->op2);

	if (IS_CONST != IS_CONST &&
	    UNEXPECTED(Z_TYPE_P(function_name) != IS_STRING)) {
		do {
			if ((IS_CONST & (IS_VAR|IS_CV)) && Z_ISREF_P(function_name)) {
				function_name = Z_REFVAL_P(function_name);
				if (EXPECTED(Z_TYPE_P(function_name) == IS_STRING)) {
					break;
				}
			}
			if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(function_name) == IS_UNDEF)) {
				GET_OP2_UNDEF_CV(function_name, BP_VAR_R);
			}
			if (UNEXPECTED(EG(exception) != NULL)) {
				HANDLE_EXCEPTION();
			}
			zend_throw_error(NULL, "Method name must be a string");


			HANDLE_EXCEPTION();
		} while (0);
	}

	object = EX_CONSTANT(opline->op1);

	if (IS_CONST == IS_UNUSED && UNEXPECTED(Z_OBJ_P(object) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}

	if (IS_CONST != IS_UNUSED) {
		do {
			if (IS_CONST == IS_CONST || UNEXPECTED(Z_TYPE_P(object) != IS_OBJECT)) {
				if ((IS_CONST & (IS_VAR|IS_CV)) && EXPECTED(Z_ISREF_P(object))) {
					object = Z_REFVAL_P(object);
					if (EXPECTED(Z_TYPE_P(object) == IS_OBJECT)) {
						break;
					}
				}
				if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(object) == IS_UNDEF)) {
					GET_OP1_UNDEF_CV(object, BP_VAR_R);
				}
				if (UNEXPECTED(EG(exception) != NULL)) {
					HANDLE_EXCEPTION();
				}
				zend_throw_error(NULL, "Call to a member function %s() on %s", Z_STRVAL_P(function_name), zend_get_type_by_const(Z_TYPE_P(object)));


				HANDLE_EXCEPTION();
			}
		} while (0);
	}

	obj = Z_OBJ_P(object);
	called_scope = obj->ce;

	if (IS_CONST != IS_CONST ||
	    UNEXPECTED((fbc = CACHED_POLYMORPHIC_PTR(Z_CACHE_SLOT_P(function_name), called_scope)) == NULL)) {
	    zend_object *orig_obj = obj;

		if (UNEXPECTED(obj->handlers->get_method == NULL)) {
			zend_throw_error(NULL, "Object does not support method calls");


			HANDLE_EXCEPTION();
		}

		/* First, locate the function. */
		fbc = obj->handlers->get_method(&obj, Z_STR_P(function_name), ((IS_CONST == IS_CONST) ? (EX_CONSTANT(opline->op2) + 1) : NULL));
		if (UNEXPECTED(fbc == NULL)) {
			if (EXPECTED(!EG(exception))) {
				zend_throw_error(NULL, "Call to undefined method %s::%s()", ZSTR_VAL(obj->ce->name), Z_STRVAL_P(function_name));
			}


			HANDLE_EXCEPTION();
		}
		if (IS_CONST == IS_CONST &&
		    EXPECTED(fbc->type <= ZEND_USER_FUNCTION) &&
		    EXPECTED(!(fbc->common.fn_flags & (ZEND_ACC_CALL_VIA_TRAMPOLINE|ZEND_ACC_NEVER_CACHE))) &&
		    EXPECTED(obj == orig_obj)) {
			CACHE_POLYMORPHIC_PTR(Z_CACHE_SLOT_P(function_name), called_scope, fbc);
		}
	}

	call_info = ZEND_CALL_NESTED_FUNCTION;
	if (UNEXPECTED((fbc->common.fn_flags & ZEND_ACC_STATIC) != 0)) {
		obj = NULL;
	} else if (IS_CONST & (IS_VAR|IS_TMP_VAR|IS_CV)) {
		/* CV may be changed indirectly (e.g. when it's a reference) */
		call_info = ZEND_CALL_NESTED_FUNCTION | ZEND_CALL_RELEASE_THIS;
		GC_REFCOUNT(obj)++; /* For $this pointer */
	}

	call = zend_vm_stack_push_call_frame(call_info,
		fbc, opline->extended_value, called_scope, obj);
	call->prev_execute_data = EX(call);
	EX(call) = call;


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_INIT_STATIC_METHOD_CALL_SPEC_CONST_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *function_name;
	zend_class_entry *ce;
	zend_object *object;
	zend_function *fbc;
	zend_execute_data *call;

	SAVE_OPLINE();

	if (IS_CONST == IS_CONST) {
		/* no function found. try a static method in class */
		if (EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1))))) {
			ce = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)));
		} else {
			ce = zend_fetch_class_by_name(Z_STR_P(EX_CONSTANT(opline->op1)), EX_CONSTANT(opline->op1) + 1, ZEND_FETCH_CLASS_DEFAULT |  ZEND_FETCH_CLASS_EXCEPTION);
			if (UNEXPECTED(EG(exception) != NULL)) {
				HANDLE_EXCEPTION();
			}
			if (UNEXPECTED(ce == NULL)) {
				zend_throw_error(NULL, "Class '%s' not found", Z_STRVAL_P(EX_CONSTANT(opline->op1)));
				HANDLE_EXCEPTION();
			}
			CACHE_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)), ce);
		}
	} else {
		ce = Z_CE_P(EX_VAR(opline->op1.var));
	}

	if (IS_CONST == IS_CONST &&
	    IS_CONST == IS_CONST &&
	    EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2))))) {
		fbc = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)));
	} else if (IS_CONST != IS_CONST &&
	           IS_CONST == IS_CONST &&
	           (fbc = CACHED_POLYMORPHIC_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)), ce))) {
		/* do nothing */
	} else if (IS_CONST != IS_UNUSED) {


		function_name = EX_CONSTANT(opline->op2);
		if (IS_CONST != IS_CONST) {
			if (UNEXPECTED(Z_TYPE_P(function_name) != IS_STRING)) {
				if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(function_name) == IS_UNDEF)) {
					GET_OP2_UNDEF_CV(function_name, BP_VAR_R);
				}
				if (UNEXPECTED(EG(exception) != NULL)) {
					HANDLE_EXCEPTION();
				}
				zend_throw_error(NULL, "Function name must be a string");

				HANDLE_EXCEPTION();
 			}
		}

		if (ce->get_static_method) {
			fbc = ce->get_static_method(ce, Z_STR_P(function_name));
		} else {
			fbc = zend_std_get_static_method(ce, Z_STR_P(function_name), ((IS_CONST == IS_CONST) ? (EX_CONSTANT(opline->op2) + 1) : NULL));
		}
		if (UNEXPECTED(fbc == NULL)) {
			if (EXPECTED(!EG(exception))) {
				zend_throw_error(NULL, "Call to undefined method %s::%s()", ZSTR_VAL(ce->name), Z_STRVAL_P(function_name));
			}

			HANDLE_EXCEPTION();
		}
		if (IS_CONST == IS_CONST &&
		    EXPECTED(fbc->type <= ZEND_USER_FUNCTION) &&
		    EXPECTED(!(fbc->common.fn_flags & (ZEND_ACC_CALL_VIA_TRAMPOLINE|ZEND_ACC_NEVER_CACHE)))) {
			if (IS_CONST == IS_CONST) {
				CACHE_PTR(Z_CACHE_SLOT_P(function_name), fbc);
			} else {
				CACHE_POLYMORPHIC_PTR(Z_CACHE_SLOT_P(function_name), ce, fbc);
			}
		}
		if (IS_CONST != IS_CONST) {

		}
	} else {
		if (UNEXPECTED(ce->constructor == NULL)) {
			zend_throw_error(NULL, "Cannot call constructor");
			HANDLE_EXCEPTION();
		}
		if (Z_OBJ(EX(This)) && Z_OBJ(EX(This))->ce != ce->constructor->common.scope && (ce->constructor->common.fn_flags & ZEND_ACC_PRIVATE)) {
			zend_throw_error(NULL, "Cannot call private %s::__construct()", ZSTR_VAL(ce->name));
			HANDLE_EXCEPTION();
		}
		fbc = ce->constructor;
	}

	object = NULL;
	if (!(fbc->common.fn_flags & ZEND_ACC_STATIC)) {
		if (Z_OBJ(EX(This)) && instanceof_function(Z_OBJCE(EX(This)), ce)) {
			object = Z_OBJ(EX(This));
		}
		if (!object) {
			if (fbc->common.fn_flags & ZEND_ACC_ALLOW_STATIC) {
				/* Allowed for PHP 4 compatibility. */
				zend_error(
					E_DEPRECATED,
					"Non-static method %s::%s() should not be called statically",
					ZSTR_VAL(fbc->common.scope->name), ZSTR_VAL(fbc->common.function_name));
				if (UNEXPECTED(EG(exception) != NULL)) {
					HANDLE_EXCEPTION();
				}
			} else {
				/* An internal function assumes $this is present and won't check that.
				 * So PHP would crash by allowing the call. */
				zend_throw_error(
					zend_ce_error,
					"Non-static method %s::%s() cannot be called statically",
					ZSTR_VAL(fbc->common.scope->name), ZSTR_VAL(fbc->common.function_name));
				HANDLE_EXCEPTION();
			}
		}
	}

	if (IS_CONST != IS_CONST) {
		/* previous opcode is ZEND_FETCH_CLASS */
		if (((opline-1)->extended_value & ZEND_FETCH_CLASS_MASK) == ZEND_FETCH_CLASS_PARENT ||
		    ((opline-1)->extended_value & ZEND_FETCH_CLASS_MASK) == ZEND_FETCH_CLASS_SELF) {
			ce = EX(called_scope);
		}
	}

	call = zend_vm_stack_push_call_frame(ZEND_CALL_NESTED_FUNCTION,
		fbc, opline->extended_value, ce, object);
	call->prev_execute_data = EX(call);
	EX(call) = call;

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_INIT_USER_CALL_SPEC_CONST_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *function_name;
	zend_fcall_info_cache fcc;
	char *error = NULL;
	zend_function *func;
	zend_class_entry *called_scope;
	zend_object *object;
	zend_execute_data *call;
	uint32_t call_info = ZEND_CALL_NESTED_FUNCTION;

	SAVE_OPLINE();
	function_name = EX_CONSTANT(opline->op2);
	if (zend_is_callable_ex(function_name, NULL, 0, NULL, &fcc, &error)) {
		func = fcc.function_handler;
		if (func->common.fn_flags & ZEND_ACC_CLOSURE) {
			/* Delay closure destruction until its invocation */
			if (IS_CONST & (IS_VAR|IS_CV)) {
				ZVAL_DEREF(function_name);
			}
			ZEND_ASSERT(GC_TYPE((zend_object*)func->common.prototype) == IS_OBJECT);
			GC_REFCOUNT((zend_object*)func->common.prototype)++;
			call_info |= ZEND_CALL_CLOSURE;
		}
		called_scope = fcc.called_scope;
		object = fcc.object;
		if (object) {
			call_info |= ZEND_CALL_RELEASE_THIS;
			GC_REFCOUNT(object)++; /* For $this pointer */
		}
		if (error) {
			efree(error);
			/* This is the only soft error is_callable() can generate */
			zend_error(E_DEPRECATED,
				"Non-static method %s::%s() should not be called statically",
				ZSTR_VAL(func->common.scope->name), ZSTR_VAL(func->common.function_name));
			if (UNEXPECTED(EG(exception) != NULL)) {
				HANDLE_EXCEPTION();
			}
		}
	} else {
		zend_internal_type_error(EX_USES_STRICT_TYPES(), "%s() expects parameter 1 to be a valid callback, %s", Z_STRVAL_P(EX_CONSTANT(opline->op1)), error);
		efree(error);
		func = (zend_function*)&zend_pass_function;
		called_scope = NULL;
		object = NULL;
	}

	call = zend_vm_stack_push_call_frame(call_info,
		func, opline->extended_value, called_scope, object);
	call->prev_execute_data = EX(call);
	EX(call) = call;

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_CASE_SPEC_CONST_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2, *result;

	op1 = EX_CONSTANT(opline->op1);
	op2 = EX_CONSTANT(opline->op2);
	do {
		int result;

		if (EXPECTED(Z_TYPE_P(op1) == IS_LONG)) {
			if (EXPECTED(Z_TYPE_P(op2) == IS_LONG)) {
				result = (Z_LVAL_P(op1) == Z_LVAL_P(op2));
			} else if (EXPECTED(Z_TYPE_P(op2) == IS_DOUBLE)) {
				result = ((double)Z_LVAL_P(op1) == Z_DVAL_P(op2));
			} else {
				break;
			}
		} else if (EXPECTED(Z_TYPE_P(op1) == IS_DOUBLE)) {
			if (EXPECTED(Z_TYPE_P(op2) == IS_DOUBLE)) {
				result = (Z_DVAL_P(op1) == Z_DVAL_P(op2));
			} else if (EXPECTED(Z_TYPE_P(op2) == IS_LONG)) {
				result = (Z_DVAL_P(op1) == ((double)Z_LVAL_P(op2)));
			} else {
				break;
			}
		} else if (EXPECTED(Z_TYPE_P(op1) == IS_STRING)) {
			if (EXPECTED(Z_TYPE_P(op2) == IS_STRING)) {
				if (Z_STR_P(op1) == Z_STR_P(op2)) {
					result = 1;
				} else if (Z_STRVAL_P(op1)[0] > '9' || Z_STRVAL_P(op2)[0] > '9') {
					if (Z_STRLEN_P(op1) != Z_STRLEN_P(op2)) {
						result = 0;
					} else {
						result = (memcmp(Z_STRVAL_P(op1), Z_STRVAL_P(op2), Z_STRLEN_P(op1)) == 0);
					}
				} else {
					result = (zendi_smart_strcmp(op1, op2) == 0);
				}

			} else {
				break;
			}
		} else {
			break;
		}
		ZEND_VM_SMART_BRANCH(result, 0);
		ZVAL_BOOL(EX_VAR(opline->result.var), result);
		ZEND_VM_NEXT_OPCODE();
	} while (0);

	SAVE_OPLINE();
	if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(op1) == IS_UNDEF)) {
		op1 = GET_OP1_UNDEF_CV(op1, BP_VAR_R);
	}
	if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(op2) == IS_UNDEF)) {
		op2 = GET_OP2_UNDEF_CV(op2, BP_VAR_R);
	}
	result = EX_VAR(opline->result.var);
	compare_function(result, op1, op2);
	ZVAL_BOOL(result, Z_LVAL_P(result) == 0);

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_CONSTANT_SPEC_CONST_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	SAVE_OPLINE();
	if (IS_CONST == IS_UNUSED) {
		zend_constant *c;

		if (EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2))))) {
			c = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)));
		} else if ((c = zend_quick_get_constant(EX_CONSTANT(opline->op2) + 1, opline->extended_value)) == NULL) {
			if ((opline->extended_value & IS_CONSTANT_UNQUALIFIED) != 0) {
				char *actual = (char *)zend_memrchr(Z_STRVAL_P(EX_CONSTANT(opline->op2)), '\\', Z_STRLEN_P(EX_CONSTANT(opline->op2)));
				if (!actual) {
					ZVAL_STR_COPY(EX_VAR(opline->result.var), Z_STR_P(EX_CONSTANT(opline->op2)));
				} else {
					actual++;
					ZVAL_STRINGL(EX_VAR(opline->result.var),
							actual, Z_STRLEN_P(EX_CONSTANT(opline->op2)) - (actual - Z_STRVAL_P(EX_CONSTANT(opline->op2))));
				}
				/* non-qualified constant - allow text substitution */
				zend_error(E_NOTICE, "Use of undefined constant %s - assumed '%s'",
						Z_STRVAL_P(EX_VAR(opline->result.var)), Z_STRVAL_P(EX_VAR(opline->result.var)));
				ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
			} else {
				zend_throw_error(NULL, "Undefined constant '%s'", Z_STRVAL_P(EX_CONSTANT(opline->op2)));
				HANDLE_EXCEPTION();
			}
		} else {
			CACHE_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)), c);
		}
#ifdef ZTS
		if (c->flags & CONST_PERSISTENT) {
			ZVAL_DUP(EX_VAR(opline->result.var), &c->value);
		} else {
			ZVAL_COPY(EX_VAR(opline->result.var), &c->value);
		}
#else
		ZVAL_COPY(EX_VAR(opline->result.var), &c->value);
#endif
	} else {
		/* class constant */
		zend_class_entry *ce;
		zval *value;

		do {
			if (IS_CONST == IS_CONST) {
				if (EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2))))) {
					value = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)));
					ZVAL_DEREF(value);
#ifdef ZTS
					ce = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)));
#endif
					break;
				} else if (EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1))))) {
					ce = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)));
				} else {
					ce = zend_fetch_class_by_name(Z_STR_P(EX_CONSTANT(opline->op1)), EX_CONSTANT(opline->op1) + 1, ZEND_FETCH_CLASS_DEFAULT | ZEND_FETCH_CLASS_EXCEPTION);
					if (UNEXPECTED(EG(exception) != NULL)) {
						HANDLE_EXCEPTION();
					}
					if (UNEXPECTED(ce == NULL)) {
						zend_throw_error(NULL, "Class '%s' not found", Z_STRVAL_P(EX_CONSTANT(opline->op1)));
						HANDLE_EXCEPTION();
					}
					CACHE_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)), ce);
				}
			} else {
				ce = Z_CE_P(EX_VAR(opline->op1.var));
				if ((value = CACHED_POLYMORPHIC_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)), ce)) != NULL) {
					ZVAL_DEREF(value);
					break;
				}
			}

			if (EXPECTED((value = zend_hash_find(&ce->constants_table, Z_STR_P(EX_CONSTANT(opline->op2)))) != NULL)) {
				ZVAL_DEREF(value);
				if (Z_CONSTANT_P(value)) {
					EG(scope) = ce;
					zval_update_constant_ex(value, 1, NULL);
					EG(scope) = EX(func)->op_array.scope;
					if (UNEXPECTED(EG(exception) != NULL)) {
						HANDLE_EXCEPTION();
					}
				}
				if (IS_CONST == IS_CONST) {
					CACHE_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)), value);
				} else {
					CACHE_POLYMORPHIC_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)), ce, value);
				}
			} else {
				zend_throw_error(NULL, "Undefined class constant '%s'", Z_STRVAL_P(EX_CONSTANT(opline->op2)));
				HANDLE_EXCEPTION();
			}
		} while (0);
#ifdef ZTS
		if (ce->type == ZEND_INTERNAL_CLASS) {
			ZVAL_DUP(EX_VAR(opline->result.var), value);
		} else {
			ZVAL_COPY(EX_VAR(opline->result.var), value);
		}
#else
		ZVAL_COPY(EX_VAR(opline->result.var), value);
#endif
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ADD_ARRAY_ELEMENT_SPEC_CONST_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *expr_ptr, new_expr;

	SAVE_OPLINE();
	if ((IS_CONST == IS_VAR || IS_CONST == IS_CV) &&
	    UNEXPECTED(opline->extended_value & ZEND_ARRAY_ELEMENT_REF)) {
		expr_ptr = NULL;
		if (IS_CONST == IS_VAR && UNEXPECTED(expr_ptr == NULL)) {
			zend_throw_error(NULL, "Cannot create references to/from string offsets");
			zend_array_destroy(Z_ARRVAL_P(EX_VAR(opline->result.var)));
			HANDLE_EXCEPTION();
		}
		ZVAL_MAKE_REF(expr_ptr);
		Z_ADDREF_P(expr_ptr);

	} else {
		expr_ptr = EX_CONSTANT(opline->op1);
		if (IS_CONST == IS_TMP_VAR) {
			/* pass */
		} else if (IS_CONST == IS_CONST) {
			if (UNEXPECTED(Z_OPT_COPYABLE_P(expr_ptr))) {
				ZVAL_COPY_VALUE(&new_expr, expr_ptr);
				zval_copy_ctor_func(&new_expr);
				expr_ptr = &new_expr;
			}
		} else if (IS_CONST == IS_CV) {
			ZVAL_DEREF(expr_ptr);
			if (Z_REFCOUNTED_P(expr_ptr)) {
				Z_ADDREF_P(expr_ptr);
			}
		} else /* if (IS_CONST == IS_VAR) */ {
			if (UNEXPECTED(Z_ISREF_P(expr_ptr))) {
				zend_refcounted *ref = Z_COUNTED_P(expr_ptr);

				expr_ptr = Z_REFVAL_P(expr_ptr);
				if (UNEXPECTED(--GC_REFCOUNT(ref) == 0)) {
					ZVAL_COPY_VALUE(&new_expr, expr_ptr);
					expr_ptr = &new_expr;
					efree_size(ref, sizeof(zend_reference));
				} else if (Z_OPT_REFCOUNTED_P(expr_ptr)) {
					Z_ADDREF_P(expr_ptr);
				}
			}
		}
	}

	if (IS_CONST != IS_UNUSED) {

		zval *offset = EX_CONSTANT(opline->op2);
		zend_string *str;
		zend_ulong hval;

add_again:
		if (EXPECTED(Z_TYPE_P(offset) == IS_STRING)) {
			str = Z_STR_P(offset);
			if (IS_CONST != IS_CONST) {
				if (ZEND_HANDLE_NUMERIC(str, hval)) {
					goto num_index;
				}
			}
str_index:
			zend_hash_update(Z_ARRVAL_P(EX_VAR(opline->result.var)), str, expr_ptr);
		} else if (EXPECTED(Z_TYPE_P(offset) == IS_LONG)) {
			hval = Z_LVAL_P(offset);
num_index:
			zend_hash_index_update(Z_ARRVAL_P(EX_VAR(opline->result.var)), hval, expr_ptr);
		} else if ((IS_CONST & (IS_VAR|IS_CV)) && EXPECTED(Z_TYPE_P(offset) == IS_REFERENCE)) {
			offset = Z_REFVAL_P(offset);
			goto add_again;
		} else if (Z_TYPE_P(offset) == IS_NULL) {
			str = ZSTR_EMPTY_ALLOC();
			goto str_index;
		} else if (Z_TYPE_P(offset) == IS_DOUBLE) {
			hval = zend_dval_to_lval(Z_DVAL_P(offset));
			goto num_index;
		} else if (Z_TYPE_P(offset) == IS_FALSE) {
			hval = 0;
			goto num_index;
		} else if (Z_TYPE_P(offset) == IS_TRUE) {
			hval = 1;
			goto num_index;
		} else if (IS_CONST == IS_CV && Z_TYPE_P(offset) == IS_UNDEF) {
			GET_OP2_UNDEF_CV(offset, BP_VAR_R);
			str = ZSTR_EMPTY_ALLOC();
			goto str_index;
		} else {
			zend_error(E_WARNING, "Illegal offset type");
			zval_ptr_dtor(expr_ptr);
		}

	} else {
		zend_hash_next_index_insert(Z_ARRVAL_P(EX_VAR(opline->result.var)), expr_ptr);
	}
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_INIT_ARRAY_SPEC_CONST_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	zval *array;
	uint32_t size;
	USE_OPLINE

	array = EX_VAR(opline->result.var);
	if (IS_CONST != IS_UNUSED) {
		size = opline->extended_value >> ZEND_ARRAY_SIZE_SHIFT;
	} else {
		size = 0;
	}
	ZVAL_NEW_ARR(array);
	zend_hash_init(Z_ARRVAL_P(array), size, NULL, ZVAL_PTR_DTOR, 0);

	if (IS_CONST != IS_UNUSED) {
		/* Explicitly initialize array as not-packed if flag is set */
		if (opline->extended_value & ZEND_ARRAY_NOT_PACKED) {
			zend_hash_real_init(Z_ARRVAL_P(array), 0);
		}
	}

	if (IS_CONST == IS_UNUSED) {
		ZEND_VM_NEXT_OPCODE();
#if 0 || (IS_CONST != IS_UNUSED)
	} else {
		ZEND_VM_TAIL_CALL(ZEND_ADD_ARRAY_ELEMENT_SPEC_CONST_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS_PASSTHRU));
#endif
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_UNSET_VAR_SPEC_CONST_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval tmp, *varname;
	HashTable *target_symbol_table;


	SAVE_OPLINE();
	if (IS_CONST == IS_CV &&
	    IS_CONST == IS_UNUSED &&
	    (opline->extended_value & ZEND_QUICK_SET)) {
		zval *var = EX_VAR(opline->op1.var);

		if (Z_REFCOUNTED_P(var)) {
			zend_refcounted *garbage = Z_COUNTED_P(var);

			if (!--GC_REFCOUNT(garbage)) {
				ZVAL_UNDEF(var);
				zval_dtor_func_for_ptr(garbage);
			} else {
				GC_ZVAL_CHECK_POSSIBLE_ROOT(var);
				ZVAL_UNDEF(var);
			}
		} else {
			ZVAL_UNDEF(var);
		}
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}

	varname = EX_CONSTANT(opline->op1);

	ZVAL_UNDEF(&tmp);
	if (IS_CONST != IS_CONST && Z_TYPE_P(varname) != IS_STRING) {
		if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(varname) == IS_UNDEF)) {
			varname = GET_OP1_UNDEF_CV(varname, BP_VAR_R);
		}
		ZVAL_STR(&tmp, zval_get_string(varname));
		varname = &tmp;
	}

	if (IS_CONST != IS_UNUSED) {
		zend_class_entry *ce;

		if (IS_CONST == IS_CONST) {
			if (EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2))))) {
				ce = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)));
			} else {
				ce = zend_fetch_class_by_name(Z_STR_P(EX_CONSTANT(opline->op2)), EX_CONSTANT(opline->op2) + 1, ZEND_FETCH_CLASS_DEFAULT | ZEND_FETCH_CLASS_EXCEPTION);
				if (UNEXPECTED(EG(exception) != NULL)) {
					if (IS_CONST != IS_CONST && Z_TYPE(tmp) != IS_UNDEF) {
						zend_string_release(Z_STR(tmp));
					}

					HANDLE_EXCEPTION();
				}
				if (UNEXPECTED(ce == NULL)) {
					zend_throw_error(NULL, "Class '%s' not found", Z_STRVAL_P(EX_CONSTANT(opline->op2)));
					if (IS_CONST != IS_CONST) {
						zend_string_release(Z_STR(tmp));
					}
					HANDLE_EXCEPTION();
				}
				CACHE_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)), ce);
			}
		} else {
			ce = Z_CE_P(EX_VAR(opline->op2.var));
		}
		zend_std_unset_static_property(ce, Z_STR_P(varname));
	} else {
		target_symbol_table = zend_get_target_symbol_table(execute_data, opline->extended_value & ZEND_FETCH_TYPE_MASK);
		zend_hash_del_ind(target_symbol_table, Z_STR_P(varname));
	}

	if (IS_CONST != IS_CONST && Z_TYPE(tmp) != IS_UNDEF) {
		zend_string_release(Z_STR(tmp));
	}

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ISSET_ISEMPTY_VAR_SPEC_CONST_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *value;
	int result;

	if (IS_CONST == IS_CV &&
	    IS_CONST == IS_UNUSED &&
	    (opline->extended_value & ZEND_QUICK_SET)) {
		value = EX_VAR(opline->op1.var);
		if (opline->extended_value & ZEND_ISSET) {
			result =
				Z_TYPE_P(value) > IS_NULL &&
			    (!Z_ISREF_P(value) || Z_TYPE_P(Z_REFVAL_P(value)) != IS_NULL);
		} else /* if (opline->extended_value & ZEND_ISEMPTY) */ {
			SAVE_OPLINE();
			result = !i_zend_is_true(value);
			if (UNEXPECTED(EG(exception))) {
				HANDLE_EXCEPTION();
			}
		}
		ZEND_VM_SMART_BRANCH(result, 0);
		ZVAL_BOOL(EX_VAR(opline->result.var), result);
		ZEND_VM_SET_NEXT_OPCODE(opline + 1);
		ZEND_VM_CONTINUE();
	} else {

		zval tmp, *varname;

		SAVE_OPLINE();
		varname = EX_CONSTANT(opline->op1);
		ZVAL_UNDEF(&tmp);
		if (IS_CONST != IS_CONST && Z_TYPE_P(varname) != IS_STRING) {
			ZVAL_STR(&tmp, zval_get_string(varname));
			varname = &tmp;
		}

		if (IS_CONST != IS_UNUSED) {
			zend_class_entry *ce;

			if (IS_CONST == IS_CONST) {
				if (IS_CONST == IS_CONST && EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1))))) {

					ce = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)));
					value = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)) + sizeof(void*));

					/* check if static properties were destoyed */
					if (UNEXPECTED(CE_STATIC_MEMBERS(ce) == NULL)) {
						value = NULL;
					}

					goto is_var_return;
				} else if (EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2))))) {
					ce = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)));
				} else {
					ce = zend_fetch_class_by_name(Z_STR_P(EX_CONSTANT(opline->op2)), EX_CONSTANT(opline->op2) + 1, ZEND_FETCH_CLASS_DEFAULT | ZEND_FETCH_CLASS_EXCEPTION);
					if (UNEXPECTED(ce == NULL)) {
						ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
					}
					CACHE_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)), ce);
				}
			} else {
				ce = Z_CE_P(EX_VAR(opline->op2.var));
				if (IS_CONST == IS_CONST &&
				    (value = CACHED_POLYMORPHIC_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)), ce)) != NULL) {

					/* check if static properties were destoyed */
					if (UNEXPECTED(CE_STATIC_MEMBERS(ce) == NULL)) {
						value = NULL;
					}

					goto is_var_return;
				}
			}

			value = zend_std_get_static_property(ce, Z_STR_P(varname), 1);

			if (IS_CONST == IS_CONST && value) {
				CACHE_POLYMORPHIC_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)), ce, value);
			}
		} else {
			HashTable *target_symbol_table = zend_get_target_symbol_table(execute_data, opline->extended_value & ZEND_FETCH_TYPE_MASK);
			value = zend_hash_find_ind(target_symbol_table, Z_STR_P(varname));
		}

		if (IS_CONST != IS_CONST && Z_TYPE(tmp) != IS_UNDEF) {
			zend_string_release(Z_STR(tmp));
		}

is_var_return:
		if (opline->extended_value & ZEND_ISSET) {
			result = value && Z_TYPE_P(value) > IS_NULL &&
			    (!Z_ISREF_P(value) || Z_TYPE_P(Z_REFVAL_P(value)) != IS_NULL);
		} else /* if (opline->extended_value & ZEND_ISEMPTY) */ {
			result = !value || !i_zend_is_true(value);
		}

		ZEND_VM_SMART_BRANCH(result, 1);
		ZVAL_BOOL(EX_VAR(opline->result.var), result);
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ISSET_ISEMPTY_DIM_OBJ_SPEC_CONST_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *container;
	int result;
	zend_ulong hval;
	zval *offset;

	SAVE_OPLINE();
	container = EX_CONSTANT(opline->op1);

	if (IS_CONST == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}

	offset = EX_CONSTANT(opline->op2);

	if (IS_CONST != IS_UNUSED && EXPECTED(Z_TYPE_P(container) == IS_ARRAY)) {
		HashTable *ht;
		zval *value;
		zend_string *str;

isset_dim_obj_array:
		ht = Z_ARRVAL_P(container);
isset_again:
		if (EXPECTED(Z_TYPE_P(offset) == IS_STRING)) {
			str = Z_STR_P(offset);
			if (IS_CONST != IS_CONST) {
				if (ZEND_HANDLE_NUMERIC(str, hval)) {
					goto num_index_prop;
				}
			}
str_index_prop:
			value = zend_hash_find_ind(ht, str);
		} else if (EXPECTED(Z_TYPE_P(offset) == IS_LONG)) {
			hval = Z_LVAL_P(offset);
num_index_prop:
			value = zend_hash_index_find(ht, hval);
		} else if ((IS_CONST & (IS_VAR|IS_CV)) && EXPECTED(Z_ISREF_P(offset))) {
			offset = Z_REFVAL_P(offset);
			goto isset_again;
		} else if (Z_TYPE_P(offset) == IS_DOUBLE) {
			hval = zend_dval_to_lval(Z_DVAL_P(offset));
			goto num_index_prop;
		} else if (Z_TYPE_P(offset) == IS_NULL) {
			str = ZSTR_EMPTY_ALLOC();
			goto str_index_prop;
		} else if (Z_TYPE_P(offset) == IS_FALSE) {
			hval = 0;
			goto num_index_prop;
		} else if (Z_TYPE_P(offset) == IS_TRUE) {
			hval = 1;
			goto num_index_prop;
		} else if (Z_TYPE_P(offset) == IS_RESOURCE) {
			hval = Z_RES_HANDLE_P(offset);
			goto num_index_prop;
		} else if (IS_CONST == IS_CV && Z_TYPE_P(offset) == IS_UNDEF) {
			GET_OP2_UNDEF_CV(offset, BP_VAR_R);
			str = ZSTR_EMPTY_ALLOC();
			goto str_index_prop;
		} else {
			zend_error(E_WARNING, "Illegal offset type in isset or empty");
			goto isset_not_found;
		}

		if (opline->extended_value & ZEND_ISSET) {
			/* > IS_NULL means not IS_UNDEF and not IS_NULL */
			result = value != NULL && Z_TYPE_P(value) > IS_NULL &&
			    (!Z_ISREF_P(value) || Z_TYPE_P(Z_REFVAL_P(value)) != IS_NULL);
		} else /* if (opline->extended_value & ZEND_ISEMPTY) */ {
			result = (value == NULL || !i_zend_is_true(value));
		}
		goto isset_dim_obj_exit;
	} else if ((IS_CONST & (IS_VAR|IS_CV)) && Z_ISREF_P(container)) {
		container = Z_REFVAL_P(container);
		if (EXPECTED(Z_TYPE_P(container) == IS_ARRAY)) {
			goto isset_dim_obj_array;
		}
	}

	if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(offset) == IS_UNDEF)) {
		offset = GET_OP2_UNDEF_CV(offset, BP_VAR_R);
	}

	if (IS_CONST == IS_UNUSED ||
	    (IS_CONST != IS_CONST && EXPECTED(Z_TYPE_P(container) == IS_OBJECT))) {
		if (EXPECTED(Z_OBJ_HT_P(container)->has_dimension)) {
			result =
				((opline->extended_value & ZEND_ISSET) == 0) ^
				Z_OBJ_HT_P(container)->has_dimension(container, offset, (opline->extended_value & ZEND_ISSET) == 0);
		} else {
			zend_error(E_NOTICE, "Trying to check element of non-array");
			goto isset_not_found;
		}
	} else if (EXPECTED(Z_TYPE_P(container) == IS_STRING)) { /* string offsets */
		zend_long lval;

		if (EXPECTED(Z_TYPE_P(offset) == IS_LONG)) {
			lval = Z_LVAL_P(offset);
isset_str_offset:
			if (EXPECTED(lval >= 0) && (size_t)lval < Z_STRLEN_P(container)) {
				if (opline->extended_value & ZEND_ISSET) {
					result = 1;
				} else {
					result = (Z_STRVAL_P(container)[lval] == '0');
				}
			} else {
				goto isset_not_found;
			}
		} else {
			if (IS_CONST & (IS_CV|IS_VAR)) {
				ZVAL_DEREF(offset);
			}
			if (Z_TYPE_P(offset) < IS_STRING /* simple scalar types */
					|| (Z_TYPE_P(offset) == IS_STRING /* or numeric string */
						&& IS_LONG == is_numeric_string(Z_STRVAL_P(offset), Z_STRLEN_P(offset), NULL, NULL, 0))) {
				lval = zval_get_long(offset);
				goto isset_str_offset;
			}
			goto isset_not_found;
		}
	} else {
isset_not_found:
		result = ((opline->extended_value & ZEND_ISSET) == 0);
	}

isset_dim_obj_exit:


	ZEND_VM_SMART_BRANCH(result, 1);
	ZVAL_BOOL(EX_VAR(opline->result.var), result);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ISSET_ISEMPTY_PROP_OBJ_SPEC_CONST_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *container;
	int result;
	zval *offset;

	SAVE_OPLINE();
	container = EX_CONSTANT(opline->op1);

	if (IS_CONST == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}

	offset = EX_CONSTANT(opline->op2);

	if (IS_CONST == IS_CONST ||
	    (IS_CONST != IS_UNUSED && UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT))) {
		if ((IS_CONST & (IS_VAR|IS_CV)) && Z_ISREF_P(container)) {
			container = Z_REFVAL_P(container);
			if (UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT)) {
				goto isset_no_object;
			}
		} else {
			goto isset_no_object;
		}
	}
	if (UNEXPECTED(!Z_OBJ_HT_P(container)->has_property)) {
		zend_error(E_NOTICE, "Trying to check property of non-object");
isset_no_object:
		result = ((opline->extended_value & ZEND_ISSET) == 0);
	} else {
		result =
			((opline->extended_value & ZEND_ISSET) == 0) ^
			Z_OBJ_HT_P(container)->has_property(container, offset, (opline->extended_value & ZEND_ISSET) == 0, ((IS_CONST == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(offset)) : NULL));
	}


	ZEND_VM_SMART_BRANCH(result, 1);
	ZVAL_BOOL(EX_VAR(opline->result.var), result);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_DECLARE_CONST_SPEC_CONST_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *name;
	zval *val;
	zend_constant c;

	SAVE_OPLINE();
	name  = EX_CONSTANT(opline->op1);
	val   = EX_CONSTANT(opline->op2);

	ZVAL_COPY_VALUE(&c.value, val);
	if (Z_OPT_CONSTANT(c.value)) {
		if (UNEXPECTED(zval_update_constant_ex(&c.value, 0, NULL) != SUCCESS)) {


			HANDLE_EXCEPTION();
		}
	} else {
		/* IS_CONST can't be IS_OBJECT, IS_RESOURCE or IS_REFERENCE */
		if (UNEXPECTED(Z_OPT_COPYABLE(c.value))) {
			zval_copy_ctor_func(&c.value);
		}
	}
	c.flags = CONST_CS; /* non persistent, case sensetive */
	c.name = zend_string_dup(Z_STR_P(name), 0);
	c.module_number = PHP_USER_CONSTANT;

	if (zend_register_constant(&c) == FAILURE) {
	}


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_YIELD_SPEC_CONST_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zend_generator *generator = zend_get_running_generator(execute_data);

	SAVE_OPLINE();
	if (UNEXPECTED(generator->flags & ZEND_GENERATOR_FORCED_CLOSE)) {
		zend_throw_error(NULL, "Cannot yield from finally in a force-closed generator");


		HANDLE_EXCEPTION();
	}

	/* Destroy the previously yielded value */
	zval_ptr_dtor(&generator->value);

	/* Destroy the previously yielded key */
	zval_ptr_dtor(&generator->key);

	/* Set the new yielded value */
	if (IS_CONST != IS_UNUSED) {


		if (UNEXPECTED(EX(func)->op_array.fn_flags & ZEND_ACC_RETURN_REFERENCE)) {
			/* Constants and temporary variables aren't yieldable by reference,
			 * but we still allow them with a notice. */
			if (IS_CONST == IS_CONST || IS_CONST == IS_TMP_VAR) {
				zval *value;

				zend_error(E_NOTICE, "Only variable references should be yielded by reference");

				value = EX_CONSTANT(opline->op1);
				ZVAL_COPY_VALUE(&generator->value, value);
				if (IS_CONST != IS_CONST) {
					if (UNEXPECTED(Z_OPT_COPYABLE(generator->value))) {
						zval_copy_ctor_func(&generator->value);
					}
				}
			} else {
				zval *value_ptr = NULL;

				if (IS_CONST == IS_VAR && UNEXPECTED(value_ptr == NULL)) {
					zend_throw_error(NULL, "Cannot yield string offsets by reference");

					HANDLE_EXCEPTION();
				}

				/* If a function call result is yielded and the function did
				 * not return by reference we throw a notice. */
				if (IS_CONST == IS_VAR &&
				    (value_ptr == &EG(uninitialized_zval) ||
				     (opline->extended_value == ZEND_RETURNS_FUNCTION &&
				      !(Z_VAR_FLAGS_P(value_ptr) & IS_VAR_RET_REF)))) {
					zend_error(E_NOTICE, "Only variable references should be yielded by reference");
				} else {
					ZVAL_MAKE_REF(value_ptr);
				}
				ZVAL_COPY(&generator->value, value_ptr);

			}
		} else {
			zval *value = EX_CONSTANT(opline->op1);

			/* Consts, temporary variables and references need copying */
			if (IS_CONST == IS_CONST) {
				ZVAL_COPY_VALUE(&generator->value, value);
				if (UNEXPECTED(Z_OPT_COPYABLE(generator->value))) {
					zval_copy_ctor_func(&generator->value);
				}
			} else if (IS_CONST == IS_TMP_VAR) {
				ZVAL_COPY_VALUE(&generator->value, value);
            } else if ((IS_CONST & (IS_VAR|IS_CV)) && Z_ISREF_P(value)) {
				ZVAL_COPY(&generator->value, Z_REFVAL_P(value));

			} else {
				ZVAL_COPY_VALUE(&generator->value, value);
				if (IS_CONST == IS_CV) {
					if (Z_OPT_REFCOUNTED_P(value)) Z_ADDREF_P(value);
				}
			}
		}
	} else {
		/* If no value was specified yield null */
		ZVAL_NULL(&generator->value);
	}

	/* Set the new yielded key */
	if (IS_CONST != IS_UNUSED) {

		zval *key = EX_CONSTANT(opline->op2);

		/* Consts, temporary variables and references need copying */
		if (IS_CONST == IS_CONST) {
			ZVAL_COPY_VALUE(&generator->key, key);
			if (UNEXPECTED(Z_OPT_COPYABLE(generator->key))) {
				zval_copy_ctor_func(&generator->key);
			}
		} else if (IS_CONST == IS_TMP_VAR) {
			ZVAL_COPY_VALUE(&generator->key, key);
		} else if ((IS_CONST & (IS_VAR|IS_CV)) && Z_ISREF_P(key)) {
			ZVAL_COPY(&generator->key, Z_REFVAL_P(key));

		} else {
			ZVAL_COPY_VALUE(&generator->key, key);
			if (IS_CONST == IS_CV) {
				if (Z_OPT_REFCOUNTED_P(key)) Z_ADDREF_P(key);
			}
		}

		if (Z_TYPE(generator->key) == IS_LONG
		    && Z_LVAL(generator->key) > generator->largest_used_integer_key
		) {
			generator->largest_used_integer_key = Z_LVAL(generator->key);
		}
	} else {
		/* If no key was specified we use auto-increment keys */
		generator->largest_used_integer_key++;
		ZVAL_LONG(&generator->key, generator->largest_used_integer_key);
	}

	if (RETURN_VALUE_USED(opline)) {
		/* If the return value of yield is used set the send
		 * target and initialize it to NULL */
		generator->send_target = EX_VAR(opline->result.var);
		ZVAL_NULL(generator->send_target);
	} else {
		generator->send_target = NULL;
	}

	/* We increment to the next op, so we are at the correct position when the
	 * generator is resumed. */
	ZEND_VM_INC_OPCODE();

	/* The GOTO VM uses a local opline variable. We need to set the opline
	 * variable in execute_data so we don't resume at an old position. */
	SAVE_OPLINE();

	ZEND_VM_RETURN();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_POW_SPEC_CONST_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2;

	SAVE_OPLINE();
	op1 = EX_CONSTANT(opline->op1);
	op2 = EX_CONSTANT(opline->op2);
	pow_function(EX_VAR(opline->result.var), op1, op2);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_IS_IDENTICAL_SPEC_CONST_TMP_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op2;
	zval *op1, *op2;
	int result;

	SAVE_OPLINE();
	op1 = EX_CONSTANT(opline->op1);
	op2 = _get_zval_ptr_tmp(opline->op2.var, execute_data, &free_op2);
	result = fast_is_identical_function(op1, op2);

	zval_ptr_dtor_nogc(free_op2);
	ZEND_VM_SMART_BRANCH(result, (IS_CONST|IS_TMP_VAR) & (IS_VAR|IS_TMP_VAR));
	ZVAL_BOOL(EX_VAR(opline->result.var), result);
	if ((IS_CONST|IS_TMP_VAR) & (IS_VAR|IS_TMP_VAR)) {
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_IS_NOT_IDENTICAL_SPEC_CONST_TMP_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op2;
	zval *op1, *op2;
	int result;

	SAVE_OPLINE();
	op1 = EX_CONSTANT(opline->op1);
	op2 = _get_zval_ptr_tmp(opline->op2.var, execute_data, &free_op2);
	result = fast_is_not_identical_function(op1, op2);

	zval_ptr_dtor_nogc(free_op2);
	ZEND_VM_SMART_BRANCH(result, (IS_CONST|IS_TMP_VAR) & (IS_VAR|IS_TMP_VAR));
	ZVAL_BOOL(EX_VAR(opline->result.var), result);
	if ((IS_CONST|IS_TMP_VAR) & (IS_VAR|IS_TMP_VAR)) {
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_YIELD_SPEC_CONST_TMP_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zend_generator *generator = zend_get_running_generator(execute_data);

	SAVE_OPLINE();
	if (UNEXPECTED(generator->flags & ZEND_GENERATOR_FORCED_CLOSE)) {
		zend_throw_error(NULL, "Cannot yield from finally in a force-closed generator");
		zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));

		HANDLE_EXCEPTION();
	}

	/* Destroy the previously yielded value */
	zval_ptr_dtor(&generator->value);

	/* Destroy the previously yielded key */
	zval_ptr_dtor(&generator->key);

	/* Set the new yielded value */
	if (IS_CONST != IS_UNUSED) {


		if (UNEXPECTED(EX(func)->op_array.fn_flags & ZEND_ACC_RETURN_REFERENCE)) {
			/* Constants and temporary variables aren't yieldable by reference,
			 * but we still allow them with a notice. */
			if (IS_CONST == IS_CONST || IS_CONST == IS_TMP_VAR) {
				zval *value;

				zend_error(E_NOTICE, "Only variable references should be yielded by reference");

				value = EX_CONSTANT(opline->op1);
				ZVAL_COPY_VALUE(&generator->value, value);
				if (IS_CONST != IS_CONST) {
					if (UNEXPECTED(Z_OPT_COPYABLE(generator->value))) {
						zval_copy_ctor_func(&generator->value);
					}
				}
			} else {
				zval *value_ptr = NULL;

				if (IS_CONST == IS_VAR && UNEXPECTED(value_ptr == NULL)) {
					zend_throw_error(NULL, "Cannot yield string offsets by reference");
					zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
					HANDLE_EXCEPTION();
				}

				/* If a function call result is yielded and the function did
				 * not return by reference we throw a notice. */
				if (IS_CONST == IS_VAR &&
				    (value_ptr == &EG(uninitialized_zval) ||
				     (opline->extended_value == ZEND_RETURNS_FUNCTION &&
				      !(Z_VAR_FLAGS_P(value_ptr) & IS_VAR_RET_REF)))) {
					zend_error(E_NOTICE, "Only variable references should be yielded by reference");
				} else {
					ZVAL_MAKE_REF(value_ptr);
				}
				ZVAL_COPY(&generator->value, value_ptr);

			}
		} else {
			zval *value = EX_CONSTANT(opline->op1);

			/* Consts, temporary variables and references need copying */
			if (IS_CONST == IS_CONST) {
				ZVAL_COPY_VALUE(&generator->value, value);
				if (UNEXPECTED(Z_OPT_COPYABLE(generator->value))) {
					zval_copy_ctor_func(&generator->value);
				}
			} else if (IS_CONST == IS_TMP_VAR) {
				ZVAL_COPY_VALUE(&generator->value, value);
            } else if ((IS_CONST & (IS_VAR|IS_CV)) && Z_ISREF_P(value)) {
				ZVAL_COPY(&generator->value, Z_REFVAL_P(value));

			} else {
				ZVAL_COPY_VALUE(&generator->value, value);
				if (IS_CONST == IS_CV) {
					if (Z_OPT_REFCOUNTED_P(value)) Z_ADDREF_P(value);
				}
			}
		}
	} else {
		/* If no value was specified yield null */
		ZVAL_NULL(&generator->value);
	}

	/* Set the new yielded key */
	if (IS_TMP_VAR != IS_UNUSED) {
		zend_free_op free_op2;
		zval *key = _get_zval_ptr_tmp(opline->op2.var, execute_data, &free_op2);

		/* Consts, temporary variables and references need copying */
		if (IS_TMP_VAR == IS_CONST) {
			ZVAL_COPY_VALUE(&generator->key, key);
			if (UNEXPECTED(Z_OPT_COPYABLE(generator->key))) {
				zval_copy_ctor_func(&generator->key);
			}
		} else if (IS_TMP_VAR == IS_TMP_VAR) {
			ZVAL_COPY_VALUE(&generator->key, key);
		} else if ((IS_TMP_VAR & (IS_VAR|IS_CV)) && Z_ISREF_P(key)) {
			ZVAL_COPY(&generator->key, Z_REFVAL_P(key));

		} else {
			ZVAL_COPY_VALUE(&generator->key, key);
			if (IS_TMP_VAR == IS_CV) {
				if (Z_OPT_REFCOUNTED_P(key)) Z_ADDREF_P(key);
			}
		}

		if (Z_TYPE(generator->key) == IS_LONG
		    && Z_LVAL(generator->key) > generator->largest_used_integer_key
		) {
			generator->largest_used_integer_key = Z_LVAL(generator->key);
		}
	} else {
		/* If no key was specified we use auto-increment keys */
		generator->largest_used_integer_key++;
		ZVAL_LONG(&generator->key, generator->largest_used_integer_key);
	}

	if (RETURN_VALUE_USED(opline)) {
		/* If the return value of yield is used set the send
		 * target and initialize it to NULL */
		generator->send_target = EX_VAR(opline->result.var);
		ZVAL_NULL(generator->send_target);
	} else {
		generator->send_target = NULL;
	}

	/* We increment to the next op, so we are at the correct position when the
	 * generator is resumed. */
	ZEND_VM_INC_OPCODE();

	/* The GOTO VM uses a local opline variable. We need to set the opline
	 * variable in execute_data so we don't resume at an old position. */
	SAVE_OPLINE();

	ZEND_VM_RETURN();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_IS_IDENTICAL_SPEC_CONST_VAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op2;
	zval *op1, *op2;
	int result;

	SAVE_OPLINE();
	op1 = EX_CONSTANT(opline->op1);
	op2 = _get_zval_ptr_var_deref(opline->op2.var, execute_data, &free_op2);
	result = fast_is_identical_function(op1, op2);

	zval_ptr_dtor_nogc(free_op2);
	ZEND_VM_SMART_BRANCH(result, (IS_CONST|IS_VAR) & (IS_VAR|IS_TMP_VAR));
	ZVAL_BOOL(EX_VAR(opline->result.var), result);
	if ((IS_CONST|IS_VAR) & (IS_VAR|IS_TMP_VAR)) {
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_IS_NOT_IDENTICAL_SPEC_CONST_VAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op2;
	zval *op1, *op2;
	int result;

	SAVE_OPLINE();
	op1 = EX_CONSTANT(opline->op1);
	op2 = _get_zval_ptr_var_deref(opline->op2.var, execute_data, &free_op2);
	result = fast_is_not_identical_function(op1, op2);

	zval_ptr_dtor_nogc(free_op2);
	ZEND_VM_SMART_BRANCH(result, (IS_CONST|IS_VAR) & (IS_VAR|IS_TMP_VAR));
	ZVAL_BOOL(EX_VAR(opline->result.var), result);
	if ((IS_CONST|IS_VAR) & (IS_VAR|IS_TMP_VAR)) {
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL zend_fetch_var_address_helper_SPEC_CONST_VAR(int type ZEND_OPCODE_HANDLER_ARGS_DC)
{
	USE_OPLINE

	zval *varname;
	zval *retval;
	zend_string *name;
	HashTable *target_symbol_table;

	SAVE_OPLINE();
	varname = EX_CONSTANT(opline->op1);

 	if (IS_CONST == IS_CONST) {
		name = Z_STR_P(varname);
	} else if (EXPECTED(Z_TYPE_P(varname) == IS_STRING)) {
		name = Z_STR_P(varname);
		zend_string_addref(name);
	} else {
		if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(varname) == IS_UNDEF)) {
			GET_OP1_UNDEF_CV(varname, BP_VAR_R);
		}
		name = zval_get_string(varname);
	}

	if (IS_VAR != IS_UNUSED) {
		zend_class_entry *ce;

		if (IS_VAR == IS_CONST) {
			if (IS_CONST == IS_CONST && EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1))))) {

				ce = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)));
				retval = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)) + sizeof(void*));

				/* check if static properties were destoyed */
				if (UNEXPECTED(CE_STATIC_MEMBERS(ce) == NULL)) {
					zend_throw_error(NULL, "Access to undeclared static property: %s::$%s", ZSTR_VAL(ce->name), ZSTR_VAL(name));

					HANDLE_EXCEPTION();
				}

				goto fetch_var_return;
			} else if (EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2))))) {
				ce = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)));
			} else {
				ce = zend_fetch_class_by_name(Z_STR_P(EX_CONSTANT(opline->op2)), EX_CONSTANT(opline->op2) + 1, ZEND_FETCH_CLASS_DEFAULT | ZEND_FETCH_CLASS_EXCEPTION);
				if (UNEXPECTED(ce == NULL)) {
					if (IS_CONST != IS_CONST) {
						zend_string_release(name);
					}

					ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
				}
				CACHE_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)), ce);
			}
		} else {
			ce = Z_CE_P(EX_VAR(opline->op2.var));
			if (IS_CONST == IS_CONST &&
			    (retval = CACHED_POLYMORPHIC_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)), ce)) != NULL) {

				/* check if static properties were destoyed */
				if (UNEXPECTED(CE_STATIC_MEMBERS(ce) == NULL)) {
					zend_throw_error(NULL, "Access to undeclared static property: %s::$%s", ZSTR_VAL(ce->name), ZSTR_VAL(name));

					HANDLE_EXCEPTION();
				}

				goto fetch_var_return;
			}
		}
		retval = zend_std_get_static_property(ce, name, 0);
		if (UNEXPECTED(EG(exception))) {

			HANDLE_EXCEPTION();
		}
		if (IS_CONST == IS_CONST && retval) {
			CACHE_POLYMORPHIC_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)), ce, retval);
		}

	} else {
		target_symbol_table = zend_get_target_symbol_table(execute_data, opline->extended_value & ZEND_FETCH_TYPE_MASK);
		retval = zend_hash_find(target_symbol_table, name);
		if (retval == NULL) {
			switch (type) {
				case BP_VAR_R:
				case BP_VAR_UNSET:
					zend_error(E_NOTICE,"Undefined variable: %s", ZSTR_VAL(name));
					/* break missing intentionally */
				case BP_VAR_IS:
					retval = &EG(uninitialized_zval);
					break;
				case BP_VAR_RW:
					zend_error(E_NOTICE,"Undefined variable: %s", ZSTR_VAL(name));
					/* break missing intentionally */
				case BP_VAR_W:
					retval = zend_hash_add_new(target_symbol_table, name, &EG(uninitialized_zval));
					break;
				EMPTY_SWITCH_DEFAULT_CASE()
			}
		/* GLOBAL or $$name variable may be an INDIRECT pointer to CV */
		} else if (Z_TYPE_P(retval) == IS_INDIRECT) {
			retval = Z_INDIRECT_P(retval);
			if (Z_TYPE_P(retval) == IS_UNDEF) {
				switch (type) {
					case BP_VAR_R:
					case BP_VAR_UNSET:
						zend_error(E_NOTICE,"Undefined variable: %s", ZSTR_VAL(name));
						/* break missing intentionally */
					case BP_VAR_IS:
						retval = &EG(uninitialized_zval);
						break;
					case BP_VAR_RW:
						zend_error(E_NOTICE,"Undefined variable: %s", ZSTR_VAL(name));
						/* break missing intentionally */
					case BP_VAR_W:
						ZVAL_NULL(retval);
						break;
					EMPTY_SWITCH_DEFAULT_CASE()
				}
			}
		}
		if ((opline->extended_value & ZEND_FETCH_TYPE_MASK) == ZEND_FETCH_STATIC) {
			if (Z_CONSTANT_P(retval)) {
				if (UNEXPECTED(zval_update_constant_ex(retval, 1, NULL) != SUCCESS)) {

					HANDLE_EXCEPTION();
				}
			}
		} else if ((opline->extended_value & ZEND_FETCH_TYPE_MASK) != ZEND_FETCH_GLOBAL_LOCK) {

		}
	}

	if (IS_CONST != IS_CONST) {
		zend_string_release(name);
	}

fetch_var_return:
	ZEND_ASSERT(retval != NULL);
	if (type == BP_VAR_R || type == BP_VAR_IS) {
		if (/*type == BP_VAR_R &&*/ Z_ISREF_P(retval) && Z_REFCOUNT_P(retval) == 1) {
			ZVAL_UNREF(retval);
		}
		ZVAL_COPY(EX_VAR(opline->result.var), retval);
	} else {
		ZVAL_INDIRECT(EX_VAR(opline->result.var), retval);
	}
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_R_SPEC_CONST_VAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	ZEND_VM_TAIL_CALL(zend_fetch_var_address_helper_SPEC_CONST_VAR(BP_VAR_R ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_W_SPEC_CONST_VAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	ZEND_VM_TAIL_CALL(zend_fetch_var_address_helper_SPEC_CONST_VAR(BP_VAR_W ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_RW_SPEC_CONST_VAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	ZEND_VM_TAIL_CALL(zend_fetch_var_address_helper_SPEC_CONST_VAR(BP_VAR_RW ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_FUNC_ARG_SPEC_CONST_VAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	if (zend_is_by_ref_func_arg_fetch(opline, EX(call))) {
		ZEND_VM_TAIL_CALL(zend_fetch_var_address_helper_SPEC_CONST_VAR(BP_VAR_W ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else {
		ZEND_VM_TAIL_CALL(zend_fetch_var_address_helper_SPEC_CONST_VAR(BP_VAR_R ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_UNSET_SPEC_CONST_VAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	ZEND_VM_TAIL_CALL(zend_fetch_var_address_helper_SPEC_CONST_VAR(BP_VAR_UNSET ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_IS_SPEC_CONST_VAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	ZEND_VM_TAIL_CALL(zend_fetch_var_address_helper_SPEC_CONST_VAR(BP_VAR_IS ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_UNSET_VAR_SPEC_CONST_VAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval tmp, *varname;
	HashTable *target_symbol_table;


	SAVE_OPLINE();
	if (IS_CONST == IS_CV &&
	    IS_VAR == IS_UNUSED &&
	    (opline->extended_value & ZEND_QUICK_SET)) {
		zval *var = EX_VAR(opline->op1.var);

		if (Z_REFCOUNTED_P(var)) {
			zend_refcounted *garbage = Z_COUNTED_P(var);

			if (!--GC_REFCOUNT(garbage)) {
				ZVAL_UNDEF(var);
				zval_dtor_func_for_ptr(garbage);
			} else {
				GC_ZVAL_CHECK_POSSIBLE_ROOT(var);
				ZVAL_UNDEF(var);
			}
		} else {
			ZVAL_UNDEF(var);
		}
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}

	varname = EX_CONSTANT(opline->op1);

	ZVAL_UNDEF(&tmp);
	if (IS_CONST != IS_CONST && Z_TYPE_P(varname) != IS_STRING) {
		if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(varname) == IS_UNDEF)) {
			varname = GET_OP1_UNDEF_CV(varname, BP_VAR_R);
		}
		ZVAL_STR(&tmp, zval_get_string(varname));
		varname = &tmp;
	}

	if (IS_VAR != IS_UNUSED) {
		zend_class_entry *ce;

		if (IS_VAR == IS_CONST) {
			if (EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2))))) {
				ce = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)));
			} else {
				ce = zend_fetch_class_by_name(Z_STR_P(EX_CONSTANT(opline->op2)), EX_CONSTANT(opline->op2) + 1, ZEND_FETCH_CLASS_DEFAULT | ZEND_FETCH_CLASS_EXCEPTION);
				if (UNEXPECTED(EG(exception) != NULL)) {
					if (IS_CONST != IS_CONST && Z_TYPE(tmp) != IS_UNDEF) {
						zend_string_release(Z_STR(tmp));
					}

					HANDLE_EXCEPTION();
				}
				if (UNEXPECTED(ce == NULL)) {
					zend_throw_error(NULL, "Class '%s' not found", Z_STRVAL_P(EX_CONSTANT(opline->op2)));
					if (IS_CONST != IS_CONST) {
						zend_string_release(Z_STR(tmp));
					}
					HANDLE_EXCEPTION();
				}
				CACHE_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)), ce);
			}
		} else {
			ce = Z_CE_P(EX_VAR(opline->op2.var));
		}
		zend_std_unset_static_property(ce, Z_STR_P(varname));
	} else {
		target_symbol_table = zend_get_target_symbol_table(execute_data, opline->extended_value & ZEND_FETCH_TYPE_MASK);
		zend_hash_del_ind(target_symbol_table, Z_STR_P(varname));
	}

	if (IS_CONST != IS_CONST && Z_TYPE(tmp) != IS_UNDEF) {
		zend_string_release(Z_STR(tmp));
	}

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ISSET_ISEMPTY_VAR_SPEC_CONST_VAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *value;
	int result;

	if (IS_CONST == IS_CV &&
	    IS_VAR == IS_UNUSED &&
	    (opline->extended_value & ZEND_QUICK_SET)) {
		value = EX_VAR(opline->op1.var);
		if (opline->extended_value & ZEND_ISSET) {
			result =
				Z_TYPE_P(value) > IS_NULL &&
			    (!Z_ISREF_P(value) || Z_TYPE_P(Z_REFVAL_P(value)) != IS_NULL);
		} else /* if (opline->extended_value & ZEND_ISEMPTY) */ {
			SAVE_OPLINE();
			result = !i_zend_is_true(value);
			if (UNEXPECTED(EG(exception))) {
				HANDLE_EXCEPTION();
			}
		}
		ZEND_VM_SMART_BRANCH(result, 0);
		ZVAL_BOOL(EX_VAR(opline->result.var), result);
		ZEND_VM_SET_NEXT_OPCODE(opline + 1);
		ZEND_VM_CONTINUE();
	} else {

		zval tmp, *varname;

		SAVE_OPLINE();
		varname = EX_CONSTANT(opline->op1);
		ZVAL_UNDEF(&tmp);
		if (IS_CONST != IS_CONST && Z_TYPE_P(varname) != IS_STRING) {
			ZVAL_STR(&tmp, zval_get_string(varname));
			varname = &tmp;
		}

		if (IS_VAR != IS_UNUSED) {
			zend_class_entry *ce;

			if (IS_VAR == IS_CONST) {
				if (IS_CONST == IS_CONST && EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1))))) {

					ce = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)));
					value = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)) + sizeof(void*));

					/* check if static properties were destoyed */
					if (UNEXPECTED(CE_STATIC_MEMBERS(ce) == NULL)) {
						value = NULL;
					}

					goto is_var_return;
				} else if (EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2))))) {
					ce = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)));
				} else {
					ce = zend_fetch_class_by_name(Z_STR_P(EX_CONSTANT(opline->op2)), EX_CONSTANT(opline->op2) + 1, ZEND_FETCH_CLASS_DEFAULT | ZEND_FETCH_CLASS_EXCEPTION);
					if (UNEXPECTED(ce == NULL)) {
						ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
					}
					CACHE_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)), ce);
				}
			} else {
				ce = Z_CE_P(EX_VAR(opline->op2.var));
				if (IS_CONST == IS_CONST &&
				    (value = CACHED_POLYMORPHIC_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)), ce)) != NULL) {

					/* check if static properties were destoyed */
					if (UNEXPECTED(CE_STATIC_MEMBERS(ce) == NULL)) {
						value = NULL;
					}

					goto is_var_return;
				}
			}

			value = zend_std_get_static_property(ce, Z_STR_P(varname), 1);

			if (IS_CONST == IS_CONST && value) {
				CACHE_POLYMORPHIC_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)), ce, value);
			}
		} else {
			HashTable *target_symbol_table = zend_get_target_symbol_table(execute_data, opline->extended_value & ZEND_FETCH_TYPE_MASK);
			value = zend_hash_find_ind(target_symbol_table, Z_STR_P(varname));
		}

		if (IS_CONST != IS_CONST && Z_TYPE(tmp) != IS_UNDEF) {
			zend_string_release(Z_STR(tmp));
		}

is_var_return:
		if (opline->extended_value & ZEND_ISSET) {
			result = value && Z_TYPE_P(value) > IS_NULL &&
			    (!Z_ISREF_P(value) || Z_TYPE_P(Z_REFVAL_P(value)) != IS_NULL);
		} else /* if (opline->extended_value & ZEND_ISEMPTY) */ {
			result = !value || !i_zend_is_true(value);
		}

		ZEND_VM_SMART_BRANCH(result, 1);
		ZVAL_BOOL(EX_VAR(opline->result.var), result);
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_YIELD_SPEC_CONST_VAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zend_generator *generator = zend_get_running_generator(execute_data);

	SAVE_OPLINE();
	if (UNEXPECTED(generator->flags & ZEND_GENERATOR_FORCED_CLOSE)) {
		zend_throw_error(NULL, "Cannot yield from finally in a force-closed generator");
		zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));

		HANDLE_EXCEPTION();
	}

	/* Destroy the previously yielded value */
	zval_ptr_dtor(&generator->value);

	/* Destroy the previously yielded key */
	zval_ptr_dtor(&generator->key);

	/* Set the new yielded value */
	if (IS_CONST != IS_UNUSED) {


		if (UNEXPECTED(EX(func)->op_array.fn_flags & ZEND_ACC_RETURN_REFERENCE)) {
			/* Constants and temporary variables aren't yieldable by reference,
			 * but we still allow them with a notice. */
			if (IS_CONST == IS_CONST || IS_CONST == IS_TMP_VAR) {
				zval *value;

				zend_error(E_NOTICE, "Only variable references should be yielded by reference");

				value = EX_CONSTANT(opline->op1);
				ZVAL_COPY_VALUE(&generator->value, value);
				if (IS_CONST != IS_CONST) {
					if (UNEXPECTED(Z_OPT_COPYABLE(generator->value))) {
						zval_copy_ctor_func(&generator->value);
					}
				}
			} else {
				zval *value_ptr = NULL;

				if (IS_CONST == IS_VAR && UNEXPECTED(value_ptr == NULL)) {
					zend_throw_error(NULL, "Cannot yield string offsets by reference");
					zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
					HANDLE_EXCEPTION();
				}

				/* If a function call result is yielded and the function did
				 * not return by reference we throw a notice. */
				if (IS_CONST == IS_VAR &&
				    (value_ptr == &EG(uninitialized_zval) ||
				     (opline->extended_value == ZEND_RETURNS_FUNCTION &&
				      !(Z_VAR_FLAGS_P(value_ptr) & IS_VAR_RET_REF)))) {
					zend_error(E_NOTICE, "Only variable references should be yielded by reference");
				} else {
					ZVAL_MAKE_REF(value_ptr);
				}
				ZVAL_COPY(&generator->value, value_ptr);

			}
		} else {
			zval *value = EX_CONSTANT(opline->op1);

			/* Consts, temporary variables and references need copying */
			if (IS_CONST == IS_CONST) {
				ZVAL_COPY_VALUE(&generator->value, value);
				if (UNEXPECTED(Z_OPT_COPYABLE(generator->value))) {
					zval_copy_ctor_func(&generator->value);
				}
			} else if (IS_CONST == IS_TMP_VAR) {
				ZVAL_COPY_VALUE(&generator->value, value);
            } else if ((IS_CONST & (IS_VAR|IS_CV)) && Z_ISREF_P(value)) {
				ZVAL_COPY(&generator->value, Z_REFVAL_P(value));

			} else {
				ZVAL_COPY_VALUE(&generator->value, value);
				if (IS_CONST == IS_CV) {
					if (Z_OPT_REFCOUNTED_P(value)) Z_ADDREF_P(value);
				}
			}
		}
	} else {
		/* If no value was specified yield null */
		ZVAL_NULL(&generator->value);
	}

	/* Set the new yielded key */
	if (IS_VAR != IS_UNUSED) {
		zend_free_op free_op2;
		zval *key = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);

		/* Consts, temporary variables and references need copying */
		if (IS_VAR == IS_CONST) {
			ZVAL_COPY_VALUE(&generator->key, key);
			if (UNEXPECTED(Z_OPT_COPYABLE(generator->key))) {
				zval_copy_ctor_func(&generator->key);
			}
		} else if (IS_VAR == IS_TMP_VAR) {
			ZVAL_COPY_VALUE(&generator->key, key);
		} else if ((IS_VAR & (IS_VAR|IS_CV)) && Z_ISREF_P(key)) {
			ZVAL_COPY(&generator->key, Z_REFVAL_P(key));
			zval_ptr_dtor_nogc(free_op2);
		} else {
			ZVAL_COPY_VALUE(&generator->key, key);
			if (IS_VAR == IS_CV) {
				if (Z_OPT_REFCOUNTED_P(key)) Z_ADDREF_P(key);
			}
		}

		if (Z_TYPE(generator->key) == IS_LONG
		    && Z_LVAL(generator->key) > generator->largest_used_integer_key
		) {
			generator->largest_used_integer_key = Z_LVAL(generator->key);
		}
	} else {
		/* If no key was specified we use auto-increment keys */
		generator->largest_used_integer_key++;
		ZVAL_LONG(&generator->key, generator->largest_used_integer_key);
	}

	if (RETURN_VALUE_USED(opline)) {
		/* If the return value of yield is used set the send
		 * target and initialize it to NULL */
		generator->send_target = EX_VAR(opline->result.var);
		ZVAL_NULL(generator->send_target);
	} else {
		generator->send_target = NULL;
	}

	/* We increment to the next op, so we are at the correct position when the
	 * generator is resumed. */
	ZEND_VM_INC_OPCODE();

	/* The GOTO VM uses a local opline variable. We need to set the opline
	 * variable in execute_data so we don't resume at an old position. */
	SAVE_OPLINE();

	ZEND_VM_RETURN();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL zend_fetch_var_address_helper_SPEC_CONST_UNUSED(int type ZEND_OPCODE_HANDLER_ARGS_DC)
{
	USE_OPLINE

	zval *varname;
	zval *retval;
	zend_string *name;
	HashTable *target_symbol_table;

	SAVE_OPLINE();
	varname = EX_CONSTANT(opline->op1);

 	if (IS_CONST == IS_CONST) {
		name = Z_STR_P(varname);
	} else if (EXPECTED(Z_TYPE_P(varname) == IS_STRING)) {
		name = Z_STR_P(varname);
		zend_string_addref(name);
	} else {
		if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(varname) == IS_UNDEF)) {
			GET_OP1_UNDEF_CV(varname, BP_VAR_R);
		}
		name = zval_get_string(varname);
	}

	if (IS_UNUSED != IS_UNUSED) {
		zend_class_entry *ce;

		if (IS_UNUSED == IS_CONST) {
			if (IS_CONST == IS_CONST && EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1))))) {

				ce = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)));
				retval = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)) + sizeof(void*));

				/* check if static properties were destoyed */
				if (UNEXPECTED(CE_STATIC_MEMBERS(ce) == NULL)) {
					zend_throw_error(NULL, "Access to undeclared static property: %s::$%s", ZSTR_VAL(ce->name), ZSTR_VAL(name));

					HANDLE_EXCEPTION();
				}

				goto fetch_var_return;
			} else if (EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2))))) {
				ce = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)));
			} else {
				ce = zend_fetch_class_by_name(Z_STR_P(EX_CONSTANT(opline->op2)), EX_CONSTANT(opline->op2) + 1, ZEND_FETCH_CLASS_DEFAULT | ZEND_FETCH_CLASS_EXCEPTION);
				if (UNEXPECTED(ce == NULL)) {
					if (IS_CONST != IS_CONST) {
						zend_string_release(name);
					}

					ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
				}
				CACHE_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)), ce);
			}
		} else {
			ce = Z_CE_P(EX_VAR(opline->op2.var));
			if (IS_CONST == IS_CONST &&
			    (retval = CACHED_POLYMORPHIC_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)), ce)) != NULL) {

				/* check if static properties were destoyed */
				if (UNEXPECTED(CE_STATIC_MEMBERS(ce) == NULL)) {
					zend_throw_error(NULL, "Access to undeclared static property: %s::$%s", ZSTR_VAL(ce->name), ZSTR_VAL(name));

					HANDLE_EXCEPTION();
				}

				goto fetch_var_return;
			}
		}
		retval = zend_std_get_static_property(ce, name, 0);
		if (UNEXPECTED(EG(exception))) {

			HANDLE_EXCEPTION();
		}
		if (IS_CONST == IS_CONST && retval) {
			CACHE_POLYMORPHIC_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)), ce, retval);
		}

	} else {
		target_symbol_table = zend_get_target_symbol_table(execute_data, opline->extended_value & ZEND_FETCH_TYPE_MASK);
		retval = zend_hash_find(target_symbol_table, name);
		if (retval == NULL) {
			switch (type) {
				case BP_VAR_R:
				case BP_VAR_UNSET:
					zend_error(E_NOTICE,"Undefined variable: %s", ZSTR_VAL(name));
					/* break missing intentionally */
				case BP_VAR_IS:
					retval = &EG(uninitialized_zval);
					break;
				case BP_VAR_RW:
					zend_error(E_NOTICE,"Undefined variable: %s", ZSTR_VAL(name));
					/* break missing intentionally */
				case BP_VAR_W:
					retval = zend_hash_add_new(target_symbol_table, name, &EG(uninitialized_zval));
					break;
				EMPTY_SWITCH_DEFAULT_CASE()
			}
		/* GLOBAL or $$name variable may be an INDIRECT pointer to CV */
		} else if (Z_TYPE_P(retval) == IS_INDIRECT) {
			retval = Z_INDIRECT_P(retval);
			if (Z_TYPE_P(retval) == IS_UNDEF) {
				switch (type) {
					case BP_VAR_R:
					case BP_VAR_UNSET:
						zend_error(E_NOTICE,"Undefined variable: %s", ZSTR_VAL(name));
						/* break missing intentionally */
					case BP_VAR_IS:
						retval = &EG(uninitialized_zval);
						break;
					case BP_VAR_RW:
						zend_error(E_NOTICE,"Undefined variable: %s", ZSTR_VAL(name));
						/* break missing intentionally */
					case BP_VAR_W:
						ZVAL_NULL(retval);
						break;
					EMPTY_SWITCH_DEFAULT_CASE()
				}
			}
		}
		if ((opline->extended_value & ZEND_FETCH_TYPE_MASK) == ZEND_FETCH_STATIC) {
			if (Z_CONSTANT_P(retval)) {
				if (UNEXPECTED(zval_update_constant_ex(retval, 1, NULL) != SUCCESS)) {

					HANDLE_EXCEPTION();
				}
			}
		} else if ((opline->extended_value & ZEND_FETCH_TYPE_MASK) != ZEND_FETCH_GLOBAL_LOCK) {

		}
	}

	if (IS_CONST != IS_CONST) {
		zend_string_release(name);
	}

fetch_var_return:
	ZEND_ASSERT(retval != NULL);
	if (type == BP_VAR_R || type == BP_VAR_IS) {
		if (/*type == BP_VAR_R &&*/ Z_ISREF_P(retval) && Z_REFCOUNT_P(retval) == 1) {
			ZVAL_UNREF(retval);
		}
		ZVAL_COPY(EX_VAR(opline->result.var), retval);
	} else {
		ZVAL_INDIRECT(EX_VAR(opline->result.var), retval);
	}
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_R_SPEC_CONST_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	ZEND_VM_TAIL_CALL(zend_fetch_var_address_helper_SPEC_CONST_UNUSED(BP_VAR_R ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_W_SPEC_CONST_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	ZEND_VM_TAIL_CALL(zend_fetch_var_address_helper_SPEC_CONST_UNUSED(BP_VAR_W ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_RW_SPEC_CONST_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	ZEND_VM_TAIL_CALL(zend_fetch_var_address_helper_SPEC_CONST_UNUSED(BP_VAR_RW ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_FUNC_ARG_SPEC_CONST_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	if (zend_is_by_ref_func_arg_fetch(opline, EX(call))) {
		ZEND_VM_TAIL_CALL(zend_fetch_var_address_helper_SPEC_CONST_UNUSED(BP_VAR_W ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else {
		ZEND_VM_TAIL_CALL(zend_fetch_var_address_helper_SPEC_CONST_UNUSED(BP_VAR_R ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_UNSET_SPEC_CONST_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	ZEND_VM_TAIL_CALL(zend_fetch_var_address_helper_SPEC_CONST_UNUSED(BP_VAR_UNSET ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_IS_SPEC_CONST_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	ZEND_VM_TAIL_CALL(zend_fetch_var_address_helper_SPEC_CONST_UNUSED(BP_VAR_IS ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_DIM_FUNC_ARG_SPEC_CONST_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *container;
	zend_free_op free_op1;

	SAVE_OPLINE();

	if (zend_is_by_ref_func_arg_fetch(opline, EX(call))) {
        if (IS_CONST == IS_CONST || IS_CONST == IS_TMP_VAR) {
            zend_throw_error(NULL, "Cannot use temporary expression in write context");


			HANDLE_EXCEPTION();
        }
		container = NULL;
		if (IS_CONST == IS_VAR && UNEXPECTED(container == NULL)) {
			zend_throw_error(NULL, "Cannot use string offset as an array");

			HANDLE_EXCEPTION();
		}
		zend_fetch_dimension_address_W(EX_VAR(opline->result.var), container, NULL, IS_UNUSED);
		if (IS_CONST == IS_VAR && READY_TO_DESTROY(free_op1)) {
			EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 1);
		}


	} else {
		if (IS_UNUSED == IS_UNUSED) {
			zend_throw_error(NULL, "Cannot use [] for reading");


			HANDLE_EXCEPTION();
		}
		container = EX_CONSTANT(opline->op1);
		zend_fetch_dimension_address_read_R(EX_VAR(opline->result.var), container, NULL, IS_UNUSED);


	}
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_INIT_STATIC_METHOD_CALL_SPEC_CONST_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *function_name;
	zend_class_entry *ce;
	zend_object *object;
	zend_function *fbc;
	zend_execute_data *call;

	SAVE_OPLINE();

	if (IS_CONST == IS_CONST) {
		/* no function found. try a static method in class */
		if (EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1))))) {
			ce = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)));
		} else {
			ce = zend_fetch_class_by_name(Z_STR_P(EX_CONSTANT(opline->op1)), EX_CONSTANT(opline->op1) + 1, ZEND_FETCH_CLASS_DEFAULT |  ZEND_FETCH_CLASS_EXCEPTION);
			if (UNEXPECTED(EG(exception) != NULL)) {
				HANDLE_EXCEPTION();
			}
			if (UNEXPECTED(ce == NULL)) {
				zend_throw_error(NULL, "Class '%s' not found", Z_STRVAL_P(EX_CONSTANT(opline->op1)));
				HANDLE_EXCEPTION();
			}
			CACHE_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)), ce);
		}
	} else {
		ce = Z_CE_P(EX_VAR(opline->op1.var));
	}

	if (IS_CONST == IS_CONST &&
	    IS_UNUSED == IS_CONST &&
	    EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2))))) {
		fbc = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)));
	} else if (IS_CONST != IS_CONST &&
	           IS_UNUSED == IS_CONST &&
	           (fbc = CACHED_POLYMORPHIC_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)), ce))) {
		/* do nothing */
	} else if (IS_UNUSED != IS_UNUSED) {


		function_name = NULL;
		if (IS_UNUSED != IS_CONST) {
			if (UNEXPECTED(Z_TYPE_P(function_name) != IS_STRING)) {
				if (IS_UNUSED == IS_CV && UNEXPECTED(Z_TYPE_P(function_name) == IS_UNDEF)) {
					GET_OP2_UNDEF_CV(function_name, BP_VAR_R);
				}
				if (UNEXPECTED(EG(exception) != NULL)) {
					HANDLE_EXCEPTION();
				}
				zend_throw_error(NULL, "Function name must be a string");

				HANDLE_EXCEPTION();
 			}
		}

		if (ce->get_static_method) {
			fbc = ce->get_static_method(ce, Z_STR_P(function_name));
		} else {
			fbc = zend_std_get_static_method(ce, Z_STR_P(function_name), ((IS_UNUSED == IS_CONST) ? (EX_CONSTANT(opline->op2) + 1) : NULL));
		}
		if (UNEXPECTED(fbc == NULL)) {
			if (EXPECTED(!EG(exception))) {
				zend_throw_error(NULL, "Call to undefined method %s::%s()", ZSTR_VAL(ce->name), Z_STRVAL_P(function_name));
			}

			HANDLE_EXCEPTION();
		}
		if (IS_UNUSED == IS_CONST &&
		    EXPECTED(fbc->type <= ZEND_USER_FUNCTION) &&
		    EXPECTED(!(fbc->common.fn_flags & (ZEND_ACC_CALL_VIA_TRAMPOLINE|ZEND_ACC_NEVER_CACHE)))) {
			if (IS_CONST == IS_CONST) {
				CACHE_PTR(Z_CACHE_SLOT_P(function_name), fbc);
			} else {
				CACHE_POLYMORPHIC_PTR(Z_CACHE_SLOT_P(function_name), ce, fbc);
			}
		}
		if (IS_UNUSED != IS_CONST) {

		}
	} else {
		if (UNEXPECTED(ce->constructor == NULL)) {
			zend_throw_error(NULL, "Cannot call constructor");
			HANDLE_EXCEPTION();
		}
		if (Z_OBJ(EX(This)) && Z_OBJ(EX(This))->ce != ce->constructor->common.scope && (ce->constructor->common.fn_flags & ZEND_ACC_PRIVATE)) {
			zend_throw_error(NULL, "Cannot call private %s::__construct()", ZSTR_VAL(ce->name));
			HANDLE_EXCEPTION();
		}
		fbc = ce->constructor;
	}

	object = NULL;
	if (!(fbc->common.fn_flags & ZEND_ACC_STATIC)) {
		if (Z_OBJ(EX(This)) && instanceof_function(Z_OBJCE(EX(This)), ce)) {
			object = Z_OBJ(EX(This));
		}
		if (!object) {
			if (fbc->common.fn_flags & ZEND_ACC_ALLOW_STATIC) {
				/* Allowed for PHP 4 compatibility. */
				zend_error(
					E_DEPRECATED,
					"Non-static method %s::%s() should not be called statically",
					ZSTR_VAL(fbc->common.scope->name), ZSTR_VAL(fbc->common.function_name));
				if (UNEXPECTED(EG(exception) != NULL)) {
					HANDLE_EXCEPTION();
				}
			} else {
				/* An internal function assumes $this is present and won't check that.
				 * So PHP would crash by allowing the call. */
				zend_throw_error(
					zend_ce_error,
					"Non-static method %s::%s() cannot be called statically",
					ZSTR_VAL(fbc->common.scope->name), ZSTR_VAL(fbc->common.function_name));
				HANDLE_EXCEPTION();
			}
		}
	}

	if (IS_CONST != IS_CONST) {
		/* previous opcode is ZEND_FETCH_CLASS */
		if (((opline-1)->extended_value & ZEND_FETCH_CLASS_MASK) == ZEND_FETCH_CLASS_PARENT ||
		    ((opline-1)->extended_value & ZEND_FETCH_CLASS_MASK) == ZEND_FETCH_CLASS_SELF) {
			ce = EX(called_scope);
		}
	}

	call = zend_vm_stack_push_call_frame(ZEND_CALL_NESTED_FUNCTION,
		fbc, opline->extended_value, ce, object);
	call->prev_execute_data = EX(call);
	EX(call) = call;

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_VERIFY_RETURN_TYPE_SPEC_CONST_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	SAVE_OPLINE();
	if (IS_CONST == IS_UNUSED) {
		zend_verify_missing_return_type(EX(func), CACHE_ADDR(opline->op2.num));
	} else {
/* prevents "undefined variable opline" errors */
#if 0 || (IS_CONST != IS_UNUSED)
		zval *retval_ref, *retval_ptr;

		zend_arg_info *ret_info = EX(func)->common.arg_info - 1;

		retval_ref = retval_ptr = EX_CONSTANT(opline->op1);

		if (IS_CONST == IS_CONST) {
			ZVAL_COPY(EX_VAR(opline->result.var), retval_ptr);
			retval_ref = retval_ptr = EX_VAR(opline->result.var);
		} else if (IS_CONST == IS_VAR) {
			if (UNEXPECTED(Z_TYPE_P(retval_ptr) == IS_INDIRECT)) {
				retval_ptr = Z_INDIRECT_P(retval_ptr);
			}
			ZVAL_DEREF(retval_ptr);
		} else if (IS_CONST == IS_CV) {
			ZVAL_DEREF(retval_ptr);
		}

		if (UNEXPECTED(!ret_info->class_name
			&& ret_info->type_hint != IS_CALLABLE
			&& !ZEND_SAME_FAKE_TYPE(ret_info->type_hint, Z_TYPE_P(retval_ptr))
			&& !(EX(func)->op_array.fn_flags & ZEND_ACC_RETURN_REFERENCE)
			&& retval_ref != retval_ptr)
		) {
			/* A cast might happen - unwrap the reference if this is a by-value return */
			if (Z_REFCOUNT_P(retval_ref) == 1) {
				ZVAL_UNREF(retval_ref);
			} else {
				Z_DELREF_P(retval_ref);
				ZVAL_COPY(retval_ref, retval_ptr);
			}
			retval_ptr = retval_ref;
		}
		zend_verify_return_type(EX(func), retval_ptr, CACHE_ADDR(opline->op2.num));

		if (UNEXPECTED(EG(exception) != NULL)) {

		}
#endif
	}
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ADD_ARRAY_ELEMENT_SPEC_CONST_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *expr_ptr, new_expr;

	SAVE_OPLINE();
	if ((IS_CONST == IS_VAR || IS_CONST == IS_CV) &&
	    UNEXPECTED(opline->extended_value & ZEND_ARRAY_ELEMENT_REF)) {
		expr_ptr = NULL;
		if (IS_CONST == IS_VAR && UNEXPECTED(expr_ptr == NULL)) {
			zend_throw_error(NULL, "Cannot create references to/from string offsets");
			zend_array_destroy(Z_ARRVAL_P(EX_VAR(opline->result.var)));
			HANDLE_EXCEPTION();
		}
		ZVAL_MAKE_REF(expr_ptr);
		Z_ADDREF_P(expr_ptr);

	} else {
		expr_ptr = EX_CONSTANT(opline->op1);
		if (IS_CONST == IS_TMP_VAR) {
			/* pass */
		} else if (IS_CONST == IS_CONST) {
			if (UNEXPECTED(Z_OPT_COPYABLE_P(expr_ptr))) {
				ZVAL_COPY_VALUE(&new_expr, expr_ptr);
				zval_copy_ctor_func(&new_expr);
				expr_ptr = &new_expr;
			}
		} else if (IS_CONST == IS_CV) {
			ZVAL_DEREF(expr_ptr);
			if (Z_REFCOUNTED_P(expr_ptr)) {
				Z_ADDREF_P(expr_ptr);
			}
		} else /* if (IS_CONST == IS_VAR) */ {
			if (UNEXPECTED(Z_ISREF_P(expr_ptr))) {
				zend_refcounted *ref = Z_COUNTED_P(expr_ptr);

				expr_ptr = Z_REFVAL_P(expr_ptr);
				if (UNEXPECTED(--GC_REFCOUNT(ref) == 0)) {
					ZVAL_COPY_VALUE(&new_expr, expr_ptr);
					expr_ptr = &new_expr;
					efree_size(ref, sizeof(zend_reference));
				} else if (Z_OPT_REFCOUNTED_P(expr_ptr)) {
					Z_ADDREF_P(expr_ptr);
				}
			}
		}
	}

	if (IS_UNUSED != IS_UNUSED) {

		zval *offset = NULL;
		zend_string *str;
		zend_ulong hval;

add_again:
		if (EXPECTED(Z_TYPE_P(offset) == IS_STRING)) {
			str = Z_STR_P(offset);
			if (IS_UNUSED != IS_CONST) {
				if (ZEND_HANDLE_NUMERIC(str, hval)) {
					goto num_index;
				}
			}
str_index:
			zend_hash_update(Z_ARRVAL_P(EX_VAR(opline->result.var)), str, expr_ptr);
		} else if (EXPECTED(Z_TYPE_P(offset) == IS_LONG)) {
			hval = Z_LVAL_P(offset);
num_index:
			zend_hash_index_update(Z_ARRVAL_P(EX_VAR(opline->result.var)), hval, expr_ptr);
		} else if ((IS_UNUSED & (IS_VAR|IS_CV)) && EXPECTED(Z_TYPE_P(offset) == IS_REFERENCE)) {
			offset = Z_REFVAL_P(offset);
			goto add_again;
		} else if (Z_TYPE_P(offset) == IS_NULL) {
			str = ZSTR_EMPTY_ALLOC();
			goto str_index;
		} else if (Z_TYPE_P(offset) == IS_DOUBLE) {
			hval = zend_dval_to_lval(Z_DVAL_P(offset));
			goto num_index;
		} else if (Z_TYPE_P(offset) == IS_FALSE) {
			hval = 0;
			goto num_index;
		} else if (Z_TYPE_P(offset) == IS_TRUE) {
			hval = 1;
			goto num_index;
		} else if (IS_UNUSED == IS_CV && Z_TYPE_P(offset) == IS_UNDEF) {
			GET_OP2_UNDEF_CV(offset, BP_VAR_R);
			str = ZSTR_EMPTY_ALLOC();
			goto str_index;
		} else {
			zend_error(E_WARNING, "Illegal offset type");
			zval_ptr_dtor(expr_ptr);
		}

	} else {
		zend_hash_next_index_insert(Z_ARRVAL_P(EX_VAR(opline->result.var)), expr_ptr);
	}
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_INIT_ARRAY_SPEC_CONST_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	zval *array;
	uint32_t size;
	USE_OPLINE

	array = EX_VAR(opline->result.var);
	if (IS_CONST != IS_UNUSED) {
		size = opline->extended_value >> ZEND_ARRAY_SIZE_SHIFT;
	} else {
		size = 0;
	}
	ZVAL_NEW_ARR(array);
	zend_hash_init(Z_ARRVAL_P(array), size, NULL, ZVAL_PTR_DTOR, 0);

	if (IS_CONST != IS_UNUSED) {
		/* Explicitly initialize array as not-packed if flag is set */
		if (opline->extended_value & ZEND_ARRAY_NOT_PACKED) {
			zend_hash_real_init(Z_ARRVAL_P(array), 0);
		}
	}

	if (IS_CONST == IS_UNUSED) {
		ZEND_VM_NEXT_OPCODE();
#if 0 || (IS_CONST != IS_UNUSED)
	} else {
		ZEND_VM_TAIL_CALL(ZEND_ADD_ARRAY_ELEMENT_SPEC_CONST_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS_PASSTHRU));
#endif
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_UNSET_VAR_SPEC_CONST_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval tmp, *varname;
	HashTable *target_symbol_table;


	SAVE_OPLINE();
	if (IS_CONST == IS_CV &&
	    IS_UNUSED == IS_UNUSED &&
	    (opline->extended_value & ZEND_QUICK_SET)) {
		zval *var = EX_VAR(opline->op1.var);

		if (Z_REFCOUNTED_P(var)) {
			zend_refcounted *garbage = Z_COUNTED_P(var);

			if (!--GC_REFCOUNT(garbage)) {
				ZVAL_UNDEF(var);
				zval_dtor_func_for_ptr(garbage);
			} else {
				GC_ZVAL_CHECK_POSSIBLE_ROOT(var);
				ZVAL_UNDEF(var);
			}
		} else {
			ZVAL_UNDEF(var);
		}
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}

	varname = EX_CONSTANT(opline->op1);

	ZVAL_UNDEF(&tmp);
	if (IS_CONST != IS_CONST && Z_TYPE_P(varname) != IS_STRING) {
		if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(varname) == IS_UNDEF)) {
			varname = GET_OP1_UNDEF_CV(varname, BP_VAR_R);
		}
		ZVAL_STR(&tmp, zval_get_string(varname));
		varname = &tmp;
	}

	if (IS_UNUSED != IS_UNUSED) {
		zend_class_entry *ce;

		if (IS_UNUSED == IS_CONST) {
			if (EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2))))) {
				ce = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)));
			} else {
				ce = zend_fetch_class_by_name(Z_STR_P(EX_CONSTANT(opline->op2)), EX_CONSTANT(opline->op2) + 1, ZEND_FETCH_CLASS_DEFAULT | ZEND_FETCH_CLASS_EXCEPTION);
				if (UNEXPECTED(EG(exception) != NULL)) {
					if (IS_CONST != IS_CONST && Z_TYPE(tmp) != IS_UNDEF) {
						zend_string_release(Z_STR(tmp));
					}

					HANDLE_EXCEPTION();
				}
				if (UNEXPECTED(ce == NULL)) {
					zend_throw_error(NULL, "Class '%s' not found", Z_STRVAL_P(EX_CONSTANT(opline->op2)));
					if (IS_CONST != IS_CONST) {
						zend_string_release(Z_STR(tmp));
					}
					HANDLE_EXCEPTION();
				}
				CACHE_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)), ce);
			}
		} else {
			ce = Z_CE_P(EX_VAR(opline->op2.var));
		}
		zend_std_unset_static_property(ce, Z_STR_P(varname));
	} else {
		target_symbol_table = zend_get_target_symbol_table(execute_data, opline->extended_value & ZEND_FETCH_TYPE_MASK);
		zend_hash_del_ind(target_symbol_table, Z_STR_P(varname));
	}

	if (IS_CONST != IS_CONST && Z_TYPE(tmp) != IS_UNDEF) {
		zend_string_release(Z_STR(tmp));
	}

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ISSET_ISEMPTY_VAR_SPEC_CONST_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *value;
	int result;

	if (IS_CONST == IS_CV &&
	    IS_UNUSED == IS_UNUSED &&
	    (opline->extended_value & ZEND_QUICK_SET)) {
		value = EX_VAR(opline->op1.var);
		if (opline->extended_value & ZEND_ISSET) {
			result =
				Z_TYPE_P(value) > IS_NULL &&
			    (!Z_ISREF_P(value) || Z_TYPE_P(Z_REFVAL_P(value)) != IS_NULL);
		} else /* if (opline->extended_value & ZEND_ISEMPTY) */ {
			SAVE_OPLINE();
			result = !i_zend_is_true(value);
			if (UNEXPECTED(EG(exception))) {
				HANDLE_EXCEPTION();
			}
		}
		ZEND_VM_SMART_BRANCH(result, 0);
		ZVAL_BOOL(EX_VAR(opline->result.var), result);
		ZEND_VM_SET_NEXT_OPCODE(opline + 1);
		ZEND_VM_CONTINUE();
	} else {

		zval tmp, *varname;

		SAVE_OPLINE();
		varname = EX_CONSTANT(opline->op1);
		ZVAL_UNDEF(&tmp);
		if (IS_CONST != IS_CONST && Z_TYPE_P(varname) != IS_STRING) {
			ZVAL_STR(&tmp, zval_get_string(varname));
			varname = &tmp;
		}

		if (IS_UNUSED != IS_UNUSED) {
			zend_class_entry *ce;

			if (IS_UNUSED == IS_CONST) {
				if (IS_CONST == IS_CONST && EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1))))) {

					ce = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)));
					value = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)) + sizeof(void*));

					/* check if static properties were destoyed */
					if (UNEXPECTED(CE_STATIC_MEMBERS(ce) == NULL)) {
						value = NULL;
					}

					goto is_var_return;
				} else if (EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2))))) {
					ce = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)));
				} else {
					ce = zend_fetch_class_by_name(Z_STR_P(EX_CONSTANT(opline->op2)), EX_CONSTANT(opline->op2) + 1, ZEND_FETCH_CLASS_DEFAULT | ZEND_FETCH_CLASS_EXCEPTION);
					if (UNEXPECTED(ce == NULL)) {
						ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
					}
					CACHE_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)), ce);
				}
			} else {
				ce = Z_CE_P(EX_VAR(opline->op2.var));
				if (IS_CONST == IS_CONST &&
				    (value = CACHED_POLYMORPHIC_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)), ce)) != NULL) {

					/* check if static properties were destoyed */
					if (UNEXPECTED(CE_STATIC_MEMBERS(ce) == NULL)) {
						value = NULL;
					}

					goto is_var_return;
				}
			}

			value = zend_std_get_static_property(ce, Z_STR_P(varname), 1);

			if (IS_CONST == IS_CONST && value) {
				CACHE_POLYMORPHIC_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)), ce, value);
			}
		} else {
			HashTable *target_symbol_table = zend_get_target_symbol_table(execute_data, opline->extended_value & ZEND_FETCH_TYPE_MASK);
			value = zend_hash_find_ind(target_symbol_table, Z_STR_P(varname));
		}

		if (IS_CONST != IS_CONST && Z_TYPE(tmp) != IS_UNDEF) {
			zend_string_release(Z_STR(tmp));
		}

is_var_return:
		if (opline->extended_value & ZEND_ISSET) {
			result = value && Z_TYPE_P(value) > IS_NULL &&
			    (!Z_ISREF_P(value) || Z_TYPE_P(Z_REFVAL_P(value)) != IS_NULL);
		} else /* if (opline->extended_value & ZEND_ISEMPTY) */ {
			result = !value || !i_zend_is_true(value);
		}

		ZEND_VM_SMART_BRANCH(result, 1);
		ZVAL_BOOL(EX_VAR(opline->result.var), result);
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_DECLARE_LAMBDA_FUNCTION_SPEC_CONST_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *zfunc;

	SAVE_OPLINE();

	zfunc = zend_hash_find(EG(function_table), Z_STR_P(EX_CONSTANT(opline->op1)));
	ZEND_ASSERT(zfunc != NULL && Z_FUNC_P(zfunc)->type == ZEND_USER_FUNCTION);

	if (UNEXPECTED((Z_FUNC_P(zfunc)->common.fn_flags & ZEND_ACC_STATIC) ||
				(EX(func)->common.fn_flags & ZEND_ACC_STATIC))) {
		zend_create_closure(EX_VAR(opline->result.var), Z_FUNC_P(zfunc),
			EG(scope), EX(called_scope), NULL);
	} else {
		zend_create_closure(EX_VAR(opline->result.var), Z_FUNC_P(zfunc),
			EG(scope), EX(called_scope), Z_OBJ(EX(This)) ? &EX(This) : NULL);
	}

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_YIELD_SPEC_CONST_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zend_generator *generator = zend_get_running_generator(execute_data);

	SAVE_OPLINE();
	if (UNEXPECTED(generator->flags & ZEND_GENERATOR_FORCED_CLOSE)) {
		zend_throw_error(NULL, "Cannot yield from finally in a force-closed generator");


		HANDLE_EXCEPTION();
	}

	/* Destroy the previously yielded value */
	zval_ptr_dtor(&generator->value);

	/* Destroy the previously yielded key */
	zval_ptr_dtor(&generator->key);

	/* Set the new yielded value */
	if (IS_CONST != IS_UNUSED) {


		if (UNEXPECTED(EX(func)->op_array.fn_flags & ZEND_ACC_RETURN_REFERENCE)) {
			/* Constants and temporary variables aren't yieldable by reference,
			 * but we still allow them with a notice. */
			if (IS_CONST == IS_CONST || IS_CONST == IS_TMP_VAR) {
				zval *value;

				zend_error(E_NOTICE, "Only variable references should be yielded by reference");

				value = EX_CONSTANT(opline->op1);
				ZVAL_COPY_VALUE(&generator->value, value);
				if (IS_CONST != IS_CONST) {
					if (UNEXPECTED(Z_OPT_COPYABLE(generator->value))) {
						zval_copy_ctor_func(&generator->value);
					}
				}
			} else {
				zval *value_ptr = NULL;

				if (IS_CONST == IS_VAR && UNEXPECTED(value_ptr == NULL)) {
					zend_throw_error(NULL, "Cannot yield string offsets by reference");

					HANDLE_EXCEPTION();
				}

				/* If a function call result is yielded and the function did
				 * not return by reference we throw a notice. */
				if (IS_CONST == IS_VAR &&
				    (value_ptr == &EG(uninitialized_zval) ||
				     (opline->extended_value == ZEND_RETURNS_FUNCTION &&
				      !(Z_VAR_FLAGS_P(value_ptr) & IS_VAR_RET_REF)))) {
					zend_error(E_NOTICE, "Only variable references should be yielded by reference");
				} else {
					ZVAL_MAKE_REF(value_ptr);
				}
				ZVAL_COPY(&generator->value, value_ptr);

			}
		} else {
			zval *value = EX_CONSTANT(opline->op1);

			/* Consts, temporary variables and references need copying */
			if (IS_CONST == IS_CONST) {
				ZVAL_COPY_VALUE(&generator->value, value);
				if (UNEXPECTED(Z_OPT_COPYABLE(generator->value))) {
					zval_copy_ctor_func(&generator->value);
				}
			} else if (IS_CONST == IS_TMP_VAR) {
				ZVAL_COPY_VALUE(&generator->value, value);
            } else if ((IS_CONST & (IS_VAR|IS_CV)) && Z_ISREF_P(value)) {
				ZVAL_COPY(&generator->value, Z_REFVAL_P(value));

			} else {
				ZVAL_COPY_VALUE(&generator->value, value);
				if (IS_CONST == IS_CV) {
					if (Z_OPT_REFCOUNTED_P(value)) Z_ADDREF_P(value);
				}
			}
		}
	} else {
		/* If no value was specified yield null */
		ZVAL_NULL(&generator->value);
	}

	/* Set the new yielded key */
	if (IS_UNUSED != IS_UNUSED) {

		zval *key = NULL;

		/* Consts, temporary variables and references need copying */
		if (IS_UNUSED == IS_CONST) {
			ZVAL_COPY_VALUE(&generator->key, key);
			if (UNEXPECTED(Z_OPT_COPYABLE(generator->key))) {
				zval_copy_ctor_func(&generator->key);
			}
		} else if (IS_UNUSED == IS_TMP_VAR) {
			ZVAL_COPY_VALUE(&generator->key, key);
		} else if ((IS_UNUSED & (IS_VAR|IS_CV)) && Z_ISREF_P(key)) {
			ZVAL_COPY(&generator->key, Z_REFVAL_P(key));

		} else {
			ZVAL_COPY_VALUE(&generator->key, key);
			if (IS_UNUSED == IS_CV) {
				if (Z_OPT_REFCOUNTED_P(key)) Z_ADDREF_P(key);
			}
		}

		if (Z_TYPE(generator->key) == IS_LONG
		    && Z_LVAL(generator->key) > generator->largest_used_integer_key
		) {
			generator->largest_used_integer_key = Z_LVAL(generator->key);
		}
	} else {
		/* If no key was specified we use auto-increment keys */
		generator->largest_used_integer_key++;
		ZVAL_LONG(&generator->key, generator->largest_used_integer_key);
	}

	if (RETURN_VALUE_USED(opline)) {
		/* If the return value of yield is used set the send
		 * target and initialize it to NULL */
		generator->send_target = EX_VAR(opline->result.var);
		ZVAL_NULL(generator->send_target);
	} else {
		generator->send_target = NULL;
	}

	/* We increment to the next op, so we are at the correct position when the
	 * generator is resumed. */
	ZEND_VM_INC_OPCODE();

	/* The GOTO VM uses a local opline variable. We need to set the opline
	 * variable in execute_data so we don't resume at an old position. */
	SAVE_OPLINE();

	ZEND_VM_RETURN();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ADD_SPEC_CONST_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2, *result;

	op1 = EX_CONSTANT(opline->op1);
	op2 = _get_zval_ptr_cv_undef(execute_data, opline->op2.var);
	if (EXPECTED(Z_TYPE_INFO_P(op1) == IS_LONG)) {
		if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_LONG)) {
			result = EX_VAR(opline->result.var);
			fast_long_add_function(result, op1, op2);
			ZEND_VM_NEXT_OPCODE();
		} else if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_DOUBLE)) {
			result = EX_VAR(opline->result.var);
			ZVAL_DOUBLE(result, ((double)Z_LVAL_P(op1)) + Z_DVAL_P(op2));
			ZEND_VM_NEXT_OPCODE();
		}
	} else if (EXPECTED(Z_TYPE_INFO_P(op1) == IS_DOUBLE)) {
		if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_DOUBLE)) {
			result = EX_VAR(opline->result.var);
			ZVAL_DOUBLE(result, Z_DVAL_P(op1) + Z_DVAL_P(op2));
			ZEND_VM_NEXT_OPCODE();
		} else if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_LONG)) {
			result = EX_VAR(opline->result.var);
			ZVAL_DOUBLE(result, Z_DVAL_P(op1) + ((double)Z_LVAL_P(op2)));
			ZEND_VM_NEXT_OPCODE();
		}
	}

	SAVE_OPLINE();
	if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(op1) == IS_UNDEF)) {
		op1 = GET_OP1_UNDEF_CV(op1, BP_VAR_R);
	}
	if (IS_CV == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(op2) == IS_UNDEF)) {
		op2 = GET_OP2_UNDEF_CV(op2, BP_VAR_R);
	}
	add_function(EX_VAR(opline->result.var), op1, op2);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_SUB_SPEC_CONST_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2, *result;

	op1 = EX_CONSTANT(opline->op1);
	op2 = _get_zval_ptr_cv_undef(execute_data, opline->op2.var);
	if (EXPECTED(Z_TYPE_INFO_P(op1) == IS_LONG)) {
		if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_LONG)) {
			result = EX_VAR(opline->result.var);
			fast_long_sub_function(result, op1, op2);
			ZEND_VM_NEXT_OPCODE();
		} else if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_DOUBLE)) {
			result = EX_VAR(opline->result.var);
			ZVAL_DOUBLE(result, ((double)Z_LVAL_P(op1)) - Z_DVAL_P(op2));
			ZEND_VM_NEXT_OPCODE();
		}
	} else if (EXPECTED(Z_TYPE_INFO_P(op1) == IS_DOUBLE)) {
		if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_DOUBLE)) {
			result = EX_VAR(opline->result.var);
			ZVAL_DOUBLE(result, Z_DVAL_P(op1) - Z_DVAL_P(op2));
			ZEND_VM_NEXT_OPCODE();
		} else if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_LONG)) {
			result = EX_VAR(opline->result.var);
			ZVAL_DOUBLE(result, Z_DVAL_P(op1) - ((double)Z_LVAL_P(op2)));
			ZEND_VM_NEXT_OPCODE();
		}
	}

	SAVE_OPLINE();
	if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(op1) == IS_UNDEF)) {
		op1 = GET_OP1_UNDEF_CV(op1, BP_VAR_R);
	}
	if (IS_CV == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(op2) == IS_UNDEF)) {
		op2 = GET_OP2_UNDEF_CV(op2, BP_VAR_R);
	}
	sub_function(EX_VAR(opline->result.var), op1, op2);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_MUL_SPEC_CONST_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2, *result;

	op1 = EX_CONSTANT(opline->op1);
	op2 = _get_zval_ptr_cv_undef(execute_data, opline->op2.var);
	if (EXPECTED(Z_TYPE_INFO_P(op1) == IS_LONG)) {
		if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_LONG)) {
			zend_long overflow;

			result = EX_VAR(opline->result.var);
			ZEND_SIGNED_MULTIPLY_LONG(Z_LVAL_P(op1), Z_LVAL_P(op2), Z_LVAL_P(result), Z_DVAL_P(result), overflow);
			Z_TYPE_INFO_P(result) = overflow ? IS_DOUBLE : IS_LONG;
			ZEND_VM_NEXT_OPCODE();
		} else if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_DOUBLE)) {
			result = EX_VAR(opline->result.var);
			ZVAL_DOUBLE(result, ((double)Z_LVAL_P(op1)) * Z_DVAL_P(op2));
			ZEND_VM_NEXT_OPCODE();
		}
	} else if (EXPECTED(Z_TYPE_INFO_P(op1) == IS_DOUBLE)) {
		if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_DOUBLE)) {
			result = EX_VAR(opline->result.var);
			ZVAL_DOUBLE(result, Z_DVAL_P(op1) * Z_DVAL_P(op2));
			ZEND_VM_NEXT_OPCODE();
		} else if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_LONG)) {
			result = EX_VAR(opline->result.var);
			ZVAL_DOUBLE(result, Z_DVAL_P(op1) * ((double)Z_LVAL_P(op2)));
			ZEND_VM_NEXT_OPCODE();
		}
	}

	SAVE_OPLINE();
	if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(op1) == IS_UNDEF)) {
		op1 = GET_OP1_UNDEF_CV(op1, BP_VAR_R);
	}
	if (IS_CV == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(op2) == IS_UNDEF)) {
		op2 = GET_OP2_UNDEF_CV(op2, BP_VAR_R);
	}
	mul_function(EX_VAR(opline->result.var), op1, op2);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_DIV_SPEC_CONST_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2;

	SAVE_OPLINE();
	op1 = EX_CONSTANT(opline->op1);
	op2 = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);
	fast_div_function(EX_VAR(opline->result.var), op1, op2);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_MOD_SPEC_CONST_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2, *result;

	op1 = EX_CONSTANT(opline->op1);
	op2 = _get_zval_ptr_cv_undef(execute_data, opline->op2.var);
	if (EXPECTED(Z_TYPE_INFO_P(op1) == IS_LONG)) {
		if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_LONG)) {
			result = EX_VAR(opline->result.var);
			if (UNEXPECTED(Z_LVAL_P(op2) == 0)) {
				SAVE_OPLINE();
				zend_throw_exception_ex(zend_ce_division_by_zero_error, 0, "Modulo by zero");
				HANDLE_EXCEPTION();
			} else if (UNEXPECTED(Z_LVAL_P(op2) == -1)) {
				/* Prevent overflow error/crash if op1==ZEND_LONG_MIN */
				ZVAL_LONG(result, 0);
			} else {
				ZVAL_LONG(result, Z_LVAL_P(op1) % Z_LVAL_P(op2));
			}
			ZEND_VM_NEXT_OPCODE();
		}
	}

	SAVE_OPLINE();
	if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(op1) == IS_UNDEF)) {
		op1 = GET_OP1_UNDEF_CV(op1, BP_VAR_R);
	}
	if (IS_CV == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(op2) == IS_UNDEF)) {
		op2 = GET_OP2_UNDEF_CV(op2, BP_VAR_R);
	}
	mod_function(EX_VAR(opline->result.var), op1, op2);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_SL_SPEC_CONST_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2;

	SAVE_OPLINE();
	op1 = EX_CONSTANT(opline->op1);
	op2 = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);
	shift_left_function(EX_VAR(opline->result.var), op1, op2);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_SR_SPEC_CONST_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2;

	SAVE_OPLINE();
	op1 = EX_CONSTANT(opline->op1);
	op2 = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);
	shift_right_function(EX_VAR(opline->result.var), op1, op2);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_CONCAT_SPEC_CONST_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2;

	SAVE_OPLINE();
	op1 = EX_CONSTANT(opline->op1);
	op2 = _get_zval_ptr_cv_undef(execute_data, opline->op2.var);

	do {
		if ((IS_CONST == IS_CONST || EXPECTED(Z_TYPE_P(op1) == IS_STRING)) &&
		    (IS_CV == IS_CONST || EXPECTED(Z_TYPE_P(op2) == IS_STRING))) {
			zend_string *op1_str = Z_STR_P(op1);
			zend_string *op2_str = Z_STR_P(op2);
			zend_string *str;

			if (IS_CONST != IS_CONST) {
				if (UNEXPECTED(ZSTR_LEN(op1_str) == 0)) {
					ZVAL_STR_COPY(EX_VAR(opline->result.var), op2_str);

					break;
				}
			}
			if (IS_CV != IS_CONST) {
				if (UNEXPECTED(ZSTR_LEN(op2_str) == 0)) {
					ZVAL_STR_COPY(EX_VAR(opline->result.var), op1_str);

					break;
				}
			}
			if (IS_CONST != IS_CONST && IS_CONST != IS_CV &&
			    !ZSTR_IS_INTERNED(op1_str) && GC_REFCOUNT(op1_str) == 1) {
			    size_t len = ZSTR_LEN(op1_str);

				str = zend_string_realloc(op1_str, len + ZSTR_LEN(op2_str), 0);
				memcpy(ZSTR_VAL(str) + len, ZSTR_VAL(op2_str), ZSTR_LEN(op2_str)+1);
				ZVAL_NEW_STR(EX_VAR(opline->result.var), str);
				break;
			} else {
				str = zend_string_alloc(ZSTR_LEN(op1_str) + ZSTR_LEN(op2_str), 0);
				memcpy(ZSTR_VAL(str), ZSTR_VAL(op1_str), ZSTR_LEN(op1_str));
				memcpy(ZSTR_VAL(str) + ZSTR_LEN(op1_str), ZSTR_VAL(op2_str), ZSTR_LEN(op2_str)+1);
				ZVAL_NEW_STR(EX_VAR(opline->result.var), str);
			}
		} else {
			if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(op1) == IS_UNDEF)) {
				op1 = GET_OP1_UNDEF_CV(op1, BP_VAR_R);
			}
			if (IS_CV == IS_CV && UNEXPECTED(Z_TYPE_P(op2) == IS_UNDEF)) {
				op2 = GET_OP2_UNDEF_CV(op2, BP_VAR_R);
			}
			concat_function(EX_VAR(opline->result.var), op1, op2);
		}

	} while (0);

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_IS_IDENTICAL_SPEC_CONST_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2;
	int result;

	SAVE_OPLINE();
	op1 = EX_CONSTANT(opline->op1);
	op2 = _get_zval_ptr_cv_deref_BP_VAR_R(execute_data, opline->op2.var);
	result = fast_is_identical_function(op1, op2);


	ZEND_VM_SMART_BRANCH(result, (IS_CONST|IS_CV) & (IS_VAR|IS_TMP_VAR));
	ZVAL_BOOL(EX_VAR(opline->result.var), result);
	if ((IS_CONST|IS_CV) & (IS_VAR|IS_TMP_VAR)) {
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_IS_NOT_IDENTICAL_SPEC_CONST_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2;
	int result;

	SAVE_OPLINE();
	op1 = EX_CONSTANT(opline->op1);
	op2 = _get_zval_ptr_cv_deref_BP_VAR_R(execute_data, opline->op2.var);
	result = fast_is_not_identical_function(op1, op2);


	ZEND_VM_SMART_BRANCH(result, (IS_CONST|IS_CV) & (IS_VAR|IS_TMP_VAR));
	ZVAL_BOOL(EX_VAR(opline->result.var), result);
	if ((IS_CONST|IS_CV) & (IS_VAR|IS_TMP_VAR)) {
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_IS_EQUAL_SPEC_CONST_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2, *result;

	op1 = EX_CONSTANT(opline->op1);
	op2 = _get_zval_ptr_cv_undef(execute_data, opline->op2.var);
	do {
		int result;

		if (EXPECTED(Z_TYPE_P(op1) == IS_LONG)) {
			if (EXPECTED(Z_TYPE_P(op2) == IS_LONG)) {
				result = (Z_LVAL_P(op1) == Z_LVAL_P(op2));
			} else if (EXPECTED(Z_TYPE_P(op2) == IS_DOUBLE)) {
				result = ((double)Z_LVAL_P(op1) == Z_DVAL_P(op2));
			} else {
				break;
			}
		} else if (EXPECTED(Z_TYPE_P(op1) == IS_DOUBLE)) {
			if (EXPECTED(Z_TYPE_P(op2) == IS_DOUBLE)) {
				result = (Z_DVAL_P(op1) == Z_DVAL_P(op2));
			} else if (EXPECTED(Z_TYPE_P(op2) == IS_LONG)) {
				result = (Z_DVAL_P(op1) == ((double)Z_LVAL_P(op2)));
			} else {
				break;
			}
		} else if (EXPECTED(Z_TYPE_P(op1) == IS_STRING)) {
			if (EXPECTED(Z_TYPE_P(op2) == IS_STRING)) {
				if (Z_STR_P(op1) == Z_STR_P(op2)) {
					result = 1;
				} else if (Z_STRVAL_P(op1)[0] > '9' || Z_STRVAL_P(op2)[0] > '9') {
					if (Z_STRLEN_P(op1) != Z_STRLEN_P(op2)) {
						result = 0;
					} else {
						result = (memcmp(Z_STRVAL_P(op1), Z_STRVAL_P(op2), Z_STRLEN_P(op1)) == 0);
					}
				} else {
					result = (zendi_smart_strcmp(op1, op2) == 0);
				}


			} else {
				break;
			}
		} else {
			break;
		}
		ZEND_VM_SMART_BRANCH(result, 0);
		ZVAL_BOOL(EX_VAR(opline->result.var), result);
		ZEND_VM_NEXT_OPCODE();
	} while (0);

	SAVE_OPLINE();
	if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(op1) == IS_UNDEF)) {
		op1 = GET_OP1_UNDEF_CV(op1, BP_VAR_R);
	}
	if (IS_CV == IS_CV && UNEXPECTED(Z_TYPE_P(op2) == IS_UNDEF)) {
		op2 = GET_OP2_UNDEF_CV(op2, BP_VAR_R);
	}
	result = EX_VAR(opline->result.var);
	compare_function(result, op1, op2);
	ZVAL_BOOL(result, Z_LVAL_P(result) == 0);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_IS_NOT_EQUAL_SPEC_CONST_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2, *result;

	op1 = EX_CONSTANT(opline->op1);
	op2 = _get_zval_ptr_cv_undef(execute_data, opline->op2.var);
	do {
		int result;

		if (EXPECTED(Z_TYPE_P(op1) == IS_LONG)) {
			if (EXPECTED(Z_TYPE_P(op2) == IS_LONG)) {
				result = (Z_LVAL_P(op1) != Z_LVAL_P(op2));
			} else if (EXPECTED(Z_TYPE_P(op2) == IS_DOUBLE)) {
				result = ((double)Z_LVAL_P(op1) != Z_DVAL_P(op2));
			} else {
				break;
			}
		} else if (EXPECTED(Z_TYPE_P(op1) == IS_DOUBLE)) {
			if (EXPECTED(Z_TYPE_P(op2) == IS_DOUBLE)) {
				result = (Z_DVAL_P(op1) != Z_DVAL_P(op2));
			} else if (EXPECTED(Z_TYPE_P(op2) == IS_LONG)) {
				result = (Z_DVAL_P(op1) != ((double)Z_LVAL_P(op2)));
			} else {
				break;
			}
		} else if (EXPECTED(Z_TYPE_P(op1) == IS_STRING)) {
			if (EXPECTED(Z_TYPE_P(op2) == IS_STRING)) {
				if (Z_STR_P(op1) == Z_STR_P(op2)) {
					result = 0;
				} else if (Z_STRVAL_P(op1)[0] > '9' || Z_STRVAL_P(op2)[0] > '9') {
					if (Z_STRLEN_P(op1) != Z_STRLEN_P(op2)) {
						result = 1;
					} else {
						result = (memcmp(Z_STRVAL_P(op1), Z_STRVAL_P(op2), Z_STRLEN_P(op1)) != 0);
					}
				} else {
					result = (zendi_smart_strcmp(op1, op2) != 0);
				}


			} else {
				break;
			}
		} else {
			break;
		}
		ZEND_VM_SMART_BRANCH(result, 0);
		ZVAL_BOOL(EX_VAR(opline->result.var), result);
		ZEND_VM_NEXT_OPCODE();
	} while (0);

	SAVE_OPLINE();
	if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(op1) == IS_UNDEF)) {
		op1 = GET_OP1_UNDEF_CV(op1, BP_VAR_R);
	}
	if (IS_CV == IS_CV && UNEXPECTED(Z_TYPE_P(op2) == IS_UNDEF)) {
		op2 = GET_OP2_UNDEF_CV(op2, BP_VAR_R);
	}
	result = EX_VAR(opline->result.var);
	compare_function(result, op1, op2);
	ZVAL_BOOL(result, Z_LVAL_P(result) != 0);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_IS_SMALLER_SPEC_CONST_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2, *result;

	op1 = EX_CONSTANT(opline->op1);
	op2 = _get_zval_ptr_cv_undef(execute_data, opline->op2.var);
	do {
		int result;

		if (EXPECTED(Z_TYPE_INFO_P(op1) == IS_LONG)) {
			if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_LONG)) {
				result = (Z_LVAL_P(op1) < Z_LVAL_P(op2));
			} else if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_DOUBLE)) {
				result = ((double)Z_LVAL_P(op1) < Z_DVAL_P(op2));
			} else {
				break;
			}
		} else if (EXPECTED(Z_TYPE_INFO_P(op1) == IS_DOUBLE)) {
			if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_DOUBLE)) {
				result = (Z_DVAL_P(op1) < Z_DVAL_P(op2));
			} else if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_LONG)) {
				result = (Z_DVAL_P(op1) < ((double)Z_LVAL_P(op2)));
			} else {
				break;
			}
		} else {
			break;
		}
		ZEND_VM_SMART_BRANCH(result, 0);
		ZVAL_BOOL(EX_VAR(opline->result.var), result);
		ZEND_VM_NEXT_OPCODE();
	} while (0);

	SAVE_OPLINE();
	if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(op1) == IS_UNDEF)) {
		op1 = GET_OP1_UNDEF_CV(op1, BP_VAR_R);
	}
	if (IS_CV == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(op2) == IS_UNDEF)) {
		op2 = GET_OP2_UNDEF_CV(op2, BP_VAR_R);
	}
	result = EX_VAR(opline->result.var);
	compare_function(result, op1, op2);
	ZVAL_BOOL(result, Z_LVAL_P(result) < 0);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_IS_SMALLER_OR_EQUAL_SPEC_CONST_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2, *result;

	op1 = EX_CONSTANT(opline->op1);
	op2 = _get_zval_ptr_cv_undef(execute_data, opline->op2.var);
	do {
		int result;

		if (EXPECTED(Z_TYPE_INFO_P(op1) == IS_LONG)) {
			if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_LONG)) {
				result = (Z_LVAL_P(op1) <= Z_LVAL_P(op2));
			} else if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_DOUBLE)) {
				result = ((double)Z_LVAL_P(op1) <= Z_DVAL_P(op2));
			} else {
				break;
			}
		} else if (EXPECTED(Z_TYPE_INFO_P(op1) == IS_DOUBLE)) {
			if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_DOUBLE)) {
				result = (Z_DVAL_P(op1) <= Z_DVAL_P(op2));
			} else if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_LONG)) {
				result = (Z_DVAL_P(op1) <= ((double)Z_LVAL_P(op2)));
			} else {
				break;
			}
		} else {
			break;
		}
		ZEND_VM_SMART_BRANCH(result, 0);
		ZVAL_BOOL(EX_VAR(opline->result.var), result);
		ZEND_VM_NEXT_OPCODE();
	} while (0);

	SAVE_OPLINE();
	if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(op1) == IS_UNDEF)) {
		op1 = GET_OP1_UNDEF_CV(op1, BP_VAR_R);
	}
	if (IS_CV == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(op2) == IS_UNDEF)) {
		op2 = GET_OP2_UNDEF_CV(op2, BP_VAR_R);
	}
	result = EX_VAR(opline->result.var);
	compare_function(result, op1, op2);
	ZVAL_BOOL(result, Z_LVAL_P(result) <= 0);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_SPACESHIP_SPEC_CONST_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2;

	SAVE_OPLINE();
	op1 = EX_CONSTANT(opline->op1);
	op2 = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);
	compare_function(EX_VAR(opline->result.var), op1, op2);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_BW_OR_SPEC_CONST_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2;

	SAVE_OPLINE();
	op1 = EX_CONSTANT(opline->op1);
	op2 = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);
	bitwise_or_function(EX_VAR(opline->result.var), op1, op2);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_BW_AND_SPEC_CONST_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2;

	SAVE_OPLINE();
	op1 = EX_CONSTANT(opline->op1);
	op2 = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);
	bitwise_and_function(EX_VAR(opline->result.var), op1, op2);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_BW_XOR_SPEC_CONST_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2;

	SAVE_OPLINE();
	op1 = EX_CONSTANT(opline->op1);
	op2 = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);
	bitwise_xor_function(EX_VAR(opline->result.var), op1, op2);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_BOOL_XOR_SPEC_CONST_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2;

	SAVE_OPLINE();
	op1 = EX_CONSTANT(opline->op1);
	op2 = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);
	boolean_xor_function(EX_VAR(opline->result.var), op1, op2);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_DIM_R_SPEC_CONST_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *container;

	SAVE_OPLINE();
	container = EX_CONSTANT(opline->op1);
	zend_fetch_dimension_address_read_R(EX_VAR(opline->result.var), container, _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var), IS_CV);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_DIM_IS_SPEC_CONST_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *container;

	SAVE_OPLINE();
	container = EX_CONSTANT(opline->op1);
	zend_fetch_dimension_address_read_IS(EX_VAR(opline->result.var), container, _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var), IS_CV);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_DIM_FUNC_ARG_SPEC_CONST_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *container;
	zend_free_op free_op1;

	SAVE_OPLINE();

	if (zend_is_by_ref_func_arg_fetch(opline, EX(call))) {
        if (IS_CONST == IS_CONST || IS_CONST == IS_TMP_VAR) {
            zend_throw_error(NULL, "Cannot use temporary expression in write context");


			HANDLE_EXCEPTION();
        }
		container = NULL;
		if (IS_CONST == IS_VAR && UNEXPECTED(container == NULL)) {
			zend_throw_error(NULL, "Cannot use string offset as an array");

			HANDLE_EXCEPTION();
		}
		zend_fetch_dimension_address_W(EX_VAR(opline->result.var), container, _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var), IS_CV);
		if (IS_CONST == IS_VAR && READY_TO_DESTROY(free_op1)) {
			EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 1);
		}


	} else {
		if (IS_CV == IS_UNUSED) {
			zend_throw_error(NULL, "Cannot use [] for reading");


			HANDLE_EXCEPTION();
		}
		container = EX_CONSTANT(opline->op1);
		zend_fetch_dimension_address_read_R(EX_VAR(opline->result.var), container, _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var), IS_CV);


	}
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_R_SPEC_CONST_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *container;

	zval *offset;

	SAVE_OPLINE();
	container = EX_CONSTANT(opline->op1);

	if (IS_CONST == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}

	offset = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);

	if (IS_CONST == IS_CONST ||
	    (IS_CONST != IS_UNUSED && UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT))) {
		if ((IS_CONST & (IS_VAR|IS_CV)) && Z_ISREF_P(container)) {
			container = Z_REFVAL_P(container);
			if (UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT)) {
				goto fetch_obj_r_no_object;
			}
		} else {
			goto fetch_obj_r_no_object;
		}
	}

	/* here we are sure we are dealing with an object */
	do {
		zend_object *zobj = Z_OBJ_P(container);
		zval *retval;

		if (IS_CV == IS_CONST &&
			EXPECTED(zobj->ce == CACHED_PTR(Z_CACHE_SLOT_P(offset)))) {
			uint32_t prop_offset = (uint32_t)(intptr_t)CACHED_PTR(Z_CACHE_SLOT_P(offset) + sizeof(void*));

			if (EXPECTED(prop_offset != (uint32_t)ZEND_DYNAMIC_PROPERTY_OFFSET)) {
				retval = OBJ_PROP(zobj, prop_offset);
				if (EXPECTED(Z_TYPE_P(retval) != IS_UNDEF)) {
					ZVAL_COPY(EX_VAR(opline->result.var), retval);
					break;
				}
			} else if (EXPECTED(zobj->properties != NULL)) {
				retval = zend_hash_find(zobj->properties, Z_STR_P(offset));
				if (EXPECTED(retval)) {
					ZVAL_COPY(EX_VAR(opline->result.var), retval);
					break;
				}
			}
		}

		if (UNEXPECTED(zobj->handlers->read_property == NULL)) {
fetch_obj_r_no_object:
			zend_error(E_NOTICE, "Trying to get property of non-object");
			ZVAL_NULL(EX_VAR(opline->result.var));
		} else {
			retval = zobj->handlers->read_property(container, offset, BP_VAR_R, ((IS_CV == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(offset)) : NULL), EX_VAR(opline->result.var));

			if (retval != EX_VAR(opline->result.var)) {
				ZVAL_COPY(EX_VAR(opline->result.var), retval);
			}
		}
	} while (0);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_IS_SPEC_CONST_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *container;

	zval *offset;

	SAVE_OPLINE();
	container = EX_CONSTANT(opline->op1);

	if (IS_CONST == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}

	offset  = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);

	if (IS_CONST == IS_CONST ||
	    (IS_CONST != IS_UNUSED && UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT))) {
		if ((IS_CONST & (IS_VAR|IS_CV)) && Z_ISREF_P(container)) {
			container = Z_REFVAL_P(container);
			if (UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT)) {
				goto fetch_obj_is_no_object;
			}
		} else {
			goto fetch_obj_is_no_object;
		}
	}

	/* here we are sure we are dealing with an object */
	do {
		zend_object *zobj = Z_OBJ_P(container);
		zval *retval;

		if (IS_CV == IS_CONST &&
			EXPECTED(zobj->ce == CACHED_PTR(Z_CACHE_SLOT_P(offset)))) {
			uint32_t prop_offset = (uint32_t)(intptr_t)CACHED_PTR(Z_CACHE_SLOT_P(offset) + sizeof(void*));

			if (EXPECTED(prop_offset != (uint32_t)ZEND_DYNAMIC_PROPERTY_OFFSET)) {
				retval = OBJ_PROP(zobj, prop_offset);
				if (EXPECTED(Z_TYPE_P(retval) != IS_UNDEF)) {
					ZVAL_COPY(EX_VAR(opline->result.var), retval);
					break;
				}
			} else if (EXPECTED(zobj->properties != NULL)) {
				retval = zend_hash_find(zobj->properties, Z_STR_P(offset));
				if (EXPECTED(retval)) {
					ZVAL_COPY(EX_VAR(opline->result.var), retval);
					break;
				}
			}
		}

		if (UNEXPECTED(zobj->handlers->read_property == NULL)) {
fetch_obj_is_no_object:
			ZVAL_NULL(EX_VAR(opline->result.var));
		} else {

			retval = zobj->handlers->read_property(container, offset, BP_VAR_IS, ((IS_CV == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(offset)) : NULL), EX_VAR(opline->result.var));

			if (retval != EX_VAR(opline->result.var)) {
				ZVAL_COPY(EX_VAR(opline->result.var), retval);
			}
		}
	} while (0);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_FUNC_ARG_SPEC_CONST_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *container;

	if (zend_is_by_ref_func_arg_fetch(opline, EX(call))) {
		/* Behave like FETCH_OBJ_W */
		zend_free_op free_op1;
		zval *property;

		SAVE_OPLINE();
		property = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);
		container = NULL;

		if (IS_CONST == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
			zend_throw_error(NULL, "Using $this when not in object context");

			HANDLE_EXCEPTION();
		}
		if (IS_CONST == IS_CONST || IS_CONST == IS_TMP_VAR) {
			zend_throw_error(NULL, "Cannot use temporary expression in write context");


			HANDLE_EXCEPTION();
		}
		if (IS_CONST == IS_VAR && UNEXPECTED(container == NULL)) {
			zend_throw_error(NULL, "Cannot use string offset as an object");

			HANDLE_EXCEPTION();
		}
		zend_fetch_property_address(EX_VAR(opline->result.var), container, IS_CONST, property, IS_CV, ((IS_CV == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), BP_VAR_W);

		if (IS_CONST == IS_VAR && READY_TO_DESTROY(free_op1)) {
			EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 0);
		}

		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	} else {
		ZEND_VM_TAIL_CALL(ZEND_FETCH_OBJ_R_SPEC_CONST_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS_PASSTHRU));
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FAST_CONCAT_SPEC_CONST_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2;
	zend_string *op1_str, *op2_str, *str;

	SAVE_OPLINE();
	op1 = EX_CONSTANT(opline->op1);
	if (IS_CONST == IS_CONST) {
		op1_str = Z_STR_P(op1);
	} else if (EXPECTED(Z_TYPE_P(op1) == IS_STRING)) {
		op1_str = zend_string_copy(Z_STR_P(op1));
	} else {
		if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(op1) == IS_UNDEF)) {
			GET_OP1_UNDEF_CV(op1, BP_VAR_R);
		}
		op1_str = _zval_get_string_func(op1);
	}
	op2 = _get_zval_ptr_cv_undef(execute_data, opline->op2.var);
	if (IS_CV == IS_CONST) {
		op2_str = Z_STR_P(op2);
	} else if (EXPECTED(Z_TYPE_P(op2) == IS_STRING)) {
		op2_str = zend_string_copy(Z_STR_P(op2));
	} else {
		if (IS_CV == IS_CV && UNEXPECTED(Z_TYPE_P(op2) == IS_UNDEF)) {
			GET_OP2_UNDEF_CV(op2, BP_VAR_R);
		}
		op2_str = _zval_get_string_func(op2);
	}
	do {
		if (IS_CONST != IS_CONST) {
			if (UNEXPECTED(ZSTR_LEN(op1_str) == 0)) {
				if (IS_CV == IS_CONST) {
					zend_string_addref(op2_str);
				}
				ZVAL_STR(EX_VAR(opline->result.var), op2_str);
				zend_string_release(op1_str);
				break;
			}
		}
		if (IS_CV != IS_CONST) {
			if (UNEXPECTED(ZSTR_LEN(op2_str) == 0)) {
				if (IS_CONST == IS_CONST) {
					zend_string_addref(op1_str);
				}
				ZVAL_STR(EX_VAR(opline->result.var), op1_str);
				zend_string_release(op2_str);
				break;
			}
		}
		str = zend_string_alloc(ZSTR_LEN(op1_str) + ZSTR_LEN(op2_str), 0);
		memcpy(ZSTR_VAL(str), ZSTR_VAL(op1_str), ZSTR_LEN(op1_str));
		memcpy(ZSTR_VAL(str) + ZSTR_LEN(op1_str), ZSTR_VAL(op2_str), ZSTR_LEN(op2_str)+1);
		ZVAL_NEW_STR(EX_VAR(opline->result.var), str);
		if (IS_CONST != IS_CONST) {
			zend_string_release(op1_str);
		}
		if (IS_CV != IS_CONST) {
			zend_string_release(op2_str);
		}
	} while (0);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_INIT_METHOD_CALL_SPEC_CONST_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *function_name;

	zval *object;
	zend_function *fbc;
	zend_class_entry *called_scope;
	zend_object *obj;
	zend_execute_data *call;
	uint32_t call_info;

	SAVE_OPLINE();

	function_name = _get_zval_ptr_cv_undef(execute_data, opline->op2.var);

	if (IS_CV != IS_CONST &&
	    UNEXPECTED(Z_TYPE_P(function_name) != IS_STRING)) {
		do {
			if ((IS_CV & (IS_VAR|IS_CV)) && Z_ISREF_P(function_name)) {
				function_name = Z_REFVAL_P(function_name);
				if (EXPECTED(Z_TYPE_P(function_name) == IS_STRING)) {
					break;
				}
			}
			if (IS_CV == IS_CV && UNEXPECTED(Z_TYPE_P(function_name) == IS_UNDEF)) {
				GET_OP2_UNDEF_CV(function_name, BP_VAR_R);
			}
			if (UNEXPECTED(EG(exception) != NULL)) {
				HANDLE_EXCEPTION();
			}
			zend_throw_error(NULL, "Method name must be a string");


			HANDLE_EXCEPTION();
		} while (0);
	}

	object = EX_CONSTANT(opline->op1);

	if (IS_CONST == IS_UNUSED && UNEXPECTED(Z_OBJ_P(object) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}

	if (IS_CONST != IS_UNUSED) {
		do {
			if (IS_CONST == IS_CONST || UNEXPECTED(Z_TYPE_P(object) != IS_OBJECT)) {
				if ((IS_CONST & (IS_VAR|IS_CV)) && EXPECTED(Z_ISREF_P(object))) {
					object = Z_REFVAL_P(object);
					if (EXPECTED(Z_TYPE_P(object) == IS_OBJECT)) {
						break;
					}
				}
				if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(object) == IS_UNDEF)) {
					GET_OP1_UNDEF_CV(object, BP_VAR_R);
				}
				if (UNEXPECTED(EG(exception) != NULL)) {
					HANDLE_EXCEPTION();
				}
				zend_throw_error(NULL, "Call to a member function %s() on %s", Z_STRVAL_P(function_name), zend_get_type_by_const(Z_TYPE_P(object)));


				HANDLE_EXCEPTION();
			}
		} while (0);
	}

	obj = Z_OBJ_P(object);
	called_scope = obj->ce;

	if (IS_CV != IS_CONST ||
	    UNEXPECTED((fbc = CACHED_POLYMORPHIC_PTR(Z_CACHE_SLOT_P(function_name), called_scope)) == NULL)) {
	    zend_object *orig_obj = obj;

		if (UNEXPECTED(obj->handlers->get_method == NULL)) {
			zend_throw_error(NULL, "Object does not support method calls");


			HANDLE_EXCEPTION();
		}

		/* First, locate the function. */
		fbc = obj->handlers->get_method(&obj, Z_STR_P(function_name), ((IS_CV == IS_CONST) ? (EX_CONSTANT(opline->op2) + 1) : NULL));
		if (UNEXPECTED(fbc == NULL)) {
			if (EXPECTED(!EG(exception))) {
				zend_throw_error(NULL, "Call to undefined method %s::%s()", ZSTR_VAL(obj->ce->name), Z_STRVAL_P(function_name));
			}


			HANDLE_EXCEPTION();
		}
		if (IS_CV == IS_CONST &&
		    EXPECTED(fbc->type <= ZEND_USER_FUNCTION) &&
		    EXPECTED(!(fbc->common.fn_flags & (ZEND_ACC_CALL_VIA_TRAMPOLINE|ZEND_ACC_NEVER_CACHE))) &&
		    EXPECTED(obj == orig_obj)) {
			CACHE_POLYMORPHIC_PTR(Z_CACHE_SLOT_P(function_name), called_scope, fbc);
		}
	}

	call_info = ZEND_CALL_NESTED_FUNCTION;
	if (UNEXPECTED((fbc->common.fn_flags & ZEND_ACC_STATIC) != 0)) {
		obj = NULL;
	} else if (IS_CONST & (IS_VAR|IS_TMP_VAR|IS_CV)) {
		/* CV may be changed indirectly (e.g. when it's a reference) */
		call_info = ZEND_CALL_NESTED_FUNCTION | ZEND_CALL_RELEASE_THIS;
		GC_REFCOUNT(obj)++; /* For $this pointer */
	}

	call = zend_vm_stack_push_call_frame(call_info,
		fbc, opline->extended_value, called_scope, obj);
	call->prev_execute_data = EX(call);
	EX(call) = call;


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_INIT_STATIC_METHOD_CALL_SPEC_CONST_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *function_name;
	zend_class_entry *ce;
	zend_object *object;
	zend_function *fbc;
	zend_execute_data *call;

	SAVE_OPLINE();

	if (IS_CONST == IS_CONST) {
		/* no function found. try a static method in class */
		if (EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1))))) {
			ce = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)));
		} else {
			ce = zend_fetch_class_by_name(Z_STR_P(EX_CONSTANT(opline->op1)), EX_CONSTANT(opline->op1) + 1, ZEND_FETCH_CLASS_DEFAULT |  ZEND_FETCH_CLASS_EXCEPTION);
			if (UNEXPECTED(EG(exception) != NULL)) {
				HANDLE_EXCEPTION();
			}
			if (UNEXPECTED(ce == NULL)) {
				zend_throw_error(NULL, "Class '%s' not found", Z_STRVAL_P(EX_CONSTANT(opline->op1)));
				HANDLE_EXCEPTION();
			}
			CACHE_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)), ce);
		}
	} else {
		ce = Z_CE_P(EX_VAR(opline->op1.var));
	}

	if (IS_CONST == IS_CONST &&
	    IS_CV == IS_CONST &&
	    EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2))))) {
		fbc = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)));
	} else if (IS_CONST != IS_CONST &&
	           IS_CV == IS_CONST &&
	           (fbc = CACHED_POLYMORPHIC_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)), ce))) {
		/* do nothing */
	} else if (IS_CV != IS_UNUSED) {


		function_name = _get_zval_ptr_cv_undef(execute_data, opline->op2.var);
		if (IS_CV != IS_CONST) {
			if (UNEXPECTED(Z_TYPE_P(function_name) != IS_STRING)) {
				if (IS_CV == IS_CV && UNEXPECTED(Z_TYPE_P(function_name) == IS_UNDEF)) {
					GET_OP2_UNDEF_CV(function_name, BP_VAR_R);
				}
				if (UNEXPECTED(EG(exception) != NULL)) {
					HANDLE_EXCEPTION();
				}
				zend_throw_error(NULL, "Function name must be a string");

				HANDLE_EXCEPTION();
 			}
		}

		if (ce->get_static_method) {
			fbc = ce->get_static_method(ce, Z_STR_P(function_name));
		} else {
			fbc = zend_std_get_static_method(ce, Z_STR_P(function_name), ((IS_CV == IS_CONST) ? (EX_CONSTANT(opline->op2) + 1) : NULL));
		}
		if (UNEXPECTED(fbc == NULL)) {
			if (EXPECTED(!EG(exception))) {
				zend_throw_error(NULL, "Call to undefined method %s::%s()", ZSTR_VAL(ce->name), Z_STRVAL_P(function_name));
			}

			HANDLE_EXCEPTION();
		}
		if (IS_CV == IS_CONST &&
		    EXPECTED(fbc->type <= ZEND_USER_FUNCTION) &&
		    EXPECTED(!(fbc->common.fn_flags & (ZEND_ACC_CALL_VIA_TRAMPOLINE|ZEND_ACC_NEVER_CACHE)))) {
			if (IS_CONST == IS_CONST) {
				CACHE_PTR(Z_CACHE_SLOT_P(function_name), fbc);
			} else {
				CACHE_POLYMORPHIC_PTR(Z_CACHE_SLOT_P(function_name), ce, fbc);
			}
		}
		if (IS_CV != IS_CONST) {

		}
	} else {
		if (UNEXPECTED(ce->constructor == NULL)) {
			zend_throw_error(NULL, "Cannot call constructor");
			HANDLE_EXCEPTION();
		}
		if (Z_OBJ(EX(This)) && Z_OBJ(EX(This))->ce != ce->constructor->common.scope && (ce->constructor->common.fn_flags & ZEND_ACC_PRIVATE)) {
			zend_throw_error(NULL, "Cannot call private %s::__construct()", ZSTR_VAL(ce->name));
			HANDLE_EXCEPTION();
		}
		fbc = ce->constructor;
	}

	object = NULL;
	if (!(fbc->common.fn_flags & ZEND_ACC_STATIC)) {
		if (Z_OBJ(EX(This)) && instanceof_function(Z_OBJCE(EX(This)), ce)) {
			object = Z_OBJ(EX(This));
		}
		if (!object) {
			if (fbc->common.fn_flags & ZEND_ACC_ALLOW_STATIC) {
				/* Allowed for PHP 4 compatibility. */
				zend_error(
					E_DEPRECATED,
					"Non-static method %s::%s() should not be called statically",
					ZSTR_VAL(fbc->common.scope->name), ZSTR_VAL(fbc->common.function_name));
				if (UNEXPECTED(EG(exception) != NULL)) {
					HANDLE_EXCEPTION();
				}
			} else {
				/* An internal function assumes $this is present and won't check that.
				 * So PHP would crash by allowing the call. */
				zend_throw_error(
					zend_ce_error,
					"Non-static method %s::%s() cannot be called statically",
					ZSTR_VAL(fbc->common.scope->name), ZSTR_VAL(fbc->common.function_name));
				HANDLE_EXCEPTION();
			}
		}
	}

	if (IS_CONST != IS_CONST) {
		/* previous opcode is ZEND_FETCH_CLASS */
		if (((opline-1)->extended_value & ZEND_FETCH_CLASS_MASK) == ZEND_FETCH_CLASS_PARENT ||
		    ((opline-1)->extended_value & ZEND_FETCH_CLASS_MASK) == ZEND_FETCH_CLASS_SELF) {
			ce = EX(called_scope);
		}
	}

	call = zend_vm_stack_push_call_frame(ZEND_CALL_NESTED_FUNCTION,
		fbc, opline->extended_value, ce, object);
	call->prev_execute_data = EX(call);
	EX(call) = call;

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_INIT_USER_CALL_SPEC_CONST_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *function_name;
	zend_fcall_info_cache fcc;
	char *error = NULL;
	zend_function *func;
	zend_class_entry *called_scope;
	zend_object *object;
	zend_execute_data *call;
	uint32_t call_info = ZEND_CALL_NESTED_FUNCTION;

	SAVE_OPLINE();
	function_name = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);
	if (zend_is_callable_ex(function_name, NULL, 0, NULL, &fcc, &error)) {
		func = fcc.function_handler;
		if (func->common.fn_flags & ZEND_ACC_CLOSURE) {
			/* Delay closure destruction until its invocation */
			if (IS_CV & (IS_VAR|IS_CV)) {
				ZVAL_DEREF(function_name);
			}
			ZEND_ASSERT(GC_TYPE((zend_object*)func->common.prototype) == IS_OBJECT);
			GC_REFCOUNT((zend_object*)func->common.prototype)++;
			call_info |= ZEND_CALL_CLOSURE;
		}
		called_scope = fcc.called_scope;
		object = fcc.object;
		if (object) {
			call_info |= ZEND_CALL_RELEASE_THIS;
			GC_REFCOUNT(object)++; /* For $this pointer */
		}
		if (error) {
			efree(error);
			/* This is the only soft error is_callable() can generate */
			zend_error(E_DEPRECATED,
				"Non-static method %s::%s() should not be called statically",
				ZSTR_VAL(func->common.scope->name), ZSTR_VAL(func->common.function_name));
			if (UNEXPECTED(EG(exception) != NULL)) {
				HANDLE_EXCEPTION();
			}
		}
	} else {
		zend_internal_type_error(EX_USES_STRICT_TYPES(), "%s() expects parameter 1 to be a valid callback, %s", Z_STRVAL_P(EX_CONSTANT(opline->op1)), error);
		efree(error);
		func = (zend_function*)&zend_pass_function;
		called_scope = NULL;
		object = NULL;
	}

	call = zend_vm_stack_push_call_frame(call_info,
		func, opline->extended_value, called_scope, object);
	call->prev_execute_data = EX(call);
	EX(call) = call;

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_CATCH_SPEC_CONST_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_class_entry *ce, *catch_ce;
	zend_object *exception;

	SAVE_OPLINE();
	/* Check whether an exception has been thrown, if not, jump over code */
	zend_exception_restore();
	if (EG(exception) == NULL) {
		ZEND_VM_SET_OPCODE(&EX(func)->op_array.opcodes[opline->extended_value]);
		ZEND_VM_CONTINUE(); /* CHECK_ME */
	}
	if (EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1))))) {
		catch_ce = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)));
	} else {
		catch_ce = zend_fetch_class_by_name(Z_STR_P(EX_CONSTANT(opline->op1)), EX_CONSTANT(opline->op1) + 1, ZEND_FETCH_CLASS_NO_AUTOLOAD);

		CACHE_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)), catch_ce);
	}
	ce = EG(exception)->ce;

#ifdef HAVE_DTRACE
	if (DTRACE_EXCEPTION_CAUGHT_ENABLED()) {
		DTRACE_EXCEPTION_CAUGHT((char *)ce->name);
	}
#endif /* HAVE_DTRACE */

	if (ce != catch_ce) {
		if (!catch_ce || !instanceof_function(ce, catch_ce)) {
			if (opline->result.num) {
				zend_throw_exception_internal(NULL);
				HANDLE_EXCEPTION();
			}
			ZEND_VM_SET_OPCODE(&EX(func)->op_array.opcodes[opline->extended_value]);
			ZEND_VM_CONTINUE(); /* CHECK_ME */
		}
	}

	exception = EG(exception);
	zval_ptr_dtor(EX_VAR(opline->op2.var));
	ZVAL_OBJ(EX_VAR(opline->op2.var), EG(exception));
	if (UNEXPECTED(EG(exception) != exception)) {
		GC_REFCOUNT(EG(exception))++;
		HANDLE_EXCEPTION();
	} else {
		EG(exception) = NULL;
		ZEND_VM_NEXT_OPCODE();
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_CASE_SPEC_CONST_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2, *result;

	op1 = EX_CONSTANT(opline->op1);
	op2 = _get_zval_ptr_cv_undef(execute_data, opline->op2.var);
	do {
		int result;

		if (EXPECTED(Z_TYPE_P(op1) == IS_LONG)) {
			if (EXPECTED(Z_TYPE_P(op2) == IS_LONG)) {
				result = (Z_LVAL_P(op1) == Z_LVAL_P(op2));
			} else if (EXPECTED(Z_TYPE_P(op2) == IS_DOUBLE)) {
				result = ((double)Z_LVAL_P(op1) == Z_DVAL_P(op2));
			} else {
				break;
			}
		} else if (EXPECTED(Z_TYPE_P(op1) == IS_DOUBLE)) {
			if (EXPECTED(Z_TYPE_P(op2) == IS_DOUBLE)) {
				result = (Z_DVAL_P(op1) == Z_DVAL_P(op2));
			} else if (EXPECTED(Z_TYPE_P(op2) == IS_LONG)) {
				result = (Z_DVAL_P(op1) == ((double)Z_LVAL_P(op2)));
			} else {
				break;
			}
		} else if (EXPECTED(Z_TYPE_P(op1) == IS_STRING)) {
			if (EXPECTED(Z_TYPE_P(op2) == IS_STRING)) {
				if (Z_STR_P(op1) == Z_STR_P(op2)) {
					result = 1;
				} else if (Z_STRVAL_P(op1)[0] > '9' || Z_STRVAL_P(op2)[0] > '9') {
					if (Z_STRLEN_P(op1) != Z_STRLEN_P(op2)) {
						result = 0;
					} else {
						result = (memcmp(Z_STRVAL_P(op1), Z_STRVAL_P(op2), Z_STRLEN_P(op1)) == 0);
					}
				} else {
					result = (zendi_smart_strcmp(op1, op2) == 0);
				}

			} else {
				break;
			}
		} else {
			break;
		}
		ZEND_VM_SMART_BRANCH(result, 0);
		ZVAL_BOOL(EX_VAR(opline->result.var), result);
		ZEND_VM_NEXT_OPCODE();
	} while (0);

	SAVE_OPLINE();
	if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(op1) == IS_UNDEF)) {
		op1 = GET_OP1_UNDEF_CV(op1, BP_VAR_R);
	}
	if (IS_CV == IS_CV && UNEXPECTED(Z_TYPE_P(op2) == IS_UNDEF)) {
		op2 = GET_OP2_UNDEF_CV(op2, BP_VAR_R);
	}
	result = EX_VAR(opline->result.var);
	compare_function(result, op1, op2);
	ZVAL_BOOL(result, Z_LVAL_P(result) == 0);

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ADD_ARRAY_ELEMENT_SPEC_CONST_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *expr_ptr, new_expr;

	SAVE_OPLINE();
	if ((IS_CONST == IS_VAR || IS_CONST == IS_CV) &&
	    UNEXPECTED(opline->extended_value & ZEND_ARRAY_ELEMENT_REF)) {
		expr_ptr = NULL;
		if (IS_CONST == IS_VAR && UNEXPECTED(expr_ptr == NULL)) {
			zend_throw_error(NULL, "Cannot create references to/from string offsets");
			zend_array_destroy(Z_ARRVAL_P(EX_VAR(opline->result.var)));
			HANDLE_EXCEPTION();
		}
		ZVAL_MAKE_REF(expr_ptr);
		Z_ADDREF_P(expr_ptr);

	} else {
		expr_ptr = EX_CONSTANT(opline->op1);
		if (IS_CONST == IS_TMP_VAR) {
			/* pass */
		} else if (IS_CONST == IS_CONST) {
			if (UNEXPECTED(Z_OPT_COPYABLE_P(expr_ptr))) {
				ZVAL_COPY_VALUE(&new_expr, expr_ptr);
				zval_copy_ctor_func(&new_expr);
				expr_ptr = &new_expr;
			}
		} else if (IS_CONST == IS_CV) {
			ZVAL_DEREF(expr_ptr);
			if (Z_REFCOUNTED_P(expr_ptr)) {
				Z_ADDREF_P(expr_ptr);
			}
		} else /* if (IS_CONST == IS_VAR) */ {
			if (UNEXPECTED(Z_ISREF_P(expr_ptr))) {
				zend_refcounted *ref = Z_COUNTED_P(expr_ptr);

				expr_ptr = Z_REFVAL_P(expr_ptr);
				if (UNEXPECTED(--GC_REFCOUNT(ref) == 0)) {
					ZVAL_COPY_VALUE(&new_expr, expr_ptr);
					expr_ptr = &new_expr;
					efree_size(ref, sizeof(zend_reference));
				} else if (Z_OPT_REFCOUNTED_P(expr_ptr)) {
					Z_ADDREF_P(expr_ptr);
				}
			}
		}
	}

	if (IS_CV != IS_UNUSED) {

		zval *offset = _get_zval_ptr_cv_undef(execute_data, opline->op2.var);
		zend_string *str;
		zend_ulong hval;

add_again:
		if (EXPECTED(Z_TYPE_P(offset) == IS_STRING)) {
			str = Z_STR_P(offset);
			if (IS_CV != IS_CONST) {
				if (ZEND_HANDLE_NUMERIC(str, hval)) {
					goto num_index;
				}
			}
str_index:
			zend_hash_update(Z_ARRVAL_P(EX_VAR(opline->result.var)), str, expr_ptr);
		} else if (EXPECTED(Z_TYPE_P(offset) == IS_LONG)) {
			hval = Z_LVAL_P(offset);
num_index:
			zend_hash_index_update(Z_ARRVAL_P(EX_VAR(opline->result.var)), hval, expr_ptr);
		} else if ((IS_CV & (IS_VAR|IS_CV)) && EXPECTED(Z_TYPE_P(offset) == IS_REFERENCE)) {
			offset = Z_REFVAL_P(offset);
			goto add_again;
		} else if (Z_TYPE_P(offset) == IS_NULL) {
			str = ZSTR_EMPTY_ALLOC();
			goto str_index;
		} else if (Z_TYPE_P(offset) == IS_DOUBLE) {
			hval = zend_dval_to_lval(Z_DVAL_P(offset));
			goto num_index;
		} else if (Z_TYPE_P(offset) == IS_FALSE) {
			hval = 0;
			goto num_index;
		} else if (Z_TYPE_P(offset) == IS_TRUE) {
			hval = 1;
			goto num_index;
		} else if (IS_CV == IS_CV && Z_TYPE_P(offset) == IS_UNDEF) {
			GET_OP2_UNDEF_CV(offset, BP_VAR_R);
			str = ZSTR_EMPTY_ALLOC();
			goto str_index;
		} else {
			zend_error(E_WARNING, "Illegal offset type");
			zval_ptr_dtor(expr_ptr);
		}

	} else {
		zend_hash_next_index_insert(Z_ARRVAL_P(EX_VAR(opline->result.var)), expr_ptr);
	}
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_INIT_ARRAY_SPEC_CONST_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	zval *array;
	uint32_t size;
	USE_OPLINE

	array = EX_VAR(opline->result.var);
	if (IS_CONST != IS_UNUSED) {
		size = opline->extended_value >> ZEND_ARRAY_SIZE_SHIFT;
	} else {
		size = 0;
	}
	ZVAL_NEW_ARR(array);
	zend_hash_init(Z_ARRVAL_P(array), size, NULL, ZVAL_PTR_DTOR, 0);

	if (IS_CONST != IS_UNUSED) {
		/* Explicitly initialize array as not-packed if flag is set */
		if (opline->extended_value & ZEND_ARRAY_NOT_PACKED) {
			zend_hash_real_init(Z_ARRVAL_P(array), 0);
		}
	}

	if (IS_CONST == IS_UNUSED) {
		ZEND_VM_NEXT_OPCODE();
#if 0 || (IS_CONST != IS_UNUSED)
	} else {
		ZEND_VM_TAIL_CALL(ZEND_ADD_ARRAY_ELEMENT_SPEC_CONST_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS_PASSTHRU));
#endif
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ISSET_ISEMPTY_DIM_OBJ_SPEC_CONST_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *container;
	int result;
	zend_ulong hval;
	zval *offset;

	SAVE_OPLINE();
	container = EX_CONSTANT(opline->op1);

	if (IS_CONST == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}

	offset = _get_zval_ptr_cv_undef(execute_data, opline->op2.var);

	if (IS_CONST != IS_UNUSED && EXPECTED(Z_TYPE_P(container) == IS_ARRAY)) {
		HashTable *ht;
		zval *value;
		zend_string *str;

isset_dim_obj_array:
		ht = Z_ARRVAL_P(container);
isset_again:
		if (EXPECTED(Z_TYPE_P(offset) == IS_STRING)) {
			str = Z_STR_P(offset);
			if (IS_CV != IS_CONST) {
				if (ZEND_HANDLE_NUMERIC(str, hval)) {
					goto num_index_prop;
				}
			}
str_index_prop:
			value = zend_hash_find_ind(ht, str);
		} else if (EXPECTED(Z_TYPE_P(offset) == IS_LONG)) {
			hval = Z_LVAL_P(offset);
num_index_prop:
			value = zend_hash_index_find(ht, hval);
		} else if ((IS_CV & (IS_VAR|IS_CV)) && EXPECTED(Z_ISREF_P(offset))) {
			offset = Z_REFVAL_P(offset);
			goto isset_again;
		} else if (Z_TYPE_P(offset) == IS_DOUBLE) {
			hval = zend_dval_to_lval(Z_DVAL_P(offset));
			goto num_index_prop;
		} else if (Z_TYPE_P(offset) == IS_NULL) {
			str = ZSTR_EMPTY_ALLOC();
			goto str_index_prop;
		} else if (Z_TYPE_P(offset) == IS_FALSE) {
			hval = 0;
			goto num_index_prop;
		} else if (Z_TYPE_P(offset) == IS_TRUE) {
			hval = 1;
			goto num_index_prop;
		} else if (Z_TYPE_P(offset) == IS_RESOURCE) {
			hval = Z_RES_HANDLE_P(offset);
			goto num_index_prop;
		} else if (IS_CV == IS_CV && Z_TYPE_P(offset) == IS_UNDEF) {
			GET_OP2_UNDEF_CV(offset, BP_VAR_R);
			str = ZSTR_EMPTY_ALLOC();
			goto str_index_prop;
		} else {
			zend_error(E_WARNING, "Illegal offset type in isset or empty");
			goto isset_not_found;
		}

		if (opline->extended_value & ZEND_ISSET) {
			/* > IS_NULL means not IS_UNDEF and not IS_NULL */
			result = value != NULL && Z_TYPE_P(value) > IS_NULL &&
			    (!Z_ISREF_P(value) || Z_TYPE_P(Z_REFVAL_P(value)) != IS_NULL);
		} else /* if (opline->extended_value & ZEND_ISEMPTY) */ {
			result = (value == NULL || !i_zend_is_true(value));
		}
		goto isset_dim_obj_exit;
	} else if ((IS_CONST & (IS_VAR|IS_CV)) && Z_ISREF_P(container)) {
		container = Z_REFVAL_P(container);
		if (EXPECTED(Z_TYPE_P(container) == IS_ARRAY)) {
			goto isset_dim_obj_array;
		}
	}

	if (IS_CV == IS_CV && UNEXPECTED(Z_TYPE_P(offset) == IS_UNDEF)) {
		offset = GET_OP2_UNDEF_CV(offset, BP_VAR_R);
	}

	if (IS_CONST == IS_UNUSED ||
	    (IS_CONST != IS_CONST && EXPECTED(Z_TYPE_P(container) == IS_OBJECT))) {
		if (EXPECTED(Z_OBJ_HT_P(container)->has_dimension)) {
			result =
				((opline->extended_value & ZEND_ISSET) == 0) ^
				Z_OBJ_HT_P(container)->has_dimension(container, offset, (opline->extended_value & ZEND_ISSET) == 0);
		} else {
			zend_error(E_NOTICE, "Trying to check element of non-array");
			goto isset_not_found;
		}
	} else if (EXPECTED(Z_TYPE_P(container) == IS_STRING)) { /* string offsets */
		zend_long lval;

		if (EXPECTED(Z_TYPE_P(offset) == IS_LONG)) {
			lval = Z_LVAL_P(offset);
isset_str_offset:
			if (EXPECTED(lval >= 0) && (size_t)lval < Z_STRLEN_P(container)) {
				if (opline->extended_value & ZEND_ISSET) {
					result = 1;
				} else {
					result = (Z_STRVAL_P(container)[lval] == '0');
				}
			} else {
				goto isset_not_found;
			}
		} else {
			if (IS_CV & (IS_CV|IS_VAR)) {
				ZVAL_DEREF(offset);
			}
			if (Z_TYPE_P(offset) < IS_STRING /* simple scalar types */
					|| (Z_TYPE_P(offset) == IS_STRING /* or numeric string */
						&& IS_LONG == is_numeric_string(Z_STRVAL_P(offset), Z_STRLEN_P(offset), NULL, NULL, 0))) {
				lval = zval_get_long(offset);
				goto isset_str_offset;
			}
			goto isset_not_found;
		}
	} else {
isset_not_found:
		result = ((opline->extended_value & ZEND_ISSET) == 0);
	}

isset_dim_obj_exit:


	ZEND_VM_SMART_BRANCH(result, 1);
	ZVAL_BOOL(EX_VAR(opline->result.var), result);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ISSET_ISEMPTY_PROP_OBJ_SPEC_CONST_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *container;
	int result;
	zval *offset;

	SAVE_OPLINE();
	container = EX_CONSTANT(opline->op1);

	if (IS_CONST == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}

	offset = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);

	if (IS_CONST == IS_CONST ||
	    (IS_CONST != IS_UNUSED && UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT))) {
		if ((IS_CONST & (IS_VAR|IS_CV)) && Z_ISREF_P(container)) {
			container = Z_REFVAL_P(container);
			if (UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT)) {
				goto isset_no_object;
			}
		} else {
			goto isset_no_object;
		}
	}
	if (UNEXPECTED(!Z_OBJ_HT_P(container)->has_property)) {
		zend_error(E_NOTICE, "Trying to check property of non-object");
isset_no_object:
		result = ((opline->extended_value & ZEND_ISSET) == 0);
	} else {
		result =
			((opline->extended_value & ZEND_ISSET) == 0) ^
			Z_OBJ_HT_P(container)->has_property(container, offset, (opline->extended_value & ZEND_ISSET) == 0, ((IS_CV == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(offset)) : NULL));
	}


	ZEND_VM_SMART_BRANCH(result, 1);
	ZVAL_BOOL(EX_VAR(opline->result.var), result);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_YIELD_SPEC_CONST_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zend_generator *generator = zend_get_running_generator(execute_data);

	SAVE_OPLINE();
	if (UNEXPECTED(generator->flags & ZEND_GENERATOR_FORCED_CLOSE)) {
		zend_throw_error(NULL, "Cannot yield from finally in a force-closed generator");


		HANDLE_EXCEPTION();
	}

	/* Destroy the previously yielded value */
	zval_ptr_dtor(&generator->value);

	/* Destroy the previously yielded key */
	zval_ptr_dtor(&generator->key);

	/* Set the new yielded value */
	if (IS_CONST != IS_UNUSED) {


		if (UNEXPECTED(EX(func)->op_array.fn_flags & ZEND_ACC_RETURN_REFERENCE)) {
			/* Constants and temporary variables aren't yieldable by reference,
			 * but we still allow them with a notice. */
			if (IS_CONST == IS_CONST || IS_CONST == IS_TMP_VAR) {
				zval *value;

				zend_error(E_NOTICE, "Only variable references should be yielded by reference");

				value = EX_CONSTANT(opline->op1);
				ZVAL_COPY_VALUE(&generator->value, value);
				if (IS_CONST != IS_CONST) {
					if (UNEXPECTED(Z_OPT_COPYABLE(generator->value))) {
						zval_copy_ctor_func(&generator->value);
					}
				}
			} else {
				zval *value_ptr = NULL;

				if (IS_CONST == IS_VAR && UNEXPECTED(value_ptr == NULL)) {
					zend_throw_error(NULL, "Cannot yield string offsets by reference");

					HANDLE_EXCEPTION();
				}

				/* If a function call result is yielded and the function did
				 * not return by reference we throw a notice. */
				if (IS_CONST == IS_VAR &&
				    (value_ptr == &EG(uninitialized_zval) ||
				     (opline->extended_value == ZEND_RETURNS_FUNCTION &&
				      !(Z_VAR_FLAGS_P(value_ptr) & IS_VAR_RET_REF)))) {
					zend_error(E_NOTICE, "Only variable references should be yielded by reference");
				} else {
					ZVAL_MAKE_REF(value_ptr);
				}
				ZVAL_COPY(&generator->value, value_ptr);

			}
		} else {
			zval *value = EX_CONSTANT(opline->op1);

			/* Consts, temporary variables and references need copying */
			if (IS_CONST == IS_CONST) {
				ZVAL_COPY_VALUE(&generator->value, value);
				if (UNEXPECTED(Z_OPT_COPYABLE(generator->value))) {
					zval_copy_ctor_func(&generator->value);
				}
			} else if (IS_CONST == IS_TMP_VAR) {
				ZVAL_COPY_VALUE(&generator->value, value);
            } else if ((IS_CONST & (IS_VAR|IS_CV)) && Z_ISREF_P(value)) {
				ZVAL_COPY(&generator->value, Z_REFVAL_P(value));

			} else {
				ZVAL_COPY_VALUE(&generator->value, value);
				if (IS_CONST == IS_CV) {
					if (Z_OPT_REFCOUNTED_P(value)) Z_ADDREF_P(value);
				}
			}
		}
	} else {
		/* If no value was specified yield null */
		ZVAL_NULL(&generator->value);
	}

	/* Set the new yielded key */
	if (IS_CV != IS_UNUSED) {

		zval *key = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);

		/* Consts, temporary variables and references need copying */
		if (IS_CV == IS_CONST) {
			ZVAL_COPY_VALUE(&generator->key, key);
			if (UNEXPECTED(Z_OPT_COPYABLE(generator->key))) {
				zval_copy_ctor_func(&generator->key);
			}
		} else if (IS_CV == IS_TMP_VAR) {
			ZVAL_COPY_VALUE(&generator->key, key);
		} else if ((IS_CV & (IS_VAR|IS_CV)) && Z_ISREF_P(key)) {
			ZVAL_COPY(&generator->key, Z_REFVAL_P(key));

		} else {
			ZVAL_COPY_VALUE(&generator->key, key);
			if (IS_CV == IS_CV) {
				if (Z_OPT_REFCOUNTED_P(key)) Z_ADDREF_P(key);
			}
		}

		if (Z_TYPE(generator->key) == IS_LONG
		    && Z_LVAL(generator->key) > generator->largest_used_integer_key
		) {
			generator->largest_used_integer_key = Z_LVAL(generator->key);
		}
	} else {
		/* If no key was specified we use auto-increment keys */
		generator->largest_used_integer_key++;
		ZVAL_LONG(&generator->key, generator->largest_used_integer_key);
	}

	if (RETURN_VALUE_USED(opline)) {
		/* If the return value of yield is used set the send
		 * target and initialize it to NULL */
		generator->send_target = EX_VAR(opline->result.var);
		ZVAL_NULL(generator->send_target);
	} else {
		generator->send_target = NULL;
	}

	/* We increment to the next op, so we are at the correct position when the
	 * generator is resumed. */
	ZEND_VM_INC_OPCODE();

	/* The GOTO VM uses a local opline variable. We need to set the opline
	 * variable in execute_data so we don't resume at an old position. */
	SAVE_OPLINE();

	ZEND_VM_RETURN();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_POW_SPEC_CONST_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2;

	SAVE_OPLINE();
	op1 = EX_CONSTANT(opline->op1);
	op2 = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);
	pow_function(EX_VAR(opline->result.var), op1, op2);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ADD_SPEC_CONST_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op2;
	zval *op1, *op2, *result;

	op1 = EX_CONSTANT(opline->op1);
	op2 = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);
	if (EXPECTED(Z_TYPE_INFO_P(op1) == IS_LONG)) {
		if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_LONG)) {
			result = EX_VAR(opline->result.var);
			fast_long_add_function(result, op1, op2);
			ZEND_VM_NEXT_OPCODE();
		} else if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_DOUBLE)) {
			result = EX_VAR(opline->result.var);
			ZVAL_DOUBLE(result, ((double)Z_LVAL_P(op1)) + Z_DVAL_P(op2));
			ZEND_VM_NEXT_OPCODE();
		}
	} else if (EXPECTED(Z_TYPE_INFO_P(op1) == IS_DOUBLE)) {
		if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_DOUBLE)) {
			result = EX_VAR(opline->result.var);
			ZVAL_DOUBLE(result, Z_DVAL_P(op1) + Z_DVAL_P(op2));
			ZEND_VM_NEXT_OPCODE();
		} else if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_LONG)) {
			result = EX_VAR(opline->result.var);
			ZVAL_DOUBLE(result, Z_DVAL_P(op1) + ((double)Z_LVAL_P(op2)));
			ZEND_VM_NEXT_OPCODE();
		}
	}

	SAVE_OPLINE();
	if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(op1) == IS_UNDEF)) {
		op1 = GET_OP1_UNDEF_CV(op1, BP_VAR_R);
	}
	if ((IS_TMP_VAR|IS_VAR) == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(op2) == IS_UNDEF)) {
		op2 = GET_OP2_UNDEF_CV(op2, BP_VAR_R);
	}
	add_function(EX_VAR(opline->result.var), op1, op2);

	zval_ptr_dtor_nogc(free_op2);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_SUB_SPEC_CONST_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op2;
	zval *op1, *op2, *result;

	op1 = EX_CONSTANT(opline->op1);
	op2 = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);
	if (EXPECTED(Z_TYPE_INFO_P(op1) == IS_LONG)) {
		if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_LONG)) {
			result = EX_VAR(opline->result.var);
			fast_long_sub_function(result, op1, op2);
			ZEND_VM_NEXT_OPCODE();
		} else if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_DOUBLE)) {
			result = EX_VAR(opline->result.var);
			ZVAL_DOUBLE(result, ((double)Z_LVAL_P(op1)) - Z_DVAL_P(op2));
			ZEND_VM_NEXT_OPCODE();
		}
	} else if (EXPECTED(Z_TYPE_INFO_P(op1) == IS_DOUBLE)) {
		if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_DOUBLE)) {
			result = EX_VAR(opline->result.var);
			ZVAL_DOUBLE(result, Z_DVAL_P(op1) - Z_DVAL_P(op2));
			ZEND_VM_NEXT_OPCODE();
		} else if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_LONG)) {
			result = EX_VAR(opline->result.var);
			ZVAL_DOUBLE(result, Z_DVAL_P(op1) - ((double)Z_LVAL_P(op2)));
			ZEND_VM_NEXT_OPCODE();
		}
	}

	SAVE_OPLINE();
	if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(op1) == IS_UNDEF)) {
		op1 = GET_OP1_UNDEF_CV(op1, BP_VAR_R);
	}
	if ((IS_TMP_VAR|IS_VAR) == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(op2) == IS_UNDEF)) {
		op2 = GET_OP2_UNDEF_CV(op2, BP_VAR_R);
	}
	sub_function(EX_VAR(opline->result.var), op1, op2);

	zval_ptr_dtor_nogc(free_op2);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_MUL_SPEC_CONST_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op2;
	zval *op1, *op2, *result;

	op1 = EX_CONSTANT(opline->op1);
	op2 = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);
	if (EXPECTED(Z_TYPE_INFO_P(op1) == IS_LONG)) {
		if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_LONG)) {
			zend_long overflow;

			result = EX_VAR(opline->result.var);
			ZEND_SIGNED_MULTIPLY_LONG(Z_LVAL_P(op1), Z_LVAL_P(op2), Z_LVAL_P(result), Z_DVAL_P(result), overflow);
			Z_TYPE_INFO_P(result) = overflow ? IS_DOUBLE : IS_LONG;
			ZEND_VM_NEXT_OPCODE();
		} else if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_DOUBLE)) {
			result = EX_VAR(opline->result.var);
			ZVAL_DOUBLE(result, ((double)Z_LVAL_P(op1)) * Z_DVAL_P(op2));
			ZEND_VM_NEXT_OPCODE();
		}
	} else if (EXPECTED(Z_TYPE_INFO_P(op1) == IS_DOUBLE)) {
		if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_DOUBLE)) {
			result = EX_VAR(opline->result.var);
			ZVAL_DOUBLE(result, Z_DVAL_P(op1) * Z_DVAL_P(op2));
			ZEND_VM_NEXT_OPCODE();
		} else if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_LONG)) {
			result = EX_VAR(opline->result.var);
			ZVAL_DOUBLE(result, Z_DVAL_P(op1) * ((double)Z_LVAL_P(op2)));
			ZEND_VM_NEXT_OPCODE();
		}
	}

	SAVE_OPLINE();
	if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(op1) == IS_UNDEF)) {
		op1 = GET_OP1_UNDEF_CV(op1, BP_VAR_R);
	}
	if ((IS_TMP_VAR|IS_VAR) == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(op2) == IS_UNDEF)) {
		op2 = GET_OP2_UNDEF_CV(op2, BP_VAR_R);
	}
	mul_function(EX_VAR(opline->result.var), op1, op2);

	zval_ptr_dtor_nogc(free_op2);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_DIV_SPEC_CONST_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op2;
	zval *op1, *op2;

	SAVE_OPLINE();
	op1 = EX_CONSTANT(opline->op1);
	op2 = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);
	fast_div_function(EX_VAR(opline->result.var), op1, op2);

	zval_ptr_dtor_nogc(free_op2);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_MOD_SPEC_CONST_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op2;
	zval *op1, *op2, *result;

	op1 = EX_CONSTANT(opline->op1);
	op2 = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);
	if (EXPECTED(Z_TYPE_INFO_P(op1) == IS_LONG)) {
		if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_LONG)) {
			result = EX_VAR(opline->result.var);
			if (UNEXPECTED(Z_LVAL_P(op2) == 0)) {
				SAVE_OPLINE();
				zend_throw_exception_ex(zend_ce_division_by_zero_error, 0, "Modulo by zero");
				HANDLE_EXCEPTION();
			} else if (UNEXPECTED(Z_LVAL_P(op2) == -1)) {
				/* Prevent overflow error/crash if op1==ZEND_LONG_MIN */
				ZVAL_LONG(result, 0);
			} else {
				ZVAL_LONG(result, Z_LVAL_P(op1) % Z_LVAL_P(op2));
			}
			ZEND_VM_NEXT_OPCODE();
		}
	}

	SAVE_OPLINE();
	if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(op1) == IS_UNDEF)) {
		op1 = GET_OP1_UNDEF_CV(op1, BP_VAR_R);
	}
	if ((IS_TMP_VAR|IS_VAR) == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(op2) == IS_UNDEF)) {
		op2 = GET_OP2_UNDEF_CV(op2, BP_VAR_R);
	}
	mod_function(EX_VAR(opline->result.var), op1, op2);

	zval_ptr_dtor_nogc(free_op2);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_SL_SPEC_CONST_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op2;
	zval *op1, *op2;

	SAVE_OPLINE();
	op1 = EX_CONSTANT(opline->op1);
	op2 = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);
	shift_left_function(EX_VAR(opline->result.var), op1, op2);

	zval_ptr_dtor_nogc(free_op2);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_SR_SPEC_CONST_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op2;
	zval *op1, *op2;

	SAVE_OPLINE();
	op1 = EX_CONSTANT(opline->op1);
	op2 = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);
	shift_right_function(EX_VAR(opline->result.var), op1, op2);

	zval_ptr_dtor_nogc(free_op2);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_CONCAT_SPEC_CONST_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op2;
	zval *op1, *op2;

	SAVE_OPLINE();
	op1 = EX_CONSTANT(opline->op1);
	op2 = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);

	do {
		if ((IS_CONST == IS_CONST || EXPECTED(Z_TYPE_P(op1) == IS_STRING)) &&
		    ((IS_TMP_VAR|IS_VAR) == IS_CONST || EXPECTED(Z_TYPE_P(op2) == IS_STRING))) {
			zend_string *op1_str = Z_STR_P(op1);
			zend_string *op2_str = Z_STR_P(op2);
			zend_string *str;

			if (IS_CONST != IS_CONST) {
				if (UNEXPECTED(ZSTR_LEN(op1_str) == 0)) {
					ZVAL_STR_COPY(EX_VAR(opline->result.var), op2_str);

					break;
				}
			}
			if ((IS_TMP_VAR|IS_VAR) != IS_CONST) {
				if (UNEXPECTED(ZSTR_LEN(op2_str) == 0)) {
					ZVAL_STR_COPY(EX_VAR(opline->result.var), op1_str);

					break;
				}
			}
			if (IS_CONST != IS_CONST && IS_CONST != IS_CV &&
			    !ZSTR_IS_INTERNED(op1_str) && GC_REFCOUNT(op1_str) == 1) {
			    size_t len = ZSTR_LEN(op1_str);

				str = zend_string_realloc(op1_str, len + ZSTR_LEN(op2_str), 0);
				memcpy(ZSTR_VAL(str) + len, ZSTR_VAL(op2_str), ZSTR_LEN(op2_str)+1);
				ZVAL_NEW_STR(EX_VAR(opline->result.var), str);
				break;
			} else {
				str = zend_string_alloc(ZSTR_LEN(op1_str) + ZSTR_LEN(op2_str), 0);
				memcpy(ZSTR_VAL(str), ZSTR_VAL(op1_str), ZSTR_LEN(op1_str));
				memcpy(ZSTR_VAL(str) + ZSTR_LEN(op1_str), ZSTR_VAL(op2_str), ZSTR_LEN(op2_str)+1);
				ZVAL_NEW_STR(EX_VAR(opline->result.var), str);
			}
		} else {
			if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(op1) == IS_UNDEF)) {
				op1 = GET_OP1_UNDEF_CV(op1, BP_VAR_R);
			}
			if ((IS_TMP_VAR|IS_VAR) == IS_CV && UNEXPECTED(Z_TYPE_P(op2) == IS_UNDEF)) {
				op2 = GET_OP2_UNDEF_CV(op2, BP_VAR_R);
			}
			concat_function(EX_VAR(opline->result.var), op1, op2);
		}

	} while (0);
	zval_ptr_dtor_nogc(free_op2);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_IS_EQUAL_SPEC_CONST_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op2;
	zval *op1, *op2, *result;

	op1 = EX_CONSTANT(opline->op1);
	op2 = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);
	do {
		int result;

		if (EXPECTED(Z_TYPE_P(op1) == IS_LONG)) {
			if (EXPECTED(Z_TYPE_P(op2) == IS_LONG)) {
				result = (Z_LVAL_P(op1) == Z_LVAL_P(op2));
			} else if (EXPECTED(Z_TYPE_P(op2) == IS_DOUBLE)) {
				result = ((double)Z_LVAL_P(op1) == Z_DVAL_P(op2));
			} else {
				break;
			}
		} else if (EXPECTED(Z_TYPE_P(op1) == IS_DOUBLE)) {
			if (EXPECTED(Z_TYPE_P(op2) == IS_DOUBLE)) {
				result = (Z_DVAL_P(op1) == Z_DVAL_P(op2));
			} else if (EXPECTED(Z_TYPE_P(op2) == IS_LONG)) {
				result = (Z_DVAL_P(op1) == ((double)Z_LVAL_P(op2)));
			} else {
				break;
			}
		} else if (EXPECTED(Z_TYPE_P(op1) == IS_STRING)) {
			if (EXPECTED(Z_TYPE_P(op2) == IS_STRING)) {
				if (Z_STR_P(op1) == Z_STR_P(op2)) {
					result = 1;
				} else if (Z_STRVAL_P(op1)[0] > '9' || Z_STRVAL_P(op2)[0] > '9') {
					if (Z_STRLEN_P(op1) != Z_STRLEN_P(op2)) {
						result = 0;
					} else {
						result = (memcmp(Z_STRVAL_P(op1), Z_STRVAL_P(op2), Z_STRLEN_P(op1)) == 0);
					}
				} else {
					result = (zendi_smart_strcmp(op1, op2) == 0);
				}

				zval_ptr_dtor_nogc(free_op2);
			} else {
				break;
			}
		} else {
			break;
		}
		ZEND_VM_SMART_BRANCH(result, 0);
		ZVAL_BOOL(EX_VAR(opline->result.var), result);
		ZEND_VM_NEXT_OPCODE();
	} while (0);

	SAVE_OPLINE();
	if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(op1) == IS_UNDEF)) {
		op1 = GET_OP1_UNDEF_CV(op1, BP_VAR_R);
	}
	if ((IS_TMP_VAR|IS_VAR) == IS_CV && UNEXPECTED(Z_TYPE_P(op2) == IS_UNDEF)) {
		op2 = GET_OP2_UNDEF_CV(op2, BP_VAR_R);
	}
	result = EX_VAR(opline->result.var);
	compare_function(result, op1, op2);
	ZVAL_BOOL(result, Z_LVAL_P(result) == 0);

	zval_ptr_dtor_nogc(free_op2);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_IS_NOT_EQUAL_SPEC_CONST_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op2;
	zval *op1, *op2, *result;

	op1 = EX_CONSTANT(opline->op1);
	op2 = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);
	do {
		int result;

		if (EXPECTED(Z_TYPE_P(op1) == IS_LONG)) {
			if (EXPECTED(Z_TYPE_P(op2) == IS_LONG)) {
				result = (Z_LVAL_P(op1) != Z_LVAL_P(op2));
			} else if (EXPECTED(Z_TYPE_P(op2) == IS_DOUBLE)) {
				result = ((double)Z_LVAL_P(op1) != Z_DVAL_P(op2));
			} else {
				break;
			}
		} else if (EXPECTED(Z_TYPE_P(op1) == IS_DOUBLE)) {
			if (EXPECTED(Z_TYPE_P(op2) == IS_DOUBLE)) {
				result = (Z_DVAL_P(op1) != Z_DVAL_P(op2));
			} else if (EXPECTED(Z_TYPE_P(op2) == IS_LONG)) {
				result = (Z_DVAL_P(op1) != ((double)Z_LVAL_P(op2)));
			} else {
				break;
			}
		} else if (EXPECTED(Z_TYPE_P(op1) == IS_STRING)) {
			if (EXPECTED(Z_TYPE_P(op2) == IS_STRING)) {
				if (Z_STR_P(op1) == Z_STR_P(op2)) {
					result = 0;
				} else if (Z_STRVAL_P(op1)[0] > '9' || Z_STRVAL_P(op2)[0] > '9') {
					if (Z_STRLEN_P(op1) != Z_STRLEN_P(op2)) {
						result = 1;
					} else {
						result = (memcmp(Z_STRVAL_P(op1), Z_STRVAL_P(op2), Z_STRLEN_P(op1)) != 0);
					}
				} else {
					result = (zendi_smart_strcmp(op1, op2) != 0);
				}

				zval_ptr_dtor_nogc(free_op2);
			} else {
				break;
			}
		} else {
			break;
		}
		ZEND_VM_SMART_BRANCH(result, 0);
		ZVAL_BOOL(EX_VAR(opline->result.var), result);
		ZEND_VM_NEXT_OPCODE();
	} while (0);

	SAVE_OPLINE();
	if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(op1) == IS_UNDEF)) {
		op1 = GET_OP1_UNDEF_CV(op1, BP_VAR_R);
	}
	if ((IS_TMP_VAR|IS_VAR) == IS_CV && UNEXPECTED(Z_TYPE_P(op2) == IS_UNDEF)) {
		op2 = GET_OP2_UNDEF_CV(op2, BP_VAR_R);
	}
	result = EX_VAR(opline->result.var);
	compare_function(result, op1, op2);
	ZVAL_BOOL(result, Z_LVAL_P(result) != 0);

	zval_ptr_dtor_nogc(free_op2);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_IS_SMALLER_SPEC_CONST_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op2;
	zval *op1, *op2, *result;

	op1 = EX_CONSTANT(opline->op1);
	op2 = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);
	do {
		int result;

		if (EXPECTED(Z_TYPE_INFO_P(op1) == IS_LONG)) {
			if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_LONG)) {
				result = (Z_LVAL_P(op1) < Z_LVAL_P(op2));
			} else if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_DOUBLE)) {
				result = ((double)Z_LVAL_P(op1) < Z_DVAL_P(op2));
			} else {
				break;
			}
		} else if (EXPECTED(Z_TYPE_INFO_P(op1) == IS_DOUBLE)) {
			if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_DOUBLE)) {
				result = (Z_DVAL_P(op1) < Z_DVAL_P(op2));
			} else if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_LONG)) {
				result = (Z_DVAL_P(op1) < ((double)Z_LVAL_P(op2)));
			} else {
				break;
			}
		} else {
			break;
		}
		ZEND_VM_SMART_BRANCH(result, 0);
		ZVAL_BOOL(EX_VAR(opline->result.var), result);
		ZEND_VM_NEXT_OPCODE();
	} while (0);

	SAVE_OPLINE();
	if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(op1) == IS_UNDEF)) {
		op1 = GET_OP1_UNDEF_CV(op1, BP_VAR_R);
	}
	if ((IS_TMP_VAR|IS_VAR) == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(op2) == IS_UNDEF)) {
		op2 = GET_OP2_UNDEF_CV(op2, BP_VAR_R);
	}
	result = EX_VAR(opline->result.var);
	compare_function(result, op1, op2);
	ZVAL_BOOL(result, Z_LVAL_P(result) < 0);

	zval_ptr_dtor_nogc(free_op2);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_IS_SMALLER_OR_EQUAL_SPEC_CONST_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op2;
	zval *op1, *op2, *result;

	op1 = EX_CONSTANT(opline->op1);
	op2 = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);
	do {
		int result;

		if (EXPECTED(Z_TYPE_INFO_P(op1) == IS_LONG)) {
			if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_LONG)) {
				result = (Z_LVAL_P(op1) <= Z_LVAL_P(op2));
			} else if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_DOUBLE)) {
				result = ((double)Z_LVAL_P(op1) <= Z_DVAL_P(op2));
			} else {
				break;
			}
		} else if (EXPECTED(Z_TYPE_INFO_P(op1) == IS_DOUBLE)) {
			if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_DOUBLE)) {
				result = (Z_DVAL_P(op1) <= Z_DVAL_P(op2));
			} else if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_LONG)) {
				result = (Z_DVAL_P(op1) <= ((double)Z_LVAL_P(op2)));
			} else {
				break;
			}
		} else {
			break;
		}
		ZEND_VM_SMART_BRANCH(result, 0);
		ZVAL_BOOL(EX_VAR(opline->result.var), result);
		ZEND_VM_NEXT_OPCODE();
	} while (0);

	SAVE_OPLINE();
	if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(op1) == IS_UNDEF)) {
		op1 = GET_OP1_UNDEF_CV(op1, BP_VAR_R);
	}
	if ((IS_TMP_VAR|IS_VAR) == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(op2) == IS_UNDEF)) {
		op2 = GET_OP2_UNDEF_CV(op2, BP_VAR_R);
	}
	result = EX_VAR(opline->result.var);
	compare_function(result, op1, op2);
	ZVAL_BOOL(result, Z_LVAL_P(result) <= 0);

	zval_ptr_dtor_nogc(free_op2);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_SPACESHIP_SPEC_CONST_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op2;
	zval *op1, *op2;

	SAVE_OPLINE();
	op1 = EX_CONSTANT(opline->op1);
	op2 = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);
	compare_function(EX_VAR(opline->result.var), op1, op2);

	zval_ptr_dtor_nogc(free_op2);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_BW_OR_SPEC_CONST_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op2;
	zval *op1, *op2;

	SAVE_OPLINE();
	op1 = EX_CONSTANT(opline->op1);
	op2 = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);
	bitwise_or_function(EX_VAR(opline->result.var), op1, op2);

	zval_ptr_dtor_nogc(free_op2);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_BW_AND_SPEC_CONST_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op2;
	zval *op1, *op2;

	SAVE_OPLINE();
	op1 = EX_CONSTANT(opline->op1);
	op2 = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);
	bitwise_and_function(EX_VAR(opline->result.var), op1, op2);

	zval_ptr_dtor_nogc(free_op2);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_BW_XOR_SPEC_CONST_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op2;
	zval *op1, *op2;

	SAVE_OPLINE();
	op1 = EX_CONSTANT(opline->op1);
	op2 = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);
	bitwise_xor_function(EX_VAR(opline->result.var), op1, op2);

	zval_ptr_dtor_nogc(free_op2);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_BOOL_XOR_SPEC_CONST_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op2;
	zval *op1, *op2;

	SAVE_OPLINE();
	op1 = EX_CONSTANT(opline->op1);
	op2 = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);
	boolean_xor_function(EX_VAR(opline->result.var), op1, op2);

	zval_ptr_dtor_nogc(free_op2);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_DIM_R_SPEC_CONST_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op2;
	zval *container;

	SAVE_OPLINE();
	container = EX_CONSTANT(opline->op1);
	zend_fetch_dimension_address_read_R(EX_VAR(opline->result.var), container, _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2), (IS_TMP_VAR|IS_VAR));
	zval_ptr_dtor_nogc(free_op2);

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_DIM_IS_SPEC_CONST_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op2;
	zval *container;

	SAVE_OPLINE();
	container = EX_CONSTANT(opline->op1);
	zend_fetch_dimension_address_read_IS(EX_VAR(opline->result.var), container, _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2), (IS_TMP_VAR|IS_VAR));
	zval_ptr_dtor_nogc(free_op2);

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_DIM_FUNC_ARG_SPEC_CONST_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *container;
	zend_free_op free_op1, free_op2;

	SAVE_OPLINE();

	if (zend_is_by_ref_func_arg_fetch(opline, EX(call))) {
        if (IS_CONST == IS_CONST || IS_CONST == IS_TMP_VAR) {
            zend_throw_error(NULL, "Cannot use temporary expression in write context");
			zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));

			HANDLE_EXCEPTION();
        }
		container = NULL;
		if (IS_CONST == IS_VAR && UNEXPECTED(container == NULL)) {
			zend_throw_error(NULL, "Cannot use string offset as an array");
			zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
			HANDLE_EXCEPTION();
		}
		zend_fetch_dimension_address_W(EX_VAR(opline->result.var), container, _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2), (IS_TMP_VAR|IS_VAR));
		if (IS_CONST == IS_VAR && READY_TO_DESTROY(free_op1)) {
			EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 1);
		}
		zval_ptr_dtor_nogc(free_op2);

	} else {
		if ((IS_TMP_VAR|IS_VAR) == IS_UNUSED) {
			zend_throw_error(NULL, "Cannot use [] for reading");
			zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));

			HANDLE_EXCEPTION();
		}
		container = EX_CONSTANT(opline->op1);
		zend_fetch_dimension_address_read_R(EX_VAR(opline->result.var), container, _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2), (IS_TMP_VAR|IS_VAR));
		zval_ptr_dtor_nogc(free_op2);

	}
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_R_SPEC_CONST_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *container;
	zend_free_op free_op2;
	zval *offset;

	SAVE_OPLINE();
	container = EX_CONSTANT(opline->op1);

	if (IS_CONST == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");
		zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
		HANDLE_EXCEPTION();
	}

	offset = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);

	if (IS_CONST == IS_CONST ||
	    (IS_CONST != IS_UNUSED && UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT))) {
		if ((IS_CONST & (IS_VAR|IS_CV)) && Z_ISREF_P(container)) {
			container = Z_REFVAL_P(container);
			if (UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT)) {
				goto fetch_obj_r_no_object;
			}
		} else {
			goto fetch_obj_r_no_object;
		}
	}

	/* here we are sure we are dealing with an object */
	do {
		zend_object *zobj = Z_OBJ_P(container);
		zval *retval;

		if ((IS_TMP_VAR|IS_VAR) == IS_CONST &&
			EXPECTED(zobj->ce == CACHED_PTR(Z_CACHE_SLOT_P(offset)))) {
			uint32_t prop_offset = (uint32_t)(intptr_t)CACHED_PTR(Z_CACHE_SLOT_P(offset) + sizeof(void*));

			if (EXPECTED(prop_offset != (uint32_t)ZEND_DYNAMIC_PROPERTY_OFFSET)) {
				retval = OBJ_PROP(zobj, prop_offset);
				if (EXPECTED(Z_TYPE_P(retval) != IS_UNDEF)) {
					ZVAL_COPY(EX_VAR(opline->result.var), retval);
					break;
				}
			} else if (EXPECTED(zobj->properties != NULL)) {
				retval = zend_hash_find(zobj->properties, Z_STR_P(offset));
				if (EXPECTED(retval)) {
					ZVAL_COPY(EX_VAR(opline->result.var), retval);
					break;
				}
			}
		}

		if (UNEXPECTED(zobj->handlers->read_property == NULL)) {
fetch_obj_r_no_object:
			zend_error(E_NOTICE, "Trying to get property of non-object");
			ZVAL_NULL(EX_VAR(opline->result.var));
		} else {
			retval = zobj->handlers->read_property(container, offset, BP_VAR_R, (((IS_TMP_VAR|IS_VAR) == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(offset)) : NULL), EX_VAR(opline->result.var));

			if (retval != EX_VAR(opline->result.var)) {
				ZVAL_COPY(EX_VAR(opline->result.var), retval);
			}
		}
	} while (0);

	zval_ptr_dtor_nogc(free_op2);

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_IS_SPEC_CONST_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *container;
	zend_free_op free_op2;
	zval *offset;

	SAVE_OPLINE();
	container = EX_CONSTANT(opline->op1);

	if (IS_CONST == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");
		zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
		HANDLE_EXCEPTION();
	}

	offset  = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);

	if (IS_CONST == IS_CONST ||
	    (IS_CONST != IS_UNUSED && UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT))) {
		if ((IS_CONST & (IS_VAR|IS_CV)) && Z_ISREF_P(container)) {
			container = Z_REFVAL_P(container);
			if (UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT)) {
				goto fetch_obj_is_no_object;
			}
		} else {
			goto fetch_obj_is_no_object;
		}
	}

	/* here we are sure we are dealing with an object */
	do {
		zend_object *zobj = Z_OBJ_P(container);
		zval *retval;

		if ((IS_TMP_VAR|IS_VAR) == IS_CONST &&
			EXPECTED(zobj->ce == CACHED_PTR(Z_CACHE_SLOT_P(offset)))) {
			uint32_t prop_offset = (uint32_t)(intptr_t)CACHED_PTR(Z_CACHE_SLOT_P(offset) + sizeof(void*));

			if (EXPECTED(prop_offset != (uint32_t)ZEND_DYNAMIC_PROPERTY_OFFSET)) {
				retval = OBJ_PROP(zobj, prop_offset);
				if (EXPECTED(Z_TYPE_P(retval) != IS_UNDEF)) {
					ZVAL_COPY(EX_VAR(opline->result.var), retval);
					break;
				}
			} else if (EXPECTED(zobj->properties != NULL)) {
				retval = zend_hash_find(zobj->properties, Z_STR_P(offset));
				if (EXPECTED(retval)) {
					ZVAL_COPY(EX_VAR(opline->result.var), retval);
					break;
				}
			}
		}

		if (UNEXPECTED(zobj->handlers->read_property == NULL)) {
fetch_obj_is_no_object:
			ZVAL_NULL(EX_VAR(opline->result.var));
		} else {

			retval = zobj->handlers->read_property(container, offset, BP_VAR_IS, (((IS_TMP_VAR|IS_VAR) == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(offset)) : NULL), EX_VAR(opline->result.var));

			if (retval != EX_VAR(opline->result.var)) {
				ZVAL_COPY(EX_VAR(opline->result.var), retval);
			}
		}
	} while (0);

	zval_ptr_dtor_nogc(free_op2);

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_FUNC_ARG_SPEC_CONST_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *container;

	if (zend_is_by_ref_func_arg_fetch(opline, EX(call))) {
		/* Behave like FETCH_OBJ_W */
		zend_free_op free_op1, free_op2;
		zval *property;

		SAVE_OPLINE();
		property = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);
		container = NULL;

		if (IS_CONST == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
			zend_throw_error(NULL, "Using $this when not in object context");
			zval_ptr_dtor_nogc(free_op2);
			HANDLE_EXCEPTION();
		}
		if (IS_CONST == IS_CONST || IS_CONST == IS_TMP_VAR) {
			zend_throw_error(NULL, "Cannot use temporary expression in write context");
			zval_ptr_dtor_nogc(free_op2);

			HANDLE_EXCEPTION();
		}
		if (IS_CONST == IS_VAR && UNEXPECTED(container == NULL)) {
			zend_throw_error(NULL, "Cannot use string offset as an object");
			zval_ptr_dtor_nogc(free_op2);
			HANDLE_EXCEPTION();
		}
		zend_fetch_property_address(EX_VAR(opline->result.var), container, IS_CONST, property, (IS_TMP_VAR|IS_VAR), (((IS_TMP_VAR|IS_VAR) == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), BP_VAR_W);
		zval_ptr_dtor_nogc(free_op2);
		if (IS_CONST == IS_VAR && READY_TO_DESTROY(free_op1)) {
			EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 0);
		}

		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	} else {
		ZEND_VM_TAIL_CALL(ZEND_FETCH_OBJ_R_SPEC_CONST_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS_PASSTHRU));
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FAST_CONCAT_SPEC_CONST_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op2;
	zval *op1, *op2;
	zend_string *op1_str, *op2_str, *str;

	SAVE_OPLINE();
	op1 = EX_CONSTANT(opline->op1);
	if (IS_CONST == IS_CONST) {
		op1_str = Z_STR_P(op1);
	} else if (EXPECTED(Z_TYPE_P(op1) == IS_STRING)) {
		op1_str = zend_string_copy(Z_STR_P(op1));
	} else {
		if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(op1) == IS_UNDEF)) {
			GET_OP1_UNDEF_CV(op1, BP_VAR_R);
		}
		op1_str = _zval_get_string_func(op1);
	}
	op2 = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);
	if ((IS_TMP_VAR|IS_VAR) == IS_CONST) {
		op2_str = Z_STR_P(op2);
	} else if (EXPECTED(Z_TYPE_P(op2) == IS_STRING)) {
		op2_str = zend_string_copy(Z_STR_P(op2));
	} else {
		if ((IS_TMP_VAR|IS_VAR) == IS_CV && UNEXPECTED(Z_TYPE_P(op2) == IS_UNDEF)) {
			GET_OP2_UNDEF_CV(op2, BP_VAR_R);
		}
		op2_str = _zval_get_string_func(op2);
	}
	do {
		if (IS_CONST != IS_CONST) {
			if (UNEXPECTED(ZSTR_LEN(op1_str) == 0)) {
				if ((IS_TMP_VAR|IS_VAR) == IS_CONST) {
					zend_string_addref(op2_str);
				}
				ZVAL_STR(EX_VAR(opline->result.var), op2_str);
				zend_string_release(op1_str);
				break;
			}
		}
		if ((IS_TMP_VAR|IS_VAR) != IS_CONST) {
			if (UNEXPECTED(ZSTR_LEN(op2_str) == 0)) {
				if (IS_CONST == IS_CONST) {
					zend_string_addref(op1_str);
				}
				ZVAL_STR(EX_VAR(opline->result.var), op1_str);
				zend_string_release(op2_str);
				break;
			}
		}
		str = zend_string_alloc(ZSTR_LEN(op1_str) + ZSTR_LEN(op2_str), 0);
		memcpy(ZSTR_VAL(str), ZSTR_VAL(op1_str), ZSTR_LEN(op1_str));
		memcpy(ZSTR_VAL(str) + ZSTR_LEN(op1_str), ZSTR_VAL(op2_str), ZSTR_LEN(op2_str)+1);
		ZVAL_NEW_STR(EX_VAR(opline->result.var), str);
		if (IS_CONST != IS_CONST) {
			zend_string_release(op1_str);
		}
		if ((IS_TMP_VAR|IS_VAR) != IS_CONST) {
			zend_string_release(op2_str);
		}
	} while (0);

	zval_ptr_dtor_nogc(free_op2);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_INIT_METHOD_CALL_SPEC_CONST_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *function_name;
	zend_free_op free_op2;
	zval *object;
	zend_function *fbc;
	zend_class_entry *called_scope;
	zend_object *obj;
	zend_execute_data *call;
	uint32_t call_info;

	SAVE_OPLINE();

	function_name = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);

	if ((IS_TMP_VAR|IS_VAR) != IS_CONST &&
	    UNEXPECTED(Z_TYPE_P(function_name) != IS_STRING)) {
		do {
			if (((IS_TMP_VAR|IS_VAR) & (IS_VAR|IS_CV)) && Z_ISREF_P(function_name)) {
				function_name = Z_REFVAL_P(function_name);
				if (EXPECTED(Z_TYPE_P(function_name) == IS_STRING)) {
					break;
				}
			}
			if ((IS_TMP_VAR|IS_VAR) == IS_CV && UNEXPECTED(Z_TYPE_P(function_name) == IS_UNDEF)) {
				GET_OP2_UNDEF_CV(function_name, BP_VAR_R);
			}
			if (UNEXPECTED(EG(exception) != NULL)) {
				HANDLE_EXCEPTION();
			}
			zend_throw_error(NULL, "Method name must be a string");
			zval_ptr_dtor_nogc(free_op2);

			HANDLE_EXCEPTION();
		} while (0);
	}

	object = EX_CONSTANT(opline->op1);

	if (IS_CONST == IS_UNUSED && UNEXPECTED(Z_OBJ_P(object) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");
		zval_ptr_dtor_nogc(free_op2);
		HANDLE_EXCEPTION();
	}

	if (IS_CONST != IS_UNUSED) {
		do {
			if (IS_CONST == IS_CONST || UNEXPECTED(Z_TYPE_P(object) != IS_OBJECT)) {
				if ((IS_CONST & (IS_VAR|IS_CV)) && EXPECTED(Z_ISREF_P(object))) {
					object = Z_REFVAL_P(object);
					if (EXPECTED(Z_TYPE_P(object) == IS_OBJECT)) {
						break;
					}
				}
				if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(object) == IS_UNDEF)) {
					GET_OP1_UNDEF_CV(object, BP_VAR_R);
				}
				if (UNEXPECTED(EG(exception) != NULL)) {
					HANDLE_EXCEPTION();
				}
				zend_throw_error(NULL, "Call to a member function %s() on %s", Z_STRVAL_P(function_name), zend_get_type_by_const(Z_TYPE_P(object)));
				zval_ptr_dtor_nogc(free_op2);

				HANDLE_EXCEPTION();
			}
		} while (0);
	}

	obj = Z_OBJ_P(object);
	called_scope = obj->ce;

	if ((IS_TMP_VAR|IS_VAR) != IS_CONST ||
	    UNEXPECTED((fbc = CACHED_POLYMORPHIC_PTR(Z_CACHE_SLOT_P(function_name), called_scope)) == NULL)) {
	    zend_object *orig_obj = obj;

		if (UNEXPECTED(obj->handlers->get_method == NULL)) {
			zend_throw_error(NULL, "Object does not support method calls");
			zval_ptr_dtor_nogc(free_op2);

			HANDLE_EXCEPTION();
		}

		/* First, locate the function. */
		fbc = obj->handlers->get_method(&obj, Z_STR_P(function_name), (((IS_TMP_VAR|IS_VAR) == IS_CONST) ? (EX_CONSTANT(opline->op2) + 1) : NULL));
		if (UNEXPECTED(fbc == NULL)) {
			if (EXPECTED(!EG(exception))) {
				zend_throw_error(NULL, "Call to undefined method %s::%s()", ZSTR_VAL(obj->ce->name), Z_STRVAL_P(function_name));
			}
			zval_ptr_dtor_nogc(free_op2);

			HANDLE_EXCEPTION();
		}
		if ((IS_TMP_VAR|IS_VAR) == IS_CONST &&
		    EXPECTED(fbc->type <= ZEND_USER_FUNCTION) &&
		    EXPECTED(!(fbc->common.fn_flags & (ZEND_ACC_CALL_VIA_TRAMPOLINE|ZEND_ACC_NEVER_CACHE))) &&
		    EXPECTED(obj == orig_obj)) {
			CACHE_POLYMORPHIC_PTR(Z_CACHE_SLOT_P(function_name), called_scope, fbc);
		}
	}

	call_info = ZEND_CALL_NESTED_FUNCTION;
	if (UNEXPECTED((fbc->common.fn_flags & ZEND_ACC_STATIC) != 0)) {
		obj = NULL;
	} else if (IS_CONST & (IS_VAR|IS_TMP_VAR|IS_CV)) {
		/* CV may be changed indirectly (e.g. when it's a reference) */
		call_info = ZEND_CALL_NESTED_FUNCTION | ZEND_CALL_RELEASE_THIS;
		GC_REFCOUNT(obj)++; /* For $this pointer */
	}

	call = zend_vm_stack_push_call_frame(call_info,
		fbc, opline->extended_value, called_scope, obj);
	call->prev_execute_data = EX(call);
	EX(call) = call;

	zval_ptr_dtor_nogc(free_op2);

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_INIT_STATIC_METHOD_CALL_SPEC_CONST_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *function_name;
	zend_class_entry *ce;
	zend_object *object;
	zend_function *fbc;
	zend_execute_data *call;

	SAVE_OPLINE();

	if (IS_CONST == IS_CONST) {
		/* no function found. try a static method in class */
		if (EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1))))) {
			ce = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)));
		} else {
			ce = zend_fetch_class_by_name(Z_STR_P(EX_CONSTANT(opline->op1)), EX_CONSTANT(opline->op1) + 1, ZEND_FETCH_CLASS_DEFAULT |  ZEND_FETCH_CLASS_EXCEPTION);
			if (UNEXPECTED(EG(exception) != NULL)) {
				HANDLE_EXCEPTION();
			}
			if (UNEXPECTED(ce == NULL)) {
				zend_throw_error(NULL, "Class '%s' not found", Z_STRVAL_P(EX_CONSTANT(opline->op1)));
				HANDLE_EXCEPTION();
			}
			CACHE_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)), ce);
		}
	} else {
		ce = Z_CE_P(EX_VAR(opline->op1.var));
	}

	if (IS_CONST == IS_CONST &&
	    (IS_TMP_VAR|IS_VAR) == IS_CONST &&
	    EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2))))) {
		fbc = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)));
	} else if (IS_CONST != IS_CONST &&
	           (IS_TMP_VAR|IS_VAR) == IS_CONST &&
	           (fbc = CACHED_POLYMORPHIC_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)), ce))) {
		/* do nothing */
	} else if ((IS_TMP_VAR|IS_VAR) != IS_UNUSED) {
		zend_free_op free_op2;

		function_name = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);
		if ((IS_TMP_VAR|IS_VAR) != IS_CONST) {
			if (UNEXPECTED(Z_TYPE_P(function_name) != IS_STRING)) {
				if ((IS_TMP_VAR|IS_VAR) == IS_CV && UNEXPECTED(Z_TYPE_P(function_name) == IS_UNDEF)) {
					GET_OP2_UNDEF_CV(function_name, BP_VAR_R);
				}
				if (UNEXPECTED(EG(exception) != NULL)) {
					HANDLE_EXCEPTION();
				}
				zend_throw_error(NULL, "Function name must be a string");
				zval_ptr_dtor_nogc(free_op2);
				HANDLE_EXCEPTION();
 			}
		}

		if (ce->get_static_method) {
			fbc = ce->get_static_method(ce, Z_STR_P(function_name));
		} else {
			fbc = zend_std_get_static_method(ce, Z_STR_P(function_name), (((IS_TMP_VAR|IS_VAR) == IS_CONST) ? (EX_CONSTANT(opline->op2) + 1) : NULL));
		}
		if (UNEXPECTED(fbc == NULL)) {
			if (EXPECTED(!EG(exception))) {
				zend_throw_error(NULL, "Call to undefined method %s::%s()", ZSTR_VAL(ce->name), Z_STRVAL_P(function_name));
			}
			zval_ptr_dtor_nogc(free_op2);
			HANDLE_EXCEPTION();
		}
		if ((IS_TMP_VAR|IS_VAR) == IS_CONST &&
		    EXPECTED(fbc->type <= ZEND_USER_FUNCTION) &&
		    EXPECTED(!(fbc->common.fn_flags & (ZEND_ACC_CALL_VIA_TRAMPOLINE|ZEND_ACC_NEVER_CACHE)))) {
			if (IS_CONST == IS_CONST) {
				CACHE_PTR(Z_CACHE_SLOT_P(function_name), fbc);
			} else {
				CACHE_POLYMORPHIC_PTR(Z_CACHE_SLOT_P(function_name), ce, fbc);
			}
		}
		if ((IS_TMP_VAR|IS_VAR) != IS_CONST) {
			zval_ptr_dtor_nogc(free_op2);
		}
	} else {
		if (UNEXPECTED(ce->constructor == NULL)) {
			zend_throw_error(NULL, "Cannot call constructor");
			HANDLE_EXCEPTION();
		}
		if (Z_OBJ(EX(This)) && Z_OBJ(EX(This))->ce != ce->constructor->common.scope && (ce->constructor->common.fn_flags & ZEND_ACC_PRIVATE)) {
			zend_throw_error(NULL, "Cannot call private %s::__construct()", ZSTR_VAL(ce->name));
			HANDLE_EXCEPTION();
		}
		fbc = ce->constructor;
	}

	object = NULL;
	if (!(fbc->common.fn_flags & ZEND_ACC_STATIC)) {
		if (Z_OBJ(EX(This)) && instanceof_function(Z_OBJCE(EX(This)), ce)) {
			object = Z_OBJ(EX(This));
		}
		if (!object) {
			if (fbc->common.fn_flags & ZEND_ACC_ALLOW_STATIC) {
				/* Allowed for PHP 4 compatibility. */
				zend_error(
					E_DEPRECATED,
					"Non-static method %s::%s() should not be called statically",
					ZSTR_VAL(fbc->common.scope->name), ZSTR_VAL(fbc->common.function_name));
				if (UNEXPECTED(EG(exception) != NULL)) {
					HANDLE_EXCEPTION();
				}
			} else {
				/* An internal function assumes $this is present and won't check that.
				 * So PHP would crash by allowing the call. */
				zend_throw_error(
					zend_ce_error,
					"Non-static method %s::%s() cannot be called statically",
					ZSTR_VAL(fbc->common.scope->name), ZSTR_VAL(fbc->common.function_name));
				HANDLE_EXCEPTION();
			}
		}
	}

	if (IS_CONST != IS_CONST) {
		/* previous opcode is ZEND_FETCH_CLASS */
		if (((opline-1)->extended_value & ZEND_FETCH_CLASS_MASK) == ZEND_FETCH_CLASS_PARENT ||
		    ((opline-1)->extended_value & ZEND_FETCH_CLASS_MASK) == ZEND_FETCH_CLASS_SELF) {
			ce = EX(called_scope);
		}
	}

	call = zend_vm_stack_push_call_frame(ZEND_CALL_NESTED_FUNCTION,
		fbc, opline->extended_value, ce, object);
	call->prev_execute_data = EX(call);
	EX(call) = call;

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_INIT_USER_CALL_SPEC_CONST_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op2;
	zval *function_name;
	zend_fcall_info_cache fcc;
	char *error = NULL;
	zend_function *func;
	zend_class_entry *called_scope;
	zend_object *object;
	zend_execute_data *call;
	uint32_t call_info = ZEND_CALL_NESTED_FUNCTION;

	SAVE_OPLINE();
	function_name = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);
	if (zend_is_callable_ex(function_name, NULL, 0, NULL, &fcc, &error)) {
		func = fcc.function_handler;
		if (func->common.fn_flags & ZEND_ACC_CLOSURE) {
			/* Delay closure destruction until its invocation */
			if ((IS_TMP_VAR|IS_VAR) & (IS_VAR|IS_CV)) {
				ZVAL_DEREF(function_name);
			}
			ZEND_ASSERT(GC_TYPE((zend_object*)func->common.prototype) == IS_OBJECT);
			GC_REFCOUNT((zend_object*)func->common.prototype)++;
			call_info |= ZEND_CALL_CLOSURE;
		}
		called_scope = fcc.called_scope;
		object = fcc.object;
		if (object) {
			call_info |= ZEND_CALL_RELEASE_THIS;
			GC_REFCOUNT(object)++; /* For $this pointer */
		}
		if (error) {
			efree(error);
			/* This is the only soft error is_callable() can generate */
			zend_error(E_DEPRECATED,
				"Non-static method %s::%s() should not be called statically",
				ZSTR_VAL(func->common.scope->name), ZSTR_VAL(func->common.function_name));
			if (UNEXPECTED(EG(exception) != NULL)) {
				HANDLE_EXCEPTION();
			}
		}
	} else {
		zend_internal_type_error(EX_USES_STRICT_TYPES(), "%s() expects parameter 1 to be a valid callback, %s", Z_STRVAL_P(EX_CONSTANT(opline->op1)), error);
		efree(error);
		func = (zend_function*)&zend_pass_function;
		called_scope = NULL;
		object = NULL;
	}

	call = zend_vm_stack_push_call_frame(call_info,
		func, opline->extended_value, called_scope, object);
	call->prev_execute_data = EX(call);
	EX(call) = call;

	zval_ptr_dtor_nogc(free_op2);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_CASE_SPEC_CONST_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op2;
	zval *op1, *op2, *result;

	op1 = EX_CONSTANT(opline->op1);
	op2 = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);
	do {
		int result;

		if (EXPECTED(Z_TYPE_P(op1) == IS_LONG)) {
			if (EXPECTED(Z_TYPE_P(op2) == IS_LONG)) {
				result = (Z_LVAL_P(op1) == Z_LVAL_P(op2));
			} else if (EXPECTED(Z_TYPE_P(op2) == IS_DOUBLE)) {
				result = ((double)Z_LVAL_P(op1) == Z_DVAL_P(op2));
			} else {
				break;
			}
		} else if (EXPECTED(Z_TYPE_P(op1) == IS_DOUBLE)) {
			if (EXPECTED(Z_TYPE_P(op2) == IS_DOUBLE)) {
				result = (Z_DVAL_P(op1) == Z_DVAL_P(op2));
			} else if (EXPECTED(Z_TYPE_P(op2) == IS_LONG)) {
				result = (Z_DVAL_P(op1) == ((double)Z_LVAL_P(op2)));
			} else {
				break;
			}
		} else if (EXPECTED(Z_TYPE_P(op1) == IS_STRING)) {
			if (EXPECTED(Z_TYPE_P(op2) == IS_STRING)) {
				if (Z_STR_P(op1) == Z_STR_P(op2)) {
					result = 1;
				} else if (Z_STRVAL_P(op1)[0] > '9' || Z_STRVAL_P(op2)[0] > '9') {
					if (Z_STRLEN_P(op1) != Z_STRLEN_P(op2)) {
						result = 0;
					} else {
						result = (memcmp(Z_STRVAL_P(op1), Z_STRVAL_P(op2), Z_STRLEN_P(op1)) == 0);
					}
				} else {
					result = (zendi_smart_strcmp(op1, op2) == 0);
				}
				zval_ptr_dtor_nogc(free_op2);
			} else {
				break;
			}
		} else {
			break;
		}
		ZEND_VM_SMART_BRANCH(result, 0);
		ZVAL_BOOL(EX_VAR(opline->result.var), result);
		ZEND_VM_NEXT_OPCODE();
	} while (0);

	SAVE_OPLINE();
	if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(op1) == IS_UNDEF)) {
		op1 = GET_OP1_UNDEF_CV(op1, BP_VAR_R);
	}
	if ((IS_TMP_VAR|IS_VAR) == IS_CV && UNEXPECTED(Z_TYPE_P(op2) == IS_UNDEF)) {
		op2 = GET_OP2_UNDEF_CV(op2, BP_VAR_R);
	}
	result = EX_VAR(opline->result.var);
	compare_function(result, op1, op2);
	ZVAL_BOOL(result, Z_LVAL_P(result) == 0);
	zval_ptr_dtor_nogc(free_op2);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ADD_ARRAY_ELEMENT_SPEC_CONST_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *expr_ptr, new_expr;

	SAVE_OPLINE();
	if ((IS_CONST == IS_VAR || IS_CONST == IS_CV) &&
	    UNEXPECTED(opline->extended_value & ZEND_ARRAY_ELEMENT_REF)) {
		expr_ptr = NULL;
		if (IS_CONST == IS_VAR && UNEXPECTED(expr_ptr == NULL)) {
			zend_throw_error(NULL, "Cannot create references to/from string offsets");
			zend_array_destroy(Z_ARRVAL_P(EX_VAR(opline->result.var)));
			HANDLE_EXCEPTION();
		}
		ZVAL_MAKE_REF(expr_ptr);
		Z_ADDREF_P(expr_ptr);

	} else {
		expr_ptr = EX_CONSTANT(opline->op1);
		if (IS_CONST == IS_TMP_VAR) {
			/* pass */
		} else if (IS_CONST == IS_CONST) {
			if (UNEXPECTED(Z_OPT_COPYABLE_P(expr_ptr))) {
				ZVAL_COPY_VALUE(&new_expr, expr_ptr);
				zval_copy_ctor_func(&new_expr);
				expr_ptr = &new_expr;
			}
		} else if (IS_CONST == IS_CV) {
			ZVAL_DEREF(expr_ptr);
			if (Z_REFCOUNTED_P(expr_ptr)) {
				Z_ADDREF_P(expr_ptr);
			}
		} else /* if (IS_CONST == IS_VAR) */ {
			if (UNEXPECTED(Z_ISREF_P(expr_ptr))) {
				zend_refcounted *ref = Z_COUNTED_P(expr_ptr);

				expr_ptr = Z_REFVAL_P(expr_ptr);
				if (UNEXPECTED(--GC_REFCOUNT(ref) == 0)) {
					ZVAL_COPY_VALUE(&new_expr, expr_ptr);
					expr_ptr = &new_expr;
					efree_size(ref, sizeof(zend_reference));
				} else if (Z_OPT_REFCOUNTED_P(expr_ptr)) {
					Z_ADDREF_P(expr_ptr);
				}
			}
		}
	}

	if ((IS_TMP_VAR|IS_VAR) != IS_UNUSED) {
		zend_free_op free_op2;
		zval *offset = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);
		zend_string *str;
		zend_ulong hval;

add_again:
		if (EXPECTED(Z_TYPE_P(offset) == IS_STRING)) {
			str = Z_STR_P(offset);
			if ((IS_TMP_VAR|IS_VAR) != IS_CONST) {
				if (ZEND_HANDLE_NUMERIC(str, hval)) {
					goto num_index;
				}
			}
str_index:
			zend_hash_update(Z_ARRVAL_P(EX_VAR(opline->result.var)), str, expr_ptr);
		} else if (EXPECTED(Z_TYPE_P(offset) == IS_LONG)) {
			hval = Z_LVAL_P(offset);
num_index:
			zend_hash_index_update(Z_ARRVAL_P(EX_VAR(opline->result.var)), hval, expr_ptr);
		} else if (((IS_TMP_VAR|IS_VAR) & (IS_VAR|IS_CV)) && EXPECTED(Z_TYPE_P(offset) == IS_REFERENCE)) {
			offset = Z_REFVAL_P(offset);
			goto add_again;
		} else if (Z_TYPE_P(offset) == IS_NULL) {
			str = ZSTR_EMPTY_ALLOC();
			goto str_index;
		} else if (Z_TYPE_P(offset) == IS_DOUBLE) {
			hval = zend_dval_to_lval(Z_DVAL_P(offset));
			goto num_index;
		} else if (Z_TYPE_P(offset) == IS_FALSE) {
			hval = 0;
			goto num_index;
		} else if (Z_TYPE_P(offset) == IS_TRUE) {
			hval = 1;
			goto num_index;
		} else if ((IS_TMP_VAR|IS_VAR) == IS_CV && Z_TYPE_P(offset) == IS_UNDEF) {
			GET_OP2_UNDEF_CV(offset, BP_VAR_R);
			str = ZSTR_EMPTY_ALLOC();
			goto str_index;
		} else {
			zend_error(E_WARNING, "Illegal offset type");
			zval_ptr_dtor(expr_ptr);
		}
		zval_ptr_dtor_nogc(free_op2);
	} else {
		zend_hash_next_index_insert(Z_ARRVAL_P(EX_VAR(opline->result.var)), expr_ptr);
	}
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_INIT_ARRAY_SPEC_CONST_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	zval *array;
	uint32_t size;
	USE_OPLINE

	array = EX_VAR(opline->result.var);
	if (IS_CONST != IS_UNUSED) {
		size = opline->extended_value >> ZEND_ARRAY_SIZE_SHIFT;
	} else {
		size = 0;
	}
	ZVAL_NEW_ARR(array);
	zend_hash_init(Z_ARRVAL_P(array), size, NULL, ZVAL_PTR_DTOR, 0);

	if (IS_CONST != IS_UNUSED) {
		/* Explicitly initialize array as not-packed if flag is set */
		if (opline->extended_value & ZEND_ARRAY_NOT_PACKED) {
			zend_hash_real_init(Z_ARRVAL_P(array), 0);
		}
	}

	if (IS_CONST == IS_UNUSED) {
		ZEND_VM_NEXT_OPCODE();
#if 0 || (IS_CONST != IS_UNUSED)
	} else {
		ZEND_VM_TAIL_CALL(ZEND_ADD_ARRAY_ELEMENT_SPEC_CONST_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS_PASSTHRU));
#endif
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ISSET_ISEMPTY_DIM_OBJ_SPEC_CONST_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op2;
	zval *container;
	int result;
	zend_ulong hval;
	zval *offset;

	SAVE_OPLINE();
	container = EX_CONSTANT(opline->op1);

	if (IS_CONST == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");
		zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
		HANDLE_EXCEPTION();
	}

	offset = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);

	if (IS_CONST != IS_UNUSED && EXPECTED(Z_TYPE_P(container) == IS_ARRAY)) {
		HashTable *ht;
		zval *value;
		zend_string *str;

isset_dim_obj_array:
		ht = Z_ARRVAL_P(container);
isset_again:
		if (EXPECTED(Z_TYPE_P(offset) == IS_STRING)) {
			str = Z_STR_P(offset);
			if ((IS_TMP_VAR|IS_VAR) != IS_CONST) {
				if (ZEND_HANDLE_NUMERIC(str, hval)) {
					goto num_index_prop;
				}
			}
str_index_prop:
			value = zend_hash_find_ind(ht, str);
		} else if (EXPECTED(Z_TYPE_P(offset) == IS_LONG)) {
			hval = Z_LVAL_P(offset);
num_index_prop:
			value = zend_hash_index_find(ht, hval);
		} else if (((IS_TMP_VAR|IS_VAR) & (IS_VAR|IS_CV)) && EXPECTED(Z_ISREF_P(offset))) {
			offset = Z_REFVAL_P(offset);
			goto isset_again;
		} else if (Z_TYPE_P(offset) == IS_DOUBLE) {
			hval = zend_dval_to_lval(Z_DVAL_P(offset));
			goto num_index_prop;
		} else if (Z_TYPE_P(offset) == IS_NULL) {
			str = ZSTR_EMPTY_ALLOC();
			goto str_index_prop;
		} else if (Z_TYPE_P(offset) == IS_FALSE) {
			hval = 0;
			goto num_index_prop;
		} else if (Z_TYPE_P(offset) == IS_TRUE) {
			hval = 1;
			goto num_index_prop;
		} else if (Z_TYPE_P(offset) == IS_RESOURCE) {
			hval = Z_RES_HANDLE_P(offset);
			goto num_index_prop;
		} else if ((IS_TMP_VAR|IS_VAR) == IS_CV && Z_TYPE_P(offset) == IS_UNDEF) {
			GET_OP2_UNDEF_CV(offset, BP_VAR_R);
			str = ZSTR_EMPTY_ALLOC();
			goto str_index_prop;
		} else {
			zend_error(E_WARNING, "Illegal offset type in isset or empty");
			goto isset_not_found;
		}

		if (opline->extended_value & ZEND_ISSET) {
			/* > IS_NULL means not IS_UNDEF and not IS_NULL */
			result = value != NULL && Z_TYPE_P(value) > IS_NULL &&
			    (!Z_ISREF_P(value) || Z_TYPE_P(Z_REFVAL_P(value)) != IS_NULL);
		} else /* if (opline->extended_value & ZEND_ISEMPTY) */ {
			result = (value == NULL || !i_zend_is_true(value));
		}
		goto isset_dim_obj_exit;
	} else if ((IS_CONST & (IS_VAR|IS_CV)) && Z_ISREF_P(container)) {
		container = Z_REFVAL_P(container);
		if (EXPECTED(Z_TYPE_P(container) == IS_ARRAY)) {
			goto isset_dim_obj_array;
		}
	}

	if ((IS_TMP_VAR|IS_VAR) == IS_CV && UNEXPECTED(Z_TYPE_P(offset) == IS_UNDEF)) {
		offset = GET_OP2_UNDEF_CV(offset, BP_VAR_R);
	}

	if (IS_CONST == IS_UNUSED ||
	    (IS_CONST != IS_CONST && EXPECTED(Z_TYPE_P(container) == IS_OBJECT))) {
		if (EXPECTED(Z_OBJ_HT_P(container)->has_dimension)) {
			result =
				((opline->extended_value & ZEND_ISSET) == 0) ^
				Z_OBJ_HT_P(container)->has_dimension(container, offset, (opline->extended_value & ZEND_ISSET) == 0);
		} else {
			zend_error(E_NOTICE, "Trying to check element of non-array");
			goto isset_not_found;
		}
	} else if (EXPECTED(Z_TYPE_P(container) == IS_STRING)) { /* string offsets */
		zend_long lval;

		if (EXPECTED(Z_TYPE_P(offset) == IS_LONG)) {
			lval = Z_LVAL_P(offset);
isset_str_offset:
			if (EXPECTED(lval >= 0) && (size_t)lval < Z_STRLEN_P(container)) {
				if (opline->extended_value & ZEND_ISSET) {
					result = 1;
				} else {
					result = (Z_STRVAL_P(container)[lval] == '0');
				}
			} else {
				goto isset_not_found;
			}
		} else {
			if ((IS_TMP_VAR|IS_VAR) & (IS_CV|IS_VAR)) {
				ZVAL_DEREF(offset);
			}
			if (Z_TYPE_P(offset) < IS_STRING /* simple scalar types */
					|| (Z_TYPE_P(offset) == IS_STRING /* or numeric string */
						&& IS_LONG == is_numeric_string(Z_STRVAL_P(offset), Z_STRLEN_P(offset), NULL, NULL, 0))) {
				lval = zval_get_long(offset);
				goto isset_str_offset;
			}
			goto isset_not_found;
		}
	} else {
isset_not_found:
		result = ((opline->extended_value & ZEND_ISSET) == 0);
	}

isset_dim_obj_exit:
	zval_ptr_dtor_nogc(free_op2);

	ZEND_VM_SMART_BRANCH(result, 1);
	ZVAL_BOOL(EX_VAR(opline->result.var), result);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ISSET_ISEMPTY_PROP_OBJ_SPEC_CONST_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op2;
	zval *container;
	int result;
	zval *offset;

	SAVE_OPLINE();
	container = EX_CONSTANT(opline->op1);

	if (IS_CONST == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");
		zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
		HANDLE_EXCEPTION();
	}

	offset = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);

	if (IS_CONST == IS_CONST ||
	    (IS_CONST != IS_UNUSED && UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT))) {
		if ((IS_CONST & (IS_VAR|IS_CV)) && Z_ISREF_P(container)) {
			container = Z_REFVAL_P(container);
			if (UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT)) {
				goto isset_no_object;
			}
		} else {
			goto isset_no_object;
		}
	}
	if (UNEXPECTED(!Z_OBJ_HT_P(container)->has_property)) {
		zend_error(E_NOTICE, "Trying to check property of non-object");
isset_no_object:
		result = ((opline->extended_value & ZEND_ISSET) == 0);
	} else {
		result =
			((opline->extended_value & ZEND_ISSET) == 0) ^
			Z_OBJ_HT_P(container)->has_property(container, offset, (opline->extended_value & ZEND_ISSET) == 0, (((IS_TMP_VAR|IS_VAR) == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(offset)) : NULL));
	}

	zval_ptr_dtor_nogc(free_op2);

	ZEND_VM_SMART_BRANCH(result, 1);
	ZVAL_BOOL(EX_VAR(opline->result.var), result);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_POW_SPEC_CONST_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op2;
	zval *op1, *op2;

	SAVE_OPLINE();
	op1 = EX_CONSTANT(opline->op1);
	op2 = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);
	pow_function(EX_VAR(opline->result.var), op1, op2);

	zval_ptr_dtor_nogc(free_op2);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_RETURN_SPEC_TMP_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *retval_ptr;
	zend_free_op free_op1;

	retval_ptr = _get_zval_ptr_tmp(opline->op1.var, execute_data, &free_op1);
	if (IS_TMP_VAR == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(retval_ptr) == IS_UNDEF)) {
		SAVE_OPLINE();
		retval_ptr = GET_OP1_UNDEF_CV(retval_ptr, BP_VAR_R);
		if (EX(return_value)) {
			ZVAL_NULL(EX(return_value));
		}
	} else if (!EX(return_value)) {
		if (IS_TMP_VAR == IS_VAR || IS_TMP_VAR == IS_TMP_VAR ) {
			if (Z_REFCOUNTED_P(free_op1) && !Z_DELREF_P(free_op1)) {
				SAVE_OPLINE();
				zval_dtor_func_for_ptr(Z_COUNTED_P(free_op1));
			}
		}
	} else {
		if (IS_TMP_VAR == IS_CONST || IS_TMP_VAR == IS_TMP_VAR) {
			ZVAL_COPY_VALUE(EX(return_value), retval_ptr);
			if (IS_TMP_VAR == IS_CONST) {
				if (UNEXPECTED(Z_OPT_COPYABLE_P(EX(return_value)))) {
					zval_copy_ctor_func(EX(return_value));
				}
			}
		} else if (IS_TMP_VAR == IS_CV) {
			ZVAL_DEREF(retval_ptr);
			ZVAL_COPY(EX(return_value), retval_ptr);
		} else /* if (IS_TMP_VAR == IS_VAR) */ {
			if (UNEXPECTED(Z_ISREF_P(retval_ptr))) {
				zend_refcounted *ref = Z_COUNTED_P(retval_ptr);

				retval_ptr = Z_REFVAL_P(retval_ptr);
				ZVAL_COPY_VALUE(EX(return_value), retval_ptr);
				if (UNEXPECTED(--GC_REFCOUNT(ref) == 0)) {
					efree_size(ref, sizeof(zend_reference));
				} else if (Z_OPT_REFCOUNTED_P(retval_ptr)) {
					Z_ADDREF_P(retval_ptr);
				}
			} else {
				ZVAL_COPY_VALUE(EX(return_value), retval_ptr);
			}
		}
	}
	ZEND_VM_TAIL_CALL(zend_leave_helper_SPEC(ZEND_OPCODE_HANDLER_ARGS_PASSTHRU));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_RETURN_BY_REF_SPEC_TMP_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *retval_ptr;
	zend_free_op free_op1;

	SAVE_OPLINE();

	do {
		if (IS_TMP_VAR == IS_CONST || IS_TMP_VAR == IS_TMP_VAR ||
		    (IS_TMP_VAR == IS_VAR && opline->extended_value == ZEND_RETURNS_VALUE)) {
			/* Not supposed to happen, but we'll allow it */
			zend_error(E_NOTICE, "Only variable references should be returned by reference");

			retval_ptr = _get_zval_ptr_tmp(opline->op1.var, execute_data, &free_op1);
			if (!EX(return_value)) {
				if (IS_TMP_VAR == IS_TMP_VAR) {
					zval_ptr_dtor_nogc(free_op1);
				}
			} else {
				ZVAL_COPY_VALUE(EX(return_value), retval_ptr);
				Z_VAR_FLAGS_P(EX(return_value)) = IS_VAR_RET_REF;
				if (IS_TMP_VAR != IS_TMP_VAR) {
					zval_opt_copy_ctor_no_imm(EX(return_value));
				}
			}
			break;
		}

		retval_ptr = NULL;

		if (IS_TMP_VAR == IS_VAR && UNEXPECTED(retval_ptr == NULL)) {
			zend_throw_error(NULL, "Cannot return string offsets by reference");
			HANDLE_EXCEPTION();
		}

		if (IS_TMP_VAR == IS_VAR) {
			if (retval_ptr == &EG(uninitialized_zval) ||
			    (opline->extended_value == ZEND_RETURNS_FUNCTION &&
			     !(Z_VAR_FLAGS_P(retval_ptr) & IS_VAR_RET_REF))) {
				zend_error(E_NOTICE, "Only variable references should be returned by reference");
				if (EX(return_value)) {
					ZVAL_NEW_REF(EX(return_value), retval_ptr);
					Z_VAR_FLAGS_P(EX(return_value)) = IS_VAR_RET_REF;
					if (Z_REFCOUNTED_P(retval_ptr)) Z_ADDREF_P(retval_ptr);
				}
				break;
			}
		}

		if (EX(return_value)) {
			ZVAL_MAKE_REF(retval_ptr);
			Z_ADDREF_P(retval_ptr);
			ZVAL_REF(EX(return_value), Z_REF_P(retval_ptr));
			Z_VAR_FLAGS_P(EX(return_value)) = IS_VAR_RET_REF;
		}
	} while (0);

	ZEND_VM_TAIL_CALL(zend_leave_helper_SPEC(ZEND_OPCODE_HANDLER_ARGS_PASSTHRU));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_GENERATOR_RETURN_SPEC_TMP_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *retval;
	zend_free_op free_op1;

	zend_generator *generator = zend_get_running_generator(execute_data);

	SAVE_OPLINE();
	retval = _get_zval_ptr_tmp(opline->op1.var, execute_data, &free_op1);

	/* Copy return value into generator->retval */
	if (IS_TMP_VAR == IS_CONST || IS_TMP_VAR == IS_TMP_VAR) {
		ZVAL_COPY_VALUE(&generator->retval, retval);
		if (IS_TMP_VAR == IS_CONST) {
			if (UNEXPECTED(Z_OPT_COPYABLE(generator->retval))) {
				zval_copy_ctor_func(&generator->retval);
			}
		}
	} else if (IS_TMP_VAR == IS_CV) {
		ZVAL_DEREF(retval);
		ZVAL_COPY(&generator->retval, retval);
	} else /* if (IS_TMP_VAR == IS_VAR) */ {
		if (UNEXPECTED(Z_ISREF_P(retval))) {
			zend_refcounted *ref = Z_COUNTED_P(retval);

			retval = Z_REFVAL_P(retval);
			ZVAL_COPY_VALUE(&generator->retval, retval);
			if (UNEXPECTED(--GC_REFCOUNT(ref) == 0)) {
				efree_size(ref, sizeof(zend_reference));
			} else if (Z_OPT_REFCOUNTED_P(retval)) {
				Z_ADDREF_P(retval);
			}
		} else {
			ZVAL_COPY_VALUE(&generator->retval, retval);
		}
	}

	/* Close the generator to free up resources */
	zend_generator_close(generator, 1);

	/* Pass execution back to handling code */
	ZEND_VM_RETURN();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_THROW_SPEC_TMP_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *value;
	zend_free_op free_op1;

	SAVE_OPLINE();
	value = _get_zval_ptr_tmp(opline->op1.var, execute_data, &free_op1);

	do {
		if (IS_TMP_VAR == IS_CONST || UNEXPECTED(Z_TYPE_P(value) != IS_OBJECT)) {
			if ((IS_TMP_VAR & (IS_VAR|IS_CV)) && Z_ISREF_P(value)) {
				value = Z_REFVAL_P(value);
				if (EXPECTED(Z_TYPE_P(value) == IS_OBJECT)) {
					break;
				}
			}
			if (IS_TMP_VAR == IS_CV && UNEXPECTED(Z_TYPE_P(value) == IS_UNDEF)) {
				GET_OP1_UNDEF_CV(value, BP_VAR_R);
			}
			if (UNEXPECTED(EG(exception) != NULL)) {
				HANDLE_EXCEPTION();
			}
			zend_throw_error(NULL, "Can only throw objects");
			zval_ptr_dtor_nogc(free_op1);
			HANDLE_EXCEPTION();
		}
	} while (0);

	zend_exception_save();
	if (IS_TMP_VAR != IS_TMP_VAR) {
		if (Z_REFCOUNTED_P(value)) Z_ADDREF_P(value);
	}

	zend_throw_exception_object(value);
	zend_exception_restore();

	HANDLE_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_SEND_VAL_SPEC_TMP_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *value, *arg;
	zend_free_op free_op1;

	value = _get_zval_ptr_tmp(opline->op1.var, execute_data, &free_op1);
	arg = ZEND_CALL_VAR(EX(call), opline->result.var);
	ZVAL_COPY_VALUE(arg, value);
	if (IS_TMP_VAR == IS_CONST) {
		if (UNEXPECTED(Z_OPT_COPYABLE_P(arg))) {
			zval_copy_ctor_func(arg);
		}
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_SEND_VAL_EX_SPEC_TMP_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *value, *arg;
	zend_free_op free_op1;

	if (EXPECTED(opline->op2.num <= MAX_ARG_FLAG_NUM)) {
		if (QUICK_ARG_MUST_BE_SENT_BY_REF(EX(call)->func, opline->op2.num)) {
			goto send_val_by_ref;
		}
	} else if (ARG_MUST_BE_SENT_BY_REF(EX(call)->func, opline->op2.num)) {
send_val_by_ref:
		SAVE_OPLINE();
		zend_throw_error(NULL, "Cannot pass parameter %d by reference", opline->op2.num);
		zval_ptr_dtor_nogc(EX_VAR(opline->op1.var));
		arg = ZEND_CALL_VAR(EX(call), opline->result.var);
		ZVAL_UNDEF(arg);
		HANDLE_EXCEPTION();
	}
	value = _get_zval_ptr_tmp(opline->op1.var, execute_data, &free_op1);
	arg = ZEND_CALL_VAR(EX(call), opline->result.var);
	ZVAL_COPY_VALUE(arg, value);
	if (IS_TMP_VAR == IS_CONST) {
		if (UNEXPECTED(Z_OPT_COPYABLE_P(arg))) {
			zval_copy_ctor_func(arg);
		}
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_CAST_SPEC_TMP_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *expr;
	zval *result = EX_VAR(opline->result.var);

	SAVE_OPLINE();
	expr = _get_zval_ptr_tmp(opline->op1.var, execute_data, &free_op1);

	switch (opline->extended_value) {
		case IS_NULL:
			/* This code is taken from convert_to_null. However, it does not seems very useful,
			 * because a conversion to null always results in the same value. This could only
			 * be relevant if a cast_object handler for IS_NULL has some kind of side-effect. */
#if 0
			if (IS_TMP_VAR == IS_VAR || IS_TMP_VAR == IS_CV) {
				ZVAL_DEREF(expr);
			}
			if (Z_TYPE_P(expr) == IS_OBJECT && Z_OBJ_HT_P(expr)->cast_object) {
				if (Z_OBJ_HT_P(expr)->cast_object(expr, result, IS_NULL) == SUCCESS) {
					break;
				}
			}
#endif

			ZVAL_NULL(result);
			break;
		case _IS_BOOL:
			ZVAL_BOOL(result, zend_is_true(expr));
			break;
		case IS_LONG:
			ZVAL_LONG(result, zval_get_long(expr));
			break;
		case IS_DOUBLE:
			ZVAL_DOUBLE(result, zval_get_double(expr));
			break;
		case IS_STRING:
			ZVAL_STR(result, zval_get_string(expr));
			break;
		default:
			if (IS_TMP_VAR & (IS_VAR|IS_CV)) {
				ZVAL_DEREF(expr);
			}
			/* If value is already of correct type, return it directly */
			if (Z_TYPE_P(expr) == opline->extended_value) {
				ZVAL_COPY_VALUE(result, expr);
				if (IS_TMP_VAR == IS_CONST) {
					if (UNEXPECTED(Z_OPT_COPYABLE_P(result))) {
						zval_copy_ctor_func(result);
					}
				} else if (IS_TMP_VAR != IS_TMP_VAR) {
					if (Z_OPT_REFCOUNTED_P(expr)) Z_ADDREF_P(expr);
				}

				ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
			}

			if (opline->extended_value == IS_ARRAY) {
				if (Z_TYPE_P(expr) != IS_OBJECT) {
					ZVAL_NEW_ARR(result);
					zend_hash_init(Z_ARRVAL_P(result), 8, NULL, ZVAL_PTR_DTOR, 0);
					if (Z_TYPE_P(expr) != IS_NULL) {
						expr = zend_hash_index_add_new(Z_ARRVAL_P(result), 0, expr);
						if (IS_TMP_VAR == IS_CONST) {
							if (UNEXPECTED(Z_OPT_COPYABLE_P(expr))) {
								zval_copy_ctor_func(expr);
							}
						} else {
							if (Z_OPT_REFCOUNTED_P(expr)) Z_ADDREF_P(expr);
						}
					}
				} else {
					ZVAL_COPY_VALUE(result, expr);
					Z_ADDREF_P(result);
					convert_to_array(result);
				}
			} else {
				if (Z_TYPE_P(expr) != IS_ARRAY) {
					object_init(result);
					if (Z_TYPE_P(expr) != IS_NULL) {
						expr = zend_hash_str_add_new(Z_OBJPROP_P(result), "scalar", sizeof("scalar")-1, expr);
						if (IS_TMP_VAR == IS_CONST) {
							if (UNEXPECTED(Z_OPT_COPYABLE_P(expr))) {
								zval_copy_ctor_func(expr);
							}
						} else {
							if (Z_OPT_REFCOUNTED_P(expr)) Z_ADDREF_P(expr);
						}
					}
				} else {
					ZVAL_COPY(result, expr);
					convert_to_object(result);
				}
			}
	}

	zval_ptr_dtor_nogc(free_op1);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FE_RESET_R_SPEC_TMP_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *array_ptr, *result;
	HashTable *fe_ht;

	SAVE_OPLINE();

	array_ptr = _get_zval_ptr_tmp(opline->op1.var, execute_data, &free_op1);
	if (EXPECTED(Z_TYPE_P(array_ptr) == IS_ARRAY)) {
		result = EX_VAR(opline->result.var);
		ZVAL_COPY_VALUE(result, array_ptr);
		if (IS_TMP_VAR != IS_TMP_VAR && Z_OPT_REFCOUNTED_P(result)) {
			Z_ADDREF_P(array_ptr);
		}
		Z_FE_POS_P(result) = 0;

		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	} else if (IS_TMP_VAR != IS_CONST && EXPECTED(Z_TYPE_P(array_ptr) == IS_OBJECT)) {
		if (!Z_OBJCE_P(array_ptr)->get_iterator) {
			HashPosition pos = 0;
			Bucket *p;

			result = EX_VAR(opline->result.var);
			ZVAL_COPY_VALUE(result, array_ptr);
			if (IS_TMP_VAR != IS_TMP_VAR) {
				Z_ADDREF_P(array_ptr);
			}
			fe_ht = Z_OBJPROP_P(array_ptr);
			pos = 0;
			p = fe_ht->arData;
			while (1) {
				if (UNEXPECTED(pos >= fe_ht->nNumUsed)) {

					Z_FE_ITER_P(EX_VAR(opline->result.var)) = (uint32_t)-1;
					ZEND_VM_JMP(OP_JMP_ADDR(opline, opline->op2));
				}
				if ((EXPECTED(Z_TYPE(p->val) != IS_UNDEF) &&
				     (EXPECTED(Z_TYPE(p->val) != IS_INDIRECT) ||
				      EXPECTED(Z_TYPE_P(Z_INDIRECT(p->val)) != IS_UNDEF))) &&
				    (UNEXPECTED(!p->key) ||
				     EXPECTED(zend_check_property_access(Z_OBJ_P(array_ptr), p->key) == SUCCESS))) {
					break;
				}
				pos++;
				p++;
			}
			Z_FE_ITER_P(EX_VAR(opline->result.var)) = zend_hash_iterator_add(fe_ht, pos);

			ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
		} else {
			zend_class_entry *ce = Z_OBJCE_P(array_ptr);
			zend_object_iterator *iter = ce->get_iterator(ce, array_ptr, 0);
			zend_bool is_empty;

			if (UNEXPECTED(!iter) || UNEXPECTED(EG(exception))) {
				zval_ptr_dtor_nogc(free_op1);
				if (!EG(exception)) {
					zend_throw_exception_ex(NULL, 0, "Object of type %s did not create an Iterator", ZSTR_VAL(ce->name));
				}
				zend_throw_exception_internal(NULL);
				HANDLE_EXCEPTION();
			}

			iter->index = 0;
			if (iter->funcs->rewind) {
				iter->funcs->rewind(iter);
				if (UNEXPECTED(EG(exception) != NULL)) {
					OBJ_RELEASE(&iter->std);
					zval_ptr_dtor_nogc(free_op1);
					HANDLE_EXCEPTION();
				}
			}

			is_empty = iter->funcs->valid(iter) != SUCCESS;

			if (UNEXPECTED(EG(exception) != NULL)) {
				OBJ_RELEASE(&iter->std);
				zval_ptr_dtor_nogc(free_op1);
				HANDLE_EXCEPTION();
			}
			iter->index = -1; /* will be set to 0 before using next handler */

			ZVAL_OBJ(EX_VAR(opline->result.var), &iter->std);
			Z_FE_ITER_P(EX_VAR(opline->result.var)) = (uint32_t)-1;

			zval_ptr_dtor_nogc(free_op1);
			if (is_empty) {
				ZEND_VM_JMP(OP_JMP_ADDR(opline, opline->op2));
			} else {
				ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
			}
		}
	} else {
		zend_error(E_WARNING, "Invalid argument supplied for foreach()");
		ZVAL_UNDEF(EX_VAR(opline->result.var));
		Z_FE_ITER_P(EX_VAR(opline->result.var)) = (uint32_t)-1;
		zval_ptr_dtor_nogc(free_op1);
		ZEND_VM_JMP(OP_JMP_ADDR(opline, opline->op2));
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FE_RESET_RW_SPEC_TMP_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *array_ptr, *array_ref;
	HashTable *fe_ht;
	HashPosition pos = 0;
	Bucket *p;

	SAVE_OPLINE();

	if (IS_TMP_VAR == IS_VAR || IS_TMP_VAR == IS_CV) {
		array_ref = array_ptr = NULL;
		if (Z_ISREF_P(array_ref)) {
			array_ptr = Z_REFVAL_P(array_ref);
		}
	} else {
		array_ref = array_ptr = _get_zval_ptr_tmp(opline->op1.var, execute_data, &free_op1);
	}

	if (EXPECTED(Z_TYPE_P(array_ptr) == IS_ARRAY)) {
		if (IS_TMP_VAR == IS_VAR || IS_TMP_VAR == IS_CV) {
			if (array_ptr == array_ref) {
				ZVAL_NEW_REF(array_ref, array_ref);
				array_ptr = Z_REFVAL_P(array_ref);
			}
			Z_ADDREF_P(array_ref);
			ZVAL_COPY_VALUE(EX_VAR(opline->result.var), array_ref);
		} else {
			array_ptr = EX_VAR(opline->result.var);
			ZVAL_COPY_VALUE(array_ptr, array_ref);
		}
		if (IS_TMP_VAR == IS_CONST) {
			zval_copy_ctor_func(array_ptr);
		} else {
			SEPARATE_ARRAY(array_ptr);
		}
		fe_ht = Z_ARRVAL_P(array_ptr);
		p = fe_ht->arData;
		while (1) {
			if (UNEXPECTED(pos >= fe_ht->nNumUsed)) {

				Z_FE_ITER_P(EX_VAR(opline->result.var)) = (uint32_t)-1;
				ZEND_VM_JMP(OP_JMP_ADDR(opline, opline->op2));
			}
			if (EXPECTED(Z_TYPE(p->val) != IS_UNDEF) &&
			    (EXPECTED(Z_TYPE(p->val) != IS_INDIRECT) ||
			     EXPECTED(Z_TYPE_P(Z_INDIRECT(p->val)) != IS_UNDEF))) {
				break;
			}
			pos++;
			p++;
		}
		Z_FE_ITER_P(EX_VAR(opline->result.var)) = zend_hash_iterator_add(fe_ht, pos);

		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	} else if (IS_TMP_VAR != IS_CONST && EXPECTED(Z_TYPE_P(array_ptr) == IS_OBJECT)) {
		if (!Z_OBJCE_P(array_ptr)->get_iterator) {
			if (IS_TMP_VAR == IS_VAR || IS_TMP_VAR == IS_CV) {
				if (array_ptr == array_ref) {
					ZVAL_NEW_REF(array_ref, array_ref);
					array_ptr = Z_REFVAL_P(array_ref);
				}
				Z_ADDREF_P(array_ref);
				ZVAL_COPY_VALUE(EX_VAR(opline->result.var), array_ref);
			} else {
				array_ptr = EX_VAR(opline->result.var);
				ZVAL_COPY_VALUE(array_ptr, array_ref);
			}
			fe_ht = Z_OBJPROP_P(array_ptr);
			p = fe_ht->arData;
			while (1) {
				if (UNEXPECTED(pos >= fe_ht->nNumUsed)) {

					Z_FE_ITER_P(EX_VAR(opline->result.var)) = (uint32_t)-1;
					ZEND_VM_JMP(OP_JMP_ADDR(opline, opline->op2));
				}
				if ((EXPECTED(Z_TYPE(p->val) != IS_UNDEF) &&
				     (EXPECTED(Z_TYPE(p->val) != IS_INDIRECT) ||
				      EXPECTED(Z_TYPE_P(Z_INDIRECT(p->val)) != IS_UNDEF))) &&
				    (UNEXPECTED(!p->key) ||
				     EXPECTED(zend_check_property_access(Z_OBJ_P(array_ptr), p->key) == SUCCESS))) {
					break;
				}
				pos++;
				p++;
			}
			Z_FE_ITER_P(EX_VAR(opline->result.var)) = zend_hash_iterator_add(fe_ht, pos);

			ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
		} else {
			zend_class_entry *ce = Z_OBJCE_P(array_ptr);
			zend_object_iterator *iter = ce->get_iterator(ce, array_ptr, 1);
			zend_bool is_empty;

			if (UNEXPECTED(!iter) || UNEXPECTED(EG(exception))) {
				if (IS_TMP_VAR == IS_VAR) {

				} else {
					zval_ptr_dtor_nogc(free_op1);
				}
				if (!EG(exception)) {
					zend_throw_exception_ex(NULL, 0, "Object of type %s did not create an Iterator", ZSTR_VAL(ce->name));
				}
				zend_throw_exception_internal(NULL);
				HANDLE_EXCEPTION();
			}

			iter->index = 0;
			if (iter->funcs->rewind) {
				iter->funcs->rewind(iter);
				if (UNEXPECTED(EG(exception) != NULL)) {
					OBJ_RELEASE(&iter->std);
					if (IS_TMP_VAR == IS_VAR) {

					} else {
						zval_ptr_dtor_nogc(free_op1);
					}
					HANDLE_EXCEPTION();
				}
			}

			is_empty = iter->funcs->valid(iter) != SUCCESS;

			if (UNEXPECTED(EG(exception) != NULL)) {
				OBJ_RELEASE(&iter->std);
				if (IS_TMP_VAR == IS_VAR) {

				} else {
					zval_ptr_dtor_nogc(free_op1);
				}
				HANDLE_EXCEPTION();
			}
			iter->index = -1; /* will be set to 0 before using next handler */

			ZVAL_OBJ(EX_VAR(opline->result.var), &iter->std);
			Z_FE_ITER_P(EX_VAR(opline->result.var)) = (uint32_t)-1;

			if (IS_TMP_VAR == IS_VAR) {

			} else {
				zval_ptr_dtor_nogc(free_op1);
			}
			if (is_empty) {
				ZEND_VM_JMP(OP_JMP_ADDR(opline, opline->op2));
			} else {
				ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
			}
		}
	} else {
		zend_error(E_WARNING, "Invalid argument supplied for foreach()");
		ZVAL_UNDEF(EX_VAR(opline->result.var));
		Z_FE_ITER_P(EX_VAR(opline->result.var)) = (uint32_t)-1;
		if (IS_TMP_VAR == IS_VAR) {

		} else {
			zval_ptr_dtor_nogc(free_op1);
		}
		ZEND_VM_JMP(OP_JMP_ADDR(opline, opline->op2));
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_END_SILENCE_SPEC_TMP_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	if (!EG(error_reporting) && Z_LVAL_P(EX_VAR(opline->op1.var)) != 0) {
		EG(error_reporting) = Z_LVAL_P(EX_VAR(opline->op1.var));
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_JMP_SET_SPEC_TMP_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *value;
	zval *ref = NULL;

	SAVE_OPLINE();
	value = _get_zval_ptr_tmp(opline->op1.var, execute_data, &free_op1);

	if ((IS_TMP_VAR == IS_VAR || IS_TMP_VAR == IS_CV) && Z_ISREF_P(value)) {
		if (IS_TMP_VAR == IS_VAR) {
			ref = value;
		}
		value = Z_REFVAL_P(value);
	}
	if (i_zend_is_true(value)) {
		ZVAL_COPY_VALUE(EX_VAR(opline->result.var), value);
		if (IS_TMP_VAR == IS_CONST) {
			if (UNEXPECTED(Z_OPT_COPYABLE_P(value))) {
				zval_copy_ctor_func(EX_VAR(opline->result.var));
			}
		} else if (IS_TMP_VAR == IS_CV) {
			if (Z_OPT_REFCOUNTED_P(value)) Z_ADDREF_P(value);
		} else if (IS_TMP_VAR == IS_VAR && ref) {
			zend_reference *r = Z_REF_P(ref);

			if (Z_OPT_REFCOUNTED_P(value)) Z_ADDREF_P(value);
			if (UNEXPECTED(--GC_REFCOUNT(r) == 0)) {
				efree_size(r, sizeof(zend_reference));
			}
		}
		ZEND_VM_JMP(OP_JMP_ADDR(opline, opline->op2));
	}

	zval_ptr_dtor_nogc(free_op1);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_COALESCE_SPEC_TMP_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *value;
	zval *ref = NULL;

	SAVE_OPLINE();
	value = _get_zval_ptr_tmp(opline->op1.var, execute_data, &free_op1);

	if ((IS_TMP_VAR == IS_VAR || IS_TMP_VAR == IS_CV) && Z_ISREF_P(value)) {
		if (IS_TMP_VAR == IS_VAR) {
			ref = value;
		}
		value = Z_REFVAL_P(value);
	}

	if (Z_TYPE_P(value) > IS_NULL) {
		ZVAL_COPY_VALUE(EX_VAR(opline->result.var), value);
		if (IS_TMP_VAR == IS_CONST) {
			if (UNEXPECTED(Z_OPT_COPYABLE_P(value))) {
				zval_copy_ctor_func(EX_VAR(opline->result.var));
			}
		} else if (IS_TMP_VAR == IS_CV) {
			if (Z_OPT_REFCOUNTED_P(value)) Z_ADDREF_P(value);
		} else if (IS_TMP_VAR == IS_VAR && ref) {
			zend_reference *r = Z_REF_P(ref);

			if (Z_OPT_REFCOUNTED_P(value)) Z_ADDREF_P(value);
			if (UNEXPECTED(--GC_REFCOUNT(r) == 0)) {
				efree_size(r, sizeof(zend_reference));
			}
		}
		ZEND_VM_JMP(OP_JMP_ADDR(opline, opline->op2));
	}

	zval_ptr_dtor_nogc(free_op1);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_QM_ASSIGN_SPEC_TMP_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *value;

	value = _get_zval_ptr_tmp(opline->op1.var, execute_data, &free_op1);
	if (IS_TMP_VAR == IS_CV && UNEXPECTED(Z_TYPE_P(value) == IS_UNDEF)) {
		SAVE_OPLINE();
		GET_OP1_UNDEF_CV(value, BP_VAR_R);
		ZVAL_NULL(EX_VAR(opline->result.var));
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}

	if ((IS_TMP_VAR == IS_VAR || IS_TMP_VAR == IS_CV) && Z_ISREF_P(value)) {
		ZVAL_COPY(EX_VAR(opline->result.var), Z_REFVAL_P(value));
		if (IS_TMP_VAR == IS_VAR) {
			if (UNEXPECTED(Z_DELREF_P(value) == 0)) {
				efree_size(Z_REF_P(value), sizeof(zend_reference));
			}
		}
	} else {
		ZVAL_COPY_VALUE(EX_VAR(opline->result.var), value);
		if (IS_TMP_VAR == IS_CONST) {
			if (UNEXPECTED(Z_OPT_COPYABLE_P(value))) {
				zval_copy_ctor_func(EX_VAR(opline->result.var));
			}
		} else if (IS_TMP_VAR == IS_CV) {
			if (Z_OPT_REFCOUNTED_P(value)) Z_ADDREF_P(value);
		}
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_YIELD_FROM_SPEC_TMP_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zend_generator *generator = zend_get_running_generator(execute_data);

	zval *val;
	zend_free_op free_op1;

	SAVE_OPLINE();
	val = _get_zval_ptr_tmp(opline->op1.var, execute_data, &free_op1);

	if (Z_TYPE_P(val) == IS_ARRAY) {
		ZVAL_COPY_VALUE(&generator->values, val);
		if (IS_TMP_VAR != IS_TMP_VAR && Z_OPT_REFCOUNTED_P(val)) {
			Z_ADDREF_P(val);
		}
		Z_FE_POS(generator->values) = 0;

	} else if (IS_TMP_VAR != IS_CONST && Z_TYPE_P(val) == IS_OBJECT && Z_OBJCE_P(val)->get_iterator) {
		zend_class_entry *ce = Z_OBJCE_P(val);
		if (ce == zend_ce_generator) {
			zend_generator *new_gen = (zend_generator *) Z_OBJ_P(val);

			if (IS_TMP_VAR != IS_TMP_VAR) {
				Z_ADDREF_P(val);
			}

			if (Z_ISUNDEF(new_gen->retval)) {
				if (UNEXPECTED(zend_generator_get_current(new_gen) == generator)) {
					zend_throw_error(NULL, "Impossible to yield from the Generator being currently run");
					HANDLE_EXCEPTION();
				} else {
					zend_generator_yield_from(generator, new_gen);
				}
			} else if (UNEXPECTED(new_gen->execute_data == NULL)) {
				zend_throw_error(NULL, "Generator passed to yield from was aborted without proper return and is unable to continue");
				HANDLE_EXCEPTION();
			} else {
				if (RETURN_VALUE_USED(opline)) {
					ZVAL_COPY(EX_VAR(opline->result.var), &new_gen->retval);
				}
				ZEND_VM_NEXT_OPCODE();
			}
		} else {
			zend_object_iterator *iter = ce->get_iterator(ce, val, 0);
			zval_ptr_dtor_nogc(free_op1);

			if (UNEXPECTED(!iter) || UNEXPECTED(EG(exception))) {
				if (!EG(exception)) {
					zend_throw_error(NULL, "Object of type %s did not create an Iterator", ZSTR_VAL(ce->name));
				}
				HANDLE_EXCEPTION();
			}

			iter->index = 0;
			if (iter->funcs->rewind) {
				iter->funcs->rewind(iter);
				if (UNEXPECTED(EG(exception) != NULL)) {
					OBJ_RELEASE(&iter->std);
					HANDLE_EXCEPTION();
				}
			}

			ZVAL_OBJ(&generator->values, &iter->std);
		}
	} else {
		zend_throw_error(NULL, "Can use \"yield from\" only with arrays and Traversables", 0);
		HANDLE_EXCEPTION();
	}

	/* This is the default return value
	 * when the expression is a Generator, it will be overwritten in zend_generator_resume() */
	if (RETURN_VALUE_USED(opline)) {
		ZVAL_NULL(EX_VAR(opline->result.var));
	}

	/* We increment to the next op, so we are at the correct position when the
	 * generator is resumed. */
	ZEND_VM_INC_OPCODE();

	/* The GOTO VM uses a local opline variable. We need to set the opline
	 * variable in execute_data so we don't resume at an old position. */
	SAVE_OPLINE();

	ZEND_VM_RETURN();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_TYPE_CHECK_SPEC_TMP_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *value;
	int result = 0;
	zend_free_op free_op1;

	SAVE_OPLINE();
	value = _get_zval_ptr_tmp(opline->op1.var, execute_data, &free_op1);
	if (EXPECTED(Z_TYPE_P(value) == opline->extended_value)) {
		if (IS_TMP_VAR != IS_CONST && UNEXPECTED(Z_TYPE_P(value) == IS_OBJECT)) {
			zend_class_entry *ce = Z_OBJCE_P(value);

			if (UNEXPECTED(ZSTR_LEN(ce->name) != sizeof("__PHP_Incomplete_Class") - 1) ||
			    EXPECTED(memcmp(ZSTR_VAL(ce->name), "__PHP_Incomplete_Class", sizeof("__PHP_Incomplete_Class") - 1) != 0)) {
				result = 1;
			}
		} else if (UNEXPECTED(Z_TYPE_P(value) == IS_RESOURCE)) {
			const char *type_name = zend_rsrc_list_get_rsrc_type(Z_RES_P(value));

			if (EXPECTED(type_name != NULL)) {
				result = 1;
			}
		} else {
			result = 1;
		}
	} else if (UNEXPECTED(opline->extended_value == _IS_BOOL) &&
			   EXPECTED(Z_TYPE_P(value) == IS_TRUE || Z_TYPE_P(value) == IS_FALSE)) {
		result = 1;
	}
	zval_ptr_dtor_nogc(free_op1);
	ZEND_VM_SMART_BRANCH(result, 1);
	ZVAL_BOOL(EX_VAR(opline->result.var), result);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_IS_IDENTICAL_SPEC_TMP_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *op1, *op2;
	int result;

	SAVE_OPLINE();
	op1 = _get_zval_ptr_tmp(opline->op1.var, execute_data, &free_op1);
	op2 = EX_CONSTANT(opline->op2);
	result = fast_is_identical_function(op1, op2);
	zval_ptr_dtor_nogc(free_op1);

	ZEND_VM_SMART_BRANCH(result, (IS_TMP_VAR|IS_CONST) & (IS_VAR|IS_TMP_VAR));
	ZVAL_BOOL(EX_VAR(opline->result.var), result);
	if ((IS_TMP_VAR|IS_CONST) & (IS_VAR|IS_TMP_VAR)) {
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_IS_NOT_IDENTICAL_SPEC_TMP_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *op1, *op2;
	int result;

	SAVE_OPLINE();
	op1 = _get_zval_ptr_tmp(opline->op1.var, execute_data, &free_op1);
	op2 = EX_CONSTANT(opline->op2);
	result = fast_is_not_identical_function(op1, op2);
	zval_ptr_dtor_nogc(free_op1);

	ZEND_VM_SMART_BRANCH(result, (IS_TMP_VAR|IS_CONST) & (IS_VAR|IS_TMP_VAR));
	ZVAL_BOOL(EX_VAR(opline->result.var), result);
	if ((IS_TMP_VAR|IS_CONST) & (IS_VAR|IS_TMP_VAR)) {
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_DIM_FUNC_ARG_SPEC_TMP_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *container;
	zend_free_op free_op1;

	SAVE_OPLINE();

	if (zend_is_by_ref_func_arg_fetch(opline, EX(call))) {
        if (IS_TMP_VAR == IS_CONST || IS_TMP_VAR == IS_TMP_VAR) {
            zend_throw_error(NULL, "Cannot use temporary expression in write context");

			zval_ptr_dtor_nogc(EX_VAR(opline->op1.var));
			HANDLE_EXCEPTION();
        }
		container = NULL;
		if (IS_TMP_VAR == IS_VAR && UNEXPECTED(container == NULL)) {
			zend_throw_error(NULL, "Cannot use string offset as an array");

			HANDLE_EXCEPTION();
		}
		zend_fetch_dimension_address_W(EX_VAR(opline->result.var), container, EX_CONSTANT(opline->op2), IS_CONST);
		if (IS_TMP_VAR == IS_VAR && READY_TO_DESTROY(free_op1)) {
			EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 1);
		}


	} else {
		if (IS_CONST == IS_UNUSED) {
			zend_throw_error(NULL, "Cannot use [] for reading");

			zval_ptr_dtor_nogc(EX_VAR(opline->op1.var));
			HANDLE_EXCEPTION();
		}
		container = _get_zval_ptr_tmp(opline->op1.var, execute_data, &free_op1);
		zend_fetch_dimension_address_read_R(EX_VAR(opline->result.var), container, EX_CONSTANT(opline->op2), IS_CONST);

		zval_ptr_dtor_nogc(free_op1);
	}
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_R_SPEC_TMP_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *container;

	zval *offset;

	SAVE_OPLINE();
	container = _get_zval_ptr_tmp(opline->op1.var, execute_data, &free_op1);

	if (IS_TMP_VAR == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}

	offset = EX_CONSTANT(opline->op2);

	if (IS_TMP_VAR == IS_CONST ||
	    (IS_TMP_VAR != IS_UNUSED && UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT))) {
		if ((IS_TMP_VAR & (IS_VAR|IS_CV)) && Z_ISREF_P(container)) {
			container = Z_REFVAL_P(container);
			if (UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT)) {
				goto fetch_obj_r_no_object;
			}
		} else {
			goto fetch_obj_r_no_object;
		}
	}

	/* here we are sure we are dealing with an object */
	do {
		zend_object *zobj = Z_OBJ_P(container);
		zval *retval;

		if (IS_CONST == IS_CONST &&
			EXPECTED(zobj->ce == CACHED_PTR(Z_CACHE_SLOT_P(offset)))) {
			uint32_t prop_offset = (uint32_t)(intptr_t)CACHED_PTR(Z_CACHE_SLOT_P(offset) + sizeof(void*));

			if (EXPECTED(prop_offset != (uint32_t)ZEND_DYNAMIC_PROPERTY_OFFSET)) {
				retval = OBJ_PROP(zobj, prop_offset);
				if (EXPECTED(Z_TYPE_P(retval) != IS_UNDEF)) {
					ZVAL_COPY(EX_VAR(opline->result.var), retval);
					break;
				}
			} else if (EXPECTED(zobj->properties != NULL)) {
				retval = zend_hash_find(zobj->properties, Z_STR_P(offset));
				if (EXPECTED(retval)) {
					ZVAL_COPY(EX_VAR(opline->result.var), retval);
					break;
				}
			}
		}

		if (UNEXPECTED(zobj->handlers->read_property == NULL)) {
fetch_obj_r_no_object:
			zend_error(E_NOTICE, "Trying to get property of non-object");
			ZVAL_NULL(EX_VAR(opline->result.var));
		} else {
			retval = zobj->handlers->read_property(container, offset, BP_VAR_R, ((IS_CONST == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(offset)) : NULL), EX_VAR(opline->result.var));

			if (retval != EX_VAR(opline->result.var)) {
				ZVAL_COPY(EX_VAR(opline->result.var), retval);
			}
		}
	} while (0);

	zval_ptr_dtor_nogc(free_op1);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_FUNC_ARG_SPEC_TMP_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *container;

	if (zend_is_by_ref_func_arg_fetch(opline, EX(call))) {
		/* Behave like FETCH_OBJ_W */
		zend_free_op free_op1;
		zval *property;

		SAVE_OPLINE();
		property = EX_CONSTANT(opline->op2);
		container = NULL;

		if (IS_TMP_VAR == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
			zend_throw_error(NULL, "Using $this when not in object context");

			HANDLE_EXCEPTION();
		}
		if (IS_TMP_VAR == IS_CONST || IS_TMP_VAR == IS_TMP_VAR) {
			zend_throw_error(NULL, "Cannot use temporary expression in write context");


			HANDLE_EXCEPTION();
		}
		if (IS_TMP_VAR == IS_VAR && UNEXPECTED(container == NULL)) {
			zend_throw_error(NULL, "Cannot use string offset as an object");

			HANDLE_EXCEPTION();
		}
		zend_fetch_property_address(EX_VAR(opline->result.var), container, IS_TMP_VAR, property, IS_CONST, ((IS_CONST == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), BP_VAR_W);

		if (IS_TMP_VAR == IS_VAR && READY_TO_DESTROY(free_op1)) {
			EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 0);
		}

		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	} else {
		ZEND_VM_TAIL_CALL(ZEND_FETCH_OBJ_R_SPEC_TMP_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS_PASSTHRU));
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ROPE_ADD_SPEC_TMP_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zend_string **rope;
	zval *var;

	/* op1 and result are the same */
	rope = (zend_string**)EX_VAR(opline->op1.var);
	if (IS_CONST == IS_CONST) {
		var = EX_CONSTANT(opline->op2);
		rope[opline->extended_value] = zend_string_copy(Z_STR_P(var));
	} else {
		var = EX_CONSTANT(opline->op2);
		if (EXPECTED(Z_TYPE_P(var) == IS_STRING)) {
			if (IS_CONST == IS_CV) {
				rope[opline->extended_value] = zend_string_copy(Z_STR_P(var));
			} else {
				rope[opline->extended_value] = Z_STR_P(var);
			}
		} else {
			SAVE_OPLINE();
			if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(var) == IS_UNDEF)) {
				GET_OP2_UNDEF_CV(var, BP_VAR_R);
			}
			rope[opline->extended_value] = _zval_get_string_func(var);

			ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
		}
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ROPE_END_SPEC_TMP_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zend_string **rope;
	zval *var, *ret;
	uint32_t i;
	size_t len = 0;
	char *target;

	rope = (zend_string**)EX_VAR(opline->op1.var);
	if (IS_CONST == IS_CONST) {
		var = EX_CONSTANT(opline->op2);
		rope[opline->extended_value] = zend_string_copy(Z_STR_P(var));
	} else {
		var = EX_CONSTANT(opline->op2);
		if (EXPECTED(Z_TYPE_P(var) == IS_STRING)) {
			if (IS_CONST == IS_CV) {
				rope[opline->extended_value] = zend_string_copy(Z_STR_P(var));
			} else {
				rope[opline->extended_value] = Z_STR_P(var);
			}
		} else {
			SAVE_OPLINE();
			if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(var) == IS_UNDEF)) {
				GET_OP2_UNDEF_CV(var, BP_VAR_R);
			}
			rope[opline->extended_value] = _zval_get_string_func(var);

			if (UNEXPECTED(EG(exception))) {
				for (i = 0; i <= opline->extended_value; i++) {
					zend_string_release(rope[i]);
				}
				HANDLE_EXCEPTION();
			}
		}
	}
	for (i = 0; i <= opline->extended_value; i++) {
		len += ZSTR_LEN(rope[i]);
	}
	ret = EX_VAR(opline->result.var);
	ZVAL_STR(ret, zend_string_alloc(len, 0));
	target = Z_STRVAL_P(ret);
	for (i = 0; i <= opline->extended_value; i++) {
		memcpy(target, ZSTR_VAL(rope[i]), ZSTR_LEN(rope[i]));
		target += ZSTR_LEN(rope[i]);
		zend_string_release(rope[i]);
	}
	*target = '\0';

	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ADD_ARRAY_ELEMENT_SPEC_TMP_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *expr_ptr, new_expr;

	SAVE_OPLINE();
	if ((IS_TMP_VAR == IS_VAR || IS_TMP_VAR == IS_CV) &&
	    UNEXPECTED(opline->extended_value & ZEND_ARRAY_ELEMENT_REF)) {
		expr_ptr = NULL;
		if (IS_TMP_VAR == IS_VAR && UNEXPECTED(expr_ptr == NULL)) {
			zend_throw_error(NULL, "Cannot create references to/from string offsets");
			zend_array_destroy(Z_ARRVAL_P(EX_VAR(opline->result.var)));
			HANDLE_EXCEPTION();
		}
		ZVAL_MAKE_REF(expr_ptr);
		Z_ADDREF_P(expr_ptr);

	} else {
		expr_ptr = _get_zval_ptr_tmp(opline->op1.var, execute_data, &free_op1);
		if (IS_TMP_VAR == IS_TMP_VAR) {
			/* pass */
		} else if (IS_TMP_VAR == IS_CONST) {
			if (UNEXPECTED(Z_OPT_COPYABLE_P(expr_ptr))) {
				ZVAL_COPY_VALUE(&new_expr, expr_ptr);
				zval_copy_ctor_func(&new_expr);
				expr_ptr = &new_expr;
			}
		} else if (IS_TMP_VAR == IS_CV) {
			ZVAL_DEREF(expr_ptr);
			if (Z_REFCOUNTED_P(expr_ptr)) {
				Z_ADDREF_P(expr_ptr);
			}
		} else /* if (IS_TMP_VAR == IS_VAR) */ {
			if (UNEXPECTED(Z_ISREF_P(expr_ptr))) {
				zend_refcounted *ref = Z_COUNTED_P(expr_ptr);

				expr_ptr = Z_REFVAL_P(expr_ptr);
				if (UNEXPECTED(--GC_REFCOUNT(ref) == 0)) {
					ZVAL_COPY_VALUE(&new_expr, expr_ptr);
					expr_ptr = &new_expr;
					efree_size(ref, sizeof(zend_reference));
				} else if (Z_OPT_REFCOUNTED_P(expr_ptr)) {
					Z_ADDREF_P(expr_ptr);
				}
			}
		}
	}

	if (IS_CONST != IS_UNUSED) {

		zval *offset = EX_CONSTANT(opline->op2);
		zend_string *str;
		zend_ulong hval;

add_again:
		if (EXPECTED(Z_TYPE_P(offset) == IS_STRING)) {
			str = Z_STR_P(offset);
			if (IS_CONST != IS_CONST) {
				if (ZEND_HANDLE_NUMERIC(str, hval)) {
					goto num_index;
				}
			}
str_index:
			zend_hash_update(Z_ARRVAL_P(EX_VAR(opline->result.var)), str, expr_ptr);
		} else if (EXPECTED(Z_TYPE_P(offset) == IS_LONG)) {
			hval = Z_LVAL_P(offset);
num_index:
			zend_hash_index_update(Z_ARRVAL_P(EX_VAR(opline->result.var)), hval, expr_ptr);
		} else if ((IS_CONST & (IS_VAR|IS_CV)) && EXPECTED(Z_TYPE_P(offset) == IS_REFERENCE)) {
			offset = Z_REFVAL_P(offset);
			goto add_again;
		} else if (Z_TYPE_P(offset) == IS_NULL) {
			str = ZSTR_EMPTY_ALLOC();
			goto str_index;
		} else if (Z_TYPE_P(offset) == IS_DOUBLE) {
			hval = zend_dval_to_lval(Z_DVAL_P(offset));
			goto num_index;
		} else if (Z_TYPE_P(offset) == IS_FALSE) {
			hval = 0;
			goto num_index;
		} else if (Z_TYPE_P(offset) == IS_TRUE) {
			hval = 1;
			goto num_index;
		} else if (IS_CONST == IS_CV && Z_TYPE_P(offset) == IS_UNDEF) {
			GET_OP2_UNDEF_CV(offset, BP_VAR_R);
			str = ZSTR_EMPTY_ALLOC();
			goto str_index;
		} else {
			zend_error(E_WARNING, "Illegal offset type");
			zval_ptr_dtor(expr_ptr);
		}

	} else {
		zend_hash_next_index_insert(Z_ARRVAL_P(EX_VAR(opline->result.var)), expr_ptr);
	}
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_INIT_ARRAY_SPEC_TMP_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	zval *array;
	uint32_t size;
	USE_OPLINE

	array = EX_VAR(opline->result.var);
	if (IS_TMP_VAR != IS_UNUSED) {
		size = opline->extended_value >> ZEND_ARRAY_SIZE_SHIFT;
	} else {
		size = 0;
	}
	ZVAL_NEW_ARR(array);
	zend_hash_init(Z_ARRVAL_P(array), size, NULL, ZVAL_PTR_DTOR, 0);

	if (IS_TMP_VAR != IS_UNUSED) {
		/* Explicitly initialize array as not-packed if flag is set */
		if (opline->extended_value & ZEND_ARRAY_NOT_PACKED) {
			zend_hash_real_init(Z_ARRVAL_P(array), 0);
		}
	}

	if (IS_TMP_VAR == IS_UNUSED) {
		ZEND_VM_NEXT_OPCODE();
#if 0 || (IS_TMP_VAR != IS_UNUSED)
	} else {
		ZEND_VM_TAIL_CALL(ZEND_ADD_ARRAY_ELEMENT_SPEC_TMP_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS_PASSTHRU));
#endif
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_YIELD_SPEC_TMP_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zend_generator *generator = zend_get_running_generator(execute_data);

	SAVE_OPLINE();
	if (UNEXPECTED(generator->flags & ZEND_GENERATOR_FORCED_CLOSE)) {
		zend_throw_error(NULL, "Cannot yield from finally in a force-closed generator");

		zval_ptr_dtor_nogc(EX_VAR(opline->op1.var));
		HANDLE_EXCEPTION();
	}

	/* Destroy the previously yielded value */
	zval_ptr_dtor(&generator->value);

	/* Destroy the previously yielded key */
	zval_ptr_dtor(&generator->key);

	/* Set the new yielded value */
	if (IS_TMP_VAR != IS_UNUSED) {
		zend_free_op free_op1;

		if (UNEXPECTED(EX(func)->op_array.fn_flags & ZEND_ACC_RETURN_REFERENCE)) {
			/* Constants and temporary variables aren't yieldable by reference,
			 * but we still allow them with a notice. */
			if (IS_TMP_VAR == IS_CONST || IS_TMP_VAR == IS_TMP_VAR) {
				zval *value;

				zend_error(E_NOTICE, "Only variable references should be yielded by reference");

				value = _get_zval_ptr_tmp(opline->op1.var, execute_data, &free_op1);
				ZVAL_COPY_VALUE(&generator->value, value);
				if (IS_TMP_VAR != IS_CONST) {
					if (UNEXPECTED(Z_OPT_COPYABLE(generator->value))) {
						zval_copy_ctor_func(&generator->value);
					}
				}
			} else {
				zval *value_ptr = NULL;

				if (IS_TMP_VAR == IS_VAR && UNEXPECTED(value_ptr == NULL)) {
					zend_throw_error(NULL, "Cannot yield string offsets by reference");

					HANDLE_EXCEPTION();
				}

				/* If a function call result is yielded and the function did
				 * not return by reference we throw a notice. */
				if (IS_TMP_VAR == IS_VAR &&
				    (value_ptr == &EG(uninitialized_zval) ||
				     (opline->extended_value == ZEND_RETURNS_FUNCTION &&
				      !(Z_VAR_FLAGS_P(value_ptr) & IS_VAR_RET_REF)))) {
					zend_error(E_NOTICE, "Only variable references should be yielded by reference");
				} else {
					ZVAL_MAKE_REF(value_ptr);
				}
				ZVAL_COPY(&generator->value, value_ptr);

			}
		} else {
			zval *value = _get_zval_ptr_tmp(opline->op1.var, execute_data, &free_op1);

			/* Consts, temporary variables and references need copying */
			if (IS_TMP_VAR == IS_CONST) {
				ZVAL_COPY_VALUE(&generator->value, value);
				if (UNEXPECTED(Z_OPT_COPYABLE(generator->value))) {
					zval_copy_ctor_func(&generator->value);
				}
			} else if (IS_TMP_VAR == IS_TMP_VAR) {
				ZVAL_COPY_VALUE(&generator->value, value);
            } else if ((IS_TMP_VAR & (IS_VAR|IS_CV)) && Z_ISREF_P(value)) {
				ZVAL_COPY(&generator->value, Z_REFVAL_P(value));

			} else {
				ZVAL_COPY_VALUE(&generator->value, value);
				if (IS_TMP_VAR == IS_CV) {
					if (Z_OPT_REFCOUNTED_P(value)) Z_ADDREF_P(value);
				}
			}
		}
	} else {
		/* If no value was specified yield null */
		ZVAL_NULL(&generator->value);
	}

	/* Set the new yielded key */
	if (IS_CONST != IS_UNUSED) {

		zval *key = EX_CONSTANT(opline->op2);

		/* Consts, temporary variables and references need copying */
		if (IS_CONST == IS_CONST) {
			ZVAL_COPY_VALUE(&generator->key, key);
			if (UNEXPECTED(Z_OPT_COPYABLE(generator->key))) {
				zval_copy_ctor_func(&generator->key);
			}
		} else if (IS_CONST == IS_TMP_VAR) {
			ZVAL_COPY_VALUE(&generator->key, key);
		} else if ((IS_CONST & (IS_VAR|IS_CV)) && Z_ISREF_P(key)) {
			ZVAL_COPY(&generator->key, Z_REFVAL_P(key));

		} else {
			ZVAL_COPY_VALUE(&generator->key, key);
			if (IS_CONST == IS_CV) {
				if (Z_OPT_REFCOUNTED_P(key)) Z_ADDREF_P(key);
			}
		}

		if (Z_TYPE(generator->key) == IS_LONG
		    && Z_LVAL(generator->key) > generator->largest_used_integer_key
		) {
			generator->largest_used_integer_key = Z_LVAL(generator->key);
		}
	} else {
		/* If no key was specified we use auto-increment keys */
		generator->largest_used_integer_key++;
		ZVAL_LONG(&generator->key, generator->largest_used_integer_key);
	}

	if (RETURN_VALUE_USED(opline)) {
		/* If the return value of yield is used set the send
		 * target and initialize it to NULL */
		generator->send_target = EX_VAR(opline->result.var);
		ZVAL_NULL(generator->send_target);
	} else {
		generator->send_target = NULL;
	}

	/* We increment to the next op, so we are at the correct position when the
	 * generator is resumed. */
	ZEND_VM_INC_OPCODE();

	/* The GOTO VM uses a local opline variable. We need to set the opline
	 * variable in execute_data so we don't resume at an old position. */
	SAVE_OPLINE();

	ZEND_VM_RETURN();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_IS_IDENTICAL_SPEC_TMP_TMP_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1, free_op2;
	zval *op1, *op2;
	int result;

	SAVE_OPLINE();
	op1 = _get_zval_ptr_tmp(opline->op1.var, execute_data, &free_op1);
	op2 = _get_zval_ptr_tmp(opline->op2.var, execute_data, &free_op2);
	result = fast_is_identical_function(op1, op2);
	zval_ptr_dtor_nogc(free_op1);
	zval_ptr_dtor_nogc(free_op2);
	ZEND_VM_SMART_BRANCH(result, (IS_TMP_VAR|IS_TMP_VAR) & (IS_VAR|IS_TMP_VAR));
	ZVAL_BOOL(EX_VAR(opline->result.var), result);
	if ((IS_TMP_VAR|IS_TMP_VAR) & (IS_VAR|IS_TMP_VAR)) {
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_IS_NOT_IDENTICAL_SPEC_TMP_TMP_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1, free_op2;
	zval *op1, *op2;
	int result;

	SAVE_OPLINE();
	op1 = _get_zval_ptr_tmp(opline->op1.var, execute_data, &free_op1);
	op2 = _get_zval_ptr_tmp(opline->op2.var, execute_data, &free_op2);
	result = fast_is_not_identical_function(op1, op2);
	zval_ptr_dtor_nogc(free_op1);
	zval_ptr_dtor_nogc(free_op2);
	ZEND_VM_SMART_BRANCH(result, (IS_TMP_VAR|IS_TMP_VAR) & (IS_VAR|IS_TMP_VAR));
	ZVAL_BOOL(EX_VAR(opline->result.var), result);
	if ((IS_TMP_VAR|IS_TMP_VAR) & (IS_VAR|IS_TMP_VAR)) {
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_YIELD_SPEC_TMP_TMP_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zend_generator *generator = zend_get_running_generator(execute_data);

	SAVE_OPLINE();
	if (UNEXPECTED(generator->flags & ZEND_GENERATOR_FORCED_CLOSE)) {
		zend_throw_error(NULL, "Cannot yield from finally in a force-closed generator");
		zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
		zval_ptr_dtor_nogc(EX_VAR(opline->op1.var));
		HANDLE_EXCEPTION();
	}

	/* Destroy the previously yielded value */
	zval_ptr_dtor(&generator->value);

	/* Destroy the previously yielded key */
	zval_ptr_dtor(&generator->key);

	/* Set the new yielded value */
	if (IS_TMP_VAR != IS_UNUSED) {
		zend_free_op free_op1;

		if (UNEXPECTED(EX(func)->op_array.fn_flags & ZEND_ACC_RETURN_REFERENCE)) {
			/* Constants and temporary variables aren't yieldable by reference,
			 * but we still allow them with a notice. */
			if (IS_TMP_VAR == IS_CONST || IS_TMP_VAR == IS_TMP_VAR) {
				zval *value;

				zend_error(E_NOTICE, "Only variable references should be yielded by reference");

				value = _get_zval_ptr_tmp(opline->op1.var, execute_data, &free_op1);
				ZVAL_COPY_VALUE(&generator->value, value);
				if (IS_TMP_VAR != IS_CONST) {
					if (UNEXPECTED(Z_OPT_COPYABLE(generator->value))) {
						zval_copy_ctor_func(&generator->value);
					}
				}
			} else {
				zval *value_ptr = NULL;

				if (IS_TMP_VAR == IS_VAR && UNEXPECTED(value_ptr == NULL)) {
					zend_throw_error(NULL, "Cannot yield string offsets by reference");
					zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
					HANDLE_EXCEPTION();
				}

				/* If a function call result is yielded and the function did
				 * not return by reference we throw a notice. */
				if (IS_TMP_VAR == IS_VAR &&
				    (value_ptr == &EG(uninitialized_zval) ||
				     (opline->extended_value == ZEND_RETURNS_FUNCTION &&
				      !(Z_VAR_FLAGS_P(value_ptr) & IS_VAR_RET_REF)))) {
					zend_error(E_NOTICE, "Only variable references should be yielded by reference");
				} else {
					ZVAL_MAKE_REF(value_ptr);
				}
				ZVAL_COPY(&generator->value, value_ptr);

			}
		} else {
			zval *value = _get_zval_ptr_tmp(opline->op1.var, execute_data, &free_op1);

			/* Consts, temporary variables and references need copying */
			if (IS_TMP_VAR == IS_CONST) {
				ZVAL_COPY_VALUE(&generator->value, value);
				if (UNEXPECTED(Z_OPT_COPYABLE(generator->value))) {
					zval_copy_ctor_func(&generator->value);
				}
			} else if (IS_TMP_VAR == IS_TMP_VAR) {
				ZVAL_COPY_VALUE(&generator->value, value);
            } else if ((IS_TMP_VAR & (IS_VAR|IS_CV)) && Z_ISREF_P(value)) {
				ZVAL_COPY(&generator->value, Z_REFVAL_P(value));

			} else {
				ZVAL_COPY_VALUE(&generator->value, value);
				if (IS_TMP_VAR == IS_CV) {
					if (Z_OPT_REFCOUNTED_P(value)) Z_ADDREF_P(value);
				}
			}
		}
	} else {
		/* If no value was specified yield null */
		ZVAL_NULL(&generator->value);
	}

	/* Set the new yielded key */
	if (IS_TMP_VAR != IS_UNUSED) {
		zend_free_op free_op2;
		zval *key = _get_zval_ptr_tmp(opline->op2.var, execute_data, &free_op2);

		/* Consts, temporary variables and references need copying */
		if (IS_TMP_VAR == IS_CONST) {
			ZVAL_COPY_VALUE(&generator->key, key);
			if (UNEXPECTED(Z_OPT_COPYABLE(generator->key))) {
				zval_copy_ctor_func(&generator->key);
			}
		} else if (IS_TMP_VAR == IS_TMP_VAR) {
			ZVAL_COPY_VALUE(&generator->key, key);
		} else if ((IS_TMP_VAR & (IS_VAR|IS_CV)) && Z_ISREF_P(key)) {
			ZVAL_COPY(&generator->key, Z_REFVAL_P(key));

		} else {
			ZVAL_COPY_VALUE(&generator->key, key);
			if (IS_TMP_VAR == IS_CV) {
				if (Z_OPT_REFCOUNTED_P(key)) Z_ADDREF_P(key);
			}
		}

		if (Z_TYPE(generator->key) == IS_LONG
		    && Z_LVAL(generator->key) > generator->largest_used_integer_key
		) {
			generator->largest_used_integer_key = Z_LVAL(generator->key);
		}
	} else {
		/* If no key was specified we use auto-increment keys */
		generator->largest_used_integer_key++;
		ZVAL_LONG(&generator->key, generator->largest_used_integer_key);
	}

	if (RETURN_VALUE_USED(opline)) {
		/* If the return value of yield is used set the send
		 * target and initialize it to NULL */
		generator->send_target = EX_VAR(opline->result.var);
		ZVAL_NULL(generator->send_target);
	} else {
		generator->send_target = NULL;
	}

	/* We increment to the next op, so we are at the correct position when the
	 * generator is resumed. */
	ZEND_VM_INC_OPCODE();

	/* The GOTO VM uses a local opline variable. We need to set the opline
	 * variable in execute_data so we don't resume at an old position. */
	SAVE_OPLINE();

	ZEND_VM_RETURN();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_IS_IDENTICAL_SPEC_TMP_VAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1, free_op2;
	zval *op1, *op2;
	int result;

	SAVE_OPLINE();
	op1 = _get_zval_ptr_tmp(opline->op1.var, execute_data, &free_op1);
	op2 = _get_zval_ptr_var_deref(opline->op2.var, execute_data, &free_op2);
	result = fast_is_identical_function(op1, op2);
	zval_ptr_dtor_nogc(free_op1);
	zval_ptr_dtor_nogc(free_op2);
	ZEND_VM_SMART_BRANCH(result, (IS_TMP_VAR|IS_VAR) & (IS_VAR|IS_TMP_VAR));
	ZVAL_BOOL(EX_VAR(opline->result.var), result);
	if ((IS_TMP_VAR|IS_VAR) & (IS_VAR|IS_TMP_VAR)) {
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_IS_NOT_IDENTICAL_SPEC_TMP_VAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1, free_op2;
	zval *op1, *op2;
	int result;

	SAVE_OPLINE();
	op1 = _get_zval_ptr_tmp(opline->op1.var, execute_data, &free_op1);
	op2 = _get_zval_ptr_var_deref(opline->op2.var, execute_data, &free_op2);
	result = fast_is_not_identical_function(op1, op2);
	zval_ptr_dtor_nogc(free_op1);
	zval_ptr_dtor_nogc(free_op2);
	ZEND_VM_SMART_BRANCH(result, (IS_TMP_VAR|IS_VAR) & (IS_VAR|IS_TMP_VAR));
	ZVAL_BOOL(EX_VAR(opline->result.var), result);
	if ((IS_TMP_VAR|IS_VAR) & (IS_VAR|IS_TMP_VAR)) {
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_YIELD_SPEC_TMP_VAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zend_generator *generator = zend_get_running_generator(execute_data);

	SAVE_OPLINE();
	if (UNEXPECTED(generator->flags & ZEND_GENERATOR_FORCED_CLOSE)) {
		zend_throw_error(NULL, "Cannot yield from finally in a force-closed generator");
		zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
		zval_ptr_dtor_nogc(EX_VAR(opline->op1.var));
		HANDLE_EXCEPTION();
	}

	/* Destroy the previously yielded value */
	zval_ptr_dtor(&generator->value);

	/* Destroy the previously yielded key */
	zval_ptr_dtor(&generator->key);

	/* Set the new yielded value */
	if (IS_TMP_VAR != IS_UNUSED) {
		zend_free_op free_op1;

		if (UNEXPECTED(EX(func)->op_array.fn_flags & ZEND_ACC_RETURN_REFERENCE)) {
			/* Constants and temporary variables aren't yieldable by reference,
			 * but we still allow them with a notice. */
			if (IS_TMP_VAR == IS_CONST || IS_TMP_VAR == IS_TMP_VAR) {
				zval *value;

				zend_error(E_NOTICE, "Only variable references should be yielded by reference");

				value = _get_zval_ptr_tmp(opline->op1.var, execute_data, &free_op1);
				ZVAL_COPY_VALUE(&generator->value, value);
				if (IS_TMP_VAR != IS_CONST) {
					if (UNEXPECTED(Z_OPT_COPYABLE(generator->value))) {
						zval_copy_ctor_func(&generator->value);
					}
				}
			} else {
				zval *value_ptr = NULL;

				if (IS_TMP_VAR == IS_VAR && UNEXPECTED(value_ptr == NULL)) {
					zend_throw_error(NULL, "Cannot yield string offsets by reference");
					zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
					HANDLE_EXCEPTION();
				}

				/* If a function call result is yielded and the function did
				 * not return by reference we throw a notice. */
				if (IS_TMP_VAR == IS_VAR &&
				    (value_ptr == &EG(uninitialized_zval) ||
				     (opline->extended_value == ZEND_RETURNS_FUNCTION &&
				      !(Z_VAR_FLAGS_P(value_ptr) & IS_VAR_RET_REF)))) {
					zend_error(E_NOTICE, "Only variable references should be yielded by reference");
				} else {
					ZVAL_MAKE_REF(value_ptr);
				}
				ZVAL_COPY(&generator->value, value_ptr);

			}
		} else {
			zval *value = _get_zval_ptr_tmp(opline->op1.var, execute_data, &free_op1);

			/* Consts, temporary variables and references need copying */
			if (IS_TMP_VAR == IS_CONST) {
				ZVAL_COPY_VALUE(&generator->value, value);
				if (UNEXPECTED(Z_OPT_COPYABLE(generator->value))) {
					zval_copy_ctor_func(&generator->value);
				}
			} else if (IS_TMP_VAR == IS_TMP_VAR) {
				ZVAL_COPY_VALUE(&generator->value, value);
            } else if ((IS_TMP_VAR & (IS_VAR|IS_CV)) && Z_ISREF_P(value)) {
				ZVAL_COPY(&generator->value, Z_REFVAL_P(value));

			} else {
				ZVAL_COPY_VALUE(&generator->value, value);
				if (IS_TMP_VAR == IS_CV) {
					if (Z_OPT_REFCOUNTED_P(value)) Z_ADDREF_P(value);
				}
			}
		}
	} else {
		/* If no value was specified yield null */
		ZVAL_NULL(&generator->value);
	}

	/* Set the new yielded key */
	if (IS_VAR != IS_UNUSED) {
		zend_free_op free_op2;
		zval *key = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);

		/* Consts, temporary variables and references need copying */
		if (IS_VAR == IS_CONST) {
			ZVAL_COPY_VALUE(&generator->key, key);
			if (UNEXPECTED(Z_OPT_COPYABLE(generator->key))) {
				zval_copy_ctor_func(&generator->key);
			}
		} else if (IS_VAR == IS_TMP_VAR) {
			ZVAL_COPY_VALUE(&generator->key, key);
		} else if ((IS_VAR & (IS_VAR|IS_CV)) && Z_ISREF_P(key)) {
			ZVAL_COPY(&generator->key, Z_REFVAL_P(key));
			zval_ptr_dtor_nogc(free_op2);
		} else {
			ZVAL_COPY_VALUE(&generator->key, key);
			if (IS_VAR == IS_CV) {
				if (Z_OPT_REFCOUNTED_P(key)) Z_ADDREF_P(key);
			}
		}

		if (Z_TYPE(generator->key) == IS_LONG
		    && Z_LVAL(generator->key) > generator->largest_used_integer_key
		) {
			generator->largest_used_integer_key = Z_LVAL(generator->key);
		}
	} else {
		/* If no key was specified we use auto-increment keys */
		generator->largest_used_integer_key++;
		ZVAL_LONG(&generator->key, generator->largest_used_integer_key);
	}

	if (RETURN_VALUE_USED(opline)) {
		/* If the return value of yield is used set the send
		 * target and initialize it to NULL */
		generator->send_target = EX_VAR(opline->result.var);
		ZVAL_NULL(generator->send_target);
	} else {
		generator->send_target = NULL;
	}

	/* We increment to the next op, so we are at the correct position when the
	 * generator is resumed. */
	ZEND_VM_INC_OPCODE();

	/* The GOTO VM uses a local opline variable. We need to set the opline
	 * variable in execute_data so we don't resume at an old position. */
	SAVE_OPLINE();

	ZEND_VM_RETURN();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_DIM_FUNC_ARG_SPEC_TMP_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *container;
	zend_free_op free_op1;

	SAVE_OPLINE();

	if (zend_is_by_ref_func_arg_fetch(opline, EX(call))) {
        if (IS_TMP_VAR == IS_CONST || IS_TMP_VAR == IS_TMP_VAR) {
            zend_throw_error(NULL, "Cannot use temporary expression in write context");

			zval_ptr_dtor_nogc(EX_VAR(opline->op1.var));
			HANDLE_EXCEPTION();
        }
		container = NULL;
		if (IS_TMP_VAR == IS_VAR && UNEXPECTED(container == NULL)) {
			zend_throw_error(NULL, "Cannot use string offset as an array");

			HANDLE_EXCEPTION();
		}
		zend_fetch_dimension_address_W(EX_VAR(opline->result.var), container, NULL, IS_UNUSED);
		if (IS_TMP_VAR == IS_VAR && READY_TO_DESTROY(free_op1)) {
			EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 1);
		}


	} else {
		if (IS_UNUSED == IS_UNUSED) {
			zend_throw_error(NULL, "Cannot use [] for reading");

			zval_ptr_dtor_nogc(EX_VAR(opline->op1.var));
			HANDLE_EXCEPTION();
		}
		container = _get_zval_ptr_tmp(opline->op1.var, execute_data, &free_op1);
		zend_fetch_dimension_address_read_R(EX_VAR(opline->result.var), container, NULL, IS_UNUSED);

		zval_ptr_dtor_nogc(free_op1);
	}
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_VERIFY_RETURN_TYPE_SPEC_TMP_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	SAVE_OPLINE();
	if (IS_TMP_VAR == IS_UNUSED) {
		zend_verify_missing_return_type(EX(func), CACHE_ADDR(opline->op2.num));
	} else {
/* prevents "undefined variable opline" errors */
#if 0 || (IS_TMP_VAR != IS_UNUSED)
		zval *retval_ref, *retval_ptr;
		zend_free_op free_op1;
		zend_arg_info *ret_info = EX(func)->common.arg_info - 1;

		retval_ref = retval_ptr = _get_zval_ptr_tmp(opline->op1.var, execute_data, &free_op1);

		if (IS_TMP_VAR == IS_CONST) {
			ZVAL_COPY(EX_VAR(opline->result.var), retval_ptr);
			retval_ref = retval_ptr = EX_VAR(opline->result.var);
		} else if (IS_TMP_VAR == IS_VAR) {
			if (UNEXPECTED(Z_TYPE_P(retval_ptr) == IS_INDIRECT)) {
				retval_ptr = Z_INDIRECT_P(retval_ptr);
			}
			ZVAL_DEREF(retval_ptr);
		} else if (IS_TMP_VAR == IS_CV) {
			ZVAL_DEREF(retval_ptr);
		}

		if (UNEXPECTED(!ret_info->class_name
			&& ret_info->type_hint != IS_CALLABLE
			&& !ZEND_SAME_FAKE_TYPE(ret_info->type_hint, Z_TYPE_P(retval_ptr))
			&& !(EX(func)->op_array.fn_flags & ZEND_ACC_RETURN_REFERENCE)
			&& retval_ref != retval_ptr)
		) {
			/* A cast might happen - unwrap the reference if this is a by-value return */
			if (Z_REFCOUNT_P(retval_ref) == 1) {
				ZVAL_UNREF(retval_ref);
			} else {
				Z_DELREF_P(retval_ref);
				ZVAL_COPY(retval_ref, retval_ptr);
			}
			retval_ptr = retval_ref;
		}
		zend_verify_return_type(EX(func), retval_ptr, CACHE_ADDR(opline->op2.num));

		if (UNEXPECTED(EG(exception) != NULL)) {
			zval_ptr_dtor_nogc(free_op1);
		}
#endif
	}
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ADD_ARRAY_ELEMENT_SPEC_TMP_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *expr_ptr, new_expr;

	SAVE_OPLINE();
	if ((IS_TMP_VAR == IS_VAR || IS_TMP_VAR == IS_CV) &&
	    UNEXPECTED(opline->extended_value & ZEND_ARRAY_ELEMENT_REF)) {
		expr_ptr = NULL;
		if (IS_TMP_VAR == IS_VAR && UNEXPECTED(expr_ptr == NULL)) {
			zend_throw_error(NULL, "Cannot create references to/from string offsets");
			zend_array_destroy(Z_ARRVAL_P(EX_VAR(opline->result.var)));
			HANDLE_EXCEPTION();
		}
		ZVAL_MAKE_REF(expr_ptr);
		Z_ADDREF_P(expr_ptr);

	} else {
		expr_ptr = _get_zval_ptr_tmp(opline->op1.var, execute_data, &free_op1);
		if (IS_TMP_VAR == IS_TMP_VAR) {
			/* pass */
		} else if (IS_TMP_VAR == IS_CONST) {
			if (UNEXPECTED(Z_OPT_COPYABLE_P(expr_ptr))) {
				ZVAL_COPY_VALUE(&new_expr, expr_ptr);
				zval_copy_ctor_func(&new_expr);
				expr_ptr = &new_expr;
			}
		} else if (IS_TMP_VAR == IS_CV) {
			ZVAL_DEREF(expr_ptr);
			if (Z_REFCOUNTED_P(expr_ptr)) {
				Z_ADDREF_P(expr_ptr);
			}
		} else /* if (IS_TMP_VAR == IS_VAR) */ {
			if (UNEXPECTED(Z_ISREF_P(expr_ptr))) {
				zend_refcounted *ref = Z_COUNTED_P(expr_ptr);

				expr_ptr = Z_REFVAL_P(expr_ptr);
				if (UNEXPECTED(--GC_REFCOUNT(ref) == 0)) {
					ZVAL_COPY_VALUE(&new_expr, expr_ptr);
					expr_ptr = &new_expr;
					efree_size(ref, sizeof(zend_reference));
				} else if (Z_OPT_REFCOUNTED_P(expr_ptr)) {
					Z_ADDREF_P(expr_ptr);
				}
			}
		}
	}

	if (IS_UNUSED != IS_UNUSED) {

		zval *offset = NULL;
		zend_string *str;
		zend_ulong hval;

add_again:
		if (EXPECTED(Z_TYPE_P(offset) == IS_STRING)) {
			str = Z_STR_P(offset);
			if (IS_UNUSED != IS_CONST) {
				if (ZEND_HANDLE_NUMERIC(str, hval)) {
					goto num_index;
				}
			}
str_index:
			zend_hash_update(Z_ARRVAL_P(EX_VAR(opline->result.var)), str, expr_ptr);
		} else if (EXPECTED(Z_TYPE_P(offset) == IS_LONG)) {
			hval = Z_LVAL_P(offset);
num_index:
			zend_hash_index_update(Z_ARRVAL_P(EX_VAR(opline->result.var)), hval, expr_ptr);
		} else if ((IS_UNUSED & (IS_VAR|IS_CV)) && EXPECTED(Z_TYPE_P(offset) == IS_REFERENCE)) {
			offset = Z_REFVAL_P(offset);
			goto add_again;
		} else if (Z_TYPE_P(offset) == IS_NULL) {
			str = ZSTR_EMPTY_ALLOC();
			goto str_index;
		} else if (Z_TYPE_P(offset) == IS_DOUBLE) {
			hval = zend_dval_to_lval(Z_DVAL_P(offset));
			goto num_index;
		} else if (Z_TYPE_P(offset) == IS_FALSE) {
			hval = 0;
			goto num_index;
		} else if (Z_TYPE_P(offset) == IS_TRUE) {
			hval = 1;
			goto num_index;
		} else if (IS_UNUSED == IS_CV && Z_TYPE_P(offset) == IS_UNDEF) {
			GET_OP2_UNDEF_CV(offset, BP_VAR_R);
			str = ZSTR_EMPTY_ALLOC();
			goto str_index;
		} else {
			zend_error(E_WARNING, "Illegal offset type");
			zval_ptr_dtor(expr_ptr);
		}

	} else {
		zend_hash_next_index_insert(Z_ARRVAL_P(EX_VAR(opline->result.var)), expr_ptr);
	}
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_INIT_ARRAY_SPEC_TMP_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	zval *array;
	uint32_t size;
	USE_OPLINE

	array = EX_VAR(opline->result.var);
	if (IS_TMP_VAR != IS_UNUSED) {
		size = opline->extended_value >> ZEND_ARRAY_SIZE_SHIFT;
	} else {
		size = 0;
	}
	ZVAL_NEW_ARR(array);
	zend_hash_init(Z_ARRVAL_P(array), size, NULL, ZVAL_PTR_DTOR, 0);

	if (IS_TMP_VAR != IS_UNUSED) {
		/* Explicitly initialize array as not-packed if flag is set */
		if (opline->extended_value & ZEND_ARRAY_NOT_PACKED) {
			zend_hash_real_init(Z_ARRVAL_P(array), 0);
		}
	}

	if (IS_TMP_VAR == IS_UNUSED) {
		ZEND_VM_NEXT_OPCODE();
#if 0 || (IS_TMP_VAR != IS_UNUSED)
	} else {
		ZEND_VM_TAIL_CALL(ZEND_ADD_ARRAY_ELEMENT_SPEC_TMP_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS_PASSTHRU));
#endif
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_YIELD_SPEC_TMP_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zend_generator *generator = zend_get_running_generator(execute_data);

	SAVE_OPLINE();
	if (UNEXPECTED(generator->flags & ZEND_GENERATOR_FORCED_CLOSE)) {
		zend_throw_error(NULL, "Cannot yield from finally in a force-closed generator");

		zval_ptr_dtor_nogc(EX_VAR(opline->op1.var));
		HANDLE_EXCEPTION();
	}

	/* Destroy the previously yielded value */
	zval_ptr_dtor(&generator->value);

	/* Destroy the previously yielded key */
	zval_ptr_dtor(&generator->key);

	/* Set the new yielded value */
	if (IS_TMP_VAR != IS_UNUSED) {
		zend_free_op free_op1;

		if (UNEXPECTED(EX(func)->op_array.fn_flags & ZEND_ACC_RETURN_REFERENCE)) {
			/* Constants and temporary variables aren't yieldable by reference,
			 * but we still allow them with a notice. */
			if (IS_TMP_VAR == IS_CONST || IS_TMP_VAR == IS_TMP_VAR) {
				zval *value;

				zend_error(E_NOTICE, "Only variable references should be yielded by reference");

				value = _get_zval_ptr_tmp(opline->op1.var, execute_data, &free_op1);
				ZVAL_COPY_VALUE(&generator->value, value);
				if (IS_TMP_VAR != IS_CONST) {
					if (UNEXPECTED(Z_OPT_COPYABLE(generator->value))) {
						zval_copy_ctor_func(&generator->value);
					}
				}
			} else {
				zval *value_ptr = NULL;

				if (IS_TMP_VAR == IS_VAR && UNEXPECTED(value_ptr == NULL)) {
					zend_throw_error(NULL, "Cannot yield string offsets by reference");

					HANDLE_EXCEPTION();
				}

				/* If a function call result is yielded and the function did
				 * not return by reference we throw a notice. */
				if (IS_TMP_VAR == IS_VAR &&
				    (value_ptr == &EG(uninitialized_zval) ||
				     (opline->extended_value == ZEND_RETURNS_FUNCTION &&
				      !(Z_VAR_FLAGS_P(value_ptr) & IS_VAR_RET_REF)))) {
					zend_error(E_NOTICE, "Only variable references should be yielded by reference");
				} else {
					ZVAL_MAKE_REF(value_ptr);
				}
				ZVAL_COPY(&generator->value, value_ptr);

			}
		} else {
			zval *value = _get_zval_ptr_tmp(opline->op1.var, execute_data, &free_op1);

			/* Consts, temporary variables and references need copying */
			if (IS_TMP_VAR == IS_CONST) {
				ZVAL_COPY_VALUE(&generator->value, value);
				if (UNEXPECTED(Z_OPT_COPYABLE(generator->value))) {
					zval_copy_ctor_func(&generator->value);
				}
			} else if (IS_TMP_VAR == IS_TMP_VAR) {
				ZVAL_COPY_VALUE(&generator->value, value);
            } else if ((IS_TMP_VAR & (IS_VAR|IS_CV)) && Z_ISREF_P(value)) {
				ZVAL_COPY(&generator->value, Z_REFVAL_P(value));

			} else {
				ZVAL_COPY_VALUE(&generator->value, value);
				if (IS_TMP_VAR == IS_CV) {
					if (Z_OPT_REFCOUNTED_P(value)) Z_ADDREF_P(value);
				}
			}
		}
	} else {
		/* If no value was specified yield null */
		ZVAL_NULL(&generator->value);
	}

	/* Set the new yielded key */
	if (IS_UNUSED != IS_UNUSED) {

		zval *key = NULL;

		/* Consts, temporary variables and references need copying */
		if (IS_UNUSED == IS_CONST) {
			ZVAL_COPY_VALUE(&generator->key, key);
			if (UNEXPECTED(Z_OPT_COPYABLE(generator->key))) {
				zval_copy_ctor_func(&generator->key);
			}
		} else if (IS_UNUSED == IS_TMP_VAR) {
			ZVAL_COPY_VALUE(&generator->key, key);
		} else if ((IS_UNUSED & (IS_VAR|IS_CV)) && Z_ISREF_P(key)) {
			ZVAL_COPY(&generator->key, Z_REFVAL_P(key));

		} else {
			ZVAL_COPY_VALUE(&generator->key, key);
			if (IS_UNUSED == IS_CV) {
				if (Z_OPT_REFCOUNTED_P(key)) Z_ADDREF_P(key);
			}
		}

		if (Z_TYPE(generator->key) == IS_LONG
		    && Z_LVAL(generator->key) > generator->largest_used_integer_key
		) {
			generator->largest_used_integer_key = Z_LVAL(generator->key);
		}
	} else {
		/* If no key was specified we use auto-increment keys */
		generator->largest_used_integer_key++;
		ZVAL_LONG(&generator->key, generator->largest_used_integer_key);
	}

	if (RETURN_VALUE_USED(opline)) {
		/* If the return value of yield is used set the send
		 * target and initialize it to NULL */
		generator->send_target = EX_VAR(opline->result.var);
		ZVAL_NULL(generator->send_target);
	} else {
		generator->send_target = NULL;
	}

	/* We increment to the next op, so we are at the correct position when the
	 * generator is resumed. */
	ZEND_VM_INC_OPCODE();

	/* The GOTO VM uses a local opline variable. We need to set the opline
	 * variable in execute_data so we don't resume at an old position. */
	SAVE_OPLINE();

	ZEND_VM_RETURN();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_IS_IDENTICAL_SPEC_TMP_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *op1, *op2;
	int result;

	SAVE_OPLINE();
	op1 = _get_zval_ptr_tmp(opline->op1.var, execute_data, &free_op1);
	op2 = _get_zval_ptr_cv_deref_BP_VAR_R(execute_data, opline->op2.var);
	result = fast_is_identical_function(op1, op2);
	zval_ptr_dtor_nogc(free_op1);

	ZEND_VM_SMART_BRANCH(result, (IS_TMP_VAR|IS_CV) & (IS_VAR|IS_TMP_VAR));
	ZVAL_BOOL(EX_VAR(opline->result.var), result);
	if ((IS_TMP_VAR|IS_CV) & (IS_VAR|IS_TMP_VAR)) {
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_IS_NOT_IDENTICAL_SPEC_TMP_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *op1, *op2;
	int result;

	SAVE_OPLINE();
	op1 = _get_zval_ptr_tmp(opline->op1.var, execute_data, &free_op1);
	op2 = _get_zval_ptr_cv_deref_BP_VAR_R(execute_data, opline->op2.var);
	result = fast_is_not_identical_function(op1, op2);
	zval_ptr_dtor_nogc(free_op1);

	ZEND_VM_SMART_BRANCH(result, (IS_TMP_VAR|IS_CV) & (IS_VAR|IS_TMP_VAR));
	ZVAL_BOOL(EX_VAR(opline->result.var), result);
	if ((IS_TMP_VAR|IS_CV) & (IS_VAR|IS_TMP_VAR)) {
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_DIM_FUNC_ARG_SPEC_TMP_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *container;
	zend_free_op free_op1;

	SAVE_OPLINE();

	if (zend_is_by_ref_func_arg_fetch(opline, EX(call))) {
        if (IS_TMP_VAR == IS_CONST || IS_TMP_VAR == IS_TMP_VAR) {
            zend_throw_error(NULL, "Cannot use temporary expression in write context");

			zval_ptr_dtor_nogc(EX_VAR(opline->op1.var));
			HANDLE_EXCEPTION();
        }
		container = NULL;
		if (IS_TMP_VAR == IS_VAR && UNEXPECTED(container == NULL)) {
			zend_throw_error(NULL, "Cannot use string offset as an array");

			HANDLE_EXCEPTION();
		}
		zend_fetch_dimension_address_W(EX_VAR(opline->result.var), container, _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var), IS_CV);
		if (IS_TMP_VAR == IS_VAR && READY_TO_DESTROY(free_op1)) {
			EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 1);
		}


	} else {
		if (IS_CV == IS_UNUSED) {
			zend_throw_error(NULL, "Cannot use [] for reading");

			zval_ptr_dtor_nogc(EX_VAR(opline->op1.var));
			HANDLE_EXCEPTION();
		}
		container = _get_zval_ptr_tmp(opline->op1.var, execute_data, &free_op1);
		zend_fetch_dimension_address_read_R(EX_VAR(opline->result.var), container, _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var), IS_CV);

		zval_ptr_dtor_nogc(free_op1);
	}
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_R_SPEC_TMP_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *container;

	zval *offset;

	SAVE_OPLINE();
	container = _get_zval_ptr_tmp(opline->op1.var, execute_data, &free_op1);

	if (IS_TMP_VAR == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}

	offset = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);

	if (IS_TMP_VAR == IS_CONST ||
	    (IS_TMP_VAR != IS_UNUSED && UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT))) {
		if ((IS_TMP_VAR & (IS_VAR|IS_CV)) && Z_ISREF_P(container)) {
			container = Z_REFVAL_P(container);
			if (UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT)) {
				goto fetch_obj_r_no_object;
			}
		} else {
			goto fetch_obj_r_no_object;
		}
	}

	/* here we are sure we are dealing with an object */
	do {
		zend_object *zobj = Z_OBJ_P(container);
		zval *retval;

		if (IS_CV == IS_CONST &&
			EXPECTED(zobj->ce == CACHED_PTR(Z_CACHE_SLOT_P(offset)))) {
			uint32_t prop_offset = (uint32_t)(intptr_t)CACHED_PTR(Z_CACHE_SLOT_P(offset) + sizeof(void*));

			if (EXPECTED(prop_offset != (uint32_t)ZEND_DYNAMIC_PROPERTY_OFFSET)) {
				retval = OBJ_PROP(zobj, prop_offset);
				if (EXPECTED(Z_TYPE_P(retval) != IS_UNDEF)) {
					ZVAL_COPY(EX_VAR(opline->result.var), retval);
					break;
				}
			} else if (EXPECTED(zobj->properties != NULL)) {
				retval = zend_hash_find(zobj->properties, Z_STR_P(offset));
				if (EXPECTED(retval)) {
					ZVAL_COPY(EX_VAR(opline->result.var), retval);
					break;
				}
			}
		}

		if (UNEXPECTED(zobj->handlers->read_property == NULL)) {
fetch_obj_r_no_object:
			zend_error(E_NOTICE, "Trying to get property of non-object");
			ZVAL_NULL(EX_VAR(opline->result.var));
		} else {
			retval = zobj->handlers->read_property(container, offset, BP_VAR_R, ((IS_CV == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(offset)) : NULL), EX_VAR(opline->result.var));

			if (retval != EX_VAR(opline->result.var)) {
				ZVAL_COPY(EX_VAR(opline->result.var), retval);
			}
		}
	} while (0);

	zval_ptr_dtor_nogc(free_op1);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_FUNC_ARG_SPEC_TMP_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *container;

	if (zend_is_by_ref_func_arg_fetch(opline, EX(call))) {
		/* Behave like FETCH_OBJ_W */
		zend_free_op free_op1;
		zval *property;

		SAVE_OPLINE();
		property = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);
		container = NULL;

		if (IS_TMP_VAR == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
			zend_throw_error(NULL, "Using $this when not in object context");

			HANDLE_EXCEPTION();
		}
		if (IS_TMP_VAR == IS_CONST || IS_TMP_VAR == IS_TMP_VAR) {
			zend_throw_error(NULL, "Cannot use temporary expression in write context");


			HANDLE_EXCEPTION();
		}
		if (IS_TMP_VAR == IS_VAR && UNEXPECTED(container == NULL)) {
			zend_throw_error(NULL, "Cannot use string offset as an object");

			HANDLE_EXCEPTION();
		}
		zend_fetch_property_address(EX_VAR(opline->result.var), container, IS_TMP_VAR, property, IS_CV, ((IS_CV == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), BP_VAR_W);

		if (IS_TMP_VAR == IS_VAR && READY_TO_DESTROY(free_op1)) {
			EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 0);
		}

		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	} else {
		ZEND_VM_TAIL_CALL(ZEND_FETCH_OBJ_R_SPEC_TMP_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS_PASSTHRU));
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ROPE_ADD_SPEC_TMP_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zend_string **rope;
	zval *var;

	/* op1 and result are the same */
	rope = (zend_string**)EX_VAR(opline->op1.var);
	if (IS_CV == IS_CONST) {
		var = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);
		rope[opline->extended_value] = zend_string_copy(Z_STR_P(var));
	} else {
		var = _get_zval_ptr_cv_undef(execute_data, opline->op2.var);
		if (EXPECTED(Z_TYPE_P(var) == IS_STRING)) {
			if (IS_CV == IS_CV) {
				rope[opline->extended_value] = zend_string_copy(Z_STR_P(var));
			} else {
				rope[opline->extended_value] = Z_STR_P(var);
			}
		} else {
			SAVE_OPLINE();
			if (IS_CV == IS_CV && UNEXPECTED(Z_TYPE_P(var) == IS_UNDEF)) {
				GET_OP2_UNDEF_CV(var, BP_VAR_R);
			}
			rope[opline->extended_value] = _zval_get_string_func(var);

			ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
		}
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ROPE_END_SPEC_TMP_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zend_string **rope;
	zval *var, *ret;
	uint32_t i;
	size_t len = 0;
	char *target;

	rope = (zend_string**)EX_VAR(opline->op1.var);
	if (IS_CV == IS_CONST) {
		var = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);
		rope[opline->extended_value] = zend_string_copy(Z_STR_P(var));
	} else {
		var = _get_zval_ptr_cv_undef(execute_data, opline->op2.var);
		if (EXPECTED(Z_TYPE_P(var) == IS_STRING)) {
			if (IS_CV == IS_CV) {
				rope[opline->extended_value] = zend_string_copy(Z_STR_P(var));
			} else {
				rope[opline->extended_value] = Z_STR_P(var);
			}
		} else {
			SAVE_OPLINE();
			if (IS_CV == IS_CV && UNEXPECTED(Z_TYPE_P(var) == IS_UNDEF)) {
				GET_OP2_UNDEF_CV(var, BP_VAR_R);
			}
			rope[opline->extended_value] = _zval_get_string_func(var);

			if (UNEXPECTED(EG(exception))) {
				for (i = 0; i <= opline->extended_value; i++) {
					zend_string_release(rope[i]);
				}
				HANDLE_EXCEPTION();
			}
		}
	}
	for (i = 0; i <= opline->extended_value; i++) {
		len += ZSTR_LEN(rope[i]);
	}
	ret = EX_VAR(opline->result.var);
	ZVAL_STR(ret, zend_string_alloc(len, 0));
	target = Z_STRVAL_P(ret);
	for (i = 0; i <= opline->extended_value; i++) {
		memcpy(target, ZSTR_VAL(rope[i]), ZSTR_LEN(rope[i]));
		target += ZSTR_LEN(rope[i]);
		zend_string_release(rope[i]);
	}
	*target = '\0';

	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ADD_ARRAY_ELEMENT_SPEC_TMP_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *expr_ptr, new_expr;

	SAVE_OPLINE();
	if ((IS_TMP_VAR == IS_VAR || IS_TMP_VAR == IS_CV) &&
	    UNEXPECTED(opline->extended_value & ZEND_ARRAY_ELEMENT_REF)) {
		expr_ptr = NULL;
		if (IS_TMP_VAR == IS_VAR && UNEXPECTED(expr_ptr == NULL)) {
			zend_throw_error(NULL, "Cannot create references to/from string offsets");
			zend_array_destroy(Z_ARRVAL_P(EX_VAR(opline->result.var)));
			HANDLE_EXCEPTION();
		}
		ZVAL_MAKE_REF(expr_ptr);
		Z_ADDREF_P(expr_ptr);

	} else {
		expr_ptr = _get_zval_ptr_tmp(opline->op1.var, execute_data, &free_op1);
		if (IS_TMP_VAR == IS_TMP_VAR) {
			/* pass */
		} else if (IS_TMP_VAR == IS_CONST) {
			if (UNEXPECTED(Z_OPT_COPYABLE_P(expr_ptr))) {
				ZVAL_COPY_VALUE(&new_expr, expr_ptr);
				zval_copy_ctor_func(&new_expr);
				expr_ptr = &new_expr;
			}
		} else if (IS_TMP_VAR == IS_CV) {
			ZVAL_DEREF(expr_ptr);
			if (Z_REFCOUNTED_P(expr_ptr)) {
				Z_ADDREF_P(expr_ptr);
			}
		} else /* if (IS_TMP_VAR == IS_VAR) */ {
			if (UNEXPECTED(Z_ISREF_P(expr_ptr))) {
				zend_refcounted *ref = Z_COUNTED_P(expr_ptr);

				expr_ptr = Z_REFVAL_P(expr_ptr);
				if (UNEXPECTED(--GC_REFCOUNT(ref) == 0)) {
					ZVAL_COPY_VALUE(&new_expr, expr_ptr);
					expr_ptr = &new_expr;
					efree_size(ref, sizeof(zend_reference));
				} else if (Z_OPT_REFCOUNTED_P(expr_ptr)) {
					Z_ADDREF_P(expr_ptr);
				}
			}
		}
	}

	if (IS_CV != IS_UNUSED) {

		zval *offset = _get_zval_ptr_cv_undef(execute_data, opline->op2.var);
		zend_string *str;
		zend_ulong hval;

add_again:
		if (EXPECTED(Z_TYPE_P(offset) == IS_STRING)) {
			str = Z_STR_P(offset);
			if (IS_CV != IS_CONST) {
				if (ZEND_HANDLE_NUMERIC(str, hval)) {
					goto num_index;
				}
			}
str_index:
			zend_hash_update(Z_ARRVAL_P(EX_VAR(opline->result.var)), str, expr_ptr);
		} else if (EXPECTED(Z_TYPE_P(offset) == IS_LONG)) {
			hval = Z_LVAL_P(offset);
num_index:
			zend_hash_index_update(Z_ARRVAL_P(EX_VAR(opline->result.var)), hval, expr_ptr);
		} else if ((IS_CV & (IS_VAR|IS_CV)) && EXPECTED(Z_TYPE_P(offset) == IS_REFERENCE)) {
			offset = Z_REFVAL_P(offset);
			goto add_again;
		} else if (Z_TYPE_P(offset) == IS_NULL) {
			str = ZSTR_EMPTY_ALLOC();
			goto str_index;
		} else if (Z_TYPE_P(offset) == IS_DOUBLE) {
			hval = zend_dval_to_lval(Z_DVAL_P(offset));
			goto num_index;
		} else if (Z_TYPE_P(offset) == IS_FALSE) {
			hval = 0;
			goto num_index;
		} else if (Z_TYPE_P(offset) == IS_TRUE) {
			hval = 1;
			goto num_index;
		} else if (IS_CV == IS_CV && Z_TYPE_P(offset) == IS_UNDEF) {
			GET_OP2_UNDEF_CV(offset, BP_VAR_R);
			str = ZSTR_EMPTY_ALLOC();
			goto str_index;
		} else {
			zend_error(E_WARNING, "Illegal offset type");
			zval_ptr_dtor(expr_ptr);
		}

	} else {
		zend_hash_next_index_insert(Z_ARRVAL_P(EX_VAR(opline->result.var)), expr_ptr);
	}
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_INIT_ARRAY_SPEC_TMP_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	zval *array;
	uint32_t size;
	USE_OPLINE

	array = EX_VAR(opline->result.var);
	if (IS_TMP_VAR != IS_UNUSED) {
		size = opline->extended_value >> ZEND_ARRAY_SIZE_SHIFT;
	} else {
		size = 0;
	}
	ZVAL_NEW_ARR(array);
	zend_hash_init(Z_ARRVAL_P(array), size, NULL, ZVAL_PTR_DTOR, 0);

	if (IS_TMP_VAR != IS_UNUSED) {
		/* Explicitly initialize array as not-packed if flag is set */
		if (opline->extended_value & ZEND_ARRAY_NOT_PACKED) {
			zend_hash_real_init(Z_ARRVAL_P(array), 0);
		}
	}

	if (IS_TMP_VAR == IS_UNUSED) {
		ZEND_VM_NEXT_OPCODE();
#if 0 || (IS_TMP_VAR != IS_UNUSED)
	} else {
		ZEND_VM_TAIL_CALL(ZEND_ADD_ARRAY_ELEMENT_SPEC_TMP_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS_PASSTHRU));
#endif
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_YIELD_SPEC_TMP_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zend_generator *generator = zend_get_running_generator(execute_data);

	SAVE_OPLINE();
	if (UNEXPECTED(generator->flags & ZEND_GENERATOR_FORCED_CLOSE)) {
		zend_throw_error(NULL, "Cannot yield from finally in a force-closed generator");

		zval_ptr_dtor_nogc(EX_VAR(opline->op1.var));
		HANDLE_EXCEPTION();
	}

	/* Destroy the previously yielded value */
	zval_ptr_dtor(&generator->value);

	/* Destroy the previously yielded key */
	zval_ptr_dtor(&generator->key);

	/* Set the new yielded value */
	if (IS_TMP_VAR != IS_UNUSED) {
		zend_free_op free_op1;

		if (UNEXPECTED(EX(func)->op_array.fn_flags & ZEND_ACC_RETURN_REFERENCE)) {
			/* Constants and temporary variables aren't yieldable by reference,
			 * but we still allow them with a notice. */
			if (IS_TMP_VAR == IS_CONST || IS_TMP_VAR == IS_TMP_VAR) {
				zval *value;

				zend_error(E_NOTICE, "Only variable references should be yielded by reference");

				value = _get_zval_ptr_tmp(opline->op1.var, execute_data, &free_op1);
				ZVAL_COPY_VALUE(&generator->value, value);
				if (IS_TMP_VAR != IS_CONST) {
					if (UNEXPECTED(Z_OPT_COPYABLE(generator->value))) {
						zval_copy_ctor_func(&generator->value);
					}
				}
			} else {
				zval *value_ptr = NULL;

				if (IS_TMP_VAR == IS_VAR && UNEXPECTED(value_ptr == NULL)) {
					zend_throw_error(NULL, "Cannot yield string offsets by reference");

					HANDLE_EXCEPTION();
				}

				/* If a function call result is yielded and the function did
				 * not return by reference we throw a notice. */
				if (IS_TMP_VAR == IS_VAR &&
				    (value_ptr == &EG(uninitialized_zval) ||
				     (opline->extended_value == ZEND_RETURNS_FUNCTION &&
				      !(Z_VAR_FLAGS_P(value_ptr) & IS_VAR_RET_REF)))) {
					zend_error(E_NOTICE, "Only variable references should be yielded by reference");
				} else {
					ZVAL_MAKE_REF(value_ptr);
				}
				ZVAL_COPY(&generator->value, value_ptr);

			}
		} else {
			zval *value = _get_zval_ptr_tmp(opline->op1.var, execute_data, &free_op1);

			/* Consts, temporary variables and references need copying */
			if (IS_TMP_VAR == IS_CONST) {
				ZVAL_COPY_VALUE(&generator->value, value);
				if (UNEXPECTED(Z_OPT_COPYABLE(generator->value))) {
					zval_copy_ctor_func(&generator->value);
				}
			} else if (IS_TMP_VAR == IS_TMP_VAR) {
				ZVAL_COPY_VALUE(&generator->value, value);
            } else if ((IS_TMP_VAR & (IS_VAR|IS_CV)) && Z_ISREF_P(value)) {
				ZVAL_COPY(&generator->value, Z_REFVAL_P(value));

			} else {
				ZVAL_COPY_VALUE(&generator->value, value);
				if (IS_TMP_VAR == IS_CV) {
					if (Z_OPT_REFCOUNTED_P(value)) Z_ADDREF_P(value);
				}
			}
		}
	} else {
		/* If no value was specified yield null */
		ZVAL_NULL(&generator->value);
	}

	/* Set the new yielded key */
	if (IS_CV != IS_UNUSED) {

		zval *key = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);

		/* Consts, temporary variables and references need copying */
		if (IS_CV == IS_CONST) {
			ZVAL_COPY_VALUE(&generator->key, key);
			if (UNEXPECTED(Z_OPT_COPYABLE(generator->key))) {
				zval_copy_ctor_func(&generator->key);
			}
		} else if (IS_CV == IS_TMP_VAR) {
			ZVAL_COPY_VALUE(&generator->key, key);
		} else if ((IS_CV & (IS_VAR|IS_CV)) && Z_ISREF_P(key)) {
			ZVAL_COPY(&generator->key, Z_REFVAL_P(key));

		} else {
			ZVAL_COPY_VALUE(&generator->key, key);
			if (IS_CV == IS_CV) {
				if (Z_OPT_REFCOUNTED_P(key)) Z_ADDREF_P(key);
			}
		}

		if (Z_TYPE(generator->key) == IS_LONG
		    && Z_LVAL(generator->key) > generator->largest_used_integer_key
		) {
			generator->largest_used_integer_key = Z_LVAL(generator->key);
		}
	} else {
		/* If no key was specified we use auto-increment keys */
		generator->largest_used_integer_key++;
		ZVAL_LONG(&generator->key, generator->largest_used_integer_key);
	}

	if (RETURN_VALUE_USED(opline)) {
		/* If the return value of yield is used set the send
		 * target and initialize it to NULL */
		generator->send_target = EX_VAR(opline->result.var);
		ZVAL_NULL(generator->send_target);
	} else {
		generator->send_target = NULL;
	}

	/* We increment to the next op, so we are at the correct position when the
	 * generator is resumed. */
	ZEND_VM_INC_OPCODE();

	/* The GOTO VM uses a local opline variable. We need to set the opline
	 * variable in execute_data so we don't resume at an old position. */
	SAVE_OPLINE();

	ZEND_VM_RETURN();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_DIM_FUNC_ARG_SPEC_TMP_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *container;
	zend_free_op free_op1, free_op2;

	SAVE_OPLINE();

	if (zend_is_by_ref_func_arg_fetch(opline, EX(call))) {
        if (IS_TMP_VAR == IS_CONST || IS_TMP_VAR == IS_TMP_VAR) {
            zend_throw_error(NULL, "Cannot use temporary expression in write context");
			zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
			zval_ptr_dtor_nogc(EX_VAR(opline->op1.var));
			HANDLE_EXCEPTION();
        }
		container = NULL;
		if (IS_TMP_VAR == IS_VAR && UNEXPECTED(container == NULL)) {
			zend_throw_error(NULL, "Cannot use string offset as an array");
			zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
			HANDLE_EXCEPTION();
		}
		zend_fetch_dimension_address_W(EX_VAR(opline->result.var), container, _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2), (IS_TMP_VAR|IS_VAR));
		if (IS_TMP_VAR == IS_VAR && READY_TO_DESTROY(free_op1)) {
			EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 1);
		}
		zval_ptr_dtor_nogc(free_op2);

	} else {
		if ((IS_TMP_VAR|IS_VAR) == IS_UNUSED) {
			zend_throw_error(NULL, "Cannot use [] for reading");
			zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
			zval_ptr_dtor_nogc(EX_VAR(opline->op1.var));
			HANDLE_EXCEPTION();
		}
		container = _get_zval_ptr_tmp(opline->op1.var, execute_data, &free_op1);
		zend_fetch_dimension_address_read_R(EX_VAR(opline->result.var), container, _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2), (IS_TMP_VAR|IS_VAR));
		zval_ptr_dtor_nogc(free_op2);
		zval_ptr_dtor_nogc(free_op1);
	}
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_R_SPEC_TMP_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *container;
	zend_free_op free_op2;
	zval *offset;

	SAVE_OPLINE();
	container = _get_zval_ptr_tmp(opline->op1.var, execute_data, &free_op1);

	if (IS_TMP_VAR == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");
		zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
		HANDLE_EXCEPTION();
	}

	offset = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);

	if (IS_TMP_VAR == IS_CONST ||
	    (IS_TMP_VAR != IS_UNUSED && UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT))) {
		if ((IS_TMP_VAR & (IS_VAR|IS_CV)) && Z_ISREF_P(container)) {
			container = Z_REFVAL_P(container);
			if (UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT)) {
				goto fetch_obj_r_no_object;
			}
		} else {
			goto fetch_obj_r_no_object;
		}
	}

	/* here we are sure we are dealing with an object */
	do {
		zend_object *zobj = Z_OBJ_P(container);
		zval *retval;

		if ((IS_TMP_VAR|IS_VAR) == IS_CONST &&
			EXPECTED(zobj->ce == CACHED_PTR(Z_CACHE_SLOT_P(offset)))) {
			uint32_t prop_offset = (uint32_t)(intptr_t)CACHED_PTR(Z_CACHE_SLOT_P(offset) + sizeof(void*));

			if (EXPECTED(prop_offset != (uint32_t)ZEND_DYNAMIC_PROPERTY_OFFSET)) {
				retval = OBJ_PROP(zobj, prop_offset);
				if (EXPECTED(Z_TYPE_P(retval) != IS_UNDEF)) {
					ZVAL_COPY(EX_VAR(opline->result.var), retval);
					break;
				}
			} else if (EXPECTED(zobj->properties != NULL)) {
				retval = zend_hash_find(zobj->properties, Z_STR_P(offset));
				if (EXPECTED(retval)) {
					ZVAL_COPY(EX_VAR(opline->result.var), retval);
					break;
				}
			}
		}

		if (UNEXPECTED(zobj->handlers->read_property == NULL)) {
fetch_obj_r_no_object:
			zend_error(E_NOTICE, "Trying to get property of non-object");
			ZVAL_NULL(EX_VAR(opline->result.var));
		} else {
			retval = zobj->handlers->read_property(container, offset, BP_VAR_R, (((IS_TMP_VAR|IS_VAR) == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(offset)) : NULL), EX_VAR(opline->result.var));

			if (retval != EX_VAR(opline->result.var)) {
				ZVAL_COPY(EX_VAR(opline->result.var), retval);
			}
		}
	} while (0);

	zval_ptr_dtor_nogc(free_op2);
	zval_ptr_dtor_nogc(free_op1);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_FUNC_ARG_SPEC_TMP_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *container;

	if (zend_is_by_ref_func_arg_fetch(opline, EX(call))) {
		/* Behave like FETCH_OBJ_W */
		zend_free_op free_op1, free_op2;
		zval *property;

		SAVE_OPLINE();
		property = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);
		container = NULL;

		if (IS_TMP_VAR == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
			zend_throw_error(NULL, "Using $this when not in object context");
			zval_ptr_dtor_nogc(free_op2);
			HANDLE_EXCEPTION();
		}
		if (IS_TMP_VAR == IS_CONST || IS_TMP_VAR == IS_TMP_VAR) {
			zend_throw_error(NULL, "Cannot use temporary expression in write context");
			zval_ptr_dtor_nogc(free_op2);

			HANDLE_EXCEPTION();
		}
		if (IS_TMP_VAR == IS_VAR && UNEXPECTED(container == NULL)) {
			zend_throw_error(NULL, "Cannot use string offset as an object");
			zval_ptr_dtor_nogc(free_op2);
			HANDLE_EXCEPTION();
		}
		zend_fetch_property_address(EX_VAR(opline->result.var), container, IS_TMP_VAR, property, (IS_TMP_VAR|IS_VAR), (((IS_TMP_VAR|IS_VAR) == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), BP_VAR_W);
		zval_ptr_dtor_nogc(free_op2);
		if (IS_TMP_VAR == IS_VAR && READY_TO_DESTROY(free_op1)) {
			EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 0);
		}

		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	} else {
		ZEND_VM_TAIL_CALL(ZEND_FETCH_OBJ_R_SPEC_TMP_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS_PASSTHRU));
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ROPE_ADD_SPEC_TMP_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op2;
	zend_string **rope;
	zval *var;

	/* op1 and result are the same */
	rope = (zend_string**)EX_VAR(opline->op1.var);
	if ((IS_TMP_VAR|IS_VAR) == IS_CONST) {
		var = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);
		rope[opline->extended_value] = zend_string_copy(Z_STR_P(var));
	} else {
		var = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);
		if (EXPECTED(Z_TYPE_P(var) == IS_STRING)) {
			if ((IS_TMP_VAR|IS_VAR) == IS_CV) {
				rope[opline->extended_value] = zend_string_copy(Z_STR_P(var));
			} else {
				rope[opline->extended_value] = Z_STR_P(var);
			}
		} else {
			SAVE_OPLINE();
			if ((IS_TMP_VAR|IS_VAR) == IS_CV && UNEXPECTED(Z_TYPE_P(var) == IS_UNDEF)) {
				GET_OP2_UNDEF_CV(var, BP_VAR_R);
			}
			rope[opline->extended_value] = _zval_get_string_func(var);
			zval_ptr_dtor_nogc(free_op2);
			ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
		}
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ROPE_END_SPEC_TMP_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op2;
	zend_string **rope;
	zval *var, *ret;
	uint32_t i;
	size_t len = 0;
	char *target;

	rope = (zend_string**)EX_VAR(opline->op1.var);
	if ((IS_TMP_VAR|IS_VAR) == IS_CONST) {
		var = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);
		rope[opline->extended_value] = zend_string_copy(Z_STR_P(var));
	} else {
		var = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);
		if (EXPECTED(Z_TYPE_P(var) == IS_STRING)) {
			if ((IS_TMP_VAR|IS_VAR) == IS_CV) {
				rope[opline->extended_value] = zend_string_copy(Z_STR_P(var));
			} else {
				rope[opline->extended_value] = Z_STR_P(var);
			}
		} else {
			SAVE_OPLINE();
			if ((IS_TMP_VAR|IS_VAR) == IS_CV && UNEXPECTED(Z_TYPE_P(var) == IS_UNDEF)) {
				GET_OP2_UNDEF_CV(var, BP_VAR_R);
			}
			rope[opline->extended_value] = _zval_get_string_func(var);
			zval_ptr_dtor_nogc(free_op2);
			if (UNEXPECTED(EG(exception))) {
				for (i = 0; i <= opline->extended_value; i++) {
					zend_string_release(rope[i]);
				}
				HANDLE_EXCEPTION();
			}
		}
	}
	for (i = 0; i <= opline->extended_value; i++) {
		len += ZSTR_LEN(rope[i]);
	}
	ret = EX_VAR(opline->result.var);
	ZVAL_STR(ret, zend_string_alloc(len, 0));
	target = Z_STRVAL_P(ret);
	for (i = 0; i <= opline->extended_value; i++) {
		memcpy(target, ZSTR_VAL(rope[i]), ZSTR_LEN(rope[i]));
		target += ZSTR_LEN(rope[i]);
		zend_string_release(rope[i]);
	}
	*target = '\0';

	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ADD_ARRAY_ELEMENT_SPEC_TMP_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *expr_ptr, new_expr;

	SAVE_OPLINE();
	if ((IS_TMP_VAR == IS_VAR || IS_TMP_VAR == IS_CV) &&
	    UNEXPECTED(opline->extended_value & ZEND_ARRAY_ELEMENT_REF)) {
		expr_ptr = NULL;
		if (IS_TMP_VAR == IS_VAR && UNEXPECTED(expr_ptr == NULL)) {
			zend_throw_error(NULL, "Cannot create references to/from string offsets");
			zend_array_destroy(Z_ARRVAL_P(EX_VAR(opline->result.var)));
			HANDLE_EXCEPTION();
		}
		ZVAL_MAKE_REF(expr_ptr);
		Z_ADDREF_P(expr_ptr);

	} else {
		expr_ptr = _get_zval_ptr_tmp(opline->op1.var, execute_data, &free_op1);
		if (IS_TMP_VAR == IS_TMP_VAR) {
			/* pass */
		} else if (IS_TMP_VAR == IS_CONST) {
			if (UNEXPECTED(Z_OPT_COPYABLE_P(expr_ptr))) {
				ZVAL_COPY_VALUE(&new_expr, expr_ptr);
				zval_copy_ctor_func(&new_expr);
				expr_ptr = &new_expr;
			}
		} else if (IS_TMP_VAR == IS_CV) {
			ZVAL_DEREF(expr_ptr);
			if (Z_REFCOUNTED_P(expr_ptr)) {
				Z_ADDREF_P(expr_ptr);
			}
		} else /* if (IS_TMP_VAR == IS_VAR) */ {
			if (UNEXPECTED(Z_ISREF_P(expr_ptr))) {
				zend_refcounted *ref = Z_COUNTED_P(expr_ptr);

				expr_ptr = Z_REFVAL_P(expr_ptr);
				if (UNEXPECTED(--GC_REFCOUNT(ref) == 0)) {
					ZVAL_COPY_VALUE(&new_expr, expr_ptr);
					expr_ptr = &new_expr;
					efree_size(ref, sizeof(zend_reference));
				} else if (Z_OPT_REFCOUNTED_P(expr_ptr)) {
					Z_ADDREF_P(expr_ptr);
				}
			}
		}
	}

	if ((IS_TMP_VAR|IS_VAR) != IS_UNUSED) {
		zend_free_op free_op2;
		zval *offset = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);
		zend_string *str;
		zend_ulong hval;

add_again:
		if (EXPECTED(Z_TYPE_P(offset) == IS_STRING)) {
			str = Z_STR_P(offset);
			if ((IS_TMP_VAR|IS_VAR) != IS_CONST) {
				if (ZEND_HANDLE_NUMERIC(str, hval)) {
					goto num_index;
				}
			}
str_index:
			zend_hash_update(Z_ARRVAL_P(EX_VAR(opline->result.var)), str, expr_ptr);
		} else if (EXPECTED(Z_TYPE_P(offset) == IS_LONG)) {
			hval = Z_LVAL_P(offset);
num_index:
			zend_hash_index_update(Z_ARRVAL_P(EX_VAR(opline->result.var)), hval, expr_ptr);
		} else if (((IS_TMP_VAR|IS_VAR) & (IS_VAR|IS_CV)) && EXPECTED(Z_TYPE_P(offset) == IS_REFERENCE)) {
			offset = Z_REFVAL_P(offset);
			goto add_again;
		} else if (Z_TYPE_P(offset) == IS_NULL) {
			str = ZSTR_EMPTY_ALLOC();
			goto str_index;
		} else if (Z_TYPE_P(offset) == IS_DOUBLE) {
			hval = zend_dval_to_lval(Z_DVAL_P(offset));
			goto num_index;
		} else if (Z_TYPE_P(offset) == IS_FALSE) {
			hval = 0;
			goto num_index;
		} else if (Z_TYPE_P(offset) == IS_TRUE) {
			hval = 1;
			goto num_index;
		} else if ((IS_TMP_VAR|IS_VAR) == IS_CV && Z_TYPE_P(offset) == IS_UNDEF) {
			GET_OP2_UNDEF_CV(offset, BP_VAR_R);
			str = ZSTR_EMPTY_ALLOC();
			goto str_index;
		} else {
			zend_error(E_WARNING, "Illegal offset type");
			zval_ptr_dtor(expr_ptr);
		}
		zval_ptr_dtor_nogc(free_op2);
	} else {
		zend_hash_next_index_insert(Z_ARRVAL_P(EX_VAR(opline->result.var)), expr_ptr);
	}
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_INIT_ARRAY_SPEC_TMP_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	zval *array;
	uint32_t size;
	USE_OPLINE

	array = EX_VAR(opline->result.var);
	if (IS_TMP_VAR != IS_UNUSED) {
		size = opline->extended_value >> ZEND_ARRAY_SIZE_SHIFT;
	} else {
		size = 0;
	}
	ZVAL_NEW_ARR(array);
	zend_hash_init(Z_ARRVAL_P(array), size, NULL, ZVAL_PTR_DTOR, 0);

	if (IS_TMP_VAR != IS_UNUSED) {
		/* Explicitly initialize array as not-packed if flag is set */
		if (opline->extended_value & ZEND_ARRAY_NOT_PACKED) {
			zend_hash_real_init(Z_ARRVAL_P(array), 0);
		}
	}

	if (IS_TMP_VAR == IS_UNUSED) {
		ZEND_VM_NEXT_OPCODE();
#if 0 || (IS_TMP_VAR != IS_UNUSED)
	} else {
		ZEND_VM_TAIL_CALL(ZEND_ADD_ARRAY_ELEMENT_SPEC_TMP_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS_PASSTHRU));
#endif
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_PRE_INC_SPEC_VAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *var_ptr;

	var_ptr = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

	if (IS_VAR == IS_VAR && UNEXPECTED(var_ptr == NULL)) {
		SAVE_OPLINE();
		zend_throw_error(NULL, "Cannot increment/decrement overloaded objects nor string offsets");
		HANDLE_EXCEPTION();
	}

	if (EXPECTED(Z_TYPE_P(var_ptr) == IS_LONG)) {
		fast_long_increment_function(var_ptr);
		if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
			ZVAL_COPY_VALUE(EX_VAR(opline->result.var), var_ptr);
		}
		ZEND_VM_NEXT_OPCODE();
	}

	if (IS_VAR == IS_VAR && UNEXPECTED(var_ptr == &EG(error_zval))) {
		if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
			ZVAL_NULL(EX_VAR(opline->result.var));
		}
		ZEND_VM_NEXT_OPCODE();
	}

	SAVE_OPLINE();
	if (IS_VAR == IS_CV && UNEXPECTED(Z_TYPE_P(var_ptr) == IS_UNDEF)) {
		var_ptr = GET_OP1_UNDEF_CV(var_ptr, BP_VAR_RW);
	}
	ZVAL_DEREF(var_ptr);
	SEPARATE_ZVAL_NOREF(var_ptr);

	increment_function(var_ptr);

	if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
		ZVAL_COPY(EX_VAR(opline->result.var), var_ptr);
	}

	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_PRE_DEC_SPEC_VAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *var_ptr;

	var_ptr = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

	if (IS_VAR == IS_VAR && UNEXPECTED(var_ptr == NULL)) {
		SAVE_OPLINE();
		zend_throw_error(NULL, "Cannot increment/decrement overloaded objects nor string offsets");
		HANDLE_EXCEPTION();
	}

	if (EXPECTED(Z_TYPE_P(var_ptr) == IS_LONG)) {
		fast_long_decrement_function(var_ptr);
		if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
			ZVAL_COPY_VALUE(EX_VAR(opline->result.var), var_ptr);
		}
		ZEND_VM_NEXT_OPCODE();
	}

	if (IS_VAR == IS_VAR && UNEXPECTED(var_ptr == &EG(error_zval))) {
		if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
			ZVAL_NULL(EX_VAR(opline->result.var));
		}
		ZEND_VM_NEXT_OPCODE();
	}

	SAVE_OPLINE();
	if (IS_VAR == IS_CV && UNEXPECTED(Z_TYPE_P(var_ptr) == IS_UNDEF)) {
		var_ptr = GET_OP1_UNDEF_CV(var_ptr, BP_VAR_RW);
	}
	ZVAL_DEREF(var_ptr);
	SEPARATE_ZVAL_NOREF(var_ptr);

	decrement_function(var_ptr);

	if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
		ZVAL_COPY(EX_VAR(opline->result.var), var_ptr);
	}

	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_POST_INC_SPEC_VAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *var_ptr;

	var_ptr = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

	if (IS_VAR == IS_VAR && UNEXPECTED(var_ptr == NULL)) {
		SAVE_OPLINE();
		zend_throw_error(NULL, "Cannot increment/decrement overloaded objects nor string offsets");
		HANDLE_EXCEPTION();
	}

	if (EXPECTED(Z_TYPE_P(var_ptr) == IS_LONG)) {
		ZVAL_COPY_VALUE(EX_VAR(opline->result.var), var_ptr);
		fast_long_increment_function(var_ptr);
		ZEND_VM_NEXT_OPCODE();
	}

	if (IS_VAR == IS_VAR && UNEXPECTED(var_ptr == &EG(error_zval))) {
		ZVAL_NULL(EX_VAR(opline->result.var));
		ZEND_VM_NEXT_OPCODE();
	}

	SAVE_OPLINE();
	if (IS_VAR == IS_CV && UNEXPECTED(Z_TYPE_P(var_ptr) == IS_UNDEF)) {
		var_ptr = GET_OP1_UNDEF_CV(var_ptr, BP_VAR_RW);
	}
	ZVAL_DEREF(var_ptr);
	ZVAL_COPY_VALUE(EX_VAR(opline->result.var), var_ptr);
	zval_opt_copy_ctor(var_ptr);

	increment_function(var_ptr);

	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_POST_DEC_SPEC_VAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *var_ptr;

	var_ptr = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

	if (IS_VAR == IS_VAR && UNEXPECTED(var_ptr == NULL)) {
		SAVE_OPLINE();
		zend_throw_error(NULL, "Cannot increment/decrement overloaded objects nor string offsets");
		HANDLE_EXCEPTION();
	}

	if (EXPECTED(Z_TYPE_P(var_ptr) == IS_LONG)) {
		ZVAL_COPY_VALUE(EX_VAR(opline->result.var), var_ptr);
		fast_long_decrement_function(var_ptr);
		ZEND_VM_NEXT_OPCODE();
	}

	if (IS_VAR == IS_VAR && UNEXPECTED(var_ptr == &EG(error_zval))) {
		ZVAL_NULL(EX_VAR(opline->result.var));
		ZEND_VM_NEXT_OPCODE();
	}

	SAVE_OPLINE();
	if (IS_VAR == IS_CV && UNEXPECTED(Z_TYPE_P(var_ptr) == IS_UNDEF)) {
		var_ptr = GET_OP1_UNDEF_CV(var_ptr, BP_VAR_RW);
	}
	ZVAL_DEREF(var_ptr);
	ZVAL_COPY_VALUE(EX_VAR(opline->result.var), var_ptr);
	zval_opt_copy_ctor(var_ptr);

	decrement_function(var_ptr);

	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_RETURN_SPEC_VAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *retval_ptr;
	zend_free_op free_op1;

	retval_ptr = _get_zval_ptr_var(opline->op1.var, execute_data, &free_op1);
	if (IS_VAR == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(retval_ptr) == IS_UNDEF)) {
		SAVE_OPLINE();
		retval_ptr = GET_OP1_UNDEF_CV(retval_ptr, BP_VAR_R);
		if (EX(return_value)) {
			ZVAL_NULL(EX(return_value));
		}
	} else if (!EX(return_value)) {
		if (IS_VAR == IS_VAR || IS_VAR == IS_TMP_VAR ) {
			if (Z_REFCOUNTED_P(free_op1) && !Z_DELREF_P(free_op1)) {
				SAVE_OPLINE();
				zval_dtor_func_for_ptr(Z_COUNTED_P(free_op1));
			}
		}
	} else {
		if (IS_VAR == IS_CONST || IS_VAR == IS_TMP_VAR) {
			ZVAL_COPY_VALUE(EX(return_value), retval_ptr);
			if (IS_VAR == IS_CONST) {
				if (UNEXPECTED(Z_OPT_COPYABLE_P(EX(return_value)))) {
					zval_copy_ctor_func(EX(return_value));
				}
			}
		} else if (IS_VAR == IS_CV) {
			ZVAL_DEREF(retval_ptr);
			ZVAL_COPY(EX(return_value), retval_ptr);
		} else /* if (IS_VAR == IS_VAR) */ {
			if (UNEXPECTED(Z_ISREF_P(retval_ptr))) {
				zend_refcounted *ref = Z_COUNTED_P(retval_ptr);

				retval_ptr = Z_REFVAL_P(retval_ptr);
				ZVAL_COPY_VALUE(EX(return_value), retval_ptr);
				if (UNEXPECTED(--GC_REFCOUNT(ref) == 0)) {
					efree_size(ref, sizeof(zend_reference));
				} else if (Z_OPT_REFCOUNTED_P(retval_ptr)) {
					Z_ADDREF_P(retval_ptr);
				}
			} else {
				ZVAL_COPY_VALUE(EX(return_value), retval_ptr);
			}
		}
	}
	ZEND_VM_TAIL_CALL(zend_leave_helper_SPEC(ZEND_OPCODE_HANDLER_ARGS_PASSTHRU));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_RETURN_BY_REF_SPEC_VAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *retval_ptr;
	zend_free_op free_op1;

	SAVE_OPLINE();

	do {
		if (IS_VAR == IS_CONST || IS_VAR == IS_TMP_VAR ||
		    (IS_VAR == IS_VAR && opline->extended_value == ZEND_RETURNS_VALUE)) {
			/* Not supposed to happen, but we'll allow it */
			zend_error(E_NOTICE, "Only variable references should be returned by reference");

			retval_ptr = _get_zval_ptr_var(opline->op1.var, execute_data, &free_op1);
			if (!EX(return_value)) {
				if (IS_VAR == IS_TMP_VAR) {
					zval_ptr_dtor_nogc(free_op1);
				}
			} else {
				ZVAL_COPY_VALUE(EX(return_value), retval_ptr);
				Z_VAR_FLAGS_P(EX(return_value)) = IS_VAR_RET_REF;
				if (IS_VAR != IS_TMP_VAR) {
					zval_opt_copy_ctor_no_imm(EX(return_value));
				}
			}
			break;
		}

		retval_ptr = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

		if (IS_VAR == IS_VAR && UNEXPECTED(retval_ptr == NULL)) {
			zend_throw_error(NULL, "Cannot return string offsets by reference");
			HANDLE_EXCEPTION();
		}

		if (IS_VAR == IS_VAR) {
			if (retval_ptr == &EG(uninitialized_zval) ||
			    (opline->extended_value == ZEND_RETURNS_FUNCTION &&
			     !(Z_VAR_FLAGS_P(retval_ptr) & IS_VAR_RET_REF))) {
				zend_error(E_NOTICE, "Only variable references should be returned by reference");
				if (EX(return_value)) {
					ZVAL_NEW_REF(EX(return_value), retval_ptr);
					Z_VAR_FLAGS_P(EX(return_value)) = IS_VAR_RET_REF;
					if (Z_REFCOUNTED_P(retval_ptr)) Z_ADDREF_P(retval_ptr);
				}
				break;
			}
		}

		if (EX(return_value)) {
			ZVAL_MAKE_REF(retval_ptr);
			Z_ADDREF_P(retval_ptr);
			ZVAL_REF(EX(return_value), Z_REF_P(retval_ptr));
			Z_VAR_FLAGS_P(EX(return_value)) = IS_VAR_RET_REF;
		}
	} while (0);

	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	ZEND_VM_TAIL_CALL(zend_leave_helper_SPEC(ZEND_OPCODE_HANDLER_ARGS_PASSTHRU));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_GENERATOR_RETURN_SPEC_VAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *retval;
	zend_free_op free_op1;

	zend_generator *generator = zend_get_running_generator(execute_data);

	SAVE_OPLINE();
	retval = _get_zval_ptr_var(opline->op1.var, execute_data, &free_op1);

	/* Copy return value into generator->retval */
	if (IS_VAR == IS_CONST || IS_VAR == IS_TMP_VAR) {
		ZVAL_COPY_VALUE(&generator->retval, retval);
		if (IS_VAR == IS_CONST) {
			if (UNEXPECTED(Z_OPT_COPYABLE(generator->retval))) {
				zval_copy_ctor_func(&generator->retval);
			}
		}
	} else if (IS_VAR == IS_CV) {
		ZVAL_DEREF(retval);
		ZVAL_COPY(&generator->retval, retval);
	} else /* if (IS_VAR == IS_VAR) */ {
		if (UNEXPECTED(Z_ISREF_P(retval))) {
			zend_refcounted *ref = Z_COUNTED_P(retval);

			retval = Z_REFVAL_P(retval);
			ZVAL_COPY_VALUE(&generator->retval, retval);
			if (UNEXPECTED(--GC_REFCOUNT(ref) == 0)) {
				efree_size(ref, sizeof(zend_reference));
			} else if (Z_OPT_REFCOUNTED_P(retval)) {
				Z_ADDREF_P(retval);
			}
		} else {
			ZVAL_COPY_VALUE(&generator->retval, retval);
		}
	}

	/* Close the generator to free up resources */
	zend_generator_close(generator, 1);

	/* Pass execution back to handling code */
	ZEND_VM_RETURN();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_THROW_SPEC_VAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *value;
	zend_free_op free_op1;

	SAVE_OPLINE();
	value = _get_zval_ptr_var(opline->op1.var, execute_data, &free_op1);

	do {
		if (IS_VAR == IS_CONST || UNEXPECTED(Z_TYPE_P(value) != IS_OBJECT)) {
			if ((IS_VAR & (IS_VAR|IS_CV)) && Z_ISREF_P(value)) {
				value = Z_REFVAL_P(value);
				if (EXPECTED(Z_TYPE_P(value) == IS_OBJECT)) {
					break;
				}
			}
			if (IS_VAR == IS_CV && UNEXPECTED(Z_TYPE_P(value) == IS_UNDEF)) {
				GET_OP1_UNDEF_CV(value, BP_VAR_R);
			}
			if (UNEXPECTED(EG(exception) != NULL)) {
				HANDLE_EXCEPTION();
			}
			zend_throw_error(NULL, "Can only throw objects");
			zval_ptr_dtor_nogc(free_op1);
			HANDLE_EXCEPTION();
		}
	} while (0);

	zend_exception_save();
	if (IS_VAR != IS_TMP_VAR) {
		if (Z_REFCOUNTED_P(value)) Z_ADDREF_P(value);
	}

	zend_throw_exception_object(value);
	zend_exception_restore();
	zval_ptr_dtor_nogc(free_op1);
	HANDLE_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_SEND_VAR_SPEC_VAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *varptr, *arg;
	zend_free_op free_op1;

	varptr = _get_zval_ptr_var(opline->op1.var, execute_data, &free_op1);
	if (IS_VAR == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(varptr) == IS_UNDEF)) {
		SAVE_OPLINE();
		GET_OP1_UNDEF_CV(varptr, BP_VAR_R);
		arg = ZEND_CALL_VAR(EX(call), opline->result.var);
		ZVAL_NULL(arg);
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}

	arg = ZEND_CALL_VAR(EX(call), opline->result.var);

	if (IS_VAR == IS_CV) {
		ZVAL_OPT_DEREF(varptr);
		ZVAL_COPY(arg, varptr);
	} else /* if (IS_VAR == IS_VAR) */ {
		if (UNEXPECTED(Z_ISREF_P(varptr))) {
			zend_refcounted *ref = Z_COUNTED_P(varptr);

			varptr = Z_REFVAL_P(varptr);
			ZVAL_COPY_VALUE(arg, varptr);
			if (UNEXPECTED(--GC_REFCOUNT(ref) == 0)) {
				efree_size(ref, sizeof(zend_reference));
			} else if (Z_OPT_REFCOUNTED_P(arg)) {
				Z_ADDREF_P(arg);
			}
		} else {
			ZVAL_COPY_VALUE(arg, varptr);
		}
	}

	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_SEND_VAR_NO_REF_SPEC_VAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *varptr, *arg;

	if (!(opline->extended_value & ZEND_ARG_COMPILE_TIME_BOUND)) {
		if (!ARG_SHOULD_BE_SENT_BY_REF(EX(call)->func, opline->op2.num)) {
			ZEND_VM_TAIL_CALL(ZEND_SEND_VAR_SPEC_VAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS_PASSTHRU));
		}
	}

	varptr = _get_zval_ptr_var(opline->op1.var, execute_data, &free_op1);

	if ((!(opline->extended_value & ZEND_ARG_SEND_FUNCTION) ||
	     (Z_VAR_FLAGS_P(varptr) & IS_VAR_RET_REF)) &&
	    (Z_ISREF_P(varptr) || Z_TYPE_P(varptr) == IS_OBJECT)) {

		ZVAL_MAKE_REF(varptr);
	} else {
		if ((opline->extended_value & ZEND_ARG_COMPILE_TIME_BOUND) ?
			!(opline->extended_value & ZEND_ARG_SEND_SILENT) :
			!ARG_MAY_BE_SENT_BY_REF(EX(call)->func, opline->op2.num)) {
			SAVE_OPLINE();
			zend_error(E_NOTICE, "Only variables should be passed by reference");
			arg = ZEND_CALL_VAR(EX(call), opline->result.var);
			ZVAL_COPY_VALUE(arg, varptr);
			ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
		}
	}

	arg = ZEND_CALL_VAR(EX(call), opline->result.var);
	ZVAL_COPY_VALUE(arg, varptr);

	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_SEND_REF_SPEC_VAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *varptr, *arg;

	SAVE_OPLINE();
	varptr = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

	if (IS_VAR == IS_VAR && UNEXPECTED(varptr == NULL)) {
		zend_throw_error(NULL, "Only variables can be passed by reference");
		arg = ZEND_CALL_VAR(EX(call), opline->result.var);
		ZVAL_UNDEF(arg);
		HANDLE_EXCEPTION();
	}

	arg = ZEND_CALL_VAR(EX(call), opline->result.var);
	if (IS_VAR == IS_VAR && UNEXPECTED(varptr == &EG(error_zval))) {
		ZVAL_NEW_REF(arg, &EG(uninitialized_zval));
		ZEND_VM_NEXT_OPCODE();
	}

	if (Z_ISREF_P(varptr)) {
		Z_ADDREF_P(varptr);
		ZVAL_COPY_VALUE(arg, varptr);
	} else {
		ZVAL_NEW_REF(arg, varptr);
		Z_ADDREF_P(arg);
		ZVAL_REF(varptr, Z_REF_P(arg));
	}

	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_SEND_VAR_EX_SPEC_VAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *varptr, *arg;
	zend_free_op free_op1;

	if (EXPECTED(opline->op2.num <= MAX_ARG_FLAG_NUM)) {
		if (QUICK_ARG_SHOULD_BE_SENT_BY_REF(EX(call)->func, opline->op2.num)) {
			goto send_var_by_ref;
		}
	} else if (ARG_SHOULD_BE_SENT_BY_REF(EX(call)->func, opline->op2.num)) {
send_var_by_ref:
		ZEND_VM_TAIL_CALL(ZEND_SEND_REF_SPEC_VAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS_PASSTHRU));
	}

	varptr = _get_zval_ptr_var(opline->op1.var, execute_data, &free_op1);
	if (IS_VAR == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(varptr) == IS_UNDEF)) {
		SAVE_OPLINE();
		GET_OP1_UNDEF_CV(varptr, BP_VAR_R);
		arg = ZEND_CALL_VAR(EX(call), opline->result.var);
		ZVAL_NULL(arg);
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}

	arg = ZEND_CALL_VAR(EX(call), opline->result.var);

	if (IS_VAR == IS_CV) {
		ZVAL_OPT_DEREF(varptr);
		ZVAL_COPY(arg, varptr);
	} else /* if (IS_VAR == IS_VAR) */ {
		if (UNEXPECTED(Z_ISREF_P(varptr))) {
			zend_refcounted *ref = Z_COUNTED_P(varptr);

			varptr = Z_REFVAL_P(varptr);
			ZVAL_COPY_VALUE(arg, varptr);
			if (UNEXPECTED(--GC_REFCOUNT(ref) == 0)) {
				efree_size(ref, sizeof(zend_reference));
			} else if (Z_OPT_REFCOUNTED_P(arg)) {
				Z_ADDREF_P(arg);
			}
		} else {
			ZVAL_COPY_VALUE(arg, varptr);
		}
	}

	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_SEND_USER_SPEC_VAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *arg, *param;
	zend_free_op free_op1;

	SAVE_OPLINE();
	arg = _get_zval_ptr_var(opline->op1.var, execute_data, &free_op1);
	param = ZEND_CALL_VAR(EX(call), opline->result.var);

	if (ARG_SHOULD_BE_SENT_BY_REF(EX(call)->func, opline->op2.num)) {
		if (UNEXPECTED(!Z_ISREF_P(arg))) {

			if (!ARG_MAY_BE_SENT_BY_REF(EX(call)->func, opline->op2.num)) {

				zend_error(E_WARNING, "Parameter %d to %s%s%s() expected to be a reference, value given",
					opline->op2.num,
					EX(call)->func->common.scope ? ZSTR_VAL(EX(call)->func->common.scope->name) : "",
					EX(call)->func->common.scope ? "::" : "",
					ZSTR_VAL(EX(call)->func->common.function_name));

				if (ZEND_CALL_INFO(EX(call)) & ZEND_CALL_CLOSURE) {
					OBJ_RELEASE((zend_object*)EX(call)->func->common.prototype);
				}
				if (Z_OBJ(EX(call)->This)) {
					OBJ_RELEASE(Z_OBJ(EX(call)->This));
				}
				ZVAL_UNDEF(param);
				EX(call)->func = (zend_function*)&zend_pass_function;
				EX(call)->called_scope = NULL;
				Z_OBJ(EX(call)->This) = NULL;

				zval_ptr_dtor_nogc(free_op1);
				ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
			}

			ZVAL_NEW_REF(arg, arg);
		}
		Z_ADDREF_P(arg);
	} else {
		if (Z_ISREF_P(arg) &&
		    !(EX(call)->func->common.fn_flags & ZEND_ACC_CALL_VIA_TRAMPOLINE)) {
			/* don't separate references for __call */
			arg = Z_REFVAL_P(arg);
		}
		if (Z_OPT_REFCOUNTED_P(arg)) {
			Z_ADDREF_P(arg);
		}
	}
	ZVAL_COPY_VALUE(param, arg);

	zval_ptr_dtor_nogc(free_op1);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_NEW_SPEC_VAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval object_zval;
	zend_function *constructor;
	zend_class_entry *ce;

	SAVE_OPLINE();
	if (IS_VAR == IS_CONST) {
		if (EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1))))) {
			ce = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)));
		} else {
			ce = zend_fetch_class_by_name(Z_STR_P(EX_CONSTANT(opline->op1)), EX_CONSTANT(opline->op1) + 1, ZEND_FETCH_CLASS_DEFAULT | ZEND_FETCH_CLASS_EXCEPTION);
			if (UNEXPECTED(ce == NULL)) {
				ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
			}
			CACHE_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)), ce);
		}
	} else {
		ce = Z_CE_P(EX_VAR(opline->op1.var));
	}
	if (UNEXPECTED(object_init_ex(&object_zval, ce) != SUCCESS)) {
		HANDLE_EXCEPTION();
	}
	constructor = Z_OBJ_HT(object_zval)->get_constructor(Z_OBJ(object_zval));

	if (constructor == NULL) {
		if (EXPECTED(RETURN_VALUE_USED(opline))) {
			ZVAL_COPY_VALUE(EX_VAR(opline->result.var), &object_zval);
		} else {
			OBJ_RELEASE(Z_OBJ(object_zval));
		}
		ZEND_VM_JMP(OP_JMP_ADDR(opline, opline->op2));
	} else {
		/* We are not handling overloaded classes right now */
		zend_execute_data *call = zend_vm_stack_push_call_frame(
				ZEND_CALL_FUNCTION | ZEND_CALL_RELEASE_THIS | ZEND_CALL_CTOR |
				(EXPECTED(RETURN_VALUE_USED(opline)) ? 0 : ZEND_CALL_CTOR_RESULT_UNUSED),
			constructor,
			opline->extended_value,
			ce,
			Z_OBJ(object_zval));
		call->prev_execute_data = EX(call);
		EX(call) = call;

		if (EXPECTED(RETURN_VALUE_USED(opline))) {
			ZVAL_COPY(EX_VAR(opline->result.var), &object_zval);
		}

		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_CAST_SPEC_VAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *expr;
	zval *result = EX_VAR(opline->result.var);

	SAVE_OPLINE();
	expr = _get_zval_ptr_var(opline->op1.var, execute_data, &free_op1);

	switch (opline->extended_value) {
		case IS_NULL:
			/* This code is taken from convert_to_null. However, it does not seems very useful,
			 * because a conversion to null always results in the same value. This could only
			 * be relevant if a cast_object handler for IS_NULL has some kind of side-effect. */
#if 0
			if (IS_VAR == IS_VAR || IS_VAR == IS_CV) {
				ZVAL_DEREF(expr);
			}
			if (Z_TYPE_P(expr) == IS_OBJECT && Z_OBJ_HT_P(expr)->cast_object) {
				if (Z_OBJ_HT_P(expr)->cast_object(expr, result, IS_NULL) == SUCCESS) {
					break;
				}
			}
#endif

			ZVAL_NULL(result);
			break;
		case _IS_BOOL:
			ZVAL_BOOL(result, zend_is_true(expr));
			break;
		case IS_LONG:
			ZVAL_LONG(result, zval_get_long(expr));
			break;
		case IS_DOUBLE:
			ZVAL_DOUBLE(result, zval_get_double(expr));
			break;
		case IS_STRING:
			ZVAL_STR(result, zval_get_string(expr));
			break;
		default:
			if (IS_VAR & (IS_VAR|IS_CV)) {
				ZVAL_DEREF(expr);
			}
			/* If value is already of correct type, return it directly */
			if (Z_TYPE_P(expr) == opline->extended_value) {
				ZVAL_COPY_VALUE(result, expr);
				if (IS_VAR == IS_CONST) {
					if (UNEXPECTED(Z_OPT_COPYABLE_P(result))) {
						zval_copy_ctor_func(result);
					}
				} else if (IS_VAR != IS_TMP_VAR) {
					if (Z_OPT_REFCOUNTED_P(expr)) Z_ADDREF_P(expr);
				}

				zval_ptr_dtor_nogc(free_op1);
				ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
			}

			if (opline->extended_value == IS_ARRAY) {
				if (Z_TYPE_P(expr) != IS_OBJECT) {
					ZVAL_NEW_ARR(result);
					zend_hash_init(Z_ARRVAL_P(result), 8, NULL, ZVAL_PTR_DTOR, 0);
					if (Z_TYPE_P(expr) != IS_NULL) {
						expr = zend_hash_index_add_new(Z_ARRVAL_P(result), 0, expr);
						if (IS_VAR == IS_CONST) {
							if (UNEXPECTED(Z_OPT_COPYABLE_P(expr))) {
								zval_copy_ctor_func(expr);
							}
						} else {
							if (Z_OPT_REFCOUNTED_P(expr)) Z_ADDREF_P(expr);
						}
					}
				} else {
					ZVAL_COPY_VALUE(result, expr);
					Z_ADDREF_P(result);
					convert_to_array(result);
				}
			} else {
				if (Z_TYPE_P(expr) != IS_ARRAY) {
					object_init(result);
					if (Z_TYPE_P(expr) != IS_NULL) {
						expr = zend_hash_str_add_new(Z_OBJPROP_P(result), "scalar", sizeof("scalar")-1, expr);
						if (IS_VAR == IS_CONST) {
							if (UNEXPECTED(Z_OPT_COPYABLE_P(expr))) {
								zval_copy_ctor_func(expr);
							}
						} else {
							if (Z_OPT_REFCOUNTED_P(expr)) Z_ADDREF_P(expr);
						}
					}
				} else {
					ZVAL_COPY(result, expr);
					convert_to_object(result);
				}
			}
	}

	zval_ptr_dtor_nogc(free_op1);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FE_RESET_R_SPEC_VAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *array_ptr, *result;
	HashTable *fe_ht;

	SAVE_OPLINE();

	array_ptr = _get_zval_ptr_var_deref(opline->op1.var, execute_data, &free_op1);
	if (EXPECTED(Z_TYPE_P(array_ptr) == IS_ARRAY)) {
		result = EX_VAR(opline->result.var);
		ZVAL_COPY_VALUE(result, array_ptr);
		if (IS_VAR != IS_TMP_VAR && Z_OPT_REFCOUNTED_P(result)) {
			Z_ADDREF_P(array_ptr);
		}
		Z_FE_POS_P(result) = 0;

		zval_ptr_dtor_nogc(free_op1);
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	} else if (IS_VAR != IS_CONST && EXPECTED(Z_TYPE_P(array_ptr) == IS_OBJECT)) {
		if (!Z_OBJCE_P(array_ptr)->get_iterator) {
			HashPosition pos = 0;
			Bucket *p;

			result = EX_VAR(opline->result.var);
			ZVAL_COPY_VALUE(result, array_ptr);
			if (IS_VAR != IS_TMP_VAR) {
				Z_ADDREF_P(array_ptr);
			}
			fe_ht = Z_OBJPROP_P(array_ptr);
			pos = 0;
			p = fe_ht->arData;
			while (1) {
				if (UNEXPECTED(pos >= fe_ht->nNumUsed)) {
					zval_ptr_dtor_nogc(free_op1);
					Z_FE_ITER_P(EX_VAR(opline->result.var)) = (uint32_t)-1;
					ZEND_VM_JMP(OP_JMP_ADDR(opline, opline->op2));
				}
				if ((EXPECTED(Z_TYPE(p->val) != IS_UNDEF) &&
				     (EXPECTED(Z_TYPE(p->val) != IS_INDIRECT) ||
				      EXPECTED(Z_TYPE_P(Z_INDIRECT(p->val)) != IS_UNDEF))) &&
				    (UNEXPECTED(!p->key) ||
				     EXPECTED(zend_check_property_access(Z_OBJ_P(array_ptr), p->key) == SUCCESS))) {
					break;
				}
				pos++;
				p++;
			}
			Z_FE_ITER_P(EX_VAR(opline->result.var)) = zend_hash_iterator_add(fe_ht, pos);

			zval_ptr_dtor_nogc(free_op1);
			ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
		} else {
			zend_class_entry *ce = Z_OBJCE_P(array_ptr);
			zend_object_iterator *iter = ce->get_iterator(ce, array_ptr, 0);
			zend_bool is_empty;

			if (UNEXPECTED(!iter) || UNEXPECTED(EG(exception))) {
				zval_ptr_dtor_nogc(free_op1);
				if (!EG(exception)) {
					zend_throw_exception_ex(NULL, 0, "Object of type %s did not create an Iterator", ZSTR_VAL(ce->name));
				}
				zend_throw_exception_internal(NULL);
				HANDLE_EXCEPTION();
			}

			iter->index = 0;
			if (iter->funcs->rewind) {
				iter->funcs->rewind(iter);
				if (UNEXPECTED(EG(exception) != NULL)) {
					OBJ_RELEASE(&iter->std);
					zval_ptr_dtor_nogc(free_op1);
					HANDLE_EXCEPTION();
				}
			}

			is_empty = iter->funcs->valid(iter) != SUCCESS;

			if (UNEXPECTED(EG(exception) != NULL)) {
				OBJ_RELEASE(&iter->std);
				zval_ptr_dtor_nogc(free_op1);
				HANDLE_EXCEPTION();
			}
			iter->index = -1; /* will be set to 0 before using next handler */

			ZVAL_OBJ(EX_VAR(opline->result.var), &iter->std);
			Z_FE_ITER_P(EX_VAR(opline->result.var)) = (uint32_t)-1;

			zval_ptr_dtor_nogc(free_op1);
			if (is_empty) {
				ZEND_VM_JMP(OP_JMP_ADDR(opline, opline->op2));
			} else {
				ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
			}
		}
	} else {
		zend_error(E_WARNING, "Invalid argument supplied for foreach()");
		ZVAL_UNDEF(EX_VAR(opline->result.var));
		Z_FE_ITER_P(EX_VAR(opline->result.var)) = (uint32_t)-1;
		zval_ptr_dtor_nogc(free_op1);
		ZEND_VM_JMP(OP_JMP_ADDR(opline, opline->op2));
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FE_RESET_RW_SPEC_VAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *array_ptr, *array_ref;
	HashTable *fe_ht;
	HashPosition pos = 0;
	Bucket *p;

	SAVE_OPLINE();

	if (IS_VAR == IS_VAR || IS_VAR == IS_CV) {
		array_ref = array_ptr = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);
		if (Z_ISREF_P(array_ref)) {
			array_ptr = Z_REFVAL_P(array_ref);
		}
	} else {
		array_ref = array_ptr = _get_zval_ptr_var(opline->op1.var, execute_data, &free_op1);
	}

	if (EXPECTED(Z_TYPE_P(array_ptr) == IS_ARRAY)) {
		if (IS_VAR == IS_VAR || IS_VAR == IS_CV) {
			if (array_ptr == array_ref) {
				ZVAL_NEW_REF(array_ref, array_ref);
				array_ptr = Z_REFVAL_P(array_ref);
			}
			Z_ADDREF_P(array_ref);
			ZVAL_COPY_VALUE(EX_VAR(opline->result.var), array_ref);
		} else {
			array_ptr = EX_VAR(opline->result.var);
			ZVAL_COPY_VALUE(array_ptr, array_ref);
		}
		if (IS_VAR == IS_CONST) {
			zval_copy_ctor_func(array_ptr);
		} else {
			SEPARATE_ARRAY(array_ptr);
		}
		fe_ht = Z_ARRVAL_P(array_ptr);
		p = fe_ht->arData;
		while (1) {
			if (UNEXPECTED(pos >= fe_ht->nNumUsed)) {
				if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
				Z_FE_ITER_P(EX_VAR(opline->result.var)) = (uint32_t)-1;
				ZEND_VM_JMP(OP_JMP_ADDR(opline, opline->op2));
			}
			if (EXPECTED(Z_TYPE(p->val) != IS_UNDEF) &&
			    (EXPECTED(Z_TYPE(p->val) != IS_INDIRECT) ||
			     EXPECTED(Z_TYPE_P(Z_INDIRECT(p->val)) != IS_UNDEF))) {
				break;
			}
			pos++;
			p++;
		}
		Z_FE_ITER_P(EX_VAR(opline->result.var)) = zend_hash_iterator_add(fe_ht, pos);

		if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	} else if (IS_VAR != IS_CONST && EXPECTED(Z_TYPE_P(array_ptr) == IS_OBJECT)) {
		if (!Z_OBJCE_P(array_ptr)->get_iterator) {
			if (IS_VAR == IS_VAR || IS_VAR == IS_CV) {
				if (array_ptr == array_ref) {
					ZVAL_NEW_REF(array_ref, array_ref);
					array_ptr = Z_REFVAL_P(array_ref);
				}
				Z_ADDREF_P(array_ref);
				ZVAL_COPY_VALUE(EX_VAR(opline->result.var), array_ref);
			} else {
				array_ptr = EX_VAR(opline->result.var);
				ZVAL_COPY_VALUE(array_ptr, array_ref);
			}
			fe_ht = Z_OBJPROP_P(array_ptr);
			p = fe_ht->arData;
			while (1) {
				if (UNEXPECTED(pos >= fe_ht->nNumUsed)) {
					if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
					Z_FE_ITER_P(EX_VAR(opline->result.var)) = (uint32_t)-1;
					ZEND_VM_JMP(OP_JMP_ADDR(opline, opline->op2));
				}
				if ((EXPECTED(Z_TYPE(p->val) != IS_UNDEF) &&
				     (EXPECTED(Z_TYPE(p->val) != IS_INDIRECT) ||
				      EXPECTED(Z_TYPE_P(Z_INDIRECT(p->val)) != IS_UNDEF))) &&
				    (UNEXPECTED(!p->key) ||
				     EXPECTED(zend_check_property_access(Z_OBJ_P(array_ptr), p->key) == SUCCESS))) {
					break;
				}
				pos++;
				p++;
			}
			Z_FE_ITER_P(EX_VAR(opline->result.var)) = zend_hash_iterator_add(fe_ht, pos);

			if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
			ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
		} else {
			zend_class_entry *ce = Z_OBJCE_P(array_ptr);
			zend_object_iterator *iter = ce->get_iterator(ce, array_ptr, 1);
			zend_bool is_empty;

			if (UNEXPECTED(!iter) || UNEXPECTED(EG(exception))) {
				if (IS_VAR == IS_VAR) {
					if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
				} else {
					zval_ptr_dtor_nogc(free_op1);
				}
				if (!EG(exception)) {
					zend_throw_exception_ex(NULL, 0, "Object of type %s did not create an Iterator", ZSTR_VAL(ce->name));
				}
				zend_throw_exception_internal(NULL);
				HANDLE_EXCEPTION();
			}

			iter->index = 0;
			if (iter->funcs->rewind) {
				iter->funcs->rewind(iter);
				if (UNEXPECTED(EG(exception) != NULL)) {
					OBJ_RELEASE(&iter->std);
					if (IS_VAR == IS_VAR) {
						if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
					} else {
						zval_ptr_dtor_nogc(free_op1);
					}
					HANDLE_EXCEPTION();
				}
			}

			is_empty = iter->funcs->valid(iter) != SUCCESS;

			if (UNEXPECTED(EG(exception) != NULL)) {
				OBJ_RELEASE(&iter->std);
				if (IS_VAR == IS_VAR) {
					if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
				} else {
					zval_ptr_dtor_nogc(free_op1);
				}
				HANDLE_EXCEPTION();
			}
			iter->index = -1; /* will be set to 0 before using next handler */

			ZVAL_OBJ(EX_VAR(opline->result.var), &iter->std);
			Z_FE_ITER_P(EX_VAR(opline->result.var)) = (uint32_t)-1;

			if (IS_VAR == IS_VAR) {
				if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
			} else {
				zval_ptr_dtor_nogc(free_op1);
			}
			if (is_empty) {
				ZEND_VM_JMP(OP_JMP_ADDR(opline, opline->op2));
			} else {
				ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
			}
		}
	} else {
		zend_error(E_WARNING, "Invalid argument supplied for foreach()");
		ZVAL_UNDEF(EX_VAR(opline->result.var));
		Z_FE_ITER_P(EX_VAR(opline->result.var)) = (uint32_t)-1;
		if (IS_VAR == IS_VAR) {
			if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
		} else {
			zval_ptr_dtor_nogc(free_op1);
		}
		ZEND_VM_JMP(OP_JMP_ADDR(opline, opline->op2));
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FE_FETCH_R_SPEC_VAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *array;
	zval *value;
	uint32_t value_type;
	HashTable *fe_ht;
	HashPosition pos;
	Bucket *p;

	array = EX_VAR(opline->op1.var);
	SAVE_OPLINE();
	if (EXPECTED(Z_TYPE_P(array) == IS_ARRAY)) {
		fe_ht = Z_ARRVAL_P(array);
		pos = Z_FE_POS_P(array);
		p = fe_ht->arData + pos;
		while (1) {
			if (UNEXPECTED(pos >= fe_ht->nNumUsed)) {
				/* reached end of iteration */
				goto fe_fetch_r_exit;
			}
			value = &p->val;
			value_type = Z_TYPE_INFO_P(value);
			if (value_type == IS_UNDEF) {
				pos++;
				p++;
				continue;
			} else if (UNEXPECTED(value_type == IS_INDIRECT)) {
				value = Z_INDIRECT_P(value);
				value_type = Z_TYPE_INFO_P(value);
				if (UNEXPECTED(value_type == IS_UNDEF)) {
					pos++;
					p++;
					continue;
				}
			}
			break;
		}
		Z_FE_POS_P(array) = pos + 1;
		if (opline->result_type == IS_TMP_VAR) {
			if (!p->key) {
				ZVAL_LONG(EX_VAR(opline->result.var), p->h);
			} else {
				ZVAL_STR_COPY(EX_VAR(opline->result.var), p->key);
			}
		}
	} else if (EXPECTED(Z_TYPE_P(array) == IS_OBJECT)) {
		zend_object_iterator *iter;

		if ((iter = zend_iterator_unwrap(array)) == NULL) {
			/* plain object */

 			fe_ht = Z_OBJPROP_P(array);
			pos = zend_hash_iterator_pos(Z_FE_ITER_P(array), fe_ht);
			p = fe_ht->arData + pos;
			while (1) {
				if (UNEXPECTED(pos >= fe_ht->nNumUsed)) {
					/* reached end of iteration */
					goto fe_fetch_r_exit;
				}

				value = &p->val;
				value_type = Z_TYPE_INFO_P(value);
				if (UNEXPECTED(value_type == IS_UNDEF)) {
					pos++;
					p++;
					continue;
				} else if (UNEXPECTED(value_type == IS_INDIRECT)) {
					value = Z_INDIRECT_P(value);
					value_type = Z_TYPE_INFO_P(value);
					if (UNEXPECTED(value_type == IS_UNDEF)) {
						pos++;
						p++;
						continue;
					}
				}
				if (UNEXPECTED(!p->key) ||
				    EXPECTED(zend_check_property_access(Z_OBJ_P(array), p->key) == SUCCESS)) {
					break;
				}
				pos++;
				p++;
			}
			if (opline->result_type == IS_TMP_VAR) {
				if (UNEXPECTED(!p->key)) {
					ZVAL_LONG(EX_VAR(opline->result.var), p->h);
				} else if (ZSTR_VAL(p->key)[0]) {
					ZVAL_STR_COPY(EX_VAR(opline->result.var), p->key);
				} else {
					const char *class_name, *prop_name;
					size_t prop_name_len;
					zend_unmangle_property_name_ex(
						p->key, &class_name, &prop_name, &prop_name_len);
					ZVAL_STRINGL(EX_VAR(opline->result.var), prop_name, prop_name_len);
				}
			}
			while (1) {
				pos++;
				if (pos >= fe_ht->nNumUsed) {
					pos = HT_INVALID_IDX;
					break;
				}
				p++;
				if ((EXPECTED(Z_TYPE(p->val) != IS_UNDEF) &&
				     (EXPECTED(Z_TYPE(p->val) != IS_INDIRECT) ||
				      EXPECTED(Z_TYPE_P(Z_INDIRECT(p->val)) != IS_UNDEF))) &&
				    (UNEXPECTED(!p->key) ||
				     EXPECTED(zend_check_property_access(Z_OBJ_P(array), p->key) == SUCCESS))) {
					break;
				}
			}
			EG(ht_iterators)[Z_FE_ITER_P(array)].pos = pos;
		} else {
			if (EXPECTED(++iter->index > 0)) {
				/* This could cause an endless loop if index becomes zero again.
				 * In case that ever happens we need an additional flag. */
				iter->funcs->move_forward(iter);
				if (UNEXPECTED(EG(exception) != NULL)) {
					zval_ptr_dtor(array);
					HANDLE_EXCEPTION();
				}
				if (UNEXPECTED(iter->funcs->valid(iter) == FAILURE)) {
					/* reached end of iteration */
					if (UNEXPECTED(EG(exception) != NULL)) {
						zval_ptr_dtor(array);
						HANDLE_EXCEPTION();
					}
					goto fe_fetch_r_exit;
				}
			}
			value = iter->funcs->get_current_data(iter);
			if (UNEXPECTED(EG(exception) != NULL)) {
				zval_ptr_dtor(array);
				HANDLE_EXCEPTION();
			}
			if (!value) {
				/* failure in get_current_data */
				goto fe_fetch_r_exit;
			}
			if (opline->result_type == IS_TMP_VAR) {
				if (iter->funcs->get_current_key) {
					iter->funcs->get_current_key(iter, EX_VAR(opline->result.var));
					if (UNEXPECTED(EG(exception) != NULL)) {
						zval_ptr_dtor(array);
						HANDLE_EXCEPTION();
					}
				} else {
					ZVAL_LONG(EX_VAR(opline->result.var), iter->index);
				}
			}
			value_type = Z_TYPE_INFO_P(value);
		}
	} else {
		zend_error(E_WARNING, "Invalid argument supplied for foreach()");
fe_fetch_r_exit:
		if (EXPECTED(!EG(exception))) {
			ZEND_VM_SET_RELATIVE_OPCODE(opline, opline->extended_value);
		}
		ZEND_VM_CONTINUE();
	}

	if (EXPECTED(opline->op2_type == IS_CV)) {
		zval *variable_ptr = _get_zval_ptr_cv_undef_BP_VAR_W(execute_data, opline->op2.var);
		zend_assign_to_variable(variable_ptr, value, IS_CV);
	} else {
		zval *res = EX_VAR(opline->op2.var);
		zend_refcounted *gc = Z_COUNTED_P(value);

		ZVAL_COPY_VALUE_EX(res, value, gc, value_type);
		if (EXPECTED((value_type & (IS_TYPE_REFCOUNTED << Z_TYPE_FLAGS_SHIFT)) != 0)) {
			GC_REFCOUNT(gc)++;
		}
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FE_FETCH_RW_SPEC_VAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *array;
	zval *value;
	uint32_t value_type;
	HashTable *fe_ht;
	HashPosition pos;
	Bucket *p;

	array = EX_VAR(opline->op1.var);
	SAVE_OPLINE();

	ZVAL_DEREF(array);
	if (EXPECTED(Z_TYPE_P(array) == IS_ARRAY)) {
		fe_ht = Z_ARRVAL_P(array);
		pos = zend_hash_iterator_pos(Z_FE_ITER_P(EX_VAR(opline->op1.var)), fe_ht);
		p = fe_ht->arData + pos;
		while (1) {
			if (UNEXPECTED(pos >= fe_ht->nNumUsed)) {
				/* reached end of iteration */
				goto fe_fetch_w_exit;
			}
			value = &p->val;
			value_type = Z_TYPE_INFO_P(value);
			if (UNEXPECTED(value_type == IS_UNDEF)) {
				pos++;
				p++;
				continue;
			} else if (UNEXPECTED(value_type == IS_INDIRECT)) {
				value = Z_INDIRECT_P(value);
				value_type = Z_TYPE_INFO_P(value);
				if (UNEXPECTED(value_type == IS_UNDEF)) {
					pos++;
					p++;
					continue;
				}
			}
			break;
		}
		if (opline->result_type == IS_TMP_VAR) {
			if (!p->key) {
				ZVAL_LONG(EX_VAR(opline->result.var), p->h);
			} else {
				ZVAL_STR_COPY(EX_VAR(opline->result.var), p->key);
			}
		}
		while (1) {
			pos++;
			if (pos >= fe_ht->nNumUsed) {
				pos = HT_INVALID_IDX;
				break;
			}
			p++;
			if (EXPECTED(Z_TYPE(p->val) != IS_UNDEF) &&
			    (EXPECTED(Z_TYPE(p->val) != IS_INDIRECT) ||
			     EXPECTED(Z_TYPE_P(Z_INDIRECT(p->val)) != IS_UNDEF))) {
				break;
			}
		}
		EG(ht_iterators)[Z_FE_ITER_P(EX_VAR(opline->op1.var))].pos = pos;
	} else if (EXPECTED(Z_TYPE_P(array) == IS_OBJECT)) {
		zend_object_iterator *iter;

		if ((iter = zend_iterator_unwrap(array)) == NULL) {
			/* plain object */

 			fe_ht = Z_OBJPROP_P(array);
			pos = zend_hash_iterator_pos(Z_FE_ITER_P(EX_VAR(opline->op1.var)), fe_ht);
			p = fe_ht->arData + pos;
			while (1) {
				if (UNEXPECTED(pos >= fe_ht->nNumUsed)) {
					/* reached end of iteration */
					goto fe_fetch_w_exit;
				}

				value = &p->val;
				value_type = Z_TYPE_INFO_P(value);
				if (UNEXPECTED(value_type == IS_UNDEF)) {
					pos++;
					p++;
					continue;
				} else if (UNEXPECTED(value_type == IS_INDIRECT)) {
					value = Z_INDIRECT_P(value);
					value_type = Z_TYPE_INFO_P(value);
					if (UNEXPECTED(value_type == IS_UNDEF)) {
						pos++;
						p++;
						continue;
					}
				}
				if (UNEXPECTED(!p->key) ||
				    EXPECTED(zend_check_property_access(Z_OBJ_P(array), p->key) == SUCCESS)) {
					break;
				}
				pos++;
				p++;
			}
			if (opline->result_type == IS_TMP_VAR) {
				if (UNEXPECTED(!p->key)) {
					ZVAL_LONG(EX_VAR(opline->result.var), p->h);
				} else if (ZSTR_VAL(p->key)[0]) {
					ZVAL_STR_COPY(EX_VAR(opline->result.var), p->key);
				} else {
					const char *class_name, *prop_name;
					size_t prop_name_len;
					zend_unmangle_property_name_ex(
						p->key, &class_name, &prop_name, &prop_name_len);
					ZVAL_STRINGL(EX_VAR(opline->result.var), prop_name, prop_name_len);
				}
			}
			while (1) {
				pos++;
				if (pos >= fe_ht->nNumUsed) {
					pos = HT_INVALID_IDX;
					break;
				}
				p++;
				if ((EXPECTED(Z_TYPE(p->val) != IS_UNDEF) &&
				     (EXPECTED(Z_TYPE(p->val) != IS_INDIRECT) ||
				      EXPECTED(Z_TYPE_P(Z_INDIRECT(p->val)) != IS_UNDEF))) &&
				    (UNEXPECTED(!p->key) ||
				     EXPECTED(zend_check_property_access(Z_OBJ_P(array), p->key) == SUCCESS))) {
					break;
				}
			}
			EG(ht_iterators)[Z_FE_ITER_P(EX_VAR(opline->op1.var))].pos = pos;
		} else {
			if (++iter->index > 0) {
				/* This could cause an endless loop if index becomes zero again.
				 * In case that ever happens we need an additional flag. */
				iter->funcs->move_forward(iter);
				if (UNEXPECTED(EG(exception) != NULL)) {
					zval_ptr_dtor(array);
					HANDLE_EXCEPTION();
				}
				if (UNEXPECTED(iter->funcs->valid(iter) == FAILURE)) {
					/* reached end of iteration */
					if (UNEXPECTED(EG(exception) != NULL)) {
						zval_ptr_dtor(array);
						HANDLE_EXCEPTION();
					}
					goto fe_fetch_w_exit;
				}
			}
			value = iter->funcs->get_current_data(iter);
			if (UNEXPECTED(EG(exception) != NULL)) {
				zval_ptr_dtor(array);
				HANDLE_EXCEPTION();
			}
			if (!value) {
				/* failure in get_current_data */
				goto fe_fetch_w_exit;
			}
			if (opline->result_type == IS_TMP_VAR) {
				if (iter->funcs->get_current_key) {
					iter->funcs->get_current_key(iter, EX_VAR(opline->result.var));
					if (UNEXPECTED(EG(exception) != NULL)) {
						zval_ptr_dtor(array);
						HANDLE_EXCEPTION();
					}
				} else {
					ZVAL_LONG(EX_VAR(opline->result.var), iter->index);
				}
			}
			value_type = Z_TYPE_INFO_P(value);
		}
	} else {
		zend_error(E_WARNING, "Invalid argument supplied for foreach()");
fe_fetch_w_exit:
		if (EXPECTED(!EG(exception))) {
			ZEND_VM_SET_RELATIVE_OPCODE(opline, opline->extended_value);
		}
		ZEND_VM_CONTINUE();
	}

	if (EXPECTED((value_type & Z_TYPE_MASK) != IS_REFERENCE)) {
		zend_refcounted *gc = Z_COUNTED_P(value);
		zval *ref;
		ZVAL_NEW_EMPTY_REF(value);
		ref = Z_REFVAL_P(value);
		ZVAL_COPY_VALUE_EX(ref, value, gc, value_type);
	}
	if (EXPECTED(opline->op2_type == IS_CV)) {
		zval *variable_ptr = _get_zval_ptr_cv_undef_BP_VAR_W(execute_data, opline->op2.var);
		if (EXPECTED(variable_ptr != value)) {
			zend_reference *ref;

			ref = Z_REF_P(value);
			GC_REFCOUNT(ref)++;
			zval_ptr_dtor(variable_ptr);
			ZVAL_REF(variable_ptr, ref);
		}
	} else {
		Z_ADDREF_P(value);
		ZVAL_REF(EX_VAR(opline->op2.var), Z_REF_P(value));
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_JMP_SET_SPEC_VAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *value;
	zval *ref = NULL;

	SAVE_OPLINE();
	value = _get_zval_ptr_var(opline->op1.var, execute_data, &free_op1);

	if ((IS_VAR == IS_VAR || IS_VAR == IS_CV) && Z_ISREF_P(value)) {
		if (IS_VAR == IS_VAR) {
			ref = value;
		}
		value = Z_REFVAL_P(value);
	}
	if (i_zend_is_true(value)) {
		ZVAL_COPY_VALUE(EX_VAR(opline->result.var), value);
		if (IS_VAR == IS_CONST) {
			if (UNEXPECTED(Z_OPT_COPYABLE_P(value))) {
				zval_copy_ctor_func(EX_VAR(opline->result.var));
			}
		} else if (IS_VAR == IS_CV) {
			if (Z_OPT_REFCOUNTED_P(value)) Z_ADDREF_P(value);
		} else if (IS_VAR == IS_VAR && ref) {
			zend_reference *r = Z_REF_P(ref);

			if (Z_OPT_REFCOUNTED_P(value)) Z_ADDREF_P(value);
			if (UNEXPECTED(--GC_REFCOUNT(r) == 0)) {
				efree_size(r, sizeof(zend_reference));
			}
		}
		ZEND_VM_JMP(OP_JMP_ADDR(opline, opline->op2));
	}

	zval_ptr_dtor_nogc(free_op1);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_COALESCE_SPEC_VAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *value;
	zval *ref = NULL;

	SAVE_OPLINE();
	value = _get_zval_ptr_var(opline->op1.var, execute_data, &free_op1);

	if ((IS_VAR == IS_VAR || IS_VAR == IS_CV) && Z_ISREF_P(value)) {
		if (IS_VAR == IS_VAR) {
			ref = value;
		}
		value = Z_REFVAL_P(value);
	}

	if (Z_TYPE_P(value) > IS_NULL) {
		ZVAL_COPY_VALUE(EX_VAR(opline->result.var), value);
		if (IS_VAR == IS_CONST) {
			if (UNEXPECTED(Z_OPT_COPYABLE_P(value))) {
				zval_copy_ctor_func(EX_VAR(opline->result.var));
			}
		} else if (IS_VAR == IS_CV) {
			if (Z_OPT_REFCOUNTED_P(value)) Z_ADDREF_P(value);
		} else if (IS_VAR == IS_VAR && ref) {
			zend_reference *r = Z_REF_P(ref);

			if (Z_OPT_REFCOUNTED_P(value)) Z_ADDREF_P(value);
			if (UNEXPECTED(--GC_REFCOUNT(r) == 0)) {
				efree_size(r, sizeof(zend_reference));
			}
		}
		ZEND_VM_JMP(OP_JMP_ADDR(opline, opline->op2));
	}

	zval_ptr_dtor_nogc(free_op1);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_QM_ASSIGN_SPEC_VAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *value;

	value = _get_zval_ptr_var(opline->op1.var, execute_data, &free_op1);
	if (IS_VAR == IS_CV && UNEXPECTED(Z_TYPE_P(value) == IS_UNDEF)) {
		SAVE_OPLINE();
		GET_OP1_UNDEF_CV(value, BP_VAR_R);
		ZVAL_NULL(EX_VAR(opline->result.var));
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}

	if ((IS_VAR == IS_VAR || IS_VAR == IS_CV) && Z_ISREF_P(value)) {
		ZVAL_COPY(EX_VAR(opline->result.var), Z_REFVAL_P(value));
		if (IS_VAR == IS_VAR) {
			if (UNEXPECTED(Z_DELREF_P(value) == 0)) {
				efree_size(Z_REF_P(value), sizeof(zend_reference));
			}
		}
	} else {
		ZVAL_COPY_VALUE(EX_VAR(opline->result.var), value);
		if (IS_VAR == IS_CONST) {
			if (UNEXPECTED(Z_OPT_COPYABLE_P(value))) {
				zval_copy_ctor_func(EX_VAR(opline->result.var));
			}
		} else if (IS_VAR == IS_CV) {
			if (Z_OPT_REFCOUNTED_P(value)) Z_ADDREF_P(value);
		}
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_YIELD_FROM_SPEC_VAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zend_generator *generator = zend_get_running_generator(execute_data);

	zval *val;
	zend_free_op free_op1;

	SAVE_OPLINE();
	val = _get_zval_ptr_var_deref(opline->op1.var, execute_data, &free_op1);

	if (Z_TYPE_P(val) == IS_ARRAY) {
		ZVAL_COPY_VALUE(&generator->values, val);
		if (IS_VAR != IS_TMP_VAR && Z_OPT_REFCOUNTED_P(val)) {
			Z_ADDREF_P(val);
		}
		Z_FE_POS(generator->values) = 0;

		zval_ptr_dtor_nogc(free_op1);
	} else if (IS_VAR != IS_CONST && Z_TYPE_P(val) == IS_OBJECT && Z_OBJCE_P(val)->get_iterator) {
		zend_class_entry *ce = Z_OBJCE_P(val);
		if (ce == zend_ce_generator) {
			zend_generator *new_gen = (zend_generator *) Z_OBJ_P(val);

			if (IS_VAR != IS_TMP_VAR) {
				Z_ADDREF_P(val);
			}
			zval_ptr_dtor_nogc(free_op1);

			if (Z_ISUNDEF(new_gen->retval)) {
				if (UNEXPECTED(zend_generator_get_current(new_gen) == generator)) {
					zend_throw_error(NULL, "Impossible to yield from the Generator being currently run");
					HANDLE_EXCEPTION();
				} else {
					zend_generator_yield_from(generator, new_gen);
				}
			} else if (UNEXPECTED(new_gen->execute_data == NULL)) {
				zend_throw_error(NULL, "Generator passed to yield from was aborted without proper return and is unable to continue");
				HANDLE_EXCEPTION();
			} else {
				if (RETURN_VALUE_USED(opline)) {
					ZVAL_COPY(EX_VAR(opline->result.var), &new_gen->retval);
				}
				ZEND_VM_NEXT_OPCODE();
			}
		} else {
			zend_object_iterator *iter = ce->get_iterator(ce, val, 0);
			zval_ptr_dtor_nogc(free_op1);

			if (UNEXPECTED(!iter) || UNEXPECTED(EG(exception))) {
				if (!EG(exception)) {
					zend_throw_error(NULL, "Object of type %s did not create an Iterator", ZSTR_VAL(ce->name));
				}
				HANDLE_EXCEPTION();
			}

			iter->index = 0;
			if (iter->funcs->rewind) {
				iter->funcs->rewind(iter);
				if (UNEXPECTED(EG(exception) != NULL)) {
					OBJ_RELEASE(&iter->std);
					HANDLE_EXCEPTION();
				}
			}

			ZVAL_OBJ(&generator->values, &iter->std);
		}
	} else {
		zend_throw_error(NULL, "Can use \"yield from\" only with arrays and Traversables", 0);
		HANDLE_EXCEPTION();
	}

	/* This is the default return value
	 * when the expression is a Generator, it will be overwritten in zend_generator_resume() */
	if (RETURN_VALUE_USED(opline)) {
		ZVAL_NULL(EX_VAR(opline->result.var));
	}

	/* We increment to the next op, so we are at the correct position when the
	 * generator is resumed. */
	ZEND_VM_INC_OPCODE();

	/* The GOTO VM uses a local opline variable. We need to set the opline
	 * variable in execute_data so we don't resume at an old position. */
	SAVE_OPLINE();

	ZEND_VM_RETURN();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_TYPE_CHECK_SPEC_VAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *value;
	int result = 0;
	zend_free_op free_op1;

	SAVE_OPLINE();
	value = _get_zval_ptr_var_deref(opline->op1.var, execute_data, &free_op1);
	if (EXPECTED(Z_TYPE_P(value) == opline->extended_value)) {
		if (IS_VAR != IS_CONST && UNEXPECTED(Z_TYPE_P(value) == IS_OBJECT)) {
			zend_class_entry *ce = Z_OBJCE_P(value);

			if (UNEXPECTED(ZSTR_LEN(ce->name) != sizeof("__PHP_Incomplete_Class") - 1) ||
			    EXPECTED(memcmp(ZSTR_VAL(ce->name), "__PHP_Incomplete_Class", sizeof("__PHP_Incomplete_Class") - 1) != 0)) {
				result = 1;
			}
		} else if (UNEXPECTED(Z_TYPE_P(value) == IS_RESOURCE)) {
			const char *type_name = zend_rsrc_list_get_rsrc_type(Z_RES_P(value));

			if (EXPECTED(type_name != NULL)) {
				result = 1;
			}
		} else {
			result = 1;
		}
	} else if (UNEXPECTED(opline->extended_value == _IS_BOOL) &&
			   EXPECTED(Z_TYPE_P(value) == IS_TRUE || Z_TYPE_P(value) == IS_FALSE)) {
		result = 1;
	}
	zval_ptr_dtor_nogc(free_op1);
	ZEND_VM_SMART_BRANCH(result, 1);
	ZVAL_BOOL(EX_VAR(opline->result.var), result);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_IS_IDENTICAL_SPEC_VAR_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *op1, *op2;
	int result;

	SAVE_OPLINE();
	op1 = _get_zval_ptr_var_deref(opline->op1.var, execute_data, &free_op1);
	op2 = EX_CONSTANT(opline->op2);
	result = fast_is_identical_function(op1, op2);
	zval_ptr_dtor_nogc(free_op1);

	ZEND_VM_SMART_BRANCH(result, (IS_VAR|IS_CONST) & (IS_VAR|IS_TMP_VAR));
	ZVAL_BOOL(EX_VAR(opline->result.var), result);
	if ((IS_VAR|IS_CONST) & (IS_VAR|IS_TMP_VAR)) {
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_IS_NOT_IDENTICAL_SPEC_VAR_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *op1, *op2;
	int result;

	SAVE_OPLINE();
	op1 = _get_zval_ptr_var_deref(opline->op1.var, execute_data, &free_op1);
	op2 = EX_CONSTANT(opline->op2);
	result = fast_is_not_identical_function(op1, op2);
	zval_ptr_dtor_nogc(free_op1);

	ZEND_VM_SMART_BRANCH(result, (IS_VAR|IS_CONST) & (IS_VAR|IS_TMP_VAR));
	ZVAL_BOOL(EX_VAR(opline->result.var), result);
	if ((IS_VAR|IS_CONST) & (IS_VAR|IS_TMP_VAR)) {
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL zend_binary_assign_op_obj_helper_SPEC_VAR_CONST(binary_op_type binary_op ZEND_OPCODE_HANDLER_ARGS_DC)
{
	USE_OPLINE
	zend_free_op free_op1, free_op_data1;
	zval *object;
	zval *property;
	zval *value;
	zval *zptr;

	SAVE_OPLINE();
	object = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

	if (IS_VAR == IS_UNUSED && UNEXPECTED(Z_OBJ_P(object) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");
		FREE_UNFETCHED_OP((opline+1)->op1_type, (opline+1)->op1.var);

		HANDLE_EXCEPTION();
	}

	property = EX_CONSTANT(opline->op2);

	if (IS_VAR == IS_VAR && UNEXPECTED(object == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an object");
		FREE_UNFETCHED_OP((opline+1)->op1_type, (opline+1)->op1.var);

		HANDLE_EXCEPTION();
	}

	do {
		value = get_zval_ptr((opline+1)->op1_type, (opline+1)->op1, execute_data, &free_op_data1, BP_VAR_R);

		if (IS_VAR != IS_UNUSED && UNEXPECTED(Z_TYPE_P(object) != IS_OBJECT)) {
			ZVAL_DEREF(object);
			if (UNEXPECTED(!make_real_object(object))) {
				zend_error(E_WARNING, "Attempt to assign property of non-object");
				if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
					ZVAL_NULL(EX_VAR(opline->result.var));
				}
				break;
			}
		}

		/* here we are sure we are dealing with an object */
		if (EXPECTED(Z_OBJ_HT_P(object)->get_property_ptr_ptr)
			&& EXPECTED((zptr = Z_OBJ_HT_P(object)->get_property_ptr_ptr(object, property, BP_VAR_RW, ((IS_CONST == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL))) != NULL)) {

			ZVAL_DEREF(zptr);
			SEPARATE_ZVAL_NOREF(zptr);

			binary_op(zptr, zptr, value);
			if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
				ZVAL_COPY(EX_VAR(opline->result.var), zptr);
			}
		} else {
			zend_assign_op_overloaded_property(object, property, ((IS_CONST == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), value, binary_op, (UNEXPECTED(RETURN_VALUE_USED(opline)) ? EX_VAR(opline->result.var) : NULL));
		}
	} while (0);

	FREE_OP(free_op_data1);

	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	/* assign_obj has two opcodes! */
	ZEND_VM_NEXT_OPCODE_EX(1, 2);
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL zend_binary_assign_op_dim_helper_SPEC_VAR_CONST(binary_op_type binary_op ZEND_OPCODE_HANDLER_ARGS_DC)
{
	USE_OPLINE
	zend_free_op free_op1, free_op_data1;
	zval *var_ptr, rv;
	zval *value, *container, *dim;

	SAVE_OPLINE();
	container = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);
	if (IS_VAR == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");
		FREE_UNFETCHED_OP((opline+1)->op1_type, (opline+1)->op1.var);

		HANDLE_EXCEPTION();
	}
	if (IS_VAR == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an array");
		FREE_UNFETCHED_OP((opline+1)->op1_type, (opline+1)->op1.var);

		HANDLE_EXCEPTION();
	}

	dim = EX_CONSTANT(opline->op2);

	do {
		if (IS_VAR == IS_UNUSED || UNEXPECTED(Z_TYPE_P(container) != IS_ARRAY)) {
			if (IS_VAR != IS_UNUSED) {
				ZVAL_DEREF(container);
			}
			if (IS_VAR == IS_UNUSED || EXPECTED(Z_TYPE_P(container) == IS_OBJECT)) {
				value = get_zval_ptr((opline+1)->op1_type, (opline+1)->op1, execute_data, &free_op_data1, BP_VAR_R);
				zend_binary_assign_op_obj_dim(container, dim, value, UNEXPECTED(RETURN_VALUE_USED(opline)) ? EX_VAR(opline->result.var) : NULL, binary_op);
				break;
			}
		}

		zend_fetch_dimension_address_RW(&rv, container, dim, IS_CONST);
		value = get_zval_ptr((opline+1)->op1_type, (opline+1)->op1, execute_data, &free_op_data1, BP_VAR_R);
		ZEND_ASSERT(Z_TYPE(rv) == IS_INDIRECT);
		var_ptr = Z_INDIRECT(rv);

		if (UNEXPECTED(var_ptr == NULL)) {
			zend_throw_error(NULL, "Cannot use assign-op operators with overloaded objects nor string offsets");

			FREE_OP(free_op_data1);
			if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
			HANDLE_EXCEPTION();
		}

		if (UNEXPECTED(var_ptr == &EG(error_zval))) {
			if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
				ZVAL_NULL(EX_VAR(opline->result.var));
			}
		} else {
			ZVAL_DEREF(var_ptr);
			SEPARATE_ZVAL_NOREF(var_ptr);

			binary_op(var_ptr, var_ptr, value);

			if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
				ZVAL_COPY(EX_VAR(opline->result.var), var_ptr);
			}
		}
	} while (0);

	FREE_OP(free_op_data1);
	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	ZEND_VM_NEXT_OPCODE_EX(1, 2);
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL zend_binary_assign_op_helper_SPEC_VAR_CONST(binary_op_type binary_op ZEND_OPCODE_HANDLER_ARGS_DC)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *var_ptr;
	zval *value;

	SAVE_OPLINE();
	value = EX_CONSTANT(opline->op2);
	var_ptr = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

	if (IS_VAR == IS_VAR && UNEXPECTED(var_ptr == NULL)) {
		zend_throw_error(NULL, "Cannot use assign-op operators with overloaded objects nor string offsets");

		HANDLE_EXCEPTION();
	}

	if (IS_VAR == IS_VAR && UNEXPECTED(var_ptr == &EG(error_zval))) {
		if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
			ZVAL_NULL(EX_VAR(opline->result.var));
		}
	} else {
		ZVAL_DEREF(var_ptr);
		SEPARATE_ZVAL_NOREF(var_ptr);

		binary_op(var_ptr, var_ptr, value);

		if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
			ZVAL_COPY(EX_VAR(opline->result.var), var_ptr);
		}
	}

	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_ADD_SPEC_VAR_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CONST != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_VAR != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_VAR_CONST(add_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_CONST(add_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_VAR_CONST(add_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_CONST(add_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_SUB_SPEC_VAR_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CONST != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_VAR != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_VAR_CONST(sub_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_CONST(sub_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_VAR_CONST(sub_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_CONST(sub_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_MUL_SPEC_VAR_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CONST != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_VAR != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_VAR_CONST(mul_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_CONST(mul_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_VAR_CONST(mul_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_CONST(mul_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_DIV_SPEC_VAR_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CONST != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_VAR != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_VAR_CONST(div_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_CONST(div_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_VAR_CONST(div_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_CONST(div_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_MOD_SPEC_VAR_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CONST != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_VAR != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_VAR_CONST(mod_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_CONST(mod_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_VAR_CONST(mod_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_CONST(mod_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_SL_SPEC_VAR_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CONST != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_VAR != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_VAR_CONST(shift_left_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_CONST(shift_left_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_VAR_CONST(shift_left_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_CONST(shift_left_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_SR_SPEC_VAR_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CONST != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_VAR != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_VAR_CONST(shift_right_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_CONST(shift_right_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_VAR_CONST(shift_right_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_CONST(shift_right_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_CONCAT_SPEC_VAR_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CONST != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_VAR != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_VAR_CONST(concat_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_CONST(concat_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_VAR_CONST(concat_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_CONST(concat_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_BW_OR_SPEC_VAR_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CONST != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_VAR != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_VAR_CONST(bitwise_or_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_CONST(bitwise_or_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_VAR_CONST(bitwise_or_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_CONST(bitwise_or_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_BW_AND_SPEC_VAR_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CONST != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_VAR != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_VAR_CONST(bitwise_and_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_CONST(bitwise_and_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_VAR_CONST(bitwise_and_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_CONST(bitwise_and_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_BW_XOR_SPEC_VAR_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CONST != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_VAR != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_VAR_CONST(bitwise_xor_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_CONST(bitwise_xor_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_VAR_CONST(bitwise_xor_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_CONST(bitwise_xor_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL zend_pre_incdec_property_helper_SPEC_VAR_CONST(int inc ZEND_OPCODE_HANDLER_ARGS_DC)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *object;
	zval *property;
	zval *zptr;

	SAVE_OPLINE();
	object = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

	if (IS_VAR == IS_UNUSED && UNEXPECTED(Z_OBJ_P(object) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}

	property = EX_CONSTANT(opline->op2);

	if (IS_VAR == IS_VAR && UNEXPECTED(object == NULL)) {
		zend_throw_error(NULL, "Cannot increment/decrement overloaded objects nor string offsets");

		HANDLE_EXCEPTION();
	}

	do {
		if (IS_VAR != IS_UNUSED && UNEXPECTED(Z_TYPE_P(object) != IS_OBJECT)) {
			ZVAL_DEREF(object);
			if (UNEXPECTED(!make_real_object(object))) {
				zend_error(E_WARNING, "Attempt to increment/decrement property of non-object");
				if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
					ZVAL_NULL(EX_VAR(opline->result.var));
				}
				break;
			}
		}

		/* here we are sure we are dealing with an object */

		if (EXPECTED(Z_OBJ_HT_P(object)->get_property_ptr_ptr)
			&& EXPECTED((zptr = Z_OBJ_HT_P(object)->get_property_ptr_ptr(object, property, BP_VAR_RW, ((IS_CONST == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL))) != NULL)) {

			if (EXPECTED(Z_TYPE_P(zptr) == IS_LONG)) {
				if (inc) {
					fast_long_increment_function(zptr);
				} else {
					fast_long_decrement_function(zptr);
				}
			} else {
				ZVAL_DEREF(zptr);
				SEPARATE_ZVAL_NOREF(zptr);

				if (inc) {
					increment_function(zptr);
				} else {
					decrement_function(zptr);
				}
			}
			if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
				ZVAL_COPY(EX_VAR(opline->result.var), zptr);
			}
		} else {
			zend_pre_incdec_overloaded_property(object, property, ((IS_CONST == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), inc, (UNEXPECTED(RETURN_VALUE_USED(opline)) ? EX_VAR(opline->result.var) : NULL));
		}
	} while (0);

	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_PRE_INC_OBJ_SPEC_VAR_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	ZEND_VM_TAIL_CALL(zend_pre_incdec_property_helper_SPEC_VAR_CONST(1 ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_PRE_DEC_OBJ_SPEC_VAR_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	ZEND_VM_TAIL_CALL(zend_pre_incdec_property_helper_SPEC_VAR_CONST(0 ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL zend_post_incdec_property_helper_SPEC_VAR_CONST(int inc ZEND_OPCODE_HANDLER_ARGS_DC)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *object;
	zval *property;
	zval *zptr;

	SAVE_OPLINE();
	object = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

	if (IS_VAR == IS_UNUSED && UNEXPECTED(Z_OBJ_P(object) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}

	property = EX_CONSTANT(opline->op2);

	if (IS_VAR == IS_VAR && UNEXPECTED(object == NULL)) {
		zend_throw_error(NULL, "Cannot increment/decrement overloaded objects nor string offsets");

		HANDLE_EXCEPTION();
	}

	do {
		if (IS_VAR != IS_UNUSED && UNEXPECTED(Z_TYPE_P(object) != IS_OBJECT)) {
			ZVAL_DEREF(object);
			if (UNEXPECTED(!make_real_object(object))) {
				zend_error(E_WARNING, "Attempt to increment/decrement property of non-object");
				ZVAL_NULL(EX_VAR(opline->result.var));
				break;
			}
		}

		/* here we are sure we are dealing with an object */

		if (EXPECTED(Z_OBJ_HT_P(object)->get_property_ptr_ptr)
			&& EXPECTED((zptr = Z_OBJ_HT_P(object)->get_property_ptr_ptr(object, property, BP_VAR_RW, ((IS_CONST == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL))) != NULL)) {

			if (EXPECTED(Z_TYPE_P(zptr) == IS_LONG)) {
				ZVAL_COPY_VALUE(EX_VAR(opline->result.var), zptr);
				if (inc) {
					fast_long_increment_function(zptr);
				} else {
					fast_long_decrement_function(zptr);
				}
			} else {
				ZVAL_DEREF(zptr);
				ZVAL_COPY_VALUE(EX_VAR(opline->result.var), zptr);
				zval_opt_copy_ctor(zptr);
				if (inc) {
					increment_function(zptr);
				} else {
					decrement_function(zptr);
				}
			}
		} else {
			zend_post_incdec_overloaded_property(object, property, ((IS_CONST == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), inc, EX_VAR(opline->result.var));
		}
	} while (0);

	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_POST_INC_OBJ_SPEC_VAR_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	ZEND_VM_TAIL_CALL(zend_post_incdec_property_helper_SPEC_VAR_CONST(1 ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_POST_DEC_OBJ_SPEC_VAR_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	ZEND_VM_TAIL_CALL(zend_post_incdec_property_helper_SPEC_VAR_CONST(0 ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_DIM_W_SPEC_VAR_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *container;

	SAVE_OPLINE();
	container = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

	if (IS_VAR == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an array");
		HANDLE_EXCEPTION();
	}
	zend_fetch_dimension_address_W(EX_VAR(opline->result.var), container, EX_CONSTANT(opline->op2), IS_CONST);

	if (IS_VAR == IS_VAR && READY_TO_DESTROY(free_op1)) {
		EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 1);
	}
	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_DIM_RW_SPEC_VAR_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *container;

	SAVE_OPLINE();
	container = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

	if (IS_VAR == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an array");
		HANDLE_EXCEPTION();
	}
	zend_fetch_dimension_address_RW(EX_VAR(opline->result.var), container, EX_CONSTANT(opline->op2), IS_CONST);

	if (IS_VAR == IS_VAR && READY_TO_DESTROY(free_op1)) {
		EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 1);
	}
	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_DIM_FUNC_ARG_SPEC_VAR_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *container;
	zend_free_op free_op1;

	SAVE_OPLINE();

	if (zend_is_by_ref_func_arg_fetch(opline, EX(call))) {
        if (IS_VAR == IS_CONST || IS_VAR == IS_TMP_VAR) {
            zend_throw_error(NULL, "Cannot use temporary expression in write context");

			zval_ptr_dtor_nogc(EX_VAR(opline->op1.var));
			HANDLE_EXCEPTION();
        }
		container = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);
		if (IS_VAR == IS_VAR && UNEXPECTED(container == NULL)) {
			zend_throw_error(NULL, "Cannot use string offset as an array");

			HANDLE_EXCEPTION();
		}
		zend_fetch_dimension_address_W(EX_VAR(opline->result.var), container, EX_CONSTANT(opline->op2), IS_CONST);
		if (IS_VAR == IS_VAR && READY_TO_DESTROY(free_op1)) {
			EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 1);
		}

		if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	} else {
		if (IS_CONST == IS_UNUSED) {
			zend_throw_error(NULL, "Cannot use [] for reading");

			zval_ptr_dtor_nogc(EX_VAR(opline->op1.var));
			HANDLE_EXCEPTION();
		}
		container = _get_zval_ptr_var(opline->op1.var, execute_data, &free_op1);
		zend_fetch_dimension_address_read_R(EX_VAR(opline->result.var), container, EX_CONSTANT(opline->op2), IS_CONST);

		zval_ptr_dtor_nogc(free_op1);
	}
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_DIM_UNSET_SPEC_VAR_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *container;

	SAVE_OPLINE();
	container = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

	if (IS_VAR == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an array");

		HANDLE_EXCEPTION();
	}
	zend_fetch_dimension_address_UNSET(EX_VAR(opline->result.var), container, EX_CONSTANT(opline->op2), IS_CONST);

	if (IS_VAR == IS_VAR && READY_TO_DESTROY(free_op1)) {
		EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 1);
	}
	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_R_SPEC_VAR_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *container;

	zval *offset;

	SAVE_OPLINE();
	container = _get_zval_ptr_var(opline->op1.var, execute_data, &free_op1);

	if (IS_VAR == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}

	offset = EX_CONSTANT(opline->op2);

	if (IS_VAR == IS_CONST ||
	    (IS_VAR != IS_UNUSED && UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT))) {
		if ((IS_VAR & (IS_VAR|IS_CV)) && Z_ISREF_P(container)) {
			container = Z_REFVAL_P(container);
			if (UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT)) {
				goto fetch_obj_r_no_object;
			}
		} else {
			goto fetch_obj_r_no_object;
		}
	}

	/* here we are sure we are dealing with an object */
	do {
		zend_object *zobj = Z_OBJ_P(container);
		zval *retval;

		if (IS_CONST == IS_CONST &&
			EXPECTED(zobj->ce == CACHED_PTR(Z_CACHE_SLOT_P(offset)))) {
			uint32_t prop_offset = (uint32_t)(intptr_t)CACHED_PTR(Z_CACHE_SLOT_P(offset) + sizeof(void*));

			if (EXPECTED(prop_offset != (uint32_t)ZEND_DYNAMIC_PROPERTY_OFFSET)) {
				retval = OBJ_PROP(zobj, prop_offset);
				if (EXPECTED(Z_TYPE_P(retval) != IS_UNDEF)) {
					ZVAL_COPY(EX_VAR(opline->result.var), retval);
					break;
				}
			} else if (EXPECTED(zobj->properties != NULL)) {
				retval = zend_hash_find(zobj->properties, Z_STR_P(offset));
				if (EXPECTED(retval)) {
					ZVAL_COPY(EX_VAR(opline->result.var), retval);
					break;
				}
			}
		}

		if (UNEXPECTED(zobj->handlers->read_property == NULL)) {
fetch_obj_r_no_object:
			zend_error(E_NOTICE, "Trying to get property of non-object");
			ZVAL_NULL(EX_VAR(opline->result.var));
		} else {
			retval = zobj->handlers->read_property(container, offset, BP_VAR_R, ((IS_CONST == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(offset)) : NULL), EX_VAR(opline->result.var));

			if (retval != EX_VAR(opline->result.var)) {
				ZVAL_COPY(EX_VAR(opline->result.var), retval);
			}
		}
	} while (0);

	zval_ptr_dtor_nogc(free_op1);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_W_SPEC_VAR_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *property;
	zval *container;

	SAVE_OPLINE();
	property = EX_CONSTANT(opline->op2);

	container = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);
	if (IS_VAR == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}
	if (IS_VAR == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an object");

		HANDLE_EXCEPTION();
	}

	zend_fetch_property_address(EX_VAR(opline->result.var), container, IS_VAR, property, IS_CONST, ((IS_CONST == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), BP_VAR_W);

	if (IS_VAR == IS_VAR && READY_TO_DESTROY(free_op1)) {
		EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 0);
	}
	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_RW_SPEC_VAR_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *property;
	zval *container;

	SAVE_OPLINE();
	property = EX_CONSTANT(opline->op2);
	container = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

	if (IS_VAR == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}
	if (IS_VAR == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an object");

		HANDLE_EXCEPTION();
	}
	zend_fetch_property_address(EX_VAR(opline->result.var), container, IS_VAR, property, IS_CONST, ((IS_CONST == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), BP_VAR_RW);

	if (IS_VAR == IS_VAR && READY_TO_DESTROY(free_op1)) {
		EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 0);
	}
	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_FUNC_ARG_SPEC_VAR_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *container;

	if (zend_is_by_ref_func_arg_fetch(opline, EX(call))) {
		/* Behave like FETCH_OBJ_W */
		zend_free_op free_op1;
		zval *property;

		SAVE_OPLINE();
		property = EX_CONSTANT(opline->op2);
		container = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

		if (IS_VAR == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
			zend_throw_error(NULL, "Using $this when not in object context");

			HANDLE_EXCEPTION();
		}
		if (IS_VAR == IS_CONST || IS_VAR == IS_TMP_VAR) {
			zend_throw_error(NULL, "Cannot use temporary expression in write context");

			if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
			HANDLE_EXCEPTION();
		}
		if (IS_VAR == IS_VAR && UNEXPECTED(container == NULL)) {
			zend_throw_error(NULL, "Cannot use string offset as an object");

			HANDLE_EXCEPTION();
		}
		zend_fetch_property_address(EX_VAR(opline->result.var), container, IS_VAR, property, IS_CONST, ((IS_CONST == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), BP_VAR_W);

		if (IS_VAR == IS_VAR && READY_TO_DESTROY(free_op1)) {
			EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 0);
		}
		if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	} else {
		ZEND_VM_TAIL_CALL(ZEND_FETCH_OBJ_R_SPEC_VAR_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS_PASSTHRU));
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_UNSET_SPEC_VAR_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *container, *property;

	SAVE_OPLINE();
	container = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

	if (IS_VAR == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}

	property = EX_CONSTANT(opline->op2);

	if (IS_VAR == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an object");

		HANDLE_EXCEPTION();
	}
	zend_fetch_property_address(EX_VAR(opline->result.var), container, IS_VAR, property, IS_CONST, ((IS_CONST == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), BP_VAR_UNSET);

	if (IS_VAR == IS_VAR && READY_TO_DESTROY(free_op1)) {
		EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 0);
	}
	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_OBJ_SPEC_VAR_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *object;
	zval *property_name;

	SAVE_OPLINE();
	object = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

	if (IS_VAR == IS_UNUSED && UNEXPECTED(Z_OBJ_P(object) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}

	property_name = EX_CONSTANT(opline->op2);

	if (IS_VAR == IS_VAR && UNEXPECTED(object == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an array");

		HANDLE_EXCEPTION();
	}
	zend_assign_to_object(UNEXPECTED(RETURN_VALUE_USED(opline)) ? EX_VAR(opline->result.var) : NULL, object, IS_VAR, property_name, IS_CONST, (opline+1)->op1_type, (opline+1)->op1, execute_data, ((IS_CONST == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property_name)) : NULL));

	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	/* assign_obj has two opcodes! */
	ZEND_VM_NEXT_OPCODE_EX(1, 2);
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_DIM_SPEC_VAR_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *object_ptr;
	zend_free_op free_op_data1;
	zval *value;
	zval *variable_ptr;
	zval *dim;

	SAVE_OPLINE();
	object_ptr = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

	if (IS_VAR == IS_VAR && UNEXPECTED(object_ptr == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an array");
		FREE_UNFETCHED_OP((opline+1)->op1_type, (opline+1)->op1.var);

		HANDLE_EXCEPTION();
	}

	if (EXPECTED(Z_TYPE_P(object_ptr) == IS_ARRAY)) {
try_assign_dim_array:
		if (IS_CONST == IS_UNUSED) {
			SEPARATE_ARRAY(object_ptr);
			variable_ptr = zend_hash_next_index_insert(Z_ARRVAL_P(object_ptr), &EG(uninitialized_zval));
			if (UNEXPECTED(variable_ptr == NULL)) {
				zend_error(E_WARNING, "Cannot add element to the array as the next element is already occupied");
				variable_ptr = &EG(error_zval);
			}
		} else {
			dim = EX_CONSTANT(opline->op2);
			SEPARATE_ARRAY(object_ptr);
			variable_ptr = zend_fetch_dimension_address_inner(Z_ARRVAL_P(object_ptr), dim, IS_CONST, BP_VAR_W);

		}
		value = get_zval_ptr((opline+1)->op1_type, (opline+1)->op1, execute_data, &free_op_data1, BP_VAR_R);
		if (UNEXPECTED(variable_ptr == &EG(error_zval))) {
			FREE_OP(free_op_data1);
			if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
				ZVAL_NULL(EX_VAR(opline->result.var));
			}
		} else {
			value = zend_assign_to_variable(variable_ptr, value, (opline+1)->op1_type);
			if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
				ZVAL_COPY(EX_VAR(opline->result.var), value);
			}
		}
	} else {
		if (EXPECTED(Z_ISREF_P(object_ptr))) {
			object_ptr = Z_REFVAL_P(object_ptr);
			if (EXPECTED(Z_TYPE_P(object_ptr) == IS_ARRAY)) {
				goto try_assign_dim_array;
			}
		}
		if (EXPECTED(Z_TYPE_P(object_ptr) == IS_OBJECT)) {

			zval *property_name = EX_CONSTANT(opline->op2);

			zend_assign_to_object_dim(UNEXPECTED(RETURN_VALUE_USED(opline)) ? EX_VAR(opline->result.var) : NULL, object_ptr, property_name, (opline+1)->op1_type, (opline+1)->op1, execute_data);

		} else if (EXPECTED(Z_TYPE_P(object_ptr) == IS_STRING)) {
			if (EXPECTED(Z_STRLEN_P(object_ptr) != 0)) {
				if (IS_CONST == IS_UNUSED) {
					zend_throw_error(NULL, "[] operator not supported for strings");
					FREE_UNFETCHED_OP((opline+1)->op1_type, (opline+1)->op1.var);
					if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
					HANDLE_EXCEPTION();
				} else {
					zend_long offset;

					dim = EX_CONSTANT(opline->op2);
					offset = zend_fetch_string_offset(object_ptr, dim, BP_VAR_W);

					value = get_zval_ptr_deref((opline+1)->op1_type, (opline+1)->op1, execute_data, &free_op_data1, BP_VAR_R);
					zend_assign_to_string_offset(object_ptr, offset, value, (UNEXPECTED(RETURN_VALUE_USED(opline)) ? EX_VAR(opline->result.var) : NULL));
					FREE_OP(free_op_data1);
				}
			} else {
				zval_ptr_dtor_nogc(object_ptr);
assign_dim_convert_to_array:
				ZVAL_NEW_ARR(object_ptr);
				zend_hash_init(Z_ARRVAL_P(object_ptr), 8, NULL, ZVAL_PTR_DTOR, 0);
				goto try_assign_dim_array;
			}
		} else if (EXPECTED(Z_TYPE_P(object_ptr) <= IS_FALSE)) {
			if (IS_VAR == IS_VAR && UNEXPECTED(object_ptr == &EG(error_zval))) {
				goto assign_dim_clean;
			}
			goto assign_dim_convert_to_array;
		} else {
			zend_error(E_WARNING, "Cannot use a scalar value as an array");
assign_dim_clean:
			dim = EX_CONSTANT(opline->op2);

			value = get_zval_ptr((opline+1)->op1_type, (opline+1)->op1, execute_data, &free_op_data1, BP_VAR_R);
			FREE_OP(free_op_data1);
			if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
				ZVAL_NULL(EX_VAR(opline->result.var));
			}
		}
	}
 	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	/* assign_dim has two opcodes! */
	ZEND_VM_NEXT_OPCODE_EX(1, 2);
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_SPEC_VAR_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *value;
	zval *variable_ptr;

	SAVE_OPLINE();
	value = EX_CONSTANT(opline->op2);
	variable_ptr = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

	if (IS_VAR == IS_VAR && UNEXPECTED(variable_ptr == &EG(error_zval))) {

		if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
			ZVAL_NULL(EX_VAR(opline->result.var));
		}
	} else {
		value = zend_assign_to_variable(variable_ptr, value, IS_CONST);
		if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
			ZVAL_COPY(EX_VAR(opline->result.var), value);
		}
		if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
		/* zend_assign_to_variable() always takes care of op2, never free it! */
	}

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_INIT_STATIC_METHOD_CALL_SPEC_VAR_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *function_name;
	zend_class_entry *ce;
	zend_object *object;
	zend_function *fbc;
	zend_execute_data *call;

	SAVE_OPLINE();

	if (IS_VAR == IS_CONST) {
		/* no function found. try a static method in class */
		if (EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1))))) {
			ce = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)));
		} else {
			ce = zend_fetch_class_by_name(Z_STR_P(EX_CONSTANT(opline->op1)), EX_CONSTANT(opline->op1) + 1, ZEND_FETCH_CLASS_DEFAULT |  ZEND_FETCH_CLASS_EXCEPTION);
			if (UNEXPECTED(EG(exception) != NULL)) {
				HANDLE_EXCEPTION();
			}
			if (UNEXPECTED(ce == NULL)) {
				zend_throw_error(NULL, "Class '%s' not found", Z_STRVAL_P(EX_CONSTANT(opline->op1)));
				HANDLE_EXCEPTION();
			}
			CACHE_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)), ce);
		}
	} else {
		ce = Z_CE_P(EX_VAR(opline->op1.var));
	}

	if (IS_VAR == IS_CONST &&
	    IS_CONST == IS_CONST &&
	    EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2))))) {
		fbc = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)));
	} else if (IS_VAR != IS_CONST &&
	           IS_CONST == IS_CONST &&
	           (fbc = CACHED_POLYMORPHIC_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)), ce))) {
		/* do nothing */
	} else if (IS_CONST != IS_UNUSED) {


		function_name = EX_CONSTANT(opline->op2);
		if (IS_CONST != IS_CONST) {
			if (UNEXPECTED(Z_TYPE_P(function_name) != IS_STRING)) {
				if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(function_name) == IS_UNDEF)) {
					GET_OP2_UNDEF_CV(function_name, BP_VAR_R);
				}
				if (UNEXPECTED(EG(exception) != NULL)) {
					HANDLE_EXCEPTION();
				}
				zend_throw_error(NULL, "Function name must be a string");

				HANDLE_EXCEPTION();
 			}
		}

		if (ce->get_static_method) {
			fbc = ce->get_static_method(ce, Z_STR_P(function_name));
		} else {
			fbc = zend_std_get_static_method(ce, Z_STR_P(function_name), ((IS_CONST == IS_CONST) ? (EX_CONSTANT(opline->op2) + 1) : NULL));
		}
		if (UNEXPECTED(fbc == NULL)) {
			if (EXPECTED(!EG(exception))) {
				zend_throw_error(NULL, "Call to undefined method %s::%s()", ZSTR_VAL(ce->name), Z_STRVAL_P(function_name));
			}

			HANDLE_EXCEPTION();
		}
		if (IS_CONST == IS_CONST &&
		    EXPECTED(fbc->type <= ZEND_USER_FUNCTION) &&
		    EXPECTED(!(fbc->common.fn_flags & (ZEND_ACC_CALL_VIA_TRAMPOLINE|ZEND_ACC_NEVER_CACHE)))) {
			if (IS_VAR == IS_CONST) {
				CACHE_PTR(Z_CACHE_SLOT_P(function_name), fbc);
			} else {
				CACHE_POLYMORPHIC_PTR(Z_CACHE_SLOT_P(function_name), ce, fbc);
			}
		}
		if (IS_CONST != IS_CONST) {

		}
	} else {
		if (UNEXPECTED(ce->constructor == NULL)) {
			zend_throw_error(NULL, "Cannot call constructor");
			HANDLE_EXCEPTION();
		}
		if (Z_OBJ(EX(This)) && Z_OBJ(EX(This))->ce != ce->constructor->common.scope && (ce->constructor->common.fn_flags & ZEND_ACC_PRIVATE)) {
			zend_throw_error(NULL, "Cannot call private %s::__construct()", ZSTR_VAL(ce->name));
			HANDLE_EXCEPTION();
		}
		fbc = ce->constructor;
	}

	object = NULL;
	if (!(fbc->common.fn_flags & ZEND_ACC_STATIC)) {
		if (Z_OBJ(EX(This)) && instanceof_function(Z_OBJCE(EX(This)), ce)) {
			object = Z_OBJ(EX(This));
		}
		if (!object) {
			if (fbc->common.fn_flags & ZEND_ACC_ALLOW_STATIC) {
				/* Allowed for PHP 4 compatibility. */
				zend_error(
					E_DEPRECATED,
					"Non-static method %s::%s() should not be called statically",
					ZSTR_VAL(fbc->common.scope->name), ZSTR_VAL(fbc->common.function_name));
				if (UNEXPECTED(EG(exception) != NULL)) {
					HANDLE_EXCEPTION();
				}
			} else {
				/* An internal function assumes $this is present and won't check that.
				 * So PHP would crash by allowing the call. */
				zend_throw_error(
					zend_ce_error,
					"Non-static method %s::%s() cannot be called statically",
					ZSTR_VAL(fbc->common.scope->name), ZSTR_VAL(fbc->common.function_name));
				HANDLE_EXCEPTION();
			}
		}
	}

	if (IS_VAR != IS_CONST) {
		/* previous opcode is ZEND_FETCH_CLASS */
		if (((opline-1)->extended_value & ZEND_FETCH_CLASS_MASK) == ZEND_FETCH_CLASS_PARENT ||
		    ((opline-1)->extended_value & ZEND_FETCH_CLASS_MASK) == ZEND_FETCH_CLASS_SELF) {
			ce = EX(called_scope);
		}
	}

	call = zend_vm_stack_push_call_frame(ZEND_CALL_NESTED_FUNCTION,
		fbc, opline->extended_value, ce, object);
	call->prev_execute_data = EX(call);
	EX(call) = call;

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_CONSTANT_SPEC_VAR_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	SAVE_OPLINE();
	if (IS_VAR == IS_UNUSED) {
		zend_constant *c;

		if (EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2))))) {
			c = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)));
		} else if ((c = zend_quick_get_constant(EX_CONSTANT(opline->op2) + 1, opline->extended_value)) == NULL) {
			if ((opline->extended_value & IS_CONSTANT_UNQUALIFIED) != 0) {
				char *actual = (char *)zend_memrchr(Z_STRVAL_P(EX_CONSTANT(opline->op2)), '\\', Z_STRLEN_P(EX_CONSTANT(opline->op2)));
				if (!actual) {
					ZVAL_STR_COPY(EX_VAR(opline->result.var), Z_STR_P(EX_CONSTANT(opline->op2)));
				} else {
					actual++;
					ZVAL_STRINGL(EX_VAR(opline->result.var),
							actual, Z_STRLEN_P(EX_CONSTANT(opline->op2)) - (actual - Z_STRVAL_P(EX_CONSTANT(opline->op2))));
				}
				/* non-qualified constant - allow text substitution */
				zend_error(E_NOTICE, "Use of undefined constant %s - assumed '%s'",
						Z_STRVAL_P(EX_VAR(opline->result.var)), Z_STRVAL_P(EX_VAR(opline->result.var)));
				ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
			} else {
				zend_throw_error(NULL, "Undefined constant '%s'", Z_STRVAL_P(EX_CONSTANT(opline->op2)));
				HANDLE_EXCEPTION();
			}
		} else {
			CACHE_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)), c);
		}
#ifdef ZTS
		if (c->flags & CONST_PERSISTENT) {
			ZVAL_DUP(EX_VAR(opline->result.var), &c->value);
		} else {
			ZVAL_COPY(EX_VAR(opline->result.var), &c->value);
		}
#else
		ZVAL_COPY(EX_VAR(opline->result.var), &c->value);
#endif
	} else {
		/* class constant */
		zend_class_entry *ce;
		zval *value;

		do {
			if (IS_VAR == IS_CONST) {
				if (EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2))))) {
					value = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)));
					ZVAL_DEREF(value);
#ifdef ZTS
					ce = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)));
#endif
					break;
				} else if (EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1))))) {
					ce = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)));
				} else {
					ce = zend_fetch_class_by_name(Z_STR_P(EX_CONSTANT(opline->op1)), EX_CONSTANT(opline->op1) + 1, ZEND_FETCH_CLASS_DEFAULT | ZEND_FETCH_CLASS_EXCEPTION);
					if (UNEXPECTED(EG(exception) != NULL)) {
						HANDLE_EXCEPTION();
					}
					if (UNEXPECTED(ce == NULL)) {
						zend_throw_error(NULL, "Class '%s' not found", Z_STRVAL_P(EX_CONSTANT(opline->op1)));
						HANDLE_EXCEPTION();
					}
					CACHE_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)), ce);
				}
			} else {
				ce = Z_CE_P(EX_VAR(opline->op1.var));
				if ((value = CACHED_POLYMORPHIC_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)), ce)) != NULL) {
					ZVAL_DEREF(value);
					break;
				}
			}

			if (EXPECTED((value = zend_hash_find(&ce->constants_table, Z_STR_P(EX_CONSTANT(opline->op2)))) != NULL)) {
				ZVAL_DEREF(value);
				if (Z_CONSTANT_P(value)) {
					EG(scope) = ce;
					zval_update_constant_ex(value, 1, NULL);
					EG(scope) = EX(func)->op_array.scope;
					if (UNEXPECTED(EG(exception) != NULL)) {
						HANDLE_EXCEPTION();
					}
				}
				if (IS_VAR == IS_CONST) {
					CACHE_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)), value);
				} else {
					CACHE_POLYMORPHIC_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)), ce, value);
				}
			} else {
				zend_throw_error(NULL, "Undefined class constant '%s'", Z_STRVAL_P(EX_CONSTANT(opline->op2)));
				HANDLE_EXCEPTION();
			}
		} while (0);
#ifdef ZTS
		if (ce->type == ZEND_INTERNAL_CLASS) {
			ZVAL_DUP(EX_VAR(opline->result.var), value);
		} else {
			ZVAL_COPY(EX_VAR(opline->result.var), value);
		}
#else
		ZVAL_COPY(EX_VAR(opline->result.var), value);
#endif
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ADD_ARRAY_ELEMENT_SPEC_VAR_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *expr_ptr, new_expr;

	SAVE_OPLINE();
	if ((IS_VAR == IS_VAR || IS_VAR == IS_CV) &&
	    UNEXPECTED(opline->extended_value & ZEND_ARRAY_ELEMENT_REF)) {
		expr_ptr = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);
		if (IS_VAR == IS_VAR && UNEXPECTED(expr_ptr == NULL)) {
			zend_throw_error(NULL, "Cannot create references to/from string offsets");
			zend_array_destroy(Z_ARRVAL_P(EX_VAR(opline->result.var)));
			HANDLE_EXCEPTION();
		}
		ZVAL_MAKE_REF(expr_ptr);
		Z_ADDREF_P(expr_ptr);
		if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	} else {
		expr_ptr = _get_zval_ptr_var(opline->op1.var, execute_data, &free_op1);
		if (IS_VAR == IS_TMP_VAR) {
			/* pass */
		} else if (IS_VAR == IS_CONST) {
			if (UNEXPECTED(Z_OPT_COPYABLE_P(expr_ptr))) {
				ZVAL_COPY_VALUE(&new_expr, expr_ptr);
				zval_copy_ctor_func(&new_expr);
				expr_ptr = &new_expr;
			}
		} else if (IS_VAR == IS_CV) {
			ZVAL_DEREF(expr_ptr);
			if (Z_REFCOUNTED_P(expr_ptr)) {
				Z_ADDREF_P(expr_ptr);
			}
		} else /* if (IS_VAR == IS_VAR) */ {
			if (UNEXPECTED(Z_ISREF_P(expr_ptr))) {
				zend_refcounted *ref = Z_COUNTED_P(expr_ptr);

				expr_ptr = Z_REFVAL_P(expr_ptr);
				if (UNEXPECTED(--GC_REFCOUNT(ref) == 0)) {
					ZVAL_COPY_VALUE(&new_expr, expr_ptr);
					expr_ptr = &new_expr;
					efree_size(ref, sizeof(zend_reference));
				} else if (Z_OPT_REFCOUNTED_P(expr_ptr)) {
					Z_ADDREF_P(expr_ptr);
				}
			}
		}
	}

	if (IS_CONST != IS_UNUSED) {

		zval *offset = EX_CONSTANT(opline->op2);
		zend_string *str;
		zend_ulong hval;

add_again:
		if (EXPECTED(Z_TYPE_P(offset) == IS_STRING)) {
			str = Z_STR_P(offset);
			if (IS_CONST != IS_CONST) {
				if (ZEND_HANDLE_NUMERIC(str, hval)) {
					goto num_index;
				}
			}
str_index:
			zend_hash_update(Z_ARRVAL_P(EX_VAR(opline->result.var)), str, expr_ptr);
		} else if (EXPECTED(Z_TYPE_P(offset) == IS_LONG)) {
			hval = Z_LVAL_P(offset);
num_index:
			zend_hash_index_update(Z_ARRVAL_P(EX_VAR(opline->result.var)), hval, expr_ptr);
		} else if ((IS_CONST & (IS_VAR|IS_CV)) && EXPECTED(Z_TYPE_P(offset) == IS_REFERENCE)) {
			offset = Z_REFVAL_P(offset);
			goto add_again;
		} else if (Z_TYPE_P(offset) == IS_NULL) {
			str = ZSTR_EMPTY_ALLOC();
			goto str_index;
		} else if (Z_TYPE_P(offset) == IS_DOUBLE) {
			hval = zend_dval_to_lval(Z_DVAL_P(offset));
			goto num_index;
		} else if (Z_TYPE_P(offset) == IS_FALSE) {
			hval = 0;
			goto num_index;
		} else if (Z_TYPE_P(offset) == IS_TRUE) {
			hval = 1;
			goto num_index;
		} else if (IS_CONST == IS_CV && Z_TYPE_P(offset) == IS_UNDEF) {
			GET_OP2_UNDEF_CV(offset, BP_VAR_R);
			str = ZSTR_EMPTY_ALLOC();
			goto str_index;
		} else {
			zend_error(E_WARNING, "Illegal offset type");
			zval_ptr_dtor(expr_ptr);
		}

	} else {
		zend_hash_next_index_insert(Z_ARRVAL_P(EX_VAR(opline->result.var)), expr_ptr);
	}
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_INIT_ARRAY_SPEC_VAR_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	zval *array;
	uint32_t size;
	USE_OPLINE

	array = EX_VAR(opline->result.var);
	if (IS_VAR != IS_UNUSED) {
		size = opline->extended_value >> ZEND_ARRAY_SIZE_SHIFT;
	} else {
		size = 0;
	}
	ZVAL_NEW_ARR(array);
	zend_hash_init(Z_ARRVAL_P(array), size, NULL, ZVAL_PTR_DTOR, 0);

	if (IS_VAR != IS_UNUSED) {
		/* Explicitly initialize array as not-packed if flag is set */
		if (opline->extended_value & ZEND_ARRAY_NOT_PACKED) {
			zend_hash_real_init(Z_ARRVAL_P(array), 0);
		}
	}

	if (IS_VAR == IS_UNUSED) {
		ZEND_VM_NEXT_OPCODE();
#if 0 || (IS_VAR != IS_UNUSED)
	} else {
		ZEND_VM_TAIL_CALL(ZEND_ADD_ARRAY_ELEMENT_SPEC_VAR_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS_PASSTHRU));
#endif
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_UNSET_DIM_SPEC_VAR_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *container;
	zval *offset;
	zend_ulong hval;
	zend_string *key;

	SAVE_OPLINE();
	container = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);
	if (IS_VAR == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}
	if (IS_VAR == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot unset string offsets");

		HANDLE_EXCEPTION();
	}
	offset = EX_CONSTANT(opline->op2);

	do {
		if (IS_VAR != IS_UNUSED && EXPECTED(Z_TYPE_P(container) == IS_ARRAY)) {
			HashTable *ht;

unset_dim_array:
			SEPARATE_ARRAY(container);
			ht = Z_ARRVAL_P(container);
offset_again:
			if (EXPECTED(Z_TYPE_P(offset) == IS_STRING)) {
				key = Z_STR_P(offset);
				if (IS_CONST != IS_CONST) {
					if (ZEND_HANDLE_NUMERIC(key, hval)) {
						goto num_index_dim;
					}
				}
str_index_dim:
				if (ht == &EG(symbol_table)) {
					zend_delete_global_variable(key);
				} else {
					zend_hash_del(ht, key);
				}
			} else if (EXPECTED(Z_TYPE_P(offset) == IS_LONG)) {
				hval = Z_LVAL_P(offset);
num_index_dim:
				zend_hash_index_del(ht, hval);
			} else if ((IS_CONST & (IS_VAR|IS_CV)) && EXPECTED(Z_TYPE_P(offset) == IS_REFERENCE)) {
				offset = Z_REFVAL_P(offset);
				goto offset_again;
			} else if (Z_TYPE_P(offset) == IS_DOUBLE) {
				hval = zend_dval_to_lval(Z_DVAL_P(offset));
				goto num_index_dim;
			} else if (Z_TYPE_P(offset) == IS_NULL) {
				key = ZSTR_EMPTY_ALLOC();
				goto str_index_dim;
			} else if (Z_TYPE_P(offset) == IS_FALSE) {
				hval = 0;
				goto num_index_dim;
			} else if (Z_TYPE_P(offset) == IS_TRUE) {
				hval = 1;
				goto num_index_dim;
			} else if (Z_TYPE_P(offset) == IS_RESOURCE) {
				hval = Z_RES_HANDLE_P(offset);
				goto num_index_dim;
			} else if (IS_CONST == IS_CV && Z_TYPE_P(offset) == IS_UNDEF) {
				GET_OP2_UNDEF_CV(offset, BP_VAR_R);
				key = ZSTR_EMPTY_ALLOC();
				goto str_index_dim;
			} else {
				zend_error(E_WARNING, "Illegal offset type in unset");
			}
			break;
		} else if (IS_VAR != IS_UNUSED && Z_ISREF_P(container)) {
			container = Z_REFVAL_P(container);
			if (EXPECTED(Z_TYPE_P(container) == IS_ARRAY)) {
				goto unset_dim_array;
			}
		}
		if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(offset) == IS_UNDEF)) {
			offset = GET_OP2_UNDEF_CV(offset, BP_VAR_R);
		}
		if (IS_VAR == IS_UNUSED || EXPECTED(Z_TYPE_P(container) == IS_OBJECT)) {
			if (UNEXPECTED(Z_OBJ_HT_P(container)->unset_dimension == NULL)) {
				zend_throw_error(NULL, "Cannot use object as array");
			} else {
				Z_OBJ_HT_P(container)->unset_dimension(container, offset);
			}
		} else if (IS_VAR != IS_UNUSED && UNEXPECTED(Z_TYPE_P(container) == IS_STRING)) {
			zend_throw_error(NULL, "Cannot unset string offsets");
		}
	} while (0);

	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_UNSET_OBJ_SPEC_VAR_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *container;
	zval *offset;

	SAVE_OPLINE();
	container = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);
	if (IS_VAR == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}
	if (IS_VAR == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot unset string offsets");

		HANDLE_EXCEPTION();
	}
	offset = EX_CONSTANT(opline->op2);

	do {
		if (IS_VAR != IS_UNUSED && UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT)) {
			if (Z_ISREF_P(container)) {
				container = Z_REFVAL_P(container);
				if (Z_TYPE_P(container) != IS_OBJECT) {
					break;
				}
			} else {
				break;
			}
		}
		if (Z_OBJ_HT_P(container)->unset_property) {
			Z_OBJ_HT_P(container)->unset_property(container, offset, ((IS_CONST == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(offset)) : NULL));
		} else {
			zend_error(E_NOTICE, "Trying to unset property of non-object");
		}
	} while (0);

	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_YIELD_SPEC_VAR_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zend_generator *generator = zend_get_running_generator(execute_data);

	SAVE_OPLINE();
	if (UNEXPECTED(generator->flags & ZEND_GENERATOR_FORCED_CLOSE)) {
		zend_throw_error(NULL, "Cannot yield from finally in a force-closed generator");

		zval_ptr_dtor_nogc(EX_VAR(opline->op1.var));
		HANDLE_EXCEPTION();
	}

	/* Destroy the previously yielded value */
	zval_ptr_dtor(&generator->value);

	/* Destroy the previously yielded key */
	zval_ptr_dtor(&generator->key);

	/* Set the new yielded value */
	if (IS_VAR != IS_UNUSED) {
		zend_free_op free_op1;

		if (UNEXPECTED(EX(func)->op_array.fn_flags & ZEND_ACC_RETURN_REFERENCE)) {
			/* Constants and temporary variables aren't yieldable by reference,
			 * but we still allow them with a notice. */
			if (IS_VAR == IS_CONST || IS_VAR == IS_TMP_VAR) {
				zval *value;

				zend_error(E_NOTICE, "Only variable references should be yielded by reference");

				value = _get_zval_ptr_var(opline->op1.var, execute_data, &free_op1);
				ZVAL_COPY_VALUE(&generator->value, value);
				if (IS_VAR != IS_CONST) {
					if (UNEXPECTED(Z_OPT_COPYABLE(generator->value))) {
						zval_copy_ctor_func(&generator->value);
					}
				}
			} else {
				zval *value_ptr = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

				if (IS_VAR == IS_VAR && UNEXPECTED(value_ptr == NULL)) {
					zend_throw_error(NULL, "Cannot yield string offsets by reference");

					HANDLE_EXCEPTION();
				}

				/* If a function call result is yielded and the function did
				 * not return by reference we throw a notice. */
				if (IS_VAR == IS_VAR &&
				    (value_ptr == &EG(uninitialized_zval) ||
				     (opline->extended_value == ZEND_RETURNS_FUNCTION &&
				      !(Z_VAR_FLAGS_P(value_ptr) & IS_VAR_RET_REF)))) {
					zend_error(E_NOTICE, "Only variable references should be yielded by reference");
				} else {
					ZVAL_MAKE_REF(value_ptr);
				}
				ZVAL_COPY(&generator->value, value_ptr);

				if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
			}
		} else {
			zval *value = _get_zval_ptr_var(opline->op1.var, execute_data, &free_op1);

			/* Consts, temporary variables and references need copying */
			if (IS_VAR == IS_CONST) {
				ZVAL_COPY_VALUE(&generator->value, value);
				if (UNEXPECTED(Z_OPT_COPYABLE(generator->value))) {
					zval_copy_ctor_func(&generator->value);
				}
			} else if (IS_VAR == IS_TMP_VAR) {
				ZVAL_COPY_VALUE(&generator->value, value);
            } else if ((IS_VAR & (IS_VAR|IS_CV)) && Z_ISREF_P(value)) {
				ZVAL_COPY(&generator->value, Z_REFVAL_P(value));
				zval_ptr_dtor_nogc(free_op1);
			} else {
				ZVAL_COPY_VALUE(&generator->value, value);
				if (IS_VAR == IS_CV) {
					if (Z_OPT_REFCOUNTED_P(value)) Z_ADDREF_P(value);
				}
			}
		}
	} else {
		/* If no value was specified yield null */
		ZVAL_NULL(&generator->value);
	}

	/* Set the new yielded key */
	if (IS_CONST != IS_UNUSED) {

		zval *key = EX_CONSTANT(opline->op2);

		/* Consts, temporary variables and references need copying */
		if (IS_CONST == IS_CONST) {
			ZVAL_COPY_VALUE(&generator->key, key);
			if (UNEXPECTED(Z_OPT_COPYABLE(generator->key))) {
				zval_copy_ctor_func(&generator->key);
			}
		} else if (IS_CONST == IS_TMP_VAR) {
			ZVAL_COPY_VALUE(&generator->key, key);
		} else if ((IS_CONST & (IS_VAR|IS_CV)) && Z_ISREF_P(key)) {
			ZVAL_COPY(&generator->key, Z_REFVAL_P(key));

		} else {
			ZVAL_COPY_VALUE(&generator->key, key);
			if (IS_CONST == IS_CV) {
				if (Z_OPT_REFCOUNTED_P(key)) Z_ADDREF_P(key);
			}
		}

		if (Z_TYPE(generator->key) == IS_LONG
		    && Z_LVAL(generator->key) > generator->largest_used_integer_key
		) {
			generator->largest_used_integer_key = Z_LVAL(generator->key);
		}
	} else {
		/* If no key was specified we use auto-increment keys */
		generator->largest_used_integer_key++;
		ZVAL_LONG(&generator->key, generator->largest_used_integer_key);
	}

	if (RETURN_VALUE_USED(opline)) {
		/* If the return value of yield is used set the send
		 * target and initialize it to NULL */
		generator->send_target = EX_VAR(opline->result.var);
		ZVAL_NULL(generator->send_target);
	} else {
		generator->send_target = NULL;
	}

	/* We increment to the next op, so we are at the correct position when the
	 * generator is resumed. */
	ZEND_VM_INC_OPCODE();

	/* The GOTO VM uses a local opline variable. We need to set the opline
	 * variable in execute_data so we don't resume at an old position. */
	SAVE_OPLINE();

	ZEND_VM_RETURN();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_POW_SPEC_VAR_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_VAR_CONST(pow_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_IS_IDENTICAL_SPEC_VAR_TMP_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1, free_op2;
	zval *op1, *op2;
	int result;

	SAVE_OPLINE();
	op1 = _get_zval_ptr_var_deref(opline->op1.var, execute_data, &free_op1);
	op2 = _get_zval_ptr_tmp(opline->op2.var, execute_data, &free_op2);
	result = fast_is_identical_function(op1, op2);
	zval_ptr_dtor_nogc(free_op1);
	zval_ptr_dtor_nogc(free_op2);
	ZEND_VM_SMART_BRANCH(result, (IS_VAR|IS_TMP_VAR) & (IS_VAR|IS_TMP_VAR));
	ZVAL_BOOL(EX_VAR(opline->result.var), result);
	if ((IS_VAR|IS_TMP_VAR) & (IS_VAR|IS_TMP_VAR)) {
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_IS_NOT_IDENTICAL_SPEC_VAR_TMP_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1, free_op2;
	zval *op1, *op2;
	int result;

	SAVE_OPLINE();
	op1 = _get_zval_ptr_var_deref(opline->op1.var, execute_data, &free_op1);
	op2 = _get_zval_ptr_tmp(opline->op2.var, execute_data, &free_op2);
	result = fast_is_not_identical_function(op1, op2);
	zval_ptr_dtor_nogc(free_op1);
	zval_ptr_dtor_nogc(free_op2);
	ZEND_VM_SMART_BRANCH(result, (IS_VAR|IS_TMP_VAR) & (IS_VAR|IS_TMP_VAR));
	ZVAL_BOOL(EX_VAR(opline->result.var), result);
	if ((IS_VAR|IS_TMP_VAR) & (IS_VAR|IS_TMP_VAR)) {
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_SPEC_VAR_TMP_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1, free_op2;
	zval *value;
	zval *variable_ptr;

	SAVE_OPLINE();
	value = _get_zval_ptr_tmp(opline->op2.var, execute_data, &free_op2);
	variable_ptr = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

	if (IS_VAR == IS_VAR && UNEXPECTED(variable_ptr == &EG(error_zval))) {
		zval_ptr_dtor_nogc(free_op2);
		if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
			ZVAL_NULL(EX_VAR(opline->result.var));
		}
	} else {
		value = zend_assign_to_variable(variable_ptr, value, IS_TMP_VAR);
		if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
			ZVAL_COPY(EX_VAR(opline->result.var), value);
		}
		if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
		/* zend_assign_to_variable() always takes care of op2, never free it! */
	}

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_YIELD_SPEC_VAR_TMP_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zend_generator *generator = zend_get_running_generator(execute_data);

	SAVE_OPLINE();
	if (UNEXPECTED(generator->flags & ZEND_GENERATOR_FORCED_CLOSE)) {
		zend_throw_error(NULL, "Cannot yield from finally in a force-closed generator");
		zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
		zval_ptr_dtor_nogc(EX_VAR(opline->op1.var));
		HANDLE_EXCEPTION();
	}

	/* Destroy the previously yielded value */
	zval_ptr_dtor(&generator->value);

	/* Destroy the previously yielded key */
	zval_ptr_dtor(&generator->key);

	/* Set the new yielded value */
	if (IS_VAR != IS_UNUSED) {
		zend_free_op free_op1;

		if (UNEXPECTED(EX(func)->op_array.fn_flags & ZEND_ACC_RETURN_REFERENCE)) {
			/* Constants and temporary variables aren't yieldable by reference,
			 * but we still allow them with a notice. */
			if (IS_VAR == IS_CONST || IS_VAR == IS_TMP_VAR) {
				zval *value;

				zend_error(E_NOTICE, "Only variable references should be yielded by reference");

				value = _get_zval_ptr_var(opline->op1.var, execute_data, &free_op1);
				ZVAL_COPY_VALUE(&generator->value, value);
				if (IS_VAR != IS_CONST) {
					if (UNEXPECTED(Z_OPT_COPYABLE(generator->value))) {
						zval_copy_ctor_func(&generator->value);
					}
				}
			} else {
				zval *value_ptr = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

				if (IS_VAR == IS_VAR && UNEXPECTED(value_ptr == NULL)) {
					zend_throw_error(NULL, "Cannot yield string offsets by reference");
					zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
					HANDLE_EXCEPTION();
				}

				/* If a function call result is yielded and the function did
				 * not return by reference we throw a notice. */
				if (IS_VAR == IS_VAR &&
				    (value_ptr == &EG(uninitialized_zval) ||
				     (opline->extended_value == ZEND_RETURNS_FUNCTION &&
				      !(Z_VAR_FLAGS_P(value_ptr) & IS_VAR_RET_REF)))) {
					zend_error(E_NOTICE, "Only variable references should be yielded by reference");
				} else {
					ZVAL_MAKE_REF(value_ptr);
				}
				ZVAL_COPY(&generator->value, value_ptr);

				if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
			}
		} else {
			zval *value = _get_zval_ptr_var(opline->op1.var, execute_data, &free_op1);

			/* Consts, temporary variables and references need copying */
			if (IS_VAR == IS_CONST) {
				ZVAL_COPY_VALUE(&generator->value, value);
				if (UNEXPECTED(Z_OPT_COPYABLE(generator->value))) {
					zval_copy_ctor_func(&generator->value);
				}
			} else if (IS_VAR == IS_TMP_VAR) {
				ZVAL_COPY_VALUE(&generator->value, value);
            } else if ((IS_VAR & (IS_VAR|IS_CV)) && Z_ISREF_P(value)) {
				ZVAL_COPY(&generator->value, Z_REFVAL_P(value));
				zval_ptr_dtor_nogc(free_op1);
			} else {
				ZVAL_COPY_VALUE(&generator->value, value);
				if (IS_VAR == IS_CV) {
					if (Z_OPT_REFCOUNTED_P(value)) Z_ADDREF_P(value);
				}
			}
		}
	} else {
		/* If no value was specified yield null */
		ZVAL_NULL(&generator->value);
	}

	/* Set the new yielded key */
	if (IS_TMP_VAR != IS_UNUSED) {
		zend_free_op free_op2;
		zval *key = _get_zval_ptr_tmp(opline->op2.var, execute_data, &free_op2);

		/* Consts, temporary variables and references need copying */
		if (IS_TMP_VAR == IS_CONST) {
			ZVAL_COPY_VALUE(&generator->key, key);
			if (UNEXPECTED(Z_OPT_COPYABLE(generator->key))) {
				zval_copy_ctor_func(&generator->key);
			}
		} else if (IS_TMP_VAR == IS_TMP_VAR) {
			ZVAL_COPY_VALUE(&generator->key, key);
		} else if ((IS_TMP_VAR & (IS_VAR|IS_CV)) && Z_ISREF_P(key)) {
			ZVAL_COPY(&generator->key, Z_REFVAL_P(key));

		} else {
			ZVAL_COPY_VALUE(&generator->key, key);
			if (IS_TMP_VAR == IS_CV) {
				if (Z_OPT_REFCOUNTED_P(key)) Z_ADDREF_P(key);
			}
		}

		if (Z_TYPE(generator->key) == IS_LONG
		    && Z_LVAL(generator->key) > generator->largest_used_integer_key
		) {
			generator->largest_used_integer_key = Z_LVAL(generator->key);
		}
	} else {
		/* If no key was specified we use auto-increment keys */
		generator->largest_used_integer_key++;
		ZVAL_LONG(&generator->key, generator->largest_used_integer_key);
	}

	if (RETURN_VALUE_USED(opline)) {
		/* If the return value of yield is used set the send
		 * target and initialize it to NULL */
		generator->send_target = EX_VAR(opline->result.var);
		ZVAL_NULL(generator->send_target);
	} else {
		generator->send_target = NULL;
	}

	/* We increment to the next op, so we are at the correct position when the
	 * generator is resumed. */
	ZEND_VM_INC_OPCODE();

	/* The GOTO VM uses a local opline variable. We need to set the opline
	 * variable in execute_data so we don't resume at an old position. */
	SAVE_OPLINE();

	ZEND_VM_RETURN();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_IS_IDENTICAL_SPEC_VAR_VAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1, free_op2;
	zval *op1, *op2;
	int result;

	SAVE_OPLINE();
	op1 = _get_zval_ptr_var_deref(opline->op1.var, execute_data, &free_op1);
	op2 = _get_zval_ptr_var_deref(opline->op2.var, execute_data, &free_op2);
	result = fast_is_identical_function(op1, op2);
	zval_ptr_dtor_nogc(free_op1);
	zval_ptr_dtor_nogc(free_op2);
	ZEND_VM_SMART_BRANCH(result, (IS_VAR|IS_VAR) & (IS_VAR|IS_TMP_VAR));
	ZVAL_BOOL(EX_VAR(opline->result.var), result);
	if ((IS_VAR|IS_VAR) & (IS_VAR|IS_TMP_VAR)) {
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_IS_NOT_IDENTICAL_SPEC_VAR_VAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1, free_op2;
	zval *op1, *op2;
	int result;

	SAVE_OPLINE();
	op1 = _get_zval_ptr_var_deref(opline->op1.var, execute_data, &free_op1);
	op2 = _get_zval_ptr_var_deref(opline->op2.var, execute_data, &free_op2);
	result = fast_is_not_identical_function(op1, op2);
	zval_ptr_dtor_nogc(free_op1);
	zval_ptr_dtor_nogc(free_op2);
	ZEND_VM_SMART_BRANCH(result, (IS_VAR|IS_VAR) & (IS_VAR|IS_TMP_VAR));
	ZVAL_BOOL(EX_VAR(opline->result.var), result);
	if ((IS_VAR|IS_VAR) & (IS_VAR|IS_TMP_VAR)) {
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_SPEC_VAR_VAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1, free_op2;
	zval *value;
	zval *variable_ptr;

	SAVE_OPLINE();
	value = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);
	variable_ptr = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

	if (IS_VAR == IS_VAR && UNEXPECTED(variable_ptr == &EG(error_zval))) {
		zval_ptr_dtor_nogc(free_op2);
		if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
			ZVAL_NULL(EX_VAR(opline->result.var));
		}
	} else {
		value = zend_assign_to_variable(variable_ptr, value, IS_VAR);
		if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
			ZVAL_COPY(EX_VAR(opline->result.var), value);
		}
		if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
		/* zend_assign_to_variable() always takes care of op2, never free it! */
	}

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_REF_SPEC_VAR_VAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1, free_op2;
	zval *variable_ptr;
	zval *value_ptr;

	SAVE_OPLINE();
	value_ptr = _get_zval_ptr_ptr_var(opline->op2.var, execute_data, &free_op2);

	if (IS_VAR == IS_VAR && UNEXPECTED(value_ptr == NULL)) {
		zend_throw_error(NULL, "Cannot create references to/from string offsets nor overloaded objects");
		zval_ptr_dtor_nogc(EX_VAR(opline->op1.var));
		HANDLE_EXCEPTION();
	}
	if (IS_VAR == IS_VAR &&
	    UNEXPECTED(Z_TYPE_P(EX_VAR(opline->op1.var)) != IS_INDIRECT) &&
	    UNEXPECTED(!Z_ISREF_P(EX_VAR(opline->op1.var)))) {
		zend_throw_error(NULL, "Cannot assign by reference to overloaded object");
		if (free_op2) {zval_ptr_dtor_nogc(free_op2);};
		HANDLE_EXCEPTION();
	}
	if (IS_VAR == IS_VAR &&
	    (value_ptr == &EG(uninitialized_zval) ||
	     (opline->extended_value == ZEND_RETURNS_FUNCTION &&
	      !(Z_VAR_FLAGS_P(value_ptr) & IS_VAR_RET_REF)))) {
		if (!(free_op2 != NULL) && UNEXPECTED(Z_TYPE_P(EX_VAR(opline->op2.var)) != IS_INDIRECT)) { /* undo the effect of get_zval_ptr_ptr() */
			Z_TRY_ADDREF_P(value_ptr);
		}
		zend_error(E_NOTICE, "Only variables should be assigned by reference");
		if (UNEXPECTED(EG(exception) != NULL)) {
			if (free_op2) {zval_ptr_dtor_nogc(free_op2);};
			HANDLE_EXCEPTION();
		}
		ZEND_VM_TAIL_CALL(ZEND_ASSIGN_SPEC_VAR_VAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS_PASSTHRU));
	}

	variable_ptr = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);
	if (IS_VAR == IS_VAR && UNEXPECTED(variable_ptr == NULL)) {
		zend_throw_error(NULL, "Cannot create references to/from string offsets nor overloaded objects");
		if (free_op2) {zval_ptr_dtor_nogc(free_op2);};
		HANDLE_EXCEPTION();
	}
	if ((IS_VAR == IS_VAR && UNEXPECTED(variable_ptr == &EG(error_zval))) ||
	    (IS_VAR == IS_VAR && UNEXPECTED(value_ptr == &EG(error_zval)))) {
		variable_ptr = &EG(uninitialized_zval);
	} else {
		zend_assign_to_variable_reference(variable_ptr, value_ptr);
	}

	if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
		ZVAL_COPY(EX_VAR(opline->result.var), variable_ptr);
	}

	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	if (free_op2) {zval_ptr_dtor_nogc(free_op2);};

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_YIELD_SPEC_VAR_VAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zend_generator *generator = zend_get_running_generator(execute_data);

	SAVE_OPLINE();
	if (UNEXPECTED(generator->flags & ZEND_GENERATOR_FORCED_CLOSE)) {
		zend_throw_error(NULL, "Cannot yield from finally in a force-closed generator");
		zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
		zval_ptr_dtor_nogc(EX_VAR(opline->op1.var));
		HANDLE_EXCEPTION();
	}

	/* Destroy the previously yielded value */
	zval_ptr_dtor(&generator->value);

	/* Destroy the previously yielded key */
	zval_ptr_dtor(&generator->key);

	/* Set the new yielded value */
	if (IS_VAR != IS_UNUSED) {
		zend_free_op free_op1;

		if (UNEXPECTED(EX(func)->op_array.fn_flags & ZEND_ACC_RETURN_REFERENCE)) {
			/* Constants and temporary variables aren't yieldable by reference,
			 * but we still allow them with a notice. */
			if (IS_VAR == IS_CONST || IS_VAR == IS_TMP_VAR) {
				zval *value;

				zend_error(E_NOTICE, "Only variable references should be yielded by reference");

				value = _get_zval_ptr_var(opline->op1.var, execute_data, &free_op1);
				ZVAL_COPY_VALUE(&generator->value, value);
				if (IS_VAR != IS_CONST) {
					if (UNEXPECTED(Z_OPT_COPYABLE(generator->value))) {
						zval_copy_ctor_func(&generator->value);
					}
				}
			} else {
				zval *value_ptr = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

				if (IS_VAR == IS_VAR && UNEXPECTED(value_ptr == NULL)) {
					zend_throw_error(NULL, "Cannot yield string offsets by reference");
					zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
					HANDLE_EXCEPTION();
				}

				/* If a function call result is yielded and the function did
				 * not return by reference we throw a notice. */
				if (IS_VAR == IS_VAR &&
				    (value_ptr == &EG(uninitialized_zval) ||
				     (opline->extended_value == ZEND_RETURNS_FUNCTION &&
				      !(Z_VAR_FLAGS_P(value_ptr) & IS_VAR_RET_REF)))) {
					zend_error(E_NOTICE, "Only variable references should be yielded by reference");
				} else {
					ZVAL_MAKE_REF(value_ptr);
				}
				ZVAL_COPY(&generator->value, value_ptr);

				if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
			}
		} else {
			zval *value = _get_zval_ptr_var(opline->op1.var, execute_data, &free_op1);

			/* Consts, temporary variables and references need copying */
			if (IS_VAR == IS_CONST) {
				ZVAL_COPY_VALUE(&generator->value, value);
				if (UNEXPECTED(Z_OPT_COPYABLE(generator->value))) {
					zval_copy_ctor_func(&generator->value);
				}
			} else if (IS_VAR == IS_TMP_VAR) {
				ZVAL_COPY_VALUE(&generator->value, value);
            } else if ((IS_VAR & (IS_VAR|IS_CV)) && Z_ISREF_P(value)) {
				ZVAL_COPY(&generator->value, Z_REFVAL_P(value));
				zval_ptr_dtor_nogc(free_op1);
			} else {
				ZVAL_COPY_VALUE(&generator->value, value);
				if (IS_VAR == IS_CV) {
					if (Z_OPT_REFCOUNTED_P(value)) Z_ADDREF_P(value);
				}
			}
		}
	} else {
		/* If no value was specified yield null */
		ZVAL_NULL(&generator->value);
	}

	/* Set the new yielded key */
	if (IS_VAR != IS_UNUSED) {
		zend_free_op free_op2;
		zval *key = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);

		/* Consts, temporary variables and references need copying */
		if (IS_VAR == IS_CONST) {
			ZVAL_COPY_VALUE(&generator->key, key);
			if (UNEXPECTED(Z_OPT_COPYABLE(generator->key))) {
				zval_copy_ctor_func(&generator->key);
			}
		} else if (IS_VAR == IS_TMP_VAR) {
			ZVAL_COPY_VALUE(&generator->key, key);
		} else if ((IS_VAR & (IS_VAR|IS_CV)) && Z_ISREF_P(key)) {
			ZVAL_COPY(&generator->key, Z_REFVAL_P(key));
			zval_ptr_dtor_nogc(free_op2);
		} else {
			ZVAL_COPY_VALUE(&generator->key, key);
			if (IS_VAR == IS_CV) {
				if (Z_OPT_REFCOUNTED_P(key)) Z_ADDREF_P(key);
			}
		}

		if (Z_TYPE(generator->key) == IS_LONG
		    && Z_LVAL(generator->key) > generator->largest_used_integer_key
		) {
			generator->largest_used_integer_key = Z_LVAL(generator->key);
		}
	} else {
		/* If no key was specified we use auto-increment keys */
		generator->largest_used_integer_key++;
		ZVAL_LONG(&generator->key, generator->largest_used_integer_key);
	}

	if (RETURN_VALUE_USED(opline)) {
		/* If the return value of yield is used set the send
		 * target and initialize it to NULL */
		generator->send_target = EX_VAR(opline->result.var);
		ZVAL_NULL(generator->send_target);
	} else {
		generator->send_target = NULL;
	}

	/* We increment to the next op, so we are at the correct position when the
	 * generator is resumed. */
	ZEND_VM_INC_OPCODE();

	/* The GOTO VM uses a local opline variable. We need to set the opline
	 * variable in execute_data so we don't resume at an old position. */
	SAVE_OPLINE();

	ZEND_VM_RETURN();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL zend_binary_assign_op_dim_helper_SPEC_VAR_UNUSED(binary_op_type binary_op ZEND_OPCODE_HANDLER_ARGS_DC)
{
	USE_OPLINE
	zend_free_op free_op1, free_op_data1;
	zval *var_ptr, rv;
	zval *value, *container, *dim;

	SAVE_OPLINE();
	container = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);
	if (IS_VAR == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");
		FREE_UNFETCHED_OP((opline+1)->op1_type, (opline+1)->op1.var);

		HANDLE_EXCEPTION();
	}
	if (IS_VAR == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an array");
		FREE_UNFETCHED_OP((opline+1)->op1_type, (opline+1)->op1.var);

		HANDLE_EXCEPTION();
	}

	dim = NULL;

	do {
		if (IS_VAR == IS_UNUSED || UNEXPECTED(Z_TYPE_P(container) != IS_ARRAY)) {
			if (IS_VAR != IS_UNUSED) {
				ZVAL_DEREF(container);
			}
			if (IS_VAR == IS_UNUSED || EXPECTED(Z_TYPE_P(container) == IS_OBJECT)) {
				value = get_zval_ptr((opline+1)->op1_type, (opline+1)->op1, execute_data, &free_op_data1, BP_VAR_R);
				zend_binary_assign_op_obj_dim(container, dim, value, UNEXPECTED(RETURN_VALUE_USED(opline)) ? EX_VAR(opline->result.var) : NULL, binary_op);
				break;
			}
		}

		zend_fetch_dimension_address_RW(&rv, container, dim, IS_UNUSED);
		value = get_zval_ptr((opline+1)->op1_type, (opline+1)->op1, execute_data, &free_op_data1, BP_VAR_R);
		ZEND_ASSERT(Z_TYPE(rv) == IS_INDIRECT);
		var_ptr = Z_INDIRECT(rv);

		if (UNEXPECTED(var_ptr == NULL)) {
			zend_throw_error(NULL, "Cannot use assign-op operators with overloaded objects nor string offsets");

			FREE_OP(free_op_data1);
			if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
			HANDLE_EXCEPTION();
		}

		if (UNEXPECTED(var_ptr == &EG(error_zval))) {
			if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
				ZVAL_NULL(EX_VAR(opline->result.var));
			}
		} else {
			ZVAL_DEREF(var_ptr);
			SEPARATE_ZVAL_NOREF(var_ptr);

			binary_op(var_ptr, var_ptr, value);

			if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
				ZVAL_COPY(EX_VAR(opline->result.var), var_ptr);
			}
		}
	} while (0);

	FREE_OP(free_op_data1);
	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	ZEND_VM_NEXT_OPCODE_EX(1, 2);
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_ADD_SPEC_VAR_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_UNUSED != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_VAR != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_VAR_UNUSED(add_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_UNUSED(add_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_VAR_UNUSED(add_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_UNUSED(add_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_SUB_SPEC_VAR_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_UNUSED != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_VAR != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_VAR_UNUSED(sub_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_UNUSED(sub_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_VAR_UNUSED(sub_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_UNUSED(sub_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_MUL_SPEC_VAR_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_UNUSED != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_VAR != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_VAR_UNUSED(mul_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_UNUSED(mul_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_VAR_UNUSED(mul_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_UNUSED(mul_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_DIV_SPEC_VAR_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_UNUSED != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_VAR != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_VAR_UNUSED(div_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_UNUSED(div_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_VAR_UNUSED(div_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_UNUSED(div_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_MOD_SPEC_VAR_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_UNUSED != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_VAR != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_VAR_UNUSED(mod_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_UNUSED(mod_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_VAR_UNUSED(mod_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_UNUSED(mod_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_SL_SPEC_VAR_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_UNUSED != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_VAR != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_VAR_UNUSED(shift_left_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_UNUSED(shift_left_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_VAR_UNUSED(shift_left_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_UNUSED(shift_left_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_SR_SPEC_VAR_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_UNUSED != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_VAR != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_VAR_UNUSED(shift_right_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_UNUSED(shift_right_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_VAR_UNUSED(shift_right_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_UNUSED(shift_right_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_CONCAT_SPEC_VAR_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_UNUSED != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_VAR != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_VAR_UNUSED(concat_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_UNUSED(concat_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_VAR_UNUSED(concat_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_UNUSED(concat_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_BW_OR_SPEC_VAR_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_UNUSED != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_VAR != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_VAR_UNUSED(bitwise_or_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_UNUSED(bitwise_or_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_VAR_UNUSED(bitwise_or_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_UNUSED(bitwise_or_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_BW_AND_SPEC_VAR_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_UNUSED != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_VAR != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_VAR_UNUSED(bitwise_and_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_UNUSED(bitwise_and_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_VAR_UNUSED(bitwise_and_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_UNUSED(bitwise_and_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_BW_XOR_SPEC_VAR_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_UNUSED != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_VAR != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_VAR_UNUSED(bitwise_xor_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_UNUSED(bitwise_xor_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_VAR_UNUSED(bitwise_xor_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_UNUSED(bitwise_xor_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_DIM_W_SPEC_VAR_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *container;

	SAVE_OPLINE();
	container = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

	if (IS_VAR == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an array");
		HANDLE_EXCEPTION();
	}
	zend_fetch_dimension_address_W(EX_VAR(opline->result.var), container, NULL, IS_UNUSED);

	if (IS_VAR == IS_VAR && READY_TO_DESTROY(free_op1)) {
		EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 1);
	}
	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_DIM_RW_SPEC_VAR_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *container;

	SAVE_OPLINE();
	container = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

	if (IS_VAR == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an array");
		HANDLE_EXCEPTION();
	}
	zend_fetch_dimension_address_RW(EX_VAR(opline->result.var), container, NULL, IS_UNUSED);

	if (IS_VAR == IS_VAR && READY_TO_DESTROY(free_op1)) {
		EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 1);
	}
	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_DIM_FUNC_ARG_SPEC_VAR_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *container;
	zend_free_op free_op1;

	SAVE_OPLINE();

	if (zend_is_by_ref_func_arg_fetch(opline, EX(call))) {
        if (IS_VAR == IS_CONST || IS_VAR == IS_TMP_VAR) {
            zend_throw_error(NULL, "Cannot use temporary expression in write context");

			zval_ptr_dtor_nogc(EX_VAR(opline->op1.var));
			HANDLE_EXCEPTION();
        }
		container = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);
		if (IS_VAR == IS_VAR && UNEXPECTED(container == NULL)) {
			zend_throw_error(NULL, "Cannot use string offset as an array");

			HANDLE_EXCEPTION();
		}
		zend_fetch_dimension_address_W(EX_VAR(opline->result.var), container, NULL, IS_UNUSED);
		if (IS_VAR == IS_VAR && READY_TO_DESTROY(free_op1)) {
			EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 1);
		}

		if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	} else {
		if (IS_UNUSED == IS_UNUSED) {
			zend_throw_error(NULL, "Cannot use [] for reading");

			zval_ptr_dtor_nogc(EX_VAR(opline->op1.var));
			HANDLE_EXCEPTION();
		}
		container = _get_zval_ptr_var(opline->op1.var, execute_data, &free_op1);
		zend_fetch_dimension_address_read_R(EX_VAR(opline->result.var), container, NULL, IS_UNUSED);

		zval_ptr_dtor_nogc(free_op1);
	}
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_DIM_SPEC_VAR_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *object_ptr;
	zend_free_op free_op_data1;
	zval *value;
	zval *variable_ptr;
	zval *dim;

	SAVE_OPLINE();
	object_ptr = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

	if (IS_VAR == IS_VAR && UNEXPECTED(object_ptr == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an array");
		FREE_UNFETCHED_OP((opline+1)->op1_type, (opline+1)->op1.var);

		HANDLE_EXCEPTION();
	}

	if (EXPECTED(Z_TYPE_P(object_ptr) == IS_ARRAY)) {
try_assign_dim_array:
		if (IS_UNUSED == IS_UNUSED) {
			SEPARATE_ARRAY(object_ptr);
			variable_ptr = zend_hash_next_index_insert(Z_ARRVAL_P(object_ptr), &EG(uninitialized_zval));
			if (UNEXPECTED(variable_ptr == NULL)) {
				zend_error(E_WARNING, "Cannot add element to the array as the next element is already occupied");
				variable_ptr = &EG(error_zval);
			}
		} else {
			dim = NULL;
			SEPARATE_ARRAY(object_ptr);
			variable_ptr = zend_fetch_dimension_address_inner(Z_ARRVAL_P(object_ptr), dim, IS_UNUSED, BP_VAR_W);

		}
		value = get_zval_ptr((opline+1)->op1_type, (opline+1)->op1, execute_data, &free_op_data1, BP_VAR_R);
		if (UNEXPECTED(variable_ptr == &EG(error_zval))) {
			FREE_OP(free_op_data1);
			if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
				ZVAL_NULL(EX_VAR(opline->result.var));
			}
		} else {
			value = zend_assign_to_variable(variable_ptr, value, (opline+1)->op1_type);
			if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
				ZVAL_COPY(EX_VAR(opline->result.var), value);
			}
		}
	} else {
		if (EXPECTED(Z_ISREF_P(object_ptr))) {
			object_ptr = Z_REFVAL_P(object_ptr);
			if (EXPECTED(Z_TYPE_P(object_ptr) == IS_ARRAY)) {
				goto try_assign_dim_array;
			}
		}
		if (EXPECTED(Z_TYPE_P(object_ptr) == IS_OBJECT)) {

			zval *property_name = NULL;

			zend_assign_to_object_dim(UNEXPECTED(RETURN_VALUE_USED(opline)) ? EX_VAR(opline->result.var) : NULL, object_ptr, property_name, (opline+1)->op1_type, (opline+1)->op1, execute_data);

		} else if (EXPECTED(Z_TYPE_P(object_ptr) == IS_STRING)) {
			if (EXPECTED(Z_STRLEN_P(object_ptr) != 0)) {
				if (IS_UNUSED == IS_UNUSED) {
					zend_throw_error(NULL, "[] operator not supported for strings");
					FREE_UNFETCHED_OP((opline+1)->op1_type, (opline+1)->op1.var);
					if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
					HANDLE_EXCEPTION();
				} else {
					zend_long offset;

					dim = NULL;
					offset = zend_fetch_string_offset(object_ptr, dim, BP_VAR_W);

					value = get_zval_ptr_deref((opline+1)->op1_type, (opline+1)->op1, execute_data, &free_op_data1, BP_VAR_R);
					zend_assign_to_string_offset(object_ptr, offset, value, (UNEXPECTED(RETURN_VALUE_USED(opline)) ? EX_VAR(opline->result.var) : NULL));
					FREE_OP(free_op_data1);
				}
			} else {
				zval_ptr_dtor_nogc(object_ptr);
assign_dim_convert_to_array:
				ZVAL_NEW_ARR(object_ptr);
				zend_hash_init(Z_ARRVAL_P(object_ptr), 8, NULL, ZVAL_PTR_DTOR, 0);
				goto try_assign_dim_array;
			}
		} else if (EXPECTED(Z_TYPE_P(object_ptr) <= IS_FALSE)) {
			if (IS_VAR == IS_VAR && UNEXPECTED(object_ptr == &EG(error_zval))) {
				goto assign_dim_clean;
			}
			goto assign_dim_convert_to_array;
		} else {
			zend_error(E_WARNING, "Cannot use a scalar value as an array");
assign_dim_clean:
			dim = NULL;

			value = get_zval_ptr((opline+1)->op1_type, (opline+1)->op1, execute_data, &free_op_data1, BP_VAR_R);
			FREE_OP(free_op_data1);
			if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
				ZVAL_NULL(EX_VAR(opline->result.var));
			}
		}
	}
 	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	/* assign_dim has two opcodes! */
	ZEND_VM_NEXT_OPCODE_EX(1, 2);
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_INIT_STATIC_METHOD_CALL_SPEC_VAR_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *function_name;
	zend_class_entry *ce;
	zend_object *object;
	zend_function *fbc;
	zend_execute_data *call;

	SAVE_OPLINE();

	if (IS_VAR == IS_CONST) {
		/* no function found. try a static method in class */
		if (EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1))))) {
			ce = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)));
		} else {
			ce = zend_fetch_class_by_name(Z_STR_P(EX_CONSTANT(opline->op1)), EX_CONSTANT(opline->op1) + 1, ZEND_FETCH_CLASS_DEFAULT |  ZEND_FETCH_CLASS_EXCEPTION);
			if (UNEXPECTED(EG(exception) != NULL)) {
				HANDLE_EXCEPTION();
			}
			if (UNEXPECTED(ce == NULL)) {
				zend_throw_error(NULL, "Class '%s' not found", Z_STRVAL_P(EX_CONSTANT(opline->op1)));
				HANDLE_EXCEPTION();
			}
			CACHE_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)), ce);
		}
	} else {
		ce = Z_CE_P(EX_VAR(opline->op1.var));
	}

	if (IS_VAR == IS_CONST &&
	    IS_UNUSED == IS_CONST &&
	    EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2))))) {
		fbc = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)));
	} else if (IS_VAR != IS_CONST &&
	           IS_UNUSED == IS_CONST &&
	           (fbc = CACHED_POLYMORPHIC_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)), ce))) {
		/* do nothing */
	} else if (IS_UNUSED != IS_UNUSED) {


		function_name = NULL;
		if (IS_UNUSED != IS_CONST) {
			if (UNEXPECTED(Z_TYPE_P(function_name) != IS_STRING)) {
				if (IS_UNUSED == IS_CV && UNEXPECTED(Z_TYPE_P(function_name) == IS_UNDEF)) {
					GET_OP2_UNDEF_CV(function_name, BP_VAR_R);
				}
				if (UNEXPECTED(EG(exception) != NULL)) {
					HANDLE_EXCEPTION();
				}
				zend_throw_error(NULL, "Function name must be a string");

				HANDLE_EXCEPTION();
 			}
		}

		if (ce->get_static_method) {
			fbc = ce->get_static_method(ce, Z_STR_P(function_name));
		} else {
			fbc = zend_std_get_static_method(ce, Z_STR_P(function_name), ((IS_UNUSED == IS_CONST) ? (EX_CONSTANT(opline->op2) + 1) : NULL));
		}
		if (UNEXPECTED(fbc == NULL)) {
			if (EXPECTED(!EG(exception))) {
				zend_throw_error(NULL, "Call to undefined method %s::%s()", ZSTR_VAL(ce->name), Z_STRVAL_P(function_name));
			}

			HANDLE_EXCEPTION();
		}
		if (IS_UNUSED == IS_CONST &&
		    EXPECTED(fbc->type <= ZEND_USER_FUNCTION) &&
		    EXPECTED(!(fbc->common.fn_flags & (ZEND_ACC_CALL_VIA_TRAMPOLINE|ZEND_ACC_NEVER_CACHE)))) {
			if (IS_VAR == IS_CONST) {
				CACHE_PTR(Z_CACHE_SLOT_P(function_name), fbc);
			} else {
				CACHE_POLYMORPHIC_PTR(Z_CACHE_SLOT_P(function_name), ce, fbc);
			}
		}
		if (IS_UNUSED != IS_CONST) {

		}
	} else {
		if (UNEXPECTED(ce->constructor == NULL)) {
			zend_throw_error(NULL, "Cannot call constructor");
			HANDLE_EXCEPTION();
		}
		if (Z_OBJ(EX(This)) && Z_OBJ(EX(This))->ce != ce->constructor->common.scope && (ce->constructor->common.fn_flags & ZEND_ACC_PRIVATE)) {
			zend_throw_error(NULL, "Cannot call private %s::__construct()", ZSTR_VAL(ce->name));
			HANDLE_EXCEPTION();
		}
		fbc = ce->constructor;
	}

	object = NULL;
	if (!(fbc->common.fn_flags & ZEND_ACC_STATIC)) {
		if (Z_OBJ(EX(This)) && instanceof_function(Z_OBJCE(EX(This)), ce)) {
			object = Z_OBJ(EX(This));
		}
		if (!object) {
			if (fbc->common.fn_flags & ZEND_ACC_ALLOW_STATIC) {
				/* Allowed for PHP 4 compatibility. */
				zend_error(
					E_DEPRECATED,
					"Non-static method %s::%s() should not be called statically",
					ZSTR_VAL(fbc->common.scope->name), ZSTR_VAL(fbc->common.function_name));
				if (UNEXPECTED(EG(exception) != NULL)) {
					HANDLE_EXCEPTION();
				}
			} else {
				/* An internal function assumes $this is present and won't check that.
				 * So PHP would crash by allowing the call. */
				zend_throw_error(
					zend_ce_error,
					"Non-static method %s::%s() cannot be called statically",
					ZSTR_VAL(fbc->common.scope->name), ZSTR_VAL(fbc->common.function_name));
				HANDLE_EXCEPTION();
			}
		}
	}

	if (IS_VAR != IS_CONST) {
		/* previous opcode is ZEND_FETCH_CLASS */
		if (((opline-1)->extended_value & ZEND_FETCH_CLASS_MASK) == ZEND_FETCH_CLASS_PARENT ||
		    ((opline-1)->extended_value & ZEND_FETCH_CLASS_MASK) == ZEND_FETCH_CLASS_SELF) {
			ce = EX(called_scope);
		}
	}

	call = zend_vm_stack_push_call_frame(ZEND_CALL_NESTED_FUNCTION,
		fbc, opline->extended_value, ce, object);
	call->prev_execute_data = EX(call);
	EX(call) = call;

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_VERIFY_RETURN_TYPE_SPEC_VAR_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	SAVE_OPLINE();
	if (IS_VAR == IS_UNUSED) {
		zend_verify_missing_return_type(EX(func), CACHE_ADDR(opline->op2.num));
	} else {
/* prevents "undefined variable opline" errors */
#if 0 || (IS_VAR != IS_UNUSED)
		zval *retval_ref, *retval_ptr;
		zend_free_op free_op1;
		zend_arg_info *ret_info = EX(func)->common.arg_info - 1;

		retval_ref = retval_ptr = _get_zval_ptr_var(opline->op1.var, execute_data, &free_op1);

		if (IS_VAR == IS_CONST) {
			ZVAL_COPY(EX_VAR(opline->result.var), retval_ptr);
			retval_ref = retval_ptr = EX_VAR(opline->result.var);
		} else if (IS_VAR == IS_VAR) {
			if (UNEXPECTED(Z_TYPE_P(retval_ptr) == IS_INDIRECT)) {
				retval_ptr = Z_INDIRECT_P(retval_ptr);
			}
			ZVAL_DEREF(retval_ptr);
		} else if (IS_VAR == IS_CV) {
			ZVAL_DEREF(retval_ptr);
		}

		if (UNEXPECTED(!ret_info->class_name
			&& ret_info->type_hint != IS_CALLABLE
			&& !ZEND_SAME_FAKE_TYPE(ret_info->type_hint, Z_TYPE_P(retval_ptr))
			&& !(EX(func)->op_array.fn_flags & ZEND_ACC_RETURN_REFERENCE)
			&& retval_ref != retval_ptr)
		) {
			/* A cast might happen - unwrap the reference if this is a by-value return */
			if (Z_REFCOUNT_P(retval_ref) == 1) {
				ZVAL_UNREF(retval_ref);
			} else {
				Z_DELREF_P(retval_ref);
				ZVAL_COPY(retval_ref, retval_ptr);
			}
			retval_ptr = retval_ref;
		}
		zend_verify_return_type(EX(func), retval_ptr, CACHE_ADDR(opline->op2.num));

		if (UNEXPECTED(EG(exception) != NULL)) {
			zval_ptr_dtor_nogc(free_op1);
		}
#endif
	}
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ADD_ARRAY_ELEMENT_SPEC_VAR_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *expr_ptr, new_expr;

	SAVE_OPLINE();
	if ((IS_VAR == IS_VAR || IS_VAR == IS_CV) &&
	    UNEXPECTED(opline->extended_value & ZEND_ARRAY_ELEMENT_REF)) {
		expr_ptr = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);
		if (IS_VAR == IS_VAR && UNEXPECTED(expr_ptr == NULL)) {
			zend_throw_error(NULL, "Cannot create references to/from string offsets");
			zend_array_destroy(Z_ARRVAL_P(EX_VAR(opline->result.var)));
			HANDLE_EXCEPTION();
		}
		ZVAL_MAKE_REF(expr_ptr);
		Z_ADDREF_P(expr_ptr);
		if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	} else {
		expr_ptr = _get_zval_ptr_var(opline->op1.var, execute_data, &free_op1);
		if (IS_VAR == IS_TMP_VAR) {
			/* pass */
		} else if (IS_VAR == IS_CONST) {
			if (UNEXPECTED(Z_OPT_COPYABLE_P(expr_ptr))) {
				ZVAL_COPY_VALUE(&new_expr, expr_ptr);
				zval_copy_ctor_func(&new_expr);
				expr_ptr = &new_expr;
			}
		} else if (IS_VAR == IS_CV) {
			ZVAL_DEREF(expr_ptr);
			if (Z_REFCOUNTED_P(expr_ptr)) {
				Z_ADDREF_P(expr_ptr);
			}
		} else /* if (IS_VAR == IS_VAR) */ {
			if (UNEXPECTED(Z_ISREF_P(expr_ptr))) {
				zend_refcounted *ref = Z_COUNTED_P(expr_ptr);

				expr_ptr = Z_REFVAL_P(expr_ptr);
				if (UNEXPECTED(--GC_REFCOUNT(ref) == 0)) {
					ZVAL_COPY_VALUE(&new_expr, expr_ptr);
					expr_ptr = &new_expr;
					efree_size(ref, sizeof(zend_reference));
				} else if (Z_OPT_REFCOUNTED_P(expr_ptr)) {
					Z_ADDREF_P(expr_ptr);
				}
			}
		}
	}

	if (IS_UNUSED != IS_UNUSED) {

		zval *offset = NULL;
		zend_string *str;
		zend_ulong hval;

add_again:
		if (EXPECTED(Z_TYPE_P(offset) == IS_STRING)) {
			str = Z_STR_P(offset);
			if (IS_UNUSED != IS_CONST) {
				if (ZEND_HANDLE_NUMERIC(str, hval)) {
					goto num_index;
				}
			}
str_index:
			zend_hash_update(Z_ARRVAL_P(EX_VAR(opline->result.var)), str, expr_ptr);
		} else if (EXPECTED(Z_TYPE_P(offset) == IS_LONG)) {
			hval = Z_LVAL_P(offset);
num_index:
			zend_hash_index_update(Z_ARRVAL_P(EX_VAR(opline->result.var)), hval, expr_ptr);
		} else if ((IS_UNUSED & (IS_VAR|IS_CV)) && EXPECTED(Z_TYPE_P(offset) == IS_REFERENCE)) {
			offset = Z_REFVAL_P(offset);
			goto add_again;
		} else if (Z_TYPE_P(offset) == IS_NULL) {
			str = ZSTR_EMPTY_ALLOC();
			goto str_index;
		} else if (Z_TYPE_P(offset) == IS_DOUBLE) {
			hval = zend_dval_to_lval(Z_DVAL_P(offset));
			goto num_index;
		} else if (Z_TYPE_P(offset) == IS_FALSE) {
			hval = 0;
			goto num_index;
		} else if (Z_TYPE_P(offset) == IS_TRUE) {
			hval = 1;
			goto num_index;
		} else if (IS_UNUSED == IS_CV && Z_TYPE_P(offset) == IS_UNDEF) {
			GET_OP2_UNDEF_CV(offset, BP_VAR_R);
			str = ZSTR_EMPTY_ALLOC();
			goto str_index;
		} else {
			zend_error(E_WARNING, "Illegal offset type");
			zval_ptr_dtor(expr_ptr);
		}

	} else {
		zend_hash_next_index_insert(Z_ARRVAL_P(EX_VAR(opline->result.var)), expr_ptr);
	}
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_INIT_ARRAY_SPEC_VAR_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	zval *array;
	uint32_t size;
	USE_OPLINE

	array = EX_VAR(opline->result.var);
	if (IS_VAR != IS_UNUSED) {
		size = opline->extended_value >> ZEND_ARRAY_SIZE_SHIFT;
	} else {
		size = 0;
	}
	ZVAL_NEW_ARR(array);
	zend_hash_init(Z_ARRVAL_P(array), size, NULL, ZVAL_PTR_DTOR, 0);

	if (IS_VAR != IS_UNUSED) {
		/* Explicitly initialize array as not-packed if flag is set */
		if (opline->extended_value & ZEND_ARRAY_NOT_PACKED) {
			zend_hash_real_init(Z_ARRVAL_P(array), 0);
		}
	}

	if (IS_VAR == IS_UNUSED) {
		ZEND_VM_NEXT_OPCODE();
#if 0 || (IS_VAR != IS_UNUSED)
	} else {
		ZEND_VM_TAIL_CALL(ZEND_ADD_ARRAY_ELEMENT_SPEC_VAR_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS_PASSTHRU));
#endif
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_SEPARATE_SPEC_VAR_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *var_ptr;

	var_ptr = EX_VAR(opline->op1.var);
	if (Z_TYPE_P(var_ptr) != IS_OBJECT &&
	    !Z_ISREF_P(var_ptr) &&
	    Z_REFCOUNTED_P(var_ptr) &&
	    Z_REFCOUNT_P(var_ptr) > 1) {

		Z_DELREF_P(var_ptr);
		ZVAL_DUP(EX_VAR(opline->op1.var), var_ptr);
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_YIELD_SPEC_VAR_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zend_generator *generator = zend_get_running_generator(execute_data);

	SAVE_OPLINE();
	if (UNEXPECTED(generator->flags & ZEND_GENERATOR_FORCED_CLOSE)) {
		zend_throw_error(NULL, "Cannot yield from finally in a force-closed generator");

		zval_ptr_dtor_nogc(EX_VAR(opline->op1.var));
		HANDLE_EXCEPTION();
	}

	/* Destroy the previously yielded value */
	zval_ptr_dtor(&generator->value);

	/* Destroy the previously yielded key */
	zval_ptr_dtor(&generator->key);

	/* Set the new yielded value */
	if (IS_VAR != IS_UNUSED) {
		zend_free_op free_op1;

		if (UNEXPECTED(EX(func)->op_array.fn_flags & ZEND_ACC_RETURN_REFERENCE)) {
			/* Constants and temporary variables aren't yieldable by reference,
			 * but we still allow them with a notice. */
			if (IS_VAR == IS_CONST || IS_VAR == IS_TMP_VAR) {
				zval *value;

				zend_error(E_NOTICE, "Only variable references should be yielded by reference");

				value = _get_zval_ptr_var(opline->op1.var, execute_data, &free_op1);
				ZVAL_COPY_VALUE(&generator->value, value);
				if (IS_VAR != IS_CONST) {
					if (UNEXPECTED(Z_OPT_COPYABLE(generator->value))) {
						zval_copy_ctor_func(&generator->value);
					}
				}
			} else {
				zval *value_ptr = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

				if (IS_VAR == IS_VAR && UNEXPECTED(value_ptr == NULL)) {
					zend_throw_error(NULL, "Cannot yield string offsets by reference");

					HANDLE_EXCEPTION();
				}

				/* If a function call result is yielded and the function did
				 * not return by reference we throw a notice. */
				if (IS_VAR == IS_VAR &&
				    (value_ptr == &EG(uninitialized_zval) ||
				     (opline->extended_value == ZEND_RETURNS_FUNCTION &&
				      !(Z_VAR_FLAGS_P(value_ptr) & IS_VAR_RET_REF)))) {
					zend_error(E_NOTICE, "Only variable references should be yielded by reference");
				} else {
					ZVAL_MAKE_REF(value_ptr);
				}
				ZVAL_COPY(&generator->value, value_ptr);

				if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
			}
		} else {
			zval *value = _get_zval_ptr_var(opline->op1.var, execute_data, &free_op1);

			/* Consts, temporary variables and references need copying */
			if (IS_VAR == IS_CONST) {
				ZVAL_COPY_VALUE(&generator->value, value);
				if (UNEXPECTED(Z_OPT_COPYABLE(generator->value))) {
					zval_copy_ctor_func(&generator->value);
				}
			} else if (IS_VAR == IS_TMP_VAR) {
				ZVAL_COPY_VALUE(&generator->value, value);
            } else if ((IS_VAR & (IS_VAR|IS_CV)) && Z_ISREF_P(value)) {
				ZVAL_COPY(&generator->value, Z_REFVAL_P(value));
				zval_ptr_dtor_nogc(free_op1);
			} else {
				ZVAL_COPY_VALUE(&generator->value, value);
				if (IS_VAR == IS_CV) {
					if (Z_OPT_REFCOUNTED_P(value)) Z_ADDREF_P(value);
				}
			}
		}
	} else {
		/* If no value was specified yield null */
		ZVAL_NULL(&generator->value);
	}

	/* Set the new yielded key */
	if (IS_UNUSED != IS_UNUSED) {

		zval *key = NULL;

		/* Consts, temporary variables and references need copying */
		if (IS_UNUSED == IS_CONST) {
			ZVAL_COPY_VALUE(&generator->key, key);
			if (UNEXPECTED(Z_OPT_COPYABLE(generator->key))) {
				zval_copy_ctor_func(&generator->key);
			}
		} else if (IS_UNUSED == IS_TMP_VAR) {
			ZVAL_COPY_VALUE(&generator->key, key);
		} else if ((IS_UNUSED & (IS_VAR|IS_CV)) && Z_ISREF_P(key)) {
			ZVAL_COPY(&generator->key, Z_REFVAL_P(key));

		} else {
			ZVAL_COPY_VALUE(&generator->key, key);
			if (IS_UNUSED == IS_CV) {
				if (Z_OPT_REFCOUNTED_P(key)) Z_ADDREF_P(key);
			}
		}

		if (Z_TYPE(generator->key) == IS_LONG
		    && Z_LVAL(generator->key) > generator->largest_used_integer_key
		) {
			generator->largest_used_integer_key = Z_LVAL(generator->key);
		}
	} else {
		/* If no key was specified we use auto-increment keys */
		generator->largest_used_integer_key++;
		ZVAL_LONG(&generator->key, generator->largest_used_integer_key);
	}

	if (RETURN_VALUE_USED(opline)) {
		/* If the return value of yield is used set the send
		 * target and initialize it to NULL */
		generator->send_target = EX_VAR(opline->result.var);
		ZVAL_NULL(generator->send_target);
	} else {
		generator->send_target = NULL;
	}

	/* We increment to the next op, so we are at the correct position when the
	 * generator is resumed. */
	ZEND_VM_INC_OPCODE();

	/* The GOTO VM uses a local opline variable. We need to set the opline
	 * variable in execute_data so we don't resume at an old position. */
	SAVE_OPLINE();

	ZEND_VM_RETURN();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_IS_IDENTICAL_SPEC_VAR_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *op1, *op2;
	int result;

	SAVE_OPLINE();
	op1 = _get_zval_ptr_var_deref(opline->op1.var, execute_data, &free_op1);
	op2 = _get_zval_ptr_cv_deref_BP_VAR_R(execute_data, opline->op2.var);
	result = fast_is_identical_function(op1, op2);
	zval_ptr_dtor_nogc(free_op1);

	ZEND_VM_SMART_BRANCH(result, (IS_VAR|IS_CV) & (IS_VAR|IS_TMP_VAR));
	ZVAL_BOOL(EX_VAR(opline->result.var), result);
	if ((IS_VAR|IS_CV) & (IS_VAR|IS_TMP_VAR)) {
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_IS_NOT_IDENTICAL_SPEC_VAR_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *op1, *op2;
	int result;

	SAVE_OPLINE();
	op1 = _get_zval_ptr_var_deref(opline->op1.var, execute_data, &free_op1);
	op2 = _get_zval_ptr_cv_deref_BP_VAR_R(execute_data, opline->op2.var);
	result = fast_is_not_identical_function(op1, op2);
	zval_ptr_dtor_nogc(free_op1);

	ZEND_VM_SMART_BRANCH(result, (IS_VAR|IS_CV) & (IS_VAR|IS_TMP_VAR));
	ZVAL_BOOL(EX_VAR(opline->result.var), result);
	if ((IS_VAR|IS_CV) & (IS_VAR|IS_TMP_VAR)) {
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL zend_binary_assign_op_obj_helper_SPEC_VAR_CV(binary_op_type binary_op ZEND_OPCODE_HANDLER_ARGS_DC)
{
	USE_OPLINE
	zend_free_op free_op1, free_op_data1;
	zval *object;
	zval *property;
	zval *value;
	zval *zptr;

	SAVE_OPLINE();
	object = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

	if (IS_VAR == IS_UNUSED && UNEXPECTED(Z_OBJ_P(object) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");
		FREE_UNFETCHED_OP((opline+1)->op1_type, (opline+1)->op1.var);

		HANDLE_EXCEPTION();
	}

	property = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);

	if (IS_VAR == IS_VAR && UNEXPECTED(object == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an object");
		FREE_UNFETCHED_OP((opline+1)->op1_type, (opline+1)->op1.var);

		HANDLE_EXCEPTION();
	}

	do {
		value = get_zval_ptr((opline+1)->op1_type, (opline+1)->op1, execute_data, &free_op_data1, BP_VAR_R);

		if (IS_VAR != IS_UNUSED && UNEXPECTED(Z_TYPE_P(object) != IS_OBJECT)) {
			ZVAL_DEREF(object);
			if (UNEXPECTED(!make_real_object(object))) {
				zend_error(E_WARNING, "Attempt to assign property of non-object");
				if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
					ZVAL_NULL(EX_VAR(opline->result.var));
				}
				break;
			}
		}

		/* here we are sure we are dealing with an object */
		if (EXPECTED(Z_OBJ_HT_P(object)->get_property_ptr_ptr)
			&& EXPECTED((zptr = Z_OBJ_HT_P(object)->get_property_ptr_ptr(object, property, BP_VAR_RW, ((IS_CV == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL))) != NULL)) {

			ZVAL_DEREF(zptr);
			SEPARATE_ZVAL_NOREF(zptr);

			binary_op(zptr, zptr, value);
			if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
				ZVAL_COPY(EX_VAR(opline->result.var), zptr);
			}
		} else {
			zend_assign_op_overloaded_property(object, property, ((IS_CV == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), value, binary_op, (UNEXPECTED(RETURN_VALUE_USED(opline)) ? EX_VAR(opline->result.var) : NULL));
		}
	} while (0);

	FREE_OP(free_op_data1);

	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	/* assign_obj has two opcodes! */
	ZEND_VM_NEXT_OPCODE_EX(1, 2);
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL zend_binary_assign_op_dim_helper_SPEC_VAR_CV(binary_op_type binary_op ZEND_OPCODE_HANDLER_ARGS_DC)
{
	USE_OPLINE
	zend_free_op free_op1, free_op_data1;
	zval *var_ptr, rv;
	zval *value, *container, *dim;

	SAVE_OPLINE();
	container = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);
	if (IS_VAR == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");
		FREE_UNFETCHED_OP((opline+1)->op1_type, (opline+1)->op1.var);

		HANDLE_EXCEPTION();
	}
	if (IS_VAR == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an array");
		FREE_UNFETCHED_OP((opline+1)->op1_type, (opline+1)->op1.var);

		HANDLE_EXCEPTION();
	}

	dim = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);

	do {
		if (IS_VAR == IS_UNUSED || UNEXPECTED(Z_TYPE_P(container) != IS_ARRAY)) {
			if (IS_VAR != IS_UNUSED) {
				ZVAL_DEREF(container);
			}
			if (IS_VAR == IS_UNUSED || EXPECTED(Z_TYPE_P(container) == IS_OBJECT)) {
				value = get_zval_ptr((opline+1)->op1_type, (opline+1)->op1, execute_data, &free_op_data1, BP_VAR_R);
				zend_binary_assign_op_obj_dim(container, dim, value, UNEXPECTED(RETURN_VALUE_USED(opline)) ? EX_VAR(opline->result.var) : NULL, binary_op);
				break;
			}
		}

		zend_fetch_dimension_address_RW(&rv, container, dim, IS_CV);
		value = get_zval_ptr((opline+1)->op1_type, (opline+1)->op1, execute_data, &free_op_data1, BP_VAR_R);
		ZEND_ASSERT(Z_TYPE(rv) == IS_INDIRECT);
		var_ptr = Z_INDIRECT(rv);

		if (UNEXPECTED(var_ptr == NULL)) {
			zend_throw_error(NULL, "Cannot use assign-op operators with overloaded objects nor string offsets");

			FREE_OP(free_op_data1);
			if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
			HANDLE_EXCEPTION();
		}

		if (UNEXPECTED(var_ptr == &EG(error_zval))) {
			if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
				ZVAL_NULL(EX_VAR(opline->result.var));
			}
		} else {
			ZVAL_DEREF(var_ptr);
			SEPARATE_ZVAL_NOREF(var_ptr);

			binary_op(var_ptr, var_ptr, value);

			if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
				ZVAL_COPY(EX_VAR(opline->result.var), var_ptr);
			}
		}
	} while (0);

	FREE_OP(free_op_data1);
	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	ZEND_VM_NEXT_OPCODE_EX(1, 2);
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL zend_binary_assign_op_helper_SPEC_VAR_CV(binary_op_type binary_op ZEND_OPCODE_HANDLER_ARGS_DC)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *var_ptr;
	zval *value;

	SAVE_OPLINE();
	value = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);
	var_ptr = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

	if (IS_VAR == IS_VAR && UNEXPECTED(var_ptr == NULL)) {
		zend_throw_error(NULL, "Cannot use assign-op operators with overloaded objects nor string offsets");

		HANDLE_EXCEPTION();
	}

	if (IS_VAR == IS_VAR && UNEXPECTED(var_ptr == &EG(error_zval))) {
		if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
			ZVAL_NULL(EX_VAR(opline->result.var));
		}
	} else {
		ZVAL_DEREF(var_ptr);
		SEPARATE_ZVAL_NOREF(var_ptr);

		binary_op(var_ptr, var_ptr, value);

		if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
			ZVAL_COPY(EX_VAR(opline->result.var), var_ptr);
		}
	}

	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_ADD_SPEC_VAR_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CV != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_VAR != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_VAR_CV(add_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_CV(add_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_VAR_CV(add_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_CV(add_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_SUB_SPEC_VAR_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CV != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_VAR != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_VAR_CV(sub_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_CV(sub_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_VAR_CV(sub_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_CV(sub_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_MUL_SPEC_VAR_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CV != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_VAR != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_VAR_CV(mul_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_CV(mul_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_VAR_CV(mul_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_CV(mul_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_DIV_SPEC_VAR_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CV != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_VAR != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_VAR_CV(div_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_CV(div_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_VAR_CV(div_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_CV(div_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_MOD_SPEC_VAR_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CV != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_VAR != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_VAR_CV(mod_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_CV(mod_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_VAR_CV(mod_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_CV(mod_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_SL_SPEC_VAR_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CV != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_VAR != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_VAR_CV(shift_left_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_CV(shift_left_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_VAR_CV(shift_left_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_CV(shift_left_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_SR_SPEC_VAR_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CV != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_VAR != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_VAR_CV(shift_right_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_CV(shift_right_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_VAR_CV(shift_right_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_CV(shift_right_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_CONCAT_SPEC_VAR_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CV != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_VAR != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_VAR_CV(concat_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_CV(concat_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_VAR_CV(concat_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_CV(concat_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_BW_OR_SPEC_VAR_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CV != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_VAR != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_VAR_CV(bitwise_or_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_CV(bitwise_or_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_VAR_CV(bitwise_or_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_CV(bitwise_or_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_BW_AND_SPEC_VAR_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CV != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_VAR != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_VAR_CV(bitwise_and_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_CV(bitwise_and_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_VAR_CV(bitwise_and_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_CV(bitwise_and_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_BW_XOR_SPEC_VAR_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CV != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_VAR != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_VAR_CV(bitwise_xor_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_CV(bitwise_xor_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_VAR_CV(bitwise_xor_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_CV(bitwise_xor_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL zend_pre_incdec_property_helper_SPEC_VAR_CV(int inc ZEND_OPCODE_HANDLER_ARGS_DC)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *object;
	zval *property;
	zval *zptr;

	SAVE_OPLINE();
	object = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

	if (IS_VAR == IS_UNUSED && UNEXPECTED(Z_OBJ_P(object) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}

	property = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);

	if (IS_VAR == IS_VAR && UNEXPECTED(object == NULL)) {
		zend_throw_error(NULL, "Cannot increment/decrement overloaded objects nor string offsets");

		HANDLE_EXCEPTION();
	}

	do {
		if (IS_VAR != IS_UNUSED && UNEXPECTED(Z_TYPE_P(object) != IS_OBJECT)) {
			ZVAL_DEREF(object);
			if (UNEXPECTED(!make_real_object(object))) {
				zend_error(E_WARNING, "Attempt to increment/decrement property of non-object");
				if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
					ZVAL_NULL(EX_VAR(opline->result.var));
				}
				break;
			}
		}

		/* here we are sure we are dealing with an object */

		if (EXPECTED(Z_OBJ_HT_P(object)->get_property_ptr_ptr)
			&& EXPECTED((zptr = Z_OBJ_HT_P(object)->get_property_ptr_ptr(object, property, BP_VAR_RW, ((IS_CV == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL))) != NULL)) {

			if (EXPECTED(Z_TYPE_P(zptr) == IS_LONG)) {
				if (inc) {
					fast_long_increment_function(zptr);
				} else {
					fast_long_decrement_function(zptr);
				}
			} else {
				ZVAL_DEREF(zptr);
				SEPARATE_ZVAL_NOREF(zptr);

				if (inc) {
					increment_function(zptr);
				} else {
					decrement_function(zptr);
				}
			}
			if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
				ZVAL_COPY(EX_VAR(opline->result.var), zptr);
			}
		} else {
			zend_pre_incdec_overloaded_property(object, property, ((IS_CV == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), inc, (UNEXPECTED(RETURN_VALUE_USED(opline)) ? EX_VAR(opline->result.var) : NULL));
		}
	} while (0);

	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_PRE_INC_OBJ_SPEC_VAR_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	ZEND_VM_TAIL_CALL(zend_pre_incdec_property_helper_SPEC_VAR_CV(1 ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_PRE_DEC_OBJ_SPEC_VAR_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	ZEND_VM_TAIL_CALL(zend_pre_incdec_property_helper_SPEC_VAR_CV(0 ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL zend_post_incdec_property_helper_SPEC_VAR_CV(int inc ZEND_OPCODE_HANDLER_ARGS_DC)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *object;
	zval *property;
	zval *zptr;

	SAVE_OPLINE();
	object = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

	if (IS_VAR == IS_UNUSED && UNEXPECTED(Z_OBJ_P(object) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}

	property = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);

	if (IS_VAR == IS_VAR && UNEXPECTED(object == NULL)) {
		zend_throw_error(NULL, "Cannot increment/decrement overloaded objects nor string offsets");

		HANDLE_EXCEPTION();
	}

	do {
		if (IS_VAR != IS_UNUSED && UNEXPECTED(Z_TYPE_P(object) != IS_OBJECT)) {
			ZVAL_DEREF(object);
			if (UNEXPECTED(!make_real_object(object))) {
				zend_error(E_WARNING, "Attempt to increment/decrement property of non-object");
				ZVAL_NULL(EX_VAR(opline->result.var));
				break;
			}
		}

		/* here we are sure we are dealing with an object */

		if (EXPECTED(Z_OBJ_HT_P(object)->get_property_ptr_ptr)
			&& EXPECTED((zptr = Z_OBJ_HT_P(object)->get_property_ptr_ptr(object, property, BP_VAR_RW, ((IS_CV == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL))) != NULL)) {

			if (EXPECTED(Z_TYPE_P(zptr) == IS_LONG)) {
				ZVAL_COPY_VALUE(EX_VAR(opline->result.var), zptr);
				if (inc) {
					fast_long_increment_function(zptr);
				} else {
					fast_long_decrement_function(zptr);
				}
			} else {
				ZVAL_DEREF(zptr);
				ZVAL_COPY_VALUE(EX_VAR(opline->result.var), zptr);
				zval_opt_copy_ctor(zptr);
				if (inc) {
					increment_function(zptr);
				} else {
					decrement_function(zptr);
				}
			}
		} else {
			zend_post_incdec_overloaded_property(object, property, ((IS_CV == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), inc, EX_VAR(opline->result.var));
		}
	} while (0);

	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_POST_INC_OBJ_SPEC_VAR_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	ZEND_VM_TAIL_CALL(zend_post_incdec_property_helper_SPEC_VAR_CV(1 ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_POST_DEC_OBJ_SPEC_VAR_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	ZEND_VM_TAIL_CALL(zend_post_incdec_property_helper_SPEC_VAR_CV(0 ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_DIM_W_SPEC_VAR_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *container;

	SAVE_OPLINE();
	container = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

	if (IS_VAR == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an array");
		HANDLE_EXCEPTION();
	}
	zend_fetch_dimension_address_W(EX_VAR(opline->result.var), container, _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var), IS_CV);

	if (IS_VAR == IS_VAR && READY_TO_DESTROY(free_op1)) {
		EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 1);
	}
	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_DIM_RW_SPEC_VAR_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *container;

	SAVE_OPLINE();
	container = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

	if (IS_VAR == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an array");
		HANDLE_EXCEPTION();
	}
	zend_fetch_dimension_address_RW(EX_VAR(opline->result.var), container, _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var), IS_CV);

	if (IS_VAR == IS_VAR && READY_TO_DESTROY(free_op1)) {
		EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 1);
	}
	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_DIM_FUNC_ARG_SPEC_VAR_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *container;
	zend_free_op free_op1;

	SAVE_OPLINE();

	if (zend_is_by_ref_func_arg_fetch(opline, EX(call))) {
        if (IS_VAR == IS_CONST || IS_VAR == IS_TMP_VAR) {
            zend_throw_error(NULL, "Cannot use temporary expression in write context");

			zval_ptr_dtor_nogc(EX_VAR(opline->op1.var));
			HANDLE_EXCEPTION();
        }
		container = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);
		if (IS_VAR == IS_VAR && UNEXPECTED(container == NULL)) {
			zend_throw_error(NULL, "Cannot use string offset as an array");

			HANDLE_EXCEPTION();
		}
		zend_fetch_dimension_address_W(EX_VAR(opline->result.var), container, _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var), IS_CV);
		if (IS_VAR == IS_VAR && READY_TO_DESTROY(free_op1)) {
			EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 1);
		}

		if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	} else {
		if (IS_CV == IS_UNUSED) {
			zend_throw_error(NULL, "Cannot use [] for reading");

			zval_ptr_dtor_nogc(EX_VAR(opline->op1.var));
			HANDLE_EXCEPTION();
		}
		container = _get_zval_ptr_var(opline->op1.var, execute_data, &free_op1);
		zend_fetch_dimension_address_read_R(EX_VAR(opline->result.var), container, _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var), IS_CV);

		zval_ptr_dtor_nogc(free_op1);
	}
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_DIM_UNSET_SPEC_VAR_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *container;

	SAVE_OPLINE();
	container = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

	if (IS_VAR == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an array");

		HANDLE_EXCEPTION();
	}
	zend_fetch_dimension_address_UNSET(EX_VAR(opline->result.var), container, _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var), IS_CV);

	if (IS_VAR == IS_VAR && READY_TO_DESTROY(free_op1)) {
		EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 1);
	}
	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_R_SPEC_VAR_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *container;

	zval *offset;

	SAVE_OPLINE();
	container = _get_zval_ptr_var(opline->op1.var, execute_data, &free_op1);

	if (IS_VAR == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}

	offset = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);

	if (IS_VAR == IS_CONST ||
	    (IS_VAR != IS_UNUSED && UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT))) {
		if ((IS_VAR & (IS_VAR|IS_CV)) && Z_ISREF_P(container)) {
			container = Z_REFVAL_P(container);
			if (UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT)) {
				goto fetch_obj_r_no_object;
			}
		} else {
			goto fetch_obj_r_no_object;
		}
	}

	/* here we are sure we are dealing with an object */
	do {
		zend_object *zobj = Z_OBJ_P(container);
		zval *retval;

		if (IS_CV == IS_CONST &&
			EXPECTED(zobj->ce == CACHED_PTR(Z_CACHE_SLOT_P(offset)))) {
			uint32_t prop_offset = (uint32_t)(intptr_t)CACHED_PTR(Z_CACHE_SLOT_P(offset) + sizeof(void*));

			if (EXPECTED(prop_offset != (uint32_t)ZEND_DYNAMIC_PROPERTY_OFFSET)) {
				retval = OBJ_PROP(zobj, prop_offset);
				if (EXPECTED(Z_TYPE_P(retval) != IS_UNDEF)) {
					ZVAL_COPY(EX_VAR(opline->result.var), retval);
					break;
				}
			} else if (EXPECTED(zobj->properties != NULL)) {
				retval = zend_hash_find(zobj->properties, Z_STR_P(offset));
				if (EXPECTED(retval)) {
					ZVAL_COPY(EX_VAR(opline->result.var), retval);
					break;
				}
			}
		}

		if (UNEXPECTED(zobj->handlers->read_property == NULL)) {
fetch_obj_r_no_object:
			zend_error(E_NOTICE, "Trying to get property of non-object");
			ZVAL_NULL(EX_VAR(opline->result.var));
		} else {
			retval = zobj->handlers->read_property(container, offset, BP_VAR_R, ((IS_CV == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(offset)) : NULL), EX_VAR(opline->result.var));

			if (retval != EX_VAR(opline->result.var)) {
				ZVAL_COPY(EX_VAR(opline->result.var), retval);
			}
		}
	} while (0);

	zval_ptr_dtor_nogc(free_op1);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_W_SPEC_VAR_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *property;
	zval *container;

	SAVE_OPLINE();
	property = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);

	container = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);
	if (IS_VAR == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}
	if (IS_VAR == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an object");

		HANDLE_EXCEPTION();
	}

	zend_fetch_property_address(EX_VAR(opline->result.var), container, IS_VAR, property, IS_CV, ((IS_CV == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), BP_VAR_W);

	if (IS_VAR == IS_VAR && READY_TO_DESTROY(free_op1)) {
		EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 0);
	}
	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_RW_SPEC_VAR_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *property;
	zval *container;

	SAVE_OPLINE();
	property = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);
	container = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

	if (IS_VAR == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}
	if (IS_VAR == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an object");

		HANDLE_EXCEPTION();
	}
	zend_fetch_property_address(EX_VAR(opline->result.var), container, IS_VAR, property, IS_CV, ((IS_CV == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), BP_VAR_RW);

	if (IS_VAR == IS_VAR && READY_TO_DESTROY(free_op1)) {
		EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 0);
	}
	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_FUNC_ARG_SPEC_VAR_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *container;

	if (zend_is_by_ref_func_arg_fetch(opline, EX(call))) {
		/* Behave like FETCH_OBJ_W */
		zend_free_op free_op1;
		zval *property;

		SAVE_OPLINE();
		property = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);
		container = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

		if (IS_VAR == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
			zend_throw_error(NULL, "Using $this when not in object context");

			HANDLE_EXCEPTION();
		}
		if (IS_VAR == IS_CONST || IS_VAR == IS_TMP_VAR) {
			zend_throw_error(NULL, "Cannot use temporary expression in write context");

			if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
			HANDLE_EXCEPTION();
		}
		if (IS_VAR == IS_VAR && UNEXPECTED(container == NULL)) {
			zend_throw_error(NULL, "Cannot use string offset as an object");

			HANDLE_EXCEPTION();
		}
		zend_fetch_property_address(EX_VAR(opline->result.var), container, IS_VAR, property, IS_CV, ((IS_CV == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), BP_VAR_W);

		if (IS_VAR == IS_VAR && READY_TO_DESTROY(free_op1)) {
			EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 0);
		}
		if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	} else {
		ZEND_VM_TAIL_CALL(ZEND_FETCH_OBJ_R_SPEC_VAR_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS_PASSTHRU));
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_UNSET_SPEC_VAR_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *container, *property;

	SAVE_OPLINE();
	container = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

	if (IS_VAR == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}

	property = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);

	if (IS_VAR == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an object");

		HANDLE_EXCEPTION();
	}
	zend_fetch_property_address(EX_VAR(opline->result.var), container, IS_VAR, property, IS_CV, ((IS_CV == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), BP_VAR_UNSET);

	if (IS_VAR == IS_VAR && READY_TO_DESTROY(free_op1)) {
		EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 0);
	}
	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_OBJ_SPEC_VAR_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *object;
	zval *property_name;

	SAVE_OPLINE();
	object = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

	if (IS_VAR == IS_UNUSED && UNEXPECTED(Z_OBJ_P(object) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}

	property_name = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);

	if (IS_VAR == IS_VAR && UNEXPECTED(object == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an array");

		HANDLE_EXCEPTION();
	}
	zend_assign_to_object(UNEXPECTED(RETURN_VALUE_USED(opline)) ? EX_VAR(opline->result.var) : NULL, object, IS_VAR, property_name, IS_CV, (opline+1)->op1_type, (opline+1)->op1, execute_data, ((IS_CV == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property_name)) : NULL));

	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	/* assign_obj has two opcodes! */
	ZEND_VM_NEXT_OPCODE_EX(1, 2);
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_DIM_SPEC_VAR_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *object_ptr;
	zend_free_op free_op_data1;
	zval *value;
	zval *variable_ptr;
	zval *dim;

	SAVE_OPLINE();
	object_ptr = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

	if (IS_VAR == IS_VAR && UNEXPECTED(object_ptr == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an array");
		FREE_UNFETCHED_OP((opline+1)->op1_type, (opline+1)->op1.var);

		HANDLE_EXCEPTION();
	}

	if (EXPECTED(Z_TYPE_P(object_ptr) == IS_ARRAY)) {
try_assign_dim_array:
		if (IS_CV == IS_UNUSED) {
			SEPARATE_ARRAY(object_ptr);
			variable_ptr = zend_hash_next_index_insert(Z_ARRVAL_P(object_ptr), &EG(uninitialized_zval));
			if (UNEXPECTED(variable_ptr == NULL)) {
				zend_error(E_WARNING, "Cannot add element to the array as the next element is already occupied");
				variable_ptr = &EG(error_zval);
			}
		} else {
			dim = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);
			SEPARATE_ARRAY(object_ptr);
			variable_ptr = zend_fetch_dimension_address_inner(Z_ARRVAL_P(object_ptr), dim, IS_CV, BP_VAR_W);

		}
		value = get_zval_ptr((opline+1)->op1_type, (opline+1)->op1, execute_data, &free_op_data1, BP_VAR_R);
		if (UNEXPECTED(variable_ptr == &EG(error_zval))) {
			FREE_OP(free_op_data1);
			if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
				ZVAL_NULL(EX_VAR(opline->result.var));
			}
		} else {
			value = zend_assign_to_variable(variable_ptr, value, (opline+1)->op1_type);
			if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
				ZVAL_COPY(EX_VAR(opline->result.var), value);
			}
		}
	} else {
		if (EXPECTED(Z_ISREF_P(object_ptr))) {
			object_ptr = Z_REFVAL_P(object_ptr);
			if (EXPECTED(Z_TYPE_P(object_ptr) == IS_ARRAY)) {
				goto try_assign_dim_array;
			}
		}
		if (EXPECTED(Z_TYPE_P(object_ptr) == IS_OBJECT)) {

			zval *property_name = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);

			zend_assign_to_object_dim(UNEXPECTED(RETURN_VALUE_USED(opline)) ? EX_VAR(opline->result.var) : NULL, object_ptr, property_name, (opline+1)->op1_type, (opline+1)->op1, execute_data);

		} else if (EXPECTED(Z_TYPE_P(object_ptr) == IS_STRING)) {
			if (EXPECTED(Z_STRLEN_P(object_ptr) != 0)) {
				if (IS_CV == IS_UNUSED) {
					zend_throw_error(NULL, "[] operator not supported for strings");
					FREE_UNFETCHED_OP((opline+1)->op1_type, (opline+1)->op1.var);
					if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
					HANDLE_EXCEPTION();
				} else {
					zend_long offset;

					dim = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);
					offset = zend_fetch_string_offset(object_ptr, dim, BP_VAR_W);

					value = get_zval_ptr_deref((opline+1)->op1_type, (opline+1)->op1, execute_data, &free_op_data1, BP_VAR_R);
					zend_assign_to_string_offset(object_ptr, offset, value, (UNEXPECTED(RETURN_VALUE_USED(opline)) ? EX_VAR(opline->result.var) : NULL));
					FREE_OP(free_op_data1);
				}
			} else {
				zval_ptr_dtor_nogc(object_ptr);
assign_dim_convert_to_array:
				ZVAL_NEW_ARR(object_ptr);
				zend_hash_init(Z_ARRVAL_P(object_ptr), 8, NULL, ZVAL_PTR_DTOR, 0);
				goto try_assign_dim_array;
			}
		} else if (EXPECTED(Z_TYPE_P(object_ptr) <= IS_FALSE)) {
			if (IS_VAR == IS_VAR && UNEXPECTED(object_ptr == &EG(error_zval))) {
				goto assign_dim_clean;
			}
			goto assign_dim_convert_to_array;
		} else {
			zend_error(E_WARNING, "Cannot use a scalar value as an array");
assign_dim_clean:
			dim = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);

			value = get_zval_ptr((opline+1)->op1_type, (opline+1)->op1, execute_data, &free_op_data1, BP_VAR_R);
			FREE_OP(free_op_data1);
			if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
				ZVAL_NULL(EX_VAR(opline->result.var));
			}
		}
	}
 	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	/* assign_dim has two opcodes! */
	ZEND_VM_NEXT_OPCODE_EX(1, 2);
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_SPEC_VAR_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *value;
	zval *variable_ptr;

	SAVE_OPLINE();
	value = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);
	variable_ptr = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

	if (IS_VAR == IS_VAR && UNEXPECTED(variable_ptr == &EG(error_zval))) {

		if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
			ZVAL_NULL(EX_VAR(opline->result.var));
		}
	} else {
		value = zend_assign_to_variable(variable_ptr, value, IS_CV);
		if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
			ZVAL_COPY(EX_VAR(opline->result.var), value);
		}
		if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
		/* zend_assign_to_variable() always takes care of op2, never free it! */
	}

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_REF_SPEC_VAR_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *variable_ptr;
	zval *value_ptr;

	SAVE_OPLINE();
	value_ptr = _get_zval_ptr_cv_BP_VAR_W(execute_data, opline->op2.var);

	if (IS_CV == IS_VAR && UNEXPECTED(value_ptr == NULL)) {
		zend_throw_error(NULL, "Cannot create references to/from string offsets nor overloaded objects");
		zval_ptr_dtor_nogc(EX_VAR(opline->op1.var));
		HANDLE_EXCEPTION();
	}
	if (IS_VAR == IS_VAR &&
	    UNEXPECTED(Z_TYPE_P(EX_VAR(opline->op1.var)) != IS_INDIRECT) &&
	    UNEXPECTED(!Z_ISREF_P(EX_VAR(opline->op1.var)))) {
		zend_throw_error(NULL, "Cannot assign by reference to overloaded object");

		HANDLE_EXCEPTION();
	}
	if (IS_CV == IS_VAR &&
	    (value_ptr == &EG(uninitialized_zval) ||
	     (opline->extended_value == ZEND_RETURNS_FUNCTION &&
	      !(Z_VAR_FLAGS_P(value_ptr) & IS_VAR_RET_REF)))) {
		if (!0 && UNEXPECTED(Z_TYPE_P(EX_VAR(opline->op2.var)) != IS_INDIRECT)) { /* undo the effect of get_zval_ptr_ptr() */
			Z_TRY_ADDREF_P(value_ptr);
		}
		zend_error(E_NOTICE, "Only variables should be assigned by reference");
		if (UNEXPECTED(EG(exception) != NULL)) {

			HANDLE_EXCEPTION();
		}
		ZEND_VM_TAIL_CALL(ZEND_ASSIGN_SPEC_VAR_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS_PASSTHRU));
	}

	variable_ptr = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);
	if (IS_VAR == IS_VAR && UNEXPECTED(variable_ptr == NULL)) {
		zend_throw_error(NULL, "Cannot create references to/from string offsets nor overloaded objects");

		HANDLE_EXCEPTION();
	}
	if ((IS_VAR == IS_VAR && UNEXPECTED(variable_ptr == &EG(error_zval))) ||
	    (IS_CV == IS_VAR && UNEXPECTED(value_ptr == &EG(error_zval)))) {
		variable_ptr = &EG(uninitialized_zval);
	} else {
		zend_assign_to_variable_reference(variable_ptr, value_ptr);
	}

	if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
		ZVAL_COPY(EX_VAR(opline->result.var), variable_ptr);
	}

	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_INIT_STATIC_METHOD_CALL_SPEC_VAR_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *function_name;
	zend_class_entry *ce;
	zend_object *object;
	zend_function *fbc;
	zend_execute_data *call;

	SAVE_OPLINE();

	if (IS_VAR == IS_CONST) {
		/* no function found. try a static method in class */
		if (EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1))))) {
			ce = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)));
		} else {
			ce = zend_fetch_class_by_name(Z_STR_P(EX_CONSTANT(opline->op1)), EX_CONSTANT(opline->op1) + 1, ZEND_FETCH_CLASS_DEFAULT |  ZEND_FETCH_CLASS_EXCEPTION);
			if (UNEXPECTED(EG(exception) != NULL)) {
				HANDLE_EXCEPTION();
			}
			if (UNEXPECTED(ce == NULL)) {
				zend_throw_error(NULL, "Class '%s' not found", Z_STRVAL_P(EX_CONSTANT(opline->op1)));
				HANDLE_EXCEPTION();
			}
			CACHE_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)), ce);
		}
	} else {
		ce = Z_CE_P(EX_VAR(opline->op1.var));
	}

	if (IS_VAR == IS_CONST &&
	    IS_CV == IS_CONST &&
	    EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2))))) {
		fbc = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)));
	} else if (IS_VAR != IS_CONST &&
	           IS_CV == IS_CONST &&
	           (fbc = CACHED_POLYMORPHIC_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)), ce))) {
		/* do nothing */
	} else if (IS_CV != IS_UNUSED) {


		function_name = _get_zval_ptr_cv_undef(execute_data, opline->op2.var);
		if (IS_CV != IS_CONST) {
			if (UNEXPECTED(Z_TYPE_P(function_name) != IS_STRING)) {
				if (IS_CV == IS_CV && UNEXPECTED(Z_TYPE_P(function_name) == IS_UNDEF)) {
					GET_OP2_UNDEF_CV(function_name, BP_VAR_R);
				}
				if (UNEXPECTED(EG(exception) != NULL)) {
					HANDLE_EXCEPTION();
				}
				zend_throw_error(NULL, "Function name must be a string");

				HANDLE_EXCEPTION();
 			}
		}

		if (ce->get_static_method) {
			fbc = ce->get_static_method(ce, Z_STR_P(function_name));
		} else {
			fbc = zend_std_get_static_method(ce, Z_STR_P(function_name), ((IS_CV == IS_CONST) ? (EX_CONSTANT(opline->op2) + 1) : NULL));
		}
		if (UNEXPECTED(fbc == NULL)) {
			if (EXPECTED(!EG(exception))) {
				zend_throw_error(NULL, "Call to undefined method %s::%s()", ZSTR_VAL(ce->name), Z_STRVAL_P(function_name));
			}

			HANDLE_EXCEPTION();
		}
		if (IS_CV == IS_CONST &&
		    EXPECTED(fbc->type <= ZEND_USER_FUNCTION) &&
		    EXPECTED(!(fbc->common.fn_flags & (ZEND_ACC_CALL_VIA_TRAMPOLINE|ZEND_ACC_NEVER_CACHE)))) {
			if (IS_VAR == IS_CONST) {
				CACHE_PTR(Z_CACHE_SLOT_P(function_name), fbc);
			} else {
				CACHE_POLYMORPHIC_PTR(Z_CACHE_SLOT_P(function_name), ce, fbc);
			}
		}
		if (IS_CV != IS_CONST) {

		}
	} else {
		if (UNEXPECTED(ce->constructor == NULL)) {
			zend_throw_error(NULL, "Cannot call constructor");
			HANDLE_EXCEPTION();
		}
		if (Z_OBJ(EX(This)) && Z_OBJ(EX(This))->ce != ce->constructor->common.scope && (ce->constructor->common.fn_flags & ZEND_ACC_PRIVATE)) {
			zend_throw_error(NULL, "Cannot call private %s::__construct()", ZSTR_VAL(ce->name));
			HANDLE_EXCEPTION();
		}
		fbc = ce->constructor;
	}

	object = NULL;
	if (!(fbc->common.fn_flags & ZEND_ACC_STATIC)) {
		if (Z_OBJ(EX(This)) && instanceof_function(Z_OBJCE(EX(This)), ce)) {
			object = Z_OBJ(EX(This));
		}
		if (!object) {
			if (fbc->common.fn_flags & ZEND_ACC_ALLOW_STATIC) {
				/* Allowed for PHP 4 compatibility. */
				zend_error(
					E_DEPRECATED,
					"Non-static method %s::%s() should not be called statically",
					ZSTR_VAL(fbc->common.scope->name), ZSTR_VAL(fbc->common.function_name));
				if (UNEXPECTED(EG(exception) != NULL)) {
					HANDLE_EXCEPTION();
				}
			} else {
				/* An internal function assumes $this is present and won't check that.
				 * So PHP would crash by allowing the call. */
				zend_throw_error(
					zend_ce_error,
					"Non-static method %s::%s() cannot be called statically",
					ZSTR_VAL(fbc->common.scope->name), ZSTR_VAL(fbc->common.function_name));
				HANDLE_EXCEPTION();
			}
		}
	}

	if (IS_VAR != IS_CONST) {
		/* previous opcode is ZEND_FETCH_CLASS */
		if (((opline-1)->extended_value & ZEND_FETCH_CLASS_MASK) == ZEND_FETCH_CLASS_PARENT ||
		    ((opline-1)->extended_value & ZEND_FETCH_CLASS_MASK) == ZEND_FETCH_CLASS_SELF) {
			ce = EX(called_scope);
		}
	}

	call = zend_vm_stack_push_call_frame(ZEND_CALL_NESTED_FUNCTION,
		fbc, opline->extended_value, ce, object);
	call->prev_execute_data = EX(call);
	EX(call) = call;

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ADD_ARRAY_ELEMENT_SPEC_VAR_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *expr_ptr, new_expr;

	SAVE_OPLINE();
	if ((IS_VAR == IS_VAR || IS_VAR == IS_CV) &&
	    UNEXPECTED(opline->extended_value & ZEND_ARRAY_ELEMENT_REF)) {
		expr_ptr = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);
		if (IS_VAR == IS_VAR && UNEXPECTED(expr_ptr == NULL)) {
			zend_throw_error(NULL, "Cannot create references to/from string offsets");
			zend_array_destroy(Z_ARRVAL_P(EX_VAR(opline->result.var)));
			HANDLE_EXCEPTION();
		}
		ZVAL_MAKE_REF(expr_ptr);
		Z_ADDREF_P(expr_ptr);
		if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	} else {
		expr_ptr = _get_zval_ptr_var(opline->op1.var, execute_data, &free_op1);
		if (IS_VAR == IS_TMP_VAR) {
			/* pass */
		} else if (IS_VAR == IS_CONST) {
			if (UNEXPECTED(Z_OPT_COPYABLE_P(expr_ptr))) {
				ZVAL_COPY_VALUE(&new_expr, expr_ptr);
				zval_copy_ctor_func(&new_expr);
				expr_ptr = &new_expr;
			}
		} else if (IS_VAR == IS_CV) {
			ZVAL_DEREF(expr_ptr);
			if (Z_REFCOUNTED_P(expr_ptr)) {
				Z_ADDREF_P(expr_ptr);
			}
		} else /* if (IS_VAR == IS_VAR) */ {
			if (UNEXPECTED(Z_ISREF_P(expr_ptr))) {
				zend_refcounted *ref = Z_COUNTED_P(expr_ptr);

				expr_ptr = Z_REFVAL_P(expr_ptr);
				if (UNEXPECTED(--GC_REFCOUNT(ref) == 0)) {
					ZVAL_COPY_VALUE(&new_expr, expr_ptr);
					expr_ptr = &new_expr;
					efree_size(ref, sizeof(zend_reference));
				} else if (Z_OPT_REFCOUNTED_P(expr_ptr)) {
					Z_ADDREF_P(expr_ptr);
				}
			}
		}
	}

	if (IS_CV != IS_UNUSED) {

		zval *offset = _get_zval_ptr_cv_undef(execute_data, opline->op2.var);
		zend_string *str;
		zend_ulong hval;

add_again:
		if (EXPECTED(Z_TYPE_P(offset) == IS_STRING)) {
			str = Z_STR_P(offset);
			if (IS_CV != IS_CONST) {
				if (ZEND_HANDLE_NUMERIC(str, hval)) {
					goto num_index;
				}
			}
str_index:
			zend_hash_update(Z_ARRVAL_P(EX_VAR(opline->result.var)), str, expr_ptr);
		} else if (EXPECTED(Z_TYPE_P(offset) == IS_LONG)) {
			hval = Z_LVAL_P(offset);
num_index:
			zend_hash_index_update(Z_ARRVAL_P(EX_VAR(opline->result.var)), hval, expr_ptr);
		} else if ((IS_CV & (IS_VAR|IS_CV)) && EXPECTED(Z_TYPE_P(offset) == IS_REFERENCE)) {
			offset = Z_REFVAL_P(offset);
			goto add_again;
		} else if (Z_TYPE_P(offset) == IS_NULL) {
			str = ZSTR_EMPTY_ALLOC();
			goto str_index;
		} else if (Z_TYPE_P(offset) == IS_DOUBLE) {
			hval = zend_dval_to_lval(Z_DVAL_P(offset));
			goto num_index;
		} else if (Z_TYPE_P(offset) == IS_FALSE) {
			hval = 0;
			goto num_index;
		} else if (Z_TYPE_P(offset) == IS_TRUE) {
			hval = 1;
			goto num_index;
		} else if (IS_CV == IS_CV && Z_TYPE_P(offset) == IS_UNDEF) {
			GET_OP2_UNDEF_CV(offset, BP_VAR_R);
			str = ZSTR_EMPTY_ALLOC();
			goto str_index;
		} else {
			zend_error(E_WARNING, "Illegal offset type");
			zval_ptr_dtor(expr_ptr);
		}

	} else {
		zend_hash_next_index_insert(Z_ARRVAL_P(EX_VAR(opline->result.var)), expr_ptr);
	}
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_INIT_ARRAY_SPEC_VAR_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	zval *array;
	uint32_t size;
	USE_OPLINE

	array = EX_VAR(opline->result.var);
	if (IS_VAR != IS_UNUSED) {
		size = opline->extended_value >> ZEND_ARRAY_SIZE_SHIFT;
	} else {
		size = 0;
	}
	ZVAL_NEW_ARR(array);
	zend_hash_init(Z_ARRVAL_P(array), size, NULL, ZVAL_PTR_DTOR, 0);

	if (IS_VAR != IS_UNUSED) {
		/* Explicitly initialize array as not-packed if flag is set */
		if (opline->extended_value & ZEND_ARRAY_NOT_PACKED) {
			zend_hash_real_init(Z_ARRVAL_P(array), 0);
		}
	}

	if (IS_VAR == IS_UNUSED) {
		ZEND_VM_NEXT_OPCODE();
#if 0 || (IS_VAR != IS_UNUSED)
	} else {
		ZEND_VM_TAIL_CALL(ZEND_ADD_ARRAY_ELEMENT_SPEC_VAR_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS_PASSTHRU));
#endif
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_UNSET_DIM_SPEC_VAR_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *container;
	zval *offset;
	zend_ulong hval;
	zend_string *key;

	SAVE_OPLINE();
	container = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);
	if (IS_VAR == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}
	if (IS_VAR == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot unset string offsets");

		HANDLE_EXCEPTION();
	}
	offset = _get_zval_ptr_cv_undef(execute_data, opline->op2.var);

	do {
		if (IS_VAR != IS_UNUSED && EXPECTED(Z_TYPE_P(container) == IS_ARRAY)) {
			HashTable *ht;

unset_dim_array:
			SEPARATE_ARRAY(container);
			ht = Z_ARRVAL_P(container);
offset_again:
			if (EXPECTED(Z_TYPE_P(offset) == IS_STRING)) {
				key = Z_STR_P(offset);
				if (IS_CV != IS_CONST) {
					if (ZEND_HANDLE_NUMERIC(key, hval)) {
						goto num_index_dim;
					}
				}
str_index_dim:
				if (ht == &EG(symbol_table)) {
					zend_delete_global_variable(key);
				} else {
					zend_hash_del(ht, key);
				}
			} else if (EXPECTED(Z_TYPE_P(offset) == IS_LONG)) {
				hval = Z_LVAL_P(offset);
num_index_dim:
				zend_hash_index_del(ht, hval);
			} else if ((IS_CV & (IS_VAR|IS_CV)) && EXPECTED(Z_TYPE_P(offset) == IS_REFERENCE)) {
				offset = Z_REFVAL_P(offset);
				goto offset_again;
			} else if (Z_TYPE_P(offset) == IS_DOUBLE) {
				hval = zend_dval_to_lval(Z_DVAL_P(offset));
				goto num_index_dim;
			} else if (Z_TYPE_P(offset) == IS_NULL) {
				key = ZSTR_EMPTY_ALLOC();
				goto str_index_dim;
			} else if (Z_TYPE_P(offset) == IS_FALSE) {
				hval = 0;
				goto num_index_dim;
			} else if (Z_TYPE_P(offset) == IS_TRUE) {
				hval = 1;
				goto num_index_dim;
			} else if (Z_TYPE_P(offset) == IS_RESOURCE) {
				hval = Z_RES_HANDLE_P(offset);
				goto num_index_dim;
			} else if (IS_CV == IS_CV && Z_TYPE_P(offset) == IS_UNDEF) {
				GET_OP2_UNDEF_CV(offset, BP_VAR_R);
				key = ZSTR_EMPTY_ALLOC();
				goto str_index_dim;
			} else {
				zend_error(E_WARNING, "Illegal offset type in unset");
			}
			break;
		} else if (IS_VAR != IS_UNUSED && Z_ISREF_P(container)) {
			container = Z_REFVAL_P(container);
			if (EXPECTED(Z_TYPE_P(container) == IS_ARRAY)) {
				goto unset_dim_array;
			}
		}
		if (IS_CV == IS_CV && UNEXPECTED(Z_TYPE_P(offset) == IS_UNDEF)) {
			offset = GET_OP2_UNDEF_CV(offset, BP_VAR_R);
		}
		if (IS_VAR == IS_UNUSED || EXPECTED(Z_TYPE_P(container) == IS_OBJECT)) {
			if (UNEXPECTED(Z_OBJ_HT_P(container)->unset_dimension == NULL)) {
				zend_throw_error(NULL, "Cannot use object as array");
			} else {
				Z_OBJ_HT_P(container)->unset_dimension(container, offset);
			}
		} else if (IS_VAR != IS_UNUSED && UNEXPECTED(Z_TYPE_P(container) == IS_STRING)) {
			zend_throw_error(NULL, "Cannot unset string offsets");
		}
	} while (0);

	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_UNSET_OBJ_SPEC_VAR_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *container;
	zval *offset;

	SAVE_OPLINE();
	container = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);
	if (IS_VAR == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}
	if (IS_VAR == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot unset string offsets");

		HANDLE_EXCEPTION();
	}
	offset = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);

	do {
		if (IS_VAR != IS_UNUSED && UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT)) {
			if (Z_ISREF_P(container)) {
				container = Z_REFVAL_P(container);
				if (Z_TYPE_P(container) != IS_OBJECT) {
					break;
				}
			} else {
				break;
			}
		}
		if (Z_OBJ_HT_P(container)->unset_property) {
			Z_OBJ_HT_P(container)->unset_property(container, offset, ((IS_CV == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(offset)) : NULL));
		} else {
			zend_error(E_NOTICE, "Trying to unset property of non-object");
		}
	} while (0);

	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_YIELD_SPEC_VAR_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zend_generator *generator = zend_get_running_generator(execute_data);

	SAVE_OPLINE();
	if (UNEXPECTED(generator->flags & ZEND_GENERATOR_FORCED_CLOSE)) {
		zend_throw_error(NULL, "Cannot yield from finally in a force-closed generator");

		zval_ptr_dtor_nogc(EX_VAR(opline->op1.var));
		HANDLE_EXCEPTION();
	}

	/* Destroy the previously yielded value */
	zval_ptr_dtor(&generator->value);

	/* Destroy the previously yielded key */
	zval_ptr_dtor(&generator->key);

	/* Set the new yielded value */
	if (IS_VAR != IS_UNUSED) {
		zend_free_op free_op1;

		if (UNEXPECTED(EX(func)->op_array.fn_flags & ZEND_ACC_RETURN_REFERENCE)) {
			/* Constants and temporary variables aren't yieldable by reference,
			 * but we still allow them with a notice. */
			if (IS_VAR == IS_CONST || IS_VAR == IS_TMP_VAR) {
				zval *value;

				zend_error(E_NOTICE, "Only variable references should be yielded by reference");

				value = _get_zval_ptr_var(opline->op1.var, execute_data, &free_op1);
				ZVAL_COPY_VALUE(&generator->value, value);
				if (IS_VAR != IS_CONST) {
					if (UNEXPECTED(Z_OPT_COPYABLE(generator->value))) {
						zval_copy_ctor_func(&generator->value);
					}
				}
			} else {
				zval *value_ptr = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

				if (IS_VAR == IS_VAR && UNEXPECTED(value_ptr == NULL)) {
					zend_throw_error(NULL, "Cannot yield string offsets by reference");

					HANDLE_EXCEPTION();
				}

				/* If a function call result is yielded and the function did
				 * not return by reference we throw a notice. */
				if (IS_VAR == IS_VAR &&
				    (value_ptr == &EG(uninitialized_zval) ||
				     (opline->extended_value == ZEND_RETURNS_FUNCTION &&
				      !(Z_VAR_FLAGS_P(value_ptr) & IS_VAR_RET_REF)))) {
					zend_error(E_NOTICE, "Only variable references should be yielded by reference");
				} else {
					ZVAL_MAKE_REF(value_ptr);
				}
				ZVAL_COPY(&generator->value, value_ptr);

				if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
			}
		} else {
			zval *value = _get_zval_ptr_var(opline->op1.var, execute_data, &free_op1);

			/* Consts, temporary variables and references need copying */
			if (IS_VAR == IS_CONST) {
				ZVAL_COPY_VALUE(&generator->value, value);
				if (UNEXPECTED(Z_OPT_COPYABLE(generator->value))) {
					zval_copy_ctor_func(&generator->value);
				}
			} else if (IS_VAR == IS_TMP_VAR) {
				ZVAL_COPY_VALUE(&generator->value, value);
            } else if ((IS_VAR & (IS_VAR|IS_CV)) && Z_ISREF_P(value)) {
				ZVAL_COPY(&generator->value, Z_REFVAL_P(value));
				zval_ptr_dtor_nogc(free_op1);
			} else {
				ZVAL_COPY_VALUE(&generator->value, value);
				if (IS_VAR == IS_CV) {
					if (Z_OPT_REFCOUNTED_P(value)) Z_ADDREF_P(value);
				}
			}
		}
	} else {
		/* If no value was specified yield null */
		ZVAL_NULL(&generator->value);
	}

	/* Set the new yielded key */
	if (IS_CV != IS_UNUSED) {

		zval *key = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);

		/* Consts, temporary variables and references need copying */
		if (IS_CV == IS_CONST) {
			ZVAL_COPY_VALUE(&generator->key, key);
			if (UNEXPECTED(Z_OPT_COPYABLE(generator->key))) {
				zval_copy_ctor_func(&generator->key);
			}
		} else if (IS_CV == IS_TMP_VAR) {
			ZVAL_COPY_VALUE(&generator->key, key);
		} else if ((IS_CV & (IS_VAR|IS_CV)) && Z_ISREF_P(key)) {
			ZVAL_COPY(&generator->key, Z_REFVAL_P(key));

		} else {
			ZVAL_COPY_VALUE(&generator->key, key);
			if (IS_CV == IS_CV) {
				if (Z_OPT_REFCOUNTED_P(key)) Z_ADDREF_P(key);
			}
		}

		if (Z_TYPE(generator->key) == IS_LONG
		    && Z_LVAL(generator->key) > generator->largest_used_integer_key
		) {
			generator->largest_used_integer_key = Z_LVAL(generator->key);
		}
	} else {
		/* If no key was specified we use auto-increment keys */
		generator->largest_used_integer_key++;
		ZVAL_LONG(&generator->key, generator->largest_used_integer_key);
	}

	if (RETURN_VALUE_USED(opline)) {
		/* If the return value of yield is used set the send
		 * target and initialize it to NULL */
		generator->send_target = EX_VAR(opline->result.var);
		ZVAL_NULL(generator->send_target);
	} else {
		generator->send_target = NULL;
	}

	/* We increment to the next op, so we are at the correct position when the
	 * generator is resumed. */
	ZEND_VM_INC_OPCODE();

	/* The GOTO VM uses a local opline variable. We need to set the opline
	 * variable in execute_data so we don't resume at an old position. */
	SAVE_OPLINE();

	ZEND_VM_RETURN();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_POW_SPEC_VAR_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_VAR_CV(pow_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL zend_binary_assign_op_obj_helper_SPEC_VAR_TMPVAR(binary_op_type binary_op ZEND_OPCODE_HANDLER_ARGS_DC)
{
	USE_OPLINE
	zend_free_op free_op1, free_op2, free_op_data1;
	zval *object;
	zval *property;
	zval *value;
	zval *zptr;

	SAVE_OPLINE();
	object = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

	if (IS_VAR == IS_UNUSED && UNEXPECTED(Z_OBJ_P(object) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");
		FREE_UNFETCHED_OP((opline+1)->op1_type, (opline+1)->op1.var);
		zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
		HANDLE_EXCEPTION();
	}

	property = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);

	if (IS_VAR == IS_VAR && UNEXPECTED(object == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an object");
		FREE_UNFETCHED_OP((opline+1)->op1_type, (opline+1)->op1.var);
		zval_ptr_dtor_nogc(free_op2);
		HANDLE_EXCEPTION();
	}

	do {
		value = get_zval_ptr((opline+1)->op1_type, (opline+1)->op1, execute_data, &free_op_data1, BP_VAR_R);

		if (IS_VAR != IS_UNUSED && UNEXPECTED(Z_TYPE_P(object) != IS_OBJECT)) {
			ZVAL_DEREF(object);
			if (UNEXPECTED(!make_real_object(object))) {
				zend_error(E_WARNING, "Attempt to assign property of non-object");
				if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
					ZVAL_NULL(EX_VAR(opline->result.var));
				}
				break;
			}
		}

		/* here we are sure we are dealing with an object */
		if (EXPECTED(Z_OBJ_HT_P(object)->get_property_ptr_ptr)
			&& EXPECTED((zptr = Z_OBJ_HT_P(object)->get_property_ptr_ptr(object, property, BP_VAR_RW, (((IS_TMP_VAR|IS_VAR) == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL))) != NULL)) {

			ZVAL_DEREF(zptr);
			SEPARATE_ZVAL_NOREF(zptr);

			binary_op(zptr, zptr, value);
			if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
				ZVAL_COPY(EX_VAR(opline->result.var), zptr);
			}
		} else {
			zend_assign_op_overloaded_property(object, property, (((IS_TMP_VAR|IS_VAR) == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), value, binary_op, (UNEXPECTED(RETURN_VALUE_USED(opline)) ? EX_VAR(opline->result.var) : NULL));
		}
	} while (0);

	FREE_OP(free_op_data1);
	zval_ptr_dtor_nogc(free_op2);
	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	/* assign_obj has two opcodes! */
	ZEND_VM_NEXT_OPCODE_EX(1, 2);
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL zend_binary_assign_op_dim_helper_SPEC_VAR_TMPVAR(binary_op_type binary_op ZEND_OPCODE_HANDLER_ARGS_DC)
{
	USE_OPLINE
	zend_free_op free_op1, free_op2, free_op_data1;
	zval *var_ptr, rv;
	zval *value, *container, *dim;

	SAVE_OPLINE();
	container = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);
	if (IS_VAR == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");
		FREE_UNFETCHED_OP((opline+1)->op1_type, (opline+1)->op1.var);
		zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
		HANDLE_EXCEPTION();
	}
	if (IS_VAR == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an array");
		FREE_UNFETCHED_OP((opline+1)->op1_type, (opline+1)->op1.var);
		zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
		HANDLE_EXCEPTION();
	}

	dim = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);

	do {
		if (IS_VAR == IS_UNUSED || UNEXPECTED(Z_TYPE_P(container) != IS_ARRAY)) {
			if (IS_VAR != IS_UNUSED) {
				ZVAL_DEREF(container);
			}
			if (IS_VAR == IS_UNUSED || EXPECTED(Z_TYPE_P(container) == IS_OBJECT)) {
				value = get_zval_ptr((opline+1)->op1_type, (opline+1)->op1, execute_data, &free_op_data1, BP_VAR_R);
				zend_binary_assign_op_obj_dim(container, dim, value, UNEXPECTED(RETURN_VALUE_USED(opline)) ? EX_VAR(opline->result.var) : NULL, binary_op);
				break;
			}
		}

		zend_fetch_dimension_address_RW(&rv, container, dim, (IS_TMP_VAR|IS_VAR));
		value = get_zval_ptr((opline+1)->op1_type, (opline+1)->op1, execute_data, &free_op_data1, BP_VAR_R);
		ZEND_ASSERT(Z_TYPE(rv) == IS_INDIRECT);
		var_ptr = Z_INDIRECT(rv);

		if (UNEXPECTED(var_ptr == NULL)) {
			zend_throw_error(NULL, "Cannot use assign-op operators with overloaded objects nor string offsets");
			zval_ptr_dtor_nogc(free_op2);
			FREE_OP(free_op_data1);
			if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
			HANDLE_EXCEPTION();
		}

		if (UNEXPECTED(var_ptr == &EG(error_zval))) {
			if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
				ZVAL_NULL(EX_VAR(opline->result.var));
			}
		} else {
			ZVAL_DEREF(var_ptr);
			SEPARATE_ZVAL_NOREF(var_ptr);

			binary_op(var_ptr, var_ptr, value);

			if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
				ZVAL_COPY(EX_VAR(opline->result.var), var_ptr);
			}
		}
	} while (0);

	zval_ptr_dtor_nogc(free_op2);
	FREE_OP(free_op_data1);
	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	ZEND_VM_NEXT_OPCODE_EX(1, 2);
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL zend_binary_assign_op_helper_SPEC_VAR_TMPVAR(binary_op_type binary_op ZEND_OPCODE_HANDLER_ARGS_DC)
{
	USE_OPLINE
	zend_free_op free_op1, free_op2;
	zval *var_ptr;
	zval *value;

	SAVE_OPLINE();
	value = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);
	var_ptr = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

	if (IS_VAR == IS_VAR && UNEXPECTED(var_ptr == NULL)) {
		zend_throw_error(NULL, "Cannot use assign-op operators with overloaded objects nor string offsets");
		zval_ptr_dtor_nogc(free_op2);
		HANDLE_EXCEPTION();
	}

	if (IS_VAR == IS_VAR && UNEXPECTED(var_ptr == &EG(error_zval))) {
		if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
			ZVAL_NULL(EX_VAR(opline->result.var));
		}
	} else {
		ZVAL_DEREF(var_ptr);
		SEPARATE_ZVAL_NOREF(var_ptr);

		binary_op(var_ptr, var_ptr, value);

		if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
			ZVAL_COPY(EX_VAR(opline->result.var), var_ptr);
		}
	}

	zval_ptr_dtor_nogc(free_op2);
	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_ADD_SPEC_VAR_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || ((IS_TMP_VAR|IS_VAR) != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_VAR != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_VAR_TMPVAR(add_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_TMPVAR(add_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_VAR_TMPVAR(add_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_TMPVAR(add_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_SUB_SPEC_VAR_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || ((IS_TMP_VAR|IS_VAR) != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_VAR != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_VAR_TMPVAR(sub_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_TMPVAR(sub_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_VAR_TMPVAR(sub_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_TMPVAR(sub_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_MUL_SPEC_VAR_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || ((IS_TMP_VAR|IS_VAR) != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_VAR != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_VAR_TMPVAR(mul_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_TMPVAR(mul_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_VAR_TMPVAR(mul_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_TMPVAR(mul_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_DIV_SPEC_VAR_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || ((IS_TMP_VAR|IS_VAR) != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_VAR != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_VAR_TMPVAR(div_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_TMPVAR(div_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_VAR_TMPVAR(div_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_TMPVAR(div_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_MOD_SPEC_VAR_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || ((IS_TMP_VAR|IS_VAR) != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_VAR != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_VAR_TMPVAR(mod_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_TMPVAR(mod_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_VAR_TMPVAR(mod_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_TMPVAR(mod_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_SL_SPEC_VAR_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || ((IS_TMP_VAR|IS_VAR) != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_VAR != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_VAR_TMPVAR(shift_left_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_TMPVAR(shift_left_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_VAR_TMPVAR(shift_left_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_TMPVAR(shift_left_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_SR_SPEC_VAR_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || ((IS_TMP_VAR|IS_VAR) != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_VAR != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_VAR_TMPVAR(shift_right_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_TMPVAR(shift_right_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_VAR_TMPVAR(shift_right_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_TMPVAR(shift_right_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_CONCAT_SPEC_VAR_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || ((IS_TMP_VAR|IS_VAR) != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_VAR != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_VAR_TMPVAR(concat_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_TMPVAR(concat_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_VAR_TMPVAR(concat_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_TMPVAR(concat_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_BW_OR_SPEC_VAR_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || ((IS_TMP_VAR|IS_VAR) != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_VAR != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_VAR_TMPVAR(bitwise_or_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_TMPVAR(bitwise_or_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_VAR_TMPVAR(bitwise_or_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_TMPVAR(bitwise_or_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_BW_AND_SPEC_VAR_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || ((IS_TMP_VAR|IS_VAR) != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_VAR != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_VAR_TMPVAR(bitwise_and_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_TMPVAR(bitwise_and_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_VAR_TMPVAR(bitwise_and_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_TMPVAR(bitwise_and_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_BW_XOR_SPEC_VAR_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || ((IS_TMP_VAR|IS_VAR) != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_VAR != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_VAR_TMPVAR(bitwise_xor_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_TMPVAR(bitwise_xor_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_VAR_TMPVAR(bitwise_xor_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_VAR_TMPVAR(bitwise_xor_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL zend_pre_incdec_property_helper_SPEC_VAR_TMPVAR(int inc ZEND_OPCODE_HANDLER_ARGS_DC)
{
	USE_OPLINE
	zend_free_op free_op1, free_op2;
	zval *object;
	zval *property;
	zval *zptr;

	SAVE_OPLINE();
	object = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

	if (IS_VAR == IS_UNUSED && UNEXPECTED(Z_OBJ_P(object) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");
		zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
		HANDLE_EXCEPTION();
	}

	property = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);

	if (IS_VAR == IS_VAR && UNEXPECTED(object == NULL)) {
		zend_throw_error(NULL, "Cannot increment/decrement overloaded objects nor string offsets");
		zval_ptr_dtor_nogc(free_op2);
		HANDLE_EXCEPTION();
	}

	do {
		if (IS_VAR != IS_UNUSED && UNEXPECTED(Z_TYPE_P(object) != IS_OBJECT)) {
			ZVAL_DEREF(object);
			if (UNEXPECTED(!make_real_object(object))) {
				zend_error(E_WARNING, "Attempt to increment/decrement property of non-object");
				if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
					ZVAL_NULL(EX_VAR(opline->result.var));
				}
				break;
			}
		}

		/* here we are sure we are dealing with an object */

		if (EXPECTED(Z_OBJ_HT_P(object)->get_property_ptr_ptr)
			&& EXPECTED((zptr = Z_OBJ_HT_P(object)->get_property_ptr_ptr(object, property, BP_VAR_RW, (((IS_TMP_VAR|IS_VAR) == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL))) != NULL)) {

			if (EXPECTED(Z_TYPE_P(zptr) == IS_LONG)) {
				if (inc) {
					fast_long_increment_function(zptr);
				} else {
					fast_long_decrement_function(zptr);
				}
			} else {
				ZVAL_DEREF(zptr);
				SEPARATE_ZVAL_NOREF(zptr);

				if (inc) {
					increment_function(zptr);
				} else {
					decrement_function(zptr);
				}
			}
			if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
				ZVAL_COPY(EX_VAR(opline->result.var), zptr);
			}
		} else {
			zend_pre_incdec_overloaded_property(object, property, (((IS_TMP_VAR|IS_VAR) == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), inc, (UNEXPECTED(RETURN_VALUE_USED(opline)) ? EX_VAR(opline->result.var) : NULL));
		}
	} while (0);

	zval_ptr_dtor_nogc(free_op2);
	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_PRE_INC_OBJ_SPEC_VAR_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	ZEND_VM_TAIL_CALL(zend_pre_incdec_property_helper_SPEC_VAR_TMPVAR(1 ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_PRE_DEC_OBJ_SPEC_VAR_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	ZEND_VM_TAIL_CALL(zend_pre_incdec_property_helper_SPEC_VAR_TMPVAR(0 ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL zend_post_incdec_property_helper_SPEC_VAR_TMPVAR(int inc ZEND_OPCODE_HANDLER_ARGS_DC)
{
	USE_OPLINE
	zend_free_op free_op1, free_op2;
	zval *object;
	zval *property;
	zval *zptr;

	SAVE_OPLINE();
	object = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

	if (IS_VAR == IS_UNUSED && UNEXPECTED(Z_OBJ_P(object) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");
		zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
		HANDLE_EXCEPTION();
	}

	property = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);

	if (IS_VAR == IS_VAR && UNEXPECTED(object == NULL)) {
		zend_throw_error(NULL, "Cannot increment/decrement overloaded objects nor string offsets");
		zval_ptr_dtor_nogc(free_op2);
		HANDLE_EXCEPTION();
	}

	do {
		if (IS_VAR != IS_UNUSED && UNEXPECTED(Z_TYPE_P(object) != IS_OBJECT)) {
			ZVAL_DEREF(object);
			if (UNEXPECTED(!make_real_object(object))) {
				zend_error(E_WARNING, "Attempt to increment/decrement property of non-object");
				ZVAL_NULL(EX_VAR(opline->result.var));
				break;
			}
		}

		/* here we are sure we are dealing with an object */

		if (EXPECTED(Z_OBJ_HT_P(object)->get_property_ptr_ptr)
			&& EXPECTED((zptr = Z_OBJ_HT_P(object)->get_property_ptr_ptr(object, property, BP_VAR_RW, (((IS_TMP_VAR|IS_VAR) == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL))) != NULL)) {

			if (EXPECTED(Z_TYPE_P(zptr) == IS_LONG)) {
				ZVAL_COPY_VALUE(EX_VAR(opline->result.var), zptr);
				if (inc) {
					fast_long_increment_function(zptr);
				} else {
					fast_long_decrement_function(zptr);
				}
			} else {
				ZVAL_DEREF(zptr);
				ZVAL_COPY_VALUE(EX_VAR(opline->result.var), zptr);
				zval_opt_copy_ctor(zptr);
				if (inc) {
					increment_function(zptr);
				} else {
					decrement_function(zptr);
				}
			}
		} else {
			zend_post_incdec_overloaded_property(object, property, (((IS_TMP_VAR|IS_VAR) == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), inc, EX_VAR(opline->result.var));
		}
	} while (0);

	zval_ptr_dtor_nogc(free_op2);
	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_POST_INC_OBJ_SPEC_VAR_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	ZEND_VM_TAIL_CALL(zend_post_incdec_property_helper_SPEC_VAR_TMPVAR(1 ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_POST_DEC_OBJ_SPEC_VAR_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	ZEND_VM_TAIL_CALL(zend_post_incdec_property_helper_SPEC_VAR_TMPVAR(0 ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_DIM_W_SPEC_VAR_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1, free_op2;
	zval *container;

	SAVE_OPLINE();
	container = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

	if (IS_VAR == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an array");
		HANDLE_EXCEPTION();
	}
	zend_fetch_dimension_address_W(EX_VAR(opline->result.var), container, _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2), (IS_TMP_VAR|IS_VAR));
	zval_ptr_dtor_nogc(free_op2);
	if (IS_VAR == IS_VAR && READY_TO_DESTROY(free_op1)) {
		EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 1);
	}
	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_DIM_RW_SPEC_VAR_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1, free_op2;
	zval *container;

	SAVE_OPLINE();
	container = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

	if (IS_VAR == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an array");
		HANDLE_EXCEPTION();
	}
	zend_fetch_dimension_address_RW(EX_VAR(opline->result.var), container, _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2), (IS_TMP_VAR|IS_VAR));
	zval_ptr_dtor_nogc(free_op2);
	if (IS_VAR == IS_VAR && READY_TO_DESTROY(free_op1)) {
		EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 1);
	}
	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_DIM_FUNC_ARG_SPEC_VAR_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *container;
	zend_free_op free_op1, free_op2;

	SAVE_OPLINE();

	if (zend_is_by_ref_func_arg_fetch(opline, EX(call))) {
        if (IS_VAR == IS_CONST || IS_VAR == IS_TMP_VAR) {
            zend_throw_error(NULL, "Cannot use temporary expression in write context");
			zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
			zval_ptr_dtor_nogc(EX_VAR(opline->op1.var));
			HANDLE_EXCEPTION();
        }
		container = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);
		if (IS_VAR == IS_VAR && UNEXPECTED(container == NULL)) {
			zend_throw_error(NULL, "Cannot use string offset as an array");
			zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
			HANDLE_EXCEPTION();
		}
		zend_fetch_dimension_address_W(EX_VAR(opline->result.var), container, _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2), (IS_TMP_VAR|IS_VAR));
		if (IS_VAR == IS_VAR && READY_TO_DESTROY(free_op1)) {
			EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 1);
		}
		zval_ptr_dtor_nogc(free_op2);
		if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	} else {
		if ((IS_TMP_VAR|IS_VAR) == IS_UNUSED) {
			zend_throw_error(NULL, "Cannot use [] for reading");
			zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
			zval_ptr_dtor_nogc(EX_VAR(opline->op1.var));
			HANDLE_EXCEPTION();
		}
		container = _get_zval_ptr_var(opline->op1.var, execute_data, &free_op1);
		zend_fetch_dimension_address_read_R(EX_VAR(opline->result.var), container, _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2), (IS_TMP_VAR|IS_VAR));
		zval_ptr_dtor_nogc(free_op2);
		zval_ptr_dtor_nogc(free_op1);
	}
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_DIM_UNSET_SPEC_VAR_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1, free_op2;
	zval *container;

	SAVE_OPLINE();
	container = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

	if (IS_VAR == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an array");
		zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
		HANDLE_EXCEPTION();
	}
	zend_fetch_dimension_address_UNSET(EX_VAR(opline->result.var), container, _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2), (IS_TMP_VAR|IS_VAR));
	zval_ptr_dtor_nogc(free_op2);
	if (IS_VAR == IS_VAR && READY_TO_DESTROY(free_op1)) {
		EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 1);
	}
	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_R_SPEC_VAR_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *container;
	zend_free_op free_op2;
	zval *offset;

	SAVE_OPLINE();
	container = _get_zval_ptr_var(opline->op1.var, execute_data, &free_op1);

	if (IS_VAR == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");
		zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
		HANDLE_EXCEPTION();
	}

	offset = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);

	if (IS_VAR == IS_CONST ||
	    (IS_VAR != IS_UNUSED && UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT))) {
		if ((IS_VAR & (IS_VAR|IS_CV)) && Z_ISREF_P(container)) {
			container = Z_REFVAL_P(container);
			if (UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT)) {
				goto fetch_obj_r_no_object;
			}
		} else {
			goto fetch_obj_r_no_object;
		}
	}

	/* here we are sure we are dealing with an object */
	do {
		zend_object *zobj = Z_OBJ_P(container);
		zval *retval;

		if ((IS_TMP_VAR|IS_VAR) == IS_CONST &&
			EXPECTED(zobj->ce == CACHED_PTR(Z_CACHE_SLOT_P(offset)))) {
			uint32_t prop_offset = (uint32_t)(intptr_t)CACHED_PTR(Z_CACHE_SLOT_P(offset) + sizeof(void*));

			if (EXPECTED(prop_offset != (uint32_t)ZEND_DYNAMIC_PROPERTY_OFFSET)) {
				retval = OBJ_PROP(zobj, prop_offset);
				if (EXPECTED(Z_TYPE_P(retval) != IS_UNDEF)) {
					ZVAL_COPY(EX_VAR(opline->result.var), retval);
					break;
				}
			} else if (EXPECTED(zobj->properties != NULL)) {
				retval = zend_hash_find(zobj->properties, Z_STR_P(offset));
				if (EXPECTED(retval)) {
					ZVAL_COPY(EX_VAR(opline->result.var), retval);
					break;
				}
			}
		}

		if (UNEXPECTED(zobj->handlers->read_property == NULL)) {
fetch_obj_r_no_object:
			zend_error(E_NOTICE, "Trying to get property of non-object");
			ZVAL_NULL(EX_VAR(opline->result.var));
		} else {
			retval = zobj->handlers->read_property(container, offset, BP_VAR_R, (((IS_TMP_VAR|IS_VAR) == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(offset)) : NULL), EX_VAR(opline->result.var));

			if (retval != EX_VAR(opline->result.var)) {
				ZVAL_COPY(EX_VAR(opline->result.var), retval);
			}
		}
	} while (0);

	zval_ptr_dtor_nogc(free_op2);
	zval_ptr_dtor_nogc(free_op1);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_W_SPEC_VAR_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1, free_op2;
	zval *property;
	zval *container;

	SAVE_OPLINE();
	property = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);

	container = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);
	if (IS_VAR == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");
		zval_ptr_dtor_nogc(free_op2);
		HANDLE_EXCEPTION();
	}
	if (IS_VAR == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an object");
		zval_ptr_dtor_nogc(free_op2);
		HANDLE_EXCEPTION();
	}

	zend_fetch_property_address(EX_VAR(opline->result.var), container, IS_VAR, property, (IS_TMP_VAR|IS_VAR), (((IS_TMP_VAR|IS_VAR) == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), BP_VAR_W);
	zval_ptr_dtor_nogc(free_op2);
	if (IS_VAR == IS_VAR && READY_TO_DESTROY(free_op1)) {
		EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 0);
	}
	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_RW_SPEC_VAR_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1, free_op2;
	zval *property;
	zval *container;

	SAVE_OPLINE();
	property = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);
	container = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

	if (IS_VAR == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");
		zval_ptr_dtor_nogc(free_op2);
		HANDLE_EXCEPTION();
	}
	if (IS_VAR == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an object");
		zval_ptr_dtor_nogc(free_op2);
		HANDLE_EXCEPTION();
	}
	zend_fetch_property_address(EX_VAR(opline->result.var), container, IS_VAR, property, (IS_TMP_VAR|IS_VAR), (((IS_TMP_VAR|IS_VAR) == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), BP_VAR_RW);
	zval_ptr_dtor_nogc(free_op2);
	if (IS_VAR == IS_VAR && READY_TO_DESTROY(free_op1)) {
		EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 0);
	}
	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_FUNC_ARG_SPEC_VAR_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *container;

	if (zend_is_by_ref_func_arg_fetch(opline, EX(call))) {
		/* Behave like FETCH_OBJ_W */
		zend_free_op free_op1, free_op2;
		zval *property;

		SAVE_OPLINE();
		property = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);
		container = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

		if (IS_VAR == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
			zend_throw_error(NULL, "Using $this when not in object context");
			zval_ptr_dtor_nogc(free_op2);
			HANDLE_EXCEPTION();
		}
		if (IS_VAR == IS_CONST || IS_VAR == IS_TMP_VAR) {
			zend_throw_error(NULL, "Cannot use temporary expression in write context");
			zval_ptr_dtor_nogc(free_op2);
			if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
			HANDLE_EXCEPTION();
		}
		if (IS_VAR == IS_VAR && UNEXPECTED(container == NULL)) {
			zend_throw_error(NULL, "Cannot use string offset as an object");
			zval_ptr_dtor_nogc(free_op2);
			HANDLE_EXCEPTION();
		}
		zend_fetch_property_address(EX_VAR(opline->result.var), container, IS_VAR, property, (IS_TMP_VAR|IS_VAR), (((IS_TMP_VAR|IS_VAR) == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), BP_VAR_W);
		zval_ptr_dtor_nogc(free_op2);
		if (IS_VAR == IS_VAR && READY_TO_DESTROY(free_op1)) {
			EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 0);
		}
		if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	} else {
		ZEND_VM_TAIL_CALL(ZEND_FETCH_OBJ_R_SPEC_VAR_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS_PASSTHRU));
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_UNSET_SPEC_VAR_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1, free_op2;
	zval *container, *property;

	SAVE_OPLINE();
	container = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

	if (IS_VAR == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");
		zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
		HANDLE_EXCEPTION();
	}

	property = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);

	if (IS_VAR == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an object");
		zval_ptr_dtor_nogc(free_op2);
		HANDLE_EXCEPTION();
	}
	zend_fetch_property_address(EX_VAR(opline->result.var), container, IS_VAR, property, (IS_TMP_VAR|IS_VAR), (((IS_TMP_VAR|IS_VAR) == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), BP_VAR_UNSET);
	zval_ptr_dtor_nogc(free_op2);
	if (IS_VAR == IS_VAR && READY_TO_DESTROY(free_op1)) {
		EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 0);
	}
	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_OBJ_SPEC_VAR_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1, free_op2;
	zval *object;
	zval *property_name;

	SAVE_OPLINE();
	object = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

	if (IS_VAR == IS_UNUSED && UNEXPECTED(Z_OBJ_P(object) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");
		zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
		HANDLE_EXCEPTION();
	}

	property_name = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);

	if (IS_VAR == IS_VAR && UNEXPECTED(object == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an array");
		zval_ptr_dtor_nogc(free_op2);
		HANDLE_EXCEPTION();
	}
	zend_assign_to_object(UNEXPECTED(RETURN_VALUE_USED(opline)) ? EX_VAR(opline->result.var) : NULL, object, IS_VAR, property_name, (IS_TMP_VAR|IS_VAR), (opline+1)->op1_type, (opline+1)->op1, execute_data, (((IS_TMP_VAR|IS_VAR) == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property_name)) : NULL));
	zval_ptr_dtor_nogc(free_op2);
	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	/* assign_obj has two opcodes! */
	ZEND_VM_NEXT_OPCODE_EX(1, 2);
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_DIM_SPEC_VAR_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *object_ptr;
	zend_free_op free_op2, free_op_data1;
	zval *value;
	zval *variable_ptr;
	zval *dim;

	SAVE_OPLINE();
	object_ptr = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);

	if (IS_VAR == IS_VAR && UNEXPECTED(object_ptr == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an array");
		FREE_UNFETCHED_OP((opline+1)->op1_type, (opline+1)->op1.var);
		zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
		HANDLE_EXCEPTION();
	}

	if (EXPECTED(Z_TYPE_P(object_ptr) == IS_ARRAY)) {
try_assign_dim_array:
		if ((IS_TMP_VAR|IS_VAR) == IS_UNUSED) {
			SEPARATE_ARRAY(object_ptr);
			variable_ptr = zend_hash_next_index_insert(Z_ARRVAL_P(object_ptr), &EG(uninitialized_zval));
			if (UNEXPECTED(variable_ptr == NULL)) {
				zend_error(E_WARNING, "Cannot add element to the array as the next element is already occupied");
				variable_ptr = &EG(error_zval);
			}
		} else {
			dim = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);
			SEPARATE_ARRAY(object_ptr);
			variable_ptr = zend_fetch_dimension_address_inner(Z_ARRVAL_P(object_ptr), dim, (IS_TMP_VAR|IS_VAR), BP_VAR_W);
			zval_ptr_dtor_nogc(free_op2);
		}
		value = get_zval_ptr((opline+1)->op1_type, (opline+1)->op1, execute_data, &free_op_data1, BP_VAR_R);
		if (UNEXPECTED(variable_ptr == &EG(error_zval))) {
			FREE_OP(free_op_data1);
			if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
				ZVAL_NULL(EX_VAR(opline->result.var));
			}
		} else {
			value = zend_assign_to_variable(variable_ptr, value, (opline+1)->op1_type);
			if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
				ZVAL_COPY(EX_VAR(opline->result.var), value);
			}
		}
	} else {
		if (EXPECTED(Z_ISREF_P(object_ptr))) {
			object_ptr = Z_REFVAL_P(object_ptr);
			if (EXPECTED(Z_TYPE_P(object_ptr) == IS_ARRAY)) {
				goto try_assign_dim_array;
			}
		}
		if (EXPECTED(Z_TYPE_P(object_ptr) == IS_OBJECT)) {
			zend_free_op free_op2;
			zval *property_name = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);

			zend_assign_to_object_dim(UNEXPECTED(RETURN_VALUE_USED(opline)) ? EX_VAR(opline->result.var) : NULL, object_ptr, property_name, (opline+1)->op1_type, (opline+1)->op1, execute_data);
			zval_ptr_dtor_nogc(free_op2);
		} else if (EXPECTED(Z_TYPE_P(object_ptr) == IS_STRING)) {
			if (EXPECTED(Z_STRLEN_P(object_ptr) != 0)) {
				if ((IS_TMP_VAR|IS_VAR) == IS_UNUSED) {
					zend_throw_error(NULL, "[] operator not supported for strings");
					FREE_UNFETCHED_OP((opline+1)->op1_type, (opline+1)->op1.var);
					if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
					HANDLE_EXCEPTION();
				} else {
					zend_long offset;

					dim = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);
					offset = zend_fetch_string_offset(object_ptr, dim, BP_VAR_W);
					zval_ptr_dtor_nogc(free_op2);
					value = get_zval_ptr_deref((opline+1)->op1_type, (opline+1)->op1, execute_data, &free_op_data1, BP_VAR_R);
					zend_assign_to_string_offset(object_ptr, offset, value, (UNEXPECTED(RETURN_VALUE_USED(opline)) ? EX_VAR(opline->result.var) : NULL));
					FREE_OP(free_op_data1);
				}
			} else {
				zval_ptr_dtor_nogc(object_ptr);
assign_dim_convert_to_array:
				ZVAL_NEW_ARR(object_ptr);
				zend_hash_init(Z_ARRVAL_P(object_ptr), 8, NULL, ZVAL_PTR_DTOR, 0);
				goto try_assign_dim_array;
			}
		} else if (EXPECTED(Z_TYPE_P(object_ptr) <= IS_FALSE)) {
			if (IS_VAR == IS_VAR && UNEXPECTED(object_ptr == &EG(error_zval))) {
				goto assign_dim_clean;
			}
			goto assign_dim_convert_to_array;
		} else {
			zend_error(E_WARNING, "Cannot use a scalar value as an array");
assign_dim_clean:
			dim = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);
			zval_ptr_dtor_nogc(free_op2);
			value = get_zval_ptr((opline+1)->op1_type, (opline+1)->op1, execute_data, &free_op_data1, BP_VAR_R);
			FREE_OP(free_op_data1);
			if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
				ZVAL_NULL(EX_VAR(opline->result.var));
			}
		}
	}
 	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	/* assign_dim has two opcodes! */
	ZEND_VM_NEXT_OPCODE_EX(1, 2);
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_INIT_STATIC_METHOD_CALL_SPEC_VAR_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *function_name;
	zend_class_entry *ce;
	zend_object *object;
	zend_function *fbc;
	zend_execute_data *call;

	SAVE_OPLINE();

	if (IS_VAR == IS_CONST) {
		/* no function found. try a static method in class */
		if (EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1))))) {
			ce = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)));
		} else {
			ce = zend_fetch_class_by_name(Z_STR_P(EX_CONSTANT(opline->op1)), EX_CONSTANT(opline->op1) + 1, ZEND_FETCH_CLASS_DEFAULT |  ZEND_FETCH_CLASS_EXCEPTION);
			if (UNEXPECTED(EG(exception) != NULL)) {
				HANDLE_EXCEPTION();
			}
			if (UNEXPECTED(ce == NULL)) {
				zend_throw_error(NULL, "Class '%s' not found", Z_STRVAL_P(EX_CONSTANT(opline->op1)));
				HANDLE_EXCEPTION();
			}
			CACHE_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)), ce);
		}
	} else {
		ce = Z_CE_P(EX_VAR(opline->op1.var));
	}

	if (IS_VAR == IS_CONST &&
	    (IS_TMP_VAR|IS_VAR) == IS_CONST &&
	    EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2))))) {
		fbc = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)));
	} else if (IS_VAR != IS_CONST &&
	           (IS_TMP_VAR|IS_VAR) == IS_CONST &&
	           (fbc = CACHED_POLYMORPHIC_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)), ce))) {
		/* do nothing */
	} else if ((IS_TMP_VAR|IS_VAR) != IS_UNUSED) {
		zend_free_op free_op2;

		function_name = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);
		if ((IS_TMP_VAR|IS_VAR) != IS_CONST) {
			if (UNEXPECTED(Z_TYPE_P(function_name) != IS_STRING)) {
				if ((IS_TMP_VAR|IS_VAR) == IS_CV && UNEXPECTED(Z_TYPE_P(function_name) == IS_UNDEF)) {
					GET_OP2_UNDEF_CV(function_name, BP_VAR_R);
				}
				if (UNEXPECTED(EG(exception) != NULL)) {
					HANDLE_EXCEPTION();
				}
				zend_throw_error(NULL, "Function name must be a string");
				zval_ptr_dtor_nogc(free_op2);
				HANDLE_EXCEPTION();
 			}
		}

		if (ce->get_static_method) {
			fbc = ce->get_static_method(ce, Z_STR_P(function_name));
		} else {
			fbc = zend_std_get_static_method(ce, Z_STR_P(function_name), (((IS_TMP_VAR|IS_VAR) == IS_CONST) ? (EX_CONSTANT(opline->op2) + 1) : NULL));
		}
		if (UNEXPECTED(fbc == NULL)) {
			if (EXPECTED(!EG(exception))) {
				zend_throw_error(NULL, "Call to undefined method %s::%s()", ZSTR_VAL(ce->name), Z_STRVAL_P(function_name));
			}
			zval_ptr_dtor_nogc(free_op2);
			HANDLE_EXCEPTION();
		}
		if ((IS_TMP_VAR|IS_VAR) == IS_CONST &&
		    EXPECTED(fbc->type <= ZEND_USER_FUNCTION) &&
		    EXPECTED(!(fbc->common.fn_flags & (ZEND_ACC_CALL_VIA_TRAMPOLINE|ZEND_ACC_NEVER_CACHE)))) {
			if (IS_VAR == IS_CONST) {
				CACHE_PTR(Z_CACHE_SLOT_P(function_name), fbc);
			} else {
				CACHE_POLYMORPHIC_PTR(Z_CACHE_SLOT_P(function_name), ce, fbc);
			}
		}
		if ((IS_TMP_VAR|IS_VAR) != IS_CONST) {
			zval_ptr_dtor_nogc(free_op2);
		}
	} else {
		if (UNEXPECTED(ce->constructor == NULL)) {
			zend_throw_error(NULL, "Cannot call constructor");
			HANDLE_EXCEPTION();
		}
		if (Z_OBJ(EX(This)) && Z_OBJ(EX(This))->ce != ce->constructor->common.scope && (ce->constructor->common.fn_flags & ZEND_ACC_PRIVATE)) {
			zend_throw_error(NULL, "Cannot call private %s::__construct()", ZSTR_VAL(ce->name));
			HANDLE_EXCEPTION();
		}
		fbc = ce->constructor;
	}

	object = NULL;
	if (!(fbc->common.fn_flags & ZEND_ACC_STATIC)) {
		if (Z_OBJ(EX(This)) && instanceof_function(Z_OBJCE(EX(This)), ce)) {
			object = Z_OBJ(EX(This));
		}
		if (!object) {
			if (fbc->common.fn_flags & ZEND_ACC_ALLOW_STATIC) {
				/* Allowed for PHP 4 compatibility. */
				zend_error(
					E_DEPRECATED,
					"Non-static method %s::%s() should not be called statically",
					ZSTR_VAL(fbc->common.scope->name), ZSTR_VAL(fbc->common.function_name));
				if (UNEXPECTED(EG(exception) != NULL)) {
					HANDLE_EXCEPTION();
				}
			} else {
				/* An internal function assumes $this is present and won't check that.
				 * So PHP would crash by allowing the call. */
				zend_throw_error(
					zend_ce_error,
					"Non-static method %s::%s() cannot be called statically",
					ZSTR_VAL(fbc->common.scope->name), ZSTR_VAL(fbc->common.function_name));
				HANDLE_EXCEPTION();
			}
		}
	}

	if (IS_VAR != IS_CONST) {
		/* previous opcode is ZEND_FETCH_CLASS */
		if (((opline-1)->extended_value & ZEND_FETCH_CLASS_MASK) == ZEND_FETCH_CLASS_PARENT ||
		    ((opline-1)->extended_value & ZEND_FETCH_CLASS_MASK) == ZEND_FETCH_CLASS_SELF) {
			ce = EX(called_scope);
		}
	}

	call = zend_vm_stack_push_call_frame(ZEND_CALL_NESTED_FUNCTION,
		fbc, opline->extended_value, ce, object);
	call->prev_execute_data = EX(call);
	EX(call) = call;

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ADD_ARRAY_ELEMENT_SPEC_VAR_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *expr_ptr, new_expr;

	SAVE_OPLINE();
	if ((IS_VAR == IS_VAR || IS_VAR == IS_CV) &&
	    UNEXPECTED(opline->extended_value & ZEND_ARRAY_ELEMENT_REF)) {
		expr_ptr = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);
		if (IS_VAR == IS_VAR && UNEXPECTED(expr_ptr == NULL)) {
			zend_throw_error(NULL, "Cannot create references to/from string offsets");
			zend_array_destroy(Z_ARRVAL_P(EX_VAR(opline->result.var)));
			HANDLE_EXCEPTION();
		}
		ZVAL_MAKE_REF(expr_ptr);
		Z_ADDREF_P(expr_ptr);
		if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	} else {
		expr_ptr = _get_zval_ptr_var(opline->op1.var, execute_data, &free_op1);
		if (IS_VAR == IS_TMP_VAR) {
			/* pass */
		} else if (IS_VAR == IS_CONST) {
			if (UNEXPECTED(Z_OPT_COPYABLE_P(expr_ptr))) {
				ZVAL_COPY_VALUE(&new_expr, expr_ptr);
				zval_copy_ctor_func(&new_expr);
				expr_ptr = &new_expr;
			}
		} else if (IS_VAR == IS_CV) {
			ZVAL_DEREF(expr_ptr);
			if (Z_REFCOUNTED_P(expr_ptr)) {
				Z_ADDREF_P(expr_ptr);
			}
		} else /* if (IS_VAR == IS_VAR) */ {
			if (UNEXPECTED(Z_ISREF_P(expr_ptr))) {
				zend_refcounted *ref = Z_COUNTED_P(expr_ptr);

				expr_ptr = Z_REFVAL_P(expr_ptr);
				if (UNEXPECTED(--GC_REFCOUNT(ref) == 0)) {
					ZVAL_COPY_VALUE(&new_expr, expr_ptr);
					expr_ptr = &new_expr;
					efree_size(ref, sizeof(zend_reference));
				} else if (Z_OPT_REFCOUNTED_P(expr_ptr)) {
					Z_ADDREF_P(expr_ptr);
				}
			}
		}
	}

	if ((IS_TMP_VAR|IS_VAR) != IS_UNUSED) {
		zend_free_op free_op2;
		zval *offset = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);
		zend_string *str;
		zend_ulong hval;

add_again:
		if (EXPECTED(Z_TYPE_P(offset) == IS_STRING)) {
			str = Z_STR_P(offset);
			if ((IS_TMP_VAR|IS_VAR) != IS_CONST) {
				if (ZEND_HANDLE_NUMERIC(str, hval)) {
					goto num_index;
				}
			}
str_index:
			zend_hash_update(Z_ARRVAL_P(EX_VAR(opline->result.var)), str, expr_ptr);
		} else if (EXPECTED(Z_TYPE_P(offset) == IS_LONG)) {
			hval = Z_LVAL_P(offset);
num_index:
			zend_hash_index_update(Z_ARRVAL_P(EX_VAR(opline->result.var)), hval, expr_ptr);
		} else if (((IS_TMP_VAR|IS_VAR) & (IS_VAR|IS_CV)) && EXPECTED(Z_TYPE_P(offset) == IS_REFERENCE)) {
			offset = Z_REFVAL_P(offset);
			goto add_again;
		} else if (Z_TYPE_P(offset) == IS_NULL) {
			str = ZSTR_EMPTY_ALLOC();
			goto str_index;
		} else if (Z_TYPE_P(offset) == IS_DOUBLE) {
			hval = zend_dval_to_lval(Z_DVAL_P(offset));
			goto num_index;
		} else if (Z_TYPE_P(offset) == IS_FALSE) {
			hval = 0;
			goto num_index;
		} else if (Z_TYPE_P(offset) == IS_TRUE) {
			hval = 1;
			goto num_index;
		} else if ((IS_TMP_VAR|IS_VAR) == IS_CV && Z_TYPE_P(offset) == IS_UNDEF) {
			GET_OP2_UNDEF_CV(offset, BP_VAR_R);
			str = ZSTR_EMPTY_ALLOC();
			goto str_index;
		} else {
			zend_error(E_WARNING, "Illegal offset type");
			zval_ptr_dtor(expr_ptr);
		}
		zval_ptr_dtor_nogc(free_op2);
	} else {
		zend_hash_next_index_insert(Z_ARRVAL_P(EX_VAR(opline->result.var)), expr_ptr);
	}
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_INIT_ARRAY_SPEC_VAR_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	zval *array;
	uint32_t size;
	USE_OPLINE

	array = EX_VAR(opline->result.var);
	if (IS_VAR != IS_UNUSED) {
		size = opline->extended_value >> ZEND_ARRAY_SIZE_SHIFT;
	} else {
		size = 0;
	}
	ZVAL_NEW_ARR(array);
	zend_hash_init(Z_ARRVAL_P(array), size, NULL, ZVAL_PTR_DTOR, 0);

	if (IS_VAR != IS_UNUSED) {
		/* Explicitly initialize array as not-packed if flag is set */
		if (opline->extended_value & ZEND_ARRAY_NOT_PACKED) {
			zend_hash_real_init(Z_ARRVAL_P(array), 0);
		}
	}

	if (IS_VAR == IS_UNUSED) {
		ZEND_VM_NEXT_OPCODE();
#if 0 || (IS_VAR != IS_UNUSED)
	} else {
		ZEND_VM_TAIL_CALL(ZEND_ADD_ARRAY_ELEMENT_SPEC_VAR_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS_PASSTHRU));
#endif
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_UNSET_DIM_SPEC_VAR_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1, free_op2;
	zval *container;
	zval *offset;
	zend_ulong hval;
	zend_string *key;

	SAVE_OPLINE();
	container = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);
	if (IS_VAR == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");
		zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
		HANDLE_EXCEPTION();
	}
	if (IS_VAR == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot unset string offsets");
		zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
		HANDLE_EXCEPTION();
	}
	offset = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);

	do {
		if (IS_VAR != IS_UNUSED && EXPECTED(Z_TYPE_P(container) == IS_ARRAY)) {
			HashTable *ht;

unset_dim_array:
			SEPARATE_ARRAY(container);
			ht = Z_ARRVAL_P(container);
offset_again:
			if (EXPECTED(Z_TYPE_P(offset) == IS_STRING)) {
				key = Z_STR_P(offset);
				if ((IS_TMP_VAR|IS_VAR) != IS_CONST) {
					if (ZEND_HANDLE_NUMERIC(key, hval)) {
						goto num_index_dim;
					}
				}
str_index_dim:
				if (ht == &EG(symbol_table)) {
					zend_delete_global_variable(key);
				} else {
					zend_hash_del(ht, key);
				}
			} else if (EXPECTED(Z_TYPE_P(offset) == IS_LONG)) {
				hval = Z_LVAL_P(offset);
num_index_dim:
				zend_hash_index_del(ht, hval);
			} else if (((IS_TMP_VAR|IS_VAR) & (IS_VAR|IS_CV)) && EXPECTED(Z_TYPE_P(offset) == IS_REFERENCE)) {
				offset = Z_REFVAL_P(offset);
				goto offset_again;
			} else if (Z_TYPE_P(offset) == IS_DOUBLE) {
				hval = zend_dval_to_lval(Z_DVAL_P(offset));
				goto num_index_dim;
			} else if (Z_TYPE_P(offset) == IS_NULL) {
				key = ZSTR_EMPTY_ALLOC();
				goto str_index_dim;
			} else if (Z_TYPE_P(offset) == IS_FALSE) {
				hval = 0;
				goto num_index_dim;
			} else if (Z_TYPE_P(offset) == IS_TRUE) {
				hval = 1;
				goto num_index_dim;
			} else if (Z_TYPE_P(offset) == IS_RESOURCE) {
				hval = Z_RES_HANDLE_P(offset);
				goto num_index_dim;
			} else if ((IS_TMP_VAR|IS_VAR) == IS_CV && Z_TYPE_P(offset) == IS_UNDEF) {
				GET_OP2_UNDEF_CV(offset, BP_VAR_R);
				key = ZSTR_EMPTY_ALLOC();
				goto str_index_dim;
			} else {
				zend_error(E_WARNING, "Illegal offset type in unset");
			}
			break;
		} else if (IS_VAR != IS_UNUSED && Z_ISREF_P(container)) {
			container = Z_REFVAL_P(container);
			if (EXPECTED(Z_TYPE_P(container) == IS_ARRAY)) {
				goto unset_dim_array;
			}
		}
		if ((IS_TMP_VAR|IS_VAR) == IS_CV && UNEXPECTED(Z_TYPE_P(offset) == IS_UNDEF)) {
			offset = GET_OP2_UNDEF_CV(offset, BP_VAR_R);
		}
		if (IS_VAR == IS_UNUSED || EXPECTED(Z_TYPE_P(container) == IS_OBJECT)) {
			if (UNEXPECTED(Z_OBJ_HT_P(container)->unset_dimension == NULL)) {
				zend_throw_error(NULL, "Cannot use object as array");
			} else {
				Z_OBJ_HT_P(container)->unset_dimension(container, offset);
			}
		} else if (IS_VAR != IS_UNUSED && UNEXPECTED(Z_TYPE_P(container) == IS_STRING)) {
			zend_throw_error(NULL, "Cannot unset string offsets");
		}
	} while (0);

	zval_ptr_dtor_nogc(free_op2);
	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_UNSET_OBJ_SPEC_VAR_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1, free_op2;
	zval *container;
	zval *offset;

	SAVE_OPLINE();
	container = _get_zval_ptr_ptr_var(opline->op1.var, execute_data, &free_op1);
	if (IS_VAR == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");
		zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
		HANDLE_EXCEPTION();
	}
	if (IS_VAR == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot unset string offsets");
		zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
		HANDLE_EXCEPTION();
	}
	offset = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);

	do {
		if (IS_VAR != IS_UNUSED && UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT)) {
			if (Z_ISREF_P(container)) {
				container = Z_REFVAL_P(container);
				if (Z_TYPE_P(container) != IS_OBJECT) {
					break;
				}
			} else {
				break;
			}
		}
		if (Z_OBJ_HT_P(container)->unset_property) {
			Z_OBJ_HT_P(container)->unset_property(container, offset, (((IS_TMP_VAR|IS_VAR) == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(offset)) : NULL));
		} else {
			zend_error(E_NOTICE, "Trying to unset property of non-object");
		}
	} while (0);

	zval_ptr_dtor_nogc(free_op2);
	if (free_op1) {zval_ptr_dtor_nogc(free_op1);};
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_POW_SPEC_VAR_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_VAR_TMPVAR(pow_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_CLONE_SPEC_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *obj;
	zend_class_entry *ce;
	zend_function *clone;
	zend_object_clone_obj_t clone_call;

	SAVE_OPLINE();
	obj = _get_obj_zval_ptr_unused(execute_data);

	if (IS_UNUSED == IS_UNUSED && UNEXPECTED(Z_OBJ_P(obj) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");
		HANDLE_EXCEPTION();
	}

	do {
		if (IS_UNUSED == IS_CONST ||
		    (IS_UNUSED != IS_UNUSED && UNEXPECTED(Z_TYPE_P(obj) != IS_OBJECT))) {
		    if ((IS_UNUSED & (IS_VAR|IS_CV)) && Z_ISREF_P(obj)) {
		    	obj = Z_REFVAL_P(obj);
		    	if (EXPECTED(Z_TYPE_P(obj) == IS_OBJECT)) {
		    		break;
				}
			}
			if (IS_UNUSED == IS_CV && UNEXPECTED(Z_TYPE_P(obj) == IS_UNDEF)) {
				GET_OP1_UNDEF_CV(obj, BP_VAR_R);
			}
			if (UNEXPECTED(EG(exception) != NULL)) {
				HANDLE_EXCEPTION();
			}
			zend_throw_error(NULL, "__clone method called on non-object");

			HANDLE_EXCEPTION();
		}
	} while (0);

	ce = Z_OBJCE_P(obj);
	clone = ce ? ce->clone : NULL;
	clone_call =  Z_OBJ_HT_P(obj)->clone_obj;
	if (UNEXPECTED(clone_call == NULL)) {
		if (ce) {
			zend_throw_error(NULL, "Trying to clone an uncloneable object of class %s", ZSTR_VAL(ce->name));
		} else {
			zend_throw_error(NULL, "Trying to clone an uncloneable object");
		}

		HANDLE_EXCEPTION();
	}

	if (ce && clone) {
		if (clone->op_array.fn_flags & ZEND_ACC_PRIVATE) {
			/* Ensure that if we're calling a private function, we're allowed to do so.
			 */
			if (UNEXPECTED(ce != EG(scope))) {
				zend_throw_error(NULL, "Call to private %s::__clone() from context '%s'", ZSTR_VAL(ce->name), EG(scope) ? ZSTR_VAL(EG(scope)->name) : "");

				HANDLE_EXCEPTION();
			}
		} else if ((clone->common.fn_flags & ZEND_ACC_PROTECTED)) {
			/* Ensure that if we're calling a protected function, we're allowed to do so.
			 */
			if (UNEXPECTED(!zend_check_protected(zend_get_function_root_class(clone), EG(scope)))) {
				zend_throw_error(NULL, "Call to protected %s::__clone() from context '%s'", ZSTR_VAL(ce->name), EG(scope) ? ZSTR_VAL(EG(scope)->name) : "");

				HANDLE_EXCEPTION();
			}
		}
	}

	if (EXPECTED(EG(exception) == NULL)) {
		ZVAL_OBJ(EX_VAR(opline->result.var), clone_call(obj));
		if (UNEXPECTED(!RETURN_VALUE_USED(opline)) || UNEXPECTED(EG(exception) != NULL)) {
			OBJ_RELEASE(Z_OBJ_P(EX_VAR(opline->result.var)));
		}
	}

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_EXIT_SPEC_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	SAVE_OPLINE();
	if (IS_UNUSED != IS_UNUSED) {

		zval *ptr = NULL;

		do {
			if (Z_TYPE_P(ptr) == IS_LONG) {
				EG(exit_status) = Z_LVAL_P(ptr);
			} else {
				if ((IS_UNUSED & (IS_VAR|IS_CV)) && Z_ISREF_P(ptr)) {
					ptr = Z_REFVAL_P(ptr);
					if (Z_TYPE_P(ptr) == IS_LONG) {
						EG(exit_status) = Z_LVAL_P(ptr);
						break;
					}
				}
				zend_print_variable(ptr);
			}
		} while (0);

	}
	zend_bailout();
	ZEND_VM_NEXT_OPCODE(); /* Never reached */
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL zend_binary_assign_op_obj_helper_SPEC_UNUSED_CONST(binary_op_type binary_op ZEND_OPCODE_HANDLER_ARGS_DC)
{
	USE_OPLINE
	zend_free_op free_op_data1;
	zval *object;
	zval *property;
	zval *value;
	zval *zptr;

	SAVE_OPLINE();
	object = _get_obj_zval_ptr_unused(execute_data);

	if (IS_UNUSED == IS_UNUSED && UNEXPECTED(Z_OBJ_P(object) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");
		FREE_UNFETCHED_OP((opline+1)->op1_type, (opline+1)->op1.var);

		HANDLE_EXCEPTION();
	}

	property = EX_CONSTANT(opline->op2);

	if (IS_UNUSED == IS_VAR && UNEXPECTED(object == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an object");
		FREE_UNFETCHED_OP((opline+1)->op1_type, (opline+1)->op1.var);

		HANDLE_EXCEPTION();
	}

	do {
		value = get_zval_ptr((opline+1)->op1_type, (opline+1)->op1, execute_data, &free_op_data1, BP_VAR_R);

		if (IS_UNUSED != IS_UNUSED && UNEXPECTED(Z_TYPE_P(object) != IS_OBJECT)) {
			ZVAL_DEREF(object);
			if (UNEXPECTED(!make_real_object(object))) {
				zend_error(E_WARNING, "Attempt to assign property of non-object");
				if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
					ZVAL_NULL(EX_VAR(opline->result.var));
				}
				break;
			}
		}

		/* here we are sure we are dealing with an object */
		if (EXPECTED(Z_OBJ_HT_P(object)->get_property_ptr_ptr)
			&& EXPECTED((zptr = Z_OBJ_HT_P(object)->get_property_ptr_ptr(object, property, BP_VAR_RW, ((IS_CONST == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL))) != NULL)) {

			ZVAL_DEREF(zptr);
			SEPARATE_ZVAL_NOREF(zptr);

			binary_op(zptr, zptr, value);
			if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
				ZVAL_COPY(EX_VAR(opline->result.var), zptr);
			}
		} else {
			zend_assign_op_overloaded_property(object, property, ((IS_CONST == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), value, binary_op, (UNEXPECTED(RETURN_VALUE_USED(opline)) ? EX_VAR(opline->result.var) : NULL));
		}
	} while (0);

	FREE_OP(free_op_data1);


	/* assign_obj has two opcodes! */
	ZEND_VM_NEXT_OPCODE_EX(1, 2);
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL zend_binary_assign_op_dim_helper_SPEC_UNUSED_CONST(binary_op_type binary_op ZEND_OPCODE_HANDLER_ARGS_DC)
{
	USE_OPLINE
	zend_free_op free_op_data1;
	zval *var_ptr, rv;
	zval *value, *container, *dim;

	SAVE_OPLINE();
	container = _get_obj_zval_ptr_unused(execute_data);
	if (IS_UNUSED == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");
		FREE_UNFETCHED_OP((opline+1)->op1_type, (opline+1)->op1.var);

		HANDLE_EXCEPTION();
	}
	if (IS_UNUSED == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an array");
		FREE_UNFETCHED_OP((opline+1)->op1_type, (opline+1)->op1.var);

		HANDLE_EXCEPTION();
	}

	dim = EX_CONSTANT(opline->op2);

	do {
		if (IS_UNUSED == IS_UNUSED || UNEXPECTED(Z_TYPE_P(container) != IS_ARRAY)) {
			if (IS_UNUSED != IS_UNUSED) {
				ZVAL_DEREF(container);
			}
			if (IS_UNUSED == IS_UNUSED || EXPECTED(Z_TYPE_P(container) == IS_OBJECT)) {
				value = get_zval_ptr((opline+1)->op1_type, (opline+1)->op1, execute_data, &free_op_data1, BP_VAR_R);
				zend_binary_assign_op_obj_dim(container, dim, value, UNEXPECTED(RETURN_VALUE_USED(opline)) ? EX_VAR(opline->result.var) : NULL, binary_op);
				break;
			}
		}

		zend_fetch_dimension_address_RW(&rv, container, dim, IS_CONST);
		value = get_zval_ptr((opline+1)->op1_type, (opline+1)->op1, execute_data, &free_op_data1, BP_VAR_R);
		ZEND_ASSERT(Z_TYPE(rv) == IS_INDIRECT);
		var_ptr = Z_INDIRECT(rv);

		if (UNEXPECTED(var_ptr == NULL)) {
			zend_throw_error(NULL, "Cannot use assign-op operators with overloaded objects nor string offsets");

			FREE_OP(free_op_data1);

			HANDLE_EXCEPTION();
		}

		if (UNEXPECTED(var_ptr == &EG(error_zval))) {
			if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
				ZVAL_NULL(EX_VAR(opline->result.var));
			}
		} else {
			ZVAL_DEREF(var_ptr);
			SEPARATE_ZVAL_NOREF(var_ptr);

			binary_op(var_ptr, var_ptr, value);

			if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
				ZVAL_COPY(EX_VAR(opline->result.var), var_ptr);
			}
		}
	} while (0);

	FREE_OP(free_op_data1);

	ZEND_VM_NEXT_OPCODE_EX(1, 2);
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_ADD_SPEC_UNUSED_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CONST != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_UNUSED != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_UNUSED_CONST(add_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_CONST(add_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_UNUSED_CONST(add_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_CONST(add_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_SUB_SPEC_UNUSED_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CONST != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_UNUSED != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_UNUSED_CONST(sub_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_CONST(sub_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_UNUSED_CONST(sub_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_CONST(sub_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_MUL_SPEC_UNUSED_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CONST != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_UNUSED != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_UNUSED_CONST(mul_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_CONST(mul_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_UNUSED_CONST(mul_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_CONST(mul_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_DIV_SPEC_UNUSED_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CONST != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_UNUSED != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_UNUSED_CONST(div_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_CONST(div_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_UNUSED_CONST(div_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_CONST(div_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_MOD_SPEC_UNUSED_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CONST != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_UNUSED != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_UNUSED_CONST(mod_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_CONST(mod_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_UNUSED_CONST(mod_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_CONST(mod_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_SL_SPEC_UNUSED_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CONST != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_UNUSED != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_UNUSED_CONST(shift_left_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_CONST(shift_left_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_UNUSED_CONST(shift_left_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_CONST(shift_left_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_SR_SPEC_UNUSED_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CONST != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_UNUSED != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_UNUSED_CONST(shift_right_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_CONST(shift_right_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_UNUSED_CONST(shift_right_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_CONST(shift_right_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_CONCAT_SPEC_UNUSED_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CONST != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_UNUSED != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_UNUSED_CONST(concat_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_CONST(concat_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_UNUSED_CONST(concat_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_CONST(concat_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_BW_OR_SPEC_UNUSED_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CONST != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_UNUSED != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_UNUSED_CONST(bitwise_or_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_CONST(bitwise_or_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_UNUSED_CONST(bitwise_or_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_CONST(bitwise_or_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_BW_AND_SPEC_UNUSED_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CONST != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_UNUSED != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_UNUSED_CONST(bitwise_and_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_CONST(bitwise_and_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_UNUSED_CONST(bitwise_and_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_CONST(bitwise_and_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_BW_XOR_SPEC_UNUSED_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CONST != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_UNUSED != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_UNUSED_CONST(bitwise_xor_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_CONST(bitwise_xor_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_UNUSED_CONST(bitwise_xor_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_CONST(bitwise_xor_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL zend_pre_incdec_property_helper_SPEC_UNUSED_CONST(int inc ZEND_OPCODE_HANDLER_ARGS_DC)
{
	USE_OPLINE

	zval *object;
	zval *property;
	zval *zptr;

	SAVE_OPLINE();
	object = _get_obj_zval_ptr_unused(execute_data);

	if (IS_UNUSED == IS_UNUSED && UNEXPECTED(Z_OBJ_P(object) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}

	property = EX_CONSTANT(opline->op2);

	if (IS_UNUSED == IS_VAR && UNEXPECTED(object == NULL)) {
		zend_throw_error(NULL, "Cannot increment/decrement overloaded objects nor string offsets");

		HANDLE_EXCEPTION();
	}

	do {
		if (IS_UNUSED != IS_UNUSED && UNEXPECTED(Z_TYPE_P(object) != IS_OBJECT)) {
			ZVAL_DEREF(object);
			if (UNEXPECTED(!make_real_object(object))) {
				zend_error(E_WARNING, "Attempt to increment/decrement property of non-object");
				if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
					ZVAL_NULL(EX_VAR(opline->result.var));
				}
				break;
			}
		}

		/* here we are sure we are dealing with an object */

		if (EXPECTED(Z_OBJ_HT_P(object)->get_property_ptr_ptr)
			&& EXPECTED((zptr = Z_OBJ_HT_P(object)->get_property_ptr_ptr(object, property, BP_VAR_RW, ((IS_CONST == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL))) != NULL)) {

			if (EXPECTED(Z_TYPE_P(zptr) == IS_LONG)) {
				if (inc) {
					fast_long_increment_function(zptr);
				} else {
					fast_long_decrement_function(zptr);
				}
			} else {
				ZVAL_DEREF(zptr);
				SEPARATE_ZVAL_NOREF(zptr);

				if (inc) {
					increment_function(zptr);
				} else {
					decrement_function(zptr);
				}
			}
			if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
				ZVAL_COPY(EX_VAR(opline->result.var), zptr);
			}
		} else {
			zend_pre_incdec_overloaded_property(object, property, ((IS_CONST == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), inc, (UNEXPECTED(RETURN_VALUE_USED(opline)) ? EX_VAR(opline->result.var) : NULL));
		}
	} while (0);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_PRE_INC_OBJ_SPEC_UNUSED_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	ZEND_VM_TAIL_CALL(zend_pre_incdec_property_helper_SPEC_UNUSED_CONST(1 ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_PRE_DEC_OBJ_SPEC_UNUSED_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	ZEND_VM_TAIL_CALL(zend_pre_incdec_property_helper_SPEC_UNUSED_CONST(0 ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL zend_post_incdec_property_helper_SPEC_UNUSED_CONST(int inc ZEND_OPCODE_HANDLER_ARGS_DC)
{
	USE_OPLINE

	zval *object;
	zval *property;
	zval *zptr;

	SAVE_OPLINE();
	object = _get_obj_zval_ptr_unused(execute_data);

	if (IS_UNUSED == IS_UNUSED && UNEXPECTED(Z_OBJ_P(object) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}

	property = EX_CONSTANT(opline->op2);

	if (IS_UNUSED == IS_VAR && UNEXPECTED(object == NULL)) {
		zend_throw_error(NULL, "Cannot increment/decrement overloaded objects nor string offsets");

		HANDLE_EXCEPTION();
	}

	do {
		if (IS_UNUSED != IS_UNUSED && UNEXPECTED(Z_TYPE_P(object) != IS_OBJECT)) {
			ZVAL_DEREF(object);
			if (UNEXPECTED(!make_real_object(object))) {
				zend_error(E_WARNING, "Attempt to increment/decrement property of non-object");
				ZVAL_NULL(EX_VAR(opline->result.var));
				break;
			}
		}

		/* here we are sure we are dealing with an object */

		if (EXPECTED(Z_OBJ_HT_P(object)->get_property_ptr_ptr)
			&& EXPECTED((zptr = Z_OBJ_HT_P(object)->get_property_ptr_ptr(object, property, BP_VAR_RW, ((IS_CONST == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL))) != NULL)) {

			if (EXPECTED(Z_TYPE_P(zptr) == IS_LONG)) {
				ZVAL_COPY_VALUE(EX_VAR(opline->result.var), zptr);
				if (inc) {
					fast_long_increment_function(zptr);
				} else {
					fast_long_decrement_function(zptr);
				}
			} else {
				ZVAL_DEREF(zptr);
				ZVAL_COPY_VALUE(EX_VAR(opline->result.var), zptr);
				zval_opt_copy_ctor(zptr);
				if (inc) {
					increment_function(zptr);
				} else {
					decrement_function(zptr);
				}
			}
		} else {
			zend_post_incdec_overloaded_property(object, property, ((IS_CONST == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), inc, EX_VAR(opline->result.var));
		}
	} while (0);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_POST_INC_OBJ_SPEC_UNUSED_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	ZEND_VM_TAIL_CALL(zend_post_incdec_property_helper_SPEC_UNUSED_CONST(1 ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_POST_DEC_OBJ_SPEC_UNUSED_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	ZEND_VM_TAIL_CALL(zend_post_incdec_property_helper_SPEC_UNUSED_CONST(0 ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_R_SPEC_UNUSED_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *container;

	zval *offset;

	SAVE_OPLINE();
	container = _get_obj_zval_ptr_unused(execute_data);

	if (IS_UNUSED == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}

	offset = EX_CONSTANT(opline->op2);

	if (IS_UNUSED == IS_CONST ||
	    (IS_UNUSED != IS_UNUSED && UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT))) {
		if ((IS_UNUSED & (IS_VAR|IS_CV)) && Z_ISREF_P(container)) {
			container = Z_REFVAL_P(container);
			if (UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT)) {
				goto fetch_obj_r_no_object;
			}
		} else {
			goto fetch_obj_r_no_object;
		}
	}

	/* here we are sure we are dealing with an object */
	do {
		zend_object *zobj = Z_OBJ_P(container);
		zval *retval;

		if (IS_CONST == IS_CONST &&
			EXPECTED(zobj->ce == CACHED_PTR(Z_CACHE_SLOT_P(offset)))) {
			uint32_t prop_offset = (uint32_t)(intptr_t)CACHED_PTR(Z_CACHE_SLOT_P(offset) + sizeof(void*));

			if (EXPECTED(prop_offset != (uint32_t)ZEND_DYNAMIC_PROPERTY_OFFSET)) {
				retval = OBJ_PROP(zobj, prop_offset);
				if (EXPECTED(Z_TYPE_P(retval) != IS_UNDEF)) {
					ZVAL_COPY(EX_VAR(opline->result.var), retval);
					break;
				}
			} else if (EXPECTED(zobj->properties != NULL)) {
				retval = zend_hash_find(zobj->properties, Z_STR_P(offset));
				if (EXPECTED(retval)) {
					ZVAL_COPY(EX_VAR(opline->result.var), retval);
					break;
				}
			}
		}

		if (UNEXPECTED(zobj->handlers->read_property == NULL)) {
fetch_obj_r_no_object:
			zend_error(E_NOTICE, "Trying to get property of non-object");
			ZVAL_NULL(EX_VAR(opline->result.var));
		} else {
			retval = zobj->handlers->read_property(container, offset, BP_VAR_R, ((IS_CONST == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(offset)) : NULL), EX_VAR(opline->result.var));

			if (retval != EX_VAR(opline->result.var)) {
				ZVAL_COPY(EX_VAR(opline->result.var), retval);
			}
		}
	} while (0);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_W_SPEC_UNUSED_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *property;
	zval *container;

	SAVE_OPLINE();
	property = EX_CONSTANT(opline->op2);

	container = _get_obj_zval_ptr_unused(execute_data);
	if (IS_UNUSED == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}
	if (IS_UNUSED == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an object");

		HANDLE_EXCEPTION();
	}

	zend_fetch_property_address(EX_VAR(opline->result.var), container, IS_UNUSED, property, IS_CONST, ((IS_CONST == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), BP_VAR_W);

	if (IS_UNUSED == IS_VAR && READY_TO_DESTROY(free_op1)) {
		EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 0);
	}

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_RW_SPEC_UNUSED_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *property;
	zval *container;

	SAVE_OPLINE();
	property = EX_CONSTANT(opline->op2);
	container = _get_obj_zval_ptr_unused(execute_data);

	if (IS_UNUSED == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}
	if (IS_UNUSED == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an object");

		HANDLE_EXCEPTION();
	}
	zend_fetch_property_address(EX_VAR(opline->result.var), container, IS_UNUSED, property, IS_CONST, ((IS_CONST == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), BP_VAR_RW);

	if (IS_UNUSED == IS_VAR && READY_TO_DESTROY(free_op1)) {
		EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 0);
	}

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_IS_SPEC_UNUSED_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *container;

	zval *offset;

	SAVE_OPLINE();
	container = _get_obj_zval_ptr_unused(execute_data);

	if (IS_UNUSED == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}

	offset  = EX_CONSTANT(opline->op2);

	if (IS_UNUSED == IS_CONST ||
	    (IS_UNUSED != IS_UNUSED && UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT))) {
		if ((IS_UNUSED & (IS_VAR|IS_CV)) && Z_ISREF_P(container)) {
			container = Z_REFVAL_P(container);
			if (UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT)) {
				goto fetch_obj_is_no_object;
			}
		} else {
			goto fetch_obj_is_no_object;
		}
	}

	/* here we are sure we are dealing with an object */
	do {
		zend_object *zobj = Z_OBJ_P(container);
		zval *retval;

		if (IS_CONST == IS_CONST &&
			EXPECTED(zobj->ce == CACHED_PTR(Z_CACHE_SLOT_P(offset)))) {
			uint32_t prop_offset = (uint32_t)(intptr_t)CACHED_PTR(Z_CACHE_SLOT_P(offset) + sizeof(void*));

			if (EXPECTED(prop_offset != (uint32_t)ZEND_DYNAMIC_PROPERTY_OFFSET)) {
				retval = OBJ_PROP(zobj, prop_offset);
				if (EXPECTED(Z_TYPE_P(retval) != IS_UNDEF)) {
					ZVAL_COPY(EX_VAR(opline->result.var), retval);
					break;
				}
			} else if (EXPECTED(zobj->properties != NULL)) {
				retval = zend_hash_find(zobj->properties, Z_STR_P(offset));
				if (EXPECTED(retval)) {
					ZVAL_COPY(EX_VAR(opline->result.var), retval);
					break;
				}
			}
		}

		if (UNEXPECTED(zobj->handlers->read_property == NULL)) {
fetch_obj_is_no_object:
			ZVAL_NULL(EX_VAR(opline->result.var));
		} else {

			retval = zobj->handlers->read_property(container, offset, BP_VAR_IS, ((IS_CONST == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(offset)) : NULL), EX_VAR(opline->result.var));

			if (retval != EX_VAR(opline->result.var)) {
				ZVAL_COPY(EX_VAR(opline->result.var), retval);
			}
		}
	} while (0);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_FUNC_ARG_SPEC_UNUSED_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *container;

	if (zend_is_by_ref_func_arg_fetch(opline, EX(call))) {
		/* Behave like FETCH_OBJ_W */
		zend_free_op free_op1;
		zval *property;

		SAVE_OPLINE();
		property = EX_CONSTANT(opline->op2);
		container = _get_obj_zval_ptr_unused(execute_data);

		if (IS_UNUSED == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
			zend_throw_error(NULL, "Using $this when not in object context");

			HANDLE_EXCEPTION();
		}
		if (IS_UNUSED == IS_CONST || IS_UNUSED == IS_TMP_VAR) {
			zend_throw_error(NULL, "Cannot use temporary expression in write context");


			HANDLE_EXCEPTION();
		}
		if (IS_UNUSED == IS_VAR && UNEXPECTED(container == NULL)) {
			zend_throw_error(NULL, "Cannot use string offset as an object");

			HANDLE_EXCEPTION();
		}
		zend_fetch_property_address(EX_VAR(opline->result.var), container, IS_UNUSED, property, IS_CONST, ((IS_CONST == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), BP_VAR_W);

		if (IS_UNUSED == IS_VAR && READY_TO_DESTROY(free_op1)) {
			EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 0);
		}

		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	} else {
		ZEND_VM_TAIL_CALL(ZEND_FETCH_OBJ_R_SPEC_UNUSED_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS_PASSTHRU));
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_UNSET_SPEC_UNUSED_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *container, *property;

	SAVE_OPLINE();
	container = _get_obj_zval_ptr_unused(execute_data);

	if (IS_UNUSED == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}

	property = EX_CONSTANT(opline->op2);

	if (IS_UNUSED == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an object");

		HANDLE_EXCEPTION();
	}
	zend_fetch_property_address(EX_VAR(opline->result.var), container, IS_UNUSED, property, IS_CONST, ((IS_CONST == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), BP_VAR_UNSET);

	if (IS_UNUSED == IS_VAR && READY_TO_DESTROY(free_op1)) {
		EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 0);
	}

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_OBJ_SPEC_UNUSED_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *object;
	zval *property_name;

	SAVE_OPLINE();
	object = _get_obj_zval_ptr_unused(execute_data);

	if (IS_UNUSED == IS_UNUSED && UNEXPECTED(Z_OBJ_P(object) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}

	property_name = EX_CONSTANT(opline->op2);

	if (IS_UNUSED == IS_VAR && UNEXPECTED(object == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an array");

		HANDLE_EXCEPTION();
	}
	zend_assign_to_object(UNEXPECTED(RETURN_VALUE_USED(opline)) ? EX_VAR(opline->result.var) : NULL, object, IS_UNUSED, property_name, IS_CONST, (opline+1)->op1_type, (opline+1)->op1, execute_data, ((IS_CONST == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property_name)) : NULL));


	/* assign_obj has two opcodes! */
	ZEND_VM_NEXT_OPCODE_EX(1, 2);
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ROPE_INIT_SPEC_UNUSED_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zend_string **rope;
	zval *var;

	/* Compiler allocates the necessary number of zval slots to keep the rope */
	rope = (zend_string**)EX_VAR(opline->result.var);
	if (IS_CONST == IS_CONST) {
		var = EX_CONSTANT(opline->op2);
		rope[0] = zend_string_copy(Z_STR_P(var));
	} else {
		var = EX_CONSTANT(opline->op2);
		if (EXPECTED(Z_TYPE_P(var) == IS_STRING)) {
			if (IS_CONST == IS_CV) {
				rope[0] = zend_string_copy(Z_STR_P(var));
			} else {
				rope[0] = Z_STR_P(var);
			}
		} else {
			SAVE_OPLINE();
			if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(var) == IS_UNDEF)) {
				GET_OP2_UNDEF_CV(var, BP_VAR_R);
			}
			rope[0] = _zval_get_string_func(var);

			ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
		}
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_INIT_METHOD_CALL_SPEC_UNUSED_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *function_name;

	zval *object;
	zend_function *fbc;
	zend_class_entry *called_scope;
	zend_object *obj;
	zend_execute_data *call;
	uint32_t call_info;

	SAVE_OPLINE();

	function_name = EX_CONSTANT(opline->op2);

	if (IS_CONST != IS_CONST &&
	    UNEXPECTED(Z_TYPE_P(function_name) != IS_STRING)) {
		do {
			if ((IS_CONST & (IS_VAR|IS_CV)) && Z_ISREF_P(function_name)) {
				function_name = Z_REFVAL_P(function_name);
				if (EXPECTED(Z_TYPE_P(function_name) == IS_STRING)) {
					break;
				}
			}
			if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(function_name) == IS_UNDEF)) {
				GET_OP2_UNDEF_CV(function_name, BP_VAR_R);
			}
			if (UNEXPECTED(EG(exception) != NULL)) {
				HANDLE_EXCEPTION();
			}
			zend_throw_error(NULL, "Method name must be a string");


			HANDLE_EXCEPTION();
		} while (0);
	}

	object = _get_obj_zval_ptr_unused(execute_data);

	if (IS_UNUSED == IS_UNUSED && UNEXPECTED(Z_OBJ_P(object) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}

	if (IS_UNUSED != IS_UNUSED) {
		do {
			if (IS_UNUSED == IS_CONST || UNEXPECTED(Z_TYPE_P(object) != IS_OBJECT)) {
				if ((IS_UNUSED & (IS_VAR|IS_CV)) && EXPECTED(Z_ISREF_P(object))) {
					object = Z_REFVAL_P(object);
					if (EXPECTED(Z_TYPE_P(object) == IS_OBJECT)) {
						break;
					}
				}
				if (IS_UNUSED == IS_CV && UNEXPECTED(Z_TYPE_P(object) == IS_UNDEF)) {
					GET_OP1_UNDEF_CV(object, BP_VAR_R);
				}
				if (UNEXPECTED(EG(exception) != NULL)) {
					HANDLE_EXCEPTION();
				}
				zend_throw_error(NULL, "Call to a member function %s() on %s", Z_STRVAL_P(function_name), zend_get_type_by_const(Z_TYPE_P(object)));


				HANDLE_EXCEPTION();
			}
		} while (0);
	}

	obj = Z_OBJ_P(object);
	called_scope = obj->ce;

	if (IS_CONST != IS_CONST ||
	    UNEXPECTED((fbc = CACHED_POLYMORPHIC_PTR(Z_CACHE_SLOT_P(function_name), called_scope)) == NULL)) {
	    zend_object *orig_obj = obj;

		if (UNEXPECTED(obj->handlers->get_method == NULL)) {
			zend_throw_error(NULL, "Object does not support method calls");


			HANDLE_EXCEPTION();
		}

		/* First, locate the function. */
		fbc = obj->handlers->get_method(&obj, Z_STR_P(function_name), ((IS_CONST == IS_CONST) ? (EX_CONSTANT(opline->op2) + 1) : NULL));
		if (UNEXPECTED(fbc == NULL)) {
			if (EXPECTED(!EG(exception))) {
				zend_throw_error(NULL, "Call to undefined method %s::%s()", ZSTR_VAL(obj->ce->name), Z_STRVAL_P(function_name));
			}


			HANDLE_EXCEPTION();
		}
		if (IS_CONST == IS_CONST &&
		    EXPECTED(fbc->type <= ZEND_USER_FUNCTION) &&
		    EXPECTED(!(fbc->common.fn_flags & (ZEND_ACC_CALL_VIA_TRAMPOLINE|ZEND_ACC_NEVER_CACHE))) &&
		    EXPECTED(obj == orig_obj)) {
			CACHE_POLYMORPHIC_PTR(Z_CACHE_SLOT_P(function_name), called_scope, fbc);
		}
	}

	call_info = ZEND_CALL_NESTED_FUNCTION;
	if (UNEXPECTED((fbc->common.fn_flags & ZEND_ACC_STATIC) != 0)) {
		obj = NULL;
	} else if (IS_UNUSED & (IS_VAR|IS_TMP_VAR|IS_CV)) {
		/* CV may be changed indirectly (e.g. when it's a reference) */
		call_info = ZEND_CALL_NESTED_FUNCTION | ZEND_CALL_RELEASE_THIS;
		GC_REFCOUNT(obj)++; /* For $this pointer */
	}

	call = zend_vm_stack_push_call_frame(call_info,
		fbc, opline->extended_value, called_scope, obj);
	call->prev_execute_data = EX(call);
	EX(call) = call;


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_CONSTANT_SPEC_UNUSED_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	SAVE_OPLINE();
	if (IS_UNUSED == IS_UNUSED) {
		zend_constant *c;

		if (EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2))))) {
			c = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)));
		} else if ((c = zend_quick_get_constant(EX_CONSTANT(opline->op2) + 1, opline->extended_value)) == NULL) {
			if ((opline->extended_value & IS_CONSTANT_UNQUALIFIED) != 0) {
				char *actual = (char *)zend_memrchr(Z_STRVAL_P(EX_CONSTANT(opline->op2)), '\\', Z_STRLEN_P(EX_CONSTANT(opline->op2)));
				if (!actual) {
					ZVAL_STR_COPY(EX_VAR(opline->result.var), Z_STR_P(EX_CONSTANT(opline->op2)));
				} else {
					actual++;
					ZVAL_STRINGL(EX_VAR(opline->result.var),
							actual, Z_STRLEN_P(EX_CONSTANT(opline->op2)) - (actual - Z_STRVAL_P(EX_CONSTANT(opline->op2))));
				}
				/* non-qualified constant - allow text substitution */
				zend_error(E_NOTICE, "Use of undefined constant %s - assumed '%s'",
						Z_STRVAL_P(EX_VAR(opline->result.var)), Z_STRVAL_P(EX_VAR(opline->result.var)));
				ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
			} else {
				zend_throw_error(NULL, "Undefined constant '%s'", Z_STRVAL_P(EX_CONSTANT(opline->op2)));
				HANDLE_EXCEPTION();
			}
		} else {
			CACHE_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)), c);
		}
#ifdef ZTS
		if (c->flags & CONST_PERSISTENT) {
			ZVAL_DUP(EX_VAR(opline->result.var), &c->value);
		} else {
			ZVAL_COPY(EX_VAR(opline->result.var), &c->value);
		}
#else
		ZVAL_COPY(EX_VAR(opline->result.var), &c->value);
#endif
	} else {
		/* class constant */
		zend_class_entry *ce;
		zval *value;

		do {
			if (IS_UNUSED == IS_CONST) {
				if (EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2))))) {
					value = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)));
					ZVAL_DEREF(value);
#ifdef ZTS
					ce = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)));
#endif
					break;
				} else if (EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1))))) {
					ce = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)));
				} else {
					ce = zend_fetch_class_by_name(Z_STR_P(EX_CONSTANT(opline->op1)), EX_CONSTANT(opline->op1) + 1, ZEND_FETCH_CLASS_DEFAULT | ZEND_FETCH_CLASS_EXCEPTION);
					if (UNEXPECTED(EG(exception) != NULL)) {
						HANDLE_EXCEPTION();
					}
					if (UNEXPECTED(ce == NULL)) {
						zend_throw_error(NULL, "Class '%s' not found", Z_STRVAL_P(EX_CONSTANT(opline->op1)));
						HANDLE_EXCEPTION();
					}
					CACHE_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)), ce);
				}
			} else {
				ce = Z_CE_P(EX_VAR(opline->op1.var));
				if ((value = CACHED_POLYMORPHIC_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)), ce)) != NULL) {
					ZVAL_DEREF(value);
					break;
				}
			}

			if (EXPECTED((value = zend_hash_find(&ce->constants_table, Z_STR_P(EX_CONSTANT(opline->op2)))) != NULL)) {
				ZVAL_DEREF(value);
				if (Z_CONSTANT_P(value)) {
					EG(scope) = ce;
					zval_update_constant_ex(value, 1, NULL);
					EG(scope) = EX(func)->op_array.scope;
					if (UNEXPECTED(EG(exception) != NULL)) {
						HANDLE_EXCEPTION();
					}
				}
				if (IS_UNUSED == IS_CONST) {
					CACHE_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)), value);
				} else {
					CACHE_POLYMORPHIC_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)), ce, value);
				}
			} else {
				zend_throw_error(NULL, "Undefined class constant '%s'", Z_STRVAL_P(EX_CONSTANT(opline->op2)));
				HANDLE_EXCEPTION();
			}
		} while (0);
#ifdef ZTS
		if (ce->type == ZEND_INTERNAL_CLASS) {
			ZVAL_DUP(EX_VAR(opline->result.var), value);
		} else {
			ZVAL_COPY(EX_VAR(opline->result.var), value);
		}
#else
		ZVAL_COPY(EX_VAR(opline->result.var), value);
#endif
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_INIT_ARRAY_SPEC_UNUSED_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	zval *array;
	uint32_t size;
	USE_OPLINE

	array = EX_VAR(opline->result.var);
	if (IS_UNUSED != IS_UNUSED) {
		size = opline->extended_value >> ZEND_ARRAY_SIZE_SHIFT;
	} else {
		size = 0;
	}
	ZVAL_NEW_ARR(array);
	zend_hash_init(Z_ARRVAL_P(array), size, NULL, ZVAL_PTR_DTOR, 0);

	if (IS_UNUSED != IS_UNUSED) {
		/* Explicitly initialize array as not-packed if flag is set */
		if (opline->extended_value & ZEND_ARRAY_NOT_PACKED) {
			zend_hash_real_init(Z_ARRVAL_P(array), 0);
		}
	}

	if (IS_UNUSED == IS_UNUSED) {
		ZEND_VM_NEXT_OPCODE();
#if 0 || (IS_UNUSED != IS_UNUSED)
	} else {
		ZEND_VM_TAIL_CALL(ZEND_ADD_ARRAY_ELEMENT_SPEC_UNUSED_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS_PASSTHRU));
#endif
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_UNSET_DIM_SPEC_UNUSED_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *container;
	zval *offset;
	zend_ulong hval;
	zend_string *key;

	SAVE_OPLINE();
	container = _get_obj_zval_ptr_unused(execute_data);
	if (IS_UNUSED == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}
	if (IS_UNUSED == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot unset string offsets");

		HANDLE_EXCEPTION();
	}
	offset = EX_CONSTANT(opline->op2);

	do {
		if (IS_UNUSED != IS_UNUSED && EXPECTED(Z_TYPE_P(container) == IS_ARRAY)) {
			HashTable *ht;

unset_dim_array:
			SEPARATE_ARRAY(container);
			ht = Z_ARRVAL_P(container);
offset_again:
			if (EXPECTED(Z_TYPE_P(offset) == IS_STRING)) {
				key = Z_STR_P(offset);
				if (IS_CONST != IS_CONST) {
					if (ZEND_HANDLE_NUMERIC(key, hval)) {
						goto num_index_dim;
					}
				}
str_index_dim:
				if (ht == &EG(symbol_table)) {
					zend_delete_global_variable(key);
				} else {
					zend_hash_del(ht, key);
				}
			} else if (EXPECTED(Z_TYPE_P(offset) == IS_LONG)) {
				hval = Z_LVAL_P(offset);
num_index_dim:
				zend_hash_index_del(ht, hval);
			} else if ((IS_CONST & (IS_VAR|IS_CV)) && EXPECTED(Z_TYPE_P(offset) == IS_REFERENCE)) {
				offset = Z_REFVAL_P(offset);
				goto offset_again;
			} else if (Z_TYPE_P(offset) == IS_DOUBLE) {
				hval = zend_dval_to_lval(Z_DVAL_P(offset));
				goto num_index_dim;
			} else if (Z_TYPE_P(offset) == IS_NULL) {
				key = ZSTR_EMPTY_ALLOC();
				goto str_index_dim;
			} else if (Z_TYPE_P(offset) == IS_FALSE) {
				hval = 0;
				goto num_index_dim;
			} else if (Z_TYPE_P(offset) == IS_TRUE) {
				hval = 1;
				goto num_index_dim;
			} else if (Z_TYPE_P(offset) == IS_RESOURCE) {
				hval = Z_RES_HANDLE_P(offset);
				goto num_index_dim;
			} else if (IS_CONST == IS_CV && Z_TYPE_P(offset) == IS_UNDEF) {
				GET_OP2_UNDEF_CV(offset, BP_VAR_R);
				key = ZSTR_EMPTY_ALLOC();
				goto str_index_dim;
			} else {
				zend_error(E_WARNING, "Illegal offset type in unset");
			}
			break;
		} else if (IS_UNUSED != IS_UNUSED && Z_ISREF_P(container)) {
			container = Z_REFVAL_P(container);
			if (EXPECTED(Z_TYPE_P(container) == IS_ARRAY)) {
				goto unset_dim_array;
			}
		}
		if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(offset) == IS_UNDEF)) {
			offset = GET_OP2_UNDEF_CV(offset, BP_VAR_R);
		}
		if (IS_UNUSED == IS_UNUSED || EXPECTED(Z_TYPE_P(container) == IS_OBJECT)) {
			if (UNEXPECTED(Z_OBJ_HT_P(container)->unset_dimension == NULL)) {
				zend_throw_error(NULL, "Cannot use object as array");
			} else {
				Z_OBJ_HT_P(container)->unset_dimension(container, offset);
			}
		} else if (IS_UNUSED != IS_UNUSED && UNEXPECTED(Z_TYPE_P(container) == IS_STRING)) {
			zend_throw_error(NULL, "Cannot unset string offsets");
		}
	} while (0);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_UNSET_OBJ_SPEC_UNUSED_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *container;
	zval *offset;

	SAVE_OPLINE();
	container = _get_obj_zval_ptr_unused(execute_data);
	if (IS_UNUSED == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}
	if (IS_UNUSED == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot unset string offsets");

		HANDLE_EXCEPTION();
	}
	offset = EX_CONSTANT(opline->op2);

	do {
		if (IS_UNUSED != IS_UNUSED && UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT)) {
			if (Z_ISREF_P(container)) {
				container = Z_REFVAL_P(container);
				if (Z_TYPE_P(container) != IS_OBJECT) {
					break;
				}
			} else {
				break;
			}
		}
		if (Z_OBJ_HT_P(container)->unset_property) {
			Z_OBJ_HT_P(container)->unset_property(container, offset, ((IS_CONST == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(offset)) : NULL));
		} else {
			zend_error(E_NOTICE, "Trying to unset property of non-object");
		}
	} while (0);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ISSET_ISEMPTY_DIM_OBJ_SPEC_UNUSED_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *container;
	int result;
	zend_ulong hval;
	zval *offset;

	SAVE_OPLINE();
	container = _get_obj_zval_ptr_unused(execute_data);

	if (IS_UNUSED == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}

	offset = EX_CONSTANT(opline->op2);

	if (IS_UNUSED != IS_UNUSED && EXPECTED(Z_TYPE_P(container) == IS_ARRAY)) {
		HashTable *ht;
		zval *value;
		zend_string *str;

isset_dim_obj_array:
		ht = Z_ARRVAL_P(container);
isset_again:
		if (EXPECTED(Z_TYPE_P(offset) == IS_STRING)) {
			str = Z_STR_P(offset);
			if (IS_CONST != IS_CONST) {
				if (ZEND_HANDLE_NUMERIC(str, hval)) {
					goto num_index_prop;
				}
			}
str_index_prop:
			value = zend_hash_find_ind(ht, str);
		} else if (EXPECTED(Z_TYPE_P(offset) == IS_LONG)) {
			hval = Z_LVAL_P(offset);
num_index_prop:
			value = zend_hash_index_find(ht, hval);
		} else if ((IS_CONST & (IS_VAR|IS_CV)) && EXPECTED(Z_ISREF_P(offset))) {
			offset = Z_REFVAL_P(offset);
			goto isset_again;
		} else if (Z_TYPE_P(offset) == IS_DOUBLE) {
			hval = zend_dval_to_lval(Z_DVAL_P(offset));
			goto num_index_prop;
		} else if (Z_TYPE_P(offset) == IS_NULL) {
			str = ZSTR_EMPTY_ALLOC();
			goto str_index_prop;
		} else if (Z_TYPE_P(offset) == IS_FALSE) {
			hval = 0;
			goto num_index_prop;
		} else if (Z_TYPE_P(offset) == IS_TRUE) {
			hval = 1;
			goto num_index_prop;
		} else if (Z_TYPE_P(offset) == IS_RESOURCE) {
			hval = Z_RES_HANDLE_P(offset);
			goto num_index_prop;
		} else if (IS_CONST == IS_CV && Z_TYPE_P(offset) == IS_UNDEF) {
			GET_OP2_UNDEF_CV(offset, BP_VAR_R);
			str = ZSTR_EMPTY_ALLOC();
			goto str_index_prop;
		} else {
			zend_error(E_WARNING, "Illegal offset type in isset or empty");
			goto isset_not_found;
		}

		if (opline->extended_value & ZEND_ISSET) {
			/* > IS_NULL means not IS_UNDEF and not IS_NULL */
			result = value != NULL && Z_TYPE_P(value) > IS_NULL &&
			    (!Z_ISREF_P(value) || Z_TYPE_P(Z_REFVAL_P(value)) != IS_NULL);
		} else /* if (opline->extended_value & ZEND_ISEMPTY) */ {
			result = (value == NULL || !i_zend_is_true(value));
		}
		goto isset_dim_obj_exit;
	} else if ((IS_UNUSED & (IS_VAR|IS_CV)) && Z_ISREF_P(container)) {
		container = Z_REFVAL_P(container);
		if (EXPECTED(Z_TYPE_P(container) == IS_ARRAY)) {
			goto isset_dim_obj_array;
		}
	}

	if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(offset) == IS_UNDEF)) {
		offset = GET_OP2_UNDEF_CV(offset, BP_VAR_R);
	}

	if (IS_UNUSED == IS_UNUSED ||
	    (IS_UNUSED != IS_CONST && EXPECTED(Z_TYPE_P(container) == IS_OBJECT))) {
		if (EXPECTED(Z_OBJ_HT_P(container)->has_dimension)) {
			result =
				((opline->extended_value & ZEND_ISSET) == 0) ^
				Z_OBJ_HT_P(container)->has_dimension(container, offset, (opline->extended_value & ZEND_ISSET) == 0);
		} else {
			zend_error(E_NOTICE, "Trying to check element of non-array");
			goto isset_not_found;
		}
	} else if (EXPECTED(Z_TYPE_P(container) == IS_STRING)) { /* string offsets */
		zend_long lval;

		if (EXPECTED(Z_TYPE_P(offset) == IS_LONG)) {
			lval = Z_LVAL_P(offset);
isset_str_offset:
			if (EXPECTED(lval >= 0) && (size_t)lval < Z_STRLEN_P(container)) {
				if (opline->extended_value & ZEND_ISSET) {
					result = 1;
				} else {
					result = (Z_STRVAL_P(container)[lval] == '0');
				}
			} else {
				goto isset_not_found;
			}
		} else {
			if (IS_CONST & (IS_CV|IS_VAR)) {
				ZVAL_DEREF(offset);
			}
			if (Z_TYPE_P(offset) < IS_STRING /* simple scalar types */
					|| (Z_TYPE_P(offset) == IS_STRING /* or numeric string */
						&& IS_LONG == is_numeric_string(Z_STRVAL_P(offset), Z_STRLEN_P(offset), NULL, NULL, 0))) {
				lval = zval_get_long(offset);
				goto isset_str_offset;
			}
			goto isset_not_found;
		}
	} else {
isset_not_found:
		result = ((opline->extended_value & ZEND_ISSET) == 0);
	}

isset_dim_obj_exit:


	ZEND_VM_SMART_BRANCH(result, 1);
	ZVAL_BOOL(EX_VAR(opline->result.var), result);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ISSET_ISEMPTY_PROP_OBJ_SPEC_UNUSED_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *container;
	int result;
	zval *offset;

	SAVE_OPLINE();
	container = _get_obj_zval_ptr_unused(execute_data);

	if (IS_UNUSED == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}

	offset = EX_CONSTANT(opline->op2);

	if (IS_UNUSED == IS_CONST ||
	    (IS_UNUSED != IS_UNUSED && UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT))) {
		if ((IS_UNUSED & (IS_VAR|IS_CV)) && Z_ISREF_P(container)) {
			container = Z_REFVAL_P(container);
			if (UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT)) {
				goto isset_no_object;
			}
		} else {
			goto isset_no_object;
		}
	}
	if (UNEXPECTED(!Z_OBJ_HT_P(container)->has_property)) {
		zend_error(E_NOTICE, "Trying to check property of non-object");
isset_no_object:
		result = ((opline->extended_value & ZEND_ISSET) == 0);
	} else {
		result =
			((opline->extended_value & ZEND_ISSET) == 0) ^
			Z_OBJ_HT_P(container)->has_property(container, offset, (opline->extended_value & ZEND_ISSET) == 0, ((IS_CONST == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(offset)) : NULL));
	}


	ZEND_VM_SMART_BRANCH(result, 1);
	ZVAL_BOOL(EX_VAR(opline->result.var), result);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_YIELD_SPEC_UNUSED_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zend_generator *generator = zend_get_running_generator(execute_data);

	SAVE_OPLINE();
	if (UNEXPECTED(generator->flags & ZEND_GENERATOR_FORCED_CLOSE)) {
		zend_throw_error(NULL, "Cannot yield from finally in a force-closed generator");


		HANDLE_EXCEPTION();
	}

	/* Destroy the previously yielded value */
	zval_ptr_dtor(&generator->value);

	/* Destroy the previously yielded key */
	zval_ptr_dtor(&generator->key);

	/* Set the new yielded value */
	if (IS_UNUSED != IS_UNUSED) {


		if (UNEXPECTED(EX(func)->op_array.fn_flags & ZEND_ACC_RETURN_REFERENCE)) {
			/* Constants and temporary variables aren't yieldable by reference,
			 * but we still allow them with a notice. */
			if (IS_UNUSED == IS_CONST || IS_UNUSED == IS_TMP_VAR) {
				zval *value;

				zend_error(E_NOTICE, "Only variable references should be yielded by reference");

				value = NULL;
				ZVAL_COPY_VALUE(&generator->value, value);
				if (IS_UNUSED != IS_CONST) {
					if (UNEXPECTED(Z_OPT_COPYABLE(generator->value))) {
						zval_copy_ctor_func(&generator->value);
					}
				}
			} else {
				zval *value_ptr = NULL;

				if (IS_UNUSED == IS_VAR && UNEXPECTED(value_ptr == NULL)) {
					zend_throw_error(NULL, "Cannot yield string offsets by reference");

					HANDLE_EXCEPTION();
				}

				/* If a function call result is yielded and the function did
				 * not return by reference we throw a notice. */
				if (IS_UNUSED == IS_VAR &&
				    (value_ptr == &EG(uninitialized_zval) ||
				     (opline->extended_value == ZEND_RETURNS_FUNCTION &&
				      !(Z_VAR_FLAGS_P(value_ptr) & IS_VAR_RET_REF)))) {
					zend_error(E_NOTICE, "Only variable references should be yielded by reference");
				} else {
					ZVAL_MAKE_REF(value_ptr);
				}
				ZVAL_COPY(&generator->value, value_ptr);

			}
		} else {
			zval *value = NULL;

			/* Consts, temporary variables and references need copying */
			if (IS_UNUSED == IS_CONST) {
				ZVAL_COPY_VALUE(&generator->value, value);
				if (UNEXPECTED(Z_OPT_COPYABLE(generator->value))) {
					zval_copy_ctor_func(&generator->value);
				}
			} else if (IS_UNUSED == IS_TMP_VAR) {
				ZVAL_COPY_VALUE(&generator->value, value);
            } else if ((IS_UNUSED & (IS_VAR|IS_CV)) && Z_ISREF_P(value)) {
				ZVAL_COPY(&generator->value, Z_REFVAL_P(value));

			} else {
				ZVAL_COPY_VALUE(&generator->value, value);
				if (IS_UNUSED == IS_CV) {
					if (Z_OPT_REFCOUNTED_P(value)) Z_ADDREF_P(value);
				}
			}
		}
	} else {
		/* If no value was specified yield null */
		ZVAL_NULL(&generator->value);
	}

	/* Set the new yielded key */
	if (IS_CONST != IS_UNUSED) {

		zval *key = EX_CONSTANT(opline->op2);

		/* Consts, temporary variables and references need copying */
		if (IS_CONST == IS_CONST) {
			ZVAL_COPY_VALUE(&generator->key, key);
			if (UNEXPECTED(Z_OPT_COPYABLE(generator->key))) {
				zval_copy_ctor_func(&generator->key);
			}
		} else if (IS_CONST == IS_TMP_VAR) {
			ZVAL_COPY_VALUE(&generator->key, key);
		} else if ((IS_CONST & (IS_VAR|IS_CV)) && Z_ISREF_P(key)) {
			ZVAL_COPY(&generator->key, Z_REFVAL_P(key));

		} else {
			ZVAL_COPY_VALUE(&generator->key, key);
			if (IS_CONST == IS_CV) {
				if (Z_OPT_REFCOUNTED_P(key)) Z_ADDREF_P(key);
			}
		}

		if (Z_TYPE(generator->key) == IS_LONG
		    && Z_LVAL(generator->key) > generator->largest_used_integer_key
		) {
			generator->largest_used_integer_key = Z_LVAL(generator->key);
		}
	} else {
		/* If no key was specified we use auto-increment keys */
		generator->largest_used_integer_key++;
		ZVAL_LONG(&generator->key, generator->largest_used_integer_key);
	}

	if (RETURN_VALUE_USED(opline)) {
		/* If the return value of yield is used set the send
		 * target and initialize it to NULL */
		generator->send_target = EX_VAR(opline->result.var);
		ZVAL_NULL(generator->send_target);
	} else {
		generator->send_target = NULL;
	}

	/* We increment to the next op, so we are at the correct position when the
	 * generator is resumed. */
	ZEND_VM_INC_OPCODE();

	/* The GOTO VM uses a local opline variable. We need to set the opline
	 * variable in execute_data so we don't resume at an old position. */
	SAVE_OPLINE();

	ZEND_VM_RETURN();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_YIELD_SPEC_UNUSED_TMP_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zend_generator *generator = zend_get_running_generator(execute_data);

	SAVE_OPLINE();
	if (UNEXPECTED(generator->flags & ZEND_GENERATOR_FORCED_CLOSE)) {
		zend_throw_error(NULL, "Cannot yield from finally in a force-closed generator");
		zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));

		HANDLE_EXCEPTION();
	}

	/* Destroy the previously yielded value */
	zval_ptr_dtor(&generator->value);

	/* Destroy the previously yielded key */
	zval_ptr_dtor(&generator->key);

	/* Set the new yielded value */
	if (IS_UNUSED != IS_UNUSED) {


		if (UNEXPECTED(EX(func)->op_array.fn_flags & ZEND_ACC_RETURN_REFERENCE)) {
			/* Constants and temporary variables aren't yieldable by reference,
			 * but we still allow them with a notice. */
			if (IS_UNUSED == IS_CONST || IS_UNUSED == IS_TMP_VAR) {
				zval *value;

				zend_error(E_NOTICE, "Only variable references should be yielded by reference");

				value = NULL;
				ZVAL_COPY_VALUE(&generator->value, value);
				if (IS_UNUSED != IS_CONST) {
					if (UNEXPECTED(Z_OPT_COPYABLE(generator->value))) {
						zval_copy_ctor_func(&generator->value);
					}
				}
			} else {
				zval *value_ptr = NULL;

				if (IS_UNUSED == IS_VAR && UNEXPECTED(value_ptr == NULL)) {
					zend_throw_error(NULL, "Cannot yield string offsets by reference");
					zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
					HANDLE_EXCEPTION();
				}

				/* If a function call result is yielded and the function did
				 * not return by reference we throw a notice. */
				if (IS_UNUSED == IS_VAR &&
				    (value_ptr == &EG(uninitialized_zval) ||
				     (opline->extended_value == ZEND_RETURNS_FUNCTION &&
				      !(Z_VAR_FLAGS_P(value_ptr) & IS_VAR_RET_REF)))) {
					zend_error(E_NOTICE, "Only variable references should be yielded by reference");
				} else {
					ZVAL_MAKE_REF(value_ptr);
				}
				ZVAL_COPY(&generator->value, value_ptr);

			}
		} else {
			zval *value = NULL;

			/* Consts, temporary variables and references need copying */
			if (IS_UNUSED == IS_CONST) {
				ZVAL_COPY_VALUE(&generator->value, value);
				if (UNEXPECTED(Z_OPT_COPYABLE(generator->value))) {
					zval_copy_ctor_func(&generator->value);
				}
			} else if (IS_UNUSED == IS_TMP_VAR) {
				ZVAL_COPY_VALUE(&generator->value, value);
            } else if ((IS_UNUSED & (IS_VAR|IS_CV)) && Z_ISREF_P(value)) {
				ZVAL_COPY(&generator->value, Z_REFVAL_P(value));

			} else {
				ZVAL_COPY_VALUE(&generator->value, value);
				if (IS_UNUSED == IS_CV) {
					if (Z_OPT_REFCOUNTED_P(value)) Z_ADDREF_P(value);
				}
			}
		}
	} else {
		/* If no value was specified yield null */
		ZVAL_NULL(&generator->value);
	}

	/* Set the new yielded key */
	if (IS_TMP_VAR != IS_UNUSED) {
		zend_free_op free_op2;
		zval *key = _get_zval_ptr_tmp(opline->op2.var, execute_data, &free_op2);

		/* Consts, temporary variables and references need copying */
		if (IS_TMP_VAR == IS_CONST) {
			ZVAL_COPY_VALUE(&generator->key, key);
			if (UNEXPECTED(Z_OPT_COPYABLE(generator->key))) {
				zval_copy_ctor_func(&generator->key);
			}
		} else if (IS_TMP_VAR == IS_TMP_VAR) {
			ZVAL_COPY_VALUE(&generator->key, key);
		} else if ((IS_TMP_VAR & (IS_VAR|IS_CV)) && Z_ISREF_P(key)) {
			ZVAL_COPY(&generator->key, Z_REFVAL_P(key));

		} else {
			ZVAL_COPY_VALUE(&generator->key, key);
			if (IS_TMP_VAR == IS_CV) {
				if (Z_OPT_REFCOUNTED_P(key)) Z_ADDREF_P(key);
			}
		}

		if (Z_TYPE(generator->key) == IS_LONG
		    && Z_LVAL(generator->key) > generator->largest_used_integer_key
		) {
			generator->largest_used_integer_key = Z_LVAL(generator->key);
		}
	} else {
		/* If no key was specified we use auto-increment keys */
		generator->largest_used_integer_key++;
		ZVAL_LONG(&generator->key, generator->largest_used_integer_key);
	}

	if (RETURN_VALUE_USED(opline)) {
		/* If the return value of yield is used set the send
		 * target and initialize it to NULL */
		generator->send_target = EX_VAR(opline->result.var);
		ZVAL_NULL(generator->send_target);
	} else {
		generator->send_target = NULL;
	}

	/* We increment to the next op, so we are at the correct position when the
	 * generator is resumed. */
	ZEND_VM_INC_OPCODE();

	/* The GOTO VM uses a local opline variable. We need to set the opline
	 * variable in execute_data so we don't resume at an old position. */
	SAVE_OPLINE();

	ZEND_VM_RETURN();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_YIELD_SPEC_UNUSED_VAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zend_generator *generator = zend_get_running_generator(execute_data);

	SAVE_OPLINE();
	if (UNEXPECTED(generator->flags & ZEND_GENERATOR_FORCED_CLOSE)) {
		zend_throw_error(NULL, "Cannot yield from finally in a force-closed generator");
		zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));

		HANDLE_EXCEPTION();
	}

	/* Destroy the previously yielded value */
	zval_ptr_dtor(&generator->value);

	/* Destroy the previously yielded key */
	zval_ptr_dtor(&generator->key);

	/* Set the new yielded value */
	if (IS_UNUSED != IS_UNUSED) {


		if (UNEXPECTED(EX(func)->op_array.fn_flags & ZEND_ACC_RETURN_REFERENCE)) {
			/* Constants and temporary variables aren't yieldable by reference,
			 * but we still allow them with a notice. */
			if (IS_UNUSED == IS_CONST || IS_UNUSED == IS_TMP_VAR) {
				zval *value;

				zend_error(E_NOTICE, "Only variable references should be yielded by reference");

				value = NULL;
				ZVAL_COPY_VALUE(&generator->value, value);
				if (IS_UNUSED != IS_CONST) {
					if (UNEXPECTED(Z_OPT_COPYABLE(generator->value))) {
						zval_copy_ctor_func(&generator->value);
					}
				}
			} else {
				zval *value_ptr = NULL;

				if (IS_UNUSED == IS_VAR && UNEXPECTED(value_ptr == NULL)) {
					zend_throw_error(NULL, "Cannot yield string offsets by reference");
					zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
					HANDLE_EXCEPTION();
				}

				/* If a function call result is yielded and the function did
				 * not return by reference we throw a notice. */
				if (IS_UNUSED == IS_VAR &&
				    (value_ptr == &EG(uninitialized_zval) ||
				     (opline->extended_value == ZEND_RETURNS_FUNCTION &&
				      !(Z_VAR_FLAGS_P(value_ptr) & IS_VAR_RET_REF)))) {
					zend_error(E_NOTICE, "Only variable references should be yielded by reference");
				} else {
					ZVAL_MAKE_REF(value_ptr);
				}
				ZVAL_COPY(&generator->value, value_ptr);

			}
		} else {
			zval *value = NULL;

			/* Consts, temporary variables and references need copying */
			if (IS_UNUSED == IS_CONST) {
				ZVAL_COPY_VALUE(&generator->value, value);
				if (UNEXPECTED(Z_OPT_COPYABLE(generator->value))) {
					zval_copy_ctor_func(&generator->value);
				}
			} else if (IS_UNUSED == IS_TMP_VAR) {
				ZVAL_COPY_VALUE(&generator->value, value);
            } else if ((IS_UNUSED & (IS_VAR|IS_CV)) && Z_ISREF_P(value)) {
				ZVAL_COPY(&generator->value, Z_REFVAL_P(value));

			} else {
				ZVAL_COPY_VALUE(&generator->value, value);
				if (IS_UNUSED == IS_CV) {
					if (Z_OPT_REFCOUNTED_P(value)) Z_ADDREF_P(value);
				}
			}
		}
	} else {
		/* If no value was specified yield null */
		ZVAL_NULL(&generator->value);
	}

	/* Set the new yielded key */
	if (IS_VAR != IS_UNUSED) {
		zend_free_op free_op2;
		zval *key = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);

		/* Consts, temporary variables and references need copying */
		if (IS_VAR == IS_CONST) {
			ZVAL_COPY_VALUE(&generator->key, key);
			if (UNEXPECTED(Z_OPT_COPYABLE(generator->key))) {
				zval_copy_ctor_func(&generator->key);
			}
		} else if (IS_VAR == IS_TMP_VAR) {
			ZVAL_COPY_VALUE(&generator->key, key);
		} else if ((IS_VAR & (IS_VAR|IS_CV)) && Z_ISREF_P(key)) {
			ZVAL_COPY(&generator->key, Z_REFVAL_P(key));
			zval_ptr_dtor_nogc(free_op2);
		} else {
			ZVAL_COPY_VALUE(&generator->key, key);
			if (IS_VAR == IS_CV) {
				if (Z_OPT_REFCOUNTED_P(key)) Z_ADDREF_P(key);
			}
		}

		if (Z_TYPE(generator->key) == IS_LONG
		    && Z_LVAL(generator->key) > generator->largest_used_integer_key
		) {
			generator->largest_used_integer_key = Z_LVAL(generator->key);
		}
	} else {
		/* If no key was specified we use auto-increment keys */
		generator->largest_used_integer_key++;
		ZVAL_LONG(&generator->key, generator->largest_used_integer_key);
	}

	if (RETURN_VALUE_USED(opline)) {
		/* If the return value of yield is used set the send
		 * target and initialize it to NULL */
		generator->send_target = EX_VAR(opline->result.var);
		ZVAL_NULL(generator->send_target);
	} else {
		generator->send_target = NULL;
	}

	/* We increment to the next op, so we are at the correct position when the
	 * generator is resumed. */
	ZEND_VM_INC_OPCODE();

	/* The GOTO VM uses a local opline variable. We need to set the opline
	 * variable in execute_data so we don't resume at an old position. */
	SAVE_OPLINE();

	ZEND_VM_RETURN();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL zend_binary_assign_op_dim_helper_SPEC_UNUSED_UNUSED(binary_op_type binary_op ZEND_OPCODE_HANDLER_ARGS_DC)
{
	USE_OPLINE
	zend_free_op free_op_data1;
	zval *var_ptr, rv;
	zval *value, *container, *dim;

	SAVE_OPLINE();
	container = _get_obj_zval_ptr_unused(execute_data);
	if (IS_UNUSED == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");
		FREE_UNFETCHED_OP((opline+1)->op1_type, (opline+1)->op1.var);

		HANDLE_EXCEPTION();
	}
	if (IS_UNUSED == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an array");
		FREE_UNFETCHED_OP((opline+1)->op1_type, (opline+1)->op1.var);

		HANDLE_EXCEPTION();
	}

	dim = NULL;

	do {
		if (IS_UNUSED == IS_UNUSED || UNEXPECTED(Z_TYPE_P(container) != IS_ARRAY)) {
			if (IS_UNUSED != IS_UNUSED) {
				ZVAL_DEREF(container);
			}
			if (IS_UNUSED == IS_UNUSED || EXPECTED(Z_TYPE_P(container) == IS_OBJECT)) {
				value = get_zval_ptr((opline+1)->op1_type, (opline+1)->op1, execute_data, &free_op_data1, BP_VAR_R);
				zend_binary_assign_op_obj_dim(container, dim, value, UNEXPECTED(RETURN_VALUE_USED(opline)) ? EX_VAR(opline->result.var) : NULL, binary_op);
				break;
			}
		}

		zend_fetch_dimension_address_RW(&rv, container, dim, IS_UNUSED);
		value = get_zval_ptr((opline+1)->op1_type, (opline+1)->op1, execute_data, &free_op_data1, BP_VAR_R);
		ZEND_ASSERT(Z_TYPE(rv) == IS_INDIRECT);
		var_ptr = Z_INDIRECT(rv);

		if (UNEXPECTED(var_ptr == NULL)) {
			zend_throw_error(NULL, "Cannot use assign-op operators with overloaded objects nor string offsets");

			FREE_OP(free_op_data1);

			HANDLE_EXCEPTION();
		}

		if (UNEXPECTED(var_ptr == &EG(error_zval))) {
			if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
				ZVAL_NULL(EX_VAR(opline->result.var));
			}
		} else {
			ZVAL_DEREF(var_ptr);
			SEPARATE_ZVAL_NOREF(var_ptr);

			binary_op(var_ptr, var_ptr, value);

			if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
				ZVAL_COPY(EX_VAR(opline->result.var), var_ptr);
			}
		}
	} while (0);

	FREE_OP(free_op_data1);

	ZEND_VM_NEXT_OPCODE_EX(1, 2);
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_ADD_SPEC_UNUSED_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_UNUSED != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_UNUSED != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_UNUSED_UNUSED(add_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_UNUSED(add_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_UNUSED_UNUSED(add_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_UNUSED(add_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_SUB_SPEC_UNUSED_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_UNUSED != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_UNUSED != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_UNUSED_UNUSED(sub_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_UNUSED(sub_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_UNUSED_UNUSED(sub_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_UNUSED(sub_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_MUL_SPEC_UNUSED_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_UNUSED != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_UNUSED != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_UNUSED_UNUSED(mul_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_UNUSED(mul_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_UNUSED_UNUSED(mul_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_UNUSED(mul_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_DIV_SPEC_UNUSED_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_UNUSED != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_UNUSED != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_UNUSED_UNUSED(div_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_UNUSED(div_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_UNUSED_UNUSED(div_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_UNUSED(div_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_MOD_SPEC_UNUSED_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_UNUSED != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_UNUSED != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_UNUSED_UNUSED(mod_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_UNUSED(mod_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_UNUSED_UNUSED(mod_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_UNUSED(mod_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_SL_SPEC_UNUSED_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_UNUSED != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_UNUSED != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_UNUSED_UNUSED(shift_left_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_UNUSED(shift_left_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_UNUSED_UNUSED(shift_left_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_UNUSED(shift_left_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_SR_SPEC_UNUSED_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_UNUSED != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_UNUSED != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_UNUSED_UNUSED(shift_right_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_UNUSED(shift_right_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_UNUSED_UNUSED(shift_right_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_UNUSED(shift_right_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_CONCAT_SPEC_UNUSED_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_UNUSED != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_UNUSED != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_UNUSED_UNUSED(concat_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_UNUSED(concat_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_UNUSED_UNUSED(concat_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_UNUSED(concat_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_BW_OR_SPEC_UNUSED_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_UNUSED != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_UNUSED != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_UNUSED_UNUSED(bitwise_or_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_UNUSED(bitwise_or_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_UNUSED_UNUSED(bitwise_or_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_UNUSED(bitwise_or_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_BW_AND_SPEC_UNUSED_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_UNUSED != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_UNUSED != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_UNUSED_UNUSED(bitwise_and_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_UNUSED(bitwise_and_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_UNUSED_UNUSED(bitwise_and_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_UNUSED(bitwise_and_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_BW_XOR_SPEC_UNUSED_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_UNUSED != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_UNUSED != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_UNUSED_UNUSED(bitwise_xor_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_UNUSED(bitwise_xor_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_UNUSED_UNUSED(bitwise_xor_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_UNUSED(bitwise_xor_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_VERIFY_RETURN_TYPE_SPEC_UNUSED_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	SAVE_OPLINE();
	if (IS_UNUSED == IS_UNUSED) {
		zend_verify_missing_return_type(EX(func), CACHE_ADDR(opline->op2.num));
	} else {
/* prevents "undefined variable opline" errors */
#if 0 || (IS_UNUSED != IS_UNUSED)
		zval *retval_ref, *retval_ptr;

		zend_arg_info *ret_info = EX(func)->common.arg_info - 1;

		retval_ref = retval_ptr = NULL;

		if (IS_UNUSED == IS_CONST) {
			ZVAL_COPY(EX_VAR(opline->result.var), retval_ptr);
			retval_ref = retval_ptr = EX_VAR(opline->result.var);
		} else if (IS_UNUSED == IS_VAR) {
			if (UNEXPECTED(Z_TYPE_P(retval_ptr) == IS_INDIRECT)) {
				retval_ptr = Z_INDIRECT_P(retval_ptr);
			}
			ZVAL_DEREF(retval_ptr);
		} else if (IS_UNUSED == IS_CV) {
			ZVAL_DEREF(retval_ptr);
		}

		if (UNEXPECTED(!ret_info->class_name
			&& ret_info->type_hint != IS_CALLABLE
			&& !ZEND_SAME_FAKE_TYPE(ret_info->type_hint, Z_TYPE_P(retval_ptr))
			&& !(EX(func)->op_array.fn_flags & ZEND_ACC_RETURN_REFERENCE)
			&& retval_ref != retval_ptr)
		) {
			/* A cast might happen - unwrap the reference if this is a by-value return */
			if (Z_REFCOUNT_P(retval_ref) == 1) {
				ZVAL_UNREF(retval_ref);
			} else {
				Z_DELREF_P(retval_ref);
				ZVAL_COPY(retval_ref, retval_ptr);
			}
			retval_ptr = retval_ref;
		}
		zend_verify_return_type(EX(func), retval_ptr, CACHE_ADDR(opline->op2.num));

		if (UNEXPECTED(EG(exception) != NULL)) {

		}
#endif
	}
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_INIT_ARRAY_SPEC_UNUSED_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	zval *array;
	uint32_t size;
	USE_OPLINE

	array = EX_VAR(opline->result.var);
	if (IS_UNUSED != IS_UNUSED) {
		size = opline->extended_value >> ZEND_ARRAY_SIZE_SHIFT;
	} else {
		size = 0;
	}
	ZVAL_NEW_ARR(array);
	zend_hash_init(Z_ARRVAL_P(array), size, NULL, ZVAL_PTR_DTOR, 0);

	if (IS_UNUSED != IS_UNUSED) {
		/* Explicitly initialize array as not-packed if flag is set */
		if (opline->extended_value & ZEND_ARRAY_NOT_PACKED) {
			zend_hash_real_init(Z_ARRVAL_P(array), 0);
		}
	}

	if (IS_UNUSED == IS_UNUSED) {
		ZEND_VM_NEXT_OPCODE();
#if 0 || (IS_UNUSED != IS_UNUSED)
	} else {
		ZEND_VM_TAIL_CALL(ZEND_ADD_ARRAY_ELEMENT_SPEC_UNUSED_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS_PASSTHRU));
#endif
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_YIELD_SPEC_UNUSED_UNUSED_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zend_generator *generator = zend_get_running_generator(execute_data);

	SAVE_OPLINE();
	if (UNEXPECTED(generator->flags & ZEND_GENERATOR_FORCED_CLOSE)) {
		zend_throw_error(NULL, "Cannot yield from finally in a force-closed generator");


		HANDLE_EXCEPTION();
	}

	/* Destroy the previously yielded value */
	zval_ptr_dtor(&generator->value);

	/* Destroy the previously yielded key */
	zval_ptr_dtor(&generator->key);

	/* Set the new yielded value */
	if (IS_UNUSED != IS_UNUSED) {


		if (UNEXPECTED(EX(func)->op_array.fn_flags & ZEND_ACC_RETURN_REFERENCE)) {
			/* Constants and temporary variables aren't yieldable by reference,
			 * but we still allow them with a notice. */
			if (IS_UNUSED == IS_CONST || IS_UNUSED == IS_TMP_VAR) {
				zval *value;

				zend_error(E_NOTICE, "Only variable references should be yielded by reference");

				value = NULL;
				ZVAL_COPY_VALUE(&generator->value, value);
				if (IS_UNUSED != IS_CONST) {
					if (UNEXPECTED(Z_OPT_COPYABLE(generator->value))) {
						zval_copy_ctor_func(&generator->value);
					}
				}
			} else {
				zval *value_ptr = NULL;

				if (IS_UNUSED == IS_VAR && UNEXPECTED(value_ptr == NULL)) {
					zend_throw_error(NULL, "Cannot yield string offsets by reference");

					HANDLE_EXCEPTION();
				}

				/* If a function call result is yielded and the function did
				 * not return by reference we throw a notice. */
				if (IS_UNUSED == IS_VAR &&
				    (value_ptr == &EG(uninitialized_zval) ||
				     (opline->extended_value == ZEND_RETURNS_FUNCTION &&
				      !(Z_VAR_FLAGS_P(value_ptr) & IS_VAR_RET_REF)))) {
					zend_error(E_NOTICE, "Only variable references should be yielded by reference");
				} else {
					ZVAL_MAKE_REF(value_ptr);
				}
				ZVAL_COPY(&generator->value, value_ptr);

			}
		} else {
			zval *value = NULL;

			/* Consts, temporary variables and references need copying */
			if (IS_UNUSED == IS_CONST) {
				ZVAL_COPY_VALUE(&generator->value, value);
				if (UNEXPECTED(Z_OPT_COPYABLE(generator->value))) {
					zval_copy_ctor_func(&generator->value);
				}
			} else if (IS_UNUSED == IS_TMP_VAR) {
				ZVAL_COPY_VALUE(&generator->value, value);
            } else if ((IS_UNUSED & (IS_VAR|IS_CV)) && Z_ISREF_P(value)) {
				ZVAL_COPY(&generator->value, Z_REFVAL_P(value));

			} else {
				ZVAL_COPY_VALUE(&generator->value, value);
				if (IS_UNUSED == IS_CV) {
					if (Z_OPT_REFCOUNTED_P(value)) Z_ADDREF_P(value);
				}
			}
		}
	} else {
		/* If no value was specified yield null */
		ZVAL_NULL(&generator->value);
	}

	/* Set the new yielded key */
	if (IS_UNUSED != IS_UNUSED) {

		zval *key = NULL;

		/* Consts, temporary variables and references need copying */
		if (IS_UNUSED == IS_CONST) {
			ZVAL_COPY_VALUE(&generator->key, key);
			if (UNEXPECTED(Z_OPT_COPYABLE(generator->key))) {
				zval_copy_ctor_func(&generator->key);
			}
		} else if (IS_UNUSED == IS_TMP_VAR) {
			ZVAL_COPY_VALUE(&generator->key, key);
		} else if ((IS_UNUSED & (IS_VAR|IS_CV)) && Z_ISREF_P(key)) {
			ZVAL_COPY(&generator->key, Z_REFVAL_P(key));

		} else {
			ZVAL_COPY_VALUE(&generator->key, key);
			if (IS_UNUSED == IS_CV) {
				if (Z_OPT_REFCOUNTED_P(key)) Z_ADDREF_P(key);
			}
		}

		if (Z_TYPE(generator->key) == IS_LONG
		    && Z_LVAL(generator->key) > generator->largest_used_integer_key
		) {
			generator->largest_used_integer_key = Z_LVAL(generator->key);
		}
	} else {
		/* If no key was specified we use auto-increment keys */
		generator->largest_used_integer_key++;
		ZVAL_LONG(&generator->key, generator->largest_used_integer_key);
	}

	if (RETURN_VALUE_USED(opline)) {
		/* If the return value of yield is used set the send
		 * target and initialize it to NULL */
		generator->send_target = EX_VAR(opline->result.var);
		ZVAL_NULL(generator->send_target);
	} else {
		generator->send_target = NULL;
	}

	/* We increment to the next op, so we are at the correct position when the
	 * generator is resumed. */
	ZEND_VM_INC_OPCODE();

	/* The GOTO VM uses a local opline variable. We need to set the opline
	 * variable in execute_data so we don't resume at an old position. */
	SAVE_OPLINE();

	ZEND_VM_RETURN();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL zend_binary_assign_op_obj_helper_SPEC_UNUSED_CV(binary_op_type binary_op ZEND_OPCODE_HANDLER_ARGS_DC)
{
	USE_OPLINE
	zend_free_op free_op_data1;
	zval *object;
	zval *property;
	zval *value;
	zval *zptr;

	SAVE_OPLINE();
	object = _get_obj_zval_ptr_unused(execute_data);

	if (IS_UNUSED == IS_UNUSED && UNEXPECTED(Z_OBJ_P(object) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");
		FREE_UNFETCHED_OP((opline+1)->op1_type, (opline+1)->op1.var);

		HANDLE_EXCEPTION();
	}

	property = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);

	if (IS_UNUSED == IS_VAR && UNEXPECTED(object == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an object");
		FREE_UNFETCHED_OP((opline+1)->op1_type, (opline+1)->op1.var);

		HANDLE_EXCEPTION();
	}

	do {
		value = get_zval_ptr((opline+1)->op1_type, (opline+1)->op1, execute_data, &free_op_data1, BP_VAR_R);

		if (IS_UNUSED != IS_UNUSED && UNEXPECTED(Z_TYPE_P(object) != IS_OBJECT)) {
			ZVAL_DEREF(object);
			if (UNEXPECTED(!make_real_object(object))) {
				zend_error(E_WARNING, "Attempt to assign property of non-object");
				if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
					ZVAL_NULL(EX_VAR(opline->result.var));
				}
				break;
			}
		}

		/* here we are sure we are dealing with an object */
		if (EXPECTED(Z_OBJ_HT_P(object)->get_property_ptr_ptr)
			&& EXPECTED((zptr = Z_OBJ_HT_P(object)->get_property_ptr_ptr(object, property, BP_VAR_RW, ((IS_CV == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL))) != NULL)) {

			ZVAL_DEREF(zptr);
			SEPARATE_ZVAL_NOREF(zptr);

			binary_op(zptr, zptr, value);
			if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
				ZVAL_COPY(EX_VAR(opline->result.var), zptr);
			}
		} else {
			zend_assign_op_overloaded_property(object, property, ((IS_CV == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), value, binary_op, (UNEXPECTED(RETURN_VALUE_USED(opline)) ? EX_VAR(opline->result.var) : NULL));
		}
	} while (0);

	FREE_OP(free_op_data1);


	/* assign_obj has two opcodes! */
	ZEND_VM_NEXT_OPCODE_EX(1, 2);
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL zend_binary_assign_op_dim_helper_SPEC_UNUSED_CV(binary_op_type binary_op ZEND_OPCODE_HANDLER_ARGS_DC)
{
	USE_OPLINE
	zend_free_op free_op_data1;
	zval *var_ptr, rv;
	zval *value, *container, *dim;

	SAVE_OPLINE();
	container = _get_obj_zval_ptr_unused(execute_data);
	if (IS_UNUSED == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");
		FREE_UNFETCHED_OP((opline+1)->op1_type, (opline+1)->op1.var);

		HANDLE_EXCEPTION();
	}
	if (IS_UNUSED == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an array");
		FREE_UNFETCHED_OP((opline+1)->op1_type, (opline+1)->op1.var);

		HANDLE_EXCEPTION();
	}

	dim = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);

	do {
		if (IS_UNUSED == IS_UNUSED || UNEXPECTED(Z_TYPE_P(container) != IS_ARRAY)) {
			if (IS_UNUSED != IS_UNUSED) {
				ZVAL_DEREF(container);
			}
			if (IS_UNUSED == IS_UNUSED || EXPECTED(Z_TYPE_P(container) == IS_OBJECT)) {
				value = get_zval_ptr((opline+1)->op1_type, (opline+1)->op1, execute_data, &free_op_data1, BP_VAR_R);
				zend_binary_assign_op_obj_dim(container, dim, value, UNEXPECTED(RETURN_VALUE_USED(opline)) ? EX_VAR(opline->result.var) : NULL, binary_op);
				break;
			}
		}

		zend_fetch_dimension_address_RW(&rv, container, dim, IS_CV);
		value = get_zval_ptr((opline+1)->op1_type, (opline+1)->op1, execute_data, &free_op_data1, BP_VAR_R);
		ZEND_ASSERT(Z_TYPE(rv) == IS_INDIRECT);
		var_ptr = Z_INDIRECT(rv);

		if (UNEXPECTED(var_ptr == NULL)) {
			zend_throw_error(NULL, "Cannot use assign-op operators with overloaded objects nor string offsets");

			FREE_OP(free_op_data1);

			HANDLE_EXCEPTION();
		}

		if (UNEXPECTED(var_ptr == &EG(error_zval))) {
			if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
				ZVAL_NULL(EX_VAR(opline->result.var));
			}
		} else {
			ZVAL_DEREF(var_ptr);
			SEPARATE_ZVAL_NOREF(var_ptr);

			binary_op(var_ptr, var_ptr, value);

			if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
				ZVAL_COPY(EX_VAR(opline->result.var), var_ptr);
			}
		}
	} while (0);

	FREE_OP(free_op_data1);

	ZEND_VM_NEXT_OPCODE_EX(1, 2);
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_ADD_SPEC_UNUSED_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CV != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_UNUSED != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_UNUSED_CV(add_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_CV(add_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_UNUSED_CV(add_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_CV(add_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_SUB_SPEC_UNUSED_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CV != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_UNUSED != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_UNUSED_CV(sub_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_CV(sub_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_UNUSED_CV(sub_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_CV(sub_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_MUL_SPEC_UNUSED_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CV != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_UNUSED != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_UNUSED_CV(mul_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_CV(mul_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_UNUSED_CV(mul_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_CV(mul_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_DIV_SPEC_UNUSED_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CV != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_UNUSED != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_UNUSED_CV(div_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_CV(div_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_UNUSED_CV(div_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_CV(div_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_MOD_SPEC_UNUSED_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CV != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_UNUSED != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_UNUSED_CV(mod_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_CV(mod_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_UNUSED_CV(mod_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_CV(mod_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_SL_SPEC_UNUSED_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CV != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_UNUSED != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_UNUSED_CV(shift_left_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_CV(shift_left_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_UNUSED_CV(shift_left_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_CV(shift_left_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_SR_SPEC_UNUSED_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CV != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_UNUSED != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_UNUSED_CV(shift_right_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_CV(shift_right_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_UNUSED_CV(shift_right_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_CV(shift_right_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_CONCAT_SPEC_UNUSED_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CV != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_UNUSED != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_UNUSED_CV(concat_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_CV(concat_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_UNUSED_CV(concat_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_CV(concat_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_BW_OR_SPEC_UNUSED_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CV != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_UNUSED != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_UNUSED_CV(bitwise_or_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_CV(bitwise_or_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_UNUSED_CV(bitwise_or_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_CV(bitwise_or_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_BW_AND_SPEC_UNUSED_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CV != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_UNUSED != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_UNUSED_CV(bitwise_and_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_CV(bitwise_and_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_UNUSED_CV(bitwise_and_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_CV(bitwise_and_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_BW_XOR_SPEC_UNUSED_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CV != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_UNUSED != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_UNUSED_CV(bitwise_xor_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_CV(bitwise_xor_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_UNUSED_CV(bitwise_xor_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_CV(bitwise_xor_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL zend_pre_incdec_property_helper_SPEC_UNUSED_CV(int inc ZEND_OPCODE_HANDLER_ARGS_DC)
{
	USE_OPLINE

	zval *object;
	zval *property;
	zval *zptr;

	SAVE_OPLINE();
	object = _get_obj_zval_ptr_unused(execute_data);

	if (IS_UNUSED == IS_UNUSED && UNEXPECTED(Z_OBJ_P(object) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}

	property = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);

	if (IS_UNUSED == IS_VAR && UNEXPECTED(object == NULL)) {
		zend_throw_error(NULL, "Cannot increment/decrement overloaded objects nor string offsets");

		HANDLE_EXCEPTION();
	}

	do {
		if (IS_UNUSED != IS_UNUSED && UNEXPECTED(Z_TYPE_P(object) != IS_OBJECT)) {
			ZVAL_DEREF(object);
			if (UNEXPECTED(!make_real_object(object))) {
				zend_error(E_WARNING, "Attempt to increment/decrement property of non-object");
				if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
					ZVAL_NULL(EX_VAR(opline->result.var));
				}
				break;
			}
		}

		/* here we are sure we are dealing with an object */

		if (EXPECTED(Z_OBJ_HT_P(object)->get_property_ptr_ptr)
			&& EXPECTED((zptr = Z_OBJ_HT_P(object)->get_property_ptr_ptr(object, property, BP_VAR_RW, ((IS_CV == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL))) != NULL)) {

			if (EXPECTED(Z_TYPE_P(zptr) == IS_LONG)) {
				if (inc) {
					fast_long_increment_function(zptr);
				} else {
					fast_long_decrement_function(zptr);
				}
			} else {
				ZVAL_DEREF(zptr);
				SEPARATE_ZVAL_NOREF(zptr);

				if (inc) {
					increment_function(zptr);
				} else {
					decrement_function(zptr);
				}
			}
			if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
				ZVAL_COPY(EX_VAR(opline->result.var), zptr);
			}
		} else {
			zend_pre_incdec_overloaded_property(object, property, ((IS_CV == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), inc, (UNEXPECTED(RETURN_VALUE_USED(opline)) ? EX_VAR(opline->result.var) : NULL));
		}
	} while (0);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_PRE_INC_OBJ_SPEC_UNUSED_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	ZEND_VM_TAIL_CALL(zend_pre_incdec_property_helper_SPEC_UNUSED_CV(1 ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_PRE_DEC_OBJ_SPEC_UNUSED_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	ZEND_VM_TAIL_CALL(zend_pre_incdec_property_helper_SPEC_UNUSED_CV(0 ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL zend_post_incdec_property_helper_SPEC_UNUSED_CV(int inc ZEND_OPCODE_HANDLER_ARGS_DC)
{
	USE_OPLINE

	zval *object;
	zval *property;
	zval *zptr;

	SAVE_OPLINE();
	object = _get_obj_zval_ptr_unused(execute_data);

	if (IS_UNUSED == IS_UNUSED && UNEXPECTED(Z_OBJ_P(object) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}

	property = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);

	if (IS_UNUSED == IS_VAR && UNEXPECTED(object == NULL)) {
		zend_throw_error(NULL, "Cannot increment/decrement overloaded objects nor string offsets");

		HANDLE_EXCEPTION();
	}

	do {
		if (IS_UNUSED != IS_UNUSED && UNEXPECTED(Z_TYPE_P(object) != IS_OBJECT)) {
			ZVAL_DEREF(object);
			if (UNEXPECTED(!make_real_object(object))) {
				zend_error(E_WARNING, "Attempt to increment/decrement property of non-object");
				ZVAL_NULL(EX_VAR(opline->result.var));
				break;
			}
		}

		/* here we are sure we are dealing with an object */

		if (EXPECTED(Z_OBJ_HT_P(object)->get_property_ptr_ptr)
			&& EXPECTED((zptr = Z_OBJ_HT_P(object)->get_property_ptr_ptr(object, property, BP_VAR_RW, ((IS_CV == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL))) != NULL)) {

			if (EXPECTED(Z_TYPE_P(zptr) == IS_LONG)) {
				ZVAL_COPY_VALUE(EX_VAR(opline->result.var), zptr);
				if (inc) {
					fast_long_increment_function(zptr);
				} else {
					fast_long_decrement_function(zptr);
				}
			} else {
				ZVAL_DEREF(zptr);
				ZVAL_COPY_VALUE(EX_VAR(opline->result.var), zptr);
				zval_opt_copy_ctor(zptr);
				if (inc) {
					increment_function(zptr);
				} else {
					decrement_function(zptr);
				}
			}
		} else {
			zend_post_incdec_overloaded_property(object, property, ((IS_CV == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), inc, EX_VAR(opline->result.var));
		}
	} while (0);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_POST_INC_OBJ_SPEC_UNUSED_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	ZEND_VM_TAIL_CALL(zend_post_incdec_property_helper_SPEC_UNUSED_CV(1 ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_POST_DEC_OBJ_SPEC_UNUSED_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	ZEND_VM_TAIL_CALL(zend_post_incdec_property_helper_SPEC_UNUSED_CV(0 ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_R_SPEC_UNUSED_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *container;

	zval *offset;

	SAVE_OPLINE();
	container = _get_obj_zval_ptr_unused(execute_data);

	if (IS_UNUSED == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}

	offset = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);

	if (IS_UNUSED == IS_CONST ||
	    (IS_UNUSED != IS_UNUSED && UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT))) {
		if ((IS_UNUSED & (IS_VAR|IS_CV)) && Z_ISREF_P(container)) {
			container = Z_REFVAL_P(container);
			if (UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT)) {
				goto fetch_obj_r_no_object;
			}
		} else {
			goto fetch_obj_r_no_object;
		}
	}

	/* here we are sure we are dealing with an object */
	do {
		zend_object *zobj = Z_OBJ_P(container);
		zval *retval;

		if (IS_CV == IS_CONST &&
			EXPECTED(zobj->ce == CACHED_PTR(Z_CACHE_SLOT_P(offset)))) {
			uint32_t prop_offset = (uint32_t)(intptr_t)CACHED_PTR(Z_CACHE_SLOT_P(offset) + sizeof(void*));

			if (EXPECTED(prop_offset != (uint32_t)ZEND_DYNAMIC_PROPERTY_OFFSET)) {
				retval = OBJ_PROP(zobj, prop_offset);
				if (EXPECTED(Z_TYPE_P(retval) != IS_UNDEF)) {
					ZVAL_COPY(EX_VAR(opline->result.var), retval);
					break;
				}
			} else if (EXPECTED(zobj->properties != NULL)) {
				retval = zend_hash_find(zobj->properties, Z_STR_P(offset));
				if (EXPECTED(retval)) {
					ZVAL_COPY(EX_VAR(opline->result.var), retval);
					break;
				}
			}
		}

		if (UNEXPECTED(zobj->handlers->read_property == NULL)) {
fetch_obj_r_no_object:
			zend_error(E_NOTICE, "Trying to get property of non-object");
			ZVAL_NULL(EX_VAR(opline->result.var));
		} else {
			retval = zobj->handlers->read_property(container, offset, BP_VAR_R, ((IS_CV == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(offset)) : NULL), EX_VAR(opline->result.var));

			if (retval != EX_VAR(opline->result.var)) {
				ZVAL_COPY(EX_VAR(opline->result.var), retval);
			}
		}
	} while (0);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_W_SPEC_UNUSED_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *property;
	zval *container;

	SAVE_OPLINE();
	property = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);

	container = _get_obj_zval_ptr_unused(execute_data);
	if (IS_UNUSED == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}
	if (IS_UNUSED == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an object");

		HANDLE_EXCEPTION();
	}

	zend_fetch_property_address(EX_VAR(opline->result.var), container, IS_UNUSED, property, IS_CV, ((IS_CV == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), BP_VAR_W);

	if (IS_UNUSED == IS_VAR && READY_TO_DESTROY(free_op1)) {
		EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 0);
	}

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_RW_SPEC_UNUSED_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *property;
	zval *container;

	SAVE_OPLINE();
	property = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);
	container = _get_obj_zval_ptr_unused(execute_data);

	if (IS_UNUSED == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}
	if (IS_UNUSED == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an object");

		HANDLE_EXCEPTION();
	}
	zend_fetch_property_address(EX_VAR(opline->result.var), container, IS_UNUSED, property, IS_CV, ((IS_CV == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), BP_VAR_RW);

	if (IS_UNUSED == IS_VAR && READY_TO_DESTROY(free_op1)) {
		EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 0);
	}

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_IS_SPEC_UNUSED_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *container;

	zval *offset;

	SAVE_OPLINE();
	container = _get_obj_zval_ptr_unused(execute_data);

	if (IS_UNUSED == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}

	offset  = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);

	if (IS_UNUSED == IS_CONST ||
	    (IS_UNUSED != IS_UNUSED && UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT))) {
		if ((IS_UNUSED & (IS_VAR|IS_CV)) && Z_ISREF_P(container)) {
			container = Z_REFVAL_P(container);
			if (UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT)) {
				goto fetch_obj_is_no_object;
			}
		} else {
			goto fetch_obj_is_no_object;
		}
	}

	/* here we are sure we are dealing with an object */
	do {
		zend_object *zobj = Z_OBJ_P(container);
		zval *retval;

		if (IS_CV == IS_CONST &&
			EXPECTED(zobj->ce == CACHED_PTR(Z_CACHE_SLOT_P(offset)))) {
			uint32_t prop_offset = (uint32_t)(intptr_t)CACHED_PTR(Z_CACHE_SLOT_P(offset) + sizeof(void*));

			if (EXPECTED(prop_offset != (uint32_t)ZEND_DYNAMIC_PROPERTY_OFFSET)) {
				retval = OBJ_PROP(zobj, prop_offset);
				if (EXPECTED(Z_TYPE_P(retval) != IS_UNDEF)) {
					ZVAL_COPY(EX_VAR(opline->result.var), retval);
					break;
				}
			} else if (EXPECTED(zobj->properties != NULL)) {
				retval = zend_hash_find(zobj->properties, Z_STR_P(offset));
				if (EXPECTED(retval)) {
					ZVAL_COPY(EX_VAR(opline->result.var), retval);
					break;
				}
			}
		}

		if (UNEXPECTED(zobj->handlers->read_property == NULL)) {
fetch_obj_is_no_object:
			ZVAL_NULL(EX_VAR(opline->result.var));
		} else {

			retval = zobj->handlers->read_property(container, offset, BP_VAR_IS, ((IS_CV == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(offset)) : NULL), EX_VAR(opline->result.var));

			if (retval != EX_VAR(opline->result.var)) {
				ZVAL_COPY(EX_VAR(opline->result.var), retval);
			}
		}
	} while (0);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_FUNC_ARG_SPEC_UNUSED_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *container;

	if (zend_is_by_ref_func_arg_fetch(opline, EX(call))) {
		/* Behave like FETCH_OBJ_W */
		zend_free_op free_op1;
		zval *property;

		SAVE_OPLINE();
		property = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);
		container = _get_obj_zval_ptr_unused(execute_data);

		if (IS_UNUSED == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
			zend_throw_error(NULL, "Using $this when not in object context");

			HANDLE_EXCEPTION();
		}
		if (IS_UNUSED == IS_CONST || IS_UNUSED == IS_TMP_VAR) {
			zend_throw_error(NULL, "Cannot use temporary expression in write context");


			HANDLE_EXCEPTION();
		}
		if (IS_UNUSED == IS_VAR && UNEXPECTED(container == NULL)) {
			zend_throw_error(NULL, "Cannot use string offset as an object");

			HANDLE_EXCEPTION();
		}
		zend_fetch_property_address(EX_VAR(opline->result.var), container, IS_UNUSED, property, IS_CV, ((IS_CV == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), BP_VAR_W);

		if (IS_UNUSED == IS_VAR && READY_TO_DESTROY(free_op1)) {
			EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 0);
		}

		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	} else {
		ZEND_VM_TAIL_CALL(ZEND_FETCH_OBJ_R_SPEC_UNUSED_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS_PASSTHRU));
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_UNSET_SPEC_UNUSED_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *container, *property;

	SAVE_OPLINE();
	container = _get_obj_zval_ptr_unused(execute_data);

	if (IS_UNUSED == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}

	property = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);

	if (IS_UNUSED == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an object");

		HANDLE_EXCEPTION();
	}
	zend_fetch_property_address(EX_VAR(opline->result.var), container, IS_UNUSED, property, IS_CV, ((IS_CV == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), BP_VAR_UNSET);

	if (IS_UNUSED == IS_VAR && READY_TO_DESTROY(free_op1)) {
		EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 0);
	}

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_OBJ_SPEC_UNUSED_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *object;
	zval *property_name;

	SAVE_OPLINE();
	object = _get_obj_zval_ptr_unused(execute_data);

	if (IS_UNUSED == IS_UNUSED && UNEXPECTED(Z_OBJ_P(object) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}

	property_name = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);

	if (IS_UNUSED == IS_VAR && UNEXPECTED(object == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an array");

		HANDLE_EXCEPTION();
	}
	zend_assign_to_object(UNEXPECTED(RETURN_VALUE_USED(opline)) ? EX_VAR(opline->result.var) : NULL, object, IS_UNUSED, property_name, IS_CV, (opline+1)->op1_type, (opline+1)->op1, execute_data, ((IS_CV == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property_name)) : NULL));


	/* assign_obj has two opcodes! */
	ZEND_VM_NEXT_OPCODE_EX(1, 2);
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ROPE_INIT_SPEC_UNUSED_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zend_string **rope;
	zval *var;

	/* Compiler allocates the necessary number of zval slots to keep the rope */
	rope = (zend_string**)EX_VAR(opline->result.var);
	if (IS_CV == IS_CONST) {
		var = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);
		rope[0] = zend_string_copy(Z_STR_P(var));
	} else {
		var = _get_zval_ptr_cv_undef(execute_data, opline->op2.var);
		if (EXPECTED(Z_TYPE_P(var) == IS_STRING)) {
			if (IS_CV == IS_CV) {
				rope[0] = zend_string_copy(Z_STR_P(var));
			} else {
				rope[0] = Z_STR_P(var);
			}
		} else {
			SAVE_OPLINE();
			if (IS_CV == IS_CV && UNEXPECTED(Z_TYPE_P(var) == IS_UNDEF)) {
				GET_OP2_UNDEF_CV(var, BP_VAR_R);
			}
			rope[0] = _zval_get_string_func(var);

			ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
		}
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_INIT_METHOD_CALL_SPEC_UNUSED_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *function_name;

	zval *object;
	zend_function *fbc;
	zend_class_entry *called_scope;
	zend_object *obj;
	zend_execute_data *call;
	uint32_t call_info;

	SAVE_OPLINE();

	function_name = _get_zval_ptr_cv_undef(execute_data, opline->op2.var);

	if (IS_CV != IS_CONST &&
	    UNEXPECTED(Z_TYPE_P(function_name) != IS_STRING)) {
		do {
			if ((IS_CV & (IS_VAR|IS_CV)) && Z_ISREF_P(function_name)) {
				function_name = Z_REFVAL_P(function_name);
				if (EXPECTED(Z_TYPE_P(function_name) == IS_STRING)) {
					break;
				}
			}
			if (IS_CV == IS_CV && UNEXPECTED(Z_TYPE_P(function_name) == IS_UNDEF)) {
				GET_OP2_UNDEF_CV(function_name, BP_VAR_R);
			}
			if (UNEXPECTED(EG(exception) != NULL)) {
				HANDLE_EXCEPTION();
			}
			zend_throw_error(NULL, "Method name must be a string");


			HANDLE_EXCEPTION();
		} while (0);
	}

	object = _get_obj_zval_ptr_unused(execute_data);

	if (IS_UNUSED == IS_UNUSED && UNEXPECTED(Z_OBJ_P(object) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}

	if (IS_UNUSED != IS_UNUSED) {
		do {
			if (IS_UNUSED == IS_CONST || UNEXPECTED(Z_TYPE_P(object) != IS_OBJECT)) {
				if ((IS_UNUSED & (IS_VAR|IS_CV)) && EXPECTED(Z_ISREF_P(object))) {
					object = Z_REFVAL_P(object);
					if (EXPECTED(Z_TYPE_P(object) == IS_OBJECT)) {
						break;
					}
				}
				if (IS_UNUSED == IS_CV && UNEXPECTED(Z_TYPE_P(object) == IS_UNDEF)) {
					GET_OP1_UNDEF_CV(object, BP_VAR_R);
				}
				if (UNEXPECTED(EG(exception) != NULL)) {
					HANDLE_EXCEPTION();
				}
				zend_throw_error(NULL, "Call to a member function %s() on %s", Z_STRVAL_P(function_name), zend_get_type_by_const(Z_TYPE_P(object)));


				HANDLE_EXCEPTION();
			}
		} while (0);
	}

	obj = Z_OBJ_P(object);
	called_scope = obj->ce;

	if (IS_CV != IS_CONST ||
	    UNEXPECTED((fbc = CACHED_POLYMORPHIC_PTR(Z_CACHE_SLOT_P(function_name), called_scope)) == NULL)) {
	    zend_object *orig_obj = obj;

		if (UNEXPECTED(obj->handlers->get_method == NULL)) {
			zend_throw_error(NULL, "Object does not support method calls");


			HANDLE_EXCEPTION();
		}

		/* First, locate the function. */
		fbc = obj->handlers->get_method(&obj, Z_STR_P(function_name), ((IS_CV == IS_CONST) ? (EX_CONSTANT(opline->op2) + 1) : NULL));
		if (UNEXPECTED(fbc == NULL)) {
			if (EXPECTED(!EG(exception))) {
				zend_throw_error(NULL, "Call to undefined method %s::%s()", ZSTR_VAL(obj->ce->name), Z_STRVAL_P(function_name));
			}


			HANDLE_EXCEPTION();
		}
		if (IS_CV == IS_CONST &&
		    EXPECTED(fbc->type <= ZEND_USER_FUNCTION) &&
		    EXPECTED(!(fbc->common.fn_flags & (ZEND_ACC_CALL_VIA_TRAMPOLINE|ZEND_ACC_NEVER_CACHE))) &&
		    EXPECTED(obj == orig_obj)) {
			CACHE_POLYMORPHIC_PTR(Z_CACHE_SLOT_P(function_name), called_scope, fbc);
		}
	}

	call_info = ZEND_CALL_NESTED_FUNCTION;
	if (UNEXPECTED((fbc->common.fn_flags & ZEND_ACC_STATIC) != 0)) {
		obj = NULL;
	} else if (IS_UNUSED & (IS_VAR|IS_TMP_VAR|IS_CV)) {
		/* CV may be changed indirectly (e.g. when it's a reference) */
		call_info = ZEND_CALL_NESTED_FUNCTION | ZEND_CALL_RELEASE_THIS;
		GC_REFCOUNT(obj)++; /* For $this pointer */
	}

	call = zend_vm_stack_push_call_frame(call_info,
		fbc, opline->extended_value, called_scope, obj);
	call->prev_execute_data = EX(call);
	EX(call) = call;


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_INIT_ARRAY_SPEC_UNUSED_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	zval *array;
	uint32_t size;
	USE_OPLINE

	array = EX_VAR(opline->result.var);
	if (IS_UNUSED != IS_UNUSED) {
		size = opline->extended_value >> ZEND_ARRAY_SIZE_SHIFT;
	} else {
		size = 0;
	}
	ZVAL_NEW_ARR(array);
	zend_hash_init(Z_ARRVAL_P(array), size, NULL, ZVAL_PTR_DTOR, 0);

	if (IS_UNUSED != IS_UNUSED) {
		/* Explicitly initialize array as not-packed if flag is set */
		if (opline->extended_value & ZEND_ARRAY_NOT_PACKED) {
			zend_hash_real_init(Z_ARRVAL_P(array), 0);
		}
	}

	if (IS_UNUSED == IS_UNUSED) {
		ZEND_VM_NEXT_OPCODE();
#if 0 || (IS_UNUSED != IS_UNUSED)
	} else {
		ZEND_VM_TAIL_CALL(ZEND_ADD_ARRAY_ELEMENT_SPEC_UNUSED_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS_PASSTHRU));
#endif
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_UNSET_DIM_SPEC_UNUSED_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *container;
	zval *offset;
	zend_ulong hval;
	zend_string *key;

	SAVE_OPLINE();
	container = _get_obj_zval_ptr_unused(execute_data);
	if (IS_UNUSED == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}
	if (IS_UNUSED == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot unset string offsets");

		HANDLE_EXCEPTION();
	}
	offset = _get_zval_ptr_cv_undef(execute_data, opline->op2.var);

	do {
		if (IS_UNUSED != IS_UNUSED && EXPECTED(Z_TYPE_P(container) == IS_ARRAY)) {
			HashTable *ht;

unset_dim_array:
			SEPARATE_ARRAY(container);
			ht = Z_ARRVAL_P(container);
offset_again:
			if (EXPECTED(Z_TYPE_P(offset) == IS_STRING)) {
				key = Z_STR_P(offset);
				if (IS_CV != IS_CONST) {
					if (ZEND_HANDLE_NUMERIC(key, hval)) {
						goto num_index_dim;
					}
				}
str_index_dim:
				if (ht == &EG(symbol_table)) {
					zend_delete_global_variable(key);
				} else {
					zend_hash_del(ht, key);
				}
			} else if (EXPECTED(Z_TYPE_P(offset) == IS_LONG)) {
				hval = Z_LVAL_P(offset);
num_index_dim:
				zend_hash_index_del(ht, hval);
			} else if ((IS_CV & (IS_VAR|IS_CV)) && EXPECTED(Z_TYPE_P(offset) == IS_REFERENCE)) {
				offset = Z_REFVAL_P(offset);
				goto offset_again;
			} else if (Z_TYPE_P(offset) == IS_DOUBLE) {
				hval = zend_dval_to_lval(Z_DVAL_P(offset));
				goto num_index_dim;
			} else if (Z_TYPE_P(offset) == IS_NULL) {
				key = ZSTR_EMPTY_ALLOC();
				goto str_index_dim;
			} else if (Z_TYPE_P(offset) == IS_FALSE) {
				hval = 0;
				goto num_index_dim;
			} else if (Z_TYPE_P(offset) == IS_TRUE) {
				hval = 1;
				goto num_index_dim;
			} else if (Z_TYPE_P(offset) == IS_RESOURCE) {
				hval = Z_RES_HANDLE_P(offset);
				goto num_index_dim;
			} else if (IS_CV == IS_CV && Z_TYPE_P(offset) == IS_UNDEF) {
				GET_OP2_UNDEF_CV(offset, BP_VAR_R);
				key = ZSTR_EMPTY_ALLOC();
				goto str_index_dim;
			} else {
				zend_error(E_WARNING, "Illegal offset type in unset");
			}
			break;
		} else if (IS_UNUSED != IS_UNUSED && Z_ISREF_P(container)) {
			container = Z_REFVAL_P(container);
			if (EXPECTED(Z_TYPE_P(container) == IS_ARRAY)) {
				goto unset_dim_array;
			}
		}
		if (IS_CV == IS_CV && UNEXPECTED(Z_TYPE_P(offset) == IS_UNDEF)) {
			offset = GET_OP2_UNDEF_CV(offset, BP_VAR_R);
		}
		if (IS_UNUSED == IS_UNUSED || EXPECTED(Z_TYPE_P(container) == IS_OBJECT)) {
			if (UNEXPECTED(Z_OBJ_HT_P(container)->unset_dimension == NULL)) {
				zend_throw_error(NULL, "Cannot use object as array");
			} else {
				Z_OBJ_HT_P(container)->unset_dimension(container, offset);
			}
		} else if (IS_UNUSED != IS_UNUSED && UNEXPECTED(Z_TYPE_P(container) == IS_STRING)) {
			zend_throw_error(NULL, "Cannot unset string offsets");
		}
	} while (0);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_UNSET_OBJ_SPEC_UNUSED_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *container;
	zval *offset;

	SAVE_OPLINE();
	container = _get_obj_zval_ptr_unused(execute_data);
	if (IS_UNUSED == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}
	if (IS_UNUSED == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot unset string offsets");

		HANDLE_EXCEPTION();
	}
	offset = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);

	do {
		if (IS_UNUSED != IS_UNUSED && UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT)) {
			if (Z_ISREF_P(container)) {
				container = Z_REFVAL_P(container);
				if (Z_TYPE_P(container) != IS_OBJECT) {
					break;
				}
			} else {
				break;
			}
		}
		if (Z_OBJ_HT_P(container)->unset_property) {
			Z_OBJ_HT_P(container)->unset_property(container, offset, ((IS_CV == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(offset)) : NULL));
		} else {
			zend_error(E_NOTICE, "Trying to unset property of non-object");
		}
	} while (0);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ISSET_ISEMPTY_DIM_OBJ_SPEC_UNUSED_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *container;
	int result;
	zend_ulong hval;
	zval *offset;

	SAVE_OPLINE();
	container = _get_obj_zval_ptr_unused(execute_data);

	if (IS_UNUSED == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}

	offset = _get_zval_ptr_cv_undef(execute_data, opline->op2.var);

	if (IS_UNUSED != IS_UNUSED && EXPECTED(Z_TYPE_P(container) == IS_ARRAY)) {
		HashTable *ht;
		zval *value;
		zend_string *str;

isset_dim_obj_array:
		ht = Z_ARRVAL_P(container);
isset_again:
		if (EXPECTED(Z_TYPE_P(offset) == IS_STRING)) {
			str = Z_STR_P(offset);
			if (IS_CV != IS_CONST) {
				if (ZEND_HANDLE_NUMERIC(str, hval)) {
					goto num_index_prop;
				}
			}
str_index_prop:
			value = zend_hash_find_ind(ht, str);
		} else if (EXPECTED(Z_TYPE_P(offset) == IS_LONG)) {
			hval = Z_LVAL_P(offset);
num_index_prop:
			value = zend_hash_index_find(ht, hval);
		} else if ((IS_CV & (IS_VAR|IS_CV)) && EXPECTED(Z_ISREF_P(offset))) {
			offset = Z_REFVAL_P(offset);
			goto isset_again;
		} else if (Z_TYPE_P(offset) == IS_DOUBLE) {
			hval = zend_dval_to_lval(Z_DVAL_P(offset));
			goto num_index_prop;
		} else if (Z_TYPE_P(offset) == IS_NULL) {
			str = ZSTR_EMPTY_ALLOC();
			goto str_index_prop;
		} else if (Z_TYPE_P(offset) == IS_FALSE) {
			hval = 0;
			goto num_index_prop;
		} else if (Z_TYPE_P(offset) == IS_TRUE) {
			hval = 1;
			goto num_index_prop;
		} else if (Z_TYPE_P(offset) == IS_RESOURCE) {
			hval = Z_RES_HANDLE_P(offset);
			goto num_index_prop;
		} else if (IS_CV == IS_CV && Z_TYPE_P(offset) == IS_UNDEF) {
			GET_OP2_UNDEF_CV(offset, BP_VAR_R);
			str = ZSTR_EMPTY_ALLOC();
			goto str_index_prop;
		} else {
			zend_error(E_WARNING, "Illegal offset type in isset or empty");
			goto isset_not_found;
		}

		if (opline->extended_value & ZEND_ISSET) {
			/* > IS_NULL means not IS_UNDEF and not IS_NULL */
			result = value != NULL && Z_TYPE_P(value) > IS_NULL &&
			    (!Z_ISREF_P(value) || Z_TYPE_P(Z_REFVAL_P(value)) != IS_NULL);
		} else /* if (opline->extended_value & ZEND_ISEMPTY) */ {
			result = (value == NULL || !i_zend_is_true(value));
		}
		goto isset_dim_obj_exit;
	} else if ((IS_UNUSED & (IS_VAR|IS_CV)) && Z_ISREF_P(container)) {
		container = Z_REFVAL_P(container);
		if (EXPECTED(Z_TYPE_P(container) == IS_ARRAY)) {
			goto isset_dim_obj_array;
		}
	}

	if (IS_CV == IS_CV && UNEXPECTED(Z_TYPE_P(offset) == IS_UNDEF)) {
		offset = GET_OP2_UNDEF_CV(offset, BP_VAR_R);
	}

	if (IS_UNUSED == IS_UNUSED ||
	    (IS_UNUSED != IS_CONST && EXPECTED(Z_TYPE_P(container) == IS_OBJECT))) {
		if (EXPECTED(Z_OBJ_HT_P(container)->has_dimension)) {
			result =
				((opline->extended_value & ZEND_ISSET) == 0) ^
				Z_OBJ_HT_P(container)->has_dimension(container, offset, (opline->extended_value & ZEND_ISSET) == 0);
		} else {
			zend_error(E_NOTICE, "Trying to check element of non-array");
			goto isset_not_found;
		}
	} else if (EXPECTED(Z_TYPE_P(container) == IS_STRING)) { /* string offsets */
		zend_long lval;

		if (EXPECTED(Z_TYPE_P(offset) == IS_LONG)) {
			lval = Z_LVAL_P(offset);
isset_str_offset:
			if (EXPECTED(lval >= 0) && (size_t)lval < Z_STRLEN_P(container)) {
				if (opline->extended_value & ZEND_ISSET) {
					result = 1;
				} else {
					result = (Z_STRVAL_P(container)[lval] == '0');
				}
			} else {
				goto isset_not_found;
			}
		} else {
			if (IS_CV & (IS_CV|IS_VAR)) {
				ZVAL_DEREF(offset);
			}
			if (Z_TYPE_P(offset) < IS_STRING /* simple scalar types */
					|| (Z_TYPE_P(offset) == IS_STRING /* or numeric string */
						&& IS_LONG == is_numeric_string(Z_STRVAL_P(offset), Z_STRLEN_P(offset), NULL, NULL, 0))) {
				lval = zval_get_long(offset);
				goto isset_str_offset;
			}
			goto isset_not_found;
		}
	} else {
isset_not_found:
		result = ((opline->extended_value & ZEND_ISSET) == 0);
	}

isset_dim_obj_exit:


	ZEND_VM_SMART_BRANCH(result, 1);
	ZVAL_BOOL(EX_VAR(opline->result.var), result);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ISSET_ISEMPTY_PROP_OBJ_SPEC_UNUSED_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *container;
	int result;
	zval *offset;

	SAVE_OPLINE();
	container = _get_obj_zval_ptr_unused(execute_data);

	if (IS_UNUSED == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}

	offset = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);

	if (IS_UNUSED == IS_CONST ||
	    (IS_UNUSED != IS_UNUSED && UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT))) {
		if ((IS_UNUSED & (IS_VAR|IS_CV)) && Z_ISREF_P(container)) {
			container = Z_REFVAL_P(container);
			if (UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT)) {
				goto isset_no_object;
			}
		} else {
			goto isset_no_object;
		}
	}
	if (UNEXPECTED(!Z_OBJ_HT_P(container)->has_property)) {
		zend_error(E_NOTICE, "Trying to check property of non-object");
isset_no_object:
		result = ((opline->extended_value & ZEND_ISSET) == 0);
	} else {
		result =
			((opline->extended_value & ZEND_ISSET) == 0) ^
			Z_OBJ_HT_P(container)->has_property(container, offset, (opline->extended_value & ZEND_ISSET) == 0, ((IS_CV == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(offset)) : NULL));
	}


	ZEND_VM_SMART_BRANCH(result, 1);
	ZVAL_BOOL(EX_VAR(opline->result.var), result);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_YIELD_SPEC_UNUSED_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zend_generator *generator = zend_get_running_generator(execute_data);

	SAVE_OPLINE();
	if (UNEXPECTED(generator->flags & ZEND_GENERATOR_FORCED_CLOSE)) {
		zend_throw_error(NULL, "Cannot yield from finally in a force-closed generator");


		HANDLE_EXCEPTION();
	}

	/* Destroy the previously yielded value */
	zval_ptr_dtor(&generator->value);

	/* Destroy the previously yielded key */
	zval_ptr_dtor(&generator->key);

	/* Set the new yielded value */
	if (IS_UNUSED != IS_UNUSED) {


		if (UNEXPECTED(EX(func)->op_array.fn_flags & ZEND_ACC_RETURN_REFERENCE)) {
			/* Constants and temporary variables aren't yieldable by reference,
			 * but we still allow them with a notice. */
			if (IS_UNUSED == IS_CONST || IS_UNUSED == IS_TMP_VAR) {
				zval *value;

				zend_error(E_NOTICE, "Only variable references should be yielded by reference");

				value = NULL;
				ZVAL_COPY_VALUE(&generator->value, value);
				if (IS_UNUSED != IS_CONST) {
					if (UNEXPECTED(Z_OPT_COPYABLE(generator->value))) {
						zval_copy_ctor_func(&generator->value);
					}
				}
			} else {
				zval *value_ptr = NULL;

				if (IS_UNUSED == IS_VAR && UNEXPECTED(value_ptr == NULL)) {
					zend_throw_error(NULL, "Cannot yield string offsets by reference");

					HANDLE_EXCEPTION();
				}

				/* If a function call result is yielded and the function did
				 * not return by reference we throw a notice. */
				if (IS_UNUSED == IS_VAR &&
				    (value_ptr == &EG(uninitialized_zval) ||
				     (opline->extended_value == ZEND_RETURNS_FUNCTION &&
				      !(Z_VAR_FLAGS_P(value_ptr) & IS_VAR_RET_REF)))) {
					zend_error(E_NOTICE, "Only variable references should be yielded by reference");
				} else {
					ZVAL_MAKE_REF(value_ptr);
				}
				ZVAL_COPY(&generator->value, value_ptr);

			}
		} else {
			zval *value = NULL;

			/* Consts, temporary variables and references need copying */
			if (IS_UNUSED == IS_CONST) {
				ZVAL_COPY_VALUE(&generator->value, value);
				if (UNEXPECTED(Z_OPT_COPYABLE(generator->value))) {
					zval_copy_ctor_func(&generator->value);
				}
			} else if (IS_UNUSED == IS_TMP_VAR) {
				ZVAL_COPY_VALUE(&generator->value, value);
            } else if ((IS_UNUSED & (IS_VAR|IS_CV)) && Z_ISREF_P(value)) {
				ZVAL_COPY(&generator->value, Z_REFVAL_P(value));

			} else {
				ZVAL_COPY_VALUE(&generator->value, value);
				if (IS_UNUSED == IS_CV) {
					if (Z_OPT_REFCOUNTED_P(value)) Z_ADDREF_P(value);
				}
			}
		}
	} else {
		/* If no value was specified yield null */
		ZVAL_NULL(&generator->value);
	}

	/* Set the new yielded key */
	if (IS_CV != IS_UNUSED) {

		zval *key = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op2.var);

		/* Consts, temporary variables and references need copying */
		if (IS_CV == IS_CONST) {
			ZVAL_COPY_VALUE(&generator->key, key);
			if (UNEXPECTED(Z_OPT_COPYABLE(generator->key))) {
				zval_copy_ctor_func(&generator->key);
			}
		} else if (IS_CV == IS_TMP_VAR) {
			ZVAL_COPY_VALUE(&generator->key, key);
		} else if ((IS_CV & (IS_VAR|IS_CV)) && Z_ISREF_P(key)) {
			ZVAL_COPY(&generator->key, Z_REFVAL_P(key));

		} else {
			ZVAL_COPY_VALUE(&generator->key, key);
			if (IS_CV == IS_CV) {
				if (Z_OPT_REFCOUNTED_P(key)) Z_ADDREF_P(key);
			}
		}

		if (Z_TYPE(generator->key) == IS_LONG
		    && Z_LVAL(generator->key) > generator->largest_used_integer_key
		) {
			generator->largest_used_integer_key = Z_LVAL(generator->key);
		}
	} else {
		/* If no key was specified we use auto-increment keys */
		generator->largest_used_integer_key++;
		ZVAL_LONG(&generator->key, generator->largest_used_integer_key);
	}

	if (RETURN_VALUE_USED(opline)) {
		/* If the return value of yield is used set the send
		 * target and initialize it to NULL */
		generator->send_target = EX_VAR(opline->result.var);
		ZVAL_NULL(generator->send_target);
	} else {
		generator->send_target = NULL;
	}

	/* We increment to the next op, so we are at the correct position when the
	 * generator is resumed. */
	ZEND_VM_INC_OPCODE();

	/* The GOTO VM uses a local opline variable. We need to set the opline
	 * variable in execute_data so we don't resume at an old position. */
	SAVE_OPLINE();

	ZEND_VM_RETURN();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL zend_binary_assign_op_obj_helper_SPEC_UNUSED_TMPVAR(binary_op_type binary_op ZEND_OPCODE_HANDLER_ARGS_DC)
{
	USE_OPLINE
	zend_free_op free_op2, free_op_data1;
	zval *object;
	zval *property;
	zval *value;
	zval *zptr;

	SAVE_OPLINE();
	object = _get_obj_zval_ptr_unused(execute_data);

	if (IS_UNUSED == IS_UNUSED && UNEXPECTED(Z_OBJ_P(object) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");
		FREE_UNFETCHED_OP((opline+1)->op1_type, (opline+1)->op1.var);
		zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
		HANDLE_EXCEPTION();
	}

	property = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);

	if (IS_UNUSED == IS_VAR && UNEXPECTED(object == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an object");
		FREE_UNFETCHED_OP((opline+1)->op1_type, (opline+1)->op1.var);
		zval_ptr_dtor_nogc(free_op2);
		HANDLE_EXCEPTION();
	}

	do {
		value = get_zval_ptr((opline+1)->op1_type, (opline+1)->op1, execute_data, &free_op_data1, BP_VAR_R);

		if (IS_UNUSED != IS_UNUSED && UNEXPECTED(Z_TYPE_P(object) != IS_OBJECT)) {
			ZVAL_DEREF(object);
			if (UNEXPECTED(!make_real_object(object))) {
				zend_error(E_WARNING, "Attempt to assign property of non-object");
				if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
					ZVAL_NULL(EX_VAR(opline->result.var));
				}
				break;
			}
		}

		/* here we are sure we are dealing with an object */
		if (EXPECTED(Z_OBJ_HT_P(object)->get_property_ptr_ptr)
			&& EXPECTED((zptr = Z_OBJ_HT_P(object)->get_property_ptr_ptr(object, property, BP_VAR_RW, (((IS_TMP_VAR|IS_VAR) == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL))) != NULL)) {

			ZVAL_DEREF(zptr);
			SEPARATE_ZVAL_NOREF(zptr);

			binary_op(zptr, zptr, value);
			if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
				ZVAL_COPY(EX_VAR(opline->result.var), zptr);
			}
		} else {
			zend_assign_op_overloaded_property(object, property, (((IS_TMP_VAR|IS_VAR) == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), value, binary_op, (UNEXPECTED(RETURN_VALUE_USED(opline)) ? EX_VAR(opline->result.var) : NULL));
		}
	} while (0);

	FREE_OP(free_op_data1);
	zval_ptr_dtor_nogc(free_op2);

	/* assign_obj has two opcodes! */
	ZEND_VM_NEXT_OPCODE_EX(1, 2);
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL zend_binary_assign_op_dim_helper_SPEC_UNUSED_TMPVAR(binary_op_type binary_op ZEND_OPCODE_HANDLER_ARGS_DC)
{
	USE_OPLINE
	zend_free_op free_op2, free_op_data1;
	zval *var_ptr, rv;
	zval *value, *container, *dim;

	SAVE_OPLINE();
	container = _get_obj_zval_ptr_unused(execute_data);
	if (IS_UNUSED == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");
		FREE_UNFETCHED_OP((opline+1)->op1_type, (opline+1)->op1.var);
		zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
		HANDLE_EXCEPTION();
	}
	if (IS_UNUSED == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an array");
		FREE_UNFETCHED_OP((opline+1)->op1_type, (opline+1)->op1.var);
		zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
		HANDLE_EXCEPTION();
	}

	dim = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);

	do {
		if (IS_UNUSED == IS_UNUSED || UNEXPECTED(Z_TYPE_P(container) != IS_ARRAY)) {
			if (IS_UNUSED != IS_UNUSED) {
				ZVAL_DEREF(container);
			}
			if (IS_UNUSED == IS_UNUSED || EXPECTED(Z_TYPE_P(container) == IS_OBJECT)) {
				value = get_zval_ptr((opline+1)->op1_type, (opline+1)->op1, execute_data, &free_op_data1, BP_VAR_R);
				zend_binary_assign_op_obj_dim(container, dim, value, UNEXPECTED(RETURN_VALUE_USED(opline)) ? EX_VAR(opline->result.var) : NULL, binary_op);
				break;
			}
		}

		zend_fetch_dimension_address_RW(&rv, container, dim, (IS_TMP_VAR|IS_VAR));
		value = get_zval_ptr((opline+1)->op1_type, (opline+1)->op1, execute_data, &free_op_data1, BP_VAR_R);
		ZEND_ASSERT(Z_TYPE(rv) == IS_INDIRECT);
		var_ptr = Z_INDIRECT(rv);

		if (UNEXPECTED(var_ptr == NULL)) {
			zend_throw_error(NULL, "Cannot use assign-op operators with overloaded objects nor string offsets");
			zval_ptr_dtor_nogc(free_op2);
			FREE_OP(free_op_data1);

			HANDLE_EXCEPTION();
		}

		if (UNEXPECTED(var_ptr == &EG(error_zval))) {
			if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
				ZVAL_NULL(EX_VAR(opline->result.var));
			}
		} else {
			ZVAL_DEREF(var_ptr);
			SEPARATE_ZVAL_NOREF(var_ptr);

			binary_op(var_ptr, var_ptr, value);

			if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
				ZVAL_COPY(EX_VAR(opline->result.var), var_ptr);
			}
		}
	} while (0);

	zval_ptr_dtor_nogc(free_op2);
	FREE_OP(free_op_data1);

	ZEND_VM_NEXT_OPCODE_EX(1, 2);
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_ADD_SPEC_UNUSED_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || ((IS_TMP_VAR|IS_VAR) != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_UNUSED != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_UNUSED_TMPVAR(add_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_TMPVAR(add_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_UNUSED_TMPVAR(add_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_TMPVAR(add_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_SUB_SPEC_UNUSED_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || ((IS_TMP_VAR|IS_VAR) != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_UNUSED != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_UNUSED_TMPVAR(sub_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_TMPVAR(sub_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_UNUSED_TMPVAR(sub_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_TMPVAR(sub_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_MUL_SPEC_UNUSED_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || ((IS_TMP_VAR|IS_VAR) != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_UNUSED != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_UNUSED_TMPVAR(mul_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_TMPVAR(mul_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_UNUSED_TMPVAR(mul_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_TMPVAR(mul_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_DIV_SPEC_UNUSED_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || ((IS_TMP_VAR|IS_VAR) != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_UNUSED != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_UNUSED_TMPVAR(div_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_TMPVAR(div_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_UNUSED_TMPVAR(div_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_TMPVAR(div_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_MOD_SPEC_UNUSED_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || ((IS_TMP_VAR|IS_VAR) != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_UNUSED != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_UNUSED_TMPVAR(mod_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_TMPVAR(mod_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_UNUSED_TMPVAR(mod_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_TMPVAR(mod_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_SL_SPEC_UNUSED_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || ((IS_TMP_VAR|IS_VAR) != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_UNUSED != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_UNUSED_TMPVAR(shift_left_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_TMPVAR(shift_left_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_UNUSED_TMPVAR(shift_left_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_TMPVAR(shift_left_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_SR_SPEC_UNUSED_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || ((IS_TMP_VAR|IS_VAR) != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_UNUSED != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_UNUSED_TMPVAR(shift_right_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_TMPVAR(shift_right_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_UNUSED_TMPVAR(shift_right_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_TMPVAR(shift_right_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_CONCAT_SPEC_UNUSED_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || ((IS_TMP_VAR|IS_VAR) != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_UNUSED != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_UNUSED_TMPVAR(concat_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_TMPVAR(concat_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_UNUSED_TMPVAR(concat_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_TMPVAR(concat_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_BW_OR_SPEC_UNUSED_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || ((IS_TMP_VAR|IS_VAR) != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_UNUSED != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_UNUSED_TMPVAR(bitwise_or_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_TMPVAR(bitwise_or_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_UNUSED_TMPVAR(bitwise_or_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_TMPVAR(bitwise_or_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_BW_AND_SPEC_UNUSED_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || ((IS_TMP_VAR|IS_VAR) != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_UNUSED != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_UNUSED_TMPVAR(bitwise_and_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_TMPVAR(bitwise_and_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_UNUSED_TMPVAR(bitwise_and_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_TMPVAR(bitwise_and_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_BW_XOR_SPEC_UNUSED_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || ((IS_TMP_VAR|IS_VAR) != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_UNUSED != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_UNUSED_TMPVAR(bitwise_xor_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_TMPVAR(bitwise_xor_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_UNUSED_TMPVAR(bitwise_xor_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_UNUSED_TMPVAR(bitwise_xor_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL zend_pre_incdec_property_helper_SPEC_UNUSED_TMPVAR(int inc ZEND_OPCODE_HANDLER_ARGS_DC)
{
	USE_OPLINE
	zend_free_op free_op2;
	zval *object;
	zval *property;
	zval *zptr;

	SAVE_OPLINE();
	object = _get_obj_zval_ptr_unused(execute_data);

	if (IS_UNUSED == IS_UNUSED && UNEXPECTED(Z_OBJ_P(object) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");
		zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
		HANDLE_EXCEPTION();
	}

	property = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);

	if (IS_UNUSED == IS_VAR && UNEXPECTED(object == NULL)) {
		zend_throw_error(NULL, "Cannot increment/decrement overloaded objects nor string offsets");
		zval_ptr_dtor_nogc(free_op2);
		HANDLE_EXCEPTION();
	}

	do {
		if (IS_UNUSED != IS_UNUSED && UNEXPECTED(Z_TYPE_P(object) != IS_OBJECT)) {
			ZVAL_DEREF(object);
			if (UNEXPECTED(!make_real_object(object))) {
				zend_error(E_WARNING, "Attempt to increment/decrement property of non-object");
				if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
					ZVAL_NULL(EX_VAR(opline->result.var));
				}
				break;
			}
		}

		/* here we are sure we are dealing with an object */

		if (EXPECTED(Z_OBJ_HT_P(object)->get_property_ptr_ptr)
			&& EXPECTED((zptr = Z_OBJ_HT_P(object)->get_property_ptr_ptr(object, property, BP_VAR_RW, (((IS_TMP_VAR|IS_VAR) == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL))) != NULL)) {

			if (EXPECTED(Z_TYPE_P(zptr) == IS_LONG)) {
				if (inc) {
					fast_long_increment_function(zptr);
				} else {
					fast_long_decrement_function(zptr);
				}
			} else {
				ZVAL_DEREF(zptr);
				SEPARATE_ZVAL_NOREF(zptr);

				if (inc) {
					increment_function(zptr);
				} else {
					decrement_function(zptr);
				}
			}
			if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
				ZVAL_COPY(EX_VAR(opline->result.var), zptr);
			}
		} else {
			zend_pre_incdec_overloaded_property(object, property, (((IS_TMP_VAR|IS_VAR) == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), inc, (UNEXPECTED(RETURN_VALUE_USED(opline)) ? EX_VAR(opline->result.var) : NULL));
		}
	} while (0);

	zval_ptr_dtor_nogc(free_op2);

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_PRE_INC_OBJ_SPEC_UNUSED_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	ZEND_VM_TAIL_CALL(zend_pre_incdec_property_helper_SPEC_UNUSED_TMPVAR(1 ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_PRE_DEC_OBJ_SPEC_UNUSED_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	ZEND_VM_TAIL_CALL(zend_pre_incdec_property_helper_SPEC_UNUSED_TMPVAR(0 ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL zend_post_incdec_property_helper_SPEC_UNUSED_TMPVAR(int inc ZEND_OPCODE_HANDLER_ARGS_DC)
{
	USE_OPLINE
	zend_free_op free_op2;
	zval *object;
	zval *property;
	zval *zptr;

	SAVE_OPLINE();
	object = _get_obj_zval_ptr_unused(execute_data);

	if (IS_UNUSED == IS_UNUSED && UNEXPECTED(Z_OBJ_P(object) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");
		zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
		HANDLE_EXCEPTION();
	}

	property = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);

	if (IS_UNUSED == IS_VAR && UNEXPECTED(object == NULL)) {
		zend_throw_error(NULL, "Cannot increment/decrement overloaded objects nor string offsets");
		zval_ptr_dtor_nogc(free_op2);
		HANDLE_EXCEPTION();
	}

	do {
		if (IS_UNUSED != IS_UNUSED && UNEXPECTED(Z_TYPE_P(object) != IS_OBJECT)) {
			ZVAL_DEREF(object);
			if (UNEXPECTED(!make_real_object(object))) {
				zend_error(E_WARNING, "Attempt to increment/decrement property of non-object");
				ZVAL_NULL(EX_VAR(opline->result.var));
				break;
			}
		}

		/* here we are sure we are dealing with an object */

		if (EXPECTED(Z_OBJ_HT_P(object)->get_property_ptr_ptr)
			&& EXPECTED((zptr = Z_OBJ_HT_P(object)->get_property_ptr_ptr(object, property, BP_VAR_RW, (((IS_TMP_VAR|IS_VAR) == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL))) != NULL)) {

			if (EXPECTED(Z_TYPE_P(zptr) == IS_LONG)) {
				ZVAL_COPY_VALUE(EX_VAR(opline->result.var), zptr);
				if (inc) {
					fast_long_increment_function(zptr);
				} else {
					fast_long_decrement_function(zptr);
				}
			} else {
				ZVAL_DEREF(zptr);
				ZVAL_COPY_VALUE(EX_VAR(opline->result.var), zptr);
				zval_opt_copy_ctor(zptr);
				if (inc) {
					increment_function(zptr);
				} else {
					decrement_function(zptr);
				}
			}
		} else {
			zend_post_incdec_overloaded_property(object, property, (((IS_TMP_VAR|IS_VAR) == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), inc, EX_VAR(opline->result.var));
		}
	} while (0);

	zval_ptr_dtor_nogc(free_op2);

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_POST_INC_OBJ_SPEC_UNUSED_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	ZEND_VM_TAIL_CALL(zend_post_incdec_property_helper_SPEC_UNUSED_TMPVAR(1 ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_POST_DEC_OBJ_SPEC_UNUSED_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	ZEND_VM_TAIL_CALL(zend_post_incdec_property_helper_SPEC_UNUSED_TMPVAR(0 ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_R_SPEC_UNUSED_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *container;
	zend_free_op free_op2;
	zval *offset;

	SAVE_OPLINE();
	container = _get_obj_zval_ptr_unused(execute_data);

	if (IS_UNUSED == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");
		zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
		HANDLE_EXCEPTION();
	}

	offset = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);

	if (IS_UNUSED == IS_CONST ||
	    (IS_UNUSED != IS_UNUSED && UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT))) {
		if ((IS_UNUSED & (IS_VAR|IS_CV)) && Z_ISREF_P(container)) {
			container = Z_REFVAL_P(container);
			if (UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT)) {
				goto fetch_obj_r_no_object;
			}
		} else {
			goto fetch_obj_r_no_object;
		}
	}

	/* here we are sure we are dealing with an object */
	do {
		zend_object *zobj = Z_OBJ_P(container);
		zval *retval;

		if ((IS_TMP_VAR|IS_VAR) == IS_CONST &&
			EXPECTED(zobj->ce == CACHED_PTR(Z_CACHE_SLOT_P(offset)))) {
			uint32_t prop_offset = (uint32_t)(intptr_t)CACHED_PTR(Z_CACHE_SLOT_P(offset) + sizeof(void*));

			if (EXPECTED(prop_offset != (uint32_t)ZEND_DYNAMIC_PROPERTY_OFFSET)) {
				retval = OBJ_PROP(zobj, prop_offset);
				if (EXPECTED(Z_TYPE_P(retval) != IS_UNDEF)) {
					ZVAL_COPY(EX_VAR(opline->result.var), retval);
					break;
				}
			} else if (EXPECTED(zobj->properties != NULL)) {
				retval = zend_hash_find(zobj->properties, Z_STR_P(offset));
				if (EXPECTED(retval)) {
					ZVAL_COPY(EX_VAR(opline->result.var), retval);
					break;
				}
			}
		}

		if (UNEXPECTED(zobj->handlers->read_property == NULL)) {
fetch_obj_r_no_object:
			zend_error(E_NOTICE, "Trying to get property of non-object");
			ZVAL_NULL(EX_VAR(opline->result.var));
		} else {
			retval = zobj->handlers->read_property(container, offset, BP_VAR_R, (((IS_TMP_VAR|IS_VAR) == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(offset)) : NULL), EX_VAR(opline->result.var));

			if (retval != EX_VAR(opline->result.var)) {
				ZVAL_COPY(EX_VAR(opline->result.var), retval);
			}
		}
	} while (0);

	zval_ptr_dtor_nogc(free_op2);

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_W_SPEC_UNUSED_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1, free_op2;
	zval *property;
	zval *container;

	SAVE_OPLINE();
	property = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);

	container = _get_obj_zval_ptr_unused(execute_data);
	if (IS_UNUSED == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");
		zval_ptr_dtor_nogc(free_op2);
		HANDLE_EXCEPTION();
	}
	if (IS_UNUSED == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an object");
		zval_ptr_dtor_nogc(free_op2);
		HANDLE_EXCEPTION();
	}

	zend_fetch_property_address(EX_VAR(opline->result.var), container, IS_UNUSED, property, (IS_TMP_VAR|IS_VAR), (((IS_TMP_VAR|IS_VAR) == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), BP_VAR_W);
	zval_ptr_dtor_nogc(free_op2);
	if (IS_UNUSED == IS_VAR && READY_TO_DESTROY(free_op1)) {
		EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 0);
	}

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_RW_SPEC_UNUSED_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1, free_op2;
	zval *property;
	zval *container;

	SAVE_OPLINE();
	property = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);
	container = _get_obj_zval_ptr_unused(execute_data);

	if (IS_UNUSED == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");
		zval_ptr_dtor_nogc(free_op2);
		HANDLE_EXCEPTION();
	}
	if (IS_UNUSED == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an object");
		zval_ptr_dtor_nogc(free_op2);
		HANDLE_EXCEPTION();
	}
	zend_fetch_property_address(EX_VAR(opline->result.var), container, IS_UNUSED, property, (IS_TMP_VAR|IS_VAR), (((IS_TMP_VAR|IS_VAR) == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), BP_VAR_RW);
	zval_ptr_dtor_nogc(free_op2);
	if (IS_UNUSED == IS_VAR && READY_TO_DESTROY(free_op1)) {
		EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 0);
	}

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_IS_SPEC_UNUSED_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *container;
	zend_free_op free_op2;
	zval *offset;

	SAVE_OPLINE();
	container = _get_obj_zval_ptr_unused(execute_data);

	if (IS_UNUSED == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");
		zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
		HANDLE_EXCEPTION();
	}

	offset  = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);

	if (IS_UNUSED == IS_CONST ||
	    (IS_UNUSED != IS_UNUSED && UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT))) {
		if ((IS_UNUSED & (IS_VAR|IS_CV)) && Z_ISREF_P(container)) {
			container = Z_REFVAL_P(container);
			if (UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT)) {
				goto fetch_obj_is_no_object;
			}
		} else {
			goto fetch_obj_is_no_object;
		}
	}

	/* here we are sure we are dealing with an object */
	do {
		zend_object *zobj = Z_OBJ_P(container);
		zval *retval;

		if ((IS_TMP_VAR|IS_VAR) == IS_CONST &&
			EXPECTED(zobj->ce == CACHED_PTR(Z_CACHE_SLOT_P(offset)))) {
			uint32_t prop_offset = (uint32_t)(intptr_t)CACHED_PTR(Z_CACHE_SLOT_P(offset) + sizeof(void*));

			if (EXPECTED(prop_offset != (uint32_t)ZEND_DYNAMIC_PROPERTY_OFFSET)) {
				retval = OBJ_PROP(zobj, prop_offset);
				if (EXPECTED(Z_TYPE_P(retval) != IS_UNDEF)) {
					ZVAL_COPY(EX_VAR(opline->result.var), retval);
					break;
				}
			} else if (EXPECTED(zobj->properties != NULL)) {
				retval = zend_hash_find(zobj->properties, Z_STR_P(offset));
				if (EXPECTED(retval)) {
					ZVAL_COPY(EX_VAR(opline->result.var), retval);
					break;
				}
			}
		}

		if (UNEXPECTED(zobj->handlers->read_property == NULL)) {
fetch_obj_is_no_object:
			ZVAL_NULL(EX_VAR(opline->result.var));
		} else {

			retval = zobj->handlers->read_property(container, offset, BP_VAR_IS, (((IS_TMP_VAR|IS_VAR) == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(offset)) : NULL), EX_VAR(opline->result.var));

			if (retval != EX_VAR(opline->result.var)) {
				ZVAL_COPY(EX_VAR(opline->result.var), retval);
			}
		}
	} while (0);

	zval_ptr_dtor_nogc(free_op2);

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_FUNC_ARG_SPEC_UNUSED_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *container;

	if (zend_is_by_ref_func_arg_fetch(opline, EX(call))) {
		/* Behave like FETCH_OBJ_W */
		zend_free_op free_op1, free_op2;
		zval *property;

		SAVE_OPLINE();
		property = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);
		container = _get_obj_zval_ptr_unused(execute_data);

		if (IS_UNUSED == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
			zend_throw_error(NULL, "Using $this when not in object context");
			zval_ptr_dtor_nogc(free_op2);
			HANDLE_EXCEPTION();
		}
		if (IS_UNUSED == IS_CONST || IS_UNUSED == IS_TMP_VAR) {
			zend_throw_error(NULL, "Cannot use temporary expression in write context");
			zval_ptr_dtor_nogc(free_op2);

			HANDLE_EXCEPTION();
		}
		if (IS_UNUSED == IS_VAR && UNEXPECTED(container == NULL)) {
			zend_throw_error(NULL, "Cannot use string offset as an object");
			zval_ptr_dtor_nogc(free_op2);
			HANDLE_EXCEPTION();
		}
		zend_fetch_property_address(EX_VAR(opline->result.var), container, IS_UNUSED, property, (IS_TMP_VAR|IS_VAR), (((IS_TMP_VAR|IS_VAR) == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), BP_VAR_W);
		zval_ptr_dtor_nogc(free_op2);
		if (IS_UNUSED == IS_VAR && READY_TO_DESTROY(free_op1)) {
			EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 0);
		}

		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	} else {
		ZEND_VM_TAIL_CALL(ZEND_FETCH_OBJ_R_SPEC_UNUSED_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS_PASSTHRU));
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_UNSET_SPEC_UNUSED_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1, free_op2;
	zval *container, *property;

	SAVE_OPLINE();
	container = _get_obj_zval_ptr_unused(execute_data);

	if (IS_UNUSED == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");
		zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
		HANDLE_EXCEPTION();
	}

	property = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);

	if (IS_UNUSED == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an object");
		zval_ptr_dtor_nogc(free_op2);
		HANDLE_EXCEPTION();
	}
	zend_fetch_property_address(EX_VAR(opline->result.var), container, IS_UNUSED, property, (IS_TMP_VAR|IS_VAR), (((IS_TMP_VAR|IS_VAR) == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), BP_VAR_UNSET);
	zval_ptr_dtor_nogc(free_op2);
	if (IS_UNUSED == IS_VAR && READY_TO_DESTROY(free_op1)) {
		EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 0);
	}

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_OBJ_SPEC_UNUSED_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op2;
	zval *object;
	zval *property_name;

	SAVE_OPLINE();
	object = _get_obj_zval_ptr_unused(execute_data);

	if (IS_UNUSED == IS_UNUSED && UNEXPECTED(Z_OBJ_P(object) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");
		zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
		HANDLE_EXCEPTION();
	}

	property_name = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);

	if (IS_UNUSED == IS_VAR && UNEXPECTED(object == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an array");
		zval_ptr_dtor_nogc(free_op2);
		HANDLE_EXCEPTION();
	}
	zend_assign_to_object(UNEXPECTED(RETURN_VALUE_USED(opline)) ? EX_VAR(opline->result.var) : NULL, object, IS_UNUSED, property_name, (IS_TMP_VAR|IS_VAR), (opline+1)->op1_type, (opline+1)->op1, execute_data, (((IS_TMP_VAR|IS_VAR) == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property_name)) : NULL));
	zval_ptr_dtor_nogc(free_op2);

	/* assign_obj has two opcodes! */
	ZEND_VM_NEXT_OPCODE_EX(1, 2);
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ROPE_INIT_SPEC_UNUSED_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op2;
	zend_string **rope;
	zval *var;

	/* Compiler allocates the necessary number of zval slots to keep the rope */
	rope = (zend_string**)EX_VAR(opline->result.var);
	if ((IS_TMP_VAR|IS_VAR) == IS_CONST) {
		var = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);
		rope[0] = zend_string_copy(Z_STR_P(var));
	} else {
		var = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);
		if (EXPECTED(Z_TYPE_P(var) == IS_STRING)) {
			if ((IS_TMP_VAR|IS_VAR) == IS_CV) {
				rope[0] = zend_string_copy(Z_STR_P(var));
			} else {
				rope[0] = Z_STR_P(var);
			}
		} else {
			SAVE_OPLINE();
			if ((IS_TMP_VAR|IS_VAR) == IS_CV && UNEXPECTED(Z_TYPE_P(var) == IS_UNDEF)) {
				GET_OP2_UNDEF_CV(var, BP_VAR_R);
			}
			rope[0] = _zval_get_string_func(var);
			zval_ptr_dtor_nogc(free_op2);
			ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
		}
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_INIT_METHOD_CALL_SPEC_UNUSED_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *function_name;
	zend_free_op free_op2;
	zval *object;
	zend_function *fbc;
	zend_class_entry *called_scope;
	zend_object *obj;
	zend_execute_data *call;
	uint32_t call_info;

	SAVE_OPLINE();

	function_name = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);

	if ((IS_TMP_VAR|IS_VAR) != IS_CONST &&
	    UNEXPECTED(Z_TYPE_P(function_name) != IS_STRING)) {
		do {
			if (((IS_TMP_VAR|IS_VAR) & (IS_VAR|IS_CV)) && Z_ISREF_P(function_name)) {
				function_name = Z_REFVAL_P(function_name);
				if (EXPECTED(Z_TYPE_P(function_name) == IS_STRING)) {
					break;
				}
			}
			if ((IS_TMP_VAR|IS_VAR) == IS_CV && UNEXPECTED(Z_TYPE_P(function_name) == IS_UNDEF)) {
				GET_OP2_UNDEF_CV(function_name, BP_VAR_R);
			}
			if (UNEXPECTED(EG(exception) != NULL)) {
				HANDLE_EXCEPTION();
			}
			zend_throw_error(NULL, "Method name must be a string");
			zval_ptr_dtor_nogc(free_op2);

			HANDLE_EXCEPTION();
		} while (0);
	}

	object = _get_obj_zval_ptr_unused(execute_data);

	if (IS_UNUSED == IS_UNUSED && UNEXPECTED(Z_OBJ_P(object) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");
		zval_ptr_dtor_nogc(free_op2);
		HANDLE_EXCEPTION();
	}

	if (IS_UNUSED != IS_UNUSED) {
		do {
			if (IS_UNUSED == IS_CONST || UNEXPECTED(Z_TYPE_P(object) != IS_OBJECT)) {
				if ((IS_UNUSED & (IS_VAR|IS_CV)) && EXPECTED(Z_ISREF_P(object))) {
					object = Z_REFVAL_P(object);
					if (EXPECTED(Z_TYPE_P(object) == IS_OBJECT)) {
						break;
					}
				}
				if (IS_UNUSED == IS_CV && UNEXPECTED(Z_TYPE_P(object) == IS_UNDEF)) {
					GET_OP1_UNDEF_CV(object, BP_VAR_R);
				}
				if (UNEXPECTED(EG(exception) != NULL)) {
					HANDLE_EXCEPTION();
				}
				zend_throw_error(NULL, "Call to a member function %s() on %s", Z_STRVAL_P(function_name), zend_get_type_by_const(Z_TYPE_P(object)));
				zval_ptr_dtor_nogc(free_op2);

				HANDLE_EXCEPTION();
			}
		} while (0);
	}

	obj = Z_OBJ_P(object);
	called_scope = obj->ce;

	if ((IS_TMP_VAR|IS_VAR) != IS_CONST ||
	    UNEXPECTED((fbc = CACHED_POLYMORPHIC_PTR(Z_CACHE_SLOT_P(function_name), called_scope)) == NULL)) {
	    zend_object *orig_obj = obj;

		if (UNEXPECTED(obj->handlers->get_method == NULL)) {
			zend_throw_error(NULL, "Object does not support method calls");
			zval_ptr_dtor_nogc(free_op2);

			HANDLE_EXCEPTION();
		}

		/* First, locate the function. */
		fbc = obj->handlers->get_method(&obj, Z_STR_P(function_name), (((IS_TMP_VAR|IS_VAR) == IS_CONST) ? (EX_CONSTANT(opline->op2) + 1) : NULL));
		if (UNEXPECTED(fbc == NULL)) {
			if (EXPECTED(!EG(exception))) {
				zend_throw_error(NULL, "Call to undefined method %s::%s()", ZSTR_VAL(obj->ce->name), Z_STRVAL_P(function_name));
			}
			zval_ptr_dtor_nogc(free_op2);

			HANDLE_EXCEPTION();
		}
		if ((IS_TMP_VAR|IS_VAR) == IS_CONST &&
		    EXPECTED(fbc->type <= ZEND_USER_FUNCTION) &&
		    EXPECTED(!(fbc->common.fn_flags & (ZEND_ACC_CALL_VIA_TRAMPOLINE|ZEND_ACC_NEVER_CACHE))) &&
		    EXPECTED(obj == orig_obj)) {
			CACHE_POLYMORPHIC_PTR(Z_CACHE_SLOT_P(function_name), called_scope, fbc);
		}
	}

	call_info = ZEND_CALL_NESTED_FUNCTION;
	if (UNEXPECTED((fbc->common.fn_flags & ZEND_ACC_STATIC) != 0)) {
		obj = NULL;
	} else if (IS_UNUSED & (IS_VAR|IS_TMP_VAR|IS_CV)) {
		/* CV may be changed indirectly (e.g. when it's a reference) */
		call_info = ZEND_CALL_NESTED_FUNCTION | ZEND_CALL_RELEASE_THIS;
		GC_REFCOUNT(obj)++; /* For $this pointer */
	}

	call = zend_vm_stack_push_call_frame(call_info,
		fbc, opline->extended_value, called_scope, obj);
	call->prev_execute_data = EX(call);
	EX(call) = call;

	zval_ptr_dtor_nogc(free_op2);

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_INIT_ARRAY_SPEC_UNUSED_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	zval *array;
	uint32_t size;
	USE_OPLINE

	array = EX_VAR(opline->result.var);
	if (IS_UNUSED != IS_UNUSED) {
		size = opline->extended_value >> ZEND_ARRAY_SIZE_SHIFT;
	} else {
		size = 0;
	}
	ZVAL_NEW_ARR(array);
	zend_hash_init(Z_ARRVAL_P(array), size, NULL, ZVAL_PTR_DTOR, 0);

	if (IS_UNUSED != IS_UNUSED) {
		/* Explicitly initialize array as not-packed if flag is set */
		if (opline->extended_value & ZEND_ARRAY_NOT_PACKED) {
			zend_hash_real_init(Z_ARRVAL_P(array), 0);
		}
	}

	if (IS_UNUSED == IS_UNUSED) {
		ZEND_VM_NEXT_OPCODE();
#if 0 || (IS_UNUSED != IS_UNUSED)
	} else {
		ZEND_VM_TAIL_CALL(ZEND_ADD_ARRAY_ELEMENT_SPEC_UNUSED_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS_PASSTHRU));
#endif
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_UNSET_DIM_SPEC_UNUSED_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op2;
	zval *container;
	zval *offset;
	zend_ulong hval;
	zend_string *key;

	SAVE_OPLINE();
	container = _get_obj_zval_ptr_unused(execute_data);
	if (IS_UNUSED == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");
		zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
		HANDLE_EXCEPTION();
	}
	if (IS_UNUSED == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot unset string offsets");
		zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
		HANDLE_EXCEPTION();
	}
	offset = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);

	do {
		if (IS_UNUSED != IS_UNUSED && EXPECTED(Z_TYPE_P(container) == IS_ARRAY)) {
			HashTable *ht;

unset_dim_array:
			SEPARATE_ARRAY(container);
			ht = Z_ARRVAL_P(container);
offset_again:
			if (EXPECTED(Z_TYPE_P(offset) == IS_STRING)) {
				key = Z_STR_P(offset);
				if ((IS_TMP_VAR|IS_VAR) != IS_CONST) {
					if (ZEND_HANDLE_NUMERIC(key, hval)) {
						goto num_index_dim;
					}
				}
str_index_dim:
				if (ht == &EG(symbol_table)) {
					zend_delete_global_variable(key);
				} else {
					zend_hash_del(ht, key);
				}
			} else if (EXPECTED(Z_TYPE_P(offset) == IS_LONG)) {
				hval = Z_LVAL_P(offset);
num_index_dim:
				zend_hash_index_del(ht, hval);
			} else if (((IS_TMP_VAR|IS_VAR) & (IS_VAR|IS_CV)) && EXPECTED(Z_TYPE_P(offset) == IS_REFERENCE)) {
				offset = Z_REFVAL_P(offset);
				goto offset_again;
			} else if (Z_TYPE_P(offset) == IS_DOUBLE) {
				hval = zend_dval_to_lval(Z_DVAL_P(offset));
				goto num_index_dim;
			} else if (Z_TYPE_P(offset) == IS_NULL) {
				key = ZSTR_EMPTY_ALLOC();
				goto str_index_dim;
			} else if (Z_TYPE_P(offset) == IS_FALSE) {
				hval = 0;
				goto num_index_dim;
			} else if (Z_TYPE_P(offset) == IS_TRUE) {
				hval = 1;
				goto num_index_dim;
			} else if (Z_TYPE_P(offset) == IS_RESOURCE) {
				hval = Z_RES_HANDLE_P(offset);
				goto num_index_dim;
			} else if ((IS_TMP_VAR|IS_VAR) == IS_CV && Z_TYPE_P(offset) == IS_UNDEF) {
				GET_OP2_UNDEF_CV(offset, BP_VAR_R);
				key = ZSTR_EMPTY_ALLOC();
				goto str_index_dim;
			} else {
				zend_error(E_WARNING, "Illegal offset type in unset");
			}
			break;
		} else if (IS_UNUSED != IS_UNUSED && Z_ISREF_P(container)) {
			container = Z_REFVAL_P(container);
			if (EXPECTED(Z_TYPE_P(container) == IS_ARRAY)) {
				goto unset_dim_array;
			}
		}
		if ((IS_TMP_VAR|IS_VAR) == IS_CV && UNEXPECTED(Z_TYPE_P(offset) == IS_UNDEF)) {
			offset = GET_OP2_UNDEF_CV(offset, BP_VAR_R);
		}
		if (IS_UNUSED == IS_UNUSED || EXPECTED(Z_TYPE_P(container) == IS_OBJECT)) {
			if (UNEXPECTED(Z_OBJ_HT_P(container)->unset_dimension == NULL)) {
				zend_throw_error(NULL, "Cannot use object as array");
			} else {
				Z_OBJ_HT_P(container)->unset_dimension(container, offset);
			}
		} else if (IS_UNUSED != IS_UNUSED && UNEXPECTED(Z_TYPE_P(container) == IS_STRING)) {
			zend_throw_error(NULL, "Cannot unset string offsets");
		}
	} while (0);

	zval_ptr_dtor_nogc(free_op2);

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_UNSET_OBJ_SPEC_UNUSED_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op2;
	zval *container;
	zval *offset;

	SAVE_OPLINE();
	container = _get_obj_zval_ptr_unused(execute_data);
	if (IS_UNUSED == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");
		zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
		HANDLE_EXCEPTION();
	}
	if (IS_UNUSED == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot unset string offsets");
		zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
		HANDLE_EXCEPTION();
	}
	offset = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);

	do {
		if (IS_UNUSED != IS_UNUSED && UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT)) {
			if (Z_ISREF_P(container)) {
				container = Z_REFVAL_P(container);
				if (Z_TYPE_P(container) != IS_OBJECT) {
					break;
				}
			} else {
				break;
			}
		}
		if (Z_OBJ_HT_P(container)->unset_property) {
			Z_OBJ_HT_P(container)->unset_property(container, offset, (((IS_TMP_VAR|IS_VAR) == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(offset)) : NULL));
		} else {
			zend_error(E_NOTICE, "Trying to unset property of non-object");
		}
	} while (0);

	zval_ptr_dtor_nogc(free_op2);

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ISSET_ISEMPTY_DIM_OBJ_SPEC_UNUSED_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op2;
	zval *container;
	int result;
	zend_ulong hval;
	zval *offset;

	SAVE_OPLINE();
	container = _get_obj_zval_ptr_unused(execute_data);

	if (IS_UNUSED == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");
		zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
		HANDLE_EXCEPTION();
	}

	offset = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);

	if (IS_UNUSED != IS_UNUSED && EXPECTED(Z_TYPE_P(container) == IS_ARRAY)) {
		HashTable *ht;
		zval *value;
		zend_string *str;

isset_dim_obj_array:
		ht = Z_ARRVAL_P(container);
isset_again:
		if (EXPECTED(Z_TYPE_P(offset) == IS_STRING)) {
			str = Z_STR_P(offset);
			if ((IS_TMP_VAR|IS_VAR) != IS_CONST) {
				if (ZEND_HANDLE_NUMERIC(str, hval)) {
					goto num_index_prop;
				}
			}
str_index_prop:
			value = zend_hash_find_ind(ht, str);
		} else if (EXPECTED(Z_TYPE_P(offset) == IS_LONG)) {
			hval = Z_LVAL_P(offset);
num_index_prop:
			value = zend_hash_index_find(ht, hval);
		} else if (((IS_TMP_VAR|IS_VAR) & (IS_VAR|IS_CV)) && EXPECTED(Z_ISREF_P(offset))) {
			offset = Z_REFVAL_P(offset);
			goto isset_again;
		} else if (Z_TYPE_P(offset) == IS_DOUBLE) {
			hval = zend_dval_to_lval(Z_DVAL_P(offset));
			goto num_index_prop;
		} else if (Z_TYPE_P(offset) == IS_NULL) {
			str = ZSTR_EMPTY_ALLOC();
			goto str_index_prop;
		} else if (Z_TYPE_P(offset) == IS_FALSE) {
			hval = 0;
			goto num_index_prop;
		} else if (Z_TYPE_P(offset) == IS_TRUE) {
			hval = 1;
			goto num_index_prop;
		} else if (Z_TYPE_P(offset) == IS_RESOURCE) {
			hval = Z_RES_HANDLE_P(offset);
			goto num_index_prop;
		} else if ((IS_TMP_VAR|IS_VAR) == IS_CV && Z_TYPE_P(offset) == IS_UNDEF) {
			GET_OP2_UNDEF_CV(offset, BP_VAR_R);
			str = ZSTR_EMPTY_ALLOC();
			goto str_index_prop;
		} else {
			zend_error(E_WARNING, "Illegal offset type in isset or empty");
			goto isset_not_found;
		}

		if (opline->extended_value & ZEND_ISSET) {
			/* > IS_NULL means not IS_UNDEF and not IS_NULL */
			result = value != NULL && Z_TYPE_P(value) > IS_NULL &&
			    (!Z_ISREF_P(value) || Z_TYPE_P(Z_REFVAL_P(value)) != IS_NULL);
		} else /* if (opline->extended_value & ZEND_ISEMPTY) */ {
			result = (value == NULL || !i_zend_is_true(value));
		}
		goto isset_dim_obj_exit;
	} else if ((IS_UNUSED & (IS_VAR|IS_CV)) && Z_ISREF_P(container)) {
		container = Z_REFVAL_P(container);
		if (EXPECTED(Z_TYPE_P(container) == IS_ARRAY)) {
			goto isset_dim_obj_array;
		}
	}

	if ((IS_TMP_VAR|IS_VAR) == IS_CV && UNEXPECTED(Z_TYPE_P(offset) == IS_UNDEF)) {
		offset = GET_OP2_UNDEF_CV(offset, BP_VAR_R);
	}

	if (IS_UNUSED == IS_UNUSED ||
	    (IS_UNUSED != IS_CONST && EXPECTED(Z_TYPE_P(container) == IS_OBJECT))) {
		if (EXPECTED(Z_OBJ_HT_P(container)->has_dimension)) {
			result =
				((opline->extended_value & ZEND_ISSET) == 0) ^
				Z_OBJ_HT_P(container)->has_dimension(container, offset, (opline->extended_value & ZEND_ISSET) == 0);
		} else {
			zend_error(E_NOTICE, "Trying to check element of non-array");
			goto isset_not_found;
		}
	} else if (EXPECTED(Z_TYPE_P(container) == IS_STRING)) { /* string offsets */
		zend_long lval;

		if (EXPECTED(Z_TYPE_P(offset) == IS_LONG)) {
			lval = Z_LVAL_P(offset);
isset_str_offset:
			if (EXPECTED(lval >= 0) && (size_t)lval < Z_STRLEN_P(container)) {
				if (opline->extended_value & ZEND_ISSET) {
					result = 1;
				} else {
					result = (Z_STRVAL_P(container)[lval] == '0');
				}
			} else {
				goto isset_not_found;
			}
		} else {
			if ((IS_TMP_VAR|IS_VAR) & (IS_CV|IS_VAR)) {
				ZVAL_DEREF(offset);
			}
			if (Z_TYPE_P(offset) < IS_STRING /* simple scalar types */
					|| (Z_TYPE_P(offset) == IS_STRING /* or numeric string */
						&& IS_LONG == is_numeric_string(Z_STRVAL_P(offset), Z_STRLEN_P(offset), NULL, NULL, 0))) {
				lval = zval_get_long(offset);
				goto isset_str_offset;
			}
			goto isset_not_found;
		}
	} else {
isset_not_found:
		result = ((opline->extended_value & ZEND_ISSET) == 0);
	}

isset_dim_obj_exit:
	zval_ptr_dtor_nogc(free_op2);

	ZEND_VM_SMART_BRANCH(result, 1);
	ZVAL_BOOL(EX_VAR(opline->result.var), result);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ISSET_ISEMPTY_PROP_OBJ_SPEC_UNUSED_TMPVAR_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op2;
	zval *container;
	int result;
	zval *offset;

	SAVE_OPLINE();
	container = _get_obj_zval_ptr_unused(execute_data);

	if (IS_UNUSED == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");
		zval_ptr_dtor_nogc(EX_VAR(opline->op2.var));
		HANDLE_EXCEPTION();
	}

	offset = _get_zval_ptr_var(opline->op2.var, execute_data, &free_op2);

	if (IS_UNUSED == IS_CONST ||
	    (IS_UNUSED != IS_UNUSED && UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT))) {
		if ((IS_UNUSED & (IS_VAR|IS_CV)) && Z_ISREF_P(container)) {
			container = Z_REFVAL_P(container);
			if (UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT)) {
				goto isset_no_object;
			}
		} else {
			goto isset_no_object;
		}
	}
	if (UNEXPECTED(!Z_OBJ_HT_P(container)->has_property)) {
		zend_error(E_NOTICE, "Trying to check property of non-object");
isset_no_object:
		result = ((opline->extended_value & ZEND_ISSET) == 0);
	} else {
		result =
			((opline->extended_value & ZEND_ISSET) == 0) ^
			Z_OBJ_HT_P(container)->has_property(container, offset, (opline->extended_value & ZEND_ISSET) == 0, (((IS_TMP_VAR|IS_VAR) == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(offset)) : NULL));
	}

	zval_ptr_dtor_nogc(free_op2);

	ZEND_VM_SMART_BRANCH(result, 1);
	ZVAL_BOOL(EX_VAR(opline->result.var), result);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_BW_NOT_SPEC_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE


	SAVE_OPLINE();
	bitwise_not_function(EX_VAR(opline->result.var),
		_get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op1.var));

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_BOOL_NOT_SPEC_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *val;


	val = _get_zval_ptr_cv_undef(execute_data, opline->op1.var);
	if (Z_TYPE_INFO_P(val) == IS_TRUE) {
		ZVAL_FALSE(EX_VAR(opline->result.var));
	} else if (EXPECTED(Z_TYPE_INFO_P(val) <= IS_TRUE)) {
		ZVAL_TRUE(EX_VAR(opline->result.var));
		if (UNEXPECTED(Z_TYPE_INFO_P(val) == IS_UNDEF)) {
			SAVE_OPLINE();
			GET_OP1_UNDEF_CV(val, BP_VAR_R);
			ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
		}
	} else {
		SAVE_OPLINE();
		ZVAL_BOOL(EX_VAR(opline->result.var), !i_zend_is_true(val));

		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_PRE_INC_SPEC_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *var_ptr;

	var_ptr = _get_zval_ptr_cv_undef_BP_VAR_RW(execute_data, opline->op1.var);

	if (IS_CV == IS_VAR && UNEXPECTED(var_ptr == NULL)) {
		SAVE_OPLINE();
		zend_throw_error(NULL, "Cannot increment/decrement overloaded objects nor string offsets");
		HANDLE_EXCEPTION();
	}

	if (EXPECTED(Z_TYPE_P(var_ptr) == IS_LONG)) {
		fast_long_increment_function(var_ptr);
		if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
			ZVAL_COPY_VALUE(EX_VAR(opline->result.var), var_ptr);
		}
		ZEND_VM_NEXT_OPCODE();
	}

	if (IS_CV == IS_VAR && UNEXPECTED(var_ptr == &EG(error_zval))) {
		if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
			ZVAL_NULL(EX_VAR(opline->result.var));
		}
		ZEND_VM_NEXT_OPCODE();
	}

	SAVE_OPLINE();
	if (IS_CV == IS_CV && UNEXPECTED(Z_TYPE_P(var_ptr) == IS_UNDEF)) {
		var_ptr = GET_OP1_UNDEF_CV(var_ptr, BP_VAR_RW);
	}
	ZVAL_DEREF(var_ptr);
	SEPARATE_ZVAL_NOREF(var_ptr);

	increment_function(var_ptr);

	if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
		ZVAL_COPY(EX_VAR(opline->result.var), var_ptr);
	}

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_PRE_DEC_SPEC_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *var_ptr;

	var_ptr = _get_zval_ptr_cv_undef_BP_VAR_RW(execute_data, opline->op1.var);

	if (IS_CV == IS_VAR && UNEXPECTED(var_ptr == NULL)) {
		SAVE_OPLINE();
		zend_throw_error(NULL, "Cannot increment/decrement overloaded objects nor string offsets");
		HANDLE_EXCEPTION();
	}

	if (EXPECTED(Z_TYPE_P(var_ptr) == IS_LONG)) {
		fast_long_decrement_function(var_ptr);
		if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
			ZVAL_COPY_VALUE(EX_VAR(opline->result.var), var_ptr);
		}
		ZEND_VM_NEXT_OPCODE();
	}

	if (IS_CV == IS_VAR && UNEXPECTED(var_ptr == &EG(error_zval))) {
		if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
			ZVAL_NULL(EX_VAR(opline->result.var));
		}
		ZEND_VM_NEXT_OPCODE();
	}

	SAVE_OPLINE();
	if (IS_CV == IS_CV && UNEXPECTED(Z_TYPE_P(var_ptr) == IS_UNDEF)) {
		var_ptr = GET_OP1_UNDEF_CV(var_ptr, BP_VAR_RW);
	}
	ZVAL_DEREF(var_ptr);
	SEPARATE_ZVAL_NOREF(var_ptr);

	decrement_function(var_ptr);

	if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
		ZVAL_COPY(EX_VAR(opline->result.var), var_ptr);
	}

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_POST_INC_SPEC_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *var_ptr;

	var_ptr = _get_zval_ptr_cv_undef_BP_VAR_RW(execute_data, opline->op1.var);

	if (IS_CV == IS_VAR && UNEXPECTED(var_ptr == NULL)) {
		SAVE_OPLINE();
		zend_throw_error(NULL, "Cannot increment/decrement overloaded objects nor string offsets");
		HANDLE_EXCEPTION();
	}

	if (EXPECTED(Z_TYPE_P(var_ptr) == IS_LONG)) {
		ZVAL_COPY_VALUE(EX_VAR(opline->result.var), var_ptr);
		fast_long_increment_function(var_ptr);
		ZEND_VM_NEXT_OPCODE();
	}

	if (IS_CV == IS_VAR && UNEXPECTED(var_ptr == &EG(error_zval))) {
		ZVAL_NULL(EX_VAR(opline->result.var));
		ZEND_VM_NEXT_OPCODE();
	}

	SAVE_OPLINE();
	if (IS_CV == IS_CV && UNEXPECTED(Z_TYPE_P(var_ptr) == IS_UNDEF)) {
		var_ptr = GET_OP1_UNDEF_CV(var_ptr, BP_VAR_RW);
	}
	ZVAL_DEREF(var_ptr);
	ZVAL_COPY_VALUE(EX_VAR(opline->result.var), var_ptr);
	zval_opt_copy_ctor(var_ptr);

	increment_function(var_ptr);

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_POST_DEC_SPEC_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *var_ptr;

	var_ptr = _get_zval_ptr_cv_undef_BP_VAR_RW(execute_data, opline->op1.var);

	if (IS_CV == IS_VAR && UNEXPECTED(var_ptr == NULL)) {
		SAVE_OPLINE();
		zend_throw_error(NULL, "Cannot increment/decrement overloaded objects nor string offsets");
		HANDLE_EXCEPTION();
	}

	if (EXPECTED(Z_TYPE_P(var_ptr) == IS_LONG)) {
		ZVAL_COPY_VALUE(EX_VAR(opline->result.var), var_ptr);
		fast_long_decrement_function(var_ptr);
		ZEND_VM_NEXT_OPCODE();
	}

	if (IS_CV == IS_VAR && UNEXPECTED(var_ptr == &EG(error_zval))) {
		ZVAL_NULL(EX_VAR(opline->result.var));
		ZEND_VM_NEXT_OPCODE();
	}

	SAVE_OPLINE();
	if (IS_CV == IS_CV && UNEXPECTED(Z_TYPE_P(var_ptr) == IS_UNDEF)) {
		var_ptr = GET_OP1_UNDEF_CV(var_ptr, BP_VAR_RW);
	}
	ZVAL_DEREF(var_ptr);
	ZVAL_COPY_VALUE(EX_VAR(opline->result.var), var_ptr);
	zval_opt_copy_ctor(var_ptr);

	decrement_function(var_ptr);

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ECHO_SPEC_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *z;

	SAVE_OPLINE();
	z = _get_zval_ptr_cv_undef(execute_data, opline->op1.var);

	if (Z_TYPE_P(z) == IS_STRING) {
		zend_string *str = Z_STR_P(z);

		if (ZSTR_LEN(str) != 0) {
			zend_write(ZSTR_VAL(str), ZSTR_LEN(str));
		}
	} else {
		zend_string *str = _zval_get_string_func(z);

		if (ZSTR_LEN(str) != 0) {
			zend_write(ZSTR_VAL(str), ZSTR_LEN(str));
		} else if (IS_CV == IS_CV && UNEXPECTED(Z_TYPE_P(z) == IS_UNDEF)) {
			GET_OP1_UNDEF_CV(z, BP_VAR_R);
		}
		zend_string_release(str);
	}

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_JMPZ_SPEC_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *val;

	val = _get_zval_ptr_cv_undef(execute_data, opline->op1.var);

	if (Z_TYPE_INFO_P(val) == IS_TRUE) {
		ZEND_VM_SET_NEXT_OPCODE(opline + 1);
		ZEND_VM_CONTINUE();
	} else if (EXPECTED(Z_TYPE_INFO_P(val) <= IS_TRUE)) {
		if (IS_CV == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(val) == IS_UNDEF)) {
			SAVE_OPLINE();
			GET_OP1_UNDEF_CV(val, BP_VAR_R);
			ZEND_VM_JMP(OP_JMP_ADDR(opline, opline->op2));
		} else {
			ZEND_VM_SET_OPCODE(OP_JMP_ADDR(opline, opline->op2));
			ZEND_VM_CONTINUE();
		}
	}

	SAVE_OPLINE();
	if (i_zend_is_true(val)) {
		opline++;
	} else {
		opline = OP_JMP_ADDR(opline, opline->op2);
	}

	if (UNEXPECTED(EG(exception) != NULL)) {
		HANDLE_EXCEPTION();
	}
	ZEND_VM_JMP(opline);
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_JMPNZ_SPEC_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *val;

	val = _get_zval_ptr_cv_undef(execute_data, opline->op1.var);

	if (Z_TYPE_INFO_P(val) == IS_TRUE) {
		ZEND_VM_SET_OPCODE(OP_JMP_ADDR(opline, opline->op2));
		ZEND_VM_CONTINUE();
	} else if (EXPECTED(Z_TYPE_INFO_P(val) <= IS_TRUE)) {
		if (IS_CV == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(val) == IS_UNDEF)) {
			SAVE_OPLINE();
			GET_OP1_UNDEF_CV(val, BP_VAR_R);
			ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
		} else {
			ZEND_VM_NEXT_OPCODE();
		}
	}

	SAVE_OPLINE();
	if (i_zend_is_true(val)) {
		opline = OP_JMP_ADDR(opline, opline->op2);
	} else {
		opline++;
	}

	if (UNEXPECTED(EG(exception) != NULL)) {
		HANDLE_EXCEPTION();
	}
	ZEND_VM_JMP(opline);
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_JMPZNZ_SPEC_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *val;

	val = _get_zval_ptr_cv_undef(execute_data, opline->op1.var);

	if (EXPECTED(Z_TYPE_INFO_P(val) == IS_TRUE)) {
		ZEND_VM_SET_RELATIVE_OPCODE(opline, opline->extended_value);
		ZEND_VM_CONTINUE();
	} else if (EXPECTED(Z_TYPE_INFO_P(val) <= IS_TRUE)) {
		if (IS_CV == IS_CV) {
			if (UNEXPECTED(Z_TYPE_INFO_P(val) == IS_UNDEF)) {
				SAVE_OPLINE();
				GET_OP1_UNDEF_CV(val, BP_VAR_R);
			}
			ZEND_VM_JMP(OP_JMP_ADDR(opline, opline->op2));
		} else {
			ZEND_VM_SET_OPCODE(OP_JMP_ADDR(opline, opline->op2));
			ZEND_VM_CONTINUE();
		}
	}

	SAVE_OPLINE();
	if (i_zend_is_true(val)) {
		opline = ZEND_OFFSET_TO_OPLINE(opline, opline->extended_value);
	} else {
		opline = OP_JMP_ADDR(opline, opline->op2);
	}

	if (UNEXPECTED(EG(exception) != NULL)) {
		HANDLE_EXCEPTION();
	}
	ZEND_VM_JMP(opline);
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_JMPZ_EX_SPEC_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *val;
	int ret;

	val = _get_zval_ptr_cv_undef(execute_data, opline->op1.var);

	if (Z_TYPE_INFO_P(val) == IS_TRUE) {
		ZVAL_TRUE(EX_VAR(opline->result.var));
		ZEND_VM_SET_NEXT_OPCODE(opline + 1);
		ZEND_VM_CONTINUE();
	} else if (EXPECTED(Z_TYPE_INFO_P(val) <= IS_TRUE)) {
		ZVAL_FALSE(EX_VAR(opline->result.var));
		if (IS_CV == IS_CV) {
			if (UNEXPECTED(Z_TYPE_INFO_P(val) == IS_UNDEF)) {
				SAVE_OPLINE();
				GET_OP1_UNDEF_CV(val, BP_VAR_R);
			}
			ZEND_VM_JMP(OP_JMP_ADDR(opline, opline->op2));
		} else {
			ZEND_VM_SET_OPCODE(OP_JMP_ADDR(opline, opline->op2));
			ZEND_VM_CONTINUE();
		}
	}

	SAVE_OPLINE();
	ret = i_zend_is_true(val);

	if (ret) {
		ZVAL_TRUE(EX_VAR(opline->result.var));
		opline++;
	} else {
		ZVAL_FALSE(EX_VAR(opline->result.var));
		opline = OP_JMP_ADDR(opline, opline->op2);
	}
	if (UNEXPECTED(EG(exception) != NULL)) {
		HANDLE_EXCEPTION();
	}
	ZEND_VM_JMP(opline);
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_JMPNZ_EX_SPEC_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *val;
	int ret;

	val = _get_zval_ptr_cv_undef(execute_data, opline->op1.var);

	if (Z_TYPE_INFO_P(val) == IS_TRUE) {
		ZVAL_TRUE(EX_VAR(opline->result.var));
		ZEND_VM_SET_OPCODE(OP_JMP_ADDR(opline, opline->op2));
		ZEND_VM_CONTINUE();
	} else if (EXPECTED(Z_TYPE_INFO_P(val) <= IS_TRUE)) {
		ZVAL_FALSE(EX_VAR(opline->result.var));
		if (IS_CV == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(val) == IS_UNDEF)) {
			SAVE_OPLINE();
			GET_OP1_UNDEF_CV(val, BP_VAR_R);
			ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
		} else {
			ZEND_VM_NEXT_OPCODE();
		}
	}

	SAVE_OPLINE();
	ret = i_zend_is_true(val);

	if (ret) {
		ZVAL_TRUE(EX_VAR(opline->result.var));
		opline = OP_JMP_ADDR(opline, opline->op2);
	} else {
		ZVAL_FALSE(EX_VAR(opline->result.var));
		opline++;
	}
	if (UNEXPECTED(EG(exception) != NULL)) {
		HANDLE_EXCEPTION();
	}
	ZEND_VM_JMP(opline);
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_RETURN_SPEC_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *retval_ptr;
	zend_free_op free_op1;

	retval_ptr = _get_zval_ptr_cv_undef(execute_data, opline->op1.var);
	if (IS_CV == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(retval_ptr) == IS_UNDEF)) {
		SAVE_OPLINE();
		retval_ptr = GET_OP1_UNDEF_CV(retval_ptr, BP_VAR_R);
		if (EX(return_value)) {
			ZVAL_NULL(EX(return_value));
		}
	} else if (!EX(return_value)) {
		if (IS_CV == IS_VAR || IS_CV == IS_TMP_VAR ) {
			if (Z_REFCOUNTED_P(free_op1) && !Z_DELREF_P(free_op1)) {
				SAVE_OPLINE();
				zval_dtor_func_for_ptr(Z_COUNTED_P(free_op1));
			}
		}
	} else {
		if (IS_CV == IS_CONST || IS_CV == IS_TMP_VAR) {
			ZVAL_COPY_VALUE(EX(return_value), retval_ptr);
			if (IS_CV == IS_CONST) {
				if (UNEXPECTED(Z_OPT_COPYABLE_P(EX(return_value)))) {
					zval_copy_ctor_func(EX(return_value));
				}
			}
		} else if (IS_CV == IS_CV) {
			ZVAL_DEREF(retval_ptr);
			ZVAL_COPY(EX(return_value), retval_ptr);
		} else /* if (IS_CV == IS_VAR) */ {
			if (UNEXPECTED(Z_ISREF_P(retval_ptr))) {
				zend_refcounted *ref = Z_COUNTED_P(retval_ptr);

				retval_ptr = Z_REFVAL_P(retval_ptr);
				ZVAL_COPY_VALUE(EX(return_value), retval_ptr);
				if (UNEXPECTED(--GC_REFCOUNT(ref) == 0)) {
					efree_size(ref, sizeof(zend_reference));
				} else if (Z_OPT_REFCOUNTED_P(retval_ptr)) {
					Z_ADDREF_P(retval_ptr);
				}
			} else {
				ZVAL_COPY_VALUE(EX(return_value), retval_ptr);
			}
		}
	}
	ZEND_VM_TAIL_CALL(zend_leave_helper_SPEC(ZEND_OPCODE_HANDLER_ARGS_PASSTHRU));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_RETURN_BY_REF_SPEC_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *retval_ptr;


	SAVE_OPLINE();

	do {
		if (IS_CV == IS_CONST || IS_CV == IS_TMP_VAR ||
		    (IS_CV == IS_VAR && opline->extended_value == ZEND_RETURNS_VALUE)) {
			/* Not supposed to happen, but we'll allow it */
			zend_error(E_NOTICE, "Only variable references should be returned by reference");

			retval_ptr = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op1.var);
			if (!EX(return_value)) {
				if (IS_CV == IS_TMP_VAR) {

				}
			} else {
				ZVAL_COPY_VALUE(EX(return_value), retval_ptr);
				Z_VAR_FLAGS_P(EX(return_value)) = IS_VAR_RET_REF;
				if (IS_CV != IS_TMP_VAR) {
					zval_opt_copy_ctor_no_imm(EX(return_value));
				}
			}
			break;
		}

		retval_ptr = _get_zval_ptr_cv_BP_VAR_W(execute_data, opline->op1.var);

		if (IS_CV == IS_VAR && UNEXPECTED(retval_ptr == NULL)) {
			zend_throw_error(NULL, "Cannot return string offsets by reference");
			HANDLE_EXCEPTION();
		}

		if (IS_CV == IS_VAR) {
			if (retval_ptr == &EG(uninitialized_zval) ||
			    (opline->extended_value == ZEND_RETURNS_FUNCTION &&
			     !(Z_VAR_FLAGS_P(retval_ptr) & IS_VAR_RET_REF))) {
				zend_error(E_NOTICE, "Only variable references should be returned by reference");
				if (EX(return_value)) {
					ZVAL_NEW_REF(EX(return_value), retval_ptr);
					Z_VAR_FLAGS_P(EX(return_value)) = IS_VAR_RET_REF;
					if (Z_REFCOUNTED_P(retval_ptr)) Z_ADDREF_P(retval_ptr);
				}
				break;
			}
		}

		if (EX(return_value)) {
			ZVAL_MAKE_REF(retval_ptr);
			Z_ADDREF_P(retval_ptr);
			ZVAL_REF(EX(return_value), Z_REF_P(retval_ptr));
			Z_VAR_FLAGS_P(EX(return_value)) = IS_VAR_RET_REF;
		}
	} while (0);

	ZEND_VM_TAIL_CALL(zend_leave_helper_SPEC(ZEND_OPCODE_HANDLER_ARGS_PASSTHRU));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_GENERATOR_RETURN_SPEC_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *retval;


	zend_generator *generator = zend_get_running_generator(execute_data);

	SAVE_OPLINE();
	retval = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op1.var);

	/* Copy return value into generator->retval */
	if (IS_CV == IS_CONST || IS_CV == IS_TMP_VAR) {
		ZVAL_COPY_VALUE(&generator->retval, retval);
		if (IS_CV == IS_CONST) {
			if (UNEXPECTED(Z_OPT_COPYABLE(generator->retval))) {
				zval_copy_ctor_func(&generator->retval);
			}
		}
	} else if (IS_CV == IS_CV) {
		ZVAL_DEREF(retval);
		ZVAL_COPY(&generator->retval, retval);
	} else /* if (IS_CV == IS_VAR) */ {
		if (UNEXPECTED(Z_ISREF_P(retval))) {
			zend_refcounted *ref = Z_COUNTED_P(retval);

			retval = Z_REFVAL_P(retval);
			ZVAL_COPY_VALUE(&generator->retval, retval);
			if (UNEXPECTED(--GC_REFCOUNT(ref) == 0)) {
				efree_size(ref, sizeof(zend_reference));
			} else if (Z_OPT_REFCOUNTED_P(retval)) {
				Z_ADDREF_P(retval);
			}
		} else {
			ZVAL_COPY_VALUE(&generator->retval, retval);
		}
	}

	/* Close the generator to free up resources */
	zend_generator_close(generator, 1);

	/* Pass execution back to handling code */
	ZEND_VM_RETURN();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_THROW_SPEC_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *value;


	SAVE_OPLINE();
	value = _get_zval_ptr_cv_undef(execute_data, opline->op1.var);

	do {
		if (IS_CV == IS_CONST || UNEXPECTED(Z_TYPE_P(value) != IS_OBJECT)) {
			if ((IS_CV & (IS_VAR|IS_CV)) && Z_ISREF_P(value)) {
				value = Z_REFVAL_P(value);
				if (EXPECTED(Z_TYPE_P(value) == IS_OBJECT)) {
					break;
				}
			}
			if (IS_CV == IS_CV && UNEXPECTED(Z_TYPE_P(value) == IS_UNDEF)) {
				GET_OP1_UNDEF_CV(value, BP_VAR_R);
			}
			if (UNEXPECTED(EG(exception) != NULL)) {
				HANDLE_EXCEPTION();
			}
			zend_throw_error(NULL, "Can only throw objects");

			HANDLE_EXCEPTION();
		}
	} while (0);

	zend_exception_save();
	if (IS_CV != IS_TMP_VAR) {
		if (Z_REFCOUNTED_P(value)) Z_ADDREF_P(value);
	}

	zend_throw_exception_object(value);
	zend_exception_restore();

	HANDLE_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_SEND_VAR_SPEC_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *varptr, *arg;


	varptr = _get_zval_ptr_cv_undef(execute_data, opline->op1.var);
	if (IS_CV == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(varptr) == IS_UNDEF)) {
		SAVE_OPLINE();
		GET_OP1_UNDEF_CV(varptr, BP_VAR_R);
		arg = ZEND_CALL_VAR(EX(call), opline->result.var);
		ZVAL_NULL(arg);
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}

	arg = ZEND_CALL_VAR(EX(call), opline->result.var);

	if (IS_CV == IS_CV) {
		ZVAL_OPT_DEREF(varptr);
		ZVAL_COPY(arg, varptr);
	} else /* if (IS_CV == IS_VAR) */ {
		if (UNEXPECTED(Z_ISREF_P(varptr))) {
			zend_refcounted *ref = Z_COUNTED_P(varptr);

			varptr = Z_REFVAL_P(varptr);
			ZVAL_COPY_VALUE(arg, varptr);
			if (UNEXPECTED(--GC_REFCOUNT(ref) == 0)) {
				efree_size(ref, sizeof(zend_reference));
			} else if (Z_OPT_REFCOUNTED_P(arg)) {
				Z_ADDREF_P(arg);
			}
		} else {
			ZVAL_COPY_VALUE(arg, varptr);
		}
	}

	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_SEND_REF_SPEC_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *varptr, *arg;

	SAVE_OPLINE();
	varptr = _get_zval_ptr_cv_BP_VAR_W(execute_data, opline->op1.var);

	if (IS_CV == IS_VAR && UNEXPECTED(varptr == NULL)) {
		zend_throw_error(NULL, "Only variables can be passed by reference");
		arg = ZEND_CALL_VAR(EX(call), opline->result.var);
		ZVAL_UNDEF(arg);
		HANDLE_EXCEPTION();
	}

	arg = ZEND_CALL_VAR(EX(call), opline->result.var);
	if (IS_CV == IS_VAR && UNEXPECTED(varptr == &EG(error_zval))) {
		ZVAL_NEW_REF(arg, &EG(uninitialized_zval));
		ZEND_VM_NEXT_OPCODE();
	}

	if (Z_ISREF_P(varptr)) {
		Z_ADDREF_P(varptr);
		ZVAL_COPY_VALUE(arg, varptr);
	} else {
		ZVAL_NEW_REF(arg, varptr);
		Z_ADDREF_P(arg);
		ZVAL_REF(varptr, Z_REF_P(arg));
	}

	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_SEND_VAR_EX_SPEC_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *varptr, *arg;


	if (EXPECTED(opline->op2.num <= MAX_ARG_FLAG_NUM)) {
		if (QUICK_ARG_SHOULD_BE_SENT_BY_REF(EX(call)->func, opline->op2.num)) {
			goto send_var_by_ref;
		}
	} else if (ARG_SHOULD_BE_SENT_BY_REF(EX(call)->func, opline->op2.num)) {
send_var_by_ref:
		ZEND_VM_TAIL_CALL(ZEND_SEND_REF_SPEC_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS_PASSTHRU));
	}

	varptr = _get_zval_ptr_cv_undef(execute_data, opline->op1.var);
	if (IS_CV == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(varptr) == IS_UNDEF)) {
		SAVE_OPLINE();
		GET_OP1_UNDEF_CV(varptr, BP_VAR_R);
		arg = ZEND_CALL_VAR(EX(call), opline->result.var);
		ZVAL_NULL(arg);
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}

	arg = ZEND_CALL_VAR(EX(call), opline->result.var);

	if (IS_CV == IS_CV) {
		ZVAL_OPT_DEREF(varptr);
		ZVAL_COPY(arg, varptr);
	} else /* if (IS_CV == IS_VAR) */ {
		if (UNEXPECTED(Z_ISREF_P(varptr))) {
			zend_refcounted *ref = Z_COUNTED_P(varptr);

			varptr = Z_REFVAL_P(varptr);
			ZVAL_COPY_VALUE(arg, varptr);
			if (UNEXPECTED(--GC_REFCOUNT(ref) == 0)) {
				efree_size(ref, sizeof(zend_reference));
			} else if (Z_OPT_REFCOUNTED_P(arg)) {
				Z_ADDREF_P(arg);
			}
		} else {
			ZVAL_COPY_VALUE(arg, varptr);
		}
	}

	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_SEND_USER_SPEC_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *arg, *param;


	SAVE_OPLINE();
	arg = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op1.var);
	param = ZEND_CALL_VAR(EX(call), opline->result.var);

	if (ARG_SHOULD_BE_SENT_BY_REF(EX(call)->func, opline->op2.num)) {
		if (UNEXPECTED(!Z_ISREF_P(arg))) {

			if (!ARG_MAY_BE_SENT_BY_REF(EX(call)->func, opline->op2.num)) {

				zend_error(E_WARNING, "Parameter %d to %s%s%s() expected to be a reference, value given",
					opline->op2.num,
					EX(call)->func->common.scope ? ZSTR_VAL(EX(call)->func->common.scope->name) : "",
					EX(call)->func->common.scope ? "::" : "",
					ZSTR_VAL(EX(call)->func->common.function_name));

				if (ZEND_CALL_INFO(EX(call)) & ZEND_CALL_CLOSURE) {
					OBJ_RELEASE((zend_object*)EX(call)->func->common.prototype);
				}
				if (Z_OBJ(EX(call)->This)) {
					OBJ_RELEASE(Z_OBJ(EX(call)->This));
				}
				ZVAL_UNDEF(param);
				EX(call)->func = (zend_function*)&zend_pass_function;
				EX(call)->called_scope = NULL;
				Z_OBJ(EX(call)->This) = NULL;

				ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
			}

			ZVAL_NEW_REF(arg, arg);
		}
		Z_ADDREF_P(arg);
	} else {
		if (Z_ISREF_P(arg) &&
		    !(EX(call)->func->common.fn_flags & ZEND_ACC_CALL_VIA_TRAMPOLINE)) {
			/* don't separate references for __call */
			arg = Z_REFVAL_P(arg);
		}
		if (Z_OPT_REFCOUNTED_P(arg)) {
			Z_ADDREF_P(arg);
		}
	}
	ZVAL_COPY_VALUE(param, arg);

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_BOOL_SPEC_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *val;


	val = _get_zval_ptr_cv_undef(execute_data, opline->op1.var);
	if (Z_TYPE_INFO_P(val) == IS_TRUE) {
		ZVAL_TRUE(EX_VAR(opline->result.var));
	} else if (EXPECTED(Z_TYPE_INFO_P(val) <= IS_TRUE)) {
		ZVAL_FALSE(EX_VAR(opline->result.var));
		if (UNEXPECTED(Z_TYPE_INFO_P(val) == IS_UNDEF)) {
			SAVE_OPLINE();
			GET_OP1_UNDEF_CV(val, BP_VAR_R);
			ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
		}
	} else {
		SAVE_OPLINE();
		ZVAL_BOOL(EX_VAR(opline->result.var), i_zend_is_true(val));

		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_CLONE_SPEC_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *obj;
	zend_class_entry *ce;
	zend_function *clone;
	zend_object_clone_obj_t clone_call;

	SAVE_OPLINE();
	obj = _get_zval_ptr_cv_undef(execute_data, opline->op1.var);

	if (IS_CV == IS_UNUSED && UNEXPECTED(Z_OBJ_P(obj) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");
		HANDLE_EXCEPTION();
	}

	do {
		if (IS_CV == IS_CONST ||
		    (IS_CV != IS_UNUSED && UNEXPECTED(Z_TYPE_P(obj) != IS_OBJECT))) {
		    if ((IS_CV & (IS_VAR|IS_CV)) && Z_ISREF_P(obj)) {
		    	obj = Z_REFVAL_P(obj);
		    	if (EXPECTED(Z_TYPE_P(obj) == IS_OBJECT)) {
		    		break;
				}
			}
			if (IS_CV == IS_CV && UNEXPECTED(Z_TYPE_P(obj) == IS_UNDEF)) {
				GET_OP1_UNDEF_CV(obj, BP_VAR_R);
			}
			if (UNEXPECTED(EG(exception) != NULL)) {
				HANDLE_EXCEPTION();
			}
			zend_throw_error(NULL, "__clone method called on non-object");

			HANDLE_EXCEPTION();
		}
	} while (0);

	ce = Z_OBJCE_P(obj);
	clone = ce ? ce->clone : NULL;
	clone_call =  Z_OBJ_HT_P(obj)->clone_obj;
	if (UNEXPECTED(clone_call == NULL)) {
		if (ce) {
			zend_throw_error(NULL, "Trying to clone an uncloneable object of class %s", ZSTR_VAL(ce->name));
		} else {
			zend_throw_error(NULL, "Trying to clone an uncloneable object");
		}

		HANDLE_EXCEPTION();
	}

	if (ce && clone) {
		if (clone->op_array.fn_flags & ZEND_ACC_PRIVATE) {
			/* Ensure that if we're calling a private function, we're allowed to do so.
			 */
			if (UNEXPECTED(ce != EG(scope))) {
				zend_throw_error(NULL, "Call to private %s::__clone() from context '%s'", ZSTR_VAL(ce->name), EG(scope) ? ZSTR_VAL(EG(scope)->name) : "");

				HANDLE_EXCEPTION();
			}
		} else if ((clone->common.fn_flags & ZEND_ACC_PROTECTED)) {
			/* Ensure that if we're calling a protected function, we're allowed to do so.
			 */
			if (UNEXPECTED(!zend_check_protected(zend_get_function_root_class(clone), EG(scope)))) {
				zend_throw_error(NULL, "Call to protected %s::__clone() from context '%s'", ZSTR_VAL(ce->name), EG(scope) ? ZSTR_VAL(EG(scope)->name) : "");

				HANDLE_EXCEPTION();
			}
		}
	}

	if (EXPECTED(EG(exception) == NULL)) {
		ZVAL_OBJ(EX_VAR(opline->result.var), clone_call(obj));
		if (UNEXPECTED(!RETURN_VALUE_USED(opline)) || UNEXPECTED(EG(exception) != NULL)) {
			OBJ_RELEASE(Z_OBJ_P(EX_VAR(opline->result.var)));
		}
	}

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_CAST_SPEC_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *expr;
	zval *result = EX_VAR(opline->result.var);

	SAVE_OPLINE();
	expr = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op1.var);

	switch (opline->extended_value) {
		case IS_NULL:
			/* This code is taken from convert_to_null. However, it does not seems very useful,
			 * because a conversion to null always results in the same value. This could only
			 * be relevant if a cast_object handler for IS_NULL has some kind of side-effect. */
#if 0
			if (IS_CV == IS_VAR || IS_CV == IS_CV) {
				ZVAL_DEREF(expr);
			}
			if (Z_TYPE_P(expr) == IS_OBJECT && Z_OBJ_HT_P(expr)->cast_object) {
				if (Z_OBJ_HT_P(expr)->cast_object(expr, result, IS_NULL) == SUCCESS) {
					break;
				}
			}
#endif

			ZVAL_NULL(result);
			break;
		case _IS_BOOL:
			ZVAL_BOOL(result, zend_is_true(expr));
			break;
		case IS_LONG:
			ZVAL_LONG(result, zval_get_long(expr));
			break;
		case IS_DOUBLE:
			ZVAL_DOUBLE(result, zval_get_double(expr));
			break;
		case IS_STRING:
			ZVAL_STR(result, zval_get_string(expr));
			break;
		default:
			if (IS_CV & (IS_VAR|IS_CV)) {
				ZVAL_DEREF(expr);
			}
			/* If value is already of correct type, return it directly */
			if (Z_TYPE_P(expr) == opline->extended_value) {
				ZVAL_COPY_VALUE(result, expr);
				if (IS_CV == IS_CONST) {
					if (UNEXPECTED(Z_OPT_COPYABLE_P(result))) {
						zval_copy_ctor_func(result);
					}
				} else if (IS_CV != IS_TMP_VAR) {
					if (Z_OPT_REFCOUNTED_P(expr)) Z_ADDREF_P(expr);
				}

				ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
			}

			if (opline->extended_value == IS_ARRAY) {
				if (Z_TYPE_P(expr) != IS_OBJECT) {
					ZVAL_NEW_ARR(result);
					zend_hash_init(Z_ARRVAL_P(result), 8, NULL, ZVAL_PTR_DTOR, 0);
					if (Z_TYPE_P(expr) != IS_NULL) {
						expr = zend_hash_index_add_new(Z_ARRVAL_P(result), 0, expr);
						if (IS_CV == IS_CONST) {
							if (UNEXPECTED(Z_OPT_COPYABLE_P(expr))) {
								zval_copy_ctor_func(expr);
							}
						} else {
							if (Z_OPT_REFCOUNTED_P(expr)) Z_ADDREF_P(expr);
						}
					}
				} else {
					ZVAL_COPY_VALUE(result, expr);
					Z_ADDREF_P(result);
					convert_to_array(result);
				}
			} else {
				if (Z_TYPE_P(expr) != IS_ARRAY) {
					object_init(result);
					if (Z_TYPE_P(expr) != IS_NULL) {
						expr = zend_hash_str_add_new(Z_OBJPROP_P(result), "scalar", sizeof("scalar")-1, expr);
						if (IS_CV == IS_CONST) {
							if (UNEXPECTED(Z_OPT_COPYABLE_P(expr))) {
								zval_copy_ctor_func(expr);
							}
						} else {
							if (Z_OPT_REFCOUNTED_P(expr)) Z_ADDREF_P(expr);
						}
					}
				} else {
					ZVAL_COPY(result, expr);
					convert_to_object(result);
				}
			}
	}

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_INCLUDE_OR_EVAL_SPEC_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_op_array *new_op_array=NULL;

	zval *inc_filename;
	zval tmp_inc_filename;
	zend_bool failure_retval=0;

	SAVE_OPLINE();
	inc_filename = _get_zval_ptr_cv_undef(execute_data, opline->op1.var);

	ZVAL_UNDEF(&tmp_inc_filename);
	if (Z_TYPE_P(inc_filename) != IS_STRING) {
		if (IS_CV == IS_CV && UNEXPECTED(Z_TYPE_P(inc_filename) == IS_UNDEF)) {
			inc_filename = GET_OP1_UNDEF_CV(inc_filename, BP_VAR_R);
		}
		ZVAL_STR(&tmp_inc_filename, zval_get_string(inc_filename));
		inc_filename = &tmp_inc_filename;
	}

	if (opline->extended_value != ZEND_EVAL && strlen(Z_STRVAL_P(inc_filename)) != Z_STRLEN_P(inc_filename)) {
		if (opline->extended_value == ZEND_INCLUDE_ONCE || opline->extended_value == ZEND_INCLUDE) {
			zend_message_dispatcher(ZMSG_FAILED_INCLUDE_FOPEN, Z_STRVAL_P(inc_filename));
		} else {
			zend_message_dispatcher(ZMSG_FAILED_REQUIRE_FOPEN, Z_STRVAL_P(inc_filename));
		}
	} else {
		switch (opline->extended_value) {
			case ZEND_INCLUDE_ONCE:
			case ZEND_REQUIRE_ONCE: {
					zend_file_handle file_handle;
					zend_string *resolved_path;

					resolved_path = zend_resolve_path(Z_STRVAL_P(inc_filename), (int)Z_STRLEN_P(inc_filename));
					if (resolved_path) {
						failure_retval = zend_hash_exists(&EG(included_files), resolved_path);
					} else {
						resolved_path = zend_string_copy(Z_STR_P(inc_filename));
					}

					if (failure_retval) {
						/* do nothing, file already included */
					} else if (SUCCESS == zend_stream_open(ZSTR_VAL(resolved_path), &file_handle)) {

						if (!file_handle.opened_path) {
							file_handle.opened_path = zend_string_copy(resolved_path);
						}

						if (zend_hash_add_empty_element(&EG(included_files), file_handle.opened_path)) {
							new_op_array = zend_compile_file(&file_handle, (opline->extended_value==ZEND_INCLUDE_ONCE?ZEND_INCLUDE:ZEND_REQUIRE));
							zend_destroy_file_handle(&file_handle);
						} else {
							zend_file_handle_dtor(&file_handle);
							failure_retval=1;
						}
					} else {
						if (opline->extended_value == ZEND_INCLUDE_ONCE) {
							zend_message_dispatcher(ZMSG_FAILED_INCLUDE_FOPEN, Z_STRVAL_P(inc_filename));
						} else {
							zend_message_dispatcher(ZMSG_FAILED_REQUIRE_FOPEN, Z_STRVAL_P(inc_filename));
						}
					}
					zend_string_release(resolved_path);
				}
				break;
			case ZEND_INCLUDE:
			case ZEND_REQUIRE:
				new_op_array = compile_filename(opline->extended_value, inc_filename);
				break;
			case ZEND_EVAL: {
					char *eval_desc = zend_make_compiled_string_description("eval()'d code");

					new_op_array = zend_compile_string(inc_filename, eval_desc);
					efree(eval_desc);
				}
				break;
			EMPTY_SWITCH_DEFAULT_CASE()
		}
	}
	if (Z_TYPE(tmp_inc_filename) != IS_UNDEF) {
		zend_string_release(Z_STR(tmp_inc_filename));
	}

	if (UNEXPECTED(EG(exception) != NULL)) {
		HANDLE_EXCEPTION();
	} else if (EXPECTED(new_op_array != NULL)) {
		zval *return_value = NULL;
		zend_execute_data *call;

		if (RETURN_VALUE_USED(opline)) {
			return_value = EX_VAR(opline->result.var);
		}

		new_op_array->scope = EG(scope);

		call = zend_vm_stack_push_call_frame(ZEND_CALL_NESTED_CODE,
			(zend_function*)new_op_array, 0, EX(called_scope), Z_OBJ(EX(This)));

		if (EX(symbol_table)) {
			call->symbol_table = EX(symbol_table);
		} else {
			call->symbol_table = zend_rebuild_symbol_table();
		}

		call->prev_execute_data = execute_data;
	    i_init_code_execute_data(call, new_op_array, return_value);
		if (EXPECTED(zend_execute_ex == execute_ex)) {
			ZEND_VM_ENTER();
		} else {
			ZEND_ADD_CALL_FLAG(call, ZEND_CALL_TOP);
			zend_execute_ex(call);
			zend_vm_stack_free_call_frame(call);
		}

		destroy_op_array(new_op_array);
		efree_size(new_op_array, sizeof(zend_op_array));
		if (UNEXPECTED(EG(exception) != NULL)) {
			zend_throw_exception_internal(NULL);
			HANDLE_EXCEPTION();
		}

	} else if (RETURN_VALUE_USED(opline)) {
		ZVAL_BOOL(EX_VAR(opline->result.var), failure_retval);
	}
	ZEND_VM_INTERRUPT_CHECK();
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FE_RESET_R_SPEC_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *array_ptr, *result;
	HashTable *fe_ht;

	SAVE_OPLINE();

	array_ptr = _get_zval_ptr_cv_deref_BP_VAR_R(execute_data, opline->op1.var);
	if (EXPECTED(Z_TYPE_P(array_ptr) == IS_ARRAY)) {
		result = EX_VAR(opline->result.var);
		ZVAL_COPY_VALUE(result, array_ptr);
		if (IS_CV != IS_TMP_VAR && Z_OPT_REFCOUNTED_P(result)) {
			Z_ADDREF_P(array_ptr);
		}
		Z_FE_POS_P(result) = 0;

		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	} else if (IS_CV != IS_CONST && EXPECTED(Z_TYPE_P(array_ptr) == IS_OBJECT)) {
		if (!Z_OBJCE_P(array_ptr)->get_iterator) {
			HashPosition pos = 0;
			Bucket *p;

			result = EX_VAR(opline->result.var);
			ZVAL_COPY_VALUE(result, array_ptr);
			if (IS_CV != IS_TMP_VAR) {
				Z_ADDREF_P(array_ptr);
			}
			fe_ht = Z_OBJPROP_P(array_ptr);
			pos = 0;
			p = fe_ht->arData;
			while (1) {
				if (UNEXPECTED(pos >= fe_ht->nNumUsed)) {

					Z_FE_ITER_P(EX_VAR(opline->result.var)) = (uint32_t)-1;
					ZEND_VM_JMP(OP_JMP_ADDR(opline, opline->op2));
				}
				if ((EXPECTED(Z_TYPE(p->val) != IS_UNDEF) &&
				     (EXPECTED(Z_TYPE(p->val) != IS_INDIRECT) ||
				      EXPECTED(Z_TYPE_P(Z_INDIRECT(p->val)) != IS_UNDEF))) &&
				    (UNEXPECTED(!p->key) ||
				     EXPECTED(zend_check_property_access(Z_OBJ_P(array_ptr), p->key) == SUCCESS))) {
					break;
				}
				pos++;
				p++;
			}
			Z_FE_ITER_P(EX_VAR(opline->result.var)) = zend_hash_iterator_add(fe_ht, pos);

			ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
		} else {
			zend_class_entry *ce = Z_OBJCE_P(array_ptr);
			zend_object_iterator *iter = ce->get_iterator(ce, array_ptr, 0);
			zend_bool is_empty;

			if (UNEXPECTED(!iter) || UNEXPECTED(EG(exception))) {

				if (!EG(exception)) {
					zend_throw_exception_ex(NULL, 0, "Object of type %s did not create an Iterator", ZSTR_VAL(ce->name));
				}
				zend_throw_exception_internal(NULL);
				HANDLE_EXCEPTION();
			}

			iter->index = 0;
			if (iter->funcs->rewind) {
				iter->funcs->rewind(iter);
				if (UNEXPECTED(EG(exception) != NULL)) {
					OBJ_RELEASE(&iter->std);

					HANDLE_EXCEPTION();
				}
			}

			is_empty = iter->funcs->valid(iter) != SUCCESS;

			if (UNEXPECTED(EG(exception) != NULL)) {
				OBJ_RELEASE(&iter->std);

				HANDLE_EXCEPTION();
			}
			iter->index = -1; /* will be set to 0 before using next handler */

			ZVAL_OBJ(EX_VAR(opline->result.var), &iter->std);
			Z_FE_ITER_P(EX_VAR(opline->result.var)) = (uint32_t)-1;

			if (is_empty) {
				ZEND_VM_JMP(OP_JMP_ADDR(opline, opline->op2));
			} else {
				ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
			}
		}
	} else {
		zend_error(E_WARNING, "Invalid argument supplied for foreach()");
		ZVAL_UNDEF(EX_VAR(opline->result.var));
		Z_FE_ITER_P(EX_VAR(opline->result.var)) = (uint32_t)-1;

		ZEND_VM_JMP(OP_JMP_ADDR(opline, opline->op2));
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FE_RESET_RW_SPEC_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *array_ptr, *array_ref;
	HashTable *fe_ht;
	HashPosition pos = 0;
	Bucket *p;

	SAVE_OPLINE();

	if (IS_CV == IS_VAR || IS_CV == IS_CV) {
		array_ref = array_ptr = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op1.var);
		if (Z_ISREF_P(array_ref)) {
			array_ptr = Z_REFVAL_P(array_ref);
		}
	} else {
		array_ref = array_ptr = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op1.var);
	}

	if (EXPECTED(Z_TYPE_P(array_ptr) == IS_ARRAY)) {
		if (IS_CV == IS_VAR || IS_CV == IS_CV) {
			if (array_ptr == array_ref) {
				ZVAL_NEW_REF(array_ref, array_ref);
				array_ptr = Z_REFVAL_P(array_ref);
			}
			Z_ADDREF_P(array_ref);
			ZVAL_COPY_VALUE(EX_VAR(opline->result.var), array_ref);
		} else {
			array_ptr = EX_VAR(opline->result.var);
			ZVAL_COPY_VALUE(array_ptr, array_ref);
		}
		if (IS_CV == IS_CONST) {
			zval_copy_ctor_func(array_ptr);
		} else {
			SEPARATE_ARRAY(array_ptr);
		}
		fe_ht = Z_ARRVAL_P(array_ptr);
		p = fe_ht->arData;
		while (1) {
			if (UNEXPECTED(pos >= fe_ht->nNumUsed)) {

				Z_FE_ITER_P(EX_VAR(opline->result.var)) = (uint32_t)-1;
				ZEND_VM_JMP(OP_JMP_ADDR(opline, opline->op2));
			}
			if (EXPECTED(Z_TYPE(p->val) != IS_UNDEF) &&
			    (EXPECTED(Z_TYPE(p->val) != IS_INDIRECT) ||
			     EXPECTED(Z_TYPE_P(Z_INDIRECT(p->val)) != IS_UNDEF))) {
				break;
			}
			pos++;
			p++;
		}
		Z_FE_ITER_P(EX_VAR(opline->result.var)) = zend_hash_iterator_add(fe_ht, pos);

		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	} else if (IS_CV != IS_CONST && EXPECTED(Z_TYPE_P(array_ptr) == IS_OBJECT)) {
		if (!Z_OBJCE_P(array_ptr)->get_iterator) {
			if (IS_CV == IS_VAR || IS_CV == IS_CV) {
				if (array_ptr == array_ref) {
					ZVAL_NEW_REF(array_ref, array_ref);
					array_ptr = Z_REFVAL_P(array_ref);
				}
				Z_ADDREF_P(array_ref);
				ZVAL_COPY_VALUE(EX_VAR(opline->result.var), array_ref);
			} else {
				array_ptr = EX_VAR(opline->result.var);
				ZVAL_COPY_VALUE(array_ptr, array_ref);
			}
			fe_ht = Z_OBJPROP_P(array_ptr);
			p = fe_ht->arData;
			while (1) {
				if (UNEXPECTED(pos >= fe_ht->nNumUsed)) {

					Z_FE_ITER_P(EX_VAR(opline->result.var)) = (uint32_t)-1;
					ZEND_VM_JMP(OP_JMP_ADDR(opline, opline->op2));
				}
				if ((EXPECTED(Z_TYPE(p->val) != IS_UNDEF) &&
				     (EXPECTED(Z_TYPE(p->val) != IS_INDIRECT) ||
				      EXPECTED(Z_TYPE_P(Z_INDIRECT(p->val)) != IS_UNDEF))) &&
				    (UNEXPECTED(!p->key) ||
				     EXPECTED(zend_check_property_access(Z_OBJ_P(array_ptr), p->key) == SUCCESS))) {
					break;
				}
				pos++;
				p++;
			}
			Z_FE_ITER_P(EX_VAR(opline->result.var)) = zend_hash_iterator_add(fe_ht, pos);

			ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
		} else {
			zend_class_entry *ce = Z_OBJCE_P(array_ptr);
			zend_object_iterator *iter = ce->get_iterator(ce, array_ptr, 1);
			zend_bool is_empty;

			if (UNEXPECTED(!iter) || UNEXPECTED(EG(exception))) {
				if (IS_CV == IS_VAR) {

				} else {

				}
				if (!EG(exception)) {
					zend_throw_exception_ex(NULL, 0, "Object of type %s did not create an Iterator", ZSTR_VAL(ce->name));
				}
				zend_throw_exception_internal(NULL);
				HANDLE_EXCEPTION();
			}

			iter->index = 0;
			if (iter->funcs->rewind) {
				iter->funcs->rewind(iter);
				if (UNEXPECTED(EG(exception) != NULL)) {
					OBJ_RELEASE(&iter->std);
					if (IS_CV == IS_VAR) {

					} else {

					}
					HANDLE_EXCEPTION();
				}
			}

			is_empty = iter->funcs->valid(iter) != SUCCESS;

			if (UNEXPECTED(EG(exception) != NULL)) {
				OBJ_RELEASE(&iter->std);
				if (IS_CV == IS_VAR) {

				} else {

				}
				HANDLE_EXCEPTION();
			}
			iter->index = -1; /* will be set to 0 before using next handler */

			ZVAL_OBJ(EX_VAR(opline->result.var), &iter->std);
			Z_FE_ITER_P(EX_VAR(opline->result.var)) = (uint32_t)-1;

			if (IS_CV == IS_VAR) {

			} else {

			}
			if (is_empty) {
				ZEND_VM_JMP(OP_JMP_ADDR(opline, opline->op2));
			} else {
				ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
			}
		}
	} else {
		zend_error(E_WARNING, "Invalid argument supplied for foreach()");
		ZVAL_UNDEF(EX_VAR(opline->result.var));
		Z_FE_ITER_P(EX_VAR(opline->result.var)) = (uint32_t)-1;
		if (IS_CV == IS_VAR) {

		} else {

		}
		ZEND_VM_JMP(OP_JMP_ADDR(opline, opline->op2));
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_EXIT_SPEC_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	SAVE_OPLINE();
	if (IS_CV != IS_UNUSED) {

		zval *ptr = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op1.var);

		do {
			if (Z_TYPE_P(ptr) == IS_LONG) {
				EG(exit_status) = Z_LVAL_P(ptr);
			} else {
				if ((IS_CV & (IS_VAR|IS_CV)) && Z_ISREF_P(ptr)) {
					ptr = Z_REFVAL_P(ptr);
					if (Z_TYPE_P(ptr) == IS_LONG) {
						EG(exit_status) = Z_LVAL_P(ptr);
						break;
					}
				}
				zend_print_variable(ptr);
			}
		} while (0);

	}
	zend_bailout();
	ZEND_VM_NEXT_OPCODE(); /* Never reached */
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_JMP_SET_SPEC_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *value;
	zval *ref = NULL;

	SAVE_OPLINE();
	value = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op1.var);

	if ((IS_CV == IS_VAR || IS_CV == IS_CV) && Z_ISREF_P(value)) {
		if (IS_CV == IS_VAR) {
			ref = value;
		}
		value = Z_REFVAL_P(value);
	}
	if (i_zend_is_true(value)) {
		ZVAL_COPY_VALUE(EX_VAR(opline->result.var), value);
		if (IS_CV == IS_CONST) {
			if (UNEXPECTED(Z_OPT_COPYABLE_P(value))) {
				zval_copy_ctor_func(EX_VAR(opline->result.var));
			}
		} else if (IS_CV == IS_CV) {
			if (Z_OPT_REFCOUNTED_P(value)) Z_ADDREF_P(value);
		} else if (IS_CV == IS_VAR && ref) {
			zend_reference *r = Z_REF_P(ref);

			if (Z_OPT_REFCOUNTED_P(value)) Z_ADDREF_P(value);
			if (UNEXPECTED(--GC_REFCOUNT(r) == 0)) {
				efree_size(r, sizeof(zend_reference));
			}
		}
		ZEND_VM_JMP(OP_JMP_ADDR(opline, opline->op2));
	}

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_COALESCE_SPEC_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *value;
	zval *ref = NULL;

	SAVE_OPLINE();
	value = _get_zval_ptr_cv_BP_VAR_IS(execute_data, opline->op1.var);

	if ((IS_CV == IS_VAR || IS_CV == IS_CV) && Z_ISREF_P(value)) {
		if (IS_CV == IS_VAR) {
			ref = value;
		}
		value = Z_REFVAL_P(value);
	}

	if (Z_TYPE_P(value) > IS_NULL) {
		ZVAL_COPY_VALUE(EX_VAR(opline->result.var), value);
		if (IS_CV == IS_CONST) {
			if (UNEXPECTED(Z_OPT_COPYABLE_P(value))) {
				zval_copy_ctor_func(EX_VAR(opline->result.var));
			}
		} else if (IS_CV == IS_CV) {
			if (Z_OPT_REFCOUNTED_P(value)) Z_ADDREF_P(value);
		} else if (IS_CV == IS_VAR && ref) {
			zend_reference *r = Z_REF_P(ref);

			if (Z_OPT_REFCOUNTED_P(value)) Z_ADDREF_P(value);
			if (UNEXPECTED(--GC_REFCOUNT(r) == 0)) {
				efree_size(r, sizeof(zend_reference));
			}
		}
		ZEND_VM_JMP(OP_JMP_ADDR(opline, opline->op2));
	}

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_QM_ASSIGN_SPEC_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *value;

	value = _get_zval_ptr_cv_undef(execute_data, opline->op1.var);
	if (IS_CV == IS_CV && UNEXPECTED(Z_TYPE_P(value) == IS_UNDEF)) {
		SAVE_OPLINE();
		GET_OP1_UNDEF_CV(value, BP_VAR_R);
		ZVAL_NULL(EX_VAR(opline->result.var));
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}

	if ((IS_CV == IS_VAR || IS_CV == IS_CV) && Z_ISREF_P(value)) {
		ZVAL_COPY(EX_VAR(opline->result.var), Z_REFVAL_P(value));
		if (IS_CV == IS_VAR) {
			if (UNEXPECTED(Z_DELREF_P(value) == 0)) {
				efree_size(Z_REF_P(value), sizeof(zend_reference));
			}
		}
	} else {
		ZVAL_COPY_VALUE(EX_VAR(opline->result.var), value);
		if (IS_CV == IS_CONST) {
			if (UNEXPECTED(Z_OPT_COPYABLE_P(value))) {
				zval_copy_ctor_func(EX_VAR(opline->result.var));
			}
		} else if (IS_CV == IS_CV) {
			if (Z_OPT_REFCOUNTED_P(value)) Z_ADDREF_P(value);
		}
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_YIELD_FROM_SPEC_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zend_generator *generator = zend_get_running_generator(execute_data);

	zval *val;


	SAVE_OPLINE();
	val = _get_zval_ptr_cv_deref_BP_VAR_R(execute_data, opline->op1.var);

	if (Z_TYPE_P(val) == IS_ARRAY) {
		ZVAL_COPY_VALUE(&generator->values, val);
		if (IS_CV != IS_TMP_VAR && Z_OPT_REFCOUNTED_P(val)) {
			Z_ADDREF_P(val);
		}
		Z_FE_POS(generator->values) = 0;

	} else if (IS_CV != IS_CONST && Z_TYPE_P(val) == IS_OBJECT && Z_OBJCE_P(val)->get_iterator) {
		zend_class_entry *ce = Z_OBJCE_P(val);
		if (ce == zend_ce_generator) {
			zend_generator *new_gen = (zend_generator *) Z_OBJ_P(val);

			if (IS_CV != IS_TMP_VAR) {
				Z_ADDREF_P(val);
			}

			if (Z_ISUNDEF(new_gen->retval)) {
				if (UNEXPECTED(zend_generator_get_current(new_gen) == generator)) {
					zend_throw_error(NULL, "Impossible to yield from the Generator being currently run");
					HANDLE_EXCEPTION();
				} else {
					zend_generator_yield_from(generator, new_gen);
				}
			} else if (UNEXPECTED(new_gen->execute_data == NULL)) {
				zend_throw_error(NULL, "Generator passed to yield from was aborted without proper return and is unable to continue");
				HANDLE_EXCEPTION();
			} else {
				if (RETURN_VALUE_USED(opline)) {
					ZVAL_COPY(EX_VAR(opline->result.var), &new_gen->retval);
				}
				ZEND_VM_NEXT_OPCODE();
			}
		} else {
			zend_object_iterator *iter = ce->get_iterator(ce, val, 0);

			if (UNEXPECTED(!iter) || UNEXPECTED(EG(exception))) {
				if (!EG(exception)) {
					zend_throw_error(NULL, "Object of type %s did not create an Iterator", ZSTR_VAL(ce->name));
				}
				HANDLE_EXCEPTION();
			}

			iter->index = 0;
			if (iter->funcs->rewind) {
				iter->funcs->rewind(iter);
				if (UNEXPECTED(EG(exception) != NULL)) {
					OBJ_RELEASE(&iter->std);
					HANDLE_EXCEPTION();
				}
			}

			ZVAL_OBJ(&generator->values, &iter->std);
		}
	} else {
		zend_throw_error(NULL, "Can use \"yield from\" only with arrays and Traversables", 0);
		HANDLE_EXCEPTION();
	}

	/* This is the default return value
	 * when the expression is a Generator, it will be overwritten in zend_generator_resume() */
	if (RETURN_VALUE_USED(opline)) {
		ZVAL_NULL(EX_VAR(opline->result.var));
	}

	/* We increment to the next op, so we are at the correct position when the
	 * generator is resumed. */
	ZEND_VM_INC_OPCODE();

	/* The GOTO VM uses a local opline variable. We need to set the opline
	 * variable in execute_data so we don't resume at an old position. */
	SAVE_OPLINE();

	ZEND_VM_RETURN();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_STRLEN_SPEC_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *value;


	SAVE_OPLINE();
	value = _get_zval_ptr_cv_undef(execute_data, opline->op1.var);
try_strlen:
	if (EXPECTED(Z_TYPE_P(value) == IS_STRING)) {
		ZVAL_LONG(EX_VAR(opline->result.var), Z_STRLEN_P(value));
	} else {
		zend_bool strict;

		if (IS_CV == IS_CV && UNEXPECTED(Z_TYPE_P(value) == IS_UNDEF)) {
			value = GET_OP1_UNDEF_CV(value, BP_VAR_R);
		}
		if ((IS_CV & (IS_VAR|IS_CV)) && Z_TYPE_P(value) == IS_REFERENCE) {
			value = Z_REFVAL_P(value);
			goto try_strlen;
		}
		strict = EX_USES_STRICT_TYPES();
		do {
			if (EXPECTED(!strict)) {
				zend_string *str;
				zval tmp;

				ZVAL_COPY(&tmp, value);
				if (zend_parse_arg_str_weak(&tmp, &str)) {
					ZVAL_LONG(EX_VAR(opline->result.var), ZSTR_LEN(str));
					zval_ptr_dtor(&tmp);
					break;
				}
				zval_ptr_dtor(&tmp);
			}
			zend_internal_type_error(strict, "strlen() expects parameter 1 to be string, %s given", zend_get_type_by_const(Z_TYPE_P(value)));
			ZVAL_NULL(EX_VAR(opline->result.var));
		} while (0);
	}

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_TYPE_CHECK_SPEC_CV_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *value;
	int result = 0;


	SAVE_OPLINE();
	value = _get_zval_ptr_cv_deref_BP_VAR_R(execute_data, opline->op1.var);
	if (EXPECTED(Z_TYPE_P(value) == opline->extended_value)) {
		if (IS_CV != IS_CONST && UNEXPECTED(Z_TYPE_P(value) == IS_OBJECT)) {
			zend_class_entry *ce = Z_OBJCE_P(value);

			if (UNEXPECTED(ZSTR_LEN(ce->name) != sizeof("__PHP_Incomplete_Class") - 1) ||
			    EXPECTED(memcmp(ZSTR_VAL(ce->name), "__PHP_Incomplete_Class", sizeof("__PHP_Incomplete_Class") - 1) != 0)) {
				result = 1;
			}
		} else if (UNEXPECTED(Z_TYPE_P(value) == IS_RESOURCE)) {
			const char *type_name = zend_rsrc_list_get_rsrc_type(Z_RES_P(value));

			if (EXPECTED(type_name != NULL)) {
				result = 1;
			}
		} else {
			result = 1;
		}
	} else if (UNEXPECTED(opline->extended_value == _IS_BOOL) &&
			   EXPECTED(Z_TYPE_P(value) == IS_TRUE || Z_TYPE_P(value) == IS_FALSE)) {
		result = 1;
	}

	ZEND_VM_SMART_BRANCH(result, 1);
	ZVAL_BOOL(EX_VAR(opline->result.var), result);
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ADD_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2, *result;

	op1 = _get_zval_ptr_cv_undef(execute_data, opline->op1.var);
	op2 = EX_CONSTANT(opline->op2);
	if (EXPECTED(Z_TYPE_INFO_P(op1) == IS_LONG)) {
		if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_LONG)) {
			result = EX_VAR(opline->result.var);
			fast_long_add_function(result, op1, op2);
			ZEND_VM_NEXT_OPCODE();
		} else if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_DOUBLE)) {
			result = EX_VAR(opline->result.var);
			ZVAL_DOUBLE(result, ((double)Z_LVAL_P(op1)) + Z_DVAL_P(op2));
			ZEND_VM_NEXT_OPCODE();
		}
	} else if (EXPECTED(Z_TYPE_INFO_P(op1) == IS_DOUBLE)) {
		if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_DOUBLE)) {
			result = EX_VAR(opline->result.var);
			ZVAL_DOUBLE(result, Z_DVAL_P(op1) + Z_DVAL_P(op2));
			ZEND_VM_NEXT_OPCODE();
		} else if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_LONG)) {
			result = EX_VAR(opline->result.var);
			ZVAL_DOUBLE(result, Z_DVAL_P(op1) + ((double)Z_LVAL_P(op2)));
			ZEND_VM_NEXT_OPCODE();
		}
	}

	SAVE_OPLINE();
	if (IS_CV == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(op1) == IS_UNDEF)) {
		op1 = GET_OP1_UNDEF_CV(op1, BP_VAR_R);
	}
	if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(op2) == IS_UNDEF)) {
		op2 = GET_OP2_UNDEF_CV(op2, BP_VAR_R);
	}
	add_function(EX_VAR(opline->result.var), op1, op2);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_SUB_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2, *result;

	op1 = _get_zval_ptr_cv_undef(execute_data, opline->op1.var);
	op2 = EX_CONSTANT(opline->op2);
	if (EXPECTED(Z_TYPE_INFO_P(op1) == IS_LONG)) {
		if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_LONG)) {
			result = EX_VAR(opline->result.var);
			fast_long_sub_function(result, op1, op2);
			ZEND_VM_NEXT_OPCODE();
		} else if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_DOUBLE)) {
			result = EX_VAR(opline->result.var);
			ZVAL_DOUBLE(result, ((double)Z_LVAL_P(op1)) - Z_DVAL_P(op2));
			ZEND_VM_NEXT_OPCODE();
		}
	} else if (EXPECTED(Z_TYPE_INFO_P(op1) == IS_DOUBLE)) {
		if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_DOUBLE)) {
			result = EX_VAR(opline->result.var);
			ZVAL_DOUBLE(result, Z_DVAL_P(op1) - Z_DVAL_P(op2));
			ZEND_VM_NEXT_OPCODE();
		} else if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_LONG)) {
			result = EX_VAR(opline->result.var);
			ZVAL_DOUBLE(result, Z_DVAL_P(op1) - ((double)Z_LVAL_P(op2)));
			ZEND_VM_NEXT_OPCODE();
		}
	}

	SAVE_OPLINE();
	if (IS_CV == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(op1) == IS_UNDEF)) {
		op1 = GET_OP1_UNDEF_CV(op1, BP_VAR_R);
	}
	if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(op2) == IS_UNDEF)) {
		op2 = GET_OP2_UNDEF_CV(op2, BP_VAR_R);
	}
	sub_function(EX_VAR(opline->result.var), op1, op2);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_MUL_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2, *result;

	op1 = _get_zval_ptr_cv_undef(execute_data, opline->op1.var);
	op2 = EX_CONSTANT(opline->op2);
	if (EXPECTED(Z_TYPE_INFO_P(op1) == IS_LONG)) {
		if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_LONG)) {
			zend_long overflow;

			result = EX_VAR(opline->result.var);
			ZEND_SIGNED_MULTIPLY_LONG(Z_LVAL_P(op1), Z_LVAL_P(op2), Z_LVAL_P(result), Z_DVAL_P(result), overflow);
			Z_TYPE_INFO_P(result) = overflow ? IS_DOUBLE : IS_LONG;
			ZEND_VM_NEXT_OPCODE();
		} else if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_DOUBLE)) {
			result = EX_VAR(opline->result.var);
			ZVAL_DOUBLE(result, ((double)Z_LVAL_P(op1)) * Z_DVAL_P(op2));
			ZEND_VM_NEXT_OPCODE();
		}
	} else if (EXPECTED(Z_TYPE_INFO_P(op1) == IS_DOUBLE)) {
		if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_DOUBLE)) {
			result = EX_VAR(opline->result.var);
			ZVAL_DOUBLE(result, Z_DVAL_P(op1) * Z_DVAL_P(op2));
			ZEND_VM_NEXT_OPCODE();
		} else if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_LONG)) {
			result = EX_VAR(opline->result.var);
			ZVAL_DOUBLE(result, Z_DVAL_P(op1) * ((double)Z_LVAL_P(op2)));
			ZEND_VM_NEXT_OPCODE();
		}
	}

	SAVE_OPLINE();
	if (IS_CV == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(op1) == IS_UNDEF)) {
		op1 = GET_OP1_UNDEF_CV(op1, BP_VAR_R);
	}
	if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(op2) == IS_UNDEF)) {
		op2 = GET_OP2_UNDEF_CV(op2, BP_VAR_R);
	}
	mul_function(EX_VAR(opline->result.var), op1, op2);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_DIV_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2;

	SAVE_OPLINE();
	op1 = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op1.var);
	op2 = EX_CONSTANT(opline->op2);
	fast_div_function(EX_VAR(opline->result.var), op1, op2);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_MOD_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2, *result;

	op1 = _get_zval_ptr_cv_undef(execute_data, opline->op1.var);
	op2 = EX_CONSTANT(opline->op2);
	if (EXPECTED(Z_TYPE_INFO_P(op1) == IS_LONG)) {
		if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_LONG)) {
			result = EX_VAR(opline->result.var);
			if (UNEXPECTED(Z_LVAL_P(op2) == 0)) {
				SAVE_OPLINE();
				zend_throw_exception_ex(zend_ce_division_by_zero_error, 0, "Modulo by zero");
				HANDLE_EXCEPTION();
			} else if (UNEXPECTED(Z_LVAL_P(op2) == -1)) {
				/* Prevent overflow error/crash if op1==ZEND_LONG_MIN */
				ZVAL_LONG(result, 0);
			} else {
				ZVAL_LONG(result, Z_LVAL_P(op1) % Z_LVAL_P(op2));
			}
			ZEND_VM_NEXT_OPCODE();
		}
	}

	SAVE_OPLINE();
	if (IS_CV == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(op1) == IS_UNDEF)) {
		op1 = GET_OP1_UNDEF_CV(op1, BP_VAR_R);
	}
	if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(op2) == IS_UNDEF)) {
		op2 = GET_OP2_UNDEF_CV(op2, BP_VAR_R);
	}
	mod_function(EX_VAR(opline->result.var), op1, op2);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_SL_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2;

	SAVE_OPLINE();
	op1 = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op1.var);
	op2 = EX_CONSTANT(opline->op2);
	shift_left_function(EX_VAR(opline->result.var), op1, op2);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_SR_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2;

	SAVE_OPLINE();
	op1 = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op1.var);
	op2 = EX_CONSTANT(opline->op2);
	shift_right_function(EX_VAR(opline->result.var), op1, op2);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_CONCAT_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2;

	SAVE_OPLINE();
	op1 = _get_zval_ptr_cv_undef(execute_data, opline->op1.var);
	op2 = EX_CONSTANT(opline->op2);

	do {
		if ((IS_CV == IS_CONST || EXPECTED(Z_TYPE_P(op1) == IS_STRING)) &&
		    (IS_CONST == IS_CONST || EXPECTED(Z_TYPE_P(op2) == IS_STRING))) {
			zend_string *op1_str = Z_STR_P(op1);
			zend_string *op2_str = Z_STR_P(op2);
			zend_string *str;

			if (IS_CV != IS_CONST) {
				if (UNEXPECTED(ZSTR_LEN(op1_str) == 0)) {
					ZVAL_STR_COPY(EX_VAR(opline->result.var), op2_str);

					break;
				}
			}
			if (IS_CONST != IS_CONST) {
				if (UNEXPECTED(ZSTR_LEN(op2_str) == 0)) {
					ZVAL_STR_COPY(EX_VAR(opline->result.var), op1_str);

					break;
				}
			}
			if (IS_CV != IS_CONST && IS_CV != IS_CV &&
			    !ZSTR_IS_INTERNED(op1_str) && GC_REFCOUNT(op1_str) == 1) {
			    size_t len = ZSTR_LEN(op1_str);

				str = zend_string_realloc(op1_str, len + ZSTR_LEN(op2_str), 0);
				memcpy(ZSTR_VAL(str) + len, ZSTR_VAL(op2_str), ZSTR_LEN(op2_str)+1);
				ZVAL_NEW_STR(EX_VAR(opline->result.var), str);
				break;
			} else {
				str = zend_string_alloc(ZSTR_LEN(op1_str) + ZSTR_LEN(op2_str), 0);
				memcpy(ZSTR_VAL(str), ZSTR_VAL(op1_str), ZSTR_LEN(op1_str));
				memcpy(ZSTR_VAL(str) + ZSTR_LEN(op1_str), ZSTR_VAL(op2_str), ZSTR_LEN(op2_str)+1);
				ZVAL_NEW_STR(EX_VAR(opline->result.var), str);
			}
		} else {
			if (IS_CV == IS_CV && UNEXPECTED(Z_TYPE_P(op1) == IS_UNDEF)) {
				op1 = GET_OP1_UNDEF_CV(op1, BP_VAR_R);
			}
			if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(op2) == IS_UNDEF)) {
				op2 = GET_OP2_UNDEF_CV(op2, BP_VAR_R);
			}
			concat_function(EX_VAR(opline->result.var), op1, op2);
		}

	} while (0);

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_IS_IDENTICAL_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2;
	int result;

	SAVE_OPLINE();
	op1 = _get_zval_ptr_cv_deref_BP_VAR_R(execute_data, opline->op1.var);
	op2 = EX_CONSTANT(opline->op2);
	result = fast_is_identical_function(op1, op2);


	ZEND_VM_SMART_BRANCH(result, (IS_CV|IS_CONST) & (IS_VAR|IS_TMP_VAR));
	ZVAL_BOOL(EX_VAR(opline->result.var), result);
	if ((IS_CV|IS_CONST) & (IS_VAR|IS_TMP_VAR)) {
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_IS_NOT_IDENTICAL_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2;
	int result;

	SAVE_OPLINE();
	op1 = _get_zval_ptr_cv_deref_BP_VAR_R(execute_data, opline->op1.var);
	op2 = EX_CONSTANT(opline->op2);
	result = fast_is_not_identical_function(op1, op2);


	ZEND_VM_SMART_BRANCH(result, (IS_CV|IS_CONST) & (IS_VAR|IS_TMP_VAR));
	ZVAL_BOOL(EX_VAR(opline->result.var), result);
	if ((IS_CV|IS_CONST) & (IS_VAR|IS_TMP_VAR)) {
		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	}
	ZEND_VM_NEXT_OPCODE();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_IS_EQUAL_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2, *result;

	op1 = _get_zval_ptr_cv_undef(execute_data, opline->op1.var);
	op2 = EX_CONSTANT(opline->op2);
	do {
		int result;

		if (EXPECTED(Z_TYPE_P(op1) == IS_LONG)) {
			if (EXPECTED(Z_TYPE_P(op2) == IS_LONG)) {
				result = (Z_LVAL_P(op1) == Z_LVAL_P(op2));
			} else if (EXPECTED(Z_TYPE_P(op2) == IS_DOUBLE)) {
				result = ((double)Z_LVAL_P(op1) == Z_DVAL_P(op2));
			} else {
				break;
			}
		} else if (EXPECTED(Z_TYPE_P(op1) == IS_DOUBLE)) {
			if (EXPECTED(Z_TYPE_P(op2) == IS_DOUBLE)) {
				result = (Z_DVAL_P(op1) == Z_DVAL_P(op2));
			} else if (EXPECTED(Z_TYPE_P(op2) == IS_LONG)) {
				result = (Z_DVAL_P(op1) == ((double)Z_LVAL_P(op2)));
			} else {
				break;
			}
		} else if (EXPECTED(Z_TYPE_P(op1) == IS_STRING)) {
			if (EXPECTED(Z_TYPE_P(op2) == IS_STRING)) {
				if (Z_STR_P(op1) == Z_STR_P(op2)) {
					result = 1;
				} else if (Z_STRVAL_P(op1)[0] > '9' || Z_STRVAL_P(op2)[0] > '9') {
					if (Z_STRLEN_P(op1) != Z_STRLEN_P(op2)) {
						result = 0;
					} else {
						result = (memcmp(Z_STRVAL_P(op1), Z_STRVAL_P(op2), Z_STRLEN_P(op1)) == 0);
					}
				} else {
					result = (zendi_smart_strcmp(op1, op2) == 0);
				}


			} else {
				break;
			}
		} else {
			break;
		}
		ZEND_VM_SMART_BRANCH(result, 0);
		ZVAL_BOOL(EX_VAR(opline->result.var), result);
		ZEND_VM_NEXT_OPCODE();
	} while (0);

	SAVE_OPLINE();
	if (IS_CV == IS_CV && UNEXPECTED(Z_TYPE_P(op1) == IS_UNDEF)) {
		op1 = GET_OP1_UNDEF_CV(op1, BP_VAR_R);
	}
	if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(op2) == IS_UNDEF)) {
		op2 = GET_OP2_UNDEF_CV(op2, BP_VAR_R);
	}
	result = EX_VAR(opline->result.var);
	compare_function(result, op1, op2);
	ZVAL_BOOL(result, Z_LVAL_P(result) == 0);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_IS_NOT_EQUAL_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2, *result;

	op1 = _get_zval_ptr_cv_undef(execute_data, opline->op1.var);
	op2 = EX_CONSTANT(opline->op2);
	do {
		int result;

		if (EXPECTED(Z_TYPE_P(op1) == IS_LONG)) {
			if (EXPECTED(Z_TYPE_P(op2) == IS_LONG)) {
				result = (Z_LVAL_P(op1) != Z_LVAL_P(op2));
			} else if (EXPECTED(Z_TYPE_P(op2) == IS_DOUBLE)) {
				result = ((double)Z_LVAL_P(op1) != Z_DVAL_P(op2));
			} else {
				break;
			}
		} else if (EXPECTED(Z_TYPE_P(op1) == IS_DOUBLE)) {
			if (EXPECTED(Z_TYPE_P(op2) == IS_DOUBLE)) {
				result = (Z_DVAL_P(op1) != Z_DVAL_P(op2));
			} else if (EXPECTED(Z_TYPE_P(op2) == IS_LONG)) {
				result = (Z_DVAL_P(op1) != ((double)Z_LVAL_P(op2)));
			} else {
				break;
			}
		} else if (EXPECTED(Z_TYPE_P(op1) == IS_STRING)) {
			if (EXPECTED(Z_TYPE_P(op2) == IS_STRING)) {
				if (Z_STR_P(op1) == Z_STR_P(op2)) {
					result = 0;
				} else if (Z_STRVAL_P(op1)[0] > '9' || Z_STRVAL_P(op2)[0] > '9') {
					if (Z_STRLEN_P(op1) != Z_STRLEN_P(op2)) {
						result = 1;
					} else {
						result = (memcmp(Z_STRVAL_P(op1), Z_STRVAL_P(op2), Z_STRLEN_P(op1)) != 0);
					}
				} else {
					result = (zendi_smart_strcmp(op1, op2) != 0);
				}


			} else {
				break;
			}
		} else {
			break;
		}
		ZEND_VM_SMART_BRANCH(result, 0);
		ZVAL_BOOL(EX_VAR(opline->result.var), result);
		ZEND_VM_NEXT_OPCODE();
	} while (0);

	SAVE_OPLINE();
	if (IS_CV == IS_CV && UNEXPECTED(Z_TYPE_P(op1) == IS_UNDEF)) {
		op1 = GET_OP1_UNDEF_CV(op1, BP_VAR_R);
	}
	if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(op2) == IS_UNDEF)) {
		op2 = GET_OP2_UNDEF_CV(op2, BP_VAR_R);
	}
	result = EX_VAR(opline->result.var);
	compare_function(result, op1, op2);
	ZVAL_BOOL(result, Z_LVAL_P(result) != 0);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_IS_SMALLER_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2, *result;

	op1 = _get_zval_ptr_cv_undef(execute_data, opline->op1.var);
	op2 = EX_CONSTANT(opline->op2);
	do {
		int result;

		if (EXPECTED(Z_TYPE_INFO_P(op1) == IS_LONG)) {
			if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_LONG)) {
				result = (Z_LVAL_P(op1) < Z_LVAL_P(op2));
			} else if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_DOUBLE)) {
				result = ((double)Z_LVAL_P(op1) < Z_DVAL_P(op2));
			} else {
				break;
			}
		} else if (EXPECTED(Z_TYPE_INFO_P(op1) == IS_DOUBLE)) {
			if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_DOUBLE)) {
				result = (Z_DVAL_P(op1) < Z_DVAL_P(op2));
			} else if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_LONG)) {
				result = (Z_DVAL_P(op1) < ((double)Z_LVAL_P(op2)));
			} else {
				break;
			}
		} else {
			break;
		}
		ZEND_VM_SMART_BRANCH(result, 0);
		ZVAL_BOOL(EX_VAR(opline->result.var), result);
		ZEND_VM_NEXT_OPCODE();
	} while (0);

	SAVE_OPLINE();
	if (IS_CV == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(op1) == IS_UNDEF)) {
		op1 = GET_OP1_UNDEF_CV(op1, BP_VAR_R);
	}
	if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(op2) == IS_UNDEF)) {
		op2 = GET_OP2_UNDEF_CV(op2, BP_VAR_R);
	}
	result = EX_VAR(opline->result.var);
	compare_function(result, op1, op2);
	ZVAL_BOOL(result, Z_LVAL_P(result) < 0);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_IS_SMALLER_OR_EQUAL_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2, *result;

	op1 = _get_zval_ptr_cv_undef(execute_data, opline->op1.var);
	op2 = EX_CONSTANT(opline->op2);
	do {
		int result;

		if (EXPECTED(Z_TYPE_INFO_P(op1) == IS_LONG)) {
			if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_LONG)) {
				result = (Z_LVAL_P(op1) <= Z_LVAL_P(op2));
			} else if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_DOUBLE)) {
				result = ((double)Z_LVAL_P(op1) <= Z_DVAL_P(op2));
			} else {
				break;
			}
		} else if (EXPECTED(Z_TYPE_INFO_P(op1) == IS_DOUBLE)) {
			if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_DOUBLE)) {
				result = (Z_DVAL_P(op1) <= Z_DVAL_P(op2));
			} else if (EXPECTED(Z_TYPE_INFO_P(op2) == IS_LONG)) {
				result = (Z_DVAL_P(op1) <= ((double)Z_LVAL_P(op2)));
			} else {
				break;
			}
		} else {
			break;
		}
		ZEND_VM_SMART_BRANCH(result, 0);
		ZVAL_BOOL(EX_VAR(opline->result.var), result);
		ZEND_VM_NEXT_OPCODE();
	} while (0);

	SAVE_OPLINE();
	if (IS_CV == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(op1) == IS_UNDEF)) {
		op1 = GET_OP1_UNDEF_CV(op1, BP_VAR_R);
	}
	if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_INFO_P(op2) == IS_UNDEF)) {
		op2 = GET_OP2_UNDEF_CV(op2, BP_VAR_R);
	}
	result = EX_VAR(opline->result.var);
	compare_function(result, op1, op2);
	ZVAL_BOOL(result, Z_LVAL_P(result) <= 0);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_SPACESHIP_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2;

	SAVE_OPLINE();
	op1 = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op1.var);
	op2 = EX_CONSTANT(opline->op2);
	compare_function(EX_VAR(opline->result.var), op1, op2);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_BW_OR_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2;

	SAVE_OPLINE();
	op1 = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op1.var);
	op2 = EX_CONSTANT(opline->op2);
	bitwise_or_function(EX_VAR(opline->result.var), op1, op2);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_BW_AND_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2;

	SAVE_OPLINE();
	op1 = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op1.var);
	op2 = EX_CONSTANT(opline->op2);
	bitwise_and_function(EX_VAR(opline->result.var), op1, op2);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_BW_XOR_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2;

	SAVE_OPLINE();
	op1 = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op1.var);
	op2 = EX_CONSTANT(opline->op2);
	bitwise_xor_function(EX_VAR(opline->result.var), op1, op2);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_BOOL_XOR_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2;

	SAVE_OPLINE();
	op1 = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op1.var);
	op2 = EX_CONSTANT(opline->op2);
	boolean_xor_function(EX_VAR(opline->result.var), op1, op2);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL zend_binary_assign_op_obj_helper_SPEC_CV_CONST(binary_op_type binary_op ZEND_OPCODE_HANDLER_ARGS_DC)
{
	USE_OPLINE
	zend_free_op free_op_data1;
	zval *object;
	zval *property;
	zval *value;
	zval *zptr;

	SAVE_OPLINE();
	object = _get_zval_ptr_cv_BP_VAR_RW(execute_data, opline->op1.var);

	if (IS_CV == IS_UNUSED && UNEXPECTED(Z_OBJ_P(object) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");
		FREE_UNFETCHED_OP((opline+1)->op1_type, (opline+1)->op1.var);

		HANDLE_EXCEPTION();
	}

	property = EX_CONSTANT(opline->op2);

	if (IS_CV == IS_VAR && UNEXPECTED(object == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an object");
		FREE_UNFETCHED_OP((opline+1)->op1_type, (opline+1)->op1.var);

		HANDLE_EXCEPTION();
	}

	do {
		value = get_zval_ptr((opline+1)->op1_type, (opline+1)->op1, execute_data, &free_op_data1, BP_VAR_R);

		if (IS_CV != IS_UNUSED && UNEXPECTED(Z_TYPE_P(object) != IS_OBJECT)) {
			ZVAL_DEREF(object);
			if (UNEXPECTED(!make_real_object(object))) {
				zend_error(E_WARNING, "Attempt to assign property of non-object");
				if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
					ZVAL_NULL(EX_VAR(opline->result.var));
				}
				break;
			}
		}

		/* here we are sure we are dealing with an object */
		if (EXPECTED(Z_OBJ_HT_P(object)->get_property_ptr_ptr)
			&& EXPECTED((zptr = Z_OBJ_HT_P(object)->get_property_ptr_ptr(object, property, BP_VAR_RW, ((IS_CONST == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL))) != NULL)) {

			ZVAL_DEREF(zptr);
			SEPARATE_ZVAL_NOREF(zptr);

			binary_op(zptr, zptr, value);
			if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
				ZVAL_COPY(EX_VAR(opline->result.var), zptr);
			}
		} else {
			zend_assign_op_overloaded_property(object, property, ((IS_CONST == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), value, binary_op, (UNEXPECTED(RETURN_VALUE_USED(opline)) ? EX_VAR(opline->result.var) : NULL));
		}
	} while (0);

	FREE_OP(free_op_data1);


	/* assign_obj has two opcodes! */
	ZEND_VM_NEXT_OPCODE_EX(1, 2);
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL zend_binary_assign_op_dim_helper_SPEC_CV_CONST(binary_op_type binary_op ZEND_OPCODE_HANDLER_ARGS_DC)
{
	USE_OPLINE
	zend_free_op free_op_data1;
	zval *var_ptr, rv;
	zval *value, *container, *dim;

	SAVE_OPLINE();
	container = _get_zval_ptr_cv_BP_VAR_RW(execute_data, opline->op1.var);
	if (IS_CV == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");
		FREE_UNFETCHED_OP((opline+1)->op1_type, (opline+1)->op1.var);

		HANDLE_EXCEPTION();
	}
	if (IS_CV == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an array");
		FREE_UNFETCHED_OP((opline+1)->op1_type, (opline+1)->op1.var);

		HANDLE_EXCEPTION();
	}

	dim = EX_CONSTANT(opline->op2);

	do {
		if (IS_CV == IS_UNUSED || UNEXPECTED(Z_TYPE_P(container) != IS_ARRAY)) {
			if (IS_CV != IS_UNUSED) {
				ZVAL_DEREF(container);
			}
			if (IS_CV == IS_UNUSED || EXPECTED(Z_TYPE_P(container) == IS_OBJECT)) {
				value = get_zval_ptr((opline+1)->op1_type, (opline+1)->op1, execute_data, &free_op_data1, BP_VAR_R);
				zend_binary_assign_op_obj_dim(container, dim, value, UNEXPECTED(RETURN_VALUE_USED(opline)) ? EX_VAR(opline->result.var) : NULL, binary_op);
				break;
			}
		}

		zend_fetch_dimension_address_RW(&rv, container, dim, IS_CONST);
		value = get_zval_ptr((opline+1)->op1_type, (opline+1)->op1, execute_data, &free_op_data1, BP_VAR_R);
		ZEND_ASSERT(Z_TYPE(rv) == IS_INDIRECT);
		var_ptr = Z_INDIRECT(rv);

		if (UNEXPECTED(var_ptr == NULL)) {
			zend_throw_error(NULL, "Cannot use assign-op operators with overloaded objects nor string offsets");

			FREE_OP(free_op_data1);

			HANDLE_EXCEPTION();
		}

		if (UNEXPECTED(var_ptr == &EG(error_zval))) {
			if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
				ZVAL_NULL(EX_VAR(opline->result.var));
			}
		} else {
			ZVAL_DEREF(var_ptr);
			SEPARATE_ZVAL_NOREF(var_ptr);

			binary_op(var_ptr, var_ptr, value);

			if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
				ZVAL_COPY(EX_VAR(opline->result.var), var_ptr);
			}
		}
	} while (0);

	FREE_OP(free_op_data1);

	ZEND_VM_NEXT_OPCODE_EX(1, 2);
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL zend_binary_assign_op_helper_SPEC_CV_CONST(binary_op_type binary_op ZEND_OPCODE_HANDLER_ARGS_DC)
{
	USE_OPLINE

	zval *var_ptr;
	zval *value;

	SAVE_OPLINE();
	value = EX_CONSTANT(opline->op2);
	var_ptr = _get_zval_ptr_cv_BP_VAR_RW(execute_data, opline->op1.var);

	if (IS_CV == IS_VAR && UNEXPECTED(var_ptr == NULL)) {
		zend_throw_error(NULL, "Cannot use assign-op operators with overloaded objects nor string offsets");

		HANDLE_EXCEPTION();
	}

	if (IS_CV == IS_VAR && UNEXPECTED(var_ptr == &EG(error_zval))) {
		if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
			ZVAL_NULL(EX_VAR(opline->result.var));
		}
	} else {
		ZVAL_DEREF(var_ptr);
		SEPARATE_ZVAL_NOREF(var_ptr);

		binary_op(var_ptr, var_ptr, value);

		if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
			ZVAL_COPY(EX_VAR(opline->result.var), var_ptr);
		}
	}


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_ADD_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CONST != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_CV != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_CV_CONST(add_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_CV_CONST(add_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_CV_CONST(add_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_CV_CONST(add_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_SUB_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CONST != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_CV != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_CV_CONST(sub_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_CV_CONST(sub_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_CV_CONST(sub_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_CV_CONST(sub_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_MUL_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CONST != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_CV != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_CV_CONST(mul_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_CV_CONST(mul_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_CV_CONST(mul_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_CV_CONST(mul_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_DIV_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CONST != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_CV != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_CV_CONST(div_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_CV_CONST(div_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_CV_CONST(div_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_CV_CONST(div_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_MOD_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CONST != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_CV != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_CV_CONST(mod_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_CV_CONST(mod_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_CV_CONST(mod_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_CV_CONST(mod_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_SL_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CONST != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_CV != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_CV_CONST(shift_left_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_CV_CONST(shift_left_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_CV_CONST(shift_left_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_CV_CONST(shift_left_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_SR_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CONST != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_CV != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_CV_CONST(shift_right_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_CV_CONST(shift_right_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_CV_CONST(shift_right_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_CV_CONST(shift_right_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_CONCAT_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CONST != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_CV != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_CV_CONST(concat_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_CV_CONST(concat_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_CV_CONST(concat_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_CV_CONST(concat_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_BW_OR_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CONST != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_CV != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_CV_CONST(bitwise_or_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_CV_CONST(bitwise_or_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_CV_CONST(bitwise_or_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_CV_CONST(bitwise_or_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_BW_AND_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CONST != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_CV != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_CV_CONST(bitwise_and_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_CV_CONST(bitwise_and_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_CV_CONST(bitwise_and_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_CV_CONST(bitwise_and_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_BW_XOR_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
#if 0 || (IS_CONST != IS_UNUSED)
	USE_OPLINE

# if 0 || (IS_CV != IS_UNUSED)
	if (EXPECTED(opline->extended_value == 0)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_helper_SPEC_CV_CONST(bitwise_xor_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
# endif
	if (EXPECTED(opline->extended_value == ZEND_ASSIGN_DIM)) {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_CV_CONST(bitwise_xor_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else /* if (EXPECTED(opline->extended_value == ZEND_ASSIGN_OBJ)) */ {
		ZEND_VM_TAIL_CALL(zend_binary_assign_op_obj_helper_SPEC_CV_CONST(bitwise_xor_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
#else
	ZEND_VM_TAIL_CALL(zend_binary_assign_op_dim_helper_SPEC_CV_CONST(bitwise_xor_function ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
#endif
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL zend_pre_incdec_property_helper_SPEC_CV_CONST(int inc ZEND_OPCODE_HANDLER_ARGS_DC)
{
	USE_OPLINE

	zval *object;
	zval *property;
	zval *zptr;

	SAVE_OPLINE();
	object = _get_zval_ptr_cv_BP_VAR_RW(execute_data, opline->op1.var);

	if (IS_CV == IS_UNUSED && UNEXPECTED(Z_OBJ_P(object) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}

	property = EX_CONSTANT(opline->op2);

	if (IS_CV == IS_VAR && UNEXPECTED(object == NULL)) {
		zend_throw_error(NULL, "Cannot increment/decrement overloaded objects nor string offsets");

		HANDLE_EXCEPTION();
	}

	do {
		if (IS_CV != IS_UNUSED && UNEXPECTED(Z_TYPE_P(object) != IS_OBJECT)) {
			ZVAL_DEREF(object);
			if (UNEXPECTED(!make_real_object(object))) {
				zend_error(E_WARNING, "Attempt to increment/decrement property of non-object");
				if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
					ZVAL_NULL(EX_VAR(opline->result.var));
				}
				break;
			}
		}

		/* here we are sure we are dealing with an object */

		if (EXPECTED(Z_OBJ_HT_P(object)->get_property_ptr_ptr)
			&& EXPECTED((zptr = Z_OBJ_HT_P(object)->get_property_ptr_ptr(object, property, BP_VAR_RW, ((IS_CONST == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL))) != NULL)) {

			if (EXPECTED(Z_TYPE_P(zptr) == IS_LONG)) {
				if (inc) {
					fast_long_increment_function(zptr);
				} else {
					fast_long_decrement_function(zptr);
				}
			} else {
				ZVAL_DEREF(zptr);
				SEPARATE_ZVAL_NOREF(zptr);

				if (inc) {
					increment_function(zptr);
				} else {
					decrement_function(zptr);
				}
			}
			if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
				ZVAL_COPY(EX_VAR(opline->result.var), zptr);
			}
		} else {
			zend_pre_incdec_overloaded_property(object, property, ((IS_CONST == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), inc, (UNEXPECTED(RETURN_VALUE_USED(opline)) ? EX_VAR(opline->result.var) : NULL));
		}
	} while (0);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_PRE_INC_OBJ_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	ZEND_VM_TAIL_CALL(zend_pre_incdec_property_helper_SPEC_CV_CONST(1 ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_PRE_DEC_OBJ_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	ZEND_VM_TAIL_CALL(zend_pre_incdec_property_helper_SPEC_CV_CONST(0 ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL zend_post_incdec_property_helper_SPEC_CV_CONST(int inc ZEND_OPCODE_HANDLER_ARGS_DC)
{
	USE_OPLINE

	zval *object;
	zval *property;
	zval *zptr;

	SAVE_OPLINE();
	object = _get_zval_ptr_cv_BP_VAR_RW(execute_data, opline->op1.var);

	if (IS_CV == IS_UNUSED && UNEXPECTED(Z_OBJ_P(object) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}

	property = EX_CONSTANT(opline->op2);

	if (IS_CV == IS_VAR && UNEXPECTED(object == NULL)) {
		zend_throw_error(NULL, "Cannot increment/decrement overloaded objects nor string offsets");

		HANDLE_EXCEPTION();
	}

	do {
		if (IS_CV != IS_UNUSED && UNEXPECTED(Z_TYPE_P(object) != IS_OBJECT)) {
			ZVAL_DEREF(object);
			if (UNEXPECTED(!make_real_object(object))) {
				zend_error(E_WARNING, "Attempt to increment/decrement property of non-object");
				ZVAL_NULL(EX_VAR(opline->result.var));
				break;
			}
		}

		/* here we are sure we are dealing with an object */

		if (EXPECTED(Z_OBJ_HT_P(object)->get_property_ptr_ptr)
			&& EXPECTED((zptr = Z_OBJ_HT_P(object)->get_property_ptr_ptr(object, property, BP_VAR_RW, ((IS_CONST == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL))) != NULL)) {

			if (EXPECTED(Z_TYPE_P(zptr) == IS_LONG)) {
				ZVAL_COPY_VALUE(EX_VAR(opline->result.var), zptr);
				if (inc) {
					fast_long_increment_function(zptr);
				} else {
					fast_long_decrement_function(zptr);
				}
			} else {
				ZVAL_DEREF(zptr);
				ZVAL_COPY_VALUE(EX_VAR(opline->result.var), zptr);
				zval_opt_copy_ctor(zptr);
				if (inc) {
					increment_function(zptr);
				} else {
					decrement_function(zptr);
				}
			}
		} else {
			zend_post_incdec_overloaded_property(object, property, ((IS_CONST == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), inc, EX_VAR(opline->result.var));
		}
	} while (0);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_POST_INC_OBJ_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	ZEND_VM_TAIL_CALL(zend_post_incdec_property_helper_SPEC_CV_CONST(1 ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_POST_DEC_OBJ_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	ZEND_VM_TAIL_CALL(zend_post_incdec_property_helper_SPEC_CV_CONST(0 ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL zend_fetch_var_address_helper_SPEC_CV_CONST(int type ZEND_OPCODE_HANDLER_ARGS_DC)
{
	USE_OPLINE

	zval *varname;
	zval *retval;
	zend_string *name;
	HashTable *target_symbol_table;

	SAVE_OPLINE();
	varname = _get_zval_ptr_cv_undef(execute_data, opline->op1.var);

 	if (IS_CV == IS_CONST) {
		name = Z_STR_P(varname);
	} else if (EXPECTED(Z_TYPE_P(varname) == IS_STRING)) {
		name = Z_STR_P(varname);
		zend_string_addref(name);
	} else {
		if (IS_CV == IS_CV && UNEXPECTED(Z_TYPE_P(varname) == IS_UNDEF)) {
			GET_OP1_UNDEF_CV(varname, BP_VAR_R);
		}
		name = zval_get_string(varname);
	}

	if (IS_CONST != IS_UNUSED) {
		zend_class_entry *ce;

		if (IS_CONST == IS_CONST) {
			if (IS_CV == IS_CONST && EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1))))) {

				ce = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)));
				retval = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)) + sizeof(void*));

				/* check if static properties were destoyed */
				if (UNEXPECTED(CE_STATIC_MEMBERS(ce) == NULL)) {
					zend_throw_error(NULL, "Access to undeclared static property: %s::$%s", ZSTR_VAL(ce->name), ZSTR_VAL(name));

					HANDLE_EXCEPTION();
				}

				goto fetch_var_return;
			} else if (EXPECTED(CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2))))) {
				ce = CACHED_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)));
			} else {
				ce = zend_fetch_class_by_name(Z_STR_P(EX_CONSTANT(opline->op2)), EX_CONSTANT(opline->op2) + 1, ZEND_FETCH_CLASS_DEFAULT | ZEND_FETCH_CLASS_EXCEPTION);
				if (UNEXPECTED(ce == NULL)) {
					if (IS_CV != IS_CONST) {
						zend_string_release(name);
					}

					ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
				}
				CACHE_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op2)), ce);
			}
		} else {
			ce = Z_CE_P(EX_VAR(opline->op2.var));
			if (IS_CV == IS_CONST &&
			    (retval = CACHED_POLYMORPHIC_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)), ce)) != NULL) {

				/* check if static properties were destoyed */
				if (UNEXPECTED(CE_STATIC_MEMBERS(ce) == NULL)) {
					zend_throw_error(NULL, "Access to undeclared static property: %s::$%s", ZSTR_VAL(ce->name), ZSTR_VAL(name));

					HANDLE_EXCEPTION();
				}

				goto fetch_var_return;
			}
		}
		retval = zend_std_get_static_property(ce, name, 0);
		if (UNEXPECTED(EG(exception))) {

			HANDLE_EXCEPTION();
		}
		if (IS_CV == IS_CONST && retval) {
			CACHE_POLYMORPHIC_PTR(Z_CACHE_SLOT_P(EX_CONSTANT(opline->op1)), ce, retval);
		}

	} else {
		target_symbol_table = zend_get_target_symbol_table(execute_data, opline->extended_value & ZEND_FETCH_TYPE_MASK);
		retval = zend_hash_find(target_symbol_table, name);
		if (retval == NULL) {
			switch (type) {
				case BP_VAR_R:
				case BP_VAR_UNSET:
					zend_error(E_NOTICE,"Undefined variable: %s", ZSTR_VAL(name));
					/* break missing intentionally */
				case BP_VAR_IS:
					retval = &EG(uninitialized_zval);
					break;
				case BP_VAR_RW:
					zend_error(E_NOTICE,"Undefined variable: %s", ZSTR_VAL(name));
					/* break missing intentionally */
				case BP_VAR_W:
					retval = zend_hash_add_new(target_symbol_table, name, &EG(uninitialized_zval));
					break;
				EMPTY_SWITCH_DEFAULT_CASE()
			}
		/* GLOBAL or $$name variable may be an INDIRECT pointer to CV */
		} else if (Z_TYPE_P(retval) == IS_INDIRECT) {
			retval = Z_INDIRECT_P(retval);
			if (Z_TYPE_P(retval) == IS_UNDEF) {
				switch (type) {
					case BP_VAR_R:
					case BP_VAR_UNSET:
						zend_error(E_NOTICE,"Undefined variable: %s", ZSTR_VAL(name));
						/* break missing intentionally */
					case BP_VAR_IS:
						retval = &EG(uninitialized_zval);
						break;
					case BP_VAR_RW:
						zend_error(E_NOTICE,"Undefined variable: %s", ZSTR_VAL(name));
						/* break missing intentionally */
					case BP_VAR_W:
						ZVAL_NULL(retval);
						break;
					EMPTY_SWITCH_DEFAULT_CASE()
				}
			}
		}
		if ((opline->extended_value & ZEND_FETCH_TYPE_MASK) == ZEND_FETCH_STATIC) {
			if (Z_CONSTANT_P(retval)) {
				if (UNEXPECTED(zval_update_constant_ex(retval, 1, NULL) != SUCCESS)) {

					HANDLE_EXCEPTION();
				}
			}
		} else if ((opline->extended_value & ZEND_FETCH_TYPE_MASK) != ZEND_FETCH_GLOBAL_LOCK) {

		}
	}

	if (IS_CV != IS_CONST) {
		zend_string_release(name);
	}

fetch_var_return:
	ZEND_ASSERT(retval != NULL);
	if (type == BP_VAR_R || type == BP_VAR_IS) {
		if (/*type == BP_VAR_R &&*/ Z_ISREF_P(retval) && Z_REFCOUNT_P(retval) == 1) {
			ZVAL_UNREF(retval);
		}
		ZVAL_COPY(EX_VAR(opline->result.var), retval);
	} else {
		ZVAL_INDIRECT(EX_VAR(opline->result.var), retval);
	}
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_R_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	ZEND_VM_TAIL_CALL(zend_fetch_var_address_helper_SPEC_CV_CONST(BP_VAR_R ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_W_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	ZEND_VM_TAIL_CALL(zend_fetch_var_address_helper_SPEC_CV_CONST(BP_VAR_W ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_RW_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	ZEND_VM_TAIL_CALL(zend_fetch_var_address_helper_SPEC_CV_CONST(BP_VAR_RW ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_FUNC_ARG_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	if (zend_is_by_ref_func_arg_fetch(opline, EX(call))) {
		ZEND_VM_TAIL_CALL(zend_fetch_var_address_helper_SPEC_CV_CONST(BP_VAR_W ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	} else {
		ZEND_VM_TAIL_CALL(zend_fetch_var_address_helper_SPEC_CV_CONST(BP_VAR_R ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_UNSET_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	ZEND_VM_TAIL_CALL(zend_fetch_var_address_helper_SPEC_CV_CONST(BP_VAR_UNSET ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_IS_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	ZEND_VM_TAIL_CALL(zend_fetch_var_address_helper_SPEC_CV_CONST(BP_VAR_IS ZEND_OPCODE_HANDLER_ARGS_PASSTHRU_CC));
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_DIM_R_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *container;

	SAVE_OPLINE();
	container = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op1.var);
	zend_fetch_dimension_address_read_R(EX_VAR(opline->result.var), container, EX_CONSTANT(opline->op2), IS_CONST);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_DIM_W_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *container;

	SAVE_OPLINE();
	container = _get_zval_ptr_cv_undef_BP_VAR_W(execute_data, opline->op1.var);

	if (IS_CV == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an array");
		HANDLE_EXCEPTION();
	}
	zend_fetch_dimension_address_W(EX_VAR(opline->result.var), container, EX_CONSTANT(opline->op2), IS_CONST);

	if (IS_CV == IS_VAR && READY_TO_DESTROY(free_op1)) {
		EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 1);
	}

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_DIM_RW_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *container;

	SAVE_OPLINE();
	container = _get_zval_ptr_cv_BP_VAR_RW(execute_data, opline->op1.var);

	if (IS_CV == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an array");
		HANDLE_EXCEPTION();
	}
	zend_fetch_dimension_address_RW(EX_VAR(opline->result.var), container, EX_CONSTANT(opline->op2), IS_CONST);

	if (IS_CV == IS_VAR && READY_TO_DESTROY(free_op1)) {
		EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 1);
	}

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_DIM_IS_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *container;

	SAVE_OPLINE();
	container = _get_zval_ptr_cv_BP_VAR_IS(execute_data, opline->op1.var);
	zend_fetch_dimension_address_read_IS(EX_VAR(opline->result.var), container, EX_CONSTANT(opline->op2), IS_CONST);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_DIM_FUNC_ARG_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *container;
	zend_free_op free_op1;

	SAVE_OPLINE();

	if (zend_is_by_ref_func_arg_fetch(opline, EX(call))) {
        if (IS_CV == IS_CONST || IS_CV == IS_TMP_VAR) {
            zend_throw_error(NULL, "Cannot use temporary expression in write context");


			HANDLE_EXCEPTION();
        }
		container = _get_zval_ptr_cv_undef_BP_VAR_W(execute_data, opline->op1.var);
		if (IS_CV == IS_VAR && UNEXPECTED(container == NULL)) {
			zend_throw_error(NULL, "Cannot use string offset as an array");

			HANDLE_EXCEPTION();
		}
		zend_fetch_dimension_address_W(EX_VAR(opline->result.var), container, EX_CONSTANT(opline->op2), IS_CONST);
		if (IS_CV == IS_VAR && READY_TO_DESTROY(free_op1)) {
			EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 1);
		}


	} else {
		if (IS_CONST == IS_UNUSED) {
			zend_throw_error(NULL, "Cannot use [] for reading");


			HANDLE_EXCEPTION();
		}
		container = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op1.var);
		zend_fetch_dimension_address_read_R(EX_VAR(opline->result.var), container, EX_CONSTANT(opline->op2), IS_CONST);


	}
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_DIM_UNSET_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *container;

	SAVE_OPLINE();
	container = _get_zval_ptr_cv_BP_VAR_UNSET(execute_data, opline->op1.var);

	if (IS_CV == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an array");

		HANDLE_EXCEPTION();
	}
	zend_fetch_dimension_address_UNSET(EX_VAR(opline->result.var), container, EX_CONSTANT(opline->op2), IS_CONST);

	if (IS_CV == IS_VAR && READY_TO_DESTROY(free_op1)) {
		EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 1);
	}

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_R_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *container;

	zval *offset;

	SAVE_OPLINE();
	container = _get_zval_ptr_cv_BP_VAR_R(execute_data, opline->op1.var);

	if (IS_CV == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}

	offset = EX_CONSTANT(opline->op2);

	if (IS_CV == IS_CONST ||
	    (IS_CV != IS_UNUSED && UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT))) {
		if ((IS_CV & (IS_VAR|IS_CV)) && Z_ISREF_P(container)) {
			container = Z_REFVAL_P(container);
			if (UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT)) {
				goto fetch_obj_r_no_object;
			}
		} else {
			goto fetch_obj_r_no_object;
		}
	}

	/* here we are sure we are dealing with an object */
	do {
		zend_object *zobj = Z_OBJ_P(container);
		zval *retval;

		if (IS_CONST == IS_CONST &&
			EXPECTED(zobj->ce == CACHED_PTR(Z_CACHE_SLOT_P(offset)))) {
			uint32_t prop_offset = (uint32_t)(intptr_t)CACHED_PTR(Z_CACHE_SLOT_P(offset) + sizeof(void*));

			if (EXPECTED(prop_offset != (uint32_t)ZEND_DYNAMIC_PROPERTY_OFFSET)) {
				retval = OBJ_PROP(zobj, prop_offset);
				if (EXPECTED(Z_TYPE_P(retval) != IS_UNDEF)) {
					ZVAL_COPY(EX_VAR(opline->result.var), retval);
					break;
				}
			} else if (EXPECTED(zobj->properties != NULL)) {
				retval = zend_hash_find(zobj->properties, Z_STR_P(offset));
				if (EXPECTED(retval)) {
					ZVAL_COPY(EX_VAR(opline->result.var), retval);
					break;
				}
			}
		}

		if (UNEXPECTED(zobj->handlers->read_property == NULL)) {
fetch_obj_r_no_object:
			zend_error(E_NOTICE, "Trying to get property of non-object");
			ZVAL_NULL(EX_VAR(opline->result.var));
		} else {
			retval = zobj->handlers->read_property(container, offset, BP_VAR_R, ((IS_CONST == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(offset)) : NULL), EX_VAR(opline->result.var));

			if (retval != EX_VAR(opline->result.var)) {
				ZVAL_COPY(EX_VAR(opline->result.var), retval);
			}
		}
	} while (0);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_W_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *property;
	zval *container;

	SAVE_OPLINE();
	property = EX_CONSTANT(opline->op2);

	container = _get_zval_ptr_cv_undef_BP_VAR_W(execute_data, opline->op1.var);
	if (IS_CV == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}
	if (IS_CV == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an object");

		HANDLE_EXCEPTION();
	}

	zend_fetch_property_address(EX_VAR(opline->result.var), container, IS_CV, property, IS_CONST, ((IS_CONST == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), BP_VAR_W);

	if (IS_CV == IS_VAR && READY_TO_DESTROY(free_op1)) {
		EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 0);
	}

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_RW_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *property;
	zval *container;

	SAVE_OPLINE();
	property = EX_CONSTANT(opline->op2);
	container = _get_zval_ptr_cv_BP_VAR_RW(execute_data, opline->op1.var);

	if (IS_CV == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}
	if (IS_CV == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an object");

		HANDLE_EXCEPTION();
	}
	zend_fetch_property_address(EX_VAR(opline->result.var), container, IS_CV, property, IS_CONST, ((IS_CONST == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), BP_VAR_RW);

	if (IS_CV == IS_VAR && READY_TO_DESTROY(free_op1)) {
		EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 0);
	}

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_IS_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *container;

	zval *offset;

	SAVE_OPLINE();
	container = _get_zval_ptr_cv_BP_VAR_IS(execute_data, opline->op1.var);

	if (IS_CV == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}

	offset  = EX_CONSTANT(opline->op2);

	if (IS_CV == IS_CONST ||
	    (IS_CV != IS_UNUSED && UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT))) {
		if ((IS_CV & (IS_VAR|IS_CV)) && Z_ISREF_P(container)) {
			container = Z_REFVAL_P(container);
			if (UNEXPECTED(Z_TYPE_P(container) != IS_OBJECT)) {
				goto fetch_obj_is_no_object;
			}
		} else {
			goto fetch_obj_is_no_object;
		}
	}

	/* here we are sure we are dealing with an object */
	do {
		zend_object *zobj = Z_OBJ_P(container);
		zval *retval;

		if (IS_CONST == IS_CONST &&
			EXPECTED(zobj->ce == CACHED_PTR(Z_CACHE_SLOT_P(offset)))) {
			uint32_t prop_offset = (uint32_t)(intptr_t)CACHED_PTR(Z_CACHE_SLOT_P(offset) + sizeof(void*));

			if (EXPECTED(prop_offset != (uint32_t)ZEND_DYNAMIC_PROPERTY_OFFSET)) {
				retval = OBJ_PROP(zobj, prop_offset);
				if (EXPECTED(Z_TYPE_P(retval) != IS_UNDEF)) {
					ZVAL_COPY(EX_VAR(opline->result.var), retval);
					break;
				}
			} else if (EXPECTED(zobj->properties != NULL)) {
				retval = zend_hash_find(zobj->properties, Z_STR_P(offset));
				if (EXPECTED(retval)) {
					ZVAL_COPY(EX_VAR(opline->result.var), retval);
					break;
				}
			}
		}

		if (UNEXPECTED(zobj->handlers->read_property == NULL)) {
fetch_obj_is_no_object:
			ZVAL_NULL(EX_VAR(opline->result.var));
		} else {

			retval = zobj->handlers->read_property(container, offset, BP_VAR_IS, ((IS_CONST == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(offset)) : NULL), EX_VAR(opline->result.var));

			if (retval != EX_VAR(opline->result.var)) {
				ZVAL_COPY(EX_VAR(opline->result.var), retval);
			}
		}
	} while (0);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_FUNC_ARG_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *container;

	if (zend_is_by_ref_func_arg_fetch(opline, EX(call))) {
		/* Behave like FETCH_OBJ_W */
		zend_free_op free_op1;
		zval *property;

		SAVE_OPLINE();
		property = EX_CONSTANT(opline->op2);
		container = _get_zval_ptr_cv_undef_BP_VAR_W(execute_data, opline->op1.var);

		if (IS_CV == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
			zend_throw_error(NULL, "Using $this when not in object context");

			HANDLE_EXCEPTION();
		}
		if (IS_CV == IS_CONST || IS_CV == IS_TMP_VAR) {
			zend_throw_error(NULL, "Cannot use temporary expression in write context");


			HANDLE_EXCEPTION();
		}
		if (IS_CV == IS_VAR && UNEXPECTED(container == NULL)) {
			zend_throw_error(NULL, "Cannot use string offset as an object");

			HANDLE_EXCEPTION();
		}
		zend_fetch_property_address(EX_VAR(opline->result.var), container, IS_CV, property, IS_CONST, ((IS_CONST == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), BP_VAR_W);

		if (IS_CV == IS_VAR && READY_TO_DESTROY(free_op1)) {
			EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 0);
		}

		ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
	} else {
		ZEND_VM_TAIL_CALL(ZEND_FETCH_OBJ_R_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS_PASSTHRU));
	}
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_OBJ_UNSET_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zend_free_op free_op1;
	zval *container, *property;

	SAVE_OPLINE();
	container = _get_zval_ptr_cv_BP_VAR_UNSET(execute_data, opline->op1.var);

	if (IS_CV == IS_UNUSED && UNEXPECTED(Z_OBJ_P(container) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}

	property = EX_CONSTANT(opline->op2);

	if (IS_CV == IS_VAR && UNEXPECTED(container == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an object");

		HANDLE_EXCEPTION();
	}
	zend_fetch_property_address(EX_VAR(opline->result.var), container, IS_CV, property, IS_CONST, ((IS_CONST == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property)) : NULL), BP_VAR_UNSET);

	if (IS_CV == IS_VAR && READY_TO_DESTROY(free_op1)) {
		EXTRACT_ZVAL_PTR(EX_VAR(opline->result.var), 0);
	}

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FETCH_LIST_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *container;

	SAVE_OPLINE();
	container = _get_zval_ptr_cv_undef(execute_data, opline->op1.var);

try_fetch_list:
	if (EXPECTED(Z_TYPE_P(container) == IS_ARRAY)) {
		zval *value = zend_hash_index_find(Z_ARRVAL_P(container), Z_LVAL_P(EX_CONSTANT(opline->op2)));

		if (UNEXPECTED(value == NULL)) {
			zend_error(E_NOTICE,"Undefined offset: " ZEND_ULONG_FMT, Z_LVAL_P(EX_CONSTANT(opline->op2)));
			ZVAL_NULL(EX_VAR(opline->result.var));
		} else {
			ZVAL_COPY(EX_VAR(opline->result.var), value);
		}
	} else if (IS_CV != IS_CONST &&
	           UNEXPECTED(Z_TYPE_P(container) == IS_OBJECT) &&
	           EXPECTED(Z_OBJ_HT_P(container)->read_dimension)) {
		zval *result = EX_VAR(opline->result.var);
		zval *retval = Z_OBJ_HT_P(container)->read_dimension(container, EX_CONSTANT(opline->op2), BP_VAR_R, result);

		if (retval) {
			if (result != retval) {
				ZVAL_COPY(result, retval);
			}
		} else {
			ZVAL_NULL(result);
		}
	} else if ((IS_CV & (IS_VAR|IS_CV)) && Z_TYPE_P(container) == IS_REFERENCE) {
		container = Z_REFVAL_P(container);
		goto try_fetch_list;
	} else {
		if (IS_CV == IS_CV && UNEXPECTED(Z_TYPE_P(container) == IS_UNDEF)) {
			GET_OP1_UNDEF_CV(container, BP_VAR_R);
		}
		ZVAL_NULL(EX_VAR(opline->result.var));
	}
	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_OBJ_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *object;
	zval *property_name;

	SAVE_OPLINE();
	object = _get_zval_ptr_cv_undef_BP_VAR_W(execute_data, opline->op1.var);

	if (IS_CV == IS_UNUSED && UNEXPECTED(Z_OBJ_P(object) == NULL)) {
		zend_throw_error(NULL, "Using $this when not in object context");

		HANDLE_EXCEPTION();
	}

	property_name = EX_CONSTANT(opline->op2);

	if (IS_CV == IS_VAR && UNEXPECTED(object == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an array");

		HANDLE_EXCEPTION();
	}
	zend_assign_to_object(UNEXPECTED(RETURN_VALUE_USED(opline)) ? EX_VAR(opline->result.var) : NULL, object, IS_CV, property_name, IS_CONST, (opline+1)->op1_type, (opline+1)->op1, execute_data, ((IS_CONST == IS_CONST) ? CACHE_ADDR(Z_CACHE_SLOT_P(property_name)) : NULL));


	/* assign_obj has two opcodes! */
	ZEND_VM_NEXT_OPCODE_EX(1, 2);
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_DIM_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *object_ptr;
	zend_free_op free_op_data1;
	zval *value;
	zval *variable_ptr;
	zval *dim;

	SAVE_OPLINE();
	object_ptr = _get_zval_ptr_cv_undef_BP_VAR_W(execute_data, opline->op1.var);

	if (IS_CV == IS_VAR && UNEXPECTED(object_ptr == NULL)) {
		zend_throw_error(NULL, "Cannot use string offset as an array");
		FREE_UNFETCHED_OP((opline+1)->op1_type, (opline+1)->op1.var);

		HANDLE_EXCEPTION();
	}

	if (EXPECTED(Z_TYPE_P(object_ptr) == IS_ARRAY)) {
try_assign_dim_array:
		if (IS_CONST == IS_UNUSED) {
			SEPARATE_ARRAY(object_ptr);
			variable_ptr = zend_hash_next_index_insert(Z_ARRVAL_P(object_ptr), &EG(uninitialized_zval));
			if (UNEXPECTED(variable_ptr == NULL)) {
				zend_error(E_WARNING, "Cannot add element to the array as the next element is already occupied");
				variable_ptr = &EG(error_zval);
			}
		} else {
			dim = EX_CONSTANT(opline->op2);
			SEPARATE_ARRAY(object_ptr);
			variable_ptr = zend_fetch_dimension_address_inner(Z_ARRVAL_P(object_ptr), dim, IS_CONST, BP_VAR_W);

		}
		value = get_zval_ptr((opline+1)->op1_type, (opline+1)->op1, execute_data, &free_op_data1, BP_VAR_R);
		if (UNEXPECTED(variable_ptr == &EG(error_zval))) {
			FREE_OP(free_op_data1);
			if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
				ZVAL_NULL(EX_VAR(opline->result.var));
			}
		} else {
			value = zend_assign_to_variable(variable_ptr, value, (opline+1)->op1_type);
			if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
				ZVAL_COPY(EX_VAR(opline->result.var), value);
			}
		}
	} else {
		if (EXPECTED(Z_ISREF_P(object_ptr))) {
			object_ptr = Z_REFVAL_P(object_ptr);
			if (EXPECTED(Z_TYPE_P(object_ptr) == IS_ARRAY)) {
				goto try_assign_dim_array;
			}
		}
		if (EXPECTED(Z_TYPE_P(object_ptr) == IS_OBJECT)) {

			zval *property_name = EX_CONSTANT(opline->op2);

			zend_assign_to_object_dim(UNEXPECTED(RETURN_VALUE_USED(opline)) ? EX_VAR(opline->result.var) : NULL, object_ptr, property_name, (opline+1)->op1_type, (opline+1)->op1, execute_data);

		} else if (EXPECTED(Z_TYPE_P(object_ptr) == IS_STRING)) {
			if (EXPECTED(Z_STRLEN_P(object_ptr) != 0)) {
				if (IS_CONST == IS_UNUSED) {
					zend_throw_error(NULL, "[] operator not supported for strings");
					FREE_UNFETCHED_OP((opline+1)->op1_type, (opline+1)->op1.var);

					HANDLE_EXCEPTION();
				} else {
					zend_long offset;

					dim = EX_CONSTANT(opline->op2);
					offset = zend_fetch_string_offset(object_ptr, dim, BP_VAR_W);

					value = get_zval_ptr_deref((opline+1)->op1_type, (opline+1)->op1, execute_data, &free_op_data1, BP_VAR_R);
					zend_assign_to_string_offset(object_ptr, offset, value, (UNEXPECTED(RETURN_VALUE_USED(opline)) ? EX_VAR(opline->result.var) : NULL));
					FREE_OP(free_op_data1);
				}
			} else {
				zval_ptr_dtor_nogc(object_ptr);
assign_dim_convert_to_array:
				ZVAL_NEW_ARR(object_ptr);
				zend_hash_init(Z_ARRVAL_P(object_ptr), 8, NULL, ZVAL_PTR_DTOR, 0);
				goto try_assign_dim_array;
			}
		} else if (EXPECTED(Z_TYPE_P(object_ptr) <= IS_FALSE)) {
			if (IS_CV == IS_VAR && UNEXPECTED(object_ptr == &EG(error_zval))) {
				goto assign_dim_clean;
			}
			goto assign_dim_convert_to_array;
		} else {
			zend_error(E_WARNING, "Cannot use a scalar value as an array");
assign_dim_clean:
			dim = EX_CONSTANT(opline->op2);

			value = get_zval_ptr((opline+1)->op1_type, (opline+1)->op1, execute_data, &free_op_data1, BP_VAR_R);
			FREE_OP(free_op_data1);
			if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
				ZVAL_NULL(EX_VAR(opline->result.var));
			}
		}
	}

	/* assign_dim has two opcodes! */
	ZEND_VM_NEXT_OPCODE_EX(1, 2);
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_ASSIGN_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *value;
	zval *variable_ptr;

	SAVE_OPLINE();
	value = EX_CONSTANT(opline->op2);
	variable_ptr = _get_zval_ptr_cv_undef_BP_VAR_W(execute_data, opline->op1.var);

	if (IS_CV == IS_VAR && UNEXPECTED(variable_ptr == &EG(error_zval))) {

		if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
			ZVAL_NULL(EX_VAR(opline->result.var));
		}
	} else {
		value = zend_assign_to_variable(variable_ptr, value, IS_CONST);
		if (UNEXPECTED(RETURN_VALUE_USED(opline))) {
			ZVAL_COPY(EX_VAR(opline->result.var), value);
		}

		/* zend_assign_to_variable() always takes care of op2, never free it! */
	}

	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_FAST_CONCAT_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE

	zval *op1, *op2;
	zend_string *op1_str, *op2_str, *str;

	SAVE_OPLINE();
	op1 = _get_zval_ptr_cv_undef(execute_data, opline->op1.var);
	if (IS_CV == IS_CONST) {
		op1_str = Z_STR_P(op1);
	} else if (EXPECTED(Z_TYPE_P(op1) == IS_STRING)) {
		op1_str = zend_string_copy(Z_STR_P(op1));
	} else {
		if (IS_CV == IS_CV && UNEXPECTED(Z_TYPE_P(op1) == IS_UNDEF)) {
			GET_OP1_UNDEF_CV(op1, BP_VAR_R);
		}
		op1_str = _zval_get_string_func(op1);
	}
	op2 = EX_CONSTANT(opline->op2);
	if (IS_CONST == IS_CONST) {
		op2_str = Z_STR_P(op2);
	} else if (EXPECTED(Z_TYPE_P(op2) == IS_STRING)) {
		op2_str = zend_string_copy(Z_STR_P(op2));
	} else {
		if (IS_CONST == IS_CV && UNEXPECTED(Z_TYPE_P(op2) == IS_UNDEF)) {
			GET_OP2_UNDEF_CV(op2, BP_VAR_R);
		}
		op2_str = _zval_get_string_func(op2);
	}
	do {
		if (IS_CV != IS_CONST) {
			if (UNEXPECTED(ZSTR_LEN(op1_str) == 0)) {
				if (IS_CONST == IS_CONST) {
					zend_string_addref(op2_str);
				}
				ZVAL_STR(EX_VAR(opline->result.var), op2_str);
				zend_string_release(op1_str);
				break;
			}
		}
		if (IS_CONST != IS_CONST) {
			if (UNEXPECTED(ZSTR_LEN(op2_str) == 0)) {
				if (IS_CV == IS_CONST) {
					zend_string_addref(op1_str);
				}
				ZVAL_STR(EX_VAR(opline->result.var), op1_str);
				zend_string_release(op2_str);
				break;
			}
		}
		str = zend_string_alloc(ZSTR_LEN(op1_str) + ZSTR_LEN(op2_str), 0);
		memcpy(ZSTR_VAL(str), ZSTR_VAL(op1_str), ZSTR_LEN(op1_str));
		memcpy(ZSTR_VAL(str) + ZSTR_LEN(op1_str), ZSTR_VAL(op2_str), ZSTR_LEN(op2_str)+1);
		ZVAL_NEW_STR(EX_VAR(opline->result.var), str);
		if (IS_CV != IS_CONST) {
			zend_string_release(op1_str);
		}
		if (IS_CONST != IS_CONST) {
			zend_string_release(op2_str);
		}
	} while (0);


	ZEND_VM_NEXT_OPCODE_CHECK_EXCEPTION();
}

static ZEND_OPCODE_HANDLER_RET ZEND_FASTCALL ZEND_INIT_METHOD_CALL_SPEC_CV_CONST_HANDLER(ZEND_OPCODE_HANDLER_ARGS)
{
	USE_OPLINE
	zval *funct