/* Generated by re2c 1.3 */
/*
   +----------------------------------------------------------------------+
   | Zend Engine                                                          |
   +----------------------------------------------------------------------+
   | Copyright (c) Zend Technologies Ltd. (http://www.zend.com)           |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2.00 of the Zend license,     |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.zend.com/license/2_00.txt.                                |
   | If you did not receive a copy of the Zend license and are unable to  |
   | obtain it through the world-wide-web, please send a note to          |
   | license@zend.com so we can mail you a copy immediately.              |
   +----------------------------------------------------------------------+
   | Authors: Marcus Boerger <helly@php.net>                              |
   |          Nuno Lopes <nlopess@php.net>                                |
   |          Scott MacVicar <scottmac@php.net>                           |
   | Flex version authors:                                                |
   |          Andi Gutmans <andi@php.net>                                 |
   |          Zeev Suraski <zeev@php.net>                                 |
   +----------------------------------------------------------------------+
*/

#if 0
# define YYDEBUG(s, c) printf("state: %d char: %c\n", s, c)
#else
# define YYDEBUG(s, c)
#endif

#include "zend_language_scanner_defs.h"

#include <errno.h>
#include "zend.h"
#ifdef ZEND_WIN32
# include <Winuser.h>
#endif
#include "zend_alloc.h"
#include <zend_language_parser.h>
#include "zend_compile.h"
#include "zend_language_scanner.h"
#include "zend_highlight.h"
#include "zend_constants.h"
#include "zend_variables.h"
#include "zend_operators.h"
#include "zend_API.h"
#include "zend_strtod.h"
#include "zend_exceptions.h"
#include "zend_virtual_cwd.h"

#define YYCTYPE   unsigned char
#define YYFILL(n) { if ((YYCURSOR + n) >= (YYLIMIT + ZEND_MMAP_AHEAD)) { return 0; } }
#define YYCURSOR  SCNG(yy_cursor)
#define YYLIMIT   SCNG(yy_limit)
#define YYMARKER  SCNG(yy_marker)

#define YYGETCONDITION()  SCNG(yy_state)
#define YYSETCONDITION(s) SCNG(yy_state) = s

#define STATE(name)  yyc##name

/* emulate flex constructs */
#define BEGIN(state) YYSETCONDITION(STATE(state))
#define YYSTATE      YYGETCONDITION()
#define yytext       ((char*)SCNG(yy_text))
#define yyleng       SCNG(yy_leng)
#define yyless(x)    do { YYCURSOR = (unsigned char*)yytext + x; \
                          yyleng   = (unsigned int)x; } while(0)
#define yymore()     goto yymore_restart

/* perform sanity check. If this message is triggered you should
   increase the ZEND_MMAP_AHEAD value in the zend_streams.h file */
#define YYMAXFILL 16

#if ZEND_MMAP_AHEAD < YYMAXFILL
# error ZEND_MMAP_AHEAD should be greater than or equal to YYMAXFILL
#endif

#include <stdarg.h>

#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif

/* Globals Macros */
#define SCNG	LANG_SCNG
#ifdef ZTS
ZEND_API ts_rsrc_id language_scanner_globals_id;
ZEND_API size_t language_scanner_globals_offset;
#else
ZEND_API zend_php_scanner_globals language_scanner_globals;
#endif

#define HANDLE_NEWLINES(s, l)													\
do {																			\
	char *p = (s), *boundary = p+(l);											\
																				\
	while (p<boundary) {														\
		if (*p == '\n' || (*p == '\r' && (*(p+1) != '\n'))) {					\
			CG(zend_lineno)++;													\
		}																		\
		p++;																	\
	}																			\
} while (0)

#define HANDLE_NEWLINE(c) \
{ \
	if (c == '\n' || c == '\r') { \
		CG(zend_lineno)++; \
	} \
}

/* To save initial string length after scanning to first variable */
#define SET_DOUBLE_QUOTES_SCANNED_LENGTH(len) SCNG(scanned_string_len) = (len)
#define GET_DOUBLE_QUOTES_SCANNED_LENGTH()    SCNG(scanned_string_len)

#define IS_LABEL_START(c) (((c) >= 'a' && (c) <= 'z') || ((c) >= 'A' && (c) <= 'Z') || (c) == '_' || (c) >= 0x80)
#define IS_LABEL_SUCCESSOR(c) (((c) >= 'a' && (c) <= 'z') || ((c) >= 'A' && (c) <= 'Z') || ((c) >= '0' && (c) <= '9') || (c) == '_' || (c) >= 0x80)

#define ZEND_IS_OCT(c)  ((c)>='0' && (c)<='7')
#define ZEND_IS_HEX(c)  (((c)>='0' && (c)<='9') || ((c)>='a' && (c)<='f') || ((c)>='A' && (c)<='F'))


static void strip_underscores(char *str, size_t *len)
{
	char *src = str, *dest = str;
	while (*src != '\0') {
		if (*src != '_') {
			*dest = *src;
			dest++;
		} else {
			--(*len);
		}
		src++;
	}
	*dest = '\0';
}

static size_t encoding_filter_script_to_internal(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding();
	ZEND_ASSERT(internal_encoding);
	return zend_multibyte_encoding_converter(to, to_length, from, from_length, internal_encoding, LANG_SCNG(script_encoding));
}

static size_t encoding_filter_script_to_intermediate(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	return zend_multibyte_encoding_converter(to, to_length, from, from_length, zend_multibyte_encoding_utf8, LANG_SCNG(script_encoding));
}

static size_t encoding_filter_intermediate_to_script(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	return zend_multibyte_encoding_converter(to, to_length, from, from_length,
LANG_SCNG(script_encoding), zend_multibyte_encoding_utf8);
}

static size_t encoding_filter_intermediate_to_internal(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding();
	ZEND_ASSERT(internal_encoding);
	return zend_multibyte_encoding_converter(to, to_length, from, from_length,
internal_encoding, zend_multibyte_encoding_utf8);
}


static void _yy_push_state(int new_state)
{
	zend_stack_push(&SCNG(state_stack), (void *) &YYGETCONDITION());
	YYSETCONDITION(new_state);
}

#define yy_push_state(state_and_tsrm) _yy_push_state(yyc##state_and_tsrm)

static void yy_pop_state(void)
{
	int *stack_state = zend_stack_top(&SCNG(state_stack));
	YYSETCONDITION(*stack_state);
	zend_stack_del_top(&SCNG(state_stack));
}

static void yy_scan_buffer(char *str, size_t len)
{
	YYCURSOR       = (YYCTYPE*)str;
	YYLIMIT        = YYCURSOR + len;
	if (!SCNG(yy_start)) {
		SCNG(yy_start) = YYCURSOR;
	}
}

void startup_scanner(void)
{
	CG(parse_error) = 0;
	CG(doc_comment) = NULL;
	CG(extra_fn_flags) = 0;
	zend_stack_init(&SCNG(state_stack), sizeof(int));
	zend_stack_init(&SCNG(nest_location_stack), sizeof(zend_nest_location));
	zend_ptr_stack_init(&SCNG(heredoc_label_stack));
	SCNG(heredoc_scan_ahead) = 0;
}

static void heredoc_label_dtor(zend_heredoc_label *heredoc_label) {
    efree(heredoc_label->label);
}

void shutdown_scanner(void)
{
	CG(parse_error) = 0;
	RESET_DOC_COMMENT();
	zend_stack_destroy(&SCNG(state_stack));
	zend_stack_destroy(&SCNG(nest_location_stack));
	zend_ptr_stack_clean(&SCNG(heredoc_label_stack), (void (*)(void *)) &heredoc_label_dtor, 1);
	zend_ptr_stack_destroy(&SCNG(heredoc_label_stack));
	SCNG(heredoc_scan_ahead) = 0;
	SCNG(on_event) = NULL;
}

ZEND_API void zend_save_lexical_state(zend_lex_state *lex_state)
{
	lex_state->yy_leng   = SCNG(yy_leng);
	lex_state->yy_start  = SCNG(yy_start);
	lex_state->yy_text   = SCNG(yy_text);
	lex_state->yy_cursor = SCNG(yy_cursor);
	lex_state->yy_marker = SCNG(yy_marker);
	lex_state->yy_limit  = SCNG(yy_limit);

	lex_state->state_stack = SCNG(state_stack);
	zend_stack_init(&SCNG(state_stack), sizeof(int));

	lex_state->nest_location_stack = SCNG(nest_location_stack);
	zend_stack_init(&SCNG(nest_location_stack), sizeof(zend_nest_location));

	lex_state->heredoc_label_stack = SCNG(heredoc_label_stack);
	zend_ptr_stack_init(&SCNG(heredoc_label_stack));

	lex_state->in = SCNG(yy_in);
	lex_state->yy_state = YYSTATE;
	lex_state->filename = CG(compiled_filename);
	lex_state->lineno = CG(zend_lineno);
	CG(compiled_filename) = NULL;

	lex_state->script_org = SCNG(script_org);
	lex_state->script_org_size = SCNG(script_org_size);
	lex_state->script_filtered = SCNG(script_filtered);
	lex_state->script_filtered_size = SCNG(script_filtered_size);
	lex_state->input_filter = SCNG(input_filter);
	lex_state->output_filter = SCNG(output_filter);
	lex_state->script_encoding = SCNG(script_encoding);

	lex_state->on_event = SCNG(on_event);
	lex_state->on_event_context = SCNG(on_event_context);

	lex_state->ast = CG(ast);
	lex_state->ast_arena = CG(ast_arena);
}

ZEND_API void zend_restore_lexical_state(zend_lex_state *lex_state)
{
	SCNG(yy_leng)   = lex_state->yy_leng;
	SCNG(yy_start)  = lex_state->yy_start;
	SCNG(yy_text)   = lex_state->yy_text;
	SCNG(yy_cursor) = lex_state->yy_cursor;
	SCNG(yy_marker) = lex_state->yy_marker;
	SCNG(yy_limit)  = lex_state->yy_limit;

	zend_stack_destroy(&SCNG(state_stack));
	SCNG(state_stack) = lex_state->state_stack;

	zend_stack_destroy(&SCNG(nest_location_stack));
	SCNG(nest_location_stack) = lex_state->nest_location_stack;

	zend_ptr_stack_clean(&SCNG(heredoc_label_stack), (void (*)(void *)) &heredoc_label_dtor, 1);
	zend_ptr_stack_destroy(&SCNG(heredoc_label_stack));
	SCNG(heredoc_label_stack) = lex_state->heredoc_label_stack;

	SCNG(yy_in) = lex_state->in;
	YYSETCONDITION(lex_state->yy_state);
	CG(zend_lineno) = lex_state->lineno;
	zend_restore_compiled_filename(lex_state->filename);

	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	SCNG(script_org) = lex_state->script_org;
	SCNG(script_org_size) = lex_state->script_org_size;
	SCNG(script_filtered) = lex_state->script_filtered;
	SCNG(script_filtered_size) = lex_state->script_filtered_size;
	SCNG(input_filter) = lex_state->input_filter;
	SCNG(output_filter) = lex_state->output_filter;
	SCNG(script_encoding) = lex_state->script_encoding;

	SCNG(on_event) = lex_state->on_event;
	SCNG(on_event_context) = lex_state->on_event_context;

	CG(ast) = lex_state->ast;
	CG(ast_arena) = lex_state->ast_arena;

	RESET_DOC_COMMENT();
}

ZEND_API zend_result zend_lex_tstring(zval *zv, unsigned char *ident)
{
	unsigned char *end = ident;
	while ((*end >= 'a' && *end <= 'z') || (*end >= 'A' && *end <= 'Z') || *end == '_') {
		end++;
	}

	size_t length = end - ident;
	if (length == 0) {
		ZEND_ASSERT(ident[0] == '<' && ident[1] == '?' && ident[2] == '=');
		zend_throw_exception(zend_ce_parse_error, "Cannot use \"<?=\" as an identifier", 0);
		return FAILURE;
	}

	if (SCNG(on_event)) {
		SCNG(on_event)(ON_FEEDBACK, T_STRING, 0, (char *) ident, length, SCNG(on_event_context));
	}

	ZVAL_STRINGL(zv, (char *) ident, length);
	return SUCCESS;
}

#define BOM_UTF32_BE	"\x00\x00\xfe\xff"
#define	BOM_UTF32_LE	"\xff\xfe\x00\x00"
#define	BOM_UTF16_BE	"\xfe\xff"
#define	BOM_UTF16_LE	"\xff\xfe"
#define	BOM_UTF8		"\xef\xbb\xbf"

static const zend_encoding *zend_multibyte_detect_utf_encoding(const unsigned char *script, size_t script_size)
{
	const unsigned char *p;
	int wchar_size = 2;
	int le = 0;

	/* utf-16 or utf-32? */
	p = script;
	assert(p >= script);
	while ((size_t)(p-script) < script_size) {
		p = memchr(p, 0, script_size-(p-script)-2);
		if (!p) {
			break;
		}
		if (*(p+1) == '\0' && *(p+2) == '\0') {
			wchar_size = 4;
			break;
		}

		/* searching for UTF-32 specific byte orders, so this will do */
		p += 4;
	}

	/* BE or LE? */
	p = script;
	assert(p >= script);
	while ((size_t)(p-script) < script_size) {
		if (*p == '\0' && *(p+wchar_size-1) != '\0') {
			/* BE */
			le = 0;
			break;
		} else if (*p != '\0' && *(p+wchar_size-1) == '\0') {
			/* LE* */
			le = 1;
			break;
		}
		p += wchar_size;
	}

	if (wchar_size == 2) {
		return le ? zend_multibyte_encoding_utf16le : zend_multibyte_encoding_utf16be;
	} else {
		return le ? zend_multibyte_encoding_utf32le : zend_multibyte_encoding_utf32be;
	}

	return NULL;
}

static const zend_encoding* zend_multibyte_detect_unicode(void)
{
	const zend_encoding *script_encoding = NULL;
	int bom_size;
	unsigned char *pos1, *pos2;

	if (LANG_SCNG(script_org_size) < sizeof(BOM_UTF32_LE)-1) {
		return NULL;
	}

	/* check out BOM */
	if (!memcmp(LANG_SCNG(script_org), BOM_UTF32_BE, sizeof(BOM_UTF32_BE)-1)) {
		script_encoding = zend_multibyte_encoding_utf32be;
		bom_size = sizeof(BOM_UTF32_BE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF32_LE, sizeof(BOM_UTF32_LE)-1)) {
		script_encoding = zend_multibyte_encoding_utf32le;
		bom_size = sizeof(BOM_UTF32_LE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF16_BE, sizeof(BOM_UTF16_BE)-1)) {
		script_encoding = zend_multibyte_encoding_utf16be;
		bom_size = sizeof(BOM_UTF16_BE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF16_LE, sizeof(BOM_UTF16_LE)-1)) {
		script_encoding = zend_multibyte_encoding_utf16le;
		bom_size = sizeof(BOM_UTF16_LE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF8, sizeof(BOM_UTF8)-1)) {
		script_encoding = zend_multibyte_encoding_utf8;
		bom_size = sizeof(BOM_UTF8)-1;
	}

	if (script_encoding) {
		/* remove BOM */
		LANG_SCNG(script_org) += bom_size;
		LANG_SCNG(script_org_size) -= bom_size;

		return script_encoding;
	}

	/* script contains NULL bytes -> auto-detection */
	if ((pos1 = memchr(LANG_SCNG(script_org), 0, LANG_SCNG(script_org_size)))) {
		/* check if the NULL byte is after the __HALT_COMPILER(); */
		pos2 = LANG_SCNG(script_org);

		while ((size_t)(pos1 - pos2) >= sizeof("__HALT_COMPILER();")-1) {
			pos2 = memchr(pos2, '_', pos1 - pos2);
			if (!pos2) break;
			pos2++;
			if (strncasecmp((char*)pos2, "_HALT_COMPILER", sizeof("_HALT_COMPILER")-1) == 0) {
				pos2 += sizeof("_HALT_COMPILER")-1;
				while (*pos2 == ' '  ||
					   *pos2 == '\t' ||
					   *pos2 == '\r' ||
					   *pos2 == '\n') {
					pos2++;
				}
				if (*pos2 == '(') {
					pos2++;
					while (*pos2 == ' '  ||
						   *pos2 == '\t' ||
						   *pos2 == '\r' ||
						   *pos2 == '\n') {
						pos2++;
					}
					if (*pos2 == ')') {
						pos2++;
						while (*pos2 == ' '  ||
							   *pos2 == '\t' ||
							   *pos2 == '\r' ||
							   *pos2 == '\n') {
							pos2++;
						}
						if (*pos2 == ';') {
							return NULL;
						}
					}
				}
			}
		}
		/* make best effort if BOM is missing */
		return zend_multibyte_detect_utf_encoding(LANG_SCNG(script_org), LANG_SCNG(script_org_size));
	}

	return NULL;
}

static const zend_encoding* zend_multibyte_find_script_encoding(void)
{
	const zend_encoding *script_encoding;

	if (CG(detect_unicode)) {
		/* check out bom(byte order mark) and see if containing wchars */
		script_encoding = zend_multibyte_detect_unicode();
		if (script_encoding != NULL) {
			/* bom or wchar detection is prior to 'script_encoding' option */
			return script_encoding;
		}
	}

	/* if no script_encoding specified, just leave alone */
	if (!CG(script_encoding_list) || !CG(script_encoding_list_size)) {
		return NULL;
	}

	/* if multiple encodings specified, detect automagically */
	if (CG(script_encoding_list_size) > 1) {
		return zend_multibyte_encoding_detector(LANG_SCNG(script_org), LANG_SCNG(script_org_size), CG(script_encoding_list), CG(script_encoding_list_size));
	}

	return CG(script_encoding_list)[0];
}

ZEND_API zend_result zend_multibyte_set_filter(const zend_encoding *onetime_encoding)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding();
	const zend_encoding *script_encoding = onetime_encoding ? onetime_encoding: zend_multibyte_find_script_encoding();

	if (!script_encoding) {
		return FAILURE;
	}

	/* judge input/output filter */
	LANG_SCNG(script_encoding) = script_encoding;
	LANG_SCNG(input_filter) = NULL;
	LANG_SCNG(output_filter) = NULL;

	if (!internal_encoding || LANG_SCNG(script_encoding) == internal_encoding) {
		if (!zend_multibyte_check_lexer_compatibility(LANG_SCNG(script_encoding))) {
			/* and if not, work around w/ script_encoding -> utf-8 -> script_encoding conversion */
			LANG_SCNG(input_filter) = encoding_filter_script_to_intermediate;
			LANG_SCNG(output_filter) = encoding_filter_intermediate_to_script;
		} else {
			LANG_SCNG(input_filter) = NULL;
			LANG_SCNG(output_filter) = NULL;
		}
		return SUCCESS;
	}

	if (zend_multibyte_check_lexer_compatibility(internal_encoding)) {
		LANG_SCNG(input_filter) = encoding_filter_script_to_internal;
		LANG_SCNG(output_filter) = NULL;
	} else if (zend_multibyte_check_lexer_compatibility(LANG_SCNG(script_encoding))) {
		LANG_SCNG(input_filter) = NULL;
		LANG_SCNG(output_filter) = encoding_filter_script_to_internal;
	} else {
		/* both script and internal encodings are incompatible w/ flex */
		LANG_SCNG(input_filter) = encoding_filter_script_to_intermediate;
		LANG_SCNG(output_filter) = encoding_filter_intermediate_to_internal;
	}

	return SUCCESS;
}

ZEND_API zend_result open_file_for_scanning(zend_file_handle *file_handle)
{
	char *buf;
	size_t size;
	zend_string *compiled_filename;

	if (zend_stream_fixup(file_handle, &buf, &size) == FAILURE) {
		/* Still add it to open_files to make destroy_file_handle work */
		zend_llist_add_element(&CG(open_files), file_handle);
		file_handle->in_list = 1;
		return FAILURE;
	}

	ZEND_ASSERT(!EG(exception) && "stream_fixup() should have failed");
	zend_llist_add_element(&CG(open_files), file_handle);
	file_handle->in_list = 1;

	/* Reset the scanner for scanning the new file */
	SCNG(yy_in) = file_handle;
	SCNG(yy_start) = NULL;

	if (size != (size_t)-1) {
		if (CG(multibyte)) {
			SCNG(script_org) = (unsigned char*)buf;
			SCNG(script_org_size) = size;
			SCNG(script_filtered) = NULL;

			zend_multibyte_set_filter(NULL);

			if (SCNG(input_filter)) {
				if ((size_t)-1 == SCNG(input_filter)(&SCNG(script_filtered), &SCNG(script_filtered_size), SCNG(script_org), SCNG(script_org_size))) {
					zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
							"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
				}
				buf = (char*)SCNG(script_filtered);
				size = SCNG(script_filtered_size);
			}
		}
		SCNG(yy_start) = (unsigned char *)buf;
		yy_scan_buffer(buf, size);
	} else {
		zend_error_noreturn(E_COMPILE_ERROR, "zend_stream_mmap() failed");
	}

	if (CG(skip_shebang)) {
		BEGIN(SHEBANG);
	} else {
		BEGIN(INITIAL);
	}

	if (file_handle->opened_path) {
		compiled_filename = zend_string_copy(file_handle->opened_path);
	} else {
		compiled_filename = zend_string_copy(file_handle->filename);
	}

	zend_set_compiled_filename(compiled_filename);
	zend_string_release_ex(compiled_filename, 0);

	RESET_DOC_COMMENT();
	CG(zend_lineno) = 1;
	CG(increment_lineno) = 0;
	return SUCCESS;
}

static zend_op_array *zend_compile(int type)
{
	zend_op_array *op_array = NULL;
	bool original_in_compilation = CG(in_compilation);

	CG(in_compilation) = 1;
	CG(ast) = NULL;
	CG(ast_arena) = zend_arena_create(1024 * 32);

	if (!zendparse()) {
		int last_lineno = CG(zend_lineno);
		zend_file_context original_file_context;
		zend_oparray_context original_oparray_context;
		zend_op_array *original_active_op_array = CG(active_op_array);

		op_array = emalloc(sizeof(zend_op_array));
		init_op_array(op_array, type, INITIAL_OP_ARRAY_SIZE);
		CG(active_op_array) = op_array;

		/* Use heap to not waste arena memory */
		op_array->fn_flags |= ZEND_ACC_HEAP_RT_CACHE;

		if (zend_ast_process) {
			zend_ast_process(CG(ast));
		}

		zend_file_context_begin(&original_file_context);
		zend_oparray_context_begin(&original_oparray_context);
		zend_compile_top_stmt(CG(ast));
		CG(zend_lineno) = last_lineno;
		zend_emit_final_return(type == ZEND_USER_FUNCTION);
		op_array->line_start = 1;
		op_array->line_end = last_lineno;
		pass_two(op_array);
		zend_oparray_context_end(&original_oparray_context);
		zend_file_context_end(&original_file_context);

		CG(active_op_array) = original_active_op_array;
	}

	zend_ast_destroy(CG(ast));
	zend_arena_destroy(CG(ast_arena));

	CG(in_compilation) = original_in_compilation;

	return op_array;
}

ZEND_API zend_op_array *compile_file(zend_file_handle *file_handle, int type)
{
	zend_lex_state original_lex_state;
	zend_op_array *op_array = NULL;
	zend_save_lexical_state(&original_lex_state);

	if (open_file_for_scanning(file_handle)==FAILURE) {
		if (!EG(exception)) {
			if (type==ZEND_REQUIRE) {
				zend_message_dispatcher(ZMSG_FAILED_REQUIRE_FOPEN, ZSTR_VAL(file_handle->filename));
			} else {
				zend_message_dispatcher(ZMSG_FAILED_INCLUDE_FOPEN, ZSTR_VAL(file_handle->filename));
			}
		}
	} else {
		op_array = zend_compile(ZEND_USER_FUNCTION);
	}

	zend_restore_lexical_state(&original_lex_state);
	return op_array;
}

ZEND_API zend_ast *zend_compile_string_to_ast(
		zend_string *code, zend_arena **ast_arena, zend_string *filename) {
	zval code_zv;
	bool original_in_compilation;
	zend_lex_state original_lex_state;
	zend_ast *ast;

	ZVAL_STR_COPY(&code_zv, code);

	original_in_compilation = CG(in_compilation);
	CG(in_compilation) = 1;

	zend_save_lexical_state(&original_lex_state);
	zend_prepare_string_for_scanning(&code_zv, filename);
	CG(ast) = NULL;
	CG(ast_arena) = zend_arena_create(1024 * 32);
	LANG_SCNG(yy_state) = yycINITIAL;

	if (zendparse() != 0) {
		zend_ast_destroy(CG(ast));
		zend_arena_destroy(CG(ast_arena));
		CG(ast) = NULL;
	}

	/* restore_lexical_state changes CG(ast) and CG(ast_arena) */
	ast = CG(ast);
	*ast_arena = CG(ast_arena);

	zend_restore_lexical_state(&original_lex_state);
	CG(in_compilation) = original_in_compilation;

	zval_ptr_dtor_str(&code_zv);

	return ast;
}

zend_op_array *compile_filename(int type, zend_string *filename)
{
	zend_file_handle file_handle;
	zend_op_array *retval;
	zend_string *opened_path = NULL;

	zend_stream_init_filename_ex(&file_handle, filename);

	retval = zend_compile_file(&file_handle, type);
	if (retval && file_handle.handle.stream.handle) {
		if (!file_handle.opened_path) {
			file_handle.opened_path = opened_path = zend_string_copy(filename);
		}

		zend_hash_add_empty_element(&EG(included_files), file_handle.opened_path);

		if (opened_path) {
			zend_string_release_ex(opened_path, 0);
		}
	}
	zend_destroy_file_handle(&file_handle);

	return retval;
}

ZEND_API void zend_prepare_string_for_scanning(zval *str, zend_string *filename)
{
	char *buf;
	size_t size, old_len;

	/* enforce ZEND_MMAP_AHEAD trailing NULLs for flex... */
	old_len = Z_STRLEN_P(str);
	Z_STR_P(str) = zend_string_extend(Z_STR_P(str), old_len + ZEND_MMAP_AHEAD, 0);
	Z_TYPE_INFO_P(str) = IS_STRING_EX;
	memset(Z_STRVAL_P(str) + old_len, 0, ZEND_MMAP_AHEAD + 1);

	SCNG(yy_in) = NULL;
	SCNG(yy_start) = NULL;

	buf = Z_STRVAL_P(str);
	size = old_len;

	if (CG(multibyte)) {
		SCNG(script_org) = (unsigned char*)buf;
		SCNG(script_org_size) = size;
		SCNG(script_filtered) = NULL;

		zend_multibyte_set_filter(zend_multibyte_get_internal_encoding());

		if (SCNG(input_filter)) {
			if ((size_t)-1 == SCNG(input_filter)(&SCNG(script_filtered), &SCNG(script_filtered_size), SCNG(script_org), SCNG(script_org_size))) {
				zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
						"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
			}
			buf = (char*)SCNG(script_filtered);
			size = SCNG(script_filtered_size);
		}
	}

	yy_scan_buffer(buf, size);
	zend_set_compiled_filename(filename);
	CG(zend_lineno) = 1;
	CG(increment_lineno) = 0;
	RESET_DOC_COMMENT();
}


ZEND_API size_t zend_get_scanned_file_offset(void)
{
	size_t offset = SCNG(yy_cursor) - SCNG(yy_start);
	if (SCNG(input_filter)) {
		size_t original_offset = offset, length = 0;
		do {
			unsigned char *p = NULL;
			if ((size_t)-1 == SCNG(input_filter)(&p, &length, SCNG(script_org), offset)) {
				return (size_t)-1;
			}
			efree(p);
			if (length > original_offset) {
				offset--;
			} else if (length < original_offset) {
				offset++;
			}
		} while (original_offset != length);
	}
	return offset;
}

zend_op_array *compile_string(zend_string *source_string, const char *filename, zend_compile_position position)
{
	zend_lex_state original_lex_state;
	zend_op_array *op_array = NULL;
	zval tmp;
	zend_string *filename_str;

	if (ZSTR_LEN(source_string) == 0) {
		return NULL;
	}

	ZVAL_STR_COPY(&tmp, source_string);

	zend_save_lexical_state(&original_lex_state);
	filename_str = zend_string_init(filename, strlen(filename), 0);
	zend_prepare_string_for_scanning(&tmp, filename_str);
	zend_string_release(filename_str);

	switch (position) {
		case ZEND_COMPILE_POSITION_AT_SHEBANG:
			BEGIN(SHEBANG);
			break;
		case ZEND_COMPILE_POSITION_AT_OPEN_TAG:
			BEGIN(INITIAL);
			break;
		case ZEND_COMPILE_POSITION_AFTER_OPEN_TAG:
			BEGIN(ST_IN_SCRIPTING);
			break;
	}

	op_array = zend_compile(ZEND_EVAL_CODE);

	zend_restore_lexical_state(&original_lex_state);
	zval_ptr_dtor(&tmp);

	return op_array;
}


zend_result highlight_file(const char *filename, zend_syntax_highlighter_ini *syntax_highlighter_ini)
{
	zend_lex_state original_lex_state;
	zend_file_handle file_handle;

	zend_stream_init_filename(&file_handle, filename);
	zend_save_lexical_state(&original_lex_state);
	if (open_file_for_scanning(&file_handle)==FAILURE) {
		zend_message_dispatcher(ZMSG_FAILED_HIGHLIGHT_FOPEN, filename);
		zend_destroy_file_handle(&file_handle);
		zend_restore_lexical_state(&original_lex_state);
		return FAILURE;
	}
	zend_highlight(syntax_highlighter_ini);
	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	zend_destroy_file_handle(&file_handle);
	zend_restore_lexical_state(&original_lex_state);
	return SUCCESS;
}

void highlight_string(zend_string *str, zend_syntax_highlighter_ini *syntax_highlighter_ini, const char *filename)
{
	zend_lex_state original_lex_state;
	zval str_zv;
	zend_string *filename_str = zend_string_init(filename, strlen(filename), 0);
	ZVAL_STR_COPY(&str_zv, str);
	zend_save_lexical_state(&original_lex_state);
	zend_prepare_string_for_scanning(&str_zv, filename_str);
	zend_string_release(filename_str);
	BEGIN(INITIAL);
	zend_highlight(syntax_highlighter_ini);
	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	zend_restore_lexical_state(&original_lex_state);
	zval_ptr_dtor(&str_zv);
}

ZEND_API void zend_multibyte_yyinput_again(zend_encoding_filter old_input_filter, const zend_encoding *old_encoding)
{
	size_t length;
	unsigned char *new_yy_start;

	/* convert and set */
	if (!SCNG(input_filter)) {
		if (SCNG(script_filtered)) {
			efree(SCNG(script_filtered));
			SCNG(script_filtered) = NULL;
		}
		SCNG(script_filtered_size) = 0;
		length = SCNG(script_org_size);
		new_yy_start = SCNG(script_org);
	} else {
		if ((size_t)-1 == SCNG(input_filter)(&new_yy_start, &length, SCNG(script_org), SCNG(script_org_size))) {
			zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
					"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
		}
		if (SCNG(script_filtered)) {
			efree(SCNG(script_filtered));
		}
		SCNG(script_filtered) = new_yy_start;
		SCNG(script_filtered_size) = length;
	}

	SCNG(yy_cursor) = new_yy_start + (SCNG(yy_cursor) - SCNG(yy_start));
	SCNG(yy_marker) = new_yy_start + (SCNG(yy_marker) - SCNG(yy_start));
	SCNG(yy_text) = new_yy_start + (SCNG(yy_text) - SCNG(yy_start));
	SCNG(yy_limit) = new_yy_start + length;

	SCNG(yy_start) = new_yy_start;
}


// TODO: avoid reallocation ???
# define zend_copy_value(zendlval, yytext, yyleng) \
	if (SCNG(output_filter)) { \
		size_t sz = 0; \
		char *s = NULL; \
		SCNG(output_filter)((unsigned char **)&s, &sz, (unsigned char *)yytext, (size_t)yyleng); \
		ZVAL_STRINGL(zendlval, s, sz); \
		efree(s); \
	} else if (yyleng == 1) { \
		ZVAL_INTERNED_STR(zendlval, ZSTR_CHAR((zend_uchar)*(yytext))); \
	} else { \
		ZVAL_STRINGL(zendlval, yytext, yyleng); \
	}

static zend_result zend_scan_escape_string(zval *zendlval, char *str, int len, char quote_type)
{
	char *s, *t;
	char *end;

	if (len <= 1) {
		if (len < 1) {
			ZVAL_EMPTY_STRING(zendlval);
		} else {
			zend_uchar c = (zend_uchar)*str;
			if (c == '\n' || c == '\r') {
				CG(zend_lineno)++;
			}
			ZVAL_INTERNED_STR(zendlval, ZSTR_CHAR(c));
		}
		goto skip_escape_conversion;
	}

	ZVAL_STRINGL(zendlval, str, len);

	/* convert escape sequences */
	s = Z_STRVAL_P(zendlval);
	end = s+Z_STRLEN_P(zendlval);
	while (1) {
		if (UNEXPECTED(*s=='\\')) {
			break;
		}
		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
		if (s == end) {
			goto skip_escape_conversion;
		}
	}

	t = s;
	while (s<end) {
		if (*s=='\\') {
			s++;
			if (s >= end) {
				*t++ = '\\';
				break;
			}

			switch(*s) {
				case 'n':
					*t++ = '\n';
					break;
				case 'r':
					*t++ = '\r';
					break;
				case 't':
					*t++ = '\t';
					break;
				case 'f':
					*t++ = '\f';
					break;
				case 'v':
					*t++ = '\v';
					break;
				case 'e':
#ifdef ZEND_WIN32
					*t++ = VK_ESCAPE;
#else
					*t++ = '\e';
#endif
					break;
				case '"':
				case '`':
					if (*s != quote_type) {
						*t++ = '\\';
						*t++ = *s;
						break;
					}
					ZEND_FALLTHROUGH;
				case '\\':
				case '$':
					*t++ = *s;
					break;
				case 'x':
				case 'X':
					if (ZEND_IS_HEX(*(s+1))) {
						char hex_buf[3] = { 0, 0, 0 };

						hex_buf[0] = *(++s);
						if (ZEND_IS_HEX(*(s+1))) {
							hex_buf[1] = *(++s);
						}
						*t++ = (char) ZEND_STRTOL(hex_buf, NULL, 16);
					} else {
						*t++ = '\\';
						*t++ = *s;
					}
					break;
				/* UTF-8 codepoint escape, format: /\\u\{\x+\}/ */
				case 'u':
					{
						/* cache where we started so we can parse after validating */
						char *start = s + 1;
						size_t len = 0;
						bool valid = 1;
						unsigned long codepoint;

						if (*start != '{') {
							/* we silently let this pass to avoid breaking code
							 * with JSON in string literals (e.g. "\"\u202e\""
							 */
							*t++ = '\\';
							*t++ = 'u';
							break;
						} else {
							/* on the other hand, invalid \u{blah} errors */
							s++;
							len++;
							s++;
							while (*s != '}') {
								if (!ZEND_IS_HEX(*s)) {
									valid = 0;
									break;
								} else {
									len++;
								}
								s++;
							}
							if (*s == '}') {
								valid = 1;
								len++;
							}
						}

						/* \u{} is invalid */
						if (len <= 2) {
							valid = 0;
						}

						if (!valid) {
							zend_throw_exception(zend_ce_parse_error,
								"Invalid UTF-8 codepoint escape sequence", 0);
							zval_ptr_dtor(zendlval);
							ZVAL_UNDEF(zendlval);
							return FAILURE;
						}

						errno = 0;
						codepoint = strtoul(start + 1, NULL, 16);

						/* per RFC 3629, UTF-8 can only represent 21 bits */
						if (codepoint > 0x10FFFF || errno) {
							zend_throw_exception(zend_ce_parse_error,
								"Invalid UTF-8 codepoint escape sequence: Codepoint too large", 0);
							zval_ptr_dtor(zendlval);
							ZVAL_UNDEF(zendlval);
							return FAILURE;
						}

						/* based on https://en.wikipedia.org/wiki/UTF-8#Sample_code */
						if (codepoint < 0x80) {
							*t++ = codepoint;
						} else if (codepoint <= 0x7FF) {
							*t++ = (codepoint >> 6) + 0xC0;
							*t++ = (codepoint & 0x3F) + 0x80;
						} else if (codepoint <= 0xFFFF) {
							*t++ = (codepoint >> 12) + 0xE0;
							*t++ = ((codepoint >> 6) & 0x3F) + 0x80;
							*t++ = (codepoint & 0x3F) + 0x80;
						} else if (codepoint <= 0x10FFFF) {
							*t++ = (codepoint >> 18) + 0xF0;
							*t++ = ((codepoint >> 12) & 0x3F) + 0x80;
							*t++ = ((codepoint >> 6) & 0x3F) + 0x80;
							*t++ = (codepoint & 0x3F) + 0x80;
						}
					}
					break;
				default:
					/* check for an octal */
					if (ZEND_IS_OCT(*s)) {
						char octal_buf[4] = { 0, 0, 0, 0 };

						octal_buf[0] = *s;
						if (ZEND_IS_OCT(*(s+1))) {
							octal_buf[1] = *(++s);
							if (ZEND_IS_OCT(*(s+1))) {
								octal_buf[2] = *(++s);
							}
						}
						if (octal_buf[2] && (octal_buf[0] > '3') && !SCNG(heredoc_scan_ahead)) {
							/* 3 octit values must not overflow 0xFF (\377) */
							zend_error(E_COMPILE_WARNING, "Octal escape sequence overflow \\%s is greater than \\377", octal_buf);
						}

						*t++ = (char) ZEND_STRTOL(octal_buf, NULL, 8);
					} else {
						*t++ = '\\';
						*t++ = *s;
					}
					break;
			}
		} else {
			*t++ = *s;
		}

		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
	}
	*t = 0;
	Z_STRLEN_P(zendlval) = t - Z_STRVAL_P(zendlval);

skip_escape_conversion:
	if (SCNG(output_filter)) {
		size_t sz = 0;
		unsigned char *str;
		// TODO: avoid realocation ???
		s = Z_STRVAL_P(zendlval);
		SCNG(output_filter)(&str, &sz, (unsigned char *)s, (size_t)Z_STRLEN_P(zendlval));
		zval_ptr_dtor(zendlval);
		ZVAL_STRINGL(zendlval, (char *) str, sz);
		efree(str);
	}
	return SUCCESS;
}

#define HEREDOC_USING_SPACES 1
#define HEREDOC_USING_TABS 2

static const char *next_newline(const char *str, const char *end, size_t *newline_len) {
	for (; str < end; str++) {
		if (*str == '\r') {
			*newline_len = str + 1 < end && *(str + 1) == '\n' ? 2 : 1;
			return str;
		} else if (*str == '\n') {
			*newline_len = 1;
			return str;
		}
	}
	*newline_len = 0;
	return NULL;
}

static bool strip_multiline_string_indentation(
	zval *zendlval, int indentation, bool using_spaces,
	bool newline_at_start, bool newline_at_end)
{
	const char *str = Z_STRVAL_P(zendlval), *end = str + Z_STRLEN_P(zendlval);
	char *copy = Z_STRVAL_P(zendlval);

	int newline_count = 0;
	size_t newline_len;
	const char *nl;

	if (!newline_at_start) {
		nl = next_newline(str, end, &newline_len);
		if (!nl) {
			return 1;
		}

		str = nl + newline_len;
		copy = (char *) nl + newline_len;
		newline_count++;
	} else {
		nl = str;
	}

	/* <= intentional */
	while (str <= end && nl) {
		size_t skip;
		nl = next_newline(str, end, &newline_len);
		if (!nl && newline_at_end) {
			nl = end;
		}

		/* Try to skip indentation */
		for (skip = 0; skip < indentation; skip++, str++) {
			if (str == nl) {
				/* Don't require full indentation on whitespace-only lines */
				break;
			}

			if (str == end || (*str != ' ' && *str != '\t')) {
				CG(zend_lineno) += newline_count;
				zend_throw_exception_ex(zend_ce_parse_error, 0,
					"Invalid body indentation level (expecting an indentation level of at least %d)", indentation);
				goto error;
			}

			if ((!using_spaces && *str == ' ') || (using_spaces && *str == '\t')) {
				CG(zend_lineno) += newline_count;
				zend_throw_exception(zend_ce_parse_error,
					"Invalid indentation - tabs and spaces cannot be mixed", 0);
				goto error;
			}
		}

		if (str == end) {
			break;
		}

		size_t len = nl ? (nl - str + newline_len) : (end - str);
		memmove(copy, str, len);
		str += len;
		copy += len;
		newline_count++;
	}

	*copy = '\0';
	Z_STRLEN_P(zendlval) = copy - Z_STRVAL_P(zendlval);
	return 1;

error:
	zval_ptr_dtor_str(zendlval);
	ZVAL_UNDEF(zendlval);

	return 0;
}

static void copy_heredoc_label_stack(void *void_heredoc_label)
{
	zend_heredoc_label *heredoc_label = void_heredoc_label;
	zend_heredoc_label *new_heredoc_label = emalloc(sizeof(zend_heredoc_label));

	*new_heredoc_label = *heredoc_label;
	new_heredoc_label->label = estrndup(heredoc_label->label, heredoc_label->length);

	zend_ptr_stack_push(&SCNG(heredoc_label_stack), (void *) new_heredoc_label);
}

/* Check that { }, [ ], ( ) are nested correctly */
static void report_bad_nesting(char opening, int opening_lineno, char closing)
{
	char   buf[256];
	size_t used = 0;

	used = snprintf(buf, sizeof(buf), "Unclosed '%c'", opening);

	if (opening_lineno != CG(zend_lineno)) {
		used += snprintf(buf + used, sizeof(buf) - used, " on line %d", opening_lineno);
	}

	if (closing) { 	/* 'closing' will be 0 if at end of file */
		used += snprintf(buf + used, sizeof(buf) - used, " does not match '%c'", closing);
	}

	zend_throw_exception(zend_ce_parse_error, buf, 0);
}

static void enter_nesting(char opening)
{
	zend_nest_location nest_loc = {opening, CG(zend_lineno)};
	zend_stack_push(&SCNG(nest_location_stack), &nest_loc);
}

static zend_result exit_nesting(char closing)
{
	if (zend_stack_is_empty(&SCNG(nest_location_stack))) {
		zend_throw_exception_ex(zend_ce_parse_error, 0, "Unmatched '%c'", closing);
		return FAILURE;
	}

	zend_nest_location *nest_loc = zend_stack_top(&SCNG(nest_location_stack));
	char opening = nest_loc->text;

	if ((opening == '{' && closing != '}') ||
	    (opening == '[' && closing != ']') ||
	    (opening == '(' && closing != ')')) {
		report_bad_nesting(opening, nest_loc->lineno, closing);
		return FAILURE;
	}

	zend_stack_del_top(&SCNG(nest_location_stack));
	return SUCCESS;
}

static zend_result check_nesting_at_end(void)
{
	if (!zend_stack_is_empty(&SCNG(nest_location_stack))) {
		zend_nest_location *nest_loc = zend_stack_top(&SCNG(nest_location_stack));
		report_bad_nesting(nest_loc->text, nest_loc->lineno, 0);
		return FAILURE;
	}

	return SUCCESS;
}

#define PARSER_MODE() \
	EXPECTED(elem != NULL)

#define RETURN_TOKEN(_token) do { \
		token = _token; \
		goto emit_token; \
	} while (0)

#define RETURN_TOKEN_WITH_VAL(_token) do { \
		token = _token; \
		goto emit_token_with_val; \
	} while (0)

#define RETURN_TOKEN_WITH_STR(_token, _offset) do { \
		token = _token; \
		offset = _offset; \
		goto emit_token_with_str; \
	} while (0)

#define RETURN_TOKEN_WITH_IDENT(_token) do { \
		token = _token; \
		goto emit_token_with_ident; \
	} while (0)

#define RETURN_OR_SKIP_TOKEN(_token) do { \
		token = _token; \
		if (PARSER_MODE()) { \
			goto skip_token; \
		} \
		goto emit_token; \
	} while (0)

#define RETURN_EXIT_NESTING_TOKEN(_token) do { \
		if (exit_nesting(_token) != SUCCESS && PARSER_MODE()) { \
			RETURN_TOKEN(T_ERROR); \
		} else { \
			RETURN_TOKEN(_token); \
		} \
	} while(0)

#define RETURN_END_TOKEN do { \
		if (check_nesting_at_end() != SUCCESS && PARSER_MODE()) { \
			RETURN_TOKEN(T_ERROR); \
		} else { \
			RETURN_TOKEN(END); \
		} \
	} while (0)

int ZEND_FASTCALL lex_scan(zval *zendlval, zend_parser_stack_elem *elem)
{
int token;
int offset;
int start_line = CG(zend_lineno);

	ZVAL_UNDEF(zendlval);
restart:
	SCNG(yy_text) = YYCURSOR;


{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	if (YYGETCONDITION() < 5) {
		if (YYGETCONDITION() < 2) {
			if (YYGETCONDITION() < 1) {
				goto yyc_ST_IN_SCRIPTING;
			} else {
				goto yyc_ST_LOOKING_FOR_PROPERTY;
			}
		} else {
			if (YYGETCONDITION() < 3) {
				goto yyc_ST_BACKQUOTE;
			} else {
				if (YYGETCONDITION() < 4) {
					goto yyc_ST_DOUBLE_QUOTES;
				} else {
					goto yyc_ST_HEREDOC;
				}
			}
		}
	} else {
		if (YYGETCONDITION() < 8) {
			if (YYGETCONDITION() < 6) {
				goto yyc_ST_LOOKING_FOR_VARNAME;
			} else {
				if (YYGETCONDITION() < 7) {
					goto yyc_ST_VAR_OFFSET;
				} else {
					goto yyc_SHEBANG;
				}
			}
		} else {
			if (YYGETCONDITION() < 9) {
				goto yyc_INITIAL;
			} else {
				if (YYGETCONDITION() < 10) {
					goto yyc_ST_END_HEREDOC;
				} else {
					goto yyc_ST_NOWDOC;
				}
			}
		}
	}
/* *********************************** */
yyc_ST_IN_SCRIPTING:
	{
		static const unsigned char yybm[] = {
			/* table 1 .. 8: 0 */
			  0, 134, 134, 134, 134, 134, 134, 134, 
			134, 135,   4, 134, 134,   4, 134, 134, 
			134, 134, 134, 134, 134, 134, 134, 134, 
			134, 134, 134, 134, 134, 134, 134, 134, 
			135, 134, 134, 134, 134, 134, 134, 134, 
			134, 134,  66, 134, 134, 134, 134, 134, 
			190, 190, 182, 182, 182, 182, 182, 182, 
			166, 166, 134, 134, 134, 134, 134, 134, 
			134, 166, 166, 166, 166, 166, 166, 134, 
			134, 134, 134, 134, 134, 134, 134, 134, 
			134, 134, 134, 134, 134, 134, 134, 134, 
			134, 134, 134, 134, 134, 134, 134, 134, 
			134, 166, 166, 166, 166, 166, 166, 134, 
			134, 134, 134, 134, 134, 134, 134, 134, 
			134, 134, 134, 134, 134, 134, 134, 134, 
			134, 134, 134, 134, 134, 134, 134, 134, 
			134, 134, 134, 134, 134, 134, 134, 134, 
			134, 134, 134, 134, 134, 134, 134, 134, 
			134, 134, 134, 134, 134, 134, 134, 134, 
			134, 134, 134, 134, 134, 134, 134, 134, 
			134, 134, 134, 134, 134, 134, 134, 134, 
			134, 134, 134, 134, 134, 134, 134, 134, 
			134, 134, 134, 134, 134, 134, 134, 134, 
			134, 134, 134, 134, 134, 134, 134, 134, 
			134, 134, 134, 134, 134, 134, 134, 134, 
			134, 134, 134, 134, 134, 134, 134, 134, 
			134, 134, 134, 134, 134, 134, 134, 134, 
			134, 134, 134, 134, 134, 134, 134, 134, 
			134, 134, 134, 134, 134, 134, 134, 134, 
			134, 134, 134, 134, 134, 134, 134, 134, 
			134, 134, 134, 134, 134, 134, 134, 134, 
			134, 134, 134, 134, 134, 134, 134, 134, 
			/* table 9 .. 11: 256 */
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,  32,  32,   0,   0,  32,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 32,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			192, 192, 192, 192, 192, 192, 192, 192, 
			192, 192,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(0, *YYCURSOR);
		YYFILL(16);
		yych = *YYCURSOR;
		if (yybm[256+yych] & 32) {
			goto yy4;
		}
		switch (yych) {
		case 0x00:
		case 0x01:
		case 0x02:
		case 0x03:
		case 0x04:
		case 0x05:
		case 0x06:
		case 0x07:
		case 0x08:
		case '\t':
		case '\n':
		case '\v':
		case '\f':
		case '\r':
		case 0x0E:
		case 0x0F:
		case 0x10:
		case 0x11:
		case 0x12:
		case 0x13:
		case 0x14:
		case 0x15:
		case 0x16:
		case 0x17:
		case 0x18:
		case 0x19:
		case 0x1A:
		case 0x1B:
		case 0x1C:
		case 0x1D:
		case 0x1E:
		case 0x1F:
		case 0x7F:	goto yy2;
		case ' ':
		case '!':	goto yy7;
		case '"':	goto yy9;
		case '#':	goto yy11;
		case '$':	goto yy13;
		case '%':	goto yy14;
		case '&':	goto yy15;
		case '\'':	goto yy17;
		case '(':	goto yy19;
		case ')':
		case ']':	goto yy21;
		case '*':	goto yy23;
		case '+':	goto yy24;
		case ',':
		case ';':
		case '@':
		case '~':	goto yy25;
		case '-':	goto yy26;
		case '.':	goto yy27;
		case '/':	goto yy28;
		case '0':	goto yy29;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':	goto yy31;
		case ':':	goto yy33;
		case '<':	goto yy34;
		case '=':	goto yy35;
		case '>':	goto yy36;
		case '?':	goto yy37;
		case 'A':
		case 'a':	goto yy38;
		case 'B':
		case 'b':	goto yy40;
		case 'C':
		case 'c':	goto yy41;
		case 'D':
		case 'd':	goto yy42;
		case 'E':
		case 'e':	goto yy43;
		case 'F':
		case 'f':	goto yy44;
		case 'G':
		case 'g':	goto yy45;
		case 'I':
		case 'i':	goto yy48;
		case 'L':
		case 'l':	goto yy49;
		case 'M':
		case 'm':	goto yy50;
		case 'N':
		case 'n':	goto yy51;
		case 'O':
		case 'o':	goto yy52;
		case 'P':
		case 'p':	goto yy53;
		case 'R':
		case 'r':	goto yy54;
		case 'S':
		case 's':	goto yy55;
		case 'T':
		case 't':	goto yy56;
		case 'U':
		case 'u':	goto yy57;
		case 'V':
		case 'v':	goto yy58;
		case 'W':
		case 'w':	goto yy59;
		case 'X':
		case 'x':	goto yy60;
		case 'Y':
		case 'y':	goto yy61;
		case '[':	goto yy62;
		case '\\':	goto yy63;
		case '^':	goto yy65;
		case '_':	goto yy66;
		case '`':	goto yy67;
		case '{':	goto yy69;
		case '|':	goto yy71;
		case '}':	goto yy72;
		default:	goto yy46;
		}
yy2:
		YYDEBUG(2, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(3, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (YYCURSOR > YYLIMIT) {
		RETURN_END_TOKEN;
	}

	RETURN_TOKEN(T_BAD_CHARACTER);
}
yy4:
		YYDEBUG(4, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(5, *YYCURSOR);
		if (yybm[256+yych] & 32) {
			goto yy4;
		}
		YYDEBUG(6, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	goto return_whitespace;
}
yy7:
		YYDEBUG(7, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy74;
yy8:
		YYDEBUG(8, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(yytext[0]);
}
yy9:
		YYDEBUG(9, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(10, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	int bprefix = (yytext[0] != '"') ? 1 : 0;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				yyleng = YYCURSOR - SCNG(yy_text);
				if (EXPECTED(zend_scan_escape_string(zendlval, yytext+bprefix+1, yyleng-bprefix-2, '"') == SUCCESS)
				 || !PARSER_MODE()) {
					RETURN_TOKEN_WITH_VAL(T_CONSTANT_ENCAPSED_STRING);
				} else {
					RETURN_TOKEN(T_ERROR);
				}
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				ZEND_FALLTHROUGH;
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	/* Remember how much was scanned to save rescanning */
	SET_DOUBLE_QUOTES_SCANNED_LENGTH(YYCURSOR - SCNG(yy_text) - yyleng);

	YYCURSOR = SCNG(yy_text) + yyleng;

	BEGIN(ST_DOUBLE_QUOTES);
	RETURN_TOKEN('"');
}
yy11:
		YYDEBUG(11, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '[') goto yy76;
yy12:
		YYDEBUG(12, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
			case '\n':
				YYCURSOR--;
				break;
			case '?':
				if (*YYCURSOR == '>') {
					YYCURSOR--;
					break;
				}
				ZEND_FALLTHROUGH;
			default:
				continue;
		}

		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);
	RETURN_OR_SKIP_TOKEN(T_COMMENT);
}
yy13:
		YYDEBUG(13, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy8;
			if (yych <= 'Z') goto yy78;
			if (yych <= '^') goto yy8;
			goto yy78;
		} else {
			if (yych <= '`') goto yy8;
			if (yych <= 'z') goto yy78;
			if (yych <= 0x7F) goto yy8;
			goto yy78;
		}
yy14:
		YYDEBUG(14, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy81;
		goto yy8;
yy15:
		YYDEBUG(15, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '"') {
			if (yych <= '\f') {
				if (yych <= 0x08) goto yy16;
				if (yych <= '\n') goto yy84;
			} else {
				if (yych <= '\r') goto yy84;
				if (yych == ' ') goto yy84;
			}
		} else {
			if (yych <= '-') {
				if (yych <= '$') goto yy84;
				if (yych == '&') goto yy89;
			} else {
				if (yych <= '/') goto yy84;
				if (yych == '=') goto yy93;
			}
		}
yy16:
		YYDEBUG(16, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_AMPERSAND_NOT_FOLLOWED_BY_VAR_OR_VARARG);
}
yy17:
		YYDEBUG(17, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(18, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	char *s, *t;
	char *end;
	int bprefix = (yytext[0] != '\'') ? 1 : 0;

	while (1) {
		if (YYCURSOR < YYLIMIT) {
			if (*YYCURSOR == '\'') {
				YYCURSOR++;
				yyleng = YYCURSOR - SCNG(yy_text);

				break;
			} else if (*YYCURSOR++ == '\\' && YYCURSOR < YYLIMIT) {
				YYCURSOR++;
			}
		} else {
			yyleng = YYLIMIT - SCNG(yy_text);

			/* Unclosed single quotes; treat similar to double quotes, but without a separate token
			 * for ' (unrecognized by parser), instead of old flex fallback to "Unexpected character..."
			 * rule, which continued in ST_IN_SCRIPTING state after the quote */
			ZVAL_NULL(zendlval);
			RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
		}
	}

	if (yyleng-bprefix-2 <= 1) {
		if (yyleng-bprefix-2 < 1) {
			ZVAL_EMPTY_STRING(zendlval);
		} else {
			zend_uchar c = (zend_uchar)*(yytext+bprefix+1);
			if (c == '\n' || c == '\r') {
				CG(zend_lineno)++;
			}
			ZVAL_INTERNED_STR(zendlval, ZSTR_CHAR(c));
		}
		goto skip_escape_conversion;
	}
	ZVAL_STRINGL(zendlval, yytext+bprefix+1, yyleng-bprefix-2);

	/* convert escape sequences */
	s = Z_STRVAL_P(zendlval);
	end = s+Z_STRLEN_P(zendlval);
	while (1) {
		if (UNEXPECTED(*s=='\\')) {
			break;
		}
		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
		if (s == end) {
			goto skip_escape_conversion;
		}
	}

	t = s;
	while (s<end) {
		if (*s=='\\') {
			s++;
			if (*s == '\\' || *s == '\'') {
				*t++ = *s;
			} else {
				*t++ = '\\';
				*t++ = *s;
			}
		} else {
			*t++ = *s;
		}
		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
	}
	*t = 0;
	Z_STRLEN_P(zendlval) = t - Z_STRVAL_P(zendlval);

skip_escape_conversion:
	if (SCNG(output_filter)) {
		size_t sz = 0;
		char *str = NULL;
		zend_string *new_str;
		s = Z_STRVAL_P(zendlval);
		// TODO: avoid reallocation ???
		SCNG(output_filter)((unsigned char **)&str, &sz, (unsigned char *)s, (size_t)Z_STRLEN_P(zendlval));
		new_str = zend_string_init(str, sz, 0);
		if (str != s) {
			efree(str);
		}
		zend_string_release_ex(Z_STR_P(zendlval), 0);
		ZVAL_STR(zendlval, new_str);
	}
	RETURN_TOKEN_WITH_VAL(T_CONSTANT_ENCAPSED_STRING);
}
yy19:
		YYDEBUG(19, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'S') {
			if (yych <= 'D') {
				if (yych <= ' ') {
					if (yych == '\t') goto yy96;
					if (yych >= ' ') goto yy96;
				} else {
					if (yych <= '@') goto yy20;
					if (yych != 'C') goto yy96;
				}
			} else {
				if (yych <= 'I') {
					if (yych == 'F') goto yy96;
					if (yych >= 'I') goto yy96;
				} else {
					if (yych == 'O') goto yy96;
					if (yych >= 'R') goto yy96;
				}
			}
		} else {
			if (yych <= 'f') {
				if (yych <= 'b') {
					if (yych == 'U') goto yy96;
					if (yych >= 'a') goto yy96;
				} else {
					if (yych == 'd') goto yy96;
					if (yych >= 'f') goto yy96;
				}
			} else {
				if (yych <= 'o') {
					if (yych == 'i') goto yy96;
					if (yych >= 'o') goto yy96;
				} else {
					if (yych <= 's') {
						if (yych >= 'r') goto yy96;
					} else {
						if (yych == 'u') goto yy96;
					}
				}
			}
		}
yy20:
		YYDEBUG(20, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	enter_nesting(yytext[0]);
	RETURN_TOKEN(yytext[0]);
}
yy21:
		YYDEBUG(21, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(22, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* Check that ] and ) match up properly with a preceding [ or ( */
	RETURN_EXIT_NESTING_TOKEN(yytext[0]);
}
yy23:
		YYDEBUG(23, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '*') goto yy106;
		if (yych == '=') goto yy108;
		goto yy8;
yy24:
		YYDEBUG(24, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '+') goto yy110;
		if (yych == '=') goto yy112;
		goto yy8;
yy25:
		YYDEBUG(25, *YYCURSOR);
		++YYCURSOR;
		goto yy8;
yy26:
		YYDEBUG(26, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') {
			if (yych == '-') goto yy114;
			goto yy8;
		} else {
			if (yych <= '=') goto yy116;
			if (yych <= '>') goto yy118;
			goto yy8;
		}
yy27:
		YYDEBUG(27, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') {
			if (yych == '.') goto yy120;
			goto yy8;
		} else {
			if (yych <= '9') goto yy121;
			if (yych == '=') goto yy124;
			goto yy8;
		}
yy28:
		YYDEBUG(28, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '.') {
			if (yych == '*') goto yy126;
			goto yy8;
		} else {
			if (yych <= '/') goto yy128;
			if (yych == '=') goto yy129;
			goto yy8;
		}
yy29:
		YYDEBUG(29, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'X') {
			if (yych <= 'N') {
				if (yych == 'B') goto yy132;
				goto yy32;
			} else {
				if (yych <= 'O') goto yy134;
				if (yych <= 'W') goto yy32;
				goto yy135;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'b') goto yy132;
				goto yy32;
			} else {
				if (yych <= 'o') goto yy134;
				if (yych == 'x') goto yy135;
				goto yy32;
			}
		}
yy30:
		YYDEBUG(30, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	size_t len = yyleng;
	char *end, *lnum = yytext;
	bool is_octal = lnum[0] == '0';
	bool contains_underscores = (memchr(lnum, '_', len) != NULL);

	if (contains_underscores) {
		lnum = estrndup(lnum, len);
		strip_underscores(lnum, &len);
	}

	/* Digits 8 and 9 are illegal in octal literals. */
	if (is_octal) {
		size_t i;
		for (i = 0; i < len; i++) {
			if (lnum[i] == '8' || lnum[i] == '9') {
				zend_throw_exception(zend_ce_parse_error, "Invalid numeric literal", 0);
				if (PARSER_MODE()) {
					if (contains_underscores) {
						efree(lnum);
					}
					ZVAL_UNDEF(zendlval);
					RETURN_TOKEN(T_ERROR);
				}

				/* Continue in order to determine if this is T_LNUMBER or T_DNUMBER. */
				len = i;
				break;
			}
		}
	}


	if (len < MAX_LENGTH_OF_LONG - 1) { /* Won't overflow */
		errno = 0;
		/* base must be passed explicitly for correct parse error on Windows */
		ZVAL_LONG(zendlval, ZEND_STRTOL(lnum, &end, is_octal ? 8 : 10));
		ZEND_ASSERT(end == lnum + len);
	} else {
		errno = 0;
		ZVAL_LONG(zendlval, ZEND_STRTOL(lnum, &end, 0));
		if (errno == ERANGE) { /* Overflow */
			errno = 0;
			if (is_octal) { /* octal overflow */
				ZVAL_DOUBLE(zendlval, zend_oct_strtod(lnum, (const char **)&end));
			} else {
				ZVAL_DOUBLE(zendlval, zend_strtod(lnum, (const char **)&end));
			}
			ZEND_ASSERT(end == lnum + len);
			if (contains_underscores) {
				efree(lnum);
			}
			RETURN_TOKEN_WITH_VAL(T_DNUMBER);
		}
		ZEND_ASSERT(end == lnum + len);
	}
	ZEND_ASSERT(!errno);
	if (contains_underscores) {
		efree(lnum);
	}
	RETURN_TOKEN_WITH_VAL(T_LNUMBER);
}
yy31:
		YYDEBUG(31, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy32:
		YYDEBUG(32, *YYCURSOR);
		if (yybm[256+yych] & 64) {
			goto yy31;
		}
		if (yych <= 'E') {
			if (yych == '.') goto yy131;
			if (yych <= 'D') goto yy30;
			goto yy133;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy30;
				goto yy136;
			} else {
				if (yych == 'e') goto yy133;
				goto yy30;
			}
		}
yy33:
		YYDEBUG(33, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == ':') goto yy137;
		goto yy8;
yy34:
		YYDEBUG(34, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= ';') goto yy8;
		if (yych <= '<') goto yy139;
		if (yych <= '=') goto yy141;
		if (yych <= '>') goto yy143;
		goto yy8;
yy35:
		YYDEBUG(35, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy8;
		if (yych <= '=') goto yy144;
		if (yych <= '>') goto yy146;
		goto yy8;
yy36:
		YYDEBUG(36, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy8;
		if (yych <= '=') goto yy148;
		if (yych <= '>') goto yy150;
		goto yy8;
yy37:
		YYDEBUG(37, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych == '-') goto yy152;
			goto yy8;
		} else {
			if (yych <= '>') goto yy153;
			if (yych <= '?') goto yy155;
			goto yy8;
		}
yy38:
		YYDEBUG(38, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'S') {
			if (yych <= 'M') {
				if (yych == 'B') goto yy157;
				goto yy47;
			} else {
				if (yych <= 'N') goto yy158;
				if (yych <= 'Q') goto yy47;
				if (yych <= 'R') goto yy159;
				goto yy160;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'b') goto yy157;
				if (yych <= 'm') goto yy47;
				goto yy158;
			} else {
				if (yych <= 'q') goto yy47;
				if (yych <= 'r') goto yy159;
				if (yych <= 's') goto yy160;
				goto yy47;
			}
		}
yy39:
		YYDEBUG(39, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_STRING, 0);
}
yy40:
		YYDEBUG(40, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ';') {
			if (yych <= '"') {
				if (yych <= '!') goto yy47;
				goto yy9;
			} else {
				if (yych == '\'') goto yy17;
				goto yy47;
			}
		} else {
			if (yych <= 'R') {
				if (yych <= '<') goto yy163;
				if (yych <= 'Q') goto yy47;
				goto yy164;
			} else {
				if (yych == 'r') goto yy164;
				goto yy47;
			}
		}
yy41:
		YYDEBUG(41, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'O') {
			if (yych <= 'K') {
				if (yych == 'A') goto yy165;
				goto yy47;
			} else {
				if (yych <= 'L') goto yy166;
				if (yych <= 'N') goto yy47;
				goto yy167;
			}
		} else {
			if (yych <= 'k') {
				if (yych == 'a') goto yy165;
				goto yy47;
			} else {
				if (yych <= 'l') goto yy166;
				if (yych == 'o') goto yy167;
				goto yy47;
			}
		}
yy42:
		YYDEBUG(42, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'O') {
			if (yych <= 'H') {
				if (yych == 'E') goto yy168;
				goto yy47;
			} else {
				if (yych <= 'I') goto yy169;
				if (yych <= 'N') goto yy47;
				goto yy170;
			}
		} else {
			if (yych <= 'h') {
				if (yych == 'e') goto yy168;
				goto yy47;
			} else {
				if (yych <= 'i') goto yy169;
				if (yych == 'o') goto yy170;
				goto yy47;
			}
		}
yy43:
		YYDEBUG(43, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		switch (yych) {
		case 'C':
		case 'c':	goto yy172;
		case 'L':
		case 'l':	goto yy173;
		case 'M':
		case 'm':	goto yy174;
		case 'N':
		case 'n':	goto yy175;
		case 'V':
		case 'v':	goto yy176;
		case 'X':
		case 'x':	goto yy177;
		default:	goto yy47;
		}
yy44:
		YYDEBUG(44, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'U') {
			if (yych <= 'M') {
				if (yych == 'I') goto yy178;
				goto yy47;
			} else {
				if (yych <= 'N') goto yy179;
				if (yych <= 'O') goto yy181;
				if (yych <= 'T') goto yy47;
				goto yy182;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'i') goto yy178;
				if (yych <= 'm') goto yy47;
				goto yy179;
			} else {
				if (yych <= 'o') goto yy181;
				if (yych == 'u') goto yy182;
				goto yy47;
			}
		}
yy45:
		YYDEBUG(45, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'O') {
			if (yych == 'L') goto yy183;
			if (yych <= 'N') goto yy47;
			goto yy184;
		} else {
			if (yych <= 'l') {
				if (yych <= 'k') goto yy47;
				goto yy183;
			} else {
				if (yych == 'o') goto yy184;
				goto yy47;
			}
		}
yy46:
		YYDEBUG(46, *YYCURSOR);
		yyaccept = 4;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy47:
		YYDEBUG(47, *YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
		goto yy39;
yy48:
		YYDEBUG(48, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'S') {
			if (yych <= 'L') {
				if (yych == 'F') goto yy185;
				goto yy47;
			} else {
				if (yych <= 'M') goto yy187;
				if (yych <= 'N') goto yy188;
				if (yych <= 'R') goto yy47;
				goto yy189;
			}
		} else {
			if (yych <= 'm') {
				if (yych == 'f') goto yy185;
				if (yych <= 'l') goto yy47;
				goto yy187;
			} else {
				if (yych <= 'n') goto yy188;
				if (yych == 's') goto yy189;
				goto yy47;
			}
		}
yy49:
		YYDEBUG(49, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy190;
		if (yych == 'i') goto yy190;
		goto yy47;
yy50:
		YYDEBUG(50, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy191;
		if (yych == 'a') goto yy191;
		goto yy47;
yy51:
		YYDEBUG(51, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'E') {
			if (yych == 'A') goto yy192;
			if (yych <= 'D') goto yy47;
			goto yy193;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy47;
				goto yy192;
			} else {
				if (yych == 'e') goto yy193;
				goto yy47;
			}
		}
yy52:
		YYDEBUG(52, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy194;
		if (yych == 'r') goto yy194;
		goto yy47;
yy53:
		YYDEBUG(53, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'U') {
			if (yych == 'R') goto yy196;
			if (yych <= 'T') goto yy47;
			goto yy197;
		} else {
			if (yych <= 'r') {
				if (yych <= 'q') goto yy47;
				goto yy196;
			} else {
				if (yych == 'u') goto yy197;
				goto yy47;
			}
		}
yy54:
		YYDEBUG(54, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy198;
		if (yych == 'e') goto yy198;
		goto yy47;
yy55:
		YYDEBUG(55, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'W') {
			if (yych == 'T') goto yy199;
			if (yych <= 'V') goto yy47;
			goto yy200;
		} else {
			if (yych <= 't') {
				if (yych <= 's') goto yy47;
				goto yy199;
			} else {
				if (yych == 'w') goto yy200;
				goto yy47;
			}
		}
yy56:
		YYDEBUG(56, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'R') {
			if (yych == 'H') goto yy201;
			if (yych <= 'Q') goto yy47;
			goto yy202;
		} else {
			if (yych <= 'h') {
				if (yych <= 'g') goto yy47;
				goto yy201;
			} else {
				if (yych == 'r') goto yy202;
				goto yy47;
			}
		}
yy57:
		YYDEBUG(57, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'S') {
			if (yych == 'N') goto yy203;
			if (yych <= 'R') goto yy47;
			goto yy204;
		} else {
			if (yych <= 'n') {
				if (yych <= 'm') goto yy47;
				goto yy203;
			} else {
				if (yych == 's') goto yy204;
				goto yy47;
			}
		}
yy58:
		YYDEBUG(58, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy205;
		if (yych == 'a') goto yy205;
		goto yy47;
yy59:
		YYDEBUG(59, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy206;
		if (yych == 'h') goto yy206;
		goto yy47;
yy60:
		YYDEBUG(60, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy207;
		if (yych == 'o') goto yy207;
		goto yy47;
yy61:
		YYDEBUG(61, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy208;
		if (yych == 'i') goto yy208;
		goto yy47;
yy62:
		YYDEBUG(62, *YYCURSOR);
		++YYCURSOR;
		goto yy20;
yy63:
		YYDEBUG(63, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy64;
			if (yych <= 'Z') goto yy209;
			if (yych >= '_') goto yy209;
		} else {
			if (yych <= '`') goto yy64;
			if (yych <= 'z') goto yy209;
			if (yych >= 0x80) goto yy209;
		}
yy64:
		YYDEBUG(64, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_NS_SEPARATOR);
}
yy65:
		YYDEBUG(65, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy212;
		goto yy8;
yy66:
		YYDEBUG(66, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy214;
		goto yy47;
yy67:
		YYDEBUG(67, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(68, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(ST_BACKQUOTE);
	RETURN_TOKEN('`');
}
yy69:
		YYDEBUG(69, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(70, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_IN_SCRIPTING);
	enter_nesting('{');
	RETURN_TOKEN('{');
}
yy71:
		YYDEBUG(71, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy215;
		if (yych == '|') goto yy217;
		goto yy8;
yy72:
		YYDEBUG(72, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(73, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RESET_DOC_COMMENT();
	if (!zend_stack_is_empty(&SCNG(state_stack))) {
		yy_pop_state();
	}
	RETURN_EXIT_NESTING_TOKEN('}');
}
yy74:
		YYDEBUG(74, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy219;
yy75:
		YYDEBUG(75, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_NOT_EQUAL);
}
yy76:
		YYDEBUG(76, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(77, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	enter_nesting('[');
	RETURN_TOKEN(T_ATTRIBUTE);
}
yy78:
		YYDEBUG(78, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(79, *YYCURSOR);
		if (yych <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy78;
			} else {
				if (yych <= '@') goto yy80;
				if (yych <= 'Z') goto yy78;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy78;
			} else {
				if (yych <= 'z') goto yy78;
				if (yych >= 0x80) goto yy78;
			}
		}
yy80:
		YYDEBUG(80, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy81:
		YYDEBUG(81, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(82, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_MOD_EQUAL);
}
yy83:
		YYDEBUG(83, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy84:
		YYDEBUG(84, *YYCURSOR);
		if (yych <= ' ') {
			if (yych <= '\f') {
				if (yych <= 0x08) goto yy85;
				if (yych <= '\n') goto yy83;
			} else {
				if (yych <= '\r') goto yy83;
				if (yych >= ' ') goto yy83;
			}
		} else {
			if (yych <= '$') {
				if (yych <= '"') goto yy85;
				if (yych <= '#') goto yy86;
				goto yy87;
			} else {
				if (yych <= '-') goto yy85;
				if (yych <= '.') goto yy91;
				if (yych <= '/') goto yy92;
			}
		}
yy85:
		YYDEBUG(85, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 47) {
			if (yyaccept <= 23) {
				if (yyaccept <= 11) {
					if (yyaccept <= 5) {
						if (yyaccept <= 2) {
							if (yyaccept <= 1) {
								if (yyaccept == 0) {
									goto yy16;
								} else {
									goto yy20;
								}
							} else {
								goto yy8;
							}
						} else {
							if (yyaccept <= 4) {
								if (yyaccept == 3) {
									goto yy30;
								} else {
									goto yy39;
								}
							} else {
								goto yy123;
							}
						}
					} else {
						if (yyaccept <= 8) {
							if (yyaccept <= 7) {
								if (yyaccept == 6) {
									goto yy127;
								} else {
									goto yy140;
								}
							} else {
								goto yy161;
							}
						} else {
							if (yyaccept <= 10) {
								if (yyaccept == 9) {
									goto yy171;
								} else {
									goto yy180;
								}
							} else {
								goto yy186;
							}
						}
					}
				} else {
					if (yyaccept <= 17) {
						if (yyaccept <= 14) {
							if (yyaccept <= 13) {
								if (yyaccept == 12) {
									goto yy195;
								} else {
									goto yy211;
								}
							} else {
								goto yy246;
							}
						} else {
							if (yyaccept <= 16) {
								if (yyaccept == 15) {
									goto yy252;
								} else {
									goto yy255;
								}
							} else {
								goto yy274;
							}
						}
					} else {
						if (yyaccept <= 20) {
							if (yyaccept <= 19) {
								if (yyaccept == 18) {
									goto yy278;
								} else {
									goto yy290;
								}
							} else {
								goto yy301;
							}
						} else {
							if (yyaccept <= 22) {
								if (yyaccept == 21) {
									goto yy314;
								} else {
									goto yy326;
								}
							} else {
								goto yy329;
							}
						}
					}
				}
			} else {
				if (yyaccept <= 35) {
					if (yyaccept <= 29) {
						if (yyaccept <= 26) {
							if (yyaccept <= 25) {
								if (yyaccept == 24) {
									goto yy331;
								} else {
									goto yy334;
								}
							} else {
								goto yy88;
							}
						} else {
							if (yyaccept <= 28) {
								if (yyaccept == 27) {
									goto yy372;
								} else {
									goto yy381;
								}
							} else {
								goto yy383;
							}
						}
					} else {
						if (yyaccept <= 32) {
							if (yyaccept <= 31) {
								if (yyaccept == 30) {
									goto yy392;
								} else {
									goto yy394;
								}
							} else {
								goto yy401;
							}
						} else {
							if (yyaccept <= 34) {
								if (yyaccept == 33) {
									goto yy408;
								} else {
									goto yy461;
								}
							} else {
								goto yy463;
							}
						}
					}
				} else {
					if (yyaccept <= 41) {
						if (yyaccept <= 38) {
							if (yyaccept <= 37) {
								if (yyaccept == 36) {
									goto yy466;
								} else {
									goto yy468;
								}
							} else {
								goto yy470;
							}
						} else {
							if (yyaccept <= 40) {
								if (yyaccept == 39) {
									goto yy472;
								} else {
									goto yy478;
								}
							} else {
								goto yy482;
							}
						}
					} else {
						if (yyaccept <= 44) {
							if (yyaccept <= 43) {
								if (yyaccept == 42) {
									goto yy491;
								} else {
									goto yy501;
								}
							} else {
								goto yy503;
							}
						} else {
							if (yyaccept <= 46) {
								if (yyaccept == 45) {
									goto yy506;
								} else {
									goto yy516;
								}
							} else {
								goto yy518;
							}
						}
					}
				}
			}
		} else {
			if (yyaccept <= 71) {
				if (yyaccept <= 59) {
					if (yyaccept <= 53) {
						if (yyaccept <= 50) {
							if (yyaccept <= 49) {
								if (yyaccept == 48) {
									goto yy520;
								} else {
									goto yy522;
								}
							} else {
								goto yy524;
							}
						} else {
							if (yyaccept <= 52) {
								if (yyaccept == 51) {
									goto yy563;
								} else {
									goto yy566;
								}
							} else {
								goto yy570;
							}
						}
					} else {
						if (yyaccept <= 56) {
							if (yyaccept <= 55) {
								if (yyaccept == 54) {
									goto yy584;
								} else {
									goto yy594;
								}
							} else {
								goto yy598;
							}
						} else {
							if (yyaccept <= 58) {
								if (yyaccept == 57) {
									goto yy600;
								} else {
									goto yy602;
								}
							} else {
								goto yy636;
							}
						}
					}
				} else {
					if (yyaccept <= 65) {
						if (yyaccept <= 62) {
							if (yyaccept <= 61) {
								if (yyaccept == 60) {
									goto yy638;
								} else {
									goto yy653;
								}
							} else {
								goto yy655;
							}
						} else {
							if (yyaccept <= 64) {
								if (yyaccept == 63) {
									goto yy657;
								} else {
									goto yy661;
								}
							} else {
								goto yy667;
							}
						}
					} else {
						if (yyaccept <= 68) {
							if (yyaccept <= 67) {
								if (yyaccept == 66) {
									goto yy671;
								} else {
									goto yy681;
								}
							} else {
								goto yy698;
							}
						} else {
							if (yyaccept <= 70) {
								if (yyaccept == 69) {
									goto yy700;
								} else {
									goto yy702;
								}
							} else {
								goto yy707;
							}
						}
					}
				}
			} else {
				if (yyaccept <= 83) {
					if (yyaccept <= 77) {
						if (yyaccept <= 74) {
							if (yyaccept <= 73) {
								if (yyaccept == 72) {
									goto yy715;
								} else {
									goto yy724;
								}
							} else {
								goto yy734;
							}
						} else {
							if (yyaccept <= 76) {
								if (yyaccept == 75) {
									goto yy738;
								} else {
									goto yy749;
								}
							} else {
								goto yy762;
							}
						}
					} else {
						if (yyaccept <= 80) {
							if (yyaccept <= 79) {
								if (yyaccept == 78) {
									goto yy764;
								} else {
									goto yy766;
								}
							} else {
								goto yy768;
							}
						} else {
							if (yyaccept <= 82) {
								if (yyaccept == 81) {
									goto yy775;
								} else {
									goto yy781;
								}
							} else {
								goto yy785;
							}
						}
					}
				} else {
					if (yyaccept <= 89) {
						if (yyaccept <= 86) {
							if (yyaccept <= 85) {
								if (yyaccept == 84) {
									goto yy787;
								} else {
									goto yy798;
								}
							} else {
								goto yy801;
							}
						} else {
							if (yyaccept <= 88) {
								if (yyaccept == 87) {
									goto yy813;
								} else {
									goto yy827;
								}
							} else {
								goto yy851;
							}
						}
					} else {
						if (yyaccept <= 92) {
							if (yyaccept <= 91) {
								if (yyaccept == 90) {
									goto yy853;
								} else {
									goto yy830;
								}
							} else {
								goto yy861;
							}
						} else {
							if (yyaccept <= 94) {
								if (yyaccept == 93) {
									goto yy839;
								} else {
									goto yy878;
								}
							} else {
								goto yy896;
							}
						}
					}
				}
			}
		}
yy86:
		YYDEBUG(86, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x00) goto yy85;
			if (yych == '\n') goto yy223;
			goto yy221;
		} else {
			if (yych <= '\r') goto yy223;
			if (yych == '[') goto yy85;
			goto yy221;
		}
yy87:
		YYDEBUG(87, *YYCURSOR);
		++YYCURSOR;
yy88:
		YYDEBUG(88, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(1);
	RETURN_TOKEN(T_AMPERSAND_FOLLOWED_BY_VAR_OR_VARARG);
}
yy89:
		YYDEBUG(89, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(90, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_BOOLEAN_AND);
}
yy91:
		YYDEBUG(91, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '.') goto yy225;
		goto yy85;
yy92:
		YYDEBUG(92, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych == '*') goto yy226;
		if (yych == '/') goto yy221;
		goto yy85;
yy93:
		YYDEBUG(93, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(94, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_AND_EQUAL);
}
yy95:
		YYDEBUG(95, *YYCURSOR);
		++YYCURSOR;
		YYFILL(7);
		yych = *YYCURSOR;
yy96:
		YYDEBUG(96, *YYCURSOR);
		if (yybm[0+yych] & 1) {
			goto yy95;
		}
		switch (yych) {
		case 'A':
		case 'a':	goto yy97;
		case 'B':
		case 'b':	goto yy98;
		case 'D':
		case 'd':	goto yy99;
		case 'F':
		case 'f':	goto yy100;
		case 'I':
		case 'i':	goto yy101;
		case 'O':
		case 'o':	goto yy102;
		case 'R':
		case 'r':	goto yy103;
		case 'S':
		case 's':	goto yy104;
		case 'U':
		case 'u':	goto yy105;
		default:	goto yy85;
		}
yy97:
		YYDEBUG(97, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy228;
		if (yych == 'r') goto yy228;
		goto yy85;
yy98:
		YYDEBUG(98, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych == 'I') goto yy229;
			if (yych <= 'N') goto yy85;
			goto yy230;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy85;
				goto yy229;
			} else {
				if (yych == 'o') goto yy230;
				goto yy85;
			}
		}
yy99:
		YYDEBUG(99, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy231;
		if (yych == 'o') goto yy231;
		goto yy85;
yy100:
		YYDEBUG(100, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy232;
		if (yych == 'l') goto yy232;
		goto yy85;
yy101:
		YYDEBUG(101, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy233;
		if (yych == 'n') goto yy233;
		goto yy85;
yy102:
		YYDEBUG(102, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy234;
		if (yych == 'b') goto yy234;
		goto yy85;
yy103:
		YYDEBUG(103, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy235;
		if (yych == 'e') goto yy235;
		goto yy85;
yy104:
		YYDEBUG(104, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy236;
		if (yych == 't') goto yy236;
		goto yy85;
yy105:
		YYDEBUG(105, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy237;
		if (yych == 'n') goto yy237;
		goto yy85;
yy106:
		YYDEBUG(106, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy238;
		YYDEBUG(107, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_POW);
}
yy108:
		YYDEBUG(108, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(109, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_MUL_EQUAL);
}
yy110:
		YYDEBUG(110, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(111, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_INC);
}
yy112:
		YYDEBUG(112, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(113, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_PLUS_EQUAL);
}
yy114:
		YYDEBUG(114, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(115, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_DEC);
}
yy116:
		YYDEBUG(116, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(117, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_MINUS_EQUAL);
}
yy118:
		YYDEBUG(118, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(119, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN(T_OBJECT_OPERATOR);
}
yy120:
		YYDEBUG(120, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '.') goto yy240;
		goto yy85;
yy121:
		YYDEBUG(121, *YYCURSOR);
		yyaccept = 5;
		YYMARKER = ++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy122:
		YYDEBUG(122, *YYCURSOR);
		if (yych <= 'E') {
			if (yych <= '/') goto yy123;
			if (yych <= '9') goto yy121;
			if (yych >= 'E') goto yy133;
		} else {
			if (yych <= '_') {
				if (yych >= '_') goto yy242;
			} else {
				if (yych == 'e') goto yy133;
			}
		}
yy123:
		YYDEBUG(123, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	const char *end;
	size_t len = yyleng;
	char *dnum = yytext;
	bool contains_underscores = (memchr(dnum, '_', len) != NULL);

	if (contains_underscores) {
		dnum = estrndup(dnum, len);
		strip_underscores(dnum, &len);
	}

	ZVAL_DOUBLE(zendlval, zend_strtod(dnum, &end));
	/* errno isn't checked since we allow HUGE_VAL/INF overflow */
	ZEND_ASSERT(end == dnum + len);
	if (contains_underscores) {
		efree(dnum);
	}
	RETURN_TOKEN_WITH_VAL(T_DNUMBER);
}
yy124:
		YYDEBUG(124, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(125, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_CONCAT_EQUAL);
}
yy126:
		YYDEBUG(126, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '*') goto yy243;
yy127:
		YYDEBUG(127, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	int doc_com;

	if (yyleng > 2) {
		doc_com = 1;
		RESET_DOC_COMMENT();
	} else {
		doc_com = 0;
	}

	while (YYCURSOR < YYLIMIT) {
		if (*YYCURSOR++ == '*' && *YYCURSOR == '/') {
			break;
		}
	}

	if (YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	} else {
		zend_throw_exception_ex(zend_ce_parse_error, 0, "Unterminated comment starting line %d", CG(zend_lineno));
		if (PARSER_MODE()) {
			RETURN_TOKEN(T_ERROR);
		}
	}

	yyleng = YYCURSOR - SCNG(yy_text);
	HANDLE_NEWLINES(yytext, yyleng);

	if (doc_com) {
		CG(doc_comment) = zend_string_init(yytext, yyleng, 0);
		RETURN_OR_SKIP_TOKEN(T_DOC_COMMENT);
	}

	RETURN_OR_SKIP_TOKEN(T_COMMENT);
}
yy128:
		YYDEBUG(128, *YYCURSOR);
		++YYCURSOR;
		goto yy12;
yy129:
		YYDEBUG(129, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(130, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_DIV_EQUAL);
}
yy131:
		YYDEBUG(131, *YYCURSOR);
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy123;
		goto yy122;
yy132:
		YYDEBUG(132, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 8) {
			goto yy244;
		}
		goto yy85;
yy133:
		YYDEBUG(133, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= ',') {
			if (yych == '+') goto yy247;
			goto yy85;
		} else {
			if (yych <= '-') goto yy247;
			if (yych <= '/') goto yy85;
			if (yych <= '9') goto yy248;
			goto yy85;
		}
yy134:
		YYDEBUG(134, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy250;
		}
		goto yy85;
yy135:
		YYDEBUG(135, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 32) {
			goto yy253;
		}
		goto yy85;
yy136:
		YYDEBUG(136, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[256+yych] & 64) {
			goto yy31;
		}
		goto yy85;
yy137:
		YYDEBUG(137, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(138, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_PAAMAYIM_NEKUDOTAYIM);
}
yy139:
		YYDEBUG(139, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ';') goto yy140;
		if (yych <= '<') goto yy256;
		if (yych <= '=') goto yy258;
yy140:
		YYDEBUG(140, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_SL);
}
yy141:
		YYDEBUG(141, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy260;
		YYDEBUG(142, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_SMALLER_OR_EQUAL);
}
yy143:
		YYDEBUG(143, *YYCURSOR);
		++YYCURSOR;
		goto yy75;
yy144:
		YYDEBUG(144, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy262;
		YYDEBUG(145, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_EQUAL);
}
yy146:
		YYDEBUG(146, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(147, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_DOUBLE_ARROW);
}
yy148:
		YYDEBUG(148, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(149, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_GREATER_OR_EQUAL);
}
yy150:
		YYDEBUG(150, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy264;
		YYDEBUG(151, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_SR);
}
yy152:
		YYDEBUG(152, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy266;
		goto yy85;
yy153:
		YYDEBUG(153, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy268;
		if (yych == '\r') goto yy269;
yy154:
		YYDEBUG(154, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(INITIAL);
	if (yytext[yyleng-1] != '>') {
		CG(increment_lineno) = 1;
	}
	if (PARSER_MODE()) {
		RETURN_TOKEN(';');  /* implicit ';' at php-end tag */
	}
	RETURN_TOKEN(T_CLOSE_TAG);
}
yy155:
		YYDEBUG(155, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy270;
		YYDEBUG(156, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_COALESCE);
}
yy157:
		YYDEBUG(157, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy272;
		if (yych == 's') goto yy272;
		goto yy47;
yy158:
		YYDEBUG(158, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy273;
		if (yych == 'd') goto yy273;
		goto yy47;
yy159:
		YYDEBUG(159, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy275;
		if (yych == 'r') goto yy275;
		goto yy47;
yy160:
		YYDEBUG(160, *YYCURSOR);
		yyaccept = 8;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy161:
		YYDEBUG(161, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_AS);
}
yy162:
		YYDEBUG(162, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy85;
			if (yych <= 'Z') goto yy276;
			if (yych <= '^') goto yy85;
			goto yy276;
		} else {
			if (yych <= '`') goto yy85;
			if (yych <= 'z') goto yy276;
			if (yych <= 0x7F) goto yy85;
			goto yy276;
		}
yy163:
		YYDEBUG(163, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '<') goto yy279;
		goto yy85;
yy164:
		YYDEBUG(164, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy280;
		if (yych == 'e') goto yy280;
		goto yy47;
yy165:
		YYDEBUG(165, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'T') {
			if (yych <= 'L') {
				if (yych <= 'K') goto yy47;
				goto yy281;
			} else {
				if (yych <= 'R') goto yy47;
				if (yych <= 'S') goto yy282;
				goto yy283;
			}
		} else {
			if (yych <= 'r') {
				if (yych == 'l') goto yy281;
				goto yy47;
			} else {
				if (yych <= 's') goto yy282;
				if (yych <= 't') goto yy283;
				goto yy47;
			}
		}
yy166:
		YYDEBUG(166, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'O') {
			if (yych == 'A') goto yy284;
			if (yych <= 'N') goto yy47;
			goto yy285;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy47;
				goto yy284;
			} else {
				if (yych == 'o') goto yy285;
				goto yy47;
			}
		}
yy167:
		YYDEBUG(167, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy286;
		if (yych == 'n') goto yy286;
		goto yy47;
yy168:
		YYDEBUG(168, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'F') {
			if (yych == 'C') goto yy287;
			if (yych <= 'E') goto yy47;
			goto yy288;
		} else {
			if (yych <= 'c') {
				if (yych <= 'b') goto yy47;
				goto yy287;
			} else {
				if (yych == 'f') goto yy288;
				goto yy47;
			}
		}
yy169:
		YYDEBUG(169, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy289;
		if (yych == 'e') goto yy289;
		goto yy47;
yy170:
		YYDEBUG(170, *YYCURSOR);
		yyaccept = 9;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy171:
		YYDEBUG(171, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_DO);
}
yy172:
		YYDEBUG(172, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy291;
		if (yych == 'h') goto yy291;
		goto yy47;
yy173:
		YYDEBUG(173, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy292;
		if (yych == 's') goto yy292;
		goto yy47;
yy174:
		YYDEBUG(174, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'P') goto yy293;
		if (yych == 'p') goto yy293;
		goto yy47;
yy175:
		YYDEBUG(175, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'U') {
			if (yych == 'D') goto yy294;
			if (yych <= 'T') goto yy47;
			goto yy295;
		} else {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy47;
				goto yy294;
			} else {
				if (yych == 'u') goto yy295;
				goto yy47;
			}
		}
yy176:
		YYDEBUG(176, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy296;
		if (yych == 'a') goto yy296;
		goto yy47;
yy177:
		YYDEBUG(177, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'T') {
			if (yych == 'I') goto yy297;
			if (yych <= 'S') goto yy47;
			goto yy298;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy47;
				goto yy297;
			} else {
				if (yych == 't') goto yy298;
				goto yy47;
			}
		}
yy178:
		YYDEBUG(178, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy299;
		if (yych == 'n') goto yy299;
		goto yy47;
yy179:
		YYDEBUG(179, *YYCURSOR);
		yyaccept = 10;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy180:
		YYDEBUG(180, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FN);
}
yy181:
		YYDEBUG(181, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy300;
		if (yych == 'r') goto yy300;
		goto yy47;
yy182:
		YYDEBUG(182, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy302;
		if (yych == 'n') goto yy302;
		goto yy47;
yy183:
		YYDEBUG(183, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy303;
		if (yych == 'o') goto yy303;
		goto yy47;
yy184:
		YYDEBUG(184, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy304;
		if (yych == 't') goto yy304;
		goto yy47;
yy185:
		YYDEBUG(185, *YYCURSOR);
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy186:
		YYDEBUG(186, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_IF);
}
yy187:
		YYDEBUG(187, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'P') goto yy305;
		if (yych == 'p') goto yy305;
		goto yy47;
yy188:
		YYDEBUG(188, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'T') {
			if (yych <= 'C') {
				if (yych <= 'B') goto yy47;
				goto yy306;
			} else {
				if (yych <= 'R') goto yy47;
				if (yych <= 'S') goto yy307;
				goto yy308;
			}
		} else {
			if (yych <= 'r') {
				if (yych == 'c') goto yy306;
				goto yy47;
			} else {
				if (yych <= 's') goto yy307;
				if (yych <= 't') goto yy308;
				goto yy47;
			}
		}
yy189:
		YYDEBUG(189, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy309;
		if (yych == 's') goto yy309;
		goto yy47;
yy190:
		YYDEBUG(190, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy310;
		if (yych == 's') goto yy310;
		goto yy47;
yy191:
		YYDEBUG(191, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy311;
		if (yych == 't') goto yy311;
		goto yy47;
yy192:
		YYDEBUG(192, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'M') goto yy312;
		if (yych == 'm') goto yy312;
		goto yy47;
yy193:
		YYDEBUG(193, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'W') goto yy313;
		if (yych == 'w') goto yy313;
		goto yy47;
yy194:
		YYDEBUG(194, *YYCURSOR);
		yyaccept = 12;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy195:
		YYDEBUG(195, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_LOGICAL_OR);
}
yy196:
		YYDEBUG(196, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'O') {
			if (yych == 'I') goto yy315;
			if (yych <= 'N') goto yy47;
			goto yy316;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy47;
				goto yy315;
			} else {
				if (yych == 'o') goto yy316;
				goto yy47;
			}
		}
yy197:
		YYDEBUG(197, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'B') goto yy317;
		if (yych == 'b') goto yy317;
		goto yy47;
yy198:
		YYDEBUG(198, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'T') {
			if (yych <= 'P') {
				if (yych == 'A') goto yy318;
				goto yy47;
			} else {
				if (yych <= 'Q') goto yy319;
				if (yych <= 'S') goto yy47;
				goto yy320;
			}
		} else {
			if (yych <= 'p') {
				if (yych == 'a') goto yy318;
				goto yy47;
			} else {
				if (yych <= 'q') goto yy319;
				if (yych == 't') goto yy320;
				goto yy47;
			}
		}
yy199:
		YYDEBUG(199, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy321;
		if (yych == 'a') goto yy321;
		goto yy47;
yy200:
		YYDEBUG(200, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy322;
		if (yych == 'i') goto yy322;
		goto yy47;
yy201:
		YYDEBUG(201, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy323;
		if (yych == 'r') goto yy323;
		goto yy47;
yy202:
		YYDEBUG(202, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'Y') {
			if (yych == 'A') goto yy324;
			if (yych <= 'X') goto yy47;
			goto yy325;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy47;
				goto yy324;
			} else {
				if (yych == 'y') goto yy325;
				goto yy47;
			}
		}
yy203:
		YYDEBUG(203, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy327;
		if (yych == 's') goto yy327;
		goto yy47;
yy204:
		YYDEBUG(204, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy328;
		if (yych == 'e') goto yy328;
		goto yy47;
yy205:
		YYDEBUG(205, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy330;
		if (yych == 'r') goto yy330;
		goto yy47;
yy206:
		YYDEBUG(206, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy332;
		if (yych == 'i') goto yy332;
		goto yy47;
yy207:
		YYDEBUG(207, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy333;
		if (yych == 'r') goto yy333;
		goto yy47;
yy208:
		YYDEBUG(208, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy335;
		if (yych == 'e') goto yy335;
		goto yy47;
yy209:
		YYDEBUG(209, *YYCURSOR);
		yyaccept = 13;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(210, *YYCURSOR);
		if (yych <= '\\') {
			if (yych <= '@') {
				if (yych <= '/') goto yy211;
				if (yych <= '9') goto yy209;
			} else {
				if (yych <= 'Z') goto yy209;
				if (yych >= '\\') goto yy336;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy209;
			} else {
				if (yych <= 'z') goto yy209;
				if (yych >= 0x80) goto yy209;
			}
		}
yy211:
		YYDEBUG(211, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_NAME_FULLY_QUALIFIED, 1);
}
yy212:
		YYDEBUG(212, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(213, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_XOR_EQUAL);
}
yy214:
		YYDEBUG(214, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		switch (yych) {
		case 'C':
		case 'c':	goto yy337;
		case 'D':
		case 'd':	goto yy338;
		case 'F':
		case 'f':	goto yy339;
		case 'H':
		case 'h':	goto yy340;
		case 'L':
		case 'l':	goto yy341;
		case 'M':
		case 'm':	goto yy342;
		case 'N':
		case 'n':	goto yy343;
		case 'T':
		case 't':	goto yy344;
		default:	goto yy47;
		}
yy215:
		YYDEBUG(215, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(216, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_OR_EQUAL);
}
yy217:
		YYDEBUG(217, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(218, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_BOOLEAN_OR);
}
yy219:
		YYDEBUG(219, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(220, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_NOT_IDENTICAL);
}
yy221:
		YYDEBUG(221, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(222, *YYCURSOR);
		if (yybm[0+yych] & 2) {
			goto yy221;
		}
		if (yych <= 0x00) goto yy85;
		goto yy83;
yy223:
		YYDEBUG(223, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(224, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy85;
				if (yych <= 0x08) goto yy221;
				goto yy223;
			} else {
				if (yych <= '\n') goto yy83;
				if (yych == '\r') goto yy83;
				goto yy221;
			}
		} else {
			if (yych <= '$') {
				if (yych <= ' ') goto yy223;
				if (yych <= '"') goto yy221;
				if (yych <= '#') goto yy345;
				goto yy346;
			} else {
				if (yych <= '-') goto yy221;
				if (yych <= '.') goto yy347;
				if (yych <= '/') goto yy348;
				goto yy221;
			}
		}
yy225:
		YYDEBUG(225, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '.') goto yy87;
		goto yy85;
yy226:
		YYDEBUG(226, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(227, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy226;
		}
		if (yych <= 0x00) goto yy85;
		goto yy349;
yy228:
		YYDEBUG(228, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy351;
		if (yych == 'r') goto yy351;
		goto yy85;
yy229:
		YYDEBUG(229, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy352;
		if (yych == 'n') goto yy352;
		goto yy85;
yy230:
		YYDEBUG(230, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy353;
		if (yych == 'o') goto yy353;
		goto yy85;
yy231:
		YYDEBUG(231, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy354;
		if (yych == 'u') goto yy354;
		goto yy85;
yy232:
		YYDEBUG(232, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy355;
		if (yych == 'o') goto yy355;
		goto yy85;
yy233:
		YYDEBUG(233, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy356;
		if (yych == 't') goto yy356;
		goto yy85;
yy234:
		YYDEBUG(234, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'J') goto yy357;
		if (yych == 'j') goto yy357;
		goto yy85;
yy235:
		YYDEBUG(235, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy358;
		if (yych == 'a') goto yy358;
		goto yy85;
yy236:
		YYDEBUG(236, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy359;
		if (yych == 'r') goto yy359;
		goto yy85;
yy237:
		YYDEBUG(237, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy360;
		if (yych == 's') goto yy360;
		goto yy85;
yy238:
		YYDEBUG(238, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(239, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_POW_EQUAL);
}
yy240:
		YYDEBUG(240, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(241, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_ELLIPSIS);
}
yy242:
		YYDEBUG(242, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '/') goto yy85;
		if (yych <= '9') goto yy121;
		goto yy85;
yy243:
		YYDEBUG(243, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy85;
			if (yych <= '\n') goto yy361;
			goto yy85;
		} else {
			if (yych <= '\r') goto yy361;
			if (yych == ' ') goto yy361;
			goto yy85;
		}
yy244:
		YYDEBUG(244, *YYCURSOR);
		yyaccept = 14;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(245, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy244;
		}
		if (yych == '_') goto yy132;
yy246:
		YYDEBUG(246, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* The +/- 2 skips "0b" */
	size_t len = yyleng - 2;
	char *end, *bin = yytext + 2;
	bool contains_underscores;

	/* Skip any leading 0s */
	while (len > 0 && (*bin == '0' || *bin == '_')) {
		++bin;
		--len;
	}

	contains_underscores = (memchr(bin, '_', len) != NULL);

	if (contains_underscores) {
		bin = estrndup(bin, len);
		strip_underscores(bin, &len);
	}

	if (len < SIZEOF_ZEND_LONG * 8) {
		if (len == 0) {
			ZVAL_LONG(zendlval, 0);
		} else {
			errno = 0;
			ZVAL_LONG(zendlval, ZEND_STRTOL(bin, &end, 2));
			ZEND_ASSERT(!errno && end == bin + len);
		}
		if (contains_underscores) {
			efree(bin);
		}
		RETURN_TOKEN_WITH_VAL(T_LNUMBER);
	} else {
		ZVAL_DOUBLE(zendlval, zend_bin_strtod(bin, (const char **)&end));
		/* errno isn't checked since we allow HUGE_VAL/INF overflow */
		ZEND_ASSERT(end == bin + len);
		if (contains_underscores) {
			efree(bin);
		}
		RETURN_TOKEN_WITH_VAL(T_DNUMBER);
	}
}
yy247:
		YYDEBUG(247, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '/') goto yy85;
		if (yych >= ':') goto yy85;
yy248:
		YYDEBUG(248, *YYCURSOR);
		yyaccept = 5;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(249, *YYCURSOR);
		if (yych <= '/') goto yy123;
		if (yych <= '9') goto yy248;
		if (yych == '_') goto yy247;
		goto yy123;
yy250:
		YYDEBUG(250, *YYCURSOR);
		yyaccept = 15;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(251, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy250;
		}
		if (yych == '_') goto yy134;
yy252:
		YYDEBUG(252, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* The +/- 2 skips "0o" */
	size_t len = yyleng - 2;
	char *end, *octal = yytext + 2;
	bool contains_underscores = (memchr(octal, '_', len) != NULL);

	/* Skip any leading 0s */
	while (len > 0 && (*octal == '0' || *octal == '_')) {
		++octal;
		--len;
	}

	if (len == 0) {
		ZVAL_LONG(zendlval, 0);
		RETURN_TOKEN_WITH_VAL(T_LNUMBER);
	}

	if (contains_underscores) {
		octal = estrndup(octal, len);
		strip_underscores(octal, &len);
	}

	errno = 0;

	ZVAL_LONG(zendlval, ZEND_STRTOL(octal, &end, 8));

	ZEND_ASSERT(end == octal + len);

	if (!errno) {
		if (contains_underscores) {
			efree(octal);
		}
		RETURN_TOKEN_WITH_VAL(T_LNUMBER);
	}

	/* Overflow */
	ZEND_ASSERT(errno == ERANGE);
	/* Reset errno */
	errno = 0;

	/* zend_oct_strtod skips leading '0' */
	ZVAL_DOUBLE(zendlval, zend_oct_strtod(octal, (const char **)&end));
	ZEND_ASSERT(!errno);
	ZEND_ASSERT(end == octal + len);
	if (contains_underscores) {
		efree(octal);
	}
	RETURN_TOKEN_WITH_VAL(T_DNUMBER);
}
yy253:
		YYDEBUG(253, *YYCURSOR);
		yyaccept = 16;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(254, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy253;
		}
		if (yych == '_') goto yy135;
yy255:
		YYDEBUG(255, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* The +/- 2 skips "0x" */
	size_t len = yyleng - 2;
	char *end, *hex = yytext + 2;
	bool contains_underscores;

	/* Skip any leading 0s */
	while (len > 0 && (*hex == '0' || *hex == '_')) {
		++hex;
		--len;
	}

	contains_underscores = (memchr(hex, '_', len) != NULL);

	if (contains_underscores) {
		hex = estrndup(hex, len);
		strip_underscores(hex, &len);
	}

	if (len < SIZEOF_ZEND_LONG * 2 || (len == SIZEOF_ZEND_LONG * 2 && *hex <= '7')) {
		if (len == 0) {
			ZVAL_LONG(zendlval, 0);
		} else {
			errno = 0;
			ZVAL_LONG(zendlval, ZEND_STRTOL(hex, &end, 16));
			ZEND_ASSERT(!errno && end == hex + len);
		}
		if (contains_underscores) {
			efree(hex);
		}
		RETURN_TOKEN_WITH_VAL(T_LNUMBER);
	} else {
		ZVAL_DOUBLE(zendlval, zend_hex_strtod(hex, (const char **)&end));
		/* errno isn't checked since we allow HUGE_VAL/INF overflow */
		ZEND_ASSERT(end == hex + len);
		if (contains_underscores) {
			efree(hex);
		}
		RETURN_TOKEN_WITH_VAL(T_DNUMBER);
	}
}
yy256:
		YYDEBUG(256, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(257, *YYCURSOR);
		if (yych <= '\'') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy256;
				if (yych <= 0x1F) goto yy85;
				goto yy256;
			} else {
				if (yych == '"') goto yy363;
				if (yych <= '&') goto yy85;
				goto yy364;
			}
		} else {
			if (yych <= '_') {
				if (yych <= '@') goto yy85;
				if (yych <= 'Z') goto yy365;
				if (yych <= '^') goto yy85;
				goto yy365;
			} else {
				if (yych <= '`') goto yy85;
				if (yych <= 'z') goto yy365;
				if (yych <= 0x7F) goto yy85;
				goto yy365;
			}
		}
yy258:
		YYDEBUG(258, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(259, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_SL_EQUAL);
}
yy260:
		YYDEBUG(260, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(261, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_SPACESHIP);
}
yy262:
		YYDEBUG(262, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(263, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_IDENTICAL);
}
yy264:
		YYDEBUG(264, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(265, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_SR_EQUAL);
}
yy266:
		YYDEBUG(266, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(267, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN(T_NULLSAFE_OBJECT_OPERATOR);
}
yy268:
		YYDEBUG(268, *YYCURSOR);
		++YYCURSOR;
		goto yy154;
yy269:
		YYDEBUG(269, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy268;
		goto yy154;
yy270:
		YYDEBUG(270, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(271, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_COALESCE_EQUAL);
}
yy272:
		YYDEBUG(272, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy367;
		if (yych == 't') goto yy367;
		goto yy47;
yy273:
		YYDEBUG(273, *YYCURSOR);
		yyaccept = 17;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy274:
		YYDEBUG(274, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_LOGICAL_AND);
}
yy275:
		YYDEBUG(275, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy368;
		if (yych == 'a') goto yy368;
		goto yy47;
yy276:
		YYDEBUG(276, *YYCURSOR);
		yyaccept = 18;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(277, *YYCURSOR);
		if (yych <= '\\') {
			if (yych <= '@') {
				if (yych <= '/') goto yy278;
				if (yych <= '9') goto yy276;
			} else {
				if (yych <= 'Z') goto yy276;
				if (yych >= '\\') goto yy162;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy276;
			} else {
				if (yych <= 'z') goto yy276;
				if (yych >= 0x80) goto yy276;
			}
		}
yy278:
		YYDEBUG(278, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_NAME_QUALIFIED, 0);
}
yy279:
		YYDEBUG(279, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '<') goto yy256;
		goto yy85;
yy280:
		YYDEBUG(280, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy369;
		if (yych == 'a') goto yy369;
		goto yy47;
yy281:
		YYDEBUG(281, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy370;
		if (yych == 'l') goto yy370;
		goto yy47;
yy282:
		YYDEBUG(282, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy371;
		if (yych == 'e') goto yy371;
		goto yy47;
yy283:
		YYDEBUG(283, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy373;
		if (yych == 'c') goto yy373;
		goto yy47;
yy284:
		YYDEBUG(284, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy374;
		if (yych == 's') goto yy374;
		goto yy47;
yy285:
		YYDEBUG(285, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy375;
		if (yych == 'n') goto yy375;
		goto yy47;
yy286:
		YYDEBUG(286, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'T') {
			if (yych <= 'R') goto yy47;
			if (yych <= 'S') goto yy376;
			goto yy377;
		} else {
			if (yych <= 'r') goto yy47;
			if (yych <= 's') goto yy376;
			if (yych <= 't') goto yy377;
			goto yy47;
		}
yy287:
		YYDEBUG(287, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy378;
		if (yych == 'l') goto yy378;
		goto yy47;
yy288:
		YYDEBUG(288, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy379;
		if (yych == 'a') goto yy379;
		goto yy47;
yy289:
		YYDEBUG(289, *YYCURSOR);
		yyaccept = 19;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy290:
		YYDEBUG(290, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_EXIT);
}
yy291:
		YYDEBUG(291, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy380;
		if (yych == 'o') goto yy380;
		goto yy47;
yy292:
		YYDEBUG(292, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy382;
		if (yych == 'e') goto yy382;
		goto yy47;
yy293:
		YYDEBUG(293, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy384;
		if (yych == 't') goto yy384;
		goto yy47;
yy294:
		YYDEBUG(294, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		switch (yych) {
		case 'D':
		case 'd':	goto yy385;
		case 'F':
		case 'f':	goto yy386;
		case 'I':
		case 'i':	goto yy387;
		case 'S':
		case 's':	goto yy388;
		case 'W':
		case 'w':	goto yy389;
		default:	goto yy47;
		}
yy295:
		YYDEBUG(295, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'M') goto yy390;
		if (yych == 'm') goto yy390;
		goto yy47;
yy296:
		YYDEBUG(296, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy391;
		if (yych == 'l') goto yy391;
		goto yy47;
yy297:
		YYDEBUG(297, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy393;
		if (yych == 't') goto yy393;
		goto yy47;
yy298:
		YYDEBUG(298, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy395;
		if (yych == 'e') goto yy395;
		goto yy47;
yy299:
		YYDEBUG(299, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy396;
		if (yych == 'a') goto yy396;
		goto yy47;
yy300:
		YYDEBUG(300, *YYCURSOR);
		yyaccept = 20;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\\') {
			if (yych <= 'D') {
				if (yych <= '/') goto yy301;
				if (yych <= '9') goto yy46;
				if (yych >= 'A') goto yy46;
			} else {
				if (yych <= 'E') goto yy397;
				if (yych <= 'Z') goto yy46;
				if (yych >= '\\') goto yy162;
			}
		} else {
			if (yych <= 'd') {
				if (yych == '_') goto yy46;
				if (yych >= 'a') goto yy46;
			} else {
				if (yych <= 'e') goto yy397;
				if (yych <= 'z') goto yy46;
				if (yych >= 0x80) goto yy46;
			}
		}
yy301:
		YYDEBUG(301, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FOR);
}
yy302:
		YYDEBUG(302, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy398;
		if (yych == 'c') goto yy398;
		goto yy47;
yy303:
		YYDEBUG(303, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'B') goto yy399;
		if (yych == 'b') goto yy399;
		goto yy47;
yy304:
		YYDEBUG(304, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy400;
		if (yych == 'o') goto yy400;
		goto yy47;
yy305:
		YYDEBUG(305, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy402;
		if (yych == 'l') goto yy402;
		goto yy47;
yy306:
		YYDEBUG(306, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy403;
		if (yych == 'l') goto yy403;
		goto yy47;
yy307:
		YYDEBUG(307, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy404;
		if (yych == 't') goto yy404;
		goto yy47;
yy308:
		YYDEBUG(308, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy405;
		if (yych == 'e') goto yy405;
		goto yy47;
yy309:
		YYDEBUG(309, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy406;
		if (yych == 'e') goto yy406;
		goto yy47;
yy310:
		YYDEBUG(310, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy407;
		if (yych == 't') goto yy407;
		goto yy47;
yy311:
		YYDEBUG(311, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy409;
		if (yych == 'c') goto yy409;
		goto yy47;
yy312:
		YYDEBUG(312, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy410;
		if (yych == 'e') goto yy410;
		goto yy47;
yy313:
		YYDEBUG(313, *YYCURSOR);
		yyaccept = 21;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy314:
		YYDEBUG(314, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_NEW);
}
yy315:
		YYDEBUG(315, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'V') {
			if (yych == 'N') goto yy411;
			if (yych <= 'U') goto yy47;
			goto yy412;
		} else {
			if (yych <= 'n') {
				if (yych <= 'm') goto yy47;
				goto yy411;
			} else {
				if (yych == 'v') goto yy412;
				goto yy47;
			}
		}
yy316:
		YYDEBUG(316, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy413;
		if (yych == 't') goto yy413;
		goto yy47;
yy317:
		YYDEBUG(317, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy414;
		if (yych == 'l') goto yy414;
		goto yy47;
yy318:
		YYDEBUG(318, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy415;
		if (yych == 'd') goto yy415;
		goto yy47;
yy319:
		YYDEBUG(319, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'U') goto yy416;
		if (yych == 'u') goto yy416;
		goto yy47;
yy320:
		YYDEBUG(320, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'U') goto yy417;
		if (yych == 'u') goto yy417;
		goto yy47;
yy321:
		YYDEBUG(321, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy418;
		if (yych == 't') goto yy418;
		goto yy47;
yy322:
		YYDEBUG(322, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy419;
		if (yych == 't') goto yy419;
		goto yy47;
yy323:
		YYDEBUG(323, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy420;
		if (yych == 'o') goto yy420;
		goto yy47;
yy324:
		YYDEBUG(324, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy421;
		if (yych == 'i') goto yy421;
		goto yy47;
yy325:
		YYDEBUG(325, *YYCURSOR);
		yyaccept = 22;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy326:
		YYDEBUG(326, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_TRY);
}
yy327:
		YYDEBUG(327, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy422;
		if (yych == 'e') goto yy422;
		goto yy47;
yy328:
		YYDEBUG(328, *YYCURSOR);
		yyaccept = 23;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy329:
		YYDEBUG(329, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_USE);
}
yy330:
		YYDEBUG(330, *YYCURSOR);
		yyaccept = 24;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy331:
		YYDEBUG(331, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_VAR);
}
yy332:
		YYDEBUG(332, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy423;
		if (yych == 'l') goto yy423;
		goto yy47;
yy333:
		YYDEBUG(333, *YYCURSOR);
		yyaccept = 25;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy334:
		YYDEBUG(334, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_LOGICAL_XOR);
}
yy335:
		YYDEBUG(335, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy424;
		if (yych == 'l') goto yy424;
		goto yy47;
yy336:
		YYDEBUG(336, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy85;
			if (yych <= 'Z') goto yy209;
			if (yych <= '^') goto yy85;
			goto yy209;
		} else {
			if (yych <= '`') goto yy85;
			if (yych <= 'z') goto yy209;
			if (yych <= 0x7F) goto yy85;
			goto yy209;
		}
yy337:
		YYDEBUG(337, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy425;
		if (yych == 'l') goto yy425;
		goto yy47;
yy338:
		YYDEBUG(338, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy426;
		if (yych == 'i') goto yy426;
		goto yy47;
yy339:
		YYDEBUG(339, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'U') {
			if (yych == 'I') goto yy427;
			if (yych <= 'T') goto yy47;
			goto yy428;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy47;
				goto yy427;
			} else {
				if (yych == 'u') goto yy428;
				goto yy47;
			}
		}
yy340:
		YYDEBUG(340, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy429;
		if (yych == 'a') goto yy429;
		goto yy47;
yy341:
		YYDEBUG(341, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy430;
		if (yych == 'i') goto yy430;
		goto yy47;
yy342:
		YYDEBUG(342, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy431;
		if (yych == 'e') goto yy431;
		goto yy47;
yy343:
		YYDEBUG(343, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy432;
		if (yych == 'a') goto yy432;
		goto yy47;
yy344:
		YYDEBUG(344, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy433;
		if (yych == 'r') goto yy433;
		goto yy47;
yy345:
		YYDEBUG(345, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 2) {
			goto yy221;
		}
		if (yych <= 0x00) goto yy85;
		goto yy223;
yy346:
		YYDEBUG(346, *YYCURSOR);
		yyaccept = 26;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 2) {
			goto yy221;
		}
		if (yych <= 0x00) goto yy88;
		goto yy83;
yy347:
		YYDEBUG(347, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x00) goto yy85;
			if (yych == '\n') goto yy83;
			goto yy221;
		} else {
			if (yych <= '\r') goto yy83;
			if (yych == '.') goto yy434;
			goto yy221;
		}
yy348:
		YYDEBUG(348, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x00) goto yy85;
			if (yych == '\n') goto yy83;
			goto yy221;
		} else {
			if (yych <= '\r') goto yy83;
			if (yych == '*') goto yy435;
			goto yy221;
		}
yy349:
		YYDEBUG(349, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(350, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy349;
		}
		if (yych <= 0x00) goto yy85;
		if (yych == '/') goto yy83;
		goto yy226;
yy351:
		YYDEBUG(351, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy437;
		if (yych == 'a') goto yy437;
		goto yy85;
yy352:
		YYDEBUG(352, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy438;
		if (yych == 'a') goto yy438;
		goto yy85;
yy353:
		YYDEBUG(353, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy439;
		if (yych == 'l') goto yy439;
		goto yy85;
yy354:
		YYDEBUG(354, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy440;
		if (yych == 'b') goto yy440;
		goto yy85;
yy355:
		YYDEBUG(355, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy441;
		if (yych == 'a') goto yy441;
		goto yy85;
yy356:
		YYDEBUG(356, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy446;
		if (yych == 'e') goto yy446;
		goto yy443;
yy357:
		YYDEBUG(357, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy447;
		if (yych == 'e') goto yy447;
		goto yy85;
yy358:
		YYDEBUG(358, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy448;
		if (yych == 'l') goto yy448;
		goto yy85;
yy359:
		YYDEBUG(359, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy450;
		if (yych == 'i') goto yy450;
		goto yy85;
yy360:
		YYDEBUG(360, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy451;
		if (yych == 'e') goto yy451;
		goto yy85;
yy361:
		YYDEBUG(361, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(362, *YYCURSOR);
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy127;
			if (yych <= '\n') goto yy361;
			goto yy127;
		} else {
			if (yych <= '\r') goto yy361;
			if (yych == ' ') goto yy361;
			goto yy127;
		}
yy363:
		YYDEBUG(363, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '"') goto yy85;
		if (yych <= '/') goto yy453;
		if (yych <= '9') goto yy85;
		goto yy453;
yy364:
		YYDEBUG(364, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\'') goto yy85;
		if (yych <= '/') goto yy455;
		if (yych <= '9') goto yy85;
		goto yy455;
yy365:
		YYDEBUG(365, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(366, *YYCURSOR);
		if (yych <= '@') {
			if (yych <= '\f') {
				if (yych == '\n') goto yy456;
				goto yy85;
			} else {
				if (yych <= '\r') goto yy458;
				if (yych <= '/') goto yy85;
				if (yych <= '9') goto yy365;
				goto yy85;
			}
		} else {
			if (yych <= '_') {
				if (yych <= 'Z') goto yy365;
				if (yych <= '^') goto yy85;
				goto yy365;
			} else {
				if (yych <= '`') goto yy85;
				if (yych <= 'z') goto yy365;
				if (yych <= 0x7F) goto yy85;
				goto yy365;
			}
		}
yy367:
		YYDEBUG(367, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy459;
		if (yych == 'r') goto yy459;
		goto yy47;
yy368:
		YYDEBUG(368, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'Y') goto yy460;
		if (yych == 'y') goto yy460;
		goto yy47;
yy369:
		YYDEBUG(369, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'K') goto yy462;
		if (yych == 'k') goto yy462;
		goto yy47;
yy370:
		YYDEBUG(370, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy464;
		if (yych == 'a') goto yy464;
		goto yy47;
yy371:
		YYDEBUG(371, *YYCURSOR);
		yyaccept = 27;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy372:
		YYDEBUG(372, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CASE);
}
yy373:
		YYDEBUG(373, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy465;
		if (yych == 'h') goto yy465;
		goto yy47;
yy374:
		YYDEBUG(374, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy467;
		if (yych == 's') goto yy467;
		goto yy47;
yy375:
		YYDEBUG(375, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy469;
		if (yych == 'e') goto yy469;
		goto yy47;
yy376:
		YYDEBUG(376, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy471;
		if (yych == 't') goto yy471;
		goto yy47;
yy377:
		YYDEBUG(377, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy473;
		if (yych == 'i') goto yy473;
		goto yy47;
yy378:
		YYDEBUG(378, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy474;
		if (yych == 'a') goto yy474;
		goto yy47;
yy379:
		YYDEBUG(379, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'U') goto yy475;
		if (yych == 'u') goto yy475;
		goto yy47;
yy380:
		YYDEBUG(380, *YYCURSOR);
		yyaccept = 28;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy381:
		YYDEBUG(381, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ECHO);
}
yy382:
		YYDEBUG(382, *YYCURSOR);
		yyaccept = 29;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\\') {
			if (yych <= 'H') {
				if (yych <= '/') goto yy383;
				if (yych <= '9') goto yy46;
				if (yych >= 'A') goto yy46;
			} else {
				if (yych <= 'I') goto yy476;
				if (yych <= 'Z') goto yy46;
				if (yych >= '\\') goto yy162;
			}
		} else {
			if (yych <= 'h') {
				if (yych == '_') goto yy46;
				if (yych >= 'a') goto yy46;
			} else {
				if (yych <= 'i') goto yy476;
				if (yych <= 'z') goto yy46;
				if (yych >= 0x80) goto yy46;
			}
		}
yy383:
		YYDEBUG(383, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ELSE);
}
yy384:
		YYDEBUG(384, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'Y') goto yy477;
		if (yych == 'y') goto yy477;
		goto yy47;
yy385:
		YYDEBUG(385, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy479;
		if (yych == 'e') goto yy479;
		goto yy47;
yy386:
		YYDEBUG(386, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy480;
		if (yych == 'o') goto yy480;
		goto yy47;
yy387:
		YYDEBUG(387, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'F') goto yy481;
		if (yych == 'f') goto yy481;
		goto yy47;
yy388:
		YYDEBUG(388, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'W') goto yy483;
		if (yych == 'w') goto yy483;
		goto yy47;
yy389:
		YYDEBUG(389, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy484;
		if (yych == 'h') goto yy484;
		goto yy47;
yy390:
		YYDEBUG(390, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x1F) {
			if (yych <= '\n') {
				if (yych <= 0x08) goto yy47;
				goto yy485;
			} else {
				if (yych == '\r') goto yy485;
				goto yy47;
			}
		} else {
			if (yych <= '#') {
				if (yych <= ' ') goto yy485;
				if (yych <= '"') goto yy47;
				goto yy487;
			} else {
				if (yych == '/') goto yy488;
				goto yy47;
			}
		}
yy391:
		YYDEBUG(391, *YYCURSOR);
		yyaccept = 30;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy392:
		YYDEBUG(392, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_EVAL);
}
yy393:
		YYDEBUG(393, *YYCURSOR);
		yyaccept = 31;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy394:
		YYDEBUG(394, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_EXIT);
}
yy395:
		YYDEBUG(395, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy489;
		if (yych == 'n') goto yy489;
		goto yy47;
yy396:
		YYDEBUG(396, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy490;
		if (yych == 'l') goto yy490;
		goto yy47;
yy397:
		YYDEBUG(397, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy492;
		if (yych == 'a') goto yy492;
		goto yy47;
yy398:
		YYDEBUG(398, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy493;
		if (yych == 't') goto yy493;
		goto yy47;
yy399:
		YYDEBUG(399, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy494;
		if (yych == 'a') goto yy494;
		goto yy47;
yy400:
		YYDEBUG(400, *YYCURSOR);
		yyaccept = 32;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy401:
		YYDEBUG(401, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_GOTO);
}
yy402:
		YYDEBUG(402, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy495;
		if (yych == 'e') goto yy495;
		goto yy47;
yy403:
		YYDEBUG(403, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'U') goto yy496;
		if (yych == 'u') goto yy496;
		goto yy47;
yy404:
		YYDEBUG(404, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'E') {
			if (yych == 'A') goto yy497;
			if (yych <= 'D') goto yy47;
			goto yy498;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy47;
				goto yy497;
			} else {
				if (yych == 'e') goto yy498;
				goto yy47;
			}
		}
yy405:
		YYDEBUG(405, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy499;
		if (yych == 'r') goto yy499;
		goto yy47;
yy406:
		YYDEBUG(406, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy500;
		if (yych == 't') goto yy500;
		goto yy47;
yy407:
		YYDEBUG(407, *YYCURSOR);
		yyaccept = 33;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy408:
		YYDEBUG(408, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_LIST);
}
yy409:
		YYDEBUG(409, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy502;
		if (yych == 'h') goto yy502;
		goto yy47;
yy410:
		YYDEBUG(410, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy504;
		if (yych == 's') goto yy504;
		goto yy47;
yy411:
		YYDEBUG(411, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy505;
		if (yych == 't') goto yy505;
		goto yy47;
yy412:
		YYDEBUG(412, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy507;
		if (yych == 'a') goto yy507;
		goto yy47;
yy413:
		YYDEBUG(413, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy508;
		if (yych == 'e') goto yy508;
		goto yy47;
yy414:
		YYDEBUG(414, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy509;
		if (yych == 'i') goto yy509;
		goto yy47;
yy415:
		YYDEBUG(415, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy510;
		if (yych == 'o') goto yy510;
		goto yy47;
yy416:
		YYDEBUG(416, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy511;
		if (yych == 'i') goto yy511;
		goto yy47;
yy417:
		YYDEBUG(417, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy512;
		if (yych == 'r') goto yy512;
		goto yy47;
yy418:
		YYDEBUG(418, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy513;
		if (yych == 'i') goto yy513;
		goto yy47;
yy419:
		YYDEBUG(419, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy514;
		if (yych == 'c') goto yy514;
		goto yy47;
yy420:
		YYDEBUG(420, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'W') goto yy515;
		if (yych == 'w') goto yy515;
		goto yy47;
yy421:
		YYDEBUG(421, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy517;
		if (yych == 't') goto yy517;
		goto yy47;
yy422:
		YYDEBUG(422, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy519;
		if (yych == 't') goto yy519;
		goto yy47;
yy423:
		YYDEBUG(423, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy521;
		if (yych == 'e') goto yy521;
		goto yy47;
yy424:
		YYDEBUG(424, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy523;
		if (yych == 'd') goto yy523;
		goto yy47;
yy425:
		YYDEBUG(425, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy525;
		if (yych == 'a') goto yy525;
		goto yy47;
yy426:
		YYDEBUG(426, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy526;
		if (yych == 'r') goto yy526;
		goto yy47;
yy427:
		YYDEBUG(427, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy527;
		if (yych == 'l') goto yy527;
		goto yy47;
yy428:
		YYDEBUG(428, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy528;
		if (yych == 'n') goto yy528;
		goto yy47;
yy429:
		YYDEBUG(429, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy529;
		if (yych == 'l') goto yy529;
		goto yy47;
yy430:
		YYDEBUG(430, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy530;
		if (yych == 'n') goto yy530;
		goto yy47;
yy431:
		YYDEBUG(431, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy531;
		if (yych == 't') goto yy531;
		goto yy47;
yy432:
		YYDEBUG(432, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'M') goto yy532;
		if (yych == 'm') goto yy532;
		goto yy47;
yy433:
		YYDEBUG(433, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy533;
		if (yych == 'a') goto yy533;
		goto yy47;
yy434:
		YYDEBUG(434, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x00) goto yy85;
			if (yych == '\n') goto yy83;
			goto yy221;
		} else {
			if (yych <= '\r') goto yy83;
			if (yych == '.') goto yy346;
			goto yy221;
		}
yy435:
		YYDEBUG(435, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(436, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy435;
		}
		if (yych <= 0x00) goto yy85;
		if (yych <= '\r') goto yy534;
		goto yy536;
yy437:
		YYDEBUG(437, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy538;
		if (yych == 'y') goto yy538;
		goto yy85;
yy438:
		YYDEBUG(438, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy540;
		if (yych == 'r') goto yy540;
		goto yy85;
yy439:
		YYDEBUG(439, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy545;
		if (yych == 'e') goto yy545;
		goto yy542;
yy440:
		YYDEBUG(440, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy546;
		if (yych == 'l') goto yy546;
		goto yy85;
yy441:
		YYDEBUG(441, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy547;
		if (yych == 't') goto yy547;
		goto yy85;
yy442:
		YYDEBUG(442, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy443:
		YYDEBUG(443, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy442;
			goto yy85;
		} else {
			if (yych <= ' ') goto yy442;
			if (yych != ')') goto yy85;
		}
		YYDEBUG(444, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(445, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_INT_CAST);
}
yy446:
		YYDEBUG(446, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'G') goto yy549;
		if (yych == 'g') goto yy549;
		goto yy85;
yy447:
		YYDEBUG(447, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy550;
		if (yych == 'c') goto yy550;
		goto yy85;
yy448:
		YYDEBUG(448, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(449, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy448;
			goto yy85;
		} else {
			if (yych <= ' ') goto yy448;
			if (yych == ')') goto yy551;
			goto yy85;
		}
yy450:
		YYDEBUG(450, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy553;
		if (yych == 'n') goto yy553;
		goto yy85;
yy451:
		YYDEBUG(451, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy554;
		if (yych == 't') goto yy554;
		goto yy85;
yy452:
		YYDEBUG(452, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy453:
		YYDEBUG(453, *YYCURSOR);
		if (yych <= 'Z') {
			if (yych <= '/') {
				if (yych == '"') goto yy556;
				goto yy85;
			} else {
				if (yych <= '9') goto yy452;
				if (yych <= '@') goto yy85;
				goto yy452;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy452;
				goto yy85;
			} else {
				if (yych <= 'z') goto yy452;
				if (yych <= 0x7F) goto yy85;
				goto yy452;
			}
		}
yy454:
		YYDEBUG(454, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy455:
		YYDEBUG(455, *YYCURSOR);
		if (yych <= 'Z') {
			if (yych <= '/') {
				if (yych == '\'') goto yy556;
				goto yy85;
			} else {
				if (yych <= '9') goto yy454;
				if (yych <= '@') goto yy85;
				goto yy454;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy454;
				goto yy85;
			} else {
				if (yych <= 'z') goto yy454;
				if (yych <= 0x7F) goto yy85;
				goto yy454;
			}
		}
yy456:
		YYDEBUG(456, *YYCURSOR);
		++YYCURSOR;
yy457:
		YYDEBUG(457, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	char *s;
	unsigned char *saved_cursor;
	int bprefix = (yytext[0] != '<') ? 1 : 0, spacing = 0, indentation = 0;
	zend_heredoc_label *heredoc_label = emalloc(sizeof(zend_heredoc_label));
	bool is_heredoc = 1;

	CG(zend_lineno)++;
	heredoc_label->length = yyleng-bprefix-3-1-(yytext[yyleng-2]=='\r'?1:0);
	s = yytext+bprefix+3;
	while ((*s == ' ') || (*s == '\t')) {
		s++;
		heredoc_label->length--;
	}

	if (*s == '\'') {
		s++;
		heredoc_label->length -= 2;
		is_heredoc = 0;

		BEGIN(ST_NOWDOC);
	} else {
		if (*s == '"') {
			s++;
			heredoc_label->length -= 2;
		}

		BEGIN(ST_HEREDOC);
	}

	heredoc_label->label = estrndup(s, heredoc_label->length);
	heredoc_label->indentation_uses_spaces = 0;
	heredoc_label->indentation = 0;
	saved_cursor = YYCURSOR;

	zend_ptr_stack_push(&SCNG(heredoc_label_stack), (void *) heredoc_label);

	while (YYCURSOR < YYLIMIT && (*YYCURSOR == ' ' || *YYCURSOR == '\t')) {
		if (*YYCURSOR == '\t') {
			spacing |= HEREDOC_USING_TABS;
		} else {
			spacing |= HEREDOC_USING_SPACES;
		}
		++YYCURSOR;
		++indentation;
	}

	if (YYCURSOR == YYLIMIT) {
		YYCURSOR = saved_cursor;
		RETURN_TOKEN(T_START_HEREDOC);
	}

	/* Check for ending label on the next line */
	if (heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, s, heredoc_label->length)) {
		if (!IS_LABEL_SUCCESSOR(YYCURSOR[heredoc_label->length])) {
			if (spacing == (HEREDOC_USING_SPACES | HEREDOC_USING_TABS)) {
				zend_throw_exception(zend_ce_parse_error, "Invalid indentation - tabs and spaces cannot be mixed", 0);
				if (PARSER_MODE()) {
					RETURN_TOKEN(T_ERROR);
				}
			}

			YYCURSOR = saved_cursor;
			heredoc_label->indentation = indentation;

			BEGIN(ST_END_HEREDOC);
			RETURN_TOKEN(T_START_HEREDOC);
		}
	}

	YYCURSOR = saved_cursor;

	if (is_heredoc && !SCNG(heredoc_scan_ahead)) {
		zend_lex_state current_state;
		zend_string *saved_doc_comment = CG(doc_comment);
		int heredoc_nesting_level = 1;
		int first_token = 0;
		int error = 0;

		zend_save_lexical_state(&current_state);

		SCNG(heredoc_scan_ahead) = 1;
		SCNG(heredoc_indentation) = 0;
		SCNG(heredoc_indentation_uses_spaces) = 0;
		LANG_SCNG(on_event) = NULL;
		CG(doc_comment) = NULL;

		zend_ptr_stack_reverse_apply(&current_state.heredoc_label_stack, copy_heredoc_label_stack);

		zend_exception_save();
		while (heredoc_nesting_level) {
			zval zv;
			int retval;

			ZVAL_UNDEF(&zv);
			retval = lex_scan(&zv, NULL);
			zval_ptr_dtor_nogc(&zv);

			if (EG(exception)) {
				zend_clear_exception();
				break;
			}

			if (!first_token) {
				first_token = retval;
			}

			switch (retval) {
				case T_START_HEREDOC:
					++heredoc_nesting_level;
					break;
				case T_END_HEREDOC:
					--heredoc_nesting_level;
					break;
				case END:
					heredoc_nesting_level = 0;
			}
		}
		zend_exception_restore();

		if (
		    (first_token == T_VARIABLE
		     || first_token == T_DOLLAR_OPEN_CURLY_BRACES
		     || first_token == T_CURLY_OPEN
		    ) && SCNG(heredoc_indentation)) {
			zend_throw_exception_ex(zend_ce_parse_error, 0, "Invalid body indentation level (expecting an indentation level of at least %d)", SCNG(heredoc_indentation));
			error = 1;
		}

		heredoc_label->indentation = SCNG(heredoc_indentation);
		heredoc_label->indentation_uses_spaces = SCNG(heredoc_indentation_uses_spaces);

		zend_restore_lexical_state(&current_state);
		SCNG(heredoc_scan_ahead) = 0;
		CG(increment_lineno) = 0;
		CG(doc_comment) = saved_doc_comment;

		if (PARSER_MODE() && error) {
			RETURN_TOKEN(T_ERROR);
		}
	}

	RETURN_TOKEN(T_START_HEREDOC);
}
yy458:
		YYDEBUG(458, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy456;
		goto yy457;
yy459:
		YYDEBUG(459, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy557;
		if (yych == 'a') goto yy557;
		goto yy47;
yy460:
		YYDEBUG(460, *YYCURSOR);
		yyaccept = 34;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy461:
		YYDEBUG(461, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ARRAY);
}
yy462:
		YYDEBUG(462, *YYCURSOR);
		yyaccept = 35;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy463:
		YYDEBUG(463, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_BREAK);
}
yy464:
		YYDEBUG(464, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'B') goto yy558;
		if (yych == 'b') goto yy558;
		goto yy47;
yy465:
		YYDEBUG(465, *YYCURSOR);
		yyaccept = 36;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy466:
		YYDEBUG(466, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CATCH);
}
yy467:
		YYDEBUG(467, *YYCURSOR);
		yyaccept = 37;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy468:
		YYDEBUG(468, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CLASS);
}
yy469:
		YYDEBUG(469, *YYCURSOR);
		yyaccept = 38;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy470:
		YYDEBUG(470, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CLONE);
}
yy471:
		YYDEBUG(471, *YYCURSOR);
		yyaccept = 39;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy472:
		YYDEBUG(472, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CONST);
}
yy473:
		YYDEBUG(473, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy559;
		if (yych == 'n') goto yy559;
		goto yy47;
yy474:
		YYDEBUG(474, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy560;
		if (yych == 'r') goto yy560;
		goto yy47;
yy475:
		YYDEBUG(475, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy561;
		if (yych == 'l') goto yy561;
		goto yy47;
yy476:
		YYDEBUG(476, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'F') goto yy562;
		if (yych == 'f') goto yy562;
		goto yy47;
yy477:
		YYDEBUG(477, *YYCURSOR);
		yyaccept = 40;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy478:
		YYDEBUG(478, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_EMPTY);
}
yy479:
		YYDEBUG(479, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy564;
		if (yych == 'c') goto yy564;
		goto yy47;
yy480:
		YYDEBUG(480, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy565;
		if (yych == 'r') goto yy565;
		goto yy47;
yy481:
		YYDEBUG(481, *YYCURSOR);
		yyaccept = 41;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy482:
		YYDEBUG(482, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ENDIF);
}
yy483:
		YYDEBUG(483, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy567;
		if (yych == 'i') goto yy567;
		goto yy47;
yy484:
		YYDEBUG(484, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy568;
		if (yych == 'i') goto yy568;
		goto yy47;
yy485:
		YYDEBUG(485, *YYCURSOR);
		++YYCURSOR;
		YYFILL(10);
		yych = *YYCURSOR;
		YYDEBUG(486, *YYCURSOR);
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych <= '\f') {
					if (yych <= 0x08) goto yy85;
					if (yych <= '\n') goto yy485;
					goto yy85;
				} else {
					if (yych <= '\r') goto yy485;
					if (yych <= 0x1F) goto yy85;
					goto yy485;
				}
			} else {
				if (yych <= '.') {
					if (yych != '#') goto yy85;
				} else {
					if (yych <= '/') goto yy488;
					if (yych <= '@') goto yy85;
					if (yych <= 'D') goto yy569;
					goto yy571;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych == 'I') goto yy572;
					goto yy569;
				} else {
					if (yych == '_') goto yy569;
					goto yy85;
				}
			} else {
				if (yych <= 'h') {
					if (yych == 'e') goto yy571;
					goto yy569;
				} else {
					if (yych <= 'i') goto yy572;
					if (yych <= 'z') goto yy569;
					if (yych <= 0x7F) goto yy85;
					goto yy569;
				}
			}
		}
yy487:
		YYDEBUG(487, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x00) goto yy85;
			if (yych == '\n') goto yy575;
			goto yy573;
		} else {
			if (yych <= '\r') goto yy575;
			if (yych == '[') goto yy85;
			goto yy573;
		}
yy488:
		YYDEBUG(488, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych == '*') goto yy577;
		if (yych == '/') goto yy573;
		goto yy85;
yy489:
		YYDEBUG(489, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy579;
		if (yych == 'd') goto yy579;
		goto yy47;
yy490:
		YYDEBUG(490, *YYCURSOR);
		yyaccept = 42;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\\') {
			if (yych <= 'K') {
				if (yych <= '/') goto yy491;
				if (yych <= '9') goto yy46;
				if (yych >= 'A') goto yy46;
			} else {
				if (yych <= 'L') goto yy580;
				if (yych <= 'Z') goto yy46;
				if (yych >= '\\') goto yy162;
			}
		} else {
			if (yych <= 'k') {
				if (yych == '_') goto yy46;
				if (yych >= 'a') goto yy46;
			} else {
				if (yych <= 'l') goto yy580;
				if (yych <= 'z') goto yy46;
				if (yych >= 0x80) goto yy46;
			}
		}
yy491:
		YYDEBUG(491, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FINAL);
}
yy492:
		YYDEBUG(492, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy581;
		if (yych == 'c') goto yy581;
		goto yy47;
yy493:
		YYDEBUG(493, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy582;
		if (yych == 'i') goto yy582;
		goto yy47;
yy494:
		YYDEBUG(494, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy583;
		if (yych == 'l') goto yy583;
		goto yy47;
yy495:
		YYDEBUG(495, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'M') goto yy585;
		if (yych == 'm') goto yy585;
		goto yy47;
yy496:
		YYDEBUG(496, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy586;
		if (yych == 'd') goto yy586;
		goto yy47;
yy497:
		YYDEBUG(497, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy587;
		if (yych == 'n') goto yy587;
		goto yy47;
yy498:
		YYDEBUG(498, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy588;
		if (yych == 'a') goto yy588;
		goto yy47;
yy499:
		YYDEBUG(499, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'F') goto yy589;
		if (yych == 'f') goto yy589;
		goto yy47;
yy500:
		YYDEBUG(500, *YYCURSOR);
		yyaccept = 43;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy501:
		YYDEBUG(501, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ISSET);
}
yy502:
		YYDEBUG(502, *YYCURSOR);
		yyaccept = 44;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy503:
		YYDEBUG(503, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_MATCH);
}
yy504:
		YYDEBUG(504, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'P') goto yy590;
		if (yych == 'p') goto yy590;
		goto yy47;
yy505:
		YYDEBUG(505, *YYCURSOR);
		yyaccept = 45;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy506:
		YYDEBUG(506, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_PRINT);
}
yy507:
		YYDEBUG(507, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy591;
		if (yych == 't') goto yy591;
		goto yy47;
yy508:
		YYDEBUG(508, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy592;
		if (yych == 'c') goto yy592;
		goto yy47;
yy509:
		YYDEBUG(509, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy593;
		if (yych == 'c') goto yy593;
		goto yy47;
yy510:
		YYDEBUG(510, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy595;
		if (yych == 'n') goto yy595;
		goto yy47;
yy511:
		YYDEBUG(511, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy596;
		if (yych == 'r') goto yy596;
		goto yy47;
yy512:
		YYDEBUG(512, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy597;
		if (yych == 'n') goto yy597;
		goto yy47;
yy513:
		YYDEBUG(513, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy599;
		if (yych == 'c') goto yy599;
		goto yy47;
yy514:
		YYDEBUG(514, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy601;
		if (yych == 'h') goto yy601;
		goto yy47;
yy515:
		YYDEBUG(515, *YYCURSOR);
		yyaccept = 46;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy516:
		YYDEBUG(516, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_THROW);
}
yy517:
		YYDEBUG(517, *YYCURSOR);
		yyaccept = 47;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy518:
		YYDEBUG(518, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_TRAIT);
}
yy519:
		YYDEBUG(519, *YYCURSOR);
		yyaccept = 48;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy520:
		YYDEBUG(520, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_UNSET);
}
yy521:
		YYDEBUG(521, *YYCURSOR);
		yyaccept = 49;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy522:
		YYDEBUG(522, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_WHILE);
}
yy523:
		YYDEBUG(523, *YYCURSOR);
		yyaccept = 50;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych <= ' ') {
			if (yych <= '\f') {
				if (yych <= 0x08) goto yy524;
				if (yych <= '\n') goto yy603;
			} else {
				if (yych <= '\r') goto yy603;
				if (yych >= ' ') goto yy603;
			}
		} else {
			if (yych <= '.') {
				if (yych == '#') goto yy605;
			} else {
				if (yych <= '/') goto yy606;
				if (yych == '\\') goto yy162;
			}
		}
yy524:
		YYDEBUG(524, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_YIELD);
}
yy525:
		YYDEBUG(525, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy607;
		if (yych == 's') goto yy607;
		goto yy47;
yy526:
		YYDEBUG(526, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy608;
		goto yy47;
yy527:
		YYDEBUG(527, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy609;
		if (yych == 'e') goto yy609;
		goto yy47;
yy528:
		YYDEBUG(528, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy610;
		if (yych == 'c') goto yy610;
		goto yy47;
yy529:
		YYDEBUG(529, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy611;
		if (yych == 't') goto yy611;
		goto yy47;
yy530:
		YYDEBUG(530, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy612;
		if (yych == 'e') goto yy612;
		goto yy47;
yy531:
		YYDEBUG(531, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy613;
		if (yych == 'h') goto yy613;
		goto yy47;
yy532:
		YYDEBUG(532, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy614;
		if (yych == 'e') goto yy614;
		goto yy47;
yy533:
		YYDEBUG(533, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy615;
		if (yych == 'i') goto yy615;
		goto yy47;
yy534:
		YYDEBUG(534, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(535, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy349;
		}
		if (yych <= ' ') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy85;
				if (yych <= 0x08) goto yy226;
				goto yy534;
			} else {
				if (yych == '\r') goto yy534;
				if (yych <= 0x1F) goto yy226;
				goto yy534;
			}
		} else {
			if (yych <= '$') {
				if (yych <= '"') goto yy226;
				if (yych <= '#') goto yy616;
				goto yy617;
			} else {
				if (yych <= '-') goto yy226;
				if (yych <= '.') goto yy618;
				if (yych <= '/') goto yy619;
				goto yy226;
			}
		}
yy536:
		YYDEBUG(536, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(537, *YYCURSOR);
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy85;
				goto yy435;
			} else {
				if (yych <= '\n') goto yy534;
				if (yych <= '\f') goto yy435;
				goto yy534;
			}
		} else {
			if (yych <= '*') {
				if (yych <= ')') goto yy435;
				goto yy536;
			} else {
				if (yych == '/') goto yy223;
				goto yy435;
			}
		}
yy538:
		YYDEBUG(538, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(539, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy538;
			goto yy85;
		} else {
			if (yych <= ' ') goto yy538;
			if (yych == ')') goto yy620;
			goto yy85;
		}
yy540:
		YYDEBUG(540, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy622;
		if (yych == 'y') goto yy622;
		goto yy85;
yy541:
		YYDEBUG(541, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy542:
		YYDEBUG(542, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy541;
			goto yy85;
		} else {
			if (yych <= ' ') goto yy541;
			if (yych != ')') goto yy85;
		}
		YYDEBUG(543, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(544, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_BOOL_CAST);
}
yy545:
		YYDEBUG(545, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy624;
		if (yych == 'a') goto yy624;
		goto yy85;
yy546:
		YYDEBUG(546, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy547;
		if (yych != 'e') goto yy85;
yy547:
		YYDEBUG(547, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(548, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy547;
			goto yy85;
		} else {
			if (yych <= ' ') goto yy547;
			if (yych == ')') goto yy625;
			goto yy85;
		}
yy549:
		YYDEBUG(549, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy627;
		if (yych == 'e') goto yy627;
		goto yy85;
yy550:
		YYDEBUG(550, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy628;
		if (yych == 't') goto yy628;
		goto yy85;
yy551:
		YYDEBUG(551, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(552, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (PARSER_MODE()) {
		zend_throw_exception(zend_ce_parse_error, "The (real) cast has been removed, use (float) instead", 0);
		RETURN_TOKEN(T_ERROR);
	}
	RETURN_TOKEN(T_DOUBLE_CAST);
}
yy553:
		YYDEBUG(553, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'G') goto yy622;
		if (yych == 'g') goto yy622;
		goto yy85;
yy554:
		YYDEBUG(554, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(555, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy554;
			goto yy85;
		} else {
			if (yych <= ' ') goto yy554;
			if (yych == ')') goto yy630;
			goto yy85;
		}
yy556:
		YYDEBUG(556, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy456;
		if (yych == '\r') goto yy458;
		goto yy85;
yy557:
		YYDEBUG(557, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy632;
		if (yych == 'c') goto yy632;
		goto yy47;
yy558:
		YYDEBUG(558, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy633;
		if (yych == 'l') goto yy633;
		goto yy47;
yy559:
		YYDEBUG(559, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'U') goto yy634;
		if (yych == 'u') goto yy634;
		goto yy47;
yy560:
		YYDEBUG(560, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy635;
		if (yych == 'e') goto yy635;
		goto yy47;
yy561:
		YYDEBUG(561, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy637;
		if (yych == 't') goto yy637;
		goto yy47;
yy562:
		YYDEBUG(562, *YYCURSOR);
		yyaccept = 51;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy563:
		YYDEBUG(563, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ELSEIF);
}
yy564:
		YYDEBUG(564, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy639;
		if (yych == 'l') goto yy639;
		goto yy47;
yy565:
		YYDEBUG(565, *YYCURSOR);
		yyaccept = 52;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\\') {
			if (yych <= 'D') {
				if (yych <= '/') goto yy566;
				if (yych <= '9') goto yy46;
				if (yych >= 'A') goto yy46;
			} else {
				if (yych <= 'E') goto yy640;
				if (yych <= 'Z') goto yy46;
				if (yych >= '\\') goto yy162;
			}
		} else {
			if (yych <= 'd') {
				if (yych == '_') goto yy46;
				if (yych >= 'a') goto yy46;
			} else {
				if (yych <= 'e') goto yy640;
				if (yych <= 'z') goto yy46;
				if (yych >= 0x80) goto yy46;
			}
		}
yy566:
		YYDEBUG(566, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ENDFOR);
}
yy567:
		YYDEBUG(567, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy641;
		if (yych == 't') goto yy641;
		goto yy47;
yy568:
		YYDEBUG(568, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy642;
		if (yych == 'l') goto yy642;
		goto yy47;
yy569:
		YYDEBUG(569, *YYCURSOR);
		++YYCURSOR;
yy570:
		YYDEBUG(570, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(4);
	RETURN_TOKEN_WITH_IDENT(T_ENUM);
}
yy571:
		YYDEBUG(571, *YYCURSOR);
		yyaccept = 53;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'X') goto yy643;
		if (yych == 'x') goto yy643;
		goto yy570;
yy572:
		YYDEBUG(572, *YYCURSOR);
		yyaccept = 53;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'M') goto yy644;
		if (yych == 'm') goto yy644;
		goto yy570;
yy573:
		YYDEBUG(573, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(574, *YYCURSOR);
		if (yych <= '\n') {
			if (yych <= 0x00) goto yy85;
			if (yych <= '\t') goto yy573;
			goto yy485;
		} else {
			if (yych == '\r') goto yy485;
			goto yy573;
		}
yy575:
		YYDEBUG(575, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(576, *YYCURSOR);
		if (yych <= 'D') {
			if (yych <= 0x1F) {
				if (yych <= '\t') {
					if (yych <= 0x00) goto yy85;
					if (yych <= 0x08) goto yy573;
					goto yy575;
				} else {
					if (yych <= '\n') goto yy485;
					if (yych == '\r') goto yy485;
					goto yy573;
				}
			} else {
				if (yych <= '#') {
					if (yych <= ' ') goto yy575;
					if (yych <= '"') goto yy573;
					goto yy645;
				} else {
					if (yych == '/') goto yy646;
					if (yych <= '@') goto yy573;
					goto yy647;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'I') {
					if (yych <= 'E') goto yy648;
					if (yych <= 'H') goto yy647;
					goto yy649;
				} else {
					if (yych <= 'Z') goto yy647;
					if (yych == '_') goto yy647;
					goto yy573;
				}
			} else {
				if (yych <= 'h') {
					if (yych == 'e') goto yy648;
					goto yy647;
				} else {
					if (yych <= 'i') goto yy649;
					if (yych <= 'z') goto yy647;
					if (yych <= 0x7F) goto yy573;
					goto yy647;
				}
			}
		}
yy577:
		YYDEBUG(577, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(578, *YYCURSOR);
		if (yych <= 0x00) goto yy85;
		if (yych == '*') goto yy650;
		goto yy577;
yy579:
		YYDEBUG(579, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy652;
		if (yych == 's') goto yy652;
		goto yy47;
yy580:
		YYDEBUG(580, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'Y') goto yy654;
		if (yych == 'y') goto yy654;
		goto yy47;
yy581:
		YYDEBUG(581, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy656;
		if (yych == 'h') goto yy656;
		goto yy47;
yy582:
		YYDEBUG(582, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy658;
		if (yych == 'o') goto yy658;
		goto yy47;
yy583:
		YYDEBUG(583, *YYCURSOR);
		yyaccept = 54;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy584:
		YYDEBUG(584, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_GLOBAL);
}
yy585:
		YYDEBUG(585, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy659;
		if (yych == 'e') goto yy659;
		goto yy47;
yy586:
		YYDEBUG(586, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy660;
		if (yych == 'e') goto yy660;
		goto yy47;
yy587:
		YYDEBUG(587, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy662;
		if (yych == 'c') goto yy662;
		goto yy47;
yy588:
		YYDEBUG(588, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy663;
		if (yych == 'd') goto yy663;
		goto yy47;
yy589:
		YYDEBUG(589, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy664;
		if (yych == 'a') goto yy664;
		goto yy47;
yy590:
		YYDEBUG(590, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy665;
		if (yych == 'a') goto yy665;
		goto yy47;
yy591:
		YYDEBUG(591, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy666;
		if (yych == 'e') goto yy666;
		goto yy47;
yy592:
		YYDEBUG(592, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy668;
		if (yych == 't') goto yy668;
		goto yy47;
yy593:
		YYDEBUG(593, *YYCURSOR);
		yyaccept = 55;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy594:
		YYDEBUG(594, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_PUBLIC);
}
yy595:
		YYDEBUG(595, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy669;
		if (yych == 'l') goto yy669;
		goto yy47;
yy596:
		YYDEBUG(596, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy670;
		if (yych == 'e') goto yy670;
		goto yy47;
yy597:
		YYDEBUG(597, *YYCURSOR);
		yyaccept = 56;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy598:
		YYDEBUG(598, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_RETURN);
}
yy599:
		YYDEBUG(599, *YYCURSOR);
		yyaccept = 57;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy600:
		YYDEBUG(600, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_STATIC);
}
yy601:
		YYDEBUG(601, *YYCURSOR);
		yyaccept = 58;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy602:
		YYDEBUG(602, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_SWITCH);
}
yy603:
		YYDEBUG(603, *YYCURSOR);
		++YYCURSOR;
		YYFILL(5);
		yych = *YYCURSOR;
		YYDEBUG(604, *YYCURSOR);
		if (yych <= '"') {
			if (yych <= '\f') {
				if (yych <= 0x08) goto yy85;
				if (yych <= '\n') goto yy603;
				goto yy85;
			} else {
				if (yych <= '\r') goto yy603;
				if (yych == ' ') goto yy603;
				goto yy85;
			}
		} else {
			if (yych <= 'E') {
				if (yych <= '#') goto yy605;
				if (yych == '/') goto yy606;
				goto yy85;
			} else {
				if (yych <= 'F') goto yy672;
				if (yych == 'f') goto yy672;
				goto yy85;
			}
		}
yy605:
		YYDEBUG(605, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x00) goto yy85;
			if (yych == '\n') goto yy675;
			goto yy673;
		} else {
			if (yych <= '\r') goto yy675;
			if (yych == '[') goto yy85;
			goto yy673;
		}
yy606:
		YYDEBUG(606, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych == '*') goto yy677;
		if (yych == '/') goto yy673;
		goto yy85;
yy607:
		YYDEBUG(607, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy679;
		if (yych == 's') goto yy679;
		goto yy47;
yy608:
		YYDEBUG(608, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy680;
		goto yy47;
yy609:
		YYDEBUG(609, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy682;
		goto yy47;
yy610:
		YYDEBUG(610, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy683;
		if (yych == 't') goto yy683;
		goto yy47;
yy611:
		YYDEBUG(611, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy684;
		goto yy47;
yy612:
		YYDEBUG(612, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy685;
		goto yy47;
yy613:
		YYDEBUG(613, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy686;
		if (yych == 'o') goto yy686;
		goto yy47;
yy614:
		YYDEBUG(614, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy687;
		if (yych == 's') goto yy687;
		goto yy47;
yy615:
		YYDEBUG(615, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy688;
		if (yych == 't') goto yy688;
		goto yy47;
yy616:
		YYDEBUG(616, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy85;
				goto yy435;
			} else {
				if (yych <= '\n') goto yy689;
				if (yych <= '\f') goto yy435;
				goto yy689;
			}
		} else {
			if (yych <= '*') {
				if (yych <= ')') goto yy435;
				goto yy536;
			} else {
				if (yych == '[') goto yy226;
				goto yy435;
			}
		}
yy617:
		YYDEBUG(617, *YYCURSOR);
		yyaccept = 26;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 4) {
			goto yy226;
		}
		if (yych <= 0x00) goto yy88;
		goto yy349;
yy618:
		YYDEBUG(618, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy349;
		}
		if (yych <= 0x00) goto yy85;
		if (yych == '.') goto yy691;
		goto yy226;
yy619:
		YYDEBUG(619, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '*') {
			if (yych <= 0x00) goto yy85;
			if (yych <= ')') goto yy226;
			goto yy692;
		} else {
			if (yych == '/') goto yy435;
			goto yy226;
		}
yy620:
		YYDEBUG(620, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(621, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_ARRAY_CAST);
}
yy622:
		YYDEBUG(622, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(623, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy622;
			goto yy85;
		} else {
			if (yych <= ' ') goto yy622;
			if (yych == ')') goto yy693;
			goto yy85;
		}
yy624:
		YYDEBUG(624, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy541;
		if (yych == 'n') goto yy541;
		goto yy85;
yy625:
		YYDEBUG(625, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(626, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_DOUBLE_CAST);
}
yy627:
		YYDEBUG(627, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy442;
		if (yych == 'r') goto yy442;
		goto yy85;
yy628:
		YYDEBUG(628, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(629, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy628;
			goto yy85;
		} else {
			if (yych <= ' ') goto yy628;
			if (yych == ')') goto yy695;
			goto yy85;
		}
yy630:
		YYDEBUG(630, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(631, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_UNSET_CAST);
}
yy632:
		YYDEBUG(632, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy697;
		if (yych == 't') goto yy697;
		goto yy47;
yy633:
		YYDEBUG(633, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy699;
		if (yych == 'e') goto yy699;
		goto yy47;
yy634:
		YYDEBUG(634, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy701;
		if (yych == 'e') goto yy701;
		goto yy47;
yy635:
		YYDEBUG(635, *YYCURSOR);
		yyaccept = 59;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy636:
		YYDEBUG(636, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_DECLARE);
}
yy637:
		YYDEBUG(637, *YYCURSOR);
		yyaccept = 60;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy638:
		YYDEBUG(638, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_DEFAULT);
}
yy639:
		YYDEBUG(639, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy703;
		if (yych == 'a') goto yy703;
		goto yy47;
yy640:
		YYDEBUG(640, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy704;
		if (yych == 'a') goto yy704;
		goto yy47;
yy641:
		YYDEBUG(641, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy705;
		if (yych == 'c') goto yy705;
		goto yy47;
yy642:
		YYDEBUG(642, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy706;
		if (yych == 'e') goto yy706;
		goto yy47;
yy643:
		YYDEBUG(643, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy708;
		if (yych == 't') goto yy708;
		goto yy85;
yy644:
		YYDEBUG(644, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy709;
		if (yych == 'p') goto yy709;
		goto yy85;
yy645:
		YYDEBUG(645, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\n') {
			if (yych <= 0x00) goto yy85;
			if (yych <= '\t') goto yy573;
			goto yy575;
		} else {
			if (yych == '\r') goto yy575;
			goto yy573;
		}
yy646:
		YYDEBUG(646, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x00) goto yy85;
			if (yych == '\n') goto yy485;
			goto yy573;
		} else {
			if (yych <= '\r') goto yy485;
			if (yych == '*') goto yy710;
			goto yy573;
		}
yy647:
		YYDEBUG(647, *YYCURSOR);
		yyaccept = 53;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\n') {
			if (yych <= 0x00) goto yy570;
			if (yych <= '\t') goto yy573;
			goto yy485;
		} else {
			if (yych == '\r') goto yy485;
			goto yy573;
		}
yy648:
		YYDEBUG(648, *YYCURSOR);
		yyaccept = 53;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy570;
				goto yy573;
			} else {
				if (yych <= '\n') goto yy485;
				if (yych <= '\f') goto yy573;
				goto yy485;
			}
		} else {
			if (yych <= 'X') {
				if (yych <= 'W') goto yy573;
				goto yy712;
			} else {
				if (yych == 'x') goto yy712;
				goto yy573;
			}
		}
yy649:
		YYDEBUG(649, *YYCURSOR);
		yyaccept = 53;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy570;
				goto yy573;
			} else {
				if (yych <= '\n') goto yy485;
				if (yych <= '\f') goto yy573;
				goto yy485;
			}
		} else {
			if (yych <= 'M') {
				if (yych <= 'L') goto yy573;
				goto yy713;
			} else {
				if (yych == 'm') goto yy713;
				goto yy573;
			}
		}
yy650:
		YYDEBUG(650, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(651, *YYCURSOR);
		if (yych <= '*') {
			if (yych <= 0x00) goto yy85;
			if (yych <= ')') goto yy577;
			goto yy650;
		} else {
			if (yych == '/') goto yy485;
			goto yy577;
		}
yy652:
		YYDEBUG(652, *YYCURSOR);
		yyaccept = 61;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy653:
		YYDEBUG(653, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_EXTENDS);
}
yy654:
		YYDEBUG(654, *YYCURSOR);
		yyaccept = 62;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy655:
		YYDEBUG(655, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FINALLY);
}
yy656:
		YYDEBUG(656, *YYCURSOR);
		yyaccept = 63;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy657:
		YYDEBUG(657, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FOREACH);
}
yy658:
		YYDEBUG(658, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy714;
		if (yych == 'n') goto yy714;
		goto yy47;
yy659:
		YYDEBUG(659, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy716;
		if (yych == 'n') goto yy716;
		goto yy47;
yy660:
		YYDEBUG(660, *YYCURSOR);
		yyaccept = 64;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\\') {
			if (yych <= '@') {
				if (yych <= '/') goto yy661;
				if (yych <= '9') goto yy46;
			} else {
				if (yych <= 'Z') goto yy46;
				if (yych >= '\\') goto yy162;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy717;
			} else {
				if (yych <= 'z') goto yy46;
				if (yych >= 0x80) goto yy46;
			}
		}
yy661:
		YYDEBUG(661, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_INCLUDE);
}
yy662:
		YYDEBUG(662, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy718;
		if (yych == 'e') goto yy718;
		goto yy47;
yy663:
		YYDEBUG(663, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy719;
		if (yych == 'o') goto yy719;
		goto yy47;
yy664:
		YYDEBUG(664, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy720;
		if (yych == 'c') goto yy720;
		goto yy47;
yy665:
		YYDEBUG(665, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy721;
		if (yych == 'c') goto yy721;
		goto yy47;
yy666:
		YYDEBUG(666, *YYCURSOR);
		yyaccept = 65;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy667:
		YYDEBUG(667, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_PRIVATE);
}
yy668:
		YYDEBUG(668, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy722;
		if (yych == 'e') goto yy722;
		goto yy47;
yy669:
		YYDEBUG(669, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'Y') goto yy723;
		if (yych == 'y') goto yy723;
		goto yy47;
yy670:
		YYDEBUG(670, *YYCURSOR);
		yyaccept = 66;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\\') {
			if (yych <= '@') {
				if (yych <= '/') goto yy671;
				if (yych <= '9') goto yy46;
			} else {
				if (yych <= 'Z') goto yy46;
				if (yych >= '\\') goto yy162;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy725;
			} else {
				if (yych <= 'z') goto yy46;
				if (yych >= 0x80) goto yy46;
			}
		}
yy671:
		YYDEBUG(671, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_REQUIRE);
}
yy672:
		YYDEBUG(672, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy726;
		if (yych == 'r') goto yy726;
		goto yy85;
yy673:
		YYDEBUG(673, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(674, *YYCURSOR);
		if (yych <= '\n') {
			if (yych <= 0x00) goto yy85;
			if (yych <= '\t') goto yy673;
			goto yy603;
		} else {
			if (yych == '\r') goto yy603;
			goto yy673;
		}
yy675:
		YYDEBUG(675, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(676, *YYCURSOR);
		if (yych <= ' ') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy85;
				if (yych <= 0x08) goto yy673;
				if (yych <= '\t') goto yy675;
				goto yy603;
			} else {
				if (yych == '\r') goto yy603;
				if (yych <= 0x1F) goto yy673;
				goto yy675;
			}
		} else {
			if (yych <= '/') {
				if (yych == '#') goto yy727;
				if (yych <= '.') goto yy673;
				goto yy728;
			} else {
				if (yych <= 'F') {
					if (yych <= 'E') goto yy673;
					goto yy729;
				} else {
					if (yych == 'f') goto yy729;
					goto yy673;
				}
			}
		}
yy677:
		YYDEBUG(677, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(678, *YYCURSOR);
		if (yych <= 0x00) goto yy85;
		if (yych == '*') goto yy730;
		goto yy677;
yy679:
		YYDEBUG(679, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy732;
		goto yy47;
yy680:
		YYDEBUG(680, *YYCURSOR);
		yyaccept = 67;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy681:
		YYDEBUG(681, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_DIR);
}
yy682:
		YYDEBUG(682, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy733;
		goto yy47;
yy683:
		YYDEBUG(683, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy735;
		if (yych == 'i') goto yy735;
		goto yy47;
yy684:
		YYDEBUG(684, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy736;
		if (yych == 'c') goto yy736;
		goto yy47;
yy685:
		YYDEBUG(685, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy737;
		goto yy47;
yy686:
		YYDEBUG(686, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy739;
		if (yych == 'd') goto yy739;
		goto yy47;
yy687:
		YYDEBUG(687, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'P') goto yy740;
		if (yych == 'p') goto yy740;
		goto yy47;
yy688:
		YYDEBUG(688, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy741;
		goto yy47;
yy689:
		YYDEBUG(689, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(690, *YYCURSOR);
		if (yych <= ' ') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy85;
				if (yych <= 0x08) goto yy435;
				if (yych <= '\t') goto yy689;
				goto yy534;
			} else {
				if (yych == '\r') goto yy534;
				if (yych <= 0x1F) goto yy435;
				goto yy689;
			}
		} else {
			if (yych <= ')') {
				if (yych <= '"') goto yy435;
				if (yych <= '#') goto yy742;
				if (yych <= '$') goto yy743;
				goto yy435;
			} else {
				if (yych <= '-') {
					if (yych <= '*') goto yy536;
					goto yy435;
				} else {
					if (yych <= '.') goto yy744;
					if (yych <= '/') goto yy745;
					goto yy435;
				}
			}
		}
yy691:
		YYDEBUG(691, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy349;
		}
		if (yych <= 0x00) goto yy85;
		if (yych == '.') goto yy617;
		goto yy226;
yy692:
		YYDEBUG(692, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy349;
		}
		if (yych <= 0x00) goto yy85;
		if (yych == '/') goto yy534;
		goto yy226;
yy693:
		YYDEBUG(693, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(694, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_STRING_CAST);
}
yy695:
		YYDEBUG(695, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(696, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_OBJECT_CAST);
}
yy697:
		YYDEBUG(697, *YYCURSOR);
		yyaccept = 68;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy698:
		YYDEBUG(698, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ABSTRACT);
}
yy699:
		YYDEBUG(699, *YYCURSOR);
		yyaccept = 69;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy700:
		YYDEBUG(700, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CALLABLE);
}
yy701:
		YYDEBUG(701, *YYCURSOR);
		yyaccept = 70;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy702:
		YYDEBUG(702, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CONTINUE);
}
yy703:
		YYDEBUG(703, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy746;
		if (yych == 'r') goto yy746;
		goto yy47;
yy704:
		YYDEBUG(704, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy747;
		if (yych == 'c') goto yy747;
		goto yy47;
yy705:
		YYDEBUG(705, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy748;
		if (yych == 'h') goto yy748;
		goto yy47;
yy706:
		YYDEBUG(706, *YYCURSOR);
		yyaccept = 71;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy707:
		YYDEBUG(707, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ENDWHILE);
}
yy708:
		YYDEBUG(708, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy750;
		if (yych == 'e') goto yy750;
		goto yy85;
yy709:
		YYDEBUG(709, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy751;
		if (yych == 'l') goto yy751;
		goto yy85;
yy710:
		YYDEBUG(710, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(711, *YYCURSOR);
		if (yych <= '\f') {
			if (yych <= 0x00) goto yy85;
			if (yych == '\n') goto yy752;
			goto yy710;
		} else {
			if (yych <= '\r') goto yy752;
			if (yych == '*') goto yy754;
			goto yy710;
		}
yy712:
		YYDEBUG(712, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy85;
				goto yy573;
			} else {
				if (yych <= '\n') goto yy485;
				if (yych <= '\f') goto yy573;
				goto yy485;
			}
		} else {
			if (yych <= 'T') {
				if (yych <= 'S') goto yy573;
				goto yy756;
			} else {
				if (yych == 't') goto yy756;
				goto yy573;
			}
		}
yy713:
		YYDEBUG(713, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy85;
				goto yy573;
			} else {
				if (yych <= '\n') goto yy485;
				if (yych <= '\f') goto yy573;
				goto yy485;
			}
		} else {
			if (yych <= 'P') {
				if (yych <= 'O') goto yy573;
				goto yy757;
			} else {
				if (yych == 'p') goto yy757;
				goto yy573;
			}
		}
yy714:
		YYDEBUG(714, *YYCURSOR);
		yyaccept = 72;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy715:
		YYDEBUG(715, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FUNCTION);
}
yy716:
		YYDEBUG(716, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy758;
		if (yych == 't') goto yy758;
		goto yy47;
yy717:
		YYDEBUG(717, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy759;
		if (yych == 'o') goto yy759;
		goto yy47;
yy718:
		YYDEBUG(718, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy760;
		if (yych == 'o') goto yy760;
		goto yy47;
yy719:
		YYDEBUG(719, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'F') goto yy761;
		if (yych == 'f') goto yy761;
		goto yy47;
yy720:
		YYDEBUG(720, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy763;
		if (yych == 'e') goto yy763;
		goto yy47;
yy721:
		YYDEBUG(721, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy765;
		if (yych == 'e') goto yy765;
		goto yy47;
yy722:
		YYDEBUG(722, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy767;
		if (yych == 'd') goto yy767;
		goto yy47;
yy723:
		YYDEBUG(723, *YYCURSOR);
		yyaccept = 73;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy724:
		YYDEBUG(724, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_READONLY);
}
yy725:
		YYDEBUG(725, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy769;
		if (yych == 'o') goto yy769;
		goto yy47;
yy726:
		YYDEBUG(726, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy770;
		if (yych == 'o') goto yy770;
		goto yy85;
yy727:
		YYDEBUG(727, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\n') {
			if (yych <= 0x00) goto yy85;
			if (yych <= '\t') goto yy673;
			goto yy675;
		} else {
			if (yych == '\r') goto yy675;
			goto yy673;
		}
yy728:
		YYDEBUG(728, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x00) goto yy85;
			if (yych == '\n') goto yy603;
			goto yy673;
		} else {
			if (yych <= '\r') goto yy603;
			if (yych == '*') goto yy771;
			goto yy673;
		}
yy729:
		YYDEBUG(729, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy85;
				goto yy673;
			} else {
				if (yych <= '\n') goto yy603;
				if (yych <= '\f') goto yy673;
				goto yy603;
			}
		} else {
			if (yych <= 'R') {
				if (yych <= 'Q') goto yy673;
				goto yy773;
			} else {
				if (yych == 'r') goto yy773;
				goto yy673;
			}
		}
yy730:
		YYDEBUG(730, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(731, *YYCURSOR);
		if (yych <= '*') {
			if (yych <= 0x00) goto yy85;
			if (yych <= ')') goto yy677;
			goto yy730;
		} else {
			if (yych == '/') goto yy603;
			goto yy677;
		}
yy732:
		YYDEBUG(732, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy774;
		goto yy47;
yy733:
		YYDEBUG(733, *YYCURSOR);
		yyaccept = 74;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy734:
		YYDEBUG(734, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FILE);
}
yy735:
		YYDEBUG(735, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy776;
		if (yych == 'o') goto yy776;
		goto yy47;
yy736:
		YYDEBUG(736, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy777;
		if (yych == 'o') goto yy777;
		goto yy47;
yy737:
		YYDEBUG(737, *YYCURSOR);
		yyaccept = 75;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy738:
		YYDEBUG(738, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_LINE);
}
yy739:
		YYDEBUG(739, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy778;
		goto yy47;
yy740:
		YYDEBUG(740, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy779;
		if (yych == 'a') goto yy779;
		goto yy47;
yy741:
		YYDEBUG(741, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy780;
		goto yy47;
yy742:
		YYDEBUG(742, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy435;
		}
		if (yych <= 0x00) goto yy85;
		if (yych <= '\r') goto yy689;
		goto yy536;
yy743:
		YYDEBUG(743, *YYCURSOR);
		yyaccept = 26;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy435;
		}
		if (yych <= 0x00) goto yy88;
		if (yych <= '\r') goto yy534;
		goto yy536;
yy744:
		YYDEBUG(744, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy85;
				goto yy435;
			} else {
				if (yych <= '\n') goto yy534;
				if (yych <= '\f') goto yy435;
				goto yy534;
			}
		} else {
			if (yych <= '*') {
				if (yych <= ')') goto yy435;
				goto yy536;
			} else {
				if (yych == '.') goto yy782;
				goto yy435;
			}
		}
yy745:
		YYDEBUG(745, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy435;
		}
		if (yych <= 0x00) goto yy85;
		if (yych <= '\r') goto yy534;
		goto yy783;
yy746:
		YYDEBUG(746, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy784;
		if (yych == 'e') goto yy784;
		goto yy47;
yy747:
		YYDEBUG(747, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy786;
		if (yych == 'h') goto yy786;
		goto yy47;
yy748:
		YYDEBUG(748, *YYCURSOR);
		yyaccept = 76;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy749:
		YYDEBUG(749, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ENDSWITCH);
}
yy750:
		YYDEBUG(750, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy788;
		if (yych == 'n') goto yy788;
		goto yy85;
yy751:
		YYDEBUG(751, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy789;
		if (yych == 'e') goto yy789;
		goto yy85;
yy752:
		YYDEBUG(752, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(753, *YYCURSOR);
		if (yych <= '@') {
			if (yych <= ' ') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy85;
					if (yych <= 0x08) goto yy577;
					goto yy752;
				} else {
					if (yych == '\r') goto yy752;
					if (yych <= 0x1F) goto yy577;
					goto yy752;
				}
			} else {
				if (yych <= ')') {
					if (yych == '#') goto yy790;
					goto yy577;
				} else {
					if (yych <= '*') goto yy650;
					if (yych == '/') goto yy791;
					goto yy577;
				}
			}
		} else {
			if (yych <= '_') {
				if (yych <= 'H') {
					if (yych == 'E') goto yy793;
					goto yy792;
				} else {
					if (yych <= 'I') goto yy794;
					if (yych <= 'Z') goto yy792;
					if (yych <= '^') goto yy577;
					goto yy792;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= '`') goto yy577;
					if (yych == 'e') goto yy793;
					goto yy792;
				} else {
					if (yych <= 'i') goto yy794;
					if (yych <= 'z') goto yy792;
					if (yych <= 0x7F) goto yy577;
					goto yy792;
				}
			}
		}
yy754:
		YYDEBUG(754, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(755, *YYCURSOR);
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy85;
				goto yy710;
			} else {
				if (yych <= '\n') goto yy752;
				if (yych <= '\f') goto yy710;
				goto yy752;
			}
		} else {
			if (yych <= '*') {
				if (yych <= ')') goto yy710;
				goto yy754;
			} else {
				if (yych == '/') goto yy575;
				goto yy710;
			}
		}
yy756:
		YYDEBUG(756, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy85;
				goto yy573;
			} else {
				if (yych <= '\n') goto yy485;
				if (yych <= '\f') goto yy573;
				goto yy485;
			}
		} else {
			if (yych <= 'E') {
				if (yych <= 'D') goto yy573;
				goto yy795;
			} else {
				if (yych == 'e') goto yy795;
				goto yy573;
			}
		}
yy757:
		YYDEBUG(757, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy85;
				goto yy573;
			} else {
				if (yych <= '\n') goto yy485;
				if (yych <= '\f') goto yy573;
				goto yy485;
			}
		} else {
			if (yych <= 'L') {
				if (yych <= 'K') goto yy573;
				goto yy796;
			} else {
				if (yych == 'l') goto yy796;
				goto yy573;
			}
		}
yy758:
		YYDEBUG(758, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy797;
		if (yych == 's') goto yy797;
		goto yy47;
yy759:
		YYDEBUG(759, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy799;
		if (yych == 'n') goto yy799;
		goto yy47;
yy760:
		YYDEBUG(760, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'F') goto yy800;
		if (yych == 'f') goto yy800;
		goto yy47;
yy761:
		YYDEBUG(761, *YYCURSOR);
		yyaccept = 77;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy762:
		YYDEBUG(762, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
    RETURN_TOKEN_WITH_IDENT(T_INSTEADOF);
}
yy763:
		YYDEBUG(763, *YYCURSOR);
		yyaccept = 78;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy764:
		YYDEBUG(764, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_INTERFACE);
}
yy765:
		YYDEBUG(765, *YYCURSOR);
		yyaccept = 79;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy802;
yy766:
		YYDEBUG(766, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_NAMESPACE);
}
yy767:
		YYDEBUG(767, *YYCURSOR);
		yyaccept = 80;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy768:
		YYDEBUG(768, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_PROTECTED);
}
yy769:
		YYDEBUG(769, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy803;
		if (yych == 'n') goto yy803;
		goto yy47;
yy770:
		YYDEBUG(770, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy804;
		if (yych == 'm') goto yy804;
		goto yy85;
yy771:
		YYDEBUG(771, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(772, *YYCURSOR);
		if (yych <= '\f') {
			if (yych <= 0x00) goto yy85;
			if (yych == '\n') goto yy805;
			goto yy771;
		} else {
			if (yych <= '\r') goto yy805;
			if (yych == '*') goto yy807;
			goto yy771;
		}
yy773:
		YYDEBUG(773, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy85;
				goto yy673;
			} else {
				if (yych <= '\n') goto yy603;
				if (yych <= '\f') goto yy673;
				goto yy603;
			}
		} else {
			if (yych <= 'O') {
				if (yych <= 'N') goto yy673;
				goto yy809;
			} else {
				if (yych == 'o') goto yy809;
				goto yy673;
			}
		}
yy774:
		YYDEBUG(774, *YYCURSOR);
		yyaccept = 81;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy775:
		YYDEBUG(775, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CLASS_C);
}
yy776:
		YYDEBUG(776, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy810;
		if (yych == 'n') goto yy810;
		goto yy47;
yy777:
		YYDEBUG(777, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'M') goto yy811;
		if (yych == 'm') goto yy811;
		goto yy47;
yy778:
		YYDEBUG(778, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy812;
		goto yy47;
yy779:
		YYDEBUG(779, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy814;
		if (yych == 'c') goto yy814;
		goto yy47;
yy780:
		YYDEBUG(780, *YYCURSOR);
		yyaccept = 82;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy781:
		YYDEBUG(781, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_TRAIT_C);
}
yy782:
		YYDEBUG(782, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy85;
				goto yy435;
			} else {
				if (yych <= '\n') goto yy534;
				if (yych <= '\f') goto yy435;
				goto yy534;
			}
		} else {
			if (yych <= '*') {
				if (yych <= ')') goto yy435;
				goto yy536;
			} else {
				if (yych == '.') goto yy743;
				goto yy435;
			}
		}
yy783:
		YYDEBUG(783, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy85;
				goto yy435;
			} else {
				if (yych <= '\n') goto yy534;
				if (yych <= '\f') goto yy435;
				goto yy534;
			}
		} else {
			if (yych <= '*') {
				if (yych <= ')') goto yy435;
				goto yy536;
			} else {
				if (yych == '/') goto yy689;
				goto yy435;
			}
		}
yy784:
		YYDEBUG(784, *YYCURSOR);
		yyaccept = 83;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy785:
		YYDEBUG(785, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ENDDECLARE);
}
yy786:
		YYDEBUG(786, *YYCURSOR);
		yyaccept = 84;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy787:
		YYDEBUG(787, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ENDFOREACH);
}
yy788:
		YYDEBUG(788, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy815;
		if (yych == 'd') goto yy815;
		goto yy85;
yy789:
		YYDEBUG(789, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy816;
		if (yych == 'm') goto yy816;
		goto yy85;
yy790:
		YYDEBUG(790, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy85;
				goto yy710;
			} else {
				if (yych <= '\n') goto yy817;
				if (yych <= '\f') goto yy710;
				goto yy817;
			}
		} else {
			if (yych <= '*') {
				if (yych <= ')') goto yy710;
				goto yy754;
			} else {
				if (yych == '[') goto yy577;
				goto yy710;
			}
		}
yy791:
		YYDEBUG(791, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '*') {
			if (yych <= 0x00) goto yy85;
			if (yych <= ')') goto yy577;
			goto yy819;
		} else {
			if (yych == '/') goto yy710;
			goto yy577;
		}
yy792:
		YYDEBUG(792, *YYCURSOR);
		yyaccept = 53;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 0x00) goto yy570;
		if (yych == '*') goto yy650;
		goto yy577;
yy793:
		YYDEBUG(793, *YYCURSOR);
		yyaccept = 53;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 'W') {
			if (yych <= 0x00) goto yy570;
			if (yych == '*') goto yy650;
			goto yy577;
		} else {
			if (yych <= 'X') goto yy820;
			if (yych == 'x') goto yy820;
			goto yy577;
		}
yy794:
		YYDEBUG(794, *YYCURSOR);
		yyaccept = 53;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 'L') {
			if (yych <= 0x00) goto yy570;
			if (yych == '*') goto yy650;
			goto yy577;
		} else {
			if (yych <= 'M') goto yy821;
			if (yych == 'm') goto yy821;
			goto yy577;
		}
yy795:
		YYDEBUG(795, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy85;
				goto yy573;
			} else {
				if (yych <= '\n') goto yy485;
				if (yych <= '\f') goto yy573;
				goto yy485;
			}
		} else {
			if (yych <= 'N') {
				if (yych <= 'M') goto yy573;
				goto yy822;
			} else {
				if (yych == 'n') goto yy822;
				goto yy573;
			}
		}
yy796:
		YYDEBUG(796, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy85;
				goto yy573;
			} else {
				if (yych <= '\n') goto yy485;
				if (yych <= '\f') goto yy573;
				goto yy485;
			}
		} else {
			if (yych <= 'E') {
				if (yych <= 'D') goto yy573;
				goto yy823;
			} else {
				if (yych == 'e') goto yy823;
				goto yy573;
			}
		}
yy797:
		YYDEBUG(797, *YYCURSOR);
		yyaccept = 85;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy798:
		YYDEBUG(798, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_IMPLEMENTS);
}
yy799:
		YYDEBUG(799, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy824;
		if (yych == 'c') goto yy824;
		goto yy47;
yy800:
		YYDEBUG(800, *YYCURSOR);
		yyaccept = 86;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy801:
		YYDEBUG(801, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_INSTANCEOF);
}
yy802:
		YYDEBUG(802, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy85;
			if (yych <= 'Z') goto yy825;
			if (yych <= '^') goto yy85;
			goto yy825;
		} else {
			if (yych <= '`') goto yy85;
			if (yych <= 'z') goto yy825;
			if (yych <= 0x7F) goto yy85;
			goto yy825;
		}
yy803:
		YYDEBUG(803, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy828;
		if (yych == 'c') goto yy828;
		goto yy47;
yy804:
		YYDEBUG(804, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '^') {
			if (yych <= '9') {
				if (yych <= '/') goto yy829;
				goto yy85;
			} else {
				if (yych <= '@') goto yy829;
				if (yych <= 'Z') goto yy85;
				goto yy829;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy85;
				goto yy829;
			} else {
				if (yych <= 'z') goto yy85;
				if (yych <= 0x7F) goto yy829;
				goto yy85;
			}
		}
yy805:
		YYDEBUG(805, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(806, *YYCURSOR);
		if (yych <= '#') {
			if (yych <= '\f') {
				if (yych <= 0x00) goto yy85;
				if (yych <= 0x08) goto yy677;
				if (yych <= '\n') goto yy805;
				goto yy677;
			} else {
				if (yych <= 0x1F) {
					if (yych <= '\r') goto yy805;
					goto yy677;
				} else {
					if (yych <= ' ') goto yy805;
					if (yych <= '"') goto yy677;
					goto yy831;
				}
			}
		} else {
			if (yych <= '/') {
				if (yych == '*') goto yy730;
				if (yych <= '.') goto yy677;
				goto yy832;
			} else {
				if (yych <= 'F') {
					if (yych <= 'E') goto yy677;
					goto yy833;
				} else {
					if (yych == 'f') goto yy833;
					goto yy677;
				}
			}
		}
yy807:
		YYDEBUG(807, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(808, *YYCURSOR);
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy85;
				goto yy771;
			} else {
				if (yych <= '\n') goto yy805;
				if (yych <= '\f') goto yy771;
				goto yy805;
			}
		} else {
			if (yych <= '*') {
				if (yych <= ')') goto yy771;
				goto yy807;
			} else {
				if (yych == '/') goto yy675;
				goto yy771;
			}
		}
yy809:
		YYDEBUG(809, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy85;
				goto yy673;
			} else {
				if (yych <= '\n') goto yy603;
				if (yych <= '\f') goto yy673;
				goto yy603;
			}
		} else {
			if (yych <= 'M') {
				if (yych <= 'L') goto yy673;
				goto yy834;
			} else {
				if (yych == 'm') goto yy834;
				goto yy673;
			}
		}
yy810:
		YYDEBUG(810, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy835;
		goto yy47;
yy811:
		YYDEBUG(811, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'P') goto yy836;
		if (yych == 'p') goto yy836;
		goto yy47;
yy812:
		YYDEBUG(812, *YYCURSOR);
		yyaccept = 87;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy813:
		YYDEBUG(813, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_METHOD_C);
}
yy814:
		YYDEBUG(814, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy837;
		if (yych == 'e') goto yy837;
		goto yy47;
yy815:
		YYDEBUG(815, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy838;
		if (yych == 's') goto yy838;
		goto yy85;
yy816:
		YYDEBUG(816, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy840;
		if (yych == 'e') goto yy840;
		goto yy85;
yy817:
		YYDEBUG(817, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(818, *YYCURSOR);
		if (yych <= '@') {
			if (yych <= 0x1F) {
				if (yych <= '\t') {
					if (yych <= 0x00) goto yy85;
					if (yych <= 0x08) goto yy710;
					goto yy817;
				} else {
					if (yych <= '\n') goto yy752;
					if (yych == '\r') goto yy752;
					goto yy710;
				}
			} else {
				if (yych <= ')') {
					if (yych <= ' ') goto yy817;
					if (yych == '#') goto yy841;
					goto yy710;
				} else {
					if (yych <= '*') goto yy754;
					if (yych == '/') goto yy842;
					goto yy710;
				}
			}
		} else {
			if (yych <= '_') {
				if (yych <= 'H') {
					if (yych == 'E') goto yy844;
					goto yy843;
				} else {
					if (yych <= 'I') goto yy845;
					if (yych <= 'Z') goto yy843;
					if (yych <= '^') goto yy710;
					goto yy843;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= '`') goto yy710;
					if (yych == 'e') goto yy844;
					goto yy843;
				} else {
					if (yych <= 'i') goto yy845;
					if (yych <= 'z') goto yy843;
					if (yych <= 0x7F) goto yy710;
					goto yy843;
				}
			}
		}
yy819:
		YYDEBUG(819, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '*') {
			if (yych <= 0x00) goto yy85;
			if (yych <= ')') goto yy577;
			goto yy650;
		} else {
			if (yych == '/') goto yy752;
			goto yy577;
		}
yy820:
		YYDEBUG(820, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 'S') {
			if (yych <= 0x00) goto yy85;
			if (yych == '*') goto yy650;
			goto yy577;
		} else {
			if (yych <= 'T') goto yy846;
			if (yych == 't') goto yy846;
			goto yy577;
		}
yy821:
		YYDEBUG(821, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 'O') {
			if (yych <= 0x00) goto yy85;
			if (yych == '*') goto yy650;
			goto yy577;
		} else {
			if (yych <= 'P') goto yy847;
			if (yych == 'p') goto yy847;
			goto yy577;
		}
yy822:
		YYDEBUG(822, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy85;
				goto yy573;
			} else {
				if (yych <= '\n') goto yy485;
				if (yych <= '\f') goto yy573;
				goto yy485;
			}
		} else {
			if (yych <= 'D') {
				if (yych <= 'C') goto yy573;
				goto yy848;
			} else {
				if (yych == 'd') goto yy848;
				goto yy573;
			}
		}
yy823:
		YYDEBUG(823, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy85;
				goto yy573;
			} else {
				if (yych <= '\n') goto yy485;
				if (yych <= '\f') goto yy573;
				goto yy485;
			}
		} else {
			if (yych <= 'M') {
				if (yych <= 'L') goto yy573;
				goto yy849;
			} else {
				if (yych == 'm') goto yy849;
				goto yy573;
			}
		}
yy824:
		YYDEBUG(824, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy850;
		if (yych == 'e') goto yy850;
		goto yy47;
yy825:
		YYDEBUG(825, *YYCURSOR);
		yyaccept = 88;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(826, *YYCURSOR);
		if (yych <= '\\') {
			if (yych <= '@') {
				if (yych <= '/') goto yy827;
				if (yych <= '9') goto yy825;
			} else {
				if (yych <= 'Z') goto yy825;
				if (yych >= '\\') goto yy802;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy825;
			} else {
				if (yych <= 'z') goto yy825;
				if (yych >= 0x80) goto yy825;
			}
		}
yy827:
		YYDEBUG(827, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_NAME_RELATIVE, sizeof("namespace\\") - 1);
}
yy828:
		YYDEBUG(828, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy852;
		if (yych == 'e') goto yy852;
		goto yy47;
yy829:
		YYDEBUG(829, *YYCURSOR);
		++YYCURSOR;
yy830:
		YYDEBUG(830, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	HANDLE_NEWLINES(yytext, yyleng);
	RETURN_TOKEN_WITH_IDENT(T_YIELD_FROM);
}
yy831:
		YYDEBUG(831, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy85;
				goto yy771;
			} else {
				if (yych <= '\n') goto yy854;
				if (yych <= '\f') goto yy771;
				goto yy854;
			}
		} else {
			if (yych <= '*') {
				if (yych <= ')') goto yy771;
				goto yy807;
			} else {
				if (yych == '[') goto yy677;
				goto yy771;
			}
		}
yy832:
		YYDEBUG(832, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '*') {
			if (yych <= 0x00) goto yy85;
			if (yych <= ')') goto yy677;
			goto yy856;
		} else {
			if (yych == '/') goto yy771;
			goto yy677;
		}
yy833:
		YYDEBUG(833, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 'Q') {
			if (yych <= 0x00) goto yy85;
			if (yych == '*') goto yy730;
			goto yy677;
		} else {
			if (yych <= 'R') goto yy857;
			if (yych == 'r') goto yy857;
			goto yy677;
		}
yy834:
		YYDEBUG(834, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '9') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy829;
				if (yych <= '\t') goto yy858;
				goto yy859;
			} else {
				if (yych == '\r') goto yy859;
				if (yych <= '/') goto yy858;
				goto yy673;
			}
		} else {
			if (yych <= '_') {
				if (yych <= '@') goto yy858;
				if (yych <= 'Z') goto yy673;
				if (yych <= '^') goto yy858;
				goto yy673;
			} else {
				if (yych <= '`') goto yy858;
				if (yych <= 'z') goto yy673;
				if (yych <= 0x7F) goto yy858;
				goto yy673;
			}
		}
yy835:
		YYDEBUG(835, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy860;
		goto yy47;
yy836:
		YYDEBUG(836, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy862;
		if (yych == 'i') goto yy862;
		goto yy47;
yy837:
		YYDEBUG(837, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy863;
		goto yy47;
yy838:
		YYDEBUG(838, *YYCURSOR);
		++YYCURSOR;
yy839:
		YYDEBUG(839, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(4);
	RETURN_TOKEN_WITH_STR(T_STRING, 0);
}
yy840:
		YYDEBUG(840, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy864;
		if (yych == 'n') goto yy864;
		goto yy85;
yy841:
		YYDEBUG(841, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x00) goto yy85;
			if (yych == '\n') goto yy817;
			goto yy710;
		} else {
			if (yych <= '\r') goto yy817;
			if (yych == '*') goto yy754;
			goto yy710;
		}
yy842:
		YYDEBUG(842, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x00) goto yy85;
			if (yych == '\n') goto yy752;
			goto yy710;
		} else {
			if (yych <= '\r') goto yy752;
			if (yych == '*') goto yy865;
			goto yy710;
		}
yy843:
		YYDEBUG(843, *YYCURSOR);
		yyaccept = 53;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x00) goto yy570;
			if (yych == '\n') goto yy752;
			goto yy710;
		} else {
			if (yych <= '\r') goto yy752;
			if (yych == '*') goto yy754;
			goto yy710;
		}
yy844:
		YYDEBUG(844, *YYCURSOR);
		yyaccept = 53;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= ')') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy570;
				if (yych <= '\t') goto yy710;
				goto yy752;
			} else {
				if (yych == '\r') goto yy752;
				goto yy710;
			}
		} else {
			if (yych <= 'X') {
				if (yych <= '*') goto yy754;
				if (yych <= 'W') goto yy710;
				goto yy866;
			} else {
				if (yych == 'x') goto yy866;
				goto yy710;
			}
		}
yy845:
		YYDEBUG(845, *YYCURSOR);
		yyaccept = 53;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= ')') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy570;
				if (yych <= '\t') goto yy710;
				goto yy752;
			} else {
				if (yych == '\r') goto yy752;
				goto yy710;
			}
		} else {
			if (yych <= 'M') {
				if (yych <= '*') goto yy754;
				if (yych <= 'L') goto yy710;
				goto yy867;
			} else {
				if (yych == 'm') goto yy867;
				goto yy710;
			}
		}
yy846:
		YYDEBUG(846, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 'D') {
			if (yych <= 0x00) goto yy85;
			if (yych == '*') goto yy650;
			goto yy577;
		} else {
			if (yych <= 'E') goto yy868;
			if (yych == 'e') goto yy868;
			goto yy577;
		}
yy847:
		YYDEBUG(847, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 'K') {
			if (yych <= 0x00) goto yy85;
			if (yych == '*') goto yy650;
			goto yy577;
		} else {
			if (yych <= 'L') goto yy869;
			if (yych == 'l') goto yy869;
			goto yy577;
		}
yy848:
		YYDEBUG(848, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy85;
				goto yy573;
			} else {
				if (yych <= '\n') goto yy485;
				if (yych <= '\f') goto yy573;
				goto yy485;
			}
		} else {
			if (yych <= 'S') {
				if (yych <= 'R') goto yy573;
				goto yy870;
			} else {
				if (yych == 's') goto yy870;
				goto yy573;
			}
		}
yy849:
		YYDEBUG(849, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy85;
				goto yy573;
			} else {
				if (yych <= '\n') goto yy485;
				if (yych <= '\f') goto yy573;
				goto yy485;
			}
		} else {
			if (yych <= 'E') {
				if (yych <= 'D') goto yy573;
				goto yy871;
			} else {
				if (yych == 'e') goto yy871;
				goto yy573;
			}
		}
yy850:
		YYDEBUG(850, *YYCURSOR);
		yyaccept = 89;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy851:
		YYDEBUG(851, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_INCLUDE_ONCE);
}
yy852:
		YYDEBUG(852, *YYCURSOR);
		yyaccept = 90;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy853:
		YYDEBUG(853, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_REQUIRE_ONCE);
}
yy854:
		YYDEBUG(854, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(855, *YYCURSOR);
		if (yych <= '"') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy85;
				if (yych <= 0x08) goto yy771;
				if (yych <= '\t') goto yy854;
				goto yy805;
			} else {
				if (yych <= '\r') {
					if (yych <= '\f') goto yy771;
					goto yy805;
				} else {
					if (yych == ' ') goto yy854;
					goto yy771;
				}
			}
		} else {
			if (yych <= '/') {
				if (yych <= ')') {
					if (yych <= '#') goto yy872;
					goto yy771;
				} else {
					if (yych <= '*') goto yy807;
					if (yych <= '.') goto yy771;
					goto yy873;
				}
			} else {
				if (yych <= 'F') {
					if (yych <= 'E') goto yy771;
					goto yy874;
				} else {
					if (yych == 'f') goto yy874;
					goto yy771;
				}
			}
		}
yy856:
		YYDEBUG(856, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '*') {
			if (yych <= 0x00) goto yy85;
			if (yych <= ')') goto yy677;
			goto yy730;
		} else {
			if (yych == '/') goto yy805;
			goto yy677;
		}
yy857:
		YYDEBUG(857, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 'N') {
			if (yych <= 0x00) goto yy85;
			if (yych == '*') goto yy730;
			goto yy677;
		} else {
			if (yych <= 'O') goto yy875;
			if (yych == 'o') goto yy875;
			goto yy677;
		}
yy858:
		YYDEBUG(858, *YYCURSOR);
		yyaccept = 91;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\n') {
			if (yych <= 0x00) goto yy830;
			if (yych <= '\t') goto yy673;
			goto yy603;
		} else {
			if (yych == '\r') goto yy603;
			goto yy673;
		}
yy859:
		YYDEBUG(859, *YYCURSOR);
		yyaccept = 91;
		YYMARKER = ++YYCURSOR;
		YYFILL(5);
		yych = *YYCURSOR;
		if (yych <= '"') {
			if (yych <= '\f') {
				if (yych <= 0x08) goto yy830;
				if (yych <= '\n') goto yy603;
				goto yy830;
			} else {
				if (yych <= '\r') goto yy603;
				if (yych == ' ') goto yy603;
				goto yy830;
			}
		} else {
			if (yych <= 'E') {
				if (yych <= '#') goto yy605;
				if (yych == '/') goto yy606;
				goto yy830;
			} else {
				if (yych <= 'F') goto yy672;
				if (yych == 'f') goto yy672;
				goto yy830;
			}
		}
yy860:
		YYDEBUG(860, *YYCURSOR);
		yyaccept = 92;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy861:
		YYDEBUG(861, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FUNC_C);
}
yy862:
		YYDEBUG(862, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy876;
		if (yych == 'l') goto yy876;
		goto yy47;
yy863:
		YYDEBUG(863, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy877;
		goto yy47;
yy864:
		YYDEBUG(864, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy815;
		if (yych == 't') goto yy815;
		goto yy85;
yy865:
		YYDEBUG(865, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy85;
				goto yy710;
			} else {
				if (yych <= '\n') goto yy752;
				if (yych <= '\f') goto yy710;
				goto yy752;
			}
		} else {
			if (yych <= '*') {
				if (yych <= ')') goto yy710;
				goto yy754;
			} else {
				if (yych == '/') goto yy817;
				goto yy710;
			}
		}
yy866:
		YYDEBUG(866, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= ')') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy85;
				if (yych <= '\t') goto yy710;
				goto yy752;
			} else {
				if (yych == '\r') goto yy752;
				goto yy710;
			}
		} else {
			if (yych <= 'T') {
				if (yych <= '*') goto yy754;
				if (yych <= 'S') goto yy710;
				goto yy879;
			} else {
				if (yych == 't') goto yy879;
				goto yy710;
			}
		}
yy867:
		YYDEBUG(867, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= ')') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy85;
				if (yych <= '\t') goto yy710;
				goto yy752;
			} else {
				if (yych == '\r') goto yy752;
				goto yy710;
			}
		} else {
			if (yych <= 'P') {
				if (yych <= '*') goto yy754;
				if (yych <= 'O') goto yy710;
				goto yy880;
			} else {
				if (yych == 'p') goto yy880;
				goto yy710;
			}
		}
yy868:
		YYDEBUG(868, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 'M') {
			if (yych <= 0x00) goto yy85;
			if (yych == '*') goto yy650;
			goto yy577;
		} else {
			if (yych <= 'N') goto yy881;
			if (yych == 'n') goto yy881;
			goto yy577;
		}
yy869:
		YYDEBUG(869, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 'D') {
			if (yych <= 0x00) goto yy85;
			if (yych == '*') goto yy650;
			goto yy577;
		} else {
			if (yych <= 'E') goto yy882;
			if (yych == 'e') goto yy882;
			goto yy577;
		}
yy870:
		YYDEBUG(870, *YYCURSOR);
		yyaccept = 93;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\n') {
			if (yych <= 0x00) goto yy839;
			if (yych <= '\t') goto yy573;
			goto yy485;
		} else {
			if (yych == '\r') goto yy485;
			goto yy573;
		}
yy871:
		YYDEBUG(871, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy85;
				goto yy573;
			} else {
				if (yych <= '\n') goto yy485;
				if (yych <= '\f') goto yy573;
				goto yy485;
			}
		} else {
			if (yych <= 'N') {
				if (yych <= 'M') goto yy573;
				goto yy883;
			} else {
				if (yych == 'n') goto yy883;
				goto yy573;
			}
		}
yy872:
		YYDEBUG(872, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x00) goto yy85;
			if (yych == '\n') goto yy854;
			goto yy771;
		} else {
			if (yych <= '\r') goto yy854;
			if (yych == '*') goto yy807;
			goto yy771;
		}
yy873:
		YYDEBUG(873, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x00) goto yy85;
			if (yych == '\n') goto yy805;
			goto yy771;
		} else {
			if (yych <= '\r') goto yy805;
			if (yych == '*') goto yy884;
			goto yy771;
		}
yy874:
		YYDEBUG(874, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= ')') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy85;
				if (yych <= '\t') goto yy771;
				goto yy805;
			} else {
				if (yych == '\r') goto yy805;
				goto yy771;
			}
		} else {
			if (yych <= 'R') {
				if (yych <= '*') goto yy807;
				if (yych <= 'Q') goto yy771;
				goto yy885;
			} else {
				if (yych == 'r') goto yy885;
				goto yy771;
			}
		}
yy875:
		YYDEBUG(875, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 'L') {
			if (yych <= 0x00) goto yy85;
			if (yych == '*') goto yy730;
			goto yy677;
		} else {
			if (yych <= 'M') goto yy886;
			if (yych == 'm') goto yy886;
			goto yy677;
		}
yy876:
		YYDEBUG(876, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy887;
		if (yych == 'e') goto yy887;
		goto yy47;
yy877:
		YYDEBUG(877, *YYCURSOR);
		yyaccept = 94;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy878:
		YYDEBUG(878, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_NS_C);
}
yy879:
		YYDEBUG(879, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= ')') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy85;
				if (yych <= '\t') goto yy710;
				goto yy752;
			} else {
				if (yych == '\r') goto yy752;
				goto yy710;
			}
		} else {
			if (yych <= 'E') {
				if (yych <= '*') goto yy754;
				if (yych <= 'D') goto yy710;
				goto yy888;
			} else {
				if (yych == 'e') goto yy888;
				goto yy710;
			}
		}
yy880:
		YYDEBUG(880, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= ')') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy85;
				if (yych <= '\t') goto yy710;
				goto yy752;
			} else {
				if (yych == '\r') goto yy752;
				goto yy710;
			}
		} else {
			if (yych <= 'L') {
				if (yych <= '*') goto yy754;
				if (yych <= 'K') goto yy710;
				goto yy889;
			} else {
				if (yych == 'l') goto yy889;
				goto yy710;
			}
		}
yy881:
		YYDEBUG(881, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 'C') {
			if (yych <= 0x00) goto yy85;
			if (yych == '*') goto yy650;
			goto yy577;
		} else {
			if (yych <= 'D') goto yy890;
			if (yych == 'd') goto yy890;
			goto yy577;
		}
yy882:
		YYDEBUG(882, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 'L') {
			if (yych <= 0x00) goto yy85;
			if (yych == '*') goto yy650;
			goto yy577;
		} else {
			if (yych <= 'M') goto yy891;
			if (yych == 'm') goto yy891;
			goto yy577;
		}
yy883:
		YYDEBUG(883, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy85;
				goto yy573;
			} else {
				if (yych <= '\n') goto yy485;
				if (yych <= '\f') goto yy573;
				goto yy485;
			}
		} else {
			if (yych <= 'T') {
				if (yych <= 'S') goto yy573;
				goto yy848;
			} else {
				if (yych == 't') goto yy848;
				goto yy573;
			}
		}
yy884:
		YYDEBUG(884, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy85;
				goto yy771;
			} else {
				if (yych <= '\n') goto yy805;
				if (yych <= '\f') goto yy771;
				goto yy805;
			}
		} else {
			if (yych <= '*') {
				if (yych <= ')') goto yy771;
				goto yy807;
			} else {
				if (yych == '/') goto yy854;
				goto yy771;
			}
		}
yy885:
		YYDEBUG(885, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= ')') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy85;
				if (yych <= '\t') goto yy771;
				goto yy805;
			} else {
				if (yych == '\r') goto yy805;
				goto yy771;
			}
		} else {
			if (yych <= 'O') {
				if (yych <= '*') goto yy807;
				if (yych <= 'N') goto yy771;
				goto yy892;
			} else {
				if (yych == 'o') goto yy892;
				goto yy771;
			}
		}
yy886:
		YYDEBUG(886, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '@') {
			if (yych <= '*') {
				if (yych <= 0x00) goto yy829;
				if (yych <= ')') goto yy893;
				goto yy894;
			} else {
				if (yych <= '/') goto yy893;
				if (yych <= '9') goto yy677;
				goto yy893;
			}
		} else {
			if (yych <= '_') {
				if (yych <= 'Z') goto yy677;
				if (yych <= '^') goto yy893;
				goto yy677;
			} else {
				if (yych <= '`') goto yy893;
				if (yych <= 'z') goto yy677;
				if (yych <= 0x7F) goto yy893;
				goto yy677;
			}
		}
yy887:
		YYDEBUG(887, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy895;
		if (yych == 'r') goto yy895;
		goto yy47;
yy888:
		YYDEBUG(888, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= ')') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy85;
				if (yych <= '\t') goto yy710;
				goto yy752;
			} else {
				if (yych == '\r') goto yy752;
				goto yy710;
			}
		} else {
			if (yych <= 'N') {
				if (yych <= '*') goto yy754;
				if (yych <= 'M') goto yy710;
				goto yy897;
			} else {
				if (yych == 'n') goto yy897;
				goto yy710;
			}
		}
yy889:
		YYDEBUG(889, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= ')') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy85;
				if (yych <= '\t') goto yy710;
				goto yy752;
			} else {
				if (yych == '\r') goto yy752;
				goto yy710;
			}
		} else {
			if (yych <= 'E') {
				if (yych <= '*') goto yy754;
				if (yych <= 'D') goto yy710;
				goto yy898;
			} else {
				if (yych == 'e') goto yy898;
				goto yy710;
			}
		}
yy890:
		YYDEBUG(890, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 'R') {
			if (yych <= 0x00) goto yy85;
			if (yych == '*') goto yy650;
			goto yy577;
		} else {
			if (yych <= 'S') goto yy899;
			if (yych == 's') goto yy899;
			goto yy577;
		}
yy891:
		YYDEBUG(891, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 'D') {
			if (yych <= 0x00) goto yy85;
			if (yych == '*') goto yy650;
			goto yy577;
		} else {
			if (yych <= 'E') goto yy900;
			if (yych == 'e') goto yy900;
			goto yy577;
		}
yy892:
		YYDEBUG(892, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= ')') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy85;
				if (yych <= '\t') goto yy771;
				goto yy805;
			} else {
				if (yych == '\r') goto yy805;
				goto yy771;
			}
		} else {
			if (yych <= 'M') {
				if (yych <= '*') goto yy807;
				if (yych <= 'L') goto yy771;
				goto yy901;
			} else {
				if (yych == 'm') goto yy901;
				goto yy771;
			}
		}
yy893:
		YYDEBUG(893, *YYCURSOR);
		yyaccept = 91;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 0x00) goto yy830;
		if (yych == '*') goto yy730;
		goto yy677;
yy894:
		YYDEBUG(894, *YYCURSOR);
		yyaccept = 91;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '*') {
			if (yych <= 0x00) goto yy830;
			if (yych <= ')') goto yy677;
			goto yy730;
		} else {
			if (yych == '/') goto yy603;
			goto yy677;
		}
yy895:
		YYDEBUG(895, *YYCURSOR);
		yyaccept = 95;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy46;
		}
		if (yych == '\\') goto yy162;
yy896:
		YYDEBUG(896, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_HALT_COMPILER);
}
yy897:
		YYDEBUG(897, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= ')') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy85;
				if (yych <= '\t') goto yy710;
				goto yy752;
			} else {
				if (yych == '\r') goto yy752;
				goto yy710;
			}
		} else {
			if (yych <= 'D') {
				if (yych <= '*') goto yy754;
				if (yych <= 'C') goto yy710;
				goto yy902;
			} else {
				if (yych == 'd') goto yy902;
				goto yy710;
			}
		}
yy898:
		YYDEBUG(898, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= ')') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy85;
				if (yych <= '\t') goto yy710;
				goto yy752;
			} else {
				if (yych == '\r') goto yy752;
				goto yy710;
			}
		} else {
			if (yych <= 'M') {
				if (yych <= '*') goto yy754;
				if (yych <= 'L') goto yy710;
				goto yy903;
			} else {
				if (yych == 'm') goto yy903;
				goto yy710;
			}
		}
yy899:
		YYDEBUG(899, *YYCURSOR);
		yyaccept = 93;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 0x00) goto yy839;
		if (yych == '*') goto yy650;
		goto yy577;
yy900:
		YYDEBUG(900, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 'M') {
			if (yych <= 0x00) goto yy85;
			if (yych == '*') goto yy650;
			goto yy577;
		} else {
			if (yych <= 'N') goto yy904;
			if (yych == 'n') goto yy904;
			goto yy577;
		}
yy901:
		YYDEBUG(901, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '/') {
			if (yych <= '\f') {
				if (yych <= 0x00) goto yy829;
				if (yych == '\n') goto yy906;
				goto yy905;
			} else {
				if (yych <= '\r') goto yy906;
				if (yych == '*') goto yy907;
				goto yy905;
			}
		} else {
			if (yych <= '^') {
				if (yych <= '9') goto yy771;
				if (yych <= '@') goto yy905;
				if (yych <= 'Z') goto yy771;
				goto yy905;
			} else {
				if (yych <= '`') {
					if (yych <= '_') goto yy771;
					goto yy905;
				} else {
					if (yych <= 'z') goto yy771;
					if (yych <= 0x7F) goto yy905;
					goto yy771;
				}
			}
		}
yy902:
		YYDEBUG(902, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= ')') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy85;
				if (yych <= '\t') goto yy710;
				goto yy752;
			} else {
				if (yych == '\r') goto yy752;
				goto yy710;
			}
		} else {
			if (yych <= 'S') {
				if (yych <= '*') goto yy754;
				if (yych <= 'R') goto yy710;
				goto yy908;
			} else {
				if (yych == 's') goto yy908;
				goto yy710;
			}
		}
yy903:
		YYDEBUG(903, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= ')') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy85;
				if (yych <= '\t') goto yy710;
				goto yy752;
			} else {
				if (yych == '\r') goto yy752;
				goto yy710;
			}
		} else {
			if (yych <= 'E') {
				if (yych <= '*') goto yy754;
				if (yych <= 'D') goto yy710;
				goto yy909;
			} else {
				if (yych == 'e') goto yy909;
				goto yy710;
			}
		}
yy904:
		YYDEBUG(904, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 'S') {
			if (yych <= 0x00) goto yy85;
			if (yych == '*') goto yy650;
			goto yy577;
		} else {
			if (yych <= 'T') goto yy890;
			if (yych == 't') goto yy890;
			goto yy577;
		}
yy905:
		YYDEBUG(905, *YYCURSOR);
		yyaccept = 91;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x00) goto yy830;
			if (yych == '\n') goto yy805;
			goto yy771;
		} else {
			if (yych <= '\r') goto yy805;
			if (yych == '*') goto yy807;
			goto yy771;
		}
yy906:
		YYDEBUG(906, *YYCURSOR);
		yyaccept = 91;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '#') {
			if (yych <= '\f') {
				if (yych <= 0x00) goto yy830;
				if (yych <= 0x08) goto yy677;
				if (yych <= '\n') goto yy805;
				goto yy677;
			} else {
				if (yych <= 0x1F) {
					if (yych <= '\r') goto yy805;
					goto yy677;
				} else {
					if (yych <= ' ') goto yy805;
					if (yych <= '"') goto yy677;
					goto yy831;
				}
			}
		} else {
			if (yych <= '/') {
				if (yych == '*') goto yy730;
				if (yych <= '.') goto yy677;
				goto yy832;
			} else {
				if (yych <= 'F') {
					if (yych <= 'E') goto yy677;
					goto yy833;
				} else {
					if (yych == 'f') goto yy833;
					goto yy677;
				}
			}
		}
yy907:
		YYDEBUG(907, *YYCURSOR);
		yyaccept = 91;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy830;
				goto yy771;
			} else {
				if (yych <= '\n') goto yy805;
				if (yych <= '\f') goto yy771;
				goto yy805;
			}
		} else {
			if (yych <= '*') {
				if (yych <= ')') goto yy771;
				goto yy807;
			} else {
				if (yych == '/') goto yy675;
				goto yy771;
			}
		}
yy908:
		YYDEBUG(908, *YYCURSOR);
		yyaccept = 93;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x00) goto yy839;
			if (yych == '\n') goto yy752;
			goto yy710;
		} else {
			if (yych <= '\r') goto yy752;
			if (yych == '*') goto yy754;
			goto yy710;
		}
yy909:
		YYDEBUG(909, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= ')') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy85;
				if (yych <= '\t') goto yy710;
				goto yy752;
			} else {
				if (yych == '\r') goto yy752;
				goto yy710;
			}
		} else {
			if (yych <= 'N') {
				if (yych <= '*') goto yy754;
				if (yych <= 'M') goto yy710;
			} else {
				if (yych != 'n') goto yy710;
			}
		}
		YYDEBUG(910, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= ')') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy85;
				if (yych <= '\t') goto yy710;
				goto yy752;
			} else {
				if (yych == '\r') goto yy752;
				goto yy710;
			}
		} else {
			if (yych <= 'T') {
				if (yych <= '*') goto yy754;
				if (yych <= 'S') goto yy710;
				goto yy902;
			} else {
				if (yych == 't') goto yy902;
				goto yy710;
			}
		}
	}
/* *********************************** */
yyc_ST_LOOKING_FOR_PROPERTY:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,  64,  64,   0,   0,  64,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 64,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(911, *YYCURSOR);
		YYFILL(3);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy915;
		}
		if (yych <= 'Z') {
			if (yych <= '>') {
				if (yych == '-') goto yy918;
			} else {
				if (yych <= '?') goto yy919;
				if (yych >= 'A') goto yy920;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy920;
			} else {
				if (yych <= 'z') goto yy920;
				if (yych >= 0x80) goto yy920;
			}
		}
		YYDEBUG(913, *YYCURSOR);
		++YYCURSOR;
yy914:
		YYDEBUG(914, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(0);
	yy_pop_state();
	goto restart;
}
yy915:
		YYDEBUG(915, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(916, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy915;
		}
		YYDEBUG(917, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	goto return_whitespace;
}
yy918:
		YYDEBUG(918, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy923;
		goto yy914;
yy919:
		YYDEBUG(919, *YYCURSOR);
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '-') goto yy925;
		goto yy914;
yy920:
		YYDEBUG(920, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(921, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy920;
		}
		YYDEBUG(922, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_pop_state();
	RETURN_TOKEN_WITH_STR(T_STRING, 0);
}
yy923:
		YYDEBUG(923, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(924, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_OBJECT_OPERATOR);
}
yy925:
		YYDEBUG(925, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy927;
		YYDEBUG(926, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy914;
yy927:
		YYDEBUG(927, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(928, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_NULLSAFE_OBJECT_OPERATOR);
}
	}
/* *********************************** */
yyc_ST_BACKQUOTE:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(929, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych == '$') goto yy933;
		} else {
			if (yych <= '`') goto yy934;
			if (yych == '{') goto yy936;
		}
		YYDEBUG(931, *YYCURSOR);
		++YYCURSOR;
yy932:
		YYDEBUG(932, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (YYCURSOR > YYLIMIT) {
		RETURN_END_TOKEN;
	}
	if (yytext[0] == '\\' && YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '`':
				break;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				ZEND_FALLTHROUGH;
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	if (EXPECTED(zend_scan_escape_string(zendlval, yytext, yyleng, '`') == SUCCESS)
	 || !PARSER_MODE()) {
		RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
	} else {
		RETURN_TOKEN(T_ERROR);
	}
}
yy933:
		YYDEBUG(933, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy932;
			if (yych <= 'Z') goto yy937;
			if (yych <= '^') goto yy932;
			goto yy937;
		} else {
			if (yych <= 'z') {
				if (yych <= '`') goto yy932;
				goto yy937;
			} else {
				if (yych <= '{') goto yy940;
				if (yych <= 0x7F) goto yy932;
				goto yy937;
			}
		}
yy934:
		YYDEBUG(934, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(935, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(ST_IN_SCRIPTING);
	RETURN_TOKEN('`');
}
yy936:
		YYDEBUG(936, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy942;
		goto yy932;
yy937:
		YYDEBUG(937, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(4);
		yych = *YYCURSOR;
		YYDEBUG(938, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy937;
		}
		if (yych <= '>') {
			if (yych == '-') goto yy944;
		} else {
			if (yych <= '?') goto yy946;
			if (yych <= '@') goto yy939;
			if (yych <= '[') goto yy947;
		}
yy939:
		YYDEBUG(939, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy940:
		YYDEBUG(940, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(941, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME);
	enter_nesting('{');
	RETURN_TOKEN(T_DOLLAR_OPEN_CURLY_BRACES);
}
yy942:
		YYDEBUG(942, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(943, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_IN_SCRIPTING);
	yyless(1);
	enter_nesting('{');
	RETURN_TOKEN(T_CURLY_OPEN);
}
yy944:
		YYDEBUG(944, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy949;
yy945:
		YYDEBUG(945, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy939;
yy946:
		YYDEBUG(946, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '-') goto yy950;
		goto yy945;
yy947:
		YYDEBUG(947, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(948, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy949:
		YYDEBUG(949, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy945;
			if (yych <= 'Z') goto yy951;
			if (yych <= '^') goto yy945;
			goto yy951;
		} else {
			if (yych <= '`') goto yy945;
			if (yych <= 'z') goto yy951;
			if (yych <= 0x7F) goto yy945;
			goto yy951;
		}
yy950:
		YYDEBUG(950, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy953;
		goto yy945;
yy951:
		YYDEBUG(951, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(952, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy953:
		YYDEBUG(953, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy945;
			if (yych <= 'Z') goto yy954;
			if (yych <= '^') goto yy945;
		} else {
			if (yych <= '`') goto yy945;
			if (yych <= 'z') goto yy954;
			if (yych <= 0x7F) goto yy945;
		}
yy954:
		YYDEBUG(954, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(955, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 4);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
	}
/* *********************************** */
yyc_ST_DOUBLE_QUOTES:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(956, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '#') {
			if (yych == '"') goto yy960;
		} else {
			if (yych <= '$') goto yy962;
			if (yych == '{') goto yy963;
		}
		YYDEBUG(958, *YYCURSOR);
		++YYCURSOR;
yy959:
		YYDEBUG(959, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (GET_DOUBLE_QUOTES_SCANNED_LENGTH()) {
		YYCURSOR += GET_DOUBLE_QUOTES_SCANNED_LENGTH() - 1;
		SET_DOUBLE_QUOTES_SCANNED_LENGTH(0);

		goto double_quotes_scan_done;
	}

	if (YYCURSOR > YYLIMIT) {
		RETURN_END_TOKEN;
	}
	if (yytext[0] == '\\' && YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				break;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				ZEND_FALLTHROUGH;
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

double_quotes_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);

	if (EXPECTED(zend_scan_escape_string(zendlval, yytext, yyleng, '"') == SUCCESS)
	 || !PARSER_MODE()) {
		RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
	} else {
		RETURN_TOKEN(T_ERROR);
	}
}
yy960:
		YYDEBUG(960, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(961, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(ST_IN_SCRIPTING);
	RETURN_TOKEN('"');
}
yy962:
		YYDEBUG(962, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy959;
			if (yych <= 'Z') goto yy964;
			if (yych <= '^') goto yy959;
			goto yy964;
		} else {
			if (yych <= 'z') {
				if (yych <= '`') goto yy959;
				goto yy964;
			} else {
				if (yych <= '{') goto yy967;
				if (yych <= 0x7F) goto yy959;
				goto yy964;
			}
		}
yy963:
		YYDEBUG(963, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy969;
		goto yy959;
yy964:
		YYDEBUG(964, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(4);
		yych = *YYCURSOR;
		YYDEBUG(965, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy964;
		}
		if (yych <= '>') {
			if (yych == '-') goto yy971;
		} else {
			if (yych <= '?') goto yy973;
			if (yych <= '@') goto yy966;
			if (yych <= '[') goto yy974;
		}
yy966:
		YYDEBUG(966, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy967:
		YYDEBUG(967, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(968, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME);
	enter_nesting('{');
	RETURN_TOKEN(T_DOLLAR_OPEN_CURLY_BRACES);
}
yy969:
		YYDEBUG(969, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(970, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_IN_SCRIPTING);
	yyless(1);
	enter_nesting('{');
	RETURN_TOKEN(T_CURLY_OPEN);
}
yy971:
		YYDEBUG(971, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy976;
yy972:
		YYDEBUG(972, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy966;
yy973:
		YYDEBUG(973, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '-') goto yy977;
		goto yy972;
yy974:
		YYDEBUG(974, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(975, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy976:
		YYDEBUG(976, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy972;
			if (yych <= 'Z') goto yy978;
			if (yych <= '^') goto yy972;
			goto yy978;
		} else {
			if (yych <= '`') goto yy972;
			if (yych <= 'z') goto yy978;
			if (yych <= 0x7F) goto yy972;
			goto yy978;
		}
yy977:
		YYDEBUG(977, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy980;
		goto yy972;
yy978:
		YYDEBUG(978, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(979, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy980:
		YYDEBUG(980, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy972;
			if (yych <= 'Z') goto yy981;
			if (yych <= '^') goto yy972;
		} else {
			if (yych <= '`') goto yy972;
			if (yych <= 'z') goto yy981;
			if (yych <= 0x7F) goto yy972;
		}
yy981:
		YYDEBUG(981, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(982, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 4);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
	}
/* *********************************** */
yyc_ST_HEREDOC:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(983, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych == '$') goto yy987;
		if (yych == '{') goto yy988;
		YYDEBUG(985, *YYCURSOR);
		++YYCURSOR;
yy986:
		YYDEBUG(986, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zend_heredoc_label *heredoc_label = zend_ptr_stack_top(&SCNG(heredoc_label_stack));
	int newline = 0, indentation = 0, spacing = 0;

	if (YYCURSOR > YYLIMIT) {
		RETURN_END_TOKEN;
	}

	YYCURSOR--;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				ZEND_FALLTHROUGH;
			case '\n':
				indentation = spacing = 0;

				while (YYCURSOR < YYLIMIT && (*YYCURSOR == ' ' || *YYCURSOR == '\t')) {
					if (*YYCURSOR == '\t') {
						spacing |= HEREDOC_USING_TABS;
					} else {
						spacing |= HEREDOC_USING_SPACES;
					}
					++YYCURSOR;
					++indentation;
				}

				if (YYCURSOR == YYLIMIT) {
					yyleng = YYCURSOR - SCNG(yy_text);
					HANDLE_NEWLINES(yytext, yyleng);
					ZVAL_NULL(zendlval);
					RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
				}

				/* Check for ending label on the next line */
				if (IS_LABEL_START(*YYCURSOR) && heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, heredoc_label->label, heredoc_label->length)) {
					if (IS_LABEL_SUCCESSOR(YYCURSOR[heredoc_label->length])) {
						continue;
					}

					if (spacing == (HEREDOC_USING_SPACES | HEREDOC_USING_TABS)) {
						zend_throw_exception(zend_ce_parse_error, "Invalid indentation - tabs and spaces cannot be mixed", 0);
						if (PARSER_MODE()) {
							RETURN_TOKEN(T_ERROR);
						}
					}

					/* newline before label will be subtracted from returned text, but
					 * yyleng/yytext will include it, for zend_highlight/strip, tokenizer, etc. */
					if (YYCURSOR[-indentation - 2] == '\r' && YYCURSOR[-indentation - 1] == '\n') {
						newline = 2; /* Windows newline */
					} else {
						newline = 1;
					}

					CG(increment_lineno) = 1; /* For newline before label */

					if (SCNG(heredoc_scan_ahead)) {
						SCNG(heredoc_indentation) = indentation;
						SCNG(heredoc_indentation_uses_spaces) = (spacing == HEREDOC_USING_SPACES);
					} else {
						YYCURSOR -= indentation;
					}

					BEGIN(ST_END_HEREDOC);

					goto heredoc_scan_done;
				}
				continue;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT && *YYCURSOR != '\n' && *YYCURSOR != '\r') {
					YYCURSOR++;
				}
				ZEND_FALLTHROUGH;
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

heredoc_scan_done:

	yyleng = YYCURSOR - SCNG(yy_text);
	ZVAL_STRINGL(zendlval, yytext, yyleng - newline);

	if (!SCNG(heredoc_scan_ahead) && !EG(exception) && PARSER_MODE()) {
		bool newline_at_start = *(yytext - 1) == '\n' || *(yytext - 1) == '\r';
		zend_string *copy = Z_STR_P(zendlval);

		if (!strip_multiline_string_indentation(
				zendlval, heredoc_label->indentation, heredoc_label->indentation_uses_spaces,
				newline_at_start, newline != 0)) {
			RETURN_TOKEN(T_ERROR);
		}

		if (UNEXPECTED(zend_scan_escape_string(zendlval, ZSTR_VAL(copy), ZSTR_LEN(copy), 0) != SUCCESS)) {
			zend_string_efree(copy);
			RETURN_TOKEN(T_ERROR);
		}

		zend_string_efree(copy);
	} else {
		HANDLE_NEWLINES(yytext, yyleng - newline);
	}

	RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
}
yy987:
		YYDEBUG(987, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy986;
			if (yych <= 'Z') goto yy989;
			if (yych <= '^') goto yy986;
			goto yy989;
		} else {
			if (yych <= 'z') {
				if (yych <= '`') goto yy986;
				goto yy989;
			} else {
				if (yych <= '{') goto yy992;
				if (yych <= 0x7F) goto yy986;
				goto yy989;
			}
		}
yy988:
		YYDEBUG(988, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy994;
		goto yy986;
yy989:
		YYDEBUG(989, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(4);
		yych = *YYCURSOR;
		YYDEBUG(990, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy989;
		}
		if (yych <= '>') {
			if (yych == '-') goto yy996;
		} else {
			if (yych <= '?') goto yy998;
			if (yych <= '@') goto yy991;
			if (yych <= '[') goto yy999;
		}
yy991:
		YYDEBUG(991, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy992:
		YYDEBUG(992, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(993, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME);
	enter_nesting('{');
	RETURN_TOKEN(T_DOLLAR_OPEN_CURLY_BRACES);
}
yy994:
		YYDEBUG(994, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(995, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_IN_SCRIPTING);
	yyless(1);
	enter_nesting('{');
	RETURN_TOKEN(T_CURLY_OPEN);
}
yy996:
		YYDEBUG(996, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy1001;
yy997:
		YYDEBUG(997, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy991;
yy998:
		YYDEBUG(998, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '-') goto yy1002;
		goto yy997;
yy999:
		YYDEBUG(999, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(1000, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy1001:
		YYDEBUG(1001, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy997;
			if (yych <= 'Z') goto yy1003;
			if (yych <= '^') goto yy997;
			goto yy1003;
		} else {
			if (yych <= '`') goto yy997;
			if (yych <= 'z') goto yy1003;
			if (yych <= 0x7F) goto yy997;
			goto yy1003;
		}
yy1002:
		YYDEBUG(1002, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy1005;
		goto yy997;
yy1003:
		YYDEBUG(1003, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(1004, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy1005:
		YYDEBUG(1005, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy997;
			if (yych <= 'Z') goto yy1006;
			if (yych <= '^') goto yy997;
		} else {
			if (yych <= '`') goto yy997;
			if (yych <= 'z') goto yy1006;
			if (yych <= 0x7F) goto yy997;
		}
yy1006:
		YYDEBUG(1006, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(1007, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 4);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
	}
/* *********************************** */
yyc_ST_LOOKING_FOR_VARNAME:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(1008, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy1010;
			if (yych <= 'Z') goto yy1012;
			if (yych >= '_') goto yy1012;
		} else {
			if (yych <= '`') goto yy1010;
			if (yych <= 'z') goto yy1012;
			if (yych >= 0x80) goto yy1012;
		}
yy1010:
		YYDEBUG(1010, *YYCURSOR);
		++YYCURSOR;
yy1011:
		YYDEBUG(1011, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(0);
	yy_pop_state();
	yy_push_state(ST_IN_SCRIPTING);
	goto restart;
}
yy1012:
		YYDEBUG(1012, *YYCURSOR);
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '_') {
			if (yych <= '@') {
				if (yych <= '/') goto yy1011;
				if (yych <= '9') goto yy1014;
				goto yy1011;
			} else {
				if (yych <= '[') goto yy1014;
				if (yych <= '^') goto yy1011;
				goto yy1014;
			}
		} else {
			if (yych <= '|') {
				if (yych <= '`') goto yy1011;
				if (yych <= 'z') goto yy1014;
				goto yy1011;
			} else {
				if (yych <= '}') goto yy1014;
				if (yych <= 0x7F) goto yy1011;
				goto yy1014;
			}
		}
yy1013:
		YYDEBUG(1013, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy1014:
		YYDEBUG(1014, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy1013;
		}
		if (yych <= '@') goto yy1015;
		if (yych <= '[') goto yy1016;
		if (yych == '}') goto yy1016;
yy1015:
		YYDEBUG(1015, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy1011;
yy1016:
		YYDEBUG(1016, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(1017, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_pop_state();
	yy_push_state(ST_IN_SCRIPTING);
	RETURN_TOKEN_WITH_STR(T_STRING_VARNAME, 0);
}
	}
/* *********************************** */
yyc_ST_VAR_OFFSET:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			248, 248, 216, 216, 216, 216, 216, 216, 
			152, 152,   0,   0,   0,   0,   0,   0, 
			  0, 144, 144, 144, 144, 144, 144,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,   0,   0,   0,   0,  16, 
			  0, 144, 144, 144, 144, 144, 144,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,   0,   0,   0,   0,   0, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
		};
		YYDEBUG(1018, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '0') {
			if (yych <= ' ') {
				if (yych <= '\f') {
					if (yych <= 0x08) goto yy1020;
					if (yych <= '\n') goto yy1022;
				} else {
					if (yych <= '\r') goto yy1022;
					if (yych >= ' ') goto yy1022;
				}
			} else {
				if (yych <= '$') {
					if (yych <= '"') goto yy1024;
					if (yych <= '#') goto yy1022;
					goto yy1026;
				} else {
					if (yych == '\'') goto yy1022;
					if (yych <= '/') goto yy1024;
					goto yy1027;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= 'Z') {
					if (yych <= '9') goto yy1029;
					if (yych <= '@') goto yy1024;
					goto yy1031;
				} else {
					if (yych <= '[') goto yy1024;
					if (yych <= '\\') goto yy1022;
					goto yy1034;
				}
			} else {
				if (yych <= '`') {
					if (yych == '_') goto yy1031;
					goto yy1024;
				} else {
					if (yych <= 'z') goto yy1031;
					if (yych <= '~') goto yy1024;
					if (yych >= 0x80) goto yy1031;
				}
			}
		}
yy1020:
		YYDEBUG(1020, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(1021, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (YYCURSOR > YYLIMIT) {
		RETURN_END_TOKEN;
	}

	RETURN_TOKEN(T_BAD_CHARACTER);
}
yy1022:
		YYDEBUG(1022, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(1023, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* Invalid rule to return a more explicit parse error with proper line number */
	yyless(0);
	yy_pop_state();
	ZVAL_NULL(zendlval);
	RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
}
yy1024:
		YYDEBUG(1024, *YYCURSOR);
		++YYCURSOR;
yy1025:
		YYDEBUG(1025, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* Only '[' or '-' can be valid, but returning other tokens will allow a more explicit parse error */
	RETURN_TOKEN(yytext[0]);
}
yy1026:
		YYDEBUG(1026, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy1025;
			if (yych <= 'Z') goto yy1036;
			if (yych <= '^') goto yy1025;
			goto yy1036;
		} else {
			if (yych <= '`') goto yy1025;
			if (yych <= 'z') goto yy1036;
			if (yych <= 0x7F) goto yy1025;
			goto yy1036;
		}
yy1027:
		YYDEBUG(1027, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'X') {
			if (yych <= 'B') {
				if (yych <= '/') goto yy1028;
				if (yych <= '9') goto yy1039;
				if (yych >= 'B') goto yy1042;
			} else {
				if (yych == 'O') goto yy1044;
				if (yych >= 'X') goto yy1045;
			}
		} else {
			if (yych <= 'b') {
				if (yych == '_') goto yy1046;
				if (yych >= 'b') goto yy1042;
			} else {
				if (yych <= 'o') {
					if (yych >= 'o') goto yy1044;
				} else {
					if (yych == 'x') goto yy1045;
				}
			}
		}
yy1028:
		YYDEBUG(1028, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Offset could be treated as a long */
	if (yyleng < MAX_LENGTH_OF_LONG - 1 || (yyleng == MAX_LENGTH_OF_LONG - 1 && strcmp(yytext, long_min_digits) < 0)) {
		char *end;
		errno = 0;
		ZVAL_LONG(zendlval, ZEND_STRTOL(yytext, &end, 10));
		if (errno == ERANGE) {
			goto string;
		}
		ZEND_ASSERT(end == yytext + yyleng);
	} else {
string:
		ZVAL_STRINGL(zendlval, yytext, yyleng);
	}
	RETURN_TOKEN_WITH_VAL(T_NUM_STRING);
}
yy1029:
		YYDEBUG(1029, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(1030, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy1029;
		}
		if (yych == '_') goto yy1046;
		goto yy1028;
yy1031:
		YYDEBUG(1031, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(1032, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy1031;
		}
		YYDEBUG(1033, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_STRING, 0);
}
yy1034:
		YYDEBUG(1034, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(1035, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_pop_state();
	RETURN_TOKEN(']');
}
yy1036:
		YYDEBUG(1036, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(1037, *YYCURSOR);
		if (yych <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy1036;
			} else {
				if (yych <= '@') goto yy1038;
				if (yych <= 'Z') goto yy1036;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy1036;
			} else {
				if (yych <= 'z') goto yy1036;
				if (yych >= 0x80) goto yy1036;
			}
		}
yy1038:
		YYDEBUG(1038, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy1039:
		YYDEBUG(1039, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(1040, *YYCURSOR);
		if (yych <= '/') goto yy1041;
		if (yych <= '9') goto yy1039;
		if (yych == '_') goto yy1046;
yy1041:
		YYDEBUG(1041, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Offset must be treated as a string */
	if (yyleng == 1) {
		ZVAL_INTERNED_STR(zendlval, ZSTR_CHAR((zend_uchar)*(yytext)));
	} else {
		ZVAL_STRINGL(zendlval, yytext, yyleng);
	}
	RETURN_TOKEN_WITH_VAL(T_NUM_STRING);
}
yy1042:
		YYDEBUG(1042, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 32) {
			goto yy1047;
		}
yy1043:
		YYDEBUG(1043, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept == 0) {
			goto yy1028;
		} else {
			goto yy1041;
		}
yy1044:
		YYDEBUG(1044, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy1049;
		}
		goto yy1043;
yy1045:
		YYDEBUG(1045, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy1051;
		}
		goto yy1043;
yy1046:
		YYDEBUG(1046, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '/') goto yy1043;
		if (yych <= '9') goto yy1039;
		goto yy1043;
yy1047:
		YYDEBUG(1047, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(1048, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy1047;
		}
		if (yych == '_') goto yy1042;
		goto yy1041;
yy1049:
		YYDEBUG(1049, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(1050, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy1049;
		}
		if (yych == '_') goto yy1044;
		goto yy1041;
yy1051:
		YYDEBUG(1051, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(1052, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy1051;
		}
		if (yych == '_') goto yy1045;
		goto yy1041;
	}
/* *********************************** */
yyc_SHEBANG:
	{
		static const unsigned char yybm[] = {
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(1053, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych == '#') goto yy1057;
		YYDEBUG(1055, *YYCURSOR);
		++YYCURSOR;
yy1056:
		YYDEBUG(1056, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(0);
	BEGIN(INITIAL);
	goto restart;
}
yy1057:
		YYDEBUG(1057, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '!') goto yy1056;
yy1058:
		YYDEBUG(1058, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(1059, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy1058;
		}
		YYDEBUG(1060, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(1061, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	CG(zend_lineno)++;
	BEGIN(INITIAL);
	goto restart;
}
	}
/* *********************************** */
yyc_INITIAL:
	YYDEBUG(1062, *YYCURSOR);
	YYFILL(7);
	yych = *YYCURSOR;
	if (yych == '<') goto yy1066;
	YYDEBUG(1064, *YYCURSOR);
	++YYCURSOR;
yy1065:
	YYDEBUG(1065, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	if (YYCURSOR > YYLIMIT) {
		RETURN_END_TOKEN;
	}

inline_char_handler:

	while (1) {
		YYCTYPE *ptr = memchr(YYCURSOR, '<', YYLIMIT - YYCURSOR);

		YYCURSOR = ptr ? ptr + 1 : YYLIMIT;

		if (YYCURSOR >= YYLIMIT) {
			break;
		}

		if (*YYCURSOR == '?') {
			if (CG(short_tags) /* <? */
				|| (*(YYCURSOR + 1) == '=') /* <?= */
				|| (!strncasecmp((char*)YYCURSOR + 1, "php", 3) && /* <?php[ \t\r\n] */
					(YYCURSOR + 4 == YYLIMIT ||
					YYCURSOR[4] == ' ' || YYCURSOR[4] == '\t' ||
					YYCURSOR[4] == '\n' || YYCURSOR[4] == '\r'))
			) {
				YYCURSOR--;
				break;
			}
		}
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	if (SCNG(output_filter)) {
		size_t readsize;
		char *s = NULL;
		size_t sz = 0;
		// TODO: avoid reallocation ???
		readsize = SCNG(output_filter)((unsigned char **)&s, &sz, (unsigned char *)yytext, (size_t)yyleng);
		ZVAL_STRINGL(zendlval, s, sz);
		efree(s);
		if (readsize < yyleng) {
			yyless(readsize);
		}
	} else if (yyleng == 1) {
		ZVAL_INTERNED_STR(zendlval, ZSTR_CHAR((zend_uchar)*yytext));
	} else {
		ZVAL_STRINGL(zendlval, yytext, yyleng);
	}
	HANDLE_NEWLINES(yytext, yyleng);
	RETURN_TOKEN_WITH_VAL(T_INLINE_HTML);
}
yy1066:
	YYDEBUG(1066, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '?') goto yy1065;
	YYDEBUG(1067, *YYCURSOR);
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych == '=') goto yy1069;
	} else {
		if (yych <= 'P') goto yy1071;
		if (yych == 'p') goto yy1071;
	}
yy1068:
	YYDEBUG(1068, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	if (CG(short_tags)) {
		BEGIN(ST_IN_SCRIPTING);
		RETURN_OR_SKIP_TOKEN(T_OPEN_TAG);
	} else {
		goto inline_char_handler;
	}
}
yy1069:
	YYDEBUG(1069, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(1070, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	BEGIN(ST_IN_SCRIPTING);
	if (PARSER_MODE()) {
		/* We'll reject this as an identifier in zend_lex_tstring. */
		RETURN_TOKEN_WITH_IDENT(T_ECHO);
	}
	RETURN_TOKEN(T_OPEN_TAG_WITH_ECHO);
}
yy1071:
	YYDEBUG(1071, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1073;
	if (yych == 'h') goto yy1073;
yy1072:
	YYDEBUG(1072, *YYCURSOR);
	YYCURSOR = YYMARKER;
	goto yy1068;
yy1073:
	YYDEBUG(1073, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy1074;
	if (yych != 'p') goto yy1072;
yy1074:
	YYDEBUG(1074, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\f') {
		if (yych <= 0x08) goto yy1075;
		if (yych <= '\n') goto yy1076;
	} else {
		if (yych <= '\r') goto yy1078;
		if (yych == ' ') goto yy1076;
	}
yy1075:
	YYDEBUG(1075, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	/* Allow <?php followed by end of file. */
	if (YYCURSOR == YYLIMIT) {
		BEGIN(ST_IN_SCRIPTING);
		RETURN_OR_SKIP_TOKEN(T_OPEN_TAG);
	}
	/* Degenerate case: <?phpX is interpreted as <? phpX with short tags. */
	if (CG(short_tags)) {
		yyless(2);
		BEGIN(ST_IN_SCRIPTING);
		RETURN_OR_SKIP_TOKEN(T_OPEN_TAG);
	}
	goto inline_char_handler;
}
yy1076:
	YYDEBUG(1076, *YYCURSOR);
	++YYCURSOR;
yy1077:
	YYDEBUG(1077, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	HANDLE_NEWLINE(yytext[yyleng-1]);
	BEGIN(ST_IN_SCRIPTING);
	RETURN_OR_SKIP_TOKEN(T_OPEN_TAG);
}
yy1078:
	YYDEBUG(1078, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\n') goto yy1076;
	goto yy1077;
/* *********************************** */
yyc_ST_END_HEREDOC:
	YYDEBUG(1079, *YYCURSOR);
	YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(1081, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(1082, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	zend_heredoc_label *heredoc_label = zend_ptr_stack_pop(&SCNG(heredoc_label_stack));

	yyleng = heredoc_label->indentation + heredoc_label->length;
	YYCURSOR += yyleng - 1;

	heredoc_label_dtor(heredoc_label);
	efree(heredoc_label);

	BEGIN(ST_IN_SCRIPTING);
	RETURN_TOKEN(T_END_HEREDOC);
}
/* *********************************** */
yyc_ST_NOWDOC:
	YYDEBUG(1083, *YYCURSOR);
	YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(1085, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(1086, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	zend_heredoc_label *heredoc_label = zend_ptr_stack_top(&SCNG(heredoc_label_stack));
	int newline = 0, indentation = 0, spacing = -1;

	if (YYCURSOR > YYLIMIT) {
		RETURN_END_TOKEN;
	}

	YYCURSOR--;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				ZEND_FALLTHROUGH;
			case '\n':
				indentation = spacing = 0;

				while (YYCURSOR < YYLIMIT && (*YYCURSOR == ' ' || *YYCURSOR == '\t')) {
					if (*YYCURSOR == '\t') {
						spacing |= HEREDOC_USING_TABS;
					} else {
						spacing |= HEREDOC_USING_SPACES;
					}
					++YYCURSOR;
					++indentation;
				}

				if (YYCURSOR == YYLIMIT) {
					yyleng = YYCURSOR - SCNG(yy_text);
					HANDLE_NEWLINES(yytext, yyleng);
					ZVAL_NULL(zendlval);
					RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
				}

				/* Check for ending label on the next line */
				if (IS_LABEL_START(*YYCURSOR) && heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, heredoc_label->label, heredoc_label->length)) {
					if (IS_LABEL_SUCCESSOR(YYCURSOR[heredoc_label->length])) {
						continue;
					}

					if (spacing == (HEREDOC_USING_SPACES | HEREDOC_USING_TABS)) {
						zend_throw_exception(zend_ce_parse_error, "Invalid indentation - tabs and spaces cannot be mixed", 0);
						if (PARSER_MODE()) {
							RETURN_TOKEN(T_ERROR);
						}
					}

					/* newline before label will be subtracted from returned text, but
					 * yyleng/yytext will include it, for zend_highlight/strip, tokenizer, etc. */
					if (YYCURSOR[-indentation - 2] == '\r' && YYCURSOR[-indentation - 1] == '\n') {
						newline = 2; /* Windows newline */
					} else {
						newline = 1;
					}

					CG(increment_lineno) = 1; /* For newline before label */

					YYCURSOR -= indentation;
					heredoc_label->indentation = indentation;

					BEGIN(ST_END_HEREDOC);

					goto nowdoc_scan_done;
				}
				ZEND_FALLTHROUGH;
			default:
				continue;
		}
	}

nowdoc_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);
	ZVAL_STRINGL(zendlval, yytext, yyleng - newline);

	if (!EG(exception) && spacing != -1 && PARSER_MODE()) {
		bool newline_at_start = *(yytext - 1) == '\n' || *(yytext - 1) == '\r';
		if (!strip_multiline_string_indentation(
				zendlval, indentation, spacing == HEREDOC_USING_SPACES,
				newline_at_start, newline != 0)) {
			RETURN_TOKEN(T_ERROR);
		}
	}

	HANDLE_NEWLINES(yytext, yyleng - newline);
	RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
}
}


emit_token_with_str:
	zend_copy_value(zendlval, (yytext + offset), (yyleng - offset));

emit_token_with_val:
	if (PARSER_MODE()) {
		ZEND_ASSERT(Z_TYPE_P(zendlval) != IS_UNDEF);
		elem->ast = zend_ast_create_zval_with_lineno(zendlval, start_line);
	}

emit_token:
	if (SCNG(on_event)) {
		SCNG(on_event)(ON_TOKEN, token, start_line, yytext, yyleng, SCNG(on_event_context));
	}
	return token;

emit_token_with_ident:
	if (PARSER_MODE()) {
		elem->ident = SCNG(yy_text);
	}
	if (SCNG(on_event)) {
		SCNG(on_event)(ON_TOKEN, token, start_line, yytext, yyleng, SCNG(on_event_context));
	}
	return token;

return_whitespace:
	HANDLE_NEWLINES(yytext, yyleng);
	if (SCNG(on_event)) {
		SCNG(on_event)(ON_TOKEN, T_WHITESPACE, start_line, yytext, yyleng, SCNG(on_event_context));
	}
	if (PARSER_MODE()) {
		start_line = CG(zend_lineno);
		goto restart;
	} else {
		return T_WHITESPACE;
	}

skip_token:
	if (SCNG(on_event)) {
		SCNG(on_event)(ON_TOKEN, token, start_line, yytext, yyleng, SCNG(on_event_context));
	}
	start_line = CG(zend_lineno);
	goto restart;
}
