/* This is an SUID wrapper to run a command as some other User.
It allows the calling User to gain the permissions
as defined by the User below.
Written by DirectAdmin

WARNING: ensure you do excessive security checking.
If you use an SUID binary, you're giving anyone who
calls it access to that User.. so ensure the code
you use doesn't allow the caller to run arbitrary commands.

For example, if you only need access to this User to read data from a file,
then do not provide any variables, and grab the data directly from that file.
Don't run arbitrary commands through this binary via command line variables.

Also, if you're going to display senstive info from this binary to the
calling script, expect that it will be possible for the client to do
the same, without the script.  Extra checks to verify the calling script
would be required.

*** ONLY USE AN SUID WRAPPER AS A LAST RESORT ***

************************************/

#define CB_PLUGIN_USER "cb_plugin"

/************************************/

#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <pwd.h>
#include <grp.h>
#include <string.h>
#include <time.h>
#include <errno.h>
extern int errno;

int
use_clearenv (void)
{
#ifdef HAVE_CLEARENV
	return clearenv();
#else
	extern char **environ;
	environ[0] = NULL;
	return 0;
#endif
}

#define INVALID_UID  -1
#define INVALID_GID  -1
#define BUFF_LEN 128

#define aTOz(ch) ('a'<=ch && ch<='z')
#define ATOZ(ch) ('A'<=ch && ch<='Z')
#define ZTON(ch) ('0'<=ch && ch<='9')
int safe_word_check(const char *word)
{
       if (!word || !*word) return 0;
       int len = strlen(word);
       if (len > 100)
       {
               printf("Option '%s' is too long\n", word);
               exit(10);
       }

       for (int i=0; i<len; i++)
       {
               if (aTOz(word[i])) continue;
               if (ATOZ(word[i])) continue;
               if (ZTON(word[i])) continue;
               if (i>0 && word[i] == '.' && word[i-1] == '.')
               {
                       printf("Option '%s' contains two periods: '..' which is not allowed, for security reasons.", word);
                       exit(12);
               }
               switch(word[i])
               {
                       case '_' :
                       case '-' :
                       case '.' :
                       case '@' : 
                       case '/' :
                       case '+' :
                       case ':' :
                               continue;
                               break;
               }

               printf("Option '%s' contains a disallowed character: '%c'\n", word, word[i]);
               exit(11);
       }
       return 1;
}

uid_t getuid_name(const char *adminname)
{
    if(adminname) {
        struct passwd *pwd = getpwnam(adminname);
        if(pwd) return pwd->pw_uid;
    }
    return INVALID_UID;
}

gid_t getgid_name(const char *adminname)
{
    if(adminname) {
        struct group *grp = getgrnam(adminname);
        if(grp) return grp->gr_gid;
    }
    return INVALID_GID;
}

int main(int argc, char **argv)
{
      uid_t original_uid = getuid();
      struct passwd *pwd_caller = getpwuid(original_uid);
      if (pwd_caller == NULL) { printf("getpwuid error: %s\n", strerror(errno)); return 0; }
      if (!pwd_caller->pw_name || strlen(pwd_caller->pw_name) > 16)
      {
             printf("Couldn't get username from uid=%d\n", original_uid);
             exit(8);
      }
      char original_username[BUFF_LEN];
      strncpy(original_username, pwd_caller->pw_name, BUFF_LEN-1);

      if (*original_username == '\0')
      {
             printf("Caller username seems to be blank\n");
             exit(9);
      }

      if (setuid(0) == -1)
      {
              printf("Error setting to uid 0. Ensure %s is chmod to 4755\n", argv[0]);
              printf("setuid(0) error: %s\n", strerror(errno));
              exit(4);
      }

      if (setgid(0) == -1)
      {
              printf("Error setting to gid 0. Ensure %s is chmod to 4755\n", argv[0]);
              exit(5);
      }

      //We are now running as full root.
      
#ifdef CB_PLUGIN_USER
      if (strcmp(original_username, CB_PLUGIN_USER))
      {
             printf("Not called by an Admin account (%s)\n", original_username);
             exit(7);
      }
#endif

	//max 4 command options. Can add more if needed.
	//first entry is 0, and will be set to the command.
	//last entry must be 0, leaving 4 command options
	//If you add more, ensure to change the i<=4 below.

	char *cmd_argv[] = { 0, 0, 0, 0, 0, 0 };
	char cmd[] = "/usr/local/directadmin/custombuild/build";
      
	struct stat filestat;
	if (stat(cmd, &filestat))
	{
		printf("Error with %s: %s\n", cmd, strerror(errno));
		exit(14);
	}

	if (filestat.st_size == 0)
	{
		printf("Script %s appears to be 0 bytes.\n", cmd);
		exit(15);
	}

	int run_in_background = 0;
	if(argc > 1 && !strcmp(argv[1], "background"))
		run_in_background = 1;

	cmd_argv[0] = cmd;
	int c=1;
	for (int i=1+run_in_background; i<argc && i<=4; i++)
	{
		if (argv[i])
			safe_word_check(argv[i]); //this will exit if unsafe

		cmd_argv[c++] = argv[i];
	}

	if (use_clearenv() != 0) {
		printf("Error with clearenv()");
		exit(14);
	}

	char envone[120]="PATH=/usr/kerberos/sbin:/usr/kerberos/bin:/usr/local/sbin:/usr/local/bin:/sbin:/bin:/usr/sbin:/usr/bin:/root/bin";
	putenv(envone);

	if (run_in_background)
	{
		char adminname[] = CB_PLUGIN_USER;
		uid_t admin_uid = getuid_name(adminname);
		if (admin_uid == INVALID_UID)
		{
			printf ("Cannot find UID of %s: %s\n", adminname, strerror(errno)); //errno is set by getuid_name
			exit(17);
		}
		gid_t admin_gid = getgid_name(adminname);
		if (admin_gid == INVALID_GID)
		{
			printf ("Cannot find GID of %s: %s\n", adminname, strerror(errno));
			exit(18);
		}

		time_t t = time(NULL); //before the fork so they copy the result

		pid_t f = fork();

		if (f == -1)
		{
			printf("Unable to fork: %s\n", strerror(errno));
			exit(19);
		}

		if (f > 0) //parent
		{
			printf("%d.%d.log used for the child process\n", t, f);
			exit(0);
		}

		if (setsid() == -1)
		{
			printf("error with set setsid: %s\n", strerror(errno));
			exit(20);
		}

		int log_max = 128;
		char log[log_max];
 		snprintf(log, log_max, "/usr/local/directadmin/plugins/custombuild/logs/%d.%d.log", t, getpid());
	
		//we want admin ownership, so just seteuid temporarily, that way we can't do damage.
		setegid(admin_gid);
		seteuid(admin_uid);

		int fd = open(log, O_RDWR | O_CREAT, S_IRUSR | S_IWUSR); //600

		setegid(0);
		seteuid(0);

		if (fd == -1)
		{
			printf("Error opening %s: %s\n", log, strerror(errno));
			exit(16);
		}

		dup2(fd, 1);
		dup2(fd, 2);

		close(fd);
	}

	execv(cmd, cmd_argv);

	//will never get here because execv becomes the process.
	printf("Execv error: %s\n", strerror(errno));
	exit(18);
}
