import request from '~/api';
import RUN_COMMAND from './actions/runCommand';
import GET_LOG from './actions/getLog';
import CHECK_PROCESS from './actions/checkProcess';

const simpleApiGetter = (id, mutation, defaultValue = {}, trackLoadTime = true) => async ({ commit }) => {
    const startTime = window.performance.now();
    if (trackLoadTime) {
        commit('SET_LOADING_TIME', 0);
    }
    const { data = defaultValue } = await request.get('vue_api', { get: id });
    commit(mutation, data);
    if (trackLoadTime) {
        const time = (window.performance.now() - startTime) / 1000; // passed time in seconds
        commit('SET_LOADING_TIME', time.toFixed(3)); // leave only 3 digist after dot
    }
};

const simpleSetter = prop => (state, data) => {
    state[prop] = data;
};

const store = {
    namespaced: true,
    state: {
        loadingTime: 0,
        version: '',
        updateCommandData: {
            pid: 0,
            command: '',
            log: '',
            status: false,
            live: false,
        },
        apps: null,
        buildTargets: null,
        removalsList: null,
        settings: null,
        settingsValidation: '',
        softwareConfiguration: null,
        configs_list: null,
        versions: null,
        logs: null,
    },
    mutations: {
        SET_UPDATE_LOG: (state, log) => {
            state.updateCommandData.log = log.replace(/\n/g, '\r\n');
        },
        SET_UPDATE_COMMAND: (state, command) => {
            state.updateCommandData.command = command;
        },
        SET_UPDATE_STATUS: (state, status) => {
            state.updateCommandData.status = status;
        },
        SET_UPDATE_PID: (state, pid) => {
            state.updateCommandData.pid = pid;
        },
        SET_UPDATE_LIVE_FLAG: (state, flag) => {
            state.updateCommandData.live = flag;
        },
        SET_VERSION: simpleSetter('version'),
        SET_APPS: simpleSetter('apps'),
        SET_BUILD_TARGETS: simpleSetter('buildTargets'),
        SET_REMOVALS_LIST: simpleSetter('removalsList'),
        SET_SETTINGS: simpleSetter('settings'),
        SET_SOFTWARE_CONFIGURATION: simpleSetter('softwareConfiguration'),
        SET_CONFIGS_LIST: simpleSetter('configs_list'),
        SET_VERSIONS: simpleSetter('versions'),
        SET_LOGS: simpleSetter('logs'),
        SET_LOADING_TIME: simpleSetter('loadingTime'),
        SET_SETTINGS_VALIDATION: simpleSetter('settingsValidation'),
    },
    actions: {
        RUN_COMMAND,
        GET_LOG,
        CHECK_PROCESS,
        KILL_PROCESS: async ({ commit }) => {
            const { status } = await request.get('kill_command');
            commit('SET_UPDATE_PID', 0);
            return status;
        },
        GET_VERSION: simpleApiGetter('version', 'SET_VERSION', '', false),
        GET_APPS: simpleApiGetter('apps', 'SET_APPS'),
        GET_BUILD_TARGETS: simpleApiGetter('build', 'SET_BUILD_TARGETS'),
        GET_REMOVALS_LIST: simpleApiGetter('removals_list', 'SET_REMOVALS_LIST'),
        GET_SETTINGS: simpleApiGetter('settings', 'SET_SETTINGS'),
        GET_SOFTWARE_CONFIGURATION: simpleApiGetter('software_config', 'SET_SOFTWARE_CONFIGURATION'),
        GET_CONFIGS_LIST: simpleApiGetter('configs_list', 'SET_CONFIGS_LIST'),
        GET_VERSIONS: simpleApiGetter('versions', 'SET_VERSIONS'),
        GET_LOGS: simpleApiGetter('log_files', 'SET_LOGS'),
        GET_SETTINGS_VALIDATION: simpleApiGetter('settings_validation', 'SET_SETTINGS_VALIDATION'),
    },
};


export default window.Evolution.registerStore('custombuild', store);