// © 2016 and later: Unicode, Inc. and others.
// License & terms of use: http://www.unicode.org/copyright.html
/**
 * Copyright (C) 2002-2016, International Business Machines Corporation and
 * others. All Rights Reserved.
 *
 * machine-generated by: icu/tools/unicode/py/preparseucd.py
 */

#define UNICODE_VERSION { 12, 1, 0, 0 }

static const Value VALUES_binprop[2] = {
    Value(0, "N No F False"),
    Value(1, "Y Yes T True"),
};

static const Value VALUES_bc[23] = {
    Value(U_LEFT_TO_RIGHT, "L Left_To_Right"),
    Value(U_RIGHT_TO_LEFT, "R Right_To_Left"),
    Value(U_EUROPEAN_NUMBER, "EN European_Number"),
    Value(U_EUROPEAN_NUMBER_SEPARATOR, "ES European_Separator"),
    Value(U_EUROPEAN_NUMBER_TERMINATOR, "ET European_Terminator"),
    Value(U_ARABIC_NUMBER, "AN Arabic_Number"),
    Value(U_COMMON_NUMBER_SEPARATOR, "CS Common_Separator"),
    Value(U_BLOCK_SEPARATOR, "B Paragraph_Separator"),
    Value(U_SEGMENT_SEPARATOR, "S Segment_Separator"),
    Value(U_WHITE_SPACE_NEUTRAL, "WS White_Space"),
    Value(U_OTHER_NEUTRAL, "ON Other_Neutral"),
    Value(U_LEFT_TO_RIGHT_EMBEDDING, "LRE Left_To_Right_Embedding"),
    Value(U_LEFT_TO_RIGHT_OVERRIDE, "LRO Left_To_Right_Override"),
    Value(U_RIGHT_TO_LEFT_ARABIC, "AL Arabic_Letter"),
    Value(U_RIGHT_TO_LEFT_EMBEDDING, "RLE Right_To_Left_Embedding"),
    Value(U_RIGHT_TO_LEFT_OVERRIDE, "RLO Right_To_Left_Override"),
    Value(U_POP_DIRECTIONAL_FORMAT, "PDF Pop_Directional_Format"),
    Value(U_DIR_NON_SPACING_MARK, "NSM Nonspacing_Mark"),
    Value(U_BOUNDARY_NEUTRAL, "BN Boundary_Neutral"),
    Value(U_FIRST_STRONG_ISOLATE, "FSI First_Strong_Isolate"),
    Value(U_LEFT_TO_RIGHT_ISOLATE, "LRI Left_To_Right_Isolate"),
    Value(U_RIGHT_TO_LEFT_ISOLATE, "RLI Right_To_Left_Isolate"),
    Value(U_POP_DIRECTIONAL_ISOLATE, "PDI Pop_Directional_Isolate"),
};

static const Value VALUES_blk[301] = {
    Value(UBLOCK_NO_BLOCK, "NB No_Block"),
    Value(UBLOCK_BASIC_LATIN, "ASCII Basic_Latin"),
    Value(UBLOCK_LATIN_1_SUPPLEMENT, "Latin_1_Sup Latin_1_Supplement Latin_1"),
    Value(UBLOCK_LATIN_EXTENDED_A, "Latin_Ext_A Latin_Extended_A"),
    Value(UBLOCK_LATIN_EXTENDED_B, "Latin_Ext_B Latin_Extended_B"),
    Value(UBLOCK_IPA_EXTENSIONS, "IPA_Ext IPA_Extensions"),
    Value(UBLOCK_SPACING_MODIFIER_LETTERS, "Modifier_Letters Spacing_Modifier_Letters"),
    Value(UBLOCK_COMBINING_DIACRITICAL_MARKS, "Diacriticals Combining_Diacritical_Marks"),
    Value(UBLOCK_GREEK, "Greek Greek_And_Coptic"),
    Value(UBLOCK_CYRILLIC, "Cyrillic Cyrillic"),
    Value(UBLOCK_ARMENIAN, "Armenian Armenian"),
    Value(UBLOCK_HEBREW, "Hebrew Hebrew"),
    Value(UBLOCK_ARABIC, "Arabic Arabic"),
    Value(UBLOCK_SYRIAC, "Syriac Syriac"),
    Value(UBLOCK_THAANA, "Thaana Thaana"),
    Value(UBLOCK_DEVANAGARI, "Devanagari Devanagari"),
    Value(UBLOCK_BENGALI, "Bengali Bengali"),
    Value(UBLOCK_GURMUKHI, "Gurmukhi Gurmukhi"),
    Value(UBLOCK_GUJARATI, "Gujarati Gujarati"),
    Value(UBLOCK_ORIYA, "Oriya Oriya"),
    Value(UBLOCK_TAMIL, "Tamil Tamil"),
    Value(UBLOCK_TELUGU, "Telugu Telugu"),
    Value(UBLOCK_KANNADA, "Kannada Kannada"),
    Value(UBLOCK_MALAYALAM, "Malayalam Malayalam"),
    Value(UBLOCK_SINHALA, "Sinhala Sinhala"),
    Value(UBLOCK_THAI, "Thai Thai"),
    Value(UBLOCK_LAO, "Lao Lao"),
    Value(UBLOCK_TIBETAN, "Tibetan Tibetan"),
    Value(UBLOCK_MYANMAR, "Myanmar Myanmar"),
    Value(UBLOCK_GEORGIAN, "Georgian Georgian"),
    Value(UBLOCK_HANGUL_JAMO, "Jamo Hangul_Jamo"),
    Value(UBLOCK_ETHIOPIC, "Ethiopic Ethiopic"),
    Value(UBLOCK_CHEROKEE, "Cherokee Cherokee"),
    Value(UBLOCK_UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS, "UCAS Unified_Canadian_Aboriginal_Syllabics Canadian_Syllabics"),
    Value(UBLOCK_OGHAM, "Ogham Ogham"),
    Value(UBLOCK_RUNIC, "Runic Runic"),
    Value(UBLOCK_KHMER, "Khmer Khmer"),
    Value(UBLOCK_MONGOLIAN, "Mongolian Mongolian"),
    Value(UBLOCK_LATIN_EXTENDED_ADDITIONAL, "Latin_Ext_Additional Latin_Extended_Additional"),
    Value(UBLOCK_GREEK_EXTENDED, "Greek_Ext Greek_Extended"),
    Value(UBLOCK_GENERAL_PUNCTUATION, "Punctuation General_Punctuation"),
    Value(UBLOCK_SUPERSCRIPTS_AND_SUBSCRIPTS, "Super_And_Sub Superscripts_And_Subscripts"),
    Value(UBLOCK_CURRENCY_SYMBOLS, "Currency_Symbols Currency_Symbols"),
    Value(UBLOCK_COMBINING_MARKS_FOR_SYMBOLS, "Diacriticals_For_Symbols Combining_Diacritical_Marks_For_Symbols Combining_Marks_For_Symbols"),
    Value(UBLOCK_LETTERLIKE_SYMBOLS, "Letterlike_Symbols Letterlike_Symbols"),
    Value(UBLOCK_NUMBER_FORMS, "Number_Forms Number_Forms"),
    Value(UBLOCK_ARROWS, "Arrows Arrows"),
    Value(UBLOCK_MATHEMATICAL_OPERATORS, "Math_Operators Mathematical_Operators"),
    Value(UBLOCK_MISCELLANEOUS_TECHNICAL, "Misc_Technical Miscellaneous_Technical"),
    Value(UBLOCK_CONTROL_PICTURES, "Control_Pictures Control_Pictures"),
    Value(UBLOCK_OPTICAL_CHARACTER_RECOGNITION, "OCR Optical_Character_Recognition"),
    Value(UBLOCK_ENCLOSED_ALPHANUMERICS, "Enclosed_Alphanum Enclosed_Alphanumerics"),
    Value(UBLOCK_BOX_DRAWING, "Box_Drawing Box_Drawing"),
    Value(UBLOCK_BLOCK_ELEMENTS, "Block_Elements Block_Elements"),
    Value(UBLOCK_GEOMETRIC_SHAPES, "Geometric_Shapes Geometric_Shapes"),
    Value(UBLOCK_MISCELLANEOUS_SYMBOLS, "Misc_Symbols Miscellaneous_Symbols"),
    Value(UBLOCK_DINGBATS, "Dingbats Dingbats"),
    Value(UBLOCK_BRAILLE_PATTERNS, "Braille Braille_Patterns"),
    Value(UBLOCK_CJK_RADICALS_SUPPLEMENT, "CJK_Radicals_Sup CJK_Radicals_Supplement"),
    Value(UBLOCK_KANGXI_RADICALS, "Kangxi Kangxi_Radicals"),
    Value(UBLOCK_IDEOGRAPHIC_DESCRIPTION_CHARACTERS, "IDC Ideographic_Description_Characters"),
    Value(UBLOCK_CJK_SYMBOLS_AND_PUNCTUATION, "CJK_Symbols CJK_Symbols_And_Punctuation"),
    Value(UBLOCK_HIRAGANA, "Hiragana Hiragana"),
    Value(UBLOCK_KATAKANA, "Katakana Katakana"),
    Value(UBLOCK_BOPOMOFO, "Bopomofo Bopomofo"),
    Value(UBLOCK_HANGUL_COMPATIBILITY_JAMO, "Compat_Jamo Hangul_Compatibility_Jamo"),
    Value(UBLOCK_KANBUN, "Kanbun Kanbun"),
    Value(UBLOCK_BOPOMOFO_EXTENDED, "Bopomofo_Ext Bopomofo_Extended"),
    Value(UBLOCK_ENCLOSED_CJK_LETTERS_AND_MONTHS, "Enclosed_CJK Enclosed_CJK_Letters_And_Months"),
    Value(UBLOCK_CJK_COMPATIBILITY, "CJK_Compat CJK_Compatibility"),
    Value(UBLOCK_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A, "CJK_Ext_A CJK_Unified_Ideographs_Extension_A"),
    Value(UBLOCK_CJK_UNIFIED_IDEOGRAPHS, "CJK CJK_Unified_Ideographs"),
    Value(UBLOCK_YI_SYLLABLES, "Yi_Syllables Yi_Syllables"),
    Value(UBLOCK_YI_RADICALS, "Yi_Radicals Yi_Radicals"),
    Value(UBLOCK_HANGUL_SYLLABLES, "Hangul Hangul_Syllables"),
    Value(UBLOCK_HIGH_SURROGATES, "High_Surrogates High_Surrogates"),
    Value(UBLOCK_HIGH_PRIVATE_USE_SURROGATES, "High_PU_Surrogates High_Private_Use_Surrogates"),
    Value(UBLOCK_LOW_SURROGATES, "Low_Surrogates Low_Surrogates"),
    Value(UBLOCK_PRIVATE_USE_AREA, "PUA Private_Use_Area Private_Use"),
    Value(UBLOCK_CJK_COMPATIBILITY_IDEOGRAPHS, "CJK_Compat_Ideographs CJK_Compatibility_Ideographs"),
    Value(UBLOCK_ALPHABETIC_PRESENTATION_FORMS, "Alphabetic_PF Alphabetic_Presentation_Forms"),
    Value(UBLOCK_ARABIC_PRESENTATION_FORMS_A, "Arabic_PF_A Arabic_Presentation_Forms_A Arabic_Presentation_Forms-A"),
    Value(UBLOCK_COMBINING_HALF_MARKS, "Half_Marks Combining_Half_Marks"),
    Value(UBLOCK_CJK_COMPATIBILITY_FORMS, "CJK_Compat_Forms CJK_Compatibility_Forms"),
    Value(UBLOCK_SMALL_FORM_VARIANTS, "Small_Forms Small_Form_Variants"),
    Value(UBLOCK_ARABIC_PRESENTATION_FORMS_B, "Arabic_PF_B Arabic_Presentation_Forms_B"),
    Value(UBLOCK_SPECIALS, "Specials Specials"),
    Value(UBLOCK_HALFWIDTH_AND_FULLWIDTH_FORMS, "Half_And_Full_Forms Halfwidth_And_Fullwidth_Forms"),
    Value(UBLOCK_OLD_ITALIC, "Old_Italic Old_Italic"),
    Value(UBLOCK_GOTHIC, "Gothic Gothic"),
    Value(UBLOCK_DESERET, "Deseret Deseret"),
    Value(UBLOCK_BYZANTINE_MUSICAL_SYMBOLS, "Byzantine_Music Byzantine_Musical_Symbols"),
    Value(UBLOCK_MUSICAL_SYMBOLS, "Music Musical_Symbols"),
    Value(UBLOCK_MATHEMATICAL_ALPHANUMERIC_SYMBOLS, "Math_Alphanum Mathematical_Alphanumeric_Symbols"),
    Value(UBLOCK_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B, "CJK_Ext_B CJK_Unified_Ideographs_Extension_B"),
    Value(UBLOCK_CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT, "CJK_Compat_Ideographs_Sup CJK_Compatibility_Ideographs_Supplement"),
    Value(UBLOCK_TAGS, "Tags Tags"),
    Value(UBLOCK_CYRILLIC_SUPPLEMENT, "Cyrillic_Sup Cyrillic_Supplement Cyrillic_Supplementary"),
    Value(UBLOCK_TAGALOG, "Tagalog Tagalog"),
    Value(UBLOCK_HANUNOO, "Hanunoo Hanunoo"),
    Value(UBLOCK_BUHID, "Buhid Buhid"),
    Value(UBLOCK_TAGBANWA, "Tagbanwa Tagbanwa"),
    Value(UBLOCK_MISCELLANEOUS_MATHEMATICAL_SYMBOLS_A, "Misc_Math_Symbols_A Miscellaneous_Mathematical_Symbols_A"),
    Value(UBLOCK_SUPPLEMENTAL_ARROWS_A, "Sup_Arrows_A Supplemental_Arrows_A"),
    Value(UBLOCK_SUPPLEMENTAL_ARROWS_B, "Sup_Arrows_B Supplemental_Arrows_B"),
    Value(UBLOCK_MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B, "Misc_Math_Symbols_B Miscellaneous_Mathematical_Symbols_B"),
    Value(UBLOCK_SUPPLEMENTAL_MATHEMATICAL_OPERATORS, "Sup_Math_Operators Supplemental_Mathematical_Operators"),
    Value(UBLOCK_KATAKANA_PHONETIC_EXTENSIONS, "Katakana_Ext Katakana_Phonetic_Extensions"),
    Value(UBLOCK_VARIATION_SELECTORS, "VS Variation_Selectors"),
    Value(UBLOCK_SUPPLEMENTARY_PRIVATE_USE_AREA_A, "Sup_PUA_A Supplementary_Private_Use_Area_A"),
    Value(UBLOCK_SUPPLEMENTARY_PRIVATE_USE_AREA_B, "Sup_PUA_B Supplementary_Private_Use_Area_B"),
    Value(UBLOCK_LIMBU, "Limbu Limbu"),
    Value(UBLOCK_TAI_LE, "Tai_Le Tai_Le"),
    Value(UBLOCK_KHMER_SYMBOLS, "Khmer_Symbols Khmer_Symbols"),
    Value(UBLOCK_PHONETIC_EXTENSIONS, "Phonetic_Ext Phonetic_Extensions"),
    Value(UBLOCK_MISCELLANEOUS_SYMBOLS_AND_ARROWS, "Misc_Arrows Miscellaneous_Symbols_And_Arrows"),
    Value(UBLOCK_YIJING_HEXAGRAM_SYMBOLS, "Yijing Yijing_Hexagram_Symbols"),
    Value(UBLOCK_LINEAR_B_SYLLABARY, "Linear_B_Syllabary Linear_B_Syllabary"),
    Value(UBLOCK_LINEAR_B_IDEOGRAMS, "Linear_B_Ideograms Linear_B_Ideograms"),
    Value(UBLOCK_AEGEAN_NUMBERS, "Aegean_Numbers Aegean_Numbers"),
    Value(UBLOCK_UGARITIC, "Ugaritic Ugaritic"),
    Value(UBLOCK_SHAVIAN, "Shavian Shavian"),
    Value(UBLOCK_OSMANYA, "Osmanya Osmanya"),
    Value(UBLOCK_CYPRIOT_SYLLABARY, "Cypriot_Syllabary Cypriot_Syllabary"),
    Value(UBLOCK_TAI_XUAN_JING_SYMBOLS, "Tai_Xuan_Jing Tai_Xuan_Jing_Symbols"),
    Value(UBLOCK_VARIATION_SELECTORS_SUPPLEMENT, "VS_Sup Variation_Selectors_Supplement"),
    Value(UBLOCK_ANCIENT_GREEK_MUSICAL_NOTATION, "Ancient_Greek_Music Ancient_Greek_Musical_Notation"),
    Value(UBLOCK_ANCIENT_GREEK_NUMBERS, "Ancient_Greek_Numbers Ancient_Greek_Numbers"),
    Value(UBLOCK_ARABIC_SUPPLEMENT, "Arabic_Sup Arabic_Supplement"),
    Value(UBLOCK_BUGINESE, "Buginese Buginese"),
    Value(UBLOCK_CJK_STROKES, "CJK_Strokes CJK_Strokes"),
    Value(UBLOCK_COMBINING_DIACRITICAL_MARKS_SUPPLEMENT, "Diacriticals_Sup Combining_Diacritical_Marks_Supplement"),
    Value(UBLOCK_COPTIC, "Coptic Coptic"),
    Value(UBLOCK_ETHIOPIC_EXTENDED, "Ethiopic_Ext Ethiopic_Extended"),
    Value(UBLOCK_ETHIOPIC_SUPPLEMENT, "Ethiopic_Sup Ethiopic_Supplement"),
    Value(UBLOCK_GEORGIAN_SUPPLEMENT, "Georgian_Sup Georgian_Supplement"),
    Value(UBLOCK_GLAGOLITIC, "Glagolitic Glagolitic"),
    Value(UBLOCK_KHAROSHTHI, "Kharoshthi Kharoshthi"),
    Value(UBLOCK_MODIFIER_TONE_LETTERS, "Modifier_Tone_Letters Modifier_Tone_Letters"),
    Value(UBLOCK_NEW_TAI_LUE, "New_Tai_Lue New_Tai_Lue"),
    Value(UBLOCK_OLD_PERSIAN, "Old_Persian Old_Persian"),
    Value(UBLOCK_PHONETIC_EXTENSIONS_SUPPLEMENT, "Phonetic_Ext_Sup Phonetic_Extensions_Supplement"),
    Value(UBLOCK_SUPPLEMENTAL_PUNCTUATION, "Sup_Punctuation Supplemental_Punctuation"),
    Value(UBLOCK_SYLOTI_NAGRI, "Syloti_Nagri Syloti_Nagri"),
    Value(UBLOCK_TIFINAGH, "Tifinagh Tifinagh"),
    Value(UBLOCK_VERTICAL_FORMS, "Vertical_Forms Vertical_Forms"),
    Value(UBLOCK_NKO, "NKo NKo"),
    Value(UBLOCK_BALINESE, "Balinese Balinese"),
    Value(UBLOCK_LATIN_EXTENDED_C, "Latin_Ext_C Latin_Extended_C"),
    Value(UBLOCK_LATIN_EXTENDED_D, "Latin_Ext_D Latin_Extended_D"),
    Value(UBLOCK_PHAGS_PA, "Phags_Pa Phags_Pa"),
    Value(UBLOCK_PHOENICIAN, "Phoenician Phoenician"),
    Value(UBLOCK_CUNEIFORM, "Cuneiform Cuneiform"),
    Value(UBLOCK_CUNEIFORM_NUMBERS_AND_PUNCTUATION, "Cuneiform_Numbers Cuneiform_Numbers_And_Punctuation"),
    Value(UBLOCK_COUNTING_ROD_NUMERALS, "Counting_Rod Counting_Rod_Numerals"),
    Value(UBLOCK_SUNDANESE, "Sundanese Sundanese"),
    Value(UBLOCK_LEPCHA, "Lepcha Lepcha"),
    Value(UBLOCK_OL_CHIKI, "Ol_Chiki Ol_Chiki"),
    Value(UBLOCK_CYRILLIC_EXTENDED_A, "Cyrillic_Ext_A Cyrillic_Extended_A"),
    Value(UBLOCK_VAI, "Vai Vai"),
    Value(UBLOCK_CYRILLIC_EXTENDED_B, "Cyrillic_Ext_B Cyrillic_Extended_B"),
    Value(UBLOCK_SAURASHTRA, "Saurashtra Saurashtra"),
    Value(UBLOCK_KAYAH_LI, "Kayah_Li Kayah_Li"),
    Value(UBLOCK_REJANG, "Rejang Rejang"),
    Value(UBLOCK_CHAM, "Cham Cham"),
    Value(UBLOCK_ANCIENT_SYMBOLS, "Ancient_Symbols Ancient_Symbols"),
    Value(UBLOCK_PHAISTOS_DISC, "Phaistos Phaistos_Disc"),
    Value(UBLOCK_LYCIAN, "Lycian Lycian"),
    Value(UBLOCK_CARIAN, "Carian Carian"),
    Value(UBLOCK_LYDIAN, "Lydian Lydian"),
    Value(UBLOCK_MAHJONG_TILES, "Mahjong Mahjong_Tiles"),
    Value(UBLOCK_DOMINO_TILES, "Domino Domino_Tiles"),
    Value(UBLOCK_SAMARITAN, "Samaritan Samaritan"),
    Value(UBLOCK_UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS_EXTENDED, "UCAS_Ext Unified_Canadian_Aboriginal_Syllabics_Extended"),
    Value(UBLOCK_TAI_THAM, "Tai_Tham Tai_Tham"),
    Value(UBLOCK_VEDIC_EXTENSIONS, "Vedic_Ext Vedic_Extensions"),
    Value(UBLOCK_LISU, "Lisu Lisu"),
    Value(UBLOCK_BAMUM, "Bamum Bamum"),
    Value(UBLOCK_COMMON_INDIC_NUMBER_FORMS, "Indic_Number_Forms Common_Indic_Number_Forms"),
    Value(UBLOCK_DEVANAGARI_EXTENDED, "Devanagari_Ext Devanagari_Extended"),
    Value(UBLOCK_HANGUL_JAMO_EXTENDED_A, "Jamo_Ext_A Hangul_Jamo_Extended_A"),
    Value(UBLOCK_JAVANESE, "Javanese Javanese"),
    Value(UBLOCK_MYANMAR_EXTENDED_A, "Myanmar_Ext_A Myanmar_Extended_A"),
    Value(UBLOCK_TAI_VIET, "Tai_Viet Tai_Viet"),
    Value(UBLOCK_MEETEI_MAYEK, "Meetei_Mayek Meetei_Mayek"),
    Value(UBLOCK_HANGUL_JAMO_EXTENDED_B, "Jamo_Ext_B Hangul_Jamo_Extended_B"),
    Value(UBLOCK_IMPERIAL_ARAMAIC, "Imperial_Aramaic Imperial_Aramaic"),
    Value(UBLOCK_OLD_SOUTH_ARABIAN, "Old_South_Arabian Old_South_Arabian"),
    Value(UBLOCK_AVESTAN, "Avestan Avestan"),
    Value(UBLOCK_INSCRIPTIONAL_PARTHIAN, "Inscriptional_Parthian Inscriptional_Parthian"),
    Value(UBLOCK_INSCRIPTIONAL_PAHLAVI, "Inscriptional_Pahlavi Inscriptional_Pahlavi"),
    Value(UBLOCK_OLD_TURKIC, "Old_Turkic Old_Turkic"),
    Value(UBLOCK_RUMI_NUMERAL_SYMBOLS, "Rumi Rumi_Numeral_Symbols"),
    Value(UBLOCK_KAITHI, "Kaithi Kaithi"),
    Value(UBLOCK_EGYPTIAN_HIEROGLYPHS, "Egyptian_Hieroglyphs Egyptian_Hieroglyphs"),
    Value(UBLOCK_ENCLOSED_ALPHANUMERIC_SUPPLEMENT, "Enclosed_Alphanum_Sup Enclosed_Alphanumeric_Supplement"),
    Value(UBLOCK_ENCLOSED_IDEOGRAPHIC_SUPPLEMENT, "Enclosed_Ideographic_Sup Enclosed_Ideographic_Supplement"),
    Value(UBLOCK_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_C, "CJK_Ext_C CJK_Unified_Ideographs_Extension_C"),
    Value(UBLOCK_MANDAIC, "Mandaic Mandaic"),
    Value(UBLOCK_BATAK, "Batak Batak"),
    Value(UBLOCK_ETHIOPIC_EXTENDED_A, "Ethiopic_Ext_A Ethiopic_Extended_A"),
    Value(UBLOCK_BRAHMI, "Brahmi Brahmi"),
    Value(UBLOCK_BAMUM_SUPPLEMENT, "Bamum_Sup Bamum_Supplement"),
    Value(UBLOCK_KANA_SUPPLEMENT, "Kana_Sup Kana_Supplement"),
    Value(UBLOCK_PLAYING_CARDS, "Playing_Cards Playing_Cards"),
    Value(UBLOCK_MISCELLANEOUS_SYMBOLS_AND_PICTOGRAPHS, "Misc_Pictographs Miscellaneous_Symbols_And_Pictographs"),
    Value(UBLOCK_EMOTICONS, "Emoticons Emoticons"),
    Value(UBLOCK_TRANSPORT_AND_MAP_SYMBOLS, "Transport_And_Map Transport_And_Map_Symbols"),
    Value(UBLOCK_ALCHEMICAL_SYMBOLS, "Alchemical Alchemical_Symbols"),
    Value(UBLOCK_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_D, "CJK_Ext_D CJK_Unified_Ideographs_Extension_D"),
    Value(UBLOCK_ARABIC_EXTENDED_A, "Arabic_Ext_A Arabic_Extended_A"),
    Value(UBLOCK_ARABIC_MATHEMATICAL_ALPHABETIC_SYMBOLS, "Arabic_Math Arabic_Mathematical_Alphabetic_Symbols"),
    Value(UBLOCK_CHAKMA, "Chakma Chakma"),
    Value(UBLOCK_MEETEI_MAYEK_EXTENSIONS, "Meetei_Mayek_Ext Meetei_Mayek_Extensions"),
    Value(UBLOCK_MEROITIC_CURSIVE, "Meroitic_Cursive Meroitic_Cursive"),
    Value(UBLOCK_MEROITIC_HIEROGLYPHS, "Meroitic_Hieroglyphs Meroitic_Hieroglyphs"),
    Value(UBLOCK_MIAO, "Miao Miao"),
    Value(UBLOCK_SHARADA, "Sharada Sharada"),
    Value(UBLOCK_SORA_SOMPENG, "Sora_Sompeng Sora_Sompeng"),
    Value(UBLOCK_SUNDANESE_SUPPLEMENT, "Sundanese_Sup Sundanese_Supplement"),
    Value(UBLOCK_TAKRI, "Takri Takri"),
    Value(UBLOCK_BASSA_VAH, "Bassa_Vah Bassa_Vah"),
    Value(UBLOCK_CAUCASIAN_ALBANIAN, "Caucasian_Albanian Caucasian_Albanian"),
    Value(UBLOCK_COPTIC_EPACT_NUMBERS, "Coptic_Epact_Numbers Coptic_Epact_Numbers"),
    Value(UBLOCK_COMBINING_DIACRITICAL_MARKS_EXTENDED, "Diacriticals_Ext Combining_Diacritical_Marks_Extended"),
    Value(UBLOCK_DUPLOYAN, "Duployan Duployan"),
    Value(UBLOCK_ELBASAN, "Elbasan Elbasan"),
    Value(UBLOCK_GEOMETRIC_SHAPES_EXTENDED, "Geometric_Shapes_Ext Geometric_Shapes_Extended"),
    Value(UBLOCK_GRANTHA, "Grantha Grantha"),
    Value(UBLOCK_KHOJKI, "Khojki Khojki"),
    Value(UBLOCK_KHUDAWADI, "Khudawadi Khudawadi"),
    Value(UBLOCK_LATIN_EXTENDED_E, "Latin_Ext_E Latin_Extended_E"),
    Value(UBLOCK_LINEAR_A, "Linear_A Linear_A"),
    Value(UBLOCK_MAHAJANI, "Mahajani Mahajani"),
    Value(UBLOCK_MANICHAEAN, "Manichaean Manichaean"),
    Value(UBLOCK_MENDE_KIKAKUI, "Mende_Kikakui Mende_Kikakui"),
    Value(UBLOCK_MODI, "Modi Modi"),
    Value(UBLOCK_MRO, "Mro Mro"),
    Value(UBLOCK_MYANMAR_EXTENDED_B, "Myanmar_Ext_B Myanmar_Extended_B"),
    Value(UBLOCK_NABATAEAN, "Nabataean Nabataean"),
    Value(UBLOCK_OLD_NORTH_ARABIAN, "Old_North_Arabian Old_North_Arabian"),
    Value(UBLOCK_OLD_PERMIC, "Old_Permic Old_Permic"),
    Value(UBLOCK_ORNAMENTAL_DINGBATS, "Ornamental_Dingbats Ornamental_Dingbats"),
    Value(UBLOCK_PAHAWH_HMONG, "Pahawh_Hmong Pahawh_Hmong"),
    Value(UBLOCK_PALMYRENE, "Palmyrene Palmyrene"),
    Value(UBLOCK_PAU_CIN_HAU, "Pau_Cin_Hau Pau_Cin_Hau"),
    Value(UBLOCK_PSALTER_PAHLAVI, "Psalter_Pahlavi Psalter_Pahlavi"),
    Value(UBLOCK_SHORTHAND_FORMAT_CONTROLS, "Shorthand_Format_Controls Shorthand_Format_Controls"),
    Value(UBLOCK_SIDDHAM, "Siddham Siddham"),
    Value(UBLOCK_SINHALA_ARCHAIC_NUMBERS, "Sinhala_Archaic_Numbers Sinhala_Archaic_Numbers"),
    Value(UBLOCK_SUPPLEMENTAL_ARROWS_C, "Sup_Arrows_C Supplemental_Arrows_C"),
    Value(UBLOCK_TIRHUTA, "Tirhuta Tirhuta"),
    Value(UBLOCK_WARANG_CITI, "Warang_Citi Warang_Citi"),
    Value(UBLOCK_AHOM, "Ahom Ahom"),
    Value(UBLOCK_ANATOLIAN_HIEROGLYPHS, "Anatolian_Hieroglyphs Anatolian_Hieroglyphs"),
    Value(UBLOCK_CHEROKEE_SUPPLEMENT, "Cherokee_Sup Cherokee_Supplement"),
    Value(UBLOCK_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_E, "CJK_Ext_E CJK_Unified_Ideographs_Extension_E"),
    Value(UBLOCK_EARLY_DYNASTIC_CUNEIFORM, "Early_Dynastic_Cuneiform Early_Dynastic_Cuneiform"),
    Value(UBLOCK_HATRAN, "Hatran Hatran"),
    Value(UBLOCK_MULTANI, "Multani Multani"),
    Value(UBLOCK_OLD_HUNGARIAN, "Old_Hungarian Old_Hungarian"),
    Value(UBLOCK_SUPPLEMENTAL_SYMBOLS_AND_PICTOGRAPHS, "Sup_Symbols_And_Pictographs Supplemental_Symbols_And_Pictographs"),
    Value(UBLOCK_SUTTON_SIGNWRITING, "Sutton_SignWriting Sutton_SignWriting"),
    Value(UBLOCK_ADLAM, "Adlam Adlam"),
    Value(UBLOCK_BHAIKSUKI, "Bhaiksuki Bhaiksuki"),
    Value(UBLOCK_CYRILLIC_EXTENDED_C, "Cyrillic_Ext_C Cyrillic_Extended_C"),
    Value(UBLOCK_GLAGOLITIC_SUPPLEMENT, "Glagolitic_Sup Glagolitic_Supplement"),
    Value(UBLOCK_IDEOGRAPHIC_SYMBOLS_AND_PUNCTUATION, "Ideographic_Symbols Ideographic_Symbols_And_Punctuation"),
    Value(UBLOCK_MARCHEN, "Marchen Marchen"),
    Value(UBLOCK_MONGOLIAN_SUPPLEMENT, "Mongolian_Sup Mongolian_Supplement"),
    Value(UBLOCK_NEWA, "Newa Newa"),
    Value(UBLOCK_OSAGE, "Osage Osage"),
    Value(UBLOCK_TANGUT, "Tangut Tangut"),
    Value(UBLOCK_TANGUT_COMPONENTS, "Tangut_Components Tangut_Components"),
    Value(UBLOCK_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_F, "CJK_Ext_F CJK_Unified_Ideographs_Extension_F"),
    Value(UBLOCK_KANA_EXTENDED_A, "Kana_Ext_A Kana_Extended_A"),
    Value(UBLOCK_MASARAM_GONDI, "Masaram_Gondi Masaram_Gondi"),
    Value(UBLOCK_NUSHU, "Nushu Nushu"),
    Value(UBLOCK_SOYOMBO, "Soyombo Soyombo"),
    Value(UBLOCK_SYRIAC_SUPPLEMENT, "Syriac_Sup Syriac_Supplement"),
    Value(UBLOCK_ZANABAZAR_SQUARE, "Zanabazar_Square Zanabazar_Square"),
    Value(UBLOCK_CHESS_SYMBOLS, "Chess_Symbols Chess_Symbols"),
    Value(UBLOCK_DOGRA, "Dogra Dogra"),
    Value(UBLOCK_GEORGIAN_EXTENDED, "Georgian_Ext Georgian_Extended"),
    Value(UBLOCK_GUNJALA_GONDI, "Gunjala_Gondi Gunjala_Gondi"),
    Value(UBLOCK_HANIFI_ROHINGYA, "Hanifi_Rohingya Hanifi_Rohingya"),
    Value(UBLOCK_INDIC_SIYAQ_NUMBERS, "Indic_Siyaq_Numbers Indic_Siyaq_Numbers"),
    Value(UBLOCK_MAKASAR, "Makasar Makasar"),
    Value(UBLOCK_MAYAN_NUMERALS, "Mayan_Numerals Mayan_Numerals"),
    Value(UBLOCK_MEDEFAIDRIN, "Medefaidrin Medefaidrin"),
    Value(UBLOCK_OLD_SOGDIAN, "Old_Sogdian Old_Sogdian"),
    Value(UBLOCK_SOGDIAN, "Sogdian Sogdian"),
    Value(UBLOCK_EGYPTIAN_HIEROGLYPH_FORMAT_CONTROLS, "Egyptian_Hieroglyph_Format_Controls Egyptian_Hieroglyph_Format_Controls"),
    Value(UBLOCK_ELYMAIC, "Elymaic Elymaic"),
    Value(UBLOCK_NANDINAGARI, "Nandinagari Nandinagari"),
    Value(UBLOCK_NYIAKENG_PUACHUE_HMONG, "Nyiakeng_Puachue_Hmong Nyiakeng_Puachue_Hmong"),
    Value(UBLOCK_OTTOMAN_SIYAQ_NUMBERS, "Ottoman_Siyaq_Numbers Ottoman_Siyaq_Numbers"),
    Value(UBLOCK_SMALL_KANA_EXTENSION, "Small_Kana_Ext Small_Kana_Extension"),
    Value(UBLOCK_SYMBOLS_AND_PICTOGRAPHS_EXTENDED_A, "Symbols_And_Pictographs_Ext_A Symbols_And_Pictographs_Extended_A"),
    Value(UBLOCK_TAMIL_SUPPLEMENT, "Tamil_Sup Tamil_Supplement"),
    Value(UBLOCK_WANCHO, "Wancho Wancho"),
};

static const Value VALUES_ccc[57] = {
    Value(0, "NR Not_Reordered"),
    Value(1, "OV Overlay"),
    Value(7, "NK Nukta"),
    Value(8, "KV Kana_Voicing"),
    Value(9, "VR Virama"),
    Value(10, "CCC10 CCC10"),
    Value(11, "CCC11 CCC11"),
    Value(12, "CCC12 CCC12"),
    Value(13, "CCC13 CCC13"),
    Value(14, "CCC14 CCC14"),
    Value(15, "CCC15 CCC15"),
    Value(16, "CCC16 CCC16"),
    Value(17, "CCC17 CCC17"),
    Value(18, "CCC18 CCC18"),
    Value(19, "CCC19 CCC19"),
    Value(20, "CCC20 CCC20"),
    Value(21, "CCC21 CCC21"),
    Value(22, "CCC22 CCC22"),
    Value(23, "CCC23 CCC23"),
    Value(24, "CCC24 CCC24"),
    Value(25, "CCC25 CCC25"),
    Value(26, "CCC26 CCC26"),
    Value(27, "CCC27 CCC27"),
    Value(28, "CCC28 CCC28"),
    Value(29, "CCC29 CCC29"),
    Value(30, "CCC30 CCC30"),
    Value(31, "CCC31 CCC31"),
    Value(32, "CCC32 CCC32"),
    Value(33, "CCC33 CCC33"),
    Value(34, "CCC34 CCC34"),
    Value(35, "CCC35 CCC35"),
    Value(36, "CCC36 CCC36"),
    Value(84, "CCC84 CCC84"),
    Value(91, "CCC91 CCC91"),
    Value(103, "CCC103 CCC103"),
    Value(107, "CCC107 CCC107"),
    Value(118, "CCC118 CCC118"),
    Value(122, "CCC122 CCC122"),
    Value(129, "CCC129 CCC129"),
    Value(130, "CCC130 CCC130"),
    Value(132, "CCC132 CCC132"),
    Value(133, "CCC133 CCC133"),
    Value(200, "ATBL Attached_Below_Left"),
    Value(202, "ATB Attached_Below"),
    Value(214, "ATA Attached_Above"),
    Value(216, "ATAR Attached_Above_Right"),
    Value(218, "BL Below_Left"),
    Value(220, "B Below"),
    Value(222, "BR Below_Right"),
    Value(224, "L Left"),
    Value(226, "R Right"),
    Value(228, "AL Above_Left"),
    Value(230, "A Above"),
    Value(232, "AR Above_Right"),
    Value(233, "DB Double_Below"),
    Value(234, "DA Double_Above"),
    Value(240, "IS Iota_Subscript"),
};

static const Value VALUES_dt[18] = {
    Value(U_DT_NONE, "None None none"),
    Value(U_DT_CANONICAL, "Can Canonical can"),
    Value(U_DT_COMPAT, "Com Compat com"),
    Value(U_DT_CIRCLE, "Enc Circle enc"),
    Value(U_DT_FINAL, "Fin Final fin"),
    Value(U_DT_FONT, "Font Font font"),
    Value(U_DT_FRACTION, "Fra Fraction fra"),
    Value(U_DT_INITIAL, "Init Initial init"),
    Value(U_DT_ISOLATED, "Iso Isolated iso"),
    Value(U_DT_MEDIAL, "Med Medial med"),
    Value(U_DT_NARROW, "Nar Narrow nar"),
    Value(U_DT_NOBREAK, "Nb Nobreak nb"),
    Value(U_DT_SMALL, "Sml Small sml"),
    Value(U_DT_SQUARE, "Sqr Square sqr"),
    Value(U_DT_SUB, "Sub Sub sub"),
    Value(U_DT_SUPER, "Sup Super sup"),
    Value(U_DT_VERTICAL, "Vert Vertical vert"),
    Value(U_DT_WIDE, "Wide Wide wide"),
};

static const Value VALUES_ea[6] = {
    Value(U_EA_NEUTRAL, "N Neutral"),
    Value(U_EA_AMBIGUOUS, "A Ambiguous"),
    Value(U_EA_HALFWIDTH, "H Halfwidth"),
    Value(U_EA_FULLWIDTH, "F Fullwidth"),
    Value(U_EA_NARROW, "Na Narrow"),
    Value(U_EA_WIDE, "W Wide"),
};

static const Value VALUES_gc[30] = {
    Value(U_GENERAL_OTHER_TYPES, "Cn Unassigned"),
    Value(U_UPPERCASE_LETTER, "Lu Uppercase_Letter"),
    Value(U_LOWERCASE_LETTER, "Ll Lowercase_Letter"),
    Value(U_TITLECASE_LETTER, "Lt Titlecase_Letter"),
    Value(U_MODIFIER_LETTER, "Lm Modifier_Letter"),
    Value(U_OTHER_LETTER, "Lo Other_Letter"),
    Value(U_NON_SPACING_MARK, "Mn Nonspacing_Mark"),
    Value(U_ENCLOSING_MARK, "Me Enclosing_Mark"),
    Value(U_COMBINING_SPACING_MARK, "Mc Spacing_Mark"),
    Value(U_DECIMAL_DIGIT_NUMBER, "Nd Decimal_Number digit"),
    Value(U_LETTER_NUMBER, "Nl Letter_Number"),
    Value(U_OTHER_NUMBER, "No Other_Number"),
    Value(U_SPACE_SEPARATOR, "Zs Space_Separator"),
    Value(U_LINE_SEPARATOR, "Zl Line_Separator"),
    Value(U_PARAGRAPH_SEPARATOR, "Zp Paragraph_Separator"),
    Value(U_CONTROL_CHAR, "Cc Control cntrl"),
    Value(U_FORMAT_CHAR, "Cf Format"),
    Value(U_PRIVATE_USE_CHAR, "Co Private_Use"),
    Value(U_SURROGATE, "Cs Surrogate"),
    Value(U_DASH_PUNCTUATION, "Pd Dash_Punctuation"),
    Value(U_START_PUNCTUATION, "Ps Open_Punctuation"),
    Value(U_END_PUNCTUATION, "Pe Close_Punctuation"),
    Value(U_CONNECTOR_PUNCTUATION, "Pc Connector_Punctuation"),
    Value(U_OTHER_PUNCTUATION, "Po Other_Punctuation"),
    Value(U_MATH_SYMBOL, "Sm Math_Symbol"),
    Value(U_CURRENCY_SYMBOL, "Sc Currency_Symbol"),
    Value(U_MODIFIER_SYMBOL, "Sk Modifier_Symbol"),
    Value(U_OTHER_SYMBOL, "So Other_Symbol"),
    Value(U_INITIAL_PUNCTUATION, "Pi Initial_Punctuation"),
    Value(U_FINAL_PUNCTUATION, "Pf Final_Punctuation"),
};

static const Value VALUES_jg[102] = {
    Value(U_JG_NO_JOINING_GROUP, "No_Joining_Group No_Joining_Group"),
    Value(U_JG_AIN, "Ain Ain"),
    Value(U_JG_ALAPH, "Alaph Alaph"),
    Value(U_JG_ALEF, "Alef Alef"),
    Value(U_JG_BEH, "Beh Beh"),
    Value(U_JG_BETH, "Beth Beth"),
    Value(U_JG_DAL, "Dal Dal"),
    Value(U_JG_DALATH_RISH, "Dalath_Rish Dalath_Rish"),
    Value(U_JG_E, "E E"),
    Value(U_JG_FEH, "Feh Feh"),
    Value(U_JG_FINAL_SEMKATH, "Final_Semkath Final_Semkath"),
    Value(U_JG_GAF, "Gaf Gaf"),
    Value(U_JG_GAMAL, "Gamal Gamal"),
    Value(U_JG_HAH, "Hah Hah"),
    Value(U_JG_TEH_MARBUTA_GOAL, "Teh_Marbuta_Goal Hamza_On_Heh_Goal"),
    Value(U_JG_HE, "He He"),
    Value(U_JG_HEH, "Heh Heh"),
    Value(U_JG_HEH_GOAL, "Heh_Goal Heh_Goal"),
    Value(U_JG_HETH, "Heth Heth"),
    Value(U_JG_KAF, "Kaf Kaf"),
    Value(U_JG_KAPH, "Kaph Kaph"),
    Value(U_JG_KNOTTED_HEH, "Knotted_Heh Knotted_Heh"),
    Value(U_JG_LAM, "Lam Lam"),
    Value(U_JG_LAMADH, "Lamadh Lamadh"),
    Value(U_JG_MEEM, "Meem Meem"),
    Value(U_JG_MIM, "Mim Mim"),
    Value(U_JG_NOON, "Noon Noon"),
    Value(U_JG_NUN, "Nun Nun"),
    Value(U_JG_PE, "Pe Pe"),
    Value(U_JG_QAF, "Qaf Qaf"),
    Value(U_JG_QAPH, "Qaph Qaph"),
    Value(U_JG_REH, "Reh Reh"),
    Value(U_JG_REVERSED_PE, "Reversed_Pe Reversed_Pe"),
    Value(U_JG_SAD, "Sad Sad"),
    Value(U_JG_SADHE, "Sadhe Sadhe"),
    Value(U_JG_SEEN, "Seen Seen"),
    Value(U_JG_SEMKATH, "Semkath Semkath"),
    Value(U_JG_SHIN, "Shin Shin"),
    Value(U_JG_SWASH_KAF, "Swash_Kaf Swash_Kaf"),
    Value(U_JG_SYRIAC_WAW, "Syriac_Waw Syriac_Waw"),
    Value(U_JG_TAH, "Tah Tah"),
    Value(U_JG_TAW, "Taw Taw"),
    Value(U_JG_TEH_MARBUTA, "Teh_Marbuta Teh_Marbuta"),
    Value(U_JG_TETH, "Teth Teth"),
    Value(U_JG_WAW, "Waw Waw"),
    Value(U_JG_YEH, "Yeh Yeh"),
    Value(U_JG_YEH_BARREE, "Yeh_Barree Yeh_Barree"),
    Value(U_JG_YEH_WITH_TAIL, "Yeh_With_Tail Yeh_With_Tail"),
    Value(U_JG_YUDH, "Yudh Yudh"),
    Value(U_JG_YUDH_HE, "Yudh_He Yudh_He"),
    Value(U_JG_ZAIN, "Zain Zain"),
    Value(U_JG_FE, "Fe Fe"),
    Value(U_JG_KHAPH, "Khaph Khaph"),
    Value(U_JG_ZHAIN, "Zhain Zhain"),
    Value(U_JG_BURUSHASKI_YEH_BARREE, "Burushaski_Yeh_Barree Burushaski_Yeh_Barree"),
    Value(U_JG_FARSI_YEH, "Farsi_Yeh Farsi_Yeh"),
    Value(U_JG_NYA, "Nya Nya"),
    Value(U_JG_ROHINGYA_YEH, "Rohingya_Yeh Rohingya_Yeh"),
    Value(U_JG_MANICHAEAN_ALEPH, "Manichaean_Aleph Manichaean_Aleph"),
    Value(U_JG_MANICHAEAN_AYIN, "Manichaean_Ayin Manichaean_Ayin"),
    Value(U_JG_MANICHAEAN_BETH, "Manichaean_Beth Manichaean_Beth"),
    Value(U_JG_MANICHAEAN_DALETH, "Manichaean_Daleth Manichaean_Daleth"),
    Value(U_JG_MANICHAEAN_DHAMEDH, "Manichaean_Dhamedh Manichaean_Dhamedh"),
    Value(U_JG_MANICHAEAN_FIVE, "Manichaean_Five Manichaean_Five"),
    Value(U_JG_MANICHAEAN_GIMEL, "Manichaean_Gimel Manichaean_Gimel"),
    Value(U_JG_MANICHAEAN_HETH, "Manichaean_Heth Manichaean_Heth"),
    Value(U_JG_MANICHAEAN_HUNDRED, "Manichaean_Hundred Manichaean_Hundred"),
    Value(U_JG_MANICHAEAN_KAPH, "Manichaean_Kaph Manichaean_Kaph"),
    Value(U_JG_MANICHAEAN_LAMEDH, "Manichaean_Lamedh Manichaean_Lamedh"),
    Value(U_JG_MANICHAEAN_MEM, "Manichaean_Mem Manichaean_Mem"),
    Value(U_JG_MANICHAEAN_NUN, "Manichaean_Nun Manichaean_Nun"),
    Value(U_JG_MANICHAEAN_ONE, "Manichaean_One Manichaean_One"),
    Value(U_JG_MANICHAEAN_PE, "Manichaean_Pe Manichaean_Pe"),
    Value(U_JG_MANICHAEAN_QOPH, "Manichaean_Qoph Manichaean_Qoph"),
    Value(U_JG_MANICHAEAN_RESH, "Manichaean_Resh Manichaean_Resh"),
    Value(U_JG_MANICHAEAN_SADHE, "Manichaean_Sadhe Manichaean_Sadhe"),
    Value(U_JG_MANICHAEAN_SAMEKH, "Manichaean_Samekh Manichaean_Samekh"),
    Value(U_JG_MANICHAEAN_TAW, "Manichaean_Taw Manichaean_Taw"),
    Value(U_JG_MANICHAEAN_TEN, "Manichaean_Ten Manichaean_Ten"),
    Value(U_JG_MANICHAEAN_TETH, "Manichaean_Teth Manichaean_Teth"),
    Value(U_JG_MANICHAEAN_THAMEDH, "Manichaean_Thamedh Manichaean_Thamedh"),
    Value(U_JG_MANICHAEAN_TWENTY, "Manichaean_Twenty Manichaean_Twenty"),
    Value(U_JG_MANICHAEAN_WAW, "Manichaean_Waw Manichaean_Waw"),
    Value(U_JG_MANICHAEAN_YODH, "Manichaean_Yodh Manichaean_Yodh"),
    Value(U_JG_MANICHAEAN_ZAYIN, "Manichaean_Zayin Manichaean_Zayin"),
    Value(U_JG_STRAIGHT_WAW, "Straight_Waw Straight_Waw"),
    Value(U_JG_AFRICAN_FEH, "African_Feh African_Feh"),
    Value(U_JG_AFRICAN_NOON, "African_Noon African_Noon"),
    Value(U_JG_AFRICAN_QAF, "African_Qaf African_Qaf"),
    Value(U_JG_MALAYALAM_BHA, "Malayalam_Bha Malayalam_Bha"),
    Value(U_JG_MALAYALAM_JA, "Malayalam_Ja Malayalam_Ja"),
    Value(U_JG_MALAYALAM_LLA, "Malayalam_Lla Malayalam_Lla"),
    Value(U_JG_MALAYALAM_LLLA, "Malayalam_Llla Malayalam_Llla"),
    Value(U_JG_MALAYALAM_NGA, "Malayalam_Nga Malayalam_Nga"),
    Value(U_JG_MALAYALAM_NNA, "Malayalam_Nna Malayalam_Nna"),
    Value(U_JG_MALAYALAM_NNNA, "Malayalam_Nnna Malayalam_Nnna"),
    Value(U_JG_MALAYALAM_NYA, "Malayalam_Nya Malayalam_Nya"),
    Value(U_JG_MALAYALAM_RA, "Malayalam_Ra Malayalam_Ra"),
    Value(U_JG_MALAYALAM_SSA, "Malayalam_Ssa Malayalam_Ssa"),
    Value(U_JG_MALAYALAM_TTA, "Malayalam_Tta Malayalam_Tta"),
    Value(U_JG_HANIFI_ROHINGYA_KINNA_YA, "Hanifi_Rohingya_Kinna_Ya Hanifi_Rohingya_Kinna_Ya"),
    Value(U_JG_HANIFI_ROHINGYA_PA, "Hanifi_Rohingya_Pa Hanifi_Rohingya_Pa"),
};

static const Value VALUES_jt[6] = {
    Value(U_JT_NON_JOINING, "U Non_Joining"),
    Value(U_JT_JOIN_CAUSING, "C Join_Causing"),
    Value(U_JT_DUAL_JOINING, "D Dual_Joining"),
    Value(U_JT_LEFT_JOINING, "L Left_Joining"),
    Value(U_JT_RIGHT_JOINING, "R Right_Joining"),
    Value(U_JT_TRANSPARENT, "T Transparent"),
};

static const Value VALUES_lb[43] = {
    Value(U_LB_UNKNOWN, "XX Unknown"),
    Value(U_LB_AMBIGUOUS, "AI Ambiguous"),
    Value(U_LB_ALPHABETIC, "AL Alphabetic"),
    Value(U_LB_BREAK_BOTH, "B2 Break_Both"),
    Value(U_LB_BREAK_AFTER, "BA Break_After"),
    Value(U_LB_BREAK_BEFORE, "BB Break_Before"),
    Value(U_LB_MANDATORY_BREAK, "BK Mandatory_Break"),
    Value(U_LB_CONTINGENT_BREAK, "CB Contingent_Break"),
    Value(U_LB_CLOSE_PUNCTUATION, "CL Close_Punctuation"),
    Value(U_LB_COMBINING_MARK, "CM Combining_Mark"),
    Value(U_LB_CARRIAGE_RETURN, "CR Carriage_Return"),
    Value(U_LB_EXCLAMATION, "EX Exclamation"),
    Value(U_LB_GLUE, "GL Glue"),
    Value(U_LB_HYPHEN, "HY Hyphen"),
    Value(U_LB_IDEOGRAPHIC, "ID Ideographic"),
    Value(U_LB_INSEPARABLE, "IN Inseparable Inseperable"),
    Value(U_LB_INFIX_NUMERIC, "IS Infix_Numeric"),
    Value(U_LB_LINE_FEED, "LF Line_Feed"),
    Value(U_LB_NONSTARTER, "NS Nonstarter"),
    Value(U_LB_NUMERIC, "NU Numeric"),
    Value(U_LB_OPEN_PUNCTUATION, "OP Open_Punctuation"),
    Value(U_LB_POSTFIX_NUMERIC, "PO Postfix_Numeric"),
    Value(U_LB_PREFIX_NUMERIC, "PR Prefix_Numeric"),
    Value(U_LB_QUOTATION, "QU Quotation"),
    Value(U_LB_COMPLEX_CONTEXT, "SA Complex_Context"),
    Value(U_LB_SURROGATE, "SG Surrogate"),
    Value(U_LB_SPACE, "SP Space"),
    Value(U_LB_BREAK_SYMBOLS, "SY Break_Symbols"),
    Value(U_LB_ZWSPACE, "ZW ZWSpace"),
    Value(U_LB_NEXT_LINE, "NL Next_Line"),
    Value(U_LB_WORD_JOINER, "WJ Word_Joiner"),
    Value(U_LB_H2, "H2 H2"),
    Value(U_LB_H3, "H3 H3"),
    Value(U_LB_JL, "JL JL"),
    Value(U_LB_JT, "JT JT"),
    Value(U_LB_JV, "JV JV"),
    Value(U_LB_CLOSE_PARENTHESIS, "CP Close_Parenthesis"),
    Value(U_LB_CONDITIONAL_JAPANESE_STARTER, "CJ Conditional_Japanese_Starter"),
    Value(U_LB_HEBREW_LETTER, "HL Hebrew_Letter"),
    Value(U_LB_REGIONAL_INDICATOR, "RI Regional_Indicator"),
    Value(U_LB_E_BASE, "EB E_Base"),
    Value(U_LB_E_MODIFIER, "EM E_Modifier"),
    Value(U_LB_ZWJ, "ZWJ ZWJ"),
};

static const Value VALUES_nt[4] = {
    Value(U_NT_NONE, "None None"),
    Value(U_NT_DECIMAL, "De Decimal"),
    Value(U_NT_DIGIT, "Di Digit"),
    Value(U_NT_NUMERIC, "Nu Numeric"),
};

static const Value VALUES_sc[189] = {
    Value(USCRIPT_COMMON, "Zyyy Common"),
    Value(USCRIPT_INHERITED, "Zinh Inherited Qaai"),
    Value(USCRIPT_ARABIC, "Arab Arabic"),
    Value(USCRIPT_ARMENIAN, "Armn Armenian"),
    Value(USCRIPT_BENGALI, "Beng Bengali"),
    Value(USCRIPT_BOPOMOFO, "Bopo Bopomofo"),
    Value(USCRIPT_CHEROKEE, "Cher Cherokee"),
    Value(USCRIPT_COPTIC, "Copt Coptic Qaac"),
    Value(USCRIPT_CYRILLIC, "Cyrl Cyrillic"),
    Value(USCRIPT_DESERET, "Dsrt Deseret"),
    Value(USCRIPT_DEVANAGARI, "Deva Devanagari"),
    Value(USCRIPT_ETHIOPIC, "Ethi Ethiopic"),
    Value(USCRIPT_GEORGIAN, "Geor Georgian"),
    Value(USCRIPT_GOTHIC, "Goth Gothic"),
    Value(USCRIPT_GREEK, "Grek Greek"),
    Value(USCRIPT_GUJARATI, "Gujr Gujarati"),
    Value(USCRIPT_GURMUKHI, "Guru Gurmukhi"),
    Value(USCRIPT_HAN, "Hani Han"),
    Value(USCRIPT_HANGUL, "Hang Hangul"),
    Value(USCRIPT_HEBREW, "Hebr Hebrew"),
    Value(USCRIPT_HIRAGANA, "Hira Hiragana"),
    Value(USCRIPT_KANNADA, "Knda Kannada"),
    Value(USCRIPT_KATAKANA, "Kana Katakana"),
    Value(USCRIPT_KHMER, "Khmr Khmer"),
    Value(USCRIPT_LAO, "Laoo Lao"),
    Value(USCRIPT_LATIN, "Latn Latin"),
    Value(USCRIPT_MALAYALAM, "Mlym Malayalam"),
    Value(USCRIPT_MONGOLIAN, "Mong Mongolian"),
    Value(USCRIPT_MYANMAR, "Mymr Myanmar"),
    Value(USCRIPT_OGHAM, "Ogam Ogham"),
    Value(USCRIPT_OLD_ITALIC, "Ital Old_Italic"),
    Value(USCRIPT_ORIYA, "Orya Oriya"),
    Value(USCRIPT_RUNIC, "Runr Runic"),
    Value(USCRIPT_SINHALA, "Sinh Sinhala"),
    Value(USCRIPT_SYRIAC, "Syrc Syriac"),
    Value(USCRIPT_TAMIL, "Taml Tamil"),
    Value(USCRIPT_TELUGU, "Telu Telugu"),
    Value(USCRIPT_THAANA, "Thaa Thaana"),
    Value(USCRIPT_THAI, "Thai Thai"),
    Value(USCRIPT_TIBETAN, "Tibt Tibetan"),
    Value(USCRIPT_CANADIAN_ABORIGINAL, "Cans Canadian_Aboriginal"),
    Value(USCRIPT_YI, "Yiii Yi"),
    Value(USCRIPT_TAGALOG, "Tglg Tagalog"),
    Value(USCRIPT_HANUNOO, "Hano Hanunoo"),
    Value(USCRIPT_BUHID, "Buhd Buhid"),
    Value(USCRIPT_TAGBANWA, "Tagb Tagbanwa"),
    Value(USCRIPT_BRAILLE, "Brai Braille"),
    Value(USCRIPT_CYPRIOT, "Cprt Cypriot"),
    Value(USCRIPT_LIMBU, "Limb Limbu"),
    Value(USCRIPT_LINEAR_B, "Linb Linear_B"),
    Value(USCRIPT_OSMANYA, "Osma Osmanya"),
    Value(USCRIPT_SHAVIAN, "Shaw Shavian"),
    Value(USCRIPT_TAI_LE, "Tale Tai_Le"),
    Value(USCRIPT_UGARITIC, "Ugar Ugaritic"),
    Value(USCRIPT_KATAKANA_OR_HIRAGANA, "Hrkt Katakana_Or_Hiragana"),
    Value(USCRIPT_BUGINESE, "Bugi Buginese"),
    Value(USCRIPT_GLAGOLITIC, "Glag Glagolitic"),
    Value(USCRIPT_KHAROSHTHI, "Khar Kharoshthi"),
    Value(USCRIPT_SYLOTI_NAGRI, "Sylo Syloti_Nagri"),
    Value(USCRIPT_NEW_TAI_LUE, "Talu New_Tai_Lue"),
    Value(USCRIPT_TIFINAGH, "Tfng Tifinagh"),
    Value(USCRIPT_OLD_PERSIAN, "Xpeo Old_Persian"),
    Value(USCRIPT_BALINESE, "Bali Balinese"),
    Value(USCRIPT_BATAK, "Batk Batak"),
    Value(USCRIPT_BLISSYMBOLS, "Blis Blis"),
    Value(USCRIPT_BRAHMI, "Brah Brahmi"),
    Value(USCRIPT_CHAM, "Cham Cham"),
    Value(USCRIPT_CIRTH, "Cirt Cirt"),
    Value(USCRIPT_OLD_CHURCH_SLAVONIC_CYRILLIC, "Cyrs Cyrs"),
    Value(USCRIPT_DEMOTIC_EGYPTIAN, "Egyd Egyd"),
    Value(USCRIPT_HIERATIC_EGYPTIAN, "Egyh Egyh"),
    Value(USCRIPT_EGYPTIAN_HIEROGLYPHS, "Egyp Egyptian_Hieroglyphs"),
    Value(USCRIPT_KHUTSURI, "Geok Geok"),
    Value(USCRIPT_SIMPLIFIED_HAN, "Hans Hans"),
    Value(USCRIPT_TRADITIONAL_HAN, "Hant Hant"),
    Value(USCRIPT_PAHAWH_HMONG, "Hmng Pahawh_Hmong"),
    Value(USCRIPT_OLD_HUNGARIAN, "Hung Old_Hungarian"),
    Value(USCRIPT_HARAPPAN_INDUS, "Inds Inds"),
    Value(USCRIPT_JAVANESE, "Java Javanese"),
    Value(USCRIPT_KAYAH_LI, "Kali Kayah_Li"),
    Value(USCRIPT_LATIN_FRAKTUR, "Latf Latf"),
    Value(USCRIPT_LATIN_GAELIC, "Latg Latg"),
    Value(USCRIPT_LEPCHA, "Lepc Lepcha"),
    Value(USCRIPT_LINEAR_A, "Lina Linear_A"),
    Value(USCRIPT_MANDAIC, "Mand Mandaic"),
    Value(USCRIPT_MAYAN_HIEROGLYPHS, "Maya Maya"),
    Value(USCRIPT_MEROITIC_HIEROGLYPHS, "Mero Meroitic_Hieroglyphs"),
    Value(USCRIPT_NKO, "Nkoo Nko"),
    Value(USCRIPT_ORKHON, "Orkh Old_Turkic"),
    Value(USCRIPT_OLD_PERMIC, "Perm Old_Permic"),
    Value(USCRIPT_PHAGS_PA, "Phag Phags_Pa"),
    Value(USCRIPT_PHOENICIAN, "Phnx Phoenician"),
    Value(USCRIPT_MIAO, "Plrd Miao"),
    Value(USCRIPT_RONGORONGO, "Roro Roro"),
    Value(USCRIPT_SARATI, "Sara Sara"),
    Value(USCRIPT_ESTRANGELO_SYRIAC, "Syre Syre"),
    Value(USCRIPT_WESTERN_SYRIAC, "Syrj Syrj"),
    Value(USCRIPT_EASTERN_SYRIAC, "Syrn Syrn"),
    Value(USCRIPT_TENGWAR, "Teng Teng"),
    Value(USCRIPT_VAI, "Vaii Vai"),
    Value(USCRIPT_VISIBLE_SPEECH, "Visp Visp"),
    Value(USCRIPT_CUNEIFORM, "Xsux Cuneiform"),
    Value(USCRIPT_UNWRITTEN_LANGUAGES, "Zxxx Zxxx"),
    Value(USCRIPT_UNKNOWN, "Zzzz Unknown"),
    Value(USCRIPT_CARIAN, "Cari Carian"),
    Value(USCRIPT_JAPANESE, "Jpan Jpan"),
    Value(USCRIPT_LANNA, "Lana Tai_Tham"),
    Value(USCRIPT_LYCIAN, "Lyci Lycian"),
    Value(USCRIPT_LYDIAN, "Lydi Lydian"),
    Value(USCRIPT_OL_CHIKI, "Olck Ol_Chiki"),
    Value(USCRIPT_REJANG, "Rjng Rejang"),
    Value(USCRIPT_SAURASHTRA, "Saur Saurashtra"),
    Value(USCRIPT_SIGN_WRITING, "Sgnw SignWriting"),
    Value(USCRIPT_SUNDANESE, "Sund Sundanese"),
    Value(USCRIPT_MOON, "Moon Moon"),
    Value(USCRIPT_MEITEI_MAYEK, "Mtei Meetei_Mayek"),
    Value(USCRIPT_IMPERIAL_ARAMAIC, "Armi Imperial_Aramaic"),
    Value(USCRIPT_AVESTAN, "Avst Avestan"),
    Value(USCRIPT_CHAKMA, "Cakm Chakma"),
    Value(USCRIPT_KOREAN, "Kore Kore"),
    Value(USCRIPT_KAITHI, "Kthi Kaithi"),
    Value(USCRIPT_MANICHAEAN, "Mani Manichaean"),
    Value(USCRIPT_INSCRIPTIONAL_PAHLAVI, "Phli Inscriptional_Pahlavi"),
    Value(USCRIPT_PSALTER_PAHLAVI, "Phlp Psalter_Pahlavi"),
    Value(USCRIPT_BOOK_PAHLAVI, "Phlv Phlv"),
    Value(USCRIPT_INSCRIPTIONAL_PARTHIAN, "Prti Inscriptional_Parthian"),
    Value(USCRIPT_SAMARITAN, "Samr Samaritan"),
    Value(USCRIPT_TAI_VIET, "Tavt Tai_Viet"),
    Value(USCRIPT_MATHEMATICAL_NOTATION, "Zmth Zmth"),
    Value(USCRIPT_SYMBOLS, "Zsym Zsym"),
    Value(USCRIPT_BAMUM, "Bamu Bamum"),
    Value(USCRIPT_LISU, "Lisu Lisu"),
    Value(USCRIPT_NAKHI_GEBA, "Nkgb Nkgb"),
    Value(USCRIPT_OLD_SOUTH_ARABIAN, "Sarb Old_South_Arabian"),
    Value(USCRIPT_BASSA_VAH, "Bass Bassa_Vah"),
    Value(USCRIPT_DUPLOYAN, "Dupl Duployan"),
    Value(USCRIPT_ELBASAN, "Elba Elbasan"),
    Value(USCRIPT_GRANTHA, "Gran Grantha"),
    Value(USCRIPT_KPELLE, "Kpel Kpel"),
    Value(USCRIPT_LOMA, "Loma Loma"),
    Value(USCRIPT_MENDE, "Mend Mende_Kikakui"),
    Value(USCRIPT_MEROITIC_CURSIVE, "Merc Meroitic_Cursive"),
    Value(USCRIPT_OLD_NORTH_ARABIAN, "Narb Old_North_Arabian"),
    Value(USCRIPT_NABATAEAN, "Nbat Nabataean"),
    Value(USCRIPT_PALMYRENE, "Palm Palmyrene"),
    Value(USCRIPT_KHUDAWADI, "Sind Khudawadi"),
    Value(USCRIPT_WARANG_CITI, "Wara Warang_Citi"),
    Value(USCRIPT_AFAKA, "Afak Afak"),
    Value(USCRIPT_JURCHEN, "Jurc Jurc"),
    Value(USCRIPT_MRO, "Mroo Mro"),
    Value(USCRIPT_NUSHU, "Nshu Nushu"),
    Value(USCRIPT_SHARADA, "Shrd Sharada"),
    Value(USCRIPT_SORA_SOMPENG, "Sora Sora_Sompeng"),
    Value(USCRIPT_TAKRI, "Takr Takri"),
    Value(USCRIPT_TANGUT, "Tang Tangut"),
    Value(USCRIPT_WOLEAI, "Wole Wole"),
    Value(USCRIPT_ANATOLIAN_HIEROGLYPHS, "Hluw Anatolian_Hieroglyphs"),
    Value(USCRIPT_KHOJKI, "Khoj Khojki"),
    Value(USCRIPT_TIRHUTA, "Tirh Tirhuta"),
    Value(USCRIPT_CAUCASIAN_ALBANIAN, "Aghb Caucasian_Albanian"),
    Value(USCRIPT_MAHAJANI, "Mahj Mahajani"),
    Value(USCRIPT_AHOM, "Ahom Ahom"),
    Value(USCRIPT_HATRAN, "Hatr Hatran"),
    Value(USCRIPT_MODI, "Modi Modi"),
    Value(USCRIPT_MULTANI, "Mult Multani"),
    Value(USCRIPT_PAU_CIN_HAU, "Pauc Pau_Cin_Hau"),
    Value(USCRIPT_SIDDHAM, "Sidd Siddham"),
    Value(USCRIPT_ADLAM, "Adlm Adlam"),
    Value(USCRIPT_BHAIKSUKI, "Bhks Bhaiksuki"),
    Value(USCRIPT_MARCHEN, "Marc Marchen"),
    Value(USCRIPT_NEWA, "Newa Newa"),
    Value(USCRIPT_OSAGE, "Osge Osage"),
    Value(USCRIPT_HAN_WITH_BOPOMOFO, "Hanb Hanb"),
    Value(USCRIPT_JAMO, "Jamo Jamo"),
    Value(USCRIPT_SYMBOLS_EMOJI, "Zsye Zsye"),
    Value(USCRIPT_MASARAM_GONDI, "Gonm Masaram_Gondi"),
    Value(USCRIPT_SOYOMBO, "Soyo Soyombo"),
    Value(USCRIPT_ZANABAZAR_SQUARE, "Zanb Zanabazar_Square"),
    Value(USCRIPT_DOGRA, "Dogr Dogra"),
    Value(USCRIPT_GUNJALA_GONDI, "Gong Gunjala_Gondi"),
    Value(USCRIPT_MAKASAR, "Maka Makasar"),
    Value(USCRIPT_MEDEFAIDRIN, "Medf Medefaidrin"),
    Value(USCRIPT_HANIFI_ROHINGYA, "Rohg Hanifi_Rohingya"),
    Value(USCRIPT_SOGDIAN, "Sogd Sogdian"),
    Value(USCRIPT_OLD_SOGDIAN, "Sogo Old_Sogdian"),
    Value(USCRIPT_ELYMAIC, "Elym Elymaic"),
    Value(USCRIPT_NYIAKENG_PUACHUE_HMONG, "Hmnp Nyiakeng_Puachue_Hmong"),
    Value(USCRIPT_NANDINAGARI, "Nand Nandinagari"),
    Value(USCRIPT_WANCHO, "Wcho Wancho"),
};

static const Value VALUES_hst[6] = {
    Value(U_HST_NOT_APPLICABLE, "NA Not_Applicable"),
    Value(U_HST_LEADING_JAMO, "L Leading_Jamo"),
    Value(U_HST_VOWEL_JAMO, "V Vowel_Jamo"),
    Value(U_HST_TRAILING_JAMO, "T Trailing_Jamo"),
    Value(U_HST_LV_SYLLABLE, "LV LV_Syllable"),
    Value(U_HST_LVT_SYLLABLE, "LVT LVT_Syllable"),
};

static const Value VALUES_NFD_QC[2] = {
    Value(UNORM_NO, "N No"),
    Value(UNORM_YES, "Y Yes"),
};

static const Value VALUES_NFKD_QC[2] = {
    Value(UNORM_NO, "N No"),
    Value(UNORM_YES, "Y Yes"),
};

static const Value VALUES_NFC_QC[3] = {
    Value(UNORM_NO, "N No"),
    Value(UNORM_YES, "Y Yes"),
    Value(UNORM_MAYBE, "M Maybe"),
};

static const Value VALUES_NFKC_QC[3] = {
    Value(UNORM_NO, "N No"),
    Value(UNORM_YES, "Y Yes"),
    Value(UNORM_MAYBE, "M Maybe"),
};

static const Value VALUES_lccc[57] = {
    Value(0, "NR Not_Reordered"),
    Value(1, "OV Overlay"),
    Value(7, "NK Nukta"),
    Value(8, "KV Kana_Voicing"),
    Value(9, "VR Virama"),
    Value(10, "CCC10 CCC10"),
    Value(11, "CCC11 CCC11"),
    Value(12, "CCC12 CCC12"),
    Value(13, "CCC13 CCC13"),
    Value(14, "CCC14 CCC14"),
    Value(15, "CCC15 CCC15"),
    Value(16, "CCC16 CCC16"),
    Value(17, "CCC17 CCC17"),
    Value(18, "CCC18 CCC18"),
    Value(19, "CCC19 CCC19"),
    Value(20, "CCC20 CCC20"),
    Value(21, "CCC21 CCC21"),
    Value(22, "CCC22 CCC22"),
    Value(23, "CCC23 CCC23"),
    Value(24, "CCC24 CCC24"),
    Value(25, "CCC25 CCC25"),
    Value(26, "CCC26 CCC26"),
    Value(27, "CCC27 CCC27"),
    Value(28, "CCC28 CCC28"),
    Value(29, "CCC29 CCC29"),
    Value(30, "CCC30 CCC30"),
    Value(31, "CCC31 CCC31"),
    Value(32, "CCC32 CCC32"),
    Value(33, "CCC33 CCC33"),
    Value(34, "CCC34 CCC34"),
    Value(35, "CCC35 CCC35"),
    Value(36, "CCC36 CCC36"),
    Value(84, "CCC84 CCC84"),
    Value(91, "CCC91 CCC91"),
    Value(103, "CCC103 CCC103"),
    Value(107, "CCC107 CCC107"),
    Value(118, "CCC118 CCC118"),
    Value(122, "CCC122 CCC122"),
    Value(129, "CCC129 CCC129"),
    Value(130, "CCC130 CCC130"),
    Value(132, "CCC132 CCC132"),
    Value(133, "CCC133 CCC133"),
    Value(200, "ATBL Attached_Below_Left"),
    Value(202, "ATB Attached_Below"),
    Value(214, "ATA Attached_Above"),
    Value(216, "ATAR Attached_Above_Right"),
    Value(218, "BL Below_Left"),
    Value(220, "B Below"),
    Value(222, "BR Below_Right"),
    Value(224, "L Left"),
    Value(226, "R Right"),
    Value(228, "AL Above_Left"),
    Value(230, "A Above"),
    Value(232, "AR Above_Right"),
    Value(233, "DB Double_Below"),
    Value(234, "DA Double_Above"),
    Value(240, "IS Iota_Subscript"),
};

static const Value VALUES_tccc[57] = {
    Value(0, "NR Not_Reordered"),
    Value(1, "OV Overlay"),
    Value(7, "NK Nukta"),
    Value(8, "KV Kana_Voicing"),
    Value(9, "VR Virama"),
    Value(10, "CCC10 CCC10"),
    Value(11, "CCC11 CCC11"),
    Value(12, "CCC12 CCC12"),
    Value(13, "CCC13 CCC13"),
    Value(14, "CCC14 CCC14"),
    Value(15, "CCC15 CCC15"),
    Value(16, "CCC16 CCC16"),
    Value(17, "CCC17 CCC17"),
    Value(18, "CCC18 CCC18"),
    Value(19, "CCC19 CCC19"),
    Value(20, "CCC20 CCC20"),
    Value(21, "CCC21 CCC21"),
    Value(22, "CCC22 CCC22"),
    Value(23, "CCC23 CCC23"),
    Value(24, "CCC24 CCC24"),
    Value(25, "CCC25 CCC25"),
    Value(26, "CCC26 CCC26"),
    Value(27, "CCC27 CCC27"),
    Value(28, "CCC28 CCC28"),
    Value(29, "CCC29 CCC29"),
    Value(30, "CCC30 CCC30"),
    Value(31, "CCC31 CCC31"),
    Value(32, "CCC32 CCC32"),
    Value(33, "CCC33 CCC33"),
    Value(34, "CCC34 CCC34"),
    Value(35, "CCC35 CCC35"),
    Value(36, "CCC36 CCC36"),
    Value(84, "CCC84 CCC84"),
    Value(91, "CCC91 CCC91"),
    Value(103, "CCC103 CCC103"),
    Value(107, "CCC107 CCC107"),
    Value(118, "CCC118 CCC118"),
    Value(122, "CCC122 CCC122"),
    Value(129, "CCC129 CCC129"),
    Value(130, "CCC130 CCC130"),
    Value(132, "CCC132 CCC132"),
    Value(133, "CCC133 CCC133"),
    Value(200, "ATBL Attached_Below_Left"),
    Value(202, "ATB Attached_Below"),
    Value(214, "ATA Attached_Above"),
    Value(216, "ATAR Attached_Above_Right"),
    Value(218, "BL Below_Left"),
    Value(220, "B Below"),
    Value(222, "BR Below_Right"),
    Value(224, "L Left"),
    Value(226, "R Right"),
    Value(228, "AL Above_Left"),
    Value(230, "A Above"),
    Value(232, "AR Above_Right"),
    Value(233, "DB Double_Below"),
    Value(234, "DA Double_Above"),
    Value(240, "IS Iota_Subscript"),
};

static const Value VALUES_GCB[18] = {
    Value(U_GCB_OTHER, "XX Other"),
    Value(U_GCB_CONTROL, "CN Control"),
    Value(U_GCB_CR, "CR CR"),
    Value(U_GCB_EXTEND, "EX Extend"),
    Value(U_GCB_L, "L L"),
    Value(U_GCB_LF, "LF LF"),
    Value(U_GCB_LV, "LV LV"),
    Value(U_GCB_LVT, "LVT LVT"),
    Value(U_GCB_T, "T T"),
    Value(U_GCB_V, "V V"),
    Value(U_GCB_SPACING_MARK, "SM SpacingMark"),
    Value(U_GCB_PREPEND, "PP Prepend"),
    Value(U_GCB_REGIONAL_INDICATOR, "RI Regional_Indicator"),
    Value(U_GCB_E_BASE, "EB E_Base"),
    Value(U_GCB_E_BASE_GAZ, "EBG E_Base_GAZ"),
    Value(U_GCB_E_MODIFIER, "EM E_Modifier"),
    Value(U_GCB_GLUE_AFTER_ZWJ, "GAZ Glue_After_Zwj"),
    Value(U_GCB_ZWJ, "ZWJ ZWJ"),
};

static const Value VALUES_SB[15] = {
    Value(U_SB_OTHER, "XX Other"),
    Value(U_SB_ATERM, "AT ATerm"),
    Value(U_SB_CLOSE, "CL Close"),
    Value(U_SB_FORMAT, "FO Format"),
    Value(U_SB_LOWER, "LO Lower"),
    Value(U_SB_NUMERIC, "NU Numeric"),
    Value(U_SB_OLETTER, "LE OLetter"),
    Value(U_SB_SEP, "SE Sep"),
    Value(U_SB_SP, "SP Sp"),
    Value(U_SB_STERM, "ST STerm"),
    Value(U_SB_UPPER, "UP Upper"),
    Value(U_SB_CR, "CR CR"),
    Value(U_SB_EXTEND, "EX Extend"),
    Value(U_SB_LF, "LF LF"),
    Value(U_SB_SCONTINUE, "SC SContinue"),
};

static const Value VALUES_WB[23] = {
    Value(U_WB_OTHER, "XX Other"),
    Value(U_WB_ALETTER, "LE ALetter"),
    Value(U_WB_FORMAT, "FO Format"),
    Value(U_WB_KATAKANA, "KA Katakana"),
    Value(U_WB_MIDLETTER, "ML MidLetter"),
    Value(U_WB_MIDNUM, "MN MidNum"),
    Value(U_WB_NUMERIC, "NU Numeric"),
    Value(U_WB_EXTENDNUMLET, "EX ExtendNumLet"),
    Value(U_WB_CR, "CR CR"),
    Value(U_WB_EXTEND, "Extend Extend"),
    Value(U_WB_LF, "LF LF"),
    Value(U_WB_MIDNUMLET, "MB MidNumLet"),
    Value(U_WB_NEWLINE, "NL Newline"),
    Value(U_WB_REGIONAL_INDICATOR, "RI Regional_Indicator"),
    Value(U_WB_HEBREW_LETTER, "HL Hebrew_Letter"),
    Value(U_WB_SINGLE_QUOTE, "SQ Single_Quote"),
    Value(U_WB_DOUBLE_QUOTE, "DQ Double_Quote"),
    Value(U_WB_E_BASE, "EB E_Base"),
    Value(U_WB_E_BASE_GAZ, "EBG E_Base_GAZ"),
    Value(U_WB_E_MODIFIER, "EM E_Modifier"),
    Value(U_WB_GLUE_AFTER_ZWJ, "GAZ Glue_After_Zwj"),
    Value(U_WB_ZWJ, "ZWJ ZWJ"),
    Value(U_WB_WSEGSPACE, "WSegSpace WSegSpace"),
};

static const Value VALUES_bpt[3] = {
    Value(U_BPT_NONE, "n None"),
    Value(U_BPT_OPEN, "o Open"),
    Value(U_BPT_CLOSE, "c Close"),
};

static const Value VALUES_InPC[15] = {
    Value(U_INPC_NA, "NA NA"),
    Value(U_INPC_BOTTOM, "Bottom Bottom"),
    Value(U_INPC_BOTTOM_AND_LEFT, "Bottom_And_Left Bottom_And_Left"),
    Value(U_INPC_BOTTOM_AND_RIGHT, "Bottom_And_Right Bottom_And_Right"),
    Value(U_INPC_LEFT, "Left Left"),
    Value(U_INPC_LEFT_AND_RIGHT, "Left_And_Right Left_And_Right"),
    Value(U_INPC_OVERSTRUCK, "Overstruck Overstruck"),
    Value(U_INPC_RIGHT, "Right Right"),
    Value(U_INPC_TOP, "Top Top"),
    Value(U_INPC_TOP_AND_BOTTOM, "Top_And_Bottom Top_And_Bottom"),
    Value(U_INPC_TOP_AND_BOTTOM_AND_RIGHT, "Top_And_Bottom_And_Right Top_And_Bottom_And_Right"),
    Value(U_INPC_TOP_AND_LEFT, "Top_And_Left Top_And_Left"),
    Value(U_INPC_TOP_AND_LEFT_AND_RIGHT, "Top_And_Left_And_Right Top_And_Left_And_Right"),
    Value(U_INPC_TOP_AND_RIGHT, "Top_And_Right Top_And_Right"),
    Value(U_INPC_VISUAL_ORDER_LEFT, "Visual_Order_Left Visual_Order_Left"),
};

static const Value VALUES_InSC[36] = {
    Value(U_INSC_OTHER, "Other Other"),
    Value(U_INSC_AVAGRAHA, "Avagraha Avagraha"),
    Value(U_INSC_BINDU, "Bindu Bindu"),
    Value(U_INSC_BRAHMI_JOINING_NUMBER, "Brahmi_Joining_Number Brahmi_Joining_Number"),
    Value(U_INSC_CANTILLATION_MARK, "Cantillation_Mark Cantillation_Mark"),
    Value(U_INSC_CONSONANT, "Consonant Consonant"),
    Value(U_INSC_CONSONANT_DEAD, "Consonant_Dead Consonant_Dead"),
    Value(U_INSC_CONSONANT_FINAL, "Consonant_Final Consonant_Final"),
    Value(U_INSC_CONSONANT_HEAD_LETTER, "Consonant_Head_Letter Consonant_Head_Letter"),
    Value(U_INSC_CONSONANT_INITIAL_POSTFIXED, "Consonant_Initial_Postfixed Consonant_Initial_Postfixed"),
    Value(U_INSC_CONSONANT_KILLER, "Consonant_Killer Consonant_Killer"),
    Value(U_INSC_CONSONANT_MEDIAL, "Consonant_Medial Consonant_Medial"),
    Value(U_INSC_CONSONANT_PLACEHOLDER, "Consonant_Placeholder Consonant_Placeholder"),
    Value(U_INSC_CONSONANT_PRECEDING_REPHA, "Consonant_Preceding_Repha Consonant_Preceding_Repha"),
    Value(U_INSC_CONSONANT_PREFIXED, "Consonant_Prefixed Consonant_Prefixed"),
    Value(U_INSC_CONSONANT_SUBJOINED, "Consonant_Subjoined Consonant_Subjoined"),
    Value(U_INSC_CONSONANT_SUCCEEDING_REPHA, "Consonant_Succeeding_Repha Consonant_Succeeding_Repha"),
    Value(U_INSC_CONSONANT_WITH_STACKER, "Consonant_With_Stacker Consonant_With_Stacker"),
    Value(U_INSC_GEMINATION_MARK, "Gemination_Mark Gemination_Mark"),
    Value(U_INSC_INVISIBLE_STACKER, "Invisible_Stacker Invisible_Stacker"),
    Value(U_INSC_JOINER, "Joiner Joiner"),
    Value(U_INSC_MODIFYING_LETTER, "Modifying_Letter Modifying_Letter"),
    Value(U_INSC_NON_JOINER, "Non_Joiner Non_Joiner"),
    Value(U_INSC_NUKTA, "Nukta Nukta"),
    Value(U_INSC_NUMBER, "Number Number"),
    Value(U_INSC_NUMBER_JOINER, "Number_Joiner Number_Joiner"),
    Value(U_INSC_PURE_KILLER, "Pure_Killer Pure_Killer"),
    Value(U_INSC_REGISTER_SHIFTER, "Register_Shifter Register_Shifter"),
    Value(U_INSC_SYLLABLE_MODIFIER, "Syllable_Modifier Syllable_Modifier"),
    Value(U_INSC_TONE_LETTER, "Tone_Letter Tone_Letter"),
    Value(U_INSC_TONE_MARK, "Tone_Mark Tone_Mark"),
    Value(U_INSC_VIRAMA, "Virama Virama"),
    Value(U_INSC_VISARGA, "Visarga Visarga"),
    Value(U_INSC_VOWEL, "Vowel Vowel"),
    Value(U_INSC_VOWEL_DEPENDENT, "Vowel_Dependent Vowel_Dependent"),
    Value(U_INSC_VOWEL_INDEPENDENT, "Vowel_Independent Vowel_Independent"),
};

static const Value VALUES_vo[4] = {
    Value(U_VO_ROTATED, "R Rotated"),
    Value(U_VO_TRANSFORMED_ROTATED, "Tr Transformed_Rotated"),
    Value(U_VO_TRANSFORMED_UPRIGHT, "Tu Transformed_Upright"),
    Value(U_VO_UPRIGHT, "U Upright"),
};

static const Value VALUES_gcm[38] = {
    Value((int32_t)U_GC_C_MASK, "C Other"),
    Value((int32_t)U_GC_CC_MASK, "Cc Control cntrl"),
    Value((int32_t)U_GC_CF_MASK, "Cf Format"),
    Value((int32_t)U_GC_CN_MASK, "Cn Unassigned"),
    Value((int32_t)U_GC_CO_MASK, "Co Private_Use"),
    Value((int32_t)U_GC_CS_MASK, "Cs Surrogate"),
    Value((int32_t)U_GC_L_MASK, "L Letter"),
    Value((int32_t)U_GC_LC_MASK, "LC Cased_Letter"),
    Value((int32_t)U_GC_LL_MASK, "Ll Lowercase_Letter"),
    Value((int32_t)U_GC_LM_MASK, "Lm Modifier_Letter"),
    Value((int32_t)U_GC_LO_MASK, "Lo Other_Letter"),
    Value((int32_t)U_GC_LT_MASK, "Lt Titlecase_Letter"),
    Value((int32_t)U_GC_LU_MASK, "Lu Uppercase_Letter"),
    Value((int32_t)U_GC_M_MASK, "M Mark Combining_Mark"),
    Value((int32_t)U_GC_MC_MASK, "Mc Spacing_Mark"),
    Value((int32_t)U_GC_ME_MASK, "Me Enclosing_Mark"),
    Value((int32_t)U_GC_MN_MASK, "Mn Nonspacing_Mark"),
    Value((int32_t)U_GC_N_MASK, "N Number"),
    Value((int32_t)U_GC_ND_MASK, "Nd Decimal_Number digit"),
    Value((int32_t)U_GC_NL_MASK, "Nl Letter_Number"),
    Value((int32_t)U_GC_NO_MASK, "No Other_Number"),
    Value((int32_t)U_GC_P_MASK, "P Punctuation punct"),
    Value((int32_t)U_GC_PC_MASK, "Pc Connector_Punctuation"),
    Value((int32_t)U_GC_PD_MASK, "Pd Dash_Punctuation"),
    Value((int32_t)U_GC_PE_MASK, "Pe Close_Punctuation"),
    Value((int32_t)U_GC_PF_MASK, "Pf Final_Punctuation"),
    Value((int32_t)U_GC_PI_MASK, "Pi Initial_Punctuation"),
    Value((int32_t)U_GC_PO_MASK, "Po Other_Punctuation"),
    Value((int32_t)U_GC_PS_MASK, "Ps Open_Punctuation"),
    Value((int32_t)U_GC_S_MASK, "S Symbol"),
    Value((int32_t)U_GC_SC_MASK, "Sc Currency_Symbol"),
    Value((int32_t)U_GC_SK_MASK, "Sk Modifier_Symbol"),
    Value((int32_t)U_GC_SM_MASK, "Sm Math_Symbol"),
    Value((int32_t)U_GC_SO_MASK, "So Other_Symbol"),
    Value((int32_t)U_GC_Z_MASK, "Z Separator"),
    Value((int32_t)U_GC_ZL_MASK, "Zl Line_Separator"),
    Value((int32_t)U_GC_ZP_MASK, "Zp Paragraph_Separator"),
    Value((int32_t)U_GC_ZS_MASK, "Zs Space_Separator"),
};

static const Property PROPERTIES[107] = {
    Property(UCHAR_ALPHABETIC, "Alpha Alphabetic"),
    Property(UCHAR_ASCII_HEX_DIGIT, "AHex ASCII_Hex_Digit"),
    Property(UCHAR_BIDI_CONTROL, "Bidi_C Bidi_Control"),
    Property(UCHAR_BIDI_MIRRORED, "Bidi_M Bidi_Mirrored"),
    Property(UCHAR_DASH, "Dash Dash"),
    Property(UCHAR_DEFAULT_IGNORABLE_CODE_POINT, "DI Default_Ignorable_Code_Point"),
    Property(UCHAR_DEPRECATED, "Dep Deprecated"),
    Property(UCHAR_DIACRITIC, "Dia Diacritic"),
    Property(UCHAR_EXTENDER, "Ext Extender"),
    Property(UCHAR_FULL_COMPOSITION_EXCLUSION, "Comp_Ex Full_Composition_Exclusion"),
    Property(UCHAR_GRAPHEME_BASE, "Gr_Base Grapheme_Base"),
    Property(UCHAR_GRAPHEME_EXTEND, "Gr_Ext Grapheme_Extend"),
    Property(UCHAR_GRAPHEME_LINK, "Gr_Link Grapheme_Link"),
    Property(UCHAR_HEX_DIGIT, "Hex Hex_Digit"),
    Property(UCHAR_HYPHEN, "Hyphen Hyphen"),
    Property(UCHAR_ID_CONTINUE, "IDC ID_Continue"),
    Property(UCHAR_ID_START, "IDS ID_Start"),
    Property(UCHAR_IDEOGRAPHIC, "Ideo Ideographic"),
    Property(UCHAR_IDS_BINARY_OPERATOR, "IDSB IDS_Binary_Operator"),
    Property(UCHAR_IDS_TRINARY_OPERATOR, "IDST IDS_Trinary_Operator"),
    Property(UCHAR_JOIN_CONTROL, "Join_C Join_Control"),
    Property(UCHAR_LOGICAL_ORDER_EXCEPTION, "LOE Logical_Order_Exception"),
    Property(UCHAR_LOWERCASE, "Lower Lowercase"),
    Property(UCHAR_MATH, "Math Math"),
    Property(UCHAR_NONCHARACTER_CODE_POINT, "NChar Noncharacter_Code_Point"),
    Property(UCHAR_QUOTATION_MARK, "QMark Quotation_Mark"),
    Property(UCHAR_RADICAL, "Radical Radical"),
    Property(UCHAR_SOFT_DOTTED, "SD Soft_Dotted"),
    Property(UCHAR_TERMINAL_PUNCTUATION, "Term Terminal_Punctuation"),
    Property(UCHAR_UNIFIED_IDEOGRAPH, "UIdeo Unified_Ideograph"),
    Property(UCHAR_UPPERCASE, "Upper Uppercase"),
    Property(UCHAR_WHITE_SPACE, "WSpace White_Space space"),
    Property(UCHAR_XID_CONTINUE, "XIDC XID_Continue"),
    Property(UCHAR_XID_START, "XIDS XID_Start"),
    Property(UCHAR_CASE_SENSITIVE, "Sensitive Case_Sensitive"),
    Property(UCHAR_S_TERM, "STerm Sentence_Terminal"),
    Property(UCHAR_VARIATION_SELECTOR, "VS Variation_Selector"),
    Property(UCHAR_NFD_INERT, "nfdinert NFD_Inert"),
    Property(UCHAR_NFKD_INERT, "nfkdinert NFKD_Inert"),
    Property(UCHAR_NFC_INERT, "nfcinert NFC_Inert"),
    Property(UCHAR_NFKC_INERT, "nfkcinert NFKC_Inert"),
    Property(UCHAR_SEGMENT_STARTER, "segstart Segment_Starter"),
    Property(UCHAR_PATTERN_SYNTAX, "Pat_Syn Pattern_Syntax"),
    Property(UCHAR_PATTERN_WHITE_SPACE, "Pat_WS Pattern_White_Space"),
    Property(UCHAR_POSIX_ALNUM, " alnum"),
    Property(UCHAR_POSIX_BLANK, " blank"),
    Property(UCHAR_POSIX_GRAPH, " graph"),
    Property(UCHAR_POSIX_PRINT, " print"),
    Property(UCHAR_POSIX_XDIGIT, " xdigit"),
    Property(UCHAR_CASED, "Cased Cased"),
    Property(UCHAR_CASE_IGNORABLE, "CI Case_Ignorable"),
    Property(UCHAR_CHANGES_WHEN_LOWERCASED, "CWL Changes_When_Lowercased"),
    Property(UCHAR_CHANGES_WHEN_UPPERCASED, "CWU Changes_When_Uppercased"),
    Property(UCHAR_CHANGES_WHEN_TITLECASED, "CWT Changes_When_Titlecased"),
    Property(UCHAR_CHANGES_WHEN_CASEFOLDED, "CWCF Changes_When_Casefolded"),
    Property(UCHAR_CHANGES_WHEN_CASEMAPPED, "CWCM Changes_When_Casemapped"),
    Property(UCHAR_CHANGES_WHEN_NFKC_CASEFOLDED, "CWKCF Changes_When_NFKC_Casefolded"),
    Property(UCHAR_EMOJI, "Emoji Emoji"),
    Property(UCHAR_EMOJI_PRESENTATION, "EPres Emoji_Presentation"),
    Property(UCHAR_EMOJI_MODIFIER, "EMod Emoji_Modifier"),
    Property(UCHAR_EMOJI_MODIFIER_BASE, "EBase Emoji_Modifier_Base"),
    Property(UCHAR_EMOJI_COMPONENT, "EComp Emoji_Component"),
    Property(UCHAR_REGIONAL_INDICATOR, "RI Regional_Indicator"),
    Property(UCHAR_PREPENDED_CONCATENATION_MARK, "PCM Prepended_Concatenation_Mark"),
    Property(UCHAR_EXTENDED_PICTOGRAPHIC, "ExtPict Extended_Pictographic"),
    Property(UCHAR_BIDI_CLASS, "bc Bidi_Class", VALUES_bc, 23),
    Property(UCHAR_BLOCK, "blk Block", VALUES_blk, 301),
    Property(UCHAR_CANONICAL_COMBINING_CLASS, "ccc Canonical_Combining_Class", VALUES_ccc, 57),
    Property(UCHAR_DECOMPOSITION_TYPE, "dt Decomposition_Type", VALUES_dt, 18),
    Property(UCHAR_EAST_ASIAN_WIDTH, "ea East_Asian_Width", VALUES_ea, 6),
    Property(UCHAR_GENERAL_CATEGORY, "gc General_Category", VALUES_gc, 30),
    Property(UCHAR_JOINING_GROUP, "jg Joining_Group", VALUES_jg, 102),
    Property(UCHAR_JOINING_TYPE, "jt Joining_Type", VALUES_jt, 6),
    Property(UCHAR_LINE_BREAK, "lb Line_Break", VALUES_lb, 43),
    Property(UCHAR_NUMERIC_TYPE, "nt Numeric_Type", VALUES_nt, 4),
    Property(UCHAR_SCRIPT, "sc Script", VALUES_sc, 189),
    Property(UCHAR_HANGUL_SYLLABLE_TYPE, "hst Hangul_Syllable_Type", VALUES_hst, 6),
    Property(UCHAR_NFD_QUICK_CHECK, "NFD_QC NFD_Quick_Check", VALUES_NFD_QC, 2),
    Property(UCHAR_NFKD_QUICK_CHECK, "NFKD_QC NFKD_Quick_Check", VALUES_NFKD_QC, 2),
    Property(UCHAR_NFC_QUICK_CHECK, "NFC_QC NFC_Quick_Check", VALUES_NFC_QC, 3),
    Property(UCHAR_NFKC_QUICK_CHECK, "NFKC_QC NFKC_Quick_Check", VALUES_NFKC_QC, 3),
    Property(UCHAR_LEAD_CANONICAL_COMBINING_CLASS, "lccc Lead_Canonical_Combining_Class", VALUES_lccc, 57),
    Property(UCHAR_TRAIL_CANONICAL_COMBINING_CLASS, "tccc Trail_Canonical_Combining_Class", VALUES_tccc, 57),
    Property(UCHAR_GRAPHEME_CLUSTER_BREAK, "GCB Grapheme_Cluster_Break", VALUES_GCB, 18),
    Property(UCHAR_SENTENCE_BREAK, "SB Sentence_Break", VALUES_SB, 15),
    Property(UCHAR_WORD_BREAK, "WB Word_Break", VALUES_WB, 23),
    Property(UCHAR_BIDI_PAIRED_BRACKET_TYPE, "bpt Bidi_Paired_Bracket_Type", VALUES_bpt, 3),
    Property(UCHAR_INDIC_POSITIONAL_CATEGORY, "InPC Indic_Positional_Category", VALUES_InPC, 15),
    Property(UCHAR_INDIC_SYLLABIC_CATEGORY, "InSC Indic_Syllabic_Category", VALUES_InSC, 36),
    Property(UCHAR_VERTICAL_ORIENTATION, "vo Vertical_Orientation", VALUES_vo, 4),
    Property(UCHAR_GENERAL_CATEGORY_MASK, "gcm General_Category_Mask", VALUES_gcm, 38),
    Property(UCHAR_NUMERIC_VALUE, "nv Numeric_Value"),
    Property(UCHAR_AGE, "age Age"),
    Property(UCHAR_BIDI_MIRRORING_GLYPH, "bmg Bidi_Mirroring_Glyph"),
    Property(UCHAR_CASE_FOLDING, "cf Case_Folding"),
    Property(UCHAR_ISO_COMMENT, "isc ISO_Comment"),
    Property(UCHAR_LOWERCASE_MAPPING, "lc Lowercase_Mapping"),
    Property(UCHAR_NAME, "na Name"),
    Property(UCHAR_SIMPLE_CASE_FOLDING, "scf Simple_Case_Folding sfc"),
    Property(UCHAR_SIMPLE_LOWERCASE_MAPPING, "slc Simple_Lowercase_Mapping"),
    Property(UCHAR_SIMPLE_TITLECASE_MAPPING, "stc Simple_Titlecase_Mapping"),
    Property(UCHAR_SIMPLE_UPPERCASE_MAPPING, "suc Simple_Uppercase_Mapping"),
    Property(UCHAR_TITLECASE_MAPPING, "tc Titlecase_Mapping"),
    Property(UCHAR_UNICODE_1_NAME, "na1 Unicode_1_Name"),
    Property(UCHAR_UPPERCASE_MAPPING, "uc Uppercase_Mapping"),
    Property(UCHAR_BIDI_PAIRED_BRACKET, "bpb Bidi_Paired_Bracket"),
    Property(UCHAR_SCRIPT_EXTENSIONS, "scx Script_Extensions"),
};

const int32_t MAX_ALIASES = 4;
