/*@ gen-errors.h, generated by su-make-errors.sh.
 *@ See core-errors.c for more */

#ifndef su_SOURCE /* For compile-time tools only */
static char const * const a_names_alphasort[] = {
   "NONE", "2BIG", "ACCES", "ADDRINUSE", "ADDRNOTAVAIL",
   "AFNOSUPPORT", "AGAIN", "ALREADY", "BADF", "BADMSG", "BUSY",
   "CANCELED", "CHILD", "CONNABORTED", "CONNREFUSED", "CONNRESET",
   "DEADLK", "DESTADDRREQ", "DOM", "DQUOT", "EXIST", "FAULT", "FBIG",
   "HOSTUNREACH", "IDRM", "ILSEQ", "INPROGRESS", "INTR", "INVAL",
   "IO", "ISCONN", "ISDIR", "LOOP", "MFILE", "MLINK", "MSGSIZE",
   "MULTIHOP", "NAMETOOLONG", "NETDOWN", "NETRESET", "NETUNREACH",
   "NFILE", "NOBUFS", "NODATA", "NODEV", "NOENT", "NOEXEC", "NOLCK",
   "NOLINK", "NOMEM", "NOMSG", "NOPROTOOPT", "NOSPC", "NOSR",
   "NOSTR", "NOSYS", "NOTCONN", "NOTDIR", "NOTEMPTY", "NOTOBACCO",
   "NOTSOCK", "NOTSUP", "NOTTY", "NXIO", "OPNOTSUPP", "OVERFLOW",
   "PERM", "PIPE", "PROTO", "PROTONOSUPPORT", "PROTOTYPE", "RANGE",
   "ROFS", "SPIPE", "SRCH", "STALE", "TIME", "TIMEDOUT", "TXTBSY",
   "WOULDBLOCK", "XDEV", NULL
};
#endif /* !su_SOURCE */

#ifdef su_SOURCE
static char const a_corerr_names[] = {
   /* 0. [0]+4 NONE */
   'N','O','N','E','\0',
   /* 1. [5]+4 2BIG */
   '2','B','I','G','\0',
   /* 2. [10]+5 ACCES */
   'A','C','C','E','S','\0',
   /* 3. [16]+9 ADDRINUSE */
   'A','D','D','R','I','N','U','S','E','\0',
   /* 4. [26]+12 ADDRNOTAVAIL */
   'A','D','D','R','N','O','T','A','V','A','I','L','\0',
   /* 5. [39]+11 AFNOSUPPORT */
   'A','F','N','O','S','U','P','P','O','R','T','\0',
   /* 6. [51]+5 AGAIN */
   'A','G','A','I','N','\0',
   /* 7. [57]+7 ALREADY */
   'A','L','R','E','A','D','Y','\0',
   /* 8. [65]+4 BADF */
   'B','A','D','F','\0',
   /* 9. [70]+6 BADMSG */
   'B','A','D','M','S','G','\0',
   /* 10. [77]+4 BUSY */
   'B','U','S','Y','\0',
   /* 11. [82]+8 CANCELED */
   'C','A','N','C','E','L','E','D','\0',
   /* 12. [91]+5 CHILD */
   'C','H','I','L','D','\0',
   /* 13. [97]+11 CONNABORTED */
   'C','O','N','N','A','B','O','R','T','E','D','\0',
   /* 14. [109]+11 CONNREFUSED */
   'C','O','N','N','R','E','F','U','S','E','D','\0',
   /* 15. [121]+9 CONNRESET */
   'C','O','N','N','R','E','S','E','T','\0',
   /* 16. [131]+6 DEADLK */
   'D','E','A','D','L','K','\0',
   /* 17. [138]+11 DESTADDRREQ */
   'D','E','S','T','A','D','D','R','R','E','Q','\0',
   /* 18. [150]+3 DOM */
   'D','O','M','\0',
   /* 19. [154]+5 DQUOT */
   'D','Q','U','O','T','\0',
   /* 20. [160]+5 EXIST */
   'E','X','I','S','T','\0',
   /* 21. [166]+5 FAULT */
   'F','A','U','L','T','\0',
   /* 22. [172]+4 FBIG */
   'F','B','I','G','\0',
   /* 23. [177]+11 HOSTUNREACH */
   'H','O','S','T','U','N','R','E','A','C','H','\0',
   /* 24. [189]+4 IDRM */
   'I','D','R','M','\0',
   /* 25. [194]+5 ILSEQ */
   'I','L','S','E','Q','\0',
   /* 26. [200]+10 INPROGRESS */
   'I','N','P','R','O','G','R','E','S','S','\0',
   /* 27. [211]+4 INTR */
   'I','N','T','R','\0',
   /* 28. [216]+5 INVAL */
   'I','N','V','A','L','\0',
   /* 29. [222]+2 IO */
   'I','O','\0',
   /* 30. [225]+6 ISCONN */
   'I','S','C','O','N','N','\0',
   /* 31. [232]+5 ISDIR */
   'I','S','D','I','R','\0',
   /* 32. [238]+4 LOOP */
   'L','O','O','P','\0',
   /* 33. [243]+5 MFILE */
   'M','F','I','L','E','\0',
   /* 34. [249]+5 MLINK */
   'M','L','I','N','K','\0',
   /* 35. [255]+7 MSGSIZE */
   'M','S','G','S','I','Z','E','\0',
   /* 36. [263]+8 MULTIHOP */
   'M','U','L','T','I','H','O','P','\0',
   /* 37. [272]+11 NAMETOOLONG */
   'N','A','M','E','T','O','O','L','O','N','G','\0',
   /* 38. [284]+7 NETDOWN */
   'N','E','T','D','O','W','N','\0',
   /* 39. [292]+8 NETRESET */
   'N','E','T','R','E','S','E','T','\0',
   /* 40. [301]+10 NETUNREACH */
   'N','E','T','U','N','R','E','A','C','H','\0',
   /* 41. [312]+5 NFILE */
   'N','F','I','L','E','\0',
   /* 42. [318]+6 NOBUFS */
   'N','O','B','U','F','S','\0',
   /* 43. [325]+6 NODATA */
   'N','O','D','A','T','A','\0',
   /* 44. [332]+5 NODEV */
   'N','O','D','E','V','\0',
   /* 45. [338]+5 NOENT */
   'N','O','E','N','T','\0',
   /* 46. [344]+6 NOEXEC */
   'N','O','E','X','E','C','\0',
   /* 47. [351]+5 NOLCK */
   'N','O','L','C','K','\0',
   /* 48. [357]+6 NOLINK */
   'N','O','L','I','N','K','\0',
   /* 49. [364]+5 NOMEM */
   'N','O','M','E','M','\0',
   /* 50. [370]+5 NOMSG */
   'N','O','M','S','G','\0',
   /* 51. [376]+10 NOPROTOOPT */
   'N','O','P','R','O','T','O','O','P','T','\0',
   /* 52. [387]+5 NOSPC */
   'N','O','S','P','C','\0',
   /* 53. [393]+4 NOSR */
   'N','O','S','R','\0',
   /* 54. [398]+5 NOSTR */
   'N','O','S','T','R','\0',
   /* 55. [404]+5 NOSYS */
   'N','O','S','Y','S','\0',
   /* 56. [410]+7 NOTCONN */
   'N','O','T','C','O','N','N','\0',
   /* 57. [418]+6 NOTDIR */
   'N','O','T','D','I','R','\0',
   /* 58. [425]+8 NOTEMPTY */
   'N','O','T','E','M','P','T','Y','\0',
   /* 59. [434]+9 NOTOBACCO */
   'N','O','T','O','B','A','C','C','O','\0',
   /* 60. [444]+7 NOTSOCK */
   'N','O','T','S','O','C','K','\0',
   /* 61. [452]+6 NOTSUP */
   'N','O','T','S','U','P','\0',
   /* 62. [459]+5 NOTTY */
   'N','O','T','T','Y','\0',
   /* 63. [465]+4 NXIO */
   'N','X','I','O','\0',
   /* 64. [470]+9 OPNOTSUPP */
   'O','P','N','O','T','S','U','P','P','\0',
   /* 65. [480]+8 OVERFLOW */
   'O','V','E','R','F','L','O','W','\0',
   /* 66. [489]+4 PERM */
   'P','E','R','M','\0',
   /* 67. [494]+4 PIPE */
   'P','I','P','E','\0',
   /* 68. [499]+5 PROTO */
   'P','R','O','T','O','\0',
   /* 69. [505]+14 PROTONOSUPPORT */
   'P','R','O','T','O','N','O','S','U','P','P','O','R','T','\0',
   /* 70. [520]+9 PROTOTYPE */
   'P','R','O','T','O','T','Y','P','E','\0',
   /* 71. [530]+5 RANGE */
   'R','A','N','G','E','\0',
   /* 72. [536]+4 ROFS */
   'R','O','F','S','\0',
   /* 73. [541]+5 SPIPE */
   'S','P','I','P','E','\0',
   /* 74. [547]+4 SRCH */
   'S','R','C','H','\0',
   /* 75. [552]+5 STALE */
   'S','T','A','L','E','\0',
   /* 76. [558]+4 TIME */
   'T','I','M','E','\0',
   /* 77. [563]+8 TIMEDOUT */
   'T','I','M','E','D','O','U','T','\0',
   /* 78. [572]+6 TXTBSY */
   'T','X','T','B','S','Y','\0',
   /* 79. [579]+10 WOULDBLOCK */
   'W','O','U','L','D','B','L','O','C','K','\0',
   /* 80. [590]+4 XDEV */
   'X','D','E','V','\0',
};

# ifdef su_HAVE_DOCSTRINGS
#  undef a_X
#  define a_X(X)
static char const a_corerr_docs[] = {
   /* 0. [0]+8 NONE */ a_X(N_("No error"))
   'N','o',' ','e','r','r','o','r','\0',
   /* 1. [9]+22 2BIG */ a_X(N_("Argument list too long"))
   'A','r','g','u','m','e','n','t',' ','l','i','s','t',' ','t','o','o',' ','l','o','n','g','\0',
   /* 2. [32]+17 ACCES */ a_X(N_("Permission denied"))
   'P','e','r','m','i','s','s','i','o','n',' ','d','e','n','i','e','d','\0',
   /* 3. [50]+22 ADDRINUSE */ a_X(N_("Address already in use"))
   'A','d','d','r','e','s','s',' ','a','l','r','e','a','d','y',' ','i','n',' ','u','s','e','\0',
   /* 4. [73]+31 ADDRNOTAVAIL */ a_X(N_("Cannot assign requested address"))
   'C','a','n','n','o','t',' ','a','s','s','i','g','n',' ','r','e','q','u','e','s','t','e','d',' ','a','d','d','r','e','s','s','\0',
   /* 5. [105]+47 AFNOSUPPORT */ a_X(N_("Address family not supported by protocol family"))
   'A','d','d','r','e','s','s',' ','f','a','m','i','l','y',' ','n','o','t',' ','s','u','p','p','o','r','t','e','d',' ','b','y',' ','p','r','o','t','o','c','o','l',' ','f','a','m','i','l','y','\0',
   /* 6. [153]+32 AGAIN */ a_X(N_("Resource temporarily unavailable"))
   'R','e','s','o','u','r','c','e',' ','t','e','m','p','o','r','a','r','i','l','y',' ','u','n','a','v','a','i','l','a','b','l','e','\0',
   /* 7. [186]+29 ALREADY */ a_X(N_("Operation already in progress"))
   'O','p','e','r','a','t','i','o','n',' ','a','l','r','e','a','d','y',' ','i','n',' ','p','r','o','g','r','e','s','s','\0',
   /* 8. [216]+19 BADF */ a_X(N_("Bad file descriptor"))
   'B','a','d',' ','f','i','l','e',' ','d','e','s','c','r','i','p','t','o','r','\0',
   /* 9. [236]+11 BADMSG */ a_X(N_("Bad message"))
   'B','a','d',' ','m','e','s','s','a','g','e','\0',
   /* 10. [248]+11 BUSY */ a_X(N_("Device busy"))
   'D','e','v','i','c','e',' ','b','u','s','y','\0',
   /* 11. [260]+18 CANCELED */ a_X(N_("Operation canceled"))
   'O','p','e','r','a','t','i','o','n',' ','c','a','n','c','e','l','e','d','\0',
   /* 12. [279]+18 CHILD */ a_X(N_("No child processes"))
   'N','o',' ','c','h','i','l','d',' ','p','r','o','c','e','s','s','e','s','\0',
   /* 13. [298]+32 CONNABORTED */ a_X(N_("Software caused connection abort"))
   'S','o','f','t','w','a','r','e',' ','c','a','u','s','e','d',' ','c','o','n','n','e','c','t','i','o','n',' ','a','b','o','r','t','\0',
   /* 14. [331]+18 CONNREFUSED */ a_X(N_("Connection refused"))
   'C','o','n','n','e','c','t','i','o','n',' ','r','e','f','u','s','e','d','\0',
   /* 15. [350]+24 CONNRESET */ a_X(N_("Connection reset by peer"))
   'C','o','n','n','e','c','t','i','o','n',' ','r','e','s','e','t',' ','b','y',' ','p','e','e','r','\0',
   /* 16. [375]+25 DEADLK */ a_X(N_("Resource deadlock avoided"))
   'R','e','s','o','u','r','c','e',' ','d','e','a','d','l','o','c','k',' ','a','v','o','i','d','e','d','\0',
   /* 17. [401]+28 DESTADDRREQ */ a_X(N_("Destination address required"))
   'D','e','s','t','i','n','a','t','i','o','n',' ','a','d','d','r','e','s','s',' ','r','e','q','u','i','r','e','d','\0',
   /* 18. [430]+32 DOM */ a_X(N_("Numerical argument out of domain"))
   'N','u','m','e','r','i','c','a','l',' ','a','r','g','u','m','e','n','t',' ','o','u','t',' ','o','f',' ','d','o','m','a','i','n','\0',
   /* 19. [463]+19 DQUOT */ a_X(N_("Disc quota exceeded"))
   'D','i','s','c',' ','q','u','o','t','a',' ','e','x','c','e','e','d','e','d','\0',
   /* 20. [483]+11 EXIST */ a_X(N_("File exists"))
   'F','i','l','e',' ','e','x','i','s','t','s','\0',
   /* 21. [495]+11 FAULT */ a_X(N_("Bad address"))
   'B','a','d',' ','a','d','d','r','e','s','s','\0',
   /* 22. [507]+14 FBIG */ a_X(N_("File too large"))
   'F','i','l','e',' ','t','o','o',' ','l','a','r','g','e','\0',
   /* 23. [522]+16 HOSTUNREACH */ a_X(N_("No route to host"))
   'N','o',' ','r','o','u','t','e',' ','t','o',' ','h','o','s','t','\0',
   /* 24. [539]+18 IDRM */ a_X(N_("Identifier removed"))
   'I','d','e','n','t','i','f','i','e','r',' ','r','e','m','o','v','e','d','\0',
   /* 25. [558]+21 ILSEQ */ a_X(N_("Illegal byte sequence"))
   'I','l','l','e','g','a','l',' ','b','y','t','e',' ','s','e','q','u','e','n','c','e','\0',
   /* 26. [580]+25 INPROGRESS */ a_X(N_("Operation now in progress"))
   'O','p','e','r','a','t','i','o','n',' ','n','o','w',' ','i','n',' ','p','r','o','g','r','e','s','s','\0',
   /* 27. [606]+23 INTR */ a_X(N_("Interrupted system call"))
   'I','n','t','e','r','r','u','p','t','e','d',' ','s','y','s','t','e','m',' ','c','a','l','l','\0',
   /* 28. [630]+16 INVAL */ a_X(N_("Invalid argument"))
   'I','n','v','a','l','i','d',' ','a','r','g','u','m','e','n','t','\0',
   /* 29. [647]+18 IO */ a_X(N_("Input/output error"))
   'I','n','p','u','t','/','o','u','t','p','u','t',' ','e','r','r','o','r','\0',
   /* 30. [666]+27 ISCONN */ a_X(N_("Socket is already connected"))
   'S','o','c','k','e','t',' ','i','s',' ','a','l','r','e','a','d','y',' ','c','o','n','n','e','c','t','e','d','\0',
   /* 31. [694]+14 ISDIR */ a_X(N_("Is a directory"))
   'I','s',' ','a',' ','d','i','r','e','c','t','o','r','y','\0',
   /* 32. [709]+33 LOOP */ a_X(N_("Too many levels of symbolic links"))
   'T','o','o',' ','m','a','n','y',' ','l','e','v','e','l','s',' ','o','f',' ','s','y','m','b','o','l','i','c',' ','l','i','n','k','s','\0',
   /* 33. [743]+19 MFILE */ a_X(N_("Too many open files"))
   'T','o','o',' ','m','a','n','y',' ','o','p','e','n',' ','f','i','l','e','s','\0',
   /* 34. [763]+14 MLINK */ a_X(N_("Too many links"))
   'T','o','o',' ','m','a','n','y',' ','l','i','n','k','s','\0',
   /* 35. [778]+16 MSGSIZE */ a_X(N_("Message too long"))
   'M','e','s','s','a','g','e',' ','t','o','o',' ','l','o','n','g','\0',
   /* 36. [795]+18 MULTIHOP */ a_X(N_("Multihop attempted"))
   'M','u','l','t','i','h','o','p',' ','a','t','t','e','m','p','t','e','d','\0',
   /* 37. [814]+18 NAMETOOLONG */ a_X(N_("File name too long"))
   'F','i','l','e',' ','n','a','m','e',' ','t','o','o',' ','l','o','n','g','\0',
   /* 38. [833]+15 NETDOWN */ a_X(N_("Network is down"))
   'N','e','t','w','o','r','k',' ','i','s',' ','d','o','w','n','\0',
   /* 39. [849]+35 NETRESET */ a_X(N_("Network dropped connection on reset"))
   'N','e','t','w','o','r','k',' ','d','r','o','p','p','e','d',' ','c','o','n','n','e','c','t','i','o','n',' ','o','n',' ','r','e','s','e','t','\0',
   /* 40. [885]+22 NETUNREACH */ a_X(N_("Network is unreachable"))
   'N','e','t','w','o','r','k',' ','i','s',' ','u','n','r','e','a','c','h','a','b','l','e','\0',
   /* 41. [908]+29 NFILE */ a_X(N_("Too many open files in system"))
   'T','o','o',' ','m','a','n','y',' ','o','p','e','n',' ','f','i','l','e','s',' ','i','n',' ','s','y','s','t','e','m','\0',
   /* 42. [938]+25 NOBUFS */ a_X(N_("No buffer space available"))
   'N','o',' ','b','u','f','f','e','r',' ','s','p','a','c','e',' ','a','v','a','i','l','a','b','l','e','\0',
   /* 43. [964]+17 NODATA */ a_X(N_("No data available"))
   'N','o',' ','d','a','t','a',' ','a','v','a','i','l','a','b','l','e','\0',
   /* 44. [982]+33 NODEV */ a_X(N_("Operation not supported by device"))
   'O','p','e','r','a','t','i','o','n',' ','n','o','t',' ','s','u','p','p','o','r','t','e','d',' ','b','y',' ','d','e','v','i','c','e','\0',
   /* 45. [1016]+32 NOENT */ a_X(N_("No such entry, file or directory"))
   'N','o',' ','s','u','c','h',' ','e','n','t','r','y',',',' ','f','i','l','e',' ','o','r',' ','d','i','r','e','c','t','o','r','y','\0',
   /* 46. [1049]+17 NOEXEC */ a_X(N_("Exec format error"))
   'E','x','e','c',' ','f','o','r','m','a','t',' ','e','r','r','o','r','\0',
   /* 47. [1067]+18 NOLCK */ a_X(N_("No locks available"))
   'N','o',' ','l','o','c','k','s',' ','a','v','a','i','l','a','b','l','e','\0',
   /* 48. [1086]+21 NOLINK */ a_X(N_("Link has been severed"))
   'L','i','n','k',' ','h','a','s',' ','b','e','e','n',' ','s','e','v','e','r','e','d','\0',
   /* 49. [1108]+22 NOMEM */ a_X(N_("Cannot allocate memory"))
   'C','a','n','n','o','t',' ','a','l','l','o','c','a','t','e',' ','m','e','m','o','r','y','\0',
   /* 50. [1131]+26 NOMSG */ a_X(N_("No message of desired type"))
   'N','o',' ','m','e','s','s','a','g','e',' ','o','f',' ','d','e','s','i','r','e','d',' ','t','y','p','e','\0',
   /* 51. [1158]+22 NOPROTOOPT */ a_X(N_("Protocol not available"))
   'P','r','o','t','o','c','o','l',' ','n','o','t',' ','a','v','a','i','l','a','b','l','e','\0',
   /* 52. [1181]+23 NOSPC */ a_X(N_("No space left on device"))
   'N','o',' ','s','p','a','c','e',' ','l','e','f','t',' ','o','n',' ','d','e','v','i','c','e','\0',
   /* 53. [1205]+23 NOSR */ a_X(N_("Out of streams resource"))
   'O','u','t',' ','o','f',' ','s','t','r','e','a','m','s',' ','r','e','s','o','u','r','c','e','\0',
   /* 54. [1229]+19 NOSTR */ a_X(N_("Device not a stream"))
   'D','e','v','i','c','e',' ','n','o','t',' ','a',' ','s','t','r','e','a','m','\0',
   /* 55. [1249]+24 NOSYS */ a_X(N_("Function not implemented"))
   'F','u','n','c','t','i','o','n',' ','n','o','t',' ','i','m','p','l','e','m','e','n','t','e','d','\0',
   /* 56. [1274]+23 NOTCONN */ a_X(N_("Socket is not connected"))
   'S','o','c','k','e','t',' ','i','s',' ','n','o','t',' ','c','o','n','n','e','c','t','e','d','\0',
   /* 57. [1298]+15 NOTDIR */ a_X(N_("Not a directory"))
   'N','o','t',' ','a',' ','d','i','r','e','c','t','o','r','y','\0',
   /* 58. [1314]+19 NOTEMPTY */ a_X(N_("Directory not empty"))
   'D','i','r','e','c','t','o','r','y',' ','n','o','t',' ','e','m','p','t','y','\0',
   /* 59. [1334]+36 NOTOBACCO */ a_X(N_("No tobacco, snorkeling on empty pipe"))
   'N','o',' ','t','o','b','a','c','c','o',',',' ','s','n','o','r','k','e','l','i','n','g',' ','o','n',' ','e','m','p','t','y',' ','p','i','p','e','\0',
   /* 60. [1371]+30 NOTSOCK */ a_X(N_("Socket operation on non-socket"))
   'S','o','c','k','e','t',' ','o','p','e','r','a','t','i','o','n',' ','o','n',' ','n','o','n','-','s','o','c','k','e','t','\0',
   /* 61. [1402]+23 NOTSUP */ a_X(N_("Operation not supported"))
   'O','p','e','r','a','t','i','o','n',' ','n','o','t',' ','s','u','p','p','o','r','t','e','d','\0',
   /* 62. [1426]+30 NOTTY */ a_X(N_("Inappropriate ioctl for device"))
   'I','n','a','p','p','r','o','p','r','i','a','t','e',' ','i','o','c','t','l',' ','f','o','r',' ','d','e','v','i','c','e','\0',
   /* 63. [1457]+21 NXIO */ a_X(N_("Device not configured"))
   'D','e','v','i','c','e',' ','n','o','t',' ','c','o','n','f','i','g','u','r','e','d','\0',
   /* 64. [1479]+23 OPNOTSUPP */ a_X(N_("Operation not supported"))
   'O','p','e','r','a','t','i','o','n',' ','n','o','t',' ','s','u','p','p','o','r','t','e','d','\0',
   /* 65. [1503]+41 OVERFLOW */ a_X(N_("Value too large to be stored in data type"))
   'V','a','l','u','e',' ','t','o','o',' ','l','a','r','g','e',' ','t','o',' ','b','e',' ','s','t','o','r','e','d',' ','i','n',' ','d','a','t','a',' ','t','y','p','e','\0',
   /* 66. [1545]+23 PERM */ a_X(N_("Operation not permitted"))
   'O','p','e','r','a','t','i','o','n',' ','n','o','t',' ','p','e','r','m','i','t','t','e','d','\0',
   /* 67. [1569]+11 PIPE */ a_X(N_("Broken pipe"))
   'B','r','o','k','e','n',' ','p','i','p','e','\0',
   /* 68. [1581]+14 PROTO */ a_X(N_("Protocol error"))
   'P','r','o','t','o','c','o','l',' ','e','r','r','o','r','\0',
   /* 69. [1596]+22 PROTONOSUPPORT */ a_X(N_("Protocol not supported"))
   'P','r','o','t','o','c','o','l',' ','n','o','t',' ','s','u','p','p','o','r','t','e','d','\0',
   /* 70. [1619]+30 PROTOTYPE */ a_X(N_("Protocol wrong type for socket"))
   'P','r','o','t','o','c','o','l',' ','w','r','o','n','g',' ','t','y','p','e',' ','f','o','r',' ','s','o','c','k','e','t','\0',
   /* 71. [1650]+16 RANGE */ a_X(N_("Result too large"))
   'R','e','s','u','l','t',' ','t','o','o',' ','l','a','r','g','e','\0',
   /* 72. [1667]+20 ROFS */ a_X(N_("Read-only filesystem"))
   'R','e','a','d','-','o','n','l','y',' ','f','i','l','e','s','y','s','t','e','m','\0',
   /* 73. [1688]+12 SPIPE */ a_X(N_("Invalid seek"))
   'I','n','v','a','l','i','d',' ','s','e','e','k','\0',
   /* 74. [1701]+15 SRCH */ a_X(N_("No such process"))
   'N','o',' ','s','u','c','h',' ','p','r','o','c','e','s','s','\0',
   /* 75. [1717]+21 STALE */ a_X(N_("Stale NFS file handle"))
   'S','t','a','l','e',' ','N','F','S',' ','f','i','l','e',' ','h','a','n','d','l','e','\0',
   /* 76. [1739]+13 TIME */ a_X(N_("Timer expired"))
   'T','i','m','e','r',' ','e','x','p','i','r','e','d','\0',
   /* 77. [1753]+19 TIMEDOUT */ a_X(N_("Operation timed out"))
   'O','p','e','r','a','t','i','o','n',' ','t','i','m','e','d',' ','o','u','t','\0',
   /* 78. [1773]+14 TXTBSY */ a_X(N_("Text file busy"))
   'T','e','x','t',' ','f','i','l','e',' ','b','u','s','y','\0',
   /* 79. [1788]+21 WOULDBLOCK */ a_X(N_("Operation would block"))
   'O','p','e','r','a','t','i','o','n',' ','w','o','u','l','d',' ','b','l','o','c','k','\0',
   /* 80. [1810]+17 XDEV */ a_X(N_("Cross-device link"))
   'C','r','o','s','s','-','d','e','v','i','c','e',' ','l','i','n','k','\0',
};
#  undef a_X
# endif /* su_HAVE_DOCSTRINGS */

# undef a_X
# ifndef __CREATE_ERRORS_SH
#  define a_X(X) X
# else
#  define a_X(X) 0
# endif
static struct a_corerr_map const a_corerr_map[] = {
   {233011709u, 0u, 0u, a_X(su_ERR_NONE)},
   {338119313u, 5u, 9u, a_X(su_ERR_2BIG)},
   {2760110381u, 10u, 32u, a_X(su_ERR_ACCES)},
   {3973621059u, 16u, 50u, a_X(su_ERR_ADDRINUSE)},
   {4228849030u, 26u, 73u, a_X(su_ERR_ADDRNOTAVAIL)},
   {1437911301u, 39u, 105u, a_X(su_ERR_AFNOSUPPORT)},
   {1876217389u, 51u, 153u, a_X(su_ERR_AGAIN)},
   {2638797879u, 57u, 186u, a_X(su_ERR_ALREADY)},
   {1628681718u, 65u, 216u, a_X(su_ERR_BADF)},
   {3563543249u, 70u, 236u, a_X(su_ERR_BADMSG)},
   {332518208u, 77u, 248u, a_X(su_ERR_BUSY)},
   {1622129131u, 82u, 260u, a_X(su_ERR_CANCELED)},
   {3508732648u, 91u, 279u, a_X(su_ERR_CHILD)},
   {3696001689u, 97u, 298u, a_X(su_ERR_CONNABORTED)},
   {1535510636u, 109u, 331u, a_X(su_ERR_CONNREFUSED)},
   {323416381u, 121u, 350u, a_X(su_ERR_CONNRESET)},
   {265908508u, 131u, 375u, a_X(su_ERR_DEADLK)},
   {1947834517u, 138u, 401u, a_X(su_ERR_DESTADDRREQ)},
   {689055206u, 150u, 430u, a_X(su_ERR_DOM)},
   {2103109256u, 154u, 463u, a_X(su_ERR_DQUOT)},
   {690634405u, 160u, 483u, a_X(su_ERR_EXIST)},
   {1325100503u, 166u, 495u, a_X(su_ERR_FAULT)},
   {191906582u, 172u, 507u, a_X(su_ERR_FBIG)},
   {3136618891u, 177u, 522u, a_X(su_ERR_HOSTUNREACH)},
   {597011636u, 189u, 539u, a_X(su_ERR_IDRM)},
   {3837265952u, 194u, 558u, a_X(su_ERR_ILSEQ)},
   {164315250u, 200u, 580u, a_X(su_ERR_INPROGRESS)},
   {295637505u, 211u, 606u, a_X(su_ERR_INTR)},
   {4001353557u, 216u, 630u, a_X(su_ERR_INVAL)},
   {1727311571u, 222u, 647u, a_X(su_ERR_IO)},
   {1873054828u, 225u, 666u, a_X(su_ERR_ISCONN)},
   {2112607642u, 232u, 694u, a_X(su_ERR_ISDIR)},
   {409311535u, 238u, 709u, a_X(su_ERR_LOOP)},
   {3633286620u, 243u, 743u, a_X(su_ERR_MFILE)},
   {2195249641u, 249u, 763u, a_X(su_ERR_MLINK)},
   {4096082673u, 255u, 778u, a_X(su_ERR_MSGSIZE)},
   {3526377641u, 263u, 795u, a_X(su_ERR_MULTIHOP)},
   {663564256u, 272u, 814u, a_X(su_ERR_NAMETOOLONG)},
   {2628143458u, 284u, 833u, a_X(su_ERR_NETDOWN)},
   {2913781409u, 292u, 849u, a_X(su_ERR_NETRESET)},
   {3902971798u, 301u, 885u, a_X(su_ERR_NETUNREACH)},
   {459859315u, 312u, 908u, a_X(su_ERR_NFILE)},
   {3446690680u, 318u, 938u, a_X(su_ERR_NOBUFS)},
   {4178159620u, 325u, 964u, a_X(su_ERR_NODATA)},
   {4238350791u, 332u, 982u, a_X(su_ERR_NODEV)},
   {1268523872u, 338u, 1016u, a_X(su_ERR_NOENT)},
   {2076180286u, 344u, 1049u, a_X(su_ERR_NOEXEC)},
   {1161014149u, 351u, 1067u, a_X(su_ERR_NOLCK)},
   {1880207780u, 357u, 1086u, a_X(su_ERR_NOLINK)},
   {2297471775u, 364u, 1108u, a_X(su_ERR_NOMEM)},
   {288687459u, 370u, 1131u, a_X(su_ERR_NOMSG)},
   {3588403549u, 376u, 1158u, a_X(su_ERR_NOPROTOOPT)},
   {2608265568u, 387u, 1181u, a_X(su_ERR_NOSPC)},
   {1014226748u, 393u, 1205u, a_X(su_ERR_NOSR)},
   {2306425920u, 398u, 1229u, a_X(su_ERR_NOSTR)},
   {2157612882u, 404u, 1249u, a_X(su_ERR_NOSYS)},
   {1106981846u, 410u, 1274u, a_X(su_ERR_NOTCONN)},
   {3361152810u, 418u, 1298u, a_X(su_ERR_NOTDIR)},
   {1159928508u, 425u, 1314u, a_X(su_ERR_NOTEMPTY)},
   {1391828806u, 434u, 1334u, a_X(su_ERR_NOTOBACCO)},
   {3263554828u, 444u, 1371u, a_X(su_ERR_NOTSOCK)},
   {151164965u, 452u, 1402u, a_X(su_ERR_NOTSUP)},
   {3870455042u, 459u, 1426u, a_X(su_ERR_NOTTY)},
   {273388482u, 465u, 1457u, a_X(su_ERR_NXIO)},
   {727228813u, 470u, 1479u, a_X(su_ERR_OPNOTSUPP)},
   {2142687439u, 480u, 1503u, a_X(su_ERR_OVERFLOW)},
   {1727042864u, 489u, 1545u, a_X(su_ERR_PERM)},
   {1752074821u, 494u, 1569u, a_X(su_ERR_PIPE)},
   {385670576u, 499u, 1581u, a_X(su_ERR_PROTO)},
   {3066850062u, 505u, 1596u, a_X(su_ERR_PROTONOSUPPORT)},
   {1908988597u, 520u, 1619u, a_X(su_ERR_PROTOTYPE)},
   {833145061u, 530u, 1650u, a_X(su_ERR_RANGE)},
   {2868169750u, 536u, 1667u, a_X(su_ERR_ROFS)},
   {2514504004u, 541u, 1688u, a_X(su_ERR_SPIPE)},
   {1572477186u, 547u, 1701u, a_X(su_ERR_SRCH)},
   {1954937632u, 552u, 1717u, a_X(su_ERR_STALE)},
   {3112234335u, 558u, 1739u, a_X(su_ERR_TIME)},
   {1794618926u, 563u, 1753u, a_X(su_ERR_TIMEDOUT)},
   {1586215649u, 572u, 1773u, a_X(su_ERR_TXTBSY)},
   {1014021045u, 579u, 1788u, a_X(su_ERR_WOULDBLOCK)},
   {1748691063u, 590u, 1810u, a_X(su_ERR_XDEV)},
};
# undef a_X
#endif /* su_SOURCE */

#ifdef su_SOURCE /* Lock-out compile-time-tools */
# define a_CORERR_REV_ILL 81u
# define a_CORERR_REV_PRIME 149u
# define a_CORERR_REV_LONGEST 4u
# define a_CORERR_REV_WRAPAROUND 0
static u8 const a_corerr_revmap[a_CORERR_REV_PRIME] = {
   81u, 70u, 6u, 81u, 63u, 36u, 45u, 52u, 81u, 81u,
   34u, 81u, 81u, 58u, 81u, 81u, 29u, 4u, 81u, 41u,
   1u, 68u, 81u, 81u, 48u, 74u, 81u, 81u, 81u, 81u,
   81u, 81u, 42u, 19u, 81u, 20u, 81u, 81u, 81u, 12u,
   47u, 81u, 32u, 64u, 51u, 81u, 81u, 81u, 44u, 27u,
   62u, 69u, 77u, 81u, 56u, 55u, 79u, 37u, 81u, 81u,
   81u, 72u, 5u, 67u, 81u, 81u, 81u, 81u, 81u, 13u,
   81u, 81u, 81u, 81u, 23u, 24u, 14u, 81u, 81u, 81u,
   60u, 81u, 57u, 81u, 81u, 81u, 81u, 18u, 54u, 40u,
   71u, 65u, 78u, 81u, 80u, 22u, 9u, 81u, 49u, 81u,
   81u, 81u, 81u, 11u, 38u, 66u, 3u, 81u, 50u, 43u,
   15u, 2u, 35u, 76u, 25u, 30u, 31u, 8u, 75u, 73u,
   81u, 81u, 81u, 10u, 81u, 81u, 81u, 81u, 16u, 28u,
   81u, 7u, 17u, 46u, 81u, 81u, 26u, 81u, 39u, 53u,
   59u, 81u, 81u, 33u, 21u, 0u, 61u, 81u, 81u
};
#endif /* su_SOURCE */
