/* virtualmail-pop3d - a POP3 server with virtual domains support
   Copyright (C) 1999, 2000, 2001 Jeremy C. Reed
   This code is licensed under the GPL; it has several authors.
   vm-pop3d is based on:
   GNU POP3 - a small, fast, and efficient POP3 daemon

 * Code for capa support by Sean 'Shaleh' Perry <shaleh@debian.org>
 * added 4/2/1999
 *
 */
#include "vm-pop3d.h"

int pop3_capa(const char *arg)
{
    if (strlen(arg) != 0)
	return ERR_BAD_ARGS;

    if (state != AUTHORIZATION && state != TRANSACTION)
	return ERR_WRONG_STATE;

    pop3_fmt_write(ofile, "+OK Capability list follows\r\n");
    pop3_fmt_write(ofile, "TOP\r\n");
    pop3_fmt_write(ofile, "USER\r\n");
    pop3_fmt_write(ofile, "RESP-CODES\r\n");
    pop3_fmt_write(ofile, "UIDL\r\n");
    pop3_fmt_write(ofile, "PIPELINING\r\n");
    if (state == TRANSACTION)	/* let's not advertise to just anyone */
	pop3_fmt_write(ofile, "IMPLEMENTATION %s %s\r\n", IMPL, VERSION);
    pop3_cache_write(ofile, DOT_MSG, DOT_MSG_LEN);
    return OK;
}
