/* virtualmail-pop3d - a POP3 server with virtual domains support
   This code is licensed under the GPL; it has several authors.
   vm-pop3d is based on:
   GNU POP3 - a small, fast, and efficient POP3 daemon
   Copyright (C) 1999 Jakob 'sparky' Kaivo <jkaivo@nodomainname.net>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "vm-pop3d.h"

/* Enters the UPDATE phase and deletes marked messages */

#ifdef USE_VIRTUAL
int pop3_quit(const char *arg, const char *domainname)
#else
int pop3_quit(const char *arg)
#endif
{
    int size = 0, wr = 0, len, msg = 0;
    int new_line = 1, empty_line = 1;
    char buf[FREAD_SIZE], *p;
    fpos_t *readpos = NULL, *writepos = NULL;

    if (strlen(arg) != 0)
	return ERR_BAD_ARGS;

    if (state == TRANSACTION) {
	if ((cursor > 0) && (num_messages > 0)) {
	    readpos = malloc(sizeof(fpos_t));
	    writepos = malloc(sizeof(fpos_t));
	    if (readpos == NULL || writepos == NULL)
		pop3_abquit(ERR_NO_MEM);
	    if (fseek(mbox, 0L, SEEK_SET))
		return ERR_FILE;
	    fgetpos(mbox, writepos);

	    debug_msg(3, LOG_INFO, "Total messages = %u, Messages to delete = %u",
		   num_messages, cursor);

	    if (num_messages == cursor) {
		ftruncate(fileno(mbox), 0);	/* quickly delete everything */
		debug_msg(3, LOG_INFO, "Deleted all messages");
	    } else {
		while (fgets(buf, FREAD_SIZE, mbox)) {
		    if (empty_line && !strncmp(buf, "From ", 5)) {
			if (pop3_mesg_exist(msg) == OK)
			    wr = 1;
			else
			    wr = 0;
			msg++;
		    }
		    if (wr) {
			fgetpos(mbox, readpos);
			fsetpos(mbox, writepos);
			if ((p = memchr(buf, '\n', FREAD_SIZE)) != NULL) {
			    len = (p - buf) + 1;  /* Count \n too */
			} else {
			    len = FREAD_SIZE - 1; 
			}
			fwrite(buf, 1, len, mbox);
			fgetpos(mbox, writepos);
			fsetpos(mbox, readpos);
			size += len;
		    }
		    /* "From " only separates messages if followed by blank line */
		    if (new_line && (buf[0] == '\n' || buf[0] == '\0'))
			empty_line = 1;
		    else
			empty_line = 0;
		    if (memchr(buf, '\n', FREAD_SIZE))
			new_line = 1;
		    else
			new_line = 0;
		}
		ftruncate(fileno(mbox), size);
	    }
	    free(readpos);
	    free(writepos);
	}
	pop3_unlock();
	if (mbox){	/* Only if correctly opened. -TEMHOTA */
	    fclose(mbox);
	    mbox = NULL;
	}
	if (messages){
	    free(messages);
	    messages = NULL;
	}
#ifdef USE_VIRTUAL
	if (domainname)
	    syslog(LOG_INFO,
		"Session ended for user: '%s@%s' from %s, nmsgs=%u, ndel=%u",
		username, domainname, peername, num_messages, cursor);
	else
#endif
	    syslog(LOG_INFO,
		"Session ended for user: '%s' from %s, nmsgs=%u, ndel=%u",
		username, peername, num_messages, cursor);
    } else
	syslog(LOG_INFO, "Session ended for no user from %s", peername);

    state = UPDATE;
    free(username);
    free(mailbox);
    free(md5shared);
    pop3_cache_write(ofile, OK_MSG, OK_MSG_LEN);
    return OK;
}
