/* virtualmail-pop3d - a POP3 server with virtual domains support
   This code is licensed under the GPL; it has several authors.
   vm-pop3d is based on:
   GNU POP3 - a small, fast, and efficient POP3 daemon
   Copyright (C) 1999 Jakob 'sparky' Kaivo <jkaivo@nodomainname.net>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "vm-pop3d.h"

/* Prints out the specified message */

int pop3_retr(const char *arg)
{
    int mesg, empty_line = 0, new_line = 1;
    int done = 0;
    int len = 0;
    char *buf, *p;

   /* DA START */
   long sent=0;
   /* DA END */

    if ((strlen(arg) == 0) || (strchr(arg, ' ') != NULL))
	return ERR_BAD_ARGS;

    if (state != TRANSACTION)
	return ERR_WRONG_STATE;

    mesg = atoi(arg) - 1;

    if (pop3_mesg_exist(mesg) != OK)
	return ERR_NO_MESG;

    fseek(mbox, messages[mesg].header, SEEK_SET);

    buf = malloc(sizeof(char) * FREAD_SIZE);
    if (buf == NULL)
	pop3_abquit(ERR_NO_MEM);

    pop3_fmt_write(ofile, "+OK %lu octets\r\n",messages[mesg].size);
    
    while (!done && fgets(buf, FREAD_SIZE, mbox)) {
	if (empty_line && !strncmp(buf, "From ", 5))
	    done = 1;
	else {
	    if (new_line) {
		if (buf[0] == '.') {	/* only matters at beginning of line */
		    /* DA START */
		    sent += pop3_cache_write(ofile, ".", 1);
		    /* DA END */
		} else if (*buf == '\n') {
		    empty_line = 1;
		} else
		    empty_line = 0;
	    }
	    if ((p = memchr(buf, '\n', FREAD_SIZE)) != NULL) {
		len = p - buf;
		if (len <= FREAD_SIZE-2){
		    *p = '\r'; *++p = '\n'; *++p = '\0'; 
		    len += 2;
		    /* DA START */
		    sent += pop3_cache_write(ofile, buf, len);
		    /* DA END */		   
		} else {
		    /* Message + terminator not fit into buffer */
		    /* DA START */
		    sent += pop3_cache_write(ofile, buf, len);
		    sent += pop3_cache_write(ofile, "\r\n", 2);
		    /* DA END */
		}
		new_line = 1;
	    } else {
		/* DA START */
		sent += pop3_cache_write(ofile, buf, FREAD_SIZE - 1);
		/* DA END */
		new_line = 0;
		empty_line = 0;
	    }
	}
    }

    free(buf);
    /* DA START */
    sent += pop3_cache_write(ofile, DOT_MSG, DOT_MSG_LEN);
    /*log the amount of data sent for the virtualdomain (vd) IF vd!=0;*/
    if (virtualdomain != NULL) /* we have a domain */
            syslog(LOG_INFO, "bytes: domain %s %ld bytes", virtualdomain, sent);
    else
             syslog(LOG_INFO, "bytes: user %s %ld bytes", username, sent);
    /* DA END */

    return OK;
}
