/* virtualmail-pop3d - a POP3 server with virtual domains support
   This code is licensed under the GPL; it has several authors.
   vm-pop3d is based on:
   GNU POP3 - a small, fast, and efficient POP3 daemon
   Copyright (C) 1999 Jakob 'sparky' Kaivo <jkaivo@nodomainname.net>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "vm-pop3d.h"

/* Prints the header of a message plus a specified number of lines */

int pop3_top(const char *arg)
{
    int i = 0, header = 1, done = 0;
    int mesg, lines, new_line = 1, empty_line = 0;
    char *mesgc, *linesc;
    char *buf;

    if (strlen(arg) == 0)
	return ERR_BAD_ARGS;

    if (state != TRANSACTION)
	return ERR_WRONG_STATE;

    mesgc = pop3_cmd(arg);
    linesc = pop3_args(arg);
    mesg = atoi(mesgc) - 1;
    lines = strlen(linesc) > 0 ? atoi(linesc) : -1;
    free(mesgc);
    free(linesc);

    if (lines < 0)
	return ERR_BAD_ARGS;

    if (pop3_mesg_exist(mesg) != OK)
	return ERR_NO_MESG;

    fseek(mbox, messages[mesg].header, SEEK_SET);

    pop3_cache_write(ofile, OK_MSG, OK_MSG_LEN);
    buf = malloc(sizeof(char) * FREAD_SIZE);
    if (buf == NULL)
	pop3_abquit(ERR_NO_MEM);

    while (!done && fgets(buf, FREAD_SIZE, mbox)) {
	if (empty_line && !strncmp(buf, "From ", 5))
	    done = 1;
	else {
	    if (new_line && buf[0] == '\n')
		empty_line = 1;
	    else
		empty_line = 0;

	    if (header || (i < lines)) {
		if (new_line && buf[0] == '.')	/* only matters at beginning of line */
		    pop3_cache_write(ofile, buf, 1);

		if ((linesc = memchr(buf, '\n', FREAD_SIZE - 1))) {
		    if (!header)
			i++;
		    else if (new_line && ((buf[0] == '\r') || (buf[0] == '\n')
			      || (buf[0] == '\0')))
			header = 0;
		    /* Reuse mesg & linesc, avoid gcc allocate 
		     * new memeory/registers
		     */
		    mesg = linesc - buf;
		    if (mesg <= FREAD_SIZE - 1) {
			*linesc = '\r';
			*++linesc = '\n';
			mesg += 2;
			pop3_cache_write(ofile, buf, mesg);
		    } else {
			/* Message + terminator not fit into buffer */
			pop3_cache_write(ofile, buf, mesg);
			pop3_cache_write(ofile, "\r\n", 2);
		    }
		    new_line = 1;
		} else {
		    pop3_cache_write(ofile, buf, FREAD_SIZE - 1);
		    new_line = 0;
		    empty_line = 0;
		}
	    } else
		done = 1;
	}
    }

    free(buf);
    pop3_cache_write(ofile, DOT_MSG, DOT_MSG_LEN);
    return OK;
}
