/* virtualmail-pop3d - a POP3 server with virtual domains support
   uidl.c
   Ideas from Pascal Bouchareine <pb@grolier.fr> and Jeffrey Stedfast.
   Since their contributions were for gnu-pop3d using ideas from
   gnu-pop3d, it is assumed (and partially due to the viral nature
   of GPL) that this code is also GPL'd. */

#include "vm-pop3d.h"

int pop3_uidl(const char *arg)
{
    int mesg;
    char uidlbuf[33];

    if (state != TRANSACTION)
	return ERR_WRONG_STATE;

    if (strchr(arg, ' ') != NULL)	/* more than one arg */
	return ERR_BAD_ARGS;

    if (strlen(arg) == 0) {	/* list all unique-ids */
	pop3_fmt_write(ofile, "+OK unique-id listing follows\r\n");
	for (mesg = 0; mesg < num_messages; mesg++)
	    if (pop3_mesg_exist(mesg) == OK) {
		PRINT_HEX(uidlbuf, messages[mesg].uidl, 16);
		pop3_fmt_write(ofile, "%u %s\r\n", mesg + 1, uidlbuf);
	    }

	pop3_cache_write(ofile, DOT_MSG, DOT_MSG_LEN); /* Flush cache */

    } else {			/* respond with only one unique id for specific message */

	mesg = atoi(arg) - 1;

	if (pop3_mesg_exist(mesg) != OK)
	    return ERR_NO_MESG;

	PRINT_HEX(uidlbuf, messages[mesg].uidl, 16);
	pop3_fmt_write(ofile, "+OK %u %s\r\n", mesg + 1, uidlbuf);
    }

    return OK;
}
