-- Copyright (C) 2000-2006 MySQL AB
-- 
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
-- 
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

-- DO NOT EDIT THIS FILE. It is generated automatically.

-- To use this file, load its contents into the mysql database. For example,
-- with the mysql client program, process the file like this, where
-- file_name is the name of this file:

--     mysql -u root -p mysql < file_name

delete from help_topic;
delete from help_category;
delete from help_keyword;
delete from help_relation;

insert into help_category (help_category_id,name,parent_category_id,url) values (1,"Geographic",0,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (2,"Polygon properties",29,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (3,"WKT",29,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (4,"Numeric Functions",33,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (5,"MBR",29,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (6,"Control flow functions",33,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (7,"Transactions",30,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (8,"Account Management",30,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (9,"Point properties",29,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (10,"Encryption Functions",33,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (11,"LineString properties",29,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (12,"Logical operators",33,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (13,"Miscellaneous Functions",33,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (14,"Functions and Modifiers for Use with GROUP BY",30,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (15,"Information Functions",33,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (16,"Storage Engines",30,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (17,"Comparison operators",33,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (18,"Bit Functions",33,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (19,"Table Maintenance",30,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (20,"Data Types",30,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (21,"Geometry constructors",29,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (22,"GeometryCollection properties",1,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (23,"Administration",30,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (24,"Data Manipulation",30,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (25,"Geometry relations",29,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (26,"Language Structure",30,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (27,"Date and Time Functions",33,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (28,"WKB",29,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (29,"Geographic Features",30,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (30,"Contents",0,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (31,"Geometry properties",29,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (32,"String Functions",33,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (33,"Functions",30,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (34,"Data Definition",30,'');

insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (0,24,"JOIN","MySQL supports the following JOIN syntaxes for the table_references\npart of SELECT statements and multiple-table DELETE and UPDATE\nstatements:\n\ntable_reference, table_reference\ntable_reference [INNER | CROSS] JOIN table_reference [join_condition]\ntable_reference STRAIGHT_JOIN table_reference\ntable_reference LEFT [OUTER] JOIN table_reference join_condition\ntable_reference NATURAL [LEFT [OUTER]] JOIN table_reference\n{ ON table_reference LEFT OUTER JOIN table_reference\n    ON conditional_expr }\ntable_reference RIGHT [OUTER] JOIN table_reference join_condition\ntable_reference NATURAL [RIGHT [OUTER]] JOIN table_reference\n\ntable_reference is defined as:\n\ntbl_name [[AS] alias]\n    [{USE|IGNORE|FORCE} INDEX (key_list)]\n\njoin_condition is defined as:\n\nON conditional_expr | USING (column_list)\n","SELECT table1.* FROM table1\n  LEFT JOIN table2 ON table1.id=table2.id\n  WHERE table2.id IS NULL;\n","join");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (1,32,"HEX","Syntax:\nHEX(N_or_S)\n\nIf N_or_S is a number, returns a string representation of the\nhexadecimal value of N, where N is a longlong (BIGINT) number. This is\nequivalent to CONV(N,10,16).\n\nFrom MySQL 4.0.1 and up, if N_or_S is a string, returns a hexadecimal\nstring representation of N_or_S where each character in N_or_S is\nconverted to two hexadecimal digits.\n","mysql> SELECT HEX(255);\n        -> 'FF'\nmysql> SELECT 0x616263;\n        -> 'abc'\nmysql> SELECT HEX('abc');\n        -> 616263\n","string-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (2,32,"REPLACE","Syntax:\nREPLACE(str,from_str,to_str)\n\nReturns the string str with all occurrences of the string from_str\nreplaced by the string to_str. REPLACE() performs a case-sensitive\nmatch when searching for from_str.\n","mysql> SELECT REPLACE('www.mysql.com', 'w', 'Ww');\n        -> 'WwWwWw.mysql.com'\n","string-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (3,25,"CONTAINS","Contains(g1,g2)\n\nReturns 1 or 0 to indicate whether g1 completely contains g2.\n","","functions-that-test-spatial-relationships-between-geometries");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (4,31,"SRID","SRID(g)\n\nReturns an integer indicating the Spatial Reference System ID for the\ngeometry value g.\n\nIn MySQL, the SRID value is just an integer associated with the\ngeometry value. All calculations are done assuming Euclidean (planar)\ngeometry.\n","mysql> SELECT SRID(GeomFromText('LineString(1 1,2 2)',101));\n+-----------------------------------------------+\n| SRID(GeomFromText('LineString(1 1,2 2)',101)) |\n+-----------------------------------------------+\n|                                           101 |\n+-----------------------------------------------+\n","general-geometry-property-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (5,27,"CURRENT_TIMESTAMP","Syntax:\nCURRENT_TIMESTAMP, CURRENT_TIMESTAMP()\n\nCURRENT_TIMESTAMP and CURRENT_TIMESTAMP() are synonyms for NOW().\n","","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (6,14,"VARIANCE","Syntax:\nVARIANCE(expr)\n\nReturns the population standard variance of expr. This is an extension\nto standard SQL, available in MySQL 4.1 or later.\n\nVARIANCE() returns NULL if there were no matching rows.\n","","group-by-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (7,32,"CONCAT","Syntax:\nCONCAT(str1,str2,...)\n\nReturns the string that results from concatenating the arguments. May\nhave one or more arguments. If all arguments are non-binary strings,\nthe result is a non-binary string. If the arguments include any binary\nstrings, the result is a binary string. A numeric argument is converted\nto its equivalent binary string form; if you want to avoid that, you\ncan use an explicit type cast, as in this example:\n\nSELECT CONCAT(CAST(int_col AS CHAR), char_col);\n\nCONCAT() returns NULL if any argument is NULL.\n","mysql> SELECT CONCAT('My', 'S', 'QL');\n        -> 'MySQL'\nmysql> SELECT CONCAT('My', NULL, 'QL');\n        -> NULL\nmysql> SELECT CONCAT(14.3);\n        -> '14.3'\n","string-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (8,29,"GEOMETRY HIERARCHY","Geometry is the base class. It is an abstract class. The instantiable\nsubclasses of Geometry are restricted to zero-, one-, and\ntwo-dimensional geometric objects that exist in two-dimensional\ncoordinate space. All instantiable geometry classes are defined so that\nvalid instances of a geometry class are topologically closed (that is,\nall defined geometries include their boundary).\n\nThe base Geometry class has subclasses for Point, Curve, Surface, and\nGeometryCollection:\n\no Point represents zero-dimensional objects.\n\no Curve represents one-dimensional objects, and has subclass\n  LineString, with sub-subclasses Line and LinearRing.\n\no Surface is designed for two-dimensional objects and has subclass\n  Polygon.\n\no GeometryCollection has specialized zero-, one-, and two-dimensional\n  collection classes named MultiPoint, MultiLineString, and\n  MultiPolygon for modeling geometries corresponding to collections of\n  Points, LineStrings, and Polygons, respectively. MultiCurve and\n  MultiSurface are introduced as abstract superclasses that generalize\n  the collection interfaces to handle Curves and Surfaces.\n\nGeometry, Curve, Surface, MultiCurve, and MultiSurface are defined as\nnon-instantiable classes. They define a common set of methods for their\nsubclasses and are included for extensibility.\n\nPoint, LineString, Polygon, GeometryCollection, MultiPoint,\nMultiLineString, and MultiPolygon are instantiable classes.\n","","gis-geometry-class-hierarchy");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (9,32,"CHAR FUNCTION","Syntax:\nCHAR(N,... [USING charset_name])\n\nCHAR() interprets each argument N as an integer and returns a string\nconsisting of the characters given by the code values of those\nintegers. NULL values are skipped.\nCHAR() returns a string in the connection character set. As of MySQL\n4.1.16, the optional USING clause may be used to produce a string in a\ngiven character set:\n\nmysql> SELECT CHARSET(CHAR(0x65)), CHARSET(CHAR(0x65 USING utf8));\n+---------------------+--------------------------------+\n| CHARSET(CHAR(0x65)) | CHARSET(CHAR(0x65 USING utf8)) |\n+---------------------+--------------------------------+\n| latin1              | utf8                           |\n+---------------------+--------------------------------+\n","mysql> SELECT CHAR(77,121,83,81,'76');\n        -> 'MySQL'\nmysql> SELECT CHAR(77,77.3,'77.3');\n        -> 'MMM'\n","string-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (10,20,"DATETIME","DATETIME\n\nA date and time combination. The supported range is '1000-01-01\n00:00:00' to '9999-12-31 23:59:59'. MySQL displays DATETIME values in\n'YYYY-MM-DD HH:MM:SS' format, but allows you to assign values to\nDATETIME columns using either strings or numbers.\n","","date-and-time-type-overview");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (11,20,"INTEGER","INTEGER[(M)] [UNSIGNED] [ZEROFILL]\n\nThis type is a synonym for INT.\n","","numeric-type-overview");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (12,32,"LOWER","Syntax:\nLOWER(str)\n\nReturns the string str with all characters changed to lowercase\naccording to the current character set mapping. The default is latin1\n(cp1252 West European).\n","mysql> SELECT LOWER('QUADRATICALLY');\n        -> 'quadratically'\n","string-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (13,24,"SHOW COLUMNS","Syntax:\nSHOW [FULL] COLUMNS FROM tbl_name [FROM db_name] [LIKE 'pattern']\n\nSHOW COLUMNS displays information about the columns in a given table.\n\nIf the data types differ from what you expect them to be based on your\nCREATE TABLE statement, note that MySQL sometimes changes data types\nwhen you create or alter a table. The conditions for which this occurs\nare described in [silent-column-changes].\n\nThe FULL keyword can be used from MySQL 3.23.32 on. It causes the\noutput to include the privileges you have for each column. As of MySQL\n4.1, FULL also causes any per-column comments to be displayed.\n\nYou can use db_name.tbl_name as an alternative to the tbl_name FROM\ndb_name syntax. In other words, these two statements are equivalent:\n\nmysql> SHOW COLUMNS FROM mytable FROM mydb;\nmysql> SHOW COLUMNS FROM mydb.mytable;\n\nSHOW FIELDS is a synonym for SHOW COLUMNS. You can also list a table's\ncolumns with the mysqlshow db_name tbl_name command.\n\nThe DESCRIBE statement provides information similar to SHOW COLUMNS.\nSee [describe].\n","","show-columns");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (14,27,"MONTH","Syntax:\nMONTH(date)\n\nReturns the month for date, in the range 0 to 12.\n","mysql> SELECT MONTH('1998-02-03');\n        -> 2\n","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (15,20,"TINYINT","TINYINT[(M)] [UNSIGNED] [ZEROFILL]\n\nA very small integer. The signed range is -128 to 127. The unsigned\nrange is 0 to 255.\n","","numeric-type-overview");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (16,13,"MASTER_POS_WAIT","Syntax:\nMASTER_POS_WAIT(log_name,log_pos[,timeout])\n\nThis function is useful for control of master/slave synchronization. It\nblocks until the slave has read and applied all updates up to the\nspecified position in the master log. The return value is the number of\nlog events the slave had to wait for to advance to the specified\nposition. The function returns NULL if the slave SQL thread is not\nstarted, the slave's master information is not initialized, the\narguments are incorrect, or an error occurs. It returns -1 if the\ntimeout has been exceeded. If the slave SQL thread stops while\nMASTER_POS_WAIT() is waiting, the function returns NULL. If the slave\nis past the specified position, the function returns immediately.\n","","miscellaneous-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (17,32,"REGEXP","Syntax:\nexpr REGEXP pat expr RLIKE pat\n\nPerforms a pattern match of a string expression expr against a pattern\npat. The pattern can be an extended regular expression. The syntax for\nregular expressions is discussed in [regexp]. Returns 1 if expr matches\npat; otherwise it returns 0. If either expr or pat is NULL, the result\nis NULL. RLIKE is a synonym for REGEXP, provided for mSQL\ncompatibility.\n\nThe pattern need not be a literal string. For example, it can be\nspecified as a string expression or table column.\n\nNote: Because MySQL uses the C escape syntax in strings (for example,\n`\\n' to represent the newline character), you must double any `\\' that\nyou use in your REGEXP strings.\n\nAs of MySQL 3.23.4, REGEXP is not case sensitive, except when used with\nbinary strings.\n","mysql> SELECT 'Monty!' REGEXP 'm%y%%';\n        -> 0\nmysql> SELECT 'Monty!' REGEXP '.*';\n        -> 1\nmysql> SELECT 'new*\\n*line' REGEXP 'new\\\\*.\\\\*line';\n        -> 1\nmysql> SELECT 'a' REGEXP 'A', 'a' REGEXP BINARY 'A';\n        -> 1  0\nmysql> SELECT 'a' REGEXP '^[a-d]';\n        -> 1\n","string-comparison-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (18,18,"^","Syntax:\n^\n\nBitwise XOR:\n","mysql> SELECT 1 ^ 1;\n        -> 0\nmysql> SELECT 1 ^ 0;\n        -> 1\nmysql> SELECT 11 ^ 3;\n        -> 8\n","bit-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (19,27,"DATE OPERATIONS","Syntax:\nDATE_ADD(date,INTERVAL expr type), DATE_SUB(date,INTERVAL expr type)\n\nThese functions perform date arithmetic. date is a DATETIME or DATE\nvalue specifying the starting date. expr is an expression specifying\nthe interval value to be added or subtracted from the starting date.\nexpr is a string; it may start with a `-' for negative intervals. type\nis a keyword indicating how the expression should be interpreted.\n","mysql> SELECT '1997-12-31 23:59:59' + INTERVAL 1 SECOND;\n        -> '1998-01-01 00:00:00'\nmysql> SELECT INTERVAL 1 DAY + '1997-12-31';\n        -> '1998-01-01'\nmysql> SELECT '1998-01-01' - INTERVAL 1 SECOND;\n        -> '1997-12-31 23:59:59'\nmysql> SELECT DATE_ADD('1997-12-31 23:59:59',\n    ->                 INTERVAL 1 SECOND);\n        -> '1998-01-01 00:00:00'\nmysql> SELECT DATE_ADD('1997-12-31 23:59:59',\n    ->                 INTERVAL 1 DAY);\n        -> '1998-01-01 23:59:59'\nmysql> SELECT DATE_ADD('1997-12-31 23:59:59',\n    ->                 INTERVAL '1:1' MINUTE_SECOND);\n        -> '1998-01-01 00:01:00'\nmysql> SELECT DATE_SUB('1998-01-01 00:00:00',\n    ->                 INTERVAL '1 1:1:1' DAY_SECOND);\n        -> '1997-12-30 22:58:59'\nmysql> SELECT DATE_ADD('1998-01-01 00:00:00',\n    ->                 INTERVAL '-1 10' DAY_HOUR);\n        -> '1997-12-30 14:00:00'\nmysql> SELECT DATE_SUB('1998-01-02', INTERVAL 31 DAY);\n        -> '1997-12-02'\nmysql> SELECT DATE_ADD('1992-12-31 23:59:59.000002',\n    ->            INTERVAL '1.999999' SECOND_MICROSECOND);\n        -> '1993-01-01 00:00:01.000001'\n","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (20,25,"WITHIN","Within(g1,g2)\n\nReturns 1 or 0 to indicate whether g1 is spatially within g2.\n","","functions-that-test-spatial-relationships-between-geometries");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (21,27,"WEEK","Syntax:\nWEEK(date[,mode])\n\nThis function returns the week number for date. The two-argument form\nof WEEK() allows you to specify whether the week starts on Sunday or\nMonday and whether the return value should be in the range from 0 to 53\nor from 1 to 53. If the mode argument is omitted, the value of the\ndefault_week_format system variable is used (or 0 before MySQL 4.0.14).\nSee [server-system-variables].\n","mysql> SELECT WEEK('1998-02-20');\n        -> 7\nmysql> SELECT WEEK('1998-02-20',0);\n        -> 7\nmysql> SELECT WEEK('1998-02-20',1);\n        -> 8\nmysql> SELECT WEEK('1998-12-31',1);\n        -> 53\n","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (22,24,"PREPARE","Syntax:\nPREPARE stmt_name FROM preparable_stmt\n\nThe PREPARE statement prepares a statement and assigns it a name,\nstmt_name, by which to refer to the statement later. Statement names\nare not case sensitive. preparable_stmt is either a string literal or a\nuser variable that contains the text of the statement. The text must\nrepresent a single SQL statement, not multiple statements. Within the\nstatement, `?' characters can be used as parameter markers to indicate\nwhere data values are to be bound to the query later when you execute\nit. The `?' characters should not be enclosed within quotes, even if\nyou intend to bind them to string values. Parameter markers can be used\nonly where data values should appear, not for SQL keywords,\nidentifiers, and so forth.\n\nIf a prepared statement with the given name already exists, it is\ndeallocated implicitly before the new statement is prepared. This means\nthat if the new statement contains an error and cannot be prepared, an\nerror is returned and no statement with the given name exists.\n\nThe scope of a prepared statement is the client session within which it\nis created. Other clients cannot see it.\n","","sqlps");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (23,7,"LOCK","Syntax:\nLOCK TABLES\n    tbl_name [AS alias] {READ [LOCAL] | [LOW_PRIORITY] WRITE}\n    [, tbl_name [AS alias] {READ [LOCAL] | [LOW_PRIORITY] WRITE}] ...\nUNLOCK TABLES\n\nLOCK TABLES locks tables for the current thread. If any of the tables\nare locked by other threads, it blocks until all locks can be acquired.\nUNLOCK TABLES releases any locks held by the current thread. All tables\nthat are locked by the current thread are implicitly unlocked when the\nthread issues another LOCK TABLES, or when the connection to the server\nis closed.\n\nA table lock protects only against inappropriate reads or writes by\nother clients. The client holding the lock, even a read lock, can\nperform table-level operations such as DROP TABLE.\n","","lock-tables");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (24,24,"RESET SLAVE","Syntax:\nRESET SLAVE\n\nRESET SLAVE makes the slave forget its replication position in the\nmaster's binary logs. This statement is meant to be used for a clean\nstart: It deletes the master.info and relay-log.info files, all the\nrelay logs, and starts a new relay log.\n\nNote: All relay logs are deleted, even if they have not been completely\nexecuted by the slave SQL thread. (This is a condition likely to exist\non a replication slave if you have issued a STOP SLAVE statement or if\nthe slave is highly loaded.)\n\nConnection information stored in the master.info file is immediately\nreset using any values specified in the corresponding startup options.\nThis information includes values such as master host, master port,\nmaster user, and master password. If the slave SQL thread was in the\nmiddle of replicating temporary tables when it was stopped, and RESET\nSLAVE is issued, these replicated temporary tables are deleted on the\nslave.\n\nThis statement was named FLUSH SLAVE before MySQL 3.23.26.\n","","reset-slave");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (25,21,"POLYGON","Polygon(ls1,ls2,...)\n\nConstructs a WKB Polygon value from a number of WKB LineString\narguments. If any argument does not represent the WKB of a LinearRing\n(that is, not a closed and simple LineString) the return value is NULL.\n","","gis-mysql-specific-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (26,27,"MINUTE","Syntax:\nMINUTE(time)\n\nReturns the minute for time, in the range 0 to 59.\n","mysql> SELECT MINUTE('98-02-03 10:05:03');\n        -> 5\n","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (27,27,"DAY","Syntax:\nDAY(date)\n\nDAY() is a synonym for DAYOFMONTH(). It is available as of MySQL 4.1.1.\n","","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (28,32,"MID","Syntax:\nMID(str,pos,len)\n\nMID(str,pos,len) is a synonym for SUBSTRING(str,pos,len).\n","","string-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (29,24,"REPLACE INTO","Syntax:\nREPLACE [LOW_PRIORITY | DELAYED]\n    [INTO] tbl_name [(col_name,...)]\n    VALUES ({expr | DEFAULT},...),(...),...\n\nOr:\n\nREPLACE [LOW_PRIORITY | DELAYED]\n    [INTO] tbl_name\n    SET col_name={expr | DEFAULT}, ...\n\nOr:\n\nREPLACE [LOW_PRIORITY | DELAYED]\n    [INTO] tbl_name [(col_name,...)]\n    SELECT ...\n\nREPLACE works exactly like INSERT, except that if an old row in the\ntable has the same value as a new row for a PRIMARY KEY or a UNIQUE\nindex, the old row is deleted before the new row is inserted. See\n[insert].\n\nREPLACE is a MySQL extension to the SQL standard. It either inserts, or\ndeletes and inserts. If you're looking for a statement that follows the\nSQL standard, and that either inserts or updates, see\n[insert-on-duplicate]. INSERT ... ON DUPLICATE KEY UPDATE is available\nas of MySQL 4.1.0.\n\nNote that unless the table has a PRIMARY KEY or UNIQUE index, using a\nREPLACE statement makes no sense. It becomes equivalent to INSERT,\nbecause there is no index to be used to determine whether a new row\nduplicates another.\n\nValues for all columns are taken from the values specified in the\nREPLACE statement. Any missing columns are set to their default values,\njust as happens for INSERT. You cannot refer to values from the current\nrow and use them in the new row. If you use an assignment such as SET\ncol_name = col_name + 1, the reference to the column name on the right\nhand side is treated as DEFAULT(col_name), so the assignment is\nequivalent to SET col_name = DEFAULT(col_name) + 1.\n\nTo use REPLACE, you must have both the INSERT and DELETE privileges for\nthe table.\n","","replace");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (30,13,"UUID","Syntax:\nUUID()\n\nReturns a Universal Unique Identifier (UUID) generated according to\n\"DCE 1.1: Remote Procedure Call\" (Appendix A) CAE (Common Applications\nEnvironment) Specifications published by The Open Group in October 1997\n(Document Number C706,\nhttp://www.opengroup.org/public/pubs/catalog/c706.htm).\n\nA UUID is designed as a number that is globally unique in space and\ntime. Two calls to UUID() are expected to generate two different\nvalues, even if these calls are performed on two separate computers\nthat are not connected to each other.\n\nA UUID is a 128-bit number represented by a string of five hexadecimal\nnumbers in aaaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee format:\n\no The first three numbers are generated from a timestamp.\n\no The fourth number preserves temporal uniqueness in case the timestamp\n  value loses monotonicity (for example, due to daylight saving time).\n\no The fifth number is an IEEE 802 node number that provides spatial\n  uniqueness. A random number is substituted if the latter is not\n  available (for example, because the host computer has no Ethernet\n  card, or we do not know how to find the hardware address of an\n  interface on your operating system). In this case, spatial uniqueness\n  cannot be guaranteed. Nevertheless, a collision should have very low\n  probability.\n\n  Currently, the MAC address of an interface is taken into account only\n  on FreeBSD and Linux. On other operating systems, MySQL uses a\n  randomly generated 48-bit number.\n","mysql> SELECT UUID();\n        -> '6ccd780c-baba-1026-9564-0040f4311e29'\n","miscellaneous-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (31,21,"LINESTRING","LineString(pt1,pt2,...)\n\nConstructs a WKB LineString value from a number of WKB Point arguments.\nIf any argument is not a WKB Point, the return value is NULL. If the\nnumber of Point arguments is less than two, the return value is NULL.\n","","gis-mysql-specific-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (32,15,"CONNECTION_ID","Syntax:\nCONNECTION_ID()\n\nReturns the connection ID (thread ID) for the connection. Every\nconnection has an ID that is unique among the set of currently\nconnected clients.\n","mysql> SELECT CONNECTION_ID();\n        -> 23786\n","information-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (33,24,"DELETE","Syntax:\nSingle-table syntax:\n\nDELETE [LOW_PRIORITY] [QUICK] [IGNORE] FROM tbl_name\n    [WHERE where_condition]\n    [ORDER BY ...]\n    [LIMIT row_count]\n\nMultiple-table syntax:\n\nDELETE [LOW_PRIORITY] [QUICK] [IGNORE]\n    tbl_name[.*] [, tbl_name[.*]] ...\n    FROM table_references\n    [WHERE where_condition]\n\nOr:\n\nDELETE [LOW_PRIORITY] [QUICK] [IGNORE]\n    FROM tbl_name[.*] [, tbl_name[.*]] ...\n    USING table_references\n    [WHERE where_condition]\n\nFor the single-table syntax, the DELETE statement deletes rows from\ntbl_name and returns the number of rows deleted. The WHERE clause, if\ngiven, specifies the conditions that identify which rows to delete.\nWith no WHERE clause, all rows are deleted. If the ORDER BY clause is\nspecified, the rows are deleted in the order that is specified. The\nLIMIT clause places a limit on the number of rows that can be deleted.\n\nFor the multiple-table syntax, DELETE deletes from each tbl_name the\nrows that satisfy the conditions. In this case, ORDER BY and LIMIT\ncannot be used.\n\nwhere_condition is an expression that evaluates to true for each row to\nbe deleted. It is specified as described in [select].\n\nAs stated, a DELETE statement with no WHERE clause deletes all rows. A\nfaster way to do this, when you do not want to know the number of\ndeleted rows, is to use TRUNCATE TABLE. See [truncate].\n","","delete");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (34,4,"ROUND","Syntax:\nROUND(X), ROUND(X,D)\n\nReturns the argument X, rounded to the nearest integer. With two\narguments, returns X rounded to D decimal places. D can be negative to\ncause D digits left of the decimal point of the value X to become zero.\n","mysql> SELECT ROUND(-1.23);\n        -> -1\nmysql> SELECT ROUND(-1.58);\n        -> -2\nmysql> SELECT ROUND(1.58);\n        -> 2\nmysql> SELECT ROUND(1.298, 1);\n        -> 1.3\nmysql> SELECT ROUND(1.298, 0);\n        -> 1\nmysql> SELECT ROUND(23.298, -1);\n        -> 20\n","mathematical-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (35,6,"NULLIF","Syntax:\nNULLIF(expr1,expr2)\n\nReturns NULL if expr1 = expr2 is true, otherwise returns expr1. This is\nthe same as CASE WHEN expr1 = expr2 THEN NULL ELSE expr1 END.\n","mysql> SELECT NULLIF(1,1);\n        -> NULL\nmysql> SELECT NULLIF(1,2);\n        -> 1\n","control-flow-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (36,24,"STOP SLAVE","Syntax:\nSTOP SLAVE [thread_type [, thread_type] ... ]\n\nthread_type: IO_THREAD | SQL_THREAD\n\nStops the slave threads. STOP SLAVE requires the SUPER privilege.\n\nLike START SLAVE, as of MySQL 4.0.2, this statement may be used with\nthe IO_THREAD and SQL_THREAD options to name the thread or threads to\nbe stopped.\n","","stop-slave");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (37,27,"TIMEDIFF","Syntax:\nTIMEDIFF(expr,expr2)\n\nTIMEDIFF() returns the time between the start time expr and the end\ntime expr2. expr and expr2 are time or date-and-time expressions, but\nboth must be of the same type.\n","mysql> SELECT TIMEDIFF('2000:01:01 00:00:00',\n    ->                 '2000:01:01 00:00:00.000001');\n        -> '-00:00:00.000001'\nmysql> SELECT TIMEDIFF('1997-12-31 23:59:59.000001',\n    ->                 '1997-12-30 01:01:01.000002');\n        -> '46:58:57.999999'\n","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (38,3,"LINEFROMTEXT","LineFromText(wkt[,srid]), LineStringFromText(wkt[,srid])\n\nConstructs a LINESTRING value using its WKT representation and SRID.\n","","gis-wkt-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (39,24,"SHOW MASTER STATUS","Provides status information about the binary log files of the master.\nExample:\n\nmysql > SHOW MASTER STATUS;\n+---------------+----------+--------------+------------------+\n| File          | Position | Binlog_Do_DB | Binlog_Ignore_DB |\n+---------------+----------+--------------+------------------+\n| mysql-bin.003 | 73       | test         | manual,mysql     |\n+---------------+----------+--------------+------------------+\n","","show-master-status");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (40,27,"ADDTIME","Syntax:\nADDTIME(expr,expr2)\n\nADDTIME() adds expr2 to expr and returns the result. expr is a time or\ndatetime expression, and expr2 is a time expression.\n","mysql> SELECT ADDTIME('1997-12-31 23:59:59.999999',\n    ->                '1 1:1:1.000002');\n        -> '1998-01-02 01:01:01.000001'\nmysql> SELECT ADDTIME('01:00:00.999999', '02:00:00.999998');\n        -> '03:00:01.999997'\n","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (41,29,"SPATIAL","MySQL can create spatial indexes using syntax similar to that for\ncreating regular indexes, but extended with the SPATIAL keyword.\nCurrently, spatial columns that are indexed must be declared NOT NULL.\nThe following examples demonstrate how to create spatial indexes:\n\no With CREATE TABLE:\n\nCREATE TABLE geom (g GEOMETRY NOT NULL, SPATIAL INDEX(g));\n\no With ALTER TABLE:\n\nALTER TABLE geom ADD SPATIAL INDEX(g);\n\no With CREATE INDEX:\n\nCREATE SPATIAL INDEX sp_index ON geom (g);\n\nTo drop spatial indexes, use ALTER TABLE or DROP INDEX:\n\no With ALTER TABLE:\n\nALTER TABLE geom DROP INDEX g;\n\no With DROP INDEX:\n\nDROP INDEX sp_index ON geom;\n\nExample: Suppose that a table geom contains more than 32,000\ngeometries, which are stored in the column g of type GEOMETRY. The\ntable also has an AUTO_INCREMENT column fid for storing object ID\nvalues.\n","","creating-spatial-indexes");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (42,32,"UPPER","Syntax:\nUPPER(str)\n\nReturns the string str with all characters changed to uppercase\naccording to the current character set mapping. The default is latin1\n(cp1252 West European).\n","mysql> SELECT UPPER('Hej');\n        -> 'HEJ'\n","string-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (43,27,"FROM_UNIXTIME","Syntax:\nFROM_UNIXTIME(unix_timestamp), FROM_UNIXTIME(unix_timestamp,format)\n\nReturns a representation of the unix_timestamp argument as a value in\n'YYYY-MM-DD HH:MM:SS' or YYYYMMDDHHMMSS format, depending on whether\nthe function is used in a string or numeric context. unix_timestamp is\nan internal timestamp value such as is produced by the UNIX_TIMESTAMP()\nfunction.\n\nIf format is given, the result is formatted according to the format\nstring, which is used the same way as listed in the entry for the\nDATE_FORMAT() function.\n","mysql> SELECT FROM_UNIXTIME(875996580);\n        -> '1997-10-04 22:23:00'\nmysql> SELECT FROM_UNIXTIME(875996580) + 0;\n        -> 19971004222300\nmysql> SELECT FROM_UNIXTIME(UNIX_TIMESTAMP(),\n    ->                      '%Y %D %M %h:%i:%s %x');\n        -> '2003 6th August 06:22:58 2003'\n","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (44,20,"MEDIUMBLOB","MEDIUMBLOB\n\nA BLOB column with a maximum length of 16,777,215 (224 - 1) bytes.\n","","string-type-overview");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (45,6,"IFNULL","Syntax:\nIFNULL(expr1,expr2)\n\nIf expr1 is not NULL, IFNULL() returns expr1; otherwise it returns\nexpr2. IFNULL() returns a numeric or string value, depending on the\ncontext in which it is used.\n","mysql> SELECT IFNULL(1,0);\n        -> 1\nmysql> SELECT IFNULL(NULL,10);\n        -> 10\nmysql> SELECT IFNULL(1/0,10);\n        -> 10\nmysql> SELECT IFNULL(1/0,'yes');\n        -> 'yes'\n","control-flow-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (46,24,"SHOW ERRORS","Syntax:\nSHOW ERRORS [LIMIT [offset,] row_count]\nSHOW COUNT(*) ERRORS\n\nThis statement is similar to SHOW WARNINGS, except that instead of\ndisplaying errors, warnings, and notes, it displays only errors. SHOW\nERRORS is available as of MySQL 4.1.0.\n\nThe LIMIT clause has the same syntax as for the SELECT statement. See\n[select].\n\nThe SHOW COUNT(*) ERRORS statement displays the number of errors. You\ncan also retrieve this number from the error_count variable:\n\nSHOW COUNT(*) ERRORS;\nSELECT @@error_count;\n","","show-errors");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (47,17,"LEAST","Syntax:\nLEAST(value1,value2,...)\n\nWith two or more arguments, returns the smallest (minimum-valued)\nargument. The arguments are compared using the following rules:\n\no If the return value is used in an INTEGER context or all arguments\n  are integer-valued, they are compared as integers.\n\no If the return value is used in a REAL context or all arguments are\n  real-valued, they are compared as reals.\n\no If any argument is a case-sensitive string, the arguments are\n  compared as case-sensitive strings.\n\no In all other cases, the arguments are compared as case-insensitive\n  strings.\n","mysql> SELECT LEAST(2,0);\n        -> 0\nmysql> SELECT LEAST(34.0,3.0,5.0,767.0);\n        -> 3.0\nmysql> SELECT LEAST('B','A','C');\n        -> 'A'\n","comparison-operators");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (48,17,"=","=\n\nEqual:\n","mysql> SELECT 1 = 0;\n        -> 0\nmysql> SELECT '0' = 0;\n        -> 1\nmysql> SELECT '0.0' = 0;\n        -> 1\nmysql> SELECT '0.01' = 0;\n        -> 0\nmysql> SELECT '.01' = 0.01;\n        -> 1\n","comparison-operators");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (49,32,"REVERSE","Syntax:\nREVERSE(str)\n\nReturns the string str with the order of the characters reversed.\n","mysql> SELECT REVERSE('abc');\n        -> 'cba'\n","string-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (50,17,"ISNULL","Syntax:\nISNULL(expr)\n\nIf expr is NULL, ISNULL() returns 1, otherwise it returns 0.\n","mysql> SELECT ISNULL(1+1);\n        -> 0\nmysql> SELECT ISNULL(1/0);\n        -> 1\n","comparison-operators");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (51,20,"BINARY","BINARY(M)\n\nThe BINARY type is similar to the CHAR type, but stores binary byte\nstrings rather than non-binary character strings.\n\nThis type was added in MySQL 4.1.2.\n","","string-type-overview");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (52,20,"BLOB DATA TYPE","A BLOB is a binary large object that can hold a variable amount of\ndata. The four BLOB types are TINYBLOB, BLOB, MEDIUMBLOB, and LONGBLOB.\nThese differ only in the maximum length of the values they can hold.\nThe four TEXT types are TINYTEXT, TEXT, MEDIUMTEXT, and LONGTEXT. These\ncorrespond to the four BLOB types and have the same maximum lengths and\nstorage requirements. See [storage-requirements]. No lettercase\nconversion for TEXT or BLOB columns takes place during storage or\nretrieval.\n","","blob");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (53,31,"BOUNDARY","Boundary(g)\n\nReturns a geometry that is the closure of the combinatorial boundary of\nthe geometry value g.\n","","general-geometry-property-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (54,21,"POINT","Point(x,y)\n\nConstructs a WKB Point using its coordinates.\n","","gis-mysql-specific-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (55,15,"CURRENT_USER","Syntax:\nCURRENT_USER, CURRENT_USER()\n\nReturns the username and hostname combination for the MySQL account\nthat the server used to authenticate the current client. This account\ndetermines your access privileges.\n\nThe value of CURRENT_USER() can differ from the value of USER().\n","mysql> SELECT USER();\n        -> 'davida@localhost'\nmysql> SELECT * FROM mysql.user;\nERROR 1044: Access denied for user ''@'localhost' to\ndatabase 'mysql'\nmysql> SELECT CURRENT_USER();\n        -> '@localhost'\n","information-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (56,32,"LCASE","Syntax:\nLCASE(str)\n\nLCASE() is a synonym for LOWER().\n","","string-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (57,17,"<=","Syntax:\n<=\n\nLess than or equal:\n","mysql> SELECT 0.1 <= 2;\n        -> 1\n","comparison-operators");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (58,24,"UPDATE","Syntax:\nSingle-table syntax:\n\nUPDATE [LOW_PRIORITY] [IGNORE] tbl_name\n    SET col_name1=expr1 [, col_name2=expr2 ...]\n    [WHERE where_condition]\n    [ORDER BY ...]\n    [LIMIT row_count]\n\nMultiple-table syntax:\n\nUPDATE [LOW_PRIORITY] [IGNORE] table_references\n    SET col_name1=expr1 [, col_name2=expr2 ...]\n    [WHERE where_condition]\n\nFor the single-table syntax, the UPDATE statement updates columns of\nexisting rows in tbl_name with new values. The SET clause indicates\nwhich columns to modify and the values they should be given. The WHERE\nclause, if given, specifies the conditions that identify which rows to\nupdate. With no WHERE clause, all rows are updated. If the ORDER BY\nclause is specified, the rows are updated in the order that is\nspecified. The LIMIT clause places a limit on the number of rows that\ncan be updated.\n\nFor the multiple-table syntax, UPDATE updates rows in each table named\nin table_references that satisfy the conditions. In this case, ORDER BY\nand LIMIT cannot be used.\n\nwhere_condition is an expression that evaluates to true for each row to\nbe updated. It is specified as described in [select].\n\nThe UPDATE statement supports the following modifiers:\n\no If you use the LOW_PRIORITY keyword, execution of the UPDATE is\n  delayed until no other clients are reading from the table.\n\no If you use the IGNORE keyword, the update statement does not abort\n  even if errors occur during the update. Rows for which duplicate-key\n  conflicts occur are not updated. Rows for which columns are updated\n  to values that would cause data conversion errors are updated to the\n  closet valid values instead.\n","","update");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (59,24,"EXECUTE STATEMENT","Syntax:\nEXECUTE stmt_name [USING @var_name [, @var_name] ...]\n\nAfter preparing a statement, you execute it with an EXECUTE statement\nthat refers to the prepared statement name. If the prepared statement\ncontains any parameter markers, you must supply a USING clause that\nlists user variables containing the values to be bound to the\nparameters. Parameter values can be supplied only by user variables,\nand the USING clause must name exactly as many variables as the number\nof parameter markers in the statement.\n\nYou can execute a given prepared statement multiple times, passing\ndifferent variables to it or setting the variables to different values\nbefore each execution.\n","","sqlps");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (60,34,"DROP INDEX","Syntax:\nDROP INDEX index_name ON tbl_name\n\nDROP INDEX drops the index named index_name from the table tbl_name. In\nMySQL 3.22 or later, DROP INDEX is mapped to an ALTER TABLE statement\nto drop the index. See [alter-table]. DROP INDEX does not do anything\nprior to MySQL 3.22.\n","","drop-index");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (61,32,"MATCH AGAINST","Syntax:\nMATCH (col1,col2,...) AGAINST (expr [search_modifier])\n\nsearch_modifier: { IN BOOLEAN MODE | WITH QUERY EXPANSION }\n\nAs of MySQL 3.23.23, MySQL has support for full-text indexing and\nsearching:\n\no A full-text index in MySQL is an index of type FULLTEXT.\n\no Full-text indexes can be used only with MyISAM tables, and can be\n  created only for CHAR, VARCHAR, or TEXT columns.\n\no A FULLTEXT index definition can be given in the CREATE TABLE\n  statement when a table is created, or added later using ALTER TABLE\n  or CREATE INDEX.\n\no For large datasets, it is much faster to load your data into a table\n  that has no FULLTEXT index and then create the index after that, than\n  to load data into a table that has an existing FULLTEXT index.\n\nFull-text searching is performed using MATCH() ... AGAINST syntax.\nMATCH() takes a comma-separated list that names the columns to be\nsearched. AGAINST takes a string to search for, and an optional\nmodifier that indicates what type of search to perform. The search\nstring must be a literal string, not a variable or a column name. There\nare three types of full-text searches:\n\no A boolean search interprets the search string using the rules of a\n  special query language. The string contains the words to search for.\n  It can also contain operators that specify requirements such that a\n  word must be present or absent in matching rows, or that it should be\n  weighted higher or lower than usual. Common words such as \"some\" or\n  \"then\" are stopwords and do not match if present in the search\n  string. The IN BOOLEAN MODE modifier specifies a boolean search. For\n  more information, see [fulltext-boolean].\n\no A natural language search interprets the search string as a phrase in\n  natural human language (a phrase in free text). There are no special\n  operators. The stopword list applies. In addition, words that are\n  present in more than 50% of the rows are considered common and do not\n  match. Full-text searches are natural language searches if no\n  modifier is given.\n\no A query expansion search is a modification of a natural language\n  search. The search string is used to perform a natural language\n  search. Then words from the most relevant rows returned by the search\n  are added to the search string and the search is done again. The\n  query returns the rows from the second search. The WITH QUERY\n  EXPANSION modifier specifies a query expansion search. For more\n  information, see [fulltext-query-expansion].\n","mysql> SELECT id, body, MATCH (title,body) AGAINST\n    -> ('Security implications of running MySQL as root') AS score\n    -> FROM articles WHERE MATCH (title,body) AGAINST\n    -> ('Security implications of running MySQL as root');\n+----+-------------------------------------+-----------------+\n| id | body                                | score           |\n+----+-------------------------------------+-----------------+\n|  4 | 1. Never run mysqld as root. 2. ... | 1.5219271183014 |\n|  6 | When configured properly, MySQL ... | 1.3114095926285 |\n+----+-------------------------------------+-----------------+\n2 rows in set (0.00 sec)\n","fulltext-search");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (62,4,"ABS","Syntax:\nABS(X)\n\nReturns the absolute value of X.\n","mysql> SELECT ABS(2);\n        -> 2\nmysql> SELECT ABS(-32);\n        -> 32\n","mathematical-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (63,28,"POLYFROMWKB","PolyFromWKB(wkb[,srid]), PolygonFromWKB(wkb[,srid])\n\nConstructs a POLYGON value using its WKB representation and SRID.\n","","gis-wkb-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (64,32,"NOT LIKE","Syntax:\nexpr NOT LIKE pat [ESCAPE 'escape_char']\n\nThis is the same as NOT (expr LIKE pat [ESCAPE 'escape_char']).\n","","string-comparison-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (65,32,"SPACE","Syntax:\nSPACE(N)\n\nReturns a string consisting of N space characters.\n","mysql> SELECT SPACE(6);\n        -> '      '\n","string-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (66,5,"MBR DEFINITION","Its MBR (Minimum Bounding Rectangle), or Envelope. This is the bounding\ngeometry, formed by the minimum and maximum (X,Y) coordinates:\n","((MINX MINY, MAXX MINY, MAXX MAXY, MINX MAXY, MINX MINY))\n","gis-class-geometry");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (67,21,"GEOMETRYCOLLECTION","GeometryCollection(g1,g2,...)\n\nConstructs a WKB GeometryCollection. If any argument is not a\nwell-formed WKB representation of a geometry, the return value is NULL.\n","","gis-mysql-specific-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (68,4,"*","Syntax:\n*\n\nMultiplication:\n","mysql> SELECT 3*5;\n        -> 15\nmysql> SELECT 18014398509481984*18014398509481984.0;\n        -> 324518553658426726783156020576256.0\nmysql> SELECT 18014398509481984*18014398509481984;\n        -> 0\n","arithmetic-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (69,20,"TIMESTAMP","TIMESTAMP[(M)]\n\nA timestamp. The range is '1970-01-01 00:00:00' to partway through the\nyear 2037.\n\nA TIMESTAMP column is useful for recording the date and time of an\nINSERT or UPDATE operation. By default, the first TIMESTAMP column in a\ntable is automatically set to the date and time of the most recent\noperation if you do not assign it a value yourself. You can also set\nany TIMESTAMP column to the current date and time by assigning it a\nNULL value. Variations on automatic initialization and update\nproperties are described in [timestamp-4-1].\n\nIn MySQL 4.1, TIMESTAMP is returned as a string with the format\n'YYYY-MM-DD HH:MM:SS'. Display widths (used as described in the\nfollowing paragraphs) are no longer supported; the display width is\nfixed at 19 characters. To obtain the value as a number, you should add\n+0 to the timestamp column.\n\nIn MySQL 4.0 and earlier, TIMESTAMP values are displayed in\nYYYYMMDDHHMMSS, YYMMDDHHMMSS, YYYYMMDD, or YYMMDD format, depending on\nwhether M is 14 (or missing), 12, 8, or 6, but allows you to assign\nvalues to TIMESTAMP columns using either strings or numbers. The M\nargument affects only how a TIMESTAMP column is displayed, not storage.\nIts values always are stored using four bytes each. From MySQL 4.0.12,\nthe --new option can be used to make the server behave as in MySQL 4.1.\n\nNote that TIMESTAMP(M) columns where M is 8 or 14 are reported to be\nnumbers, whereas other TIMESTAMP(M) columns are reported to be strings.\nThis is just to ensure that you can reliably dump and restore the table\nwith these types.\n\nNote: The behavior of TIMESTAMP columns changed considerably in MySQL\n4.1. For complete information on the differences with regard to this\ndata type in MySQL 4.1 and later versions (as opposed to MySQL 4.0 and\nearlier versions), be sure to see [timestamp-pre-4-1], and\n[timestamp-4-1].\n","","date-and-time-type-overview");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (70,10,"DES_DECRYPT","Syntax:\nDES_DECRYPT(crypt_str[,key_str])\n\nDecrypts a string encrypted with DES_ENCRYPT(). If an error occurs,\nthis function returns NULL.\n\nNote that this function works only if MySQL has been configured with\nSSL support. See [secure-connections].\n\nIf no key_str argument is given, DES_DECRYPT() examines the first byte\nof the encrypted string to determine the DES key number that was used\nto encrypt the original string, and then reads the key from the DES key\nfile to decrypt the message. For this to work, the user must have the\nSUPER privilege. The key file can be specified with the --des-key-file\nserver option.\n\nIf you pass this function a key_str argument, that string is used as\nthe key for decrypting the message.\n\nIf the crypt_str argument does not appear to be an encrypted string,\nMySQL returns the given crypt_str.\n","","encryption-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (71,11,"ENDPOINT","EndPoint(ls)\n\nReturns the Point that is the endpoint of the LineString value ls.\n","mysql> SET @ls = 'LineString(1 1,2 2,3 3)';\nmysql> SELECT AsText(EndPoint(GeomFromText(@ls)));\n+-------------------------------------+\n| AsText(EndPoint(GeomFromText(@ls))) |\n+-------------------------------------+\n| POINT(3 3)                          |\n+-------------------------------------+\n","linestring-property-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (72,24,"CACHE INDEX","Syntax:\nCACHE INDEX\n  tbl_index_list [, tbl_index_list] ...\n  IN key_cache_name\n\ntbl_index_list:\n  tbl_name [[INDEX|KEY] (index_name[, index_name] ...)]\n\nThe CACHE INDEX statement assigns table indexes to a specific key\ncache. It is used only for MyISAM tables.\n\nThe following statement assigns indexes from the tables t1, t2, and t3\nto the key cache named hot_cache:\n\nmysql> CACHE INDEX t1, t2, t3 IN hot_cache;\n+---------+--------------------+----------+----------+\n| Table   | Op                 | Msg_type | Msg_text |\n+---------+--------------------+----------+----------+\n| test.t1 | assign_to_keycache | status   | OK       |\n| test.t2 | assign_to_keycache | status   | OK       |\n| test.t3 | assign_to_keycache | status   | OK       |\n+---------+--------------------+----------+----------+\n","","cache-index");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (73,10,"COMPRESS","Syntax:\nCOMPRESS(string_to_compress)\n\nCompresses a string and returns the result as a binary string. This\nfunction requires MySQL to have been compiled with a compression\nlibrary such as zlib. Otherwise, the return value is always NULL. The\ncompressed string can be uncompressed with UNCOMPRESS().\n","mysql> SELECT LENGTH(COMPRESS(REPEAT('a',1000)));\n        -> 21\nmysql> SELECT LENGTH(COMPRESS(''));\n        -> 0\nmysql> SELECT LENGTH(COMPRESS('a'));\n        -> 13\nmysql> SELECT LENGTH(COMPRESS(REPEAT('a',16)));\n        -> 15\n","encryption-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (74,24,"INSERT","Syntax:\nINSERT [LOW_PRIORITY | DELAYED | HIGH_PRIORITY] [IGNORE]\n    [INTO] tbl_name [(col_name,...)]\n    VALUES ({expr | DEFAULT},...),(...),...\n    [ ON DUPLICATE KEY UPDATE col_name=expr, ... ]\n\nOr:\n\nINSERT [LOW_PRIORITY | DELAYED | HIGH_PRIORITY] [IGNORE]\n    [INTO] tbl_name\n    SET col_name={expr | DEFAULT}, ...\n    [ ON DUPLICATE KEY UPDATE col_name=expr, ... ]\n\nOr:\n\nINSERT [LOW_PRIORITY | HIGH_PRIORITY] [IGNORE]\n    [INTO] tbl_name [(col_name,...)]\n    SELECT ...\n    [ ON DUPLICATE KEY UPDATE col_name=expr, ... ]\n\nINSERT inserts new rows into an existing table. The INSERT ... VALUES\nand INSERT ... SET forms of the statement insert rows based on\nexplicitly specified values. The INSERT ... SELECT form inserts rows\nselected from another table or tables. The INSERT ... VALUES form with\nmultiple value lists is supported in MySQL 3.22.5 or later. The INSERT\n... SET syntax is supported in MySQL 3.22.10 or later. INSERT ...\nSELECT is discussed further in [insert-select].\n","","insert");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (75,14,"COUNT","Syntax:\nCOUNT(expr)\n\nReturns a count of the number of non-NULL values in the rows retrieved\nby a SELECT statement. The result is a BIGINT value.\n\nCOUNT() returns 0 if there were no matching rows.\n","mysql> SELECT student.student_name,COUNT(*)\n    ->        FROM student,course\n    ->        WHERE student.student_id=course.student_id\n    ->        GROUP BY student_name;\n","group-by-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (76,24,"HANDLER","Syntax:\nHANDLER tbl_name OPEN [ AS alias ]\nHANDLER tbl_name READ index_name { = | >= | <= | < } (value1,value2,...)\n    [ WHERE where_condition ] [LIMIT ... ]\nHANDLER tbl_name READ index_name { FIRST | NEXT | PREV | LAST }\n    [ WHERE where_condition ] [LIMIT ... ]\nHANDLER tbl_name READ { FIRST | NEXT }\n    [ WHERE where_condition ] [LIMIT ... ]\nHANDLER tbl_name CLOSE\n\nThe HANDLER statement provides direct access to table storage engine\ninterfaces. It is available for MyISAM tables as MySQL 4.0.0 and InnoDB\ntables as of MySQL 4.0.3.\n","","handler");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (77,3,"MLINEFROMTEXT","MLineFromText(wkt[,srid]), MultiLineStringFromText(wkt[,srid])\n\nConstructs a MULTILINESTRING value using its WKT representation and\nSRID.\n","","gis-wkt-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (78,28,"GEOMCOLLFROMWKB","GeomCollFromWKB(wkb[,srid]), GeometryCollectionFromWKB(wkb[,srid])\n\nConstructs a GEOMETRYCOLLECTION value using its WKB representation and\nSRID.\n","","gis-wkb-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (79,34,"RENAME TABLE","Syntax:\nRENAME TABLE tbl_name TO new_tbl_name\n    [, tbl_name2 TO new_tbl_name2] ...\n\nThis statement renames one or more tables. It was added in MySQL\n3.23.23.\n\nThe rename operation is done atomically, which means that no other\nthread can access any of the tables while the rename is running. For\nexample, if you have an existing table old_table, you can create\nanother table new_table that has the same structure but is empty, and\nthen replace the existing table with the empty one as follows (assuming\nthat backup_table does not already exist):\n","CREATE TABLE new_table (...);\nRENAME TABLE old_table TO backup_table, new_table TO old_table;\n","rename-table");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (80,20,"BOOLEAN","BOOL, BOOLEAN\n\nThese types are synonyms for TINYINT(1). The BOOLEAN synonym was added\nin MySQL 4.1.0. A value of zero is considered false. Non-zero values\nare considered true.\n","","numeric-type-overview");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (81,13,"DEFAULT","Syntax:\nDEFAULT(col_name)\n\nReturns the default value for a table column.\n","mysql> UPDATE t SET i = DEFAULT(i)+1 WHERE id < 100;\n","miscellaneous-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (82,20,"TINYTEXT","TINYTEXT\n\nA TEXT column with a maximum length of 255 (28 - 1) characters.\n","","string-type-overview");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (83,19,"OPTIMIZE TABLE","Syntax:\nOPTIMIZE [LOCAL | NO_WRITE_TO_BINLOG] TABLE tbl_name [, tbl_name] ...\n\nOPTIMIZE TABLE should be used if you have deleted a large part of a\ntable or if you have made many changes to a table with variable-length\nrows (tables that have VARCHAR, VARBINARY, BLOB, or TEXT columns).\nDeleted rows are maintained in a linked list and subsequent INSERT\noperations reuse old row positions. You can use OPTIMIZE TABLE to\nreclaim the unused space and to defragment the data file.\n\nThis statement requires SELECT and INSERT privileges for the table.\n","","optimize-table");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (84,10,"DECODE","Syntax:\nDECODE(crypt_str,pass_str)\n\nDecrypts the encrypted string crypt_str using pass_str as the password.\ncrypt_str should be a string returned from ENCODE().\n","","encryption-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (85,17,"<=>","Syntax:\n<=>\n\nNULL-safe equal. This operator performs an equality comparison like the\n= operator, but returns 1 rather than NULL if both operands are NULL,\nand 0 rather than NULL if one operand is NULL.\n","mysql> SELECT 1 <=> 1, NULL <=> NULL, 1 <=> NULL;\n        -> 1, 1, 0\nmysql> SELECT 1 = 1, NULL = NULL, 1 = NULL;\n        -> 1, NULL, NULL\n","comparison-operators");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (86,24,"LOAD DATA FROM MASTER","Syntax:\nLOAD DATA FROM MASTER\n\nThis statement takes a snapshot of the master and copies it to the\nslave. It updates the values of MASTER_LOG_FILE and MASTER_LOG_POS so\nthat the slave starts replicating from the correct position. Any table\nand database exclusion rules specified with the --replicate-*-do-* and\n--replicate-*-ignore-* options are honored. --replicate-rewrite-db is\nnot taken into account because a user could use this option to set up a\nnon-unique mapping such as --replicate-rewrite-db=\"db1->db3\" and\n--replicate-rewrite-db=\"db2->db3\", which would confuse the slave when\nloading tables from the master.\n\nUse of this statement is subject to the following conditions:\n\no It works only for MyISAM tables. Attempting to load a non-MyISAM\n  table results in the following error:\n\nERROR 1189 (08S01): Net error reading from master\n\no It acquires a global read lock on the master while taking the\n  snapshot, which prevents updates on the master during the load\n  operation.\n\nIf you are loading large tables, you might have to increase the values\nof net_read_timeout and net_write_timeout on both the master and slave\nservers. See [server-system-variables].\n\nNote that LOAD DATA FROM MASTER does not copy any tables from the mysql\ndatabase. This makes it easy to have different users and privileges on\nthe master and the slave.\n\nTo use LOAD DATA FROM MASTER, the replication account that is used to\nconnect to the master must have the RELOAD and SUPER privileges on the\nmaster and the SELECT privilege for all master tables you want to load.\nAll master tables for which the user does not have the SELECT privilege\nare ignored by LOAD DATA FROM MASTER. This is because the master hides\nthem from the user: LOAD DATA FROM MASTER calls SHOW DATABASES to know\nthe master databases to load, but SHOW DATABASES returns only databases\nfor which the user has some privilege. See [show-databases]. On the\nslave side, the user that issues LOAD DATA FROM MASTER must have\nprivileges for dropping and creating the databases and tables that are\ncopied.\n","","load-data-from-master");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (87,24,"RESET","Syntax:\nRESET reset_option [, reset_option] ...\n\nThe RESET statement is used to clear the state of various server\noperations. You must have the RELOAD privilege to execute RESET.\n\nRESET acts as a stronger version of the FLUSH statement. See [flush].\n","","reset");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (88,13,"GET_LOCK","Syntax:\nGET_LOCK(str,timeout)\n\nTries to obtain a lock with a name given by the string str, using a\ntimeout of timeout seconds. Returns 1 if the lock was obtained\nsuccessfully, 0 if the attempt timed out (for example, because another\nclient has previously locked the name), or NULL if an error occurred\n(such as running out of memory or the thread was killed with mysqladmin\nkill). If you have a lock obtained with GET_LOCK(), it is released when\nyou execute RELEASE_LOCK(), execute a new GET_LOCK(), or your\nconnection terminates (either normally or abnormally). Locks obtained\nwith GET_LOCK() do not interact with transactions. That is, committing\na transaction does not release any such locks obtained during the\ntransaction.\n\nThis function can be used to implement application locks or to simulate\nrecord locks. Names are locked on a server-wide basis. If a name has\nbeen locked by one client, GET_LOCK() blocks any request by another\nclient for a lock with the same name. This allows clients that agree on\na given lock name to use the name to perform cooperative advisory\nlocking. But be aware that it also allows a client that is not among\nthe set of cooperating clients to lock a name, either inadvertently or\ndeliberately, and thus prevent any of the cooperating clients from\nlocking that name. One way to reduce the likelihood of this is to use\nlock names that are database-specific or application-specific. For\nexample, use lock names of the form db_name.str or app_name.str.\n","mysql> SELECT GET_LOCK('lock1',10);\n        -> 1\nmysql> SELECT IS_FREE_LOCK('lock2');\n        -> 1\nmysql> SELECT GET_LOCK('lock2',10);\n        -> 1\nmysql> SELECT RELEASE_LOCK('lock2');\n        -> 1\nmysql> SELECT RELEASE_LOCK('lock1');\n        -> NULL\n","miscellaneous-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (89,32,"UCASE","Syntax:\nUCASE(str)\n\nUCASE() is a synonym for UPPER().\n","","string-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (90,24,"SHOW BINLOG EVENTS","Syntax:\nSHOW BINLOG EVENTS\n   [IN 'log_name'] [FROM pos] [LIMIT [offset,] row_count]\n\nShows the events in the binary log. If you do not specify 'log_name',\nthe first binary log is displayed.\n","","show-binlog-events");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (91,28,"MPOLYFROMWKB","MPolyFromWKB(wkb[,srid]), MultiPolygonFromWKB(wkb[,srid])\n\nConstructs a MULTIPOLYGON value using its WKB representation and SRID.\n","","gis-wkb-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (92,24,"DO","Syntax:\nDO expr [, expr] ...\n\nDO executes the expressions but does not return any results. In most\nrespects, DO is shorthand for SELECT expr, ..., but has the advantage\nthat it is slightly faster when you do not care about the result.\n\nDO is useful primarily with functions that have side effects, such as\nRELEASE_LOCK().\n","","do");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (93,27,"CURTIME","Syntax:\nCURTIME()\n\nReturns the current time as a value in 'HH:MM:SS' or HHMMSS format,\ndepending on whether the function is used in a string or numeric\ncontext.\n","mysql> SELECT CURTIME();\n        -> '23:50:26'\nmysql> SELECT CURTIME() + 0;\n        -> 235026\n","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (94,32,"CHAR_LENGTH","Syntax:\nCHAR_LENGTH(str)\n\nReturns the length of the string str, measured in characters. A\nmulti-byte character counts as a single character. This means that for\na string containing five two-byte characters, LENGTH() returns 10,\nwhereas CHAR_LENGTH() returns 5.\n","","string-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (95,20,"BIGINT","BIGINT[(M)] [UNSIGNED] [ZEROFILL]\n\nA large integer. The signed range is -9223372036854775808 to\n9223372036854775807. The unsigned range is 0 to 18446744073709551615.\n","","numeric-type-overview");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (96,24,"SET","Syntax:\nSET variable_assignment [, variable_assignment] ...\n\nvariable_assignment:\n      user_var_name = expr\n    | [GLOBAL | SESSION] system_var_name = expr\n    | [@@global. | @@session. | @@]system_var_name = expr\n\nThe SET statement assigns values to different types of variables that\naffect the operation of the server or your client. Older versions of\nMySQL employed SET OPTION, but this syntax is deprecated in favor of\nSET without OPTION.\n","","set-option");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (97,20,"DATE","DATE\n\nA date. The supported range is '1000-01-01' to '9999-12-31'. MySQL\ndisplays DATE values in 'YYYY-MM-DD' format, but allows you to assign\nvalues to DATE columns using either strings or numbers.\n","","date-and-time-type-overview");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (98,32,"CONV","Syntax:\nCONV(N,from_base,to_base)\n\nConverts numbers between different number bases. Returns a string\nrepresentation of the number N, converted from base from_base to base\nto_base. Returns NULL if any argument is NULL. The argument N is\ninterpreted as an integer, but may be specified as an integer or a\nstring. The minimum base is 2 and the maximum base is 36. If to_base is\na negative number, N is regarded as a signed number. Otherwise, N is\ntreated as unsigned. CONV() works with 64-bit precision.\n","mysql> SELECT CONV('a',16,2);\n        -> '1010'\nmysql> SELECT CONV('6E',18,8);\n        -> '172'\nmysql> SELECT CONV(-17,10,-18);\n        -> '-H'\nmysql> SELECT CONV(10+'10'+'10'+0xa,10,10);\n        -> '40'\n","string-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (99,24,"SHOW OPEN TABLES","Syntax:\nSHOW OPEN TABLES\n\nSHOW OPEN TABLES lists the non-TEMPORARY tables that are currently open\nin the table cache. See [table-cache].\n","","show-open-tables");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (100,27,"EXTRACT","Syntax:\nEXTRACT(type FROM date)\n\nThe EXTRACT() function uses the same kinds of interval type specifiers\nas DATE_ADD() or DATE_SUB(), but extracts parts from the date rather\nthan performing date arithmetic.\n","mysql> SELECT EXTRACT(YEAR FROM '1999-07-02');\n       -> 1999\nmysql> SELECT EXTRACT(YEAR_MONTH FROM '1999-07-02 01:02:03');\n       -> 199907\nmysql> SELECT EXTRACT(DAY_MINUTE FROM '1999-07-02 01:02:03');\n       -> 20102\nmysql> SELECT EXTRACT(MICROSECOND\n    ->                FROM '2003-01-02 10:30:00.00123');\n        -> 123\n","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (101,10,"ENCRYPT","Syntax:\nENCRYPT(str[,salt])\n\nEncrypts str using the Unix crypt() system call and returns a binary\nstring. The salt argument should be a string with two characters. (As\nof MySQL 3.22.16, salt may be longer than two characters.) If no salt\nargument is given, a random value is used.\n","mysql> SELECT ENCRYPT('hello');\n        -> 'VxuFAJXVARROc'\n","encryption-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (102,24,"SHOW STATUS","Syntax:\nSHOW STATUS [LIKE 'pattern']\n\nSHOW STATUS provides server status information. This information also\ncan be obtained using the mysqladmin extended-status command.\nWith a LIKE clause, the statement displays only rows for those\nvariables with names that match the pattern:\n\nmysql> SHOW STATUS LIKE 'Key%';\n+--------------------+----------+\n| Variable_name      | Value    |\n+--------------------+----------+\n| Key_blocks_used    | 14955    |\n| Key_read_requests  | 96854827 |\n| Key_reads          | 162040   |\n| Key_write_requests | 7589728  |\n| Key_writes         | 3813196  |\n+--------------------+----------+\n","","show-status");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (103,10,"OLD_PASSWORD","Syntax:\nOLD_PASSWORD(str)\n\nOLD_PASSWORD() is available as of MySQL 4.1, when the implementation of\nPASSWORD() was changed to improve security. OLD_PASSWORD() returns the\nvalue of the pre-4.1 implementation of PASSWORD() as a binary string,\nand is intended to permit you to reset passwords for any pre-4.1\nclients that need to connect to your version 4.1 MySQL server without\nlocking them out. See [password-hashing].\n","","encryption-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (104,32,"FORMAT","Syntax:\nFORMAT(X,D)\n\nFormats the number X to a format like '#,###,###.##', rounded to D\ndecimal places, and returns the result as a string. If D is 0, the\nresult has no decimal point or fractional part.\n","mysql> SELECT FORMAT(12332.123456, 4);\n        -> '12,332.1235'\nmysql> SELECT FORMAT(12332.1,4);\n        -> '12,332.1000'\nmysql> SELECT FORMAT(12332.2,0);\n        -> '12,332'\n","string-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (105,12,"||","Syntax:\nOR, ||\n\nLogical OR. When both operands are non-NULL, the result is 1 if any\noperand is non-zero, and 0 otherwise. With a NULL operand, the result\nis 1 if the other operand is non-zero, and NULL otherwise. If both\noperands are NULL, the result is NULL.\n","mysql> SELECT 1 || 1;\n        -> 1\nmysql> SELECT 1 || 0;\n        -> 1\nmysql> SELECT 0 || 0;\n        -> 0\nmysql> SELECT 0 || NULL;\n        -> NULL\nmysql> SELECT 1 || NULL;\n        -> 1\n","logical-operators");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (106,32,"BIT_LENGTH","Syntax:\nBIT_LENGTH(str)\n\nReturns the length of the string str in bits.\n","mysql> SELECT BIT_LENGTH('text');\n        -> 32\n","string-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (107,2,"EXTERIORRING","ExteriorRing(poly)\n\nReturns the exterior ring of the Polygon value poly as a LineString.\n","mysql> SET @poly =\n    -> 'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))';\nmysql> SELECT AsText(ExteriorRing(GeomFromText(@poly)));\n+-------------------------------------------+\n| AsText(ExteriorRing(GeomFromText(@poly))) |\n+-------------------------------------------+\n| LINESTRING(0 0,0 3,3 3,3 0,0 0)           |\n+-------------------------------------------+\n","polygon-property-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (108,28,"GEOMFROMWKB","GeomFromWKB(wkb[,srid]), GeometryFromWKB(wkb[,srid])\n\nConstructs a geometry value of any type using its WKB representation\nand SRID.\n","","gis-wkb-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (109,24,"SHOW SLAVE HOSTS","Syntax:\nSHOW SLAVE HOSTS\n\nDisplays a list of replication slaves currently registered with the\nmaster. Any slave not started with the --report-host=slave_name option\nis not visible in this list.\n","","show-slave-hosts");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (110,7,"START TRANSACTION","Syntax:\nSTART TRANSACTION | BEGIN [WORK]\nCOMMIT\nROLLBACK\nSET AUTOCOMMIT = {0 | 1}\n\nThe START TRANSACTION and BEGIN statement begin a new transaction.\nCOMMIT commits the current transaction, making its changes permanent.\nROLLBACK rolls back the current transaction, canceling its changes. The\nSET AUTOCOMMIT statement disables or enables the default autocommit\nmode for the current connection.\n\nBy default, MySQL runs with autocommit mode enabled. This means that as\nsoon as you execute a statement that updates (modifies) a table, MySQL\nstores the update on disk.\n\nIf you are using a transaction-safe storage engine (such as InnoDB,\nBDB, or NDB Cluster), you can disable autocommit mode with the\nfollowing statement:\n\nSET AUTOCOMMIT=0;\n\nAfter disabling autocommit mode by setting the AUTOCOMMIT variable to\nzero, you must use COMMIT to store your changes to disk or ROLLBACK if\nyou want to ignore the changes you have made since the beginning of\nyour transaction.\n\nTo disable autocommit mode for a single series of statements, use the\nSTART TRANSACTION statement:\n","START TRANSACTION;\nSELECT @A:=SUM(salary) FROM table1 WHERE type=1;\nUPDATE table2 SET summary=@A WHERE type=1;\nCOMMIT;\n","commit");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (111,17,"BETWEEN AND","Syntax:\nexpr BETWEEN min AND max\n\nIf expr is greater than or equal to min and expr is less than or equal\nto max, BETWEEN returns 1, otherwise it returns 0. This is equivalent\nto the expression (min <= expr AND expr <= max) if all the arguments\nare of the same type. Otherwise type conversion takes place according\nto the rules described in [type-conversion], but applied to all the\nthree arguments. Note: Before MySQL 4.0.5, arguments were converted to\nthe type of expr instead.\n","mysql> SELECT 1 BETWEEN 2 AND 3;\n        -> 0\nmysql> SELECT 'b' BETWEEN 'a' AND 'c';\n        -> 1\nmysql> SELECT 2 BETWEEN 2 AND '3';\n        -> 1\nmysql> SELECT 2 BETWEEN 2 AND 'x-3';\n        -> 0\n","comparison-operators");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (112,21,"MULTIPOLYGON","MultiPolygon(poly1,poly2,...)\n\nConstructs a WKB MultiPolygon value from a set of WKB Polygon\narguments. If any argument is not a WKB Polygon, the return value is\nNULL.\n","","gis-mysql-specific-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (113,27,"TIME_FORMAT","Syntax:\nTIME_FORMAT(time,format)\n\nThis is used like the DATE_FORMAT() function, but the format string may\ncontain format specifiers only for hours, minutes, and seconds. Other\nspecifiers produce a NULL value or 0.\n","mysql> SELECT TIME_FORMAT('100:00:00', '%H %k %h %I %l');\n        -> '100 100 04 04 4'\n","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (114,32,"LEFT","Syntax:\nLEFT(str,len)\n\nReturns the leftmost len characters from the string str.\n","mysql> SELECT LEFT('foobarbar', 5);\n        -> 'fooba'\n","string-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (115,23,"FLUSH QUERY CACHE","You can defragment the query cache to better utilize its memory with\nthe FLUSH QUERY CACHE statement. The statement does not remove any\nqueries from the cache.\n\nThe RESET QUERY CACHE statement removes all query results from the\nquery cache. The FLUSH TABLES statement also does this.\n","","query-cache-status-and-maintenance");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (116,20,"SET DATA TYPE","SET('value1','value2',...)\n\nA set. A string object that can have zero or more values, each of which\nmust be chosen from the list of values 'value1', 'value2', ... A SET\ncolumn can have a maximum of 64 members. SET values are represented\ninternally as integers.\n","","string-type-overview");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (117,4,"RAND","Syntax:\nRAND(), RAND(N)\n\nReturns a random floating-point value v between 0 and 1 inclusive (that\nis, in the range 0 <= v <= 1.0). If an integer argument N is specified,\nit is used as the seed value, which produces a repeatable sequence.\n","mysql> SELECT RAND();\n        -> 0.9233482386203\nmysql> SELECT RAND(20);\n        -> 0.15888261251047\nmysql> SELECT RAND(20);\n        -> 0.15888261251047\nmysql> SELECT RAND();\n        -> 0.63553050033332\nmysql> SELECT RAND();\n        -> 0.70100469486881\nmysql> SELECT RAND(20);\n        -> 0.15888261251047\n","mathematical-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (118,32,"RPAD","Syntax:\nRPAD(str,len,padstr)\n\nReturns the string str, right-padded with the string padstr to a length\nof len characters. If str is longer than len, the return value is\nshortened to len characters.\n","mysql> SELECT RPAD('hi',5,'?');\n        -> 'hi???'\nmysql> SELECT RPAD('hi',1,'?');\n        -> 'h'\n","string-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (119,34,"CREATE DATABASE","Syntax:\nCREATE DATABASE [IF NOT EXISTS] db_name\n    [create_specification [, create_specification] ...]\n\ncreate_specification:\n    [DEFAULT] CHARACTER SET charset_name\n  | [DEFAULT] COLLATE collation_name\n\nCREATE DATABASE creates a database with the given name. To use this\nstatement, you need the CREATE privilege for the database.\n","","create-database");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (120,20,"DEC","DEC[(M[,D])] [UNSIGNED] [ZEROFILL], NUMERIC[(M[,D])] [UNSIGNED]\n[ZEROFILL], FIXED[(M[,D])] [UNSIGNED] [ZEROFILL]\n\nThese types are synonyms for DECIMAL. The FIXED synonym was added in\nMySQL 4.1.0 for compatibility with other database systems.\n","","numeric-type-overview");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (121,32,"ELT","Syntax:\nELT(N,str1,str2,str3,...)\n\nReturns str1 if N = 1, str2 if N = 2, and so on. Returns NULL if N is\nless than 1 or greater than the number of arguments. ELT() is the\ncomplement of FIELD().\n","mysql> SELECT ELT(1, 'ej', 'Heja', 'hej', 'foo');\n        -> 'ej'\nmysql> SELECT ELT(4, 'ej', 'Heja', 'hej', 'foo');\n        -> 'foo'\n","string-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (122,24,"SHOW DATABASES","Syntax:\nSHOW DATABASES [LIKE 'pattern']\n\nSHOW DATABASES lists the databases on the MySQL server host. As of\nMySQL 4.0.2, you see only those databases for which you have some kind\nof privilege, if you do not have the global SHOW DATABASES privilege.\nYou can also get this list using the mysqlshow command.\n\nIf the server was started with the --skip-show-database option, you\ncannot use this statement at all unless you have the SHOW DATABASES\nprivilege.\n","","show-databases");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (123,18,"~","Syntax:\n~\n\nInvert all bits.\n","mysql> SELECT 5 & ~1;\n        -> 4\n","bit-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (124,20,"TEXT","TEXT[(M)]\n\nA TEXT column with a maximum length of 65,535 (216 - 1) characters.\n\nBeginning with MySQL 4.1, an optional length M can be given for this\ntype. MySQL creates the column as the smallest TEXT type large enough\nto hold values M characters long.\n","","string-type-overview");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (125,32,"CONCAT_WS","Syntax:\nCONCAT_WS(separator,str1,str2,...)\n\nCONCAT_WS() stands for Concatenate With Separator and is a special form\nof CONCAT(). The first argument is the separator for the rest of the\narguments. The separator is added between the strings to be\nconcatenated. The separator can be a string, as can the rest of the\narguments. If the separator is NULL, the result is NULL.\n","mysql> SELECT CONCAT_WS(',','First name','Second name','Last Name');\n        -> 'First name,Second name,Last Name'\nmysql> SELECT CONCAT_WS(',','First name',NULL,'Last Name');\n        -> 'First name,Last Name'\n","string-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (126,4,"ASIN","Syntax:\nASIN(X)\n\nReturns the arc sine of X, that is, the value whose sine is X. Returns\nNULL if X is not in the range -1 to 1.\n","mysql> SELECT ASIN(0.2);\n        -> 0.201358\nmysql> SELECT ASIN('foo');\n        -> 0.000000\n","mathematical-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (127,24,"SHOW LOGS","Syntax:\nSHOW [BDB] LOGS\n\nSHOW LOGS displays status information about existing BDB log files. It\nwas implemented in MySQL 3.23.29. An alias for it (available as of\nMySQL 4.1.1) is SHOW BDB LOGS. As of MySQL 4.1.2, this statement is\ndeprecated and SHOW ENGINE BDB LOGS should be used instead. See\n[show-engine].\n","","show-logs");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (128,4,"SIGN","Syntax:\nSIGN(X)\n\nReturns the sign of the argument as -1, 0, or 1, depending on whether X\nis negative, zero, or positive.\n","mysql> SELECT SIGN(-32);\n        -> -1\nmysql> SELECT SIGN(0);\n        -> 0\nmysql> SELECT SIGN(234);\n        -> 1\n","mathematical-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (129,27,"SEC_TO_TIME","Syntax:\nSEC_TO_TIME(seconds)\n\nReturns the seconds argument, converted to hours, minutes, and seconds,\nas a value in 'HH:MM:SS' or HHMMSS format, depending on whether the\nfunction is used in a string or numeric context.\n","mysql> SELECT SEC_TO_TIME(2378);\n        -> '00:39:38'\nmysql> SELECT SEC_TO_TIME(2378) + 0;\n        -> 3938\n","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (130,20,"FLOAT","FLOAT[(M,D)] [UNSIGNED] [ZEROFILL]\n\nA small (single-precision) floating-point number. Allowable values are\n-3.402823466E+38 to -1.175494351E-38, 0, and 1.175494351E-38 to\n3.402823466E+38. These are the theoretical limits, based on the IEEE\nstandard. The actual range might be slightly smaller depending on your\nhardware or operating system.\n\nM is the total number of decimal digits and D is the number of digits\nfollowing the decimal point. If M and D are omitted, values are stored\nto the limits allowed by the hardware. A single-precision\nfloating-point number is accurate to approximately 7 decimal places.\n\nUNSIGNED, if specified, disallows negative values.\n\nUsing FLOAT might give you some unexpected problems because all\ncalculations in MySQL are done with double precision. See\n[no-matching-rows].\n","","numeric-type-overview");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (131,32,"LOCATE","Syntax:\nLOCATE(substr,str), LOCATE(substr,str,pos)\n\nThe first syntax returns the position of the first occurrence of\nsubstring substr in string str. The second syntax returns the position\nof the first occurrence of substring substr in string str, starting at\nposition pos. Returns 0 if substr is not in str.\n","mysql> SELECT LOCATE('bar', 'foobarbar');\n        -> 4\nmysql> SELECT LOCATE('xbar', 'foobar');\n        -> 0\nmysql> SELECT LOCATE('bar', 'foobarbar', 5);\n        -> 7\n","string-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (132,15,"CHARSET","Syntax:\nCHARSET(str)\n\nReturns the character set of the string argument.\n","mysql> SELECT CHARSET('abc');\n        -> 'latin1'\nmysql> SELECT CHARSET(CONVERT('abc' USING utf8));\n        -> 'utf8'\nmysql> SELECT CHARSET(USER());\n        -> 'utf8'\n","information-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (133,27,"SUBDATE","Syntax:\nSUBDATE(date,INTERVAL expr type), SUBDATE(expr,days)\n\nWhen invoked with the INTERVAL form of the second argument, SUBDATE()\nis a synonym for DATE_SUB(). For information on the INTERVAL argument,\nsee the discussion for DATE_ADD().\n\nmysql> SELECT DATE_SUB('1998-01-02', INTERVAL 31 DAY);\n        -> '1997-12-02'\nmysql> SELECT SUBDATE('1998-01-02', INTERVAL 31 DAY);\n        -> '1997-12-02'\n\nAs of MySQL 4.1.1, the second syntax is allowed, where expr is a date\nor datetime expression and days is the number of days to be subtracted\nfrom expr.\n\nmysql> SELECT SUBDATE('1998-01-02 12:00:00', 31);\n        -> '1997-12-02 12:00:00'\n\nNote: You cannot use format \"%X%V\" to convert a year-week string to a\ndate because the combination of a year and week does not uniquely\nidentify a year and month if the week crosses a month boundary. To\nconvert a year-week to a date, then you should also specify the\nweekday:\n\nmysql> SELECT STR_TO_DATE('200442 Monday', '%X%V %W');\n        -> '2004-10-18'\n","","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (134,27,"DAYOFYEAR","Syntax:\nDAYOFYEAR(date)\n\nReturns the day of the year for date, in the range 1 to 366.\n","mysql> SELECT DAYOFYEAR('1998-02-03');\n        -> 34\n","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (135,4,"%","Syntax:\nMOD(N,M), N % M, N MOD M\n\nModulo operation. Returns the remainder of N divided by M.\n","mysql> SELECT MOD(234, 10);\n        -> 4\nmysql> SELECT 253 % 7;\n        -> 1\nmysql> SELECT MOD(29,9);\n        -> 2\nmysql> SELECT 29 MOD 9;\n        -> 2\n","mathematical-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (136,20,"LONGTEXT","LONGTEXT\n\nA TEXT column with a maximum length of 4,294,967,295 or 4GB (232 - 1)\ncharacters. Up to MySQL 3.23, the client/server protocol and MyISAM\ntables had a limit of 16MB per communication packet or table row. From\nMySQL 4.0, the maximum allowed length of LONGTEXT columns depends on\nthe configured maximum packet size in the client/server protocol and\navailable memory.\n","","string-type-overview");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (137,25,"DISJOINT","Disjoint(g1,g2)\n\nReturns 1 or 0 to indicate whether g1 is spatially disjoint from (does\nnot intersect) g2.\n","","functions-that-test-spatial-relationships-between-geometries");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (138,24,"KILL","Syntax:\nKILL thread_id\n\nEach connection to mysqld runs in a separate thread. You can see which\nthreads are running with the SHOW PROCESSLIST statement and kill a\nthread with the KILL thread_id statement.\n\nIf you have the PROCESS privilege, you can see all threads. If you have\nthe SUPER privilege, you can kill all threads and statements.\nOtherwise, you can see and kill only your own threads and statements.\n\nYou can also use the mysqladmin processlist and mysqladmin kill\ncommands to examine and kill threads.\n\nNote: You cannot use KILL with the Embedded MySQL Server library,\nbecause the embedded server merely runs inside the threads of the host\napplication. It does not create any connection threads of its own.\n","","kill");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (139,3,"ASTEXT","AsText(g)\n\nConverts a value in internal geometry format to its WKT representation\nand returns the string result.\n","mysql> SET @g = 'LineString(1 1,2 2,3 3)';\nmysql> SELECT AsText(GeomFromText(@g));\n+--------------------------+\n| AsText(GeomFromText(@g)) |\n+--------------------------+\n| LINESTRING(1 1,2 2,3 3)  |\n+--------------------------+\n","functions-to-convert-geometries-between-formats");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (140,32,"LPAD","Syntax:\nLPAD(str,len,padstr)\n\nReturns the string str, left-padded with the string padstr to a length\nof len characters. If str is longer than len, the return value is\nshortened to len characters.\n\n","mysql> SELECT LPAD('hi',4,'??');\n        -> '??hi'\nmysql> SELECT LPAD('hi',1,'??');\n        -> 'h'\n","string-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (141,19,"RESTORE TABLE","Syntax:\nRESTORE TABLE tbl_name [, tbl_name] ... FROM '/path/to/backup/directory'\n\nRESTORE TABLE restores the table or tables from a backup that was made\nwith BACKUP TABLE. Existing tables are not overwritten; if you try to\nrestore over an existing table, an error occurs. Just as for BACKUP\nTABLE, RESTORE TABLE currently works only for MyISAM tables. The\ndirectory should be specified as a full pathname.\n\nThe backup for each table consists of its .frm format file and .MYD\ndata file. The restore operation restores those files, and then uses\nthem to rebuild the .MYI index file. Restoring takes longer than\nbacking up due to the need to rebuild the indexes. The more indexes the\ntable has, the longer it takes.\n","","restore-table");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (142,25,"OVERLAPS","Overlaps(g1,g2)\n\nReturns 1 or 0 to indicate whether g1 spatially overlaps g2. The term\nspatially overlaps is used if two geometries intersect and their\nintersection results in a geometry of the same dimension but not equal\nto either of the given geometries.\n","","functions-that-test-spatial-relationships-between-geometries");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (143,22,"NUMGEOMETRIES","NumGeometries(gc)\n\nReturns the number of geometries in the GeometryCollection value gc.\n","mysql> SET @gc = 'GeometryCollection(Point(1 1),LineString(2 2, 3 3))';\nmysql> SELECT NumGeometries(GeomFromText(@gc));\n+----------------------------------+\n| NumGeometries(GeomFromText(@gc)) |\n+----------------------------------+\n|                                2 |\n+----------------------------------+\n","geometrycollection-property-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (144,24,"SET GLOBAL SQL_SLAVE_SKIP_COUNTER","Syntax:\nSET GLOBAL SQL_SLAVE_SKIP_COUNTER = N\n\nThis statement skips the next N events from the master. This is useful\nfor recovering from replication stops caused by a statement.\n\nThis statement is valid only when the slave thread is not running.\nOtherwise, it produces an error.\n\nBefore MySQL 4.0, omit the GLOBAL keyword from the statement.\n","","set-global-sql-slave-skip-counter");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (145,27,"MONTHNAME","Syntax:\nMONTHNAME(date)\n\nReturns the full name of the month for date.\n","mysql> SELECT MONTHNAME('1998-02-05');\n        -> 'February'\n","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (146,5,"MBREQUAL","MBREqual(g1,g2)\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of\nthe two geometries g1 and g2 are the same.\n","","relations-on-geometry-mbr");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (147,24,"CHANGE MASTER TO","Syntax:\nCHANGE MASTER TO master_def [, master_def] ...\n\nmaster_def:\n    MASTER_HOST = 'host_name'\n  | MASTER_USER = 'user_name'\n  | MASTER_PASSWORD = 'password'\n  | MASTER_PORT = port_num\n  | MASTER_CONNECT_RETRY = count\n  | MASTER_LOG_FILE = 'master_log_name'\n  | MASTER_LOG_POS = master_log_pos\n  | RELAY_LOG_FILE = 'relay_log_name'\n  | RELAY_LOG_POS = relay_log_pos\n  | MASTER_SSL = {0|1}\n  | MASTER_SSL_CA = 'ca_file_name'\n  | MASTER_SSL_CAPATH = 'ca_directory_name'\n  | MASTER_SSL_CERT = 'cert_file_name'\n  | MASTER_SSL_KEY = 'key_file_name'\n  | MASTER_SSL_CIPHER = 'cipher_list'\n\nCHANGE MASTER TO changes the parameters that the slave server uses for\nconnecting to and communicating with the master server. It also updates\nthe contents of the master.info and relay-log.info files.\n\nMASTER_USER, MASTER_PASSWORD, MASTER_SSL, MASTER_SSL_CA,\nMASTER_SSL_CAPATH, MASTER_SSL_CERT, MASTER_SSL_KEY, and\nMASTER_SSL_CIPHER provide information to the slave about how to connect\nto its master.\n\nThe relay log options (RELAY_LOG_FILE and RELAY_LOG_POS) are available\nbeginning with MySQL 4.0.\n\nThe SSL options (MASTER_SSL, MASTER_SSL_CA, MASTER_SSL_CAPATH,\nMASTER_SSL_CERT, MASTER_SSL_KEY, and MASTER_SSL_CIPHER) are available\nbeginning with MySQL 4.1.1. You can change these options even on slaves\nthat are compiled without SSL support. They are saved to the\nmaster.info file, but are ignored unless you use a server that has SSL\nsupport enabled.\n\nIf you don't specify a given parameter, it keeps its old value, except\nas indicated in the following discussion. For example, if the password\nto connect to your MySQL master has changed, you just need to issue\nthese statements to tell the slave about the new password:\n\nSTOP SLAVE; -- if replication was running\nCHANGE MASTER TO MASTER_PASSWORD='new3cret';\nSTART SLAVE; -- if you want to restart replication\n\nThere is no need to specify the parameters that do not change (host,\nport, user, and so forth).\n\nMASTER_HOST and MASTER_PORT are the hostname (or IP address) of the\nmaster host and its TCP/IP port. Note that if MASTER_HOST is equal to\nlocalhost, then, like in other parts of MySQL, the port number might be\nignored (if Unix socket files can be used, for example).\n\nIf you specify MASTER_HOST or MASTER_PORT, the slave assumes that the\nmaster server is different from before (even if you specify a host or\nport value that is the same as the current value.) In this case, the\nold values for the master binary log name and position are considered\nno longer applicable, so if you do not specify MASTER_LOG_FILE and\nMASTER_LOG_POS in the statement, MASTER_LOG_FILE='' and\nMASTER_LOG_POS=4 are silently appended to it.\n\nMASTER_LOG_FILE and MASTER_LOG_POS are the coordinates at which the\nslave I/O thread should begin reading from the master the next time the\nthread starts. If you specify either of them, you cannot specify\nRELAY_LOG_FILE or RELAY_LOG_POS. If neither of MASTER_LOG_FILE or\nMASTER_LOG_POS are specified, the slave uses the last coordinates of\nthe slave SQL thread before CHANGE MASTER was issued. This ensures that\nreplication has no discontinuity, even if the slave SQL thread was late\ncompared to the slave I/O thread, when you just want to change, say,\nthe password to use. This safe behavior was introduced starting from\nMySQL 4.0.17 and 4.1.1. (Before these versions, the coordinates used\nwere the last coordinates of the slave I/O thread before CHANGE MASTER\nwas issued. This caused the SQL thread to possibly lose some events\nfrom the master, thus breaking replication.)\n\nCHANGE MASTER deletes all relay log files and starts a new one, unless\nyou specify RELAY_LOG_FILE or RELAY_LOG_POS. In that case, relay logs\nare kept; as of MySQL 4.1.1, the relay_log_purge global variable is set\nsilently to 0.\n\nCHANGE MASTER is useful for setting up a slave when you have the\nsnapshot of the master and have recorded the log and the offset\ncorresponding to it. After loading the snapshot into the slave, you can\nrun CHANGE MASTER TO MASTER_LOG_FILE='log_name_on_master',\nMASTER_LOG_POS=log_offset_on_master on the slave.\n\nThe following example changes the master and master's binary log\ncoordinates. This is used when you want to set up the slave to\nreplicate the master:\n\nCHANGE MASTER TO\n  MASTER_HOST='master2.mycompany.com',\n  MASTER_USER='replication',\n  MASTER_PASSWORD='bigs3cret',\n  MASTER_PORT=3306,\n  MASTER_LOG_FILE='master2-bin.001',\n  MASTER_LOG_POS=4,\n  MASTER_CONNECT_RETRY=10;\n\nThe next example shows an operation that is less frequently employed.\nIt is used when the slave has relay logs that you want it to execute\nagain for some reason. To do this, the master need not be reachable.\nYou need only use CHANGE MASTER TO and start the SQL thread (START\nSLAVE SQL_THREAD):\n\nCHANGE MASTER TO\n  RELAY_LOG_FILE='slave-relay-bin.006',\n  RELAY_LOG_POS=4025;\n","","change-master-to");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (148,34,"DROP DATABASE","Syntax:\nDROP DATABASE [IF EXISTS] db_name\n\nDROP DATABASE drops all tables in the database and deletes the\ndatabase. Be very careful with this statement! To use DROP DATABASE,\nyou need the DROP privilege on the database.\n\nIn MySQL 3.22 or later, you can use the keywords IF EXISTS to prevent\nan error from occurring if the database does not exist.\n","","drop-database");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (149,27,"TIMESTAMP FUNCTION","Syntax:\nTIMESTAMP(expr), TIMESTAMP(expr,expr2)\n\nWith a single argument, this function returns the date or datetime\nexpression expr as a datetime value. With two arguments, it adds the\ntime expression expr2 to the date or datetime expression expr and\nreturns the result as a datetime value.\n","mysql> SELECT TIMESTAMP('2003-12-31');\n        -> '2003-12-31 00:00:00'\nmysql> SELECT TIMESTAMP('2003-12-31 12:00:00','12:00:00');\n        -> '2004-01-01 00:00:00'\n","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (150,32,"CHARACTER_LENGTH","Syntax:\nCHARACTER_LENGTH(str)\n\nCHARACTER_LENGTH() is a synonym for CHAR_LENGTH().\n","","string-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (151,24,"SHOW GRANTS","Syntax:\nSHOW GRANTS FOR user\n\nThis statement lists the GRANT statement or statements that must be\nissued to duplicate the privileges that are granted to a MySQL user\naccount. The account is named using the same format as for the GRANT\nstatement; for example, 'jeffrey'@'localhost'. The user and host parts\nof the account name correspond to the User and Host column values of\nthe user table row for the account.\n\nmysql> SHOW GRANTS FOR 'root'@'localhost';\n+---------------------------------------------------------------------+\n| Grants for root@localhost                                           |\n+---------------------------------------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO 'root'@'localhost' WITH GRANT OPTION |\n+---------------------------------------------------------------------+\n\nAs of MySQL 4.1.2, to list the privileges granted to the account that\nyou are using to connect to the server, you can use any of the\nfollowing statements:\n\nSHOW GRANTS;\nSHOW GRANTS FOR CURRENT_USER;\nSHOW GRANTS FOR CURRENT_USER();\n","","show-grants");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (152,24,"SHOW PRIVILEGES","Syntax:\nSHOW PRIVILEGES\n\nSHOW PRIVILEGES shows the list of system privileges that the MySQL\nserver supports. This statement is implemented as of MySQL 4.1.0. The\nexact list of privileges depends on the version of your server.\n","","show-privileges");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (153,32,"INSERT FUNCTION","Syntax:\nINSERT(str,pos,len,newstr)\n\nReturns the string str, with the substring beginning at position pos\nand len characters long replaced by the string newstr. Returns the\noriginal string if pos is not within the length of the string. Replaces\nthe rest of the string from position pos is len is not within the\nlength of the rest of the string. Returns NULL if any argument is NULL.\n","mysql> SELECT INSERT('Quadratic', 3, 4, 'What');\n        -> 'QuWhattic'\nmysql> SELECT INSERT('Quadratic', -1, 4, 'What');\n        -> 'Quadratic'\nmysql> SELECT INSERT('Quadratic', 3, 100, 'What');\n        -> 'QuWhat'\n","string-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (154,4,"CRC32","Syntax:\nCRC32(expr)\n\nComputes a cyclic redundancy check value and returns a 32-bit unsigned\nvalue. The result is NULL if the argument is NULL. The argument is\nexpected to be a string and (if possible) is treated as one if it is\nnot.\n","mysql> SELECT CRC32('MySQL');\n        -> 3259397556\n","mathematical-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (155,12,"XOR","Syntax:\nXOR\n\nLogical XOR. Returns NULL if either operand is NULL. For non-NULL\noperands, evaluates to 1 if an odd number of operands is non-zero,\notherwise 0 is returned.\n","mysql> SELECT 1 XOR 1;\n        -> 0\nmysql> SELECT 1 XOR 0;\n        -> 1\nmysql> SELECT 1 XOR NULL;\n        -> NULL\nmysql> SELECT 1 XOR 1 XOR 1;\n        -> 1\n","logical-operators");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (156,11,"STARTPOINT","StartPoint(ls)\n\nReturns the Point that is the start point of the LineString value ls.\n","mysql> SET @ls = 'LineString(1 1,2 2,3 3)';\nmysql> SELECT AsText(StartPoint(GeomFromText(@ls)));\n+---------------------------------------+\n| AsText(StartPoint(GeomFromText(@ls))) |\n+---------------------------------------+\n| POINT(1 1)                            |\n+---------------------------------------+\n","linestring-property-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (157,3,"MPOLYFROMTEXT","MPolyFromText(wkt[,srid]), MultiPolygonFromText(wkt[,srid])\n\nConstructs a MULTIPOLYGON value using its WKT representation and SRID.\n","","gis-wkt-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (158,8,"GRANT","Syntax:\nGRANT priv_type [(column_list)] [, priv_type [(column_list)]] ...\n    ON {tbl_name | * | *.* | db_name.*}\n    TO user [IDENTIFIED BY [PASSWORD] 'password']\n        [, user [IDENTIFIED BY [PASSWORD] 'password']] ...\n    [REQUIRE\n        NONE |\n        [{SSL| X509}]\n        [CIPHER 'cipher' [AND]]\n        [ISSUER 'issuer' [AND]]\n        [SUBJECT 'subject']]\n    [WITH with_option [with_option] ...]\n\nwith_option =\n    GRANT OPTION\n  | MAX_QUERIES_PER_HOUR count\n  | MAX_UPDATES_PER_HOUR count\n  | MAX_CONNECTIONS_PER_HOUR count\n\nThe GRANT statement enables system administrators to create MySQL user\naccounts and to grant rights to accounts. To use GRANT, you must have\nthe GRANT OPTION privilege, and you must have the privileges that you\nare granting. GRANT is implemented in MySQL 3.22.11 or later. For\nearlier MySQL versions, it does nothing. The REVOKE statement is\nrelated and enables administrators to remove account privileges. See\n[revoke].\n\nMySQL account information is stored in the tables of the mysql\ndatabase. This database and the access control system are discussed\nextensively in [database-administration], which you should consult for\nadditional details.\n\nImportant: Some releases of MySQL introduce changes to the structure of\nthe grant tables to add new privileges or features. Whenever you update\nto a new version of MySQL, you should update your grant tables to make\nsure that they have the current structure so that you can take\nadvantage of any new capabilities. See [mysql-fix-privilege-tables].\n\nIf the grant tables hold privilege rows that contain mixed-case\ndatabase or table names and the lower_case_table_names system variable\nis set to a non-zero value, REVOKE cannot be used to revoke these\nprivileges. It will be necessary to manipulate the grant tables\ndirectly. (GRANT will not create such rows when lower_case_table_names\nis set, but such rows might have been created prior to setting the\nvariable.)\n\nPrivileges can be granted at several levels:\n\no Global level\n\n  Global privileges apply to all databases on a given server. These\n  privileges are stored in the mysql.user table. GRANT ALL ON *.* and\n  REVOKE ALL ON *.* grant and revoke only global privileges.\n\no Database level\n\n  Database privileges apply to all tables in a given database. These\n  privileges are stored in the mysql.db and mysql.host tables. GRANT\n  ALL ON db_name.* and REVOKE ALL ON db_name.* grant and revoke only\n  database privileges.\n\no Table level\n\n  Table privileges apply to all columns in a given table. These\n  privileges are stored in the mysql.tables_priv table. GRANT ALL ON\n  db_name.tbl_name and REVOKE ALL ON db_name.tbl_name grant and revoke\n  only table privileges.\n\no Column level\n\n  Column privileges apply to single columns in a given table. These\n  privileges are stored in the mysql.columns_priv table. When using\n  REVOKE, you must specify the same columns that were granted.\n","","grant");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (159,5,"MBRINTERSECTS","MBRIntersects(g1,g2)\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of\nthe two geometries g1 and g2 intersect.\n","","relations-on-geometry-mbr");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (160,14,"BIT_OR","Syntax:\nBIT_OR(expr)\n\nReturns the bitwise OR of all bits in expr. The calculation is\nperformed with 64-bit (BIGINT) precision.\n","","group-by-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (161,27,"YEARWEEK","Syntax:\nYEARWEEK(date), YEARWEEK(date,start)\n\nReturns year and week for a date. The start argument works exactly like\nthe start argument to WEEK(). The year in the result may be different\nfrom the year in the date argument for the first and the last week of\nthe year.\n","mysql> SELECT YEARWEEK('1987-01-01');\n        -> 198653\n","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (162,17,"NOT BETWEEN","Syntax:\nexpr NOT BETWEEN min AND max\n\nThis is the same as NOT (expr BETWEEN min AND max).\n","","comparison-operators");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (163,4,"LOG10","Syntax:\nLOG10(X)\n\nReturns the base-10 logarithm of X.\n","mysql> SELECT LOG10(2);\n        -> 0.301030\nmysql> SELECT LOG10(100);\n        -> 2.000000\nmysql> SELECT LOG10(-100);\n        -> NULL\n","mathematical-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (164,4,"SQRT","Syntax:\nSQRT(X)\n\nReturns the square root of a non-negative number X.\n","mysql> SELECT SQRT(4);\n        -> 2\nmysql> SELECT SQRT(20);\n        -> 4.4721359549996\nmysql> SELECT SQRT(-16);\n        -> NULL        \n","mathematical-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (165,20,"DECIMAL","DECIMAL[(M[,D])] [UNSIGNED] [ZEROFILL]\n\nAn unpacked fixed-point number. Behaves like a CHAR column; \"unpacked\"\nmeans the number is stored as a string, using one character for each\ndigit of the value. M is the total number of digits and D is the number\nof digits after the decimal point. The decimal point and (for negative\nnumbers) the `-' sign are not counted in M, although space for them is\nreserved. If D is 0, values have no decimal point or fractional part.\nThe maximum range of DECIMAL values is the same as for DOUBLE, but the\nactual range for a given DECIMAL column may be constrained by the\nchoice of M and D. If D is omitted, the default is 0. If M is omitted,\nthe default is 10.\n\nUNSIGNED, if specified, disallows negative values.\n\nNote: Before MySQL 3.23, the value of M must be large enough to include\nthe space needed for the sign and the decimal point characters.\n","","numeric-type-overview");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (166,33,"CREATE FUNCTION","Syntax:\nCREATE [AGGREGATE] FUNCTION function_name RETURNS {STRING|INTEGER|REAL}\n    SONAME shared_library_name\n\nA user-defined function (UDF) is a way to extend MySQL with a new\nfunction that works like a native (built-in) MySQL function such as\nABS() or CONCAT().\n\nfunction_name is the name that should be used in SQL statements to\ninvoke the function. The RETURNS clause indicates the type of the\nfunction's return value. shared_library_name is the basename of the\nshared object file that contains the code that implements the function.\nThe file must be located in a directory that is searched by your\nsystem's dynamic linker.\n\nTo create a function, you must have the INSERT and privilege for the\nmysql database. This is necessary because CREATE FUNCTION adds a row to\nthe mysql.func system table that records the function's name, type, and\nshared library name. If you do not have this table, you should run the\nmysql_fix_privilege_tables script to create it. See\n[mysql-fix-privilege-tables].\n","","create-function");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (167,22,"GEOMETRYN","GeometryN(gc,N)\n\nReturns the N-th geometry in the GeometryCollection value gc.\nGeometries are numbered beginning with 1.\n","mysql> SET @gc = 'GeometryCollection(Point(1 1),LineString(2 2, 3 3))';\nmysql> SELECT AsText(GeometryN(GeomFromText(@gc),1));\n+----------------------------------------+\n| AsText(GeometryN(GeomFromText(@gc),1)) |\n+----------------------------------------+\n| POINT(1 1)                             |\n+----------------------------------------+\n","geometrycollection-property-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (168,34,"CREATE INDEX","Syntax:\nCREATE [UNIQUE|FULLTEXT|SPATIAL] INDEX index_name\n    [USING type_name]\n    ON tbl_name (index_col_name,...)\n\nindex_col_name:\n    col_name [(length)] [ASC | DESC]\n\nIn MySQL 3.22 or later, CREATE INDEX is mapped to an ALTER TABLE\nstatement to create indexes. See [alter-table]. The CREATE INDEX\nstatement does not do anything prior to MySQL 3.22. For more\ninformation about indexes, see [mysql-indexes].\n","","create-index");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (169,34,"ALTER DATABASE","Syntax:\nALTER DATABASE [db_name]\n    alter_specification [, alter_specification] ...\n\nalter_specification:\n    [DEFAULT] CHARACTER SET charset_name\n  | [DEFAULT] COLLATE collation_name\n\nALTER DATABASE enables you to change the overall characteristics of a\ndatabase. These characteristics are stored in the db.opt file in the\ndatabase directory. To use ALTER DATABASE, you need the ALTER privilege\non the database.\n\nThe CHARACTER SET clause changes the default database character set.\nThe COLLATE clause changes the default database collation. [charset],\ndiscusses character set and collation names.\n","","alter-database");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (170,18,"<<","Syntax:\n<<\n\nShifts a longlong (BIGINT) number to the left.\n","mysql> SELECT 1 << 2;\n        -> 4\n","bit-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (171,24,"SHOW TABLE STATUS","Syntax:\nSHOW TABLE STATUS [FROM db_name] [LIKE 'pattern']\n\nSHOW TABLE STATUS works likes SHOW TABLE, but provides a lot of\ninformation about each table. You can also get this list using the\nmysqlshow --status db_name command. This statement was added in MySQL\n3.23.\n","","show-table-status");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (172,10,"MD5","Syntax:\nMD5(str)\n\nCalculates an MD5 128-bit checksum for the string. The value is\nreturned as a binary string of 32 hex digits, or NULL if the argument\nwas NULL. The return value can, for example, be used as a hash key.\n","mysql> SELECT MD5('testing');\n        -> 'ae2b1fca515949e5d54fb22b8ed95575'\n","encryption-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (173,17,"<","Syntax:\n<\n\nLess than:\n","mysql> SELECT 2 < 2;\n        -> 0\n","comparison-operators");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (174,27,"UNIX_TIMESTAMP","Syntax:\nUNIX_TIMESTAMP(), UNIX_TIMESTAMP(date)\n\nIf called with no argument, returns a Unix timestamp (seconds since\n'1970-01-01 00:00:00' UTC) as an unsigned integer. If UNIX_TIMESTAMP()\nis called with a date argument, it returns the value of the argument as\nseconds since '1970-01-01 00:00:00' UTC. date may be a DATE string, a\nDATETIME string, a TIMESTAMP, or a number in the format YYMMDD or\nYYYYMMDD. The server interprets date as a value in the current time\nzone and converts it to an internal value in UTC. Clients can set their\ntime zone as described in [time-zone-support].\n","mysql> SELECT UNIX_TIMESTAMP();\n        -> 882226357\nmysql> SELECT UNIX_TIMESTAMP('1997-10-04 22:23:00');\n        -> 875996580\n","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (175,27,"DAYOFMONTH","Syntax:\nDAYOFMONTH(date)\n\nReturns the day of the month for date, in the range 0 to 31.\n","mysql> SELECT DAYOFMONTH('1998-02-03');\n        -> 3\n","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (176,32,"ASCII","Syntax:\nASCII(str)\n\nReturns the numeric value of the leftmost character of the string str.\nReturns 0 if str is the empty string. Returns NULL if str is NULL.\nASCII() works for characters with numeric values from 0 to 255.\n","mysql> SELECT ASCII('2');\n        -> 50\nmysql> SELECT ASCII(2);\n        -> 50\nmysql> SELECT ASCII('dx');\n        -> 100\n","string-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (177,4,"DIV","Syntax:\nDIV\n\nInteger division. Similar to FLOOR(), but is safe with BIGINT values.\n","mysql> SELECT 5 DIV 2;\n        -> 2\n","arithmetic-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (178,24,"SHOW SLAVE STATUS","Syntax:\nSHOW SLAVE STATUS\n\nThis statement provides status information on essential parameters of\nthe slave threads. If you issue this statement using the mysql client,\nyou can use a \\G statement terminator rather than a semicolon to obtain\na more readable vertical layout:\n\nmysql> SHOW SLAVE STATUS\\G\n*************************** 1. row ***************************\n       Slave_IO_State: Waiting for master to send event\n          Master_Host: localhost\n          Master_User: root\n          Master_Port: 3306\n        Connect_Retry: 3\n      Master_Log_File: gbichot-bin.005\n  Read_Master_Log_Pos: 79\n       Relay_Log_File: gbichot-relay-bin.005\n        Relay_Log_Pos: 548\nRelay_Master_Log_File: gbichot-bin.005\n     Slave_IO_Running: Yes\n    Slave_SQL_Running: Yes\n      Replicate_Do_DB:\n  Replicate_Ignore_DB:\n           Last_Errno: 0\n           Last_Error:\n         Skip_Counter: 0\n  Exec_Master_Log_Pos: 79\n      Relay_Log_Space: 552\n      Until_Condition: None\n       Until_Log_File:\n        Until_Log_Pos: 0\n   Master_SSL_Allowed: No\n   Master_SSL_CA_File:\n   Master_SSL_CA_Path:\n      Master_SSL_Cert:\n    Master_SSL_Cipher:\n       Master_SSL_Key:\nSeconds_Behind_Master: 8\n","","show-slave-status");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (179,29,"GEOMETRY","MySQL provides a standard way of creating spatial columns for geometry\ntypes, for example, with CREATE TABLE or ALTER TABLE. Currently,\nspatial columns are supported only for MyISAM tables.\n","CREATE TABLE geom (g GEOMETRY);\n","creating-spatial-columns");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (180,11,"NUMPOINTS","NumPoints(ls)\n\nReturns the number of Point objects in the LineString value ls.\n","mysql> SET @ls = 'LineString(1 1,2 2,3 3)';\nmysql> SELECT NumPoints(GeomFromText(@ls));\n+------------------------------+\n| NumPoints(GeomFromText(@ls)) |\n+------------------------------+\n|                            3 |\n+------------------------------+\n","linestring-property-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (181,18,"&","Syntax:\n&\n\nBitwise AND:\n","mysql> SELECT 29 & 15;\n        -> 13\n","bit-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (182,27,"LOCALTIMESTAMP","Syntax:\nLOCALTIMESTAMP, LOCALTIMESTAMP()\n\nLOCALTIMESTAMP and LOCALTIMESTAMP() are synonyms for NOW().\n","","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (183,27,"ADDDATE","Syntax:\nADDDATE(date,INTERVAL expr type), ADDDATE(expr,days)\n\nWhen invoked with the INTERVAL form of the second argument, ADDDATE()\nis a synonym for DATE_ADD(). The related function SUBDATE() is a\nsynonym for DATE_SUB(). For information on the INTERVAL argument, see\nthe discussion for DATE_ADD().\n\nmysql> SELECT DATE_ADD('1998-01-02', INTERVAL 31 DAY);\n        -> '1998-02-02'\nmysql> SELECT ADDDATE('1998-01-02', INTERVAL 31 DAY);\n        -> '1998-02-02'\n\nAs of MySQL 4.1.1, the second syntax is allowed. When invoked with the\ndays form of the second argument, MySQL treats it as an integer number\nof days to be added to expr.\n","mysql> SELECT ADDDATE('1998-01-02', 31);\n        -> '1998-02-02'\n","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (184,20,"SMALLINT","SMALLINT[(M)] [UNSIGNED] [ZEROFILL]\n\nA small integer. The signed range is -32768 to 32767. The unsigned\nrange is 0 to 65535.\n","","numeric-type-overview");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (185,20,"DOUBLE PRECISION","DOUBLE PRECISION[(M,D)] [UNSIGNED] [ZEROFILL], REAL[(M,D)] [UNSIGNED]\n[ZEROFILL]\n\nThese types are synonyms for DOUBLE. Exception: If the REAL_AS_FLOAT\nSQL mode is enabled, REAL is a synonym for FLOAT rather than DOUBLE.\n","","numeric-type-overview");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (186,32,"ORD","Syntax:\nORD(str)\n\nIf the leftmost character of the string str is a multi-byte character,\nreturns the code for that character, calculated from the numeric values\nof its constituent bytes using this formula:\n\n  (1st byte code)\n+ (2nd byte code × 256)\n+ (3rd byte code × 2562) ...\n\nIf the leftmost character is not a multi-byte character, ORD() returns\nthe same value as the ASCII() function.\n","mysql> SELECT ORD('2');\n        -> 50\n","string-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (187,31,"ENVELOPE","Envelope(g)\n\nReturns the Minimum Bounding Rectangle (MBR) for the geometry value g.\nThe result is returned as a Polygon value.\n\nThe polygon is defined by the corner points of the bounding box:\n\nPOLYGON((MINX MINY, MAXX MINY, MAXX MAXY, MINX MAXY, MINX MINY))\n","mysql> SELECT AsText(Envelope(GeomFromText('LineString(1 1,2 2)')));\n+-------------------------------------------------------+\n| AsText(Envelope(GeomFromText('LineString(1 1,2 2)'))) |\n+-------------------------------------------------------+\n| POLYGON((1 1,2 1,2 2,1 2,1 1))                        |\n+-------------------------------------------------------+\n","general-geometry-property-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (188,24,"DEALLOCATE PREPARE","Syntax:\n{DEALLOCATE | DROP} PREPARE stmt_name\n\nTo deallocate a prepared statement, use the DEALLOCATE PREPARE\nstatement. Attempting to execute a prepared statement after\ndeallocating it results in an error.\n\nIf you terminate a client session without deallocating a previously\nprepared statement, the server deallocates it automatically.\n","","sqlps");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (189,13,"IS_FREE_LOCK","Syntax:\nIS_FREE_LOCK(str)\n\nChecks whether the lock named str is free to use (that is, not locked).\nReturns 1 if the lock is free (no one is using the lock), 0 if the lock\nis in use, and NULL if an error occurs (such as an incorrect argument).\n","","miscellaneous-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (190,25,"TOUCHES","Touches(g1,g2)\n\nReturns 1 or 0 to indicate whether g1 spatially touches g2. Two\ngeometries spatially touch if the interiors of the geometries do not\nintersect, but the boundary of one of the geometries intersects either\nthe boundary or the interior of the other.\n","","functions-that-test-spatial-relationships-between-geometries");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (191,13,"INET_ATON","Syntax:\nINET_ATON(expr)\n\nGiven the dotted-quad representation of a network address as a string,\nreturns an integer that represents the numeric value of the address.\nAddresses may be 4- or 8-byte addresses.\n","mysql> SELECT INET_ATON('209.207.224.40');\n        -> 3520061480\n","miscellaneous-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (192,10,"UNCOMPRESS","Syntax:\nUNCOMPRESS(string_to_uncompress)\n\nUncompresses a string compressed by the COMPRESS() function. If the\nargument is not a compressed value, the result is NULL. This function\nrequires MySQL to have been compiled with a compression library such as\nzlib. Otherwise, the return value is always NULL.\n","mysql> SELECT UNCOMPRESS(COMPRESS('any string'));\n        -> 'any string'\nmysql> SELECT UNCOMPRESS('any string');\n        -> NULL\n","encryption-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (193,20,"AUTO_INCREMENT","The AUTO_INCREMENT attribute can be used to generate a unique identity\nfor new rows:\n","CREATE TABLE animals (\n     id MEDIUMINT NOT NULL AUTO_INCREMENT,\n     name CHAR(30) NOT NULL,\n     PRIMARY KEY (id)\n );\n\nINSERT INTO animals (name) VALUES \n    ('dog'),('cat'),('penguin'),\n    ('lax'),('whale'),('ostrich');\n\nSELECT * FROM animals;\n","example-auto-increment");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (194,31,"ISSIMPLE","IsSimple(g)\n\nCurrently, this function is a placeholder and should not be used. If\nimplemented, its behavior will be as described in the next paragraph.\n\nReturns 1 if the geometry value g has no anomalous geometric points,\nsuch as self-intersection or self-tangency. IsSimple() returns 0 if the\nargument is not simple, and -1 if it is NULL.\n\nThe description of each instantiable geometric class given earlier in\nthe chapter includes the specific conditions that cause an instance of\nthat class to be classified as not simple. (See\n[gis-geometry-class-hierarchy].)\n","","general-geometry-property-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (195,4,"- BINARY","Syntax:\n-\n\nSubtraction:\n","mysql> SELECT 3-5;\n        -> -2\n","arithmetic-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (196,3,"GEOMCOLLFROMTEXT","GeomCollFromText(wkt[,srid]), GeometryCollectionFromText(wkt[,srid])\n\nConstructs a GEOMETRYCOLLECTION value using its WKT representation and\nSRID.\n","","gis-wkt-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (197,3,"WKT DEFINITION","The Well-Known Text (WKT) representation of Geometry is designed to\nexchange geometry data in ASCII form.\n","","gis-wkt-format");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (198,27,"CURRENT_TIME","Syntax:\nCURRENT_TIME, CURRENT_TIME()\n\nCURRENT_TIME and CURRENT_TIME() are synonyms for CURTIME().\n","","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (199,8,"REVOKE","Syntax:\nREVOKE priv_type [(column_list)] [, priv_type [(column_list)]] ...\n    ON {tbl_name | * | *.* | db_name.*}\n    FROM user [, user] ...\n\nREVOKE ALL PRIVILEGES, GRANT OPTION FROM user [, user] ...\n\nThe REVOKE statement enables system administrators to revoke privileges\nfrom MySQL accounts. To use REVOKE, you must have the GRANT OPTION\nprivilege, and you must have the privileges that you are revoking.\nREVOKE is implemented in MySQL 3.22.11 or later. For earlier MySQL\nversions, it does nothing.\n\nFor details on the levels at which privileges exist, the allowable\npriv_type values, and the syntax for specifying users and passwords,\nsee [grant]\n","","revoke");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (200,15,"LAST_INSERT_ID","Syntax:\nLAST_INSERT_ID(), LAST_INSERT_ID(expr)\n\nReturns the first automatically generated value that was set for an\nAUTO_INCREMENT column by the most recent INSERT or UPDATE statement to\naffect such a column.\n","mysql> SELECT LAST_INSERT_ID();\n        -> 195\n","information-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (201,27,"LAST_DAY","Syntax:\nLAST_DAY(date)\n\nTakes a date or datetime value and returns the corresponding value for\nthe last day of the month. Returns NULL if the argument is invalid.\n","mysql> SELECT LAST_DAY('2003-02-05');\n        -> '2003-02-28'\nmysql> SELECT LAST_DAY('2004-02-05');\n        -> '2004-02-29'\nmysql> SELECT LAST_DAY('2004-01-01 01:01:01');\n        -> '2004-01-31'\nmysql> SELECT LAST_DAY('2003-03-32');\n        -> NULL\n","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (202,20,"MEDIUMINT","MEDIUMINT[(M)] [UNSIGNED] [ZEROFILL]\n\nA medium-sized integer. The signed range is -8388608 to 8388607. The\nunsigned range is 0 to 16777215.\n","","numeric-type-overview");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (203,4,"FLOOR","Syntax:\nFLOOR(X)\n\nReturns the largest integer value not greater than X.\n","mysql> SELECT FLOOR(1.23);\n        -> 1\nmysql> SELECT FLOOR(-1.23);\n        -> -2\n","mathematical-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (204,32,"RTRIM","Syntax:\nRTRIM(str)\n\nReturns the string str with trailing space characters removed.\n","mysql> SELECT RTRIM('barbar   ');\n        -> 'barbar'\n","string-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (205,4,"DEGREES","Syntax:\nDEGREES(X)\n\nReturns the argument X, converted from radians to degrees.\n","mysql> SELECT DEGREES(PI());\n        -> 180.000000\n","mathematical-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (206,24,"EXPLAIN","Syntax:\nEXPLAIN tbl_name\n\nOr:\n\nEXPLAIN [EXTENDED] SELECT select_options\n\nThe EXPLAIN statement can be used either as a synonym for DESCRIBE or\nas a way to obtain information about how MySQL executes a SELECT\nstatement:\n\no EXPLAIN tbl_name is synonymous with DESCRIBE tbl_name or SHOW COLUMNS\n  FROM tbl_name.\n\no When you precede a SELECT statement with the keyword EXPLAIN, MySQL\n  displays information from the optimizer about the query execution\n  plan. That is, MySQL explains how it would process the SELECT,\n  including information about how tables are joined and in which order.\n","","explain");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (207,20,"VARCHAR","[NATIONAL] VARCHAR(M)\n\nA variable-length string. M represents the maximum column length. The\nrange of M is 1 to 255 before MySQL 4.0.2, and 0 to 255 as of MySQL\n4.0.2.\n\nNote: Trailing spaces are removed when VARCHAR values are stored. This\ndiffers from the standard SQL specification.\n\nIn MySQL 4.1, a VARCHAR column with a length specification greater than\n255 is converted to the smallest TEXT type that can hold values of the\ngiven length. For example, VARCHAR(500) is converted to TEXT, and\nVARCHAR(200000) is converted to MEDIUMTEXT. This is a compatibility\nfeature. However, this conversion affects trailing-space removal.\n\nVARCHAR is shorthand for CHARACTER VARYING.\n","","string-type-overview");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (208,32,"UNHEX","Syntax:\n\nUNHEX(str)\n\nPerforms the inverse operation of HEX(str). That is, it interprets each\npair of hexadecimal digits in the argument as a number and converts it\nto the character represented by the number. The resulting characters\nare returned as a binary string.\n","mysql> SELECT UNHEX('4D7953514C');\n        -> 'MySQL'\nmysql> SELECT 0x4D7953514C;\n        -> 'MySQL'\nmysql> SELECT UNHEX(HEX('string'));\n        -> 'string'\nmysql> SELECT HEX(UNHEX('1267'));\n        -> '1267'\n","string-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (209,4,"- UNARY","Syntax:\n-\n\nUnary minus. This operator changes the sign of the argument.\n","mysql> SELECT - 2;\n        -> -2\n","arithmetic-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (210,4,"COS","Syntax:\nCOS(X)\n\nReturns the cosine of X, where X is given in radians.\n","mysql> SELECT COS(PI());\n        -> -1.000000\n","mathematical-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (211,27,"DATE FUNCTION","Syntax:\nDATE(expr)\n\nExtracts the date part of the date or datetime expression expr.\n","mysql> SELECT DATE('2003-12-31 01:02:03');\n        -> '2003-12-31'\n","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (212,24,"RESET MASTER","Syntax:\nRESET MASTER\n\nDeletes all binary logs listed in the index file, resets the binary log\nindex file to be empty, and creates a new binary log file.\n\nThis statement was named FLUSH MASTER before MySQL 3.23.26.\n","","reset-master");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (213,4,"TAN","Syntax:\nTAN(X)\n\nReturns the tangent of X, where X is given in radians.\n","mysql> SELECT TAN(PI());\n        -> -1.2246063538224e-16\nmysql> SELECT TAN(PI()+1);\n        -> 1.5574077246549\n","mathematical-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (214,4,"PI","Syntax:\nPI()\n\nReturns the value of π (pi). The default number of decimal places\ndisplayed is five, but MySQL uses the full double-precision value\ninternally.\n","mysql> SELECT PI();\n        -> 3.141593\nmysql> SELECT PI()+0.000000000000000000;\n        -> 3.141592653589793116\n","mathematical-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (215,27,"WEEKOFYEAR","Syntax:\nWEEKOFYEAR(date)\n\nReturns the calendar week of the date as a number in the range from 1\nto 53. WEEKOFYEAR() is a compatibility function that is equivalent to\nWEEK(date,3).\n","mysql> SELECT WEEKOFYEAR('1998-02-20');\n        -> 8\n","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (216,4,"/","Syntax:\n/\n\nDivision:\n","mysql> SELECT 3/5;\n        -> 0.60\n","arithmetic-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (217,28,"MLINEFROMWKB","MLineFromWKB(wkb[,srid]), MultiLineStringFromWKB(wkb[,srid])\n\nConstructs a MULTILINESTRING value using its WKB representation and\nSRID.\n","","gis-wkb-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (218,4,"LOG2","Syntax:\nLOG2(X)\n\nReturns the base-2 logarithm of X.\n","mysql> SELECT LOG2(65536);\n        -> 16.000000\nmysql> SELECT LOG2(-100);\n        -> NULL\n","mathematical-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (219,27,"SUBTIME","Syntax:\nSUBTIME(expr,expr2)\n\nSUBTIME() subtracts expr2 from expr and returns the result. expr is a\ntime or datetime expression, and expr2 is a time expression.\n","mysql> SELECT SUBTIME('1997-12-31 23:59:59.999999','1 1:1:1.000002');\n        -> '1997-12-30 22:58:58.999997'\nmysql> SELECT SUBTIME('01:00:00.999999', '02:00:00.999998');\n        -> '-00:59:59.999999'\n","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (220,10,"UNCOMPRESSED_LENGTH","Syntax:\nUNCOMPRESSED_LENGTH(compressed_string)\n\nReturns the length that the compressed string had before being\ncompressed.\n","mysql> SELECT UNCOMPRESSED_LENGTH(COMPRESS(REPEAT('a',30)));\n        -> 30\n","encryption-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (221,34,"DROP TABLE","Syntax:\nDROP [TEMPORARY] TABLE [IF EXISTS]\n    tbl_name [, tbl_name] ...\n    [RESTRICT | CASCADE]\n\nDROP TABLE removes one or more tables. You must have the DROP privilege\nfor each table. All table data and the table definition are removed, so\nbe careful with this statement!\n\nIn MySQL 3.22 or later, you can use the keywords IF EXISTS to prevent\nan error from occurring for tables that do not exist. As of MySQL 4.1,\na NOTE is generated for each non-existent table when using IF EXISTS.\nSee [show-warnings].\n\nRESTRICT and CASCADE are allowed to make porting easier. For the\nmoment, they do nothing.\n\nNote: DROP TABLE automatically commits the current active transaction,\nunless you are using MySQL 4.1 or higher and the TEMPORARY keyword.\n","","drop-table");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (222,24,"SHOW CREATE TABLE","Syntax:\nSHOW CREATE TABLE tbl_name\n\nShows the CREATE TABLE statement that creates the given table. It was\nadded in MySQL 3.23.20.\nSHOW CREATE TABLE quotes table and column names according to the value\nof the SQL_QUOTE_SHOW_CREATE option. See [set-option].\n","mysql> SHOW CREATE TABLE t\\G\n*************************** 1. row ***************************\n       Table: t\nCreate Table: CREATE TABLE t (\n  id INT(11) default NULL auto_increment,\n  s char(60) default NULL,\n  PRIMARY KEY (id)\n) ENGINE=MyISAM\n","show-create-table");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (223,24,"DUAL","From MySQL 4.1.0 on, you are allowed to specify DUAL as a dummy table\nname in situations where no tables are referenced:\n\nmysql> SELECT 1 + 1 FROM DUAL;\n        -> 2\n\nDUAL is purely for compatibility with some other database servers that\nrequire a FROM clause. MySQL does not require the clause if no tables\nare referenced.\n","","select");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (224,32,"INSTR","Syntax:\nINSTR(str,substr)\n\nReturns the position of the first occurrence of substring substr in\nstring str. This is the same as the two-argument form of LOCATE(),\nexcept that the order of the arguments is reversed.\n","mysql> SELECT INSTR('foobarbar', 'bar');\n        -> 4\nmysql> SELECT INSTR('xbar', 'foobar');\n        -> 0\n","string-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (225,27,"NOW","Syntax:\nNOW()\n\nReturns the current date and time as a value in 'YYYY-MM-DD HH:MM:SS'\nor YYYYMMDDHHMMSS format, depending on whether the function is used in\na string or numeric context.\n","mysql> SELECT NOW();\n        -> '1997-12-15 23:50:26'\nmysql> SELECT NOW() + 0;\n        -> 19971215235026\n","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (226,24,"SHOW ENGINES","Syntax:\nSHOW [STORAGE] ENGINES\n\nSHOW ENGINES displays status information about the the server's storage\nengines. This is particularly useful for checking whether a storage\nengine is supported, or to see what the default engine is. This\nstatement is implemented in MySQL 4.1.2. SHOW TABLE TYPES is a\ndeprecated synonym.\n","","show-engines");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (227,17,">=","Syntax:\n>=\n\nGreater than or equal:\n","mysql> SELECT 2 >= 2;\n        -> 1\n","comparison-operators");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (228,4,"EXP","Syntax:\nEXP(X)\n\nReturns the value of e (the base of natural logarithms) raised to the\npower of X.\n","mysql> SELECT EXP(2);\n        -> 7.389056\nmysql> SELECT EXP(-2);\n        -> 0.135335\n","mathematical-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (229,10,"SHA","Syntax:\nSHA1(str), SHA(str)\n\nCalculates an SHA-1 160-bit checksum for the string, as described in\nRFC 3174 (Secure Hash Algorithm). The value is returned as a binary\nstring of 40 hex digits, or NULL if the argument was NULL. One of the\npossible uses for this function is as a hash key. You can also use it\nas a cryptographic function for storing passwords. SHA() is synonymous\nwith SHA1().\n","mysql> SELECT SHA1('abc');\n        -> 'a9993e364706816aba3e25717850c26c9cd0d89d'\n","encryption-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (230,20,"LONGBLOB","LONGBLOB\n\nA BLOB column with a maximum length of 4,294,967,295 or 4GB (232 - 1)\nbytes. Up to MySQL 3.23, the client/server protocol and MyISAM tables\nhad a limit of 16MB per communication packet or table row. From MySQL\n4.0, the maximum allowed length of LONGBLOB columns depends on the\nconfigured maximum packet size in the client/server protocol and\navailable memory.\n","","string-type-overview");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (231,11,"POINTN","PointN(ls,N)\n\nReturns the N-th Point in the Linestring value ls. Points are numbered\nbeginning with 1.\n","mysql> SET @ls = 'LineString(1 1,2 2,3 3)';\nmysql> SELECT AsText(PointN(GeomFromText(@ls),2));\n+-------------------------------------+\n| AsText(PointN(GeomFromText(@ls),2)) |\n+-------------------------------------+\n| POINT(2 2)                          |\n+-------------------------------------+\n","linestring-property-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (232,20,"YEAR DATA TYPE","YEAR[(2|4)]\n\nA year in two-digit or four-digit format. The default is four-digit\nformat. In four-digit format, the allowable values are 1901 to 2155,\nand 0000. In two-digit format, the allowable values are 70 to 69,\nrepresenting years from 1970 to 2069. MySQL displays YEAR values in\nYYYY format, but allows you to assign values to YEAR columns using\neither strings or numbers. The YEAR type is unavailable prior to MySQL\n3.22.\n","","date-and-time-type-overview");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (233,14,"SUM","Syntax:\nSUM(expr)\n\nReturns the sum of expr. If the return set has no rows, SUM() returns\nNULL.\n\nSUM() returns NULL if there were no matching rows.\n","","group-by-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (234,32,"OCT","Syntax:\nOCT(N)\n\nReturns a string representation of the octal value of N, where N is a\nlonglong (BIGINT) number. This is equivalent to CONV(N,10,8). Returns\nNULL if N is NULL.\n","mysql> SELECT OCT(12);\n        -> '14'\n","string-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (235,27,"SYSDATE","Syntax:\nSYSDATE()\n\nReturns the current date and time as a value in 'YYYY-MM-DD HH:MM:SS'\nor YYYYMMDDHHMMSS format, depending on whether the function is used in\na string or numeric context.\n","","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (236,28,"ASBINARY","AsBinary(g)\n\nConverts a value in internal geometry format to its WKB representation\nand returns the binary result.\n","SELECT AsBinary(g) FROM geom;\n","functions-to-convert-geometries-between-formats");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (237,32,"REPEAT FUNCTION","Syntax:\nREPEAT(str,count)\n\nReturns a string consisting of the string str repeated count times. If\ncount is less than 1, returns an empty string. Returns NULL if str or\ncount are NULL.\n","mysql> SELECT REPEAT('MySQL', 3);\n        -> 'MySQLMySQLMySQL'\n","string-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (238,24,"SHOW TABLES","Syntax:\nSHOW TABLES [FROM db_name] [LIKE 'pattern']\n\nSHOW TABLES lists the non-TEMPORARY tables in a given database. You can\nalso get this list using the mysqlshow db_name command.\n\nThe output from SHOW TABLES contains a single column of table names.\n","","show-tables");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (239,27,"MAKEDATE","Syntax:\nMAKEDATE(year,dayofyear)\n\nReturns a date, given year and day-of-year values. dayofyear must be\ngreater than 0 or the result is NULL.\n","mysql> SELECT MAKEDATE(2001,31), MAKEDATE(2001,32);\n        -> '2001-01-31', '2001-02-01'\nmysql> SELECT MAKEDATE(2001,365), MAKEDATE(2004,365);\n        -> '2001-12-31', '2004-12-30'\nmysql> SELECT MAKEDATE(2001,0);\n        -> NULL\n","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (240,32,"BINARY OPERATOR","Syntax:\nBINARY\n\nThe BINARY operator casts the string following it to a binary string.\nThis is an easy way to force a column comparison to be done byte by\nbyte rather than character by character. This causes the comparison to\nbe case sensitive even if the column isn't defined as BINARY or BLOB.\nBINARY also causes trailing spaces to be significant.\n","mysql> SELECT 'a' = 'A';\n        -> 1\nmysql> SELECT BINARY 'a' = 'A';\n        -> 0\nmysql> SELECT 'a' = 'a ';\n        -> 1\nmysql> SELECT BINARY 'a' = 'a ';\n        -> 0\n","cast-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (241,5,"MBROVERLAPS","MBROverlaps(g1,g2)\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of\nthe two geometries g1 and g2 overlap.\n","","relations-on-geometry-mbr");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (242,32,"SOUNDEX","Syntax:\nSOUNDEX(str)\n\nReturns a soundex string from str. Two strings that sound almost the\nsame should have identical soundex strings. A standard soundex string\nis four characters long, but the SOUNDEX() function returns an\narbitrarily long string. You can use SUBSTRING() on the result to get a\nstandard soundex string. All non-alphabetic characters in str are\nignored. All international alphabetic characters outside the A-Z range\nare treated as vowels.\n","mysql> SELECT SOUNDEX('Hello');\n        -> 'H400'\nmysql> SELECT SOUNDEX('Quadratically');\n        -> 'Q36324'\n","string-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (243,24,"SHOW MASTER LOGS","Syntax:\nSHOW MASTER LOGS\nSHOW BINARY LOGS\n\nLists the binary log files on the server. This statement is used as\npart of the procedure described in [purge-master-logs], that shows how\nto determine which logs can be purged.\n\nmysql> SHOW BINARY LOGS;\n+---------------+-----------+\n| Log_name      | File_size |\n+---------------+-----------+\n| binlog.000015 |    724935 |\n| binlog.000016 |    733481 |\n+---------------+-----------+\n","","show-master-logs");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (244,5,"MBRTOUCHES","MBRTouches(g1,g2)\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of\nthe two geometries g1 and g2 touch.\n","","relations-on-geometry-mbr");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (245,24,"INSERT SELECT","Syntax:\nINSERT [LOW_PRIORITY | HIGH_PRIORITY] [IGNORE]\n    [INTO] tbl_name [(col_name,...)]\n    SELECT ...\n    [ ON DUPLICATE KEY UPDATE col_name=expr, ... ]\n\nWith INSERT ... SELECT, you can quickly insert many rows into a table\nfrom one or many tables. For example:\n\nINSERT INTO tbl_temp2 (fld_id)\n  SELECT tbl_temp1.fld_order_id\n  FROM tbl_temp1 WHERE tbl_temp1.fld_order_id > 100;\n","","insert-select");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (246,20,"VARBINARY","VARBINARY(M)\n\nThe VARBINARY type is similar to the VARCHAR type, but stores binary\nbyte strings rather than non-binary character strings.\n\nThis type was added in MySQL 4.1.2.\n","","string-type-overview");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (247,24,"LOAD INDEX","Syntax:\nLOAD INDEX INTO CACHE\n  tbl_index_list [, tbl_index_list] ...\n\ntbl_index_list:\n  tbl_name\n    [[INDEX|KEY] (index_name[, index_name] ...)]\n    [IGNORE LEAVES]\n\nThe LOAD INDEX INTO CACHE statement preloads a table index into the key\ncache to which it has been assigned by an explicit CACHE INDEX\nstatement, or into the default key cache otherwise. LOAD INDEX INTO\nCACHE is used only for MyISAM tables.\n\nThe IGNORE LEAVES modifier causes only blocks for the non-leaf nodes of\nthe index to be preloaded.\n","","load-index");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (248,24,"UNION","Syntax:\nSELECT ...\nUNION [ALL | DISTINCT] SELECT ...\n[UNION [ALL | DISTINCT] SELECT ...]\n\nUNION is used to combine the result from multiple SELECT statements\ninto a single result set. UNION is available from MySQL 4.0.0 on.\n\nThe column names from the first SELECT statement are used as the column\nnames for the results returned. Selected columns listed in\ncorresponding positions of each SELECT statement should have the same\ndata type. (For example, the first column selected by the first\nstatement should have the same type as the first column selected by the\nother statements.)\n","","union");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (249,27,"TO_DAYS","Syntax:\nTO_DAYS(date)\n\nGiven a date date, returns a day number (the number of days since year\n0).\n","mysql> SELECT TO_DAYS(950501);\n        -> 728779\nmysql> SELECT TO_DAYS('1997-10-07');\n        -> 729669\n","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (250,32,"NOT REGEXP","Syntax:\nexpr NOT REGEXP pat, expr NOT RLIKE pat\n\nThis is the same as NOT (expr REGEXP pat).\n","","string-comparison-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (251,24,"SHOW INDEX","Syntax:\nSHOW INDEX FROM tbl_name [FROM db_name]\n\nSHOW INDEX returns table index information. The format resembles that\nof the SQLStatistics call in ODBC.\nYou can use db_name.tbl_name as an alternative to the tbl_name FROM\ndb_name syntax. These two statements are equivalent:\n\nSHOW INDEX FROM mytable FROM mydb;\nSHOW INDEX FROM mydb.mytable;\n\nSHOW KEYS is a synonym for SHOW INDEX. You can also list a table's\nindexes with the mysqlshow -k db_name tbl_name command.\n","","show-index");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (252,24,"SHOW CREATE DATABASE","Syntax:\nSHOW CREATE DATABASE db_name\n\nShows the CREATE DATABASE statement that creates the given database. It\nwas added in MySQL 4.1.\n","mysql> SHOW CREATE DATABASE test\\G\n*************************** 1. row ***************************\n       Database: test\nCreate Database: CREATE DATABASE `test`\n                 /*!40100 DEFAULT CHARACTER SET latin1 */\n","show-create-database");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (253,17,"NOT IN","Syntax:\nexpr NOT IN (value,...)\n\nThis is the same as NOT (expr IN (value,...)).\n","","comparison-operators");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (254,12,"!","Syntax:\nNOT, !\n\nLogical NOT. Evaluates to 1 if the operand is 0, to 0 if the operand is\nnon-zero, and NOT NULL returns NULL.\n","mysql> SELECT NOT 10;\n        -> 0\nmysql> SELECT NOT 0;\n        -> 1\nmysql> SELECT NOT NULL;\n        -> NULL\nmysql> SELECT ! (1+1);\n        -> 0\nmysql> SELECT ! 1+1;\n        -> 1\n","logical-operators");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (255,20,"DOUBLE","DOUBLE[(M,D)] [UNSIGNED] [ZEROFILL]\n\nA normal-size (double-precision) floating-point number. Allowable\nvalues are -1.7976931348623157E+308 to -2.2250738585072014E-308, 0, and\n2.2250738585072014E-308 to 1.7976931348623157E+308. These are the\ntheoretical limits, based on the IEEE standard. The actual range might\nbe slightly smaller depending on your hardware or operating system.\n\nM is the total number of decimal digits and D is the number of digits\nfollowing the decimal point. If M and D are omitted, values are stored\nto the limits allowed by the hardware. A double-precision\nfloating-point number is accurate to approximately 15 decimal places.\n\nUNSIGNED, if specified, disallows negative values.\n","","numeric-type-overview");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (256,20,"TIME","TIME\n\nA time. The range is '-838:59:59' to '838:59:59'. MySQL displays TIME\nvalues in 'HH:MM:SS' format, but allows you to assign values to TIME\ncolumns using either strings or numbers.\n","","date-and-time-type-overview");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (257,12,"&&","Syntax:\nAND, &&\n\nLogical AND. Evaluates to 1 if all operands are non-zero and not NULL,\nto 0 if one or more operands are 0, otherwise NULL is returned.\n","mysql> SELECT 1 && 1;\n        -> 1\nmysql> SELECT 1 && 0;\n        -> 0\nmysql> SELECT 1 && NULL;\n        -> NULL\nmysql> SELECT 0 && NULL;\n        -> 0\nmysql> SELECT NULL && 0;\n        -> 0\n","logical-operators");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (258,9,"X","X(p)\n\nReturns the X-coordinate value for the point p as a double-precision\nnumber.\n","mysql> SET @pt = 'Point(56.7 53.34)';\nmysql> SELECT X(GeomFromText(@pt));\n+----------------------+\n| X(GeomFromText(@pt)) |\n+----------------------+\n|                 56.7 |\n+----------------------+\n","point-property-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (259,15,"FOUND_ROWS","Syntax:\nFOUND_ROWS()\n\nA SELECT statement may include a LIMIT clause to restrict the number of\nrows the server returns to the client. In some cases, it is desirable\nto know how many rows the statement would have returned without the\nLIMIT, but without running the statement again. To obtain this row\ncount, include a SQL_CALC_FOUND_ROWS option in the SELECT statement,\nand then invoke FOUND_ROWS() afterward:\n","mysql> SELECT SQL_CALC_FOUND_ROWS * FROM tbl_name\n    -> WHERE id > 100 LIMIT 10;\nmysql> SELECT FOUND_ROWS();\n","information-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (260,15,"SYSTEM_USER","Syntax:\nSYSTEM_USER()\n\nSYSTEM_USER() is a synonym for USER().\n","","information-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (261,25,"CROSSES","Crosses(g1,g2)\n\nReturns 1 if g1 spatially crosses g2. Returns NULL if g1 is a Polygon\nor a MultiPolygon, or if g2 is a Point or a MultiPoint. Otherwise,\nreturns 0.\n\nThe term spatially crosses denotes a spatial relation between two given\ngeometries that has the following properties:\n\no The two geometries intersect\n\no Their intersection results in a geometry that has a dimension that is\n  one less than the maximum dimension of the two given geometries\n\no Their intersection is not equal to either of the two given geometries\n","","functions-that-test-spatial-relationships-between-geometries");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (262,24,"TRUNCATE TABLE","Syntax:\nTRUNCATE [TABLE] tbl_name\n\nTRUNCATE TABLE empties a table completely. Logically, this is\nequivalent to a DELETE statement that deletes all rows, but there are\npractical differences under some circumstances.\n\nFor InnoDB, TRUNCATE TABLE is mapped to DELETE, so there is no\ndifference.\n\nFor other storage engines, TRUNCATE TABLE differs from DELETE in the\nfollowing ways from MySQL 4.0 onward:\n\no Truncate operations drop and re-create the table, which is much\n  faster than deleting rows one by one.\n\no Truncate operations are not transaction-safe; an error occurs when\n  attempting one in the course of an active transaction or active table\n  lock.\n\no The number of deleted rows is not returned.\n\no As long as the table format file tbl_name.frm is valid, the table can\n  be re-created as an empty table with TRUNCATE TABLE, even if the data\n  or index files have become corrupted.\n\no The table handler does not remember the last used AUTO_INCREMENT\n  value, but starts counting from the beginning. This is true even for\n  MyISAM and InnoDB, which normally do not reuse sequence values.\n\nIn MySQL 3.23, TRUNCATE TABLE is mapped to COMMIT; DELETE FROM\ntbl_name, so it behaves like DELETE. See [delete].\n\nTRUNCATE TABLE is an Oracle SQL extension. This statement was added in\nMySQL 3.23.28, although from 3.23.28 to 3.23.32, the keyword TABLE must\nbe omitted.\n","","truncate");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (263,27,"CURRENT_DATE","Syntax:\nCURRENT_DATE, CURRENT_DATE()\n\nCURRENT_DATE and CURRENT_DATE() are synonyms for CURDATE().\n","","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (264,14,"BIT_XOR","Syntax:\nBIT_XOR(expr)\n\nReturns the bitwise XOR of all bits in expr. The calculation is\nperformed with 64-bit (BIGINT) precision.\n","","group-by-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (265,2,"AREA","Area(poly)\n\nReturns as a double-precision number the area of the Polygon value\npoly, as measured in its spatial reference system.\n","mysql> SET @poly = 'Polygon((0 0,0 3,3 0,0 0),(1 1,1 2,2 1,1 1))';\nmysql> SELECT Area(GeomFromText(@poly));\n+---------------------------+\n| Area(GeomFromText(@poly)) |\n+---------------------------+\n|                         4 |\n+---------------------------+\n","polygon-property-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (266,24,"START SLAVE","Syntax:\nSTART SLAVE [thread_type [, thread_type] ... ]\nSTART SLAVE [SQL_THREAD] UNTIL\n    MASTER_LOG_FILE = 'log_name', MASTER_LOG_POS = log_pos\nSTART SLAVE [SQL_THREAD] UNTIL\n    RELAY_LOG_FILE = 'log_name', RELAY_LOG_POS = log_pos\n\nthread_type: IO_THREAD | SQL_THREAD\n\nSTART SLAVE with no thread_type options starts both of the slave\nthreads. The I/O thread reads queries from the master server and stores\nthem in the relay log. The SQL thread reads the relay log and executes\nthe queries. START SLAVE requires the SUPER privilege.\n\nIf START SLAVE succeeds in starting the slave threads, it returns\nwithout any error. However, even in that case, it might be that the\nslave threads start and then later stop (for example, because they do\nnot manage to connect to the master or read its binary logs, or some\nother problem). START SLAVE does not warn you about this. You must\ncheck the slave's error log for error messages generated by the slave\nthreads, or check that they are running satisfactorily with SHOW SLAVE\nSTATUS.\n","","start-slave");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (267,24,"FLUSH","Syntax:\nFLUSH [LOCAL | NO_WRITE_TO_BINLOG] flush_option [, flush_option] ...\n\nThe FLUSH statement clears or reloads various internal caches used by\nMySQL. To execute FLUSH, you must have the RELOAD privilege.\n\nThe RESET statement is similar to FLUSH. See [reset].\n","","flush");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (268,24,"SHOW WARNINGS","Syntax:\nSHOW WARNINGS [LIMIT [offset,] row_count]\nSHOW COUNT(*) WARNINGS\n\nSHOW WARNINGS shows the error, warning, and note messages that resulted\nfrom the last statement that generated messages, or nothing if the last\nstatement that used a table generated no messages. This statement is\nimplemented as of MySQL 4.1.0. A related statement, SHOW ERRORS, shows\nonly the errors. See [show-errors].\n\nThe list of messages is reset for each new statement that uses a table.\n\nThe SHOW COUNT(*) WARNINGS statement displays the total number of\nerrors, warnings, and notes. You can also retrieve this number from the\nwarning_count variable:\n\nSHOW COUNT(*) WARNINGS;\nSELECT @@warning_count;\n\nThe value of warning_count might be greater than the number of messages\ndisplayed by SHOW WARNINGS if the max_error_count system variable is\nset so low that not all messages are stored. An example shown later in\nthis section demonstrates how this can happen.\n\nThe LIMIT clause has the same syntax as for the SELECT statement. See\n[select].\n","","show-warnings");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (269,23,"DESCRIBE","Syntax:\n{DESCRIBE | DESC} tbl_name [col_name | wild]\n\nDESCRIBE provides information about the columns in a table. It is a\nshortcut for SHOW COLUMNS FROM. (See [show-columns].)\n","","describe");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (270,8,"DROP USER","Syntax:\nDROP USER user [, user] ...\n\nThe DROP USER statement removes one or more MySQL accounts. To use it,\nyou must have the DELETE privilege for the mysql database. Each account\nis named using the same format as for the GRANT statement; for example,\n'jeffrey'@'localhost'. The user and host parts of the account name\ncorrespond to the User and Host column values of the user table row for\nthe account.\n","","drop-user");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (271,24,"SHOW CHARACTER SET","Syntax:\nSHOW CHARACTER SET [LIKE 'pattern']\n\nThe SHOW CHARACTER SET statement shows all available character sets. It\ntakes an optional LIKE clause that indicates which character set names\nto match. For example:\n\nmysql> SHOW CHARACTER SET LIKE 'latin%';\n+---------+-----------------------------+-------------------+--------+\n| Charset | Description                 | Default collation | Maxlen |\n+---------+-----------------------------+-------------------+--------+\n| latin1  | cp1252 West European        | latin1_swedish_ci |      1 |\n| latin2  | ISO 8859-2 Central European | latin2_general_ci |      1 |\n| latin5  | ISO 8859-9 Turkish          | latin5_turkish_ci |      1 |\n| latin7  | ISO 8859-13 Baltic          | latin7_general_ci |      1 |\n+---------+-----------------------------+-------------------+--------+\n\nThe Maxlen column shows the maximum number of bytes required to store\none character.\n","","show-character-set");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (272,32,"SUBSTRING","Syntax:\nSUBSTRING(str,pos), SUBSTRING(str FROM pos), SUBSTRING(str,pos,len),\nSUBSTRING(str FROM pos FOR len)\n\nThe forms without a len argument return a substring from string str\nstarting at position pos. The forms with a len argument return a\nsubstring len characters long from string str, starting at position\npos. The forms that use FROM are standard SQL syntax. Beginning with\nMySQL 4.1.0, it is possible to use a negative value for pos. In this\ncase, the beginning of the substring is pos characters from the end of\nthe string, rather than the beginning. A negative value may be used for\npos in any of the forms of this function.\n","mysql> SELECT SUBSTRING('Quadratically',5);\n        -> 'ratically'\nmysql> SELECT SUBSTRING('foobarbar' FROM 4);\n        -> 'barbar'\nmysql> SELECT SUBSTRING('Quadratically',5,6);\n        -> 'ratica'        \nmysql> SELECT SUBSTRING('Sakila', -3);\n        -> 'ila'        \nmysql> SELECT SUBSTRING('Sakila', -5, 3);\n        -> 'aki'\nmysql> SELECT SUBSTRING('Sakila' FROM -4 FOR 2);\n        -> 'ki'\n","string-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (273,31,"ISEMPTY","IsEmpty(g)\n\nReturns 1 if the geometry value g is the empty geometry, 0 if it is not\nempty, and -1 if the argument is NULL. If the geometry is empty, it\nrepresents the empty point set.\n","","general-geometry-property-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (274,32,"LTRIM","Syntax:\nLTRIM(str)\n\nReturns the string str with leading space characters removed.\n","mysql> SELECT LTRIM('  barbar');\n        -> 'barbar'\n","string-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (275,25,"INTERSECTS","Intersects(g1,g2)\n\nReturns 1 or 0 to indicate whether g1 spatially intersects g2.\n","","functions-that-test-spatial-relationships-between-geometries");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (276,5,"MBRDISJOINT","MBRDisjoint(g1,g2)\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of\nthe two geometries g1 and g2 are disjoint (do not intersect).\n","","relations-on-geometry-mbr");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (277,13,"VALUES","Syntax:\nVALUES(col_name)\n\nIn an INSERT ... ON DUPLICATE KEY UPDATE statement, you can use the\nVALUES(col_name) function in the UPDATE clause to refer to column\nvalues from the INSERT portion of the statement. In other words,\nVALUES(col_name) in the UPDATE clause refers to the value of col_name\nthat would be inserted, had no duplicate-key conflict occurred. This\nfunction is especially useful in multiple-row inserts. The VALUES()\nfunction is meaningful only in INSERT ... ON DUPLICATE KEY UPDATE\nstatements and returns NULL otherwise. [insert-on-duplicate].\n","mysql> INSERT INTO table (a,b,c) VALUES (1,2,3),(4,5,6)\n    -> ON DUPLICATE KEY UPDATE c=VALUES(a)+VALUES(b);\n","miscellaneous-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (278,32,"SUBSTRING_INDEX","Syntax:\nSUBSTRING_INDEX(str,delim,count)\n\nReturns the substring from string str before count occurrences of the\ndelimiter delim. If count is positive, everything to the left of the\nfinal delimiter (counting from the left) is returned. If count is\nnegative, everything to the right of the final delimiter (counting from\nthe right) is returned. SUBSTRING_INDEX() performs a case-sensitive\nmatch when searching for delim.\n","mysql> SELECT SUBSTRING_INDEX('www.mysql.com', '.', 2);\n        -> 'www.mysql'\nmysql> SELECT SUBSTRING_INDEX('www.mysql.com', '.', -2);\n        -> 'mysql.com'\n","string-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (279,10,"ENCODE","Syntax:\nENCODE(str,pass_str)\n\nEncrypt str using pass_str as the password. To decrypt the result, use\nDECODE().\n\nThe result is a binary string of the same length as str.\n","","encryption-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (280,4,"TRUNCATE","Syntax:\nTRUNCATE(X,D)\n\nReturns the number X, truncated to D decimal places. If D is 0, the\nresult has no decimal point or fractional part. D can be negative to\ncause D digits left of the decimal point of the value X to become zero.\n","mysql> SELECT TRUNCATE(1.223,1);\n        -> 1.2\nmysql> SELECT TRUNCATE(1.999,1);\n        -> 1.9\nmysql> SELECT TRUNCATE(1.999,0);\n        -> 1\nmysql> SELECT TRUNCATE(-1.999,1);\n        -> -1.9\nmysql> SELECT TRUNCATE(122,-2);\n       -> 100\nmysql> SELECT TRUNCATE(10.28*100,0);\n       -> 1027\n","mathematical-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (281,24,"SHOW","SHOW has many forms that provide information about databases, tables,\ncolumns, or status information about the server. This section describes\nthose following:\n\nSHOW [FULL] COLUMNS FROM tbl_name [FROM db_name] [LIKE 'pattern']\nSHOW CREATE DATABASE db_name\nSHOW CREATE TABLE tbl_name\nSHOW DATABASES [LIKE 'pattern']\nSHOW ENGINE engine_name {LOGS | STATUS }\nSHOW [STORAGE] ENGINES\nSHOW ERRORS [LIMIT [offset,] row_count]\nSHOW GRANTS FOR user\nSHOW INDEX FROM tbl_name [FROM db_name]\nSHOW INNODB STATUS\nSHOW [BDB] LOGS\nSHOW PRIVILEGES\nSHOW [FULL] PROCESSLIST\nSHOW [GLOBAL | SESSION] STATUS [LIKE 'pattern']\nSHOW TABLE STATUS [FROM db_name] [LIKE 'pattern']\nSHOW [OPEN] TABLES [FROM db_name] [LIKE 'pattern']\nSHOW [GLOBAL | SESSION] VARIABLES [LIKE 'pattern']\nSHOW WARNINGS [LIMIT [offset,] row_count]\n\nThe SHOW statement also has forms that provide information about\nreplication master and slave servers and are described in\n[replication-sql]:\n\nSHOW BINLOG EVENTS\nSHOW MASTER LOGS\nSHOW MASTER STATUS\nSHOW SLAVE HOSTS\nSHOW SLAVE STATUS\n\nIf the syntax for a given SHOW statement includes a LIKE 'pattern'\npart, 'pattern' is a string that can contain the SQL `%' and `_'\nwildcard characters. The pattern is useful for restricting statement\noutput to matching values.\n","","show");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (282,17,"GREATEST","Syntax:\nGREATEST(value1,value2,...)\n\nWith two or more arguments, returns the largest (maximum-valued)\nargument. The arguments are compared using the same rules as for\nLEAST().\n","mysql> SELECT GREATEST(2,0);\n        -> 2\nmysql> SELECT GREATEST(34.0,3.0,5.0,767.0);\n        -> 767.0\nmysql> SELECT GREATEST('B','A','C');\n        -> 'C'\n","comparison-operators");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (283,32,"OCTETLENGTH","Syntax:\nOCTET_LENGTH(str)\n\nOCTET_LENGTH() is a synonym for LENGTH().\n","","string-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (284,24,"SHOW VARIABLES","Syntax:\nSHOW [GLOBAL | SESSION] VARIABLES [LIKE 'pattern']\n\nSHOW VARIABLES shows the values of MySQL system variables. This\ninformation also can be obtained using the mysqladmin variables\ncommand.\n\nThe GLOBAL and SESSION modifiers are new in MySQL 4.0.3. With the\nGLOBAL modifier, SHOW VARIABLES displays the values that are used for\nnew connections to MySQL. With SESSION, it displays the values that are\nin effect for the current connection. If no modifier is present, the\ndefault is SESSION. LOCAL is a synonym for SESSION.\nWith a LIKE clause, the statement displays only rows for those\nvariables with names that match the pattern. To obtain the row for a\nspecific variable, use a LIKE clause as shown:\n\nSHOW VARIABLES LIKE 'max_join_size';\nSHOW SESSION VARIABLES LIKE 'max_join_size';\n\nTo get a list of variables whose name match a pattern, use the `%'\nwildcard character in a LIKE clause:\n\nSHOW VARIABLES LIKE '%size%';\nSHOW GLOBAL VARIABLES LIKE '%size%';\n\nWildcard characters can be used in any position within the pattern to\nbe matched. Strictly speaking, because `_' is a wildcard that matches\nany single character, you should escape it as `\\_' to match it\nliterally. In practice, this is rarely necessary.\n","","show-variables");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (285,27,"SECOND","Syntax:\nSECOND(time)\n\nReturns the second for time, in the range 0 to 59.\n","mysql> SELECT SECOND('10:05:03');\n        -> 3\n","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (286,14,"BIT_AND","Syntax:\nBIT_AND(expr)\n\nReturns the bitwise AND of all bits in expr. The calculation is\nperformed with 64-bit (BIGINT) precision.\n","","group-by-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (287,4,"ATAN2","Syntax:\nATAN(Y,X), ATAN2(Y,X)\n\nReturns the arc tangent of the two variables X and Y. It is similar to\ncalculating the arc tangent of Y / X, except that the signs of both\narguments are used to determine the quadrant of the result.\n","mysql> SELECT ATAN(-2,2);\n        -> -0.785398\nmysql> SELECT ATAN2(PI(),0);\n        -> 1.570796\n","mathematical-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (288,5,"MBRCONTAINS","MBRContains(g1,g2)\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangle of g1\ncontains the Minimum Bounding Rectangle of g2.\n","mysql> SET @g1 = GeomFromText('Polygon((0 0,0 3,3 3,3 0,0 0))');\nmysql> SET @g2 = GeomFromText('Point(1 1)');\nmysql> SELECT MBRContains(@g1,@g2), MBRContains(@g2,@g1);\n----------------------+----------------------+\n| MBRContains(@g1,@g2) | MBRContains(@g2,@g1) |\n+----------------------+----------------------+\n|                    1 |                    0 |\n+----------------------+----------------------+\n","relations-on-geometry-mbr");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (289,27,"HOUR","Syntax:\nHOUR(time)\n\nReturns the hour for time. The range of the return value is 0 to 23 for\ntime-of-day values. However, the range of TIME values actually is much\nlarger, so HOUR can return values greater than 23.\n","mysql> SELECT HOUR('10:05:03');\n        -> 10\nmysql> SELECT HOUR('272:59:59');\n        -> 272\n","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (290,24,"SELECT","Syntax:\nSELECT\n    [ALL | DISTINCT | DISTINCTROW ]\n      [HIGH_PRIORITY]\n      [STRAIGHT_JOIN]\n      [SQL_SMALL_RESULT] [SQL_BIG_RESULT] [SQL_BUFFER_RESULT]\n      [SQL_CACHE | SQL_NO_CACHE] [SQL_CALC_FOUND_ROWS]\n    select_expr, ...\n    [FROM table_references\n    [WHERE where_condition]\n    [GROUP BY {col_name | expr | position}\n      [ASC | DESC], ... [WITH ROLLUP]]\n    [HAVING where_condition]\n    [ORDER BY {col_name | expr | position}\n      [ASC | DESC], ...]\n    [LIMIT {[offset,] row_count | row_count OFFSET offset}]\n    [PROCEDURE procedure_name(argument_list)]\n    [INTO OUTFILE 'file_name' export_options\n      | INTO DUMPFILE 'file_name']\n    [FOR UPDATE | LOCK IN SHARE MODE]]\n\nSELECT is used to retrieve rows selected from one or more tables.\nSupport for UNION statements and subqueries is available as of MySQL\n4.0 and 4.1, respectively. See [union], and [subqueries].\n\nThe most commonly used clauses of SELECT statements are these:\n\no Each select_expr indicates a column that you want to retrieve. There\n  must be at least one select_expr.\n\no table_references indicates the table or tables from which to retrieve\n  rows. Its syntax is described in [join].\n\no The WHERE clause, if given, indicates the condition or conditions\n  that rows must satisfy to be selected. where_condition is an\n  expression that evaluates to true for each row to be selected. The\n  statement selects all rows if there is no WHERE clause.\n\n  In the WHERE clause, you can use any of the functions and operators\n  that MySQL supports, except for aggregate (summary) functions. See\n  [functions].\n\nSELECT can also be used to retrieve rows computed without reference to\nany table.\n","","select");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (291,4,"COT","Syntax:\nCOT(X)\n\nReturns the cotangent of X.\n","mysql> SELECT COT(12);\n        -> -1.57267341\nmysql> SELECT COT(0);\n        -> NULL\n","mathematical-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (292,19,"BACKUP TABLE","Syntax:\nBACKUP TABLE tbl_name [, tbl_name] ... TO '/path/to/backup/directory'\n\nNote: This statement is deprecated. We are working on a better\nreplacement for it that will provide online backup capabilities. In the\nmeantime, the mysqlhotcopy script can be used instead.\n\nBACKUP TABLE copies to the backup directory the minimum number of table\nfiles needed to restore the table, after flushing any buffered changes\nto disk. The statement works only for MyISAM tables. It copies the .frm\ndefinition and .MYD data files. The .MYI index file can be rebuilt from\nthose two files. The directory should be specified as a full pathname.\nTo restore the table, use RESTORE TABLE.\n","","backup-table");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (293,32,"LOAD_FILE","Syntax:\nLOAD_FILE(file_name)\n\nReads the file and returns the file contents as a string. To use this\nfunction, the file must be located on the server host, you must specify\nthe full pathname to the file, and you must have the FILE privilege.\nThe file must be readable by all and its size less than\nmax_allowed_packet bytes.\n\nIf the file does not exist or cannot be read because one of the\npreceding conditions is not satisfied, the function returns NULL.\n","mysql> UPDATE t\n            SET blob_col=LOAD_FILE('/tmp/picture')\n            WHERE id=1;\n","string-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (294,3,"POINTFROMTEXT","PointFromText(wkt[,srid])\n\nConstructs a POINT value using its WKT representation and SRID.\n","","gis-wkt-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (295,24,"LOAD TABLE FROM MASTER","Syntax:\nLOAD TABLE tbl_name FROM MASTER\n\nTransfers a copy of the table from the master to the slave. This\nstatement is implemented mainly debugging LOAD DATA FROM MASTER\noperations. To use LOAD TABLE, the account used for connecting to the\nmaster server must have the RELOAD and SUPER privileges on the master\nand the SELECT privilege for the master table to load. On the slave\nside, the user that issues LOAD TABLE FROM MASTER must have privileges\nfor dropping and creating the table.\n\nThe conditions for LOAD DATA FROM MASTER apply here as well. For\nexample, LOAD TABLE FROM MASTER works only for MyISAM tables. The\ntimeout notes for LOAD DATA FROM MASTER apply as well.\n","","load-table-from-master");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (296,14,"GROUP_CONCAT","Syntax:\nGROUP_CONCAT(expr)\n\nThis function returns a string result with the concatenated non-NULL\nvalues from a group. It returns NULL if there are no non-NULL values.\nThe full syntax is as follows:\n\nGROUP_CONCAT([DISTINCT] expr [,expr ...]\n             [ORDER BY {unsigned_integer | col_name | expr}\n                 [ASC | DESC] [,col_name ...]]\n             [SEPARATOR str_val])\n","mysql> SELECT student_name,\n    ->     GROUP_CONCAT(test_score)\n    ->     FROM student\n    ->     GROUP BY student_name;\n","group-by-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (297,27,"DATE_FORMAT","Syntax:\nDATE_FORMAT(date,format)\n\nFormats the date value according to the format string.\n","mysql> SELECT DATE_FORMAT('1997-10-04 22:23:00', '%W %M %Y');\n        -> 'Saturday October 1997'\nmysql> SELECT DATE_FORMAT('1997-10-04 22:23:00', '%H:%i:%s');\n        -> '22:23:00'\nmysql> SELECT DATE_FORMAT('1997-10-04 22:23:00',\n                          '%D %y %a %d %m %b %j');\n        -> '4th 97 Sat 04 10 Oct 277'\nmysql> SELECT DATE_FORMAT('1997-10-04 22:23:00',\n                          '%H %k %I %r %T %S %w');\n        -> '22 22 10 10:23:00 PM 22:23:00 00 6'\nmysql> SELECT DATE_FORMAT('1999-01-01', '%X %V');\n        -> '1998 52'\nmysql> SELECT DATE_FORMAT('2006-06-00', '%d');\n        -> '00'\n","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (298,15,"BENCHMARK","Syntax:\nBENCHMARK(count,expr)\n\nThe BENCHMARK() function executes the expression expr repeatedly count\ntimes. It may be used to time how quickly MySQL processes the\nexpression. The result value is always 0. The intended use is from\nwithin the mysql client, which reports query execution times:\n","mysql> SELECT BENCHMARK(1000000,ENCODE('hello','goodbye'));\n+----------------------------------------------+\n| BENCHMARK(1000000,ENCODE('hello','goodbye')) |\n+----------------------------------------------+\n|                                            0 |\n+----------------------------------------------+\n1 row in set (4.74 sec)\n","information-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (299,27,"YEAR","Syntax:\nYEAR(date)\n\nReturns the year for date, in the range 1000 to 9999, or 0 for the\n\"zero\" date.\n","mysql> SELECT YEAR('98-02-03');\n        -> 1998\n","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (300,24,"SHOW ENGINE","Syntax:\nSHOW ENGINE engine_name {LOGS | STATUS }\n\nSHOW ENGINE displays log or status information about a storage engine.\nThe following statements currently are supported:\n\nSHOW ENGINE BDB LOGS\nSHOW ENGINE INNODB STATUS\n","","show-engine");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (301,13,"RELEASE_LOCK","Syntax:\nRELEASE_LOCK(str)\n\nReleases the lock named by the string str that was obtained with\nGET_LOCK(). Returns 1 if the lock was released, 0 if the lock was not\nestablished by this thread (in which case the lock is not released),\nand NULL if the named lock did not exist. The lock does not exist if it\nwas never obtained by a call to GET_LOCK() or if it has previously been\nreleased.\n\nThe DO statement is convenient to use with RELEASE_LOCK(). See [do].\n","","miscellaneous-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (302,17,"IS NULL","Syntax:\nIS NULL, IS NOT NULL\n\nTests whether a value is or is not NULL.\n","mysql> SELECT 1 IS NULL, 0 IS NULL, NULL IS NULL;\n        -> 0, 0, 1\nmysql> SELECT 1 IS NOT NULL, 0 IS NOT NULL, NULL IS NOT NULL;\n        -> 1, 1, 0\n","comparison-operators");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (303,27,"CONVERT_TZ","Syntax:\nCONVERT_TZ(dt,from_tz,to_tz)\n\nCONVERT_TZ() converts a datetime value dt from the time zone given by\nfrom_tz to the time zone given by to_tz and returns the resulting\nvalue. Time zones are specified as described in [time-zone-support].\nThis function returns NULL if the arguments are invalid.\n","mysql> SELECT CONVERT_TZ('2004-01-01 12:00:00','GMT','MET');\n        -> '2004-01-01 13:00:00'\nmysql> SELECT CONVERT_TZ('2004-01-01 12:00:00','+00:00','+10:00');\n        -> '2004-01-01 22:00:00'\n","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (304,27,"TIME_TO_SEC","Syntax:\nTIME_TO_SEC(time)\n\nReturns the time argument, converted to seconds.\n","mysql> SELECT TIME_TO_SEC('22:23:00');\n        -> 80580\nmysql> SELECT TIME_TO_SEC('00:39:38');\n        -> 2378\n","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (305,27,"WEEKDAY","Syntax:\nWEEKDAY(date)\n\nReturns the weekday index for date (0 = Monday, 1 = Tuesday, ... 6 =\nSunday).\n","mysql> SELECT WEEKDAY('1998-02-03 22:23:00');\n        -> 1\nmysql> SELECT WEEKDAY('1997-11-05');\n        -> 2\n","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (306,32,"EXPORT_SET","Syntax:\nEXPORT_SET(bits,on,off[,separator[,number_of_bits]])\n\nReturns a string such that for every bit set in the value bits, you get\nan on string and for every reset bit, you get an off string. Bits in\nbits are examined from right to left (from low-order to high-order\nbits). Strings are added to the result from left to right, separated by\nthe separator string (the default being the comma character `,'). The\nnumber of bits examined is given by number_of_bits (defaults to 64).\n","mysql> SELECT EXPORT_SET(5,'Y','N',',',4);\n        -> 'Y,N,Y,N'\nmysql> SELECT EXPORT_SET(6,'1','0',',',10);\n        -> '0,1,1,0,0,0,0,0,0,0'\n","string-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (307,27,"TIME FUNCTION","Syntax:\nTIME(expr)\n\nExtracts the time part of the time or datetime expression expr and\nreturns it as a string.\n","mysql> SELECT TIME('2003-12-31 01:02:03');\n        -> '01:02:03'\nmysql> SELECT TIME('2003-12-31 01:02:03.000123');\n        -> '01:02:03.000123'\n","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (308,32,"CAST","Syntax:\nCAST(expr AS type), CONVERT(expr,type), CONVERT(expr USING\ntranscoding_name)\n\nThe CAST() and CONVERT() functions take a value of one type and produce\na value of another type.\n\nThe type can be one of the following values:\n\no BINARY (and BINARY[N] as of MySQL 4.1.1)\n\no CHAR (and CHAR[N] as of MySQL 4.1.1)\n\no DATE\n\no DATETIME\n\no SIGNED [INTEGER]\n\no TIME\n\no UNSIGNED [INTEGER]\n\nBINARY produces a string with the BINARY data type. See\n[binary-varbinary] for a description of how this affects comparisons.\nIf the optional length N is given, BINARY(N) causes the cast to use no\nmore than N bytes of the argument. Similarly, CHAR[N] causes the cast\nto use no more than N characters of the argument.\n\nCAST() and CONVERT() are available as of MySQL 4.0.2. The CHAR\nconversion type is available as of 4.0.6. The USING form of CONVERT()\nis available as of 4.1.0.\n\nCAST() and CONVERT(... USING ...) are standard SQL syntax. The\nnon-USING form of CONVERT() is ODBC syntax.\n\nCONVERT() with USING is used to convert data between different\ncharacter sets. In MySQL, transcoding names are the same as the\ncorresponding character set names. For example, this statement converts\nthe string 'abc' in the default character set to the corresponding\nstring in the utf8 character set:\n\nSELECT CONVERT('abc' USING utf8);\n","SELECT enum_col FROM tbl_name ORDER BY CAST(enum_col AS CHAR);\n","cast-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (309,32,"SOUNDS LIKE","Syntax:\nexpr1 SOUNDS LIKE expr2\n\nThis is the same as SOUNDEX(expr1) = SOUNDEX(expr2). It is available\nbeginning with MySQL 4.1.0.\n","","string-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (310,27,"PERIOD_DIFF","Syntax:\nPERIOD_DIFF(P1,P2)\n\nReturns the number of months between periods P1 and P2. P1 and P2\nshould be in the format YYMM or YYYYMM. Note that the period arguments\nP1 and P2 are not date values.\n","mysql> SELECT PERIOD_DIFF(9802,199703);\n        -> 11\n","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (311,32,"LIKE","Syntax:\nexpr LIKE pat [ESCAPE 'escape_char']\n\nPattern matching using SQL simple regular expression comparison.\nReturns 1 (TRUE) or 0 (FALSE). If either expr or pat is NULL, the\nresult is NULL.\n\nThe pattern need not be a literal string. For example, it can be\nspecified as a string expression or table column.\n","mysql> SELECT 'David!' LIKE 'David_';\n        -> 1\nmysql> SELECT 'David!' LIKE '%D%v%';\n        -> 1\n","string-comparison-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (312,21,"MULTIPOINT","MultiPoint(pt1,pt2,...)\n\nConstructs a WKB MultiPoint value using WKB Point arguments. If any\nargument is not a WKB Point, the return value is NULL.\n","","gis-mysql-specific-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (313,18,">>","Syntax:\n>>\n\nShifts a longlong (BIGINT) number to the right.\n","mysql> SELECT 4 >> 2;\n        -> 1\n","bit-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (314,26,"TRUE FALSE","Beginning with MySQL 4.1, The constants TRUE and FALSE evaluate to 1\nand 0, respectively. The constant names can be written in any\nlettercase.\n\nmysql> SELECT TRUE, true, FALSE, false;\n        -> 1, 1, 0, 0\n","","boolean-values");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (315,14,"AVG","Syntax:\nReturns the average value of expr.\n\nAVG() returns NULL if there were no matching rows.\n","mysql> SELECT student_name, AVG(test_score)\n    ->        FROM student\n    ->        GROUP BY student_name;\n","group-by-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (316,5,"MBRWITHIN","MBRWithin(g1,g2)\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangle of g1\nis within the Minimum Bounding Rectangle of g2.\n","mysql> SET @g1 = GeomFromText('Polygon((0 0,0 3,3 3,3 0,0 0))');\nmysql> SET @g2 = GeomFromText('Polygon((0 0,0 5,5 5,5 0,0 0))');\nmysql> SELECT MBRWithin(@g1,@g2), MBRWithin(@g2,@g1);\n+--------------------+--------------------+\n| MBRWithin(@g1,@g2) | MBRWithin(@g2,@g1) |\n+--------------------+--------------------+\n|                  1 |                  0 |\n+--------------------+--------------------+\n","relations-on-geometry-mbr");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (317,17,"IN","Syntax:\nexpr IN (value,...)\n\nReturns 1 if expr is equal to any of the values in the IN list, else\nreturns 0. If all values are constants, they are evaluated according to\nthe type of expr and sorted. The search for the item then is done using\na binary search. This means IN is very quick if the IN value list\nconsists entirely of constants. Otherwise, type conversion takes place\naccording to the rules described in [type-conversion], but applied to\nall the arguments.\n","mysql> SELECT 2 IN (0,3,5,'wefwf');\n        -> 0\nmysql> SELECT 'wefwf' IN (0,3,5,'wefwf');\n        -> 1\n","comparison-operators");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (318,32,"QUOTE","Syntax:\nQUOTE(str)\n\nQuotes a string to produce a result that can be used as a properly\nescaped data value in an SQL statement. The string is returned enclosed\nby single quotes and with each instance of single quote (`''),\nbackslash (`\\'), ASCII NUL, and Control-Z preceded by a backslash. If\nthe argument is NULL, the return value is the word \"NULL\" without\nenclosing single quotes. The QUOTE() function was added in MySQL 4.0.3.\n","mysql> SELECT QUOTE('Don\\'t!');\n        -> 'Don\\'t!'\nmysql> SELECT QUOTE(NULL);\n        -> NULL\n","string-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (319,15,"SESSION_USER","Syntax:\nSESSION_USER()\n\nSESSION_USER() is a synonym for USER().\n","","information-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (320,27,"QUARTER","Syntax:\nQUARTER(date)\n\nReturns the quarter of the year for date, in the range 1 to 4.\n","mysql> SELECT QUARTER('98-04-01');\n        -> 2\n","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (321,32,"POSITION","Syntax:\nPOSITION(substr IN str)\n\nPOSITION(substr IN str) is a synonym for LOCATE(substr,str).\n","","string-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (322,13,"IS_USED_LOCK","Syntax:\nIS_USED_LOCK(str)\n\nChecks whether the lock named str is in use (that is, locked). If so,\nit returns the connection identifier of the client that holds the lock.\nOtherwise, it returns NULL.\n","","miscellaneous-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (323,3,"POLYFROMTEXT","PolyFromText(wkt[,srid]), PolygonFromText(wkt[,srid])\n\nConstructs a POLYGON value using its WKT representation and SRID.\n","","gis-wkt-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (324,10,"DES_ENCRYPT","Syntax:\nDES_ENCRYPT(str[,{key_num|key_str}])\n\nEncrypts the string with the given key using the Triple-DES algorithm.\n","key_num des_key_str\n","encryption-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (325,32,"LENGTH","Syntax:\nLENGTH(str)\n\nReturns the length of the string str, measured in bytes. A multi-byte\ncharacter counts as multiple bytes. This means that for a string\ncontaining five two-byte characters, LENGTH() returns 10, whereas\nCHAR_LENGTH() returns 5.\n","mysql> SELECT LENGTH('text');\n        -> 4\n","string-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (326,27,"STR_TO_DATE","Syntax:\nSTR_TO_DATE(str,format)\n\nThis is the inverse of the DATE_FORMAT() function. It takes a string\nstr and a format string format. STR_TO_DATE() returns a DATETIME value\nif the format string contains both date and time parts, or a DATE or\nTIME value if the string contains only date or time parts.\n\nThe date, time, or datetime values contained in str should be given in\nthe format indicated by format. For the specifiers that can be used in\nformat, see the DATE_FORMAT() function description. If str contains an\nillegal date, time, or datetime value, STR_TO_DATE() returns NULL.\n","","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (327,9,"Y","Y(p)\n\nReturns the Y-coordinate value for the point p as a double-precision\nnumber.\n","mysql> SET @pt = 'Point(56.7 53.34)';\nmysql> SELECT Y(GeomFromText(@pt));\n+----------------------+\n| Y(GeomFromText(@pt)) |\n+----------------------+\n|                53.34 |\n+----------------------+\n","point-property-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (328,24,"SHOW INNODB STATUS","Syntax:\nSHOW INNODB STATUS\n\nThis statement shows extensive information about the state of the\nInnoDB storage engine. As of MySQL 4.1.2, it is deprecated and SHOW\nENGINE INNODB STATUS should be used instead. See [show-engine].\n","","show-innodb-status");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (329,19,"CHECKSUM TABLE","Syntax:\nCHECKSUM TABLE tbl_name [, tbl_name] ... [ QUICK | EXTENDED ]\n\nCHECKSUM TABLE reports a table checksum.\n\nWith QUICK, the live table checksum is reported if it is available, or\nNULL otherwise. This is very fast. A live checksum is enabled by\nspecifying the CHECKSUM=1 table option when you create the table;\ncurrently, this is supported only for MyISAM tables. See\n[create-table].\n\nWith EXTENDED, the entire table is read row by row and the checksum is\ncalculated. This can be very slow for large tables.\n\nIf neither QUICK nor EXTENDED is specified, MySQL returns a live\nchecksum if the table storage engine supports it and scans the table\notherwise.\n\nFor a non-existent table, CHECKSUM TABLE returns NULL.\n","","checksum-table");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (330,2,"NUMINTERIORRINGS","NumInteriorRings(poly)\n\nReturns the number of interior rings in the Polygon value poly.\n","mysql> SET @poly =\n    -> 'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))';\nmysql> SELECT NumInteriorRings(GeomFromText(@poly));\n+---------------------------------------+\n| NumInteriorRings(GeomFromText(@poly)) |\n+---------------------------------------+\n|                                     1 |\n+---------------------------------------+\n","polygon-property-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (331,2,"INTERIORRINGN","InteriorRingN(poly,N)\n\nReturns the N-th interior ring for the Polygon value poly as a\nLineString. Rings are numbered beginning with 1.\n","mysql> SET @poly =\n    -> 'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))';\nmysql> SELECT AsText(InteriorRingN(GeomFromText(@poly),1));\n+----------------------------------------------+\n| AsText(InteriorRingN(GeomFromText(@poly),1)) |\n+----------------------------------------------+\n| LINESTRING(1 1,1 2,2 2,2 1,1 1)              |\n+----------------------------------------------+\n","polygon-property-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (332,27,"UTC_TIME","Syntax:\nUTC_TIME, UTC_TIME()\n\nReturns the current UTC time as a value in 'HH:MM:SS' or HHMMSS format,\ndepending on whether the function is used in a string or numeric\ncontext.\n","mysql> SELECT UTC_TIME(), UTC_TIME() + 0;\n        -> '18:07:53', 180753\n","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (333,33,"DROP FUNCTION","Syntax:\nDROP FUNCTION function_name\n\nThis statement drops the user-defined function (UDF) named\nfunction_name.\n\nTo drop a function, you must have the DELETE privilege for the mysql\ndatabase. This is because DROP FUNCTION removes a row from the\nmysql.func system table that records the function's name, type, and\nshared library name.\n","","drop-function");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (334,14,"STDDEV","Syntax:\nSTD(expr) STDDEV(expr)\n\nReturns the population standard deviation of expr. This is an extension\nto standard SQL. The STDDEV() form of this function is provided for\ncompatibility with Oracle.\n\nThese functions return NULL if there were no matching rows.\n","","group-by-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (335,27,"PERIOD_ADD","Syntax:\nPERIOD_ADD(P,N)\n\nAdds N months to period P (in the format YYMM or YYYYMM). Returns a\nvalue in the format YYYYMM. Note that the period argument P is not a\ndate value.\n","mysql> SELECT PERIOD_ADD(9801,2);\n        -> 199803\n","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (336,18,"|","Syntax:\n|\n\nBitwise OR:\n","mysql> SELECT 29 | 15;\n        -> 31\n","bit-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (337,3,"GEOMFROMTEXT","GeomFromText(wkt[,srid]), GeometryFromText(wkt[,srid])\n\nConstructs a geometry value of any type using its WKT representation\nand SRID.\n","","gis-wkt-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (338,32,"RIGHT","Syntax:\nRIGHT(str,len)\n\nReturns the rightmost len characters from the string str.\n","mysql> SELECT RIGHT('foobarbar', 4);\n        -> 'rbar'\n","string-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (339,27,"DATEDIFF","Syntax:\nDATEDIFF(expr,expr2)\n\nDATEDIFF() returns the number of days between the start date expr and\nthe end date expr2. expr and expr2 are date or date-and-time\nexpressions. Only the date parts of the values are used in the\ncalculation.\n","mysql> SELECT DATEDIFF('1997-12-31 23:59:59','1997-12-30');\n        -> 1\nmysql> SELECT DATEDIFF('1997-11-30 23:59:59','1997-12-31');\n        -> -31\n","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (340,19,"CHECK TABLE","Syntax:\nCHECK TABLE tbl_name [, tbl_name] ... [option] ...\n\noption = {QUICK | FAST | MEDIUM | EXTENDED | CHANGED}\n\nCHECK TABLE checks a table or tables for errors. CHECK TABLE works for\nMyISAM and InnoDB tables. For MyISAM tables, the key statistics are\nupdated as well.\n","","check-table");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (341,32,"BIN","Syntax:\nBIN(N)\n\nReturns a string representation of the binary value of N, where N is a\nlonglong (BIGINT) number. This is equivalent to CONV(N,10,2). Returns\nNULL if N is NULL.\n","mysql> SELECT BIN(12);\n        -> '1100'\n","string-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (342,6,"CASE FUNCTION","Syntax:\nCASE value WHEN [compare_value] THEN result [WHEN [compare_value] THEN\nresult ...] [ELSE result] END\n\nCASE WHEN [condition] THEN result [WHEN [condition] THEN result ...]\n[ELSE result] END\n\nThe first version returns the result where value=compare_value. The\nsecond version returns the result for the first condition that is true.\nIf there was no matching result value, the result after ELSE is\nreturned, or NULL if there is no ELSE part.\n","mysql> SELECT CASE 1 WHEN 1 THEN 'one'\n    ->     WHEN 2 THEN 'two' ELSE 'more' END;\n        -> 'one'\nmysql> SELECT CASE WHEN 1>0 THEN 'true' ELSE 'false' END;\n        -> 'true'\nmysql> SELECT CASE BINARY 'B'\n    ->     WHEN 'a' THEN 1 WHEN 'b' THEN 2 END;\n        -> NULL\n","control-flow-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (343,21,"MULTILINESTRING","MultiLineString(ls1,ls2,...)\n\nConstructs a WKB MultiLineString value using WKB LineString arguments.\nIf any argument is not a WKB LineString, the return value is NULL.\n","","gis-mysql-specific-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (344,24,"LOAD DATA","Syntax:\nLOAD DATA [LOW_PRIORITY | CONCURRENT] [LOCAL] INFILE 'file_name'\n    [REPLACE | IGNORE]\n    INTO TABLE tbl_name\n    [FIELDS\n        [TERMINATED BY 'string']\n        [[OPTIONALLY] ENCLOSED BY 'char']\n        [ESCAPED BY 'char']\n    ]\n    [LINES\n        [STARTING BY 'string']\n        [TERMINATED BY 'string']\n    ]\n    [IGNORE number LINES]\n    [(col_name,...)]\n\nThe LOAD DATA INFILE statement reads rows from a text file into a table\nat a very high speed. The filename must be given as a literal string.\n\nLOAD DATA INFILE is the complement of SELECT ... INTO OUTFILE. (See\n[select].) To write data from a table to a file, use SELECT ... INTO\nOUTFILE. To read the file back into a table, use LOAD DATA INFILE. The\nsyntax of the FIELDS and LINES clauses is the same for both statements.\nBoth clauses are optional, but FIELDS must precede LINES if both are\nspecified.\n\nFor more information about the efficiency of INSERT versus LOAD DATA\nINFILE and speeding up LOAD DATA INFILE, see [insert-speed].\n\nAs of MySQL 4.1, the character set indicated by the\ncharacter_set_database system variable is used to interpret the\ninformation in the file. SET NAMES and the setting of\ncharacter_set_client do not affect interpretation of input.\n\nNote that it is currently not possible to load data files that use the\nucs2 character set.\n\nYou can also load data files by using the mysqlimport utility; it\noperates by sending a LOAD DATA INFILE statement to the server. The\n--local option causes mysqlimport to read data files from the client\nhost. You can specify the --compress option to get better performance\nover slow networks if the client and server support the compressed\nprotocol. See [mysqlimport].\n\nIf you use LOW_PRIORITY, execution of the LOAD DATA statement is\ndelayed until no other clients are reading from the table.\n\nIf you specify CONCURRENT with a MyISAM table that satisfies the\ncondition for concurrent inserts (that is, it contains no free blocks\nin the middle), other threads can retrieve data from the table while\nLOAD DATA is executing. Using this option affects the performance of\nLOAD DATA a bit, even if no other thread is using the table at the same\ntime.\n\nThe LOCAL keyword, if specified, is interpreted with respect to the\nclient end of the connection:\n\no If LOCAL is specified, the file is read by the client program on the\n  client host and sent to the server. The file can be given as a full\n  pathname to specify its exact location. If given as a relative\n  pathname, the name is interpreted relative to the directory in which\n  the client program was started.\n\n  LOCAL is available in MySQL 3.22.6 or later.\n\no If LOCAL is not specified, the file must be located on the server\n  host and is read directly by the server. The server uses the\n  following rules to locate the file:\n\n  o If the filename is an absolute pathname, the server uses it as\n    given.\n\n  o If the filename is a relative pathname with one or more leading\n    components, the server searches for the file relative to the\n    server's data directory.\n\n  o If a filename with no leading components is given, the server looks\n    for the file in the database directory of the default database.\n\nNote that, in the non-LOCAL case, these rules mean that a file named as\n./myfile.txt is read from the server's data directory, whereas the file\nnamed as myfile.txt is read from the database directory of the default\ndatabase. For example, if db1 is the default database, the following\nLOAD DATA statement reads the file data.txt from the database directory\nfor db1, even though the statement explicitly loads the file into a\ntable in the db2 database:\n\nLOAD DATA INFILE 'data.txt' INTO TABLE db2.my_table;\n\nWindows pathnames are specified using forward slashes rather than\nbackslashes. If you do use backslashes, you must double them.\n\nFor security reasons, when reading text files located on the server,\nthe files must either reside in the database directory or be readable\nby all. Also, to use LOAD DATA INFILE on server files, you must have\nthe FILE privilege. See [privileges-provided].\n","","load-data");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (345,27,"LOCALTIME","Syntax:\nLOCALTIME, LOCALTIME()\n\nLOCALTIME and LOCALTIME() are synonyms for NOW().\n","","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (346,3,"MPOINTFROMTEXT","MPointFromText(wkt[,srid]), MultiPointFromText(wkt[,srid])\n\nConstructs a MULTIPOINT value using its WKT representation and SRID.\n","","gis-wkt-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (347,20,"BLOB","BLOB[(M)]\n\nA BLOB column with a maximum length of 65,535 (216 - 1) bytes.\n\nBeginning with MySQL 4.1, an optional length M can be given for this\ntype. MySQL creates the column as the smallest BLOB type large enough\nto hold values M bytes long.\n","","string-type-overview");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (348,10,"PASSWORD","Syntax:\nPASSWORD(str)\n\nCalculates and returns a password string from the plaintext password\nstr and returns a binary string, or NULL if the argument was NULL. This\nis the function that is used for encrypting MySQL passwords for storage\nin the Password column of the user grant table.\n","mysql> SELECT PASSWORD('badpwd');\n        -> '7f84554057dd964b'\n","encryption-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (349,20,"CHAR","[NATIONAL] CHAR(M)\n\nA fixed-length string that is always right-padded with spaces to the\nspecified length when stored. M represents the column length. The range\nof M is 0 to 255 characters (1 to 255 prior to MySQL 3.23).\n\nNote: Trailing spaces are removed when CHAR values are retrieved.\n\nIn MySQL 4.1, a CHAR column with a length specification greater than\n255 is converted to the smallest TEXT type that can hold values of the\ngiven length. For example, CHAR(500) is converted to TEXT, and\nCHAR(200000) is converted to MEDIUMTEXT. This is a compatibility\nfeature. However, this conversion causes the column to become a\nvariable-length column, and also affects trailing-space removal.\n","","string-type-overview");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (350,27,"UTC_DATE","Syntax:\nUTC_DATE, UTC_DATE()\n\nReturns the current UTC date as a value in 'YYYY-MM-DD' or YYYYMMDD\nformat, depending on whether the function is used in a string or\nnumeric context.\n","mysql> SELECT UTC_DATE(), UTC_DATE() + 0;\n        -> '2003-08-14', 20030814\n","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (351,31,"DIMENSION","Dimension(g)\n\nReturns the inherent dimension of the geometry value g. The result can\nbe -1, 0, 1, or 2. The meaning of these values is given in\n[gis-class-geometry].\n","mysql> SELECT Dimension(GeomFromText('LineString(1 1,2 2)'));\n+------------------------------------------------+\n| Dimension(GeomFromText('LineString(1 1,2 2)')) |\n+------------------------------------------------+\n|                                              1 |\n+------------------------------------------------+\n","general-geometry-property-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (352,14,"COUNT DISTINCT","Syntax:\nCOUNT(DISTINCT expr,[expr...])\n\nReturns a count of the number of different non-NULL values.\n\nCOUNT(DISTINCT) returns 0 if there were no matching rows.\n","mysql> SELECT COUNT(DISTINCT results) FROM student;\n","group-by-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (353,20,"BIT","BIT\n\nIn versions of MySQL up to and lincluding 4.1, BIT is a synonym for\nTINYINT(1).\n","","numeric-type-overview");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (354,25,"EQUALS","Equals(g1,g2)\n\nReturns 1 or 0 to indicate whether g1 is spatially equal to g2.\n","","functions-that-test-spatial-relationships-between-geometries");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (355,17,"INTERVAL","Syntax:\nINTERVAL(N,N1,N2,N3,...)\n\nReturns 0 if N < N1, 1 if N < N2 and so on or -1 if N is NULL. All\narguments are treated as integers. It is required that N1 < N2 < N3 <\n... < Nn for this function to work correctly. This is because a binary\nsearch is used (very fast).\n","mysql> SELECT INTERVAL(23, 1, 15, 17, 30, 44, 200);\n        -> 3\nmysql> SELECT INTERVAL(10, 1, 10, 100, 1000);\n        -> 2\nmysql> SELECT INTERVAL(22, 23, 30, 44, 200);\n        -> 0\n","comparison-operators");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (356,27,"FROM_DAYS","Syntax:\nFROM_DAYS(N)\n\nGiven a day number N, returns a DATE value.\n","mysql> SELECT FROM_DAYS(729669);\n        -> '1997-10-07'\n","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (357,18,"BIT_COUNT","Syntax:\nBIT_COUNT(N)\n\nReturns the number of bits that are set in the argument N.\n","mysql> SELECT BIT_COUNT(29);\n        -> 4\n","bit-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (358,27,"UTC_TIMESTAMP","Syntax:\nUTC_TIMESTAMP, UTC_TIMESTAMP()\n\nReturns the current UTC date and time as a value in 'YYYY-MM-DD\nHH:MM:SS' or YYYYMMDDHHMMSS format, depending on whether the function\nis used in a string or numeric context.\n","mysql> SELECT UTC_TIMESTAMP(), UTC_TIMESTAMP() + 0;\n        -> '2003-08-14 18:08:04', 20030814180804\n","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (359,4,"+","Syntax:\n+\n\nAddition:\n","mysql> SELECT 3+5;\n        -> 8\n","arithmetic-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (360,13,"INET_NTOA","Syntax:\nINET_NTOA(expr)\n\nGiven a numeric network address (4 or 8 byte), returns the dotted-quad\nrepresentation of the address as a string.\n","mysql> SELECT INET_NTOA(3520061480);\n        -> '209.207.224.40'\n","miscellaneous-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (361,4,"ACOS","Syntax:\nACOS(X)\n\nReturns the arc cosine of X, that is, the value whose cosine is X.\nReturns NULL if X is not in the range -1 to 1.\n","mysql> SELECT ACOS(1);\n        -> 0.000000\nmysql> SELECT ACOS(1.0001);\n        -> NULL\nmysql> SELECT ACOS(0);\n        -> 1.570796\n","mathematical-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (362,7,"ISOLATION","Syntax:\nSET [GLOBAL | SESSION] TRANSACTION ISOLATION LEVEL\n{ READ UNCOMMITTED | READ COMMITTED | REPEATABLE READ | SERIALIZABLE }\n\nThis statement sets the transaction isolation level for the next\ntransaction, globally, or for the current session.\n\nThe default behavior of SET TRANSACTION is to set the isolation level\nfor the next (not yet started) transaction. If you use the GLOBAL\nkeyword, the statement sets the default transaction level globally for\nall new connections created from that point on. Existing connections\nare unaffected. You need the SUPER privilege to do this. Using the\nSESSION keyword sets the default transaction level for all future\ntransactions performed on the current connection.\n\nFor descriptions of each InnoDB transaction isolation level, see\n[innodb-transaction-isolation]. InnoDB supports each of these levels\nfrom MySQL 4.0.5 on. The default level is REPEATABLE READ.\n\nTo set the initial default global isolation level for mysqld, use the\n--transaction-isolation option. See [server-options].\n","","set-transaction");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (363,4,"CEILING","Syntax:\nCEILING(X), CEIL(X)\n\nReturns the smallest integer value not less than X.\n","mysql> SELECT CEILING(1.23);\n        -> 2\nmysql> SELECT CEIL(-1.23);\n        -> -1\n","mathematical-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (364,4,"SIN","Syntax:\nSIN(X)\n\nReturns the sine of X, where X is given in radians.\n","mysql> SELECT SIN(PI());\n        -> 1.2246063538224e-16\nmysql> SELECT ROUND(SIN(PI()));\n        -> 0\n","mathematical-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (365,27,"DAYOFWEEK","Syntax:\nDAYOFWEEK(date)\n\nReturns the weekday index for date (1 = Sunday, 2 = Monday, ..., 7 =\nSaturday). These index values correspond to the ODBC standard.\n","mysql> SELECT DAYOFWEEK('1998-02-03');\n        -> 3\n","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (366,28,"LINEFROMWKB","LineFromWKB(wkb[,srid]), LineStringFromWKB(wkb[,srid])\n\nConstructs a LINESTRING value using its WKB representation and SRID.\n","","gis-wkb-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (367,24,"SHOW PROCESSLIST","Syntax:\nSHOW [FULL] PROCESSLIST\n\nSHOW PROCESSLIST shows you which threads are running. You can also get\nthis information using the mysqladmin processlist command. If you have\nthe SUPER privilege, you can see all threads. Otherwise, you can see\nonly your own threads (that is, threads associated with the MySQL\naccount that you are using). See [kill]. If you do not use the FULL\nkeyword, only the first 100 characters of each statement are shown in\nthe Info field.\n","","show-processlist");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (368,31,"GEOMETRYTYPE","GeometryType(g)\n\nReturns as a string the name of the geometry type of which the geometry\ninstance g is a member. The name corresponds to one of the instantiable\nGeometry subclasses.\n","mysql> SELECT GeometryType(GeomFromText('POINT(1 1)'));\n+------------------------------------------+\n| GeometryType(GeomFromText('POINT(1 1)')) |\n+------------------------------------------+\n| POINT                                    |\n+------------------------------------------+\n","general-geometry-property-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (369,32,"TRIM","Syntax:\nTRIM([{BOTH | LEADING | TRAILING} [remstr] FROM] str), TRIM([remstr\nFROM] str)\n\nReturns the string str with all remstr prefixes or suffixes removed. If\nnone of the specifiers BOTH, LEADING, or TRAILING is given, BOTH is\nassumed. remstr is optional and, if not specified, spaces are removed.\n","mysql> SELECT TRIM('  bar   ');\n        -> 'bar'\nmysql> SELECT TRIM(LEADING 'x' FROM 'xxxbarxxx');\n        -> 'barxxx'\nmysql> SELECT TRIM(BOTH 'x' FROM 'xxxbarxxx');\n        -> 'bar'\nmysql> SELECT TRIM(TRAILING 'xyz' FROM 'barxxyz');\n        -> 'barx'\n","string-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (370,27,"GET_FORMAT","Syntax:\nGET_FORMAT(DATE|TIME|DATETIME, 'EUR'|'USA'|'JIS'|'ISO'|'INTERNAL')\n\nReturns a format string. This function is useful in combination with\nthe DATE_FORMAT() and the STR_TO_DATE() functions.\n","mysql> SELECT DATE_FORMAT('2003-10-03',GET_FORMAT(DATE,'EUR'));\n        -> '03.10.2003'\nmysql> SELECT STR_TO_DATE('10.31.2003',GET_FORMAT(DATE,'USA'));\n        -> '2003-10-31'\n","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (371,20,"TINYBLOB","TINYBLOB\n\nA BLOB column with a maximum length of 255 (28 - 1) bytes.\n","","string-type-overview");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (372,7,"SAVEPOINT","Syntax:\nSAVEPOINT identifier\nROLLBACK TO SAVEPOINT identifier\n\nStarting from MySQL 4.0.14 and 4.1.1, InnoDB supports the SQL\nstatements SAVEPOINT and ROLLBACK TO SAVEPOINT.\n","","savepoints");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (373,15,"USER","Syntax:\nUSER()\n\nReturns the current MySQL username and hostname.\n","mysql> SELECT USER();\n        -> 'davida@localhost'\n","information-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (374,28,"MPOINTFROMWKB","MPointFromWKB(wkb[,srid]), MultiPointFromWKB(wkb[,srid])\n\nConstructs a MULTIPOINT value using its WKB representation and SRID.\n","","gis-wkb-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (375,34,"ALTER TABLE","Syntax:\nALTER [IGNORE] TABLE tbl_name\n    alter_specification [, alter_specification] ...\n\nalter_specification:\n    ADD [COLUMN] column_definition [FIRST | AFTER col_name ]\n  | ADD [COLUMN] (column_definition,...)\n  | ADD {INDEX|KEY} [index_name] [index_type] (index_col_name,...)\n  | ADD [CONSTRAINT [symbol]]\n        PRIMARY KEY [index_type] (index_col_name,...)\n  | ADD [CONSTRAINT [symbol]]\n        UNIQUE [INDEX|KEY] [index_name] [index_type] (index_col_name,...)\n  | ADD [FULLTEXT|SPATIAL] [INDEX|KEY] [index_name] (index_col_name,...)\n  | ADD [CONSTRAINT [symbol]]\n        FOREIGN KEY [index_name] (index_col_name,...)\n        [reference_definition]\n  | ALTER [COLUMN] col_name {SET DEFAULT literal | DROP DEFAULT}\n  | CHANGE [COLUMN] old_col_name column_definition\n        [FIRST|AFTER col_name]\n  | MODIFY [COLUMN] column_definition [FIRST | AFTER col_name]\n  | DROP [COLUMN] col_name\n  | DROP PRIMARY KEY\n  | DROP {INDEX|KEY} index_name\n  | DROP FOREIGN KEY fk_symbol\n  | DISABLE KEYS\n  | ENABLE KEYS\n  | RENAME [TO] new_tbl_name\n  | ORDER BY col_name\n  | CONVERT TO CHARACTER SET charset_name [COLLATE collation_name]\n  | [DEFAULT] CHARACTER SET charset_name [COLLATE collation_name]\n  | DISCARD TABLESPACE\n  | IMPORT TABLESPACE\n  | table_option ...\n\nALTER TABLE enables you to change the structure of an existing table.\nFor example, you can add or delete columns, create or destroy indexes,\nchange the type of existing columns, or rename columns or the table\nitself. You can also change the comment for the table and type of the\ntable.\n","","alter-table");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (376,24,"PURGE MASTER LOGS","Syntax:\nPURGE {MASTER | BINARY} LOGS TO 'log_name'\nPURGE {MASTER | BINARY} LOGS BEFORE 'date'\n\nDeletes all the binary logs listed in the log index prior to the\nspecified log or date. The logs also are removed from the list recorded\nin the log index file, so that the given log becomes the first.\n","PURGE MASTER LOGS TO 'mysql-bin.010';\nPURGE MASTER LOGS BEFORE '2003-04-02 22:46:26';\n","purge-master-logs");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (377,20,"CHAR BYTE","From MySQL 4.1.2 on, the CHAR BYTE data type is an alias for the BINARY\ndata type. This is a compatibility feature.\n","","string-type-overview");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (378,19,"REPAIR TABLE","Syntax:\nREPAIR [LOCAL | NO_WRITE_TO_BINLOG] TABLE\n    tbl_name [, tbl_name] ... [QUICK] [EXTENDED] [USE_FRM]\n\nREPAIR TABLE repairs a possibly corrupted table. By default, it has the\nsame effect as myisamchk --recover tbl_name. REPAIR TABLE works for\nMyISAM and for ARCHIVE tables. See [myisam-storage-engine], and\n[archive-storage-engine].\n\nThis statement requires SELECT and INSERT privileges for the table.\n","","repair-table");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (379,34,"MERGE","The MERGE storage engine was introduced in MySQL 3.23.25. It is also\nknown as the MRG_MyISAM engine.\n\nA MERGE table is a collection of identical MyISAM tables that can be\nused as one. \"Identical\" means that all tables have identical column\nand index information. You cannot merge MyISAM tables in which the\ncolumns are listed in a different order, do not have exactly the same\ncolumns, or have the indexes in different order. However, any or all of\nthe MyISAM tables can be compressed with myisampack. See [myisampack].\nDifferences in table options such as AVG_ROW_LENGTH, MAX_ROWS, or\nPACK_KEYS do not matter.\n","mysql> CREATE TABLE t1 (\n    ->    a INT NOT NULL AUTO_INCREMENT PRIMARY KEY,\n    ->    message CHAR(20)) ENGINE=MyISAM;\nmysql> CREATE TABLE t2 (\n    ->    a INT NOT NULL AUTO_INCREMENT PRIMARY KEY,\n    ->    message CHAR(20)) ENGINE=MyISAM;\nmysql> INSERT INTO t1 (message) VALUES ('Testing'),('table'),('t1');\nmysql> INSERT INTO t2 (message) VALUES ('Testing'),('table'),('t2');\nmysql> CREATE TABLE total (\n    ->    a INT NOT NULL AUTO_INCREMENT,\n    ->    message CHAR(20), INDEX(a))\n    ->    ENGINE=MERGE UNION=(t1,t2) INSERT_METHOD=LAST;\n","merge-storage-engine");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (380,34,"CREATE TABLE","Syntax:\nCREATE [TEMPORARY] TABLE [IF NOT EXISTS] tbl_name\n    (create_definition,...)\n    [table_option ...]\n\nOr:\n\nCREATE [TEMPORARY] TABLE [IF NOT EXISTS] tbl_name\n    [(create_definition,...)]\n    [table_option ...]\n    select_statement\n\nOr:\n\nCREATE [TEMPORARY] TABLE [IF NOT EXISTS] tbl_name\n    { LIKE old_tbl_name | (LIKE old_tbl_name) }\n\ncreate_definition:\n    column_definition\n  | [CONSTRAINT [symbol]] PRIMARY KEY [index_type] (index_col_name,...)\n  | {INDEX|KEY} [index_name] [index_type] (index_col_name,...)\n  | [CONSTRAINT [symbol]] UNIQUE [INDEX|KEY]\n      [index_name] [index_type] (index_col_name,...)\n  | {FULLTEXT|SPATIAL} [INDEX|KEY] [index_name] (index_col_name,...)\n  | [CONSTRAINT [symbol]] FOREIGN KEY\n      [index_name] (index_col_name,...) [reference_definition]\n  | CHECK (expr)\n\ncolumn_definition:\n    col_name data_type [NOT NULL | NULL] [DEFAULT default_value]\n      [AUTO_INCREMENT] [UNIQUE [KEY] | [PRIMARY] KEY]\n      [COMMENT 'string'] [reference_definition]\n\ndata_type:\n    TINYINT[(length)] [UNSIGNED] [ZEROFILL]\n  | SMALLINT[(length)] [UNSIGNED] [ZEROFILL]\n  | MEDIUMINT[(length)] [UNSIGNED] [ZEROFILL]\n  | INT[(length)] [UNSIGNED] [ZEROFILL]\n  | INTEGER[(length)] [UNSIGNED] [ZEROFILL]\n  | BIGINT[(length)] [UNSIGNED] [ZEROFILL]\n  | REAL[(length,decimals)] [UNSIGNED] [ZEROFILL]\n  | DOUBLE[(length,decimals)] [UNSIGNED] [ZEROFILL]\n  | FLOAT[(length,decimals)] [UNSIGNED] [ZEROFILL]\n  | DECIMAL(length,decimals) [UNSIGNED] [ZEROFILL]\n  | NUMERIC(length,decimals) [UNSIGNED] [ZEROFILL]\n  | DATE\n  | TIME\n  | TIMESTAMP\n  | DATETIME\n  | YEAR\n  | CHAR(length) [BINARY | ASCII | UNICODE]\n  | VARCHAR(length) [BINARY]\n  | BINARY(length)\n  | VARBINARY(length)\n  | TINYBLOB\n  | BLOB\n  | MEDIUMBLOB\n  | LONGBLOB\n  | TINYTEXT [BINARY]\n  | TEXT [BINARY]\n  | MEDIUMTEXT [BINARY]\n  | LONGTEXT [BINARY]\n  | ENUM(value1,value2,value3,...)\n  | SET(value1,value2,value3,...)\n  | spatial_type\n\nindex_col_name:\n    col_name [(length)] [ASC | DESC]\n\nreference_definition:\n    REFERENCES tbl_name [(index_col_name,...)]\n      [MATCH FULL | MATCH PARTIAL | MATCH SIMPLE]\n      [ON DELETE reference_option]\n      [ON UPDATE reference_option]\n\nreference_option:\n    RESTRICT | CASCADE | SET NULL | NO ACTION\n\ntable_option:\n    {ENGINE|TYPE} = engine_name\n  | AUTO_INCREMENT = value\n  | AVG_ROW_LENGTH = value\n  | [DEFAULT] CHARACTER SET charset_name\n  | CHECKSUM = {0 | 1}\n  | COLLATE collation_name\n  | COMMENT = 'string'\n  | DATA DIRECTORY = 'absolute path to directory'\n  | DELAY_KEY_WRITE = {0 | 1}\n  | INDEX DIRECTORY = 'absolute path to directory'\n  | INSERT_METHOD = { NO | FIRST | LAST }\n  | MAX_ROWS = value\n  | MIN_ROWS = value\n  | PACK_KEYS = {0 | 1 | DEFAULT}\n  | PASSWORD = 'string'\n  | RAID_TYPE = { 1 | STRIPED | RAID0 }\n      RAID_CHUNKS = value\n      RAID_CHUNKSIZE = value\n  | ROW_FORMAT = {DEFAULT|DYNAMIC|FIXED|COMPRESSED|REDUNDANT|COMPACT}\n  | UNION = (tbl_name[,tbl_name]...)\n\nselect_statement:\n    [IGNORE | REPLACE] [AS] SELECT ...   (Some legal select statement)\n\nCREATE TABLE creates a table with the given name. You must have the\nCREATE privilege for the table.\n\nRules for allowable table names are given in [legal-names]. By default,\nthe table is created in the default database. An error occurs if the\ntable exists, if there is no default database, or if the database does\nnot exist.\n","","create-table");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (381,17,">","Syntax:\n>\n\nGreater than:\n","mysql> SELECT 2 > 2;\n        -> 0\n","comparison-operators");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (382,19,"ANALYZE TABLE","Syntax:\nANALYZE [LOCAL | NO_WRITE_TO_BINLOG] TABLE tbl_name [, tbl_name] ...\n\nANALYZE TABLE analyzes and stores the key distribution for a table.\nDuring the analysis, the table is locked with a read lock. This\nstatement works with MyISAM, BDB, and (as of MySQL 4.0.13) InnoDB\ntables. For MyISAM tables, this statement is equivalent to using\nmyisamchk --analyze.\n\nMySQL uses the stored key distribution to decide the order in which\ntables should be joined when you perform a join on something other than\na constant.\n\nThis statement requires SELECT and INSERT privileges for the table.\n","","analyze-table");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (383,27,"MICROSECOND","Syntax:\nMICROSECOND(expr)\n\nReturns the microseconds from the time or datetime expression expr as a\nnumber in the range from 0 to 999999.\n","mysql> SELECT MICROSECOND('12:00:00.123456');\n        -> 123456\nmysql> SELECT MICROSECOND('1997-12-31 23:59:59.000010');\n        -> 10\n","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (384,34,"CONSTRAINT","The syntax of a foreign key constraint definition in InnoDB looks like\nthis:\n\n[CONSTRAINT symbol] FOREIGN KEY [id] (index_col_name, ...)\n    REFERENCES tbl_name (index_col_name, ...)\n    [ON DELETE {RESTRICT | CASCADE | SET NULL | NO ACTION}]\n    [ON UPDATE {RESTRICT | CASCADE | SET NULL | NO ACTION}]\n","CREATE TABLE product (category INT NOT NULL, id INT NOT NULL,\n                      price DECIMAL,\n                      PRIMARY KEY(category, id)) TYPE=INNODB;\nCREATE TABLE customer (id INT NOT NULL,\n                       PRIMARY KEY (id)) TYPE=INNODB;\nCREATE TABLE product_order (no INT NOT NULL AUTO_INCREMENT,\n                            product_category INT NOT NULL,\n                            product_id INT NOT NULL,\n                            customer_id INT NOT NULL,\n                            PRIMARY KEY(no),\n                            INDEX (product_category, product_id),\n                            FOREIGN KEY (product_category, product_id)\n                              REFERENCES product(category, id)\n                              ON UPDATE CASCADE ON DELETE RESTRICT,\n                            INDEX (customer_id),\n                            FOREIGN KEY (customer_id)\n                              REFERENCES customer(id)) TYPE=INNODB;\n","innodb-foreign-key-constraints");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (385,32,"FIELD","Syntax:\nFIELD(str,str1,str2,str3,...)\n\nReturns the index (position) of str in the str1, str2, str3, ... list.\nReturns 0 if str is not found.\n\nIf all arguments to FIELD() are strings, all arguments are compared as\nstrings. If all arguments are numbers, they are compared as numbers.\nOtherwise, the arguments are compared as double.\n\nIf str is NULL, the return value is 0 because NULL fails equality\ncomparison with any value. FIELD() is the complement of ELT().\n","mysql> SELECT FIELD('ej', 'Hej', 'ej', 'Heja', 'hej', 'foo');\n        -> 2\nmysql> SELECT FIELD('fo', 'Hej', 'ej', 'Heja', 'hej', 'foo');\n        -> 0\n","string-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (386,27,"MAKETIME","Syntax:\nMAKETIME(hour,minute,second)\n\nReturns a time value calculated from the hour, minute, and second\narguments.\n","mysql> SELECT MAKETIME(12,15,30);\n        -> '12:15:30'\n","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (387,27,"CURDATE","Syntax:\nCURDATE()\n\nReturns the current date as a value in 'YYYY-MM-DD' or YYYYMMDD format,\ndepending on whether the function is used in a string or numeric\ncontext.\n","mysql> SELECT CURDATE();\n        -> '1997-12-15'\nmysql> SELECT CURDATE() + 0;\n        -> 19971215\n","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (388,14,"MIN MAX","Syntax:\nMIN(expr), MAX(expr)\n\nReturns the minimum or maximum value of expr. MIN() and MAX() may take\na string argument; in such cases they return the minimum or maximum\nstring value. See [mysql-indexes].\n\nMIN() and MAX() return NULL if there were no matching rows.\n","mysql> SELECT student_name, MIN(test_score), MAX(test_score)\n    ->        FROM student\n    ->        GROUP BY student_name;\n","group-by-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (389,8,"SET PASSWORD","Syntax:\nSET PASSWORD [FOR user] = PASSWORD('some password')\n\nThe SET PASSWORD statement assigns a password to an existing MySQL user\naccount.\n\nWith no FOR clause, this statement sets the password for the current\nuser. Any client that has connected to the server using a non-anonymous\naccount can change the password for that account.\n\nWith a FOR clause, this statement sets the password for a specific\naccount on the current server host. Only clients that have the UPDATE\nprivilege for the mysql database can do this. The user value should be\ngiven in user_name@host_name format, where user_name and host_name are\nexactly as they are listed in the User and Host columns of the\nmysql.user table entry. For example, if you had an entry with User and\nHost column values of 'bob' and '%.loc.gov', you would write the\nstatement like this:\n\nSET PASSWORD FOR 'bob'@'%.loc.gov' = PASSWORD('newpass');\n","","set-password");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (390,20,"ENUM","ENUM('value1','value2',...)\n\nAn enumeration. A string object that can have only one value, chosen\nfrom the list of values 'value1', 'value2', ..., NULL or the special ''\nerror value. An ENUM column can have a maximum of 65,535 distinct\nvalues. ENUM values are represented internally as integers.\n","","string-type-overview");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (391,6,"IF FUNCTION","Syntax:\nIF(expr1,expr2,expr3)\n\nIf expr1 is TRUE (expr1 <> 0 and expr1 <> NULL) then IF() returns\nexpr2; otherwise it returns expr3. IF() returns a numeric or string\nvalue, depending on the context in which it is used.\n","mysql> SELECT IF(1>2,2,3);\n        -> 3\nmysql> SELECT IF(1<2,'yes','no');\n        -> 'yes'\nmysql> SELECT IF(STRCMP('test','test1'),'no','yes');\n        -> 'no'\n","control-flow-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (392,15,"DATABASE","Syntax:\nDATABASE()\n\nReturns the default (current) database name. As of MySQL 4.1, the\nstring uses the utf8 character set. If there is no default database,\nDATABASE() returns NULL as of MySQL 4.1.1, and the empty string before\nthat.\n","mysql> SELECT DATABASE();\n        -> 'test'\n","information-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (393,28,"POINTFROMWKB","PointFromWKB(wkb[,srid])\n\nConstructs a POINT value using its WKB representation and SRID.\n","","gis-wkb-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (394,4,"POWER","Syntax:\nPOW(X,Y), POWER(X,Y)\n\nReturns the value of X raised to the power of Y.\n","mysql> SELECT POW(2,2);\n        -> 4.000000\nmysql> SELECT POW(2,-2);\n        -> 0.250000\n","mathematical-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (395,4,"ATAN","Syntax:\nATAN(X)\n\nReturns the arc tangent of X, that is, the value whose tangent is X.\n","mysql> SELECT ATAN(2);\n        -> 1.107149\nmysql> SELECT ATAN(-2);\n        -> -1.107149\n","mathematical-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (396,32,"STRCMP","Syntax:\nSTRCMP(expr1,expr2)\n\nSTRCMP() returns 0 if the strings are the same, -1 if the first\nargument is smaller than the second according to the current sort\norder, and 1 otherwise.\n","mysql> SELECT STRCMP('text', 'text2');\n        -> -1\nmysql> SELECT STRCMP('text2', 'text');\n        -> 1\nmysql> SELECT STRCMP('text', 'text');\n        -> 0\n","string-comparison-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (397,24,"INSERT DELAYED","Syntax:\nINSERT DELAYED ...\n\nThe DELAYED option for the INSERT statement is a MySQL extension to\nstandard SQL that is very useful if you have clients that cannot or\nneed not wait for the INSERT to complete. This is a common situation\nwhen you use MySQL for logging and you also periodically run SELECT and\nUPDATE statements that take a long time to complete. DELAYED was\nintroduced in MySQL 3.22.15.\n\nWhen a client uses INSERT DELAYED, it gets an okay from the server at\nonce, and the row is queued to be inserted when the table is not in use\nby any other thread.\n\nAnother major benefit of using INSERT DELAYED is that inserts from many\nclients are bundled together and written in one block. This is much\nfaster than performing many separate inserts.\n\nNote that INSERT DELAYED is slower than a normal INSERT if the table is\nnot otherwise in use. There is also the additional overhead for the\nserver to handle a separate thread for each table for which there are\ndelayed rows. This means that you should use INSERT DELAYED only when\nyou are really sure that you need it.\n\nThe queued rows are held only in memory until they are inserted into\nthe table. This means that if you terminate mysqld forcibly (for\nexample, with kill -9) or if mysqld dies unexpectedly, any queued rows\nthat have not been written to disk are lost.\n\nThere are some constraints on the use of DELAYED:\n\no INSERT DELAYED works only with ISAM, MyISAM, and (beginning with\n  MySQL 4.1) MEMORY tables. See [myisam-storage-engine],\n  [memory-storage-engine], and [archive-storage-engine].\n\n  For MyISAM tables, if there are no free blocks in the middle of the\n  data file, concurrent SELECT and INSERT statements are supported.\n  Under these circumstances, you very seldom need to use INSERT DELAYED\n  with MyISAM.\n\no INSERT DELAYED should be used only for INSERT statements that specify\n  value lists. This is enforced as of MySQL 4.0.18. The server ignores\n  DELAYED for INSERT ... SELECT or INSERT ... ON DUPLICATE KEY UPDATE\n  statements.\n\no Because the INSERT DELAYED statement returns immediately, before the\n  rows are inserted, you cannot use LAST_INSERT_ID() to get the\n  AUTO_INCREMENT value that the statement might generate.\n\no DELAYED rows are not visible to SELECT statements until they actually\n  have been inserted.\n\no DELAYED is ignored on slave replication servers because it could\n  cause the slave to have different data than the master.\n","","insert-delayed");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (398,20,"MEDIUMTEXT","MEDIUMTEXT\n\nA TEXT column with a maximum length of 16,777,215 (224 - 1) characters.\n","","string-type-overview");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (399,4,"LN","Syntax:\nLN(X)\n\nReturns the natural logarithm of X; that is, the base-e logarithm of X.\n","mysql> SELECT LN(2);\n        -> 0.693147\nmysql> SELECT LN(-2);\n        -> NULL\n","mathematical-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (400,24,"SHOW COLLATION","Syntax:\nSHOW COLLATION [LIKE 'pattern']\n\nThe output from SHOW COLLATION includes all available character sets.\nIt takes an optional LIKE clause whose pattern indicates which\ncollation names to match. For example:\n\nmysql> SHOW COLLATION LIKE 'latin1%';\n+-------------------+---------+----+---------+----------+---------+\n| Collation         | Charset | Id | Default | Compiled | Sortlen |\n+-------------------+---------+----+---------+----------+---------+\n| latin1_german1_ci | latin1  |  5 |         |          |       0 |\n| latin1_swedish_ci | latin1  |  8 | Yes     | Yes      |       0 |\n| latin1_danish_ci  | latin1  | 15 |         |          |       0 |\n| latin1_german2_ci | latin1  | 31 |         | Yes      |       2 |\n| latin1_bin        | latin1  | 47 |         | Yes      |       0 |\n| latin1_general_ci | latin1  | 48 |         |          |       0 |\n| latin1_general_cs | latin1  | 49 |         |          |       0 |\n| latin1_spanish_ci | latin1  | 94 |         |          |       0 |\n+-------------------+---------+----+---------+----------+---------+\n\nThe Default column indicates whether a collation is the default for its\ncharacter set. Compiled indicates whether the character set is compiled\ninto the server. Sortlen is related to the amount of memory required to\nsort strings expressed in the character set.\n","","show-collation");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (401,4,"LOG","Syntax:\nLOG(X), LOG(B,X)\n\nIf called with one parameter, this function returns the natural\nlogarithm of X.\n","mysql> SELECT LOG(2);\n        -> 0.693147\nmysql> SELECT LOG(-2);\n        -> NULL\n","mathematical-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (402,24,"SET SQL_LOG_BIN","Syntax:\nSET SQL_LOG_BIN = {0|1}\n\nDisables or enables binary logging for the current connection\n(SQL_LOG_BIN is a session variable) if the client that has the SUPER\nprivilege. The statement is refused with an error if the client does\nnot have that privilege. (Before MySQL 4.1.2, the statement was simply\nignored in that case.)\n","","set-sql-log-bin");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (403,17,"!=","Syntax:\n<>, !=\n\nNot equal:\n","mysql> SELECT '.01' <> '0.01';\n        -> 1\nmysql> SELECT .01 <> '0.01';\n        -> 0\nmysql> SELECT 'zapp' <> 'zappp';\n        -> 1\n","comparison-operators");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (404,10,"AES_DECRYPT","Syntax:\nAES_ENCRYPT(str,key_str), AES_DECRYPT(crypt_str,key_str)\n\nThese functions allow encryption and decryption of data using the\nofficial AES (Advanced Encryption Standard) algorithm, previously known\nas \"Rijndael.\" Encoding with a 128-bit key length is used, but you can\nextend it up to 256 bits by modifying the source. We chose 128 bits\nbecause it is much faster and it is secure enough for most purposes.\n\nAES_ENCRYPT() encrypts a string and returns a binary string.\nAES_DESCRIPT() descrypts the encrypted string and returns the original\nstring. The input arguments may be any length. If either argument is\nNULL, the result of this function is also NULL.\n\nBecause AES is a block-level algorithm, padding is used to encode\nuneven length strings and so the result string length may be calculated\nusing this formula:\n\n16 × (trunc(string_length / 16) + 1)\n\nIf AES_DECRYPT() detects invalid data or incorrect padding, it returns\nNULL. However, it is possible for AES_DECRYPT() to return a non-NULL\nvalue (possibly garbage) if the input data or the key is invalid.\n\nYou can use the AES functions to store data in an encrypted form by\nmodifying your queries:\n","INSERT INTO t VALUES (1,AES_ENCRYPT('text','password'));\n","encryption-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (405,27,"DAYNAME","Syntax:\nDAYNAME(date)\n\nReturns the name of the weekday for date.\n","mysql> SELECT DAYNAME('1998-02-05');\n        -> 'Thursday'\n","date-and-time-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (406,15,"COERCIBILITY","Syntax:\nCOERCIBILITY(str)\n\nReturns the collation coercibility value of the string argument.\n","mysql> SELECT COERCIBILITY('abc' COLLATE latin1_swedish_ci);\n        -> 0\nmysql> SELECT COERCIBILITY(USER());\n        -> 3\nmysql> SELECT COERCIBILITY('abc');\n        -> 4\n","information-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (407,20,"INT","INT[(M)] [UNSIGNED] [ZEROFILL]\n\nA normal-size integer. The signed range is -2147483648 to 2147483647.\nThe unsigned range is 0 to 4294967295.\n","","numeric-type-overview");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (408,11,"GLENGTH","GLength(ls)\n\nReturns as a double-precision number the length of the LineString value\nls in its associated spatial reference.\n","mysql> SET @ls = 'LineString(1 1,2 2,3 3)';\nmysql> SELECT GLength(GeomFromText(@ls));\n+----------------------------+\n| GLength(GeomFromText(@ls)) |\n+----------------------------+\n|            2.8284271247462 |\n+----------------------------+\n","linestring-property-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (409,4,"RADIANS","Syntax:\nRADIANS(X)\n\nReturns the argument X, converted from degrees to radians. (Note that\nπ radians equals 180 degrees.)\n","mysql> SELECT RADIANS(90);\n        -> 1.570796\n","mathematical-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (410,15,"COLLATION","Syntax:\nCOLLATION(str)\n\nReturns the collation of the string argument.\n","mysql> SELECT COLLATION('abc');\n        -> 'latin1_swedish_ci'\nmysql> SELECT COLLATION(_utf8'abc');\n        -> 'utf8_general_ci'\n","information-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (411,17,"COALESCE","Syntax:\nCOALESCE(value,...)\n\nReturns the first non-NULL value in the list, or NULL if there are no\nnon-NULL values.\n","mysql> SELECT COALESCE(NULL,1);\n        -> 1\nmysql> SELECT COALESCE(NULL,NULL,NULL);\n        -> NULL\n","comparison-operators");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (412,15,"VERSION","Syntax:\nVERSION()\n\nReturns a string that indicates the MySQL server version. As of MySQL\n4.1, the string has the utf8 character set.\n","mysql> SELECT VERSION();\n        -> '4.1.21-standard'\n","information-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (413,32,"MAKE_SET","Syntax:\nMAKE_SET(bits,str1,str2,...)\n\nReturns a set value (a string containing substrings separated by `,'\ncharacters) consisting of the strings that have the corresponding bit\nin bits set. str1 corresponds to bit 0, str2 to bit 1, and so on. NULL\nvalues in str1, str2, ... are not appended to the result.\n","mysql> SELECT MAKE_SET(1,'a','b','c');\n        -> 'a'\nmysql> SELECT MAKE_SET(1 | 4,'hello','nice','world');\n        -> 'hello,world'\nmysql> SELECT MAKE_SET(1 | 4,'hello','nice',NULL,'world');\n        -> 'hello'\nmysql> SELECT MAKE_SET(0,'a','b','c');\n        -> ''\n","string-functions");
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (414,32,"FIND_IN_SET","Syntax:\nFIND_IN_SET(str,strlist)\n\nReturns a value in the range of 1 to N if the string str is in the\nstring list strlist consisting of N substrings. A string list is a\nstring composed of substrings separated by `,' characters. If the first\nargument is a constant string and the second is a column of type SET,\nthe FIND_IN_SET() function is optimized to use bit arithmetic. Returns\n0 if str is not in strlist or if strlist is the empty string. Returns\nNULL if either argument is NULL. This function does not work properly\nif the first argument contains a comma (`,') character.\n","mysql> SELECT FIND_IN_SET('b','a,b,c,d');\n        -> 2\n","string-functions");

insert into help_keyword (help_keyword_id,name) values (0,"MIN");
insert into help_keyword (help_keyword_id,name) values (1,"JOIN");
insert into help_keyword (help_keyword_id,name) values (2,"SERIALIZABLE");
insert into help_keyword (help_keyword_id,name) values (3,"REPLACE");
insert into help_keyword (help_keyword_id,name) values (4,"RETURNS");
insert into help_keyword (help_keyword_id,name) values (5,"MASTER_SSL_CA");
insert into help_keyword (help_keyword_id,name) values (6,"NCHAR");
insert into help_keyword (help_keyword_id,name) values (7,"COLUMNS");
insert into help_keyword (help_keyword_id,name) values (8,"WORK");
insert into help_keyword (help_keyword_id,name) values (9,"DATETIME");
insert into help_keyword (help_keyword_id,name) values (10,"MODE");
insert into help_keyword (help_keyword_id,name) values (11,"OPEN");
insert into help_keyword (help_keyword_id,name) values (12,"INTEGER");
insert into help_keyword (help_keyword_id,name) values (13,"ESCAPE");
insert into help_keyword (help_keyword_id,name) values (14,"VALUE");
insert into help_keyword (help_keyword_id,name) values (15,"GEOMETRYCOLLECTIONFROMWKB");
insert into help_keyword (help_keyword_id,name) values (16,"SQL_BIG_RESULT");
insert into help_keyword (help_keyword_id,name) values (17,"DROP");
insert into help_keyword (help_keyword_id,name) values (18,"EVENTS");
insert into help_keyword (help_keyword_id,name) values (19,"MONTH");
insert into help_keyword (help_keyword_id,name) values (20,"DUPLICATE");
insert into help_keyword (help_keyword_id,name) values (21,"REPLICATION");
insert into help_keyword (help_keyword_id,name) values (22,"INNODB");
insert into help_keyword (help_keyword_id,name) values (23,"YEAR_MONTH");
insert into help_keyword (help_keyword_id,name) values (24,"SUBJECT");
insert into help_keyword (help_keyword_id,name) values (25,"PREPARE");
insert into help_keyword (help_keyword_id,name) values (26,"LOCK");
insert into help_keyword (help_keyword_id,name) values (27,"NDB");
insert into help_keyword (help_keyword_id,name) values (28,"CHECK");
insert into help_keyword (help_keyword_id,name) values (29,"FULL");
insert into help_keyword (help_keyword_id,name) values (30,"INT4");
insert into help_keyword (help_keyword_id,name) values (31,"BY");
insert into help_keyword (help_keyword_id,name) values (32,"NO");
insert into help_keyword (help_keyword_id,name) values (33,"MINUTE");
insert into help_keyword (help_keyword_id,name) values (34,"DATA");
insert into help_keyword (help_keyword_id,name) values (35,"DAY");
insert into help_keyword (help_keyword_id,name) values (36,"SHARE");
insert into help_keyword (help_keyword_id,name) values (37,"RAID_CHUNKSIZE");
insert into help_keyword (help_keyword_id,name) values (38,"REAL");
insert into help_keyword (help_keyword_id,name) values (39,"SEPARATOR");
insert into help_keyword (help_keyword_id,name) values (40,"DELETE");
insert into help_keyword (help_keyword_id,name) values (41,"ON");
insert into help_keyword (help_keyword_id,name) values (42,"CLOSE");
insert into help_keyword (help_keyword_id,name) values (43,"X509");
insert into help_keyword (help_keyword_id,name) values (44,"USE");
insert into help_keyword (help_keyword_id,name) values (45,"WHERE");
insert into help_keyword (help_keyword_id,name) values (46,"PRIVILEGES");
insert into help_keyword (help_keyword_id,name) values (47,"SPATIAL");
insert into help_keyword (help_keyword_id,name) values (48,"SUPER");
insert into help_keyword (help_keyword_id,name) values (49,"SQL_BUFFER_RESULT");
insert into help_keyword (help_keyword_id,name) values (50,"IGNORE");
insert into help_keyword (help_keyword_id,name) values (51,"QUICK");
insert into help_keyword (help_keyword_id,name) values (52,"SIGNED");
insert into help_keyword (help_keyword_id,name) values (53,"SECURITY");
insert into help_keyword (help_keyword_id,name) values (54,"POLYGONFROMWKB");
insert into help_keyword (help_keyword_id,name) values (55,"NDBCLUSTER");
insert into help_keyword (help_keyword_id,name) values (56,"FALSE");
insert into help_keyword (help_keyword_id,name) values (57,"LEVEL");
insert into help_keyword (help_keyword_id,name) values (58,"FORCE");
insert into help_keyword (help_keyword_id,name) values (59,"BINARY");
insert into help_keyword (help_keyword_id,name) values (60,"TO");
insert into help_keyword (help_keyword_id,name) values (61,"CHANGE");
insert into help_keyword (help_keyword_id,name) values (62,"HOUR_MINUTE");
insert into help_keyword (help_keyword_id,name) values (63,"UPDATE");
insert into help_keyword (help_keyword_id,name) values (64,"INTO");
insert into help_keyword (help_keyword_id,name) values (65,"VARYING");
insert into help_keyword (help_keyword_id,name) values (66,"HOUR_SECOND");
insert into help_keyword (help_keyword_id,name) values (67,"VARIABLE");
insert into help_keyword (help_keyword_id,name) values (68,"ROLLBACK");
insert into help_keyword (help_keyword_id,name) values (69,"MAX");
insert into help_keyword (help_keyword_id,name) values (70,"PROCEDURE");
insert into help_keyword (help_keyword_id,name) values (71,"RTREE");
insert into help_keyword (help_keyword_id,name) values (72,"TIMESTAMP");
insert into help_keyword (help_keyword_id,name) values (73,"IMPORT");
insert into help_keyword (help_keyword_id,name) values (74,"AGAINST");
insert into help_keyword (help_keyword_id,name) values (75,"CHECKSUM");
insert into help_keyword (help_keyword_id,name) values (76,"COUNT");
insert into help_keyword (help_keyword_id,name) values (77,"LONGBINARY");
insert into help_keyword (help_keyword_id,name) values (78,"THEN");
insert into help_keyword (help_keyword_id,name) values (79,"INSERT");
insert into help_keyword (help_keyword_id,name) values (80,"ENGINES");
insert into help_keyword (help_keyword_id,name) values (81,"DAY_SECOND");
insert into help_keyword (help_keyword_id,name) values (82,"EXISTS");
insert into help_keyword (help_keyword_id,name) values (83,"BOOLEAN");
insert into help_keyword (help_keyword_id,name) values (84,"MOD");
insert into help_keyword (help_keyword_id,name) values (85,"DEFAULT");
insert into help_keyword (help_keyword_id,name) values (86,"TYPE");
insert into help_keyword (help_keyword_id,name) values (87,"NO_WRITE_TO_BINLOG");
insert into help_keyword (help_keyword_id,name) values (88,"RESET");
insert into help_keyword (help_keyword_id,name) values (89,"BIGINT");
insert into help_keyword (help_keyword_id,name) values (90,"SET");
insert into help_keyword (help_keyword_id,name) values (91,"ISSUER");
insert into help_keyword (help_keyword_id,name) values (92,"DATE");
insert into help_keyword (help_keyword_id,name) values (93,"STATUS");
insert into help_keyword (help_keyword_id,name) values (94,"FULLTEXT");
insert into help_keyword (help_keyword_id,name) values (95,"COMMENT");
insert into help_keyword (help_keyword_id,name) values (96,"MASTER_CONNECT_RETRY");
insert into help_keyword (help_keyword_id,name) values (97,"INNER");
insert into help_keyword (help_keyword_id,name) values (98,"STOP");
insert into help_keyword (help_keyword_id,name) values (99,"MASTER_LOG_FILE");
insert into help_keyword (help_keyword_id,name) values (100,"MRG_MYISAM");
insert into help_keyword (help_keyword_id,name) values (101,"PRECISION");
insert into help_keyword (help_keyword_id,name) values (102,"REQUIRE");
insert into help_keyword (help_keyword_id,name) values (103,"TRAILING");
insert into help_keyword (help_keyword_id,name) values (104,"LONG");
insert into help_keyword (help_keyword_id,name) values (105,"OPTION");
insert into help_keyword (help_keyword_id,name) values (106,"ELSE");
insert into help_keyword (help_keyword_id,name) values (107,"DEALLOCATE");
insert into help_keyword (help_keyword_id,name) values (108,"IO_THREAD");
insert into help_keyword (help_keyword_id,name) values (109,"CASE");
insert into help_keyword (help_keyword_id,name) values (110,"CIPHER");
insert into help_keyword (help_keyword_id,name) values (111,"FROM");
insert into help_keyword (help_keyword_id,name) values (112,"READ");
insert into help_keyword (help_keyword_id,name) values (113,"LEFT");
insert into help_keyword (help_keyword_id,name) values (114,"MINUTE_SECOND");
insert into help_keyword (help_keyword_id,name) values (115,"COMPACT");
insert into help_keyword (help_keyword_id,name) values (116,"DEC");
insert into help_keyword (help_keyword_id,name) values (117,"FOR");
insert into help_keyword (help_keyword_id,name) values (118,"WARNINGS");
insert into help_keyword (help_keyword_id,name) values (119,"MIN_ROWS");
insert into help_keyword (help_keyword_id,name) values (120,"STRING");
insert into help_keyword (help_keyword_id,name) values (121,"FUNCTION");
insert into help_keyword (help_keyword_id,name) values (122,"ENCLOSED");
insert into help_keyword (help_keyword_id,name) values (123,"AGGREGATE");
insert into help_keyword (help_keyword_id,name) values (124,"FIELDS");
insert into help_keyword (help_keyword_id,name) values (125,"INT3");
insert into help_keyword (help_keyword_id,name) values (126,"ARCHIVE");
insert into help_keyword (help_keyword_id,name) values (127,"ADD");
insert into help_keyword (help_keyword_id,name) values (128,"AVG_ROW_LENGTH");
insert into help_keyword (help_keyword_id,name) values (129,"FLOAT4");
insert into help_keyword (help_keyword_id,name) values (130,"STRIPED");
insert into help_keyword (help_keyword_id,name) values (131,"REPEATABLE");
insert into help_keyword (help_keyword_id,name) values (132,"INFILE");
insert into help_keyword (help_keyword_id,name) values (133,"ORDER");
insert into help_keyword (help_keyword_id,name) values (134,"USING");
insert into help_keyword (help_keyword_id,name) values (135,"MIDDLEINT");
insert into help_keyword (help_keyword_id,name) values (136,"GRANT");
insert into help_keyword (help_keyword_id,name) values (137,"UNSIGNED");
insert into help_keyword (help_keyword_id,name) values (138,"DECIMAL");
insert into help_keyword (help_keyword_id,name) values (139,"GEOMETRYFROMTEXT");
insert into help_keyword (help_keyword_id,name) values (140,"INDEXES");
insert into help_keyword (help_keyword_id,name) values (141,"FOREIGN");
insert into help_keyword (help_keyword_id,name) values (142,"CACHE");
insert into help_keyword (help_keyword_id,name) values (143,"HOSTS");
insert into help_keyword (help_keyword_id,name) values (144,"COMMIT");
insert into help_keyword (help_keyword_id,name) values (145,"LEADING");
insert into help_keyword (help_keyword_id,name) values (146,"SNAPSHOT");
insert into help_keyword (help_keyword_id,name) values (147,"LOAD");
insert into help_keyword (help_keyword_id,name) values (148,"SQL_CACHE");
insert into help_keyword (help_keyword_id,name) values (149,"CONVERT");
insert into help_keyword (help_keyword_id,name) values (150,"DYNAMIC");
insert into help_keyword (help_keyword_id,name) values (151,"POLYGONFROMTEXT");
insert into help_keyword (help_keyword_id,name) values (152,"BYTE");
insert into help_keyword (help_keyword_id,name) values (153,"LINESTRINGFROMWKB");
insert into help_keyword (help_keyword_id,name) values (154,"GLOBAL");
insert into help_keyword (help_keyword_id,name) values (155,"BERKELEYDB");
insert into help_keyword (help_keyword_id,name) values (156,"WHEN");
insert into help_keyword (help_keyword_id,name) values (157,"HAVING");
insert into help_keyword (help_keyword_id,name) values (158,"AS");
insert into help_keyword (help_keyword_id,name) values (159,"STARTING");
insert into help_keyword (help_keyword_id,name) values (160,"RELOAD");
insert into help_keyword (help_keyword_id,name) values (161,"AUTOCOMMIT");
insert into help_keyword (help_keyword_id,name) values (162,"REVOKE");
insert into help_keyword (help_keyword_id,name) values (163,"GRANTS");
insert into help_keyword (help_keyword_id,name) values (164,"OUTER");
insert into help_keyword (help_keyword_id,name) values (165,"FLOOR");
insert into help_keyword (help_keyword_id,name) values (166,"WITH");
insert into help_keyword (help_keyword_id,name) values (167,"STD");
insert into help_keyword (help_keyword_id,name) values (168,"AFTER");
insert into help_keyword (help_keyword_id,name) values (169,"CSV");
insert into help_keyword (help_keyword_id,name) values (170,"DISABLE");
insert into help_keyword (help_keyword_id,name) values (171,"OUTFILE");
insert into help_keyword (help_keyword_id,name) values (172,"LOW_PRIORITY");
insert into help_keyword (help_keyword_id,name) values (173,"FILE");
insert into help_keyword (help_keyword_id,name) values (174,"BDB");
insert into help_keyword (help_keyword_id,name) values (175,"SONAME");
insert into help_keyword (help_keyword_id,name) values (176,"POW");
insert into help_keyword (help_keyword_id,name) values (177,"MULTIPOINTFROMWKB");
insert into help_keyword (help_keyword_id,name) values (178,"INDEX");
insert into help_keyword (help_keyword_id,name) values (179,"MULTIPOINTFROMTEXT");
insert into help_keyword (help_keyword_id,name) values (180,"BACKUP");
insert into help_keyword (help_keyword_id,name) values (181,"MULTILINESTRINGFROMWKB");
insert into help_keyword (help_keyword_id,name) values (182,"EXTENDED");
insert into help_keyword (help_keyword_id,name) values (183,"CROSS");
insert into help_keyword (help_keyword_id,name) values (184,"NATIONAL");
insert into help_keyword (help_keyword_id,name) values (185,"GROUP");
insert into help_keyword (help_keyword_id,name) values (186,"ZEROFILL");
insert into help_keyword (help_keyword_id,name) values (187,"CLIENT");
insert into help_keyword (help_keyword_id,name) values (188,"MASTER_PASSWORD");
insert into help_keyword (help_keyword_id,name) values (189,"RELAY_LOG_FILE");
insert into help_keyword (help_keyword_id,name) values (190,"TRUE");
insert into help_keyword (help_keyword_id,name) values (191,"CHARACTER");
insert into help_keyword (help_keyword_id,name) values (192,"MASTER_USER");
insert into help_keyword (help_keyword_id,name) values (193,"ENGINE");
insert into help_keyword (help_keyword_id,name) values (194,"TABLE");
insert into help_keyword (help_keyword_id,name) values (195,"INSERT_METHOD");
insert into help_keyword (help_keyword_id,name) values (196,"CASCADE");
insert into help_keyword (help_keyword_id,name) values (197,"RELAY_LOG_POS");
insert into help_keyword (help_keyword_id,name) values (198,"SQL_CALC_FOUND_ROWS");
insert into help_keyword (help_keyword_id,name) values (199,"MYISAM");
insert into help_keyword (help_keyword_id,name) values (200,"MODIFY");
insert into help_keyword (help_keyword_id,name) values (201,"MATCH");
insert into help_keyword (help_keyword_id,name) values (202,"MASTER_LOG_POS");
insert into help_keyword (help_keyword_id,name) values (203,"DESC");
insert into help_keyword (help_keyword_id,name) values (204,"DISTINCTROW");
insert into help_keyword (help_keyword_id,name) values (205,"TIME");
insert into help_keyword (help_keyword_id,name) values (206,"NUMERIC");
insert into help_keyword (help_keyword_id,name) values (207,"EXPANSION");
insert into help_keyword (help_keyword_id,name) values (208,"GEOMETRYCOLLECTIONFROMTEXT");
insert into help_keyword (help_keyword_id,name) values (209,"RAID_CHUNKS");
insert into help_keyword (help_keyword_id,name) values (210,"FLUSH");
insert into help_keyword (help_keyword_id,name) values (211,"CREATE");
insert into help_keyword (help_keyword_id,name) values (212,"ISAM");
insert into help_keyword (help_keyword_id,name) values (213,"MAX_UPDATES_PER_HOUR");
insert into help_keyword (help_keyword_id,name) values (214,"INT2");
insert into help_keyword (help_keyword_id,name) values (215,"PROCESSLIST");
insert into help_keyword (help_keyword_id,name) values (216,"LOGS");
insert into help_keyword (help_keyword_id,name) values (217,"HEAP");
insert into help_keyword (help_keyword_id,name) values (218,"SOUNDS");
insert into help_keyword (help_keyword_id,name) values (219,"BETWEEN");
insert into help_keyword (help_keyword_id,name) values (220,"MULTILINESTRINGFROMTEXT");
insert into help_keyword (help_keyword_id,name) values (221,"PACK_KEYS");
insert into help_keyword (help_keyword_id,name) values (222,"FAST");
insert into help_keyword (help_keyword_id,name) values (223,"VALUES");
insert into help_keyword (help_keyword_id,name) values (224,"VARCHARACTER");
insert into help_keyword (help_keyword_id,name) values (225,"BEFORE");
insert into help_keyword (help_keyword_id,name) values (226,"SHOW");
insert into help_keyword (help_keyword_id,name) values (227,"REDUNDANT");
insert into help_keyword (help_keyword_id,name) values (228,"ALL");
insert into help_keyword (help_keyword_id,name) values (229,"USER_RESOURCES");
insert into help_keyword (help_keyword_id,name) values (230,"PARTIAL");
insert into help_keyword (help_keyword_id,name) values (231,"BINLOG");
insert into help_keyword (help_keyword_id,name) values (232,"END");
insert into help_keyword (help_keyword_id,name) values (233,"SECOND");
insert into help_keyword (help_keyword_id,name) values (234,"AND");
insert into help_keyword (help_keyword_id,name) values (235,"FLOAT8");
insert into help_keyword (help_keyword_id,name) values (236,"PREV");
insert into help_keyword (help_keyword_id,name) values (237,"HOUR");
insert into help_keyword (help_keyword_id,name) values (238,"SELECT");
insert into help_keyword (help_keyword_id,name) values (239,"DATABASES");
insert into help_keyword (help_keyword_id,name) values (240,"OR");
insert into help_keyword (help_keyword_id,name) values (241,"IDENTIFIED");
insert into help_keyword (help_keyword_id,name) values (242,"MASTER_SSL_CIPHER");
insert into help_keyword (help_keyword_id,name) values (243,"SQL_SLAVE_SKIP_COUNTER");
insert into help_keyword (help_keyword_id,name) values (244,"BOTH");
insert into help_keyword (help_keyword_id,name) values (245,"BOOL");
insert into help_keyword (help_keyword_id,name) values (246,"YEAR");
insert into help_keyword (help_keyword_id,name) values (247,"MASTER_PORT");
insert into help_keyword (help_keyword_id,name) values (248,"CONCURRENT");
insert into help_keyword (help_keyword_id,name) values (249,"UNIQUE");
insert into help_keyword (help_keyword_id,name) values (250,"PROCESS");
insert into help_keyword (help_keyword_id,name) values (251,"CONSISTENT");
insert into help_keyword (help_keyword_id,name) values (252,"MASTER_SSL");
insert into help_keyword (help_keyword_id,name) values (253,"DATE_ADD");
insert into help_keyword (help_keyword_id,name) values (254,"MAX_CONNECTIONS_PER_HOUR");
insert into help_keyword (help_keyword_id,name) values (255,"LIKE");
insert into help_keyword (help_keyword_id,name) values (256,"IN");
insert into help_keyword (help_keyword_id,name) values (257,"COLUMN");
insert into help_keyword (help_keyword_id,name) values (258,"DUMPFILE");
insert into help_keyword (help_keyword_id,name) values (259,"USAGE");
insert into help_keyword (help_keyword_id,name) values (260,"EXECUTE");
insert into help_keyword (help_keyword_id,name) values (261,"MEMORY");
insert into help_keyword (help_keyword_id,name) values (262,"CEIL");
insert into help_keyword (help_keyword_id,name) values (263,"QUERY");
insert into help_keyword (help_keyword_id,name) values (264,"MASTER_HOST");
insert into help_keyword (help_keyword_id,name) values (265,"LINES");
insert into help_keyword (help_keyword_id,name) values (266,"SQL_THREAD");
insert into help_keyword (help_keyword_id,name) values (267,"MAX_QUERIES_PER_HOUR");
insert into help_keyword (help_keyword_id,name) values (268,"MULTIPOLYGONFROMWKB");
insert into help_keyword (help_keyword_id,name) values (269,"MASTER_SSL_CERT");
insert into help_keyword (help_keyword_id,name) values (270,"DAY_MINUTE");
insert into help_keyword (help_keyword_id,name) values (271,"TRANSACTION");
insert into help_keyword (help_keyword_id,name) values (272,"DATE_SUB");
insert into help_keyword (help_keyword_id,name) values (273,"GEOMETRYFROMWKB");
insert into help_keyword (help_keyword_id,name) values (274,"RENAME");
insert into help_keyword (help_keyword_id,name) values (275,"INT1");
insert into help_keyword (help_keyword_id,name) values (276,"ALTER");
insert into help_keyword (help_keyword_id,name) values (277,"MAX_ROWS");
insert into help_keyword (help_keyword_id,name) values (278,"RIGHT");
insert into help_keyword (help_keyword_id,name) values (279,"STRAIGHT_JOIN");
insert into help_keyword (help_keyword_id,name) values (280,"NATURAL");
insert into help_keyword (help_keyword_id,name) values (281,"VARIABLES");
insert into help_keyword (help_keyword_id,name) values (282,"ESCAPED");
insert into help_keyword (help_keyword_id,name) values (283,"SHA1");
insert into help_keyword (help_keyword_id,name) values (284,"PASSWORD");
insert into help_keyword (help_keyword_id,name) values (285,"RAID_TYPE");
insert into help_keyword (help_keyword_id,name) values (286,"CHAR");
insert into help_keyword (help_keyword_id,name) values (287,"OFFSET");
insert into help_keyword (help_keyword_id,name) values (288,"NEXT");
insert into help_keyword (help_keyword_id,name) values (289,"SQL_LOG_BIN");
insert into help_keyword (help_keyword_id,name) values (290,"ERRORS");
insert into help_keyword (help_keyword_id,name) values (291,"TEMPORARY");
insert into help_keyword (help_keyword_id,name) values (292,"SQL_SMALL_RESULT");
insert into help_keyword (help_keyword_id,name) values (293,"COMMITTED");
insert into help_keyword (help_keyword_id,name) values (294,"DELAY_KEY_WRITE");
insert into help_keyword (help_keyword_id,name) values (295,"BEGIN");
insert into help_keyword (help_keyword_id,name) values (296,"MEDIUM");
insert into help_keyword (help_keyword_id,name) values (297,"INTERVAL");
insert into help_keyword (help_keyword_id,name) values (298,"SSL");
insert into help_keyword (help_keyword_id,name) values (299,"DAY_HOUR");
insert into help_keyword (help_keyword_id,name) values (300,"REFERENCES");
insert into help_keyword (help_keyword_id,name) values (301,"AES_ENCRYPT");
insert into help_keyword (help_keyword_id,name) values (302,"STORAGE");
insert into help_keyword (help_keyword_id,name) values (303,"ISOLATION");
insert into help_keyword (help_keyword_id,name) values (304,"INT8");
insert into help_keyword (help_keyword_id,name) values (305,"RESTRICT");
insert into help_keyword (help_keyword_id,name) values (306,"LINESTRINGFROMTEXT");
insert into help_keyword (help_keyword_id,name) values (307,"UNCOMMITTED");
insert into help_keyword (help_keyword_id,name) values (308,"IS");
insert into help_keyword (help_keyword_id,name) values (309,"NOT");
insert into help_keyword (help_keyword_id,name) values (310,"DES_KEY_FILE");
insert into help_keyword (help_keyword_id,name) values (311,"COMPRESSED");
insert into help_keyword (help_keyword_id,name) values (312,"START");
insert into help_keyword (help_keyword_id,name) values (313,"IF");
insert into help_keyword (help_keyword_id,name) values (314,"SAVEPOINT");
insert into help_keyword (help_keyword_id,name) values (315,"PRIMARY");
insert into help_keyword (help_keyword_id,name) values (316,"INNOBASE");
insert into help_keyword (help_keyword_id,name) values (317,"LAST");
insert into help_keyword (help_keyword_id,name) values (318,"KEYS");
insert into help_keyword (help_keyword_id,name) values (319,"LIMIT");
insert into help_keyword (help_keyword_id,name) values (320,"KEY");
insert into help_keyword (help_keyword_id,name) values (321,"MERGE");
insert into help_keyword (help_keyword_id,name) values (322,"SQL_NO_CACHE");
insert into help_keyword (help_keyword_id,name) values (323,"DELAYED");
insert into help_keyword (help_keyword_id,name) values (324,"CONSTRAINT");
insert into help_keyword (help_keyword_id,name) values (325,"SERIAL");
insert into help_keyword (help_keyword_id,name) values (326,"ACTION");
insert into help_keyword (help_keyword_id,name) values (327,"WRITE");
insert into help_keyword (help_keyword_id,name) values (328,"SESSION");
insert into help_keyword (help_keyword_id,name) values (329,"DATABASE");
insert into help_keyword (help_keyword_id,name) values (330,"NULL");
insert into help_keyword (help_keyword_id,name) values (331,"USE_FRM");
insert into help_keyword (help_keyword_id,name) values (332,"SLAVE");
insert into help_keyword (help_keyword_id,name) values (333,"TERMINATED");
insert into help_keyword (help_keyword_id,name) values (334,"ASC");
insert into help_keyword (help_keyword_id,name) values (335,"ENABLE");
insert into help_keyword (help_keyword_id,name) values (336,"OPTIONALLY");
insert into help_keyword (help_keyword_id,name) values (337,"DIRECTORY");
insert into help_keyword (help_keyword_id,name) values (338,"MAX_USER_CONNECTIONS");
insert into help_keyword (help_keyword_id,name) values (339,"DISTINCT");
insert into help_keyword (help_keyword_id,name) values (340,"LOCAL");
insert into help_keyword (help_keyword_id,name) values (341,"MASTER_SSL_KEY");
insert into help_keyword (help_keyword_id,name) values (342,"NONE");
insert into help_keyword (help_keyword_id,name) values (343,"TABLES");
insert into help_keyword (help_keyword_id,name) values (344,"<>");
insert into help_keyword (help_keyword_id,name) values (345,"RLIKE");
insert into help_keyword (help_keyword_id,name) values (346,"COLLATION");
insert into help_keyword (help_keyword_id,name) values (347,"SHUTDOWN");
insert into help_keyword (help_keyword_id,name) values (348,"HIGH_PRIORITY");
insert into help_keyword (help_keyword_id,name) values (349,"BTREE");
insert into help_keyword (help_keyword_id,name) values (350,"FIRST");
insert into help_keyword (help_keyword_id,name) values (351,"TYPES");
insert into help_keyword (help_keyword_id,name) values (352,"MASTER");
insert into help_keyword (help_keyword_id,name) values (353,"FIXED");
insert into help_keyword (help_keyword_id,name) values (354,"RAID0");
insert into help_keyword (help_keyword_id,name) values (355,"MULTIPOLYGONFROMTEXT");
insert into help_keyword (help_keyword_id,name) values (356,"ROW_FORMAT");

insert into help_relation (help_topic_id,help_keyword_id) values (388,0);
insert into help_relation (help_topic_id,help_keyword_id) values (290,1);
insert into help_relation (help_topic_id,help_keyword_id) values (362,2);
insert into help_relation (help_topic_id,help_keyword_id) values (344,3);
insert into help_relation (help_topic_id,help_keyword_id) values (166,4);
insert into help_relation (help_topic_id,help_keyword_id) values (147,5);
insert into help_relation (help_topic_id,help_keyword_id) values (349,6);
insert into help_relation (help_topic_id,help_keyword_id) values (281,7);
insert into help_relation (help_topic_id,help_keyword_id) values (13,7);
insert into help_relation (help_topic_id,help_keyword_id) values (110,8);
insert into help_relation (help_topic_id,help_keyword_id) values (308,9);
insert into help_relation (help_topic_id,help_keyword_id) values (61,10);
insert into help_relation (help_topic_id,help_keyword_id) values (290,10);
insert into help_relation (help_topic_id,help_keyword_id) values (99,11);
insert into help_relation (help_topic_id,help_keyword_id) values (281,11);
insert into help_relation (help_topic_id,help_keyword_id) values (76,11);
insert into help_relation (help_topic_id,help_keyword_id) values (407,12);
insert into help_relation (help_topic_id,help_keyword_id) values (166,12);
insert into help_relation (help_topic_id,help_keyword_id) values (311,13);
insert into help_relation (help_topic_id,help_keyword_id) values (193,14);
insert into help_relation (help_topic_id,help_keyword_id) values (78,15);
insert into help_relation (help_topic_id,help_keyword_id) values (290,16);
insert into help_relation (help_topic_id,help_keyword_id) values (60,17);
insert into help_relation (help_topic_id,help_keyword_id) values (188,17);
insert into help_relation (help_topic_id,help_keyword_id) values (148,17);
insert into help_relation (help_topic_id,help_keyword_id) values (333,17);
insert into help_relation (help_topic_id,help_keyword_id) values (221,17);
insert into help_relation (help_topic_id,help_keyword_id) values (375,17);
insert into help_relation (help_topic_id,help_keyword_id) values (90,18);
insert into help_relation (help_topic_id,help_keyword_id) values (19,19);
insert into help_relation (help_topic_id,help_keyword_id) values (74,20);
insert into help_relation (help_topic_id,help_keyword_id) values (158,21);
insert into help_relation (help_topic_id,help_keyword_id) values (328,22);
insert into help_relation (help_topic_id,help_keyword_id) values (281,22);
insert into help_relation (help_topic_id,help_keyword_id) values (380,22);
insert into help_relation (help_topic_id,help_keyword_id) values (19,23);
insert into help_relation (help_topic_id,help_keyword_id) values (158,24);
insert into help_relation (help_topic_id,help_keyword_id) values (22,25);
insert into help_relation (help_topic_id,help_keyword_id) values (188,25);
insert into help_relation (help_topic_id,help_keyword_id) values (290,26);
insert into help_relation (help_topic_id,help_keyword_id) values (380,27);
insert into help_relation (help_topic_id,help_keyword_id) values (380,28);
insert into help_relation (help_topic_id,help_keyword_id) values (281,29);
insert into help_relation (help_topic_id,help_keyword_id) values (13,29);
insert into help_relation (help_topic_id,help_keyword_id) values (380,29);
insert into help_relation (help_topic_id,help_keyword_id) values (367,29);
insert into help_relation (help_topic_id,help_keyword_id) values (407,30);
insert into help_relation (help_topic_id,help_keyword_id) values (33,31);
insert into help_relation (help_topic_id,help_keyword_id) values (380,31);
insert into help_relation (help_topic_id,help_keyword_id) values (58,31);
insert into help_relation (help_topic_id,help_keyword_id) values (158,31);
insert into help_relation (help_topic_id,help_keyword_id) values (290,31);
insert into help_relation (help_topic_id,help_keyword_id) values (344,31);
insert into help_relation (help_topic_id,help_keyword_id) values (296,31);
insert into help_relation (help_topic_id,help_keyword_id) values (375,31);
insert into help_relation (help_topic_id,help_keyword_id) values (384,32);
insert into help_relation (help_topic_id,help_keyword_id) values (380,32);
insert into help_relation (help_topic_id,help_keyword_id) values (19,33);
insert into help_relation (help_topic_id,help_keyword_id) values (86,34);
insert into help_relation (help_topic_id,help_keyword_id) values (380,34);
insert into help_relation (help_topic_id,help_keyword_id) values (344,34);
insert into help_relation (help_topic_id,help_keyword_id) values (19,35);
insert into help_relation (help_topic_id,help_keyword_id) values (290,36);
insert into help_relation (help_topic_id,help_keyword_id) values (380,37);
insert into help_relation (help_topic_id,help_keyword_id) values (255,38);
insert into help_relation (help_topic_id,help_keyword_id) values (166,38);
insert into help_relation (help_topic_id,help_keyword_id) values (296,39);
insert into help_relation (help_topic_id,help_keyword_id) values (384,40);
insert into help_relation (help_topic_id,help_keyword_id) values (380,40);
insert into help_relation (help_topic_id,help_keyword_id) values (384,41);
insert into help_relation (help_topic_id,help_keyword_id) values (0,41);
insert into help_relation (help_topic_id,help_keyword_id) values (76,42);
insert into help_relation (help_topic_id,help_keyword_id) values (158,43);
insert into help_relation (help_topic_id,help_keyword_id) values (0,44);
insert into help_relation (help_topic_id,help_keyword_id) values (33,45);
insert into help_relation (help_topic_id,help_keyword_id) values (58,45);
insert into help_relation (help_topic_id,help_keyword_id) values (76,45);
insert into help_relation (help_topic_id,help_keyword_id) values (152,46);
insert into help_relation (help_topic_id,help_keyword_id) values (199,46);
insert into help_relation (help_topic_id,help_keyword_id) values (158,46);
insert into help_relation (help_topic_id,help_keyword_id) values (168,47);
insert into help_relation (help_topic_id,help_keyword_id) values (375,47);
insert into help_relation (help_topic_id,help_keyword_id) values (158,48);
insert into help_relation (help_topic_id,help_keyword_id) values (290,49);
insert into help_relation (help_topic_id,help_keyword_id) values (0,50);
insert into help_relation (help_topic_id,help_keyword_id) values (290,50);
insert into help_relation (help_topic_id,help_keyword_id) values (74,50);
insert into help_relation (help_topic_id,help_keyword_id) values (58,50);
insert into help_relation (help_topic_id,help_keyword_id) values (344,50);
insert into help_relation (help_topic_id,help_keyword_id) values (375,50);
insert into help_relation (help_topic_id,help_keyword_id) values (378,51);
insert into help_relation (help_topic_id,help_keyword_id) values (340,51);
insert into help_relation (help_topic_id,help_keyword_id) values (33,51);
insert into help_relation (help_topic_id,help_keyword_id) values (308,52);
insert into help_relation (help_topic_id,help_keyword_id) values (158,53);
insert into help_relation (help_topic_id,help_keyword_id) values (63,54);
insert into help_relation (help_topic_id,help_keyword_id) values (393,54);
insert into help_relation (help_topic_id,help_keyword_id) values (380,55);
insert into help_relation (help_topic_id,help_keyword_id) values (314,56);
insert into help_relation (help_topic_id,help_keyword_id) values (362,57);
insert into help_relation (help_topic_id,help_keyword_id) values (0,58);
insert into help_relation (help_topic_id,help_keyword_id) values (243,59);
insert into help_relation (help_topic_id,help_keyword_id) values (308,59);
insert into help_relation (help_topic_id,help_keyword_id) values (376,60);
insert into help_relation (help_topic_id,help_keyword_id) values (372,60);
insert into help_relation (help_topic_id,help_keyword_id) values (147,60);
insert into help_relation (help_topic_id,help_keyword_id) values (147,61);
insert into help_relation (help_topic_id,help_keyword_id) values (375,61);
insert into help_relation (help_topic_id,help_keyword_id) values (19,62);
insert into help_relation (help_topic_id,help_keyword_id) values (384,63);
insert into help_relation (help_topic_id,help_keyword_id) values (290,63);
insert into help_relation (help_topic_id,help_keyword_id) values (74,63);
insert into help_relation (help_topic_id,help_keyword_id) values (247,64);
insert into help_relation (help_topic_id,help_keyword_id) values (290,64);
insert into help_relation (help_topic_id,help_keyword_id) values (74,64);
insert into help_relation (help_topic_id,help_keyword_id) values (29,64);
insert into help_relation (help_topic_id,help_keyword_id) values (207,65);
insert into help_relation (help_topic_id,help_keyword_id) values (19,66);
insert into help_relation (help_topic_id,help_keyword_id) values (96,67);
insert into help_relation (help_topic_id,help_keyword_id) values (110,68);
insert into help_relation (help_topic_id,help_keyword_id) values (372,68);
insert into help_relation (help_topic_id,help_keyword_id) values (388,69);
insert into help_relation (help_topic_id,help_keyword_id) values (290,70);
insert into help_relation (help_topic_id,help_keyword_id) values (168,71);
insert into help_relation (help_topic_id,help_keyword_id) values (149,72);
insert into help_relation (help_topic_id,help_keyword_id) values (69,72);
insert into help_relation (help_topic_id,help_keyword_id) values (344,73);
insert into help_relation (help_topic_id,help_keyword_id) values (61,74);
insert into help_relation (help_topic_id,help_keyword_id) values (380,75);
insert into help_relation (help_topic_id,help_keyword_id) values (46,76);
insert into help_relation (help_topic_id,help_keyword_id) values (352,76);
insert into help_relation (help_topic_id,help_keyword_id) values (268,76);
insert into help_relation (help_topic_id,help_keyword_id) values (230,77);
insert into help_relation (help_topic_id,help_keyword_id) values (342,78);
insert into help_relation (help_topic_id,help_keyword_id) values (153,79);
insert into help_relation (help_topic_id,help_keyword_id) values (74,79);
insert into help_relation (help_topic_id,help_keyword_id) values (397,79);
insert into help_relation (help_topic_id,help_keyword_id) values (281,80);
insert into help_relation (help_topic_id,help_keyword_id) values (226,80);
insert into help_relation (help_topic_id,help_keyword_id) values (19,81);
insert into help_relation (help_topic_id,help_keyword_id) values (119,82);
insert into help_relation (help_topic_id,help_keyword_id) values (148,82);
insert into help_relation (help_topic_id,help_keyword_id) values (221,82);
insert into help_relation (help_topic_id,help_keyword_id) values (61,83);
insert into help_relation (help_topic_id,help_keyword_id) values (15,83);
insert into help_relation (help_topic_id,help_keyword_id) values (135,84);
insert into help_relation (help_topic_id,help_keyword_id) values (74,85);
insert into help_relation (help_topic_id,help_keyword_id) values (380,85);
insert into help_relation (help_topic_id,help_keyword_id) values (193,85);
insert into help_relation (help_topic_id,help_keyword_id) values (375,85);
insert into help_relation (help_topic_id,help_keyword_id) values (380,86);
insert into help_relation (help_topic_id,help_keyword_id) values (375,86);
insert into help_relation (help_topic_id,help_keyword_id) values (378,87);
insert into help_relation (help_topic_id,help_keyword_id) values (267,87);
insert into help_relation (help_topic_id,help_keyword_id) values (83,87);
insert into help_relation (help_topic_id,help_keyword_id) values (382,87);
insert into help_relation (help_topic_id,help_keyword_id) values (24,88);
insert into help_relation (help_topic_id,help_keyword_id) values (212,88);
insert into help_relation (help_topic_id,help_keyword_id) values (115,88);
insert into help_relation (help_topic_id,help_keyword_id) values (177,89);
insert into help_relation (help_topic_id,help_keyword_id) values (271,90);
insert into help_relation (help_topic_id,help_keyword_id) values (110,90);
insert into help_relation (help_topic_id,help_keyword_id) values (384,90);
insert into help_relation (help_topic_id,help_keyword_id) values (144,90);
insert into help_relation (help_topic_id,help_keyword_id) values (402,90);
insert into help_relation (help_topic_id,help_keyword_id) values (169,90);
insert into help_relation (help_topic_id,help_keyword_id) values (58,90);
insert into help_relation (help_topic_id,help_keyword_id) values (29,90);
insert into help_relation (help_topic_id,help_keyword_id) values (375,90);
insert into help_relation (help_topic_id,help_keyword_id) values (158,91);
insert into help_relation (help_topic_id,help_keyword_id) values (211,92);
insert into help_relation (help_topic_id,help_keyword_id) values (97,92);
insert into help_relation (help_topic_id,help_keyword_id) values (308,92);
insert into help_relation (help_topic_id,help_keyword_id) values (19,92);
insert into help_relation (help_topic_id,help_keyword_id) values (328,93);
insert into help_relation (help_topic_id,help_keyword_id) values (281,93);
insert into help_relation (help_topic_id,help_keyword_id) values (39,93);
insert into help_relation (help_topic_id,help_keyword_id) values (300,93);
insert into help_relation (help_topic_id,help_keyword_id) values (102,93);
insert into help_relation (help_topic_id,help_keyword_id) values (178,93);
insert into help_relation (help_topic_id,help_keyword_id) values (171,93);
insert into help_relation (help_topic_id,help_keyword_id) values (380,94);
insert into help_relation (help_topic_id,help_keyword_id) values (168,94);
insert into help_relation (help_topic_id,help_keyword_id) values (375,94);
insert into help_relation (help_topic_id,help_keyword_id) values (380,95);
insert into help_relation (help_topic_id,help_keyword_id) values (147,96);
insert into help_relation (help_topic_id,help_keyword_id) values (0,97);
insert into help_relation (help_topic_id,help_keyword_id) values (36,98);
insert into help_relation (help_topic_id,help_keyword_id) values (147,99);
insert into help_relation (help_topic_id,help_keyword_id) values (380,100);
insert into help_relation (help_topic_id,help_keyword_id) values (255,101);
insert into help_relation (help_topic_id,help_keyword_id) values (158,102);
insert into help_relation (help_topic_id,help_keyword_id) values (369,103);
insert into help_relation (help_topic_id,help_keyword_id) values (230,104);
insert into help_relation (help_topic_id,help_keyword_id) values (158,105);
insert into help_relation (help_topic_id,help_keyword_id) values (342,106);
insert into help_relation (help_topic_id,help_keyword_id) values (188,107);
insert into help_relation (help_topic_id,help_keyword_id) values (36,108);
insert into help_relation (help_topic_id,help_keyword_id) values (266,108);
insert into help_relation (help_topic_id,help_keyword_id) values (342,109);
insert into help_relation (help_topic_id,help_keyword_id) values (158,110);
insert into help_relation (help_topic_id,help_keyword_id) values (281,111);
insert into help_relation (help_topic_id,help_keyword_id) values (86,111);
insert into help_relation (help_topic_id,help_keyword_id) values (369,111);
insert into help_relation (help_topic_id,help_keyword_id) values (33,111);
insert into help_relation (help_topic_id,help_keyword_id) values (90,111);
insert into help_relation (help_topic_id,help_keyword_id) values (290,111);
insert into help_relation (help_topic_id,help_keyword_id) values (295,111);
insert into help_relation (help_topic_id,help_keyword_id) values (362,112);
insert into help_relation (help_topic_id,help_keyword_id) values (23,112);
insert into help_relation (help_topic_id,help_keyword_id) values (76,112);
insert into help_relation (help_topic_id,help_keyword_id) values (0,113);
insert into help_relation (help_topic_id,help_keyword_id) values (19,114);
insert into help_relation (help_topic_id,help_keyword_id) values (380,115);
insert into help_relation (help_topic_id,help_keyword_id) values (165,116);
insert into help_relation (help_topic_id,help_keyword_id) values (281,117);
insert into help_relation (help_topic_id,help_keyword_id) values (290,117);
insert into help_relation (help_topic_id,help_keyword_id) values (281,118);
insert into help_relation (help_topic_id,help_keyword_id) values (268,118);
insert into help_relation (help_topic_id,help_keyword_id) values (380,119);
insert into help_relation (help_topic_id,help_keyword_id) values (166,120);
insert into help_relation (help_topic_id,help_keyword_id) values (166,121);
insert into help_relation (help_topic_id,help_keyword_id) values (333,121);
insert into help_relation (help_topic_id,help_keyword_id) values (344,122);
insert into help_relation (help_topic_id,help_keyword_id) values (166,123);
insert into help_relation (help_topic_id,help_keyword_id) values (281,124);
insert into help_relation (help_topic_id,help_keyword_id) values (344,124);
insert into help_relation (help_topic_id,help_keyword_id) values (202,125);
insert into help_relation (help_topic_id,help_keyword_id) values (380,126);
insert into help_relation (help_topic_id,help_keyword_id) values (41,127);
insert into help_relation (help_topic_id,help_keyword_id) values (375,127);
insert into help_relation (help_topic_id,help_keyword_id) values (380,128);
insert into help_relation (help_topic_id,help_keyword_id) values (375,128);
insert into help_relation (help_topic_id,help_keyword_id) values (130,129);
insert into help_relation (help_topic_id,help_keyword_id) values (380,130);
insert into help_relation (help_topic_id,help_keyword_id) values (362,131);
insert into help_relation (help_topic_id,help_keyword_id) values (344,132);
insert into help_relation (help_topic_id,help_keyword_id) values (33,133);
insert into help_relation (help_topic_id,help_keyword_id) values (290,133);
insert into help_relation (help_topic_id,help_keyword_id) values (58,133);
insert into help_relation (help_topic_id,help_keyword_id) values (375,133);
insert into help_relation (help_topic_id,help_keyword_id) values (296,133);
insert into help_relation (help_topic_id,help_keyword_id) values (0,134);
insert into help_relation (help_topic_id,help_keyword_id) values (59,134);
insert into help_relation (help_topic_id,help_keyword_id) values (33,134);
insert into help_relation (help_topic_id,help_keyword_id) values (202,135);
insert into help_relation (help_topic_id,help_keyword_id) values (158,136);
insert into help_relation (help_topic_id,help_keyword_id) values (255,137);
insert into help_relation (help_topic_id,help_keyword_id) values (407,137);
insert into help_relation (help_topic_id,help_keyword_id) values (165,137);
insert into help_relation (help_topic_id,help_keyword_id) values (15,137);
insert into help_relation (help_topic_id,help_keyword_id) values (308,137);
insert into help_relation (help_topic_id,help_keyword_id) values (130,137);
insert into help_relation (help_topic_id,help_keyword_id) values (95,137);
insert into help_relation (help_topic_id,help_keyword_id) values (120,138);
insert into help_relation (help_topic_id,help_keyword_id) values (337,139);
insert into help_relation (help_topic_id,help_keyword_id) values (281,140);
insert into help_relation (help_topic_id,help_keyword_id) values (384,141);
insert into help_relation (help_topic_id,help_keyword_id) values (380,141);
insert into help_relation (help_topic_id,help_keyword_id) values (375,141);
insert into help_relation (help_topic_id,help_keyword_id) values (247,142);
insert into help_relation (help_topic_id,help_keyword_id) values (72,142);
insert into help_relation (help_topic_id,help_keyword_id) values (115,142);
insert into help_relation (help_topic_id,help_keyword_id) values (109,143);
insert into help_relation (help_topic_id,help_keyword_id) values (281,143);
insert into help_relation (help_topic_id,help_keyword_id) values (110,144);
insert into help_relation (help_topic_id,help_keyword_id) values (369,145);
insert into help_relation (help_topic_id,help_keyword_id) values (110,146);
insert into help_relation (help_topic_id,help_keyword_id) values (247,147);
insert into help_relation (help_topic_id,help_keyword_id) values (86,147);
insert into help_relation (help_topic_id,help_keyword_id) values (344,147);
insert into help_relation (help_topic_id,help_keyword_id) values (295,147);
insert into help_relation (help_topic_id,help_keyword_id) values (290,148);
insert into help_relation (help_topic_id,help_keyword_id) values (308,149);
insert into help_relation (help_topic_id,help_keyword_id) values (380,150);
insert into help_relation (help_topic_id,help_keyword_id) values (323,151);
insert into help_relation (help_topic_id,help_keyword_id) values (377,152);
insert into help_relation (help_topic_id,help_keyword_id) values (366,153);
insert into help_relation (help_topic_id,help_keyword_id) values (96,154);
insert into help_relation (help_topic_id,help_keyword_id) values (362,154);
insert into help_relation (help_topic_id,help_keyword_id) values (144,154);
insert into help_relation (help_topic_id,help_keyword_id) values (284,154);
insert into help_relation (help_topic_id,help_keyword_id) values (380,155);
insert into help_relation (help_topic_id,help_keyword_id) values (342,156);
insert into help_relation (help_topic_id,help_keyword_id) values (290,157);
insert into help_relation (help_topic_id,help_keyword_id) values (0,158);
insert into help_relation (help_topic_id,help_keyword_id) values (23,158);
insert into help_relation (help_topic_id,help_keyword_id) values (290,158);
insert into help_relation (help_topic_id,help_keyword_id) values (344,159);
insert into help_relation (help_topic_id,help_keyword_id) values (158,160);
insert into help_relation (help_topic_id,help_keyword_id) values (110,161);
insert into help_relation (help_topic_id,help_keyword_id) values (199,162);
insert into help_relation (help_topic_id,help_keyword_id) values (281,163);
insert into help_relation (help_topic_id,help_keyword_id) values (151,163);
insert into help_relation (help_topic_id,help_keyword_id) values (0,164);
insert into help_relation (help_topic_id,help_keyword_id) values (177,165);
insert into help_relation (help_topic_id,help_keyword_id) values (61,166);
insert into help_relation (help_topic_id,help_keyword_id) values (158,166);
insert into help_relation (help_topic_id,help_keyword_id) values (334,167);
insert into help_relation (help_topic_id,help_keyword_id) values (375,168);
insert into help_relation (help_topic_id,help_keyword_id) values (380,169);
insert into help_relation (help_topic_id,help_keyword_id) values (344,169);
insert into help_relation (help_topic_id,help_keyword_id) values (375,170);
insert into help_relation (help_topic_id,help_keyword_id) values (290,171);
insert into help_relation (help_topic_id,help_keyword_id) values (23,172);
insert into help_relation (help_topic_id,help_keyword_id) values (33,172);
insert into help_relation (help_topic_id,help_keyword_id) values (74,172);
insert into help_relation (help_topic_id,help_keyword_id) values (58,172);
insert into help_relation (help_topic_id,help_keyword_id) values (29,172);
insert into help_relation (help_topic_id,help_keyword_id) values (344,172);
insert into help_relation (help_topic_id,help_keyword_id) values (158,173);
insert into help_relation (help_topic_id,help_keyword_id) values (127,174);
insert into help_relation (help_topic_id,help_keyword_id) values (380,174);
insert into help_relation (help_topic_id,help_keyword_id) values (166,175);
insert into help_relation (help_topic_id,help_keyword_id) values (394,176);
insert into help_relation (help_topic_id,help_keyword_id) values (374,177);
insert into help_relation (help_topic_id,help_keyword_id) values (281,178);
insert into help_relation (help_topic_id,help_keyword_id) values (0,178);
insert into help_relation (help_topic_id,help_keyword_id) values (380,178);
insert into help_relation (help_topic_id,help_keyword_id) values (247,178);
insert into help_relation (help_topic_id,help_keyword_id) values (60,178);
insert into help_relation (help_topic_id,help_keyword_id) values (41,178);
insert into help_relation (help_topic_id,help_keyword_id) values (251,178);
insert into help_relation (help_topic_id,help_keyword_id) values (72,178);
insert into help_relation (help_topic_id,help_keyword_id) values (168,178);
insert into help_relation (help_topic_id,help_keyword_id) values (375,178);
insert into help_relation (help_topic_id,help_keyword_id) values (346,179);
insert into help_relation (help_topic_id,help_keyword_id) values (292,180);
insert into help_relation (help_topic_id,help_keyword_id) values (217,181);
insert into help_relation (help_topic_id,help_keyword_id) values (378,182);
insert into help_relation (help_topic_id,help_keyword_id) values (0,183);
insert into help_relation (help_topic_id,help_keyword_id) values (207,184);
insert into help_relation (help_topic_id,help_keyword_id) values (349,184);
insert into help_relation (help_topic_id,help_keyword_id) values (290,185);
insert into help_relation (help_topic_id,help_keyword_id) values (255,186);
insert into help_relation (help_topic_id,help_keyword_id) values (407,186);
insert into help_relation (help_topic_id,help_keyword_id) values (165,186);
insert into help_relation (help_topic_id,help_keyword_id) values (15,186);
insert into help_relation (help_topic_id,help_keyword_id) values (130,186);
insert into help_relation (help_topic_id,help_keyword_id) values (95,186);
insert into help_relation (help_topic_id,help_keyword_id) values (158,187);
insert into help_relation (help_topic_id,help_keyword_id) values (147,188);
insert into help_relation (help_topic_id,help_keyword_id) values (147,189);
insert into help_relation (help_topic_id,help_keyword_id) values (314,190);
insert into help_relation (help_topic_id,help_keyword_id) values (271,191);
insert into help_relation (help_topic_id,help_keyword_id) values (207,191);
insert into help_relation (help_topic_id,help_keyword_id) values (349,191);
insert into help_relation (help_topic_id,help_keyword_id) values (169,191);
insert into help_relation (help_topic_id,help_keyword_id) values (147,192);
insert into help_relation (help_topic_id,help_keyword_id) values (281,193);
insert into help_relation (help_topic_id,help_keyword_id) values (300,193);
insert into help_relation (help_topic_id,help_keyword_id) values (380,193);
insert into help_relation (help_topic_id,help_keyword_id) values (375,193);
insert into help_relation (help_topic_id,help_keyword_id) values (222,194);
insert into help_relation (help_topic_id,help_keyword_id) values (281,194);
insert into help_relation (help_topic_id,help_keyword_id) values (41,194);
insert into help_relation (help_topic_id,help_keyword_id) values (171,194);
insert into help_relation (help_topic_id,help_keyword_id) values (292,194);
insert into help_relation (help_topic_id,help_keyword_id) values (295,194);
insert into help_relation (help_topic_id,help_keyword_id) values (221,194);
insert into help_relation (help_topic_id,help_keyword_id) values (380,195);
insert into help_relation (help_topic_id,help_keyword_id) values (384,196);
insert into help_relation (help_topic_id,help_keyword_id) values (380,196);
insert into help_relation (help_topic_id,help_keyword_id) values (221,196);
insert into help_relation (help_topic_id,help_keyword_id) values (147,197);
insert into help_relation (help_topic_id,help_keyword_id) values (290,198);
insert into help_relation (help_topic_id,help_keyword_id) values (380,199);
insert into help_relation (help_topic_id,help_keyword_id) values (375,200);
insert into help_relation (help_topic_id,help_keyword_id) values (61,201);
insert into help_relation (help_topic_id,help_keyword_id) values (147,202);
insert into help_relation (help_topic_id,help_keyword_id) values (269,203);
insert into help_relation (help_topic_id,help_keyword_id) values (290,203);
insert into help_relation (help_topic_id,help_keyword_id) values (296,203);
insert into help_relation (help_topic_id,help_keyword_id) values (290,204);
insert into help_relation (help_topic_id,help_keyword_id) values (256,205);
insert into help_relation (help_topic_id,help_keyword_id) values (307,205);
insert into help_relation (help_topic_id,help_keyword_id) values (308,205);
insert into help_relation (help_topic_id,help_keyword_id) values (165,206);
insert into help_relation (help_topic_id,help_keyword_id) values (61,207);
insert into help_relation (help_topic_id,help_keyword_id) values (196,208);
insert into help_relation (help_topic_id,help_keyword_id) values (380,209);
insert into help_relation (help_topic_id,help_keyword_id) values (115,210);
insert into help_relation (help_topic_id,help_keyword_id) values (281,211);
insert into help_relation (help_topic_id,help_keyword_id) values (119,211);
insert into help_relation (help_topic_id,help_keyword_id) values (380,211);
insert into help_relation (help_topic_id,help_keyword_id) values (222,211);
insert into help_relation (help_topic_id,help_keyword_id) values (252,211);
insert into help_relation (help_topic_id,help_keyword_id) values (41,211);
insert into help_relation (help_topic_id,help_keyword_id) values (168,211);
insert into help_relation (help_topic_id,help_keyword_id) values (166,211);
insert into help_relation (help_topic_id,help_keyword_id) values (380,212);
insert into help_relation (help_topic_id,help_keyword_id) values (158,213);
insert into help_relation (help_topic_id,help_keyword_id) values (184,214);
insert into help_relation (help_topic_id,help_keyword_id) values (281,215);
insert into help_relation (help_topic_id,help_keyword_id) values (367,215);
insert into help_relation (help_topic_id,help_keyword_id) values (243,216);
insert into help_relation (help_topic_id,help_keyword_id) values (281,216);
insert into help_relation (help_topic_id,help_keyword_id) values (300,216);
insert into help_relation (help_topic_id,help_keyword_id) values (127,216);
insert into help_relation (help_topic_id,help_keyword_id) values (380,217);
insert into help_relation (help_topic_id,help_keyword_id) values (309,218);
insert into help_relation (help_topic_id,help_keyword_id) values (111,219);
insert into help_relation (help_topic_id,help_keyword_id) values (77,220);
insert into help_relation (help_topic_id,help_keyword_id) values (380,221);
insert into help_relation (help_topic_id,help_keyword_id) values (340,222);
insert into help_relation (help_topic_id,help_keyword_id) values (29,223);
insert into help_relation (help_topic_id,help_keyword_id) values (207,224);
insert into help_relation (help_topic_id,help_keyword_id) values (376,225);
insert into help_relation (help_topic_id,help_keyword_id) values (243,226);
insert into help_relation (help_topic_id,help_keyword_id) values (152,226);
insert into help_relation (help_topic_id,help_keyword_id) values (271,226);
insert into help_relation (help_topic_id,help_keyword_id) values (46,226);
insert into help_relation (help_topic_id,help_keyword_id) values (300,226);
insert into help_relation (help_topic_id,help_keyword_id) values (122,226);
insert into help_relation (help_topic_id,help_keyword_id) values (99,226);
insert into help_relation (help_topic_id,help_keyword_id) values (328,226);
insert into help_relation (help_topic_id,help_keyword_id) values (222,226);
insert into help_relation (help_topic_id,help_keyword_id) values (127,226);
insert into help_relation (help_topic_id,help_keyword_id) values (251,226);
insert into help_relation (help_topic_id,help_keyword_id) values (400,226);
insert into help_relation (help_topic_id,help_keyword_id) values (252,226);
insert into help_relation (help_topic_id,help_keyword_id) values (226,226);
insert into help_relation (help_topic_id,help_keyword_id) values (102,226);
insert into help_relation (help_topic_id,help_keyword_id) values (171,226);
insert into help_relation (help_topic_id,help_keyword_id) values (13,226);
insert into help_relation (help_topic_id,help_keyword_id) values (284,226);
insert into help_relation (help_topic_id,help_keyword_id) values (178,226);
insert into help_relation (help_topic_id,help_keyword_id) values (109,226);
insert into help_relation (help_topic_id,help_keyword_id) values (39,226);
insert into help_relation (help_topic_id,help_keyword_id) values (238,226);
insert into help_relation (help_topic_id,help_keyword_id) values (90,226);
insert into help_relation (help_topic_id,help_keyword_id) values (268,226);
insert into help_relation (help_topic_id,help_keyword_id) values (151,226);
insert into help_relation (help_topic_id,help_keyword_id) values (367,226);
insert into help_relation (help_topic_id,help_keyword_id) values (380,227);
insert into help_relation (help_topic_id,help_keyword_id) values (248,228);
insert into help_relation (help_topic_id,help_keyword_id) values (199,228);
insert into help_relation (help_topic_id,help_keyword_id) values (290,228);
insert into help_relation (help_topic_id,help_keyword_id) values (158,228);
insert into help_relation (help_topic_id,help_keyword_id) values (267,229);
insert into help_relation (help_topic_id,help_keyword_id) values (380,230);
insert into help_relation (help_topic_id,help_keyword_id) values (90,231);
insert into help_relation (help_topic_id,help_keyword_id) values (342,232);
insert into help_relation (help_topic_id,help_keyword_id) values (19,233);
insert into help_relation (help_topic_id,help_keyword_id) values (111,234);
insert into help_relation (help_topic_id,help_keyword_id) values (257,234);
insert into help_relation (help_topic_id,help_keyword_id) values (255,235);
insert into help_relation (help_topic_id,help_keyword_id) values (76,236);
insert into help_relation (help_topic_id,help_keyword_id) values (19,237);
insert into help_relation (help_topic_id,help_keyword_id) values (29,238);
insert into help_relation (help_topic_id,help_keyword_id) values (206,238);
insert into help_relation (help_topic_id,help_keyword_id) values (281,239);
insert into help_relation (help_topic_id,help_keyword_id) values (122,239);
insert into help_relation (help_topic_id,help_keyword_id) values (105,240);
insert into help_relation (help_topic_id,help_keyword_id) values (158,241);
insert into help_relation (help_topic_id,help_keyword_id) values (147,242);
insert into help_relation (help_topic_id,help_keyword_id) values (144,243);
insert into help_relation (help_topic_id,help_keyword_id) values (369,244);
insert into help_relation (help_topic_id,help_keyword_id) values (80,245);
insert into help_relation (help_topic_id,help_keyword_id) values (15,245);
insert into help_relation (help_topic_id,help_keyword_id) values (19,246);
insert into help_relation (help_topic_id,help_keyword_id) values (147,247);
insert into help_relation (help_topic_id,help_keyword_id) values (344,248);
insert into help_relation (help_topic_id,help_keyword_id) values (375,249);
insert into help_relation (help_topic_id,help_keyword_id) values (158,250);
insert into help_relation (help_topic_id,help_keyword_id) values (110,251);
insert into help_relation (help_topic_id,help_keyword_id) values (147,252);
insert into help_relation (help_topic_id,help_keyword_id) values (19,253);
insert into help_relation (help_topic_id,help_keyword_id) values (158,254);
insert into help_relation (help_topic_id,help_keyword_id) values (281,255);
insert into help_relation (help_topic_id,help_keyword_id) values (309,255);
insert into help_relation (help_topic_id,help_keyword_id) values (61,256);
insert into help_relation (help_topic_id,help_keyword_id) values (90,256);
insert into help_relation (help_topic_id,help_keyword_id) values (290,256);
insert into help_relation (help_topic_id,help_keyword_id) values (375,257);
insert into help_relation (help_topic_id,help_keyword_id) values (290,258);
insert into help_relation (help_topic_id,help_keyword_id) values (158,259);
insert into help_relation (help_topic_id,help_keyword_id) values (59,260);
insert into help_relation (help_topic_id,help_keyword_id) values (158,260);
insert into help_relation (help_topic_id,help_keyword_id) values (290,261);
insert into help_relation (help_topic_id,help_keyword_id) values (363,262);
insert into help_relation (help_topic_id,help_keyword_id) values (61,263);
insert into help_relation (help_topic_id,help_keyword_id) values (115,263);
insert into help_relation (help_topic_id,help_keyword_id) values (147,264);
insert into help_relation (help_topic_id,help_keyword_id) values (344,265);
insert into help_relation (help_topic_id,help_keyword_id) values (36,266);
insert into help_relation (help_topic_id,help_keyword_id) values (266,266);
insert into help_relation (help_topic_id,help_keyword_id) values (158,267);
insert into help_relation (help_topic_id,help_keyword_id) values (91,268);
insert into help_relation (help_topic_id,help_keyword_id) values (147,269);
insert into help_relation (help_topic_id,help_keyword_id) values (19,270);
insert into help_relation (help_topic_id,help_keyword_id) values (110,271);
insert into help_relation (help_topic_id,help_keyword_id) values (362,271);
insert into help_relation (help_topic_id,help_keyword_id) values (19,272);
insert into help_relation (help_topic_id,help_keyword_id) values (108,273);
insert into help_relation (help_topic_id,help_keyword_id) values (375,274);
insert into help_relation (help_topic_id,help_keyword_id) values (15,275);
insert into help_relation (help_topic_id,help_keyword_id) values (41,276);
insert into help_relation (help_topic_id,help_keyword_id) values (158,276);
insert into help_relation (help_topic_id,help_keyword_id) values (375,276);
insert into help_relation (help_topic_id,help_keyword_id) values (380,277);
insert into help_relation (help_topic_id,help_keyword_id) values (0,278);
insert into help_relation (help_topic_id,help_keyword_id) values (0,279);
insert into help_relation (help_topic_id,help_keyword_id) values (290,279);
insert into help_relation (help_topic_id,help_keyword_id) values (0,280);
insert into help_relation (help_topic_id,help_keyword_id) values (281,281);
insert into help_relation (help_topic_id,help_keyword_id) values (284,281);
insert into help_relation (help_topic_id,help_keyword_id) values (344,282);
insert into help_relation (help_topic_id,help_keyword_id) values (229,283);
insert into help_relation (help_topic_id,help_keyword_id) values (158,284);
insert into help_relation (help_topic_id,help_keyword_id) values (380,285);
insert into help_relation (help_topic_id,help_keyword_id) values (377,286);
insert into help_relation (help_topic_id,help_keyword_id) values (308,286);
insert into help_relation (help_topic_id,help_keyword_id) values (290,287);
insert into help_relation (help_topic_id,help_keyword_id) values (76,288);
insert into help_relation (help_topic_id,help_keyword_id) values (402,289);
insert into help_relation (help_topic_id,help_keyword_id) values (46,290);
insert into help_relation (help_topic_id,help_keyword_id) values (281,290);
insert into help_relation (help_topic_id,help_keyword_id) values (221,291);
insert into help_relation (help_topic_id,help_keyword_id) values (290,292);
insert into help_relation (help_topic_id,help_keyword_id) values (362,293);
insert into help_relation (help_topic_id,help_keyword_id) values (380,294);
insert into help_relation (help_topic_id,help_keyword_id) values (110,295);
insert into help_relation (help_topic_id,help_keyword_id) values (340,296);
insert into help_relation (help_topic_id,help_keyword_id) values (19,297);
insert into help_relation (help_topic_id,help_keyword_id) values (158,298);
insert into help_relation (help_topic_id,help_keyword_id) values (19,299);
insert into help_relation (help_topic_id,help_keyword_id) values (384,300);
insert into help_relation (help_topic_id,help_keyword_id) values (380,300);
insert into help_relation (help_topic_id,help_keyword_id) values (158,300);
insert into help_relation (help_topic_id,help_keyword_id) values (404,301);
insert into help_relation (help_topic_id,help_keyword_id) values (226,302);
insert into help_relation (help_topic_id,help_keyword_id) values (362,303);
insert into help_relation (help_topic_id,help_keyword_id) values (95,304);
insert into help_relation (help_topic_id,help_keyword_id) values (384,305);
insert into help_relation (help_topic_id,help_keyword_id) values (221,305);
insert into help_relation (help_topic_id,help_keyword_id) values (38,306);
insert into help_relation (help_topic_id,help_keyword_id) values (362,307);
insert into help_relation (help_topic_id,help_keyword_id) values (302,308);
insert into help_relation (help_topic_id,help_keyword_id) values (119,309);
insert into help_relation (help_topic_id,help_keyword_id) values (254,309);
insert into help_relation (help_topic_id,help_keyword_id) values (267,310);
insert into help_relation (help_topic_id,help_keyword_id) values (380,311);
insert into help_relation (help_topic_id,help_keyword_id) values (110,312);
insert into help_relation (help_topic_id,help_keyword_id) values (266,312);
insert into help_relation (help_topic_id,help_keyword_id) values (391,313);
insert into help_relation (help_topic_id,help_keyword_id) values (119,313);
insert into help_relation (help_topic_id,help_keyword_id) values (148,313);
insert into help_relation (help_topic_id,help_keyword_id) values (221,313);
insert into help_relation (help_topic_id,help_keyword_id) values (372,314);
insert into help_relation (help_topic_id,help_keyword_id) values (375,315);
insert into help_relation (help_topic_id,help_keyword_id) values (380,316);
insert into help_relation (help_topic_id,help_keyword_id) values (76,317);
insert into help_relation (help_topic_id,help_keyword_id) values (281,318);
insert into help_relation (help_topic_id,help_keyword_id) values (251,318);
insert into help_relation (help_topic_id,help_keyword_id) values (375,318);
insert into help_relation (help_topic_id,help_keyword_id) values (33,319);
insert into help_relation (help_topic_id,help_keyword_id) values (90,319);
insert into help_relation (help_topic_id,help_keyword_id) values (290,319);
insert into help_relation (help_topic_id,help_keyword_id) values (58,319);
insert into help_relation (help_topic_id,help_keyword_id) values (76,319);
insert into help_relation (help_topic_id,help_keyword_id) values (384,320);
insert into help_relation (help_topic_id,help_keyword_id) values (41,320);
insert into help_relation (help_topic_id,help_keyword_id) values (74,320);
insert into help_relation (help_topic_id,help_keyword_id) values (380,320);
insert into help_relation (help_topic_id,help_keyword_id) values (375,320);
insert into help_relation (help_topic_id,help_keyword_id) values (380,321);
insert into help_relation (help_topic_id,help_keyword_id) values (290,322);
insert into help_relation (help_topic_id,help_keyword_id) values (74,323);
insert into help_relation (help_topic_id,help_keyword_id) values (29,323);
insert into help_relation (help_topic_id,help_keyword_id) values (397,323);
insert into help_relation (help_topic_id,help_keyword_id) values (380,324);
insert into help_relation (help_topic_id,help_keyword_id) values (375,324);
insert into help_relation (help_topic_id,help_keyword_id) values (380,325);
insert into help_relation (help_topic_id,help_keyword_id) values (193,325);
insert into help_relation (help_topic_id,help_keyword_id) values (384,326);
insert into help_relation (help_topic_id,help_keyword_id) values (380,326);
insert into help_relation (help_topic_id,help_keyword_id) values (23,327);
insert into help_relation (help_topic_id,help_keyword_id) values (96,328);
insert into help_relation (help_topic_id,help_keyword_id) values (362,328);
insert into help_relation (help_topic_id,help_keyword_id) values (284,328);
insert into help_relation (help_topic_id,help_keyword_id) values (281,329);
insert into help_relation (help_topic_id,help_keyword_id) values (119,329);
insert into help_relation (help_topic_id,help_keyword_id) values (252,329);
insert into help_relation (help_topic_id,help_keyword_id) values (148,329);
insert into help_relation (help_topic_id,help_keyword_id) values (384,330);
insert into help_relation (help_topic_id,help_keyword_id) values (302,330);
insert into help_relation (help_topic_id,help_keyword_id) values (378,331);
insert into help_relation (help_topic_id,help_keyword_id) values (24,332);
insert into help_relation (help_topic_id,help_keyword_id) values (109,332);
insert into help_relation (help_topic_id,help_keyword_id) values (178,332);
insert into help_relation (help_topic_id,help_keyword_id) values (36,332);
insert into help_relation (help_topic_id,help_keyword_id) values (266,332);
insert into help_relation (help_topic_id,help_keyword_id) values (344,333);
insert into help_relation (help_topic_id,help_keyword_id) values (290,334);
insert into help_relation (help_topic_id,help_keyword_id) values (296,334);
insert into help_relation (help_topic_id,help_keyword_id) values (375,335);
insert into help_relation (help_topic_id,help_keyword_id) values (344,336);
insert into help_relation (help_topic_id,help_keyword_id) values (380,337);
insert into help_relation (help_topic_id,help_keyword_id) values (158,338);
insert into help_relation (help_topic_id,help_keyword_id) values (248,339);
insert into help_relation (help_topic_id,help_keyword_id) values (352,339);
insert into help_relation (help_topic_id,help_keyword_id) values (388,339);
insert into help_relation (help_topic_id,help_keyword_id) values (290,339);
insert into help_relation (help_topic_id,help_keyword_id) values (296,339);
insert into help_relation (help_topic_id,help_keyword_id) values (378,340);
insert into help_relation (help_topic_id,help_keyword_id) values (267,340);
insert into help_relation (help_topic_id,help_keyword_id) values (23,340);
insert into help_relation (help_topic_id,help_keyword_id) values (83,340);
insert into help_relation (help_topic_id,help_keyword_id) values (344,340);
insert into help_relation (help_topic_id,help_keyword_id) values (382,340);
insert into help_relation (help_topic_id,help_keyword_id) values (147,341);
insert into help_relation (help_topic_id,help_keyword_id) values (158,342);
insert into help_relation (help_topic_id,help_keyword_id) values (99,343);
insert into help_relation (help_topic_id,help_keyword_id) values (281,343);
insert into help_relation (help_topic_id,help_keyword_id) values (238,343);
insert into help_relation (help_topic_id,help_keyword_id) values (23,343);
insert into help_relation (help_topic_id,help_keyword_id) values (403,344);
insert into help_relation (help_topic_id,help_keyword_id) values (17,345);
insert into help_relation (help_topic_id,help_keyword_id) values (400,346);
insert into help_relation (help_topic_id,help_keyword_id) values (158,347);
insert into help_relation (help_topic_id,help_keyword_id) values (290,348);
insert into help_relation (help_topic_id,help_keyword_id) values (74,348);
insert into help_relation (help_topic_id,help_keyword_id) values (168,349);
insert into help_relation (help_topic_id,help_keyword_id) values (380,350);
insert into help_relation (help_topic_id,help_keyword_id) values (76,350);
insert into help_relation (help_topic_id,help_keyword_id) values (375,350);
insert into help_relation (help_topic_id,help_keyword_id) values (281,351);
insert into help_relation (help_topic_id,help_keyword_id) values (243,352);
insert into help_relation (help_topic_id,help_keyword_id) values (86,352);
insert into help_relation (help_topic_id,help_keyword_id) values (39,352);
insert into help_relation (help_topic_id,help_keyword_id) values (147,352);
insert into help_relation (help_topic_id,help_keyword_id) values (212,352);
insert into help_relation (help_topic_id,help_keyword_id) values (295,352);
insert into help_relation (help_topic_id,help_keyword_id) values (165,353);
insert into help_relation (help_topic_id,help_keyword_id) values (380,353);
insert into help_relation (help_topic_id,help_keyword_id) values (380,354);
insert into help_relation (help_topic_id,help_keyword_id) values (157,355);
insert into help_relation (help_topic_id,help_keyword_id) values (380,356);

