/*
   Copyright (c) 2010, 2021, Oracle and/or its affiliates.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License, version 2.0,
   as published by the Free Software Foundation.

   This program is also distributed with certain software (including
   but not limited to OpenSSL) that is licensed under separate terms,
   as designated in a particular file or component or in included license
   documentation.  The authors of MySQL hereby grant you an additional
   permission to link the program and your derivative works with the
   separately licensed software that they have included with MySQL.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License, version 2.0, for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA
*/

#include <cstring>
#include "trp_node.hpp"
#include <NdbOut.hpp>

trp_node::trp_node()
{
  compatible = nfCompleteRep = true;
  m_connected = defined = m_alive = m_api_reg_conf = m_node_fail_rep = false;
  std::memset(&m_state, 0, sizeof(m_state));
  m_state.init();
  m_state.startLevel = NodeState::SL_NOTHING;
  minDbVersion = 0;
  minApiVersion = 0;
}

bool
trp_node::operator==(const trp_node& other) const
{
  return (compatible == other.compatible &&
          nfCompleteRep == other.nfCompleteRep &&
          m_connected == other.m_connected &&
          defined == other.defined &&
          m_alive == other.m_alive &&
          m_api_reg_conf == other.m_api_reg_conf &&
          m_node_fail_rep == other.m_node_fail_rep &&
          minDbVersion == other.minDbVersion &&
          minApiVersion == other.minApiVersion &&
          memcmp(&m_state, &other.m_state, sizeof(m_state)) == 0);
}

NdbOut&
operator<<(NdbOut& out, const trp_node& n)
{
  out << "[ "
      << "defined: " << n.defined
      << ", compatible: " << n.compatible
      << ", connected: " << n.m_connected
      << ", api_reg_conf: " << n.m_api_reg_conf
      << ", alive: " << n.m_alive
      << ", nodefailrep: " << n.m_node_fail_rep
      << ", nfCompleteRep: " << n.nfCompleteRep
      << ", minDbVersion: " << n.minDbVersion
      << ", minApiVersion: " << n.minApiVersion
      << ", state: " << n.m_state
      << ", connected: "
      << BaseString::getPrettyTextShort(n.m_state.m_connected_nodes).c_str()
      << "]";

  return out;
}
